<?php
/**
 * @license MIT
 *
 * Modified by impress-org on 25-September-2024 using Strauss.
 * @see https://github.com/BrianHenryIE/strauss
 */

namespace Give\Vendors\Faker\Provider\ka_GE;

class Text extends \Give\Vendors\Faker\Provider\Text
{
    protected static $textStartsWithUppercase = false;

    /**
     * License: Attribution-ShareAlike 3.0 Unported (CC BY-SA 3.0)
     *
     * Title: კაცია-ადამიანი?!
     * Author: ილია ჭავჭავაძე
     * Language: Georgian
     *
     * About Author: http://en.wikipedia.org/wiki/Ilia_Chavchavadze
     *
     * @see http://www.nplg.gov.ge/gsdl/cgi-bin/library.exe?e=q-00000-00---off-0vertwo--00-1----0-10-0---0---0direct-10-DT--4----Doc---0-1l--11-en-50---20-about-%E1%83%AD%E1%83%90%E1%83%95%E1%83%AD%E1%83%90%E1%83%95%E1%83%90%E1%83%AB%E1%83%94+%E1%83%99%E1%83%90%E1%83%AA%E1%83%98%E1%83%90+%E1%83%90%E1%83%93%E1%83%90%E1%83%9B%E1%83%98%E1%83%90%E1%83%9C%E1%83%98--00-3-1-00-0-0-11-1-0utfZz-8-00&a=d&c=vertwo&srp=0&srn=0&cl=search&d=HASH81409ccfa8b32143543b5f
     *
     * @var string
     */
    protected static $baseText = <<<'EOT'
„მოყვარეს პირში უძრახე,
მტერს პირს უკანაო”.
გონიერი ანდაზა.
შესავალი
რიტორიკაში სწერია: ყველაფერი შესავალით უნდა დაიწყოს კაცმაო. ჭეშმარიტია. ჩვენც ისე დავიწყოთ.
ვინც ლუარსაბის სახეში თავის-თავს იცნობს, ვინც ლუარსაბზედ დაწერილს თავის-თავზედ მიიღებს, ის, რასაკვირველია, ლაფის სროლას დამიწყებს და „გიჟიას“ დაუძახებს ამ მოთხრობის უხეირო დამწერსა. ეს კარგად იცოდნენ, რომ ჩვენ პირთან საქმე არა გვაქვს, ჩვენ საზოგადო ჭირზედა ვწერთ.
სხვამ რაც უნდა სთქვას, მე კი ამ სიტყვების სიმართლით გავამხნევებ ჩემს თავსა: „მოყვარეს პირში უძრახე, მტერს პირს უკანაო”. სადა ხარ ეხლა ამ გონიერის სიტყვის მთქმელო? ვიცი, სადაცა ხარ: ხალხში ხარ, უხილავო, და ხალხისა ხარ. ისიც ვიცი, რაცა გქვიან: შენ ხალხის გენიას გეძახიან. ისიც ვიცი, რა თვისებისა ხარ: შეუცდომელი და ყოველთვის მართალი ხარ. შენ და მხოლოდ შენ უკეთებ გულს იმას, ვისაც „სხვისთვის“ გული სტკივა. მაშინაც კი უკეთებ, როცა თვით ის „სხვანივე” თავიანთ გულშემატკივარს ცოდვად უთვლიან გულის-ტკივილსა. რა ვუყოთ? ზოგი გულის-ტკივილს იმითი იჩენს, რომ მოყვარეს ცუდსაც უქებს, და ზოგი კი იმითი, რომ ცუდს უწუნებს. ამ ორგვარ ხალხში რომელს უფრო მეტი და ჭეშმარიტი გულის-ტკივილი და სიყვარული აქვს — ეს თითონ მკითხველმა გამოიცნოს.
I
კარგი რამ იყო თავად თათქარიძის სახლ-კარი. წარმოიდგინეთ შუა კახეთის პატარა სოფელში ერთი ტრიალი, დაცემული ადგილი და იმ ადგილის შუაგულსა — ორსართულიანი სახლი ქვითკირისა. აი, ის სართულები რა ფერისა იყო: ქვეშ იყო მარანი, წალმით დახურული, და იმ მარნის უკანა კედელზედ ამოყვანილი გახლდათ ერთი პატარა ოთახი მოაჯირითურთ. მოაჯირს ეკრა ზედ მერცხლის ბუდესავით ერთი მცირედი ფიცრული, რომელიც საქვეშაგებოსა ჰთამაშობდა. კარგა მანძილზედ კიდევ ფიცრულის სათორნეც იდგა, იმას აქედამ ხულა, რომელსაც ზედ ჰქონდა მოდგმული ცალთვალა სასიმინდე, ერთი უბადრუკი რამ და მგლოვიარე. ბაღჩაც იყო, ღობით გავლილი. ღობესთან, ერთის ფურცლის ხის სიახლოვეს, მოჩანდა ძველი ჩალური, დროთა ბრუნვისაგან ისე გვერდზედ წამოღებული და წამოხრილი, თითქო გრილოში წამოწოლას აპირებსო, მაგრამ ბებერსავით ნეკრესის ქარის ტკივილებს უეცრად ისე წამოხრილი და დაღრეჯილი შეუკავებიათო. ეზო ამ ციხე-დარბაზისა, სიგრძეზედ თუ სიგანეზედ, კარგა ფართოდ იყო გაზიდული. იმას ერტყა გარშემო ძველი ტყრუშული ღობე, რომელიც ზოგიერთგან გადაქცეული იყო და ეხლანდელს პატრონს არც კი მოსვლია ფიქრად, რომ გაეკეთებინა. ეტყობა, რომ ქართველია!..
ღობე ერთგან თავდებოდა უშველებელის ჭიის-კარებითა, რომლის ერთი ნახევარი, — თუნდ ორი წელიწადია, — ისე საცოდავად დაღრეჯით გადმოჰკიდებოდა ერთს ყუნწსა, ასე გგონია — ბოძს დაუჭერია საცემლადაო და ის კი იწევსო, რომ როგორმე ხელიდამ დაუსხლტესო. ჭიის-კარიდამ იწყება კალო, დიაღ მოზრდილი. მისი ბუჩო ერთ მხრივ მთელ კალოს სამხრეთის ნაპირზედ გორასავით გაწოლილი იყო, ასე რომ იმისი ბოლო ზედ საბძელთან დააწყდებოდა. საბძელი იყო სასაცილო, ისე სულელურად ჩაფიქრებული და გვერდ-აწეული მარტო ფრთა-მოტეხილი ბატი თუ მინახავს.
ჩემს პატარა ბიჭობაში ბევრი კარგი ნახულა ამ ბუჩოზედა: აქ ხშირად უქეიფნიათ გრძნობის აღმტაცის ხრუტუნით ნებიერს ღორებსა; თავის ფაფუკის დინგით ბევრჯერ უთხრიათ ეს სურნელი ბუჩო, ისე გულმოდგინებით, ისეთის სინაზით, ასე გგონია — მართლა და ღორები იყვნენ. მერე იმათი ოხუნჯობა! იმათი ალერსი! ოჰ, ეს კი აუწერელია. რაღაც კმაყოფილებით გატაცებულთა, იმ ღორებს ერთმანეთისათვის ბევრჯერ წაუთავაზებიათ დინგი. რა ყვირილი და ჭყივილი ასტყდებოდა ხოლმე! ეგრე ჩვენი გლეხკაცი საალერსოდ წაუთავაზებს ხოლმე ქისტსა ახალ მოყვანილ პატარძალსა. ვიღაცამა სთქვა: „ქართული სიყვარული ლანძღვააო“, მეც ვიტყვი: ქისტი კიდევ საოხუნჯო ალერსია. ადმინისტრაციაში მაგას კიდევ სხვა მნიშვნელობა აქვს: იქ ქისტი შემამცნებელი საბუთია. ეგ ჩვენი საქმე არ არის.
შიგ თითონ ეზო ისე უწმინდური იყო, როგორც ძველი ჩინოვნიკის გული. დიდი საქმე იყო, პატრონამდინ ისე მიგეღწიათ, რომ ან არ გასვრილიყავით, ან კიდევ ერთი ამბრის სურნელება თან არ აგეყოლიათ. ეს გარეგანი, — ეხლა, ბატონებო, შიგ სახლში ვეწვიოთ თავადს თათქარიძესა.
ეს კი უნდა მოგახსენოთ, რომ, თუ ვეწვევით, ფრთხილად უნდა ვიყვნეთ. იატაკი აგურისა არის. ეგ არაფერი. ეს არის ძნელი, რომ აგურები შიგა-და-შიგ ამოცვივნულან; იმათი ალაგი ამოთხრილ ორმოებად დარჩენილა. თვალების ძალიან გაფაციცება უნდა, თორემ, თუ ფეხი შიგ ჩავარდა, ვაი შენს მტერს! ან კისერი მოსტყდება კაცსა, ან თითონვე ფეხი. თუმცა, მართალია, სახლის პატრონი ბევრს ბოდიშს მოიხდის, მაგრამ ხომ მოგეხსენებათ, რომ ბოდიში ძნელად თუ მოარჩენს მოგრეხილს კისერსა, — და არც მოტეხილ ფეხისათვის არის უებარი წამალი. ამ ხიფათს შეიძლება კაცი გადურჩეს, თუ რომ ოთახი ნათელი იყოს. ვაი, რომ არც ეს არის. თუმცა ორი, სათოფეზედ კარგა მოდიდო, ფანჯარა აქვს, მაგრამ ოთახი მაინც ბნელია, იმიტომ რომ ფიჭვის ჩარჩოებზედ მინის მაგიერად მეტად გამჭრიახ გონებას გაქონილი ქაღალდი გაუკრავს. აი, ამაზედ არის ნათქვამი: „ხერხი სჯობია ღონესა, თუ კაცი მოიგონებსა“. მოგონებაში ქართველ კაცს პირველი ევროპიელი მეჭორეც არა სჯობია.
ბევრჯერ მინახავს სხვაგანაც მაგისთანა ფანჯრის სასაცილო სამკაული. ბევრჯერ მინახავს ის გაქონილი ფანჯრის ქაღალდი ნემსით დაჩხვლეტილიცა: ხან გულია გამოყვანილი, ხან ჯვარია, ხან კიდევ დაწერილია რამე, თუნდ ამისთანა რამ: „დათვი ხეზედ როგორ გავა, იავ-ნანინაო!..“ ეს კი ქალის საქმე უნდა იყოს. თუნდ მართლადაც ესე იყოს, რა დასაძრახისია? მოსწყენია დავითნის კითხვა, გულზედ რაღაცა სევდა მოსწოლია, — და გონების გასართავად და უგემურ დღის დასალევად მიმჯდარა ფანჯარასთან, ამოუძვრია გულის ქინძისთავი და მიუყვია ხელი ამ მართლა-და გონება-გასართველ საქმისათვის. უსაქმო ყოფილა და საქმე გაუჩენია ამ ანდაზის ძალით: „ცუდად ჯდომას ცუდად შრომა სჯობიაო“.
იმ თათქარიძის ოთახში იდგა ორი გრძელი ტახტი, ერთმანეთის პირდაპირ. ასეთი ფაქიზი ქეჩა და ხალიჩა ეშალა ზედა, რომ, როცა კნეინა ადგებოდა, ყოველ მის ბრწყინვალების ბრწყინვალე ფეხის ბრწყინვალე გადადგმაზედ ისე ლამაზად აბოლდებოდა ხოლმე, რომ კაცი ყურებით ვერ გაძღებოდა. ამ ორ ტახტ-შუა აღმოსავლეთის კედელზედ მოჩანდა, კბილებჩაცვივნულ ბებერ დედაკაცის დაღებულ პირსავით, ერთი ამოჭვარტლული გარედამ და შიგნიდამ, ერთი მწუხარე და დაღრეჯილი ბუხარი. აქა-იქ ოთახის სამკაულად ეყარა სხვადასხვანაირი ნივთები, მაგალითებრ: ტალახიანი ყარაბაღული თეთრი წაღები, პირმოტეხილი სპილენძის თუნგი, ქონიანი შანდალი, სპილენძის საჩაიეში მოხარშული მყრალა-ბალახი, ზურგიელის ნაჭერი და სხვანი და სხვანი.
II
 არ გეგონოთ, მკითხველნო, რომ ეს სახლი ეკუთვნოდეს ერთს ვისმეს ღარიბსა და მის-გამო იყოს ეგრე გულშეუტკივრად თავმინებებული, — არა, ამის პატრონს ჰყავს ოცი კარგად გაკეთებული კომლი კაცი, ასე რომ ათ ურმამდინ საბეგრო ებმებოდა, ცხვარი ბლომად და ასიოდეც ცხენი, რომელიც ყმაზედ ნაკლები არ არის განათლებულ მებატონისათვის. ეს სულიერი ქონება. ეხლა უსულო ჩამოვთვალოთ: ორი მოზრდილი ვენახი და ას-ორმოც-და-ათი დღის სახნავ-სათესი. ეს ქონება, ყმებიდგან დაწყებული ცხენამდინა და მიწამდინა, იმის ხელში, - ვინც გამოყენება იცის, - კაი ლუკმა არის. მაშ რაღად სდგას ეგრე ცუდად? მკითხავს გაკვირვებული მკითხველი. იმიტომ, რომ ქართველია, — მოგიგებთ სრულიად დარწმუნებული, რომ კაი საბუთი გითხარით.
დიაღ, ამ მშვენიერ სახლში ქართველი კაცი იდგა. აქ სცხოვრებდა ტკბილად და აუმღვრევლად ორმოცის წლის კაცი თავადი ლუარსაბ თათქარიძე, თავის განუშორებელ მეუღლითურთ, რომელსაც ერქვა კნეინა დარეჯანი.
თავადი ლუარსაბ თათქარიძე გახლდათ კარგად ჩასუქებული ძველი ქართველი, მრგვალი — უკაცრავოდ არ ვიყო ამ სიტყვაზედ — როგორც კარგი ნასუქი კურატი. დარბაისელის კაცის შეხედულება ჰქონდა მის ბრწყინვალებასა: თავი ისეთი მსხვილი, რომ თითქო იმის სიმძიმეს მორგვივით სქელი კისერი მხრებში ჩაუძვრენიაო; წითელი, თურაშაულ ვაშლსავით ხაშხაში ლოყები; სამკეცად ჩამოსული ტრფიალების აღმგზნები ფაფუკი ღაბაბი; დიდრონი თვალები, ყოველთვის დასისხლებულნი, თითქო ყელში თოკი წაუჭერიათო! გაბერილი, მეტად გონიერად გადმოგდებული, დიაღ პატივსაცემი და პატივცემული ღიპი, კოტიტა და ქონით გატენილი ბალნიანი ხელები, დამორილი სხვილი ფეხები - ესე ყოველი ერთად და თვითოეული ცალკე გახლდათ თავად ლუარსაბის „ცით მონაბერის სულის" ღირსეული სამკაული. ის „მონაბერი სული“ არსად არა სჩანდა, თითქო ჩამკვდარაო, ისე გაშლილიყო მის ბრწყინვალების ქონშია. ქართველს კაცს არც ქარის შემოტანილი უნდა და არც გატანილი; ის „მონაბერი სული“ ქარად ხომ არ მიიღო ჩვენმა თავადმა?
სწავლა, ღვთის მადლით, არაფრისა არა ჰქონდა. რომ ჰქონოდა, ეგრე მსუქანიც აღარ იქნებოდა. ხშირია ხოლმე, რომ, როცა სული ჭლექდება - ხორცის დღეობა მაშინ არის, როცა სული ჰყვავის — ხორცი დნება. ამიტომაც ჭლექები ჭკვიანები არიანო, ამბობენ ხოლმე. ჩვენი ლუარსაბი, მგონი, თითონაც ბევრს არ იცემდა თავში, — რატომ სწავლა არა მაქვსო, — სწორედ ამის გამო.
— ეგ ეხლანდელი ჭირიაო, — იტყოდა ხოლმე გულმტკივნეულად, თითქო ქვეყანა ამ ჭირისაგან ებრალებაო.
მართალიც ბრძანდებოდა მისი ბრწყინვალება: მისის აზრით კაცი ძირგავარდნილი ქვევრი იყო, რომელსაც დღე-ყოველ უნდა ჩააყარო ხორაგი და ჩაასხა სასმელი, მაგრამ კიდევ მაინც ვერ აავსო. მისი ბრწყინვალება თავის თავზედ ჰხედავდა თავის ბრწყინვალე გონიერებით, რომ ამ მნიშვნელობას კაცი უსწავლელადაც კარგად ასრულებს, ნამეტნავად ჯოგის და ყმის პატრონი, ყმისა — რომელსაც ჯოგში დიდი განსხვავება არა აქვს.
— დრო გამოიცვალა, — იტყოდა ხოლმე აღმოოხვრით ლუარსაბი, — დრო გამოიცვალა. რაც ეს რაღაც ეშმაკური სკოლები შემოიღეს, ბატონო, ქართველ კაცის ხეირი მაშინ წავიდა. ფერი კი აღარ შერჩათ ჩვენს შვილებსა და!.. ჭამით ისინი ვერა სჭამენ, სმით ისინი ვეღარა სმენ, რა კაცები არიან?! წიგნი იციან? მე თუ წიგნი არ ვიცი, კაცი აღარ ვარ, ქუდი არა მხურავს, განა! ხორცი მე არ მაკლია და ფერი. წიგნი რა ვაჟკაცის ხელობაა, — ეგ ხომ ქალის საქმეა. ვენაცვალე უწინდელ დროს! ყველაფერი მაშინ თავის დონეზედ იყო მოყვანილი, ყველა თავის ქერქში იყო. ვენაცვალე!.. კაი ცხენი, კაი თოფი, მარჯვე მკლავი და კაცი იყავ პატიოსანი.
ეჰ, ჩემო ლუარსაბ! ვიცი, გულწრფელი კი ხარ, როგორც ყველა ძველი ქართველი, მაგრამ ძველს დროს ტყუილად შეჰნატრი. რომ არც კი იცი, რა იყო სანატრელი ძველს დროში? ცხენი განა ეხლა კი არ არის? თოფი განა ეხლა კი ნიშანში ვერ მივა? მარჯვე მკლავი ცოტაა? ეხლაც არის ეს ყველაფერი, მაგრამ ის გული აღარ არის, ის გულის სიმხურვალე. ის თავგამოდება მამულისათვის, რომელიც კაი ცხენს და კაი თოფს კაი საქმეში ახმარებდა. უწინ კაცი აშვენებდა ცხენსაც და თოფსაც. ეხლა კი ცხენი და თოფი კაცს აშვენებს. კარგი იყო ძველი დრო, მაგრამ არც ეს ბესარიონ გაბაშვილის სიტყვებია ურიგო: „ერთი მაქვს სჯობს ათასს მქონდას“. — ესა ვთქვათ და ენა მოვიკვნიტოთ, თორემ.
თუმცა ლუარსაბი ეგრე სწუხდა ეხლანდელ დროების ჭირისა გამო, მაგრამ სახე მუდამ ერთ განსაკუთრებულ სულელობით უცინოდა ხოლმე. „ხარი ხართან დააბიო, ან ფერს იცვლის ან ზნესაო“, ნათქვამია. ეს ანდაზა არსად ისე გამართლებული არ მინახავს, როგორც თავად ლუარსაბის სახლში. ამისი ძვირფასი მეუღლე კნეინა დარეჯანი სწორედ თავის ქმრის მეორე გვერდი გახლდათ და იყვნენ „ერთ სულ და ერთ ხორც“, როგორც ბრძანებს საღმრთო წერილი. მერე რა-რიგად: იგივე სიმრგვლე, იგივე სიმსუქნე, იგივე მოცინარე პირი და თითქმის იგივე სისულელე. ეს ორი ტურფა გვრიტი, ერთსულოვანი და ერთ-ხორციანი, საკვირველად ტკბილად სცხოვრობდნენ, ქვეყნის უგემურ ყაყანს მოშორებულნი. მამალი იყივლებდა თუ არა, ბედნიერ ცოლ-ქმარს თვალები დაჭყეტილები ჰქონდათ, დარეჯანი მაშინვე წამოფრინდებოდა, ლუარსაბმა კი, ნებიერმა ლუარსაბმა, ხანდისხან განაზება იცოდა. ქვეშაგებიდგანვე ის გულგადაღეღილი ტახტზედ გადაგორდებოდა ერთის ქშენით, ვაი-ვაგლახით და კიდევ რაღაცეებით... მომხდარა ისე, რომ სადილობამდინაც ამ ნებივრობაში უგემური დრო გაუტარებია.
ქართველები იტყვიან: ვისაც ბალანი ბლომად აქვს ტანზედ მოდებულიო, ის ბედნიერიაო. მართალიც არის, პირუტყვები სულ იმისაგან არიან ბედნიერნი! თუ ეს ტყუილია, ბევრი ჩვენგანი პირუტყვობას რადა ჰცდილობს? იმისთვის, რომ პირუტყვები ბედნიერნი არიან, ბედნიერები კიდევ იმისთვისა, რომ ტანზედ ბალანი აქვთ.
ლუარსაბის ტანისა კი რა მოგახსენოთ და გული კი, რო გენახათ, ღორის ჯაგარსავით მოდებული ჰქონდა, ასე რომ მრავალ საეჭვო სულიერებს შეეძლოთ შიშიანობის დროს აქ თავი შეეფარათ, მაგრამ... მაგრამ რა? განა ლუარსაბი ბედნიერი არ იყო? იმდენი დღეგრძელობა ამის დამწერს ჰქონდეს, რამდენი იმის ტოლი თავადიშვილი იმის ყოფა-ცხოვრებას შეჰნატროდა. მარტო იმის ტანის ბალანი სამყოფი იყო, რომ უბედურ კაცში შური აენთო, რომ სხვა არა იყოს-რა. თორემ რა უჭირდა ლუარსაბსა? ფერი აკლდა, თუ ხორცი? რა, სხვა უხეირო კაცსავით, ფიქრი და ზრუნვა ძილს დაუფრთხობდა, მადას წაართმევდა? ფერი კარგი ჰქონდა, ხორცი უკეთესი, სმა-ჭამა და ძილი ხომ რაღა. მეტი რა უნდა ქართველ კაცს, რომელიც ბედს და უბედობას ბალნით არჩევს, და რომლისათვისაც ბედს თუ ხვედრს დაუნიშნავს, რომ თავისი დღენი ქუდით უნდა ბუზს ერეკებოდეს.
მკითხველო, ხომ არ მოგეწყინა? რასაკვირველია, მოგეწყინა: აქ არ არის არც სიყვარულის ეშმაკობა, არც კაცის-კვლა, არც უიმედო ქალის ოხვრა, არც წყალში გადავარდნა, ერთის სიტყვით — რაც აშვენებს გასართველად დაწერილს მოთხრობასა — ის აქ არაფერი არ არის. მაშ მოგეწყინება, ამას რაღა თქმა უნდა. მაგრამ ეს უნდა იცოდე შენ, მკითხველო, რომ მე ამისა ქვემორე ხელის მომწერელი მკითხველის გასართველად არ ვწერ ამ უხეირო მოთხრობასა. მე მინდა ამ მოთხრობამ ჩააფიქროს მკითხველი და, თუ მოიწყენს, ამის გამო მოიწყინოს; იმიტომ რომ ფიქრი და მოწყენა გაუყრელნი და-ძმანი არიან. მე მინდა, რომ მკითხველმა იმიტომ კი არ მოიწყინოს, რომ გასართველი არ არი, არამედ იმიტომ, რომ ჩამაფიქრებელია. თუ ამოდენა იხერხა და შესძლო ამ უხეირო წერილმა, მე ამის მეტი არა მინდა-რა და არც მდომებია, ჩემო მოწყენილო მკითხველო! თუ ვერ იხერხა, რა ვუყო? ამით ვინუგეშებ, რომ „ცუდად ჯდომას ცუდად შრომა სჯობია”. ამ დალოცვილს ანდაზას რამდენი უხეირო კაცი ხეირიანად გამოჰყავს და გამოუყვანია. მეც იმათში...
როცა ლუარსაბი იმ ზემოთ აღწერილ განცხრომაში ბრძანდებოდა, სიკვდილი იყო, რომ ვისმეს მოეშალა ამისი ქეიფი და ნებიერობა, ესე იგი ტახტზედ დარბაისლურად და პატიოსნად გადაგორ-გადმოგორება. სტუმარი ეჯავრებაო, ამაზე ამბობდა უგუნური ხალხი, მაგრამ განა სიძუნწით მოსდიოდა ეს ამბავი? აბა თქვენგან არ მიკვირს! სიძუნწე და ქართველი ორივე ერთად მოთავსდება? ყინული და ცეცხლი ერთი-ერთმანეთს არ დალევენ? თუ ეჯავრებოდა სტუმარი, იმიტომ ეჯავრებოდა, რომ უნდა ამდგარიყო და ტანთ ჩაეცვა. ადგომა კიდევ არაფერი, ეს ესე არ ეზარებოდა ლუარსაბსა: ტანთ ჩაცმა იყო ამის სიკვდილი. მთელს ზაფხულს ისე გაატარებდა, რომ პერანგის და მის ამხანაგის მეტს არას მიიკარებდა ტანზედ, თუ თავის ნებაზედ მიაგდებდით, თუ არა, მეტი რა ჩარა იყო. ზამთარში კიდევ პერანგზედ ქურქს წამოისხამდა, თუ ვინმე დიდი კაცი არ ეწვეოდა, ვსთქვათ თუნდა დიანბეგი. მაშინ, რა დროს ამბავსაც მე ვწერ, დიანბეგი დიდი ბობოლა იყო; ეხლაა, რომ, რაც ეს ოხერი სწავლა შემოვიდა, დიანბეგს დიდკაცად არ აგდებენ, თორემ უწინ — უჰ! უჰ! რა დიდი ვინმე ბრძანდებოდა. ასეთი დიდი, რომ კინაღამ აზნაურის სტუმრობაზედ ნათქვამი ანდაზა დიანბეგზედ არ გადაკეთდა: კინაღამ „დიანბეგის სტუმრობა, ნუ გგონია ხუმრობად“ არ შეიცვალა. რომ დიანბეგის სტუმრობა ხუმრობა არ არის — ეს ყოველ გლეხკაცმა ძალიან კარგად იცის დღესაც და ადრევ კი თავადიშვილმაც იცოდა.
დარეჯანი კი არ იყო ეგრე ზანტი, როგორც ლუარსაბი, — ამაში კი ღვთის წინაშე, ისინი ერთმანეთს არა ჰგვანდნენ; გამოვიდა, რომ ფერი ერთი ჰქონდათ და ზნე კი არა. რაკი, ბატონო, კნეინა თვალს გააჭყეტდა, შავარდენივით გადმოფრინდებოდა ტახტიდამ, გადიკრავდა შუბლსაფენსა, ზედ წაიკრავდა ჩითმერდინსა, გადიცვამდა ჩითის კაბასა — ხანდისხან სიჩქარისაგან უკუღმაცა — შიშველა ფეხს შეიმოსავდა ჩუსტითა და — ჰერი ბიჭო — დაეშვებოდა ჩალურისაკენ, სადაც მოსამსახურენი სუფევდნენ, ესე იგი ვაინაჩრობით და გულში ჩაკეტილ გაბოროტებით სულს იბრუნებდნენ. საკვირველიც იყო და სასაცილოც ამ ჩვენის კნეინის ტყუილ-უბრალოდ ფაცა-ფუცი. ეს ამოდენა დედაკაცი, ჩაგოდრებული, ჩასორსლებული, ხშირად დილიდამ შუადღემდინ ფეხზედ იდგა და გორგალსავით დაგორავდა. უსაქმო არ იყო, როგორც სჩანს: იქ მუჯლუგუნს წაჰკრავდა საკერავზედ მთვლემარე წირპლიან გოგოსა, აქ თავში ჩაუტყაპუნებდა ძონძებში გახვეულ პატარა მურიან ბიჭსა, რომელიც მთქნარებით და ზარმაცად სწმენდდა საღამოსათვის ჯერ კიდევ წუხანდელ გაქონილს შანდალსა; აქ იმას გაუწყრებოდა — რაზედ? თითონ კნეინამაც არ იცოდა — რაზედ; აქ ამას გამოგილანძღავდა — რისთვის? — არც ეს იცოდა კნეინამა; დასწყევლიდა, დაჰქოლავდა, დასტუქსავდა — ერთის სიტყვით — მთელის ღამის ნაგუბარსა წამოანთხევდა ქვეშევრდომებზედ, — და მერე დაღლილი და დაქანცული შემობრუნდებოდა; თუ გოგო დაჰხვდებოდა, ვერ მაითმენდა, რომ ერთი მუჯლუგუნი კიდევ არ ეთავაზებინა, „მეხი კი დაგეცა“-საც ზედ დაატანდა, თუ ქეიფზედ იყო, — და ეგრე ქანცგაწყვეტილი შეგორდებოდა ოთახში, საცა ხანდისხან ხოლმე რუმბსავით გაბერილი თავადი გორავდა და, თუ ზაფხული იყო, ჭერში ბუზებსა სთვლიდა. ერთხელ ფრიად ღირსსაცნობი სჯა და ბაასი გამართეს. ეს იყო შუა ზაფხულის პაპანაქებაში, სადილ-წინ, როცა დარეჯანმა გაათავა ერთი ზემოხსენებულ-გვარი მოგზაურობა და თავში ტყაპუნი და ოფლში გაწუწული შემოვიდა ოთახში. ლუარსაბმა შეხედა, და დაინახა თუ არა, რომ ოფლი წურწურით ჩამოსდის წითელ ლოყებზედ, თავის გულში სთქვა სრულიად კმაყოფილმა: — კაი ოჯახის ბურჯია, კაი მადლიანი დედაკაცია გმადლობ, ჩემო გამჩენო, რომ ამისთანა შემახვედრე.
ესა სთქვა და კმაყოფილი თავისი უბრყვილო ბედისა გადატრიალდა ერთის გვერდიდამ მეორეზედ ღვთისა და კაცის მადლიერი თავადი. ეს გადატრიალება იმის ნიშანი იყო, რომ ლუარსაბს იამა რამე.
— სად იყავ, შენი ჭირიმე, — ჰკითხა მერე კნეინასა, — რომ ეგრე დაიღალე?
— როგორ თუ სადა, შენი ჭირიმე? ოჯახობაა, სახლია, კარია, თვალყურის ჭერა უნდა, შენ გენაცვალოს ჩემი თავი, — მიუგო კნეინამ.
— ეგრე, ჩემო დარეჯან, ეგრე გეთაყვანე! დედაკაცობაც ეგ არის და.
— მაშ? — მიუგო ქებით თავ-გაზვიადებულმა ცოლმა, — ესე უნდა თვალგაფაციცებული დასტრიალებდე მოსამსახურესა, თორემ ჭამის მეტს არას გააკეთებს. ბიჭებს მოვლა უნდა.
— მაშ, მაშ!
—ბევრმა არ იცის, როგორ მოეპყრას.
— მაშ, არ იცის, თორემ, რომ იცოდეს, კარგია, მაშ!
— ხანდისხან ტყუილ-უბრალოდაც უნდა დასტუქსო. რომ გამოლანძღო კიდეც, ცუდი არ იქნება. აი, მე გავლანძღავ კიდეც, გავუჯავრდები, დავტუქსავ, დავწყევლი, — სულ რისთვის? იმისთვის, რომ შიში და კრძალვა ჰქონდეს, თორემ შენი მტერი!..
— ოღონდაც, შენი მტერი!.. ოღონდაც!..
— ეს გლეხები არიან: გაქირ ვირსავით თუ ერთხელ შედგა, მერე, თუნდა შვინდის სახრით მისდგე, ფეხს ვერ გადაადგმევინებ, თუ ადრევე დატუქსული არა გყავს.
— ოღონდაც, დატუქსული უნდა გყვანდეს, — მიუგო ხელახლად თავის ცოლის სიბრძნისაგან გაოცებულმა ლუარსაბმა, — ოღონდაც, გაქირ ვირსავით შედგება.
— არა, გეთაყვა, ეს, რაცა ვთქვი, ტყუილია?
— ტყუილი რად იქნება? მართალია. შენოდენა დედაკაცს სიზმარიც დაეჯერება, — წამოროხა უთავბოლოდ ლუარსაბმა. თითონაც არ იცოდა „სიზმარი“ რისთვის ჩააკერა ლაპარაკში.
ორივე დაჩუმდნენ. ლუარსაბმა ჭერს მიაბჯინა თვალები; იქ ჯგუფად ისხდნენ ბუზები. დარეჯანმა მატყლის წინდის ქსოვა დაიწყო.
პატარა ხანს უკან ლუარსაბმა წამოიძახა:
— დარეჯან, აბა, თუ ჭკვიანი დედაკაცი ხარ, გამოიცან, ა იმ ფიცარზედ რამდენი ბუზი ზის?
— აბა სადა?
— აი, ჭერის ფიცარზედ.
თურმე, ნუ იტყვით, ამ სასაცილო ლუარსაბსა, დაჩუმებულნი რომ იყვნენ, იმ დროს ის ბუზები უთვლია! დარეჯანმა რა იცოდა.
— რამდენია? — სთქვა დარეჯანმა, — მაიცა, ჯერ დავთვალო.
— ეგრე ხომ მეც გამოვიცნობ. აბა ისე გამოიცან, კაცობა ის იქნება.
— ისე გამოვიცნო? მაშ კარგი, ოცდაათი იქნება.
— ოლოლო შენ, ვერ გამოიცან.
— მაშ რამდენია?
— რამდენია? გითხრა? არა, არ გეტყვი.
— სთქვი, თუ იცი, რაღა.
— თუ კაცი ვარ, ორმოცი უნდა იყოს. ოლოლო შენ, მე გამოვიცან.
— დიაღ, გამოიცან... დაგითვლია, როგორც იმ დღესა ჰქენი, ეგრე ხომ მეც გამოვიცნობ.
— შენც არ მამიკვდე, ის კარგი მამა არ წამიწყდეს, რომ არ დამითვლია.
— მაშ საიდამ იცი, რომ ორმოცია.
— საიდამ? იქიდამ, რომ გონება მაქვს.
— განა მე კი არა მაქვს გონება?
— შენც გაქვს, მაგრამ კაცის გონებასთან დედაკაცის გონება როგორ მოვა? მე ვარაუდით მივხვდი, რომ ორმოცია.
— რომ არ იყოს ორმოცი?
— ჯარიმა გადამახდევინე.
— მაშ დავთვალოთ.
დაიწყეს ცოლმა და ქმარმა ბუზების თვლა. გამოვიდა, რომ ორმოცდაათზედაც მეტი იყო.
— გამოიცნო?! — სთქვა ნიშნის მოგებით დარეჯანმა, — დიაღ, გამოიცნო, გონება აქვს ამ ჩემ ბატონს და იმიტომ გამოიცნო.
ლუარსაბს შერცხვა, ცოტად აირია.
— გაფრენილან, თორემ ორმოცი იყო, — სთქვა სულელმა თავის გასამართლებლად, — სწორედ გაფრენილან.
— უფრო კარგი, თუ გაფრენილან, უფრო ცოტა არ უნდა დარჩენილიყო? მანდ ორმოცდაათზედაც მეტი არის ეხლა.
ლუარსაბი გაიწურა, ეს რა წამოვროხეო, სთქვა გულშია.
რომ ჩააფუჩეჩოს თავისი მახეში გაბმა, კბილების კრაჭუნით, რომელსაც კნეინა ღიმილს ეძახდა, სთქვა:
— დალახვრა ღმერთმა — ეგ ვეღარ მოვიფიქრე, ბიჭოს!.. თითქო ოთხჯერ დავთვალე.
— აკი არ დამითვლიაო.
— შენგან არ მიკვირს! რომ არ დამეთვალა, სოლომონ ბრძენი ხომ არ ვიყავ, რომ ისე გამომეცნო. როგორ არ დავთვალე, აი დალახვრა ღმერთმა, — შემცდარვარ, თორემ გაჯობებდი, აი, ჩემო სულიკო! მე და ჩემმა ღმერთმა, გაჯობებდი.
სთქვა და გაცრუებული ლუარსაბი შაქარსავით გაუტკბილდა თავის ამ ჟამად გამარჯვებულს მეუღლესა.
— აკი არ დამითვლიაო, შე ეშმაკო, შენა! — მიატანა ღიმილითვე კნეინამა.
— ხომ გაგიტყდი, შენი კუჭისა, სხვა რა გინდა?
— შენი სიცოცხლე და ბედნიერება, ჩემო ტურფავ! რა უნდა მინდოდეს სხვა.
— დარეჯან!.. — უთხრა გულნატკენად და მორცხობით ლუარსაბმა, — დარეჯან!.. თუ გიყვარდე, ტურფას ნუ მეძახი.
— რატომ, შენი ჭირიმე? რატომ?
— ჩემოდენა კაცს არ უხდება, შენ გეთაყვანე: ტურფას პატარა გოშიას ეძახიან, ეგ ძაღლის სახელია, აბა რა კაცის საკადრისია ეგ სახელი?
— მაშ შენ ჩემი გოშია არა ხარ? არა ხარ განა? მე შენგან ეგ პირველად მესმის, — მიუგო გულამომჯდარად დარეჯანმა, რადგანაც ეგონა, გოშიაობაზედ რომ ხელი აიღოვო, სჩანს გულიც აუყრია ჩემზედაო.
ლუარსაბი მიხვდა, რომ გულიც ატკინა და ტყუილ-უბრალოდაც ატკინა, — და რომ ის გულაყრილობის ფიქრი გაუფანტოს, უთხრა კბილების კრაჭუნით:
— ჰო, გეთაყვა, ჰო, შენი გოშია ვარ, მაშ რა ვარ?
— პირწყლიანი დედაკაცი არა ყოფილა ეს დალოცვილისშვილი, — სთქვა თავის გულში ლუარსაბმა, — მოლექსესავით რა ლამაზად მოაწყო ჩემი გოშიობა... რა ენის პატრონია!.. როგორ იხერხა?!
თითონაც უნდოდა ერთი ამისთანა ალერსი მოეწყო რამ, მაგრამ, როცა ეს გაჭირება დაადგებოდა, თვალებში სულ ზურგიელი, თართის დოში, არტალა ნივრით და სხვა ამისთანა გაეჩხირებოდა ხოლმე. აბა ამ საგნებით რა ალერსს გამოხატავს კაცი? მაგრამ ლუარსაბმა მაინც კიდევ მოახერხა წყლიანი სიტყვა:
— შენ იცი, ჩემი რა ხარ? სულის წიწმატი, გულის ტარხუნა, გონების, აბა რა ვთქვა? — თუნდა მარილი იყოს. კარგად არ ვთქვი, ის კარგი და სახელოვანი მამა ნუ წაგიწყდება? კარგი მოწყობა არ იყო?
წამოროშა ესა და მხიარულობის ნიშნად დააკრაჭუნა კბილები თავის პირწყლიანობით აღტაცებულმა ლუარსაბმა. არც დარეჯანი დარჩა უსიამოვნოდ. ხშირად გაუტარებიათ ამ-რიგად დრო ჩვენს ცოლ-ქმარსა. ნეტავი იმათ, მკითხველო!..
III
ლუარსაბმაც კი იცოდა ბიჭების „დაწიოკება“, როგორც თითონ იტყოდა ხოლმე. მართალია, ცოტა ზანტი იყო, მაგრამ იმოდენა მამულ-დედულს მოვლა არ უნდოდა? ეს მამულის მზრუნველობა ძალას დაატანდა ხოლმე და წამოახტუნებდა ტახტიდამა. მაშინ უნდა გენახათ, რა ლამაზი იყო ჩვენი ლუარსაბი: ფეხშიშველა, ლურჯი კალმუხის ქუდით თავზედ, წითელ პერანგის და მის განუშორებელ ამხანაგის ანაბარას, გულგადაღეღილი, ფაშვიანი, ჩიბუხით ხელში მიგორდებოდა მოაჯირის გადასაყუდებელთან და გადასძახებდა ძილისაგან გაბოხებულ ხმითა თავის მოურავს დათოსა:
— დათო! ხორცი ხომ ჩამოიტანე ბაზრიდამ? (იმ სოფელში ბაზარიც გახლდათ).
— დიაღ, შენი ჭირიმე.
— რა ნაჭერია?
— ჩალაღაჯი.
— სამწვადედ?
— სუკი ვიშოვე, შენი ჭირიმე.
— ძვირფასი კაცია, — გაიფიქრებდა ხოლმე მადლიერი მებატონე, მერე დათოს ეტყოდა: — ბარაქალა, ჩემო დათო! თუ კაცმა დაივიწყა, ღმერთი არ დაივიწყებს ბატონის ერთგულობასა. ბარაქალა! შენ ჩემი მარჯვენა მკლავი ხარ, მაგარი მკლავი.
დათო თავს მოიფხანდა ხოლმე და უხეიროდ გაიღიმებდა ამგვარ ქებაზედა.
— მეზვრემ მწვანილი მოიტანა? — ჰკითხავდა კიდევ ბატონი.
— მოიტანა.
— ტარხუნა ხომ არის?
— გახლავს.
— კიტრი?
— კიტრიც გახლავს.
ლუარსაბს იამა. ტახტი რომ ყოფილიყო, ერთი ორჯერ მაინც გადატრიალ-გადმოტრიალდებოდა.
— მაშ სახლი სავსე ყოფილა, — სთქვა ბატონმა სიამოვნებით.
— როდისა გხლებიათ ნაკლული, შენი ჭირიმე, რომ ეხლა იყოს?..
— ეგრე, ჩემო დათო! ბატონის ოჯახის პატივი და სახელი ერთგულმა ყმამ ქვეყანას უნდა მოსდოს. ბარაქალა! თუნდ ნაკლული იყოს, უნდა სთქვა, რომ სავსეაო. შენ გამოცდილი კაცი ხარ, — ეს ყველაფერი იცი.
— ამოდენა კაცი შენს ხელში ვარ და როგორ არ მეცოდინება, შენი ჭირიმე!
— ეხლა ერთი ეს ვიკითხოთ, — სთქვა პატარა ხანს უკან მზრუნველმა მებატონემ, — ურმები გაისტუმრე?
— გავისტუმრე, შენი ჭირიმე! ეხლა თუნდ ორღობეებს იქნებიან გაცილებულნი.
— სად გაისტუმრე?
— ყანაში, შენი ჭირიმე!
— რამდენია?
— ოთხი საბატონო და ათი ბეგრისა.
— რატომ ბეგრისა ხუთმეტი არ არის?
— ხუთმეტი ჩვენ კაცებში თავის გაჩენაში არ შებმულან, შენი ჭირიმე, და დღეს საიდამ იქნებოდა!
— ხუთმეტი უნდა ყოფილიყო, ვეჟო! რატომ არ არის? მე არ ვიცი, ხუთმეტი უნდა ყოფილიყო. როგორ იქნება? ბატონს სამსახური უნდა, მაშ მე ბატონი აღარ ვყოფილვარ!.. გაგონილა!.. ფიე! ხუთმეტი უნდა ყოფილყო. მე ვუჩვენებ იმათ, რომ მე ბატონი ვარ და ისინი ყმები არიან.
მართლა-და ლუარსაბსა თავის დღეში ათის ურმის მეტი არ შეჰბმია და რაზედ გაწყრა ეგრე უწყალოდ? დათოსაც არ ესმოდა — ეს წყრომა რის ნიშანი იყო. გაუკვირდა და ბატონს ყურება დაუწყო, ხომ არ გაგიჟდაო. დიაღ, ლუარსაბი კი იქნება, რომ გაგიჟდეს!.. და თუ ტყუილ-უბრალოდ გაწყრა, მაგისი საბუთები სულ გოგრაში ჰქონდა. როგორც ამისი ძვირფასი კნეინა, ისე თითონაც ძალიანა ჰჩემობდა მოსამსახურეების და ყმის მოხმარებასა.
— გლეხკაცს ეგრე უნდა მოეპყრას ბატონიო, — იტყოდა ხოლმე ბრძენი თავადი, — ეგრე უნდაო, რომ ყოველ ცისმარა დღეს ეშინოდეს, თორემ, ღორის მკბენარსავით, რომ გლეხკაცი ფეხზედ დაისო, თავზედ აგაცოცდებაო. მაშ! შიში შეიქმს სიყვარულსაო.
ოღონდაც, ჩემო ლუარსაბ, ოღონდაც!
ის კი არ იცოდა ამ ბედნიერმა ადამიანმა, რომ უმიზეზო და ამგვარ ტყუილ-უბრალო აპილპილებაზედ გლეხებს სულ სხვა მსჯელობა და დასკვნა აქვთ ხოლმე. ეჰ, შენ რაც უნდა სთქვა, მკითხველო, და ამ ცოლ-ქმარს კი ეგონა, რომ თუ მუცელი მაძღარი აქვთ, ამ-გვარ ყმების მოხმარების ცოდნისაგან აქვთ.
ამისთანა სულელობას ჩვენი გულწრფელი თავადი ეძახდა ბიჭების „დაწიოკებასა“. დარწმუნებული იყო, რომ ეს „დაწიოკება“ ისე აუცილებლად საჭიროა ოჯახისათვის, როგორც სმა-ჭამა კაცისათვისა. ამიტომაც, რომ შემოვიდოდა ოთახში, თავის-თავის კმაყოფილებით ეტყოდა ხოლმე ცოლსა:
— ძლივს არ გავისტუმრე ურმები (ტყუილიც უყვარდა ჩვენს ლუარსაბსა), ძლივს! დალახვროს ღმერთმა გლეხკაცი! ვეჟო, მინამ თავს არ დაადგები და კარგად არ დასჭყივლებ, ხელს კი არ გასძრავს და. გაგონილა! მე რომ არ ვყოფილიყავ, ყანა მინდორში დაგვილპებოდა.
— ეგრე, შენი ჭირიმე, — გაუკეთებდა გულს და თავს უფრო მოაწონებდა დარეჯანი, — ეგრე უნდა. მას აქეთ, რაკი ევამ ადამი შეაცდინა, მას აქეთ ნაბძანებია ღვთისაგან, რომ ჩვენის ოფლით პური უნდა ვჭამოთ.
— ეგ თავადებზედ ხომ არ არის ნათქვამი, გლეხებზედ არის ნათქვამი, გლეხებზედ, — მიუგო ლუარსაბმა.
— მაშინ თავადები სად იქნებოდნენ?
— როგორ არა, იყვნენ: ჩვენი გვარი მაშინდელია.
— რას ამბობ? ისე ჰლაპარაკობ, ასე გგონია, არა იცოდე-რაო. მაშინ ადამის და ევას მეტი არავინა ყოფილა და ადამი თავის თავზედ თავადი ხომ არ იქნებოდა?
— მართლა, ეგ კი ვეღარ მოვიფიქრე. არა, გეთაყვანე, ის რა ხე იყო, იმათ რომ ხილი მოიპარეს?
— ხე ბოროტისა და კეთილისა.
— ეხლა აღარ არის იმისთანა ხე?
—როგორ არა: ამბობენ, რუსთ ხელმწიფის ბაღში ერთი ოქროს ოთახიაო, იმაში არის, სულ იაგუნდის ფოთლები ასხიაო.
— ზურმუხტისა იქნება, — გაუსწორა ლუარსაბმა.
— ჰო, მართლა, ზურმუხტისაა, ზურმუხტიც ხომ ფოთოლსავით მწვანეა: დიაღ, ზურმუხტისაა, სულ ალმასები და იაგუნდები ასხია ხილის მაგიერად.
— ნეტავი მაჭამა, აბა გემო იმაში იქნება.
— ძალიან კი მიგიშვებენ: ქვიშაზედ უმრავლესი ჯარი ახვევია თურმე.
— მაშ ხონთქარს როგორ მოუპარვინებია?
— აი როგორ: ერთი ფერია ყოფილა, ფერია არწივად გადაქცეულა, შეპარულა, მოუგლეჯია ერთი დიდი ალმასი, ჩაუყლაპავს და ისე გამოპარულა.
— წაუღია, წაუღია! რა ეშმაკი ყოფილა!
— მაშ, წაუღია. მერე დედოფალი შებძანებულა, უნახავს, რომ ერთი დიდი ალმასი აკლია, მაშინვე რუსთ ხელმწიფისთვის შეუტყობინებია. რუსთ ხელმწიფე მაშინვე მიმხვდარა, რომ ეს ხონთქრის საქმეა და ომი დაუწყია. ის ომი ხომ დღესაც არ გადაწყვეტილა.
— მაშ შერჩა, შერჩა?
— ვინ იცის? ჯერ ომი არ გათავებულა.
— ნეტავი მე მამეპარა.
— ხომ დაგარჩობდნენ.
— რომ არ შევატყობინებდი: ჩავყლაპავდი და მუცელს ხომ ვერ გამიჭრიდნენ.
— გაგიჭრიდნენ კი არა, მეტსაც გიზამდნენ.
— რა ეცოდინებოდათ, რომ მე მაქვს?
— შენი ჭირიმე, მკითხავს ვერ იშოვიდნენ, რომ ეკითხნათ.
— მართლა, ეგ აღარ მომაგონდა. დაიცა, რა გითხრა: ადამმა რომ შეჭამა, ის რაღა იქნა?
— კუნძულელ ხელმწიფეს ზღვაში ეპოვნა თურმე და იმასა აქვს.
— აბა, დახე ღვთის სამართალსა! მე მეპოვნა, უფრო მადლი არ იქნებოდა?
— მერე ვინ შეგარჩენდა? ორასი წელიწადია თურმე მაშრიყ-მაღრიბის ხელმწიფე სულ იმისათვის ებრძვის კუნძულელსა.
— აქამდინ ვერ წაართო?
— ვერა.
— პაი, პაი, პაი! ღონიერი არა ყოფილა ისიცა!..
— მე კი არ ვიცი, რომ ღონიერი ყოფილა!.. ხელმწიფე და უღონო გაგონილა!
— ერეკლე მეფე რომ ყოფილიყო ეხლა, ის კი უთუოდ წაართმევდა, დიდ ვაჟკაცს ამბობენ.
— ის, რასაკვირველია, წაართმევდა, მაგრამ სად არის?
— ცოდო არ არის, ის ეხლა მიწაში ლპებოდეს და შენი მაზლი დავით კი ცოცხალი იყოს!
— აბა, უყურე წუთის-სოფლის მუხანათობას! ეგ რა კიდევ, თამარ დედოფალი შავ მიწაში უნდა იყოს და შენი რძალი ელისაბედი კი მზეს უყურებდეს!
— აბა, წუთის-სოფლის ანგარიში ეგ არის და, — დაატანდა ლუარსაბი და ამოიოხრებდა, მერე ისე, რომ სანთელი წინ სდგომიყო, გააქრობდა.
დილით ლუარსაბი და მისი მეუღლე კნეინა დარეჯანი, რაკი მოიცლიდნენ იმ საუცხოვო ოჯახის მოვალეობისაგან — რომლის ნიმუშიც ზევით მოვიხსენიე, მიუჯდებოდნენ ჩაის და ერთი ლაზათიანად გაიბერებოდნენ თბილის წყლით, როგორც ამბობს ჩვენი გლეხკაცი. პატარა ხანს უკან, ორიოდ გონიერ ბაასის შემდეგ, თუნდ იმის მსგავსისა — როგორც ზემოხსენებულია, სადილობაც მოვიდოდა, ერთი მაშინ მიძღებოდნენ „ძველებურადა, ჩვენებურადა“, — და ლუარსაბი რაღაც დაღლილის სიამოვნებით წამოიძახებდა ხოლმე გულწრფელად: „გმადლობ შენ, უფალო, რათა განმაძღე მე“. ამას იტყოდა თუ არა და, გამოისახავდა პირჯვარსა, მსწრაფლ სუფრიდამ იქავ ტახტზედ გადაგორდებოდა და, სრულიად კმაყოფილი თავისის ცხოვრებისა, დაიკრავდა მუცელზედ ხელსა და იტყოდა რაღაც ტრაბახობითა: „მე თუ უსწავლელი ვარ, მე ვიცი... რა ჰქვიან... მე ვიცი, შიმშილით კუჭი მიდნება, დიაღ, მიდნება! ზედაც ემცნევა ჩემ სტომაქსა“. გამოსაცდელად ერთს კიდევ დაიკრავდა მუცელზედ ხელსა, თითქო სინჯავსო, კარგად არის გატენილი თუ არა, და რა ჰნახავდა, რომ კარგად არის, როგორც ცხენი დააკრაჭუნებდა კბილებს მეტის სიამოვნებისაგან: „დიაღ,— კიდევ იტყოდა, — ლუარსაბი უსწავლელი გახლავთ, იმიტომაც მშიერია“. სადილს შემდეგ ძილი, მერე ისევ გაღვიძება, მერე ისევ ჩაი, მერე ვახშამი, და ბოლოს ისევ ის სატრფიალო ძილი, — და ესრეთ ტკბილად და აუმღვრევლად მიდიოდა ამ ორთა უმანკო სულთა უბოროტო ცხოვრება ამ წუთის-სოფელში, რომელმაც ისე არაფერი არ იცოდა ამათის ვინაობისა, როგორც ამათ არა იცოდნენ-რა, ჭამა-სმის გარდა, ღვთისაგან განაჩენი ამ მუხანათის წუთის-სოფლისა.
IV
ამ ყოფაში და ჭკუის გონიერ ვარჯიშობაში გადიოდა დილა. როცა სადილს უკან ლაზათიანად გამოიძინებდნენ ცოლ-ქმარნი, როცა საღამოზედ ნიავი ფრთას გაშლიდა და ბაღჩის ღობის გრძლად გამოწოლილი ჩრდილი ეზოს მოადგებოდა, მაშინ კნეინა დარეჯანი ერთ ბალან-გაცვივნულ ხალიჩას ჩრდილში გააშლევინებდა და დაბრძანდებოდა ხოლმე თავმომწონე პატარძალივით თავდახურული, წარბებ-აჭიმული და გამოპრანჭული. ლუარსაბიც, თავის განუშორებელ ჩიბუხით ხელში, ჩამოვიდოდა — და ქოშებით შიშველ ფეხებზედ, ხშირად წითელ პერანგის ანაბარას და უფრო ხშირად ლურჯ კალმუხის დარბაისლურად ჩატეხილ ქუდით, ბოლთასა სცემდა გრილოშია.
საღამო ხანი — როგორც მოგეხსენებათ — ჩვენს სოფლებში და ნამეტნავად კახეთში სადარბაზო ხანია. რაც ეს რაღაც წყეული განათლება შემოვიდა ჩვენს ქვეყანაში, რასაკვირველია, — მეტად თუ ნაკლებ ეს საქებური ჩვენი ძველი ჩვეულებაც დაჩაგრა, ასე რომ ზოგიერთნი განათლებით გაჩარხულნი ეხლა ვიზიტობენ, თორემ უწინ კი საღამო ხანი დიდს პატივში იყო. ამიტომაც საღამოობით დარეჯანი ეგრე გამოიპრანჭებოდა ხოლმე და ასე იფიქრეთ — უკაცრავოდ კი არ ვიყო — საკურტუმესაც კი გაიკეთებდა. მაშინ, როდინდელ ამბავსაც მე ვწერ, ჯერ კრინოლინი არ იყო, — და თუნდ ყოფილიყო კიდენაც, იმ სოფლამდინ ვინ მიაღწევინებდა მაგ იუბკების მეუფესა. ყველამ კარგად იცის, რომ განათლება ფეხ-მძიმედ დადის, ნამეტნავად ჩვენში ასკინკილობს, და აბა იმ სოფელში ეგრე ჩქარა როგორ მიიტანდა სახელოვანს „ხაბარდასა“. სწორედ გითხრათ, ზოგიერთ სოფლის ორღობეებშიაც ვერ გაეტეოდა ეგ განათლებული კრინოლინი, თუნდ რომ მისულიყო კიდენაც.
— ქალბატონი ადღეგრძელა ღმერთმა, — უთხრა ერთხელ ერთმა ლამაზად მოყვანილმა გლეხის პატარძალმა, გრძელ კავების ქნევით და ცოტა ტუჩების პრანჭვითა.
— აი, ღმერთმა გაცოცხლოს, ჩემო ბაბალე!.. რასა იქ, ხომ კარგადა ხარ? — მოიკითხა თავის რიგზედ დარეჯანმა, მაგრამ ისე კი, რომ პატივი კნეინობისა სრულიად არ დაუმცირებია.
— რაღა რასა ვიქ, შენი კვნესამე! ჩვენებიანთ ვენახში ჩვენი კამეჩი შეპარულა, და მეველეებს დაუჭერიათ, ეხლა ორი დღეა ბაკში ჰყავთ დაჭერილი. ეხლა, შენი სახელის ჭირიმე, ამას გემუდარები, გვაპატივებინოთ, აგრემც ჩვენი ნათელ-მირონობა დღეგრძელობას მოგიმატებს, შენი კვნესამე!
— რა? მითამ გამოვაშვებინოთ?
— ჰო, შენმა მზემ, ეხლა ჩვენი ვედრება ეგ არის, ქალბატონო.
— როგორ იქნება, ჩემო ბაბალე? ეხლა, მართალია, შენ ჩემი ნათელ-მირონი ხარ, მაგრამ სოფელი აყაყანდება, ყველა მაგას მოჰყვება.
— აგრემც ღმერთი ბატონის თავს გიდღეგრძელებს, და მაშინ, როგორც გნებავთ, დამსაქმეთ. აი ეხლაც, შენი კვნესამე, ერთი გაბმა აბრეშუმი მოგართვი, ღმერთი და თქვენი წყალობა თუ კიდევ შეგვაძლებინებს — კიდევაც თქვენი ყურმოჭრილი ყმანი ვართ.
ბაბალემ ჯიბიდამ ამოიღო ერთი გაბმა აბრეშუმი და მიართო კნეინასა. კნეინამ გამოართო და ამოიდო ქვეშ, ზედაც დაატანა:
— ეგ რომ არა ყოფილიყო, განა ისე კი, რაც შემიძლიან, არ გაგირიგებდი! — ლუარსაბ! ლუარსაბ! — დაუძახა ქმარსა, რომელიც შორი-ახლო ბოლთასა სცემდა და ერთი-ორჯერ მსუნაგსავით მაცდურის თვალით გადმოჰხედა კიდეც მოხდენილ პატარძალსა.
ლუარსაბი მოვიდა.
— ქა! ბაბალეს კამეჩი მეველეებს დაუმწყვდევიათ და გემუდარება — გამოაშვებინო.
ლუარსაბმა შეხედა პატარძალსა, რომელმაც ჩვეულებისამებრ თავი იქით მიიბრუნა. ლუარსაბმა დააკრაჭუნა კიდეც თავისებურად კბილები სიამოვნების ნიშნად, მითამ-და სამაცდუროდ გაიღიმა.
— კამეჩიო!..
— ჰო, კამეჩი, — დაატანა დარეჯანმა, — აი ერთი გაბმა აბრეშუმიც მოგართვა.
— მაშ კარგი! დათო ბიჭო! დათო! — დაიყვირა ლუარსაბმა, — ჩადი და უზბაშს უთხარი, ჩემი ნათლიდედის კამეჩი ეხლავ გამოუშვას, თორემ იქაურობას სულ მტვერს ავადენ.
სთქვა, ერთი კიდევ მაცდურად დააკრაჭუნა კბილები, და გამარჯვებულსავით ამაყად წავიდა ისევ ბოლთის საცემლად.
— აი, აგრემც ღმერთი მაგაზედ უფრო მეტს დიდებას და პატივს მოგცემს, აგრემც გაგაპატიოსნოს ღმერთმა, და ერთი კაი ვაჟიშვილი მოგცეს და მე ძუძუ მაწოებინოს, შენი კვნესამე, შენი, ბატონო და ქალბატონო!
— ჰხედავ, — უთხრა დარეჯანმა, როცა ლუარსაბი წავიდა, — ჰხედავ, რა რისხვა შეუთვალა, იქაურობას სულ ააწიოკებს.
— დიდება აქვს, შენ გენაცვალე, და იმიტომ.
— ეგეც ხომ, მაგრამ ხმაც დიდი აქვს სოფელში გავარდნილი. აი, დავით, ჩემი მაზლი: იმას კაცად არავინ აგდებს.
— აბა, შენი კვნესამე, იმათ ფეხი სად მოუწვდებათ თქვენამდინ, ელისაბედიც მითამ თავადის-შვილის ცოლია და თქვენცა?
— ახლა იმასა ჰკითხე ზოგი, იმისთანა დიდი-კაცი აქ არავინ არის.
— უი, უწინამც დღე გაუქრება! გუშინ მეზობლიანთას გახლდი, იმათი გოგოც იქ მოვიდა. რაც იმან იმათზედ ილაპარაკა, ადამიანისაგან არ გაგონილა.
— რა, გეთაყვანე, რა! — ჰკითხა აჩქარებით და მოუთმენლად დარეჯანმა.
— რაღა რა? ისა, რომ საწყალ გოგოს თავისის თითებით მოგროვილის ფულით ერთი ჩითმერდინი უყიდნია, იმას უნახავს და წაურთმევია. ეხლა თურმე თავზედ იკრავს. გოგოს ცოდვით აღარა ვართ, ქალბატონის მზემა, ისე გულანატირად ჰლაპარაკობდა ბედშავი. მე ხომ თქვენის ფეხის ნატერფალიც არა ვარ, მაგრამ მაგას მეც ვითაკილებდი, მამა მიცხონდა!
— უი! უი! დახე იმას, იმ წყეულს! ამას იქით როგორღა ამბობს, რომ თავადის-შვილის ცოლი ვარო. წართმევა არაფერი, ეგ, რასაკვირველია, ქალბატონის ნებაა: გოგოც ჩემია და ჩითმერდინიც; მაგრამ გოგოს ჩითმერდინის თავზედ შემოკვრა კი სწორედ თავლაფის დასხმაა. კუმ ფეხი გამოჰყო, მეც ნახირ-ნახირო. აი, მეხი კი დაეცა. ისიც, ამას იქით, ჩვენში ერევა, თავადის-შვილის ცოლი ვარო! სხვა არა უთქვამს-რა გოგოსა?
— სხვა არა მოუხსენებია-რა.
— ნუ დამიმალავ, ჩემო ბაბალე! ხომ იცი მე შენი მწყალობელი ვარ, თუ უთქვამს კიდევ რამე — მითხარი.
— არაფერი არ უთქვამს, მამი-ჩემის ცხონებამ, თორემ, რომ ეთქვა, რად დაგიმალავთ.
— რა ვიცი? იქნება გეშინოდეს-მეთქი.
— თქვენისთანა მწყალობელი რომ კაცს სადმე ეგულებოდეს, იქ ვიღასი უნდა ეშინოდეს.
— მეც ეგ უნდა მეთქვა, ჩემო ბაბალე!
— მართალია, გლეხები გახლავართ, მაგრამ ჩვენც გვესმის ეგენი. ვისი უნდა მეშინოდეს, თქვენ აქა მყევხართ!
— მაშ სხვა არა უთქვამს-რა?
— არა უთქვამს-რა, აგრემც ჩემზედ მიწა ნუ გენახოთ.
— იტყოდა.
— ის ერთი დედის-ერთა შვილი არ დამიმიწდეს, არა უთქვამს-რა.
— მართლა, შენი შვილი რასა იქს? — ჰკითხა მერე დარეჯანმა, რომ ვერა გახდა-რა.
— რაღა როგორ არის, შენი კვნესამე, ქალბატონო! ავად შენი მტერი გვყვანდეს, ავად მე ისა მყავს. რა არ ვუყავი: ბალახებში არ ვაბანე, არ შევალოცვინე, შანები არ შევაბი, მაგრამ ვერაფერმა ვერ უშველა, აგრემც არა ეშველოს-რა შენს მტერსა! თქვენთანაც კი მომასწავლეს, ვითამც თქვენ უებარი ლოცვა იცოდეთ, — მიშველეთ რამე, აგრემც მაგიერს ღმერთი გადაგიხდით.
— მე მარტო შაკიკის ლოცვა ვიცი და დასუნთქვილისა. განა შენი შვილის სენი — შაკიკია?
— ჰო, თქვენმა მზემ, შაკიკი გახლავთ. ლამის თავი გაუხეთქოს.
— გოგო, ლამაზისეულო! — დაიყვირა კნეინამ, — წადი, საწერკალამი და ქაღალდი, ქეჩის ქვეშ რომ ნაბარათევია, ჩამომიტანე. მე დაგიწერ ლოცვას, ჩემო ბაბალევ, დაწერილი ქაღალდი იმ მხარეს დააკარ, რომელიცა სტკივა, ეგრე იყოს ორი-სამი დღე, თუ შაკიკია — გააქარწყლებს მაშინვე.
ვერ უყურებთ, მკითხველო! კნეინა დარეჯანი მე უსწავლელი მეგონა და დახეთ, რაები სცოდნია? ეხლა მომაგონდა, რომ იმისი განაყოფი რძალი ელისაბედი, რომელიც ორგანაც მოვიხსენიეთ, თურმე ჩუმად ქვეყანაში ჰლაპარაკობდა, რომ ვითომც დარეჯანმა ჯადოობაც იცისო, ვითომც სოლომონ ბრძნის წიგნიც წაეკითხოს და ამიტომაც ღმერთი უწყრება და შვილს არ აძლევსო. ამისთანა ცილისწამებას როგორ დავიჯერებ? მაგრამ ელისაბედი კი ფიცით იჭაჭებოდა, რომ ეგ ეგრეაო. მაინც არ დავიჯერებ; რძალი — როგორც მოგეხსენებათ ჩვენის კურთხეულის ცხოვრების ამბავი — რძლის მტერია. განა ამისთანა ჭორები მოუგონია ელისაბედს დარეჯანზედა?
ამ დროს ძაღლმა, რომელიც შორი-ახლო იწვა და წაეყო ცხვირი მიწაშია, დაიყეფა, მაგრამ, რაკი თვალი გაახილა და დაინახა ორი მომავალი დედაკაცი, ისევ ხმა გაიკმინდა და ღრენით გაჯავრებულსავით ისევ ცხვირი ფეხებით ამოთხრილ მიწაში ჩაჰყო. დარეჯანმაც მოიხედა ამ ხმაურობაზედ და დაინახა კნეინა ელისაბედი და იმის ჩითმერდინით დარბეული, გულდაჩაგრული გოგო.
დარეჯანი ფეხზედ წამოდგა.
— მობძანდით, ჩემო რძალო! — მიაგება სიტყვა ელისაბედსა, — ძლივს არ მოგვიგონეთ!
— შენმა სიცოცხლემ, მოცლა არა მაქვს. ეს ისაო, ეს ესაო, სახლია, კარია, ხომ მოგეხსენებათ.
— აქეთ მობძანდით, აქეთ უფრო ნიავია, — მოიპატიჟა დარეჯანმა.
— სულ ერთია, — სთქვა ელისაბედმა და წაიძრო ფეხიდამ კროული ჩუსტები, გადმოვიდა ხალიჩაზედ და ჩაჯდა დარეჯანის გვერდით.
— სხვა, როგორა ბძანდებით, ჩემო რძალო? ჩემი მაზლი დავითი ხომ კარგად სუფევს, — დაიწყო ისევ დარეჯანმა.
— კარგად გახლავთ, — მიუგო ელისაბედმა.
— შინა ბძანდება?
— აბა ამისთანა დროს კაცი შინ დადგება, მამულის და მოსავლის პატრონი? — ყანაშია, ეს ორი დღეც იქნება, — სთქვა რაღაც ნიშნის მოგებით ელისაბედმა და უნებლიეთ შეჰხედა ლუარსაბსა, რომელიც ბოლთასა სცემდა და რომელსაც ფეხებზედ ეკიდა მოსავალიც და მამულიცა.
დარეჯანს ეწყინა. ამას ეგონა, რომ ელისაბედმა სახრე ლუარსაბისაკენ გადმოიქნივა.
— რასაკვირველია, ვისაც კაცი არა ჰყავს და არ აბადია, — რომ ჩააბაროს სახლის პატრონობა, და ვინც ასე გაზრდილა პატარაობითვე — რომ არც მზე დასიცხავს და არც ავნებს, ის შინ არ დადგება, ჩემი ლუარსაბი მაგას ვერა იქს.
— განა მაგაზედ მოგახსენე! — დაასწრო ელისაბედმა.
— მეც განა მაგაზედ მოგახსენე! — დაატანა დარეჯანმა, — მე მარტო ეს უნდა მეთქო, რომ ჩემს ლუარსაბს ჯერ ისე არა გასჭირებია-რა, რომ გლეხობა ჩაიდინოს.
— გლეხობა ჩაიდინოსო!.. რას ბძანებთ, ჩემო რძალო? არა, თქვენმა მზემ! ვინც მოსავლის დროს შინ არა დგება, განა იმისაგან, რომ გაჭირებულია, ან გლეხობა ჩაიდინოს და მესვეურსავით მკაში ბეგრის ხალხთან ოფლი იწუროს? თქვენც არ მამიკვდეთ. აი, თუნდ თქვენი მაზლი, — განა გლეხია, ან გლეხობას იდენს, რომ ყანაშია? სულაც არა, თქვენმა მზემ! მუშები იქა მკიან და იმას კი, როგორც შეჰფერის თავადიშვილის პატიოსნებასა, ხელზედ ლამაზი ნაგეში მიმინო უზის და ნადირობს. გუშინ საღამოზედაც, ჯერისთვის რომ ბიჭი ამოვიდა, ერთი აბგა მწყერი გამოეგზავნა. რა სათაკილოა, თქვენი ჭირიმე, მეფეები ნადირობენ და იმისთვის რა სათაკილოა!..
— არა, თქვენმა მზემ, ჩემო რძალო, მე ჩემს მაზლზედ არ მომიხსენებია. ისიც ლუარსაბის ძმა არ არის, ერთის სისხლისა და ხორცისა? განა არ ვიცი, რომ სხვებსავით ხელებს არ დაიბებრებს ნამგლის ჭერითა და არც ამ პაპანაქებაში დაისიცხება? განა არ ვიცი, ნამდვილის სისხლის თავადიშვილი ამას ვერ აიტანს, — და, სწორედაც მოგახსენო, არც საკადრისია: თავადს — თავადობა უნდა ეტყობოდეს და გლეხს — გლეხობა.
— მართალი ბძანებაა, თქვენმა მზემ!
— არა და, რომ არ იქნება: მთა და ბარი ვის გაუსწორებია?
— არავის, თქვენმა მზემ, ღვთის ბძანებას ვინ წაუვა?
ამ დროს ფეხის ხმაურობაც მოესმა დარეჯანსა, მოიხედა და დაინახა თავისი გოგო, ლამაზისეული, რომელსაც ხელში ეჭირა რაღაც ნაბარათევი და თავმოტეხილი წამლის მინა, რომელიც საწერელობას ჰთამაშობდა.
— რა დაგემართა აქამდინ? ის კიდეც წავიდა, — უბძანა დარეჯანმა.
— ჯერ კიდევ აქ გახლავთ, ჩალურშია თაფლუასთან, — მიუგო გოგომა.
— აშ კარგი, — სთქვა დარეჯანმა, დაიდო მუხლებზედ ქაღალდი და დაიწყო შაკიკის ლოცვის წერა. ამ დროს ლუარსაბიც მოვიდა ახალუხ და შალვარ-ჩაცმული, მოიკითხა ზდილობიანად თავისი რძალი და გაგორდა იქავ ხალიჩის ახლო მწვანე ბალახზედ და, დაასვენა რა ჩიბუხის ტარი თავის ღირსეულს მუცელზედა, — დაუწყო პირაღმა ყურება გუმბათიან ცასა.
მშვენიერს სურათს წარმოადგენდა ეს კრება. აღვწერ, თუ კი შევიძელ ჯერ გოგოდამ დავიწყოთ.
სასაცილო რამ იყო ეს ლამაზისეული: ერთი რაღაც უშნოდ ჩასუქებული, ჯმუხი, ჭუჭყიანი, ტანზედ ეცვა ხამის ჩითის კაბა, ჭუჭყისაგან ვერ გაირჩეოდა — რა ფერისა იყო; კალთები აქა-იქ გამომწვარი ჰქონდა ზამთარში ცეცხლთან ახლო გდებისაგან, ბოლოები სულ მომპალი და შემოფხრეწილი ჰქონდა; დახეულებიდამ გამოჩანდა ერთი რაღაც დამპალის საბნის ნაგლეჯი, კაბის ქვეშა გარშემო ჩამოკიდებული, მითომ და იუბკაა. აი, მეხი კი დაგეცა! ამასაც კი სდომებია იუბკა! თავზედ ეკრა შიგა-და-შიგ ამოფლეთილი ჩითმერდინი, ქალბატონის გამონაცვალი. იმ ამოფლეთილებში მუთაქის მატყლსავით დასორსვლილი შავი — უკაცრავოდ არ ვიყო — წილიანი და დაუვარცხნელი თმა მუჭა-მუჭად ამოშვეროდა. ქუსლებ-დახეთქილი, მუგუზალსავით შავი ფეხები, წენგოსაგან შეღებილი ხელები, ცხვირ-პირი ქვაბების მურით მოთხუპნული — აი, ამ-გვარი იყო ის ცხოველი, რომელსაც დარეჯანი „ლამაზისეულს“ ეძახდა და რომელიც გულ-ხელ-დაკრებილი დაჰყურებდა ბალან-გაცვივნულ ხალიჩასა. ხალიჩაზედ ორი პატიოსანი და დარბაისელი კნეინა იჯდა, როგორც მოგახსენეთ წინათვე, — ორი კნეინა, მაგრამ კი სხვა-და-სხვანაირი: ერთი მსუქანი, წითური, მეორე გამხდარი და უფერო. მსუქანი თავჩაღუნული სწერს, გამხდარი კი თვალ-გაფაციცებით თვალს ადევნებს მწერალის ხელსა, იქნება როგორმე შევატყო, რასა სწერსო: ხანდისხან გოგოსაც თვალს უშვრება და თავს უქნევს იმის ნიშნად, რომ „წეღან რომ სთქვა — „წავიდაო“, ვიზედა სთქვაო“. გოგოც იქიდამ ანიშნებს და ელისაბედი ვერ მიმხვდარა. მაშიბ გოგო პირზედ ხელს იფარებს, თავს იქით იბრუნებს, მითამ ეცინება კიდეც — რომ ელისაბედი ჰცდილობს და ვერ მიმხვდარა კი, და ჰმორცხობს კიდეც — რომ ბატონის რძალთან სიცილსა ჰბედავს. აქეთ ბალახებზედ ხალისიანად ჰქშენს ჩვენი ლუარსაბი, პირაღმა წევს, აბოლებს ჩიბუხს და, მინამ თვალში ცრემლი არ მოუვა, თვალს გულმოდგინებით ჩიბუხის ბოლს ადევნებს, — ვნახო, ღრუბლებამდინ ავა, თუ არაო. იქით, ხალიჩის დასწვრივ, ღობის გადმოღმა, ჩვენი ნაცნობი ქოფაკი ძაღლი წევს, ისევ-ისე მიწაში ცხვირწაყოფილი და ქანცმიწყვეტილსავით თვალებ-დახუჭვილი; ყოველს ხმაურობაზედ მძიმედ ახილებს თვალსა და გულზედ-მოსულსავით ჰღრინავს, თითქო ჯავრობსო — რომ ძილს უფრთხობენ. პატარა შორი-ახლო ძველი, ჭუჭყიანი სამოვარი სდგას, გვერდით დაჩოქილია გოგოზედ უარესად ჭუჭყიანი, დაგლეჯილი პატარა ბიჭი და, რაც ძალი და ღონე აქვს, უბერავს სამოვარსა. ხანდისხან ისეთის სახით გადააპარებს თვალსა იქითკენ, საცა ძაღლი განცხრომითა წევს და მოსვენებაშია, რომ თითქო შეჰნატრისო მის ყოფა-ცხოვრებასა და გულში ამბობსო: ნეტავი შენ, რომ ძაღლი ხარ! ნეტავი მეც ძაღლი ვყოფილიყავი!
ეს საძაგელი სურათი საძაგელის მიწისა, სასაცილოდ ახამებდა ამ დიდებულ სამხრეთის ცასა, მის ერთნაირად ღრმასა და ციაგსა კამარასა, რომელზედაც სარტყელსავით მიიგრიხებოდა ერთ გაუწყვეტელ ზოლად მთების ლაჟვარდი გრეხილი.
დრო გავიდა. დარეჯანმა გაათავა ლოცვის წერა და ბარათი მისცა გოგოს, ამ სიტყვის ზედ-დატანებით: როგორც გითხარი, ისე მოიქეცი-თქო.
მერე მოუბრუნდა ელისაბედს და შესაქცევრად ჩამოუგდო ლაპარაკი. ლუარსაბი ისევ ოცნებაში იყო და აბოლებდა ჩიბუხსა.
— პურის მოსავალი როგორი გაქვთ წელს? — ჰკითხა დარეჯანმა.
— თქვენმა მზემ, შარშანდელზედ ცოტა. თქვენს მაზლს ოც-და-ათის ურმის იმედი აქვს, — დაიტრაბახა ელისაბედმა.
— ეგ, ბატონო, კაი მოსავალია. ოც-და-ათი ურემი ხუმრობა არ არის; ჩვენც მოგვივა მაგდენი, მაგრამ ჩვენ ერთი ორად მეტი ნახნავი გვქონდა თქვენზედა, — იტყუვა თავის რიგზედ დარეჯანმაც.
— რას ბძანებთ, ჩემო რძალო, ჩვენზედ მეტი თქვენ რად გექნებოდათ. ჩვენ დიდი ნახნავები გვქონდა წელსა.
— რად გექნებოდათო? ჩვენ მკათათვის ნახევარში გუთანი გატანილი გვქონდა, თქვენ კი ენკენისთვეშიაც არ გაგეტანათ.
— არა, თქვენმა მზემ, ჩვენ თქვენზედ ადრე გავიტანეთ. ჩვენ დიდი ნახნავები გვქონდა.
— აი, ბატონო, თუნდ ლუარსაბსა ვკითხოთ. ეგ კაცია, მაგას უფრო ეცოდინება. ლუარსაბ! — დაუძახა ქმარს კნეინამა.
— რაო? — ჰკითხა ლუარსაბმა და მოიღრიჯა ცოლისაკენ კისერი.
— შენი რძალი ამბობს, რომ ჩვენ ამათზედ ნაკლები ნახნავები გვქონდაო წელსა.
— ეჰ, რას ამბობ, ჩემო რძალო! წელს ოთხი თქვენოდენა ნახნავები მქონდა, — მიუგო ლუარსაბმა. ამ-გვარებში ლუარსაბმა საშინელი კვეხნა იცოდა. — რას ბძანებთ!.. ჩემოდენა მოსავალი კახეთში ორს არ მოუვა, ქართლშიაც ბევრს არ მოუვა. აი, ჰნახავ, რამოდენა ფრთა-მოქცეულს წამოვაყენებ კალოზედა. ასეთს წამოვაყენებ რომ... რომ... აბა რა გითხრათ? თუნდ თორმეტ ამ სახლის ოდენასა, ვაი არა აქვს ლუარსაბსა! ფიე! ნახნავი იყო, რომ ჩემი იყო. შარშან ვენახისა არ იყოს, ჩემოდენა ღვინო კახეთში ორს არ მოუვა. ქართლში ხომ ნახევრის ნახევარიც არ მოუვათ. მაშ! თუ ეს მართალი არ იყოს, საიდამ ვცხოვრობ ეგრე მეფურად? საიდამ? ლევანსავით ურმებს ხომ ქირაზედ არა ვგზავნი, თავადიშვილის სისხლს ხომ არ შევირცხვენ! სომეხი ხომ არა ვარ, რომ ქირაობით ვიცხოვრო. თავადიშვილი ვარ, კაი ოჯახის და გვარის შვილი.
კიდევ რაღაცა უნდა ეთქვა, მაგრამ ელისაბედმა აღარ დააცალა:
— მართლა, ჩემო მაზლო, ლევანი ქირაზედ ურმებს ატარებს?
— მართლა, მაშ! ის შერცხვენილი, გვარის დამამცირებელი ისა!
— ნიკოლოზიც ატარებს თურმე, — დაუმატა დარეჯანმა.
— მაშ?! — უპასუხა ლუარსაბმა.
— უი, ლაფი დაესხათ თავზედ. კარგი გვარის მასახელებელი ისინი ყოფილან, — სთქვა ელისაბედმა.
— ნეტავი თავადიშვილი მაინც არ იყოს! — დაუმატა გულმტკივნეულად დარეჯანმა.
— ეგ არის და, რომ თავადიშვილია! — სთქვა წყრომით ლუარსაბმა. — თავადიშვილი რომ არ იყოს, ჯანი გავარდეს. ან გლეხი იყოს, ან სომეხი, კიდევ ჰო, — ეგა მკლავს, რომ თავადიშვილია. ძალიან არ წახდა ხალხი, თქვენი ჭირიმეთ! ამასაც შევესწარი, რომ თავადიშვილი ქირაზედ ურმებს ატარებს!
— ერე რა დედ-მამის შვილი — წამოიძახა დარეჯანმა.
— ეგა სთქვი და, — მიუგო ლუარსაბმა.
— კაცმა ეგრე როგორ უნდა დაკარგოს პატივი, — სთქვა თავის რიგზედ ელისაბედმა.
— ამას იქით გლეხი და თავადი რით უნდა გაირჩიოს. გლეხიცა გზავნის ურმებს ქირაზედ და თავადიშვილიცა, ისიც ქირითა სცხოვრობს და ესეცა. რით უნდა გაირჩიოს? — იკითსა ლუარსაბმა.
— არაფრით, თქვენმა მზემ, — დაარწმუნა რძალმა.
— ოღონდაც, რომ არაფრით, — კვერი დაჰკრა ცოლმაც.
— მშიერი რომ ვკვდებოდე, მშიერი, და ასი ურემი მებმებოდეს, მე მაგას არ ვიკადრებდი, თავი არ მომიკვდება. შენა, ჩემო რძალო?
— უი, უწინამც დღე გამქრობია. ვიკადრებდი კი არა, მე ჩემის ხელით თავს მოვიკლავდი. ოხრად დამრჩეს ქირით შემოტანილი ქონება. რა თავადიშვილის საქმეა.
— შენა, დარეჯან? — ჰკითხა ეხლა თავის ცოლს ცნობისმოყვარე თავადმა.
— არც მე, — სთქვა დარეჯანმა.
— მაშ არც მე, — სთქვა ლუარსაბმა იმ სახით, თითქო ამ სამის აზრით სამის ქვეყნის ბედი გადაწყდაო. — არა, დრო ძალიან გამოიცვალა, ჩემო რძალო! — გააგრძელა სიტყვა ლუარსაბმა, — ხალხი წახდა, სისხლი მოითხარა. აბა ჩვენ დროს ვინ მოიფიქრებდა, რომ თავადიშვილს თავი შეერცხვინა და ურემი ქირაზედ ეტარებინა. ქვით არ ჩავაქვავებდით? თავზედ ლაფს არ დავასხამდით? მაგრამ ეხლა? — დასწყევლოთ ღმერთმა — სირაჯობენ კიდეცა!.. გაგონილა? თავადიშვილების სირაჯობა! ოჰ, ღმერთო, რატომ წარღვნა არ მოვა? სომხები გახდნენ, სწორედ სომხები: ეხლა ისღა აკლიათ, ადლი ამოიჩარონ იღლიაში, სოფელ-სოფელ იარონ და „სავაჭრო, სავაჭრო“ იძახონ.
— მაგასაც იქმონენ, თქვენმა მზემ, — სთქვა ელისაბედმა, — მე კი ღმერთმა ნუ შემასწროს იმ დროსა და!
— იქმონენ, თავი არ მამიკვდება, იქმონენ, — წარმოსთქვა მწუხარებით ლუარსაბმა, — ბატონო! სისხლი რომ აღარ არის? წახდა სისხლი, მოითხარა.
— მართლა რომ წახდა, — დაატანა დარეჯანმა.
— ი, მაგალითად, გუშინ ზაქარიას ცოლს რა უქნია? — წამოიძახა ენაჭარტალა ელისაბედმა, — იცით რა უქნია? — ბიჭს გაუჯავრებია... ზაქარიას ცოლი ხომ ანჩხლია?
— მერე რა-რიგი! საშინელი! — დაჰკრა კვერი დარეჯანმა.
— ბიჭს გაუჯავრებია, — დაიწყო ისევ ელისაბედმა, — გამოსდგომია, წაუძვრია ფეხიდამ — ჩუსტი ყოფილა თუ ქოში — ქოში იქნებოდა — ამდენი უცემია, რომ დაუოსებია თურმე.
— არა, თუ ღმერთი გწამს? — ჰკითხა გაკვირვებულმა ლუარსაბმა.
— თქვენმა სიცოცხლემ!
— ეს რა მესმის, თქვენი ჭირიმეთ! იქნება პატარა ბიჭსა სცემა?
— კიდეც ეგ არის, რომ არა. პატარა ბიჭს რომ სცემოს, ეგ არაფერი: აი, მეცა ვსცემ ხოლმე, — სთქვა ელისაბედმა.
— მეცა, თქვენმა მზემ, — უპასუხა დარეჯანმა, — პატარა ბიჭი და გოგო სულ ერთია. როგორც ქალბატონმა რომ გოგოსა სცემოს, არ დაიძრახება, ისე პატარა ბიჭს რომ სცემოს, არაფერია.
— რასაკვირველია, — ჩამოართო სიტყვა ელისაბედმა, — პატარა ბიჭის ცემაზედ ვინ დაიძრახება. ის კი ვაჟკაცი კაცი გხლებიათ, აბა ქალი რომ ვაჟკაცს შეებას, — ვერაფერია, თქვენმა მზემ.
— დიდება შენდა, ღმერთო ჩემო, — სთქვა პირჯვრის-წერით ლუარსაბმა, — ეს რა მესმის, თქვენი ჭირიმეთ: დედაკაცმა ისე თავზედ ხელი უნდა აიღოს, რომ ვაჟკაცსა სცემოს? ცემა არაფერია, მაგაში ბატონს ვინ დასძრახავს, — იმისი ბატონი არა ვარ, რომ მინდა ვცემ, მინდა არა, — მაგრამ კაცმა კაცს უნდა სცემოს, დედაკაცისაგან რომ არა თქმულა! რომ არ გაგონილა! აი, გოგო ჰყავს, გოგოს რამდენიც უნდა სცემოს, ეგ საკადრისია, კაცს კი... ღმერთო დამიხსენ ქვეყნის ცოდვისაგან.
— ეგ რა კიდევ... — უნდა დაეწყო კიდევ ელისაბედს ჭორიკანაობა, მაგრამ ამ დროს ჩაიც მოართვეს.
— სიტყვა კი არ დაივიწყოთ, ჩემო რძალო, — უთხრა დარეჯანმა, — ჩაი მიირთვით.
— მიირთვით, სულ ერთია, — უპასუხა ელისაბედმა და წამოავლო ჭიქას ხელი.
ჩაი ჩამორიგდა.
ელისაბედმა მოსვა ცოტა თუ არა, ისევ დაიწყო გაწყვეტილი სიტყვა:
— იმას მოგახსენებდით: იმ წუწკს ნიკოლოზს, იცით, რა უქნია? თავის მოახლისათვის არშიყობა დაუწყია. ერთხელ ბინდი ყოფილა, — აქ რაღაც წასჩურჩულა დარეჯანს ყურში, — ბიჭებს დაუნახავთ, ქალბატონისთვის შეუტყობინებიათ, ის საწყალი ქალიც მისულა და გულს შემოჰყრია. აი, ბატონო!..
— მართლა?
— თქვენზედ მიწა არ მენახოს! — მოაჭორა ელისაბედმა და, მითამ ნიკოლოზის ცოლზედ გულიც შესტკივა, დაუმატა: — მე ის საწყალი ქალი მეცოდება, თორემ ნიკოლოზს თუნდა თავშიაც ქვა უხლია.
— საშინელ დროებას არ შევესწარით, თქვენი ჭირიმეთ! — მართალის გულით სთქვა ლუარსაბმა, — სწორედ მეორედ მოსვლა მოახლოვდა: ვაჟო, ქალს — ქალობა აღარ ეტყობა, კაცს — აცობა. ტყუილად კი არ მოგვეჩვენებიან ეს კუდიანი ვარსკვლავები, ერთი ღვთის რისხვა რამ უნდა მოვიდეს. რომ არ გაგონილა ყურით და ენით არა თქმულა ქალისაგან ვაჟკაცის გალახვა და ქმრისაგან ეგრე აშკარად მაგისთანა ამბები! სირცხვილი აღარ არის ეხლანდელ დროში. პირში წყალი გაგვშრობია.
— რა, ისე ჩუმად მოეხდინა მაინც იმ სულის მტერსა, კიდევ არაფერი იქნებოდა, — სთქვა დარეჯანმა.
— ჩუმად რომ მოეხდინა, ვინ რას იტყოდა? — გააწყვეტინა სიტყვა ლუარსაბმა. — განა უწინ კი არ იყო მაგისთანა ამბები, ხორციელები არ იყვნენ თუ? მაგრამ უწინ სულ დაფარული იყო, ისე დაიჭერდნენ საქმეს — რომ ხორციელ ადამიანს არ გააგებინებდნენ, — ბევრი მაგისთანაები მომხდარა უწინაც, მაგრამ აბა ერთი შეგიტყვიათ რამე? სულ ისე ჩუმად და გონიერად იცოდნენ უწინ ყველაფერი, ამიტომ რომ პირში წყალი ჰქონდათ. ეხლა, ბატონო, არაფრისა აღარ ჰრცხვენიანთ. ნამუსი აღარ არის, არა, წახდა ქვეყანა.
— სწორედ მეორედ-მოსვლის ნიშნებია, — დაუმატა დარეჯანმა.
— სწორედ. აი, ერთი კიდევ რა შევიტყე. გოგო და ბიჭი დაითხოვეთ, მოგახსენებთ, — სთქვა ელისაბედმა.
გოგო და ბიჭი დაითხოვეს. ელისაბედმა შემოავლო თვალი გარეშემოსა და ჰნახა რომ არავინ არ არის, მიჯდა ახლო. ლუარსაბმა ყურები დააცქვიტა და ახლო მოიწივა. დარეჯანმაც ყურთან ლეჩაქი გადაკეცა, რომ კარგად გაიგოს.
ელისაბედმა დაბალ ხმით დაიწყო:
— ამ წინაზედ რომ კუდიანი ვარსკვლავი ამოვიდა, ხომ გახსოვთ?
— დიაღ, — მიუგეს ერთ-ხმით ცოლ-ქმარმა.
— იმ დღეს თურმე გველეშაპი გამოსდგომოდა მზესა, — ისიც ხომ გაიგეთ?
— დიაღ, დიაღ, გავიგეთ! — წამოიძახეს ერთად შეშინებულმა ცოლმა და ქმარმა.
— იმ კუდიან ვარსკვლავზედ და გველეშაპზედ სომხების ტერტერებს თავიანთი კარაბადინი გაუშლიათ და უთქვამთ, რომ — აქ უფრო ხმა დაიდაბლა — თავადიშვილებს ყმები ჩამოერთმევათო.
— ვაი შენს ლუარსაბსა! — წამოიძახა ფერწასულმა ლუარსაბმა. — ეგ რა სთქვი, რა? აკი მოგახსენეთ, ბატონებო, რომ წარღვნა უნდა მოვიდეს-მეთქი. აი, ღვთის წყრომა! სულ ჩვენისავე ცოდვებისაგან მოგვევლინა. მამა-ჩემი ზაალ ნუ წამიწყდება, რომ წავალ, ზაქარიას ცოლსაც, ლევანსაც, ნიკოლოზსაც წიხლ-ქვეშ გავიგდებ, რომ ეს ამბავი სულ იმათი უნარია. კიდევ ატარონ ქირაზედ ურმები!
— რაზედ გაცხარდი, შენ გეთაყვანე! — მიატანა ლუარსაბსა ცოლმა, — სომხების კარაბადინს როგორ უჯერებ! შარშანწინ კი არა სთქვეს, რომ დედამიწა ხარის რქაზედა სდგას. იმ ხარს ერთი რქა მოსტეხია და ქვეყანა უნდა გადაბრუნდესო, მაგრამ ტყუილი კი გამოდგა. გარეჯელ მკითხავს ეთქო, რომ არც რქა მოსტეხია და არც არაფერიო.
— მართლა, ეგ კი აღარ მომაგონდა — სთქვა ეხლა კი დამშვიდებულმა ლუარსაბმა, — ჭორი იქნება. აბა, გეთაყვა, მეფის ერეკლეს ნაბოძებს სომხის კარაბადინის სიტყვით ვინ წამართმევს? თუნდ ეგ არ იყოს, რიღას თავადიშვილი ვიქნებით, თუ ყმაც არ გვეყოლება: კარაბადინი კი არა, სოლომონ ბრძნის წიგნიც რომ იყოს, არ დავიჯერებ. ან რა დასაჯერია?
— რასაკვირველია, დასაჯერი არ არის, მაგრამ გლეხობაში ეგ ხმა გავარდნილა, — ეგ ცუდია, თქვენმა მზემ, — სთქვა ელისაბედმა.
— ხმა გავარდნილა, მე ვიცი, თათქარიძობას წამართმევენ! შარშან კი არ იძახდნენ, რომ საიქიოს ბატონები ყმებად შეიცვლებიანო, ყმები ბატონებადაო, — ვენაცვალე ღვთის მადლს, იქაც ისე არიანო ბატონი ბატონადა, ყმა ყმადაო, როგორც აქა. ინგლისის ხელმწიფეს ბარათი ჩამოუგდიაო ფრანგის ხელმწიფისათვის, რომ „ნუ გეშინიანო, მეცა და ჩემ დიდკაცებსაცაო აქ უფრო დიდი პატივი გვაქვსო, მინამ მანდაო. ნუ დაიჯერებო, რასაც მანდ ყბედობენო“.
— რასაკვირველია, ეგ აგრე იქნება: ბატობ-ყმობა ღმერთს დაუწესებია და თითონვე ღმერთი რად მოშლის? ვენაცვალე ღვთის დიდებასა! — სთქვა დარეჯანმაცა.
— უფლისა უფალსა და კეისრისა კეისარსაო, სახარებაში სწერია: კეისრები ჩვენა ვართ, — დაუმატა ელისაბედმა.
— მართალი ბძანებაა, ჩემო რძალო! სახარების სიტყვას ვინ წაუვა? — მიატანა დარეჯანმა.
— არავინ, თქვენმა სიცოცხლემ! — დაამტკიცა ელისაბედმა და წამოდგა შინ წასასვლელად, — მშვიდობით ბძანდებოდეთ!
— მშვიდობით, ჩემო რძალო! ბიჭებში კი ხმა გააგდეთ, რომ ტყუილია-თქო, — ურჩია ლუარსაბმა.
— თქვენც რომ ეგრე ჰქმნათ, ცუდი არ იქნება: გლეხები არიან, მალე დაიჯერებენ ტყუილსაც და მართალსაც. მშვიდობით, — გამოესალმა და წავიდა ელისაბედი. თან აედევნა დაჩაგრული გოგო.
— ღმერთო, რა მეჭორეა!.. რა ენაჭარტალაა!.. — უთხრა ქმარს ელისაბედზე დარეჯანმა.
— ის რა მოიგონა, თქვენი ჭირიმეთ, ყმები უნდა ჩამოგვერთოსო! — დაჰკრა კვერი ლუარსაბმა.
— შენ ხომ მაშინვე დაიჯერე!
— კარაბადინმა სთქვაო, მოდი და ნუ დაიჯერებ. ის კი, ღვთის წინაშე, არ მომაგონდა, რომ გარეჯელ მკითხავს ბევრჯერ გაუცრუებია სომხური კარაბადინი.
— გონება სადა გქონდა?
— ეჰ, შე დალოცვილო! აქა მქონდა, მაგრამ ვერ მომაგონდა. სულ რომ მაგონდებოდეს, რაც გამიგია, მეტი რაღა მინდა: სოლომონ ბრძენი ვიქნებოდი. თუნდ ეგ არ იყოს, ქვეყანაზედ რა ვიცი რამდენი ეშმაკის მანქანებაა, ეგეც იქნება ერთი იმათგანი იყოს. ვეჟო, ცოდვილ ქვეყანაზედ რა არ მომხდარა ჩვენის ცოდვებისაგან? ეგეც შეიძლება, რომ მოჰხდეს, მაგრამ სიფრთხილეს თავი არ ასტკივდებაო, ნათქვამია; ხმა გავაგდოთ, რომ ტყუილია.
— რასაკვირველია, ცუდი არ იქნება, ჩვენ მაგითი რა დაგვაკლდება?
— არაფერი, შენმა მზემ, — ეხლავ დავუძახებ დათოსა და ვეტყვი. — დათო, დათო! — დაუყვირა ბატონმა.
— ბატონო! — სადღაც შორიდამ მოისმა დათოს ხმა: — ეხლავ გიახლებით.
ცოტას ხანს შემდეგ დათოც მოვიდა და ჰკითხა ბატონსა:
— რას გვიბძანებთ?
— იმას, რომა, ყმები ჩამოგვერთმევაო რომ ამბობენ, ტყუილია. გესმის, თუ არა? ყველას უთხარი, რომ ტყუილია. ხელმწიფეს მოუწერია, რომ დავარჩობ, ვინც იტყვის, რომ ეგ მართალიაო, ვინც გუნებაში მაგას გაიტარებსო. გაიგე?
— გავიგე, შენი ჭირიმე! — უპასუხა დათომა, — განა მაგას ვინა ჰფიქრობს? აი, რაღაც გოგო-ბიჭები მიჰქარავენ, შენი ჭირიმე, იმათ ვინ დაუჯერებს. წვრილფეხობის სიტყვა რა დასაჯერია? იყბედებენ და დაჩუმდებიან.
— ეგრე სთქვი ხოლმე სხვაგანაც, ჩემო დათო! ან რა კარგი იქნება თქვენთვის, რომ ჩვენ არა გყვანდეთ.
— შენი მტერი ყოფილა, ჩვენ ვიქნებოდით, შენი ჭირიმე!
— რაც უნდა იყოს, მამასავით გპატრონობთ.
— დიაღ, შენი ჭირიმე! სწორედ მამა ბძანდებით და ჩვენ შვილები ვართ. თუ ხანდისხან გაგვიწყრებით, აგვიკლებთ, წაგვართმევთ, — ეგ რა? სულ ჩვენის სიკეთისათვის არის ხოლმე, განა მამა შვილს არ გაუწყრება?
— ოღონდაც, რომ გაუწყრება, მაგრამ შვილი ისევ შვილია, მამა ისევ მამაა ხოლმე.
— მართალი ბძანებაა. სხვას არა აქვს მაგის გაგება, ამბობს, რომ რაც ჩემია — ჩემი უნდა იყოს, ბატონი რად უნდა გვართმევდესო. ის კი არ იციან, რომ თუ ბატონი ართმევს რასმეს, სულ იმათისავე სიკეთისათვის ართმევს. ხომ მოგეხსენებათ, გლეხკაცი რეგვენია.
— ოღონდაც რეგვენია, — ჩაერივა დარეჯანი, — მაშ ბატონი რისა არის, თუ არ დასტუქსავს, არ წაართმევს? თუნდ ეგ არ იყოს: უცხო ხომ არ ართმევს, ისევ თავისივე ბატონია.
— მართალი ბძანებაა. მამაა, უცხო რად იქნება? — დაუმატა ეშმაკობით დათომა.
— დიდი და პატარაობა სად არ არის? — სთქვა ლუარსაბმა, — აი, თუნდ თითებზედ დაიხედე: ერთი დიდია, მეორე პატარა. რისთვის? ამისთვის, რომ ღმერთს აგრე გაუჩენია, დიდი და პატარაობა ყველგან უნდა იყოს. აბა, დაიხედე!
— განა არ დამიხედნია, შენი ჭირიმე! დიდიც არის, პატარაც, მაგრამ, დაილოცა ღვთის სამართალი, ისე გაუჩენია, რომ ერთმანეთს არ უშლიან, — სთქვა ცბიერმა დათომ.
— მაშ! ყველგან არის დიდი და პატარაცა, ეხლა როგორ იქნება, რომ ჩვენში არ იყოს. ან რა დასაჯერია? — გააგრძელა ლუარსაბმა და ვერ გაიგო კი დათოს აზრი.
— ვისაც თავში ტვინი აქვს, აკი არ იჯერებს, შენი ჭირიმე, ვინც უტვინოა — ისინი მოგახსენებენ, რომ მართალიაო.
— როგორი მართალია? — დაატანა დარეჯანმა, — ხელმწიფისათვის ან ჩვენ რა დაგვიშავებია, რომ ყმები ჩამოგვერთოს, ან თქვენ რა შეგიმატებიათ, რომ გაგააზატონ. ეს როგორ ვერ მოიფიქრეთ?
— მითამ მოგახსენებენ, შენი ჭირიმე, ჭკვიან კაცებს დაუწერიათო, რომ ქვეყნისათვის კარგი იქნებაო. ტყუილი უნდა იყოს.
— ტყუილია, მაშ რა არის? — დაიყვირა ლუარსაბმა, — აბა, რომელი ჭკვიანი კაცი იტყოდა მაგას, თუ არ იუდას კერძო?
— აი, მეხი კი დავაყარე იმისთანა ჭკვიანსა! — მიაყარა ქოქოლა დარეჯანმა.
— თუ ეგ მართალია, გარეჯელ მკითხავს იცი რა უთქვამს? — ჰკითხა ლუარსაბმა.
— არა, შენი ჭირიმე! რა მოგახსენათ?
— ისა, რომ ტყუილიაო.
— აბა, იმისთანა გულთმისანს მოდი და ნუ დაუჯერებ, — დაუმატა დარეჯანმა.
— მე ეგ ადრევე ვიცოდი, შენი ჭირიმე, რომ ტყუილია, აბა უბატონოდ რა ხეირი დაგვეყრება? უპატრონო საყდარსაო ეშმაკები დაეპატრონებიანო, გლეხები იტყვიან ხოლმე. ჩვენც ეგრე მოგვივა. ეხლა ამითი გვატყუებენ თავადებსაც და გლეხსაც, რომ ქვეყნისათვის კარგი იქნებაო, თორემ რა დასაჯერია?
— თუ მე არ ვიქნები, ქვეყანა თუნდ ძირიანად ამოვარდნილა, თუნდ ბოდბელისა არ იყოს — „ქვა ქვაზედაც ნუ იქნება“, — სთქვა ლუარსაბმა, — ქვეყნისათვის კარგი იქნებაო! თუ მე და შენ არ ვიქნებით, ქვეყანა რად გვინდა? ჯანიც გავარდნია. არა, დათო?
— დიაღ, შენი ჭირიმე! სულ ტყუილია. მე ბევრისათვის მითქომს, რომ ტყუილია, და როდი მიჯერებენ.
— შენ უთხარი, რომ თითონ ბატონმა თავის პირით მიბძანა-თქო, მაშინაც არ დაიჯერებენ? — უბძანა ლუარსაბმა.
— მაშინ კი რაღა ეთქმით, შენი ჭირიმე!
— ეგრე, ჩემო დათო! ყველას უთხარი.
— ბატონი ხარ, მაშ გიახლოთ?
— წადი.
დათო წავიდა. ვინ იცის გულში როგორ ეცინებოდა ამ პირმოთნე ყმასა.
— არა, გული დააჯერა, რომ ტყუილია, — უთხრა დარეჯანმა, როცა დათო წავიდა.
— ჭკვიანი კაცია, დააჯერებდა, — უპასუხა ლუარსაბმა.
V
— ყველა-ყველა და ამაღამ ვახშმად რა გვაქვს? — ერთს საღამოს ლუარსაბმა თავის მეუღლეს ჰკითხა, როცა ქათმების შესხდომის დრომ მოაღწია. — დარეჯან! არ გეყურება, დედაკაცო? ამაღამ რა უნდა ვჭამოთ?
— რატომ რა უნდა ვჭამოთ, გენაცვალოს დარეჯანი! ღვთის წყალობა ბევრი გვაქვს, — ანუგეშა დარეჯანმა.
— მაინც?
— სადილიდამ დარჩომილი კაი ცივად ძროხა გვაქვს, კარგი ღორის სუკებია, კარგი...
კიდევ უნდა რაღაც ეთქვა, მაგრამ ღორის სუკების ხსენებაზედ აღტაცებულმა ლუარსაბმა სიტყვა გააწყვეტინა:
— უჰ, უჰ, უჰ! ეგ ღორის სუკები, შენმა მზემ, რადაც უნდა ჰღირს. სხვა? მე ამაღამ როგორღაც მადაზედა ვარ.
— ზურგიელიცა გვაქვს, ღვინოები რომ იყიდა, იმისი ფეშქაშია. ასეთია, რომ ქონი გასდის.
— უჰ ეგეც კარგია. სხვა?
— ყველი, პური და კაი გული.
— არც ეგ არის ურიგო, შენმა მზემ: ჩვენისთანა ვახშამი ხელმწიფესაც არ ექნება.
გაიკეთა ჩიბუხი მადა-წახალისებულმა მებატონემ და, მინამ სანატრელს ვახშამს მოიტანდნენ, მოუთმენლად წინა და უკან პატარა ოთახში ბოლთასა სცემდა. ხანდისხან რაღაც ფიქრში გართული უეცრად წამოიძახებდა: „ღორის სუკები? შენმა მზემ, რომ კარგია!“
ვახშამსაც, როგორც ყველაფერსა ამ წუთის-სოფელში, ბოლო მოეღებოდა. გამაძღარი და ტახტზედ გადაგორებული ლუარსაბი ეხლა ხვალისთვის დაიწყებდა ზრუნვასა. მაშ! ოჯახის კაცი იყო.
— ესეც ვახშამი, ღვთის მადლით, გადავაგორეთ, ეხლა ხვალინდელ დღისათვისაც ვიფიქროთ. ხვალაც ჭამა გვინდა, დალოცვილს ღმერთს ეგრე გაუჩენია კაცი. ხვალ რაღა ვჭამოთ?
— ხვალ?.. — ჩაფიქრდა დარეჯანი, ვითომც და ძნელი გამოსარკვევი საქმე მიანდვეს: — ხვალ? დაიცა ერთი მოვიგონო... ხვალ? არტალაზედ როგორა ხარ?
— უჰ, უჰ! შენმა მზემ, კარგი რამ მოიგონე. არტალაზედ? ვაცივითა ვარ, ვაცივით, — უპასუხა მსუნაგსავით სულწასულმა თავადმა, — ბარაქალა, დარეჯან! ერთი კარგი მსუქანი არტალა, ჩვენი თედოს მოხარშული, ნივრით, — ერთ სახელმწიფოდა ჰღირს, მე და ჩემმა ღმერთმა. ეგ ძალიან კარგი. სხვა? მარტო ეგ რას გვეყოფა?
— ერთი კარგი ჩიხირთმა? — ჰკითხა მაცდურის ღიმილით კნეინამა.
— ჩიხირთმა?.. ჰა, ჩიხირთმა?.. არა, გეთაყვა, ბოზბაში სჯობია, — მიუგო მცირე დაფიქრების შემდეგ ლუარსაბმა.
— ეხლა მაგას დაიჟინებ. რითა სჯობია?
— ვა!.. ტყემლის მჟავით გაკეთებული ბოზბაში?.. — ისეთის ხმით წამოიძახა ლუარსაბმა, თითქო უკვირსო: ეს ამისთანა უბრალო ჭეშმარიტება როგორ არ ესმის ამისთანა ჭკვიან დედაკაცსაო.
— შენც არ მომიკვდე, ლუარსაბ, კარგად გაკეთებულ ჩიხირთმას ბოზბაში არა სჯობდეს.
— ვა!.. — უფრო გაკვირვებით შეჰყვირა ლუარსაბმა, — ტყემლით გაკეთებულს ბოზბაშს ჩიხირთმა უნდა ამჯობინო?.. შენს ჭკვაზედ არა ხარ, დედაკაცო! ჯერ ისე ბოზბაში რა არის, რომ ტყემლით რა იყოს!.. რას ამბობ, რასა? ერთი მსუქან ბოზბაშში ამოვლებული პურის ლუკმა მთელ ქვაბ ჩიხირთმას მირჩევნია. ამის შემდეგ შენ უნდა დამაჯერო, რომ ჩიხირთმა სჯობია? მაშ კაცი აღარ ვყოფილვარ, ქუდი არა მხურებია.
— შენ ერთი ახირებული კაცი ხარ: რასაც იტყვი, ხომ კაცი ვეღარ გადაგათქმევინებს? — არ იყო რომ ცოტა წყენით არ უთხრა დარეჯანმა დაჟინებულს ლუარსაბსა.
— მაშ? კაციც მაგისთანა უნდა. ის ხომ კარგია, დღეს ერთი სთქვას, ხვალ სხვა? — სთქვა ლუარსაბმა, შემოიყარა დოინჯი და გამარჯვებულსავით ამაყი შეხედულობა მიიღო.
დარეჯანმა იგრძნო, რომ ლუარსაბმა საბუთიანად დაიჭირა და შერცხვენილმა ბანზედ სიტყვა გადააგდო:
— მაშ შენ ბოზბაშს ამჯობინებ?
— ვამჯობინებ.
— მაშ შენ პირში გემო არა გქონია, — ეხლა კი გულზედ მოსულსავით სთქვა დარეჯანმა.
ლუარსაბი აიტკიცა, მაგრამ თავი შეიკავა და არ იყო რომ მაინც ცოტა წყენით არ უპასუხა:
— შენ არა გქონია, რომ ჩიხირთმას ამჯობინებ, თორემ მე ხომ ბოზბაში მირჩევნია.
— აბა რას მიედ-მოედები? — ეხლა კი გაანჩხლდა დარეჯანი, — ბოზბაში როგორა სჯობია ჩიხირთმასა, რომ როცა ჩიხირთმა მაგონდება — პირში წყალი მომდის, თუ მშიერიც ვარ — მაშინ უფრო, ბოზბაშზედ კი არა. მაშ ჩიხირთმა სჯობნებია. ეხლაც დაიჟინებ?
ისეთ გულდაჯერებით და ზაფრიანად წარმოსთქვა ეს კნეინამა, რომ, ასე გგონია, უნდა ეთქვაო: „შე სულელო, ამისთანა საბუთი მაქვს და შენ კი მაინც შენსას ამბობო?“
მაგრამ არც ამის მოპირდაპირე იყო სუსტის ჭკუისა, რომ ის საბუთი უფრო ძლიერის საბუთით არ დაერღვია. მართალია, პირველშივე ძალიან ჩაფიქრდა, მაშინვე ვერ მოახერხა, — რა ეთქვა, მერე კი — ღვთის წყალობა გქონდეთ — ყოჩაღად ლუარსაბმა იმას მიუგო.
— მაგ სიტყვებზედ სდგეხარ? — ჰკითხა ჯერ ლუარსაბმა და ფეხზედ წამოდგა.
— ვდგევარ.
— მაშ კარგი: შენ ხომ ჩიხირთმა მშიერს მოგგვრის პირში ნერწყვსა, მე კი ბოზბაში — მაძღარსაცა. აი, თუნდა ეხლა: მე ხომ ამაღამ შენზედ მეტი მიჭამია, მაგრამ რომ მაგონდება პირამდინ პურ-ჩაყრილი, ჩაჟუჟუნებული ბოზბაშით სავსე მათლაბა, თუ ზემოდამაც ერთი კარგი კანჭი აძევს!.. რას ამბობ, დედაკაცო? მე მოგიკვდე, თუ შენ გესმოდეს რამე: ბოზბაში — წვნიანების მეფეა, როგორც თართი — თევზებისა. შენ რა იცი, დედაკაცი ხარ.
— აბა შენ კაცმა როგორ უნდა დაგიჯეროს, რომ ეგეც არ იცი: ორაგული თქმულა თევზების მეფედ და არა თართი... აბა, სულ ეგრე სტყუი ხოლმე, — უკიჟინა ნიშნის მოგებით გახარებულმა კნეინამ, რომ ტყუილში დაიჭირა.
შერცხვა ცოტა ლუარსაბსა, მაგრამ არ შეიმცნივა და გაიზრახა, რომ პატივისათვის — რაც უნდა დაემართოს — უნდა დაამტკიცოს, რომ თართი არის მეფე.
— ეხლა მაგას დაიჟინებ. თართია-მეთქი.
— ორაგულია.
— ეჰ, თართია, თავი არ მამიკვდება, არც ეხლა დაიჯერებ?
— ორაგულია, ორაგული! — დასძახა კნეინამა.
— აბა საიდამ იცი, რომ ორაგულია?
— შენ საიდამღა იცი, რომ თართია?!
ამ კითხვამ გააბა ლუარსაბი მახეში. მერე რა-რიგად! ხსნა არ იყო! ძალიან კი უნდოდა მოეგონა რამ, უნდოდა ეთქვა კიდეც, რომ „კარაბადინში“ სწერიაო, მაგრამ მოაგონდა, რომ დარეჯანი უფრო ნაკითხია და ვეღარ გაბედა.
დარეჯანი ჭკვიანი დედაკაცი იყო — როგორც იცის თითონ მკითხველმა ჰნახა რომ ლუარსაბმა პასუხი ვერ მოუხერხა, უფრო-და-უფრო დააყარა თავმოწონებით:
— მითხარ, საიდამ იცი? მაშა! რაც არ იცი, ნუ იტყვი. აბა ეხლა სთქვი: ჩიხირთმა არა სჯობია?
დარეჯანმა იფიქრა, რომ ეგრე დაჭერილი ლუარსაბი თუ გატყდება, ეხლა უნდა გატყდეს. ამისთანა გაჭირებაში თუ დაიყოლიებს ჩიხირთმის უკეთესობაზედ, თორემ სხვა დროს ვეღარა. ამიტომაც ეგრე უეცრად გადავიდა ისევ ჩიხირთმაზედ.
ლუარსაბი დაგვიღონდა, მკითხველო! ისე თავჩაღუნული იდგა, როგორც პატარა ბავშვი, როცა შაქრის ქურდობაში დაიჭერენ. არ იცოდა რა ექნა. ჰგრძნობდა, რომ ცოლმა დაიჭირა, აჯობა, მაგრამ ამის კისრად აღება ეთაკილებოდა. სხვა დროს იქნება დაეთმო, მაგრამ ეხლა, რაკი საქმე სახუმარი აღარ იყო, რაკი ჯიბრზედ შედგა, ეხლა დათმობა სათაკილო ეგონა. მართალია, იყო წუთი, როცა ისე დამარცხებული ჰნახა თავისი თავი, რომ თითქმის დააპირა კიდეც ჩიხირთმის უკეთესობის აღიარება, მაგრამ ამ დროს თვალ-წინ წამოუდგა მაორთქლავი მათლაბა ლავაშ-ჩაყრილის ბოზბაშისა, მოაგონდა ზემოდამაც გადახირული ბატკნის კანჭი, ამან გაიტაცა ისევ ლუარსაბი: ამის სულს ღონე მოემატა, გული გაუმაგრდა, დაავიწყა სირცხვილიც, დამარცხებაც, გამარჯვებაც და ათქმევინა ეს ღონიერი სიტყვები:
— მე არ ვიცი, თუნდ რომ მართლა ორაგული იყოს თქმული თევზების მეფედ, მაინც კიდევ ბოზბაში სჯობია ჩიხირთმასა.
— ჩიხირთმა, ადამიანო!
— ბოზბაში, დედაკაცო!
— ეჰ, წეღანდელი არ იყოს, მტყუანი ხარ და არა სტყდები, — უთხრა ყვედრებით დარეჯანმა.
— შენა ხარ მტყუანი.
— დახე! შენ არა თქვი — თართიაო?
— მე ეგ არ მითქვამს — ეგ შენა თქვი, — იცრუა ლუარსაბმა და თავის სიტყვა თავის ცოლს გადააბრალა, — მე ორაგული ვთქვი.
— დახე, დახე, თქვენი ჭირიმეთ!.. ეს რა მოიგონა! — წამოიძახა ეხლა კი სწორედ გულზედ-მოსულმა დარეჯანმა.
— ამდენი იყვირე, რამდენიც გინდოდეს! — დაბალ ხმით უთხრა ლუარსაბმა და წავიდა, რომ გარეთ გავიდეს. კარებში რომ მივიდა, ერთი კიდევა სთქვა:
— მე ორაგული ვთქვი. — თქმა ამისა და იმისი გარეთ გასვლა ერთი იყო.
— მტყუანს?.. — მისძახა გაკაპასებულმა, ამ უსირცხვილობისაგან მოთმინებიდამ გამოსულმა ცოლმა, — გაუწყრეს წმინდი-გიორგის მადლი და ნეკრესის ღვთისმშობლისა!
ლუარსაბმა ყური არ ათხოვა, თუ ვერ გაიგონა — არ ვიცი, ეს კი ვიცი, რომ ამ წყევლამ დარეჯანს მშვიდობიანად ჩაუარა.
ხშირად შუაღამემდინ ცოლ-ქმარნი გაცხარებულნი და გაჭარხლებულნი ამისთანა ღრმა აზრებს ამტკიცებდნენ: „დღეს რა ვჭამოთ“, — იტყოდნენ დილით. „ხვალ რა ვჭამოთ“, — იტყოდნენ საღამოზედ. ეს იყო იმათი სულის საზრდო, ეს იყო იმათი გონების ვარჯიში, ეს იყო იმათი აზრის აღებ-მიცემა.
რა იცოდნენ ამათ, რომ თავისის ქცევით, თავისის ცხოვრებით არისხებდნენ ღმერთსა, რომელსაც თავისი სული ამათთვის შთაუბერია.
— ვაჟო! მე ვარისხებ ღმერთსაო? — გეტყოდათ გაოცებით ლუარსაბი: — წირვა-ლოცვას მე არ ვაკლდები, კაცი მე არ მამიკლავს და კაცისათვის მე არ მამიპარავს, — რაზედ ვარისხებ ღმერთსა?
მართალი ხარ, ჩემო ლუარსაბ, შენ კაცი არ მოგიკლავს, კაცისთვის არ მოგიპარავს, ერთის სიტყვით — რაც არ უნდა გექნა, არ გიქნია — ესეც კარგია: უარარაობას ეგა სჯობია. მაგრამ ეხლა ეს უნდა გკითხო: რაც უნდა გექნა, ის კი გიქნია?
— დიაღ, — მეტყვი შენ, — მისვამს და მიჭამია, არც ერთი დღე მშიერი არა ვყოფილვარ.
მითამ პასუხი ეგ არის? წირვა-ლოცვას არ ვაკლდებიო რა გამოვიდა? იქ ყოველთვის გსმენია ჩვენთვის ჯვარცმულის ქრისტეს სიტყვა: „ვითა მამა ზეცისა იყავ შენ სრულიო“. აბა, ან ერთს წამს შენს სიცოცხლეში მაგისთვის სცდილხარ? არა, შენ მაგისათვის არა სცხოვრობ: შენ სცხოვრობ — რომ სვა და სჭამო, და არა იმისთვის სჭამ და სვამ — რომ იცხოვრო, ესე იგი ეცადო — რომ ვითა მამა ზეცის იყო შენც სრული.
VI
ოცი წელიწადია თურმე, რაც ლუარსაბი და დარეჯანი ერთს უღელში შებმულან და ერთს ბედის კალთას ქვეშ ამოფარებულან. საოცარი ამბავია ამათი ჯვარისწერა. ჯერ ლუარსაბი თავის ძმასთან — დავითთან — გაუყრელი იყო, როცა ოცი წლისა შესრულდა და მოინდომა ცოლის შერთვა. ძალიან მოინდომა, მაგრამ არ იცოდა ვისი ქალი შეერთო; მდიდარიც უნდოდა, კაი გვარის-შვილიც და მზეთუნახავიცა. ამაების მექონი ქალი ჩვენში ძვირია. ლუარსაბს ჯერ კი თვალი ეჭირა — იქნება შემხვდესო, და, რომ ვერსად ვერა ჰპოვა, გაიზრახა გულში — შეიკეროს პტყელის ბუზმენტებით ჩოხა, ბუზმენტებითვე მორთული განიერი მაუდის შალვარი, ერთი ოციოდ თუმანს თავი მოუყაროს და ჩავიდეს ქალაქში იმ ფიქრით, რომ ერთი-ორიოდჯერ ქუჩა-ქუჩა გავაჭენებ დროშკასაო, იქნება ერთი მდიდარი, კაი გვარის და ოჯახის შვილი ქალი ბადეს მოხვდესო, თუ არა და სომხის ქალები ხომ იქ არიან, ათასს თუმანს წამოვიღებო. ბოლოს შეიტყო, რომ შორს წასვლა საჭირო არ არის; თავად გძელაძეს, დიაღ პატიოსანის გვარის და კაი ოჯახის შვილს, ერთი მზეთუნახავი ქალი უზის გასათხოვარი და ზედ ზურგზედ ორასი თუმანი თეთრი ნაღდად აკერია. აუფორთხალდა ლუარსაბს გული, გაუჯდა გვერდებში და დღე-მუდამ საამურად უღიტინებდა, მაგრამ არ იცოდა — როგორ მოეხდინა საქმე. უშველა ღმერთმა და ერთს დღეს მაჭანკალიც გაუტყვრა.
მაჭანკალი, გძელაძისაგან მოგზავნილი, გახლდათ ერთი მოხუცებული, დარბაისელი, ღარიბი და ქვრივი დედაკაცი, რომელიც მას აქეთ, რაც ქმარი მოჰკდომოდა, ამ პატიოსანის ხელობით თავს ირჩენდა. ამას „სუტ-კნეინას“ ეძახოდნენ, იმიტომ რომ ამისი უბედური ქმარი მთელ სიცოცხლეში კნიაზობას ეძებდა და ვერ დაიმტკიცა. ჩვენც ეგრე დავუძახოთ.
დიდი ენამეტყველობის სახელი ჰქონდა გავარდნილი თავადიშვილებში ამ სუტ-კნეინასა. ამისთანა გამოცდილი შუამავალი თურმე ორიც არ დადიოდა დედამიწის ზურგზედა. ამიტომაც ბლომად იღებდა ფეხის-ქირასა, მაგრამ ეს იყო კარგი, რომ რაკი იკისრებდა საქმეს, ბოლოსაც მოუღებდა. აი, გძელაძესაც ეს ამოერჩივა, ხუთი თუმანი ბე მიეცა და თხუთმეტსაც დაჰპირებოდა, როცა საქმეს გაარიგებს. თუმცა გძელაძემ გამოგზავნა ლუარსაბთან, მაგრამ გამოცდილმა სუტ-კნეინამ ისე აჩვენა თავი, რომ მითამ ჩემ თავად მოვედიო, რომ ლუარსაბსაც დაავალოს და დასცინცლოს რამე.
ეს მოჰხდა ერთის აზნაურიშვილის სახლში, რომელმაც ჯვარი დაიწერა და ქორწილში სხვათა შორის ლუარსაბიც დაჰპატიჟა. ის სუტ-კნეინა ამ აზნაურიშვილის მამიდა იყო. ქორწილის მეორე დღეს, სადილის შემდეგ, ჩვენი ლუარსაბი შექეიფიანებული წავიდა და ფანჩატურში დაწვა. მზე დაწურვაზედ იყო, როცა ვიღაცამ ხელი ჰკრა და გააღვიძა. ლუარსაბმა გააჭყიტა თვალები და დაინახა ერთი პატიოსანი ხნიერი დედაკაცი. წამოხტა მაშინვე ფეხზედ.
— დაბძანდით, შენი ჭირიმე, მოისვენეთ, — უთხრა სუტ-კნეინამა, — უკაცრავოდა ვარ, მოსვენება დაგიფრთხეთ, მაგრამ დედითქვენის მეგობრობა და ხათრიჯამი რომ მაგონდება, ის პატივი და სიყვარული, თქვენზედაც გული შემტკივა... აი ამოდენა (დაბლა ხელით აჩვენა) ხელში მჭერიხართ, მითამაშებიხართ. დედა-თქვენი და მე დიდი მეგობრები ვიყავით, უერთი-ერთმანეთოდ ვერ გაგვეძლო, დიდი სიყვარული გვქონდა ერთმანეთისა: დები რად იქნებიან ისე, როგორც ჩვენ ვიყავით. დედა-თქვენი ხომ არ გახსოვთ?
— არა, მე მაშინ ორის წლისა ძლივა ვყოფილვარ, — მიუგო ლუარსაბმა, რომელმაც არ იცოდა ჯერ, რა ამბავია და ან რა უნდა ამ კნეინასა.
— რასაკვირველია, არ გეხსომებათ. ის უბედური ღმერთს რომ თავის უმანკო სულს აბარებდა, — იმის დამკარგავი მე ცოცხალი რაღადა ვარ, ეჰ, მადლობა ღმერთს, იმის ნებას ვინ წაუვა, — რომ უმანკო სულს აბარებდა, მე მაშინ ფეხთით ვეჯექი. ყველანი დაითხოვა ჩემ-გარდა. მამა თქვენი, მგონია, მაშინ მიცვალებული იყო.
— არა, ჯერ მასუკან თუნდ ექვსი წელიწადი იცოცხლა, — მიუგო ისევ ლუარსაბმა.
— მართლა, მართლა, რამ დამავიწყა? — სთქვა სუტ-კნეინამა, მითამ-და მართლა დაავიწყდა, — აი, სიბერე რა არის, ხსოვნამ მიღალატა, დიაღ, ცოცხალი ბძანდებოდა. დახე ჩემს გონებას! თავის პირით არ მიბძანა: „დაო, ხორეშან! ვიცი, რა სიყვარული გაქვთ შენ და ჩემ ცოლსა, წადი, ფეხთით დაუჯექ, იამება, შენ რომ გნახავს ისე ჩემი ნახვაც არ იამება“. მამა-თქვენი დარბაისელი კაცი იყო, დიდი პატიოსანი, სახელოვანი და ყველასაგან პატივცემული. დიდი შიში-კრძალვა ჰქონდათ იმისი, განა მარტო საქრისტიანოში, სალეკოშიაც; დაღისტნამდინ იმისი სახელი გავარდნილი იყო, რუსებისაგანაც დიდი პატივი ჰქონდა. აბა თქვენ რა გეხსომებათ, პატარა იყავით. ჰო, რას მოგახსენებდით?.. — ჰკითხა ლუარსაბსა.
— რომ მამი-ჩემის სახელი დაღისტნამდინ გავარდნილი იყო, რომ რუსებისაგანაც დიდი პატივი ჰქონია, — უპასუხა ლუარსაბმა.
— არა, ეგ ხომ ვიცი. რაზედ დავიწყე, ის დამავიწყდა, ვეღარ მომიგონებია. აი, ბატონო, სიბერე ეს გახლავთ: წუთის წინად რას ვლაპარაკობდი, არ მახსოვს, მამა-თქვენის სიკვდილი — ოცის წლის ამბავი — რომ არ მახსოვდეს, რა საკვირველია.
— თორმეტის წლის ამბავი გახლავთ, — გაუსწორა ლუარსაბმა
— თუნდ თორმეტისა, მაინც საკვირველი არ არის. რაზედ დავიწყე ლაპარაკი?.. — ჩაფიქრდა სუტ-კნეინა, მითამ-და არ იცოდა, რაზედ დაიწყო. იცოდა, ძალიან კარგად იცოდა, მაგრამ ჰფიქრობდა, ისე როგორ მოახერხოს, რომ ლუარსაბმა ტყუილში ვეღარ დაიჭიროს, როგორც მამის სიკვდილში დაიჭირა. ლუარსაბი გაშტერებული იდგა და სულ არ ესმოდა, რა განზრახვით მოსულა ამასთან კნეინა და რა განზრახვით ჰლაპარაკობს.
— ჰო, მართლა! — წამოიძახა სუტ-კნეინამა, ფიქრის შემდეგ, — იმას მოგახსენებდით: ცხონებული დედა-თქვენი რომ უმანკო სულს უფალს აბარებდა, ყველანი დაითხოვა, ჩემ-გარდა, და, როცა მარტოკანი დავრჩით, მიბძანა თავის სირინოზის ხმითა: „მე, ჩემო გულითადო მეგობარო ხორეშან, დიდის ხნის სიცოცხლე აღარა მაქვს. ვიცი, რომ ჩემი სიყვარული დიდი გაქვს. აი, ეს შენ და ეს ჩემი ობლები, შენ იყავ ამათი დედა“. ეს რომ ბძანა, — ვუი უბედურების მნახველს! — გული ამოუჯდა. მეც ღაპა-ღუპით წამომივიდა ცრემლები, ბევრი ვიტირეთ. მერე ხომ განუტევა კიდეც ის ანგელოზის სული. მე, როგორც თავზარდაცემული, ისე გიჟსავით დავრბოდი, თურმე ეგონათ — ვერ ავიტან მწუხარებას და ჭკვიდამ შევცდები. დიდი სიყვარული გვქონდა, ესე ვიყავით, თითქო ერთი ხორცი გვაქვსო და ერთი სული. დედა-თქვენიც ასეთი დედაკაცი ბძანდებოდა, — დაუმკვიდროს ღმერთმა სასუფეველი, — ასეთი დედაკაცი ბძანდებოდა, რომ ყველას ხატსავით უნდა ელოცნა. ასეთი რამ იყო! სადღა არიან ეხლა იმისთანები! ჩვენც ვიტყვით, დედაკაცები ვართო... მესამეს დღეს ქრისტიანულის წესით მივაბარეთ მიწასა იმისი ნათელი გვამი. დიდი სამღვდელო იყო მოპატიჟებული. მოგახსენებენ, მამა-თქვენს გვამის გასაპატიოსნებლად არქიელიც უნდა მოეწვივა, მაგრამ დროშკის ცხენები ვერ ეშოვნათ, რომ გაეგზავნათ. თქვენ ერთი ბეწო ობლები დარჩით, თქვენ და დავით პატარები იყავით, თქვენ მაშინვე შემიყვარდით, თქვენკენ მაშინვე გული უფრო მამიწევდა. არ ვიცი რად, — დათიკოც ხომ იმისი ნაშობი იყო, მაგრამ თქვენ ჩემთვის სხვა იყავით. მე თქვენ ხომ არ გეხსომებით?
— არა, არ მახსოვხართ.
— აბა, რასაკვირველია, არ გეხსომები, შენ სამის წლისა იქნებოდი, როცა მე ქმარი მომიკვდა, — ვაი იმის დამკარგავს! — მას აქეთ შინიდამა ფეხი არ გამომიდგამს, — ვარ ესე უნუგეშო, უპატრონო, ქვრივ-ოხერი. სიხარული ჩემთვის სიხარული აღარ არის, ქვეყანა ჩემთვის სულ შავებშია ჩაცმული. მაპატივეთ კადნიერება, იქნება თავი მოგაწყინეთ. რა ვქნა? ბედისაგან დამწვარ-დადაგული ვარ, დარდები მეშლება ხოლმე. რაღა გავაგრძელო, მოკლე სიტყვა სჯობია. თქვენ სამის წლისა იქნებოდით, რომ ქმარი დავკარგე. მოგშორდით და მას აქეთ აღარ მინახვიხართ, მაგრამ გულით ისევ თქვენთან ვიყავი; ვისაც კი თქვენებურს შევხვდებოდი, თქვენს ამბავს ვკითხავდი, ერთ ღამეს — აი, ეს სამი თვეც არ იქნება — დამეძინა. ვნახოთ, ღრმა ძილში რომ ვარ — ერთი მშვენიერი ანგელოზი, შუქმოფენილი, განწმენდილი და გასპეტაკებული თვალ-წინ გამომეცხადა. სიზმარს მოგახსენებთ, მაგრამ ასეთი სიზმარი იყო, რომ აქამდინ ცხადი მგონია. — „ხორეშან!— მიბძანა სულმა ცხოველმა, — მე შენის გულითადის მეგობრის სული ვარ, განწმენდილი და გასპეტაკებული“. მაშინვე მუხლებზედ მოვეხვიე დედი-თქვენის სულსა, დედა-თქვენი ბძანდებოდა. — „მუხლებზედ ნუ მეხვევი, — მიბძანა ხელახლად, — მე შენგან გული მტკივა: რად დაანებე თავი ჩემს დავითს და ლუარსაბსა? დავითი კიდევ არაფერი, იმან ცოლი იშოვა და დაბინავდა, ლუარსაბს რატომ არ ჰპატრონობ?“ სამი ღამე ერთი-ერთმანეთზედ მომევლინებოდა და სულ იმას მეტყოდა ხოლმე. ეგრე გახლდათ, თქვენი დაუტირებელი არ მოვკვდე! თუნდ ეგ არ ყოფილიყო, მე — როგორც მოგახსენეთ — უფლისა წინაშე აღთქმა მივეც, რომ დედობა გაგიწივო, და, აი, დღეს მოვიდა ის დღე. თქვენ ყმაწვილი კაცი ბძანდებით. მე, რა წამსაც დაგინახეთ, მაშინვე მივხვდი, რასაც გაუგიჟებია ის საწყალი ქალი. ღმერთმა შეარცხვინოს შენს მხარ-ბეჭთან ყარამანის მხარ-ბეჭი და სიტურფე ტარიელისა, გონიერება გარდანქეშანისა. თვალი მოგკარით თუ არა, მაშინვე მივხვდი, რასაც აუნთია ცეცხლი იმ უბედურის ქალის გულშია. უბედურს ვამბობ იმიტომ, რომ იქნება თქვენ იმაზედ არც კი ჰფიქრობთ, ის კი იქა ჰდნება.
ლუარსაბს იამა, ისე უნებლიეთ ქუდი უფრო ჩაიტეხა, კისერი მოიღერა, წვრილ, ახალ აშლილ ულვაშებს ხელი გადუსო, წელში გასწორდა და მხარ-ბეჭი მოიმარჯვა. ისე იამა, რომ პირველ ხანში ვერ მოახერხა სიტყვის თქმაცა. ჯერ არ იცოდა, რასაკვირველია, ის ქალი ვინ იყო, მაგრამ მაინც იამა.
— არც ქალია ურიგო, — დაიწყო ისევ სუტ-კნეინამა, — როგორი ყარამანიც შენ ხარ, იმისთანა სალბიხურამან ის არის. სწორედ ტარიელ და ნესტანდარეჯანი იქნებით, ორივე ერთად რომ შეგყაროთ. არც გვარი და შთამომავლობა აქვს ცუდი. მუხრან-ბატონთან ერთ ფურცელზედ არის იმათი გვარიც ჩაწერილი. კაი ქალი, კაი გვარიშვილი, კაი ოჯახი, სახელგანთქმული ნათესაობა — ბიძა ერთი მაიორი ჰყავს, მეორე დიანბეგია თათრებში, ფულიც აქვს ნაღდად, მეტი რა გინდა? მერე დედი-შენის სურვილიც არის. ის ანგელოზი წუხელიც მომევლინა და მითხრა: „ეგ უთუოდ მოახდინეო!“
— ფული რაერთი აქვს? — ჰკითხა ლუარსაბმა.
— ორასი თუმანი ექნება?
— ნაღდად?
— სულ ბაჯაღლო ოქრო; შინა აქვს, პარკში შეკრული.
— გძელაძიანთ ქალი ხომ არ არის?
— თქვენ ვინ გითხრათ?
— მე ვიცი.
— მაინც?
— ვიცი, ის არის. განა მე კი გულში არა მქონდა იმ ქალის სახე, — მორცხობით ჩაიღიმილა ამ სიტყვაზედ ლუარსაბმა.
— საიდამ? გინახავს თუ?
— თვალითაც არ მინახავს, მაგრამ ისე ვიცი.
— მაშ ნებას დამრთავთ თქვენ მაგიერ ვილაპარაკო? რა-რიგად გაუხარდება ქალსა!
— თორემ მამას კი არა, — სთქვა სუტ-კნეინის ქებით გაზვიადებულმა ლუარსაბმა.
— არ გაუხარდება, თქვენმა მზემ! — გაუძნელა ძალად საქმე სუტ-კნეინამ.
— მაშ იმისგან არა ხართ მოგზავნილი?
— რას ბძანებთ? იმისაგან რომ ვიყო, საქმე გათავდებოდა, რაკი თქვენი ნებაც არის. ის არის, რომ თითონ მამა დიდს უარზედ სდგას.
— უარზე სდგასო!.. — წამოიძახა გულნატკენმა ლუარსაბმა, — რაში მიწუნებს მითამ? გვარი იმაზედ ცუდი არა მაქვს და ოჯახი მითამ რაო?
— ეხლა, ხომ მოგეხსენებათ, რიხიანი კაცია.
— მაშ არა იქს, რაღა?
— როგორ არა იქს, მაგრამ დიდი ცდა და ხერხიანობა კი უნდა.
— აშ შეიძლება დავიყოლიოთ?
— ვინ იცის? ეგ ხერხზედ ჰკიდია, მაგრამ მაინც კიდევ ღმერთმა იცის, ჯიუტი კაცია.
— ერხი კიდევ თქვენი საქმეა.
— მართალია, მაგრამ მარტო ჩემი ხერხი რასა იქს?
— სხვა რა უნდა? რაც შემეძლება, ჩემ კისერზედ იყოს. მადლის გადახდა ჩვენც ვიცით.
— უი, შენ გეთაყვანე, შენა! მაგას ვინ მოგახსენებს? გულუხვობაში თქვენი გვარი დიდი ხანია განთქმულია, განა არ ვიცი, თუნდ ეგ არ იყოს, დედიშენის შვილს მე უნდა გამოგართო რამე, მაშინ შემერგება ლუკმა? არა, გეთაყვა, მე მაგას არ ვიქ, — ეგ შენ იცი. მაგრამ... მაგარი ეს არის, რომ „ქრთამი ჯოჯოხეთს ანათებსო“, ერთი ოციოდ თუმანი მოგინდება, რომ იმისი მახლობლები შემოვისყიდოთ. ერთი კაცია იქ, იმისი სიტყვა გძელაძიანთ მოსესათვის ბეჭედია, ფირმანია სწორედ. იმას უნდა ხახა დავულბოთ.
— ეხლა სად ვიშოვო მე ოცი თუმანი? — უთხრა ცხვირ-პირ-ჩამოშვებულმა და დაღონებულმა ლუარსაბმა.
— მაგაზედ ნუ შესწუხდები: შენ თამასუქი მამეც და ფულს მე გიშოვი.
— ბატონი ხარ. აი, თუნდ ეხლავ, — წაატანა სიტყვა გახარებულმა ლუარსაბმა.
სუტ-კნეინამ, რომ ჰნახა ესე ადვილად ლუარსაბის დაყოლება, იფიქრა: სულელი ყოფილა, რატომ ბლომად არ ვუთხარიო და, რომ გაასწოროს შეცდომა, ეს მოიგონა:
— ეს კი უნდა იცოდე, ჩემო შვილო, რომ დიდს სარგებელს გამოგართმევენ.
— დიდსა? მაინც რამდენს?
— თუმანზედ შვიდ შაურს.
— რა ვუყოთ, მივცემ. „როგორც გიჭირდეს, ისე გიღირდესო“, — ნათქვამია...
— მაშ ყური დამიგდე: შენ ჯერ უარზედ დადეგ, ვინც რა უნდა გითხრას, ფეხი მაგრა დააჭირე, იქნება იმ ქოფაკს, როცა დაყაბულდება, ჭახრაკი მოვუჭიროთ, მეტი დავსტყუოთ, გესმის? მე სულ შენთვის ვამბობ, თორემ მე რა მერგება. ხომ გესმის?
— ესმის, როგორ არ მესმის! ფეხი უნდა დავაჭირო.
— მაშ ეხლა მე ვიცი, ხვალ დილაზედ თამასუქს მოვამზადებინებ, შენც ხელი მოაწერე და მერე მე ვიცი.
— თამასუქი წინ მოგცე?
— მაშ, ქა!.. ფულს ისე ვინ განდობს? მე რომ მქონდეს, არ დაგიჭერ, ხომ იცი. დედი-შენის შვილს როგორ დავუჭერ, მაგრამ მე, ქვრივ-ოხერს, ვინ მომაბადა, სომეხს უნდა გამოვართო. აბა სომეხი, ხომ იცი, რა ურიაა.
— ვიცი, ვიცი.
— მერე, როცა გავარიგებ, მეც ერთი ქვრივ-ოხერი ვარ... ერთი-ორჯერ პურს მაინც მაჭმევ, — შეაბრალა თავი სუტ-კნეინამა, — შენი გვარი დარდიმანდობაში და პურ-მარილობაში განთქმულია.
ლუარსაბს იამებოდა ხოლმე, როცა ეგრე იხსენიებდნენ იმის გვარს, ოღონდ ეს გეთქვა და ჩოხას გაიხდიდა და შენ ჩაგაცმევდა.
— ერთი ეს მითხარ, ქალი როგორია? ყველა-ყველა და ეს კი დაგვავიწყდა, — მოიგონა ბოლოს ლუარსაბმა.
— წიგნში და ხელსაქმეში კარგად გაწურთვნილია, მეტი რა გინდა, — უპასუხა იმანაც.
— წიგნი რად მინდა? რა, ბრძნად ხომ არ დავსომ!.. შენ ერთი ეს მითხარ, მადლიანი სახე აქვს? ფერზედ როგორ არის?
— მაგას ნუღარ მკითხავ, კალმით ნახატია.
— მაშ რაღა, ფეხი დავაჭირო? — ჰკითხა ლუარსაბმა, რომელსაც სუტ-კნეინის უკანასკნელ სიტყვებზედ სიხარულმა და წადილმა ტანში მეტად საამურად გაურბინა.
— დიაღ, ფეხი დააჭირე. ამას შენთვის ვამბობ, რადგანაც ჩემს დაზედ უკეთესის შვილი ხარ, თორემ — თითონ შენ იცი — მე გამორჩენა არა მაქვს-რა. ჩემის სულის საცხონებლად მინდა მოვახდინო ეს საქმე, თორემ მოსე გძელაძე მე არას მამცემს. ნეტავი დავიყოლიო და დედი-შენის შვილის ბედნიერება მოვახდინო და გამორჩენას ვინ იკითხავს!
— ჩემ კისერზედ იყოს ეგა. ლამაზია? — ჰკითხა ღიმილით კიდევ ლუარსაბმა.
— გითხარ — კალმით ნახატია-მეთქი.
— ორასი თუმანიცა აქვს?
— იქნება მეტიც. — ეგ მე და შენზედ ჰკიდია.
— იქნება მეტიცო!.. ჰა, თქვენ რას იტყვით, ცუდი არ იქნება, — ისე სთქვა ლუარსაბმა, თითქო რჩევას ეხლა აპირებსო.
— შენ როგორღაც გულში ჯერ არ გადაგიწყვეტნია, როგორც ვხედავ, — დაატანა ცბიერმა სუტ-კნეინამ, რომ გამოათქმევინოს, გულში კარგად გაუჯდა თუ არა; თუ გაუჯდა, კიდევ დასტყუოს რამე.
— ეჰ, რას ბძანებ?
— როგორ რას ვბძანებ? თუ გულში არა გაქვს, ნუ შემარცხვენ, ეხლავ თავი დამანებებინე.
— თავი როგორ დაგანებებინო, რომ იმ ქალის სიყვარული გულში ნაღვერდალსავით ჩამიგდე. აბა, როგორ დავანებო თავი? მითამ რაში დავიწუნებ?
— მაშ გავათავეთ?
— გავათავეთ.
— უი, შენ გენაცვალოს ჩემი თავი! ძლივს დედი-შენის მოვალეობას და უფლისა წინაშე აღთქმას არ შევასრულებ, თუ მოსე გძელაძე ძალიან არ გაგვიჯიუტდა!
— ის კაცი რომ სთქვი, მოიყიდე, მეც აქ ფეხს დავაჭერ.
— ნეტავი იმის მეტი ქრთამი არ დაგვეხარჯოს! იქნება სხვასაც მოუნდეს.
— შუაზედ გაუყავ ოცი თუმანი.
— უი ჩემ თვალებს! ქა, როგორ იქნება? უბრალო კაცის შვილები ხომ არ არიან, ათ-ათ თუმანში ხელი გაისვარონ, თავადიშვილები არიან, სახელგანთქმულები, იმათი მოსყიდვა ადვილი არ არის. აი, როგორ გეტყობა, რომ ჯერ ყმაწვილი ხარ.
— ოცის წლისა ჯერ სრული არა ვარ, — იტყუა ლუარსაბმა, სრული იყო.
— ისიც ჩვიდმეტის წლისა იქნება. სწორედ გვრიტები იქნებით. უი, ნეტავი კი იმ ბედნიერ დღეს შევესწრა, რომ თქვენ ერთად მხარი-მხარ მსხდომნი გნახოთ და! ბევრი არ შემოგნატრებენ!
— მაშ ერთი აუჩქარე, თუ მართლა ეგრეა, თუ ღმერთი გწამს, — შეეხვეწა მოუთმენელი ლუარსაბი.
— ნეტავი ჩემს აჩქარებაზედ იყოს დამოკიდებული და მალე მტერი მოგიკვდეს, მალე მე მაგას ბოლო მოვუღო, მაგრამ ის წყეული მამაა საქმე. ღმერთი მოწყალეა, ნუ გეშინიან.
ეგრე გათავდა პირველი მოციქულობა სახელოვანის მოციქულისა. ლუარსაბს ამ დღის აქეთ, ცხადივ თუ სიზმრად, სულ ის კალმით ნახატი ქალი აგონდებოდა და ორას-თუმნიანი პარკი. საღერღელი მეტად აეშალა, სურვილმა მეტად აადუღა, ასე რომ, როცა მოიგონებდა, ერთს ლაზათიანად გაიზმორებდა და ამას იტყოდა მსუნაგსავით ტუჩის ლოკვითა: „კალმით ნახატი ქალი, ორასი თუმანი ბაჯაღლო ოქრო და იქნება მეტიცო... ჰა! რას იტყვი ლუარსაბ, ურიგო არ იქნება, განა? ამაზედ არის ნათქვამი: „ბედი მომეცი და სანახვეზედ გადამაგდეო!“
VII
 თუმცა სუტ-კნეინამ თავის ანგარიშების გამო საქმე ცოტად გააგრძელა, მაგრამ მალე უნდა გათავებულიყო, რადგანაც ორივეს მხრივ ნების დართვა იყო. სუტ-კნეინის ანგარიშების გარდა, ერთი სხვა ხიფათიც მოსდევდა ამ საქმეს: ქალი — პირველი, რომ ოცის წლისა იყო და ამბობდნენ ოც-და-ერთისაცააო — ეგ არაფერი, ამაში შეიძლებოდა კიდევ ხერხიანად მოეტყუებინათ, ცხენი ხომ არ იყო — კბილებზედ შეეტყოთ, მაგრამ ჭირი ის იყო, რომ მეტად მახინჯი გახლდათ. აბა, აქ როგორ მოატყუებ? თვალებს ხომ არ აუბამ? მართალია, შეიძლებოდა, პირველში სხვა ეჩვენებინათ, მერე, რაკი ჯვარის დასაწერად მოვიდოდა, ძალად გადასწერდნენ ჯვარსა, მაგრამ სუტ-კნეინას ეშინოდა: მერე ხომ თმით მათრევენო. თმით თრევა კიდევ არაფერი, რომ კარგად გამორჩენა შეიძლებოდეს, ოცი თუმანი აბა რა ფულია! მართალია, ლუარსაბსაც ჩამოართო ბარათი, მაგრამ, რაკი ამისთანა მახეში გააბამდა საწყალსა, მერე როგორღა მივიდოდა ფულის გამოსართმევად? ხომ უზიარებლად დაარჩობდა. ეჩივლა და ბარათი დიანბეგთან წარედგინა, რა გამოვიდოდა? ლუარსაბი გააბათილებინებდა, თუ არა და ნახევარს დიანბეგი წაიღებდა. მაგ ნახევარს ჯანი გავარდეს, ოღონდ საქმე არ გამოაშკარავდეს, — მაშინ რა ეშველებოდა სუტ-კნეინასა? ხომ ციხეში დაიჭერდნენ. „არა,— იფიქრა კნეინამა, — ეს ბარათი კიდევ აქა მქონდეს: როცა დრო მოვა, შევუთვლი, თუ მომცა, ხომ რა კარგი, თუ არა და ჯანი იმასაც გავარდეს, — ერთის სიტყვით ეს ბარათი ან ჰო არის, ან არა. საჰო-არაოდ საქმე რად გავიხადო. სიფრთხილეს თავი არ ასტკივა: ისევ ისა სჯობია, მოსე გძელაძეს ათიოდ თუმანი ნაღდი — აი ეგ მიყვარს! — მოვამატებინო და გავბედო ლუარსაბის მოტყუება, თორემ იქ ჩივილი, ერთი დავიდარაბა ასტყდება, იქნება საქმეც გამოაშკარავდეს, ამას იქნება კიდევ სხვა საქმეებიც ზედ შემიკეცონ, — ერთი ხათაბალა რამ გამოვა... რადა? არა, ეგ ჩემი საქმე არ არის: მე მიყვარს „ჩისტად“ საქმის დაჭერა.
ეგრე მომართული იყო სუტ-კნეინა, როცა გძელაძიანთ სოფელში შევიდა ამისი ურემი, მითამ-და ერთ რაღაც ძველ საყდარში ღამის სათევად მოვიდა. მეორე დილას თითონ მოსე გძელაძე მოიჭრა და სუტ-კნეინა თავის სახლში შეიპატიჟა. დაიწყეს ლაპარაკი.
— აბა, ჩემო ღვიძლ დაზედ უფრო უკეთესო დაო! ქალია თუ ვაჟი? — ჰკითხა მოსე გძელაძემ.
— ვაი, რომ ქალია, — უპასუხა შეწუხებულსავით სუტ-კნეინამ.
— როგორ? არ ირთავს?
— არა.
— მაინც რას ამბობს?
— ქალი არ მოსწონს — ნუ გეწყინებათ კი — მახინჯი არისო.
— ვაი შენს მოსეს! განა უნახავს სადმე?
— არა, არსად არ უნახავს, მაგრამ შეუტყვია.
— თუ არ უნახავს, მაშ კიდევ შეიძლება საქმე დავატრიალოთ.
— აბა როგორ?
— თუ შენ შემეწევი, ჩემო დაო, და ჩემს პურ-მარილს არ დაივიწყებ, საქმეს დამში მოვიყვანთ.
— აბა, გეთაყვა, მე რაღა თხოვნა მინდა, ხომ იცი ჩემს თავს შენის სამსახურისათვის არ დავზოგავ.
— მაშ თუ ეგრეა, დამაცა.
ადგა მოსე, გავიდა გარეთ და პატარა ხანს შემდეგ შემოიყვანა ერთი მშვენიერი, მოხდენილი ახალგაზრდა გოგო. დააყენა სუტ-კნეინის წინ, ხან აქეთ შემოატრიალა, ხან იქით, მერე უბძანა, რომ გარეთ გავიდეს.
გამოცდილი სუტ-კნეინა მიხვდა, რასაც მოასწავებდა ეს ამბავი, მაგრამ თავი მოიკატუნა, მითამ და არაფერი იცის. მოსე გძელაძე მოვიდა და მოუჯდა ისევ გვერდით.
— როგორ მოგეწონა? — დაიწყო გძელაძემ.
— ერთი ტურფა რამ არის, — უმანკოებით მიუგო მანკიერმა სუტ-კნეინამ.
— უფრო კარგი იქნება, რომ ჩემის ქალის ტანისამოსით მოვრთოთ?
— რასაკვირველია: ერთი-ორად მოემატება სიკეკლუცე.
— ეხლა შენ რას იტყვი, რომ ნიშანის მომტანს ეს გოგო, ლამაზად მორთული, ჩემის ქალის მაგიერად ვაჩვენოთ? — ჰკითხა მოსემ და თვალი თვალში გაუყარა, რომ პასუხი იქ ამოეკითხა.
— მერე სასიძო ხომ მოვა ნიშნის მერეთ, იმას რაღას უზამ?
— იქამდინ ვინ დააცლის? მესამე დღესვე ჯვარისწერა დავუნიშნოთ. სადღა მოიცლის, რომ ქალის სანახავადაც მოვიდეს?
— მერე ხომ მაინც ჯვარის-საწერად მოვა?
— მერე მე ვიცი. შენ ოღონდ მანამდინ დამეხმარე, მერე ჩემს კისერზედ იყოს. ძალად ჯვარს გადავწერ.
— არა, გეთაყვა, მე მაგ საქმეში ხელი დამიბანია, მე მაგას არა ვიქ, ეხლავ გეუბნები.
— რატომ?
— აბა, იმას გაუგია, რომ მახინჯიაო...
— მაგის ფიქრი ნუ გაქვს, — გააწყვეტინა სიტყვა მოსემა, — ნიშანის მომტანი რომ ამ გოგოსა ჰნახავს, მივა და ეტყვის: რას მიჰქარავ, იმისთანა ქალი ჩემს თვალებს ჯერ არ უნახავსო. თუნდ ეგ არ იყოს, ერთი ხუთიოდე თუმანი და იმისი ჯანი. ასეთს ავალაპარაკებ, რომ...
— ძმას გამოგზავნის.
— უფრო კარგი. რასაც თავის თვალით ჰნახავს, თუნდ ქრთამი არ იყოს, ის არ უნდა უთხრას? თორემ ფულიც ხომ არა მშურს.
— არა, გეთაყვანე, მე მაგ ცოდვაში არ ჩავდგები. აი, შენი ბეედ მოცემული ხუთი თუმანი, მე კი ხელი დამიბანია.
ამოიღო ორი ოც-და-ხუთ მანეთიანი ასიგნაცია და მისცა მოსეს გამოქნილმა მოციქულმა.
— მაშ მღალატობ?.. — უთხრა გულის სატკენად მოსემა, — მაშ ჩემი ოჯახის დაღუპვა გინდა? მაშ ჩემი საწყალი ქალი არ გებრალება? ეჰ! მუხანათო წუთის-სოფელო!.. სულ ტყუილი ყოფილა: პურმარილიც, პატივისცემაც, სიყვარულიც, მეგობრობაც!.. ეჰ, შენი ნებაა!.. ეს კი იცოდე, რომ გულში შხამ-წასმული ისარი გამიყარე, სპილენძის ტყვია მომარტყი, ურჯულო ლეკსავით ქრისტიანი სული წამწყმინდე.
მოსეს ეგონა, რომ ამ სიტყვებით მოვულბობ გულსაო, ის კი არ იცოდა, სუტ-კნეინა რა კნეინა იყო! სუტ-კნეინა კი იქნებოდა, რომ სიტყვით მოტყუებულიყო!.. სუტ-კნეინას თუმცა გულში ეცინებოდა, მაგრამ სახე შეიჭმუხნა, მითამ სწუხს კიდეც და ვერა უშველია-რაო.
— შენ ნუ მამიკვდები, მოსე, — უთხრა მწუხარეს ხმით კნეინამ, — და იმ შენის სახის ჩემს უბედურს ქმარს პირშავად არ შევეყრები საიქიოს, რომ შენის ოჯახის სამსახურისათვის მე თავს არ დავიზოგავდი, მაგრამ სამსახურიც არის და სამსახურიც.
— რა ვუყოთ, რომ არის? — მიუგო ეხლა კი ცოტად იმედმოცემულმა მოსემ, რადგანაც შეატყო, რომ სუტ-კნეინა დაყოლებას აპირებს, — რა ვუყოთ რომ არის? განა ჩვენ კი არ ვიცით სამსახურის გადახდა? რა უმადური მე მიპოვე? ოცი თუმანი არ დაგპირდი? ოც-და-ხუთი იყოს, შე დალოცვილო!
— არა, გეთაყვა, ფულზედ ხომ არ არის საქმე: თმით მათრევენ სიბერის დროს, სულს წავიწყმენდ.
— ოც-და-შვიდი იყოს.
— არა, გეთაყვა, ფული რა სახსენებელია: საქმე დიდი გასაბედავია.
— ხომ მოხერხება შეიძლება? ოც-და-რვა იყოს.
— არა, შეძლებით კი შეიძლება, მაგრამ თავს ვინ გამოიმეტებს?
— ოც-და-ცხრა იყოს, — უმატებს ნელ-ნელად მოსე და ყოველ მომატებაზედ ჰხედავს, რომ სუტ-კნეინა რბილდება.
— ძალიან თავის გამომეტება კი უნდა, თორემ შეძლებით რა არ შეიძლება.
სუტ-კნეინამ, ხელოვანმა სუტ-კნეინამ, ძალიან ცბიერობითა სთქვა ეს უკანასკნელი სიტყვა, თითქო მოსე რომ ფულს უმატებს, იმას ყურსაც არ ათხოვებსო, და მარტო იმასა ჰფიქრობს: შეიძლება, თუ არაო. დიდი ხანია იცის სუტ-კნეინამა, რომ შეიძლება, მაგრამ კარგა მსუქანის ლუკმის ამოვლება უყვარდა, რაკი ქვაბში ხელს ჩაჰყოფდა ხოლმე. მოსეს რომ არ დაესწრო, თითონ სუტ-კნეინა ეტყოდა მაგას, ესე მოვიქცეთო. კალმით ნახატიაო — უთხრა და ამისთანა მახინჯს ხომ არ დაანახვებდა? სწორედ მაგისთვისაც მოვიდა, რომ მოსესთან არჩიოს, ისე კი, რომ ფულიც მეტი გამორჩეს. რაკი მოსემ დაასწრო, გამორჩენის საქმე ნახევრად გარიგდა. სუტ-კნეინას კიდეც გაუხარდა, — ეხლა მე უარზედ უნდა დავდგეო, სთქვა გულში, და თუ გამორჩენაა, აქ გამოვრჩებიო.
— ოც-და-ათი იყოს, — დაუმატა კიდევ სწორე გზაზედ დამდგარმა მოსემ. — მეტი კი აღარ შემიძლიან.
— რატომ? — დაიწყო ისევ თავისებურად კნეინამ, რაკი ოც-და-ათამდინ აიყვანა, — რატომ? შეძლებით კი შეიძლება, მაგრამ ნიშნობაში მეც უნდა ვიყო, რომ, თუ მოხერხდეს, კარგად მოხერხდეს. ეს არის ჭირი, რომ ამ კაბით ხომ ვერ მოვალ?
— კაბაც შენი ჭირის სანაცვლო იყოს, — დაასწრო გახარებულმა მოსემ, რაკი ჰნახა, რომ სრულიად დაიყოლია, — კაბა ჩემ კისერზედ იყოს.
— მაშ ყური მათხოვე, რას გეტყვი: მე იმას ნიშანის მოსატანად ძმას გამოვაგზავნინებ. შენ გოგო ლამაზად მორთე — ეცადე არავინ გაგცეს — სამ დღეს უკან კი უთუოდ ქორწილი უნდა მოახდინო. მოიგონე რამე, რომ ყმაწვილმა ქალის ნახვა არ მოასწროს. მერე ხომ შენ იცი, ჩემი საქმე მაშინ გათავებული იქნება.
— ნიშნობის ღამეს ფულს სრულად ჩაგაბარებ, ეხლა თუ გინდა, ეს ხუთი თუმანი ბე ისევ წაიღე.
— არა, ათი თუმანი მიბოძე, რა ვიცი, იქნება როგორ დამჭირდეს, აქ ხომ ვერ გამოვიქცევი.
— შვიდ-თუმან-ნახევარი იყოს ჯერ.
— ათი მიბოძე. ისევ შენის საქმისათვის მინდა, შენს საქმეს მოვახმარებ, თუ გამიჭირდა. ჩემთვის ხომ არა გთხოვ.
— რა? ეს ათი თუმანი იმ ოც-და-ათ თუმნის ანგარიშში არ გინდა წაიღო თუ?
სუტ-კნეინამ გაიცინა.
— მაშ, ქა?
— ჰო, ეგრე სთქვი, მე მეგონა, მართლა, ეს ცალკე გინდა, რომ ჩემს საქმეს მოახმარო.
— არა, გეთაყვანე, იმის ანგარიშში მიმაქვს. საკაბე კი მალე მიბოძე, რომ შეკერვა მოვასწრო.
— აი, ათს თუმანს მოგართმევ, იქიდამ შეიკერე და მერე გავსწორდებით.
სუტ-კნეინა დაჰყაბულდა, მაგრამ მოსტყუვდა კი.
რაღა გავაგრძელო, მოსემა და კნეინამ ესე დააწყეს საქმე და სწორედ ეგრეთაც ბოლო მოუღეს. კაი ბადე დაუგეს ლუარსაბსა და კარგადაც გააბეს.
ორი კვირა რომ გავიდა, აღტაცებულმა ლუარსაბმა, აქაო და საქმე გარიგდაო, კარგის ნიშანით თავისი უფროსი ძმა დავითი გამოისტუმრა. დიდის ყოფით მიიღეს დავითი. ხალხი მოსემ არ მოიწვივა, სრულიად არავინ, რომ ეშმაკობა არ შეუტყონ, ლუარსაბსაც მისწერა — ნურავის შეატყობინებო. აი, ის წიგნი ნამდვილი თავის ღირსებით და შეცდომებით:
„ჩემო აღმატებულო ბედნიერო გვაროვანო სიძეო:.
„თუმცა დიდათ ბედნიერი ვარ რომელიცა რომა შენგანა ვარ დღეს მოხუცებული ბედნიერი და გული ჩემი სიხარულით აღავსე ნეტარითა სიძოობითა თქვენითა და თვალი ჩემი აახილე რომელიცა რომა დაინახა ისევ გაზაფხული მუხთალისა სოფლისა ამისა ფრიად სიხარულში ვარ რომელიცა ეხლა ვარ ჩემო აღმატებულო გვაროვანო სიძეო რომელიცა გთხოვ გამოგზავნო ნიშანი რომა საქმემ არ დაიგვიანოს დიდი ხალხი არ გამოგზავნო რომელიცა რომა მე მოხუცებული კაცი ავადა ვარ სნეული და პატივი და მასლაათი და ქეიფი რომელიცა აწ მე აღარ ძალმიძს რომელიცა ფრიად შეაწუხებენ ქორწილში რომელიც თქვენ იქნებით ჩემს სახლში მასპინძელი დიაღ დიდი ხალხი მოვიწვიოთ თქვენცა დიდი და პატიოსანი ნათესაობა გყავს რომელიცა არც მე ვარ უნათესაო და ბლომად შევყაროთ ისე როგორათაც შეჰფერის დიდებულს გვაროვნობასა თქვენსა და ჩემსა ოჯახს სახლკარიანობასა ჩემსა.
“სხვებრ ბძანდებოდეთ ბედნიერებით იესო ძე ღვთის მიერ ვითხოვ თქვენს ბედნიერებას რომელიცა რომა მსურს ნახვა თქვენი თქვენი სიმამრი ბრწყინვალე თავადი მოსე ნოშრევანისძე გძელაძე:.”
რასაკვირველია, თავაზიანი ლუარსაბი ამ წიგნის შემდეგ აღარ გაგზავნიდა ბევრს ხალხსა. მარტო ერთი დავითი და ერთი კიდევ ვიღაცა გამოისტუმრა, რომ ახალი სიმამრი, რადგანაც ავად არის, არ შეაწუხონ, დავითს კი დააბარა, რომ ფულზედ კარგად მოილაპარაკოს, როდის ჩააბარებენ, და მერე ქალი კარგად გასინჯოს.
დიდის პატივით მიიღო მოსემ დავითი. ქალის მაგიერად ის მშვენიერი გოგო მორთეს და დავითს ისე აჩვენეს. დავითი გაგიჟდა — რომ დაინახა და გულში არ იყო რომ შურმაც არ გაუარა, ნამეტნავად თავისი მჭლე ცოლი რომ მოაგონდა ამასთან. ვახშამზედ რომ ისხდნენ, მარტო ოთხნი იყვნენ — დავითი და ამასთან მოყოლილი ის ვიღაცა, თითონ მოსე და ამისი მოზრდილი შვილი. კნეინაც თუმცა მოსესთან იყო, მაგრამ ქალთან ივახშმა. მოსემ ბოდიში მოიხადა, რომ ხალხი არ დაუპატიჟა ამისთანა ბრწყინვალე გვარიშვილებსა.
— რა ვქნა, შენი ჭირიმე, — უთხრა დავითს მოსემა, — ჩემო ახალო მოყვარევ! ავადა ვარ, თასლიბს ვერ გავუწევდი. სიძუნწეში არ ჩამომართო, შენი ჭირიმე! აბა, ჯერ ისე ავადმყოფი რა არის, მერე მასპინძელი რა უნდა იყოს. თორემ იმდენი სიკეთე ღმერთმა შენ მოგცეს, რამდენი ნათესაობა და მახლობლობა მე მყვანდეს. მაგრამ ჩემი მაყურებლები რა ქეიფს გასწევდნენ. ისევ ის ვამჯობინე — ნუ დავპატიჟებ-მეთქი. ამ ნიშნობამ ისე შინაურულად ჩაიაროს, ქორწილი კი ჩემ კისერზედ იყოს. ქორწილისა რა ბძანა ჩემმა სიძემა?
— რაც ჩქარა იქნება, ისა სჯობიაო, — უპასუხა დავითმა, პირფერობაში კი ნუ ჩამომართმევთ და ეს ქალი რომ ჰნახოს იმან, იმ წამშივე ჯვარს დაიწერს, თავი არ მომიკვდება!
— მზეთუნახავი ყოფილა, — დაუმატა სტუმარმაც.
— რა ვქნა? მადლობა ღმერთსა, ღმერთმა ეგ მომცა და ყველაფერი ღვთის ნებაზედ ჰკიდია, — თქვა მოსემა, — მიხარიან, თქვენმა მზემ, რომ ქალი მოგეწონათ.
— ღმერთმა აცოცხლოს პატარძალი! — წამოავლო ჯამს ხელი დავითმა, — ღმერთმა ტკბილად შეაბეროსთ ერთმანეთს!
— მადლობელი ვარ, თქვენი ჭირიმეთ! — დაუკრა ყველას თავი მოსემა. — მაშ რაც მალე იქნება, ისა სჯობია.
— იმან ისე მოგახსენათ, — უპასუხა დავითმა, — მეც, სწორედ მოგახსენოთ, მაგას ვურჩევ ჩემს ძმასა. რაღა გავაგრძელოთ საქმე.
— ჩემის ფიქრითაც ეგრე სჯობია, — სთქვა მოსემა, — ქალი აქა ჰდნება — მამისაგან კი არ უნდა ითქვას ესა, მაგრამ შორეული ხომ არა ხართ, თქვენთან რა დავმალო, — ქალი აქა ჰდნება...
— ის კიდევ იქ, თქვენმა სიცოცხლემ! — წაართო სიტყვა დავითმა.
— მაშ, როცა მიბძანებთ, მაშინ იყოს ქორწილი, — სთხოვა მოსემა.
ერთის სიტყვით, გადასწყვიტეს, რომ სამშაბათს საღამოზედ სიძე უნდა მოვიდეს და იმ ღამესვე ჯვარი უნდა დაიწეროს. მეორე დღეს დავითმა ფულზედ ჩამოუგდო ლაპარაკი. მოსემ დააჯერა, რომ ქორწილის მეორე დღეს ორასს თუმანს სულ ბაჯაღლო ოქროებს თავის ხელით მიართმევს. ხელი-ხელს დაჰკრეს, დავითი, — მეორე დღეს პატარძალი აღარ აჩვენეს, — შინ წამოვიდა და მოსე თავის სახლში დარჩა. როცა მოსემ ცხენზედ შესო და გამოისტუმრა დავითი, როცა მარტო დარჩა, ხელები დაიფშვნიტა მეტის სიხარულისაგან და სთქვა ღიმილით: ყოჩაღად წავიყვანე საქმე. ეხლა ჩემი წუხილი მარტო ის არის, რომ სუტ-კნეინას ხრიკი მოვუგდო, ერთი მიზეზი რამ მოვუგონო, რომ ფული აღარ მივცე იმაზე მეტი, რაც მიმიცია, თორემ, იმისაგან რომ მოვტყუვდე, სირცხვილია.
ამ ფიქრში იყო, რომ სუტ-კნეინა — მოსეს ცოლი არა ჰყვანდა და ჯალაბობას კნეინა ჰთამაშობდა — რომ სუტ-კნეინა წინ მოეგება გახარებული.
— ჰა, რა-რიგად მოვიდა საქმე! — უთხრა სუტ-კნეინამა, — მომილოცავს შვილის ბედნიერება. დიდი ჯაფა კი გავწიე. სულ ვიწურებოდი — შენზედ მიწა არ მენახოს — სულ ვიწურებოდი, რომ ან აი ეხლა შეიტყობენ-მეთქი, ან აი ეხლა — და დავიღუპები, მაგრამ მიშველა ღმერთმა და ვერ შეიტყეს.
— ეჰ, შე დალოცვილო — უპასუხა მოსემ, — იწურებოდი, ასე გგონია, პირველად ჩაგედინოს ამისთანა საქმე. იწურებოდა!.. თქვენი ხელობა მეტი რა არის? იწურებოდა!..
სუტ-კნეინა შეკრთა.
— არა, ჰხუმრობ, თუ მართლა მეუბნები? — ჰკითხა შემკრთალმა სუტ-კნეინამა.
— მაშ არა და გეხუმრები!
— ეხლა განა?
— ეხლაცა და მაშინაც.
— მერთმა მშვიდობა მოგცეს, თუ ეგრეა, მე კი გამისტუმრე და მერე შენ იცი.
— სადაც გინდა წაბძანდი, ხელს ვინ გიჭერს.
— რასაკვირველია. ხელს არავინ დამიჭერს, მაგრამ დაპირებული მიბოძე და ღმერთმა მშვიდობა მოგცეს, რაც გინდა ილაპარაკე ჩემზედ: გული არ მეტკინება.
— დაპირებულიო!.. რაც მოგეცი იმასაც ვნანობ და გგონია — კიდევ მოგცე რამა!
— ეხლა ეგ ნამუსია? მოხუცებული დედაკაცი ფოშტის ცხენსავით მათრიე, ქვეყანაში თავი შევირცხვინე, საქმე საქმეზედ მოვიყვანე და ეხლა მაგას მეუბნები?! ნამუსია?
— აჩუმდი, თორემ...
— არა, ნამუსია?.. შენა გკითხავ, ნამუსია?
— ის კი ნამუსია, რომ აგიღია ფეხი, სოფლიდან სოფლად დადიხარ და მაჭანკლობ, ნამუსია? შარშან რომ ათ თუმნად შენი დისწული, გასათხოვარი ქალი, დიანბეგს მიჰგვარე, ნამუსია? როცა დაორსულდა, შენ რომ წამალი მიეცი და მუცელი წაუხდინე, ნამუსია?..
სუტ-კნეინას გული ყელში მოებჯინა, თავისი სიფრთხილე, გამოცდილობა ამგვარებში და გულის სიგრილე დაჰკარგა.
— მაშ თუ აგრეა, — დაიყვირა გაკაპასებულმა სუტ-კნეინამ, — შენი ფეხი დამკარ თავში, შენი ფეხი, თუ ეგ საქმე არ დაგიხლართო!
— შენი ლეჩაქი დამხურე თავზედ, — ამ მუქარაზედ მშვიდობიანად უპასუხა მოსემ, — შენი ლეჩაქი, თუ ეხლავ გომურში არ დაგამწყვდიო, მინამ ქორწილი არ გათავდება. რას მიზამ! მიჩივლებ თუ? არა მგონია, შენი თავი სადიანბეგოდ გახადო: ცოდვა ბევრი გაწევს კისერზედ, სულ ერთი-ერთმანეთს ზედ მიეკეცება, და მაშინ ციმბირშიაც ალაგი არ გექნება, შე ტყუილო-კნეინავ, შენა! ეს ის დიანბეგი კი არ არის, რომელსაც გოგოს გაურიგებდი ხოლმე და ბურთსავით ხელში ათამაშებდი! ის დრო წავიდა.
ვერც ამ სიტყვებმა მოიყვანეს თავის გონზედ გამწარებული სუტ-კნეინა. ის ისევ-ისე სიმწარისაგან გონებამიხდილი იყო, თორემ გაჯავრების და მუქარის მაგიერ ისეთნაირად მოიკატუნებდა თავს, ისეთნაირად მოუკვდებოდა ხელში, რომ ყველაფერს გააქარწყლებდა. ეხლა კი ჯავრისაგან, როგორცა ვთქვი, გონება დაბნეული ჰქონდა, იმიტომაც მაინც კიდევ შეჰყვირა:
— დამამწყვდევ!.. უი, მეხი კი დაგეცა მაგ უხეირო თავზედ! დამამწყვდევ რა, შენი მოახლე გოგო ვარ, ან შენი გომბიო ქალი!..
— რაო? აი, თუ გოგოზედაც უარესი არა ხარ. მე ეხლავ გაჩვენებ, როგორც გაგისტუმრებ გომურში, — უთხრა ხუმრობაგაშვებით მოსემა, — შენ რომ ჩამოგარჩო კიდეც, ხმას არავინ გამცემს. მაგრამ სიფრთხილეს თავი არ ასტკივაო, მერე რომ არა დამაბრალო-რა, ეხლავ მიჩვენე ჯიბეში რა გაქვს.
მივარდა სუტ-კნეინას ჩვენი მართალი კნიაზი. სუტ-კნეინა ჯერ გაუძალიანდა, ბოლოს კი — ღვთის წყალობა გქონდეთ — იკადრა ერთის ლურჯის ხელსახოცის ამოღება, რომელშიაც რაღაცები ეხვია. სუტ-კნეინა გაფითრდა და პირი გაუშრა. ვეღარა უთხრა-რა. მოსემ გაშალა ხელსახოცი და თავისი ათი თუმანი იქ გამოკრული ისევ ხელუხლებლად ჰნახა, მაშინვე ჯიბეში იკრა. ერთი რაღაც ქაღალდიც მოჰხვდა ხელში. გაშალა, თამასუქი იყო, ის თამასუქი, რომელიც სუტ-კნეინამ ლუარსაბს დასტყუვა. მინამ ამ საქმეში იყო გართული, სუტ-კნეინას თავისი ხერხი, ეშმაკობა, გამოცდილება დაუბრუნდა. იფიქრა სუტ-კნეინამა: „ამ ყვირილს და მუქარას თავი უნდა დავანებო, თორემ დამწყვდევას გამიმართლებსო. თუნდ დამამწყვდივოს, არაფერი, ხუთი-ექვსი დღე სიზმარსავით გაირბენს: შინ მივწერ, რომ მზითევს ვუმზადებ-მეთქი და ქორწილამდინ ვეღარ გადმოვალ. ვინ რას შეიტყობს, ოღონდ ეგ ათი თუმანი მაინც დავიბრუნო! ეგ მაინც არ დამეკარგოს!..“ ამ ფიქრებმა თვალის დახამხამების უმალ გაურბინეს გონებაში სუტს, მაგრამ კი მოხერხებულს კნეინასა.
— ეს ვინ მოგცა შენ? — ჰკითხა მოსემ და აჩვენა თამასუქი. სუტ-კნეინას მზად ჰქონდა პასუხი.
— ეხლა, შენ არ დაიჯერებ, რასაკვირველია, რომ ეგ თამასუქი თუ ჩამოვართვი, ისევ შენის საქმისათვის ჩამოვართვი. თუ ვინიცობაა, რომ მოვატყუეთ, ქალი ის არ ვაჩვენეთ — ეს შეეტყო და უარზედ დამდგარიყო, ამ თამასუქს ვაჩვენებდით და ვეტყოდით: დაიწერე, თორემ დიანბეგს წარვუდგენთ და სულ ნაღდს დაგათვლევინებთ. აი, რისთვის გამოვართვი, შენ ხომ არ დაიჯერებ, გაჯავრებული ხარ, მაგრამ მე კი გული ძალიან შემტკივა შენთვისა.
— თუ ეგრეა, რატომ აქამდინ არ მაჩვენე?
— რომ ვაჩვენო-მეთქი, ვიფიქრე, ვაი თუ ამის იმედით საქმეზედ მუყაითობა იმისთანა აღარ გასწიოს-მეთქი. რა ვიცი? ხორციელები ვართ.
— ეხლა მაგითი გინდა მამატყუვო განა?
— აკი გითხარ: არ დაიჯერებ-მეთქი. კაცს რაკი ერთხელ და ერთხელ ესტიბარი წაუხდება, აღარ დაუჯერებენ. მეც ისე მომდის. შენა გგონია, გატყუებ? თუნდ ეგ ბარათი შენ მიირთვი, ორასს თუმანში გაუბარე და მე ეგ ათი თუმანიც მეყოფა, ჩემო კარგო!
— შენ მაგითი მე ვერ მომატყუებ. ეს ბარათიც მე დამრჩება, ეს ათი თუმანიცა, და შენ კი გომურის მაგიერად ხულაში დაგამწყვდევ, რომ ჯვარის-წერამდინ არ გამცე. მერე რაც გინდა ჰქენი — ბიჭო! — დაიყვირა მოსემ.
ბიჭი მოვიდა.
— ეს ტყუილი-კნეინა წააბძანე ხულაში, ხალიჩაც მიართვი, მუთაქაც, ქვეშსაგებიც. პური და ღვინო არ მოაკლოთ. ეს კი უნდა ჰქნა, რომ გარედამ კლიტით უნდა გადაკეტო და გასაღები აქ მომართო. თუ ეს აბმავი შეუტყვია ვისმე, ვაი თქვენი ბრალი!
ბიჭი არ გაინძრა, ჯერ ტყუილი ეგონა.
— არ გეყურება შე ...შვილო! — დაუჭყივლა მოსემა.
ეხლა კი იკადრა ბრძანების დაჯერება, მივიდა, წაავლო ხელი და გამოსწია საწყალ სუტ-კნეინასა, რომელიც ეხლა კი ისე მაიკუნტა, ისე მაიკუნტა, რომ მუშტის ოდენა გახდა, მაგრამ მაინც კი იმედი არ დაჰკარგა, რომ გააქარწყლებს ამ ამბავსა და მშვიდობით გადარჩება. კიდევ სიტყვა მოახერხა ეშმაკურად და უთხრა მოსესა ისე, ვითამ აქ არაფერი ამბავია:
— უი, შენ კი გენაცვალოს ჩემი თავი! ტყუილი გაჯავრება რა-რიგად გიხდება! ამ სულელ ბიჭმაც დაიჯერა, ასე ჰგონია — მართლა უბძანე. გლეხ-კაცია, ვერ მიხვდა, ნუ გაუწყრები, შენ გენაცვალოს ჩემი თავი!
ამისთანა ოსტატობამ კინაღამ მოსე არ გააცინა. ბიჭიც გაშტერებული შედგა. ბევრი კიდევ სხვა იოსტატა სუტ-კნეინამა, მაგრამ ვერაფერმა ვეღარ უშველა: ხულაში დაამწყვდიეს, შინ კი წიგნი მისწერა — ჯერ კი მოსემ გადიკითხა — რომ აქ მზითევს და საკერავებს ვუმზადებო და ოთხშაბათამდინ ნუ მომელოდებითო. ეს მისწერა, შევიდა ხულაში, დაჯდა ხალიჩაზედ და დაიწყო ტარის რთვა, რომელსაც, საცა წავიდოდა, თან წაიღებდა ხოლმე. ესე იყო, მითამდა აქ არაფერია.
VIII
 როცა დავითი შინ მივიდა, საღამო ხანი იყო. ამისი ცოლი, ელისაბედი და ლუარსაბი ეზოში ღობის ჩრდილში ისხდნენ. თვალი შეასწრო თუ არა, ლუარსაბი წამოხტა, მიეგება ძმას, ვერაფერი კი ვერა ჰკითხა, იმიტომ რომ რცხვენოდა. დავითი ცხენიდამ გადმოხტა, გაისწორა მოშვებული ჩაღსაკრავი, მოვიდა, ცოლს არც კი მიემშვიდობა და წამოწვა ხალიჩაზედ.
— როგორ მოგეწონა სასძლო? — ჰკითხა ცოლმა. ლუარსაბმა ყურები აიცქვიტა.
— მზეთუნახავს რომ იტყვიან, ის არის. — მიუგო დავითმა, — მე იმისთანა ლამაზი ქალი არ მინახავს.
ლუარსაბს გაუხარდა, ელისაბედს ეწყინა: ჩემზედ უკეთესი იქნებაო.
— მართლა, გეთაყვანე? — ჰკითხა ლუარსაბმა.
— შენ ნუ მომიკვდები, იმისთანა ქალის მნახველი არა ვარ. — ამის მერე ცოლს შეჰხედა და შურით დაუმატა: — მე რომ პატარა კიდევ მომეცადნა, სხვა რიგად წავიდოდა ჩემი საქმე.
— რა? შენ შეირთავდი თუ? — წააყვედრა გულღვარძლიანმა ცოლმა, — უი შენ თვალებს! შენთვის მეც არ ვემეტებოდი ჩემს ბედსა. მამა-ჩემი განა რომ უარზედ იდგა, შენისთანები მთხოულობდნენ!
— უარზედ იდგა, მე ვიცი, რუსთ ხელმწიფის შვილს მიგცემდა. იმისიც მადლობელი იყავ, რომ მე გავბრიყვდი.
ესე სიტყვა-სიტყვაზედ შეჰყვნენ და ერთი კაი ლაზათიანი ჩხუბი მოუვიდათ, ასე რომ მოგეწონებოდათ. ელისაბედს იმ დღითვე შურით აევსო გული და შეიძულა ჯერ თვალით არ-ნახული რძალი.
„მალე ჩემი მტერი დაჭკნეს, მალე მე ის დავაჭკნო, — ამბობდა გულში ელისაბედი, — ამ სახლში ჩემზედ უკეთესი და ჩემზედ უფროსი არავინ არ უნდა იყოს. ჩემი ქმარი უნდა მაყვედრიდეს იმის სილამაზეს?! უი, უწინამც დღე გაჰქრობია. ასეთ ეკალს გავუყრი თვალში, რომ დღენი ვაწყევლინო!“
ელისაბედი ქორწილში არ წავიდა.
ქორწილის ღამეს დიდი ამბები მოხდა. მოვიდა სიძე დიდის მაყრიონით, ძმაც თანა ჰყვანდა, სწორედ სამშაბათს დღეს. იმ დღეს საცოლო არ აჩვენეს, რასაკვირველია. მოსესაც შეეყარა დიდი ხალხი. უგანზრახვოდ არ იყო ეს ხალხის შეყრა მოსეს მხრით. ეხლა კი მართალი ქალი გაისტუმრეს საყდარში. როცა ყველაფერი მოამზადეს, მერე მიიპატიჟეს საქმროცა. როცა შევიდა ლუარსაბი საყდარში და თვალი მოჰკრა თავის საცოლოსა, ელდა ეცა. მოუბრუნდა თავის ძმას დავითს, თავაზასაც და ზრდილობასაც თავი დაანება და უთხრა:
— დავით, აკი მზეთუნახავიაო?
ხალხს სიცილი წასკდა, საწყალი პატარძალი სირცხვილით აინთო და ტირილი დაიწყო. დავითი წინ წადგა; რომ დაინახა ერთი უმსგავსო პატარძალი, მღვდელს მიუბრუნდა:
— მამაო! ჯერ სხვა იწერს ჯვარს, თუ ეს რა ამბავია?
— კნიაზი ლუარსაბ თათქარიძე და დარეჯან მოსე გძელაძის ასული იწერს ჯვარს, — მიუგო მდვდელმა.
— პატარძალი სად არის?
— აი, ესა ბძანდება.
— ლუარსაბ! — დაუძახა ძმას დავითმა, — მოგვატყუვეს, ეგ ის არ არის, ჯვარი არ დაიწერო.
მთელი ხალხი გაოცდა. ლუარსაბი დაღონებული და უფრო გაფითრებული გამოვიდა საყდრიდგან, მთელი მაყრიონი გამოჰყვა. ცხენები მოიკითხეს, უნდა წამოსულიყვნენ. ცხენები დაემალათ. შეატყობინეს მოსეს, რომ საქმრო ჯვარს არ იწერსო. მოვიდა მოსე და თან მოიყვანა მრავალი ხალხი.
— კნიაზო დავით! ეს რა ამბავია? — უთხრა გაჯავრებულსავით მოსემ, — ქალი საყდარშია და საქმრო ეხლა დადგა უარზედ? აქამდინ სად იყავით, თუ არ გინდოდათ ჩემი ქალი? ვინ გეხვეწებოდათ? თქვენისთანა ოჯახის-შვილები მეხვეწებოდნენ, რომ არ მივეცი!
— აი, ბატონო, ქალი მანდ არის და, ვისაც გნებავდეთ, იმას მიეცით. ჩემი ძმა კი მაგის შემრთველი არ არის, — მიუგო თავგამოდებით დავითმა.
— ეხლა განა? როცა მთელმა ქვეყანამ შეიტყო, რომ ჩემს ქალს ირთავს შენი ძმა, როცა შენმა ძმამ საყდარშიაც შეიყვანა ჩემი ქალი? არა, თავზედ ლაფს არავის არ დავასხმევინებ! ან უნდა ჯვარი დაიწეროს, ან არა და აქედამ ცოცხლები ვეღარ წახვალთ! გაგონილა? სიძე სახლში ჩამიდგეს, ქალი საყდარში შეიყვანოს და ჯვარი აღარ დაიწეროს!..
— ის კი გაგონილა, რომ პატარძალი შეცვალონ! ეს შენი ქალი არ არის.
— ხალხო და ჯამაათო! დახე, რომ ვეღარა მოუგონიათ რა, იმას ამბობენ, შენი ქალი არ არისო, — დაუძახა ხალხს მოსემ.
— მაშ ვისია, თუ მაგისი არ არის! — გაიხმაურა მოსეს ხალხმა, ჩვენ ფიცს მოგცემთ.
— არა, ბატონებო, ჩემი ძმა ჯვარს არ იწერს. თუ ძალაზედ დადგებით, არც ჩვენა ვართ ლაჩრები, — წამოსთქვა დავითმა და ხანჯალი მოიმართა.
ქალები, ვინც კი იყვნენ საყდარში, სულ აქეთ-იქით მიიფანტნენ, ჰნახეს რომ ამათი ალაგი არ არის. პატარძალი კი და ორი ვიღაც ბებერი მოსემ საყდრიდამ არ გამოაყვანინა, იმედი ჰქონდა, რომ როგორმე მოახდენდა ჯვარისწერას.
— მაშ მოსე თავადიშვილი აღარ ყოფილა, — წამოიძახა მოსემ, — თუ თქვენ ჩემი ოჯახი შეგარცხვენინოთ; ჩემის ცოცხალის თავით არ ვაკადრებ ჩემს გვარს, რომ თათქარიძეებმა საყდარში ქალი გამიუპატიურონ, ჯვარი უნდა დაიწეროს.
— არ დაიწერს.
— უკანასკნელი სიტყვაა?
— უკანასკნელია.
— დავით! — უეცრად გადაასხვაფერა სიტყვა მოსემ და ხმაც მოურბილა, — აქეთ მობძანდი.
დავითი გაჰყვა. იქით ორნივ გაშორებით გადგნენ. მოსემ ამოიღო ხუთი თუმანი და უთხრა ხმადაბლა დავითს:
— ეს ხუთი თუმანი, დაჩუმდი, შენ რა გინდა? შენ ხომ არ ირთავ?
დავითი დარბილდა.
— ხუთ თუმანზე ძმა როგორ გავყიდო? — უპასუხა.
— შვიდი იყოს.
— ან შვიდად.
— რვა იყოს
— ვერც რვა თუმნად.
— აშ რამდენი გინდა?
— ათი მაინც იყოს.
— ცხრაზედ რას იტყვი?
— არა, ათი.
— ეჰ, ჯანი გავარდეს: ათი იყოს.
ამოიღო ათი თუმანი და მისცა. დავითმა ჯიბეში ჩაიდო.
— მე კი დავჩუმდები და ჩემი ძმისა შენ იცი, — უთხრა ღიმილით დავითმა.
— ოღონდ შენ დაჩუმდი და ერთი ორიოდე კაცი თქვენი მაყრიონიდამაც დაიყოლიე და ლუარსაბს მე მოვუხერხებ.
— ბატონი ხარ. მაგის პირობას გაძლევ.
— მაშ ხელი დაჰკარ.
დაჰკრეს ხელი ხელს და საწყალ ლუარსაბს ძალად გადასწერეს ჯვარი იმ ღამესა. მოსემ არც დაპირებული ორასი თუმანი მისცა, იმის მაგიერ ის თამასუქი დაუბრუნა, სუტ-კნეინას რომ წაართო. ლუარსაბს არ მიჰყვანდა ცოლი, მინამ არ გამისწორდებაო, ბოლოს ესეც რომ ვერა გახდა-რა — გარემოებას დაემორჩილა და წამოიყვანა შინ თავისი დარეჯანი.
ელისაბედი სიხარულით აღარ იყო, რომ ლუარსაბმა მზეთუნახავის მაგიერ გონჯი ცოლი მოიყვანა. „ჰი, ვენაცვალე ღმერთსა! — ეტყოდა ხოლმე ქმარს ელისაბედი, — ჰი, ვენაცვალე! — ჯერ ჩემზედ უკეთესი უნდა შეერთო და მერე ჩემთვის ნიშნი მოეგო! ჰი, ვენაცვალე ღმერთსა!“ ბოლოს ხომ — როგორც მოგეხსენებათ — ცოლების მოწყალებით ძმებს ჩხუბი მოუვიდათ და გაიყარნენ.
IX
ჩვენმა ლუარსაბმა ესე დაიწერა ჯვარი. თუმცა ძალადობით მოხდა ესა, თუმცა მზითევშიაც მოატყუეს და მზეთუნახავის მაგიერ მახინჯი დარეჯანი შერთეს, მაგრამ — შუბლზედ ეგ მეწერაო — იფიქრა და დაემორჩილა ბედისწერასა. ბოლოს ხომ, — შენც იცი, მკითხველო, — რომ ამათ ერთმანეთი შეუყვარდათ. ამათ კი ისე ეგონათ რომ უყვართ ერთმანეთი და სხვისა კი არ ვიცი. „ფერი ფერსაო, მადლი ღმერთსაო”. — ნათქვამია, ფერი ფერს შეხვდა და ერთმანეთი შეიფერეს. ეს შეფერება ჩვენში ცოტასა აქვს მიღებული სიყვარულად? კარგი რამ არის ქართველი კაცი: ბედსაც და უბედობასაც თანასწორად ემორჩილება ხოლმე. არც ერთისთვის გაიხეთქს თავს და არც მეორისთვის დაიწყებს ბრძოლასა, — და არის ისე ყველგან ერთნაირად გულგრილი და შეუპოვარი. ამ გულგრილობას და შეუპოვრობას კმაყოფილებად ადიდებენ; კმაყოფილება კიდევ — ვიღაცამა სთქვა — ბედნიერება არისო. ბევრჯერ უთქვამთ დარბაისელთ მოხუცებულთ ჩემთვის, რომ ახალ თაობას იმითი მაინც ვჯობივართო, რომ ჩვენ ცოტას კმაყოფილებიცა ვართო. მე კი დავჩუმებულვარ და გამიფიქრია: „კმაყოფილება კაცის მომაკვდინებელი სენია. ბედნიერია ახალი თაობა, თუ მართლა ის კმაყოფილება არა აქვს. იმედი თუა სადმე, ამაში უნდა იყოს: უმადლონი სჯერდებიან მას, რაც არის, იმიტომაც იმათში უფრო ბევრია ბედნიერი, მადლიანნი კი ძნელად: ამათ ყოველთვის უკეთესი უნდათ იმიტომ, რომ კარგს უფრო კარგი მოსდევს თანა, „მჯობს მჯობი არ დაელევაო”, — ნათქვამია.
ჩვენი ცოლ-ქმარნი კი ამისთანანი არ იყვნენ: ამათ თავიანთ ცხოვრებაზედ „მჯობი“ ცხოვრება არ ეგონათ ქვეყანაზედა. ესენი კმაყოფილნი იყვნენ: ვალი ამათ არ ემართათ და ვახში, დავა არავისთანა ჰქონდათ და დარაბა, მხოლოდ ერთი ჯავრი ედოთ გულშია: შვილი არა ჰყვანდათ. აი, ლუარსაბი ორმოცის წლისა და დარეჯანი ორმოცდაერთისა შესრულდა, რომ ღმერთმა მემკვიდრე არ უბოძათ. ბევრჯერ გადაფურცლა კნეინამ კარაბადინი, ბევრი რაღაც ბალახბულახი მიირთო და ლუარსაბსაც დაალევინა. მაგრამ ვერა ეშველათ-რა. „ტყუილად თავს რად იხეთქენ, — ამბობდა ხოლმე ამათზედ ღვარძლიანი ელისაბედი, — ტყუილად რად იხეთქენ? სოლომონ ბრძნის წიგნს რომ ჩააბულბულებდა ხოლმე და კუდიანობდა — ეგ იმან ჩასცხო თავშია. ღმერთმა მაგათზედ გული აიყარა, ეხლა აღარა ეშველებათ-რა”.
ჩვენი ცოლ-ქმარნი კი იმედს არა ჰკარგავდნენ. შეიტყეს, რომ ქალაქში ერთი მკითხავია, ის შეიტყობს უშვილობის მიზეზსაო. თუმცა შვილოსნობის დრო გადასვლოდათ, მაგრამ მაინც კიდევ ქალაქისაკენ კაცი აფრინეს, თან გაატანეს ერთი კარგი ბაღდადი, რომელზედაც — როგორც მოგეხსენებათ — უკითხავს მკითხავი იმას, ვინც თითონ ვერ მივა, და რომელიც, რასაკვირველია, მკითხავს დარჩება ხოლმე. სამს დღეს უკან ბიჭმა პასუხი მოუტანათ, რომა „თქვენზედ ხატია გამწყრალიო. მერე რომელი ხატი? თელეთისაო, ასე სთქვა მკითხავმაო“. ეს რომ გაიგეს ცოლ-ქმართ, ერთ დროს და ერთხმად პირჯვრისწერით წამოიძახეს:
— საიდამ სად მოგვიკითხა! დიდება სახელსა უფლისასა, — სთქვეს და ისევ პირჯვარი გადიწერეს.
— დალახვრა ღმერთმა! საიდამ სად მოგვიკითხა! — ისევ გაიმეორა ლუარსაბმა.
— ხატზედ „დალახვრას“ როგორ ამბობ?
— ღმერთო, ნუ მიწყენ, ღმერთო, ნუ მიწყენ! — რამდენჯერმე პირჯვარი გადიწერა სხაპა-სხუპით, — აი, დალახვრა ღმერთმა, დაჩვეული რომ ვარ, ისე თავის-თავად ითქმის ხოლმე, ღმერთო, ნუ მიწყენ!
— ახლა რას იტყვი, ლუარსაბ, წავიდეთ?
— შორს რომ არის?
— რა ვუყოთ? ალბად ნება ღვთისა ეგ არის.
— მოდი, აქვე ნეკრესის ღვთისმშობელი ვილოცოთ.
— თელეთის ხატს ეწყინება: მე დავიბარეო, აქ კი არ მოვიდნენო და იქ კი წავიდნენო, იტყვის.
— მართალია, ეწყინება. გული მოუვა. აი, მე ხომ კაცი ვარ, მეც გული მამივიდოდა და ის ხომ ხატი ბძანდება — ვენაცვალე იმის მადლს! — უფრო გული არ უნდა მოუვიდეს?
— ეგ არის და.
— აშ რა ვქნათ?
— უნდა წავიდეთ.
— შორს კი არის, თუ შენც იტყვი.
— ეხლა, თუ მივდივართ, ნუღარ ამადლებ — გვიწყენს.
— მართლა, მართლა! ნუ მიწყენ, აგრემც დიდება შენსა სახელსა, ხატო თელეთისაო! გიახლები, გიახლები და თაყვანსა ვცემ სახელსა შენსა.
დაიჯერეს მკითხავის სიტყვა: თედოს შეაბმევინეს ურემი, გადააფარეს ფარდაგი, ერთი კარგი ცხვარი დააკრეს ურმის ბოლოს, ახსენეს ღმერთი და ერთ მშვენიერ ზაფხულის დილას შეუდგნენ ქალაქის შარა-გზასა. ურემში ისხდნენ კნეინა დარეჯანი და მისი მოახლე ლამაზისეული. ერთი ბიჭი და ლუარსაბი თავის წითელს ულაყ ცხენზედ მჯდომი ნელ-ნელა აედევნენ უკან ფეხმძიმე ურემსა. მეომარის თვალადობა ჰქონდა ამ-ჟამად ჩვენს უამისოდაც საყვარელს ლუარსაბსა, თუმცა კი, როგორც ბამბის ტომარა, ისე იდო ცხენზედა. წელზედ ერტყა ქართული ხმალი და გრძელი ლეკური ხანჯალი, უკან წელში გაყრილი ჰქონდა სევადიანი დამბაჩა. შავი შალის ჩოხა ეცვა, იმისი კალთები ვაჟკაცურად ამოტარებული ჰქონდა ჩოხის ჯიბეებშია. შარვალში იჯდა, შარვლის ტოტები ჩაეკეცნა მაღალყელიან ყარაბაღულ თეთრ ჩექმებში, წვივებზედ პტყელი ჩაღსაკრავი, გრძელფოჩებიანი, სირაჯსავით შემოეკრა. თავზედ ეხურა ლურჯი ყალმუხის ქუდი — კახურად ჩატეხილი და შუბლთან შიგ შეკეცილი — რადგანაცა ცხელოდა, — ერთის სიტყვით, ხმლის პირი, ზედწამოცმულ ვაშლით, რომ ამოღებული სჭეროდა, თავიდამ ფეხამდინ ორშაბათის ყეინი იქნებოდა.
ამ ყოფით ავიდნენ თელეთში მეხუთე დღეს, ილოცეს და მეორე დღესვე დაბრუნდნენ. ქალაქს რომ ჩამოუარეს და შეუდგნენ კახეთის გზასა, კნეინა დარეჯანმა შეაქცია ზურგი კოფასა, წამოიჩოქა და გამოჰხედა ქალაქსა. ლუარსაბს ურემში ეძინა. ისიც გააღვიძა.
— ლუარსაბ, ერთი შეხედე, რა ამბავია. ამოდენა ქვეყანა გაგონილა, რომ აქ არის! დიდება შენდა, ღმერთო! სულ ქვითკირის შენობა უნდა იყოს.
კნეინას ქალაქი ჯერ არ ენახა.
— მაშ არა და წნული იქნება.
— ერთი შეხედე და, რამდენი საყდრებია!..
— ვიცი. განა არა ვყოფილვარ?
— პირველად რომ ჩაგიყვანეს, კენჭები არ ჩაგაყლაპეს?∗
— როგორ არა? სამი ასეთი კენჭი ჩავყლაპე, რომ ძლივს მოვინელე.
— აღარ დაგცადა ქალაქმა?
— არა, რაღას დამცდიდა. რომ კენჭებ-ჩაყლაპული ვიყავ? რომ არ ჩამეყლაპა, მაშინ სხვა იქნებოდა.
— ეგ ხომ აგრეა. კაი სანახავი კი უნდა იყოს!
— კარგი როგორ არ არის, მთელი მილეთის ხალხი სულ მანდ დაწანწალებს: თათარი, ყაზილბაში, ურია, ოსი, სომეხი, რუსები ხომ რაღა, ბუზსავით ირევიან.
— მართალია, რომ აქ კაცს თავს მოსჭრიანო და მერე ისევ გააცოცხლებენო?
— მართალია, მაშ? ეგ კიდევ რა! რაღაც მოუგონიათო, ფიცრებს თავის-თავად ხერხავსო.
— ეხლა ეგა სთქვი.
— თავი არ მამიკვდება.
— როგორ? ისე თავის-თავად?
— თავის-თავად.
— არც კაცია, არც ადამიანი?
— არა.
— მაშ ხერხი ვის უჭირავს?
— ეშმაკს და ქაჯს, ღმერთმა ნუ იცის რუსების თავი!
— რუსების მოგონილია განა ეგა?
— მაშ არა და შენის მაზლის დავითისაა!
— დიდება შენდა, ღმერთო თვალთმაქცობას რომ ჰთამაშობენ, ისიც გინახავს?
— აბა რომელი?
— აი, გაჭენებულ ცხენზედ რომ კაცი დადგება, იმ კაცზედ კიდევ კაცი, იმაზედ კიდევ კაცი და კიდევა და კიდევა.
— ეგ რა არის? მე კი არ დავდგებოდი ხოლმე გაჭენებულ ცხენზედ ჩემ პატარა ბიჭობაში!.. — დაიკვეხა ლუარსაბმა.
— აი, შენმა მზემ! შენ კი იქნებოდი, რომ დამდგარიყავ.
— ღმერთმა იცის! ეხლა ჯანი აღარ მამდევს და სიმარდე, თორემ ეხლავ გიჩვენებდი.
— ნუ იკვეხ. ხომ ვიცი, ჩემო კარგო, რაცა ხარ.
— განა კვეხნისთვის ვამბობ? მე იმისთვის ვთქვი, რომ ეგ რა თვალთმაქცობაა-მეთქი. მაგაზედ უფრო ბევრი ასეთია, რომ...
— მაინც?
— რა ვიცი, რამდენი რამ არის.
— სთქვი რაღა, მეც ვიცოდე.
— ბევრია.
— მაინც?
— რა ვიცი, რამდენი რაღაცაებია...
— მაინც?
— ეჰ, ვინ მოსთვლის? ბევრია, ნეტავი შენ! რა-რიგად ჩამოცხა! უჰ!
რომ არ იცოდა რა ეთქვა ჩვენ უბოროტო ლუარსაბსა, სიტყვა გადაასხვაფერა. მოიხადა ყალმუხის ქუდი, შუბლიდან და სახიდან იმითი ჩამოიწმინდა ოფლი. მერე გააკეთებინა ჩიბუხი და ჩიბუხის წევაში ისევ ხვრინვა ამოუშვა, მერე ასეთი, რომ რამდენიმე დღის უძილო ეგონებოდა კაცსა.
X
 მეხუთე დღეს შინ მშვიდობით მოვიდნენ ჩვენი ბედნიერი ცოლქმარნი, თან მოჰყვათ, რასაკვირველია, იმედი, რომ შვილი გაუჩნდებათ. მაგრამ გავიდა სამი თვე — ყმაწვილმა მუცელში არ გაიჩუჩუნა, გავიდა ექვსი თვე — კაბა არ დაუვიწროვდა დარეჯანსა. გავიდა ცხრა თვეც და დარეჯანს მუცელი არ ასტკივდა. დარეჯანი მაინც იმედს არა ჰკარგავდა: ამდენი სხვა-და-სხვა ფერის და სხვა-და-სხვა ნაირად შელოცვილი ქვები შეიბა და კაბის უბეზედ დაიკერა, რომ მართლა იმედი უნდა ჰქონოდა, და ჰქონდა კიდეც. თუ აქამდინ არ ეყოლა, ის იმიტომ, რომ ლუარსაბმა ხატს დაამუნათა და წააყვედრა — „შორს არისო“. თორემ ეს დამუნათება და წაყვედრება არა ყოფილიყო, ეხლა შვილი ეჯდებოდა დარეჯანს კალთაში. ლუარსაბი ავ გუნებაზედ იყო. ეგ არაფერია, რომ შვილი არ უჩნდებოდა და ხატმა მოატყუვა: დაიბარა და არ მისცა კი შვილი; ამის ჯავრი ის იყო, რომ დავითს, ამის ძმასა, უთქვამს: „ის ოხერი, როდის იქნება ჩაძაღლდეს, რომ იმის მამულებზედ ვინავარდოო“. ესა ჰკლავდა ლუარსაბსა, თორემ შვილის უყოლობა ამისთვის კიდევ დიდი უბედურება არ იყო.
ერთხელ ესე დაღონებული აქეთ ტახტზედ გულდაღმა იწვა ლუარსაბი, იქით ტახტზედ კიდევ კნეინა დარეჯანი წინდასა ჰქსოვდა. ძალიან ცუდს გუნებაზედ იყო ხმაგაკმენდილი ჭერს გაუშტერა თვალი და ჰფიქრობდა, იმაზედ ჰფიქრობდა, როგორ მოახერხოს, რომ შვილი გაუჩნდეს. — „განა შვილი იმისათვის მინდა, რომ მართლა შვილი მყვანდეს? — ამბობდა თავის-თავად, — შენც არ მამიკვდე! დავითის გამოჯავრებით მინდა, ის არ მინდა ჩემს მამულებზედ გავახარო. იმისი ჯავრი არ მინდა შევირჩინო, თორემ ეს ჯაბრი რომ არ იყოს, ძალიანაც არ ვინაღვლიდი, რომ შვილი არა მყავს. ცოტანი არიან უშვილონი განა? მეც იმათში ვიქნებოდი. დავითი არ მინდა გავახარო, დავითი!”
ეს რომა სთქვა თავის-თავად, გადმობრუნდა დარეჯანისაკენ დაღონებული და მწუხარე ხმით უთხრა:
— ეხლა დავითს უნდა შერჩეს ის სიტყვები!.. უნდა ჩვენს მამულ-დედულზედ გავახაროთ!.. დარეჯან შენი ჭირიმე, თუ გიყვარდე, თუ გიყვარდე, აი! ერთი ვაჟიშვილი ჰშობე, დავითის გამოჯავრებით მაინცა ჰშობე, რომ სხვა არა იყოს-რა. ოღონდ იმისი ჯავრი კი ამომაყრევინე და მერე თუნდა მამკალ. შენი ჭირიმე, შენი დედაკაცობის ჭირიმე! თუ გიყვარდე, აი!
— ვშობამ, შენ ნუ მოუკვდები ჩემს თავს, ვშობამ, თუ აგრეა! — უპასუხა კნეინამ ისე, ასე გგონია მართლა ამის ხელში იყოს შვილის შობა. — წუხელის სიზმარში ერთმა მოხუცებულმა კაცმა — ფეხებამდინ უმტვერო ქაღალდივით წვერი ჰქონდა — ერთი წამალი დამალევინა და მითხრა: გამრავლდი, ვითარცა იაკობო! მე მაშინვე მუხლზედ ვემთხვივე, შენ მაგიერადაც ვემთხვივე.
— მართლა? — წამოიძახა იმედმოცემულმა ლუარსაბმა, — ისე თვალითა ნახე?
— აი, როგორც შენა გხედავ.
— ენი ჭირიმე!.. მაშ იმედია, დარეჯან-ჯან!
— მაშ ქა!
— ო, შენ გეთაყვანე, შენა! — დაიჯერა და გაიღიმა ლუარსაბმა, — როგორ გითხრა?
— გამრავლდიო, ვითარცა იაკობ.
— იაკობი ვინ იყო?
დარეჯანმა არ იცოდა, ვინ იყო. ისე კი გაეგო, მგონი — წირვა-ლოცვაზედ, იაკობის სახელი, და ვინ იყო, რა იყო, როდის იყო — ამაების არა იცოდა-რა. მაგრამ არ-ცოდნა ითაკილა, ისევ რაღაცა მოჭორება ირჩივა „არ ვიცის“ თქმასა, როგორც ამ-გვარ შემთხვევაში ყველა ქართველმა იცის ხოლმე.
— ვინ იყო? — იკითხა დარეჯანმა, — წირვა-ლოცვაზედ მაინც არ გაგიგია? აბრაამის მძახლის განაყოფის შვილი იყო.
— ეხლა, გამრავლდიო, ვითარცა იაკობ, მითამ რაო?
— მითამ ისაო, რომ გამრავლდიო, — აუხსნა დარეჯანმა.
— აი, ვენაცვალე იმის ენას! მაშ იმედია?
— იდევ! ნუ იცი შენ ეგ, ნუ! ნუ ხარ უჯერო, ცოდვაა.
— აღარ ვიქნები, აღარ, ოღონდ შენ შვილი ჰშობე, თუნდა ენასაც მოვიკვნეტ, ოღონდ კი დავითს ნუ გაახარებ.
— ღმერთია მოწყალე გეუბნები, არ გავახარებ-მეთქი.
— ახ, ნეტავი კი მართალა ჰშობო და.
— კიდევ! ნუ ხარ უჯათი, წმინდა კაცის სიტყვაზედ როგორ ხარ უჯერო, რა დაგემართა?!
— აი, დალახვრა ღმერთმა! ჩემ-თავად გულში უნდა მეთქვა — ღმერთმან იცის — და აკი კიდევ წამომცდა. ახ, ნეტ...
—კიდევ!
— ფუი, დალახვრა ღმერთმა! კინაღამ კიდევ არ წამცდა!.. ეხლა, მეტად რომ მინდა, იმიტომ, თორემ... ეჰ, გადავბრუნდები, დავიძინებ, თორემ, მე რომ ვიცი ჩემის ენის ამბავი, ერთს კიდევ წამომაროშვინებს რასმეს და ღმერთი მიწყენს.
— თელეთისა არ იყოს! იმდენი ამუნათე, იმდენი იძახე — შორს არისო, რომ გაგვიწყრა და აი, დღესაც შვილი არა გვყავს.
— მერე აკი მაშინვე შევეხვეწე, ნუ გაჯავრდები-მეთქი. რატომ არ მაპატივა! რა ვუყოთ, რომ „შორს არის“-მეთქი ერთხელ წამომცდა? ერთი ალილო მღვდელსაც შესცდებაო.
— კარგი, კარგი! რაც იყო, იყო; ეხლა მაინც არ აწყენინო.
— მაშ დავიძინებ.
— შენი ნებაა.
ლუარსაბი გადატრიალდა და პატარა ხანს უკან ერთი მადლიანი თავისებური ხვრინვა ამოუშვა.
ნეტავი არ დაეძინა. ძილში საშინელი სიზმარი ჰნახა. ჰნახა, რომ დავითი სიხარულით აღარ არის, რომ ამას შვილი არ უჩნდება; დადის ყველგან და სულ იმას იძახის: ის ოხერი როდის იქნება ჩაძაღლდეს, რომ იმის მამულებზედ ვინავარდოო. სტკივა გული ლუარსაბსა, ჯავრი მოსდის, გული ყელში მოებჯინა. რა ჰქნას? — „ღმერთო! — ამბობს სიზმარში გულნატკენად ლუარსაბი, — რა დაგიშავე, შე დალოცვილო, რომ შვილს არ მაძლევ? მიბძანე და აკი გიახელ თელეთს სალოცავადა, თორმეტ-აბაზიანი ცხვარი დაგიკალ, ორი აბაზის წმინდა სანთელი აგინთე. სხვა რა ვქნა? წირვა-ლოცვას უამისოდაც არ ვაკლდებოდი, მარხვა მე არ გამიტეხია, ყოველ წელიწადს წმინდა ზიარება მიმიღია და აღსარება მითქვამს. აბა ჩვენ მღვდელსა ჰკითხე, თუ მე ცოდვა მიქნია რამე. დავითის ლუკმად უნდა გამხადო?! რაც იმას ქვეყანაზედ ცოდვა ჩაუდენია, ვინ მოსთვლის? შარშან ივანე ნათლისმცემლის თავის მოკვეთის დღეს ხორცი უჭამია. პურის ნატეხს რომ მიწაზედ ჰხედავს, არ აიღებს და არ ემთხვეა, იქნება ფეხიც დაადგას და გასრისოს კიდეცა. უკურთხეველ ყურძენსა სჭამს, ფერისცვალობამდის არ მოიცდის ხოლმე, აღდგომა-დღეს მღვდელს არ მოუცდის — რომ სუფრა უკურთხოს, ისე მივარდება ხორცეულს — როგორც დათვი, ამისთანა მსუნაგია. ზიარებით კი ეზიარება ხოლმე, მაგრამ რა გამოვიდა? სამი დღე ემზადება, მარტო სამი დღე. აბა, ეს რა ზიარებაა! ეს ყველა იცი — შე დალოცვილო ღმერთო — და მაინც კიდევ იმისაკენა ხარ! დაილოცა შენი სამართალი! ჰო, მართლა, ერთი კიდევ დამავიწყდა: ერთი მწევარი ჰყავს, თავის თეფშში აჭმევს ხოლმე. ქრისტიანი კაცი კია! მე ხომ ამისთანას არაფერსა ვცოდავ, რად მიწყრები? მერცხალი გინდა, იმას დასძლევს ხოლმე,∗ ოფოფი გინდა, იმას დასძლევს, გუგული, კვიცი — რაც გინდა, ყველაფერი ბოროტი იმაშია. მე კი — ღმერთო, ხომ შენ იცი — არაფერს არ დაუძლევივარ, რად მიწყრები? იმისთვის, რომ თელეთში წასვლაზედ ჭოჭმანობა დავიწყე? აკი მაშინვე მოვინანიე!..“
ეგრე უჩიოდა ღმერთს ლუარსაბი. მერე ჰნახა, რომ მითამ ღმერთმა მიიღო ეს ჩივილი საბუთად და გული მოიბრუნა ლუარსაბისაკენ, აი, მითამ რვა თვეც არის, რაც დარეჯანი ორსულია. ერთი თვეც, ერთად-ერთი, და ლუარსაბს შვილი ეყოლება და დავითს თვალი დაუდგება. უხარიან სიზმარში ლუარსაბსა, რომ ამის ჩივილმა გასჭრა, სიხარულით ფეხზედ ვეღარა დგება. დავით და იმისი ცოლი ჯავრით აღარ არიან. ლუარსაბს ისე შვილი არ უხარიან, როგორც ისა, რომ დავითი და ელისაბედი ჯავრით აღარ არიან. ორი კვირაც მითამ გავიდა, აი, ორი კვირა კიდევ და დარეჯანი დაწვება. უხარიან, უხარიან ლუარსაბს, მაგრამ! — აი, უბედურება — ლუარსაბი უეცრად ავადა ჰხდება და ძალიანაც ჰხდება, ასე რომ მითამ მოკვდა კიდეცა. მაგრამ ისე კი მოკვდა, რომ ყველაფერსა ჰგრძნობს. ესმის, რომ დარეჯანი საშინელის ხმითა სტირის და სოფლის მოტირალე დედაკაცები მწუხარე ბანს აძლევენ. ესმის, რომ იქით, სადღაც კუთხეში, დავითი და ელისაბედი იცინიან, ჰხტიან და ლუარსაბის ავეჯეულობა თავის სახლში გადააქვთ. ლუარსაბს სისხლი ყელში მოსდის, უნდა წამოდგეს, მაგრამ იცის რომ მკვდარია და იმიტომ არა დგება. — „ხვალ მამულებს ჩავიბარებო,” — იძახის ხმა-მაღლა დავითი. ლუარსაბი იწურება ამ სიტყვებზედა, იტანჯება, უნდა სთქვას — რომ „ნუ მისცემთო, დარეჯანი ორსულად არის, შვილი ეყოლებაო”, მაგრამ იცის, რომ მკვდარია და არას ამბობს. საშინელ მდგომარეობაშია საწყალი, ცოცხალ-მკვდარი ლუარსაბი. რა ჰქნას აბა მკვდარმა? — „ვაი, რა დროს მოვკვდი!.. როცა ღმერთმა შვილის მოცემა ინება, მაშინ! — ამბობს სიზმარში თავის-თავად ლუარსაბი, — ახ, ნეტავი ეხლა კი გავცოცხლდე და!..“
მაგრამ სად არის გაცოცხლება? აი, კუბოც მოიტანეს, აი, ჩაასვენეს კიდეცა და კუბოში ჩადებული და მორთული დაასვენეს ტახტზედა. მესამე დღეს მღვდლებიც მოვიდნენ, ასწიეს კუბო და წაიღეს გალობითა და ტირილითა. ამ გალობაში და ტირილში დავითისა და იმის ცოლის მხიარული სიმღერა ესმის ლუარსაბსა. ესმის ეს ყველაფერი, ჰგრძნობს რომ ანდერძიც აუგეს და სასაფლაოზედაც წაიღეს, უნდა სთქვას: „ნუ დამმარხავთო“, მაგრამ იცის მკვდარია და არას ამბობს. აი, მიწაში ჩაუშვეს საწყალი ლუარსაბი, ესმის, რომ საფლავის პირზედ დავითი სდგას და ეუბნება დიანბეგს: ხვალ მამულები უნდა ჩამაბაროვო. ელისაბედი კი უჯავრდება: რას ჰბოდავ? სახვალიოდ რად იხდი საქმესა, განა დღეს კი ვერ ჩაიბარებ? ლუარსაბს ეს ყველაფერი ესმის, ჰხვნეშის, ჰწვალობს, იტანჯება, ცივ ოფლს ასხამს, ჰკანკალებს, თრთის ცალკე შიშისაგან, ცალკე ჯავრისაგან, რომ დავითსა რჩება ბურთი და მოედანი. — „ახ! ნეტავი კი ეხლა გავცოცხლდე და!“ — იძახის გულში ლუარსაბი.
მაგრამ სად არის გაცოცხლება? აი, მიწაც მოაყარეს, ჯერ მუჭა-მუჭად მიწა ცვივა და კუბოს ფიცრებზედ რახა-რუხი გააქვს, მერე შეატყო, რომ ნიჩბებითაც დაუწყეს მიწის ყრა. ლუარსაბს უღონდება გული, სული ეხუთება, ჰაერი დაეხშო და, აი, ერთი წუთიც და გათავდება კიდეცა. მაგრამ ვინ არის მეშველი? ესმის, რომ ხალხის ხმაურობა თან-და-თან მისწყდა, ყველანი წავიდნენ და მარტო ლუარსაბი საფლავში დააგდეს დაფლული. გულმა ტეხა დაუწყო, რომ დარეჯანმაც კი — ამის საყვარელმა დარეჯანმაც კი — სხვებსავით თავი დაანება და ამასთან არ დაიმარხა. ლუარსაბს გული ამოუჯდა, დაიწყო ტირილი: „ეგ იმედი მქონდა იმისაგან!“ ამბობს თავის გულში: „დამაცა, შენც საიქიოს არ მოხვალ, იქ მოგაგონებ“. ამ ლაპარაკში რომ არის, საფლავზედ ფერხულის ხმა შემოესმა, ხმა გაიკმინდა, ყური დაუგდო. მოესმა, რომ დავითი და ელისაბედი ფერხულში ჩაბმულან და ჯერ კიდევ სველ საფლავზედა ფერხულსაც უვლიან. „ჩაძაღლდი, განა?“ — უყვირიან ზემოდამ. ეხლა კი გული აენთო; ერთი საშინლად გაინძრა, უნდოდა ისე წამოწეულიყო, რომ კუბოს თავი და მიწა აეგლიჯნა, საფლავიდამ ამოსულიყო, ამათთვის ერთი ყოფა დაეწია და თავზედ ლაფი დაესხა. ამ ტრიალში და ვაი-ვაგლახში რომ არის, ერთი იხტუნა, მითამ საფლავიდამ ამოხტომა უნდა, და ტახტიდამ ძირს აგურებზედ კი ბრაგვანი მოიღო. მაშინ კი თვალები დააჭყიტა, ჯერ კიდევ სიზმრის შიშის-ზარი ისევ უბზუოდა თავში, ასე რომ სულელსავით გაშტერებული და ფილაქანზედ გაშოტილი პირღია დარჩა. სასაცილო რამ იყო. ისე დაიკარგა, ისე გაფითრებული და ცივ ოფლში იყო, რომ დიდხანს გონზედ ვეღარ მოვიდა და არამც თუ წამოდგომა მოაგონდა, არც კი გაინძრა. ისეთი შეშინებული იყო, რომ სიკვდილის ფერი ედო ოფლიან სახეზედა. ამის დაცემაზედ ოთახი, რასაკვირველია, შეინძრა. დარეჯანს თურმე — იქით, მეორე ტახტზედ — ჩასძინებოდა და ოთახის ზანზარზედ ამასაც გამოეღვიძა. ამან, — რადგანაც ჯერ არ იცოდა ლუარსაბი რა ყოფაშია, — ჯერ წამოიძახა, — ლუარსაბ! გაიგე? მიწისძვრა იყო.
ლუარსაბი ჯერ კიდევ სიზმრის ამბავში იყო და ხმა არ გასცა, დარეჯანი წამოჯდა და მხოლოდ მაშინ დაინახა, რომ ლუარსაბი გაფითრებული აგურებზედ უძრავად ჰგდია და სულელსავით დაუჭყეტია უგუნური თვალები. დარეჯანს ფერი ეცვალა.
— უი შენს დარეჯანსა! ეს რა დაგმართვია, შენ გეთაყვანოს ჩემი ცოცხალი თავი!
ლუარსაბმა ვერც ეს დარეჯანის ნათქვამი გაიგო. სიზმარმა ისეთი თავბრუ დაასხა, რომ შიში ჯერ გამონელებული არა ჰქონდა და ეს ამბავი სიზმრის გაგრძელება ეგონა, იმიტომ ჯერ არც-არა ესმოდა-რა და ვერცა-რასა ჰხედავდა, თუმცა თვალები კი ეჭყიტა. დიაღ, ჯერ ისევ სიზმარი ეგონა, მხოლოდ ის აოცებდა, რომ „აკი დამმარხესო და მგონი მე ჩემს ოთახში ვარ ეხლაო. ეს როგორ მოჰხდაო?”
ამის ფიქრში დაიფანტა ამისი გონება. ამიტომაც პასუხის მაგიერად თავისი შიშნაჭამი თვალები გიჟსავით შეაჭყიტა დარეჯანსა, თითქო ჰხედავს კიდეცაო და არც იჯერებსო, რომ იმის წინ დარეჯანია. დარეჯანს ელდა ეცა, ხომ არ გაგიჟდაო. მაშინვე ტახტიდამ ჩამოფრინდა და მივარდა გაშოტვილს ლუარსაბს.
— რა დაგემართა, შენი ჭირიმე, შენი! ხმა ამოიღე, გეთაყვანე, თორემ ლამის მე ჩემი დამემართოს!
— დამაცა!.. — გაუქნივა თანაც ხელი ლუარსაბმა, მითამ მამშორდიო, — მინდა მოვიგონო.
ესა სთქვა, ხმა გაიკმინდა, მაინც არ წამოდგა და თვალებდაჭყეტილმა და პირდაღებულმა დაიწყო ფიქრი, რომ მოიგონოს ის, რაც დაემართა. ისე უეცრად და ამ ყოფით გამოღვიძებულს სიზმრის ამბავი ცოტაღა დაახსოვდა და ის უნდა მოეგონა.
— შენ გენაცვალე! — მიემუდარა დარეჯანი, — ჩქარა მითხარ, თორემ შიშისაგან ლამის გავთავდე.
ლუარსაბმა ყური არ ათხოვა და სიზმრის ფიქრში წასულმა თავის-თავად ხმამაღლა ლაპარაკი დაიწყო:
— მე მოვკვდი. დარეჯანი ჯერ კი ტიროდა და მერე, როცა დამმარხეს და ყველამ თავი დამანება, დარეჯანმაც მიღალატა. ეგ იმედი მქონდა იმისაგან? თავი დამანება და ჩემთან არ დაიმარხა!.. აკი უყვარდი! დამაცალოს!.. ის სულ-ძაღლი დავითი!.. ის ქოფაკი ჩემი რძალი!.. ფერხული დააბეს განა, დამაცადონ!.. აი, მკვდარი არა ვყოფილიყავ, მე ვუჩვენებდი იმათ!.. მაგრამ რა მექნა, რომ მკვდარი ვიყავი!..
ბევრს რაღაცეების ბოდვას მოჰყვა ჩვენი ლუარსაბი. დარეჯანი კი გაფითრებული ყურს უგდებდა, არ ესმოდა რას ჰლაპარაკობს.
— შენი ჭირიმე, ლუარსაბ! — უთხრა კანკალით დარეჯანმა, — სიზმარში ხარ, თუ ცხადივ? მითხარ, თორემ შენს მაყურებელს სული დამელია.
— ეხლა განა? მაშინ რატომ არ დაგელია, როცა მიწა მომაყარე და მარტოკა ჩამფალი შავ მიწაშია?
— რას ამბობ, შენი ჭირიმე, რასა? ერთი შემატყობინე.
— რა უნდა შეგატყობინო? ცარიელი ტირილით რა გამოვიდა, უნდა თან ჩამამყოლოდი. არა გრცხვენიან, პირში როგორღა მიყურებ?
— უი, თვალები ეხლა დამდგომია, თვალები! — შეჰჭყივლა დარეჯანმა და მაშინვე გამოვიდა მოაჯირზედ, რომ ბიჭებს დაუძახოს, რადგანაც გული დააჯერა, რომ ლუარსაბისათვის ეშმაკს ძილში თავში ჩაუკრამს და ჭკვიდამ შეუშლია. ის კი არა თუ, ლუარსაბი ჯერ კიდევ სიზმრის ამბავშია.
— მიშველეთ, მიშველეთ!
ჰყვიროდა დარეჯანი მოაჯირიდამ თავში ცემით თავმოხდილი და გაწეწილი.
— მიშველეთ! უი ამ დღის მნახველსა, შე ქოფაკო დარეჯანო!
ჰყვიროდა კნეინა და იცემდა თავში, რაც ძალი და ღონე ჰქონდა. ლუარსაბი ამ ყვირილზედ სრულიად გამოფხიზლდა. წამოხტა აგურებიდამ და ისე გაღეღილი გავარდა, რომ შეიტყოს, რა დამართვია დარეჯანსა. დარეჯანმა დაინახა თუ არა ლუარსაბი, ეგონა — მე გამომიდგაო, იშვირა ფეხი და ეცა კიბეს. კიბეზედ ფეხი გაუსხლტა და ისე რახა-რუხით ჩაგორდა ძირამდინა. ამ კიჟინაზედ და ვაი-ვაგლახზედ ბიჭები მოგროვდნენ.
— დაიჭირეთ, დააბით! — წივოდა გვერდებდალეწილი დარეჯანი, — დაიჭირეთ, თორემ დაგვჭამს, ვაი, შე ქოფაკო თავო! ამ დღესაც შეესწარ, რომ ქმარი გაგიგიჟდა!
ჰწიოდა საწყალი კნეინა და იცემდა ძალზედ თავში, თითქო იმისი ბრალი იყოს ლუარსაბის გაგიჟება. ლუარსაბი გაოცდა, ეს ამბავი რომ ჰნახა, სრულიად გაშრა. ეხლა ამას ეგონა, რომ ცოლი გაუგიჟდა და დაიწყო საწყალმა ტირილი: გულჩვილი იყო.
— რა გაყვირებს, ადამიანო, — გადასძახა ხმაამოჯდომით და ნაღვლიანად დარეჯანსა, სრულიად გონებაზედ მოსულმა და დამშვიდებულმა, — ვინ გაგიჟდა, შენი სულისა, შენი! მე ჩემ გონებაზედა ვარ.
დარეჯანმა შემოჰხედა, დაინახა, რომ ლუარსაბი ისევ ის ლუარსაბია, არც გიჟი, არც ჭკვიანი, არც ფლავი, არც ჩლავი; მაგრამ მაინც კიდევ ჯერ ეჭვში იყო. გიჟმა იცის ხანდისხან დაჭკვიანებაო, გაიფიქრა გულში.
— აბა სწორედ შემომხედე, — დაუძახა ქვევიდამ დარეჯანმა და თვალები შემოაჭყიტა.
— აჰა, შენი სულისა! — სთქვა და შეჰხედა ლუარსაბმა.
— წეღან რას ჰლაპარაკობდი?
— აბა როდის, შენი ჭირიმე!
— აი, აგურებზედ რომ იწექი.
— სიზმარი ვნახე და იმას ვიგონებდი.
— მაშ აგურებზედ რად იყავი გაშოტილი?
— ცუდი სიზმარი ვნახე: მმარხავდნენ მითამ და საფლავიდამ ამოხტომა მინდოდა და ძირს კი დავეცი.
— მართლა, შენ გენაცვალე! — შემოჰხარა დარეჯანმა, — ვუი, შერცხვენილო თავო! მე კი ქვეყანა შევყარე, ქმარი გამიგიჟდა-მეთქი.
დარეჯანი ამოვიდა მაღლა ლუარსაბთან და მაშინვე შემოსცინა. ლუარსაბმაც კბილები დაუკრიჭა.
— მართლა გიჟი გეგონე, შენი სულისა? — ჰკითხა ლუარსაბმა.
— მართლა მეგონე, შენ გენაცვალოს ჩემი თავი.
— აი, დალახვრა ღმერთმა, მე კიდევ შენ მეგონე გიჟი. მადლობა ღმერთსა, ორივ კარგადა ვართ. კიბეზედ რომ ჩაგორდი?
— რა მიშავს? მე, რაკი შენ შენს გონებაზედ გხედავ, ყველაფერი დამავიწყდა.
— მეც ისე ვარ.
— უი, შენი ჭირიმე, შენი! რომ მართლა გაგიჟებულიყავ, რა მამივიდოდა? — უთხრა ესა დარეჯანმა და სიხარულით ატაცებულმა, რომ ლუარსაბი თავის ჭკვაზედ არის, ლოყაზედ უჩქმიტა.
ლუარსაბს იამა და, რომ უკან არ ჩამორჩეს ალერსშია, თითონაც უჩქმიტა და ზედ ტკბილის ხმით და ღიმილით „ჰი!” დაატანა. ესე მოხდა ეს ამბავი.
XI
ლუარსაბმა ეს სიზმარი თავიდამ ბოლომდინ, როგორც იყო, ისე უამბო. დარეჯანმა ისე ახსნა ეს სიზმარი, რომ სწორედ ცხრა თვეს უკან შვილი უნდა ეყოლოს.
— აბა, როგორ? — ჰკითხა ლუარსაბმა.
— ხომ სტიროდი სიზმარშია? — ეხლა დარეჯანმა ჰკითხა.
— ვტიროდი.
— მეც ხომ ვტიროდი?
— შენცა სტიროდი.
— ტირილი კიდევ სიხარულის ნიშანია. მე და შენ სიხარული სხვა რა გვექნება, თუ არ შვილის ყოლა? მაშ შვილი გვეყოლება და ჩვენი სიხარულიც ისე აგვიხდება.
— მართლა, ტირილი ხომ სიხარულის ნიშანია. უთუოდ ეგრე აგვიხდება. აი, ვენაცვალე სულში იმ სიზმარსა! თვალი არ დაუდგება დავითსა! აბა, ფერხულს მაშინ ჩამოუვლის, აი! ღმერთო, შენ იცი ეხლა.
ამ დროს ლამაზისეულმა კარი შემოაღო და გახარებული შემოვარდა ოთახში.
— ქალბატონო, ქალბატონო! — წამოიძახა გოგომა, — ჩამჩიაშვილს რომ ძაღლმა შვილი დაუცოფა, იმისთვის ერთი აქიმი დედაკაცი მოუყვანიათ, იმ დედაკაცმა თურმე მკითხაობაც იცისო. ხომ არა გნებავთ აკითხვინოთ? რაც კაცს გულში აქვს და შუბლზედ აწერია, ყველაფერს თურმე მაშინვე შეიტყობს.
— შენს პირს შაქარი, ჩემო ლამაზისეულო, შენს პირს შაქარი, — წამოიძახა გახარებულმა დარეჯანმა, — წადი და ეხლავ აქ მომიყვანე, ფულს გაჩუქებენ-თქო.
გოგო გამოტრიალდა და გაიქცა.
— დარეჯან, შენი ჭირიმე, დარეჯან! სიზმარი ცხადდება! — შეჰყვირა ღრეჯით გახარებულმა ლუარსაბმა, — ვა! მეტი რაღა გინდა! ღმერთმა თავისთავად მკითხავი კარზედ მოგაყენა. ეს რის ნიშანია?
— მაშ, ქა, რომ გეუბნებოდი და არ მიჯერებდი, მაშ რის იმედით გეუბნებოდი, რომ შვილი მეყოლება-მეთქი? მე რათა ხანია გული მითხრობდა.
— მეც დიდი ხანია გული მითხრობდა, თურმე ეს ამბავი იყო. აბა, ეხლა დაუდგება თვალი დავითსა, აი!
**
— რა ნაღველი აქვთ იმისთანა, რომ ავადმყოფს თავი დამანებებინეს და აგრე საჩქაროდ მიბარებენ? — ჰკითხავდა ლამაზისეულს გზა-და-გზა ერთი ტანში მოხრილი, პატარა, მოკუნტული, დაღმეჭილი ბებერი დედაკაცი.
— რა ვიცი? ხომ იცი, რომ უშვილონი არიან...
— ეგ ხომ მე უშენოდაც ვიცი, რომ შვილი არა ჰყავთ, — გააწყვეტინა სიტყვა ოსტატურად გამოქნილმა და ცბიერმა მკითხავმა.
სულელს ლამაზისეულს გაუკვირდა: საიდამ იცისო!
— მაშ ქალაქში რომ მკითხავს აკითხვინეს და ეთქო, თელეთი ილოცეთო, ისიც გეცოდინება? — უთხრა გოგომა და დააცქერდა გაოცებული, ვნახოთ, რას იტყვისო.
— მაშ, ჩემო კარგო, ჩვენი ხელობა რა არის? პურს მაგითი ვჭამ და ეგ როგორ არ მეცოდინება? — მიუგო ოსტატმა დედაბერმა ისე არხეინად, ასე გგონია — მართლა იცოდაო.
— თელეთში რომ ვიყავით, ისიც იცი?
— გეუბნები, შვილო, ჩვენი ხელობა ეგ არის-მეთქი. მაგითი ვცხოვრობთ, მაშ არ გვეცოდინება?
ძალიან უხაროდა გულში მკითხავსა, რომ ამისთანა სულელი გოგო შეჰხვდა, რომ ზოგიერთი საჭირო ამბავი გზა-და-გზა გამოათქმევინა. გოგოს კი საშინლად უკვირდა ამისთანა გულთამხილაობა ამ დედაკაცისა, სულელს ფიქრადაც არ მოუვიდა, რომ თითონ გააგებინა ყველაფერი, — უმაგისოდ არა ეცოდინებოდა-რა.
გოგომ თავლაზედ ამოატარა მკითხავი. მკითხავმა თავლის გარეშემო თვალი გადაავლო და ერთი ამოღრანტული რაღაცა შენიშნა „ეს კარგია”, სთქვა გულში.
ცოლ-ქმარი მოუთმენლად ელოდნენ მკითხავსა, ბოლოს მკითხავიც მოვიდა. რა წამსაც ფეხი ოთახში შემოდგა და თავი დაუკრა, მაშინათვე ოსტატურად მოფიქრებული სიტყვები მიაყარა:
— ძერას ჰკითხეს: შვილები გირჩევნია, თუ ორი თვის წყალუსმელობაო? — წყლის უსმელობაო. ჯორსა ჰკითხეს: — შენ რაღაო? — უშვილობაო. თქვენთვის არავის უკითხავს და რატომ შვილი არა გყავთ? ვინ დაგწყევლათ ეგრე?
ცოლ-ქმარმა გაოცებით ერთმანეთს შეჰხედეს: საიდამ გაიგო ეგრე მალეო! ლუარსაბმა პირი დააღო ჯერა, მინამ სიტყვების აზრს მიჰხვდებოდა; როცა მიჰხვდა — თითქო შეშინდაო, პირჯვარი გადიწერა და სთქვა იმ სახით, როგორც ჭექა-ქუხილის დროს ვიცით ხოლმე:
— ურთხეულ არს სახელი უფლისა. ეს რა მესმის, თქვენი ჭირიმეთ!.. დედაკაცო! ჩვენ გულში იჯექ?..
მკითხავმა ხმა არ გასცა, თითქო ამისთანა ქებას ყურსაც არ ათხოვებსო. მიუბრუნდა რაღაც მზრუნველობით გოგოს და უთხრა:
— ჯამით წმინდა წყალი მომიტანე, ერთი შავტარა დანა, ნახშირი და ახალი ხორბალი.
მინამ გოგო ამას მოუტანდა, ლუარსაბი და დარეჯანი ენა-ჩავარდნილებსავით იყვნენ. ეგონათ, რომ თუ არ ეშმაკის მანქანებით, ამისთანა გულთმისნობა არ იქნება. მოდი და ეშმაკის ხსენებაზედ შიშისაგან ენა ნუ ჩაუვარდებოდათ!
გოგომ მოიტანა ყველაფერი. ბებერი ძირს ჩაჯდა. ჩააგდო ჯერ ერთი ხორბალის მარცვალი, აიღო ხელში დანა და ნახშირი და დაიწყო ტუჩების ცმაცუნი, მითამ-და ულოცავს. მერე გაუშტერა თვალი წყალსა. ჩვენი ცოლ-ქმარნი შიშით და კრძალვით ელოდებოდნენ, ჩვენი ბედისწერა რას იტყვისო.
— ქალაქში მკითხავთან გიკითხვინებიათ, — დაიწყო კუდიანმა, — მკითხავიც კარგი შეგხვედრიათ. სწორედ უთქვამს, რომ თელეთი ილოცეთო.
ეხლა კი მართლა შეშინდნენ ცოლიცა და ქმარიცა. ერთმანეთს ყურება დაუწყეს. ამისთანა გულთამხილაობა რომ არ გაეგონათ თავის დღეში!
დედაბერი ვითომ არაფერს არ ამცნევს, რაც ძალი და ღონე აქვს აცმაცურებს ტუჩებსა და თითო ხორბლის მარცვალსა ჰყრის წყალში.
— კარგი გიქნიათ, — დაიწყო ისევ მკითხავმა, — კარგი გიქნიათ, რომ მკითხავისთვის დაგიჯერებიათ და თელეთის სალოცავად წასულხართ. შეგეწიოთ თელეთის მადლი; მაგრამ...
აქ სიტყვა გასწყვიტა ბებერმა: თითქო წყალში უნდა ამოიკითხოსო, თვალი უფრო დააკვირვა.
— მაგრამ ისა, რომ იმ მკითხავს გულთმისნობა სავსე არა ჰქონია, — ცოტა ჰკლებია, თორემ თელეთი როგორ არ გიშველიდათ, რომ გამოეცნო.
— აკი შენი ბრალიაო, დარეჯან! ადრევ რომ მითხარი. გამოდის ჩემი ბრალი არა ყოფილა, — უთხრა ლუარსაბმა თავის ცოლსა, მაგრამ ისე კი, რომ გაშტერებული თვალი მკითხავისათვის არ მოუშორებია.
— დამაცა, რა დროს ეგ არის. მე აქ შიშისაგან სული მძვრება. რა ყოფილა, შენ გენაცვალე, ეს დედაკაცი!.. — ამბობდა მართლა შეშინებული დარეჯანი.
— დიაღ, მკითხავის ბრალია, — მოჰყვა ისევ კუდიანი, — იმის ბრალია. იმას რომ მიგნება ჰქონოდა, ეხლა შვილი კალთაში გეჯდებოდათ. დიაღ გეჯდებოდათ, რომ...
აქ ისევ სიტყვა გასწყვიტა ხერხიანმა დედაკაცმა და უფრო გაუშტერა თვალი წყალსა. ლუარსაბი და დარეჯანი სმენად გადაიქცნენ.
— დიაღ, თელეთი გიშველიდათ — კიდევ შეგეწიოთ იმისი მადლი — თელეთი გიშველიდათ, — გააგრძელა სიტყვა მკითხავმა ისევ თვალაუღებლად, — რომ თქვენ სახლში ჯადო არა ყოფილიყო.
ლუარსაბმა და დარეჯანმა, შიშისაგან სულწასულთა, ერთს დროს და ერთხმად კანკალით წამოიძახეს:
— ვაი, ადრე და მალე დაღუპულო ოჯახო!..
— ნუ გეშინიანთ: ეხლა ის ჯადო საშიში აღარ არის, მე ხელში მყავს.
— აბა, მაჩვენე, თუ ხელში გყავს, — უთხრა ლუარსაბმა, მაგრამ, რადგანაც თითონ ეშინოდა იმისი ნახვა, დარეჯანს უთხრა: — მე კი ვერ შევხედავ, მე თვალებს დავხუჭავ და შენ გასინჯე.
— უი, არა გეთაყვანე, შენ თითონა ჰნახე, მე დავხუჭავ თვალებსა, — მიუგო შიშისაგან ფერმიხდილმა ცოლმა.
— ნუ გეშინიანთ, — დააშოშმანა მკითხავმა, — განა მართლა ხელში მყავს, ჯადო თქვენს ეზოშია.
— სადა, გეთაყვანე, სადა? არიქა, ბიჭებო, მიშველეთ! — დაიყვირა ბატონმა.
— თავლას უკან რომ ორმოა, ჯადო იქა დევს... — მშვიდად დაუმატა მკითხავმა.
— ბიჭებო, არიქა, ბიჭებო! აბა, თქვენი ჭირიმე, ბიჭებო! თუ ბატონის წყალობა გინდათ, ბიჭებო! თუ ჩოხები გინდათ, თავლის უკან ორმოაო! არიქა, ბიჭებო! თქვენი ჭირიმე, ბიჭებო!
ჰყვიროდა ოთახში ზარდაცემული ლუარსაბი. აქეთ კიდევ დარეჯანი კანკალმა აიტანა და ტუჩები გაულურჯდა, მაგრამ მაინც კიდევ ქმარს უთხრა:
— აქ რომ ჰყვირი, ვინ რას გაიგებს? გარეთ გადი და გაგზავნე ბიჭები.
— არა, გეთაყვანე, ეხლაკი შენ გადი და მერე თუნდა ორმოცჯერ მე გავალ.
— გადი, რისა გეშინიან, ჯადო ხომ არ დაგარჩობს, — ეუბნებოდა კნეინა და თითონაც კი ეშინოდა.
— არა, გეთაყვა, შენ გადი. რა არის? ეხლა, თუ ღმერთი გწამს, შენ გადი, თუ გიყვარვარ, შენ გადი.
— არა გრცხვენიან, მე დედაკაცსა მგზავნი და შენ კი ქუდი გეხუროს და კაცი გერქვას?
— რა დროს კაცობაა, რას ამბობ? სახლში ჯადო არისო.
— მე დავუძახებ ბიჭებს, — უთხრა მკითხავმა, — მაგაზედ როგორ დაღონდით!
— ო, გეთაყვა, შენ დაუძახე, ჩვენ — ხომ ხედავ — დავღონდით, — შეეხვეწა ლუარსაბი, — ეხლა, ოთახში რომ ჩვენ მარტონი დავრჩებით, ხომ არაფერი?
— არაფერი.
მკითხავი გავიდა, ბიჭები გაისტუმრა ჯადოს ამოსაღებად. ბიჭებმა ბევრი უტრიალეს თავლასა და ორმო ვერა ჰნახეს. მოვიდნენ და ბატონს უთხრეს: იქ ორმოს რა უნდაო.
— ვაი, შენ ჩემო თავო! — დაიძახა ლუარსაბმა, — დახე, ჯადოს ამათთვისაც თვალი აუბამს, რა გვეშველება?
მკითხავმა ჩაიცინა.
— მე წავალ თითონ. მე ჯადო თვალებს ვერ ამიბამს, — სთქვა მკითხავმა, — თქვენც წამოდით, რომ თქვენის თვალითა ჰნახოთ.
— არა, გეთაყვანე, ჩვენ ისეც დაგიჯერებთ, — უთხრა ლუარსაბმა, რომ ეშინოდა იქ წასვლა. — უჩვენოდ წადი, შენა ჰნახე, მითამ ჩვენ გვინახავს.
დედაბერი წავიდა, თან ბიჭები წაასხა და პატარა ხანს უკან რაღაცა ძონძები ამოიტანა.
— აქ ნუ შემოიტან, — ჰყვიროდა ლუარსაბი და თან კუთხეში იმალებოდა, — აქ ნუ შემოიტან, მანდვე დააწვევინე, მანდვე!
ჯადო დასწვეს.
XII
მეორე დღეს გუშინდელი ბიჭები დაიბარა ლუარსაბმა და ამისთანა საუბარი დაუწყო:
— მართლა ორმო იყო?
— თქვენი რისხვა არა გვაქვს, მართლა ვნახეთ, — მიუგეს ბიჭებმა. იმათ ხომ მალე იციან ამისთანაების გატანა.
— არა, თქვენ ის ორი თვალითა ჰნახეთ?
— ორის თვალითა, აი ისე, როგორც შენ გხედავთ, ბატონო!
— დიდება შენდა, ღმერთო! ამოდენა კაცი აქ დავბერდი და მე იქ ორმო არსად არ მინახავს!.. გაგონილა? როგორ შეიტყო? დიდი მისნობა არ უნდა ჰქონდეს?..
— მაგის ხელობა ეგ არის, შენი ჭირიმე, და იქიდამ შეიტყო, — მიუგეს ბიჭებმა.
— ალბად ეგრეა, თორემ... აი, დალახვრა ღმერთმა! აბა, თქვენ გინახავთ ვისმე იქ ორმო, ან გაგიგონიათ?
— რაც არ არის, რასა ჰნახავდნენ, — წაიბუტბუტა ერთმა თავმოწონებულმა ყმაწვილმა ბიჭმა, რომელიც შორი-ახლო იდგა და მკლავი ხანჯალზედ ებჯინა, — ერთი რაღაც გოგო-ბიჭების ნაჩიჩქნია და იმ კუდიანმა ორმოდ გახადა. რა უკვირთ?
ეს ისე სთქვა, რასაკვირველია, რომ ლუარსაბს არ გააგებინა.
— შენ რა გენაღვლება, ძმაო, — წასჩურჩულა ერთმა ხნიერმა გამოცდილმა გლეხკაცმა, — ხომ ჰხედავ — ბატონს უხარიან, რომ იქ ორმოა. დაე ეგონოს, რომ ორმოა, შენ რა?
— შენი რისხვა არა მქონდეს, — მიუბრუნდა მერე ბატონს ცბიერი მონა, — მე იქ ორმო არც მენახოს და არც გამეგონოს დღევანდლამდინა. აი, ჭიპი აქ მომიჭრია და ამოდენა კაცს ლამის სულიც აქ დამელიოს, მაგრამ ხომ მოგეხსენებათ, შენი ჭირიმე, კუდიანის საქმე ეგ არის.
— განა ის კუდიანი იყო?
— მაშ? კუდიანობის ღამეს, ჭიაკოკონობას, შენი ჭირიმე, გადააჯდებიან ხოლმე — აი, დასწყევლოთ ღმერთმა — ცოცხზედა და თავის ბატონთან გაფრინდებიან ხოლმე. მოგახსენებენ, ჩიტურაშვილის დედა თურმე ბუხარში აძვრება ხოლმე, ცოცხზედ — როგორც ცხენზედ — შეჯდება და, ჰერი ბიჭო, გაუტევს ხოლმე.
— ეგ მეც გამიგია. რამდენი სასწაულია ქვეყანაზედ! დიდება შენდა ღმერთო!.. — გადიწერა პირჯვარი ლუარსაბმა, — მაშ ჩიტურაშვილის დედასაც ეცოდინება მკითხაობა?
— განა ყველამ იცის, შენი ჭირიმე! ის უფროსი რომ ჰყავთ და კუდიანობის ღამეს ძღვენით რომ მიდიან ხოლმე, ის უფროსი თურმე ეტყვის: შენ, მავანო, მკითხაობა მიჩუქებია შენთვის, მეორეს კიდევ ეტყვის: შენთვის — აქიმობაო, ესე გახლავთ.
— ეგრე იქნება, თორემ აბა საიდამ გამოიცნობდა, რომ იქ ორმო არის? ჭკვიანი არ უნდა იყოს ის უფროსი?
— მოგახსენებენ, სოლომონ ბრძენზედ უფრო ჭკვიანიაო.
— არ ეტყობა, თუ! დიდება შენდა, ღმერთო ჩემო! — გადიწერა ისევ პირჯვარი და შევიდა ოთახში დარეჯანთან.
— გაიგე, დედაკაცო, რა ამბები მოახდინა იმ უხეირო, უკბილო ბებერმა? — უთხრა ცოლსა, — ის უფროსი რომ ჰყავთ, იმისი პირველი კარის-კაცი ეგ უნდა იყოს. აი, დალახვროს ღმერთმა! ეს რა ვნახე, თქვენი ჭირიმეთ!
— კარგი, ნუღარ მომაგონე, თუ ღმერთი გწამს! აქამდინ ტანში შიშისაგან ჟრუანტელი მივლის.
— აი, გულთმისნობა რა არის! ამდენს ხალხს ჩემს სახლში ჭიპი მოუჭრიათ და ერთმა არ იცოდა დღევანდლამდინ, რომ იქ ორმოა. რა ქნა, თქვენი ჭირიმეთ!
— ღმერთო, შეგცოდე და, იმას თუ ეშმაკი არ ეჯდა ტანში, რა ვიცი?
ცოლ-ქმარმა ეშმაკის ხსენებაზედ პირჯვარი გადაიწერეს და სამჯერ შეაფურთხეს ეშმაკსა.
— ეხლა კი... რა ვიცი? ეხლაც რომ შვილი არ გვეყოლოს, ერთი მეტის-მეტი ღვთის წყრომა იქნება, — სთქვა ლუარსაბმა.
— ეჰ, შენც ერთი!.. მაგას რაღა თქმა უნდა. ისე დაჯერებული ვარ, რომ მითამ შვილი კალთაში მჯდომია. რაები არ გამოიცნო!.. მოდი და ნუ დაიჯერებ.
— მაშ! მეც იმიტომ ვამბობ და!.. მკითხაობა რომ არ გაეჩინა ღმერთსა — ვენაცვალე იმის სიბრძნეს — რა გვეშველებოდა? ჯადოს ვიღა იპოვიდა?
ორივენი ჩაჩუმდნენ და ორივენი მაინც კიდევ გაოცებულნი იმეორებდნენ გონებაში გუშინდელს საოცარს ამბავსა. ბოლოს ლუარსაბმა ისევ დაიწყო:
— დარეჯან! წყალში ხომ არა ჰხედავდა? ჰა? შენ რას იტყვი?
— იქნება მართლა! შენ ნუ მოუკვდები ჩემს თავს, სწორედ წყალში ჰხედავდა.
— რა ვქნა, მე კი აგრე მგონია და!
— ღმერთმან იცის, იქნება სწორედ ეგრე იყოს.
— რა ვიცი! მე კი რაღაც ეჭვი მაქვს და!
— ენმა მზემ, ეგრე უნდა იყოს.
— რა ვიცი, ჩემმა გონებამ კი ეგრე გასჭრა და!
— ჩემი გულიც ეგრე მითხრობს, ლუარსაბის სიცოცხლემ!
— იმ ხორბლის მარცვალს რომ ჩააგდებდა ხოლმე წყალში და რაღაცა რგოლები კეთდებოდა, ის ხომ არ იყო?
— იქნება მართლა! სწორედ ის იქნებოდა.
— რა „ის”?
— რომ სთქვი „ისა”.
— აკი გითხარ! — მიუგო ლუარსაბმა თავმოწონებით, რომ მე გამოვიცანიო, — სწორედ ეგრე უნდა იყოს, თორემ ის დედაკაცი ეშმაკი ხომ არ იყო, რომ იმისთანა სასწაული მოეხდინა.
— ეგრე უნდა იყოს, მე კი — ღმერთო, შეგცოდე, — ეშმაკობა შევწამე.
— შენგან არ მიკვირს! ეშმაკი როგორ იქნებოდა, რქები არა ჰქონდა. ეშმაკს რქები უნდა ჰქონდეს.
— ეჰ, განა ეგ მე კი არ ვიცი, ისე გავიფიქრე.
— ჰო, ეგ სხვა არის.
ორივენი დაჩუმდნენ, ორივენი დარწმუნდნენ, რომ რაც გუშინ არ ესმოდათ, მკითხავს რომ უყურებდნენ, ის დღეს გამოიცნეს და გაიგეს.
— მე კი გამოვიცან, აი, — დაიკვეხა ლუარსაბმა. დარეჯანს, თუმცა ლუარსაბი უყვარდა, მაგრამ მაინც კიდევ თითონ უნდოდა, რომ გამოცნობის სახელი ამისი იყოს და არა ლუარსაბისა: კაცი სულელი, თუ ბრძენი, ყოველთვის თავმოყვარეა.
— განა, რომ მდომებოდა, მე კი ვერ გამოვიცნობდი, — მიუგო დარეჯანმა, — არ მინდოდა, თორემ გუშინვე გამოცნობილი მქონდა.
— ეხლა მაგას დაიჟინებ.
— ღმერთმანი, რომ ასეა.
— ეჰ, შენ ხომ კაცი ვერას დაგანახვებს და თუნდ სოლომონ ბრძენი მოვიდეს, მაშინვე ეტყვი: მე შენზედ ჭკვიანი ვარო. ეხლა რა არის, ერთხელ მე დამითმო. უცხო ხომ არა ვარ, შენი ქმარი ვარ.
არ ვიცი, დარეჯანმა დაუთმო, თუ არა, ეს კი ვიცი, რომ ლუარსაბს ძალიან ეწყინა, დარეჯანი რომ შეეცილა.
XIII
მკითხავმა მეტად მტკიცედ დააჯერა ცოლ-ქმარი, რომ შვილი ეყოლებათ. ამ იმედს მცირედი ეჭვიც არ შეურყევდათ. ამ დაჯერებამ იქამდინ მიაღწია, რომ ერთს მშვენიერს დღეს დარეჯანს ეჩვენა, ვითომც მუცელში ყმაწვილმა გაუჩუჩუნა. რასაკვირველია, გახარებულმა კნეინამ მაშინვე ლუარსაბს ახარა.
— მართლა გაიჩუჩუნა? — წამოიძახა სიხარულისაგან გონებამიხდილმა ლუარსაბმა.
— რას ამბობ, შენ გენაცვალოს ჩემი თავი!.. დარბაისელი დედაკაცი სიხარულისაგან კინაღამ არ შევხტი, მაგრამ მომაგონდა, რომ მუცელი წამიხდება-მეთქი, და შენ მაინც კიდევ არა გჯერა.
— უი, შენ კი ჩაგეკონე მაგ გემრიელ სულშია! ბარაქალა, რომ არ შეხტი, თორემ მუცელი წაგიხდებოდა. იმ სიხარულში ეგ როგორღა მოგაგონდა! მე კი — მე და ჩემმა ღმერთმა — შევხტებოდი, მერე ისე შევხტებოდი, რომ დავცემულიყავი, კიტრსავით გავსკდებოდი. დაუდგეს თვალი დავითსა! ფერხული, აბა, ეხლა დაუაროს, აი! მაშ დღეს მე და შენ ერთი კაი ქეიფი გავწიოთ, ერთი კაი წითელი ღვინო ავახდევინოთ, რომ შვილის სადღეგრძელო დავლიოთ. ურაა! — დაიყვირა ლუარსაბმა და, რადგანაც გულდაღმა იწვა, თავისებურად, ტახტზედ, ერთი ფეხიც აიშვირა მაღლა და მანამ “ურა” არ გაათავა, ფეხი არ ჩამოუღია.
ეს ამბავი სადილობის დროს მოხდა. აახდევინეს წითელი ღვინო. ცოლ-ქმარნი, დაჯერებულნი, რომ მემკვიდრე ეყოლებათ და დავითიანთ თვალები დაუდგებათ, სადილზედ გამხიარულდნენ. ნამეტნავად ლუარსაბი შექეიფიანდა და კარგად გამოიბრუჟა. ელისაბედი ამბობდა, რომ ვითომც დარეჯანსაც უყვარსო ღვინის სმა. ეს კი ვიცი, რომ იმ სადილზედ ამანაც გადუსო ორიოდ ჭიქა. ლუარსაბმა სამი ჭიქა ერთად ჯერ არ-დაბადებულის შვილის სადღეგრძელო გადაჰყლაპა და ალავერდი დარეჯანთანაც მივიდა. დარეჯანმა, თუმცა ესეც ჩაღლეული იყო, მაგრამ დედაკაცობის პატივი შეინახა და ჭიქა თუმცა ჩამოართო, სულ არ დალია.
— დალიე, შენ გეთაყვანე! — ეუბნებოდა მთვრალი ლუარსაბი, — ეხლა ქეიფს ნუ წამიხდენ. ჩვენის შვილის სადღეგრძელოს როგორ არა სომ? თუ მე და შენ არ დავლევთ, მაშ ვინ უნდა დალიოს? ღმერთი გვიწყენს, იტყვის: მე შვილი მივეცი და ისინი სადღეგრძელოსაც არა სმენო. ნუ აწყენინებ მოწყალე ღმერთსა, ძლივს კაი თვალით არის ჩვენზედა. მეც ქეიფს ნუ წამიხდენ. დალიე, გეთაყვანე!
უთხრა და მიაწოდა ისევ ჭიქა.
დარეჯანმა ჩამოართო ჭიქა, მაგრამ ისეთის მორცხობით, ისეთის თვალების ხამხამით და გემრიელ ღიმილით, რომ მე მაშინვე მივხვდი, რომ კნეინა უამისოდაც გადაკრულია. ჩამოართო და გადაჰკრა. სასაცილო რამ იყო კნეინა: ღვინო თან-და-თან ეკიდებოდა, ლოყები აუხაშხაშდა კიდეც, ტუჩებს ღიმილი მიეკრა ზედა და აღარა ჰშორდებოდა. ქვევითი ტუჩი ძირს ჩამოეშვა და დორბლმა დენა დაუწყო, თვალები აემღვრა და თავის-თავად ეხუჭებოდა, — ერთის სიტყვით — დარეჯანი ქეიფზედ იყო. ლუარსაბიც დაითვრა. მიუშვა აღვირი ღვინოსაგან მოდუნებულს ენასა და მოჰყვა უგზო-უკვლო ტიტინს, დარეჯანი სულ თავს აცანცარებდა და შესცინოდა.
— ვენაცვალე კახეთსა! — ამბობდა მთვრალი ლუარსაბი ენადაბმით, — ვენაცვალე! ეგ რომ არა ყოფილიყო, არც კახური იქნებოდა. მაშინ მე რაღა კაცი ვიქნებოდი? ჩემს გათქმულ სახელსა მაშინ ვინღა მოიგონებდა? დღეს თუ ლუარსაბის სახელი იხსენება სადმე, ღვინის მადლობელი უნდა ვიყო. თუ კაცი ვარ მე დღეს, აი, ამ შავის ყურძნის წვენითა ვარ კაცი! ჩემოდენას საქართველოში ორიც არ დალევს, დიდი მსმელი ვარ. მე რომ სიმღერა ვიცოდე, მთელის კახეთის ღვინო არ მომერევა. ეს არის რომ არ ვიცი და! სიმღერა ღვინოს ანელებინებს და! თორემ სხვაფრივ რა მიჭირს: ფაშვი კაი მსმელისა მაქვს, აქ თუნდა ოთხი ჩაფი ღვინო ჩაეტევა. ხომ გახსოვს ის იმერელი? აი, რომ მოვიდა, დადიანის „პოვერნია“ ვარო? „პოვერნია“ კი არა, — შენც არ მამიკვდე — ის ძალად გამოგზავნეს იმერლებმა: აბა წადიო, კახეთში ერთი დევი კაცი არისო, ლუარსაბ თათქარიძე, ოღონდ ის კი დაგვითვრეო და ნახევარ იმერეთს შენ მოგცემთო. ეხლა იმან მე რომ დამინახა, მაშინვე მიხვდა, რა კაციცა ვარ, იმიტომ „პოვერნიობა“ დაირქვა, სახელი არ წამიხდესო. კვეხნაში კი ნუ ჩამომართმევ და ჩემი სახელი სათათრემდინ არის გავარდნილი, იმერეთშიაც მისულა ჩემი ქება. მაგრამ აი, ამ შენმა უხეირო ლუარსაბმა ასე გაგიხადე ის ფხიკიანი იმერელი, რომ, რომ... სულ ჩემი მზე ვაფიცებინე. თითონვე თავის პირით მითხრა: ბაყბაყ-დევი ხარო. თითიც მომიკაკვა და ყურში ჩუმად ჩამჩურჩულა: სანაძლევო მოიგეო, ნახევარი იმერეთი შენი უნდა იყოსო. რომ მეჩივლა, რასაკვირველია, იმ ნახევარს გამოვიტანდი, მაგრამ ჩვენი მამა-პაპის მამულებიც მაშინ ისე ოხრადა გვრჩებოდა და იმერეთი რაღად მინდოდა? ეხლა ოხრად აღარ დაგვრჩება: ვენაცვალე შენს სტომაქსა! ეხლა შიგ პატარა თათქარიძე ზის და, მგონია, წითელ ღვინოში ჭყუპალაობს. უჰ, შენი კი ჭირიმე! მოდი ერთი ეგ ნაზი ტუჩები ამოგწუწნო! ეხლა ეგეც ხომ შვილი გვეყოლა, აბა ეხლა მაგის ქორწილზედ ვიფიქროთ. იცი, რა, დარეჯან? შენ ხომ ბრძენი დედაკაცი ხარ და არც მე ვარ — ღვთის მადლით — სულელი, თოთხმეტის წლისა შესრულდება თუ არა — აბა, იანგარიშე, როდის შესრულდება, მგონი ბევრი ხანი არ გასწევს, მალე შესრულდება, — შესრულდება თუ არა, ჯვარიც დავწეროთ, რაღას უნდა მოვუცადოთ? ეხლა მაგის ქორწილში ლეკურს არ ჩამოუვლი? მე კი — ღვთის წყალობა შენა გაქვს — ასეთს ბუქნას დავუვლი, რომ იქაურობას სულ მტვერი ავადინო... ეხლა იმ იმერელს რომ ვაჯობე, იცი, რა ვუთხარი? წადი-მეთქი, სადაც შენი სთქვა, იქ ჩვენიცა სთქვი-მეთქი, და იმერლებსაც უთხარი, რომ, რაც თქვენ კრიკინას წვენი გამოუვა, ერთ „ყლაპად“ არ მეყოფა-თქო, და „ყლუპი“ კი კიდევ თქვენზედ დარჩება-თქო. აი, ამისთანა კაცები ვართ კახეთში-მეთქი. მაშ!.. თუ ღმერთი გწამს — კარგად არ მითქვამს?
— კარგად და პატიოსნად.
— მაშ, მოდი ერთი კიდევ ამოვწუწნო ეგ შენი მარწყვი ლოყები. ეხლა, დარეჯან, შვილის ქორწილში ლეკურს არ ითამაშებ?
— რატომ.
— ჰო, გეთაყვანე! მოდი, იცი, რა ვქნათ? მითამ ეხლა ქორწილია: აბა ერთი... ერთი შენებური დიდოური... მე „განდიდურს“ დაგძახებ. თუ გიყვარდე, აი! მითამ ქორწილია. თუნდა ლეკური იყოს, ჰა! მე „პაწპაწინა ნიგვზის ტოტს“ დაგძახებ. ჰა და პაწპაწინა ნიგვზის ტოტი! პაწპაწინა ნიგვზის ტოტი! ჩუპრი-ჩუპარ, ჩუპრი-ჩუპარ, ჩუპრი დარეჯანასა!.. ურაა!.. აი, გიდი!.. ქუდი ჭერში!.. კახური კა... ცის... ჭი... რი... იი... მეე... ჩა... აა... რაკ... რაა... კებს... კუ... უუ... ლა... სა... იმ იმერელსაც... კაი... საქმე... დავმარ... დავითსაც... თვალიმც... გამოს... ძრო... მია... ურაა!..
ყროყინებდა სიმღერის ხმაზედ გაბრუჟებული ლუარსაბი, ჰბოდავდა რაღაცეებსა და ამ ბოდვაში ჩაეძინა კიდეცა.
XIV
აღარ გაათავებ? — მკითხავს მოწყენილი, და იქნება გაჯავრებულიც, მკითხველი. — როგორ არა? გავათავებ, მაგრამ იცით რითა? იმითი, რომ ლუარსაბის ბედნიერება დაირღვევა. თუ მაგისთანა მტკიცე ბედნიერებაც დაირღვევა, მაშ რაღა ყოფილა დაურღვეველი ქვეყანაზედ? — დაიძახებს ჩემთან ერთხმად დაღონებული მკითხველი.
მარტო ქვეყანაა, მკითხველო, დაურღვეველი, და ერთი ლამაზი, გონიერი ქართვლის ანდაზა: „ის ურჩევნია მამულსა, რომ შვილი სჯობდეს მამასა“, თორემ „ნუ დააგდებ ძველსა გზასაო“ — ეს ჩინეთიდამ შემოგვეპარა და რასაც ჩინეთის ფერი ადევს, ის რასაკვირველია, დაირღვევა ღვთისა და თქვენის წყალობითა, ჩემო ძველის გზის მოყვარევ, მაგრამ მაინც კიდევ საყვარელო ქართველო!..
გაიარა რაოდენმამე ჟამმა და წუთის-სოფლის დაუდგრომელმა ბრუნვამ ბევრი რამ გამოსცვალა დედამიწის ზურგზედ. ამათ შვილი არ მიეცათ. დარეჯანმა ერთი აქიმი დედაკაცი იშოვა და წამლობა დაიწყო, აქიმმა დედაკაცმა ერთი რაღაც წამალი მისცა, მთელი ორი კვირა ასმევდა და მესამე კვირას კი დარეჯანს ფეხები გააჭიმინა. დარჩა ქვრივად საწყალი ლუარსაბი. წვერი დაიყენა, შავები ჩაიცვა. თავისი ბედნიერება სულ დარეჯანთან დამარხა. ორი სიამოვნებაღა დარჩა ამ ტრიალ ქვეყანაზედ: ერთი — მადა; მეორე ისა, რომ ლამაზისეული ფეხთ უჯდა ხოლმე, როცა ძილს დააპირებდა ბატონი, ფეხის გულებზედ და კანჭებზედ ხელს უსვამდა და ისე აძინებდა. ესღა იყო ამისათვის ნუგეშად, თორემ ის პატიოსანი ფაშვი ჩამოებღერტა, ის ხაშხაში ლოყები ჩაუყვითლდა, ის დიდრონი ძროხის ოდენა თვალები უგემურად მიელივა, ის სამკეცი ფაფუკი ღაბაბი გუდა ლეღვსავით გაუხდა, ამასთანაც ის თავისებური განსხვავებითი მუდამი ღიმილი სახიდამ დაეკარგა, — ერთის სიტყვით, წახდა კაკალი კაცი. მწუხარებამ ესე იცის. ბოლოს, ფერისცვალობის დღეს, რაღაც ეშმაკად, ნათლიმამამ ნახევარი ლიტრა კალმახი მოართვა. ჯავრისაგან იმ კალმახს ლაზათიანად მიაძღა, მოუვიდა კუჭის ანთება და ჩაჰბარდა პატრონსა.
მოკვდა ლუარსაბიცა ისე, როგორც იხოცებიან ბევრნი ჩვენგანნი, რომელნიც არც თავის სიცოცხლით უმატებენ რასმეს ქვეყანასა და არც თავის სიკვდილით აკლებენ.
წაიშალა ამ ორთა გვამთა ცხოვრების კვალი დედამიწის ზურგზედა. რისთვის მოვიდნენ და რისთვის წავიდნენ? ნუთუ ნახევარი საუკუნე იმისთვის იცხოვრეს, რომ ოთხი ფიჭვის ფიცარი ეშოვნათ და სამ-სამი ადლი მიწა? ან კიდევ ქვაზედ წაიწერონ, რომ „ჩყ... წლამდინ თავადი ლუარსაბი თათქარიძე და მისი კნეინა დარეჯანი ცოცხალნი ყოფილან და მერე დახოცილან?“ სხვა ხომ არაფერი გვეტყვის, რომ ესენი ამ ქვეყანაში ყოფილან და უცხოვრიათ. „წამკითხველო, შენდობა გვიბძანეთო“, ამბობს იმათი ქვის ზედწარწერილი. ნახევარი საუკუნე ამისთვის იცხოვრეს ამ ქვეყანაზედ, რომ ბოლოს მაინც კიდევ „შენდობა“ ითხოვონ და საბოდიშოდ გაიხადონ საქმე? უფროსთაგანს ქართვლის საფლავის ქვას რომ აწერია „შენდობა გვიბძანეთო“, ეხლა მესმის, რისთვისაც აწერია. მაგ შესანდობარს და შესაბრალისს ჩვეულებას თავისი აზრი და საფუძველი ჰქონია, მაგრამ არ გითარგმნი კი, მკითხველო! თუ კაი გული გაქვს და გამჭრე გონება შენც თითონ ჩემზედ უკეთესად მიხვდები, თუ არა და, თქმა საჭირო არ არის. ტყუილად გულს გატკენ, გაგარისხებ და ის რისხვა ისე აგიბამს თვალსა, რომ სხვას შენზედ მეტადაც რომ გული სტკიოდეს, ამას ვეღარ დაინახავ და იმის გულის სატკენ სიტყვას მუხანათობაში ჩამოართმევ.
მე გავათავე და შენ, რაც გინდა, ჰქმენ, მკითხველო! გინდა იცინე, გინდა იტირე, როცა ამ ამბავს წაიკითხავ. ორივეს საბუთი ისევ ამავე მოთხრობაში გაქვს. თუ ოდესმე თვალი აგიხილებია და შენს გარშემო რაც გინახავს, იმაზედ გონება გივარჯიშებია, — ნახავდი, რომ ხშირად ერთი და იგივე საგანი ზოგს აცინებს, ზოგს ატირებს. მე მინახავს ერთი მოხუცებული, ღარიბი, შიშველ-ტიტველი, ფეხებდახეთქილი დედაკაცი. ვინ იცის, რა-გვარ უბედურობისაგან ლოთად ჩავარდნილიყო და ლოთობაში სამუდამოდ დაეკარგა თავისი დედაკაცობა და ადამიანობა. მე მინახავს ის საცოდავი დედაკაცი, ქალაქის ბიჭებს დაეჭირათ და ხუთ გროშად მთელი საათი ახტუნებდნენ პამპულასავით. მე მინახავს, რომ იმათში ბევრი იცინოდა და ზოგიერთს კი ამ საცოდავის დედაკაცის მაგ ყოფაზედ გული უტიროდათ. ვინ იყო ამათში მართალი? მოცინარენი, თუ მოტირალენი? ორივენი, იმიტომ რომ ერთნი თვალითა ჰხედავდნენ მარტო და თვალისათვის მართლა სასაცილო იყო, მეორენი კი თვალითაცა და გონებითაცა. გონებას-კი — ძნელად თუ გაეცინება. სჩანს, შეიძლება, რომ ერთი და იგივე ამბავი სატირალიც იყოს და საცინარიცა, — ეგ იმაზედ არის დამოკიდებული, როგორი აგებულებისა ხარ: თუ იმისთანა გონების ძალა გაქვს, რომ, რაც უნდა მწუხარე ჭეშმარიტება იყოს, გულდაგულ შეხვდები, და თუ იმისთანა გულიცა გაქვს, რომ უბედურს და გზა-კვალ-არეულს შეიბრალებ, ამისთანა სასაცილო ამბავი უფრო ხშირად უნდა გატირებდეს შენა, თუ არა და იცინე, რამდენიც გენებოს. იცინე და თანაც გაჯავრდი ამ მოთხრობის დამწერზედ და მამიგონე ჭორი — შენ ხომ ჭორების მოგონება გიყვარს — რომ მე ვითომც ქართველობას ვღალატობ, რადგანაც იმის სასაცილო ამბავს გიამბობ და არა ვმალავ ზოგიერთ გულ-მოკლე პატრიოტივით. ვიცი, რომ, ჩვენდა საუბედუროდ, თქვენში, მკითხველო, ძნელად იპოვება იმისთანა კაცი, რომ მართალს სიტყვას გონება გაუსწოროს. ვიცი ეს და მაინც კიდევ პირში — როგორც მოყვარე — გეტყვი, რომ ლუარსაბი და დარეჯანი შენს კალთაში დაბადებულან და შენის ძუძუთი გაზრდილან. გინდა მიწყინე, გინდა არა. თუ იმათ დასცინებ, მითამ შენის თავისთვის დაგიცინია, თუ დასტირებ — ეგ კაი ნიშანია: სჩანს, სწუხხარ, რომ ამისთანანი ვართ, სჩანს, შენის თავის გასწორების განზრახვამ ფრთა აიბა. ღმერთმა ქნას, რომ ეგ აგრე იყოს.
მე თუ შენ მიყვარხარ, მკითხველო, იმისთვის მიყვარხარ, რომ იმედი მაქვს ეგ გასწორების განზრახვა, დღესა თუ ხვალე, შენში გაიღვიძებს. ამ იმედს ნუ წაგვართმევ. ნუ იფიქრებ, რომ ამ მოთხრობას შენი გაჯავრება უნდა. ამას მარტო ის უნდა, რომ შენ დაგანახვოს — რამოდენადაც შეძლება აქვს-შენი ცუდი, შენი ავი, რომ იცოდე, რა გაისწორო. მინამ სარკეში არ ჩაიხედავ, ან სხვა არ გეტყვის, ხომ ვერ გაიგებ, რომ პირზედ ურიგობა რამ გატყვია? ეს მოთხრობა სარკე იყოს და მე — თუ გინდა — მთქმელი ვიქნები. დააკვირდი, იქნება გენიშნოს რამე. ესეც იცოდე: მარტო შენი მტერი დაგიმალავს, შენს სახეზედ რომ ურიგობა ჰნახოს რამე, მოყვარე კი მაშინვე სარკეს მოგიტანს, რომ გაისწორო და ხალხში არ შერცხვე. მეც მოყვარესავით გექცევი, — სარკე მოგიტანე, ამაზედ როგორ უნდა გამიწყრე?! რა ვუყოთ, თუ ეს სარკე გაბზარული გამოდგება და შიგა-და-შიგ ლაქებიანიცა? რაცა მქონდა ის მოგართვი, როგორც შემეძლო, ისე დაგეხმარე. თუ მაინც-და-მაინც წყრომას არ დაიშლი, შენი ნებაა. მე შენის წყრომისა არ მეშინიან. მაშინ მხოლოდ დავღონდები, რომ შენშიაც მოვტყუვდი; რომ შენ ის არა ჰყოფილხარ, რაც მეგონე. მაშინ გულ-ხელ-დაკრებილს ესღა დამრჩება სათქმელად: მე მიყივლია და გათენდება თუ არა — ეგ ღმერთმა იცის! წყრომა კი რომ არა ყოფილიყო, ეგ გათენება, ჩვენც კარგად გვეცოდინებოდა, როდისაც იქნებოდა!..
სხვაფრივ მშვიდობით ბძანდებოდეთ და შენდობით იხსენიებდეთ მონასა თქვენსა...
1858 - 1863 წ.
∗ ჩვენში ბევრსა სწამს, რომ თუ ვინც პირველად ქალაქში ჩადის და კენჭს არ ჩაჰყლაპავს, ქალაქი დასცდისო. მეც, ამის დამწერს, გადამაყლაპეს ერთს დროს.
∗ არის ამისთანა ამაოთმორწმუნება ჩვენში, რომ თუ ღვინო დალეული არ შეხვდა პირველად მერცხალს, მერცხალი დაგძლევს. კვიცი რომ დაინახო, მაშინვე ქვაზედ უნდა შედგე, თორემ დაძლეული იქნები, ოფოფს თავდავარცხნილი უნდა დახვდე და სხვა. ლუარსაბს, როგორც ათასს სხვას, ეს დაძლევა ცოდვა ჰგონია, ამიტომაც ეგრე გულმოდგინედ დავითს ღმერთთან აბეზღებს.
∗ პირვანდელი ესკიზი მოთხრობისა ( — ნაწყვეტში „კაკო“) — ეკუთვნის 1858 — 1859 წ.წ. ხოლო ბოლო რედაქცია შესრულებულია 1863 წელს. რედ.
EOT;
}
