<?php if ( !defined( 'ABSPATH' ) ) exit();

	$id = get_the_id();

	$feature_image   = wp_get_attachment_image_url(get_post_thumbnail_id() , 'ova_collection_thumbnail' );
	if ( is_post_type_archive( 'collection' ) || is_tax( 'collection_type' ) ) { 
		$feature_image  = wp_get_attachment_image_url(get_post_thumbnail_id() , 'large' );
	}
	if ( $feature_image == '') {
	    $feature_image  =  \Elementor\Utils::get_placeholder_image_src();
	}

	$collection_year_number = get_post_meta( $id, 'collection_year_number', true );

	// Artist
	$collection_artist  = get_post_meta( $id, 'collection_artist', true );

	$args_artist = array(
		'post_type'      => 'artist',
		'posts_per_page' => '-1',
		'post_name__in'  => $collection_artist,
	);

	if ( is_plugin_active('sitepress-multilingual-cms/sitepress.php') ) {
		$args_artist['suppress_filters'] = false;
	}

	$artists = get_posts( $args_artist );

	$value_artist = '';

	// Collection type ( categories )
	$categories = get_the_terms($id, 'collection_type');

	// show fields
	$show_year   = isset($args['show_year']) ? $args['show_year'] : 'yes';
	$show_type   = isset($args['show_type']) ? $args['show_type'] : 'yes';
	$show_title  = isset($args['show_title']) ? $args['show_title'] : 'yes';
	$show_artist = isset($args['show_artist']) ? $args['show_artist'] : 'yes';

?>

<div class="items_archive_coll">
	<div class="wrapper-content">

		<div class="img">
			<a href="<?php the_permalink() ?>">
				<img src="<?php echo esc_url( $feature_image ); ?>" alt="<?php the_title(); ?>" class="collection-feature-image">
			</a>
			<?php if( $collection_year_number  && $show_year == 'yes'){ ?>
				<span class="year">
					<?php echo esc_attr( $collection_year_number ); ?>
				</span>
			<?php } ?>
		</div>

		<?php if( $show_type == 'yes' || $show_title == 'yes' || $show_artist == 'yes' ) { ?>
			<div class="desc">
				<?php if( !empty($categories) && is_array($categories) && $show_type == 'yes' ) { ?>
					<div class="categories">
			    		<span class="value">
			    			<?php $category_first_link = get_term_link($categories[0]->term_id);
						        if ( $category_first_link ) {
						        	echo '<a href="'.esc_url( $category_first_link ).'" title="'.esc_attr($categories[0]->name).'">'.$categories[0]->name.'</a>';
						        }
							?>
			    		</span>
			    	</div>
			    <?php } ?>

			    <?php if( $show_title == 'yes'){ ?>
					<h2 class="title">
						<a href="<?php the_permalink(); ?>">
							<?php echo get_the_title(); ?>
						</a>
					</h2>
				 <?php } ?>

				<?php if( !empty($artists) && is_array($artists) && $show_artist == 'yes' ) { ?>
					<div class="artists">
						<?php foreach ($artists as $value) {
								$artist_id = $value->ID;
								$artist_link = get_the_permalink( $artist_id );
								$artist_title = get_the_title( $artist_id );
								$artist_image = wp_get_attachment_image_url( get_post_thumbnail_id($artist_id), '' );
							
								$value_artist .= '<img src="'.$artist_image.'" alt="'.$artist_title.'"><a href=" '.$artist_link.' ">'.$artist_title.'</a>'.', ' ;
							}
							echo substr($value_artist, 0, -2) ;
						?>
					</div>
				<?php } ?>
			</div>
		<?php } ?>

	</div>
</div>