<?php if ( !defined( 'ABSPATH' ) ) exit();
	get_header( );
	global $post;

	$collection_type = isset( $_GET['collection_type'] ) ? $_GET['collection_type'] : OVACOLL_Settings::archive_collection_type();
	$related_heading = OVACOLL_Settings::single_artist_related_heading();

	// show fields
	$show_image     	= OVACOLL_Settings::single_artist_show_image();
	$show_title     	= OVACOLL_Settings::single_artist_show_title();
	$show_skill     	= OVACOLL_Settings::single_artist_show_skill();
	$show_phone     	= OVACOLL_Settings::single_artist_show_phone();
	$show_email     	= OVACOLL_Settings::single_artist_show_email();
	$show_content   	= OVACOLL_Settings::single_artist_show_content();
	$show_some_of_works = OVACOLL_Settings::single_artist_show_some_of_works();

if ( have_posts() ) : while( have_posts() ) : the_post();
	$slug_artist 	= $post->post_name;
	$id 			= get_the_id();
	$artist_skill 	= get_post_meta( $id, 'artist_skill', true ) ? $artist_skill = get_post_meta( $id, 'artist_skill', true ) : '';
	$artist_phone 	= get_post_meta( $id, 'artist_phone', true ) ? $artist_phone = get_post_meta( $id, 'artist_phone', true ) : '';
	$artist_email 	= get_post_meta( $id, 'artist_email', true ) ? $artist_email = get_post_meta( $id, 'artist_email', true ) : '';
	$artist_page 	= get_post_meta( $id, 'artist_page', true ) ? get_post_meta( $id, 'artist_page', true ) : 'default';
	$collections 	= apply_filters( 'OVACOLL_collection_get', $slug_artist );
?>
	
	<div class="row_site">
		<div class="container_site">

			<div class="single_artist">
				<div class="intro">
					<?php if ( $show_image == 'yes' ) { ?>
						<div class="image">
							<?php the_post_thumbnail(''); ?>
						</div>
					<?php } ?>

					<div class="desc">
						<?php if ( $show_title == 'yes' ) { ?>
							<h2 class="name second_font">
								<?php echo get_the_title(); ?>
							</h2>
						<?php } ?>

						<?php if ( $artist_skill != '' && $show_skill == 'yes' ) { ?>
							<div class="skill">
								<?php echo esc_html( $artist_skill ); ?>
							</div>
						<?php } ?>

						<?php if ( $artist_phone != '' && $show_phone == 'yes' ) { ?>
							<a class="contact phone" href="tel:<?php echo preg_replace('/\s+/', '', $artist_phone);  ?>">
								<?php echo esc_html( $artist_phone ); ?>
							</a>
						<?php } ?>

						<?php if ($artist_email != '' && $show_email == 'yes') { ?>
							<a class="contact email" href="mailto:<?php echo esc_html($artist_email); ?>">
								<?php echo esc_html( $artist_email ); ?>
							</a>
						<?php } ?>

						<?php if ( $show_content == 'yes' ) { ?>
							<div class="content">
								<?php the_content(); ?>	
							</div>
						<?php } ?>
					</div>
				</div>

				<?php if ( !empty( $artist_page ) && $artist_page != 'default' && get_post_status( $artist_page ) == 'publish' ): ?>
					<div class="section_element_artist">
						<div class="container">
							<?php echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $artist_page ); ?>
						</div>
					</div>
				<?php endif; ?>

				<?php if ( $collections->have_posts() && $show_some_of_works == 'yes' ) { ?>
					<div class="work">
						<?php if( !empty( $related_heading ) ) { ?>
							<h2 class="related-title">
								<?php echo esc_html($related_heading);  ?>	
							</h2>
						<?php } ?>

						<div class="content_archive_coll <?php echo esc_attr( $collection_type );?>">
							<?php while ( $collections->have_posts() ) : $collections->the_post(); 
								ovacoll_get_template( 'parts/item-collection.php' );
							endwhile; wp_reset_postdata(); ?>
						</div>
					</div>
				<?php } ?>

				<?php
					if ( comments_open() || get_comments_number() ) {
						comments_template();
					}
				?>
			</div>
			
		</div>
	</div>

<?php endwhile; endif; wp_reset_postdata();?>

<?php get_footer( );