(function( $ ){
	'use strict';

	$(document).ready(function(){
		/* Select2*/
	    if ($('.ovadep_cat').length > 0) {
	      	$('.ovadep_cat').select2({
	      		language: {
	                inputTooShort: function() {
	                    return Select2Text.input_short;
	                },
	                noResults: function (params) {
	                  return Select2Text.no_results;
	                }
	            }
	      	});
	    };

	    /* Auto completed name - search form archive */
	    var data_names = $('.search_archive_department').data('names');

	    var data = [];
		for(var id in data_names){
		    var child_data = {"id": id, "text": data_names[id]};
		    data.push(child_data);
		}

		if ($('.search_archive_department .ovadep_name').length > 0) { 
			$('.search_archive_department .ovadep_name').select2({
		    	data: data,
		    	minimumInputLength: 1,
		    	maximumSelectionSize: 1,
		    	width: '100%',
		    	placeholder: Placeholder.name,
		    	language: {
	                inputTooShort: function() {
	                    return Select2Text.input_short;
	                },
	                noResults: function (params) {
	                  return Select2Text.no_results;
	                }
	            }
		    });
		}

	    $('.search_archive_department .ovadep_name').on('change', function(e){
	    	e.preventDefault();
	    	var value = $(this).find("option:selected").text();
	        $(this).val(value);
	        $(this).find('option:selected').prop("selected", false);
	    });
	  

    });

})(jQuery);