<?php

namespace ova_dep_elementor;

use ova_dep_elementor\widgets\ova_dep_list_file;
use ova_dep_elementor\widgets\ova_list_dep;
use ova_dep_elementor\widgets\ova_list_dep_name;
use ova_dep_elementor\widgets\ova_archive_dep;
use ova_dep_elementor\widgets\ova_archive_dep_slide;
use ova_dep_elementor\widgets\ova_dep_info;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


/**
 * Main Plugin Class
 *
 * Register new elementor widget.
 *
 * @since 1.0.0
 */
class Ova_Dep_Register_Elementor {

	/**
	 * Constructor
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function __construct() {
		$this->add_actions();
	}

	/**
	 * Add Actions
	 *
	 * @since 1.0.0
	 *
	 * @access private
	 */
	private function add_actions() {

	    // Register Ovatheme Category in Pane
	    add_action( 'elementor/elements/categories_registered', array( $this, 'add_ovatheme_dep_category' ) );
		
		add_action( 'elementor/widgets/register', [ $this, 'on_widgets_registered' ] );

	}

	
	public function add_ovatheme_dep_category(  ) {

	    \Elementor\Plugin::instance()->elements_manager->add_category(
	        'ovatheme_dep',
	        [
	            'title' => __( 'Ovatheme Department', 'ova-team' ),
	            'icon' => 'fa fa-plug',
	        ]
	    );

	}


	/**
	 * On Widgets Registered
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function on_widgets_registered() {
		$this->includes();
		$this->register_widget();
	}

	/**
	 * Includes
	 *
	 * @since 1.0.0
	 *
	 * @access private
	 */
	private function includes() {


		require OVADEP_PLUGIN_PATH . 'elementor/widgets/ova_dep_list_file.php';
		require OVADEP_PLUGIN_PATH . 'elementor/widgets/ova_list_dep.php';
		require OVADEP_PLUGIN_PATH . 'elementor/widgets/ova_list_dep_name.php';
		require OVADEP_PLUGIN_PATH . 'elementor/widgets/ova_archive_dep.php';
		require OVADEP_PLUGIN_PATH . 'elementor/widgets/ova_archive_dep_slide.php';
		require OVADEP_PLUGIN_PATH . 'elementor/widgets/ova_dep_info.php';
	}

	/**
	 * Register Widget
	 *
	 * @since 1.0.0
	 *
	 * @access private
	 */
	private function register_widget() {

		\Elementor\Plugin::instance()->widgets_manager->register( new ova_dep_list_file() );
		\Elementor\Plugin::instance()->widgets_manager->register( new ova_list_dep() );
		\Elementor\Plugin::instance()->widgets_manager->register( new ova_list_dep_name() );
		\Elementor\Plugin::instance()->widgets_manager->register( new ova_archive_dep() );
		\Elementor\Plugin::instance()->widgets_manager->register( new ova_archive_dep_slide() );
		\Elementor\Plugin::instance()->widgets_manager->register( new ova_dep_info() );

	}
	    
	

}

new Ova_Dep_Register_Elementor();