<?php 

if( !defined( 'ABSPATH' ) ) exit();

if( !class_exists( 'OVADIR_custom_post_type' ) ) {

	class OVADIR_custom_post_type{

		public function __construct(){
			add_action( 'init', array( $this, 'OVADIR_register_post_type_ova_dir' ) );
			add_action( 'init', array( $this, 'OVADIR_register_taxonomy_ova_dir' ) );
			add_action( 'init', array( $this, 'OVADIR_register_taxonomy_tag_ova_dir' ) );
		}

		
		function OVADIR_register_post_type_ova_dir() {

			$taxonomies = array('cat_dir');

			$labels = array(
				'name'                  => _x( 'Directories', 'Post Type General Name', 'ova-dir' ),
				'singular_name'         => _x( 'Directory', 'Post Type Singular Name', 'ova-dir' ),
				'menu_name'             => __( 'Directory', 'ova-dir' ),
				'name_admin_bar'        => __( 'Directory', 'ova-dir' ),
				'archives'              => __( 'Item Archives', 'ova-dir' ),
				'attributes'            => __( 'Item Attributes', 'ova-dir' ),
				'parent_item_colon'     => __( 'Parent Item:', 'ova-dir' ),
				'all_items'             => __( 'All Directories', 'ova-dir' ),
				'add_new_item'          => __( 'Add New Directory', 'ova-dir' ),
				'add_new'               => __( 'Add New', 'ova-dir' ),
				'new_item'              => __( 'New Item', 'ova-dir' ),
				'edit_item'             => __( 'Edit Directory', 'ova-dir' ),
				'view_item'             => __( 'View Item', 'ova-dir' ),
				'view_items'            => __( 'View Items', 'ova-dir' ),
				'search_items'          => __( 'Search Item', 'ova-dir' ),
				'not_found'             => __( 'Not found', 'ova-dir' ),
				'not_found_in_trash'    => __( 'Not found in Trash', 'ova-dir' ),
			);
			$args = array(
				'description'         => __( 'Post Type Description', 'ova-dir' ),
				'labels'              => $labels,
				'supports'            => array( 'title', 'editor', 'comments', 'thumbnail', 'excerpt' ),
				'taxonomies'          => $taxonomies,
				'hierarchical'        => false,
				'public'              => true,
				'show_ui'             => true,
				'show_in_rest'        => true,
				'menu_position'       => 20,
				'menu_icon' 		  => 'dashicons-location-alt',
				'query_var'           => true,
				'has_archive'         => true,
				'exclude_from_search' => true,
				'publicly_queryable'  => true,
				'rewrite'             => array( 'slug' => _x( 'ova_dir', 'URL slug', 'ova-dir' ) ),
				'capability_type'     => 'post',
			);
			register_post_type( 'ova_dir', $args );
		}

		function OVADIR_register_taxonomy_ova_dir(){

			$labels = array(
				'name'                       => _x( 'Directory Categories', 'Post Type General Name', 'ova-dir' ),
				'singular_name'              => _x( 'Category Directory', 'Post Type Singular Name', 'ova-dir' ),
				'menu_name'                  => __( 'Categories', 'ova-dir' ),
				'all_items'                  => __( 'All Category Directory', 'ova-dir' ),
				'parent_item'                => __( 'Parent Item', 'ova-dir' ),
				'parent_item_colon'          => __( 'Parent Item:', 'ova-dir' ),
				'new_item_name'              => __( 'New Item Name', 'ova-dir' ),
				'add_new_item'               => __( 'Add New Category', 'ova-dir' ),
				'add_new'                    => __( 'Add New Category', 'ova-dir' ),
				'edit_item'                  => __( 'Edit Category', 'ova-dir' ),
				'view_item'                  => __( 'View Item', 'ova-dir' ),
				'separate_items_with_commas' => __( 'Separate items with commas', 'ova-dir' ),
				'add_or_remove_items'        => __( 'Add or remove items', 'ova-dir' ),
				'choose_from_most_used'      => __( 'Choose from the most used', 'ova-dir' ),
				'popular_items'              => __( 'Popular Items', 'ova-dir' ),
				'search_items'               => __( 'Search Items', 'ova-dir' ),
				'not_found'                  => __( 'Not Found', 'ova-dir' ),
				'no_terms'                   => __( 'No items', 'ova-dir' ),
				'items_list'                 => __( 'Items list', 'ova-dir' ),
				'items_list_navigation'      => __( 'Items list navigation', 'ova-dir' ),

			);
			$args = array(
				'labels'            => $labels,
				'hierarchical'      => true,
				'publicly_queryable' => true,
				'public'            => true,
				'show_ui'           => true,
				'show_in_rest'      => true,
				'show_admin_column' => true,
				'show_in_nav_menus' => true,
				'show_tagcloud'     => false,
				'rewrite'            => array(
					'slug'       => _x( 'cat_dir','Directory Category Slug', 'ova-dir' ),
					'with_front' => false,
					'feeds'      => true,
				),
			);
			register_taxonomy( 'cat_dir', array( 'ova_dir' ), $args );
		}

		function OVADIR_register_taxonomy_tag_ova_dir(){

			$labels = array(
				'name'                       => _x( 'Directory Tags', 'Post Type General Name', 'ova-dir' ),
				'singular_name'              => _x( 'Tag Directory', 'Post Type Singular Name', 'ova-dir' ),
				'menu_name'                  => __( 'Tags', 'ova-dir' ),
				'all_items'                  => __( 'All Tag Directory', 'ova-dir' ),
				'parent_item'                => __( 'Parent Item', 'ova-dir' ),
				'parent_item_colon'          => __( 'Parent Item:', 'ova-dir' ),
				'new_item_name'              => __( 'New Item Name', 'ova-dir' ),
				'add_new_item'               => __( 'Add New Tag', 'ova-dir' ),
				'add_new'                    => __( 'Add New Tag', 'ova-dir' ),
				'edit_item'                  => __( 'Edit Tag', 'ova-dir' ),
				'view_item'                  => __( 'View Item', 'ova-dir' ),
				'separate_items_with_commas' => __( 'Separate items with commas', 'ova-dir' ),
				'add_or_remove_items'        => __( 'Add or remove items', 'ova-dir' ),
				'choose_from_most_used'      => __( 'Choose from the most used', 'ova-dir' ),
				'popular_items'              => __( 'Popular Items', 'ova-dir' ),
				'search_items'               => __( 'Search Items', 'ova-dir' ),
				'not_found'                  => __( 'Not Found', 'ova-dir' ),
				'no_terms'                   => __( 'No items', 'ova-dir' ),
				'items_list'                 => __( 'Items list', 'ova-dir' ),
				'items_list_navigation'      => __( 'Items list navigation', 'ova-dir' ),

			);
			$args = array(
				'labels'            => $labels,
				'hierarchical'      => true,
				'publicly_queryable' => true,
				'public'            => true,
				'show_ui'           => true,
				'show_in_rest'      => true,
				'show_admin_column' => true,
				'show_in_nav_menus' => true,
				'show_tagcloud'     => false,
				'rewrite'            => array(
					'slug'       => _x( 'tag_dir','Directory Tag Slug', 'ova-dir' ),
					'with_front' => false,
					'feeds'      => true,
				),
			);
			register_taxonomy( 'tag_dir', array( 'ova_dir' ), $args );
		}
	}

	new OVADIR_custom_post_type();
}