<?php

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

if( !function_exists( 'ovadir_locate_template' ) ){
	function ovadir_locate_template( $template_name, $template_path = '', $default_path = '' ) {
		
		// Set variable to search in ovacoll-templates folder of theme.
		if ( ! $template_path ) :
			$template_path = 'ovadir-templates/';
		endif;

		// Set default plugin templates path.
		if ( ! $default_path ) :
			$default_path = OVADIR_PLUGIN_PATH . 'templates/'; // Path to the template folder
		endif;

		// Search template file in theme folder.
		$template = locate_template( array(
			$template_path . $template_name
			// $template_name
		) );

		// Get plugins template file.
		if ( ! $template ) :
			$template = $default_path . $template_name;
		endif;

		return apply_filters( 'ovadir_locate_template', $template, $template_name, $template_path, $default_path );
	}

}


function ovadir_get_template( $template_name, $args = array(), $tempate_path = '', $default_path = '' ) {
	if ( is_array( $args ) && isset( $args ) ) :
		extract( $args );
	endif;
	$template_file = ovadir_locate_template( $template_name, $tempate_path, $default_path );
	if ( ! file_exists( $template_file ) ) :
		_doing_it_wrong( __FUNCTION__, sprintf( '<code>%s</code> does not exist.', $template_file ), '1.0.0' );
		return;
	endif;

	
	include $template_file;
}


add_filter( 'gimont_header_customize', 'gimont_header_customize_dir', 10, 1 );
function gimont_header_customize_dir( $header ){


	if( is_tax( 'cat_dir' ) ||  get_query_var( 'cat_dir' ) != '' || is_post_type_archive( 'ova_dir' ) ){

	  	$header = get_theme_mod( 'header_archive_dir', 'default' );

	}else if( is_singular( 'ova_dir' ) ){

		$header = get_theme_mod( 'header_single_dir', 'default' );
	}

	return $header;

}


add_filter( 'gimont_footer_customize', 'gimont_footer_customize_dir', 10, 1 );
function gimont_footer_customize_dir( $footer ){
    
   if( is_tax( 'cat_dir' ) ||  get_query_var( 'cat_dir' ) != '' || is_post_type_archive( 'ova_dir' ) ){

        $footer = get_theme_mod( 'archive_footer_dir', 'default' );

    }else if( is_singular( 'ova_dir' ) ){

        $footer = get_theme_mod( 'single_footer_dir', 'default' );
    }

    return $footer;

}