<?php if ( !defined( 'ABSPATH' ) ) exit();
get_header(); 

	global $wp_query;
	$sidebar 	= get_theme_mod( 'ova_dir_archive_sidebar', 'right_sidebar' );
	$column 	= get_theme_mod( 'ova_dir_layout', 'two_column' );

	// show fields
	$args_show = array(
		'show_map'   	=> get_theme_mod( 'ova_dir_archive_show_map', 'yes' ),
		'show_image' 	=> get_theme_mod( 'ova_dir_archive_show_image', 'yes' ),
		'show_title' 	=> get_theme_mod( 'ova_dir_archive_show_title', 'yes' ),
		'show_location' => get_theme_mod( 'ova_dir_archive_show_location', 'yes' ),
		'show_category' => get_theme_mod( 'ova_dir_archive_show_category', 'yes' ),
		'show_link_to'  => get_theme_mod( 'ova_dir_archive_show_link_to', 'yes' ),
	);
?>

<div class="ova-dir-archive <?php echo esc_attr( $column ); ?>">
	<div class="container">
		<div class="row_site">
			<div class="container_site">

				<div class="ova-dir-wrapper <?php printf( '%1$s', $sidebar ); ?>">
					<?php if ( $sidebar == 'left_sidebar' && is_active_sidebar( 'ova-dir-sidebar' ) ) { ?>
						<div class="ova-dir-sidebar-wrapper">
							<div class="ova-dir-sidebar">
								<?php dynamic_sidebar('ova-dir-sidebar'); ?>
							</div>
						</div>
					<?php } ?>
					
					<div class="ova_dir_archive_content">
						<?php 
							ova_dir_get_items_archive( $wp_query, $args_show );

							$args = array(
								'type'      => 'list',
								'next_text' => '<i class="ovaicon-next" aria-hidden="true"></i><span class="visuallyhidden">Next</span>',
								'prev_text' => '<i class="ovaicon-back" aria-hidden="true"></i><span class="visuallyhidden">Previous</span>',
							);

							the_posts_pagination($args);
						?>
					</div>
					
					<?php if ( $sidebar == 'right_sidebar' && is_active_sidebar( 'ova-dir-sidebar' ) ) { ?>
						<div class="ova-dir-sidebar-wrapper">
							<div class="ova-dir-sidebar">
								<?php dynamic_sidebar('ova-dir-sidebar'); ?>
							</div>
						</div>
					<?php } ?>
				</div>

			</div>
		</div>
	</div>
</div>

<?php get_footer();