<?php

namespace ova_doc_elementor;

use ova_doc_elementor\widgets\ova_doc_category;
use ova_doc_elementor\widgets\ova_doc_download;
use ova_doc_elementor\widgets\ova_doc_download_2;
use ova_doc_elementor\widgets\ova_doc_download_3;
use ova_doc_elementor\widgets\ova_doc_items;
use ova_doc_elementor\widgets\ova_document_ajax;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Main Plugin Class
 *
 * Register new elementor widget.
 *
 * @since 1.0.0
 */
class Ova_Team_Register_Elementor {

	/**
	 * Constructor
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function __construct() {
		$this->add_actions();
	}

	/**
	 * Add Actions
	 *
	 * @since 1.0.0
	 *
	 * @access private
	 */
	private function add_actions() {
	    // Register Ovatheme Category in Pane
	    add_action( 'elementor/elements/categories_registered', array( $this, 'add_ovatheme_doc_category' ) );
		add_action( 'elementor/widgets/register', [ $this, 'on_widgets_registered' ] );
	}

	public function add_ovatheme_doc_category(  ) {
	    \Elementor\Plugin::instance()->elements_manager->add_category(
	        'ovatheme_doc',
	        [
	            'title' => esc_html__( 'Ovatheme Document', 'ova-team' ),
	            'icon' 	=> 'fa fa-plug',
	        ]
	    );
	}

	/**
	 * On Widgets Registered
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function on_widgets_registered() {
		$this->includes();
		$this->register_widget();
	}

	/**
	 * Includes
	 *
	 * @since 1.0.0
	 *
	 * @access private
	 */
	private function includes() {
		require OVADOC_PLUGIN_PATH . 'elementor/widgets/ova_doc_category.php';
		require OVADOC_PLUGIN_PATH . 'elementor/widgets/ova_doc_download.php';
		require OVADOC_PLUGIN_PATH . 'elementor/widgets/ova_doc_download_2.php';
		require OVADOC_PLUGIN_PATH . 'elementor/widgets/ova_doc_download_3.php';
		require OVADOC_PLUGIN_PATH . 'elementor/widgets/ova_doc_items.php';
		require OVADOC_PLUGIN_PATH . 'elementor/widgets/ova_document_ajax.php';
	}

	/**
	 * Register Widget
	 *
	 * @since 1.0.0
	 *
	 * @access private
	 */
	private function register_widget() {
		\Elementor\Plugin::instance()->widgets_manager->register( new ova_doc_category() );
		\Elementor\Plugin::instance()->widgets_manager->register( new ova_doc_download() );
		\Elementor\Plugin::instance()->widgets_manager->register( new ova_doc_download_2() );
		\Elementor\Plugin::instance()->widgets_manager->register( new ova_doc_download_3() );
		\Elementor\Plugin::instance()->widgets_manager->register( new ova_doc_items() );
		\Elementor\Plugin::instance()->widgets_manager->register( new ova_document_ajax() );
	}    
}

new Ova_Team_Register_Elementor();