<?php

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

function ova_get_doc_list( $documents, $cate_slug, $args_show = [] ){
	$term = get_term_by('slug', $cate_slug , 'cat_doc');

	$show_date  		= isset($args_show['show_date']) ? $args_show['show_date'] : 'yes';
	$show_title 		= isset($args_show['show_title']) ? $args_show['show_title'] : 'yes';
	$show_link_to 		= isset($args_show['show_link_to']) ? $args_show['show_link_to'] : 'yes';
	$show_view_icon 	= isset($args_show['show_view_icon']) ? $args_show['show_view_icon'] : 'yes';
	$show_download_icon = isset($args_show['show_download_icon']) ? $args_show['show_download_icon'] : 'yes';

	?>

	<div class="ova-doc-overlay"></div>

	<?php if ( $term ): ?>
		<div class="category-info">
			<h1 class="category-name"><?php echo esc_html( $term->name ); ?></h1>
			<?php if ( $term->description ): ?>
				<p class="desc">
					<?php echo esc_html( $term->description ); ?>
				</p>
			<?php endif; ?>
		</div>
	<?php endif; ?>
	<?php if ( $documents->have_posts() ): ?>
		<ul class="document-list">
			<?php while ( $documents->have_posts() ) : $documents->the_post();
				$id 			= get_the_ID();
				$published_date = get_post_meta( $id, 'ova_doc_met_publish_date', true);
			?>
				<li class="item">
					<div class="item-wrap">
						<div class="info">
							<?php if ( $show_view_icon == 'yes' ): ?>
								<a href="#" class="view" data-id="<?php echo esc_attr( $id ); ?>"
									aria-label="<?php esc_attr_e('View files','ova-doc'); ?>"
									title="<?php esc_attr_e( 'View files', 'ova-doc' ); ?>"
								>
									<i class="far fa-eye" aria-hidden="true"></i>
									<span class="loader" aria-label="<?php esc_attr_e( 'Loader','ova-doc' ); ?>"></span>
								</a>
							<?php endif; ?>

							<?php if ( $published_date && $show_date == 'yes' ): ?>
								<p class="date">
									<?php echo esc_html( date_i18n( 'F d, Y', $published_date ) ); ?>
								</p>
							<?php endif; ?>

							<?php if ( $show_title == 'yes' ): ?>
								<?php if ( $show_link_to == 'yes' ): ?>
									<a href="<?php echo esc_url( get_the_permalink( $id ) ); ?>"
										title="<?php echo esc_attr( get_the_title( $id ) ); ?>"
									>
									<?php endif; ?>
									<h3 class="title">
										<?php echo esc_html( get_the_title( $id ) ); ?>
									</h3>
								<?php if ( $show_link_to == 'yes' ): ?>
								</a>
								<?php endif; ?>
							<?php endif; ?>
						</div>

						<?php if ( $show_download_icon == 'yes' ): ?>
							<a href="#" class="icon" data-id="<?php echo esc_attr( $id ); ?>"
								aria-label="<?php esc_attr_e('Download file','ova-doc'); ?>"
								title="<?php esc_attr_e('Download file','ova-doc'); ?>"
							>
								<i class="gimonticon-download" aria-hidden="true"></i>
							</a>
						<?php endif; ?>
					</div>
				</li>
			<?php endwhile; ?>
		</ul>
	<?php else: ?>
		<p><?php esc_attr_e( 'Not found !', 'ova-doc' ); ?></p>
	<?php endif;wp_reset_postdata();
}

function ova_modal_get_file_list( $id ) {
	$list_document 	= get_post_meta( $id, 'ova_doc_met_list_document', true );
	
	?>

	<div class="modal-content">
		
		<span class="close" aria-label="<?php esc_attr_e( 'Close Popup', 'ova-doc' ); ?>">
			<i class="ovaicon ovaicon-cancel-1" aria-hidden="true"></i>
		</span>
		
		<?php if( ! empty( $list_document ) ){ ?>

			<ul class="ova-list-attachment">

				<?php foreach( $list_document as $file_id => $document ){

					$data = @file_get_contents($document);

					$name_file = basename( $document );
					$ext_file  = pathinfo( $name_file, PATHINFO_EXTENSION );

					// Get post from $file_id
					$files = ova_doc_get_name_files( $file_id );
					if ( !empty( $files ) ) {
						foreach ($files as $file) {
							$name_file = $file->post_title ? $file->post_title : $file->post_excerpt;
						}
					}

					// Check empty $name_file
					if ( empty( $name_file ) ) {
						$name_file = basename( $file_dep );
					}

				?>
					<?php if( $data ) { ?>
						<li>
							<span class="icon-attachment" aria-label="<?php esc_attr_e('Icon Attachment','ova-doc'); ?>">
								<?php echo ova_doc_get_icon_attachment_file( $ext_file ); ?>
							</span>
							<span class="ova-file-name-size">
								<span class="ova-file-name" aria-label="<?php esc_attr_e('File Name','ova-doc'); ?>">
									<?php echo esc_html( $name_file ) ?>
								</span>
								<span class="ova-file-size">
									<span class="type" aria-label="<?php esc_attr_e('File Type','ova-doc'); ?>">
										<?php echo esc_html( $ext_file ) ?>
									</span>
									<span class="file-size" aria-label="<?php esc_attr_e('File Size','ova-doc'); ?>">
										(<?php echo ova_doc_get_file_size( $document ) . esc_html__( 'kb', 'ova-doc' ); ?>)
									</span>
								</span>
							</span>
							<span class="ova-download">
								<a href="<?php echo esc_url( $document ); ?>" class="view"
									target="_blank" role="button"
									aria-label="<?php esc_attr_e('Popup list files','ova-doc'); ?>"
									title="<?php esc_attr_e( 'View', 'ova-doc' ); ?>"
								>
									<i class="far fa-eye" aria-hidden="true"></i>
								</a>
								<a href="<?php echo esc_url( $document ); ?>"
									aria-label="<?php esc_attr_e('Download file','ova-doc'); ?>"
									title="<?php esc_attr_e( 'Download', 'ova-doc' ); ?>" download
								>
									<i class="gimonticon-download" aria-hidden="true"></i>
								</a>
							</span>
						</li>
					<?php } ?>

				<?php } ?>

			</ul>

		<?php } else { ?>
			<p><?php esc_html_e( 'Not found !', 'ova-doc' ); ?></p>
		<?php } ?>
	</div>
	<?php
}

function ova_get_file_list( $id ) {

	$list_document = get_post_meta( $id, 'ova_doc_met_list_document', true );

	$list_document = array_reverse($list_document);

	if( ! empty( $list_document ) ){ ?>

		<ul class="ova-list-attachment">

			<?php foreach( $list_document as $file_id => $document ){

				$data = @file_get_contents($document);

				$name_file = basename( $document );
				$ext_file  = pathinfo( $name_file, PATHINFO_EXTENSION );

				// Get post from $file_id
				$files = ova_doc_get_name_files( $file_id );
				if ( !empty( $files ) ) {
					foreach ($files as $file) {
						$name_file = $file->post_title ? $file->post_title : $file->post_excerpt;
					}
				}

				// Check empty $name_file
				if ( empty( $name_file ) ) {
					$name_file = basename( $file_dep );
				}

			?>
				<?php if( $data ) { ?>
					<li>
						<span class="icon-attachment">
							<?php echo ova_doc_get_icon_attachment_file( $ext_file ); ?>
						</span>
						<span class="ova-file-name-size">
							<span class="ova-file-name">
								<?php echo esc_html( $name_file ) ?>
							</span>
							<span class="ova-file-size">
								<span class="type">
									<?php echo esc_html( $ext_file ) ?>
								</span>
								<span class="file-size">
									(<?php echo ova_doc_get_file_size( $document ) . esc_html__( 'kb', 'ova-doc' ); ?>)
								</span>
							</span>
						</span>
						<span class="ova-download">
							<a href="<?php echo esc_url( $document ); ?>" class="view"
								target="_blank" role="button"
								aria-label="<?php esc_attr_e('Popup list files','ova-doc'); ?>"
								title="<?php esc_attr_e( 'View', 'ova-doc' ); ?>"
							>
								<i class="far fa-eye" aria-hidden="true"></i>
							</a>
							<a href="<?php echo esc_url( $document ); ?>"
								aria-label="<?php esc_attr_e('Download file','ova-doc'); ?>"
								title="<?php esc_attr_e( 'Download', 'ova-doc' ); ?>" download
							>
								<i class="gimonticon-download" aria-hidden="true"></i>
							</a>
						</span>
					</li>
				<?php } ?>

			<?php } ?>

		</ul>

		<?php } else { ?>
			<p><?php esc_html_e( 'Not found !', 'ova-doc' ); ?></p>
		<?php } ?>

	<?php
}

function ova_doc_pagination_ajax($total_pages,$curent_page,$posts_per_page,$args){
	if ( $total_pages > 1 ) :
		$page_num_arr = range(1, $total_pages);
	?>
		<div class="ova_doc_pagination_ajax" data-args="<?php echo esc_attr( json_encode( $args ) ); ?>">
			<nav class="navigation pagination" aria-label="<?php esc_attr_e( 'Pagination','ova-doc' ); ?>">
				<div class="nav-links">
					<ul class="page-numbers">

						<?php if ( $curent_page > 1 ): ?>
							<?php $offset = $posts_per_page * ( max( $curent_page - 1, 1) - 1) == 0 ? -1 : $posts_per_page * ( max( $curent_page - 1, 1) - 1); ?>
							<li>
								<a class="prev page-numbers" href="#"
								aria-label="<?php esc_attr_e('Previous Page', 'ova-doc'); ?>"
								data-offset="<?php echo esc_attr( $offset ); ?>"
								data-page="<?php echo esc_attr( max( $curent_page - 1, 1) ); ?>">
									<i class="ovaicon-back" aria-hidden="true"></i>
								</a>
							</li>
						<?php endif;

						$first_item = max( $curent_page - 1, 1 );
						$last_item = min( $curent_page + 1, $total_pages );
						if ($curent_page == 1) {
							$last_item = min( $curent_page + 2, $total_pages );
						}
						if ($curent_page == $total_pages) {
							$first_item = max( $curent_page - 2, 1 );
						}
						$sub_page_num_arr = range( $first_item, $last_item );

						foreach ( $sub_page_num_arr as $page_number ): ?>
							<li>
								<?php if ( $curent_page == $page_number ): ?>
									<span aria-current="page" class="page-numbers current">
										<?php echo esc_html( $page_number ); ?>
									</span>
								<?php else: ?>
									<?php
									$offset = $posts_per_page * ($page_number - 1) == 0 ? -1 : $posts_per_page * ($page_number - 1);
									?>
									<a href="#" class="page-numbers"
									data-offset="<?php echo esc_attr( $offset ); ?>"
									data-page="<?php echo esc_attr( $page_number ); ?>">
									<?php echo esc_html( $page_number ); ?>
									</a>
								<?php endif; ?>
							</li>
						<?php endforeach; ?>

						<?php if ( $curent_page < $total_pages ): ?>
							<li>
								<a class="next page-numbers" href="#"
								aria-label="<?php esc_attr_e('Next Page', 'ova-doc'); ?>"
								data-offset="<?php echo esc_attr( $posts_per_page * ( min( $curent_page + 1, $total_pages) - 1) ); ?>"
								data-page="<?php echo esc_attr( min( $curent_page + 1, $total_pages) ); ?>">
								<i class="ovaicon-next" aria-hidden="true"></i>
								</a>
							</li>
						<?php endif; ?>

					</ul>
				</div>
			</nav>
		</div>
	<?php endif;
}

function ova_doc_query_filter( $cate_name, $start_date, $end_date, $cate_slug ){

	$order 			= get_theme_mod( 'ova_doc_order', 'DESC' );
	$order_by 		= get_theme_mod( 'ova_doc_orderby', 'ID' );
	$posts_per_page = get_theme_mod( 'ova_doc_total_record', 8 );

	$args = array(
		'post_type' 		=> 'ova_doc',
		'post_status' 		=> 'publish',
		'order' 			=> $order,
		'orderby' 			=> $order_by,
		'posts_per_page' 	=> $posts_per_page,
	);

	if ( $cate_name ) {
		$args['s'] = trim( $cate_name );
	}
	if ( $start_date && $end_date ) {
		$args['meta_query'] = array(
			'relation' => 'AND',
			array(
				'key' => 'ova_doc_met_publish_date',
				'value' => strtotime( $start_date ),
				'compare' => '>=',
				'type' => 'NUMERIC',
			),
			array(
				'key' => 'ova_doc_met_publish_date',
				'value' => strtotime( $end_date ),
				'compare' => '<=',
				'type' => 'NUMERIC',
			),
		);
	}

	if ( $order_by == 'ova_doc_met_order_doc' || $order_by == 'ova_doc_met_publish_date' ) {
		$args['orderby'] 	= 'meta_value_num';
		$args['meta_key'] 	= $order_by;
		$args['meta_type'] 	= 'NUMERIC';
	}

	if ($cate_slug != 'all') {
		$args['tax_query'] = array(
			array(
				'taxonomy'         => 'cat_doc',
				'field'            => 'slug',
				'terms'            => $cate_slug,
				'include_children' => true,
				'operator'         => 'IN',
			),
		);
	}

	return new WP_Query( $args );
	
}

function ova_doc_query($args) {

	$order_by 		= $args['order_by'];
	$order 			= $args['order'];
	$posts_per_page = $args['posts_per_page'];
	$cate 			= $args['cate'];
	$wp_args = array(
		'post_type' 		=> 'ova_doc',
		'post_status' 		=> 'publish',
		'order' 			=> $order,
		'orderby' 			=> $order_by,
		'posts_per_page' 	=> $posts_per_page,
	);

	if ( $order_by == 'ova_doc_met_order_doc' || $order_by == 'ova_doc_met_publish_date' ) {
		$wp_args['orderby'] 	= 'meta_value_num';
		$wp_args['meta_key'] 	= $order_by;
		$wp_args['meta_type'] 	= 'NUMERIC';
	}

	if ($cate != 'all') {
		$wp_args['tax_query'] = array(
			array(
				'taxonomy'         => 'cat_doc',
				'field'            => 'slug',
				'terms'            => $cate,
				'include_children' => true,
				'operator'         => 'IN',
			),
		);
	}

	return new WP_Query( $wp_args );
}

function ova_doc_pagination_query_ajax($args) {

	$order_by 		= $args['order_by'];
	$order 			= $args['order'];
	$posts_per_page = $args['posts_per_page'];
	$cate 			= $args['cate'];

	$wp_args = array(
		'post_type' 		=> 'ova_doc',
		'post_status' 		=> 'publish',
		'order' 			=> $order,
		'orderby' 			=> $order_by,
		'posts_per_page' 	=> $posts_per_page,
	);

	if ( array_key_exists('offset', $args) ) {
		if ($args['offset'] != -1) {
			$wp_args['offset'] = $args['offset'];
		}
	}

	if (array_key_exists('cate_name', $args)) {

		if ( $args['cate_name'] ) {
			$wp_args['s'] = $args['cate_name'];
		}
	}

	if ( array_key_exists('start_date', $args) && array_key_exists('end_date', $args) ) {
		
		if ( $args['start_date'] && $args['end_date'] ) {
			
			$wp_args['meta_query'] = array(
				'relation' => 'AND',
				array(
					'key' => 'ova_doc_met_publish_date',
					'value' => strtotime( $args['start_date'] ),
					'compare' => '>=',
					'type' => 'NUMERIC',
				),
				array(
					'key' => 'ova_doc_met_publish_date',
					'value' => strtotime( $args['end_date'] ),
					'compare' => '<=',
					'type' => 'NUMERIC',
				),
			);
		}
	}

	if ( $order_by == 'ova_doc_met_order_doc' || $order_by == 'ova_doc_met_publish_date' ) {
		$wp_args['orderby'] 	= 'meta_value_num';
		$wp_args['meta_key'] 	= $order_by;
		$wp_args['meta_type'] 	= 'NUMERIC';
	}

	if ($cate != 'all') {
		$wp_args['tax_query'] = array(
			array(
				'taxonomy'         => 'cat_doc',
				'field'            => 'slug',
				'terms'            => $cate,
				'include_children' => true,
				'operator'         => 'IN',
			),
		);
	}

	return new WP_Query( $wp_args );
}

function ova_doc_category_ajax( $term_slug ){

	$order 			= get_theme_mod( 'ova_doc_order', 'DESC' );
	$order_by 		= get_theme_mod( 'ova_doc_orderby', 'ID');
	$posts_per_page = intval( get_theme_mod( 'ova_doc_total_record', 8 ) );
	$cate 			= $term_slug;
	$wp_args = array(
		'post_type' 		=> 'ova_doc',
		'post_status' 		=> 'publish',
		'order' 			=> $order,
		'orderby' 			=> $order_by,
		'posts_per_page' 	=> $posts_per_page,
	);

	if ( $order_by == 'ova_doc_met_order_doc' || $order_by == 'ova_doc_met_publish_date' ) {
		$wp_args['orderby'] 	= 'meta_value_num';
		$wp_args['meta_key'] 	= $order_by;
		$wp_args['meta_type'] 	= 'NUMERIC';
	}

	$wp_args['tax_query'] = array(
		array(
			'taxonomy'         => 'cat_doc',
			'field'            => 'slug',
			'terms'            => $cate,
			'include_children' => true,
			'operator'         => 'IN',
		),
	);

	return new WP_Query( $wp_args );
}

function ova_doc_get_child_cate( $parent_id, $term_ids){
	if (! $parent_id) {
		return;
	}

	$args = array(
		'taxonomy' 		=> 'cat_doc',
		'orderby' 		=> 'name',
		'order'   		=> 'ASC',
		'hide_empty' 	=> false,
		'parent' 		=> $parent_id,
	);

	$id 				= get_the_ID();
	$term_id 			= get_queried_object_id();
	$child_categories 	= get_categories( $args );

	if ( $child_categories ) {
	?>
		<ul class="child-cate">
			<?php foreach ($child_categories as $child) {
				$active_class = $child->term_id == $term_id ? 'active' : '';
				if ( $id ) {
					$active_class = in_array( $child->term_id, $term_ids) ? 'active' : '';
				}
			?>
				<li class="item">
					<a href="<?php echo esc_url( get_term_link( $child ) ); ?>"
						class="item-link <?php echo esc_attr( $active_class ); ?>"
						data-slug="<?php echo esc_attr( $child->slug ); ?>"
						title="<?php echo esc_attr( $child->name ); ?>"
					>
						<span class="cate_name">
							<?php echo esc_html( $child->name ); ?>	
						</span>
						<?php if (get_term_children( $child->term_id, 'cat_doc' ) ): ?>
							<i class="fas fa-plus" aria-hidden="true"></i>
						<?php endif; ?>
					</a>
					<?php ova_doc_get_child_cate( $child->term_id, $term_ids); ?>
				</li>
			<?php } ?>
		</ul>
	<?php }
}

/**
 * Get icon attachment file
 */
function ova_doc_get_icon_attachment_file( $ext_file = '' ){ 
	if( $ext_file == '' ) return '<i class="fas fa-file-alt" aria-hidden="true"></i>';

	if( $ext_file === 'docx' || $ext_file === 'doc' ){
		$icon = '<i class="fas fa-file-alt" aria-hidden="true"></i>';
	} elseif( $ext_file === 'jpg' || $ext_file === 'gif' || $ext_file === 'png' ){
		$icon = '<i class="fas fa-file-image" aria-hidden="true"></i>';
	} elseif( $ext_file === 'pdf' ){
		$icon = '<i class="gimonticon gimonticon-pdf-file" aria-hidden="true"></i>';
	} elseif( $ext_file === 'mp4' ){
		$icon = '<i class="fas fa-file-video" aria-hidden="true"></i>';
	} else{
		$icon = '<i class="fas fa-file-alt" aria-hidden="true"></i>';
	}

	return $icon;
}

/**
 * Get file size
 */
function ova_doc_get_file_size( $url_file = '' ){
	if( $url_file === '' ) return;
	$upload_dir = wp_upload_dir();
	$path_upload_full = $upload_dir['path'];

	$path_upload_sub = substr( $path_upload_full, 0, strpos( $path_upload_full, 'wp-content/uploads' ) );


	$position = strpos( $url_file, 'wp-content/uploads' );
	$sub_str = substr( $url_file, $position );
	$path_file = $path_upload_sub . $sub_str;

	$file_size_byte = filesize( $path_file );
	$file_size_kb = $file_size_byte * 0.0009765625;
	$file_size_kb = round( $file_size_kb );

	return $file_size_kb;
}

// get list category document dropdown
add_filter( 'ovadoc_cat_dropdown', 'ovadoc_cat_dropdown');
function ovadoc_cat_dropdown($selected){
	$args = array(
		'show_option_all'   => '' ,
		'show_option_none'   => esc_html__( 'All Categories', 'ova-doc' ),
		'post_type'         => 'ova_doc',
		'post_status'       => 'publish',
		'posts_per_page'    => '-1',
		'option_none_value' => 'all',
		'orderby'           => 'ID',
		'order'             => 'ASC',
		'show_count'        => 0,
		'hide_empty'        => 0,
		'child_of'          => 0,
		'exclude'           => '',
		'include'           => '',
		'echo'              => 1,
		'selected'          => $selected,
		'hierarchical'      => 1,
		'name'              => 'category',
		'id'                => 'ovadoc_category',
		'depth'             => 0,
		'tab_index'         => 0,
		'taxonomy'          => 'cat_doc',
		'hide_if_empty'     => false,
		'value_field'       => 'slug',
		'class' 			=> 'ovadoc_cat',
	);
	
	return wp_dropdown_categories($args);
}

// Get all id document
function ova_doc_get_all_id(){
   $all_ids = get_posts( array(
        'post_type'      => 'ova_doc',
        'posts_per_page' => -1,
        'post_status'    => 'publish',
        'fields'         => 'ids',
    ));

    return $all_ids;
}