<?php if ( !defined( 'ABSPATH' ) ) exit();

$margin_items 		= $args['margin_items'];
$item_number 		= $args['item_number'];
$slides_to_scroll 	= $args['slides_to_scroll'];
$pause_on_hover 	= $args['pause_on_hover'] == 'yes' ? true : false;
$infinite 			= $args['infinite'] == 'yes' ? true : false;
$autoplay 			= $args['autoplay'] == 'yes' ? true : false;
$autoplay_speed 	= $args['autoplay_speed'];
$smartspeed 		= $args['smartspeed'];
$dots 				= $args['dot_control'] == 'yes' ? true : false;

$data_options = array(
	'margin' 			=> $margin_items,
	'items' 			=> $item_number,
	'slidesToScroll'	=> $slides_to_scroll,
	'pauseOnHover' 		=> $pause_on_hover,
	'infinite' 			=> $infinite,
	'autoplay' 			=> $autoplay ,
	'autoplaySpeed' 	=> $autoplay_speed,
	'smartspeed' 		=> $smartspeed,
	'dots' 				=> $dots,
	'rtl'               => is_rtl()
);

$documents 	= ova_doc_query($args);

?>

<div class="ova-doc-download-3">
	<?php if ( $documents->have_posts() ) : ?>
		<div class="document-slider" data-option="<?php echo esc_attr( json_encode( $data_options ) ); ?>">
			<div class="owl-carousel owl-theme">
				<?php while ( $documents->have_posts() ) : $documents->the_post();
					$id = get_the_ID();
					$published_date = get_post_meta( $id, 'ova_doc_met_publish_date', true);
				?>
					<div class="item">
						<div class="item-wrap">
							<div class="info">
								<?php if ( $show_view_icon == 'yes' ) : ?>
									<a href="#" class="view"
										data-id="<?php echo esc_attr( $id ); ?>"
										title="<?php esc_attr_e( 'View files', 'ova-doc' ); ?>"
									>
										<i class="far fa-eye" aria-hidden="true"></i>
										<span class="loader"></span>
									</a>
								<?php endif; ?>

								<?php if ( $published_date && $show_date == 'yes' ) : ?>
									<p class="date">
										<?php echo esc_html( date_i18n( 'F d, Y', $published_date ) ); ?>
									</p>
								<?php endif; ?>

								<?php if ( $show_title == 'yes' ) : ?>
									<?php if ( $show_link_to == 'yes' ) : ?>
										<a href="<?php echo esc_url( get_the_permalink( $id ) ); ?>"
											title="<?php echo esc_attr( get_the_title( $id ) ); ?>"
										>
									<?php endif; ?>
										<h3 class="title">
											<?php echo esc_html( get_the_title( $id ) ); ?>
										</h3>
									<?php if ( $show_link_to == 'yes' ) : ?>
										</a>
									<?php endif; ?>
								<?php endif; ?>
							</div>

							<?php if ( $show_download_icon == 'yes' ) : ?>
								<a href="#" title="<?php esc_attr_e( 'Download files', 'ova-doc' ); ?>" class="icon" data-id="<?php echo esc_attr( $id ); ?>">
									<i class="gimonticon-download" aria-hidden="true"></i>
								</a>
							<?php endif; ?>
						</div>
					</div>
				<?php endwhile; ?>
			</div>
		</div>
	<?php endif;wp_reset_postdata(); ?>
	<div class="ova-doc-modal"></div>
</div>