(function($){
	"use strict";

	$(window).on('elementor/frontend/init', function () {

        elementorFrontend.hooks.addAction('frontend/element_ready/ova_por_slide_2.default', function(){

            var owlsl       = $('.ova_por_slider_2 .owl-carousel');
            var dataOps     = $('.ova_por_slider_2').attr('data-option');
            var owlsl_ops   = JSON.parse( dataOps );

            if ( $('body').hasClass('rtl') ) {
                owlsl_ops.rtl = true;
            }

            owlsl.owlCarousel({
                nav:false,
                margin: owlsl_ops.margin,
                items: owlsl_ops.items,
                loop: owlsl_ops.loop,
                autoplay: owlsl_ops.autoplay,
                autoplayTimeout: owlsl_ops.autoplayTimeout,
                dots: owlsl_ops.dots,
                autoplayHoverPause: owlsl_ops.autoplayHoverPause,
                slideBy: owlsl_ops.slideBy,
                smartSpeed: owlsl_ops.smartSpeed,
                rtl: owlsl_ops.rtl,
                responsive: {
                    0: {
                        items: 1,
                    },
                    768: {
                        items: 2,
                    },
                    1024: {
                        items: 3,
                    },
                    1200: {
                        items: owlsl_ops.items,
                    },
                }
            });

            /* Fixed WCAG */
            owlsl.find(".owl-nav button.owl-prev").attr("title", "Previous");
            owlsl.find(".owl-nav button.owl-next").attr("title", "Next");
            owlsl.find(".owl-dots button").attr("title", "Dots");

        });

    });
})(jQuery);