<?php

if (!defined( 'ABSPATH' )) {
	exit;
}
if (!class_exists( 'Ova_Por_Customize' )){

	class Ova_Por_Customize {

		public function __construct() {
			add_action( 'customize_register', array( $this, 'ova_por_customize_register' ) );
		}

		public function ova_por_customize_register($wp_customize) {

			$this->ova_por_init( $wp_customize );

			do_action( 'ova_por_customize_register', $wp_customize );
		}


		public function ova_por_init( $wp_customize ){

			$wp_customize->add_panel( 'ova_por_panel', array(
			  	'title' => esc_html__( 'Portfolio', 'ova-por' ),
			  	'priority' => 5,
			) );

			$wp_customize->add_section( 'ova_por_archive_section' , array(
				'title'      => esc_html__( 'Archive', 'ova-por' ),
				'priority'   => 1,
				'panel' => 'ova_por_panel',
			) );

			$wp_customize->add_section( 'ova_por_single_section' , array(
				'title'      => esc_html__( 'Single', 'ova-por' ),
				'priority'   => 2,
				'panel' => 'ova_por_panel',
			) );


			$wp_customize->add_setting( 'ova_por_total_record', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => '60',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_por_total_record', array(
				'label' => esc_html__('Number of posts per page','ova-por'),
				'section' => 'ova_por_archive_section',
				'settings' => 'ova_por_total_record',
				'type' =>'number'
			));

			$wp_customize->add_setting( 'ova_por_orderby', array(
			  	'type' 				=> 'theme_mod', // or 'option'
			  	'capability' 		=> 'edit_theme_options',
			  	'theme_supports' 	=> '', // Rarely needed.
			  	'default' 			=> 'sort_order',
			  	'transport' 		=> 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('ova_por_orderby', array(
				'label' 	=> esc_html__('Order By','ova-por'),
				'section' 	=> 'ova_por_archive_section',
				'settings' 	=> 'ova_por_orderby',
				'type' 		=>'select',
				'choices' 	=> array(
					'sort_order' 	=> esc_html__( 'Sort Order', 'ova-por' ),
					'ID' 			=> esc_html__( 'ID', 'ova-por' ),
					'title' 		=> esc_html__( 'Title', 'ova-por' ),
					'date' 			=> esc_html__( 'Date', 'ova-por' ),
					'rand' 			=> esc_html__( 'Random', 'ova-por' ),
				)
			));

			$wp_customize->add_setting( 'ova_por_order', array(
			  	'type' 				=> 'theme_mod', // or 'option'
			  	'capability' 		=> 'edit_theme_options',
			  	'theme_supports' 	=> '', // Rarely needed.
			  	'default' 			=> 'ASC',
			  	'transport' 		=> 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('ova_por_order', array(
				'label' 	=> esc_html__('Order','ova-por'),
				'section' 	=> 'ova_por_archive_section',
				'settings' 	=> 'ova_por_order',
				'type' 		=>'select',
				'choices' 	=> array(
					'ASC' 	=> esc_html__( 'Ascending', 'ova-por' ),
					'DESC' 	=> esc_html__( 'Descending', 'ova-por' ),
				)
			));

			$wp_customize->add_setting( 'ova_por_layout', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'three_column',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_por_layout', array(
				'label' => esc_html__('Layout','ova-por'),
				'section' => 'ova_por_archive_section',
				'settings' => 'ova_por_layout',
				'type' =>'select',
				'choices' => array(
					'two_column'    => __( '2 column', 'ova-por' ),
					'three_column' 	=> __( '3 column', 'ova-por' ),
					'four_column'   => __( '4 column', 'ova-por' ),
				)
			));

			$wp_customize->add_setting( 'ova_por_archive_type', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'classic',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_por_archive_type', array(
				'label' => esc_html__('Type','ova-por'),
				'section' => 'ova_por_archive_section',
				'settings' => 'ova_por_archive_type',
				'type' =>'select',
				'choices' => array(
					'classic'  => esc_html__( 'Classic', 'ova-por' ),
					'modern'   => esc_html__( 'Modern', 'ova-por' ),
					'grid' 	   => esc_html__( 'Grid', 'ova-por' ),
				)
			));
				
			$wp_customize->add_setting( 'header_archive_por', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'default',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('header_archive_por', array(
				'label' => esc_html__('Header','ova-por'),
				'section' => 'ova_por_archive_section',
				'settings' => 'header_archive_por',
				'type' =>'select',
				'choices' => apply_filters('gimont_list_header', '')
			));

			$wp_customize->add_setting( 'archive_footer_por', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'default',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('archive_footer_por', array(
				'label' => esc_html__('Footer','ova-por'),
				'section' => 'ova_por_archive_section',
				'settings' => 'archive_footer_por',
				'type' =>'select',
				'choices' => apply_filters('gimont_list_footer', '')
			));

			$wp_customize->add_setting( 'ova_por_archive_show_filter', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_por_archive_show_filter', array(
				'label' => esc_html__('Show Filter','ova-por'),
				'section' => 'ova_por_archive_section',
				'settings' => 'ova_por_archive_show_filter',
				'type' =>'select',
				'choices' => array(
					'yes'	=> esc_html__( 'Yes', 'ova-por' ),
					'no'	=> esc_html__( 'No', 'ova-por' ),
				)
			));

			$wp_customize->add_setting( 'ova_por_archive_show_category', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_por_archive_show_category', array(
				'label' => esc_html__('Show Category','ova-por'),
				'section' => 'ova_por_archive_section',
				'settings' => 'ova_por_archive_show_category',
				'type' =>'select',
				'choices' => array(
					'yes'	=> esc_html__( 'Yes', 'ova-por' ),
					'no'	=> esc_html__( 'No', 'ova-por' ),
				)
			));

			$wp_customize->add_setting( 'ova_por_archive_show_title', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_por_archive_show_title', array(
				'label' => esc_html__('Show Title','ova-por'),
				'section' => 'ova_por_archive_section',
				'settings' => 'ova_por_archive_show_title',
				'type' =>'select',
				'choices' => array(
					'yes'	=> esc_html__( 'Yes', 'ova-por' ),
					'no'	=> esc_html__( 'No', 'ova-por' ),
				)
			));

			$wp_customize->add_setting( 'ova_por_archive_show_link_to', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_por_archive_show_link_to', array(
				'label' => esc_html__('Show Link to Detail','ova-por'),
				'section' => 'ova_por_archive_section',
				'settings' => 'ova_por_archive_show_link_to',
				'type' =>'select',
				'choices' => array(
					'yes'	=> esc_html__( 'Yes', 'ova-por' ),
					'no'	=> esc_html__( 'No', 'ova-por' ),
				)
			));

			$wp_customize->add_setting( 'ova_por_archive_show_loadmore', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_por_archive_show_loadmore', array(
				'label' => esc_html__('Show Load More Button','ova-por'),
				'section' => 'ova_por_archive_section',
				'settings' => 'ova_por_archive_show_loadmore',
				'type' =>'select',
				'choices' => array(
					'yes'	=> esc_html__( 'Yes', 'ova-por' ),
					'no'	=> esc_html__( 'No', 'ova-por' ),
				)
			));


			// Single
			$wp_customize->add_setting( 'ova_por_single_type', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'type1',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_por_single_type', array(
				'label' => esc_html__('Type','ova-por'),
				'section' => 'ova_por_single_section',
				'settings' => 'ova_por_single_type',
				'type' =>'select',
				'choices' => array(
					'type1' => __( 'Type 1', 'ova-por' ),
					'type2' => __( 'Type 2', 'ova-por' ),
					'type3' => __( 'Type 3', 'ova-por' ),
				)
			));

			$wp_customize->add_setting( 'header_single_por', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'default',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('header_single_por', array(
				'label' => esc_html__('Header','ova-por'),
				'section' => 'ova_por_single_section',
				'settings' => 'header_single_por',
				'type' =>'select',
				'choices' => apply_filters('gimont_list_header', '')
			));

			$wp_customize->add_setting( 'single_footer_por', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'default',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('single_footer_por', array(
				'label' => esc_html__('Footer','ova-por'),
				'section' => 'ova_por_single_section',
				'settings' => 'single_footer_por',
				'type' =>'select',
				'choices' => apply_filters('gimont_list_footer', '')
			));

			$wp_customize->add_setting( 'ova_por_single_show_gallery', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_por_single_show_gallery', array(
				'label' => esc_html__('Show Gallery','ova-por'),
				'section' => 'ova_por_single_section',
				'settings' => 'ova_por_single_show_gallery',
				'type' =>'select',
				'choices' => array(
					'yes'	=> esc_html__( 'Yes', 'ova-por' ),
					'no'	=> esc_html__( 'No', 'ova-por' ),
				)
			));

			$wp_customize->add_setting( 'ova_por_single_show_category', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_por_single_show_category', array(
				'label' => esc_html__('Show Category','ova-por'),
				'section' => 'ova_por_single_section',
				'settings' => 'ova_por_single_show_category',
				'type' =>'select',
				'choices' => array(
					'yes'	=> esc_html__( 'Yes', 'ova-por' ),
					'no'	=> esc_html__( 'No', 'ova-por' ),
				)
			));

			$wp_customize->add_setting( 'ova_por_single_show_date', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_por_single_show_date', array(
				'label' => esc_html__('Show Date','ova-por'),
				'section' => 'ova_por_single_section',
				'settings' => 'ova_por_single_show_date',
				'type' =>'select',
				'choices' => array(
					'yes'	=> esc_html__( 'Yes', 'ova-por' ),
					'no'	=> esc_html__( 'No', 'ova-por' ),
				)
			));

			$wp_customize->add_setting( 'ova_por_single_show_location', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_por_single_show_location', array(
				'label' => esc_html__('Show Location','ova-por'),
				'section' => 'ova_por_single_section',
				'settings' => 'ova_por_single_show_location',
				'type' =>'select',
				'choices' => array(
					'yes'	=> esc_html__( 'Yes', 'ova-por' ),
					'no'	=> esc_html__( 'No', 'ova-por' ),
				)
			));

			
			$wp_customize->add_setting( 'ova_por_single_show_department', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_por_single_show_department', array(
				'label' => esc_html__('Show Department','ova-por'),
				'section' => 'ova_por_single_section',
				'settings' => 'ova_por_single_show_department',
				'type' =>'select',
				'choices' => array(
					'yes'	=> esc_html__( 'Yes', 'ova-por' ),
					'no'	=> esc_html__( 'No', 'ova-por' ),
				)
			));

			$wp_customize->add_setting( 'ova_por_single_show_share', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_por_single_show_share', array(
				'label' => esc_html__('Show Share','ova-por'),
				'section' => 'ova_por_single_section',
				'settings' => 'ova_por_single_show_share',
				'type' =>'select',
				'choices' => array(
					'yes'	=> esc_html__( 'Yes', 'ova-por' ),
					'no'	=> esc_html__( 'No', 'ova-por' ),
				)
			));

			$wp_customize->add_setting( 'ova_por_single_show_content', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_por_single_show_content', array(
				'label' => esc_html__('Show Content','ova-por'),
				'section' => 'ova_por_single_section',
				'settings' => 'ova_por_single_show_content',
				'type' =>'select',
				'choices' => array(
					'yes'	=> esc_html__( 'Yes', 'ova-por' ),
					'no'	=> esc_html__( 'No', 'ova-por' ),
				)
			));

			$wp_customize->add_setting( 'ova_por_single_show_next_prev', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_por_single_show_next_prev', array(
				'label' => esc_html__('Show Next Prev','ova-por'),
				'section' => 'ova_por_single_section',
				'settings' => 'ova_por_single_show_next_prev',
				'type' =>'select',
				'choices' => array(
					'yes'	=> esc_html__( 'Yes', 'ova-por' ),
					'no'	=> esc_html__( 'No', 'ova-por' ),
				)
			));

			$wp_customize->add_setting( 'ova_por_single_show_related', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_por_single_show_related', array(
				'label' => esc_html__('Show Related','ova-por'),
				'section' => 'ova_por_single_section',
				'settings' => 'ova_por_single_show_related',
				'type' =>'select',
				'choices' => array(
					'yes'	=> esc_html__( 'Yes', 'ova-por' ),
					'no'	=> esc_html__( 'No', 'ova-por' ),
				)
			));

			$wp_customize->add_setting( 'ova_por_comments', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_por_comments', array(
				'label' => esc_html__('Show Comments','ova-por'),
				'section' => 'ova_por_single_section',
				'settings' => 'ova_por_comments',
				'type' =>'select',
				'choices' => array(
					'yes'	=> __( 'Yes', 'ova-por' ),
					'no'	=> __( 'No', 'ova-por' ),
				)
			));

		}

	}

}

new Ova_Por_Customize();