(function($){
	"use strict";

	$(window).on('elementor/frontend/init', function () {

		/* Service Ajax */
		elementorFrontend.hooks.addAction('frontend/element_ready/ova_service_ajax.default', function(){
			$(".ova-service-ajax").each(function(e){

				var loader 	  	 = $(this).find(".service-ajax-results-wrapper .ova-sev-loader .loader");
				var wrap_results = $(this).find(".service-ajax-results");

				var item       = $(this).find(".service-cat-parent-list .item-link");
				var item_child = $(this).find(".service-cat-child-list .item-link");

				var active_item = $(this).find(".service-cat-list .item-link.active-category");
				var active_slug = active_item.data('slug');

				$(this).find("[data-parent_slug='" + active_slug + "']").show(); 

				var posts_per_page = $(this).data('posts_per_page');
				var order 		   = $(this).data('order');
				var orderby 	   = $(this).data('orderby');
				var show_desc 	   = $(this).data('show_desc');

				item.click(function(e){
					// class active category
					$(".ova-service-ajax .service-cat-list .item-link").removeClass('active-category');
					$(this).addClass('active-category');

					var slug = $(this).data('slug');

					// show hide child category
					$('.service-cat-child-list').hide();
					$(this).closest('.service-cat-list-wrapper').find("[data-parent_slug='" + slug + "']").show(); 

					// load ajax
					loader.addClass("is-active");
					$.ajax({
			            type: "post",
			            dataType: "html",
			            url: ova_sev_ajax_object.ajax_url,
			            data: {
			                action: 'ova_service_ajax',
			                cate_slug: slug,
			                posts_per_page: posts_per_page,
			                order: order,
			                orderby: orderby,
			                show_desc: show_desc
			            },
			            success: function(response){
			                wrap_results.html(response);
			                loader.removeClass("is-active");
			            }
			        });

				});

				item_child.click(function(e){
					// class active category
					$(".ova-service-ajax .service-cat-child-list .item-link").removeClass('active-category');
					$(this).addClass('active-category');

					var slug = $(this).data('slug');

					// load ajax
					loader.addClass("is-active");
					$.ajax({
			            type: "post",
			            dataType: "html",
			            url: ova_sev_ajax_object.ajax_url,
			            data: {
			                action: 'ova_service_ajax',
			                cate_slug: slug,
			                posts_per_page: posts_per_page,
			                order: order,
			                orderby: orderby,
			                show_desc: show_desc
			            },
			            success: function(response){
			                wrap_results.html(response);
			                loader.removeClass("is-active");
			            }
			        });
				});
		      
			});
		});
		
	});
})(jQuery);
