jQuery(document).ready(function($) {
	
	/* Service Pagination */
    $(document).on('click', ".ova_sev_pagination_ajax li .page-numbers", function (e) {    
        e.preventDefault();
        var wrapper     = $(this).closest('.ova-sev-archive');

        var dataArgs 	= $(document).find(".ova_sev_pagination_ajax").attr("data-args");
        var args 		= JSON.parse( dataArgs );

        var offset 		= parseInt( $(this).attr("data-offset") );
        var page 		= parseInt( $(this).attr("data-page") );
        var args_show   = JSON.parse(wrapper.attr("data-args_show"));
    
        var search_sort = $('.ova-sev-archive #search_sort select').find(":selected").val();
        if( typeof(search_sort) == "undefined" ) {
            search_sort = wrapper.attr("data-sort_default");
        }

        var sevContent 	= $(".ova-sev-archive .content_inner");
        var loader 		= $(".ova-sev-archive .ova-sev-loader .loader");

        if (page) {
        	loader.addClass("is-active");
        	sevContent.addClass("overlay");
            $('html, body').animate({
                scrollTop: $(".ova-sev-archive.has-sev-filter").offset().top
            });
            $.ajax({
                type: "post",
                dataType: "html",
                url: ova_sev_ajax_object.ajax_url,
                data: {
                    action: 'ova_sev_pagination_ajax',
                    args: args,
                    offset: offset,
                    page: page,
                    search_sort: search_sort,
                    args_show: args_show
                },
                success: function(response){
                	loader.removeClass("is-active");
                	sevContent.removeClass("overlay");
                    sevContent.html(response);
                }
            });
        }
        
    });

    /* Service Filter */
    $(document).on("submit",".ova-sev-archive #ova-sev-filter",function(e){
        e.preventDefault();
        var wrapper    = $(this).closest('.ova-sev-archive');

        var cateName   = $(this).find("#ovasev_name").val();
        var cateSlug   = $(this).find("#ovasev_category").val();
        var s_sort     = $('.ova-sev-archive #search_sort select').find(":selected").val();

        if( typeof(s_sort) == "undefined" ) {
            s_sort = wrapper.attr("data-sort_default");
        }

        var post_per_page = wrapper.data("post_per_page");

        var order      = wrapper.data("order");
        var order_by   = wrapper.data("order_by");
        var args_show  = JSON.parse(wrapper.attr("data-args_show"));

        var sevContent = $(".ova-sev-archive .content_inner");
        var loader     = $(".ova-sev-archive .ova-sev-loader .loader");

        sevContent.addClass("overlay");
        loader.addClass("is-active");

        var formData = {
            cate_name:cateName, 
            cate_slug:cateSlug, 
            post_per_page:post_per_page, 
            order:order, 
            order_by:order_by, 
            s_sort:s_sort,
            args_show: args_show
        };

        $.ajax({
            type: "post",
            dataType: "html",
            url: ova_sev_ajax_object.ajax_url,
            data: {
                action: 'ova_sev_filter_ajax',
                form_data: formData,
            },
            success: function(response){
                sevContent.removeClass("overlay");
                sevContent.html(response);
                loader.removeClass("is-active");
            }
        });
    });

    /* Select2*/
    if ($('.ovasev_cat').length > 0) {
        $('.ovasev_cat').select2({
            language: {
                inputTooShort: function() {
                    return Select2Text.input_short;
                },
                noResults: function (params) {
                  return Select2Text.no_results;
                }
            }
        });
    };

    /* Auto completed name - search form archive */
    var data_names = $('.ova-sev-archive.has-sev-filter').data('names');

    var data = [];
    for(var id in data_names){
        var child_data = {"id": id, "text": data_names[id]};
        data.push(child_data);
    }

    // select2
    if ($('.ova-sev-archive .ovasev_name').length > 0) {
        $('.ova-sev-archive .ovasev_name').select2({
            data: data,
            minimumInputLength: 1,
            maximumSelectionSize: 1,
            width: '100%',
            placeholder: Placeholder.name,
            language: {
                inputTooShort: function() {
                    return Select2Text.input_short;
                },
                noResults: function (params) {
                  return Select2Text.no_results;
                }
            }
        });
    }

    $('.ova-sev-archive .ovasev_name').on('change', function(e){
        e.preventDefault();
        var value = $(this).find("option:selected").text();
        $(this).val(value);
        $(this).find('option:selected').prop("selected", false);
    });

});