<?php
namespace ova_sev_elementor\Widgets;

use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class ova_sev_list extends Widget_Base {

	public function get_name() {
		return 'ova_sev_list';
	}

	public function get_title() {
		return esc_html__( 'Service List', 'ova-sev' );
	}

	public function get_icon() {
		return 'eicon-editor-list-ul';
	}

	public function get_categories() {
		return [ 'ovatheme_service' ];
	}

	public function get_script_depends() {
		return [ '' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'ova-sev-list', OVASEV_PLUGIN_URI.'/assets/css/elementor/sev-list.css', array(), null);
		return [];
	}

	protected function ova_sev_categories() {

		$cate_args = array(
			'taxonomy' => 'cat_sev',
			'orderby' => 'name',
			'order'   => 'ASC'
		);

		$categories = get_categories( $cate_args );
		$new_category = array( 'all'=> esc_html__('All', 'ova-sev') );
		if ( $categories ) {
			foreach ($categories as $key => $cate) {
				$new_category[$cate->slug] = $cate->name;
			}
		}
		return $new_category;
	}

	protected function register_controls() {

		/* Service */
		$this->start_controls_section(
				'sev_section',
				[
					'label' => esc_html__( 'Service', 'ova-sev' ),
					'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				]
			);

			$this->add_control(
				'template',
				[
					'label' => esc_html__( 'Template', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'template_1',
					'options' => [
						'template_1' => esc_html__( 'Template 1', 'ova-sev' ),
						'template_2' => esc_html__( 'Template 2', 'ova-sev' ),
					],
				]
			);

			$categories = $this->ova_sev_categories();

			$this->add_control(
				'cate',
				[
					'label' => esc_html__( 'Category', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'all',
					'options' => $categories,
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'column',
				[
					'label' => esc_html__( 'Columns', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'two_columns',
					'options' => [
						'one_column' => esc_html__( '1 Column', 'ova-sev' ),
						'two_columns' => esc_html__( '2 Columns', 'ova-sev' ),
					],
				]
			);

			$this->add_control(
				'order',
				[
					'label' => esc_html__( 'Order', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'DESC',
					'options' => [
						'ASC' => esc_html__( 'Ascending', 'ova-sev' ),
						'DESC' => esc_html__( 'Descending', 'ova-sev' ),
					],
				]
			);

			$this->add_control(
				'order_by',
				[
					'label' => esc_html__( 'Order By', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'date',
					'options' => [
						'ID'  	=> esc_html__( 'ID', 'ova-sev' ),
						'date'  => esc_html__( 'Date', 'ova-sev' ),
						'title' => esc_html__( 'Title', 'ova-sev' ),
						'rand'  => esc_html__( 'Random', 'ova-sev' ),
						'ova_sev_met_order_sev' => esc_html__( 'Sort Order', 'ova-sev' ),
					],
				]
			);

			$this->add_control(
				'posts_per_page',
				[
					'label' => esc_html__( 'Total', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::NUMBER,
					'default' => 12,
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'show_icon',
				[
					'label' => esc_html__( 'Show Icon', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-sev' ),
					'label_off' => esc_html__( 'Hide', 'ova-sev' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

		$this->end_controls_section();

		/* General */
		$this->start_controls_section(
				'sev_style_section',
				[
					'label' => esc_html__( 'General', 'ova-sev' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'sev_padding',
				[
					'label' => esc_html__( 'Padding', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-sev-list' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .ova-sev-list.template_2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name' => 'sev_border',
					'selector' => '{{WRAPPER}} .ova-sev-list,{{WRAPPER}} .ova-sev-list.template_2',
				]
			);

			$this->add_control(
				'sev_bg',
				[
					'label' => esc_html__( 'Background', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-sev-list' => 'background: {{VALUE}}',
						'{{WRAPPER}} .ova-sev-list.template_2' => 'background: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Item */
		$this->start_controls_section(
				'item_style_section',
				[
					'label' => esc_html__( 'Item', 'ova-sev' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'item_padding',
				[
					'label' => esc_html__( 'Padding', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-sev-list .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .ova-sev-list.template_2 .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name' => 'item_border',
					'selector' => '{{WRAPPER}} .ova-sev-list .title,{{WRAPPER}} .ova-sev-list.template_2 .title',
				]
			);

			$this->start_controls_tabs(
					'item_style_tabs'
				);

				$this->start_controls_tab(
					'item_style_normal_tab',
					[
						'label' => esc_html__( 'Normal', 'ova-sev' ),
					]
				);

				$this->add_control(
					'item_color',
					[
						'label' => esc_html__( 'Color', 'ova-sev' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-sev-list .title' => 'color: {{VALUE}}',
							'{{WRAPPER}} .ova-sev-list.template_2 .title' => 'color: {{VALUE}}',
						],
					]
				);

				$this->add_control(
					'item_bg',
					[
						'label' => esc_html__( 'Background', 'ova-sev' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-sev-list .title' => 'background: {{VALUE}}',
							'{{WRAPPER}} .ova-sev-list.template_2 .title' => 'background: {{VALUE}}',
						],
					]
				);

			$this->end_controls_tab();

			$this->start_controls_tab(
					'item_style_hover_tab',
					[
						'label' => esc_html__( 'Hover', 'ova-sev' ),
					]
				);

				$this->add_control(
					'item_hover_color',
					[
						'label' => esc_html__( 'Color', 'ova-sev' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-sev-list .title:hover' => 'color: {{VALUE}}',
							'{{WRAPPER}} .ova-sev-list.template_2 .title:hover' => 'color: {{VALUE}}',
							'{{WRAPPER}} .ova-sev-list .title:hover' => 'border-bottom-color: {{VALUE}}',
							'{{WRAPPER}} .ova-sev-list.template_2 .title:hover' => 'border-bottom-color: {{VALUE}}',
						],
					]
				);

				$this->add_control(
					'item_hover_bg',
					[
						'label' => esc_html__( 'Background', 'ova-sev' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-sev-list .title:hover' => 'background: {{VALUE}}',
							'{{WRAPPER}} .ova-sev-list.template_2 .title:hover' => 'background: {{VALUE}}',
						],
					]
				);

			$this->end_controls_tab();

			$this->end_controls_tabs();

		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();
		$template = apply_filters( 'el_elementor_ova_sev_list', 'elementor/ova_sev_list.php' );

		ob_start();
		ovasev_get_template( $template, $settings );
		echo ob_get_clean();
	}
}
