<?php
namespace ova_sev_elementor\Widgets;

use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class ova_sev_list_box extends Widget_Base {

	public function get_name() {
		return 'ova_sev_list_box';
	}

	public function get_title() {
		return esc_html__( 'Service List Box', 'ova-sev' );
	}

	public function get_icon() {
		return 'eicon-flip-box';
	}

	public function get_categories() {
		return [ 'ovatheme_service' ];
	}

	public function get_script_depends() {
		return [ '' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'ova-sev-list-box', OVASEV_PLUGIN_URI.'/assets/css/elementor/sev-list-box.css', array(), null);
		return [];
	}

	protected function ova_sev_categories() {

		$cate_args = array(
			'taxonomy' => 'cat_sev',
			'orderby' => 'name',
			'order'   => 'ASC'
		);

		$categories = get_categories( $cate_args );
		$new_category = array( 'all'=> esc_html__('All', 'ova-sev') );
		if ( $categories ) {
			foreach ($categories as $key => $cate) {
				$new_category[$cate->slug] = $cate->name;
			}
		}
		return $new_category;
	}

	protected function register_controls() {

		/* Content */
		$this->start_controls_section(
				'content_section',
				[
					'label' => esc_html__( 'Content', 'ova-sev' ),
					'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				]
			);

			$this->add_control(
				'title',
				[
					'label' => esc_html__( 'Title', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Online services', 'ova-sev' ),
				]
			);

			$this->add_control(
				'link',
				[
					'label' => esc_html__( 'Link', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::URL,
					'placeholder' => esc_html__( 'https://your-link.com', 'ova-sev' ),
					'options' => [ 'url', 'is_external', 'nofollow' ],
					'default' => [
						'url' => '#',
						'is_external' => true,
						'nofollow' => false,
					],
					'label_block' => true,
				]
			);

			$this->add_control(
				'text_btn',
				[
					'label' => esc_html__( 'Text Button', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Discover More', 'ova-sev' ),
				]
			);

			$this->add_control(
				'show_icon',
				[
					'label' => esc_html__( 'Show Icon', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-sev' ),
					'label_off' => esc_html__( 'Hide', 'ova-sev' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

		$this->end_controls_section();

		/* Service */
		$this->start_controls_section(
				'sev_section',
				[
					'label' => esc_html__( 'Service', 'ova-sev' ),
					'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				]
			);

			$categories = $this->ova_sev_categories();

			$this->add_control(
				'cate',
				[
					'label' => esc_html__( 'Category', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'all',
					'options' => $categories,
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'columns',
				[
					'label' => esc_html__( 'Columns', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'three_columns',
					'options' => [
						'two_columns' => esc_html__( '2', 'ova-sev' ),
						'three_columns' => esc_html__( '3', 'ova-sev' ),
						'four_columns' => esc_html__( '4', 'ova-sev' ),
					],
				]
			);

			$this->add_control(
				'order',
				[
					'label' => esc_html__( 'Order', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'DESC',
					'options' => [
						'ASC' => esc_html__( 'Ascending', 'ova-sev' ),
						'DESC' => esc_html__( 'Descending', 'ova-sev' ),
					],
				]
			);

			$this->add_control(
				'order_by',
				[
					'label' => esc_html__( 'Order By', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'date',
					'options' => [
						'ID'  	=> esc_html__( 'ID', 'ova-sev' ),
						'date'  => esc_html__( 'Date', 'ova-sev' ),
						'title' => esc_html__( 'Title', 'ova-sev' ),
						'rand'  => esc_html__( 'Random', 'ova-sev' ),
						'ova_sev_met_order_sev' => esc_html__( 'Sort Order', 'ova-sev' ),
					],
				]
			);

			$this->add_control(
				'posts_per_page',
				[
					'label' => esc_html__( 'Total', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::NUMBER,
					'min' => 1,
					'max' => 10,
					'step' => 1,
					'default' => 6,
					'frontend_available' => true,
				]
			);

		$this->end_controls_section();

		/* General */
		$this->start_controls_section(
				'sev_style_section',
				[
					'label' => esc_html__( 'General', 'ova-sev' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'sev_padding',
				[
					'label' => esc_html__( 'Padding', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-sev-list-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'sev_bg',
				[
					'label' => esc_html__( 'Background', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-sev-list-box' => 'background: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Title */
		$this->start_controls_section(
				'title_style_section',
				[
					'label' => esc_html__( 'Title', 'ova-sev' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'title_margin',
				[
					'label' => esc_html__( 'Margin', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-sev-list-box .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'title_typography',
					'selector' => '{{WRAPPER}} .ova-sev-list-box .title',
				]
			);

			$this->add_control(
				'title_color',
				[
					'label' => esc_html__( 'Color', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-sev-list-box .title' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Item */
		$this->start_controls_section(
				'item_style_section',
				[
					'label' => esc_html__( 'Item', 'ova-sev' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'item_padding',
				[
					'label' => esc_html__( 'Padding', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-sev-list-box .sev-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name' => 'item_border',
					'selector' => '{{WRAPPER}} .ova-sev-list-box .sev-link',
				]
			);

			$this->start_controls_tabs(
					'item_style_tabs'
				);

				$this->start_controls_tab(
					'item_style_normal_tab',
					[
						'label' => esc_html__( 'Normal', 'ova-sev' ),
					]
				);

				$this->add_control(
					'item_color',
					[
						'label' => esc_html__( 'Color', 'ova-sev' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-sev-list-box .sev-link' => 'color: {{VALUE}}',
						],
					]
				);

				$this->add_control(
					'item_bg',
					[
						'label' => esc_html__( 'Background', 'ova-sev' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-sev-list-box .sev-link' => 'background: {{VALUE}}',
						],
					]
				);

			$this->end_controls_tab();

			$this->start_controls_tab(
					'item_style_hover_tab',
					[
						'label' => esc_html__( 'Hover', 'ova-sev' ),
					]
				);

				$this->add_control(
					'item_hover_color',
					[
						'label' => esc_html__( 'Color', 'ova-sev' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-sev-list-box .sev-link:hover' => 'color: {{VALUE}}',
						],
					]
				);

				$this->add_control(
					'item_hover_bg',
					[
						'label' => esc_html__( 'Background', 'ova-sev' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-sev-list-box .sev-link:hover' => 'background: {{VALUE}}',
						],
					]
				);

			$this->end_controls_tab();

			$this->end_controls_tabs();

		$this->end_controls_section();

		/* Text Button */
		$this->start_controls_section(
				'text_btn_style_section',
				[
					'label' => esc_html__( 'Text Button', 'ova-sev' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'text_btn_margin',
				[
					'label' => esc_html__( 'Margin', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-sev-list-box .link-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'text_btn_padding',
				[
					'label' => esc_html__( 'Padding', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-sev-list-box .link-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'text_btn_typography',
					'selector' => '{{WRAPPER}} .ova-sev-list-box .link-btn',
				]
			);

			$this->start_controls_tabs(
					'text_btn_style_tabs'
				);

				$this->start_controls_tab(
					'text_btn_style_normal_tab',
					[
						'label' => esc_html__( 'Normal', 'ova-sev' ),
					]
				);

				$this->add_control(
					'text_btn_color',
					[
						'label' => esc_html__( 'Color', 'ova-sev' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-sev-list-box .link-btn' => 'color: {{VALUE}}',
						],
					]
				);

				$this->add_control(
					'text_btn_bg',
					[
						'label' => esc_html__( 'Background', 'ova-sev' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-sev-list-box .link-btn' => 'background: {{VALUE}}',
						],
					]
				);

			$this->end_controls_tab();

			$this->start_controls_tab(
					'text_btn_style_hover_tab',
					[
						'label' => esc_html__( 'Hover', 'ova-sev' ),
					]
				);

				$this->add_control(
					'text_btn_hover_color',
					[
						'label' => esc_html__( 'Color', 'ova-sev' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-sev-list-box .link-btn:hover' => 'color: {{VALUE}}',
						],
					]
				);

				$this->add_control(
					'text_btn_hover_bg',
					[
						'label' => esc_html__( 'Background', 'ova-sev' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-sev-list-box .link-btn:hover' => 'background: {{VALUE}}',
						],
					]
				);

			$this->end_controls_tab();

			$this->end_controls_tabs();

		$this->end_controls_section();

	}


	protected function render() {
		$settings = $this->get_settings_for_display();
		$template = apply_filters( 'el_elementor_ova_sev_list_box', 'elementor/ova_sev_list_box.php' );

		ob_start();
		ovasev_get_template( $template, $settings );
		echo ob_get_clean();
	}
}
