<?php
/*
Plugin Name: Ovatheme Service
Plugin URI: https://themeforest.net/user/ovatheme
Description: Service
Author: Ovatheme
Version: 1.0.7
Author URI: https://themeforest.net/user/ovatheme/portfolio
Text Domain: ova-sev
Domain Path: /languages/
*/

if ( !defined( 'ABSPATH' ) ) exit();


if (!class_exists('ovasev')) {
	
	class ovasev
	{
		static $_instance = null;

		function __construct()
		{
			$this -> define_constants();
			$this -> includes();
			$this -> supports();
		}

		function define_constants(){
			$this->define( 'OVASEV_PLUGIN_FILE', __FILE__ );
			$this->define( 'OVASEV_PLUGIN_URI', plugin_dir_url( __FILE__ ) );
			$this->define( 'OVASEV_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
			load_plugin_textdomain( 'ova-sev', false, basename( dirname( __FILE__ ) ) .'/languages' );
		}

		function define( $name, $value ) {
			if ( ! defined( $name ) ) {
				define( $name, $value );
			}
		}

		public static function instance() {
			if ( !empty( self::$_instance ) ) {
				return self::$_instance;
			}
			return self::$_instance = new self();
		}

		function includes() {

			// inc
			require_once( OVASEV_PLUGIN_PATH.'inc/class-ova-custom-post-type.php' );

			require_once( OVASEV_PLUGIN_PATH.'inc/class-ova-register-sidebar.php' );

			require_once( OVASEV_PLUGIN_PATH.'inc/class-ova-get-data.php' );

			require_once( OVASEV_PLUGIN_PATH.'inc/ova-core-functions.php' );
			
			require_once( OVASEV_PLUGIN_PATH.'inc/class-ova-templates-loaders.php' );

			require_once( OVASEV_PLUGIN_PATH.'inc/class-ova-assets.php' );

			require_once( OVASEV_PLUGIN_PATH.'inc/class-ova-ajax.php' );


			// admin
			require_once( OVASEV_PLUGIN_PATH.'admin/class-ova-metabox.php' );

			/* Customize */

			// if( current_user_can('customize') ){
			    require_once OVASEV_PLUGIN_PATH.'/inc/class-customize.php';
			// }

		}


		function supports() {

			/* Make Elementors */
			if ( did_action( 'elementor/loaded' ) ) {
				include OVASEV_PLUGIN_PATH.'elementor/class-ova-register-elementor.php';
			}

			add_image_size( 'ova_sev_thumbnail', 450, 300, true );

		}

	}
}

function ovasev() {
	return ovasev::instance();
}

$GLOBALS['ovasev'] = ovasev();