<?php if ( !defined( 'ABSPATH' ) ) exit();

get_header( );

	$id = get_the_ID();

	$sidebar = isset($_GET['single_service_sidebar']) ? $_GET['single_service_sidebar'] : get_theme_mod( 'ova_sev_sidebar_2', 'no_sidebar' );

	// show fields
	$show_thumbnail = get_theme_mod( 'ova_sev_single_show_featured_image', 'yes' );
	$show_title     = get_theme_mod( 'ova_sev_single_show_title', 'yes' );
	$show_excerpt   = get_theme_mod( 'ova_sev_single_show_excerpt', 'yes' );
	$show_content   = get_theme_mod( 'ova_sev_single_show_content', 'yes' );
	$show_share     = get_theme_mod( 'ova_sev_single_show_share', 'yes' );
	$show_comments 	= get_theme_mod( 'ova_sev_comments', 'yes' );


	if ( has_post_thumbnail( $id ) && $show_thumbnail == 'yes' ) {
		$image_id 	= get_post_thumbnail_id( $id );
		$image_src 	= get_the_post_thumbnail_url( $id, 'full' );
	} else {
		$image_src = '';
	}

?>

<div class="ova-sev-single-2">

	<div class="hero-banner-wrapper">
		<?php if($show_title == 'yes' || $show_excerpt == 'yes' || $image_src != '') { ?>
			<div class="hero-banner" style="background-image:url(<?php echo esc_url( $image_src ); ?>);">
				<?php if($show_title == 'yes' || $show_excerpt == 'yes' ) { ?>
					<div class="wrap-title">
						<?php if($show_title == 'yes') { ?>
							<h1 class="title">
								<?php the_title(); ?>
							</h1>
						<?php } ?>

						<?php if($show_excerpt == 'yes') {
							the_excerpt(); 
						} ?>
					</div>
				<?php } ?>
			</div>
		<?php } ?>

		<?php if( has_filter( 'ova_share_social' ) && $show_share == 'yes' ){ 
			apply_filters( 'ova_share_social', get_the_permalink(), get_the_title() );
	    } ?>
	</div>

	<div class="row_site">
		<div class="container_site">

			<div class="ova-sev-wrapper <?php printf( '%1$s', $sidebar ); ?>">

				<?php if ( $sidebar == 'left_sidebar' && is_active_sidebar( 'ova-sev-sidebar' ) ) { ?>
					<div class="ova-sev-sidebar-wrapper">
						<div class="ova-sev-sidebar">
							<?php dynamic_sidebar('ova-sev-sidebar'); ?>
						</div>
					</div>
				<?php } ?>

				<div class="ova-sev-content">
					<?php if($show_content == 'yes') { ?>
						<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
							<div class="content">
								<?php the_content(); ?>
							</div>
						<?php endwhile; endif; wp_reset_postdata(); ?>
					<?php } ?>

			        <?php
				        if ( $show_comments == 'yes' ) {
				        	if( comments_open( get_the_ID() ) ) {
					        	comments_template(); 
					        }
				        }
			        ?>
				</div>

				<?php if ( $sidebar == 'right_sidebar' && is_active_sidebar( 'ova-sev-sidebar' ) ) { ?>
					<div class="ova-sev-sidebar-wrapper">
						<div class="ova-sev-sidebar">
							<?php dynamic_sidebar('ova-sev-sidebar'); ?>
						</div>
					</div>
				<?php } ?>

			</div>

		</div>
	</div>

</div>

<?php get_footer();