<?php
namespace ova_doc_elementor\Widgets;

use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class ova_doc_download_3 extends Widget_Base {

	public function get_name() {
		return 'ova_doc_download_3';
	}

	public function get_title() {
		return esc_html__( 'Document Download 3 - Slide', 'ova-doc' );
	}

	public function get_icon() {
		return 'eicon-posts-carousel';
	}

	public function get_categories() {
		return [ 'ovatheme_doc' ];
	}

	public function get_script_depends() {
		wp_enqueue_script('ovadoc-download-3', OVADOC_PLUGIN_URI . 'assets/js/elementor/ova-doc-download-3.js', array('jquery'), false, true);	
		wp_enqueue_script('ova_show_doc_script', OVADOC_PLUGIN_URI . 'assets/js/show-document.js', array('jquery'), false, true);
		wp_localize_script( 'ova_show_doc_script', 'ova_doc_ajax_object', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
		return [ '' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'ovadoc-download-3', OVADOC_PLUGIN_URI.'assets/css/elementor/ova-doc-download-3.css' );	
		wp_enqueue_style( 'ova_show_doc_style', OVADOC_PLUGIN_URI.'assets/css/frontend/show-document.css' );
		return [];
	}

	protected function ova_doc_categories() {

		$cate_args = array(
			'taxonomy' => 'cat_doc',
			'orderby' => 'name',
			'order'   => 'ASC'
		);

		$categories = get_categories( $cate_args );
		$new_category = array( 'all'=> esc_html__('All', 'ova-doc') );
		if ( $categories ) {
			foreach ($categories as $key => $cate) {
				$new_category[$cate->slug] = $cate->name;
			}
		}
		return $new_category;
	}

	protected function register_controls() {

		/* Document */
		$this->start_controls_section(
				'doc_section',
				[
					'label' => esc_html__( 'Document', 'ova-doc' ),
					'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				]
			);

			$this->add_control(
				'order',
				[
					'label' => esc_html__( 'Order', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'DESC',
					'options' => [
						'ASC' => esc_html__( 'Ascending', 'ova-doc' ),
						'DESC' => esc_html__( 'Descending', 'ova-doc' ),
					],
				]
			);

			$this->add_control(
				'order_by',
				[
					'label' => esc_html__( 'Order By', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'ID',
					'options' => [
						'ova_doc_met_order_doc' 	=> esc_html__( 'Sort Order', 'ova-doc' ),
						'ova_doc_met_publish_date' 	=> esc_html__( 'Published Date', 'ova-doc' ),
						'ID'  						=> esc_html__( 'ID', 'ova-doc' ),
						'date'  					=> esc_html__( 'Date', 'ova-doc' ),
						'title' 					=> esc_html__( 'Title', 'ova-doc' ),
						'rand'  					=> esc_html__( 'Random', 'ova-doc' ),
					],
				]
			);

			$this->add_control(
				'posts_per_page',
				[
					'label' => esc_html__( 'Document Items', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::NUMBER,
					'min' => 1,
					'max' => 10,
					'step' => 1,
					'default' => 4,
					'frontend_available' => true,
				]
			);

			$categories = $this->ova_doc_categories();

			$this->add_control(
				'cate',
				[
					'label' => esc_html__( 'Category', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'all',
					'options' => $categories,
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'show_date',
				[
					'label' => esc_html__( 'Show Date', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-doc' ),
					'label_off' => esc_html__( 'Hide', 'ova-doc' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_view_icon',
				[
					'label' => esc_html__( 'Show View Icon', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-doc' ),
					'label_off' => esc_html__( 'Hide', 'ova-doc' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_download_icon',
				[
					'label' => esc_html__( 'Show Download Icon', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-doc' ),
					'label_off' => esc_html__( 'Hide', 'ova-doc' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_title',
				[
					'label' => esc_html__( 'Show Title', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-doc' ),
					'label_off' => esc_html__( 'Hide', 'ova-doc' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_link_to',
				[
					'label' => esc_html__( 'Show Link of Title', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-doc' ),
					'label_off' => esc_html__( 'Hide', 'ova-doc' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

		$this->end_controls_section();

		/* Additional Options */
		$this->start_controls_section(
				'section_additional_options',
				[
					'label' => esc_html__( 'Additional Options', 'ova-doc' ),
				]
			);

			$this->add_control(
				'margin_items',
				[
					'label'   => esc_html__( 'Space between 2 items', 'ova-doc' ),
					'type'    => \Elementor\Controls_Manager::NUMBER,
					'default' => 7,
					'frontend_available' => true,
				]
				
			);

			$this->add_control(
				'item_number',
				[
					'label'       => esc_html__( 'Number of Items', 'ova-doc' ),
					'type'        => \Elementor\Controls_Manager::NUMBER,
					'description' => esc_html__( 'Number of Items', 'ova-doc' ),
					'default'     => 2,
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'slides_to_scroll',
				[
					'label'       => esc_html__( 'Slides to Scroll', 'ova-doc' ),
					'type'        => \Elementor\Controls_Manager::NUMBER,
					'description' => esc_html__( 'Set how many slides are scrolled per swipe.', 'ova-doc' ),
					'default'     => 1,
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'pause_on_hover',
				[
					'label'   => esc_html__( 'Pause on Hover', 'ova-doc' ),
					'type'    => \Elementor\Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'ova-doc' ),
						'no'  => esc_html__( 'No', 'ova-doc' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'infinite',
				[
					'label'   => esc_html__( 'Infinite Loop', 'ova-doc' ),
					'type'    => \Elementor\Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'ova-doc' ),
						'no'  => esc_html__( 'No', 'ova-doc' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'autoplay',
				[
					'label'   => esc_html__( 'Autoplay', 'ova-doc' ),
					'type'    => \Elementor\Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'ova-doc' ),
						'no'  => esc_html__( 'No', 'ova-doc' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'autoplay_speed',
				[
					'label'     => esc_html__( 'Autoplay Speed', 'ova-doc' ),
					'type'      => \Elementor\Controls_Manager::NUMBER,
					'default'   => 3000,
					'step'      => 500,
					'condition' => [
						'autoplay' => 'yes',
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'smartspeed',
				[
					'label'   => esc_html__( 'Smart Speed', 'ova-doc' ),
					'type'    => \Elementor\Controls_Manager::NUMBER,
					'default' => 500,
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'dot_control',
				[
					'label'   => esc_html__( 'Show Dots', 'ova-doc' ),
					'type'    => \Elementor\Controls_Manager::SWITCHER,
					'default' => 'no',
					'options' => [
						'yes' => esc_html__( 'Yes', 'ova-doc' ),
						'no'  => esc_html__( 'No', 'ova-doc' ),
					],
					'frontend_available' => true,
				]
			);

		$this->end_controls_section();

		/* Items */
		$this->start_controls_section(
				'items_style_section',
				[
					'label' => esc_html__( 'Items', 'ova-doc' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'items_margin',
				[
					'label' => esc_html__( 'Margin', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-doc-download-3 .document-slider .item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'items_padding',
				[
					'label' => esc_html__( 'Padding', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-doc-download-3 .document-slider .item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->start_controls_tabs(
					'items_style_tabs'
				);

				$this->start_controls_tab(
					'items_style_normal_tab',
					[
						'label' => esc_html__( 'Normal', 'ova-doc' ),
					]
				);

				$this->add_control(
					'items_bg',
					[
						'label' => esc_html__( 'Background', 'ova-doc' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-doc-download-3 .document-slider .item' => 'background: {{VALUE}}',
						],
					]
				);

				$this->end_controls_tab();

				$this->start_controls_tab(
						'items_style_hover_tab',
						[
							'label' => esc_html__( 'Hover', 'ova-doc' ),
						]
					);

				$this->add_control(
					'items_bg_hover',
					[
						'label' => esc_html__( 'Background', 'ova-doc' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-doc-download-3 .document-slider .item:hover' => 'background: {{VALUE}}',
						],
					]
				);

				$this->end_controls_tab();

			$this->end_controls_tabs();

		$this->end_controls_section();

		/* Icon View */
		$this->start_controls_section(
				'icon_view_style_section',
				[
					'label' => esc_html__( 'Icon View', 'ova-doc' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'icon_view_margin',
				[
					'label' => esc_html__( 'Margin', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-doc-download-3 .document-slider .view' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'icon_view_size',
				[
					'label' => esc_html__( 'Size', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 50,
							'step' => 5,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ova-doc-download-3 .document-slider .view i' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->start_controls_tabs(
					'icon_view_style_tabs'
				);

				$this->start_controls_tab(
					'icon_view_style_normal_tab',
					[
						'label' => esc_html__( 'Normal', 'ova-doc' ),
					]
				);

				$this->add_control(
					'icon_view_color',
					[
						'label' => esc_html__( 'Color', 'ova-doc' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-doc-download-3 .document-slider .view i' => 'color: {{VALUE}}',
						],
					]
				);

				$this->end_controls_tab();

				$this->start_controls_tab(
						'icon_view_style_hover_tab',
						[
							'label' => esc_html__( 'Hover', 'ova-doc' ),
						]
					);

				$this->add_control(
					'icon_view_color_hover',
					[
						'label' => esc_html__( 'Color', 'ova-doc' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-doc-download-3 .document-slider .view:hover i' => 'color: {{VALUE}}',
						],
					]
				);

				$this->end_controls_tab();

			$this->end_controls_tabs();

		$this->end_controls_section();

		/* Date */
		$this->start_controls_section(
				'date_style_section',
				[
					'label' => esc_html__( 'Date', 'ova-doc' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'date_margin',
				[
					'label' => esc_html__( 'Margin', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-doc-download-3 .document-slider .date' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'date_typography',
					'selector' => '{{WRAPPER}} .ova-doc-download-3 .document-slider .date',
				]
			);

			$this->add_control(
				'date_color',
				[
					'label' => esc_html__( 'Color', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-doc-download-3 .document-slider .date' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Title */
		$this->start_controls_section(
				'title_style_section',
				[
					'label' => esc_html__( 'Title', 'ova-doc' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'title_margin',
				[
					'label' => esc_html__( 'Margin', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-doc-download-3 .document-slider .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'title_typography',
					'selector' => '{{WRAPPER}} .ova-doc-download-3 .document-slider .title',
				]
			);

			$this->add_control(
				'title_color',
				[
					'label' => esc_html__( 'Color', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-doc-download-3 .document-slider .title' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Icon Download */
		$this->start_controls_section(
				'icon_down_style_section',
				[
					'label' => esc_html__( 'Icon Download', 'ova-doc' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'icon_down_margin',
				[
					'label' => esc_html__( 'Margin', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-doc-download-3 .document-slider .icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'icon_down_border_radius',
				[
					'label' => esc_html__( 'Border Radius', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-doc-download-3 .document-slider .icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'icon_down_size',
				[
					'label' => esc_html__( 'Size', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 40,
							'step' => 5,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ova-doc-download-3 .document-slider .icon' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'icon_down_color',
				[
					'label' => esc_html__( 'Color', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-doc-download-3 .document-slider .icon' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'icon_down_bg',
				[
					'label' => esc_html__( 'Background', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-doc-download-3 .document-slider .icon' => 'background: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();
		$template = apply_filters( 'el_elementor_ova_doc_download3', 'elementor/ova_doc_download_3.php' );

		ob_start();
		ovadoc_get_template( $template, $settings );
		echo ob_get_clean();
	}
}
