<?php if ( !defined( 'ABSPATH' ) ) exit(); 

get_header( );

$number_column 	= get_theme_mod( 'ova_doc_layout', 'two_column' );
$sidebar		= get_theme_mod( 'ova_doc_archive_sidebar', 'left_sidebar' );

$cate_slug 		= get_query_var('cat_doc') ? get_query_var('cat_doc') : 'all';

$posts_per_page = get_theme_mod( 'ova_doc_total_record', 8 );
$orderby 		= get_theme_mod( 'ova_doc_orderby', 'ID' );
$order 			= get_theme_mod( 'ova_doc_order', 'DESC' );

$args = array(
	'order_by' 			=> $orderby,
	'order' 			=> $order,
	'posts_per_page' 	=> $posts_per_page,
	'cate' 				=> $cate_slug,
);

$documents = ova_doc_query( $args );

// show fields
$args_show = array(
	'show_date' 		 => get_theme_mod( 'ova_doc_archive_show_date', 'yes' ),
	'show_title' 		 => get_theme_mod( 'ova_doc_archive_show_title', 'yes' ),
	'show_link_to' 	     => get_theme_mod( 'ova_doc_archive_show_link_of_title', 'yes' ),
	'show_view_icon' 	 => get_theme_mod( 'ova_doc_archive_show_view_icon', 'yes' ),
	'show_download_icon' => get_theme_mod( 'ova_doc_archive_show_download_icon', 'yes' ),
);

$show_search_name     = get_theme_mod( 'ova_doc_archive_show_search_name', 'yes' );
$show_search_date     = get_theme_mod( 'ova_doc_archive_show_search_date', 'yes' );
$show_search_category = get_theme_mod( 'ova_doc_archive_show_search_category', 'yes' );

// get document list names
$all_ids   = ova_doc_get_all_id();
$all_names = [];

foreach ($all_ids as $id ) {
	$all_names[$id] = get_the_title($id);
}

// caleran config
$range_label  = esc_html__('Ranges:','ova-doc');
$ranges_title = array(
	esc_html__('Today','ova-doc'),
	esc_html__('3 Days','ova-doc'),
	esc_html__('5 Days','ova-doc'),
	esc_html__('1 Week','ova-doc'),
	esc_html__('Till Next Week','ova-doc'),
	esc_html__('Till Next Month','ova-doc'),
);

?>

<div class="ova-doc-archive <?php printf( '%1$s', $number_column ); ?>" data-names="<?php echo esc_attr(json_encode($all_names)); ?>">
	<div class="row_site">
		<div class="container_site">

			<div class="ova-doc-wrapper <?php printf( 'archive_%1$s', $sidebar ); ?>">
				<?php if ( $sidebar == 'left_sidebar' && is_active_sidebar( 'ova-doc-sidebar' ) ) { ?>
					<div class="ova-doc-sidebar-wrapper">
						<div class="ova-doc-sidebar">
							<?php dynamic_sidebar('ova-doc-sidebar'); ?>
						</div>
					</div>
				<?php } ?>

				<div class="ova-doc-content">
					<?php if($show_search_name == 'yes' || $show_search_date == 'yes' || $show_search_category == 'yes' ) : ?>
						<form id="ova-doc-filter" class="ova-doc-filter" method="POST" autocomplete="off">
							<div class="wrapper">
								<?php if($show_search_name == 'yes' ) : ?>
									<div class="form-control name_control">
										<label for="name"><?php esc_html_e( 'Name', 'ova-doc' ); ?></label>
										<input type="text" name="s" class="ovadoc_name" id="ovadoc_name">
									</div>
								<?php endif; ?>

								<?php if($show_search_date == 'yes' ) : ?>
									<div class="form-control">
										<label for="date">
											<?php esc_html_e( 'Published Date', 'ova-doc' ); ?>
										</label>
										<div class="date-control" data-locale="<?php echo esc_attr( get_locale() );?>"
											data-range_label="<?php echo esc_attr($range_label);?>"
											data-ranges_title="<?php echo esc_attr(json_encode($ranges_title));?>"
										>
											<input type="text" name="date" id="ovadoc_date">
											<div class="icon">
												<i class="far fa-calendar-alt" aria-hidden="true"></i>
											</div>
										</div>
									</div>
								<?php endif; ?>

								<?php if($show_search_category == 'yes' ) : ?>
									<div class="form-control">
										<label for="category">
											<?php esc_html_e( 'Category', 'ova-doc' ); ?>	
										</label>
										<?php $ovadoc_cat_dropdown = apply_filters( 'ovadoc_cat_dropdown', $cate_slug ); ?>
									</div>
								<?php endif; ?>

								<div class="form-control">
									<button type="submit" class="ova-doc-submit">
										<?php esc_html_e( 'Find Document', 'ova-doc' ); ?>	
									</button>
								</div>
							</div>
						</form>
					<?php endif; ?>

					<span class="loader doc_loader"></span>

					<div class="content_inner" data-args_show="<?php echo esc_attr( json_encode($args_show) );?>">
						<?php
							$total_pages 	= $documents->max_num_pages;
							$curent_page 	= 1;
							ob_start();
							ova_get_doc_list( $documents, 'all', $args_show );
							ova_doc_pagination_ajax($total_pages,$curent_page,$posts_per_page,$args);
							echo ob_get_clean();
						?>
					</div>
				</div>

				<?php if ( $sidebar == 'right_sidebar' && is_active_sidebar( 'ova-doc-sidebar' ) ) { ?>
					<div class="ova-doc-sidebar-wrapper">
						<div class="ova-doc-sidebar">
							<?php dynamic_sidebar('ova-doc-sidebar'); ?>
						</div>
					</div>
				<?php } ?>
			</div>

			<div class="ova-doc-modal"></div>

		</div>
	</div>
</div>

<?php get_footer( );