<?php

if (!defined( 'ABSPATH' )) {
	exit;
}
if (!class_exists( 'Ova_Career_Customize' )){

	class Ova_Career_Customize {

		public function __construct() {
			add_action( 'customize_register', array( $this, 'ova_career_customize_register' ) );
		}

		public function ova_career_customize_register($wp_customize) {

			$this->ova_career_init( $wp_customize );

			do_action( 'ova_career_customize_register', $wp_customize );
		}


		public function ova_career_init( $wp_customize ){

			$wp_customize->add_panel( 'ova_career_panel', array(
			  	'title' => esc_html__( 'Career', 'ova-career' ),
			  	'priority' => 10,
			) );

			$wp_customize->add_section( 'ova_career_map_section' , array(
				'title'      => esc_html__( 'Google Map', 'ova-career' ),
				'priority'   => 20,
				'panel' => 'ova_career_panel',
			) );

			$wp_customize->add_section( 'ova_career_section' , array(
				'title'      => esc_html__( 'Archive', 'ova-career' ),
				'priority'   => 20,
				'panel' => 'ova_career_panel',
			) );

			$wp_customize->add_section( 'ova_career_single_section' , array(
				'title'      => esc_html__( 'Single', 'ova-career' ),
				'priority'   => 20,
				'panel' => 'ova_career_panel',
			) );

			// Map
			$wp_customize->add_setting( 'ova_career_use_google_map', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'yes',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('ova_career_use_google_map', array(
				'label' 	=> esc_html__('Use Google Map','ova-career'),
				'section' 	=> 'ova_career_map_section',
				'settings' 	=> 'ova_career_use_google_map',
				'type' 		=>'select',
				'choices' 	=> array(
					'yes' 	=> esc_html__( 'Yes', 'ova-career' ),
					'no' 	=> esc_html__( 'No', 'ova-career' ),
				)
			));

			$wp_customize->add_setting( 'ova_career_google_key_map', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => '',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name  
			) );

			$wp_customize->add_control('ova_career_google_key_map', array(
				'label' => esc_html__('Google Key Map','ova-career'),
				'section' => 'ova_career_map_section',
				'settings' => 'ova_career_google_key_map',
				'type' =>'text',
				'description' => esc_html__('You can get here: https://developers.google.com/maps/documentation/javascript/get-api-key','ova-career'),
			));

			$wp_customize->add_setting( 'ova_career_zoom_map_default', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 17,
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name  
			) );

			$wp_customize->add_control('ova_career_zoom_map_default', array(
				'label' => esc_html__('Zoom Map','ova-career'),
				'section' => 'ova_career_map_section',
				'settings' => 'ova_career_zoom_map_default',
				'type' =>'number'
			));

			// Archive
			$wp_customize->add_setting( 'ova_career_total_record', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 8,
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name  
			) );

			$wp_customize->add_control('ova_career_total_record', array(
				'label' => esc_html__('Number of posts per page','ova-career'),
				'section' => 'ova_career_section',
				'settings' => 'ova_career_total_record',
				'type' =>'number'
			));

			$wp_customize->add_setting( 'ova_career_layout', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'two_column',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_career_layout', array(
				'label' => esc_html__('Layout','ova-career'),
				'section' => 'ova_career_section',
				'settings' => 'ova_career_layout',
				'type' =>'select',
				'choices' => array(
					'one_column'   => esc_html__( 'Single Column', 'ova-career' ),
					'two_column'   => esc_html__( '2 Column', 'ova-career' ),
				)
			));

			$wp_customize->add_setting( 'header_archive_career', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'default',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('header_archive_career', array(
				'label' => esc_html__('Header Archive','ova-career'),
				'section' => 'ova_career_section',
				'settings' => 'header_archive_career',
				'type' =>'select',
				'choices' => apply_filters('gimont_list_header', '')
			));

			$wp_customize->add_setting( 'archive_footer_career', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'default',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name  
			) );

			$wp_customize->add_control('archive_footer_career', array(
				'label' => esc_html__('Footer Archive','ova-career'),
				'section' => 'ova_career_section',
				'settings' => 'archive_footer_career',
				'type' =>'select',
				'choices' => apply_filters('gimont_list_footer', '')
			));

			$wp_customize->add_setting( 'ova_career_archive_show_heart', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_career_archive_show_heart', array(
				'label' => esc_html__('Show Heart','ova-career'),
				'section' => 'ova_career_section',
				'settings' => 'ova_career_archive_show_heart',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-dep' ),
					'no'    => esc_html__( 'No', 'ova-dep' ),
				)
			));

			$wp_customize->add_setting( 'ova_career_archive_show_featured_image', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_career_archive_show_featured_image', array(
				'label' => esc_html__('Show Featured Image','ova-career'),
				'section' => 'ova_career_section',
				'settings' => 'ova_career_archive_show_featured_image',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-dep' ),
					'no'    => esc_html__( 'No', 'ova-dep' ),
				)
			));

			$wp_customize->add_setting( 'ova_career_archive_show_title', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_career_archive_show_title', array(
				'label' => esc_html__('Show Title','ova-career'),
				'section' => 'ova_career_section',
				'settings' => 'ova_career_archive_show_title',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-dep' ),
					'no'    => esc_html__( 'No', 'ova-dep' ),
				)
			));

			$wp_customize->add_setting( 'ova_career_archive_show_link_to', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_career_archive_show_link_to', array(
				'label' => esc_html__('Show Link of Title','ova-career'),
				'section' => 'ova_career_section',
				'settings' => 'ova_career_archive_show_link_to',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-dep' ),
					'no'    => esc_html__( 'No', 'ova-dep' ),
				)
			));

			$wp_customize->add_setting( 'ova_career_archive_show_created_by', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_career_archive_show_created_by', array(
				'label' => esc_html__('Show Created By','ova-career'),
				'section' => 'ova_career_section',
				'settings' => 'ova_career_archive_show_created_by',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-dep' ),
					'no'    => esc_html__( 'No', 'ova-dep' ),
				)
			));

			$wp_customize->add_setting( 'ova_career_archive_show_category', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_career_archive_show_category', array(
				'label' => esc_html__('Show Category','ova-career'),
				'section' => 'ova_career_section',
				'settings' => 'ova_career_archive_show_category',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-dep' ),
					'no'    => esc_html__( 'No', 'ova-dep' ),
				)
			));

			$wp_customize->add_setting( 'ova_career_archive_show_working_from', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_career_archive_show_working_from', array(
				'label' => esc_html__('Show Working From','ova-career'),
				'section' => 'ova_career_section',
				'settings' => 'ova_career_archive_show_working_from',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-dep' ),
					'no'    => esc_html__( 'No', 'ova-dep' ),
				)
			));

			$wp_customize->add_setting( 'ova_career_archive_show_venue', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_career_archive_show_venue', array(
				'label' => esc_html__('Show Venue','ova-career'),
				'section' => 'ova_career_section',
				'settings' => 'ova_career_archive_show_venue',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-dep' ),
					'no'    => esc_html__( 'No', 'ova-dep' ),
				)
			));

			$wp_customize->add_setting( 'ova_career_archive_show_salary', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_career_archive_show_salary', array(
				'label' => esc_html__('Show Offered Salary','ova-career'),
				'section' => 'ova_career_section',
				'settings' => 'ova_career_archive_show_salary',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-dep' ),
					'no'    => esc_html__( 'No', 'ova-dep' ),
				)
			));

			// Single
			$wp_customize->add_setting( 'header_single_career', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'default',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name   
			) );

			$wp_customize->add_control('header_single_career', array(
				'label' => esc_html__('Header Single','ova-career'),
				'section' => 'ova_career_single_section',
				'settings' => 'header_single_career',
				'type' =>'select',
				'choices' => apply_filters('gimont_list_header', '')
			));

			$wp_customize->add_setting( 'single_footer_career', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'default',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('single_footer_career', array( 
				'label' => esc_html__('Footer Single','ova-career'),
				'section' => 'ova_career_single_section',
				'settings' => 'single_footer_career',
				'type' =>'select',
				'choices' => apply_filters('gimont_list_footer', '')
			));

			$wp_customize->add_setting( 'career_single_show_banner', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('career_single_show_banner', array(
				'label' => esc_html__('Show Banner','ova-career'),
				'section' => 'ova_career_single_section',
				'settings' => 'career_single_show_banner',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-dep' ),
					'no'    => esc_html__( 'No', 'ova-dep' ),
				)
			));

			$wp_customize->add_setting( 'career_single_show_heart', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('career_single_show_heart', array(
				'label' => esc_html__('Show Heart','ova-career'),
				'section' => 'ova_career_single_section',
				'settings' => 'career_single_show_heart',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-dep' ),
					'no'    => esc_html__( 'No', 'ova-dep' ),
				)
			));

			$wp_customize->add_setting( 'career_single_show_featured_image', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('career_single_show_featured_image', array(
				'label' => esc_html__('Show Featured Image','ova-career'),
				'section' => 'ova_career_single_section',
				'settings' => 'career_single_show_featured_image',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-dep' ),
					'no'    => esc_html__( 'No', 'ova-dep' ),
				)
			));

			$wp_customize->add_setting( 'career_single_show_title', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('career_single_show_title', array(
				'label' => esc_html__('Show Title','ova-career'),
				'section' => 'ova_career_single_section',
				'settings' => 'career_single_show_title',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-dep' ),
					'no'    => esc_html__( 'No', 'ova-dep' ),
				)
			));

			$wp_customize->add_setting( 'career_single_show_created_by', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'yes',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 	  
			) );
			
			$wp_customize->add_control('career_single_show_created_by', array(
				'label' => esc_html__('Show Created By','ova-career'),
				'section' => 'ova_career_single_section',
				'settings' => 'career_single_show_created_by',
				'type' =>'select',
				'choices' => array(
					'yes' => esc_html__('Yes', 'ova-career'),
					'no'  => esc_html__('No', 'ova-career'),
				)
			));

			$wp_customize->add_setting( 'career_single_show_category', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'yes',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 	  
			) );
			
			$wp_customize->add_control('career_single_show_category', array(
				'label' => esc_html__('Show Category','ova-career'),
				'section' => 'ova_career_single_section',
				'settings' => 'career_single_show_category',
				'type' =>'select',
				'choices' => array(
					'yes' => esc_html__('Yes', 'ova-career'),
					'no'  => esc_html__('No', 'ova-career'),
				)
			));

			$wp_customize->add_setting( 'career_single_show_working_from', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'yes',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 	  
			) );

			$wp_customize->add_control('career_single_show_working_from', array(
				'label' => esc_html__('Show Working From','ova-career'),
				'section' => 'ova_career_single_section',
				'settings' => 'career_single_show_working_from',
				'type' =>'select',
				'choices' => array(
					'yes' => esc_html__('Yes', 'ova-career'),
					'no'  => esc_html__('No', 'ova-career'),
				)
			));

			$wp_customize->add_setting( 'career_single_show_venue', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'yes',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 	  
			) );

			$wp_customize->add_control('career_single_show_venue', array(
				'label' => esc_html__('Show Venue','ova-career'),
				'section' => 'ova_career_single_section',
				'settings' => 'career_single_show_venue',
				'type' =>'select',
				'choices' => array(
					'yes' => esc_html__('Yes', 'ova-career'),
					'no'  => esc_html__('No', 'ova-career'),
				)
			));

			$wp_customize->add_setting( 'career_single_show_salary', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'yes',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 	  
			) );

			$wp_customize->add_control('career_single_show_salary', array(
				'label' => esc_html__('Show Offered Salary','ova-career'),
				'section' => 'ova_career_single_section',
				'settings' => 'career_single_show_salary',
				'type' =>'select',
				'choices' => array(
					'yes' => esc_html__('Yes', 'ova-career'),
					'no'  => esc_html__('No', 'ova-career'),
				)
			));

			$wp_customize->add_setting( 'career_single_show_description', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'yes',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 	  
			) );
			
			$wp_customize->add_control('career_single_show_description', array(
				'label' => esc_html__('Show Description','ova-career'),
				'section' => 'ova_career_single_section',
				'settings' => 'career_single_show_description',
				'type' =>'select',
				'choices' => array(
					'yes' => esc_html__('Yes', 'ova-career'),
					'no'  => esc_html__('No', 'ova-career'),
				)
			));

			$wp_customize->add_setting( 'career_single_show_share', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'yes',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 	  
			) );
			
			$wp_customize->add_control('career_single_show_share', array(
				'label' => esc_html__('Show Share Socials','ova-career'),
				'section' => 'ova_career_single_section',
				'settings' => 'career_single_show_share',
				'type' =>'select',
				'choices' => array(
					'yes' => esc_html__('Yes', 'ova-career'),
					'no'  => esc_html__('No', 'ova-career'),
				)
			));

			$wp_customize->add_setting( 'ova_career_comments', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );
			
			$wp_customize->add_control('ova_career_comments', array(
				'label' => esc_html__('Show Comments','ova-career'),
				'section' => 'ova_career_single_section',
				'settings' => 'ova_career_comments',
				'type' =>'select',
				'choices' => array(
					'yes'	=> esc_html__( 'Yes', 'ova-career' ),
					'no'	=> esc_html__( 'No', 'ova-career' ),
				)
			));

			$wp_customize->add_setting( 'career_single_show_gallery', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'yes',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 	  
			) );
			
			$wp_customize->add_control('career_single_show_gallery', array(
				'label' => esc_html__('Show Gallery','ova-career'),
				'section' => 'ova_career_single_section',
				'settings' => 'career_single_show_gallery',
				'type' =>'select',
				'choices' => array(
					'yes' => esc_html__('Yes', 'ova-career'),
					'no'  => esc_html__('No', 'ova-career'),
				)
			));

			$wp_customize->add_setting( 'career_single_show_map', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'yes',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 	  
			) );
			
			$wp_customize->add_control('career_single_show_map', array(
				'label' => esc_html__('Show Map','ova-career'),
				'section' => 'ova_career_single_section',
				'settings' => 'career_single_show_map',
				'type' =>'select',
				'choices' => array(
					'yes' => esc_html__('Yes', 'ova-career'),
					'no'  => esc_html__('No', 'ova-career'),
				)
			));

			$wp_customize->add_setting( 'career_single_show_related', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'yes',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 	  
			) );
			
			$wp_customize->add_control('career_single_show_related', array(
				'label' => esc_html__('Show Related','ova-career'),
				'section' => 'ova_career_single_section',
				'settings' => 'career_single_show_related',
				'type' =>'select',
				'choices' => array(
					'yes' => esc_html__('Yes', 'ova-career'),
					'no'  => esc_html__('No', 'ova-career'),
				)
			));

			$wp_customize->add_setting( 'career_single_show_apply', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'yes',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 	  
			) );
			
			$wp_customize->add_control('career_single_show_apply', array(
				'label' => esc_html__('Show Apply','ova-career'),
				'section' => 'ova_career_single_section',
				'settings' => 'career_single_show_apply',
				'type' =>'select',
				'choices' => array(
					'yes' => esc_html__('Yes', 'ova-career'),
					'no'  => esc_html__('No', 'ova-career'),
				)
			));

			$wp_customize->add_setting( 'career_single_show_overview', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'yes',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 	  
			) );
			
			$wp_customize->add_control('career_single_show_overview', array(
				'label' => esc_html__('Show Overview','ova-career'),
				'section' => 'ova_career_single_section',
				'settings' => 'career_single_show_overview',
				'type' =>'select',
				'choices' => array(
					'yes' => esc_html__('Yes', 'ova-career'),
					'no'  => esc_html__('No', 'ova-career'),
				)
			));

			$wp_customize->add_setting( 'career_single_show_website_url', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'yes',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 	  
			) );
			
			$wp_customize->add_control('career_single_show_website_url', array(
				'label' => esc_html__('Show Website URL','ova-career'),
				'section' => 'ova_career_single_section',
				'settings' => 'career_single_show_website_url',
				'type' =>'select',
				'choices' => array(
					'yes' => esc_html__('Yes', 'ova-career'),
					'no'  => esc_html__('No', 'ova-career'),
				)
			));

			$wp_customize->add_setting( 'career_single_show_send_message', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'yes',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 	  
			) );
			
			$wp_customize->add_control('career_single_show_send_message', array(
				'label' => esc_html__('Show Send us message','ova-career'),
				'section' => 'ova_career_single_section',
				'settings' => 'career_single_show_send_message',
				'type' =>'select',
				'choices' => array(
					'yes' => esc_html__('Yes', 'ova-career'),
					'no'  => esc_html__('No', 'ova-career'),
				)
			));

			$wp_customize->add_setting( 'career_single_show_social', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'yes',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 	  
			) );
			
			$wp_customize->add_control('career_single_show_social', array(
				'label' => esc_html__('Show Social','ova-career'),
				'section' => 'ova_career_single_section',
				'settings' => 'career_single_show_social',
				'type' =>'select',
				'choices' => array(
					'yes' => esc_html__('Yes', 'ova-career'),
					'no'  => esc_html__('No', 'ova-career'),
				)
			));

			$wp_customize->add_setting( 'career_single_show_sidebar', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'yes',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 	  
			) );
			
			$wp_customize->add_control('career_single_show_sidebar', array(
				'label' => esc_html__('Show Sidebar','ova-career'),
				'section' => 'ova_career_single_section',
				'settings' => 'career_single_show_sidebar',
				'type' =>'select',
				'choices' => array(
					'yes' => esc_html__('Yes', 'ova-career'),
					'no'  => esc_html__('No', 'ova-career'),
				)
			));

		}

	}

}

new Ova_Career_Customize();