(function($){
    "use strict";

    function initMap() {
        const ovaMap = document.getElementById("ova_dir_map");
        if (! ovaMap) {return};
        const ova_dir_met_latitude  = parseFloat(document.getElementById("ova_dir_met_latitude").value);
        const ova_dir_met_longitude = parseFloat(document.getElementById("ova_dir_met_longitude").value);
        const dataMap   = JSON.parse(ovaMap.getAttribute('data-map'));
        var latitude    = dataMap.latitude;
        var longitude   = dataMap.longitude;
        const zoom      = dataMap.zoom;

        if ( ova_dir_met_latitude && ova_dir_met_latitude ) {
            latitude    = ova_dir_met_latitude
            longitude   = ova_dir_met_longitude;
        }
        const map = new google.maps.Map(document.getElementById("ova_dir_map"), {
            center: { lat: latitude, lng: longitude },
            zoom: zoom,
            mapTypeControl: false,
        });

        const input = document.getElementById("pac-input");
        const options = {
            fields: ["formatted_address", "geometry", "name"],
            strictBounds: false,
        };

        const autocomplete = new google.maps.places.Autocomplete(input, options);

        const infowindow = new google.maps.InfoWindow();
        const infowindowContent = document.getElementById("infowindow-content");

        infowindow.setContent(infowindowContent);
        const marker = new google.maps.Marker({
            map,
            anchorPoint: new google.maps.Point(0, -29),
            position: { lat: latitude, lng: longitude },
        });

        autocomplete.addListener("place_changed", () => {
            infowindow.close();
            marker.setVisible(false);

            const place         = autocomplete.getPlace();
            const latitude      = document.getElementById("ova_dir_met_latitude");
            const longitude     = document.getElementById("ova_dir_met_longitude");

            if ( ! place.geometry || ! place.geometry.location ) {
                window.alert("No details available for input: '" + place.name + "'");
                return;
            }

            if (place.geometry.viewport) {
                map.fitBounds(place.geometry.viewport);
            } else {
                map.setCenter(place.geometry.location);
                map.setZoom(17);
            }

            marker.setPosition(place.geometry.location);
            latitude.value    = place.geometry.location.lat();
            longitude.value   = place.geometry.location.lng();
            marker.setVisible(true);
            infowindowContent.children["place-name"].textContent = place.name;
            infowindowContent.children["place-address"].textContent = place.formatted_address;
            infowindow.open(map, marker);
        });
    }
    
    initMap();

}) (jQuery);