<?php
namespace ova_dir_elementor\Widgets;

use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class ova_dir_category extends Widget_Base {

	public function get_name() {
		return 'ova_dir_category';
	}

	public function get_title() {
		return esc_html__( 'Directory Category', 'ova-dir' );
	}

	public function get_icon() {
		return 'eicon-bullet-list';
	}

	public function get_categories() {
		return [ 'ovatheme_directory' ];
	}

	public function get_script_depends() {
		wp_enqueue_script('ova-dir-category', OVADIR_PLUGIN_URI . 'assets/js/elementor/category.js', array('jquery'),false, true);
		return [ '' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'ova-dir-category', OVADIR_PLUGIN_URI.'assets/css/elementor/category.css' );	
		return [];
	}

	protected function register_controls() {

		/* Content */
		$this->start_controls_section(
				'content_section',
				[
					'label' => esc_html__( 'Content', 'ova-dir' ),
					'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				]
			);

			$this->add_control(
				'dir_title',
				[
					'label' => esc_html__( 'Directory Title', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'All Categories', 'ova-dir' ),
					'label_block' => true,
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name' => 'cate_border',
					'selector' => '{{WRAPPER}} .ova-dir-category .directory-cat-list',
				]
			);


		$this->end_controls_section();

		/* Title */
		$this->start_controls_section(
				'title_style_section',
				[
					'label' => esc_html__( 'Title', 'ova-dir' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'title_typography',
					'selector' => '{{WRAPPER}} .ova-dir-category .title',
				]
			);

			$this->add_control(
				'title_color',
				[
					'label' => esc_html__( 'Color', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-dir-category .title' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'title_background',
				[
					'label' => esc_html__( 'Background', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-dir-category .title' => 'background: {{VALUE}}',
						'{{WRAPPER}} .ova-dir-category .title:after' => 'border-top-color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/*Category*/
		$this->start_controls_section(
			'category_style_section',
			[
				'label' => esc_html__( 'Category', 'ova-dir' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'cate_typography',
					'selector' => '{{WRAPPER}} .ova-dir-category .directory-cat-list .cate_name',
				]
			);

			$this->start_controls_tabs(
				'cate_style_tabs'
				);

				$this->start_controls_tab(
						'cate_style_normal_tab',
						[
							'label' => esc_html__( 'Normal', 'ova-dir' ),
						]
					);

					$this->add_control(
						'cate_color',
						[
							'label' => esc_html__( 'Color', 'ova-dir' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-dir-category .directory-cat-list .cate_name' => 'color: {{VALUE}}',
								'{{WRAPPER}} .ova-dir-category .directory-cat-list .item-link i' => 'color: {{VALUE}}',
							],
						]
					);

					$this->add_control(
						'cate_background',
						[
							'label' => esc_html__( 'Background', 'ova-dir' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-dir-category .directory-cat-list .item-link' => 'background: {{VALUE}}',
							],
						]
					);

				$this->end_controls_tab();

				$this->start_controls_tab(
					'cate_style_hover_tab',
						[
							'label' => esc_html__( 'Hover', 'ova-dir' ),
						]
					);

					$this->add_control(
						'cate_hover_color',
						[
							'label' => esc_html__( 'Color', 'ova-dir' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-dir-category .directory-cat-list .cate_name:hover' => 'color: {{VALUE}}',
								'{{WRAPPER}} .ova-dir-category .directory-cat-list .item-link i:hover' => 'color: {{VALUE}}',
							],
						]
					);

					$this->add_control(
						'cate_hover_background',
						[
							'label' => esc_html__( 'Background', 'ova-dir' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-dir-category .directory-cat-list .item-link:hover' => 'background: {{VALUE}}',
								'{{WRAPPER}} .ova-dir-category .directory-cat-list .item-link.active' => 'background: {{VALUE}}',
							],
						]
					);

				$this->end_controls_tab();

			$this->end_controls_tabs();

		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();
		$template = apply_filters( 'el_elementor_ova_dir_category', 'elementor/ova_dir_category.php' );

		ob_start();
		ovadir_get_template( $template, $settings );
		echo ob_get_clean();
	}
}
