<?php

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

if( !function_exists( 'ovadep_locate_template' ) ){
	function ovadep_locate_template( $template_name, $template_path = '', $default_path = '' ) {
		
		// Set variable to search in ovacoll-templates folder of theme.
		if ( ! $template_path ) :
			$template_path = 'ovadep-templates/';
		endif;

		// Set default plugin templates path.
		if ( ! $default_path ) :
			$default_path = OVADEP_PLUGIN_PATH . 'templates/'; // Path to the template folder
		endif;

		// Search template file in theme folder.
		$template = locate_template( array(
			$template_path . $template_name
			// $template_name
		) );

		// Get plugins template file.
		if ( ! $template ) :
			$template = $default_path . $template_name;
		endif;

		return apply_filters( 'ovadep_locate_template', $template, $template_name, $template_path, $default_path );
	}

}


function ovadep_get_template( $template_name, $args = array(), $tempate_path = '', $default_path = '' ) {
	if ( is_array( $args ) && isset( $args ) ) :
		extract( $args );
	endif;
	$template_file = ovadep_locate_template( $template_name, $tempate_path, $default_path );
	if ( ! file_exists( $template_file ) ) :
		_doing_it_wrong( __FUNCTION__, sprintf( '<code>%s</code> does not exist.', $template_file ), '1.0.0' );
		return;
	endif;

	
	include $template_file;
}


add_action( 'widgets_init', 'ovadep_sidebar' );
function ovadep_sidebar() {
    $args = array(
        'name'          => esc_html__( 'Department Sidebar', 'ova-dep' ),
        'id'            => 'ova-dep-sidebar',
        'description'   => esc_html__( 'Department Sidebar', 'ova-dep' ),
        'class'         => '',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>' 
    );

    register_sidebar( $args );

}


add_filter( 'gimont_header_customize', 'gimont_header_customize_dep', 10, 1 );
function gimont_header_customize_dep( $header ){


	if( is_tax( 'cat_department' ) ||  get_query_var( 'cat_department' ) != '' || is_post_type_archive( 'ova_dep' ) ){

	  	$header = get_theme_mod( 'header_archive_dep', 'default' );

	}else if( is_singular( 'ova_dep' ) ){

		$header = get_theme_mod( 'header_single_dep', 'default' );
	}

	return $header;

}


add_filter( 'gimont_footer_customize', 'gimont_footer_customize_dep', 10, 1 );
function gimont_footer_customize_dep( $footer ){
    
   if( is_tax( 'cat_department' ) ||  get_query_var( 'cat_department' ) != '' || is_post_type_archive( 'ova_dep' ) ){

        $footer = get_theme_mod( 'archive_footer_dep', 'default' );

    }else if( is_singular( 'ova_dep' ) ){

        $footer = get_theme_mod( 'single_footer_dep', 'default' );
    }

    return $footer;

}