<?php if ( !defined( 'ABSPATH' ) ) exit();

	// get default category from URL parameter
	$cat_slug  = isset($_GET['cat_slug']) ? sanitize_text_field($_GET['cat_slug']) : '';

	// Categories service
	$category_not_in = isset($args['category_not_in']) ? $args['category_not_in'] : '';

	$args_query = array(
		'taxonomy' 	 => 'cat_sev',
		'orderby' 	 => 'name',
		'order'   	 => 'ASC',
		'hide_empty' => false,
		'parent' 	 => 0,
		'exclude'    => explode( '|', $category_not_in )
	);

	$categories = get_categories($args_query);

	// Services
	$args_sev = array(
		'post_type' 	=> 'ova_sev',
		'numberposts' 	=> $posts_per_page,
		'order' 		=> $order,
		'orderby' 		=> $orderby,
	);

	if(!empty($cat_slug)) {
		$args_sev['tax_query'] = array(
	        array(
	            'taxonomy' => 'cat_sev',
	            'field'    => 'slug',
	            'terms' => $cat_slug,
	            'include_children' => true
	        ),
	    );
	} elseif($categories[0]) {
		$args_sev['tax_query'] = array(
	        array(
	            'taxonomy' => 'cat_sev',
	            'field'    => 'slug',
	            'terms' => $categories[0]->slug,
	            'include_children' => true
	        ),
	    );
	}

	$list_sevs = get_posts( $args_sev );

?>

<div class="ova-service-ajax" data-order="<?php echo esc_attr($order);?>" data-orderby="<?php echo esc_attr($orderby);?>"
	data-posts_per_page="<?php echo esc_attr($posts_per_page);?>" data-show_desc="<?php echo esc_attr($show_desc);?>"
>

	<div class="service-cat-list-wrapper">
		<div class="service-cat-list service-cat-parent-list">
			<?php if ( $categories ): foreach ($categories as $k => $category): 
				if(!empty($cat_slug)) {
					$active = ($cat_slug == $category->slug) ? 'active-category' : '';
				} else {
					$active = ( 0 == $k ) ? 'active-category' : '';
				}
			?>
				<div class="item-link <?php echo esc_attr( $active ); ?>"
					data-slug="<?php echo esc_attr( $category->slug ); ?>"
					title="<?php echo esc_attr( $category->name ); ?>"
				>	
					<span class="cate_name"><?php echo esc_html( $category->name ); ?></span>
				</div>	
			<?php endforeach; endif; ?>
		</div>

		<?php foreach ($categories as $k => $category) :
			$args_child_query = array(
				'taxonomy' 		=> 'cat_sev',
				'orderby' 		=> 'name',
				'order'   		=> 'ASC',
				'hide_empty' 	=> false,
				'parent' 		=> $categories[$k]->term_id,
			);
			$term_id 			= get_queried_object_id();
			$child_categories 	= get_categories( $args_child_query );

			if ( $child_categories ) {
		?>

			<div class="service-cat-list service-cat-child-list" data-parent_slug="<?php echo esc_attr($categories[$k]->slug);?>">
				<?php foreach ($child_categories as $child): ?>
					<div class="item-link" data-slug="<?php echo esc_attr( $child->slug ); ?>">	
						<span class="cate_name"><?php echo esc_html( $child->name ); ?></span>
					</div>	
				<?php endforeach; ?>
			</div>
		<?php } endforeach; ?>
	</div>

	<div class="service-ajax-results-wrapper">

		<div class="ova-sev-loader">
			<div class="loader" aria-hidden="true"></div>
		</div>

		<div class="service-ajax-results service-post-list-wrapper">
			<?php if( !empty($cat_slug) ) { 
				$term = get_term_by('slug', $cat_slug, 'cat_sev');
			?>
				<h3 class="service-category-name">
					<?php echo esc_html($term->name); ?>	
				</h3>
			<?php } elseif($categories[0]->name) { ?>
				<h3 class="service-category-name">
					<?php echo esc_html($categories[0]->name); ?>	
				</h3>
			<?php } ?>
			<?php if( !empty($list_sevs) ) { ?>
				<div class="service-post-list">
					<?php if ($list_sevs) : foreach ( $list_sevs as $sev ) :
						$id_sev 		= $sev->ID;
						$title_sev 		= $sev->post_title;
						$desc_sev       = $sev->post_excerpt;
						if($desc_sev == '') {
							$desc_sev   = $sev->post_content;
						}
					?>
						<a class="item-link" href="<?php echo get_the_permalink( $id_sev ); ?>">
							<div class="title-wrap">
								<h4 class="title">
									<?php echo esc_html( $title_sev ); ?>
								</h4>
								<i aria-hidden="true" class="flaticonnew- flaticon-new-right-arrows"></i>
							</div>
							<?php if( $show_desc == 'yes' ) { ?>
								<p class="desc">
									<?php echo esc_html( ova_sev_custom_text( $desc_sev, 12 ) ); ?>	
								</p>
							<?php } ?>
						</a>
					<?php endforeach; endif; ?>
				</div>
			<?php } else { ?>
				<p><?php esc_attr_e( 'Not found !', 'ova-sev' ); ?></p>
			<?php } ?>
		</div>

	</div>

</div>