<?php if ( !defined( 'ABSPATH' ) ) exit();

	$title 		= $args['title'];
	$link 		= $args['link'];
	$text_btn 	= $args['text_btn'];

	$link_url 	= $link['url'];
	$target 	= $link['is_external'] 	? 'target="_blank"' : '';
	$nofollow 	= $link['nofollow']		? 'rel="nofollow"' 	: '';
	$services 	= ova_sev_query($args);
?>

<div class="ova-sev-list-box">
	<?php if($title) { ?>
		<h3 class="title">
			<?php echo esc_html( $title ); ?>	
		</h3>
	<?php } ?>

	<?php if ( $services->have_posts() ) : ?>
		<ul class="sev-list">
			<?php while ( $services->have_posts() ) : $services->the_post(); ?>
				<li class="item">
					<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" class="sev-link">	
						<?php if($show_icon == 'yes') { ?>
							<i class="gimonticon-right-arrow" aria-hidden="true"></i>
						<?php } ?>
						<?php the_title(); ?>
					</a>
				</li>
			<?php endwhile;?>
		</ul>
	<?php endif; wp_reset_postdata(); ?>

	<?php if( $link_url && $text_btn ) { ?>
		<a href="<?php echo esc_url( $link_url ); ?>" class="link-btn" <?php printf( '%1$s %2$s', $target, $nofollow ); ?>>
			<?php echo esc_html( $text_btn ); ?>
		</a>
	<?php } ?>
</div>