<?php if ( !defined( 'ABSPATH' ) ) exit();

get_header( );

	$id = get_the_ID();

	$sidebar = isset($_GET['single_service_sidebar']) ? $_GET['single_service_sidebar'] : get_theme_mod( 'ova_sev_sidebar', 'left_sidebar' );

	// show fields
	$show_thumbnail = get_theme_mod( 'ova_sev_single_show_featured_image', 'yes' );
	$show_title     = get_theme_mod( 'ova_sev_single_show_title', 'yes' );
	$show_content   = get_theme_mod( 'ova_sev_single_show_content', 'yes' );
	$show_share     = get_theme_mod( 'ova_sev_single_show_share', 'yes' );
	$show_comments 	= get_theme_mod( 'ova_sev_comments', 'yes' );

?>

<div class="ova-sev-single">
	<div class="row_site">
		<div class="container_site">

			<div class="ova-sev-wrapper <?php printf( '%1$s', $sidebar ); ?>">

				<?php if ( $sidebar == 'left_sidebar' && is_active_sidebar( 'ova-sev-sidebar' ) ) { ?>
					<div class="ova-sev-sidebar-wrapper">
						<div class="ova-sev-sidebar">
							<?php dynamic_sidebar('ova-sev-sidebar'); ?>
						</div>
					</div>
				<?php } ?>

				<div class="ova-sev-content">

					<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

						<?php if ( has_post_thumbnail( $id ) && $show_thumbnail == 'yes' ) :
							$image_id 	= get_post_thumbnail_id( $id );
							$image_src 	= get_the_post_thumbnail_url( $id, 'large' );
							$image_alt 	= get_the_title();
							if ( get_post_meta( $image_id, '_wp_attachment_image_alt', true) ) {
								$image_alt = get_post_meta( $image_id, '_wp_attachment_image_alt', true);
							}
						?>
							<div class="image-feature">
								<img src="<?php echo esc_url( $image_src ); ?>" alt="<?php echo esc_attr( $image_alt ); ?>">
							</div>
						<?php endif;?>
						
						<?php if( $show_title == 'yes' ) : ?>
							<h1 class="title">
								<?php the_title(); ?>
							</h1>
						<?php endif;?>

						<?php if( $show_content == 'yes' ) : ?>
							<div class="content">
								<?php the_content(); ?>
							</div>
						<?php endif;?>

					<?php endwhile; endif; wp_reset_postdata(); ?>

					<?php if( has_filter( 'ova_share_social' ) && $show_share == 'yes' ) { 
						apply_filters( 'ova_share_social', get_the_permalink(), get_the_title() );
			        } ?>

			        <?php
				        if ( $show_comments == 'yes' ) {
				        	if( comments_open( get_the_ID() ) ) {
					        	comments_template(); 
					        }
				        }
			        ?>

				</div>

				<?php if ( $sidebar == 'right_sidebar' && is_active_sidebar( 'ova-sev-sidebar' ) ) { ?>
					<div class="ova-sev-sidebar-wrapper">
						<div class="ova-sev-sidebar">
							<?php dynamic_sidebar('ova-sev-sidebar'); ?>
						</div>
					</div>
				<?php } ?>

			</div>

		</div>
	</div>
</div>

<?php get_footer();