<?php if ( !defined( 'ABSPATH' ) ) exit();

get_header();

$artists = apply_filters( 'OVACOLL_artist', '' );

$archive_artist_heading = OVACOLL_Settings::archive_artist_heading();
$archive_artist_desc    = OVACOLL_Settings::archive_artist_desc();

// show fields
$args_show = array(
	'show_image'  => OVACOLL_Settings::archive_artist_show_image(),
	'show_title'  => OVACOLL_Settings::archive_artist_show_title(),
	'show_skill'  => OVACOLL_Settings::archive_artist_show_skill(),
	'show_phone'  => OVACOLL_Settings::archive_artist_show_phone(),
	'show_email'  => OVACOLL_Settings::archive_artist_show_email(),
);

?>

<div class="row_site">
	<div class="container_site">

		<div class="archive_artist">

			<div class="heading_archive_artist">
				<?php if ($archive_artist_heading != '') { ?>
					<h1 class="heading_artist">
						<?php echo $archive_artist_heading; ?>	
					</h1>
				<?php } ?>
				
				<?php if ($archive_artist_desc != '') { ?>
					<p class="desc_artist">
						<?php echo $archive_artist_desc; ?>	
					</p>
				<?php } ?>
			</div>
			
			<div class="content">
				<?php if($artists->have_posts() ) : while ( $artists->have_posts() ) : $artists->the_post();
					ovacoll_get_template( 'parts/item-artist.php', $args_show );
				endwhile; endif; wp_reset_postdata(); ?>
			</div>
			
			<?php 
				$args = array(
					'type'      => 'list',
					'next_text' => '<i class="ovaicon-next"></i><span class="visuallyhidden">Next</span>',
					'prev_text' => '<i class="ovaicon-back"></i><span class="visuallyhidden">Previous</span>',
				);

				the_posts_pagination($args);
			?>

		</div>
	</div>
</div>


<?php get_footer( );