(function($){
	"use strict";
	

	$(window).on('elementor/frontend/init', function () {
		
        
		elementorFrontend.hooks.addAction('frontend/element_ready/gimont_elementor_search_all_ajax.default', function(){

			$('.ova-search-all-ajax').each( function(){
				var that  = $(this);
				var input = that.find('.search-form .search-field');

				var results    = that.find('.search-results');
				var post_types = that.data('post_types');
				var total	   = that.data('total');
				var order	   = that.data('order');
				var orderby	   = that.data('orderby');
				var search_by  = that.data('search_by');

				input.on('input', function() {
					var keyword = $(this).val();
					that.find('.loader').fadeIn(100);
					loadAjaxCaseStudy(results,post_types,total,order,orderby,search_by,keyword)
					results.css({"opacity":1, "visibility":"visible", "top":"111%"});
				});

				input.focusout(function() {
					results.css({"opacity":0, "visibility":"hidden", "top":0});
				});
			});

			function loadAjaxCaseStudy(results,post_types,total,order,orderby,search_by,keyword) {
	        	$.ajax({
	             	url: ajax_object.ajax_url,
	             	type: 'POST',
	             	data: ({
		                action: 'load_search_item_list',
		                keyword: keyword,
		                post_types: post_types,
		                total: total,
		                order: order,
		                orderby: orderby,
		                search_by: search_by,
		                security: ajax_object.ajax_nonce
		            }),
	             	success: function(response){
	             		$('.ova-search-all-ajax').find('.loader').fadeOut(100);
	             		results.html(response);
	             	},
	          	});
	        }
			
		});


   });

})(jQuery);
