<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Gimont_Elementor_Counter_2 extends Widget_Base {

	public function get_name() {
		return 'gimont_elementor_counter_2';
	}

	public function get_title() {
		return esc_html__( 'Counter 2', 'gimont' );
	}

	public function get_icon() {
		return 'eicon-counter';
	}

	public function get_categories() {
		return [ 'gimont' ];
	}

	public function get_script_depends() {
		// appear js
		wp_enqueue_script( 'gimont-counter-appear', get_theme_file_uri('/assets/libs/appear/appear.js'), array('jquery'), false, true);
		// Odometer for counter
		wp_enqueue_style( 'odometer', get_template_directory_uri().'/assets/libs/odometer/odometer.min.css' );
		wp_enqueue_script( 'odometer', get_template_directory_uri().'/assets/libs/odometer/odometer.min.js', array('jquery'), false, true );
		return [ 'gimont-elementor-counter-2' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'gimont-elementor-counter-2', GIMONT_URI.'/assets/scss/elementor/counters/counter-2.css' );
		return [];
	}
	
	// Add Your Controll In This Function
	protected function register_controls() {

		$this->start_controls_section(
				'section_content',
				[
					'label' => esc_html__( 'Content', 'gimont' ),
				]
			);

			$this->add_control(
				'template',
				[
					'label' => esc_html__( 'Template', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'template_1',
					'options' => [
						'template_1' => esc_html__( 'Template 1', 'gimont' ),
						'template_2' => esc_html__( 'Template 2', 'gimont' ),
						'template_3' => esc_html__( 'Template 3', 'gimont' ),
						'template_4' => esc_html__( 'Template 4', 'gimont' ),
						'template_5' => esc_html__( 'Template 5', 'gimont' ),
					],
				]
			);

		    $this->add_control(
				'icon',
				[
					'label' 	=> __( 'Icon', 'gimont' ),
					'type' 		=> Controls_Manager::ICONS,
					'default' 	=> [
						'value' 	=> 'gimonticon gimonticon-real-estate',
						'library' 	=> 'all',
					],
				]
			);

		    $this->add_control(
				'number',
				[
					'label' 	=> esc_html__( 'Number', 'gimont' ),
					'type'    => Controls_Manager::NUMBER,
					'default' => 4,
				]
			);

			$this->add_control(
				'suffix',
				[
					'label'  => esc_html__( 'Suffix', 'gimont' ),
					'type'   => Controls_Manager::TEXT,
					'placeholder' => esc_html__( 'Suffix', 'gimont' ),
					'default' => 'th',
				]
			);

			$this->add_control(
				'title',
				[
					'label' 	=> esc_html__( 'Title', 'gimont' ),
					'type' => \Elementor\Controls_Manager::TEXTAREA,
					'rows' => 3,
					'default' => esc_html__( 'Home ownership&#13;&#10;costs', 'gimont' ),
				]
			);

			$this->add_responsive_control(
				'text_align',
				[
					'label' 	=> esc_html__( 'Alignment', 'gimont' ),
					'type' 		=> Controls_Manager::CHOOSE,
					'options' 	=> [
						'left' 	=> [
							'title' => esc_html__( 'Left', 'gimont' ),
							'icon' 	=> 'eicon-text-align-left',
						],
						'center' => [
							'title' => esc_html__( 'Center', 'gimont' ),
							'icon' 	=> 'eicon-text-align-center',
						],
						'right' => [
							'title' => esc_html__( 'Right', 'gimont' ),
							'icon' 	=> 'eicon-text-align-right',
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ova-counter-2' => 'text-align: {{VALUE}};',
					],
				]
			);
			
		$this->end_controls_section();

		/* Begin Counter Style */
		$this->start_controls_section(
            'counter_style',
            [
               'label' => esc_html__( 'Ova Counter', 'gimont' ),
               'tab' 	=> Controls_Manager::TAB_STYLE,
            ]
        );

        	$this->add_responsive_control(
	            'counter_padding',
	            [
	                'label' 		=> esc_html__( 'Padding', 'gimont' ),
	                'type' 			=> Controls_Manager::DIMENSIONS,
	                'size_units' 	=> [ 'px', '%', 'em' ],
	                'selectors' 	=> [
	                    '{{WRAPPER}} .ova-counter-2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
	                ],
	            ]
	        );

			$this->add_control(
				'counter_bgcolor',
				[
					'label' 	=> esc_html__( 'Background', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-counter-2' => 'background: {{VALUE}};',
					],
				]
			);

        $this->end_controls_section();
		/* End counter style */
        
        /* Begin icon Style */
		$this->start_controls_section(
			'section_icon_style',
			[
				'label' => esc_html__( 'Icon', 'gimont' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);


			$this->add_control(
				'icon_bgsize',
				[
					'label' 		=> esc_html__( 'Background Size', 'gimont' ),
					'type' 			=> Controls_Manager::SLIDER,
					'size_units' 	=> [ 'px' ],
					'range' => [
						'px' => [
							'min' 	=> 60,
							'max' 	=> 200,
							'step' 	=> 1,
						]
					],
					'selectors' 	=> [
						'{{WRAPPER}} .ova-counter-2 .icon' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'icon_fontsize',
				[
					'label' 		=> esc_html__( 'Size', 'gimont' ),
					'type' 			=> Controls_Manager::SLIDER,
					'size_units' 	=> [ 'px' ],
					'range' => [
						'px' => [
							'min' 	=> 0,
							'max' 	=> 90,
							'step' 	=> 1,
						]
					],
					'selectors' 	=> [
						'{{WRAPPER}} .ova-counter-2 .icon i' => 'font-size: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .ova-counter-2 .icon svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name' => 'icon_border',
					'selector' => '{{WRAPPER}} .ova-counter-2 .icon',
				]
			);

			$this->add_control(
				'icon_color',
				[
					'label' 	=> esc_html__( 'Color', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-counter-2 .icon i' => 'color : {{VALUE}};',
						'{{WRAPPER}} .ova-counter-2 .icon svg' => 'fill : {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'icon_bgcolor',
				[
					'label' 	=> esc_html__( 'Background Color', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-counter-2 .icon' => 'background-color : {{VALUE}};',
					],
				]
			);

			$this->add_responsive_control(
				'icon_margin',
				[
					'label' 		=> esc_html__( 'Margin', 'gimont' ),
					'type' 			=> Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px', 'em', '%' ],
					'selectors' 	=> [
						'{{WRAPPER}} .ova-counter-2 .icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section(); 
		// End Style tab Icon

		/* Begin number (odometer) Style */
		$this->start_controls_section(
            'number_style',
            [
                'label' => esc_html__( 'Number', 'gimont' ),
                'tab' 	=> Controls_Manager::TAB_STYLE,
            ]
        );

			 $this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'number_typography',
					'selector' 	=> '{{WRAPPER}} .ova-counter-2 .odometer',
				]
			);

			$this->add_control(
				'number_color',
				[
					'label' 	=> esc_html__( 'Color', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-counter-2 .odometer' => 'color: {{VALUE}};',
					],
				]
			);

        $this->end_controls_section();
		/* End number style */

		/* Begin suffix Style */
		$this->start_controls_section(
            'suffix_style',
            [
                'label' => esc_html__( 'Suffix', 'gimont' ),
                'tab' 	=> Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'suffix_typography',
					'selector' 	=> '{{WRAPPER}} .ova-counter-2 .suffix',
				]
			);

			$this->add_control(
				'suffix_color',
				[
					'label' 	=> esc_html__( 'Color', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-counter-2 .suffix' => 'color: {{VALUE}};',
					],
				]
			);

        $this->end_controls_section();
		/* End suffix style */

		/* Begin title Style */
		$this->start_controls_section(
            'title_style',
            [
                'label' => esc_html__( 'Title', 'gimont' ),
                'tab' 	=> Controls_Manager::TAB_STYLE,
            ]
        );

        	$this->add_responsive_control(
	            'title_margin',
	            [
	                'label' 		=> esc_html__( 'Margin', 'gimont' ),
	                'type' 			=> Controls_Manager::DIMENSIONS,
	                'size_units' 	=> [ 'px', '%', 'em' ],
	                'selectors' 	=> [
	                    '{{WRAPPER}} .ova-counter-2 .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
	                ],
	            ]
	        );

            $this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'title_typography',
					'selector' 	=> '{{WRAPPER}} .ova-counter-2 .title',
				]
			);

			$this->add_control(
				'title_color',
				[
					'label' 	=> esc_html__( 'Color', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-counter-2 .title' => 'color: {{VALUE}};',
					],
				]
			);

        $this->end_controls_section();
		/* End title style */	
	}

	// Render Template Here
	protected function render() {

		$settings 	= $this->get_settings();
		
		$template 	= $settings['template'];
        $icon 		= $settings['icon'];
		$number     = isset( $settings['number'] ) ? $settings['number'] : 100;
		$suffix     = $settings['suffix'];
		$title      = $settings['title'];

		?>
           
        <div class="ova-counter-2 <?php echo esc_attr( $template ); ?>" data-count="<?php echo esc_attr( $number ); ?>">

           	<?php if ( $icon['value'] ): ?>
	        	<div class="icon">
					<?php \Elementor\Icons_Manager::render_icon( $icon, [ 'aria-hidden' => 'true' ] ); ?>
				</div>
			<?php endif;?>

			<div class="info">
				<div class="odometer-wrapper">
					<span class="odometer">0</span>
					<span class="suffix"><?php echo esc_html( $suffix ); ?></span>
				</div>

				<?php if ( $template == 'template_4' ): ?>
					<div class="divider"></div>
				<?php endif;?>

	      	    <?php if ( $title ): ?>
					<p class="title"><?php echo esc_html( $title ); ?></p>
				<?php endif;?>
			</div>

        </div>
		 	
		<?php
	}

	
}
$widgets_manager->register( new Gimont_Elementor_Counter_2() );