<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Gimont_Elementor_Give_Donations extends Widget_Base {

	public function get_name() {
		return 'gimont_elementor_give_donations';
	}

	public function get_title() {
		return esc_html__( 'Give Donations', 'gimont' );
	}

	public function get_icon() {
		return 'eicon-price-table';
	}

	public function get_categories() {
		return [ 'gimont' ];
	}

	public function get_script_depends() {
		return [ 'gimont-elementor-give-donations' ];
	}

	protected function register_controls() {

		/***** Layout Section *****/
		$this->start_controls_section(
			'section_layout',
			[
				'label' => esc_html__( 'Layout', 'gimont' ),
			]
		);

		$this->add_control(
			'layout_columns',
			[
				'label' => esc_html__( 'Columns', 'gimont' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'two_column',
				'options' => [
					'two_column'  	=> esc_html__( '2 Columns', 'gimont' ),
					'three_column'  => esc_html__( '3 Columns', 'gimont' ),
					'four_column'   => esc_html__( '4 Columns', 'gimont' ),
				],
			]
		);

		$this->add_control(
			'visibility',
			[
				'label' 	=> esc_html__( 'Visibility', 'gimont' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> 'public',
				'options' 	=> [
					'public' 	=> esc_html__( 'Public', 'gimont' ),
					'featured' => esc_html__( 'Featured Give Form', 'gimont' ),
				],
			]
		);

		$args = array(
			'taxonomy' => 'give_forms_category',
		  	'orderby' 	=> 'name',
		  	'order' 	=> 'ASC'
		);

		$categories  	= get_categories($args);
		$cate_array 	= array();
		$arrayCateAll 	= array( 'all' => esc_html__( 'All categories', 'gimont' ) );
		
		if ($categories) {
			foreach ( $categories as $cate ) {
				$cate_array[$cate->slug] = $cate->cat_name;
			}
		} else {
			$cate_array[ esc_html__( 'No content Category found', 'gimont' ) ] = 0;
		}

		$this->add_control(
			'category',
			[
				'label' 	=> esc_html__( 'Category', 'gimont' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> 'all',
				'options' 	=> array_merge($arrayCateAll,$cate_array),
			]
		);


		$this->add_control(
			'posts_per_page',
			[
				'label' => esc_html__( 'Posts Per Page', 'gimont' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 3,
			]
		);

		$this->add_control(
			'order',
			[
				'label' => esc_html__('Order', 'gimont'),
				'type' 	=> Controls_Manager::SELECT,
				'default' => 'desc',
				'options' => [
					'asc' 	=> esc_html__('Ascending', 'gimont'),
					'desc' 	=> esc_html__('Descending', 'gimont'),
				]
			]
		);

		$this->add_control(
			'orderby',
			[
				'label' 	=> esc_html__('Order By', 'gimont'),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> 'ID',
				'options' 	=> [
					'ID' 		=> esc_html__('ID', 'gimont'),
					'title' 	=> esc_html__('Title', 'gimont'),
					'date' 		=> esc_html__('Date', 'gimont'),
					'modified' 	=> esc_html__('Modified', 'gimont'),
					'rand' 		=> esc_html__('Rand', 'gimont'),
				]
			]
		);

		$this->add_control(
			'show_category',
			[
				'label' 		=> esc_html__( 'Show Category', 'gimont' ),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on' 		=> esc_html__( 'Show', 'gimont' ),
				'label_off' 	=> esc_html__( 'Hide', 'gimont' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'no',
			]
		);

		$this->add_control(
			'show_excerpt',
			[
				'label' 		=> esc_html__( 'Show Excerpt', 'gimont' ),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on' 		=> esc_html__( 'Show', 'gimont' ),
				'label_off' 	=> esc_html__( 'Hide', 'gimont' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

		$this->add_control(
			'limit_text',
			[
				'label' 	=> esc_html__( 'Description Words Limit', 'gimont' ),
				'type' 		=> Controls_Manager::NUMBER,
				'default' 	=> 12,
				'condition' => [
					'show_excerpt' => 'yes'
				]
			]
		);


		$this->end_controls_section();
		/***** End Layout Section *****/

		//SECTION TAB STYLE TITLE
		$this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__( 'Title', 'gimont' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' 		=> 'content_typography_title',
					'label' 	=> esc_html__( 'Typography', 'gimont' ),
					'selector' 	=> '{{WRAPPER}} .ova_give_detail .detail_body .title',
				]
			);

			$this->add_control(
				'color_title',
				[
					'label' 	=> esc_html__( 'Color', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_give_detail .detail_body  .title' => 'color : {{VALUE}};',
						'{{WRAPPER}} .ova_give_detail .detail_body  .title a' => 'color : {{VALUE}};',	
					],
				]
			);

			$this->add_control(
				'color_title_hover',
				[
					'label' 	=> esc_html__( 'Color hover', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_give_detail .detail_body .title a:hover' => 'color : {{VALUE}};'
					],
					
				]
			);

			$this->add_responsive_control(
				'padding_title',
				[
					'label' 	 => esc_html__( 'Padding', 'gimont' ),
					'type' 		 => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .ova_give_detail .detail_body .title ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'margin_title',
				[
					'label' 	 => esc_html__( 'Margin', 'gimont' ),
					'type' 		 => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .ova_give_detail .detail_body .title ' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section();
		//END SECTION TAB STYLE TITLE


		$this->start_controls_section(
			'section_progress_style',
			[
				'label' => esc_html__( 'Progress', 'gimont' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'color_progress_main',
				[
					'label' => esc_html__( 'Main Color', 'gimont' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .give-progress .project-percent' => 'background-color : {{VALUE}} !important;',
					],
				]
			);

			$this->add_control(
				'color_progress',
				[
					'label' => esc_html__( 'Sub Color', 'gimont' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .give-progress' => 'background-color : {{VALUE}} !important;',
					],
				]
			);

		$this->end_controls_section();

	}
	

	protected function render() {

		$settings = $this->get_settings();

		$layout_columns = $settings['layout_columns'];
		$category 		= $settings['category'];
		$posts_per_page = $settings['posts_per_page'];
		$order  		= $settings['order'];
		$orderby  		= $settings['orderby'];

		if ($settings['visibility'] != 'public') {
			$layout_show_post = array(
				array(
					'key' => 'ova_met_feature_give',
					'value' => 'on',
					'compare' => '=',
				)
			);
		} else {
			$layout_show_post = '';
		};

		$paged   = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;

		if ($category == 'all') {
		    $args_base = array(
				'post_type' 	 => 'give_forms',
				'posts_per_page' => $posts_per_page,
				'orderby'		 => $orderby,
				'order'   		 => $order,
				'meta_query' 	 => $layout_show_post,
			);

		} else {
			$args_base = array(
				'post_type' 	 => 'give_forms',
				'posts_per_page' => $posts_per_page,
				'orderby'		 => $orderby,
				'order'   		 => $order,
				'meta_query' 	 => $layout_show_post,
				'tax_query'      => array(
                    array(
                        'taxonomy' => 'give_forms_category',
                        'field'    => 'slug',
                        'terms'    => $category,
                    )
                ),
			);
		}

		$give_donation = new WP_Query( $args_base );

		if( in_array('give/give.php', apply_filters('active_plugins', get_option('active_plugins') ) ) ) {

		?>

			<div class="ova-item-give <?php echo esc_attr($layout_columns); ?>">

				 <?php if( $give_donation->have_posts() ) : while ( $give_donation->have_posts() ) : $give_donation->the_post();

					ob_start(); 
						
					    get_template_part( 'give/template-parts/item-give', null, $settings );
					    
					echo ob_get_clean(); ?>

				<?php endwhile; else: ?>

					<div class="search_not_found">
						<?php esc_html_e( 'Not Found Give Form', 'gimont' ); ?>
					</div>

				<?php endif; wp_reset_postdata(); ?>

			</div>

		<?php } else {
			esc_html_e( 'Please active plugins Give Donations', 'gimont' );
		}
	}
}

$widgets_manager->register( new Gimont_Elementor_Give_Donations() );