<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Gimont_Elementor_Title_Box extends Widget_Base {

	public function get_name() {
		return 'gimont_elementor_title_box';
	}

	public function get_title() {
		return esc_html__( 'Title Box', 'gimont' );
	}

	public function get_icon() {
		return 'eicon-flip-box';
	}

	public function get_categories() {
		return [ 'gimont' ];
	}

	public function get_script_depends() {
		return [ '' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'gimont-elementor-title-box', GIMONT_URI.'/assets/scss/elementor/boxes/title-box.css' );
		return [];
	}
	
	// Add Your Controll In This Function
	protected function register_controls() {

		$this->start_controls_section(
				'section_content',
				[
					'label' => esc_html__( 'Content', 'gimont' ),
				]
			);

			$this->add_control(
				'link',
				[
					'label' => esc_html__( 'Link', 'gimont' ),
					'type' => \Elementor\Controls_Manager::URL,
					'placeholder' => esc_html__( 'https://your-link.com', 'gimont' ),
					'options' => [ 'url', 'is_external', 'nofollow' ],
					'default' => [
						'url' => '',
						'is_external' => true,
						'nofollow' => false,
					],
					'label_block' => true,
				]
			);

			$this->add_control(
				'title',
				[
					'label' => esc_html__( 'Title', 'gimont' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Get Our More Resources', 'gimont' ),
					'placeholder' => esc_html__( 'Type your title here', 'gimont' ),
					'label_block' => true,
				]
			);

			$this->add_control(
				'text_btn',
				[
					'label' => esc_html__( 'Text Button', 'gimont' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Sign Up', 'gimont' ),
					'placeholder' => esc_html__( 'Type your text button here', 'gimont' ),
					'label_block' => true,
				]
			);

			$this->add_control(
				'icon',
				[
					'label' => esc_html__( 'Icon', 'gimont' ),
					'type' => \Elementor\Controls_Manager::ICONS,
					'default' => [
						'value' => 'fas fa-arrow-right',
						'library' => 'all',
					],
				]
			);

		$this->end_controls_section();

		/* General */
		$this->start_controls_section(
				'style_section',
				[
					'label' => esc_html__( 'General', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'item_padding',
				[
					'label' => esc_html__( 'Padding', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-title-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'item_bg',
				[
					'label' => esc_html__( 'Background', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-title-box' => 'background: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Line */
		$this->start_controls_section(
				'line_style_section',
				[
					'label' => esc_html__( 'Line', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'line_mg',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-title-box .line' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'line_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-title-box .line' => 'background: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Title */
		$this->start_controls_section(
				'title_style_section',
				[
					'label' => esc_html__( 'Title', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'title_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-title-box .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'title_typography',
					'selector' => '{{WRAPPER}} .ova-title-box .title a',
				]
			);

			$this->start_controls_tabs(
				'title_style_tabs'
				);

				$this->start_controls_tab(
						'title_style_normal_tab',
						[
							'label' => esc_html__( 'Normal', 'gimont' ),
						]
					);

				$this->add_control(
					'title_color',
					[
						'label' => esc_html__( 'Color', 'gimont' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-title-box .title a' => 'color: {{VALUE}}',
						],
					]
				);

				$this->end_controls_tab();

				$this->start_controls_tab(
						'title_style_hover_tab',
						[
							'label' => esc_html__( 'Hover', 'gimont' ),
						]
					);

				$this->add_control(
					'title_color_hover',
					[
						'label' => esc_html__( 'Color', 'gimont' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-title-box:hover .title a' => 'color: {{VALUE}}',
						],
					]
				);

				$this->end_controls_tab();

			$this->end_controls_tabs();

		$this->end_controls_section();

		/* Text Button */
		$this->start_controls_section(
				'text_btn_style_section',
				[
					'label' => esc_html__( 'Text Button', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'text_btn_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-title-box .link .text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'text_btn_typography',
					'selector' => '{{WRAPPER}} .ova-title-box .link .text',
				]
			);

			$this->start_controls_tabs(
				'text_btn_style_tabs'
				);

				$this->start_controls_tab(
						'text_btn_style_normal_tab',
						[
							'label' => esc_html__( 'Normal', 'gimont' ),
						]
					);

				$this->add_control(
					'text_btn_color',
					[
						'label' => esc_html__( 'Color', 'gimont' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-title-box .link .text' => 'color: {{VALUE}}',
						],
					]
				);

				$this->end_controls_tab();

				$this->start_controls_tab(
						'text_btn_style_hover_tab',
						[
							'label' => esc_html__( 'Hover', 'gimont' ),
						]
					);

				$this->add_control(
					'text_btn_color_hover',
					[
						'label' => esc_html__( 'Color', 'gimont' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-title-box .link .text:hover' => 'color: {{VALUE}}',
						],
					]
				);

				$this->end_controls_tab();

			$this->end_controls_tabs();

		$this->end_controls_section();

		/* Icon */
		$this->start_controls_section(
				'icon_style_section',
				[
					'label' => esc_html__( 'Icon', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'icon_size',
				[
					'label' => esc_html__( 'Icon Size', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 100,
							'step' => 5,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ova-title-box .icon i' => 'font-size: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .ova-title-box .icon svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
					],
				]
			);		

			$this->start_controls_tabs(
				'icon_style_tabs'
				);

				$this->start_controls_tab(
						'icon_style_normal_tab',
						[
							'label' => esc_html__( 'Normal', 'gimont' ),
						]
					);

				$this->add_control(
					'icon_color',
					[
						'label' => esc_html__( 'Color', 'gimont' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-title-box .icon i' => 'color: {{VALUE}}',
							'{{WRAPPER}} .ova-title-box .icon svg' => 'fill: {{VALUE}}',
						],
					]
				);

				$this->end_controls_tab();

				$this->start_controls_tab(
						'icon_style_hover_tab',
						[
							'label' => esc_html__( 'Hover', 'gimont' ),
						]
					);

				$this->add_control(
					'icon_color_hover',
					[
						'label' => esc_html__( 'Color', 'gimont' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-title-box .icon:hover i' => 'color: {{VALUE}}',
							'{{WRAPPER}} .ova-title-box .icon:hover svg' => 'fill: {{VALUE}}',
						],
					]
				);

				$this->end_controls_tab();

			$this->end_controls_tabs();

		$this->end_controls_section();
	}

	// Render Template Here
	protected function render() {
		$settings 	= $this->get_settings();

		$link 		= $settings['link'];
		$title 		= $settings['title'];
		$text_btn 	= $settings['text_btn'];
		$icon 		= $settings['icon'];
		$link_url 	= $link['url'];
		$target 	= '';
		$nofollow 	= '';
		if ( $link && $link_url) {
			$target 	= $link['is_external'] 	? 'target="_blank"' : '';
			$nofollow 	= $link['nofollow'] 	? 'rel="nofollow"' 	: '';
		}

		?>
		<div class="ova-title-box">
			<div class="line"></div>
			<h3 class="title">
				<a href="<?php echo esc_url( $link_url ); ?>"
					title="<?php echo esc_attr( $title ); ?>"
					<?php printf('%1$s %2$s', $target, $nofollow ); ?>>
					<?php echo esc_html( $title ); ?>
				</a>
			</h3>
			<div class="link">
				<a href="<?php echo esc_url( $link_url ); ?>"
					title="<?php echo esc_attr( $text_btn ); ?>"
					<?php printf('%1$s %2$s', $target, $nofollow ); ?>
					class="text">
					<?php echo esc_html( $text_btn ); ?>
				</a>
				<div class="icon">
					<?php \Elementor\Icons_Manager::render_icon( $icon, [ 'aria-hidden' => 'true' ] ); ?>
				</div>
			</div>
		</div>
		<?php
	}

	
}
$widgets_manager->register( new Gimont_Elementor_Title_Box() );