<?php if ( !defined( 'ABSPATH' ) ) exit(); 

	if( isset( $args['id'] ) ) {
		$id = $args['id'];
	} else {
		$id = get_the_id();
	}

	$thumbnail   	= wp_get_attachment_image_url(get_post_thumbnail_id() , 'gimont_thumbnail' );
	if ( $thumbnail == '') {
	    $thumbnail  =  \Elementor\Utils::get_placeholder_image_src();
	}

	$ova_met_gallery_give 	= get_post_meta( $id, 'ova_met_gallery_give', true );
	$ova_met_media_give 	= get_post_meta( $id, 'ova_met_media_give', true );

	$gallery_data = array();

	if ( $ova_met_gallery_give && is_array( $ova_met_gallery_give ) ) {
	    foreach( $ova_met_gallery_give as $img_id => $image_url ) {
	        $image_caption  = wp_get_attachment_caption( $img_id );

	        if ( !$image_caption ) {
	            $image_caption = get_post_meta( $img_id, '_wp_attachment_image_alt', true );
	        }

	        if ( !$image_caption ) {
	            $image_caption = get_the_title( $img_id );
	        }

	        array_push( $gallery_data, array(
	            'src'       => $image_url,
	            'caption'   => $image_caption,
	            'thumb'     => $image_url,
	            'type'      => 'image',
	        ));
	    }
	}

	$show_goal 				= give_get_meta( $id, '_give_goal_option', true ) ? get_post_meta( $id, '_give_goal_option', true ) : '';
	$gimont_progress_stats  = apply_filters( 'gimont_progress_stats', $id );

	$show_category	= isset($args['show_category'])  ? $args['show_category'] : 'no';

	$show_excerpt	= isset($args['show_excerpt'])  ? $args['show_excerpt'] : 'no';
	$limit_text		= isset($args['limit_text']) 	? $args['limit_text'] 	: 12;
	$excerpt       	= wp_trim_words(get_the_excerpt(),$limit_text,'...');

	$give_type  	= !is_wp_error( get_the_terms( $id, 'give_forms_category') ) ? get_the_terms( $id, 'give_forms_category') : '' ;
			
	$value_give_type = $slug_give_type = array();

	if ( $give_type != '' ) {
		foreach ( $give_type as $value ) {
			$value_give_type[] = $value->term_id ? '<a class="give_type" href="'.get_term_link($value->term_id).'">' .$value->name. '</a>': "";
			$slug_give_type[]  = $value->term_id ? $value->slug : "";
		}
	}
	

?>

	<div class="ova_give_detail <?php echo implode( ' ', $slug_give_type ); ?>">

		<div class="image_future">

			<div class="thumbnail">
				<a href="<?php echo get_the_permalink( $id ); ?>">
					<img src="<?php echo esc_url( $thumbnail ); ?>" alt="<?php the_title(); ?>">
				</a>
			</div>

			<div class="media">

				<?php if ( $ova_met_gallery_give ) { ?>
					<div class="gallery" data-gallery="<?php echo esc_attr( json_encode( $gallery_data ) );?>">
						<i class="fas fa-photo-video"></i>
					</div>
				<?php } ?>

				<?php if ( $ova_met_media_give ) { ?>
					<a href="<?php echo esc_url( $ova_met_media_give ); ?>" data-fancybox="give-video-<?php echo esc_attr($id);?>" data-src="<?php echo esc_attr( $ova_met_media_give ); ?>" class="video" aria-label="<?php esc_attr_e('Give Video','gimont');?>">
						<i class="fas fa-play"></i>
					</a>
				<?php } ?>

			</div>

			<a href="<?php echo get_the_permalink( $id ); ?>" class="donate-button">
			    <span class="text-button">
			    	<?php echo esc_html__('Donate now','gimont');?>
			    </span>
			</a>
			
		</div>
		
		<div class="detail_body">

			<?php if ( !empty(array_filter($value_give_type)) && $show_category == 'yes' ) { ?>
				<div class="post_cat">
					<?php echo implode( ', ', $value_give_type ); ?>
				</div>
			<?php } ?>

			<h3 class="title">
				<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
			</h3>

			<?php if( $show_excerpt == 'yes' && $excerpt != '') { ?>
				<p class="desc"><?php echo esc_html( $excerpt ); ?></p>
			<?php }?>

			<?php if ( $show_goal != 'disabled' ) { ?>
				<div class="give-progress">

					<span class="project-percent" data-percent=<?php echo esc_attr( $gimont_progress_stats['progress'] ); ?>  >
							
						<?php if ($show_goal != 'disabled') { ?>
							<span class="percentage">
								<?php echo esc_html( $gimont_progress_stats['progress'] . '%' ); ?>
							</span>
						<?php } ?>
					
					</span>
				</div>
			<?php } ?>

			<div class="raised">
				<div class="income">
					<span><?php esc_html_e( 'Raised :', 'gimont' ); ?></span>
					<span><?php echo esc_html( $gimont_progress_stats['actual'] ); ?></span>
				</div>

				<?php if ($show_goal != 'disabled') { ?>
					<div class="goal">
						<span><?php esc_html_e( 'Goal :', 'gimont' ); ?></span>
						<span><?php echo esc_html( $gimont_progress_stats['goal'] ); ?></span>
					</div>
				<?php } ?>
			</div>

		</div>
	</div>