<?php if ( !defined( 'ABSPATH' ) ) exit();

if ( ! class_exists( 'Gimont_Ajax' ) ) {

	class Gimont_Ajax{

		public function __construct(){

			add_action( 'wp_ajax_load_search_item_list', array( $this, 'load_search_item_list') );
			add_action( 'wp_ajax_nopriv_load_search_item_list', array( $this, 'load_search_item_list') );
		
		}

		public function load_search_item_list() {
			check_ajax_referer( apply_filters( 'gimont_ajax_security', 'ajax_theme' ), 'security' );

			$keyword 		= isset($_POST['keyword']) 		? sanitize_text_field( $_POST['keyword'] ) 	  : '';
			$post_types 	= isset($_POST['post_types']) 	? gimont_array_sanitize_text_field($_POST['post_types']) : '';
			$posts_per_page = isset($_POST['total']) 		? sanitize_text_field( $_POST['total'] ) 	  : 20;
			$order 			= isset($_POST['order']) 		? sanitize_text_field( $_POST['order'] ) 	  : 'asc';
			$orderby 		= isset($_POST['orderby']) 		? sanitize_text_field( $_POST['orderby'] ) 	  : 'title';
			$search_by  	= isset($_POST['search_by']) 	? sanitize_text_field( $_POST['search_by'] )  : 'both';

			$all_post_types = array('post','page','event','team','career','give_forms','collection','artist','exhibition','ova_dep','ova_doc','ova_por','ova_sev','ova_dir');

			if( in_array('all', $post_types) ) {
				$post_types = $all_post_types;
			}

			if($search_by == 'both') {
				$args_search =  array( 
					'post_status' => 'publish', 
					'post_type' => $post_types, 
					'posts_per_page'=> $posts_per_page,
					'order' => $order, 
					'orderby' => $orderby, 
					's' => $keyword, 
					'fields' => 'ids',
				);
			} else {
				$args_search =  array( 
					'post_status' => 'publish', 
					'post_type' => $post_types, 
					'posts_per_page'=> $posts_per_page,
					'order' => $order, 
					'orderby' => $orderby, 
					's' => $keyword, 
					'search_columns' => $search_by,
					'fields' => 'ids',
				);
			}

			$result_ids = get_posts( $args_search );

			if( $result_ids ) : foreach($result_ids as $result_id) :
				$image_src = wp_get_attachment_url( get_post_thumbnail_id($result_id) );
				if($image_src == '') {
					$image_src = \Elementor\Utils::get_placeholder_image_src();
				}
			?>
				<a href="<?php echo get_the_permalink($result_id); ?>" class="item">
			        <img src="<?php echo esc_url($image_src);?>" alt="<?php the_title($result_id);?>">
			        <div class="info">
			        	<h3 class="title">
				            <?php echo get_the_title($result_id);?>
				        </h3>
				        <p class="desc">
				        	<?php echo gimont_custom_text( get_the_excerpt($result_id), 15 ); ?>
				        </p>
			        </div>
				</a>
			<?php endforeach; wp_reset_postdata(); else : ?>
				<p class='item'><?php esc_html_e( 'Not found !', 'gimont' ); ?></p>
			<?php endif;

			wp_die();
		}

	}

	new Gimont_Ajax();
}