<?php

require_once (GIMONT_URL.'/install-resource/class-tgm-plugin-activation.php');

add_action( 'tgmpa_register', 'gimont_register_required_plugins' );

function gimont_register_required_plugins() {
   
    $plugins = array(

        array(
            'name'                     => esc_html__('Elementor','gimont'),
            'slug'                     => 'elementor',
            'required'                 => true,
        ),
        array(
            'name'                     => esc_html__('Contact Form 7','gimont'),
            'slug'                     => 'contact-form-7',
            'required'                 => true,
        ),
        array(
            'name'                     => esc_html__('Widget importer exporter','gimont'),
            'slug'                     => 'widget-importer-exporter',
            'required'                 => true,
        ),
        array(
            'name'                     => esc_html__('One click demo import','gimont'),
            'slug'                     => 'one-click-demo-import',
            'required'                 => true,
        ),
        array(
            'name'                     => esc_html__('Slider Revolution','gimont'),
            'slug'                     => 'revslider',
            'required'                 => true,
            'source'                   => get_template_directory() . '/install-resource/plugins/revslider.zip',
            'version'                  => '6.7.18',
        ),
        array(
            'name'                     => esc_html__('OvaTheme Framework','gimont'),
            'slug'                     => 'ova-framework',
            'required'                 => true,
            'source'                   => get_template_directory() . '/install-resource/plugins/ova-framework.zip',
            'version'                  => '1.0.3',
        ),
        array(
            'name'                     => esc_html__('Ovatheme MegaMenu','gimont'),
            'slug'                     => 'ova-megamenu',
            'required'                 => true,
            'source'                   => get_template_directory() . '/install-resource/plugins/ova-megamenu.zip',
            'version'                  => '1.0.3',
        ),
        array(
            'name'                     => esc_html__('Ovatheme Department','gimont'),
            'slug'                     => 'ova-dep',
            'required'                 => true,
            'source'                   => get_template_directory() . '/install-resource/plugins/ova-dep.zip',
            'version'                  => '1.0.5',
        ),
        array(
            'name'                     => esc_html__('Ovatheme Document','gimont'),
            'slug'                     => 'ova-doc',
            'required'                 => true,
            'source'                   => get_template_directory() . '/install-resource/plugins/ova-doc.zip',
            'version'                  => '1.0.6',
        ),
        array(
            'name'                     => esc_html__('Ovatheme Service','gimont'),
            'slug'                     => 'ova-sev',
            'required'                 => true,
            'source'                   => get_template_directory() . '/install-resource/plugins/ova-sev.zip',
            'version'                  => '1.0.7',
        ),
        array(
            'name'                     => esc_html__('Ovatheme Team','gimont'),
            'slug'                     => 'ova-team',
            'required'                 => true,
            'source'                   => get_template_directory() . '/install-resource/plugins/ova-team.zip',
            'version'                  => '1.0.6',
        ),
        array(
            'name'                     => esc_html__('Ovatheme Portfolio','gimont'),
            'slug'                     => 'ova-portfolio',
            'required'                 => true,
            'source'                   => get_template_directory() . '/install-resource/plugins/ova-portfolio.zip',
            'version'                  => '1.0.6',
        ),
        array(
            'name'                     => esc_html__('Ovatheme Events','gimont'),
            'slug'                     => 'ova-events',
            'required'                 => true,
            'source'                   => get_template_directory() . '/install-resource/plugins/ova-events.zip',
            'version'                  => '1.0.9',
        ),
        array(
            'name'                     => esc_html__('Ovatheme Career','gimont'),
            'slug'                     => 'ova-career',
            'required'                 => true,
            'source'                   => get_template_directory() . '/install-resource/plugins/ova-career.zip',
            'version'                  => '1.0.6',
        ),
        array(
            'name'                     => esc_html__('Ovatheme Directory','gimont'),
            'slug'                     => 'ova-dir',
            'required'                 => true,
            'source'                   => get_template_directory() . '/install-resource/plugins/ova-dir.zip',
            'version'                  => '1.0.6',
        ),
        array(
            'name'                     => esc_html__('OvaTheme Collections','gimont'),
            'slug'                     => 'ova-collections',
            'required'                 => true,
            'source'                   => get_template_directory() . '/install-resource/plugins/ova-collections.zip',
            'version'                   => '1.0.3'
        ),
        array(
            'name'                     => esc_html__('OvaTheme Exhibition','gimont'),
            'slug'                     => 'ova-exhibition',
            'required'                 => true,
            'source'                   => get_template_directory() . '/install-resource/plugins/ova-exhibition.zip',
            'version'                   => '1.0.3' 
        ),
        array(
            'name'                     => esc_html__('Mailchimp','gimont'),
            'slug'                     => 'mailchimp-for-wp',
            'required'                 => true,
        ),
        array(
            'name'                     => esc_html__('WooCommerce','gimont'),
            'slug'                     => 'woocommerce',
            'required'                 => true,
        ),
        array(
            'name'                     => esc_html__('Give - Donation Plugin','gimont'),
            'slug'                     => 'give',
            'required'                 => true,
        ),
        array(
            'name'                     => esc_html__('CMB2','gimont'),
            'slug'                     => 'cmb2',
            'required'                 => true,
        ),
    );

    $config = array(
        'id'           => 'gimont',                 // Unique ID for hashing notices for multiple instances of TGMPA.
        'default_path' => '',                      // Default absolute path to bundled plugins.
        'menu'         => 'tgmpa-install-plugins', // Menu slug.
        'has_notices'  => true,                    // Show admin notices or not.
        'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
        'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
        'is_automatic' => false,                   // Automatically activate plugins after installation or not.
        'message'      => '',                      // Message to output right before the plugins table.
    );

    tgmpa( $plugins, $config );


    // update option give  
    $give_settings = get_option('give_settings');

    if( $give_settings ){
        $give_settings['categories'] = 'enabled';
        $give_settings['tags']       = 'enabled';

        update_option( 'give_settings', $give_settings );    
    }
    

}

// Before import demo data
add_action( 'ocdi/before_content_import', 'gimont_before_content_import' );
function gimont_before_content_import() { 
    // update option elementor cpt support
    $post_types = array('post','page','event','team','career','ova_framework_hf_el','ova_dep','ova_doc','ova_por','ova_sev');
    update_option( 'elementor_cpt_support', $post_types );

    // update option give  
    $give_settings = get_option('give_settings');

    if( $give_settings ){
        $give_settings['categories'] = 'enabled';
        $give_settings['tags']       = 'enabled';

        update_option( 'give_settings', $give_settings );    
    }
    
}

// After import demo data
add_action( 'ocdi/after_import', 'gimont_after_import_setup' );
function gimont_after_import_setup() {

    gimont_replace_url_after_import();

    // Assign menus to their locations.
    $primary = get_term_by( 'name', 'Primary Menu', 'nav_menu' );

    set_theme_mod( 'nav_menu_locations', array(
            'primary' => $primary->term_id,
        )
    );

    // Assign front page and posts page (blog page).
    $front_page_id = gimont_get_page_by_title( 'Home 1' );
    $blog_page_id  = gimont_get_page_by_title( 'Blog' );

    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );
    update_option( 'page_for_posts', $blog_page_id->ID );

    // Config Elementor
    update_option( 'elementor_disable_color_schemes', 'yes' );
    update_option( 'elementor_disable_typography_schemes', 'yes' );
    update_option( 'elementor_css_print_method', 'internal' );
    update_option( 'elementor_load_fa4_shim', 'yes' );

    gimont_import_slideshows_demo();

    gimont_setup_header_footer_plugins();
}

add_filter( 'ocdi/import_files', 'gimont_import_files' );
function gimont_import_files() {
    return array(
        array(
            'import_file_name'             => 'Demo Import',
            'categories'                   => array( 'Category 1', 'Category 2' ),
            'local_import_file'            => trailingslashit( get_template_directory() ) . 'install-resource/demo-import/demo-content.xml',
            'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'install-resource/demo-import/widgets.wie',
            'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'install-resource/demo-import/customize.dat',
        )
    );
}



// Get page by title
if ( ! function_exists( 'gimont_get_page_by_title' ) ) {
    function gimont_get_page_by_title( $page_title, $output = OBJECT, $post_type = 'page' ) {
        global $wpdb;

        if ( is_array( $post_type ) ) {
            $post_type           = esc_sql( $post_type );
            $post_type_in_string = "'" . implode( "','", $post_type ) . "'";
            $sql                 = $wpdb->prepare(
                "
                SELECT ID
                FROM $wpdb->posts
                WHERE post_title = %s
                AND post_type IN ($post_type_in_string)
            ",
                $page_title
            );
        } else {
            $sql = $wpdb->prepare(
                "
                SELECT ID
                FROM $wpdb->posts
                WHERE post_title = %s
                AND post_type = %s
            ",
                $page_title,
                $post_type
            );
        }

        $page = $wpdb->get_var( $sql );

        if ( $page ) {
            return get_post( $page, $output );
        }

        return null;
    }
}

// Replace url after import demo data
if ( ! function_exists('gimont_replace_url_after_import') ) {
    
    function gimont_replace_url_after_import(){
        global $wpdb;
        $site_url       = get_site_url();
        $ovatheme_url   = "https://demo.ovatheme.com/gimont";
        $wpdb->get_results( "UPDATE {$wpdb->prefix}options SET option_value = replace(option_value, '{$ovatheme_url}', '{$site_url}' )" );
        $wpdb->get_results( "UPDATE {$wpdb->prefix}postmeta SET meta_value = replace(meta_value, '{$ovatheme_url}', '{$site_url}' )" );
        $wpdb->get_results( "UPDATE {$wpdb->prefix}posts SET post_content = replace(post_content, '{$ovatheme_url}', '{$site_url}' )" );
        $wpdb->get_results( "UPDATE {$wpdb->prefix}posts SET guid = replace(guid, '{$ovatheme_url}', '{$site_url}' )" );

        // Elementor replace
        $escaped_from       = str_replace( '/', '\\/', $ovatheme_url );
        $escaped_to         = str_replace( '/', '\\/', $site_url );
        $meta_value_like    = '[%'; // meta_value LIKE '[%' are json formatted

        $wpdb->query(
            $wpdb->prepare(
                "UPDATE {$wpdb->postmeta} " .
                'SET `meta_value` = REPLACE(`meta_value`, %s, %s) ' .
                "WHERE `meta_key` = '_elementor_data' AND `meta_value` LIKE %s;",
                $escaped_from,
                $escaped_to,
                $meta_value_like
            )
        );
    }
}

// Import slideshows
if ( ! function_exists( 'gimont_import_slideshows_demo' ) ) {
    function gimont_import_slideshows_demo() {
        if ( is_plugin_active('revslider/revslider.php') && class_exists( 'RevSliderSliderImport' ) ) {
            $slide_files = glob( get_template_directory() . '/install-resource/demo-import/slideshows/*.zip' );

            if ( ! empty( $slide_files ) && is_array( $slide_files ) ) {
                $import = new RevSliderSliderImport();

                foreach ( $slide_files as $path_file ) {
                    if ( file_exists( $path_file ) ) {
                        $return = $import->import_slider( false, $path_file );
                    }
                }
            }
        }
    }
}

// Setup Header Footer for Ova plugins
if ( ! function_exists( 'gimont_setup_header_footer_plugins' ) ) {
    function gimont_setup_header_footer_plugins() {
        $header_banner  = 'ova,header-banner';
        $header         = 'ova,header';
        $header_1       = 'ova,header-1';
        $footer         = 'ova,footer';

        if ( class_exists( 'OVAEV' ) ) { // event
            $ovaev_options = get_option('ovaev_options');

            $ovaev_options['archive_event_header'] = $ovaev_options['single_event_header'] = $header_banner;
            $ovaev_options['archive_event_footer'] = $ovaev_options['single_event_footer'] = $footer;

            update_option( 'ovaev_options', $ovaev_options );
        }

        if ( class_exists( 'OVAEX' ) ) { // exhibition
            $ovaex_options = get_option('ovaex_options');

            $ovaex_options['archive_exhibition_header'] = $ovaex_options['single_exhibition_header'] = $header_banner;
            $ovaex_options['archive_exhibition_footer'] = $ovaex_options['single_exhibition_footer'] =  $footer;

            update_option( 'ovaex_options', $ovaex_options );
        }

        if ( class_exists( 'ovacollection' ) ) { // collection, artist
            $ovacoll_options = get_option('ovacoll_options');

            // collection
            $ovacoll_options['archive_collection_header'] = $ovacoll_options['single_collection_header'] = $header_banner;
            $ovacoll_options['archive_collection_footer'] = $ovacoll_options['single_collection_footer'] = $footer;

            // artist
            $ovacoll_options['archive_artist_header'] = $ovacoll_options['single_artist_header'] = $header_banner;
            $ovacoll_options['archive_artist_footer'] = $ovacoll_options['single_artist_footer'] = $footer;

            update_option( 'ovacoll_options', $ovacoll_options );
        }

        if ( class_exists( 'OvaCAREER' ) ) { // career
            set_theme_mod('header_archive_career', $header_banner);
            set_theme_mod('header_single_career', $header_1);
            set_theme_mod('archive_footer_career', $footer);
            set_theme_mod('single_footer_career', $footer);
        }

        if ( class_exists( 'ovadep' ) ) { // department
            set_theme_mod('header_archive_dep', $header_banner);
            set_theme_mod('header_single_dep', $header_banner);
            set_theme_mod('archive_footer_dep', $footer);
            set_theme_mod('single_footer_dep', $footer);
        }

        if ( class_exists( 'ovadir' ) ) { // directory
            set_theme_mod('header_archive_dir', $header_banner);
            set_theme_mod('header_single_dir', $header_banner);
            set_theme_mod('archive_footer_dir', $footer);
            set_theme_mod('single_footer_dir', $footer);
        }

        if ( class_exists( 'ovadoc' ) ) { // document
            set_theme_mod('header_archive_doc', $header_banner);
            set_theme_mod('header_single_doc', $header_banner);
            set_theme_mod('archive_footer_doc', $footer);
            set_theme_mod('single_footer_doc', $footer);
        }

        if ( class_exists( 'ovapor' ) ) { // portfolio
            set_theme_mod('header_archive_por', $header_banner);
            set_theme_mod('header_single_por', $header_banner);
            set_theme_mod('archive_footer_por', $footer);
            set_theme_mod('single_footer_por', $footer);
        }

        if ( class_exists( 'ovasev' ) ) { // service
            set_theme_mod('header_archive_sev', $header_banner);
            set_theme_mod('header_single_sev', $header_banner);
            set_theme_mod('header_single_sev_2', $header);
            set_theme_mod('archive_footer_sev', $footer);
            set_theme_mod('single_footer_sev', $footer);
            set_theme_mod('single_footer_sev_2', $footer);
        }

        if ( class_exists( 'ovateam' ) ) { // team
            set_theme_mod('header_archive_team', $header_banner);
            set_theme_mod('header_single_team', $header_banner);
            set_theme_mod('archive_footer_team', $footer);
            set_theme_mod('single_footer_team', $footer);
        }

    }
}