<?php

  // Namespace
  namespace BMI\Plugin;

  // Exit on direct access
  if (!defined('ABSPATH')) {
    exit;
  }

  // Plugin includes
  if (!defined('BMI_AUTHOR_URI')) {
    define('BMI_AUTHOR_URI', 'https://backupbliss.com/');
  }
  if (!defined('BMI_API_BACKUPBLISS_PUSH')) {
    define('BMI_API_BACKUPBLISS_PUSH', 'api.backupbliss.com');
  }
  if (!defined('BMI_BACKUPS_DEFAULT')) {
    define('BMI_BACKUPS_DEFAULT', WP_CONTENT_DIR . DIRECTORY_SEPARATOR . 'backup-migration');
  }
  if (!defined('BMI_CONFIG_DEFAULT')) {
    define('BMI_CONFIG_DEFAULT', BMI_INCLUDES . DIRECTORY_SEPARATOR . 'htaccess' . DIRECTORY_SEPARATOR . 'default.json');
  }
  if (!defined('BMI_STATIC_PHP_CONFIG')) {
    define('BMI_STATIC_PHP_CONFIG', WP_CONTENT_DIR . DIRECTORY_SEPARATOR . 'backup-migration-config.php');
  }
  if (!defined('BMI_REV')) {
    define('BMI_REV', 2);
  }

  // Load configuration
  require_once BMI_INCLUDES . DIRECTORY_SEPARATOR . 'config.php';

  // Database queries amount
  if (!defined('BMI_DB_MAX_ROWS_PER_QUERY')) {
    $db_queries = Dashboard\bmi_get_config('OTHER:DB:QUERIES');
    if (is_numeric($db_queries)) {
      $db_queries = intval($db_queries);

      if ($db_queries > 15000 || $db_queries < 15) {
        $db_queries = 2000;
      }
    }

    if (!isset($db_queries) || is_null($db_queries) || !is_numeric($db_queries)) {
      $db_queries = 2000;
    }

    define('BMI_DB_MAX_ROWS_PER_QUERY', $db_queries);
  }

  // Default constants
  if (!defined('BMI_MAX_SEARCH_REPLACE_PAGE')) {
    $db_sr_max_page = Dashboard\bmi_get_config('OTHER:DB:SEARCHREPLACE:MAX');
    if (is_numeric($db_sr_max_page)) {
      $db_sr_max_page = intval($db_sr_max_page);

      if ($db_sr_max_page > 30000 || $db_sr_max_page < 10) {
        $db_sr_max_page = 300;
      }
    }

    if (!isset($db_sr_max_page) || is_null($db_sr_max_page) || !is_numeric($db_sr_max_page)) {
      $db_sr_max_page = 300;
    }

    define('BMI_MAX_SEARCH_REPLACE_PAGE', $db_sr_max_page);
  }
  if (!defined('BMI_MAX_FILE_EXTRACTION_LIMIT')) {
    $file_ex_max_limit = Dashboard\bmi_get_config('OTHER:FILE:EXTRACT:MAX');
    if (is_numeric($file_ex_max_limit)) {
      $file_ex_max_limit = intval($file_ex_max_limit);

      if ($file_ex_max_limit > 20000 || $file_ex_max_limit < 50) {
        $file_ex_max_limit = 'auto';
      }
    } else if (trim(strtolower($file_ex_max_limit)) == 'auto') {
      $file_ex_max_limit = 'auto';
    }

    if ((!isset($file_ex_max_limit) || is_null($file_ex_max_limit) || !is_numeric($file_ex_max_limit)) && $file_ex_max_limit != 'auto') {
      $file_ex_max_limit = 'auto';
    }

    define('BMI_MAX_FILE_EXTRACTION_LIMIT', $file_ex_max_limit);
  }
  if (!defined('BMI_CLI_EXECUTABLE')) {
    $php_cli_path = Dashboard\bmi_get_config('OTHER:CLI:PATH');
    if (strlen(trim($php_cli_path)) > 0) {
      define('BMI_CLI_EXECUTABLE', $php_cli_path);
    }
  }
  if (!defined('BMI_CLI_ENABLED')) {
    $cli_enabled = Dashboard\bmi_get_config('OTHER:CLI:DISABLE') === true ? false : true;
    if ($cli_enabled === false) {
      define('BMI_CLI_ENABLED', $cli_enabled);
    }
  }

  if (Dashboard\bmi_get_config('OTHER:EXPERIMENT:TIMEOUT') === true) {
    $disabled = explode(',', ini_get('disable_functions'));

    if (!function_exists('curl_version') || !function_exists('curl_exec') || !function_exists('curl_init') || in_array('curl_exec', $disabled) || in_array('curl_init', $disabled) || in_array('curl_version', $disabled)) {
      Dashboard\bmi_set_config('OTHER:EXPERIMENT:TIMEOUT', false);
      Dashboard\bmi_set_config('OTHER:USE:TIMEOUT:NORMAL', true);
    }
  }

  if (!defined('BMI_LEGACY_VERSION')) {
    $legacy = (Dashboard\bmi_get_config('OTHER:EXPERIMENT:TIMEOUT') == 'true' || Dashboard\bmi_get_config('OTHER:EXPERIMENT:TIMEOUT') === true) ? false : true;
    define('BMI_LEGACY_VERSION', $legacy);
  }
  if (!defined('BMI_LEGACY_HARD_VERSION')) {
    $legacy_hard = (Dashboard\bmi_get_config('OTHER:EXPERIMENT:TIMEOUT:HARD') == 'true' || Dashboard\bmi_get_config('OTHER:EXPERIMENT:TIMEOUT:HARD') === true) ? false : true;
    define('BMI_LEGACY_HARD_VERSION', $legacy_hard);
  }
  if (!defined('BMI_FUNCTION_NORMAL')) {
    if (BMI_LEGACY_VERSION && BMI_LEGACY_HARD_VERSION) {
      define('BMI_FUNCTION_NORMAL', true);
    } else {
      define('BMI_FUNCTION_NORMAL', false);
    }
  }
  if (!defined('BMI_ASSETS')) {
    define('BMI_ASSETS', plugin_dir_url(BMI_ROOT_FILE) . 'admin');
  }
  if (!defined('BMI_BACKUPS_ROOT')) {
    define('BMI_BACKUPS_ROOT', WP_CONTENT_DIR . DIRECTORY_SEPARATOR . 'backup-migration');
  }
  if (!defined('BMI_TMP')) {
    define('BMI_TMP', BMI_BACKUPS_ROOT . DIRECTORY_SEPARATOR . 'tmp');
  }
  if (!defined('BMI_BACKUPS')) {
    define('BMI_BACKUPS', WP_CONTENT_DIR . DIRECTORY_SEPARATOR . 'backup-migration' . DIRECTORY_SEPARATOR . 'backups');
  }
  if (!defined('BMI_STAGING')) {
    define('BMI_STAGING', WP_CONTENT_DIR . DIRECTORY_SEPARATOR . 'backup-migration' . DIRECTORY_SEPARATOR . 'staging');
  }

  // Fill folders if not removed (security)
  if (!file_exists(BMI_BACKUPS)) {
    mkdir(BMI_BACKUPS, 0755, true);
  }
  if (!file_exists(BMI_STAGING)) {
    mkdir(BMI_STAGING, 0755, true);
  }
  if (!file_exists(BMI_CONFIG_DIR)) {
    mkdir(BMI_CONFIG_DIR, 0755, true);
  }
  if (!file_exists(BMI_TMP)) {
    mkdir(BMI_TMP, 0755, true);
  }

  // Secure config and logs
  if (!file_exists(BMI_CONFIG_DIR . DIRECTORY_SEPARATOR . 'index.php')) {
    touch(BMI_CONFIG_DIR . DIRECTORY_SEPARATOR . 'index.php');
  }
  if (!file_exists(BMI_CONFIG_DIR . DIRECTORY_SEPARATOR . 'index.html')) {
    touch(BMI_CONFIG_DIR . DIRECTORY_SEPARATOR . 'index.html');
  }
  if (!file_exists(BMI_CONFIG_DIR . DIRECTORY_SEPARATOR . '.htaccess')) {
    copy(BMI_INCLUDES . DIRECTORY_SEPARATOR . 'htaccess' . DIRECTORY_SEPARATOR . '.htaccess', BMI_CONFIG_DIR . DIRECTORY_SEPARATOR . '.htaccess');
  }
  if (!file_exists(BMI_STAGING . DIRECTORY_SEPARATOR . 'index.php')) {
    touch(BMI_STAGING . DIRECTORY_SEPARATOR . 'index.php');
  }
  if (!file_exists(BMI_STAGING . DIRECTORY_SEPARATOR . 'index.html')) {
    touch(BMI_STAGING . DIRECTORY_SEPARATOR . 'index.html');
  }
  if (!file_exists(BMI_STAGING . DIRECTORY_SEPARATOR . '.htaccess')) {
    copy(BMI_INCLUDES . DIRECTORY_SEPARATOR . 'htaccess' . DIRECTORY_SEPARATOR . '.htaccess', BMI_STAGING . DIRECTORY_SEPARATOR . '.htaccess');
  }
  if (!file_exists(BMI_TMP . DIRECTORY_SEPARATOR . 'index.php')) {
    touch(BMI_TMP . DIRECTORY_SEPARATOR . 'index.php');
  }
  if (!file_exists(BMI_TMP . DIRECTORY_SEPARATOR . 'index.html')) {
    touch(BMI_TMP . DIRECTORY_SEPARATOR . 'index.html');
  }
  if (!file_exists(BMI_TMP . DIRECTORY_SEPARATOR . '.htaccess')) {
    copy(BMI_INCLUDES . DIRECTORY_SEPARATOR . 'htaccess' . DIRECTORY_SEPARATOR . '.htaccess', BMI_TMP . DIRECTORY_SEPARATOR . '.htaccess');
  }

  // Secure backups (if in backup dir)
  if (!file_exists(BMI_BACKUPS . DIRECTORY_SEPARATOR . 'index.php')) {
    touch(BMI_BACKUPS . DIRECTORY_SEPARATOR . 'index.php');
  }
  if (!file_exists(BMI_BACKUPS . DIRECTORY_SEPARATOR . 'index.html')) {
    touch(BMI_BACKUPS . DIRECTORY_SEPARATOR . 'index.html');
  }
  if (!file_exists(BMI_BACKUPS . DIRECTORY_SEPARATOR . '.htaccess')) {
    copy(BMI_INCLUDES . DIRECTORY_SEPARATOR . 'htaccess' . DIRECTORY_SEPARATOR . '.htaccess', BMI_BACKUPS . DIRECTORY_SEPARATOR . '.htaccess');
  }

  // Tooltips
  if (!defined('BMI_PREMIUM_TOOLTIP')) {
    $tooltip = sanitize_text_field(__("This feature isn’t ready yet in the premium plugin, that’s why you can buy it at a <b>big discount</b>", 'backup-backup'));
    $tooltip .= '&nbsp;– <a href="' . BMI_AUTHOR_URI . '" target="_blank">' . sanitize_text_field(__('learn more', 'backup-backup')) . '</a>.';
    define('BMI_PREMIUM_TOOLTIP', $tooltip);
  }
  if (!defined('BMI_PREMIUM_TOOLTIP_R')) {
    $tooltip_r = '– <a href="' . BMI_AUTHOR_URI . '" target="_blank">' . sanitize_text_field(__('check it out', 'backup-backup')) . '</a>.';
    define('BMI_PREMIUM_TOOLTIP_R', $tooltip_r);
  }
  if (!defined('BMI_COMMING_SOON_TUNED')) {
    $cmsx = '<b><a href="' . BMI_AUTHOR_URI . '" target="_blank" class="link-white">' . sanitize_text_field(__('Order it now at a big discount!', 'backup-backup')) . '</a></b>';
    define('BMI_COMMING_SOON_TUNED', $cmsx);
  }
  if (!defined('BMI_COMMING_SOON_PRO')) {
    $cmsv = '<p class="f16">';
    $cmsv .= sanitize_text_field(__("Coming soon in the Premium Plugin", 'backup-backup'));
    $cmsv .= '&nbsp;–&nbsp;' . BMI_COMMING_SOON_TUNED;
    $cmsv .= '</p>';
    define('BMI_COMMING_SOON_PRO', $cmsv);
  }
  if (!defined('BMI_ALREADY_IN_PRO')) {
    $aisv = '<p class="f16">';
    $aisv .= sanitize_text_field(__("Already included in the Premium Plugin", 'backup-backup'));
    $aisv .= '&nbsp;–&nbsp;' . BMI_COMMING_SOON_TUNED;
    $aisv .= '</p>';
    define('BMI_ALREADY_IN_PRO', $aisv);
  }
  if (!defined('BMI_COMMING_SOON_FREE')) {
    $cmsne = '<p class="f16">';
    $cmsne .= __("Coming soon also in the free plugin", 'backup-backup') . ' – <b>' . __("stay tuned!", 'backup-backup') . '</b>';
    $cmsne .= '</p>';
    define('BMI_COMMING_SOON_FREE', $cmsne);
  }
  if (!defined('BMI_CHAT_SUPPORT_URL')) {
    define('BMI_CHAT_SUPPORT_URL', '//code.jivosite.com/widget/qli4YP0snZ');
  }
