<?php
/**
 * @license MIT
 *
 * Modified by impress-org on 25-September-2024 using Strauss.
 * @see https://github.com/BrianHenryIE/strauss
 */

namespace Give\Vendors\Faker\Provider\de_CH;

class Text extends \Give\Vendors\Faker\Provider\Text
{
    /**
     * The Project Gutenberg EBook of Die Leiden des jungen Werther--Buch 1, by
     * Johann Wolfgang von Goethe
     *
     * This eBook is for the use of anyone anywhere at no cost and with
     * almost no restrictions whatsoever.  You may copy it, give it away or
     * re-use it under the terms of the Project Gutenberg License included
     * with this eBook or online at www.gutenberg.org
     *
     * Title: Die Leiden des jungen Werther--Buch 1
     *
     * Author: Johann Wolfgang von Goethe
     *
     * Posting Date: June 28, 2011 [EBook #2407]
     * Release Date: November, 2000
     *
     * Language: German
     *
     * *** START OF THIS PROJECT GUTENBERG EBOOK DIE LEIDEN DES JUNGEN WERTHER ***
     *
     * Produced by Michael Pullen, globaltraveler5565@yahoo.com
     * with proofreading and correction by Dr. Mary Cicora,
     * mcicora@yahoo.com.
     *
     * @see http://www.gutenberg.org/cache/epub/2407/pg2407.txt
     *
     * @var string
     */
    protected static $baseText = <<<'EOT'
Am 4. Mai 1771

Wie froh bin ich, dass ich weg bin! Bester Freund, was ist das Herz des
Menschen! Dich zu verlassen, den ich so liebe, von dem ich unzertrennlich war, und
froh zu sein! Ich weiss, du verzeihst mir's. Waren nicht meine übrigen
Verbindungen recht ausgesucht vom Schicksal, um ein Herz wie das meine zu ängstigen?
Die arme Leonore! Und doch war ich unschuldig. Konnt' ich dafür, dass, während
die eigensinnigen Reize ihrer Schwester mir eine angenehme Unterhaltung
verschafften, dass eine Leidenschaft in dem armen Herzen sich bildete? Und doch—bin ich
ganz unschuldig? Hab' ich nicht ihre Empfindungen genährt? Hab' ich mich nicht
an den ganz wahren Ausdrücken der Natur, die uns so oft zu lachen machten, so
wenig lächerlich sie waren, selbst ergetzt? Hab' ich nicht—o was ist der Mensch,
dass er über sich klagen darf! Ich will, lieber Freund, ich verspreche dir's,
ich will mich bessern, will nicht mehr ein bisschen Übel, das uns das Schicksal
vorlegt, wiederkäuen, wie ich's immer getan habe; ich will das Gegenwärtige
geniessen, und das Vergangene soll mir vergangen sein. Gewiss, du hast recht, Bester,
der Schmerzen wären minder unter den Menschen, wenn sie nicht—Gott weiss, warum
sie so gemacht sind!—mit so viel Emsigkeit der Einbildungskraft sich
beschäftigten, die Erinnerungen des vergangenen Übels zurückzurufen, eher als eine
gleichgültige Gegenwart zu ertragen.

Du bist so gut, meiner Mutter zu sagen, dass ich ihr Geschäft bestens
betreiben und ihr ehstens Nachricht davon geben werde. Ich habe meine Tante
gesprochen und bei weitem das böse Weib nicht gefunden, das man bei uns aus ihr
macht. Sie ist eine muntere, heftige Frau von dem besten Herzen. Ich erklärte ihr
meiner Mutter Beschwerden über den zurückgehaltenen Erbschaftsanteil; sie sagte
mir ihre Gründe, Ursachen und die Bedingungen, unter welchen sie bereit wäre,
alles herauszugeben, und mehr als wir verlangten—kurz, ich mag jetzt nichts
davon schreiben, sage meiner Mutter, es werde alles gut gehen. Und ich habe,
mein Lieber, wieder bei diesem kleinen Geschäft gefunden, dass Missverständnisse
und Trägheit vielleicht mehr Irrungen in der Welt machen als List und Bosheit.
Wenigstens sind die beiden letzteren gewiss seltener.

Übrigens befinde ich mich hier gar wohl. Die Einsamkeit ist meinem Herzen
köstlicher Balsam in dieser paradiesischen Gegend, und diese Jahreszeit der Jugend
wärmt mit aller Fülle mein oft schauderndes Herz. Jeder Baum, jede Hecke ist ein
Strauss von Blüten, und man möchte zum Maienkäfer werden, um in dem Meer von
Wohlgerüchen herumschweben und alle seine Nahrung darin finden zu können.

Die Stadt selbst ist unangenehm, dagegen rings umher eine unaussprechliche
Schönheit der Natur. Das bewog den verstorbenen Grafen von M., einen Garten auf
einem der Hügel anzulegen, die mit der schönsten Mannigfaltigkeit sich kreuzen
und die lieblichsten Täler bilden. Der Garten ist einfach, und man fühlt
gleich bei dem Eintritte, dass nicht ein wissenschaftlicher Gärtner, sondern ein
fühlendes Herz den Plan gezeichnet, das seiner selbst hier geniessen wollte. Schon
manche Träne hab' ich dem Abgeschiedenen in dem verfallenen Kabinettchen geweint,
das sein Lieblingsplätzchen war und auch meines ist. Bald werde ich Herr vom
Garten sein; der Gärtner ist mir zugetan, nur seit den paar Tagen, und er wird
sich nicht übel dabei befinden.

Am 10. Mai

Eine wunderbare Heiterkeit hat meine ganze Seele eingenommen, gleich den süssen
Frühlingsmorgen, die ich mit ganzem Herzen geniesse. Ich bin allein und freue mich meines
Lebens in dieser Gegend, die für solche Seelen geschaffen ist wie die meine. Ich
bin so glücklich, mein Bester, so ganz in dem Gefühle von ruhigem Dasein
versunken, dass meine Kunst darunter leidet. Ich könnte jetzt nicht zeichnen, nicht
einen Strich, und bin nie ein grösserer Maler gewesen als in diesen Augenblicken.
Wenn das liebe Tal um mich dampft, und die hohe Sonne an der Oberfläche der
undurchdringlichen Finsternis meines Waldes ruht, und nur einzelne Strahlen sich in das
innere Heiligtum stehlen, ich dann im hohen Grase am fallenden Bache liege, und
näher an der Erde tausend mannigfaltige Gräschen mir merkwürdig werden; wenn ich
das Wimmeln der kleinen Welt zwischen Halmen, die unzähligen, unergründlichen
Gestalten der Würmchen, der Mückchen näher an meinem Herzen fühle, und fühle die
Gegenwart des Allmächtigen, der uns nach seinem Bilde schuf, das Wehen des
Alliebenden, der uns in ewiger Wonne schwebend trägt und erhält; mein Freund! Wenn's
dann um meine Augen dämmert, und die Welt um mich her und der Himmel ganz in
meiner Seele ruhn wie die Gestalt einer Geliebten—dann sehne ich mich oft und
denke : ach könntest du das wieder ausdrücken, könntest du dem Papiere das
einhauchen, was so voll, so warm in dir lebt, dass es würde der Spiegel deiner Seele,
wie deine Seele ist der Spiegel des unendlichen Gottes!—mein Freund—aber ich
gehe darüber zugrunde, ich erliege unter der Gewalt der Herrlichkeit dieser
Erscheinungen.

Ich weiss nicht, ob täuschende Geister um diese Gegend schweben, oder ob die
warme, himmlische Phantasie in meinem Herzen ist, die mir alles rings umher so
paradiesisch macht. Das ist gleich vor dem Orte ein Brunnen, ein Brunnen, an den ich
gebannt bin wie Melusine mit ihren Schwestern.—Du gehst einen kleinen Hügel
hinunter und findest dich vor einem Gewölbe, da wohl zwanzig Stufen hinabgehen, wo
unten das klarste Wasser aus Marmorfelsen quillt. Die kleine Mauer, die oben
umher die Einfassung macht, die hohen Bäume, die den Platz rings umher bedecken,
die Kühle des Orts; das hat alles so was Anzügliches, was Schauerliches. Es
vergeht kein Tag, dass ich nicht eine Stunde da sitze. Da kommen die Mädchen aus
der Stadt und holen Wasser, das harmloseste Geschäft und das nötigste, das
ehemals die Töchter der Könige selbst verrichteten. Wenn ich da sitze, so lebt die
patriarchalische Idee so lebhaft um mich, wie sie, alle die Altväter, am Brunnen
Bekanntschaft machen und freien, und wie um die Brunnen und Quellen wohltätige Geister
schweben. O der muss nie nach einer schweren Sommertagswanderung sich an des Brunnens
Kühle gelabt haben, der das nicht mitempfinden kann.

Am 13. Mai

Du fragst, ob du mir meine Bücher schicken sollst?—lieber, ich bitte dich um
Gottes willen, lass mir sie vom Halse! Ich will nicht mehr geleitet, ermuntert,
angefeuert sein, braust dieses Herz doch genug aus sich selbst; ich brauche
Wiegengesang, und den habe ich in seiner Fülle gefunden in meinem Homer. Wie oft lull'
ich mein empörtes Blut zur Ruhe, denn so ungleich, so unstet hast du nichts
gesehn als dieses Herz. Lieber! Brauch' ich dir das zu sagen, der du so oft die
Last getragen hast, mich vom Kummer zur Ausschweifung und von süsser Melancholie
zur verderblichen Leidenschaft übergehen zu sehn? Auch halte ich mein Herzchen
wie ein krankes Kind; jeder Wille wird ihm gestattet. Sage das nicht weiter;
es gibt Leute, die mir es verübeln würden.

Am 15. Mai

Die geringen Leute des Ortes kennen mich schon und lieben mich, besonders die
Kinder. Eine traurige Bemerkung hab' ich gemacht. Wie ich im Anfange mich zu ihnen
gesellte, sie freundschaftlich fragte über dies und das, glaubten einige, ich wollte
ihrer spotten, und fertigten mich wohl gar grob ab. Ich liess mich das nicht
verdriessen; nur fühlte ich, was ich schon oft bemerkt habe, auf das lebhafteste :
Leute von einigem Stande werden sich immer in kalter Entfernung vom gemeinen
Volke halten, als glaubten sie durch Annäherung zu verlieren; und dann gibt's
Flüchtlinge und üble Spassvögel, die sich herabzulassen scheinen, um ihren Übermut dem
armen Volke desto empfindlicher zu machen.

Ich weiss wohl, dass wir nicht gleich sind, noch sein können; aber ich halte
dafür, dass der, der nötig zu haben glaubt, vom so genannten Pöbel sich zu
entfernen, um den Respekt zu erhalten, ebenso tadelhaft ist als ein Feiger, der sich
vor seinem Feinde verbirgt, weil er zu unterliegen fürchtet.

Letzthin kam ich zum Brunnen und fand ein junges Dienstmädchen, das ihr Gefäss auf
die unterste Treppe gesetzt hatte und sich umsah, ob keine Kamerädin kommen
wollte, ihr es auf den Kopf zu helfen. Ich stieg hinunter und sah sie an.—"Soll
ich Ihr helfen, Jungfer?" sagte ich.—sie ward rot über und über.—"O nein,
Herr!" sagte sie.—"Ohne Umstände".—sie legte ihren Kragen zurecht, und ich half
ihr. Sie dankte und stieg hinauf.

Den 17. Mai

Ich habe allerlei Bekanntschaft gemacht, Gesellschaft habe ich noch keine
gefunden. Ich weiss nicht, was ich Anzügliches für die Menschen haben muss; es mögen
mich ihrer so viele und hängen sich an mich, und da tut mir's weh, wenn unser
Weg nur eine kleine Strecke miteinander geht. Wenn du fragst, wie die Leute
hier sind, muss ich dir sagen: wie überall! Es ist ein einförmiges Ding um das
Menschengeschlecht. Die meisten verarbeiten den grössten Teil der Zeit, um zu leben, und das
bisschen, das ihnen von Freiheit übrig bleibt, ängstigt sie so, dass sie alle Mittel
aufsuchen, um es los zu werden. O Bestimmung des Menschen!

Aber eine recht gute Art Volks! Wenn ich mich manchmal vergesse, manchmal mit
ihnen die Freuden geniesse, die den Menschen noch gewährt sind, an einem artig
besetzten Tisch mit aller Offen—und Treuherzigkeit sich herumzuspassen, eine
Spazierfahrt, einen Tanz zur rechten Zeit anzuordnen, und dergleichen, das tut eine ganz
gute Wirkung auf mich; nur muss mir nicht einfallen, dass noch so viele andere
Kräfte in mir ruhen, die alle ungenutzt vermodern und die ich sorgfältig
verbergen muss. Ach das engt das ganze Herz so ein.—Und doch! Missverstanden zu
werden, ist das Schicksal von unsereinem.

Ach, dass die Freundin meiner Jugend dahin ist, ach, dass ich sie je gekannt
habe!—ich würde sagen: du bist ein Tor! Du suchst, was hienieden nicht zu finden
ist! Aber ich habe sie gehabt, ich habe das Herz gefühlt, die grosse Seele, in
deren Gegenwart ich mir schien mehr zu sein, als ich war, weil ich alles war,
was ich sein konnte. Guter Gott! Blieb da eine einzige Kraft meiner Seele
ungenutzt? Konnt' ich nicht vor ihr das ganze wunderbare Gefühl entwickeln, mit dem
mein Herz die Natur umfasst? War unser Umgang nicht ein ewiges Weben von der
feinsten Empfindung, dem schärfsten Witze, dessen Modifikationen, bis zur Unart,
alle mit dem Stempel des Genies bezeichnet waren? Und nun!—ach ihre Jahre, die
sie voraus hatte, führten sie früher ans Grab als mich. Nie werde ich sie
vergessen, nie ihren festen Sinn und ihre göttliche Duldung.

Vor wenig Tagen traf ich einen jungen V. an, einen offnen Jungen, mit einer
gar glücklichen Gesichtsbildung. Er kommt erst von Akademien dünkt sich eben
nicht weise, aber glaubt doch, er wisse mehr als andere. Auch war er fleissig,
wie ich an allerlei spüre, kurz, er hat hübsche Kenntnisse. Da er hörte, dass
ich viel zeichnete und Griechisch könnte (zwei Meteore hierzulande), wandte er
sich an mich und kramte viel Wissens aus, von Batteux bis zu Wood, von de Piles
zu Winckelmann, und versicherte mich, er habe Sulzers Theorie, den ersten
Teil, ganz durchgelesen und besitze ein Manuskript von Heynen über das Studium
der Antike. Ich liess das gut sein.

Noch gar einen braven Mann habe ich kennen lernen, den fürstlichen Amtmann,
einen offenen, treuherzigen Menschen. Man sagt, es soll eine Seelenfreude sein,
ihn unter seinen Kindern zu sehen, deren er neun hat; besonders macht man viel
Wesens von seiner ältesten Tochter. Er hat mich zu sich gebeten, und ich will ihn
ehster Tage besuchen. Er wohnt auf einem fürstlichen Jagdhofe, anderthalb Stunden
von hier, wohin er nach dem Tode seiner Frau zu ziehen die Erlaubnis erhielt,
da ihm der Aufenthalt hier in der Stadt und im Amthause zu weh tat.

Sonst sind mir einige verzerrte Originale in den Weg gelaufen, an denen alles
unausstehlich ist, am unerträglichsten Freundschaftsbezeigungen.

Leb' wohl! Der Brief wird dir recht sein, er ist ganz historisch.

Am 22. Mai

Dass das Leben des Menschen nur ein Traum sei, ist manchem schon so
vorgekommen, und auch mit mir zieht dieses Gefühl immer herum. Wenn ich die
Einschränkung ansehe, in welcher die tätigen und forschenden Kräfte des Menschen
eingesperrt sind; wenn ich sehe, wie alle Wirksamkeit dahinaus läuft, sich die
Befriedigung von Bedürfnissen zu verschaffen, die wieder keinen Zweck haben, als unsere
arme Existenz zu verlängern, und dann, dass alle Beruhigung über gewisse Punkte
des Nachforschens nur eine träumende Regignation ist, da man sich die Wände,
zwischen denen man gefangen sitzt, mit bunten Gestalten und lichten Aussichten
bemalt—das alles, Wilhelm, macht mich stumm. Ich kehre in mich selbst zurück, und
finde eine Welt! Wieder mehr in Ahnung und dunkler Begier als in Darstellung und
lebendiger Kraft. Und da schwimmt alles vor meinen Sinnen, und ich lächle dann so
träumend weiter in die Welt.

Dass die Kinder nicht wissen, warum sie wollen, darin sind alle hochgelahrten
Schul—und Hofmeister einig; dass aber auch Erwachsene gleich Kindern auf diesem
Erdboden herumtaumeln und wie jene nicht wissen, woher sie kommen und wohin sie
gehen, ebensowenig nach wahren Zwecken handeln, ebenso durch Biskuit und Kuchen
und Birkenreiser regiert werden: das will niemand gern glauben, und mich
dünkt, man kann es mit Händen greifen.

Ich gestehe dir gern, denn ich weiss, was du mir hierauf sagen möchtest, dass
diejenigen die Glücklichsten sind, die gleich den Kindern in den Tag hinein leben,
ihre Puppen herumschleppen, aus—und anziehen und mit grossem Respekt um die
Schublade umherschleichen, wo Mama das Zuckerbrot hineingeschlossen hat, und, wenn
sie das gewünschte endlich erhaschen, es mit vollen Backen verzehren und
rufen:"mehr!"—das sind glückliche Geschöpfe. Auch denen ist's wohl, die ihren
Lumpenbeschäftigungen oder wohl gar ihren Leidenschaften prächtige Titel geben und sie dem
Menschengeschlechte als Riesenoperationen zu dessen Heil und Wohlfahrt anschreiben.—Wohl dem,
der so sein kann! Wer aber in seiner Demut erkennt, wo das alles hinausläuft,
wer da sieht, wie artig jeder Bürger, dem es wohl ist, sein Gärtchen zum
Paradiese zuzustutzen weiss, und wie unverdrossen auch der Unglückliche unter der
Bürde seinen Weg fortkeucht, und alle gleich interessiert sind, das Licht dieser
Sonne noch eine Minute länger zu sehn—ja, der ist still und bildet auch seine
Welt aus sich selbst und ist auch glücklich, weil er ein Mensch ist. Und dann,
so eingeschränkt er ist, hält er doch immer im Herzen das süsse Gefühl der
Freiheit, und dass er diesen Kerker verlassen kann, wann er will.

Am 26. Mai

Du kennst von alters her meine Art, mich anzubauen, mir irgend an einem
vertraulichen Orte ein Hüttchen aufzuschlagen und da mit aller Einschränkung zu
herbergen. Auch hier habe ich wieder ein Plätzchen angetroffen, das mich angezogen
hat.

Ungefähr eine Stunde von der Stadt liegt ein Ort, den sie Wahlheim nennen. Die Lage
an einem Hügel ist sehr interessant, und wenn man oben auf dem Fusspfade zum
Dorf herausgeht, übersieht man auf einmal das ganze Tal. Eine gute Wirtin, die
gefällig und munter in ihrem Alter ist, schenkt Wein, Bier, Kaffee; und was über
alles geht, sind zwei Linden, die mit ihren ausgebreiteten Ästen den kleinen
Platz vor der Kirche bedecken, der ringsum mit Bauerhäusern, Scheunen und Höfen
eingeschlossen ist. So vertraulich, so heimlich hab' ich nicht leicht ein Plätzchen
gefunden, und dahin lass' ich mein Tischchen aus dem Wirtshause bringen und meinen
Stuhl, trinke meinen Kaffee da und lese meinen Homer. Das erstenmal, als ich
durch einen Zufall an einem schönen Nachmittage unter die Linden kam, fand ich
das Plätzchen so einsam. Es war alles im Felde; nur ein Knabe von ungefähr
vier Jahren sass an der Erde und hielt ein anderes, etwa halbjähriges, vor ihm
zwischen seinen Füssen sitzendes Kind mit beiden Armen wider seine Brust, so dass er
ihm zu einer Art von Sessel diente und ungeachtet der Munterkeit, womit er aus
seinen schwarzen Augen herumschaute, ganz ruhig sass. Mich vergnügte der Anblick:
ich setzte mich auf einen Pflug, der gegenüber stand, und zeichnete die
brüderliche Stellung mit vielem Ergetzen. Ich fügte den nächsten Zaun, ein Scheunentor
und einige gebrochene Wagenräder bei, alles, wie es hinter einander stand, und
fand nach Verlauf einer Stunde, dass ich eine wohlgeordnete, sehr interessante
Zeichnung verfertigt hatte, ohne das mindeste von dem Meinen hinzuzutun. Das
bestärkte mich in meinem Vorsatze, mich künftig allein an die Natur zu halten. Sie
allein ist unendlich reich, und sie allein bildet den grossen Künstler. Man kann
zum Vorteile der Regeln viel sagen, ungefähr was man zum Lobe der bürgerlichen
Gesellschaft sagen kann. Ein Mensch, der sich nach ihnen bildet, wird nie etwas
Abgeschmacktes und Schlechtes hervorbringen, wie einer, der sich durch Gesetze und
Wohlstand modeln lässt, nie ein unerträglicher Nachbar, nie ein merkwürdiger
Bösewicht werden kann; dagegen wird aber auch alle Regel, man rede was man wolle,
das wahre Gefühl von Natur und den wahren Ausdruck derselben zerstören! Sag'
du: 'das ist zu hart! Sie schränkt nur ein, beschneidet die geilen Reben'
etc.—guter Freund, soll ich dir ein Gleichnis geben? Es ist damit wie mit der Liebe.
Ein junges Herz hängt ganz an einem Mädchen, bringt alle Stunden seines Tages
bei ihr zu, verschwendet alle seine Kräfte, all sein Vermögen, um ihr jeden
Augenblick auszudrücken, dass er sich ganz ihr hingibt. Und da käme ein Philister, ein
Mann, der in einem öffentlichen Amte steht, und sagte zu ihm: 'feiner junger
Herr! Lieben ist menschlich, nur müsst Ihr menschlich lieben! Teilet Eure Stunden
ein, die einen zur Arbeit, und die Erholungsstunden widmet Eurem Mädchen.
Berechnet Euer Vermögen, und was Euch von Eurer Notdurft übrig bleibt, davon
verwehr' ich Euch nicht, ihr ein Geschenk, nur nicht zu oft, zu machen, etwa zu
ihrem Geburts—und Namenstage ' etc.—folgt der Mensch, so gibt's einen
brauchbaren jungen Menschen, und ich will selbst jedem Fürsten raten, ihn in ein
Kollegium zu setzen; nur mit seiner Liebe ist's am Ende und, wenn er ein Künstler
ist, mit seiner Kunst. O meine Freunde! Warum der Strom des Genies so selten
ausbricht, so selten in hohen Fluten hereinbraust und eure staunende Seele
erschüttert?—liebe Freunde, da wohnen die gelassenen Herren auf beiden Seiten des Ufers,
denen ihre Gartenhäuschen, Tulpenbeete und Krautfelder zugrunde gehen würden,
die daher in Zeiten mit Dämmen und Ableiten der künftig drohenden Gefahr
abzuwehren wissen.

Am 27. Mai

Ich bin, wie ich sehe, in Verzückung, Gleichnisse und Deklamation verfallen
und habe darüber vergessen, dir auszuerzählen, was mit den Kindern weiter
geworden ist. Ich sass, ganz in malerische Empfindung vertieft, die dir mein
gestriges Blatt sehr zerstückt darlegt, auf meinem Pfluge wohl zwei Stunden. Da
kommt gegen Abend eine junge Frau auf die Kinder los, die sich indes nicht
gerührt hatten, mit einem Körbchen am Arm und ruft von weitem: "Philipps, du bist
recht brav". —Sie grüsste mich, ich dankte ihr, stand auf, trat näher hin und
fragte sie, ob sie Mutter von den Kindern wäre? Sie bejahte es, und indem sie dem
ältesten einen halben Weck gab, nahm sie das kleine auf und küsste es mit aller
mütterlichen Liebe.—"ich habe", sagte sie, "meinem Philipps das Kleine zu halten
gegeben und bin mit meinem Ältesten in die Stadt gegangen, um weiss Brot zu holen
und Zucker und ein irden Breipfännchen".—Ich sah das alles in dem Korbe,
dessen Deckel abgefallen war.—"Ich will meinem Hans (das war der Name des
Jüngsten) ein Süppchen kochen zum Abende; der lose Vogel, der Grosse, hat mir gestern
das Pfännchen zerbrochen, als er sich mit Philippsen um die Scharre des Breis
zankte".—ich fragte nach dem Ältesten, und sie hatte mir kaum gesagt, dass er sich auf
der Wiese mit ein paar Gänsen herumjage, als er gesprungen kam und dem Zweiten
eine Haselgerte mitbrachte. Ich unterhielt mich weiter mit dem Weibe und
erfuhr, dass sie des Schulmeisters Tochter sei, und dass ihr Mann eine Reise in die
Schweiz gemacht habe, um die Erbschaft eines Vetters zu holen.—"Sie haben ihn drum
betriegen wollen", sagte sie,"und ihm auf seine Briefe nicht geantwortet; da ist er
selbst hineingegangen. Wenn ihm nur kein Unglück widerfahren ist, ich höre nichts
von ihm".—Es ward mir schwer, mich von dem Weibe los zu machen, gab jedem der
Kinder einen Kreuzer, und auch fürs jüngste gab ich ihr einen, ihm einen Weck zur
Suppe mitzubringen, wenn sie in die Stadt ginge, und so schieden wir von
einander.

Ich sage dir, mein Schatz, wenn meine Sinne gar nicht mehr halten wollen, so
lindert all den Tumult der Anblick eines solchen Geschöpfs, das in glücklicher
Gelassenheit den engen Kreis seines Daseins hingeht, von einem Tage zum andern sich
durchhilft, die Blätter abfallen sieht und nichts dabei denkt, als dass der Winter
kommt.

Seit der Zeit bin ich oft draussen. Die Kinder sind ganz an mich gewöhnt, sie
kriegen Zucker, wenn ich Kaffee trinke, und teilen das Butterbrot und die saure
Milch mit mir des Abends. Sonntags fehlt ihnen der Kreuzer nie, und wenn ich
nicht nach der Betstunde da bin, so hat die Wirtin Ordre, ihn auszuzahlen.

Sie sind vertraut, erzählen mir allerhand, und besonders ergetze ich mich an
ihren Leidenschaften und simpeln Ausbrüchen des Begehrens, wenn mehr Kinder aus
dem Dorfe sich versammeln.

Viele Mühe hat mich's gekostet, der Mutter ihre Besorgnis zu nehmen, sie möchten
den Herrn inkommodieren.

Am 30. Mai

Was ich dir neulich von der Malerei sagte, gilt gewiss auch von der Dichtkunst;
es ist nur, dass man das Vortreffliche erkenne und es auszusprechen wage, und
das ist freilich mit wenigem viel gesagt. Ich habe heute eine Szene gehabt,
die, rein abgeschrieben, die schönste Idylle von der Welt gäbe; doch was soll
Dichtung, Szene und Idylle? Muss es denn immer gebosselt sein, wenn wir teil an einer
Naturerscheinung nehmen sollen?

Wenn du auf diesen Eingang viel Hohes und Vornehmes erwartest, so bist du
wieder übel betrogen; es ist nichts als ein Bauerbursch, der mich zu dieser
lebhaften Teilnehmung hingerissen hat. Ich werde, wie gewöhnlich, schlecht erzählen,
und du wirst mich, wie gewöhnlich, denk' ich, übertrieben finden; es ist
wieder Wahlheim, und immer Wahlheim, das diese Seltenheiten hervorbringt.

Es war eine Gesellschaft draussen unter den Linden, Kaffee zu trinken. Weil
sie mir nicht ganz anstand, so blieb ich unter einem Vorwande zurück.

Ein Bauerbursch kam aus einem benachbarten Hause und beschäftigte sich, an dem
Pfluge, den ich neulich gezeichnet hatte, etwas zurecht zu machen. Da mir sein
Wesen gefiel, redete ich ihn an, fragte nach seinen Umständen, wir waren bald
bekannt und, wie mir's gewöhnlich mit dieser Art Leuten geht, bald vertraut. Er
erzählte mir, dass er bei einer Witwe in Diensten sei und von ihr gar wohl gehalten
werde. Er sprach so vieles von ihr und lobte sie dergestalt, dass ich bald merken
konnte, er sei ihr mit Leib und Seele zugetan. Sie sei nicht mehr jung, sagte er,
sie sei von ihrem ersten Mann übel gehalten worden, wolle nicht mehr heiraten,
und aus seiner Erzählung leuchtete so merklich hervor, wie schön, wie reizend
sie für ihn sei, wie sehr er wünschte, dass sie ihn wählen möchte, um das
Andenken der Fehler ihres ersten Mannes auszulöschen, dass ich Wort für Wort
wiederholen müsste, um dir die reine Neigung, die Liebe und Treue dieses Menschen
anschaulich zu machen. Ja, ich müsste die Gabe des grössten Dichters besitzen, um dir
zugleich den Ausdruck seiner Gebärden, die Harmonie seiner Stimme, das heimliche
Feuer seiner Blicke lebendig darstellen zu können. Nein, es sprechen keine Worte
die Zartheit aus, die in seinem ganzen Wesen und Ausdruck war; es ist alles
nur plump, was ich wieder vorbringen könnte. Besonders rührte mich, wie er
fürchtete, ich möchte über sein Verhältnis zu ihr ungleich denken und an ihrer guten
Aufführung zweifeln. Wie reizend es war, wenn er von ihrer Gestalt, von ihrem Körper
sprach, der ihn ohne jugendliche Reize gewaltsam an sich zog und fesselte, kann
ich mir nur in meiner innersten Seele wiederholen. Ich hab' in meinem Leben
die dringende Begierde und das heisse, sehnliche Verlangen nicht in dieser
Reinheit gesehen, ja wohl kann ich sagen, in dieser Reinheit nicht gedacht und
geträumt. Schelte mich nicht, wenn ich dir sage, dass bei der Erinnerung dieser
Unschuld und Wahrheit mir die innerste Seele glüht, und dass mich das Bild dieser
Treue und Zärtlichkeit überall verfolgt, und dass ich, wie selbst davon
entzündet, lechze und schmachte.

Ich will nun suchen, auch sie ehstens zu sehn, oder vielmehr, wenn ich's recht
bedenke, ich will's vermeiden. Es ist besser, ich sehe sie durch die Augen ihres
Liebhabers; vielleicht erscheint sie mir vor meinen eigenen Augen nicht so, wie sie
jetzt vor mir steht, und warum soll ich mir das schöne Bild verderben?

Am 16. Junius

Warum ich dir nicht schreibe?—Fragst du das und bist doch auch der Gelehrten
einer. Du solltest raten, dass ich mich wohl befinde, und zwar—kurz und gut, ich
habe eine Bekanntschaft gemacht, die mein Herz näher angeht. Ich habe—ich weiss
nicht.

Dir in der Ordnung zu erzählen, wie's zugegangen ist, dass ich eins der
liebenswürdigsten Geschöpfe habe kennen lernen, wird schwer halten. Ich bin vergnügt und
glücklich, und also kein guter Historienschreiber.

Einen Engel!—pfui! Das sagt jeder von der Seinigen, nicht wahr? Und doch bin ich
nicht imstande, dir zu sagen, wie sie vollkommen ist, warum sie vollkommen ist;
genug, sie hat allen meinen Sinn gefangengenommen.

So viel Einfalt bei so viel Verstand, so viel Güte bei so viel Festigkeit,
und die Ruhe der Seele bei dem wahren Leben und der Tätigkeit.—Das ist alles
garstiges Gewäsch, was ich da von ihr sage, leidige Abstraktionen, die nicht einen
Zug ihres Selbst ausdrücken. Ein andermal—nein, nicht ein andermal, jetzt
gleich will ich dir's erzählen. Tu' ich 's jetzt nicht, so geschäh' es niemals.
Denn, unter uns, seit ich angefangen habe zu schreiben, war ich schon dreimal im
Begriffe, die Feder niederzulegen, mein Pferd satteln zu lassen und hinauszureiten.
Und doch schwur ich mir heute früh, nicht hinauszureiten, und gehe doch alle
Augenblick' ans Fenster, zu sehen, wie hoch die Sonne noch steht.—Ich hab's nicht
überwinden können, ich musste zu ihr hinaus. Da bin ich wieder, Wilhelm, will mein
Butterbrot zu Nacht essen und dir schreiben. Welch eine Wonne das für meine Seele
ist, sie in dem Kreise der lieben, muntern Kinder, ihrer acht Geschwister, zu
sehen!—Wenn ich so fortfahre, wirst du am Ende so klug sein wie am Anfange. Höre denn,
ich will mich zwingen, ins Detail zu gehen.

Ich schrieb dir neulich, wie ich den Amtmann S. habe kennen lernen, und wie er
mich gebeten habe, ihn bald in seiner Einsiedelei oder vielmehr seinem kleinen
Königreiche zu besuchen. Ich vernachlässigte das, und wäre vielleicht nie hingekommen,
hätte mir der Zufall nicht den Schatz entdeckt, der in der stillen Gegend
verborgen liegt.

Unsere jungen Leute hatten einen Ball auf dem Lande angestellt, zu dem ich mich
denn auch willig finden liess. Ich bot einem hiesigen guten, schönen, übrigens
unbedeutenden Mädchen die Hand, und es wurde ausgemacht, dass ich eine Kutsche nehmen,
mit meiner Tänzerin und ihrer Base nach dem Orte der Lustbarkeit hinausfahren
und auf dem Wege Charlotten S. mitnehmen sollte.—"Sie werden ein schönes
Frauenzimmer kennenlernen", sagte meine Gesellschafterin, da wir durch den weiten,
ausgehauenen Wald nach dem Jagdhause fuhren.—"Nehmen Sie sich in acht", versetzte die
Base, "dass Sie sich nicht verlieben!"—"Wieso?" sagte ich.—"Sie ist schon
vergeben,"antwortete jene,"an einen sehr braven Mann, der weggereist ist, seine Sachen in
Ordnung zu bringen, weil sein Vater gestorben ist, und sich um eine ansehnliche
Versorgung zu bewerben".—Die Nachricht war mir ziemlich gleichgültig.

Die Sonne war noch eine Viertelstunde vom Gebirge, als wir vor dem Hoftore
anfuhren. Es war sehr schwül, und die Frauenzimmer äusserten ihre Besorgnis wegen
eines Gewitters, das sich in weissgrauen, dumpfichten Wölkchen rings am Horizonte
zusammenzuziehen schien. Ich täuschte ihre Furcht mit anmasslicher Wetterkunde, ob mir
gleich selbst zu ahnen anfing, unsere Lustbarkeit werde einen Stoss leiden.

Ich war ausgestiegen, und eine Magd, die ans Tor kam, bat uns, einen
Augenblick zu verziehen, Mamsell Lottchen würde gleich kommen. Ich ging durch den Hof
nach dem wohlgebauten Hause, und da ich die vorliegenden Treppen
hinaufgestiegen war und in die Tür trat, fiel mir das reizendste Schauspiel in die Augen,
das ich je gesehen habe. in dem Vorsaale wimmelten sechs Kinder von eilf zu
zwei Jahren um ein Mädchen von schöner Gestalt, mittlerer Grösse, die ein
simples weisses Kleid, mit blassroten Schleifen an Arm und Brust, anhatte. Sie hielt
ein schwarzes Brot und schnitt ihren Kleinen rings herum jedem sein Stück nach
Proportion ihres Alters und Appetits ab, gab's jedem mit solcher Freundlichkeit, und
jedes rief so ungekünstelt sein "danke!", indem es mit den kleinen Händchen
lange in die Höhe gereicht hatte, ehe es noch abgeschnitten war, und nun mit
seinem Abendbrote vergnügt entweder wegsprang, oder nach seinem stillern
Charakter gelassen davonging nach dem Hoftore zu, um die Fremden und die Kutsche zu
sehen, darin ihre Lotte wegfahren sollte.—"Ich bitte um Vergebung", sagte sie,
"dass ich Sie hereinbemühe und die Frauenzimmer warten lasse. Über dem Anziehen
und allerlei Bestellungen fürs Haus in meiner Abwesenheit habe ich vergessen,
meinen Kindern ihr Vesperbrot zu geben, und sie wollen von niemanden Brot
geschnitten haben als von mir".

Ich machte ihr ein unbedeutendes Kompliment, meine ganze Seele ruhte auf der
Gestalt, dem Tone, dem Betragen, und ich hatte eben Zeit, mich von der Überraschung
zu erholen, als sie in die Stube lief, ihre Handschuhe und den Fächer zu
holen. Die Kleinen sahen mich in einiger Entfernung so von der Seite an, und ich
ging auf das jüngste los, das ein Kind von der glücklichsten Gesichtsbildung
war. Es zog sich zurück, als eben Lotte zur Türe herauskam und sagte:"Louis,
gib dem Herrn Vetter eine Hand".—das tat der Knabe sehr freimütig, und ich
konnte mich nicht enthalten, ihn, ungeachtet seines kleinen Rotznäschens,
herzlich zu küssen.

"Vetter?" sagte ich, indem ich ihr die Hand reichte," glauben Sie, dass ich des
Glücks wert sei, mit Ihnen verwandt zu sein?"—"O", sagte sie mit einem
leichtfertigen Lächeln, "unsere Vetterschaft ist sehr weitläufig, und es wäre mir leid,
wenn Sie der schlimmste drunter sein sollten".—Im Gehen gab sie Sophien, der
ältesten Schwester nach ihr, einem Mädchen von ungefähr elf Jahren, den Auftrag,
wohl auf die Kinder acht zu haben und den Papa zu grüssen, wenn er vom
Spazierritte nach Hause käme. Den Kleinen sagte sie, sie sollten ihrer Schwester Sophie
folgen, als wenn sie's selber wäre, das denn auch einige ausdrücklich versprachen.
Eine kleine, naseweise Blondine aber, von ungefähr sechs Jahren, sagte: "du
bist's doch nicht, Lottchen, wir haben dich doch lieber".—die zwei ältesten
Knaben waren hinten auf die Kutsche geklettert, und auf mein Vorbitten erlaubte
sie ihnen, bis vor den Wald mitzufahren, wenn sie versprächen, sich nicht zu
necken und sich recht festzuhalten.

Wir hatten uns kaum zurecht gesetzt, die Frauenzimmer sich bewillkommt,
wechselsweise über den Anzug, vorzüglich über die Hüte ihre Anmerkungen gemacht und die
Gesellschaft, die man erwartete, gehörig durchgezogen, als Lotte den Kutscher halten und
ihre Brüder herabsteigen liess, die noch einmal ihre Hand zu küssen begehrten,
das denn der älteste mit aller Zärtlichkeit, die dem Alter von fünfzehn Jahren
eigen sein kann, der andere mit viel Heftigkeit und Leichtsinn tat. Sie liess die
Kleinen noch einmal grüssen, und wir fuhren weiter.

Die Base fragte, ob sie mit dem Buche fertig wäre, das sie ihr neulich
geschickt hätte.—"nein", sagte Lotte,"es gefällt mir nicht, Sie können's
wiederhaben. Das vorige war auch nicht besser".—Ich erstaunte, als ich fragte, was es
für Bücher wären, und sie mir antwortete:—ich fand so viel Charakter in allem,
was sie sagte, ich sah mit jedem Wort neue Reize, neue Strahlen des Geistes
aus ihren Gesichtszügen hervorbrechen, die sich nach und nach vergnügt zu
entfalten schienen, weil sie an mir fühlte, dass ich sie verstand.

"Wie ich jünger war", sagte sie, "liebte ich nichts so sehr als Romane. Weiss
Gott, wie wohl mir's war, wenn ich mich Sonntags in so ein Eckchen setzen und
mit ganzem Herzen an dem Glück und Unstern einer Miss Jonny teilnehmen konnte.
Ich leugne auch nicht, dass die Art noch einige Reize für mich hat. Doch da ich
so selten an ein Buch komme, so muss es auch recht nach meinem Geschmack sein.
Und der Autor ist mir der liebste, in dem ich meine Welt wiederfinde, bei dem
es zugeht wie um mich, und dessen Geschichte mir doch so interessant und
herzlich wird als mein eigen häuslich Leben, das freilich kein Paradies, aber doch
im ganzen eine Quelle unsäglicher Glückseligkeit ist".

Ich bemühte mich, meine Bewegungen über diese Worte zu verbergen. Das ging
freilich nicht weit: denn da ich sie mit solcher Wahrheit im Vorbeigehen vom
Landpriester von Wakefield, vom—reden hörte, kam ich ganz ausser mich, sagte ihr alles,
was ich musste, und bemerkte erst nach einiger Zeit, da Lotte das Gespräch an
die anderen wendete, dass diese die Zeit über mit offenen Augen, als sässen sie
nicht da, dagesessen hatten. Die Base sah mich mehr als einmal mit einem
spöttischen Näschen an, daran mir aber nichts gelegen war.

Das Gespräch fiel aufs Vergnügen am Tanze.—"wenn diese Leidenschaft ein Fehler
ist,"sagte Lotte, "so gestehe ich Ihnen gern, ich weiss mir nichts übers Tanzen. Und
wenn ich was im Kopfe habe und mir auf meinem verstimmten Klavier einen
Contretanz vortrommle, so ist alles wieder gut".

Wie ich mich unter dem Gespäche in den schwarzen Augen weidete—wie die
lebendigen Lippen und die frischen, muntern Wangen meine ganze Seele anzogen—wie ich,
in den herrlichen Sinn ihrer Rede ganz versunken, oft gar die Worte nicht
hörte, mit denen sie sich ausdrückte—davon hast du eine Vorstellung, weil du mich
kennst. Kurz, ich stieg aus dem Wagen wie ein Träumender, als wir vor dem
Lusthause stille hielten, und war so in Träumen rings in der dämmernden Welt
verloren, dass ich auf die Musik kaum achtete, die uns von dem erleuchteten Saal
herunter entgegenschallte.

Die zwei Herren Audran und ein gewisser N. N.—wer behält alle die
Namen—, die der Base und Lottens Tänzer waren, empfingen uns am
Schlage, bemächtigten sich ihrer Frauenzimmer, und ich führte das
meinige hinauf.

Wir schlangen uns in Menuetts um einander herum; ich forderte ein Frauenzimmer
nach dem andern auf, und just die unleidlichsten konnten nicht dazu kommen,
einem die Hand zu reichen und ein Ende zu machen. Lotte und ihr Tänzer fingen
einen Englischen an, und wie wohl mir's war, als sie auch in der Reihe die Figur
mit uns anfing, magst du fühlen. Tanzen muss man sie sehen! Siehst du, sie ist
so mit ganzem Herzen und mit ganzer Seele dabei, ihr ganzer Körper eine
Harmonie, so sorglos, so unbefangen, als wenn das eigentlich alles wäre, als wenn
sie sonst nichts dächte, nichts empfände; und in dem Augenblicke gewiss
schwindet alles andere vor ihr.

Ich bat sie um den zweiten Contretanz; sie sagte mit den dritten zu, und mit
der liebenswürdigsten Freimütigkeit von der Welt versicherte sie mir, dass sie
herzlich gern deutsch tanze.—"Es ist hier so Mode, "fuhr sie fort," dass jedes Paar,
das zusammen gehört, beim Deutschen zusammenbleibt, und mein Chapeau walzt
schlecht und dankt mir's, wenn ich ihm die Arbeit erlasse. Ihr Frauenzimmer kann's
auch nicht und mag nicht, und ich habe im Englischen gesehen, dass Sie gut
walzen; wenn Sie nun mein sein wollen fürs Deutsche, so gehen Sie und bitten
sich's von meinem Herrn aus, und ich will zu Ihrer Dame gehen".—ich gab ihr die
Hand darauf, und wir machten aus, dass ihr Tänzer inzwischen meine Tänzerin
unterhalten sollte.

Nun ging's an, und wir ergetzten uns eine Weile an manigfaltigen Schlingungen
der Arme. Mit welchem Reize, mit welcher Flüchtigkeit bewegte sie sich! Und da
wir nun gar ans Walzen kamen und wie die Sphären um einander herumrollten,
ging's freilich anfangs, weil's die wenigsten können, ein bisschen bunt
durcheinander. Wir waren klug und liessen sie austoben, und als die Ungeschicktesten den
Plan geräumt hatten, fielen wir ein und hielten mit noch einem Paare, mit
Audran und seiner Tänzerin, wacker aus. Nie ist mir's so leicht vom Flecke
gegangen. Ich war kein Mensch mehr. Das liebenswürdigste Geschöpf in den Armen zu
haben und mit ihr herumzufliegen wie Wetter, dass alles rings umher verging,
und—Wilhelm, um ehrlich zu sein, tat ich aber doch den Schwur, dass ein Mädchen, das ich
liebte, auf das ich Ansprüche hätte, mir nie mit einem andern walzen sollte als
mit mir, und wenn ich drüber zugrunde gehen müsste. Du verstehst mich!

Wir machten einige Touren gehend im Saale, um zu verschnaufen. Dann setzte sie
sich, und die Orangen, die ich beiseite gebracht hatte, die nun die einzigen
noch übrigen waren, taten vortreffliche Wirkung, nur dass mir mit jedem
Schnittchen, das sie einer unbescheidenen Nachbarin ehrenhalben zuteilte, ein Stich
durchs Herz ging.

Beim dritten englischen Tanz waren wir das zweite Paar. Wie wir die Reihe
durchtanzten und ich, weiss Gott mit wieviel Wonne, an ihrem Arm und Auge hing, das voll
vom wahrsten Ausdruck des offensten, reinsten Vergnügens war, kommen wir an
eine Frau, die mir wegen ihrer liebenswürdigen Miene auf einem nicht mehr ganz
jungen Gesichte merkwürdig gewesen war. Sie sieht Lotten lächelnd an, hebt einen
drohenden Finger auf und nennt den Namen Albert zweimal im Vorbeifliegen mit viel
Bedeutung.

"Wer ist Albert?" sagte ich zu Lotten, "wenn's nicht Vermessenheit ist zu
fragen".—Sie war im Begriff zu antworten, als wir uns scheiden mussten, um die grosse
Achte zu machen, und mich dünkte einiges Nachdenken auf ihrer Stirn zu sehen,
als wir so vor einander vorbeikreuzten.—"Was soll ich's Ihnen leugnen," sagte
sie, indem sie mir die Hand zur Promenade bot. "Albert ist ein braver Mensch,
dem ich so gut als verlobt bin".—nun war mir das nichts Neues (denn die
Mädchen hatten mir's auf dem Wege gesagt) und war mir doch so ganz neu, weil ich
es noch nicht im Verhältnis auf sie, die mir in so wenig Augenblicken so wert
geworden war, gedacht hatte. Genug, ich verwirrte mich, vergass mich und kam
zwischen das unrechte Paar hinein, dass alles drunter und drüber ging und Lottens
ganze Gegenwart und Zerren und Ziehen nötig war, um es schnell wieder in Ordnung
zu bringen.

Der Tanz war noch nicht zu Ende, als die Blitze, die wir schon lange am
Horizonte leuchten gesehn und die ich immer für Wetterkühlen ausgegeben hatte, viel
stärker zu werden anfingen und der Donner die Musik überstimmte. Drei Frauenzimmer
liefen aus der Reihe, denen ihre Herren folgten; die Unordnung wurde allgemein,
und die Musik hörte auf. Es ist natürlich, wenn uns ein Unglück oder etwas
Schreckliches im Vergnügen überrascht, dass es stärkere Eindrücke auf uns macht als
sonst, teils wegen des Gegensatzes, der sich so lebhaft empfinden lässt, teils und
noch mehr, weil unsere Sinne einmal der Fühlbarkeit geöffnet sind und also
desto schneller einen Eindruck annehmen. Diesen Ursachen muss ich die wunderbaren
Grimassen zuschreiben, in die ich mehrere Frauenzimmer ausbrechen sah. Die klügste
setzte sich in eine Ecke, mit dem Rücken gegen das Fenster, und hielt die Ohren
zu. Eine andere kniete vor ihr nieder und verbarg den Kopf in der erster
Schoss. Eine dritte schob sich zwischen beide hinein und umfasste ihre
Schwesterchen mit tausend Tränen. Einige wollten nach Hause; andere, die noch weniger
wussten, was sie taten, hatten nicht so viel Besinnungskraft, den Keckheiten
unserer jungen Schlucker zu steuern, die sehr beschäftigt zu sein schienen, alle
die ängstlichen Gebete, die dem Himmel bestimmt waren, von den Lippen der
schönen Bedrängten wegzufangen. Einige unserer Herren hatten sich hinabbegeben, um
ein Pfeifchen in Ruhe zu rauchen; und die übrige Gesellschaft schlug es nicht
aus, als die Wirtin auf den klugen Einfall kam, uns ein Zimmer anzuweisen, das
Läden und Vorhänge hätte. Kaum waren wir da angelangt, als Lotte beschäftigt
war, einen Kreis von Stühlen zu stellen und, als sich die Gesellschaft auf ihre
Bitte gesetzt hatte, den Vortrag zu einem Spiele zu tun.

Ich sah manchen, der in Hoffnung auf ein saftiges Pfand sein Mäulchen spitzte
und seine Glieder reckte.—"Wir spielen Zählens!" sagte sie. "Nun gebt acht!
Ich geh' im Kreise herum von der Rechten zur Linken, und so zählt ihr auch
rings herum, jeder die Zahl, die an ihn kommt, und das muss gehen wie ein
Lauffeuer, und wer stockt oder sich irrt, kriegt eine Ohrfeige, und so bis
tausend".—nun war das lustig anzusehen: sie ging mit ausgestrecktem Arm im Kreise herum.
"Eins", fing der erste an, der Nachbar "zwei", "drei" der folgende, und so fort.
Dann fing sie an, geschwinder zu gehen, immer geschwinder; da versah's einer:
Patsch! Eine Ohrfeige, und über das Gelächter der folgende auch: Patsch! Und immer
geschwinder. Ich selbst kriegte zwei Maulschellen und glaubte mit innigem Vergnügen zu
bemerken, dass sie stärker seien, als sie den übrigen zuzumessen pflegte. Ein
allgemeines Gelächter und Geschwärm endigte das Spiel, ehe noch das Tausend ausgezählt
war. Die Vertrautesten zogen einander beiseite, das Gewitter war vorüber, und
ich folgte Lotten in den Saal. Unterwegs sagte sie:"über die Ohrfeigen haben
sie Wetter und alles vergessen!"—ich konnte ihr nichts antworten.—"ich war",
fuhr sie fort, "eine der Furchtsamsten, und indem ich mich herzhaft stellte, um
den andern Mut zu geben, bin ich mutig geworden".—Wir traten ans Fenster. Es
donnerte abseitwärts, und der herrliche Regen säuselte auf das Land, und der
erquickendste Wohlgeruch stieg in aller Fülle einer warmen Luft zu uns auf. Sie stand
auf ihren Ellenbogen gestützt, ihr Blick durchdrang die Gegend; sie sah gen
Himmel und auf mich, ich sah ihr Auge tränenvoll, sie legte ihre Hand auf die
meinige und sagte: "Klopstock!"—Ich erinnerte mich sogleich der herrlichen Ode,
die ihr in Gedanken lag, und versank in dem Strome von Empfindungen, den sie
in dieser Losung über mich ausgoss. Ich ertrug's nicht, neigte mich auf ihre
Hand und küsste sie unter den wonnevollsten Tränen. Und sah nach ihrem Auge
wieder—Edler! Hättest du deine Vergötterung in diesem Blicke gesehen, und möcht' ich nun
deinen so oft entweihten Namen nie wieder nennen hören!

Am 19. Junius

Wo ich neulich mit meiner Erzählung geblieben bin, weiss ich nicht mehr; das
weiss ich, dass es zwei Uhr des Nachts war, als ich zu Bette kam, und dass, wenn
ich dir hätte vorschwatzen können, statt zu schreiben, ich dich vielleicht bis
an den Morgen aufgehalten hätte.

Was auf unserer Hereinfahrt vom Balle geschehen ist, habe ich noch nicht
erzählt, habe auch heute keinen Tag dazu.

Es war der herrlichste Sonnenaufgang. Der tröpfelnde Wald und das erfrischte
Feld umher! Unsere Gesellschafterinnen nickten ein. Sie fragte mich, ob ich
nicht auch von der Partie sein wollte; ihretwegen sollt' ich unbekümmert
sein.—"So lange ich diese Augen offen sehe", sagte ich und sah sie fest an,"so lange
hat's keine Gefahr".—Und wir haben beide ausgehalten bis an ihr Tor, da ihr die
Magd leise aufmachte und auf ihr Fragen versicherte, dass Vater und Kleine wohl
seien und alle noch schliefen. Da verliess ich sie mit der Bitte, sie selbigen
Tags noch sehen zu dürfen; sie gestand mir's zu, und ich bin gekommen—und seit
der Zeit können Sonne, Mond und Sterne geruhig ihre Wirtschaft treiben, ich
weiss weder dass Tag noch dass Nacht ist, und die ganze Welt verliert sich um mich
her.

Am 21. Junius

Ich lebe so glückliche Tage, wie sie Gott seinen Heiligen ausspart; und mit
mir mag werden was will, so darf ich nicht sagen, dass ich die Freuden, die
reinsten Freuden des Lebens nicht genossen habe.—du kennst mein Wahlheim; dort bin
ich völlig etabliert, von da habe ich nur eine halbe Stunde zu Lotten, dort
fühl' ich mich selbst und alles Glück, das dem Menschen gegeben ist.

Hätt' ich gedacht, als ich mir Wahlheim zum Zwecke meiner Spaziergänge wählte,
dass es so nahe am Himmel läge! Wie oft habe ich das Jagdhaus, das nun alle
meine Wünsche einschliesst, auf meinen weiten Wanderungen, bald vom Berge, bald
von der Ebne über den Fluss gesehn!

Lieber Wilhelm, ich habe allerlei nachgedacht, über die Begier im Menschen, sich
auszubreiten, neue Entdeckungen zu machen, herumzuschweifen; und dann wieder über den
inneren Trieb, sich der Einschränkung willig zu ergeben, in dem Gleise der
Gewohnheit so hinzufahren und sich weder um Rechts noch um Links zu bekümmern.

Es ist wunderbar: wie ich hierher kam und vom Hügel in das schöne Tal
schaute, wie es mich rings umher anzog.—dort das Wäldchen!—ach könntest du dich in
seine Schatten mischen!—dort die Spitze des Berges!—ach könntest du von da die
weite Gegend überschauen!—die in einander geketteten Hügel und vertraulichen
Täler!—o könnte ich mich in ihnen verlieren!—ich eilte hin, und kehrte zurück, und
hatte nicht gefunden, was ich hoffte. O es ist mit der Ferne wie mit der
Zukunft! Ein grosses dämmerndes Ganze ruht vor unserer Seele, unsere Empfindung
verschwimmt darin wie unser Auge, und wir sehnen uns, ach! Unser ganzes Wesen
hinzugeben, uns mit aller Wonne eines einzigen, grossen, herrlichen Gefühls ausfüllen
zu lassen.—und ach! Wenn wir hinzueilen, wenn das Dort nun Hier wird, ist
alles vor wie nach, und wir stehen in unserer Armut, in unserer
Eingeschränktheit, und unsere Seele lechzt nach entschlüpftem Labsale.

So sehnt sich der unruhigste Vagabund zuletzt wieder nach seinem
Vaterlande und findet in seiner Hütte, an der Brust seiner Gattin, in
dem Kreise seiner Kinder, in den Geschäften zu ihrer Erhaltung die
Wonne, die er in der weiten Welt vergebens suchte.

Wenn ich des Morgens mit Sonnenaufgange hinausgehe nach meinem Wahlheim und
dort im Wirtsgarten mir meine Zuckererbsen selbst pflücke, mich hinsetze, sie
abfädne und dazwischen in meinem Homer lese; wenn ich in der kleinen Küche mir
einen Topf wähle, mir Butter aussteche, Schoten ans Feuer stelle, zudecke und
mich dazusetze, sie manchmal umzuschütteln: da fühl' ich so lebhaft, wie die
übermütigen Freier der Penelope Ochsen und Schweine schlachten, zerlegen und braten.
Es ist nichts, das mich so mit einer stillen, wahren Empfindung ausfüllte als
die Züge patriarchalischen Lebens, die ich, Gott sei Dank, ohne Affektation in
meine Lebensart verweben kann.

Wie wohl ist mir's, dass mein Herz die simple, harmlose Wonne des Menschen
fühlen kann, der ein Krauthaupt auf seinen Tisch bringt, das er selbst gezogen,
und nun nicht den Kohl allein, sondern all die guten Tage, den schönen Morgen,
da er ihn pflanzte, die lieblichen Abende, da er ihn begoss, und da er an dem
fortschreitenden Wachstum seine Freude hatte, alle in einem Augenblicke wieder mitgeniesst.

Am 29. Junius

Vorgestern kam der Medikus hier aus der Stadt hinaus zum Amtmann und fand mich auf
der Erde unter Lottens Kindern, wie einige auf mir herumkrabbelten, andere
mich neckten, und wie ich sie kitzelte und ein grosses Geschrei mit ihnen
erregte. Der Doktor, der eine sehr dogmatische Drahtpuppe ist, unterm Reden seine
Manschetten in Falten legt und einen Kräusel ohne Ende herauszupft, fand dieses unter
der Würde eines gescheiten Menschen; das merkte ich an seiner Nase. Ich liess
mich aber in nichts stören, liess ihn sehr vernünftige Sachen abhandeln und
baute den Kindern ihre Kartenhäuser wieder, die sie zerschlagen hatten. Auch
ging er darauf in der Stadt herum und beklagte, des Amtmanns Kinder wären so
schon ungezogen genug, der Werther verderbe sie nun völlig.

Ja, lieber Wilhelm, meinem Herzen sind die Kinder am nächsten auf der Erde.
Wenn ich ihnen zusehe und in dem kleinen Dinge die Keime aller Tugenden, aller
Kräfte sehe, die sie einmal so nötig brauchen werden; wenn ich in dem Eigensinne
künftige Standhaftigkeit und Festigkeit des Charakters, in dem Mutwillen guten
Humor und Leichtigkeit, über die Gefahren der Welt hinzuschlüpfen, erblicke,
alles so unverdorben, so ganz!—immer, immer wiederhole ich dann die goldenen
Worte des Lehrers der Menschen:"wenn ihr nicht werdet wie eines von diesen!" und
nun, mein Bester, sie, die unseresgleichen sind, die wir als unsere Muster
ansehen sollten, behandeln wir als Untertanen. Sie sollen keinen Willen
haben!—haben wir denn keinen? Und wo liegt das Vorrecht?—weil wir älter sind und
gescheiter!—guter Gott von deinem Himmel, alte Kinder siehst du und junge Kinder, und nichts
weiter; und an welchen du mehr Freude hast, das hat dein Sohn schon lange
verkündigt. Aber sie glauben an ihn und hören ihn nicht—das ist auch was Altes!—und
bilden ihre Kinder nach sich und—Adieu, Wilhelm! Ich mag darüber nicht weiter
radotieren.

Am 1. Julius

Was Lotte einem Kranken sein muss, fühl' ich an meinem eigenen Herzen, das
übler dran ist als manches, das auf dem Siechbette verschmachtet. Sie wird
einige Tage in der Stadt bei einer rechtschaffnen Frau zubringen, die sich nach
der Aussage der Ärzte ihrem Ende naht und in diesen letzten Augenblicken
Lotten um sich haben will. Ich war vorige Woche mit ihr, den Pfarrer von St. zu
besuchen; ein Örtchen, das eine Stunde seitwärts im Gebirge liegt. Wir kamen gegen
vier dahin. Lotte hatte ihre zweite Schwester mitgenommen. Als wir in den mit
zwei hohen Nussbäumen überschatteten Pfarrhof traten, sass der gute alte Mann auf
einer Bank vor der Haustür, und da er Lotten sah, ward er wie neu belebt, vergass
seinen Knotenstock und wagte sich auf, ihr entgegen. Sie lief hin zu ihm, nötigte
ihn sich niederzulassen, indem sie sich zu ihm setzte, brachte viele Grüsse von
ihrem Vater, herzte seinen garstigen, schmutzigen jüngsten Buben, das Quakelchen
seines Alters. Du hättest sie sehen sollen, wie sie den Alten beschäftigte, wie
sie ihre Stimme erhob, um seinen halb tauben Ohren vernehmlich zu werden, wie
sie ihm von jungen, robusten Leuten erzählte, die unvermutet gestorben wären,
von der Vortrefflichkeit des Karlsbades, und wie sie seinen Entschluss lobte,
künftigen Sommer hinzugehen, wie sie fand, dass er viel besser aussähe, viel munterer
sei als das letztemal, da sie ihn gesehn.—ich hatte indes der Frau Pfarrerin
meine Höflichkeiten gemacht. Der Alte wurde ganz munter, und da ich nicht umhin
konnte, die schönen Nussbäume zu loben, die uns so lieblich beschatteten, fing er
an, uns, wiewohl mit einiger Beschwerlichkeit, die Geschichte davon zu
geben.—"den alten", sagte er,"wissen wir nicht, wer den gepflanzt hat; einige sagen
dieser, andere jener Pfarrer. Der jüngere aber dort hinten ist so alt als meine
Frau, im Oktober funfzig Jahr. Ihr Vater pflanzte ihn des Morgens, als sie gegen
Abend geboren wurde. Er war mein Vorfahr im Amt, und wie lieb ihm der Baum war,
ist nicht zu sagen; mir ist er's gewiss nicht weniger. Meine Frau sass darunter
auf einem Balken und strickte, da ich vor siebenundzwanzig Jahren als ein
armer Student zum erstenmale hier in den Hof kam".—Lotte fragte nach seiner
Tochter; es hiess, sie sei mit Herrn Schmidt auf die Wiese hinaus zu den Arbeitern,
und der Alte fuhr in seiner Erzählung fort: wie sein Vorfahr ihn liebgewonnen
und die Tochter dazu, und wie er erst sein Vikar und dann sein Nachfolger
geworden. Die Geschichte war nicht lange zu Ende, als die Jungfer Pfarrerin mit dem
sogenannten Herrn Schmidt durch den Garten herkam: sie bewillkommte Lotten mit
herzlicher Wärme, und ich muss sagen, sie gefiel mir nicht übel; eine rasche,
wohlgewachsene Brünette, die einen die kurze Zeit über auf dem Lande wohl unterhalten
hätte. Ihr Liebhaber (denn als solchen stellte sich Herr Schmidt gleich dar), ein
feiner, doch stiller Mensch, der sich nicht in unsere Gespräche mischen wollte, ob
ihn gleich Lotte immer hereinzog. Was mich am meisten betrübte, war, dass ich
an seinen Gesichtszügen zu bemerken schien, es sei mehr Eigensinn und übler
Humor als Eingeschränktheit des Verstandes, der ihn sich mitzuteilen hinderte.
In der Folge ward dies leider nur zu deutlich; denn als Friederike beim
Spazierengehen mit Lotten und gelegentlich auch mit mir ging, wurde des Herrn Angesicht,
das ohnedies einer bräunlichen Farbe war, so sichtlich verdunkelt, dass es Zeit
war, dass Lotte mich beim Ärmel zupfte und mir zu verstehn gab, dass ich mit
Friederiken zu artig getan. Nun verdriesst mich nichts mehr, als wenn die Menschen
einander plagen, am meisten, wenn junge Leute in der Blüte des Lebens, da sie am
offensten für alle Freuden sein könnten, einander die paar guten Tage mit Fratzen
verderben und nur erst zu spät das Unersetzliche ihrer Verschwendung einsehen. Mich
wurmte das, und ich konnte nicht umhin, da wir gegen Abend in den Pfarrhof
zurückkehrten und an einem Tische Milch assen und das Gespräch auf Freude und Leid der
Welt sich wendete, den Faden zu ergreifen und recht herzlich gegen die üble
Laune zu reden.—"wir Menschen beklagen uns oft", fing ich an, "dass der guten
Tage so wenig sind und der schlimmen so viel, und, wie mich dünkt, meist mit
Unrecht. Wenn wir immer ein offenes Herz hätten, das Gute zu geniessen, das uns Gott
für jeden Tag bereitet, wir würden alsdann auch Kraft genug haben, das Übel zu
tragen, wenn es kommt". —"Wir haben aber unser Gemüt nicht in unserer Gewalt",
versetzte die Pfarrerin, "wie viel hängt vom Körper ab! Wenn einem nicht wohl ist,
ist's einem überall nicht recht".—Ich gestand ihr das ein.—"Wir wollen es also",
fuhr ich fort,"als eine Krankheit ansehen und fragen, ob dafür kein Mittel
ist?"—"Das lässt sich hören", sagte Lotte, "ich glaube wenigstens, dass viel von uns
abhängt. Ich weiss es an mir. Wenn mich etwas neckt und mich verdriesslich machen
will, spring' ich auf und sing' ein paar Contretänze den Garten auf und ab,
gleich ist's weg".—"das war's, was ich sagen wollte,"versetzte ich,"es ist mit
der üblen Laune völlig wie mit der Trägheit, denn es ist eine Art von
Trägheit. Unsere Natur hängt sehr dahin, und doch, wenn wir nur einmal die Kraft
haben, uns zu ermannen, geht uns die Arbeit frisch von der Hand, und wir finden
in der Tätigkeit ein wahres Vergnügen". —Friederike war sehr aufmerksam, und
der junge Mensch wandte mir ein, dass man nicht Herr über sich selbst sei und
am wenigsten über seine Empfindungen gebieten könne.—"es ist hier die Frage
von einer unangenehmen Empfindung", versetzte ich, "die doch jedermann gerne
los ist; und niemand weiss, wie weit seine Kräfte gehen, bis er sie versucht
hat. Gewiss, wer krank ist, wird bei allen Ärzten herumfragen, und die grössten
Resignationen, die bittersten Arzeneien wird er nicht abweisen, um seine gewünschte
Gesundheit zu erhalten".—ich bemerkte, dass der ehrliche Alte sein Gehör anstrengte,
um an unserm Diskurse teilzunehmen, ich erhob die Stimme, indem ich die Rede
gegen ihn wandte". Man predigt gegen so viele Laster", sagte ich, "ich habe noch
nie gehört, dass man gegen die üble Laune vom Predigtstuhle gearbeitet
hätte.—"Das müssten die Stadtpfarrer tun", sagte er, "die Bauern haben keinen bösen
Humor; doch könnte es auch zuweilen nicht schaden, es wäre eine Lektion für seine
Frau wenigstens und für den Herrn Amtmann".—Die Gesellschaft lachte, und er
herzlich mit, bis er in einen Husten verfiel, der unsern Diskurs eine Zeitlang
unterbrach; darauf denn der junge Mensch wieder das Wort nahm: "Sie nannten den bösen
Humor ein Laster; mich deucht, das ist übertrieben".—"Mit nichten", gab ich zur
Antwort, "wenn das, womit man sich selbst und seinem Nächsten schadet, diesen Namen
verdient. Ist es nicht genug, dass wir einander nicht glücklich machen können, müssen
wir auch noch einander das Vergnügen rauben, das jedes Herz sich noch manchmal
selbst gewähren kann? Und nennen Sie mir den Menschen, der übler Laune ist und so
brav dabei, sie zu verbergen, sie allein zu tragen, ohne die Freude um sich her
zu zerstören! Oder ist sie nicht vielmehr ein innerer Unmut über unsere
eigene Unwürdigkeit, ein Missfallen an uns selbst, das immer mit einem Neide
verknüpft ist, der durch eine törichte Eitelkeit aufgehetzt wird? Wir sehen
glückliche Menschen, die wir nicht glücklich machen, und das ist unerträglich".—Lotte
lächelte mich an, da sie die Bewegung sah, mit der ich redete, und eine Träne in
Friederikens Auge spornte mich fortzufahren.—"Wehe denen", sagte ich, "die sich der
Gewalt bedienen, die sie über ein Herz haben, um ihm die einfachen Freuden zu
rauben, die aus ihm selbst hervorkeimen. Alle Geschenke, alle Gefälligkeiten der
Welt ersetzen nicht einen Augenblick Vergnügen an sich selbst, den uns eine
neidische Unbehaglichkeit unsers Tyrannen vergällt hat".

Mein ganzes Herz war voll in diesem Augenblicke; die Erinnerung so manches
Vergangenen drängte sich an meine Seele, und die Tränen kamen mir in die Augen.

"Wer sich das nur täglich sagte",rief ich aus,"du vermagst nichts auf deine
Freunde, als ihnen ihre Freuden zu lassen und ihr Glück zu vermehren, indem du es
mit ihnen geniessest. Vermagst du, wenn ihre innere Seele von einer
ängstigenden Leidenschaft gequält, vom Kummer zerrüttet ist, ihnen einen Tropfen
Linderung zu geben?

Und wenn die letzte, bangste Krankheit dann über das Geschöpf herfällt, das du
in blühenden Tagen untergraben hast, und sie nun daliegt in dem
erbärmlichsten Ermatten, das Auge gefühllos gen Himmel sieht, der Todesschweiss auf der
blassen Stirne abwechselt, und du vor dem Bette stehst wie ein Verdammter, in dem
innigsten Gefühl, dass du nichts vermagst mit deinem ganzen Vermögen, und die Angst
dich inwendig krampft, dass du alles hingeben möchtest, dem untergehenden
Geschöpfe einen Tropfen Stärkung, einen Funken Mut einflössen zu können".

Die Erinnerung einer solchen Szene, wobei ich gegenwärtig war, fiel mit ganzer
Gewalt bei diesen Worten über mich. Ich nahm das Schnupftuch vor die Augen und
verliess die Gesellschaft, und nur Lottens Stimme, die mir rief, wir wollten fort,
brachte mich zu mir selbst. Und wie sie mich auf dem Wege schalt über den zu
warmen Anteil an allem, und dass ich drüber zugrunde gehen würde! Dass ich mich
schonen sollte!—O der Engel! Um deinetwillen muss ich leben!

Am 6. Julius

Sie ist immer um ihre sterbende Freundin, und ist immer dieselbe, immer das
gegenwärtige, holde Geschöpf, das, wo sie hinsieht, Schmerzen lindert und Glückliche
macht. Sie ging gestern abend mit Marianen und dem kleinen Malchen spazieren, ich
wusste es und traf sie an, und wir gingen zusammen. Nach einem Wege von
anderthalb Stunden kamen wir gegen die Stadt zurück, an den Brunnen, der mir so wert
und nun tausendmal werter ist. Lotte setzte sich aufs Mäuerchen, wir standen
vor ihr. Ich sah umher, ach, und die Zeit, da mein Herz so allein war, lebte
wieder vor mir auf.—"Lieber Brunnen", sagte ich, "seither hab' ich nicht mehr an
deiner Kühle geruht, hab' in eilendem Vorübergehn dich manchmal nicht
angesehn".—Ich blickte hinab und sah, dass Malchen mit einem Glase Wasser sehr beschäftigt
heraufstieg.—Ich sah Lotten an und fühlte alles, was ich an ihr habe. Indem kommt Malchen
mit einem Glase. Mariane wollt' es ihr abnehmen: "nein!" rief das Kind mit dem
süssesten Ausdrucke,"nein, Lottchen, du sollst zuerst trinken!"—ich ward über die
Wahrheit, über die Güte, womit sie das ausrief, so entzückt, dass ich meine
Empfindung mit nichts ausdrücken konnte, als ich nahm das Kind von der Erde und küsste
es lebhaft, das sogleich zu schreien und zu weinen anfing.—"Sie haben übel
getan", sagte Lotte.—Ich war betroffen.—"komm, Malchen, "fuhr sie fort, indem sie
es bei der Hand nahm und die Stufen hinabführte, "da wasche dich aus der
frischen Quelle geschwind, geschwind, da tut's nichts".—Wie ich so dastand und
zusah, mit welcher Emsigkeit das Kleine seinen nassen Händchen die Backen rieb,
mit welchem Glauben, dass durch die Wunderquelle alle Verunreinigung abgespült
und die Schmach abgetan würde, einen hässlichen Bart zu kriegen; wie Lotte
sagte: "es ist genug!" und das Kind doch immer eifrig fortwusch, als wenn Viel
mehr täte als Wenig—ich sage dir, Wilhelm, ich habe mit mehr Respekt nie einer
Taufhandlung beigewohnt; und als Lotte heraufkam, hätte ich mich gern vor ihr
niedergeworfen wie vor einem Propheten, der die Schulden einer Nation weggeweiht hat.

Des Abends konnte ich nicht umhin, in der Freude meines Herzens den Vorfall
einem Manne zu erzählen, dem ich Menschensinn zutraute, weil er Verstand hat;
aber wie kam ich an! Er sagte, das sei sehr übel von Lotten gewesen; man solle
den Kindern nichts weis machen; dergleichen gebe zu unzähligen Irrtümern und
Aberglauben Anlass, wovor man die Kinder frühzeitig bewahren müsse.—nun fiel mir ein,
dass der Mann vor acht Tagen hatte taufen lassen, drum liess ich's vorbeigehen
und blieb in meinem Herzen der Wahrheit getreu: wir sollen es mit den Kindern
machen wie Gott mit uns, der uns am glücklichsten macht, wenn er uns in
freundlichem Wahne so hintaumeln lässt.

Am 8. Julius

Was man ein Kind ist! Was man nach so einem Blicke geizt! Was man ein Kind
ist!—Wir waren nach Wahlheim gegangen. Die Frauenzimmer fuhren hinaus, und während
unserer Spaziergänge glaubte ich in Lottens schwarzen Augen—ich bin ein Tor,
verzeih mir's! Du solltest sie sehen, diese Augen.—Dass ich kurz bin (denn die
Augen fallen mir zu vor Schlaf): siehe, die Frauenzimmer stiegen ein, da standen
um die Kutsche der junge W., Selstadt und Audran und ich. Da ward aus dem
Schlage geplaudert mit den Kerlchen, die freilich leicht und lüftig genug
waren.—ich suchte Lottens Augen: ach, sie gingen von einem zum andern! Aber auf mich!
Mich! Mich! Der ganz allein auf sie resigniert dastand, fielen sie nicht!—Mein
Herz sagte ihr tausend Adieu! Und sie sah mich nicht! Die Kutsche fuhr vorbei,
und eine Träne stand mir im Auge. Ich sah ihr nach und sah Lottens Kopfputz
sich zum Schlage herauslehnen, und sie wandte sich um zu sehen, ach! Nach
mir?—Lieber! In dieser Ungewissheit schwebe ich; das ist mein Trost: vielleicht hat sie
sich nach mir umgesehen! Vielleicht!—Gute Nacht! O, was ich ein Kind bin!

Am 10. Julius

Die alberne Figur, die ich mache, wenn in Gesellschaft von ihr gesprochen
wird, solltest du sehen! Wenn man mich nun gar fragt, wie sie mir
gefällt?—gefällt! Das Wort hasse ich auf den Tod. Was muss das für ein Mensch sein, dem Lotte
gefällt, dem sie nicht alle Sinne, alle Empfindungen ausfüllt! Gefällt! Gefällt!
Neulich fragte mich einer, wie mir Ossian gefiele!

Am 11. Julius

Frau M. ist sehr schlecht; ich bete für ihr Leben, weil ich mit Lotten dulde.
Ich sehe sie selten bei einer Freundin, und heute hat sie mir einen
wunderbaren Vorfall erzählt.—der alte M. ist ein geiziger, rangiger Filz, der seine
Frau im Leben was Rechts geplagt und eingeschränkt hat; doch hat sich die Frau
immer durchzuhelfen gewusst. Vor wenigen Tagen, als der Arzt ihr das Leben
abgesprochen hatte, liess sie ihren Mann kommen (Lotte war im Zimmer) und redete ihn
also an: "ich muss dir eine Sache gestehen, die nach meinem Tode Verwirrung und
Verdruss machen könnte. Ich habe bisher die Haushaltung geführt, so ordentlich und
sparsam als möglich; allein du wirst mir verzeihen, dass ich dich diese dreissig
Jahre her hintergangen habe. Du bestimmtest im Anfange unserer Heirat ein
Geringes für die Bestreitung der Küche und anderer häuslichen Ausgaben. Als unsere
Haushaltung stärker wurde, unser Gewerbe grösser, warst du nicht zu bewegen, mein
Wochengeld nach dem Verhältnisse zu vermehren; kurz, du weisst, dass du in den Zeiten,
da sie am grössten war, verlangtest, ich solle mit sieben Gulden die Woche
auskommen.

Die habe ich denn ohne Widerrede genommen und mir den Überschuss wöchentlich
aus der Losung geholt, da niemand vermutete, dass die Frau die Kasse bestehlen
würde. Ich habe nichts verschwendet und wäre auch, ohne es zu bekennen, getrost
der Ewigkeit entgegengegangen, wenn nicht diejenige, die nach mir das
Hauswesen zu führen hat, sich nicht zu helfen wissen würde, und du doch immer darauf
bestehen könntest, deine erste Frau sei damit ausgekommen".

Ich redete mit Lotten über die unglaubliche Verblendung des Menschensinns, dass
einer nicht argwohnen soll, dahinter müsse was anders stecken, wenn eins mit
sieben Gulden hinreicht, wo man den Aufwand vielleicht um zweimal so viel sieht.
Aber ich habe selbst Leute gekannt, die des Propheten ewiges Ölkrüglein ohne
Verwunderung in ihrem Hause angenommen hätten.

Am 13. Julius

Nein, ich betrüge mich nicht! Ich lese in ihren schwarzen Augen wahre
Teilnehmung an mir und meinem Schicksal. Ja ich fühle, und darin darf ich meinem
Herzen trauen, dass sie—o darf ich, kann ich den Himmel in diesen Worten
aussprechen?—dass sie mich liebt!

Mich liebt!—und wie wert ich mir selbst werde, wie ich—dir darf ich's wohl
sagen, du hast Sinn für so etwas—wie ich mich selbst anbete, seitdem sie mich
liebt!

Ob das Vermessenheit ist oder Gefühl des wahren Verhältnisses?—ich kenne den
Menschen nicht, von dem ich etwas in Lottens Herzen fürchtete. Und doch—wenn sie
von ihrem Bräutigam spricht, mit solcher Wärme, solcher Liebe von ihm
spricht—da ist mir's wie einem, der aller seiner Ehren und Würden entsetzt und dem
der Degen genommen wird.

Am 16. Julius

Ach wie mir das durch alle Adern läuft, wenn mein Finger unversehens den
ihrigen berührt, wenn unsere Füsse sich unter dem Tische begegnen! Ich ziehe zurück
wie vom Feuer, und eine geheime Kraft zieht mich wieder vorwärts—mir wird's so
schwindelig vor allen Sinnen.—O! Und ihre Unschuld, ihre unbefangene Seele fühlt
nicht, wie sehr mich die kleinen Vertraulichkeiten peinigen. Wenn sie gar im
Gespräch ihre Hand auf die meinige legt und im Interesse der Unterredung näher zu
mir rückt, dass der himmlische Atem ihres Mundes meine Lippen erreichen
kann:—ich glaube zu versinken, wie vom Wetter gerührt.—und, Wilhelm! Wenn ich mich
jemals unterstehe, diesen Himmel, dieses Vertrauen—! Du verstehst mich. Nein,
mein Herz ist so verderbt nicht! Schwach! Schwach genug!—und ist das nicht
Verderben?—sie ist mir heilig. Alle Begier schweigt in ihrer Gegenwart. Ich weiss nie, wie
mir ist, wenn ich bei ihr bin; es ist, als wenn die Seele sich mir in allen
Nerven umkehrte.—sie hat eine Melodie, die sie auf dem Klaviere spielet mit der
Kraft eines Engels, so simpel und so geistvoll! Es ist ihr Leiblied, und mich
stellt es von aller Pein, Verwirrung und Grillen her, wenn sie nur die erste Note
davon greift.

Kein Wort von der Zauberkraft der alten Musik ist mir unwahrscheinlich. Wie
mich der einfache Gesang angreift! Und wie sie ihn anzubringen weiss, oft zur
Zeit, wo ich mir eine Kugel vor den Kopf schiessen möchte! Die Irrung und
Finsternis meiner Seele zerstreut sich, und ich atme wieder freier.

Am 18. Julius

Wilhelm, was ist unserem Herzen die Welt ohne Liebe! Was eine Zauberlaterne ist
ohne Licht! Kaum bringst du das Lämpchen hinein, so scheinen dir die buntesten
Bilder an deine weisse Wand! Und wenn's nichts wäre als das, als vorübergehende
Phantome, so macht's doch immer unser Glück, wenn wir wie frische Jungen davor
stehen und uns über die Wundererscheinungen entzücken. Heute konnte ich nicht zu
Lotten, eine unvermeidliche Gesellschaft hielt mich ab. Was war zu tun? Ich
schickte meinen Diener hinaus, nur um einen Menschen um mich zu haben, der ihr
heute nahe gekommen wäre. Mit welcher Ungeduld ich ihn erwartete, mit welcher
Freude ich ihn wiedersah! Ich hätte ihn gern beim Kopfe genommen und geküsst, wenn
ich mich nicht geschämt hätte.

Man erzählt von dem Bononischen Steine, dass er, wenn man ihn in die Sonne
legt, ihre Strahlen anzieht und eine Weile bei Nacht leuchtet. So war mir's mit
dem Burschen. Das Gefühl, dass ihre Augen auf seinem Gesichte, seinen Backen,
seinen Rockknöpfen und dem Kragen am Surtout geruht hatten, machte mir das alles
so heilig, so wert! Ich hätte in dem Augenblick den Jungen nicht um tausend
Taler gegeben. Es war mir so wohl in seiner Gegenwart.—bewahre dich Gott, dass du
darüber lachest. Wilhelm, sind das Phantome, wenn es uns wohl ist?

Den 19. Julius

"Ich werde sie sehen!" ruf' ich morgens aus, wenn ich mich ermuntere und mit
aller Heiterkeit der schönen Sonne entgegenblicke; "ich werde sie sehen!" und da
habe ich für den ganzen Tag keinen Wunsch weiter. Alles, alles verschlingt sich
in dieser Aussicht.

Eure Idee will noch nicht die meinige werden, dass ich mit dem Gesandten nach
*** gehen soll. Ich liebe die Subordination nicht sehr, und wir wissen alle,
dass der Mann noch dazu ein widriger Mensch ist. Meine Mutter möchte mich gern
in Aktivität haben, sagst du, das hat mich zu lachen gemacht. Bin ich jetzt
nicht auch aktiv, und ist's im Grunde nicht einerlei, ob ich Erbsen zähle oder
Linsen? Alles in der Welt läuft doch auf eine Lumperei hinaus, und ein Mensch, der
um anderer willen, ohne dass es seine eigene Leidenschaft, sein eigenes
Bedürfnis ist, sich um Geld oder Ehre oder sonst was abarbeitet, ist immer ein Tor.

Am 24. Julius

Da dir so sehr daran gelegen ist, dass ich mein Zeichnen nicht vernachlässige,
möchte ich lieber die ganze Sache übergehen als dir sagen, dass zeither wenig
getan wird.

Noch nie war ich glücklicher, noch nie war meine Empfindung an der Natur, bis
aufs Steinchen, aufs Gräschen herunter, voller und inniger, und doch—ich weiss
nicht, wie ich mich ausdrücken soll, meine vorstellende Kraft ist so schwach,
alles schwimmt und schwankt so vor meiner Seele, dass ich keinen Umriss packen
kann; aber ich bilde mir ein, wenn ich Ton hätte oder Wachs, so wollte ich's
wohl herausbilden. Ich werde auch Ton nehmen, wenn's länger währt, und kneten,
uns sollten's Kuchen werden!

Lottens Porträt habe ich dreimal angefangen, und habe mich dreimal prostituiert;
das mich um so mehr verdriesst, weil ich vor einiger Zeit sehr glücklich im
Treffen war. Darauf habe ich denn ihren Schattenriss gemacht, und damit soll mir
g'nügen.

Ja, liebe Lotte, ich will alles besorgen und bestellen; geben Sie mir nur mehr
Aufträge, nur recht oft. Um eins bitte ich Sie: keinen Sand mehr auf die Zettelchen,
die Sie mir schreiben. Heute führte ich es schnell nach der Lippe, und die
Zähne knisterten mir.

Am 26. Julius

Ich habe mir schon manchmal vorgenommen, sie nicht so oft zu sehn. Ja wer das
halten könnte! Alle Tage unterlieg' ich der Versuchung und verspreche mir heilig:
morgen willst du einmal wegbleiben. Und wenn der Morgen kommt, finde ich doch
wieder eine unwiderstehliche Ursache, und ehe ich mich's versehe, bin ich bei
ihr. Entweder sie hat des Abends gesagt: "Sie kommen doch morgen?"—wer könnte
da wegbleiben? Oder sie gibt mir einen Auftrag, und ich finde schicklich, ihr
selbst die Antwort zu bringen; oder der Tag ist gar zu schön, ich gehe nach
Wahlheim, und wenn ich nun da bin, ist's nur noch eine halbe Stunde zu ihr!—ich bin
zu nah in der Atmosphäre—zuck! So bin ich dort. Meine Grossmutter hatte ein
Märchen vom Magnetenberg: die Schiffe, die zu nahe kamen, wurden auf einmal alles
Eisenwerks beraubt, die Nägel flogen dem Berge zu, und die armen Elenden scheiterten
zwischen den übereinander stürzenden Brettern.

Am 30. Julius

Albert ist angekommen, und ich werde gehen; und wenn er der beste, der edelste
Mensch wäre, unter den ich mich in jeder Betrachtung zu stellen bereit wäre, so
wär's unerträglich, ihn vor meinem Angesicht im Besitz so vieler Vollkommenheit
zu sehen.—Besitz!—genug, Wilhelm, der Bräutigam ist da! Ein braver, lieber
Mann, dem man gut sein muss. Glücklicherweise war ich nicht beim Empfange! Das
hätte mir das Herz zerrissen. Auch ist er so ehrlich und hat Lotten in meiner
Gegenwart noch nicht ein einzigmal geküsst. Das lohn' ihm Gott! Um des Respekts
willen, den er vor dem Mädchen hat, muss ich ihn lieben. Er will mir wohl, und ich
vermute, das ist Lottens Werk mehr als seiner eigenen Empfindung; denn darin sind
die Weiber fein und haben recht; wenn sie zwei Verehrer in gutem Vernehmen mit
einander erhalten können, ist der Vorteil immer ihr, so selten es auch angeht.

Indes kann ich Alberten meine Achtung nicht versagen. Seine gelassene Aussenseite
sticht gegen die Unruhe meines Charakters sehr lebhaft ab, die sich nicht
verbergen lässt. Er hat viel Gefühl und weiss, was er an Lotten hat. Erscheint wenig
üble Laune zu haben, und du weisst, das ist die Sünde, die ich ärger hasse am
Menschen als alle andre.

Er hält mich für einen Menschen von Sinn; und meine Anhänglichkeit zu Lotten,
meine warme Freude, die ich an allen ihren Handlungen habe, vermehrt seinen
Triumph, und er liebt sie nur desto mehr. Ob er sie nicht einmal mit keiner
Eifersüchtelei peinigt, das lasse ich dahingestellt sein, wenigstens würd' ich an seinem
Platz nicht ganz sicher vor diesem Teufel bleiben.

Dem sei nun wie ihm wolle, meine Freude, bei Lotten zu sein, ist hin.
Soll ich das Torheit nennen oder Verblendung?—was braucht's Namen!
Erzählt die Sache an sich!—ich wusste alles, was ich jetzt weiss, ehe
Albert kam; ich wusste, dass ich keine Prätension an sie zu machen hatte,
machte auch keine—das heisst, insofern es möglich ist, bei so viel
Liebenswürdigkeit nicht zu begehren—und jetzt macht der Fratze grosse
Augen, da der andere nun wirklich kommt und ihm das Mädchen wegnimmt.

Ich beisse die Zähne auf einander und spott über mein Elend, und spottete derer
doppelt und dreifach, die sagen könnten, ich sollte mich resignieren, und weil es
nun einmal nicht anders sein könnte. —schafft mir diese Strohmänner vom
Halse!—ich laufe in den Wäldern herum, und wenn ich zu Lotten komme, und Albert bei
ihr sitzt im Gärtchen unter der Laube, und ich nicht weiter kann, so bin ich
ausgelassen närrisch und fange viel Possen, viel verwirrtes Zeug an. —"um Gottes
willen", sagte mir Lotte heut, "ich bitte Sie, keine Szene wie die von gestern
abend! Sie sind fürchterlich, wenn Sie so lustig sind".—Unter uns, ich passe die
Zeit ab, wenn er zu tun hat; wutsch! Bin ich drauss, und da ist mir's immer
wohl, wenn ich sie allein finde.

Am 8. August

Ich bitte dich, lieber Wilhelm, es war gewiss nicht auf dich geredet, wenn ich
die Menschen unerträglich schalt, die von uns Ergebung in unvermeidliche
Schicksale fordern. Ich dachte wahrlich nicht daran, dass du von ähnlicher Meinung
sein könntest. Und im Grunde hast du recht. Nur eins, mein Bester! In der Welt
ist es sehr selten mit dem Entweder-Oder getan; die Empfindungen und
Handlungsweisen schattieren sich so mannigfaltig, als Abfälle zwischen einer Habichts—und
Stumpfnase sind.

Du wirst mir also nicht übelnehmen, wenn ich dir dein ganzes Argument
einräume und mich doch zwischen dem Entweder-Oder durchzustehlen suche.

Entweder, sagst du, hast du Hoffnung auf Lotten, oder du hast keine. Gut, im ersten
Fall suche sie durchzutreiben, suche die Erfüllung deiner Wünsche zu umfassen:
im anderen Fall ermanne dich und suche einer elenden Empfindung los zu
werden, die alle deine Kräfte verzehren muss.—Bester! Das ist wohl gesagt, und—bald
gesagt.

Und kannst du von dem Unglücklichen, dessen Leben unter einer schleichenden
Krankheit unaufhaltsam allmählich abstirbt, kannst du von ihm verlangen, er solle
durch einen Dolchstoss der Qual auf einmal ein Ende machen? Und raubt das Übel,
das ihm die Kräfte verzehrt, ihm nicht auch zugleich den Mut, sich davon zu
befreien?

Zwar könntest du mir mit einem verwandten Gleichnisse antworten: wer liesse sich
nicht lieber den Arm abnehmen, als dass er durch Zaudern und Zagen sein Leben
aufs Spiel setzte?—Ich weiss nicht!—Und wir wollen uns nicht in Gleichnissen
herumbeissen. Genug—ja, Wilhelm, ich habe manchmal so einen Augenblick aufspringenden,
abschüttelnden Muts, und da—wenn ich nur wüsste wohin, ich ginge wohl.

Abends

Mein Tagebuch, das ich seit einiger Zeit vernachlässiget, fiel mir heut wieder
in die Hände, und ich bin erstaunt, wie ich so wissentlich in das alles,
Schritt vor Schritt, hineingegangen bin! Wie ich über meinen Zustand immer so klar
gesehen und doch gehandelt habe wie ein Kind, jetzt noch so klar sehe, und es noch
keinen Anschein zur Besserung hat.

Am 10. August

Ich könnte das beste, glücklichste Leben führen, wenn ich nicht ein Tor wäre.
So schöne Umstände vereinigen sich nicht leicht, eines Menschen Seele zu
ergetzen, als die sind, in denen ich mich jetzt befinde. Ach so gewiss ist's, dass
unser Herz allein sein Glück macht. —ein Glied der liebenswürdigen Familie zu
sein, von dem Alten geliebt zu werden wie ein Sohn, von den Kleinen wie ein
Vater, und von Lotten! —dann der ehrliche Albert, der durch keine launische Unart
mein Glück stört; der mich mit herzlicher Freundschaft umfasst; dem ich nach
Lotten das Liebste auf der Welt bin!—Wilhelm, es ist eine Freude, uns zu hören,
wenn wir spazierengehen und uns einander von Lotten unterhalten: es ist in der
Welt nichts Lächerlichers erfunden worden als dieses Verhältnis, und doch
kommen mir oft darüber die Tränen in die Augen.

Wenn er mir von ihrer rechtschaffenen Mutter erzählt: wie sie auf ihrem
Todbette Lotten ihr Haus und ihre Kinder übergeben und ihm Lotten anbefohlen habe,
wie seit der Zeit ein ganz anderer Geist Lotten belebt habe, wie sie, in der
Sorge für ihre Wirtschaft und in dem Ernste, eine wahre Mutter geworden, wie
kein Augenblick ihrer Zeit ohne tätige Liebe, ohne Arbeit verstrichen, und
dennoch ihre Munterkeit, ihr leichter Sinn sie nie dabei verlassen habe.—Ich gehe
so neben ihm hin und pflücke Blumen am Wege, füge sie sehr sorgfältig in
einen Strauss und—werfe sie in den vorüberfliessenden Strom und sehe ihnen nach,
wie sie leise hinunterwallen.—Ich weiss nicht, ob ich dir geschrieben habe, dass
Albert hier bleiben und ein Amt mit einem artigen Auskommen vom Hofe erhalten
wird, wo er sehr beliebt ist. In Ordnung und Emsigkeit in Geschäften habe ich
wenig seinesgleichen gesehen.

Am 12. August

Gewiss, Albert ist der beste Mensch unter dem Himmel. Ich habe gestern eine
wunderbare Szene mit ihm gehabt. Ich kam zu ihm, um Abschied von ihm zu nehmen; denn
mich wandelte die Lust an, ins Gebirge zu reiten, von woher ich dir auch jetzt
schreibe, und wie ich in der Stube auf und ab gehe, fallen mir seine Pistolen in die
Augen.—"Borge mir die Pistolen", sagte ich, "zu meiner Reise".—"Meinetwegen", sagte er,
"wenn du dir die Mühe nehmen willst, sie zu laden; bei mir hängen sie nur pro
forma".—Ich nahm eine herunter, und er fuhr fort: "seit mir meine Vorsicht einen so
unartigen Streich gespielt hat, mag ich mit dem Zeuge nichts mehr zu tun haben".—Ich
war neugierig, die Geschichte zu wissen.—"Ich hielt mich", erzählte er, "wohl
ein Vierteljahr auf dem Lande bei einem Freunde auf, hatte ein paar Terzerolen
ungeladen und schlief ruhig. Einmal an einem regnichten Nachmittage, da ich müssig
sitze, weiss ich nicht, wie mir einfällt: wir könnten überfallen werden, wir
könnten die Terzerolen nötig haben und könnten—du weisst ja, wie das ist.—ich gab
sie dem Bedienten, sie zu putzen und zu laden; und der dahlt mit den Mädchen,
will sie schrecken, und Gott weiss wie, das Gewehr geht los, da der Ladstock
noch drin steckt, und schiesst den Ladstock einem Mädchen zur Maus herein an der
rechten Hand und zerschlägt ihr den Daumen. Da hatte ich das Lamentieren, und die
Kur zu bezahlen obendrein, und seit der Zeit lass' ich alles Gewehr ungeladen.
Lieber Schatz, was ist Vorsicht? Die Gefahr lässt sich nicht auslernen! Zwar.—Nun
weisst du, dass ich den Menschen sehr lieb habe bis auf seine Zwar; denn versteht
sich's nicht von selbst, dass jeder allgemeine Satz Ausnahmen leidet? Aber so
rechtfertig ist der Mensch! Wenn er glaubt, etwas Übereiltes, Allgemeines, Halbwahres
gesagt zu haben, so hört er dir nicht auf zu limitieren, zu modifizieren und
ab—und zuzutun, bis zuletzt gar nichts mehr an der Sache ist.

Und bei diesem Anlass kam er sehr tief in Text: ich hörte endlich gar nicht
weiter auf ihn, verfiel in Grillen, und mit einer auffahrenden Gebärde drückte
ich mir die Mündung der Pistole übers rechte Aug' an die Stirn.—"Pfui!" sagte
Albert, indem er mir die Pistole herabzog, "was soll das?"—"Sie ist nicht
geladen", sagte ich.—"Und auch so, was soll's?" versetzte er ungeduldig. "Ich kann
mir nicht vorstellen, wie ein Mensch so töricht sein kann, sich zu erschiessen;
der blosse Gedanke erregt mir Widerwillen".

"Dass ihr Menschen", rief ich aus, "um von einer Sache zu reden, gleich sprechen
müsst: 'das ist töricht, das ist klug, das ist gut, das ist bös!' und was will
das alles heissen? Habt ihr deswegen die innern Verhältnisse einer Handlung
erforscht? Wisst ihr mit Bestimmtheit die Ursachen zu entwickeln, warum sie geschah,
warum sie geschehen musste? Hättet ihr das, ihr würdet nicht so eilfertig mit
euren Urteilen sein". "Du wirst mir zugeben", sagte Albert, "dass gewisse
Handlungen lasterhaft bleiben, sie mögen geschehen, aus welchem Beweggrunde sie
wollen". Ich zuckte die Achseln und gab's ihm zu.—"Doch, mein Lieber", fuhr ich
fort, "finden sich auch hier einige Ausnahmen. Es ist wahr, der Diebstahl ist
ein Laster: aber der Mensch, der, um sich und die Seinigen vom gegenwärtigen
Hungertode zu erretten, auf Raub ausgeht, verdient der Mitleiden oder Strafe? Wer
hebt den ersten Stein auf gegen den Ehemann, der im gerechten Zorne sein
untreues Weib und ihren nichtswürdigen Verführer aufopfert? Gegen das Mädchen, das
in einer wonnevollen Stunde sich in den unaufhaltsamen Freuden der Liebe
verliert? Unsere Gesetze selbst, diese kaltblütigen Pedanten, lassen sich rühren und
halten ihre Strafe zurück".

"Das ist ganz was anders", versetzte Albert, "weil ein Mensch, den seine
Leidenschaften hinreissen, alle Besinnungskraft verliert und als ein Trunkener, als ein
Wahnsinniger angesehen wird". "Ach ihr vernünftigen Leute!" rief ich lächelnd aus.
"Leidenschaft! Trunkenheit! Wahnsinn! Ihr steht so gelassen, so ohne Teilnehmung da, ihr
sittlichen Menschen, scheltet den Trinker, verabscheut den Unsinnigen, geht vorbei
wie der Priester und dankt Gott wie der Pharisäer, dass er euch nicht gemacht
hat wie einen von diesen. Ich bin mehr als einmal trunken gewesen, meine
Leidenschaften waren nie weit vom Wahnsinn, und beides reut mich nicht: denn ich habe in
einem Masse begreifen lernen, wie man alle ausserordentlichen Menschen, die etwas
Grosses, etwas Unmöglichscheinendes wirkten, von jeher für Trunkene und Wahnsinnige
ausschreiten musste. Aber auch im gemeinen Leben ist's unerträglich, fast einem jeden
bei halbweg einer freien, edlen, unerwarteten Tat nachrufen zu hören: ' der
Mensch ist trunken, der ist närrisch!' Schämt euch, ihr Nüchternen! Schämt euch,
ihr Weisen!" "Das sind nun wieder von deinen Grillen", sagte Albert, "du
überspannst alles und hast wenigstens hier gewiss unrecht, dass du den Selbstmord, wovon
jetzt die Rede ist, mit grossen Handlungen vergleichst: da man es doch für nichts
anders als eine Schwäche halten kann. Denn freilich ist es leichter zu sterben,
als ein qualvolles Leben standhaft zu ertragen". Ich war im Begriff
abzubrechen; denn kein Argument bringt mich so aus der Fassung, als wenn einer mit
einem unbedeutenden Gemeinspruche angezogen kommt, wenn ich aus ganzem Herzen
rede.

Doch fasste ich mich, weil ich's schon oft gehört und mich öfter darüber
geärgert hatte, und versetzte ihm mit einiger Lebhaftigkeit: "Du nennst das
Schwäche? Ich bitte dich, lass dich vom Anscheine nicht verführen. Ein Volk, das
unter dem unerträglichen Joch eines Tyrannen seufzt, darfst du das schwach
heissen, wenn es endlich aufgärt und seine Ketten zerreisst? Ein Mensch, der über
dem Schrecken, dass Feuer sein Haus ergriffen hat, alle Kräfte gespannt fühlt
und mit Leichtigkeit Lasten wegträgt, die er bei ruhigem Sinne kaum bewegen
kann; einer, der in der Wut der Beleidigung es mit sechsen aufnimmt und sie
überwältig, sind die schwach zu nennen? Und, mein Guter, wenn Anstrengung Stärke ist,
warum soll die Überspannung das Gegenteil sein?"—Albert sah mich an und sagte:
"nimm mir's nicht übel, die Beispiele, die du gibst, scheinen hieher gar nicht
zu gehören".—"Es mag sein", sagte ich, "man hat mir schon öfters vorgeworfen,
dass meine Kombinationsart manchmal an Radotage grenze. Lasst uns denn sehen, ob
wir uns auf eine andere Weise vorstellen können, wie dem Menschen zu Mute sein
mag, der sich entschliesst, die sonst angenehme Bürde des Lebens abzuwerfen.
Denn nur insofern wir mitempfinden, haben wir die Ehre, von einer Sache zu
reden".

"Die menschliche Natur", fuhr ich fort, "hat ihre Grenzen: sie kann Freude,
Leid, Schmerzen bis auf einen gewissen Grad ertragen und geht zugrunde, sobald
der überstiegen ist. Hier ist also nicht die Frage, ob einer schwach oder
stark ist, sondern ob er das Mass seines Leidens ausdauern kann, es mag nun
moralisch oder körperlich sein. Und ich finde es ebenso wunderbar zu sagen, der
Mensch ist feige, der sich das Leben nimmt, als es ungehörig wäre, den einen
Feigen zu nennen, der an einem bösartigen Fieber stirbt".

"Paradox! Sehr paradox!" rief Albert aus.—"Nicht so sehr, als du denkst", versetzte
ich. "Du gibst mir zu, wir nennen das eine Krankheit zum Tode, wodurch die
Natur so angegriffen wird, dass teils ihre Kräfte verzehrt, teils so ausser
Wirkung gesetzt werden, dass sie sich nicht wieder aufzuhelfen, durch keine
glückliche Revolution den gewöhnlichen Umlauf des Lebens wieder herzustellen fähig
ist.

Nun, mein Lieber, lass uns das auf den Geist anwenden. Sieh den
Menschen an in seiner Eingeschränktheit, wie Eindrücke auf ihn wirken,
Ideen sich bei ihm festsetzen, bis endlich eine wachsende Leidenschaft
ihn aller ruhigen Sinneskraft beraubt und ihn zugrunde richtet.

Vergebens, dass der gelassene, vernünftige Mensch den Zustand Unglücklichen übersieht,
vergebens, dass er ihm zuredet! Ebenso wie ein Gesunder, der am Bette des Kranken
steht, ihm von seinen Kräften nicht das geringste einflössen kann".

Alberten war das zu allgemein gesprochen. Ich erinnerte ihn an ein Mädchen, das man
vor weniger Zeit im Wasser tot gefunden, und wiederholte ihm ihre
Geschichte.—"Ein gutes, junges Geschöpf, das in dem engen Kreise häuslicher
Beschäftigungen, wöchentlicher bestimmter Arbeit herangewachsen war, das weiter keine
Aussicht von Vergnügen kannte, als etwa Sonntags in einem nach und nach
zusammengeschafften Putz mit ihresgleichen um die Stadt spazierenzugehen, vielleicht alle
hohen Feste einmal zu tanzen und übrigens mit aller Lebhaftigkeit des
herzlichsten Anteils manche Stunde über den Anlass eines Gezänkes, einer übeln Nachrede
mit einer Nachbarin zu verplaudern—deren feurige Natur fühlt nun endlich
innigere Bedürfnisse, die durch die Schmeicheleien der Männer vermehrt werden; ihre
vorigen Freuden werden ihr nach und nach unschmackhaft, bis sie endlich einen
Menschen antrifft, zu dem ein unbekanntes Gefühl sie unwiderstehlich hinreisst, auf
den sie nun alle ihre Hoffnungen wirft, die Welt rings um sich vergisst, nichts
hört, nichts sieht, nichts fühlt als ihn, den Einzigen, sich nur sehnt nach ihm,
dem Einzigen. Durch die leeren Vergnügungen einer unbeständigen Eitelkeit
nicht verdorben, zieht ihr Verlangen gerade nach dem Zweck, sie will die Seinige
werden, sie will in ewiger Verbindung all das Glück antreffen, das ihr mangelt,
die Vereinigung aller Freuden geniessen, nach denen sie sich sehnte.
Wiederholtes Versprechen, das ihr die Gewissheit aller Hoffnungen versiegelt, kühne
Liebkosungen, die ihre Begierden vermehren, umfangen ganz ihre Seele; sie schwebt in
einem dumpfen Bewusstsein, in einem Vorgefühl aller Freuden, sie ist bis auf den
höchsten Grad gespannt, sie streckt endlich ihre Arme aus, all ihre Wünsche zu
umfassen—und ihr Geliebter verlässt sie.—Erstarrt, ohne Sinne steht sie vor einem
Abgrunde; alles ist Finsternis um sie her, keine Aussicht, kein Trost, keine Ahnung!
Denn der hat sie verlassen, in dem sie allein ihr Dasein fühlte. Sie sieht
nicht die weite Welt, die vor ihr liegt, nicht die vielen, die ihr den Verlust
ersetzen könnten, sie fühlt sich allein, verlassen von aller Welt,—und blind, in
die Enge gepresst von der entsetzlichen Not ihres Herzens, stürzt sie sich
hinunter, um in einem rings umfangenden Tode alle ihre Qualen zu ersticken.—Sieh,
Albert, das ist die Geschichte so manches Menschen! Und sag', ist das nicht der
Fall der Krankheit? Die Natur findet keinen Ausweg aus dem Labyrinthe der
verworrenen und widersprechenden Kräfte, und der Mensch muss sterben. Wehe dem, der
zusehen und sagen könnte: 'die Törin! Hätte sie gewartet, hätte sie die Zeit
wirken lassen, die Verzweifelung würde sich schon gelegt, es würde sich schon ein
anderer sie zu trösten vorgefunden haben.'—Das ist eben, als wenn einer sagte:
'der Tor, stirbt am Fieber! Hätte er gewartet, bis seine Kräfte sich erholt,
seine Säfte sich verbessert, der Tumult seines Blutes sich gelegt hätten: alles
wäre gut gegangen, und er lebte bis auf den heutigen Tag! '"

Albert, dem die Vergleichung noch nicht anschaulich war, wandte noch einiges ein,
und unter andern: ich hätte nur von einem einfältigen Mädchen gesprochen; wie
aber ein Mensch von Verstande, der nicht so eingeschränkt sei, der mehr
Verhältnisse übersehe, zu entschuldigen sein möchte, könne er nicht begreifen.—"Mein
Freund", rief ich aus, "der Mensch ist Mensch, und das bisschen Verstand, das einer
haben mag, kommt wenig oder nicht in Anschlag, wenn Leidenschaft wütet und die
Grenzen der Menschheit einen drängen. Vielmehr—ein andermal davon", sagte ich und
griff nach meinem Hute. O mir war das Herz so voll—und wir gingen auseinander,
ohne einander verstanden zu haben. Wie denn auf dieser Welt keiner leicht den
andern versteht.

Am 15. August

Es ist doch gewiss, dass in der Welt den Menschen nichts notwendig macht als
die Liebe. Ich fühl's an Lotten, dass sie mich ungern verlöre, und die Kinder
haben keinen andern Begriff, als dass ich immer morgen wiederkommen würde. Heute
war ich hinausgegangen, Lottens Klavier zu stimmen, ich konnte aber nicht dazu
kommen, denn die Kleinen verfolgten mich um ein Märchen, und Lotte sagte selbst,
ich sollte ihnen den Willen tun. Ich schnitt ihnen das Abendbrot, das sie nun
fast so gern von mir als von Lotten annehmen, und erzählte ihnen das
Hauptstückchen von der Prinzessin, die von Händen bedient wird. Ich lerne viel dabei, das
versichre ich dich, und ich bin erstaunt, was es auf sie für Eindrücke macht. Weil
ich manchmal einen Inzidentpunkt erfinden muss, den ich beim zweitenmal
vergesse, sagen sie gleich, das vorigemal wär' es anders gewesen, so dass ich mich
jetzt übe, sie unveränderlich in einem singenden Silbenfall an einem Schnürchen
weg zu rezitieren. Ich habe daraus gelernt, wie ein Autor durch eine zweite,
veränderte Ausgabe seiner Geschichte, und wenn sie poetisch noch so besser geworden
wäre, notwendig seinem Buche schaden muss. Der erste Eindruck findet uns willig,
und der Mensch ist gemacht, dass man ihn das Abenteuerlichste überreden kann;
das haftet aber auch gleich so fest, und wehe dem, der es wieder auskratzen
und austilgen will!

Am 18. August

Musste denn das so sein, dass das, was des Menschen Glückseligkeit macht, wieder
die Quelle seines Elendes würde?

Das volle, warme Gefühl meines Herzens an der lebendigen Natur, das mich mit
so vieler Wonne überströmte, das rings umher die Welt mir zu einem Paradiese
schuf, wird mir jetzt zu einem unerträglichen Peiniger, zu einem quälenden Geist,
der mich auf allen Wegen verfolgt. Wenn ich sonst vom Felsen über den Fluss bis
zu jenen Hügeln das fruchtbare Tal überschaute und alles um mich her keimen
und quellen sah; wenn ich jene Berge, vom Fusse bis auf zum Gipfel, mit hohen,
dichten Bäumen bekleidet, jene Täler in ihren mannigfaltigen Krümmungen von den
lieblichsten Wäldern beschattet sah, und der sanfte Fluss zwischen den lispelnden Rohren
dahingleitete und die lieben Wolken abspiegelte, die der sanfte Abendwind am Himmel
herüberwiegte; wenn ich dann die Vögel um mich den Wald beleben hörte, und die Millionen
Mückenschwärme im letzten roten Strahle der Sonne mutig tanzten, und ihr letzter
zuckender Blick den summenden Käfer aus seinem Grase befreite, und das Schwirren und
Weben um mich her mich auf den Boden aufmerksam machte, und das Moos, das meinem
harten Felsen seine Nahrung abzwingt, und das Geniste, das den dürren Sandhügel
hinunter wächst, mir das innere, glühende, heilige Leben der Natur eröffnete: wie
fasste ich das alles in mein warmes Herz, fühlte mich in der überfliessenden Fülle
wie vergöttert, und die herrlichen Gestalten der unendlichen Welt bewegten
sich allbelebend in meiner Seele. Ungeheure Berge umgaben mich, Abgründe lagen
vor mir, und Wetterbäche stürzten herunter, die Flüsse strömten unter mir, und
Wald und Gebirg erklang; und ich sah sie wirken und schaffen ineinander in den
Tiefen der Erde, alle die unergründlichen Kräfte; und nun über der Erde und unter
dem Himmel wimmeln die Geschlechter der mannigfaltigen Geschöpfe. Alles, alles
bevölkert mit tausendfachen Gestalten; und die Menschen dann sich in Häuslein
zusammen sichern und sich annisten und herrschen in ihrem Sinne über die weite
Welt! Armer Tor! Der du alles so gering achtest, weil du so klein bist.—vom
unzugänglichen Gebirge über die Einöde, die kein Fuss betrat, bis ans Ende des unbekannten
Ozeans weht der Geist des Ewigschaffenden und freut sich jedes Staubes, der ihn
vernimmt und lebt.—ach damals, wie oft habe ich mich mit Fittichen eines Kranichs,
der über mich hin flog, zu dem Ufer des ungemessenen Meeres gesehnt, aus dem
schäumenden Becher des Unendlichen jene schwellende Lebenswonne zu trinken und nur
einen Augenblick in der eingeschränkten Kraft meines Busens einen Tropfen der
Seligkeit des Wesens zu fühlen, das alles in sich und durch sich hervorbringt.

Bruder, nur die Erinnerung jener Stunden macht mir wohl. Selbst diese Anstrengung,
jene unsäglichen Gelüste zurückzurufen, wieder auszusprechen, hebt meine Seele
über sich selbst und lässt mich dann das Bange des Zustandes doppelt empfinden,
der mich jetzt umgibt.

Es hat sich vor meiner Seele wie ein Vorhang weggezogen, und der Schauplatz
des unendlichen Lebens verwandelt sich vor mir in den Abgrund des ewig offenen
Grabes. Kannst du sagen: Das ist! Da alles vorübergeht? Da alles mit der
Wetterschnelle vorüberrollt, so selten die ganze Kraft seines Daseins ausdauert, ach, in
den Strom fortgerissen, untergetaucht und an Felsen zerschmettert wird? Da ist
kein Augenblick, der nicht dich verzehrte und die Deinigen um dich her, kein
Augenblick, da du nicht ein Zerstörer bist, sein musst; der harmloseste Spaziergang
kostet tausend armen Würmchen das Leben, es zerrüttet ein Fusstritt die mühseligen
Gebäude der Ameisen und stampft eine kleine Welt in ein schmähliches Grab. Ha!
Nicht die grosse, seltne Not der Welt, diese Fluten, die eure Dörfer wegspülen,
diese Erdbeben, die eure Städte verschlingen, rühren mich; mir untergräbt das
Herz die verzehrende Kraft, die in dem All der Natur verborgen liegt; die
nichts gebildet hat, das nicht seinen Nachbar, nicht sich selbst zerstörte. Und
so taumle ich beängstigt. Himmel und Erde und ihre webenden Kräfte um mich
her: ich sehe nichts als ein ewig verschlingendes, ewig wiederkäuendes
Ungeheuer.

Am 21. August

Umsonst strecke ich meine Arme nach ihr aus, morgens, wenn ich von schweren
Träumen aufdämmere, vergebens suche ich sie nachts in meinem Bette, wenn mich ein
glücklicher, unschuldiger Traum getäuscht hat, als säss' ich neben ihr auf der Wiese und
hielt' ihre Hand und deckte sie mit tausend Küssen. Ach, wenn ich dann noch halb
im Taumel des Schlafes nach ihr tappe und drüber mich ermuntere—ein Strom von
Tränen bricht aus meinem gepressten Herzen, und ich weine trostlos einer finstern
Zukunft entgegen.

Am 22. August

Es ist ein Unglück, Wilhelm, meine tätigen Kräfte sind zu einer unruhigen
Lässigkeit verstimmt, ich kann nicht müssig sein und kann doch auch nichts tun. Ich
habe keine Vorstellungskraft, kein Gefühl an der Natur, und die Bücher ekeln
mich an. Wenn wir uns selbst fehlen, fehlt uns doch alles. Ich schwöre dir,
manchmal wünschte ich, ein Tagelöhner zu sein, um nur des Morgens beim Erwachen
eine Aussicht auf den künftigen Tag, einen Drang, eine Hoffnung zu haben. Oft
beneide ich Alberten, den ich über die Ohren in Akten begraben sehe, und bilde mir
ein, mir wäre wohl, wenn ich an seiner Stelle wäre! Schon etlichemal ist mir's
so aufgefahren, ich wollte dir schreiben und dem Minister, um die Stelle bei
der Gesandtschaft anzuhalten, die, wie du versicherst, mir nicht versagt
werden würde. Ich glaube es selbst. Der Minister liebt mich seit langer Zeit,
hatte lange mir angelegen, ich sollte mich irgendeinem Geschäfte widmen; und
eine Stunde ist mir's auch wohl drum zu tun. Hernach, wenn ich wieder dran
denke und mir die Fabel vom Pferde einfällt, das, seiner Freiheit ungeduldig,
sich Sattel und Zeug auflegen lässt und zuschanden geritten wird—ich weiss nicht,
was ich soll.—und, mein Lieber! Ist nicht vielleicht das Sehnen in mir nach
Veränderung des Zustands eine innere, unbehagliche Ungeduld, die mich überallhin
verfolgen wird?

Am 28. August

Es ist wahr, wenn meine Krankheit zu heilen wäre, so würden diese Menschen es
tun. Heute ist mein Geburtstag, und in aller Frühe empfange ich ein Päckchen
von Alberten. Mir fällt beim Eröffnen sogleich eine der blassroten Schleifen in
die Augen, die Lotte vor hatte, als ich sie kennen lernte, und um die ich sie
seither etlichemal gebeten hatte. Es waren zwei Büchelchen in Duodez dabei, der
kleine Wetsteinische Homer, eine Ausgabe, nach der ich so oft verlangt, um mich
auf dem Spaziergange mit dem Ernestischen nicht zu schleppen. Sieh! So kommen
sie meinen Wünschen zuvor, so suchen sie alle die kleinen Gefälligkeiten der
Freundschaft auf, die tausendmal werter sind als jene blendenden Geschenke, wodurch uns
die Eitelkeit des Gebers erniedrigt. Ich küsse diese Schleife tausendmal, und
mit jedem Atemzuge schlürfe ich die Erinnerung jener Seligkeiten ein, mit
denen mich jene wenigen, glücklichen, unwiederbringlichen Tage überfüllten.
Wilhelm, es ist so, und ich murre nicht, die Blüten des Lebens sind nur
Erscheinungen! Wie viele gehn vorüber, ohne eine Spur hinter sich zu lassen, wie wenige
setzen Frucht an, und wie wenige dieser Früchte werden reif! Und doch sind deren
noch genug da; und doch—o mein Bruder!—können wir gereifte Früchte
vernachlässigen, verachten, ungenossen verfaulen lassen?

Lebe wohl! Es ist ein herrlicher Sommer; ich sitze oft auf den Obstbäumen in
Lottens Baumstück mit dem Obstbrecher, der langen Stange, und hole die Birnen aus
dem Gipfel. Sie steht unten und nimmt sie ab, wenn ich sie ihr herunterlasse.

Am 30. August

Unglücklicher! Bist du nicht ein Tor? Betriegst du dich nicht selbst? Was soll diese
tobende, endlose Leidenschaft? Ich habe kein Gebet mehr als an sie; meiner
Einbildungskraft erscheint keine andere Gestalt als die ihrige, und alles in der Welt um
mich her sehe ich nur im Verhältnisse mit ihr. Und das macht mir denn so manche
glückliche Stunde—bis ich mich wieder von ihr losreissen muss! Ach Wilhelm! Wozu mich
mein Herz oft drängt!—wenn ich bei ihr gesessen bin, zwei, drei Stunden, und
mich an ihrer Gestalt, an ihrem Betragen, an dem himmlischen Ausdruck ihrer
Worte geweidet habe, und nun nach und nach alle meine Sinne aufgespannt werden,
mir es düster vor den Augen wird, ich kaum noch höre, und es mich an die
Gurgel fasst wie ein Meuchelmörder, dann mein Herz in wilden Schlägen den
bedrängten Sinnen Luft zu machen sucht und ihre Verwirrung nur vermehrt—Wilhelm, ich
weiss oft nicht, ob ich auf der Welt bin! Und—wenn nicht manchmal die Wehmut das
Übergewicht nimmt und Lotte mir den elenden Trost erlaubt, auf ihrer Hand meine
Beklemmung auszuweinen,—so muss ich fort, muss hinaus, und schweife dann weit im Felde
umher; einen jähen Berg zu klettern ist dann meine Freude, durch einen unwegsamen
Wald einen Pfad durchzuarbeiten, durch die Hecken, die mich verletzen, durch
die Dornen, die mich zerreissen! Da wird mir's etwas besser! Etwas! Und wenn
ich vor Müdigkeit und Durst manchmal unterwegs liegen bleibe, manchmal in der
tiefen Nacht, wenn der hohe Vollmond über mir steht, im einsamen Walde auf einen
krumm gewachsenen Baum mich setze, um meinen verwundeten Sohlen nur einige
Linderung zu verschaffen, und dann in einer ermattenden Ruhe in dem Dämmerschein
hinschlummre! O Wilhelm! Die einsame Wohnung einer Zelle, das härene Gewand und der
Stachelgürtel wären Labsale, nach denen meine Seele schmachtet. Adieu! Ich sehe dieses
Elendes kein Ende als das Grab.

Am 3. September

Ich muss fort! Ich danke dir, Wilhelm, dass du meinen wankenden
Entschluss bestimmt hast. Schon vierzehn Tage gehe ich mit dem
Gedanken um, sie zu verlassen. Ich muss fort. Sie ist wieder in der
Stadt bei einer Freundin. Und Albert—und—ich muss fort!

Am 10. September

Das war eine Nacht! Wilhelm! Nun überstehe ich alles. Ich werde sie nicht
wiedersehn! O dass ich nicht an deinen Hals fliegen, dir mit tausend Tränen und
Entzückungen ausdrücken kann, mein Bester, die Empfindungen, die mein Herz bestürmen.
Hier sitze ich und schnappe nach Luft, suche mich zu beruhigen, erwarte den
Morgen, und mit Sonnenaufgang sind die Pferde bestellt.

Ach, sie schläft ruhig und denkt nicht, dass sie mich nie wieder sehen wird. Ich
habe mich losgerissen, bin stark genug gewesen, in einem Gespräch von zwei
Stunden mein Vorhaben nicht zu verraten. Und Gott, welch ein Gespräch!

Albert hatte mir versprochen, gleich nach dem Nachtessen mit Lotten im Garten zu
sein. Ich stand auf der Terrasse unter den hohen Kastanienbäumen und sah der
Sonne nach, die mir nun zum letztenmale über dem lieblichen Tale, über dem
sanften Fluss unterging. So oft hatte ich hier gestanden mit ihr und eben dem
herrlichen Schauspiele zugesehen, und nun—ich ging in der Allee auf und ab, die mir
so lieb war; ein geheimer sympathetischer Zug hatte mich hier so oft
gehalten, ehe ich noch Lotten kannte, und wie freuten wir uns, als wir im Anfang
unserer Bekanntschaft die wechselseitige Neigung zu diesem Plätzchen entdeckten,
das wahrhaftig eins von den romantischsten ist, die ich von der Kunst
hervorgebracht gesehen habe.

Erst hast du zwischen den Kastanienbäumen die weite Aussicht—Ach, ich erinnere
mich, ich habe dir, denk' ich, schon viel davon geschrieben, wie hohe
Buchenwände einen endlich einschliessen und durch ein daranstossendes Boskett die Allee
immer düsterer wird, bis zuletzt alles sich in ein geschlossenes Plätzchen
endigt, das alle Schauer der Einsamkeit umschweben. Ich fühle es noch, wie
heimlich mir's ward, als ich zum erstenmale an einem hohen Mittage hineintrat; ich
ahnete ganz leise, was für ein Schauplatz das noch werden sollte von Seligkeit
und Schmerz.

Ich hatte mich etwa eine halbe Stunde in den schmachtenden, süssen Gedanken des
Abscheidens, des Wiedersehens geweidet, als ich sie die Terrasse heraufsteigen hörte.
Ich lief ihnen entgegen, mit einem Schauer fasste ich ihre Hand und küsste sie.
Wir waren eben heraufgetreten, als der Mond hinter dem buschigen Hügel
aufging; wir redeten mancherlei und kamen unvermerkt dem düstern Kabinette näher.
Lotte trat hinein und setzte sich, Albert neben sie, ich auch; doch meine Unruhe
liess mich nicht lange sitzen; ich stand auf, trat vor sie, ging auf und ab,
setzte mich wieder: es war ein ängstlicher Zustand. Sie machte uns aufmerksam auf
die schöne Wirkung des Mondenlichtes, das am Ende der Buchenwände die ganze
Terrasse vor uns erleuchtete: ein herrlicher Anblick, der um so viel frappanter
war, weil uns rings eine tiefe Dämmerung einschloss. Wir waren still, und sie
fing nach einer Weile an: "niemals gehe ich im Mondenlichte spazieren, niemals,
dass mir nicht der Gedanke an meine Verstorbenen begegnete, dass nicht das
Gefühl von Tod, von Zukunft über mich käme". "Wir werden sein!" fuhr sie mit der
Stimme des herrlichsten Gefühls fort; "aber, Werther, sollen wir uns wieder
finden? Wieder erkennen? Was ahnen Sie? Was sagen Sie?"

"Lotte", sagte ich, indem ich ihr die Hand reichte und mir die Augen voll Tränen
wurden,"wir werden uns wiedersehn! Hier und dort wiedersehn!"—ich konnte nicht weiter
reden—Wilhelm, musste sie mich das fragen, da ich diesen ängstlichen Abschied im Herzen
hatte!

"Und ob die lieben Abgeschiednen von uns wissen", fuhr sie fort, "ob sie
fühlen, wann's uns wohl geht, dass wir mit warmer Liebe uns ihrer erinnern? O! Die
Gestalt meiner Mutter schwebt immer um mich, wenn ich am stillen Abend unter ihren
Kindern, unter meinen Kindern sitze und sie um mich versammelt sind, wie sie um sie
versammelt waren. Wenn ich dann mit einer sehnenden Träne gen Himmel sehe und
wünsche, dass sie hereinschauen könnte einen Augenblick, wie ich mein Wort halte,
das ich ihr in der Stunde des Todes gab: die Mutter ihrer Kinder zu sein. Mit
welcher Empfindung rufe ich aus: 'verzeihe mir's, Teuerste, wenn ich ihnen nicht
bin, was du ihnen warst. Ach! Tue ich doch alles, was ich kann; sind sie doch
gekleidet, genährt, ach, und, was mehr ist als das alles, gepflegt und geliebt.
Könntest du unsere Eintracht sehen, liebe Heilige! Du würdest mit dem heissesten
Danke den Gott verherrlichen, den du mit den letzten, bittersten Tränen um die
Wohlfahrt deiner Kinder batest.'"—Sie sagte das! O Wilhelm, wer kann wiederholen,
was sie sagte! Wie kann der kalte, tote Buchstabe diese himmlische Blüte des
Geistes darstellen! Albert fiel ihr sanft in die Rede: "es greift zu stark an,
liebe Lotte! Ich weiss, Ihre Seele hängt sehr nach diesen Ideen, aber ich bitte
Sie".—"O Albert", sagte sie, "ich weiss, du vergissest nicht die Abende, da wir
zusammensassen an dem kleinen, runden Tischchen, wenn der Papa verreist war, und wir die
Kleinen schlafen geschickt hatten. Du hattest oft ein gutes Buch und kamst so
selten dazu, etwas zu lesen—war der Umgang dieser herrlichen Seele nicht mehr als
alles? Die schöne, sanfte, muntere und immer tätige Frau! Gott kennt meine
Tränen, mit denen ich mich oft in meinem Bette vor ihn hinwarf: er möchte mich ihr
gleich machen".

"Lotte!" rief ich aus, indem ich mich vor sie hinwarf, ihre Hand nahm und mit
tausend Tränen netzte, "Lotte! Der Segen Gottes ruht über dir und der Geist deiner
Mutter!" "Wenn Sie sie gekannt hätten", sagte sie, indem sie mir die Hand
drückte,—"sie war wert, von Ihnen gekannt zu sein!"—ich glaubte zu vergehen.

Nie war ein grösseres, stolzeres Wort über mich ausgesprochen worden—und sie
fuhr fort:"und diese Frau musste in der Blüte ihrer Jahre dahin, da ihr jüngster
Sohn nicht sechs Monate alt war! Ihre Krankheit dauerte nicht lange; sie war
ruhig, hingegeben, nur ihre Kinder taten ihr weh, besonders das kleine. Wie es
gegen das Ende ging und sie zu mir sagte: 'bringe mir sie herauf!' und wie ich
sie hereinführte, die kleinen, die nicht wussten, und die ältesten, die ohne
Sinne waren, wie sie ums Bette standen, und wie sie die Hände aufhob und über
sie betete, und sie küsste nach einander und sie wegschickte und zu mir sagte:
'sei ihre Mutter!'—Ich gab ihr die Hand drauf!—'Du versprichst viel, meine
Tochter', sagte sie, 'das Herz einer Mutter und das Aug' einer Mutter. Ich habe oft
an deinen dankbaren Tränen gesehen, dass du fühlst, was das sei. Habe es für
deine Geschwister, und für deinen Vater die Treue und den Gehorsam einer Frau.
Du wirst ihn trösten.'—Sie fragte nach ihm, er war ausgegangen, um uns den
unerträglichen Kummer zu verbergen, den er fühlte, der Mann war ganz zerrissen.

Albert, du warst im Zimmer. Sie hörte jemand gehn und fragte und forderte dich zu
sich, und wie sie dich ansah und mich, mit dem getrösteten, ruhigen Blicke, dass
wir glücklich sein, zusammen glücklich sein würden".—Albert fiel ihr um den
Hals und küsste sie und rief: "wir sind es! Wir werden es sein!"—der ruhige
Albert war ganz aus seiner Fassung, und ich wusste nichts von mir selber.
"Werther", fing sie an, "und diese Frau sollte dahin sein! Gott! Wenn ich manchmal
denke, wie man das Liebste seines Lebens wegtragen lässt, und niemand als die
Kinder das so scharf fühlt, die sich noch lange beklagten, die schwarzen Männer
hätten die Mama weggetragen! "sie stand auf, und ich ward erweckt und
erschüttert, blieb sitzen und hielt ihre Hand.—"Wir wollen fort", sagte sie, "es wird
Zeit".—Sie wollte ihre Hand zurückziehen, und ich hielt sie fester.—"wir werden uns
wieder sehen" rief ich, "wir werden uns finden, unter allen Gestalten werden wir
uns erkennen. Ich gehe", fuhr ich fort, "ich gehe willig, und doch, wenn ich
sagen sollte auf ewig, ich würde es nicht aushalten. Leb' wohl, Lotte! Leb'
wohl, Albert! Wir sehn uns wieder".—"Morgen, denke ich", versetzte sie
scherzend.—Ich fühlte das Morgen! Ach, sie wusste nicht, als sie ihre Hand aus der meinen
zog—Sie gingen die Allee hinaus, ich stand, sah ihnen nach im Mondscheine und warf
mich an die Erde und weinte mich aus und sprang auf und lief auf die Terrasse
hervor und sah noch dort unten im Schatten der hohen Lindenbäume ihr weisses Kleid
nach der Gartentür schimmern, ich streckte meine Arme aus, und es verschwand.
EOT;

    /*
    End of the Project Gutenberg EBook of Die Leiden des jungen Werther--Buch 1, by
    Johann Wolfgang von Goethe

    *** END OF THIS PROJECT GUTENBERG EBOOK DIE LEIDEN DES JUNGEN WERTHER ***

    ***** This file should be named 2407-8.txt or 2407-8.zip *****
    This and all associated files of various formats will be found in:
            http://www.gutenberg.org/2/4/0/2407/

    Produced by Michael Pullen, globaltraveler5565@yahoo.com
    with proofreading and correction by Dr. Mary Cicora,
    mcicora@yahoo.com.

    Updated editions will replace the previous one--the old editions
    will be renamed.

    Creating the works from public domain print editions means that no
    one owns a United States copyright in these works, so the Foundation
    (and you!) can copy and distribute it in the United States without
    permission and without paying copyright royalties.  Special rules,
    set forth in the General Terms of Use part of this license, apply to
    copying and distributing Project Gutenberg-tm electronic works to
    protect the PROJECT GUTENBERG-tm concept and trademark.  Project
    Gutenberg is a registered trademark, and may not be used if you
    charge for the eBooks, unless you receive specific permission.  If you
    do not charge anything for copies of this eBook, complying with the
    rules is very easy.  You may use this eBook for nearly any purpose
    such as creation of derivative works, reports, performances and
    research.  They may be modified and printed and given away--you may do
    practically ANYTHING with public domain eBooks.  Redistribution is
    subject to the trademark license, especially commercial
    redistribution.

    *** START: FULL LICENSE ***

    THE FULL PROJECT GUTENBERG LICENSE
    PLEASE READ THIS BEFORE YOU DISTRIBUTE OR USE THIS WORK

    To protect the Project Gutenberg-tm mission of promoting the free
    distribution of electronic works, by using or distributing this work
    (or any other work associated in any way with the phrase "Project
    Gutenberg"), you agree to comply with all the terms of the Full Project
    Gutenberg-tm License (available with this file or online at
    http://gutenberg.org/license).

    Section 1.  General Terms of Use and Redistributing Project Gutenberg-tm
    electronic works

    1.A.  By reading or using any part of this Project Gutenberg-tm
    electronic work, you indicate that you have read, understand, agree to
    and accept all the terms of this license and intellectual property
    (trademark/copyright) agreement.  If you do not agree to abide by all
    the terms of this agreement, you must cease using and return or destroy
    all copies of Project Gutenberg-tm electronic works in your possession.
    If you paid a fee for obtaining a copy of or access to a Project
    Gutenberg-tm electronic work and you do not agree to be bound by the
    terms of this agreement, you may obtain a refund from the person or
    entity to whom you paid the fee as set forth in paragraph 1.E.8.

    1.B.  "Project Gutenberg" is a registered trademark.  It may only be
    used on or associated in any way with an electronic work by people who
    agree to be bound by the terms of this agreement.  There are a few
    things that you can do with most Project Gutenberg-tm electronic works
    even without complying with the full terms of this agreement.  See
    paragraph 1.C below.  There are a lot of things you can do with Project
    Gutenberg-tm electronic works if you follow the terms of this agreement
    and help preserve free future access to Project Gutenberg-tm electronic
    works.  See paragraph 1.E below.

    1.C.  The Project Gutenberg Literary Archive Foundation ("the Foundation"
    or PGLAF), owns a compilation copyright in the collection of Project
    Gutenberg-tm electronic works.  Nearly all the individual works in the
    collection are in the public domain in the United States.  If an
    individual work is in the public domain in the United States and you are
    located in the United States, we do not claim a right to prevent you from
    copying, distributing, performing, displaying or creating derivative
    works based on the work as long as all references to Project Gutenberg
    are removed.  Of course, we hope that you will support the Project
    Gutenberg-tm mission of promoting free access to electronic works by
    freely sharing Project Gutenberg-tm works in compliance with the terms of
    this agreement for keeping the Project Gutenberg-tm name associated with
    the work.  You can easily comply with the terms of this agreement by
    keeping this work in the same format with its attached full Project
    Gutenberg-tm License when you share it without charge with others.

    1.D.  The copyright laws of the place where you are located also govern
    what you can do with this work.  Copyright laws in most countries are in
    a constant state of change.  If you are outside the United States, check
    the laws of your country in addition to the terms of this agreement
    before downloading, copying, displaying, performing, distributing or
    creating derivative works based on this work or any other Project
    Gutenberg-tm work.  The Foundation makes no representations concerning
    the copyright status of any work in any country outside the United
    States.

    1.E.  Unless you have removed all references to Project Gutenberg:

    1.E.1.  The following sentence, with active links to, or other immediate
    access to, the full Project Gutenberg-tm License must appear prominently
    whenever any copy of a Project Gutenberg-tm work (any work on which the
    phrase "Project Gutenberg" appears, or with which the phrase "Project
    Gutenberg" is associated) is accessed, displayed, performed, viewed,
    copied or distributed:

    This eBook is for the use of anyone anywhere at no cost and with
    almost no restrictions whatsoever.  You may copy it, give it away or
    re-use it under the terms of the Project Gutenberg License included
    with this eBook or online at www.gutenberg.org

    1.E.2.  If an individual Project Gutenberg-tm electronic work is derived
    from the public domain (does not contain a notice indicating that it is
    posted with permission of the copyright holder), the work can be copied
    and distributed to anyone in the United States without paying any fees
    or charges.  If you are redistributing or providing access to a work
    with the phrase "Project Gutenberg" associated with or appearing on the
    work, you must comply either with the requirements of paragraphs 1.E.1
    through 1.E.7 or obtain permission for the use of the work and the
    Project Gutenberg-tm trademark as set forth in paragraphs 1.E.8 or
    1.E.9.

    1.E.3.  If an individual Project Gutenberg-tm electronic work is posted
    with the permission of the copyright holder, your use and distribution
    must comply with both paragraphs 1.E.1 through 1.E.7 and any additional
    terms imposed by the copyright holder.  Additional terms will be linked
    to the Project Gutenberg-tm License for all works posted with the
    permission of the copyright holder found at the beginning of this work.

    1.E.4.  Do not unlink or detach or remove the full Project Gutenberg-tm
    License terms from this work, or any files containing a part of this
    work or any other work associated with Project Gutenberg-tm.

    1.E.5.  Do not copy, display, perform, distribute or redistribute this
    electronic work, or any part of this electronic work, without
    prominently displaying the sentence set forth in paragraph 1.E.1 with
    active links or immediate access to the full terms of the Project
    Gutenberg-tm License.

    1.E.6.  You may convert to and distribute this work in any binary,
    compressed, marked up, nonproprietary or proprietary form, including any
    word processing or hypertext form.  However, if you provide access to or
    distribute copies of a Project Gutenberg-tm work in a format other than
    "Plain Vanilla ASCII" or other format used in the official version
    posted on the official Project Gutenberg-tm web site (www.gutenberg.org),
    you must, at no additional cost, fee or expense to the user, provide a
    copy, a means of exporting a copy, or a means of obtaining a copy upon
    request, of the work in its original "Plain Vanilla ASCII" or other
    form.  Any alternate format must include the full Project Gutenberg-tm
    License as specified in paragraph 1.E.1.

    1.E.7.  Do not charge a fee for access to, viewing, displaying,
    performing, copying or distributing any Project Gutenberg-tm works
    unless you comply with paragraph 1.E.8 or 1.E.9.

    1.E.8.  You may charge a reasonable fee for copies of or providing
    access to or distributing Project Gutenberg-tm electronic works provided
    that

    - You pay a royalty fee of 20% of the gross profits you derive from
         the use of Project Gutenberg-tm works calculated using the method
         you already use to calculate your applicable taxes.  The fee is
         owed to the owner of the Project Gutenberg-tm trademark, but he
         has agreed to donate royalties under this paragraph to the
         Project Gutenberg Literary Archive Foundation.  Royalty payments
         must be paid within 60 days following each date on which you
         prepare (or are legally required to prepare) your periodic tax
         returns.  Royalty payments should be clearly marked as such and
         sent to the Project Gutenberg Literary Archive Foundation at the
         address specified in Section 4, "Information about donations to
         the Project Gutenberg Literary Archive Foundation."

    - You provide a full refund of any money paid by a user who notifies
         you in writing (or by e-mail) within 30 days of receipt that s/he
         does not agree to the terms of the full Project Gutenberg-tm
         License.  You must require such a user to return or
         destroy all copies of the works possessed in a physical medium
         and discontinue all use of and all access to other copies of
         Project Gutenberg-tm works.

    - You provide, in accordance with paragraph 1.F.3, a full refund of any
         money paid for a work or a replacement copy, if a defect in the
         electronic work is discovered and reported to you within 90 days
         of receipt of the work.

    - You comply with all other terms of this agreement for free
         distribution of Project Gutenberg-tm works.

    1.E.9.  If you wish to charge a fee or distribute a Project Gutenberg-tm
    electronic work or group of works on different terms than are set
    forth in this agreement, you must obtain permission in writing from
    both the Project Gutenberg Literary Archive Foundation and Michael
    Hart, the owner of the Project Gutenberg-tm trademark.  Contact the
    Foundation as set forth in Section 3 below.

    1.F.

    1.F.1.  Project Gutenberg volunteers and employees expend considerable
    effort to identify, do copyright research on, transcribe and proofread
    public domain works in creating the Project Gutenberg-tm
    collection.  Despite these efforts, Project Gutenberg-tm electronic
    works, and the medium on which they may be stored, may contain
    "Defects," such as, but not limited to, incomplete, inaccurate or
    corrupt data, transcription errors, a copyright or other intellectual
    property infringement, a defective or damaged disk or other medium, a
    computer virus, or computer codes that damage or cannot be read by
    your equipment.

    1.F.2.  LIMITED WARRANTY, DISCLAIMER OF DAMAGES - Except for the "Right
    of Replacement or Refund" described in paragraph 1.F.3, the Project
    Gutenberg Literary Archive Foundation, the owner of the Project
    Gutenberg-tm trademark, and any other party distributing a Project
    Gutenberg-tm electronic work under this agreement, disclaim all
    liability to you for damages, costs and expenses, including legal
    fees.  YOU AGREE THAT YOU HAVE NO REMEDIES FOR NEGLIGENCE, STRICT
    LIABILITY, BREACH OF WARRANTY OR BREACH OF CONTRACT EXCEPT THOSE
    PROVIDED IN PARAGRAPH F3.  YOU AGREE THAT THE FOUNDATION, THE
    TRADEMARK OWNER, AND ANY DISTRIBUTOR UNDER THIS AGREEMENT WILL NOT BE
    LIABLE TO YOU FOR ACTUAL, DIRECT, INDIRECT, CONSEQUENTIAL, PUNITIVE OR
    INCIDENTAL DAMAGES EVEN IF YOU GIVE NOTICE OF THE POSSIBILITY OF SUCH
    DAMAGE.

    1.F.3.  LIMITED RIGHT OF REPLACEMENT OR REFUND - If you discover a
    defect in this electronic work within 90 days of receiving it, you can
    receive a refund of the money (if any) you paid for it by sending a
    written explanation to the person you received the work from.  If you
    received the work on a physical medium, you must return the medium with
    your written explanation.  The person or entity that provided you with
    the defective work may elect to provide a replacement copy in lieu of a
    refund.  If you received the work electronically, the person or entity
    providing it to you may choose to give you a second opportunity to
    receive the work electronically in lieu of a refund.  If the second copy
    is also defective, you may demand a refund in writing without further
    opportunities to fix the problem.

    1.F.4.  Except for the limited right of replacement or refund set forth
    in paragraph 1.F.3, this work is provided to you 'AS-IS' WITH NO OTHER
    WARRANTIES OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO
    WARRANTIES OF MERCHANTIBILITY OR FITNESS FOR ANY PURPOSE.

    1.F.5.  Some states do not allow disclaimers of certain implied
    warranties or the exclusion or limitation of certain types of damages.
    If any disclaimer or limitation set forth in this agreement violates the
    law of the state applicable to this agreement, the agreement shall be
    interpreted to make the maximum disclaimer or limitation permitted by
    the applicable state law.  The invalidity or unenforceability of any
    provision of this agreement shall not void the remaining provisions.

    1.F.6.  INDEMNITY - You agree to indemnify and hold the Foundation, the
    trademark owner, any agent or employee of the Foundation, anyone
    providing copies of Project Gutenberg-tm electronic works in accordance
    with this agreement, and any volunteers associated with the production,
    promotion and distribution of Project Gutenberg-tm electronic works,
    harmless from all liability, costs and expenses, including legal fees,
    that arise directly or indirectly from any of the following which you do
    or cause to occur: (a) distribution of this or any Project Gutenberg-tm
    work, (b) alteration, modification, or additions or deletions to any
    Project Gutenberg-tm work, and (c) any Defect you cause.

    Section  2.  Information about the Mission of Project Gutenberg-tm

    Project Gutenberg-tm is synonymous with the free distribution of
    electronic works in formats readable by the widest variety of computers
    including obsolete, old, middle-aged and new computers.  It exists
    because of the efforts of hundreds of volunteers and donations from
    people in all walks of life.

    Volunteers and financial support to provide volunteers with the
    assistance they need, are critical to reaching Project Gutenberg-tm's
    goals and ensuring that the Project Gutenberg-tm collection will
    remain freely available for generations to come.  In 2001, the Project
    Gutenberg Literary Archive Foundation was created to provide a secure
    and permanent future for Project Gutenberg-tm and future generations.
    To learn more about the Project Gutenberg Literary Archive Foundation
    and how your efforts and donations can help, see Sections 3 and 4
    and the Foundation web page at http://www.pglaf.org.


    Section 3.  Information about the Project Gutenberg Literary Archive
    Foundation

    The Project Gutenberg Literary Archive Foundation is a non profit
    501(c)(3) educational corporation organized under the laws of the
    state of Mississippi and granted tax exempt status by the Internal
    Revenue Service.  The Foundation's EIN or federal tax identification
    number is 64-6221541.  Its 501(c)(3) letter is posted at
    http://pglaf.org/fundraising.  Contributions to the Project Gutenberg
    Literary Archive Foundation are tax deductible to the full extent
    permitted by U.S. federal laws and your state's laws.

    The Foundation's principal office is located at 4557 Melan Dr. S.
    Fairbanks, AK, 99712., but its volunteers and employees are scattered
    throughout numerous locations.  Its business office is located at
    809 North 1500 West, Salt Lake City, UT 84116, (801) 596-1887, email
    business@pglaf.org.  Email contact links and up to date contact
    information can be found at the Foundation's web site and official
    page at http://pglaf.org

    For additional contact information:
         Dr. Gregory B. Newby
         Chief Executive and Director
         gbnewby@pglaf.org

    Section 4.  Information about Donations to the Project Gutenberg
    Literary Archive Foundation

    Project Gutenberg-tm depends upon and cannot survive without wide
    spread public support and donations to carry out its mission of
    increasing the number of public domain and licensed works that can be
    freely distributed in machine readable form accessible by the widest
    array of equipment including outdated equipment.  Many small donations
    ($1 to $5,000) are particularly important to maintaining tax exempt
    status with the IRS.

    The Foundation is committed to complying with the laws regulating
    charities and charitable donations in all 50 states of the United
    States.  Compliance requirements are not uniform and it takes a
    considerable effort, much paperwork and many fees to meet and keep up
    with these requirements.  We do not solicit donations in locations
    where we have not received written confirmation of compliance.  To
    SEND DONATIONS or determine the status of compliance for any
    particular state visit http://pglaf.org

    While we cannot and do not solicit contributions from states where we
    have not met the solicitation requirements, we know of no prohibition
    against accepting unsolicited donations from donors in such states who
    approach us with offers to donate.

    International donations are gratefully accepted, but we cannot make
    any statements concerning tax treatment of donations received from
    outside the United States.  U.S. laws alone swamp our small staff.

    Please check the Project Gutenberg Web pages for current donation
    methods and addresses.  Donations are accepted in a number of other
    ways including checks, online payments and credit card donations.
    To donate, please visit: http://pglaf.org/donate

    Section 5.  General Information About Project Gutenberg-tm electronic
    works.

    Professor Michael S. Hart is the originator of the Project Gutenberg-tm
    concept of a library of electronic works that could be freely shared
    with anyone.  For thirty years, he produced and distributed Project
    Gutenberg-tm eBooks with only a loose network of volunteer support.

    Project Gutenberg-tm eBooks are often created from several printed
    editions, all of which are confirmed as Public Domain in the U.S.
    unless a copyright notice is included.  Thus, we do not necessarily
    keep eBooks in compliance with any particular paper edition.

    Most people start at our Web site which has the main PG search facility:

         http://www.gutenberg.org

    This Web site includes information about Project Gutenberg-tm,
    including how to make donations to the Project Gutenberg Literary
    Archive Foundation, how to help produce our new eBooks, and how to
    subscribe to our email newsletter to hear about new eBooks.
    */
}
