<?php
/**
 * @license MIT
 *
 * Modified by impress-org on 25-September-2024 using Strauss.
 * @see https://github.com/BrianHenryIE/strauss
 */

namespace Give\Vendors\Faker\Provider\nl_BE;

class Text extends \Give\Vendors\Faker\Provider\Text
{
    /**
     * The Project Gutenberg EBook of De legende en de heldhaftige, vroolijke en
     * roemrijke daden van Uilenspiegel en Lamme Goedzak in Vlaanderenland en elders, by Charles de Coster
     *
     * This eBook is for the use of anyone anywhere at no cost and with
     * almost no restrictions whatsoever.  You may copy it, give it away or
     * re-use it under the terms of the Project Gutenberg License included
     * with this eBook or online at www.gutenberg.org/license
     *
     *
     * Title: De legende en de heldhaftige, vroolijke en roemrijke daden
     * van Uilenspiegel en Lamme Goedzak in Vlaanderenland en elders
     *
     * Author: Charles de Coster
     *
     * Release Date: July 3, 2005 [EBook #11208]
     * [Last updated: March 14, 2015]
     *
     * Language: Dutch
     *
     * @see http://www.gutenberg.org/cache/epub/11208/pg11208.txt
     *
     * @var string
     */
    protected static $baseText = <<<'EOT'
  De legende en de heldhaftige,
                    vroolijke en roemrijke daden van
                     Uilenspiegel en Lamme Goedzak
                      in Vlaanderenland en elders


                                  door

                           Charles de Coster



                     in het Vlaamsch vertaald door

                 Richard Delbecq   en   René de Clercq
                 (voor het proza)     (voor de liederen)

                               Derde druk
                     met 22 platen van Jules Gondry
                                  1919







KORTE LEVENSBESCHRIJVING VAN CHARLES DE COSTER

Bewerkt naar Ch. Potvin, Francis Nautet enz.


Charles-Theodore-Henri De Coster werd geboren te München, den 20n
Augustus 1827. Zijn vader was intendant van graaf Charles Mercy
d'Argenteau, aartsbisschop van Tyrus, die peter des kunstenaars was en
hem de markiezin Henriette de la Tour Dupin, vrouw van den Franschen
gezant te Turijn, tot meter gaf.

De kleine De Coster, een engeltje van een knaap, sleet dus zijne
eerste levensjaren in het paleis van den aartsbisschop, midden in
weelde, in bloemen, geliefkoosd door zijne ouders en zijnen peter. Zijn
eerste opvoeding was dus zeer aristocratisch en die indrukken blijven
gewoonlijk onuitwischbaar.

Doch weinig tijds nadien verandert dit alles. Zijne ouders verlaten
München en gaan naar Brussel, waar hun tweede kind ter wereld komt;
dan sterft zijn vader te Ieperen, bij zijn broeder, die daar geneesheer
was. Zijn moeder keert terug naar Brussel bij hare zuster en hare
kinderen.

Charles was reeds in eene kostschool te Etterbeek, waar "ik mij zal
moeten schikken naar den wil van een ander", zegt hij, "na zoolang
mijn zin te hebben gedaan". Als hij uit de kostschool komt, is het
om in het "Collège Saint-Michel" te treden, waar men een oogenblik
hoopte dat het kind, dat reeds de droomerijen boven de droge studiën
verkoos, zich aan het priesterschap zou wijden.

Eerst dacht hij in de balie te treden, doch een vriend deed hem
opmerken dat de rechten en de kunst moeilijk samengaan, en De Coster,
geholpen door machtige beschermers, aanvaardde eene bediening in de
"Société Générale".

In 't lot gevallen, stelde zijne moeder eenen plaatsvervanger, die
wegliep; na eenige dagen in het regiment, bij zijn kolonel, vertoefd
te hebben, "om den plaatsvervanger te vervangen", maakte de jonge
bediende op zijne beurt van de gelegenheid gebruik om zijne plaats
te ontloopen. "Het ambtenaarsleven bevalt mij in het geheel niet",
zegde hij. In de Bank voelde hij zich als een vreemdeling te midden
van de bureaucraten. Hij stikte in die atmosfeer en "overigens wilde
hij voor zich zelven werken". De letterkundige roeping verkreeg de
bovenhand en hij trad in 1850 in de Hoogeschool van Brussel, waar
hij het diploma van candidaat in de letteren behaalde.

Maar De Coster gaf aan de Hoogeschool noch zijn hart, noch zijnen
geest, noch zijne pen. Toen hij ze verliet, was hij noch doctor,
noch professor, noch dagbladschrijver, noch tooneeldichter. Maar hij
was kunstenaar, meer dan ooit.

Vervolgens wilde hij in de redactie van een dagblad treden, maar hij
aanbad het schoone boven alles en weigerde "een werktuig te maken
van zijne pen".

Dan begint een jammerlijk leven van voortdurenden tegenspoed en
onbegrepen arbeid. In 1856 weigert hij eene plaats bij een makelaar
in wijnen,--alles wat men hem aanbood.

Om het even, de jonge kunstenaar heeft wilskracht en, door al zijn
kommer heen, maakt hij eervol naam in de Fransche letterkunde. Buiten
en behalve menigvuldige gewaardeerde bijdragen in dagbladen en
tijdschriften, levert hij, in 1856, les Frères de la bonne trogne
(Brabantsche legende); in 1857, de Légendes flamandes et wallones,
die een ongemeenen bijval ontmoeten en door de Fransche pers vleiend
beoordeeld worden; in 1861, de Contes brabançons.

Zijn peter, de aartsbisschop, had hem sedert lang zijne bescherming
onttrokken, die hem zeker ware bijgebleven, hadde De Coster zijne
studiën in de Hoogeschool van Leuven willen doen. Hij had Brussel
verkozen, waar hij vrienden vond. Dat was eene keuze doen voor de
algeheele vrijheid des geestes. In 1863 wordt het petekind van den
aartsbisschop van Tyrus lid van de Vrije Gedachte van Brussel. Hij was
toen in den vollen bloei van zijn eersten bijval en gansch vervoerd
door zijne liefde voor het schoone.

Zijne liefde voor het volk, voor het wakkere Vlaamsche volk, stuwt
hem voorwaarts en houdt zijn machtig genie bezig. De schilder Dillens
zijn vriend, bezat in zijn werkhuis een verzameling oude Vlaamsche
boeken. De Coster en Dillens doen verscheidene reizen door Zeeland
en Vlaanderen: de "Legende van Uilenspiegel" was van dan af geboren
in De Coster's brein.

De Legende van Uilenspiegel en Lamme Goedzak, in de letterwereld
met ongeduld verwacht, verscheen in 1867 in een prachtige uitgave,
opgeluisterd met twee en dertig etsen van negentien talentvolle
kunstenaars.

Ziehier wat onder meer drie Fransche bladen zeiden van dat gewrocht:

La Liberté van 18 December 1868: "'t Is een heldendicht in proza,
waarin het bloed zoo rijkelijk vloeit als het bier. Men zou zeggen
een kermis rondom eenen brandstapel".

Le Constitutionnel, 9 December 1868, wijdde drie groote kolommen
aan Uilenspiegel, waarin de recensent het boek met Goethe's Faust
vergelijkt.

Le Corsaire: "'t Is een heldendicht in proza, 't is de verheerlijking
van den Vlaamschen geest".

Heel de Fransche pers deelde dit gevoelen en drukte hare bewondering
in de vleiendste artikelen uit.

Onze Busken Huët getuigde: "Hollanders noch Vlamingen bezitten een
werk over de XVIe eeuw in Vlaanderen, dat met het meesterwerk van De
Coster kan vergeleken worden".

Na Uilenspiegel verscheen nog: Voyage de noce (1872) en le Mariage
de Toulet (1879).

Edoch De Coster, die in het volle succes van de Légendes flamandes
zijne vriendin verloren had, zag zich op 29 Juli 1869, wanneer
Uilenspiegel zoo gunstig onthaald werd, nu nog zijne moeder ontrukken.

Die ramp schokte hem diep in zijn reeds droevig bestaan, want De Coster
leefde veelal in armoede, niettegenstaande zijn talent en de gunst
waarmede zijne werken ontvangen werden. Schrale schrijversrechten,
karige toelagen, luttel betaalde lessen moesten hem vrijwaren voor
ellende. Hij kloeg dan ook, steeds denzelfden strijd te moeten
herbeginnen. In 1870 schreef hij: "Hoewel ik veel gewerkt heb
uit lust en uit liefde, begrijp ik, sedert minder dan drie jaar,
de schrikverwekkende waarde van het geld en de noodwendigheid van
een arbeid, die, genoegzaam betaald, den mensch, met den welstand,
ook vrijheid en vreugde schenkt".

Maar daarom legde hij zijne fierheid niet af.

Toen eindelijk de regeering, een tiental jaren vóór zijnen dood, er
aan dacht de verstandelijke hulpmiddelen van den grooten schrijver
ten behoeve van het onderwijs aan te wenden, was het te laat. Hij
stak zoo diep in schulden, dat zijne benoeming geen anderen uitslag
opleverde dan eene opschudding te verwekken onder zijne schuldeischers,
die zijn traktement aansloegen en hunne prooi niet meer loslieten.

Toen hij stierf, op 7 Mei 1879, verkeerde hij in de diepste ellende.

                   *       *       *       *       *

Den 22n Juli 1894 werd door het gemeentebestuur van Eisene een
eenvoudig doch treffend gedenkteeken van den beeldhouwer Samuel ter
nagedachtenis van De Coster ingehuldigd.







DE LAATSTE OOGENBLIKKEN VAN CHARLES DE COSTER.


Charles De Coster stierf op 7 Mei 1879, te Elsene, in het huis, dat
den hoek uitmaakt van de Gewijde-Boomstraat, en toen gehuurd werd
door een fruitverkooper. Heel de woning van den grooten kunstenaar
bestond uit de twee kamers op de eerste verdieping: de grootste was
zijn werkkabinet, de andere zijne slaapkamer; daarin stonden een
ijzeren bed, een kleine tafel, een houten kast, eenige stoelen.

Hij had zich den dag te voren te bed gelegd: de pisvloed waaraan
hij leed, en diens noodlottige gezellin, de longtering, waren
plotseling verergerd. Charles De Coster nam zelden zijne toevlucht tot
geneesheeren; een zijner vrienden nochtans, M. Kirkpatrick, verschrikt
over den voortgang van de kwaal, had den heer dokter Vaucleroy,
geneesheer aan de Krijgsschool, ontboden. Toen deze kwam, vond hij
aan de sponde van den zieke eene oppasster, die De Coster in zijn
verheven en grenzenloos medelijden met de onterfden en ongelukkigen,
bij zich genomen had. Deze arme vrouw, die bij den zieltogende waakte,
was zelve het toonbeeld des doods; heel haar aangezicht was ingevreten
door zweren. De geneesheer ging heen zonder hoop den zieke te redden,
maar hij voorzag toch geen dreigenden dood: hij zou 's anderen daags
namiddags terugkomen.

's Anderen daags scheen De Coster zijn nakend einde niet bewust te
zijn, want hij vroeg noch naar zijnen schoonbroeder, noch naar zijne
zuster, die hij aanbad. Doch hij wilde zich omringen van vrienden,
als om zijn lichaam en zijn hart te verwarmen. Hij liet deze roepen,
die in de nabijheid woonden: zoo werden Félix Bouré, de beeldhouwer,
en later ik zelf geroepen. Bouré was ziek; hij verwittigde zijn
broeder, mede een vriend van De Coster: de heer Bouré vond in het
werkkabinet kapitein Mertens die, diep bedroefd, in de kamer van den
zieke niet dorst gaan. Deze betoonde een levendige erkentelijkheid
aan den heer Bouré, die zijn bed wat gemakkelijker schikte en hem te
drinken gaf. Toen ik en mijne vrouw op onze beurt kwamen, richtte De
Coster zich op in zijn bed en herkende mij heel goed. Kloekmoedig in
het aanschijn van den dood, had hij nog het gedacht om den heer Bouré
en mij aan elkander voor te stellen. De heer Bouré bevestigde mij dat
hij, toespeling makend op mijn beroep van advocaat, eenige Latijnsche
woorden mompelde. Maar zijn blik verduisterde, zijne ademhaling werd
hijgend; toen mijne vrouw hem naderde om zijn hoofdkussen te schikken
en zijn voorhoofd te verfrisschen, moest hij eene inspanning doen om
heur te herkennen: "Hoe, gij ook, mevrouw, ik dank u zeer!" Daarna
werd de ademhaling flauwer, een laatste naam, die zijner zuster,
kwam pijnlijk over zijne lippen: "Ca...ro...line". Het was zijn hart,
dat ontsnapte. Het was twee uren.


Hector Denis.







VOORREDE VAN DEN UIL [1]


Heeren kunstenaars, heeren uitgevers, heer dichter, ik heb u eenige
aanmerkingen te doen aangaande uwe eerste uitgave. Hoe! in dat
lijvige boek, in dien olifant dien gij met achttienen naar den roem
tracht te drijven, hebt gij het kleinste plaatsje niet gegund aan
den vogel van Minerva, den wijzen, omzichtigen uil! In Duitschland
en in dat Vlaanderen dat gij zoozeer bemint, reis ik gedurig op den
schouder van Uilenspiegel, die maar aldus genoemd wordt, omdat zijn
naam bediedt: Uil en Spiegel, wijsheid en komediespel. Die van Damme,
waar hij geboren werd, naar men zegt, spreken uit: Ulenspiegel, door
samentrekking en de gewoonte die zij hebben u in stee van Ui uit te
spreken. Dat is hunne zaak.

Gij hebt eene andere uitlegging uitgedacht: Ulen voor U lieden Spiegel,
de Spiegel van U, boeren en heeren, geregeerden en regeerders, de
spiegel van de dwaasheden, de belachelijkheden, de misdaden van een
tijdstip. Dat was vernuftig, maar onredelijk. Men moet nooit afbreken
met den slenter.

Misschien vondt gij het vreemd de wijsheid te verbeelden door een--naar
uwe meening--treurigen, belachelijken vogel, een gebrilden schoolvos,
een kermis-grappenmaker, een vriend der duisternis, dien men niet
hoort vliegen en die doodt zonder dat men hem hoort komen, evenals de
Dood. Nochtans gelijkt gij op mij, huichelaars die lacht met mij. In
menige uwer nachten stroomde het bloed onder de slagen der Moord,
die op vilten zolen liep, opdat men heur ook niet zoude hooren komen.

Brak, in uw aller geschiedenis, nooit geen bleeke dageraad aan, die met
zijn vale schemering de met lijken van mannen, vrouwen en kinderen
bedekte straatsteenen verlichtte? Waarvan leeft uwe Staatkunde,
sedert dat gij over de wereld regeert? Van worgen en moorden.

Ik, uil, de leelijke uil, ik dood om mij te spijzen, om mijne jongen
te spijzen, ik dood niet om te dooden. Verwijt gij mij de vogeltjes
op te peuzelen, dan kan ik u even goed de slachting verwijten die
gij aanricht onder alles wat leeft. Gij hebt boeken geschreven waarin
gij met verteedering spreekt over de lichtheid van de vogelen, over
hunne minnarijen, over hunne schoonheid, over de kunst waarmede zij hun
nestje bouwen, en over de angsten des moederschaps, vervolgens zegt gij
met welke saus men ze moet opdienen en in welke maand van het jaar zij
de vetste stoverij opleveren. Ik, ik maak geen boeken, God beware mij
daarvoor, anders schreef ik dat, als gij den vogel niet kunt opeten,
gij het nest opeet, uit vreeze dat gij een hap zoudt verliezen.

Wat u betreft, onbesuisde dichter, het was uw belang mij terug te
brengen in uw werk, waarvan ten minste twintig hoofdstukken mij
toebehooren [2] de andere laat ik u in onbetwisten eigendom. Men mag
toch wel het volstrekt meesterschap behouden over de domheden die
men laat drukken. Schreeuwende dichter, gij slaat links en rechts op
die welke gij de beulen des vaderlands heet, gij stelt Keizer Karel
en Philips II aan den schandpaal der geschiedenis; gij zijt geen
uil; gij zijt niet voorzichtig. Weet gij of er geen Keizer Karel
of geen Philips II op de wereld meer bestaan? Vreest gij niet dat
eene opmerkzame censuur uit den buik van uwen olifant toespelingen
op doorluchtige tijdgenooten vinde? Waarom laat gij dien Keizer en
dien Koning niet slapen in hun graf? Waarom moet gij al die majesteit
aanblaffen? Die het zweerd trekt, zal door het zweerd vergaan. Er zijn
menschen die het u nooit zullen vergeven, ik ook vergeef het u niet,
gij stoort mijne burgerlijke spijsvertering.

Wat beteekent die bestendige tegenstelling tusschen een verfoeiden
koning, wreedaardig van jongs af--daarom is het een mensch--en
dat Vlaamsche volk, dat gij ons wilt voorstellen als heldhaftig,
gulhartig, eerlijk en werkzaam? Wie zegt u dat die koning slecht en
dat volk goed was? Wijselijk zou ik u het tegenovergestelde kunnen
bewijzen. Uwe hoofdpersonages zijn dwazen of zotten, zonder er een
uit te zonderen: uw deugniet van Uilenspiegel neemt de wapenen op
voor de gewetensvrijheid; zijn vader Klaas sterft, laat zich levend
verbranden voor zijne godsdienstige overtuiging; zijne moeder, Soetkin,
kwijnt van verdriet en sterft ten gevolge van de foltering, om een
fortuin voor haren zoon te bewaren; uw Lamme Goedzak stapt recht door
het leven alsof het al was, goed en eerlijk op deze wereld te zijn;
uwe kleine Nele, die niet leelijk is, bemint in heel haar leven maar
een enkelen man.... Waar ziet men nog zulke dingen? Ik zou u beklagen,
zoo ge mij niet deedt lachen.

Nochtans moet ik bekennen dat naast die bespottelijke personages, er
wel eenige zijn die ik geerne onder mijne boezemvrienden zoude nemen:
uwe Spaansche huurlingen, uwe monniken die het gemeen verbranden,
uwe Gilline, spionneerster der Inquisitie, uw gierige vischverkooper,
aanklager en weerwolf, uw edelman die 's nachts duivel speelt om eene
onnoozele te verleiden, en vooral dien omzichtigen Philips II, die,
geld noodig hebbende, de heilige beelden in de kerken doet breken,
ten einde een opstand te beteugelen waarvan hij de wijze aanstoker
was. Minder kan men toch niet, als men geroepen is te erven van
degenen die men doodt.

Maar ik geloof dat al mijne woorden verloren moeite zijn. Gij weet
niet wat een uil is. Ik ga het u zeggen.

De uil is hij die in 't geniep, eerroof stookt onder de lieden
die hem hinderlijk zijn en die, als men hem vraagt of hij de
verantwoordelijkheid over zijne gezegden wil dragen, voorzichtig
antwoordt: Ik bevestig niets, Men heeft mij gezegd.... Hij weet wel
dat Men onvindbaar is.

Uil is hij die een eerlijk gezin binnendringt, zich aanstelt als
een trouwer, een meisje verleidt, geld ontleent, soms zijne schuld
betaalt en henengaat als er niets meer te nemen is.

Uil, de politieke man die een masker van vrijheid, van oprechtheid,
van menschenliefde opzet en die, op een gegeven oogenblik, zonder te
verwittigen, een man of eene natie zachtjes de keel toeworgt.

Uil, de koopman die zijnen wijn doopt, zijne eetwaren vervalscht,
een kwade maag brengt daar waar spijsverteering,--woede, daar waar
vroolijkheid was.

Uil, hij die behendig steelt, zonder dat men hem bij den kraag vatten
kan, valsch getuigt tegen de waarheid, de weduwe ten onder brengt,
de weeze stroopt, en zegepraalt in 't vet, lijk anderen zegepralen in
't bloed.

Uilin, zij die hare schoonheid verkoopt, de beste harten van
jongelieden vermorst, dat heeten: de jeugd vormen, en ze zonder eenen
cent, achterlaat in het slijk waarin zij hen sleepte.

Als ze ooit treurig gestemd is, zich ooit herinnert dat ze vrouw is,
moeder zoude kunnen zijn, dan verloochen ik heur. Als ze, dat bestaan
moede, in 't water springt, dan is zij eene zinnelooze, die niet
verdiende te leven.

Zie rondom u, domme schrijver, en tel, als gij kunt, de uilen van deze
wereld; bedenk of het voorzichtig is gelijk gij het doet, van Macht
en List, die koninginnen der uilen, aan te vallen. Kom tot inkeer,
zeg mea culpa en vraag op uwe knieën om vergiffenis.

Nochtans hebt gij mijne belangstelling gewonnen door uwe onbesuisdheid,
vol zelfvertrouwen; tegen mijne gekende gewoonten in, verwittig ik u
dan ook dat ik, op staanden voet, de grofheid en roekeloosheid van
uwen stijl ga aanklagen bij mijne neven in letterkunde, die eene
sterke pen, eene stoute tong en voortreffelijke brillen hebben, en
zeer voorzichtige en pedante lieden zijn, die uwen trant niet gewoon
zijn en hunne taal zoozeer kuischen, dat er ten lange laatste niets
zal van overblijven. [3]


Bubulus Bubb.







EERSTE BOEK.


I.

In meimaand, als de hagedoorn in bloei stond, werd te Damme, in
Vlaanderenland, Uilenspiegel, de zoon van Klaas geboren.

Terwijl Katelijne, de vroedvrouw, hem in warme doeken bakerde, bezag
ze zijn hoofd en riep ze blijde uit:

--Hij is met den helm geboren!

Maar weldra jammerend, met den vinger een zwart stipje op den schouder
van den boorling toonend:

--Laas! schreide zij, dat is het zwarte merk van den vinger des
duivels!

--Heer Satan is vandaag vroeg opgestaan, antwoordde Klaas, dat hij
alreeds den tijd vond om mijn zoon te teekenen?

--Satan sliep nog niet, zei Katelijne, want luister, nu eerst kraait
Kanteklaar de hennen wakker.

En zij gaf het kind over aan Klaas en ging naar buiten.

De dageraad verdreef nu het nachtelijk duister, de zwaluwen vlogen
kwetterend rakelings over de weide, en de zon kleurde vuurrood
de kimme.

Klaas deed het venster open en sprak tot Uilenspiegel:

--Kind met den helm, zie, daar is moeder de Zon, die Vlaanderenland
komt groeten. Bezie haar als uwe kijkers zullen open zijn; verkeert
gij later ooit in twijfel, weet gij niet wat te doen om goed te doen,
ga dan om raad bij de Zonne; zij is warm en helder: wees zoo goed
als zij warm, zoo eerlijk als zij helder is.

--Klaas, mijn man, zei Soetkin, ge spreekt tot een doove; kom en drink,
mijn jongen.

En de moeder stak den boorling hare schoone, blanke borsten toe.




II.

Terwijl Uilenspiegel zich laafde aan de levensbron, ontwaakten al de
vogelkens in 't veld.

Klaas, die mutsaards bond, bezag zijne vrouw, die Uilenspiegel de
borst gaf.

--Zeg eens, vrouw, sprak hij, hebt ge nog veel van die lekkere melk?

--De kruiken zijn vol, man, antwoordde zij, maar dat is niet voldoende
om mijn hert te verblijden.

--Gij spreekt zoo treurig en het is zoo vroeg nog in den morgen.

--Ik denk er aan, dat er geen oortje meer steekt in de tassche,
die daar aan den muur hangt.

Klaas nam de tassche van den wand; maar hij had goed schudden, er
rinkelde geen geld in. Hij was er onthutst over; doch hij wilde zijne
vrouw moed inspreken, en zei:

--Waarover bekommert gij U? Hebben wij in de schapraai den koek
niet liggen, dien Katelijne ons gisteren gaf? Zie ik daar geen groot
stuk vleesch, dat ten minste voor drie dagen goede melk aan 't kind
zal geven? Die zak boonen daar in den hoek, is die een voorteeken
van hongersnood? En dat kuipje boter bestaat toch niet in mijne
verbeelding? In mijne verbeelding ook niet, die appelen, welke,
met elven in 't gelid, op onzen zolder liggen? En de dikke tonne
schuimende Brugsche kuite, noodt zij ons niet, met haren vollen buik,
tot een gulle drinkpartij?

--Als 't kind gedoopt wordt, zei Soetkin, moeten er twee oortjes zijn
voor den pastoor en één gulden voor 't festijn.

Daarop kwam Katelijne het huis binnen met een grooten bundel kruiden
en zij sprak:

--Aan het kind bied ik de angelica, die den man voor ontucht behoedt
en de venkel, die Satan van hem verwijderd houdt....

--Hebt gij het kruideken niet, vroeg Klaas, dat guldens aantrekt?

--Neen, zegde zij.

--Dan ga ik zien of er iets in de vaart is te vinden.

Hij ging heen, met zijn hengel en zijn net, zeker dat hij niemand
ontmoeten zou, want het was nog een heel uur vóór oosterzon, wat in
Vlaanderen vijf uren zeggen wil.




III.

Klaas kwam aan de Brugsche vaart, niet verre van de zee. Hij schoof
het aas aan den haak, wierp de lijn uit en liet ook zijn net in 't
water zinken. Op den overkant der vaart lag een goedgekleede knaap
vast in slaap, op een bed van mosselen.

Op het gerucht, dat Klaas maakte, werd de jongen wakker; hij wilde
vluchten, meenende dat het een serjant der naburige gemeente was, die
kwam om hem te pakken en naar het Steen te brengen voor landlooperij.

Doch de schrik was verdwenen toen hij Klaas herkende, die hem toeriep:

--Wilt gij zes duiten verdienen? Ja?... Jaag dan de visch langs hier!

Op die woorden ging het knaapje, een kleine dikzak, het water in;
het trok er eenige lischbladeren, vatte ze tot een bundel samen en
joeg er mee de visch naar Klaas.

Toen de vangst gedaan was, trok Klaas net en lijn uit het water en
ging hij de sluis over naar het knaapje.

--Gij zijt het, zegde hij, die Lamme heet van uw doopnaam, en
Goedzak om den wille van uw zachtaardig karakter, en achter Onze
Lieve Vrouwekerk in de Reigerstraat woont? Hoe komt het dat gij,
zoo jong en zoo netgekleed, onder den blooten hemel slaapt?

--Laas! baas kooldrager, antwoordde het jongetje, ik heb thuis eene
zuster, die een jaar jonger is dan ik en mij troef geeft bij den
minsten twist. Maar op haren rug durf ik mijne weerwraak niet nemen,
want ik zou haar zeer doen, baas. Gisterenavond, onder het eten,
wischte ik met mijne vingers een teil uit, waarin ossenvleesch met
boonen geweest was, en zij wou er heur deel van hebben. Daar was niet
eens genoeg voor mij, baas. Als ze mij zag likkebaarden om den goeden
smaak der saus, werd ze razend en sloeg ze met de volle hand mij zóó in
't gezicht, dat ik heel bebloed het huis uitgeloopen ben.

Klaas vroeg hem wat zijn vader en zijne moeder zeiden, terwijl hij
zoo geslagen werd.

Lamme Goedzak antwoordde:

--Vader stompte mij op den eenen schouder en moeder klopte mij op den
anderen, roepende: "Verweer u, laffe Lamme". Maar ik wil geen meisje
slaan en daarom ben ik weggeloopen.

Eensklaps verbleekte Lamme en beefde hij als een riet.

En Klaas zag een lange vrouw afkomen, met een mager meisje naast zich,
dat er barsch uitzag.

--Ah! zuchtte Lamme, terwijl hij Klaas bij zijne hooze vastgreep, daar
komen moeder en zuster mij halen. Bescherm mij toch, baas kooldrager!

--Dáár, sprak Klaas, neem eerst die zes duiten voor uwe moeite en
heb geen vrees.

Toen de twee vrouwen Lamme zagen, liepen zij naar hem toe, en beiden
wilden hem slaan, de moeder omdat hij haar onrust aangedaan had en
de zuster uit gewoonte.

Lamme verschool zich achter Klaas en riep:

--Ik heb zes duiten verdiend, ik heb zes duiten verdiend, slaat
me niet!

Doch de moeder kuste haren jongen reeds, terwijl het meisje Lamme's
handen wilde openwringen, om hem zijn geld af te nemen. Maar Lamme
schreeuwde:

--'t Is 't mijne, ge zult het niet hebben.... 't Is 't mijne!

En hij balde de vuisten.

Toen trok Klaas de kleine meid geducht bij de ooren en sprak:

--Als het u nog voorvalt leed te doen aan uw broer, die goed en zacht
is als een lammeken, steek ik u in een donker kolenhok, en daar zal
ik u niet meer bij de ooren trekken, maar de roode duivel uit de hel;
hij zal u aan stukken scheuren met zijn groote klauwen en zijne tanden,
die op vorken gelijken.

Op die woorden dorst de meid Klaas niet meer te bezien, noch
heuren broeder te naderen; zij verborg zich achter de rokken heurer
moeder. Doch in de stad schreeuwde zij het overal uit:

--De kooldrager heeft mij geslagen; hij heeft een duivel in zijn
kelder.

Nochtans dorst zij Lamme niet meer slaan; maar als zij groot was,
deed ze hem haar werk doen. En de goede sul gehoorzaamde gewillig.

Onderweg had Klaas zijne vangst verkocht aan een pachter, een
lekkerbek, en thuis komende, zegde hij tot Soetkin:

--Zie, dat heb ik gevonden in den buik van vier snoeken, negen karpers
en in een volle ben paling.

En hij smeet twee gulden en een oortje op tafel.

--Man, waarom gaat gij niet alle dagen visschen? vroeg Soetkin.

Klaas antwoordde:

--Wel, omdat ik zelf niet geerne zou spartelen in de netten van de
stadsserjanten.




IV.

Te Damme werd Uilenspiegel's vader "Klaas de kooldrager"
geheeten. Klaas had zwart haar, schitterende oogen; zijn vel was van
de kleur zijner koopwaar, uitgenomen op Zon- en feestdagen, als er
veel zeep in de stulp was. Hij was klein, hoekig, sterk en blijgezind.

Als zijn werk gedaan was en hij met den valavond naar eene taveerne
van den Brugschen steenweg ging, om met kuite zijn keelgat te spoelen,
dat zwart was van koolstof, riepen al de vrouwen, die, op den dorpel
van heur deur den koelen avond genoten, hem vriendelijk toe:

--Goên avond en klaar bier, kooldrager!

--Goên avond en 'nen man die niet slaapt, antwoordde Klaas.

De meisjes die in troepjes van het veld kwamen, stelden zich vóór hem,
lieten hem niet door en vroegen hem:

--Wat geeft ge om er door te mogen: een scharlaken lint, een vergulden
gesp, fluweelen schoentjes of een gulden in ons beursje?

Maar Klaas nam er eene om haar middel en kuste heur wangen of heur
hals, al naarvolgens zijn mond het dichtst bij de donzige huid was,
en dan zegde hij:

--Vraagt, mijne hertjes, vraagt de rest aan uwe minnaars.

En schaterlachend gingen de joelende meisjes voort.

De kinderen herkenden Klaas aan zijn grove stem en aan zijn zwaren
stap. Zij liepen naar hem toe en zeiden:

--'n Avond, kooldrager!

--Van 's gelijken, mijne engelkens, zei Klaas; maar komt niet te dicht,
of 'k maak U zwart als moorkens.

De stoute kaboutermannekens kwamen toch nader; dan nam Klaas er een
bij zijn wambuis, streek zijn zwarte hand over 't gladde gezichtje
en liet hem zoo loopen, tot groote vreugd van de schaterende bende.

Soetkin, Klaas' wijf, was een brave, wakkere vrouw, die opstond met
de zon, en vlug en vlijtig was als een bij.

Zij en Klaas bebouwden getweeën hunnen akker en spanden zich als ossen
vóór den ploeg. Zwaar was het om hem voort te trekken, doch zwaarder
nog trok de egge, die met hare houten tanden den harden grond moest
scheuren. Toch deden zij het blij te moede, met een liedeken op
de lippen.

En de grond mocht nog zoo hard zijn en de zon hare heetste stralen
op hen neerschieten: zij konden water en bloed zweeten als zij de
egge trokken dat hunne knieën knikten--al hun lijden vergaten zij,
als zij even stil stonden en Soetkin heur zacht gelaat naar Klaas
keerde, want dan kuste Klaas den spiegel van die teedere ziele.




V.

Den vooravond had men van de pui van 't gemeentehuis uitgeroepen dat
Mevrouw, echtgenoote van keizer Karel, zwanger was en dat er gebeden
voor hare aanstaande verlossing moesten worden opgezegd.

Gansch huiverend kwam Katelijne bij Klaas binnen.

--Wat scheelt er? vroeg de kooldrager.

--Laas! sprak zij met hijgenden boezem. Dezen nacht zag ik spoken,
die menschen maaiden gelijk de hooiers het gras.--'k Zag meisjes
levend begraven! En de beul danste op de lijken!--De bloedsteen,
die sedert negen maanden zweette, is dezen nacht gebarsten.

--Erbarming, zuchtte Soetkin, erbarming, Heere God: wat duister
voorteeken voor Vlaanderenland!

--Ziet gij dat met uwe oogen of in droom? vroeg Klaas.

--Met mijne eigen oogen, sprak Katelijne.

Doodsbleek en schreiend sprak Katelijne toen:

--Twee kinderkens zijn geboren; het een, in Spanje, is de kleine
Philippus, het ander, in Vlaanderenland, is de zoon van Klaas,
die later Uilenspiegel zal heeten. Philippus wordt een beul, want
hij werd verwekt door Karel den Vijfde, den moordenaar van ons
land. Uilenspiegel wordt een meester in kwinkslagen en guitenstreken,
maar goedhertig zal hij zijn, want zijn vader is Klaas, de wakkere
arbeider, die in braafheid, eer en deugd zijn brood verdient. Keizer
Karel en koning Philippus zullen hun leven lang kwaad doen, door
oorlog en knevelarij en andere misdaden. Klaas, die heel de week werkt,
zal leven volgens recht en wet, bij zijn zuren arbeid zal hij lachen
in stee van weenen: hij zal het zinnebeeld van de goede Vlaamsche
werkers zijn. Uilenspiegel, immer jong en onsterfelijk, gaat de wereld
door, maar nergens zal hij een vaste woonplaats hebben. En hij zal
boer, edelman, schilder, beeldhouwer worden, alles zal hij te gelijk
zijn. Zoo zal hij dolen langs velden en wegen, het goede en het schoone
prijzen en lachen en spotten met alles wat dwaas en verkeerd is. Klaas
is uw moed, edel volk van Vlaanderen, en Soetkin uwe dappere moeder;
Uilenspiegel is uw geest; een lief en bevallig meisje, Uilenspiegel's
gezellin en onsterfelijk als hij, zal uw hert zijn, en Lamme Goedzak,
een dikke pens, uwe maag. En omhoog zullen de opeters van 't volk gaan,
en omlaag hunne slachtoffers; omhoog de roovende wespen, omlaag de
noeste bijen, en in den hemel zullen de wonden van Christus bloeden.

Toen Katelijne, de goede tooveres, dit gezegd had, viel zij in slaap.




VI.

Uilenspiegel werd ten doop gebracht, toen plotseling een hevige
regenbui viel, die hem gansch nat maakte. Zoo werd hij voor de eerste
maal gedoopt.

Als hij nu de kerk binnengebracht werd, kwam de kosterschoolmeester
aan peter en meter, vader en moeder zeggen, dat zij zich rond de
doopvont moesten scharen, hetgeen zij deden.

Maar boven de vont, was er in 't gewelf een gat, dat een metser gekapt
had om er eene lamp aan een vergulde sterre te hangen. De metser, die,
van boven, peter en meter stokstijf rond de toegedekte vont zag staan,
goot verraderlijk door het gat een emmer water, dat, tusschen hen, met
groot geplas op het deksel van de vont kletste. Doch Uilenspiegel kreeg
er het grootste deel van. En zoo werd hij voor de tweede maal gedoopt.

De deken kwam; zij deden hem hun beklag, maar hij zei hun van zich te
haasten, dat het een ongeluk was. Uilenspiegel ging te werk als een
bezetene, om den wille van het water, dat op hem gespat was. De deken
gaf hem het zout en het water en heette hem Thijlbert, wat zeggen wil:
"altijd ongedurig". En zoo werd hij voor de derde maal gedoopt.

Uit Onze Lieve Vrouwekerk ging men daar rechtover, in de Langestraat,
eene taveerne binnen, die voor uithangbord een rozenkrans had, met
eene pint in het midden. Zij dronken er zeventien pinten dobbele kuite
en nog meer. Want in Vlaanderen, als men nat is, droogt men zich met
een vuur van bier in den buik. Zoo werd Uilenspiegel voor de vierde
maal gedoopt.

Met het hoofd zwaarder dan 't lichaam, strompelden ze huiswaarts;
zoo kwamen ze aan een brugje over eenen poel; Katelijne, die
meter was, droeg het kind; zij struikelde en viel in de modder met
Uilenspiegel. Zoo werd hij voor de vijfde maal gedoopt.

Men trok hem uit den poel. In 't huis van Klaas werd hij met lauw
water gewasschen. Dit was zijn zesde doopsel.




VII.

Dien dag besloot Zijne Heilige Majesteit keizer Karel, groote feesten
te houden, om de geboorte van zijn zoon te vieren. Evenals Klaas,
besloot hij uit visschen te gaan, niet in de vaart, doch in de beurzen
en tasschen zijner onderdanen. Daaruit is het dat vorstelijke lijnen
gouden karolussen, gouden lammeren, rozenobels, dubloenen, zilveren
daelders en al die wonderbare visschen trekken, die, naar willekeur
van den visscher, veranderen in fluweelen kleederen en schitterende
edelgesteenten, in lekkeren wijn en smakelijke gerechten. Want de
rivieren, die 't rijkst zijn aan visch, zijn niet die, waarin het
meeste water is.

Nadat Zijne Heilige Majesteit zijn raad bijeengeroepen had, besloot
hij, dat de vangst volgenderwijze geschieden zou:

De genadige infant zou rond negen of tien uren ten doop gebracht
worden; ten blijke van groote vreugde, zouden de inwoners van
Valladolid heel den nacht, op eigen kosten, feesten en kermissen,
en ten bate der armen, hun geld op de Groote Markt strooien.

Op vijf punten zou eene fontein, tot aan den dageraad toe, goeden
wijn spuiten, die door de stad moest betaald worden. Op vijf andere
plaatsen zouden, op houten kramen, allerhande worsten, ossetongen en
pasteien uitgestald worden, mede ten laste van de stad.

Op eigen kosten zouden de lieden van Valladolid, op den doortocht van
den stoet, in grooten getale zegebogen oprichten, den Vrede, het Geluk,
den Overvloed, de Fortuin voorstellend, en allerhande zinnebeeldige
toespelingen op de gaven des hemels, waarmede zij onder de regeering
van Zijne Heilige Majesteit begunstigd waren.

Ten slotte en behalve deze bogen van pais, zouden er andere opgericht
worden, waarop, in helle kleuren, minder goedertieren kenteekenen
zouden prijken, zooals arenden, leeuwen, lansen, hellebaarden,
vlammende spiesen, kanonnen, falkonetten, slangen met wijden mond,
mitsgaders al ander oorlogstuig, om op zinnebeeldige wijze de macht
en de kracht van Zijne Heilige Majesteit voor te stellen.

En, voor het verlichten der kerk zou, als een blijk van de genade
Zijner Majesteit, aan het gilde der keersgieters toegestaan worden,
voor niet, over de twintig duizend waskeersen te leveren, waarvan de
onopgebrande einden naar 't kapittel zouden gaan.

Al de andere kosten zou de keizer zelf betalen, om aldus te toonen,
dat het Zijner Goedertierenheid behaagde, zijne volkeren niet te zeer
te belasten.

Als de gemeente die bevelen uitvoerde, kwamen jammerlijke tijdingen uit
Rome. Oranje, Alençon en Frundsberg, bevelhebbers van den keizer,
waren binnen de heilige stede gedrongen en hadden er kerken,
kapellen en huizen verwoest en geplunderd, niemand, priesters,
nonnen, moeders noch kinderen, sparend. Den Heiligen Vader hadden zij
gevangengenomen. De plundering duurde reeds een volle week; ridders en
landsknechten doolden door Rome, zwelgend en brassend, met de wapens
zwaaiend, op zoek naar de kardinalen, roepende en tierende, dat zij
hen allen derwijze verminken zouden, dat geen hunner ooit paus zou
worden. Enkelen hadden die bedreiging reeds ten uitvoer gebracht en
dweilden langs de straten met halssnoeren van acht-en-twintig of meer
bloedige bollen, groot als okkernoten. De wegen leken roode beken,
waarin de verminkte lijken der vermoorden lagen.

Onder het volk werd gezegd, dat de keizer, die geld noodig had, er
wilde visschen in het bloed van de priesters, en dat hij bekend met
het tractaat, den gevangen paus door zijne bevelhebbers opgelegd, hem
dwong afstand te doen van al de versterkte plaatsen zijner Staten,
400.000 dukaten te betalen en gevangen te blijven totdat aan die
voorwaarden voldaan was.

Nochtans was de droefheid van Zijne Majesteit zoo groot, dat hij al
de toebereidselen van vreugde, feesten en vermakelijkheden afzegde
en den heeren en edelvrouwen van zijn huis beval den rouw aan te nemen.

En de infant werd gedoopt in zijn witte doeken, ten teeken van
koninklijken rouw.

Dat alles aanschouwden de heeren en edelvrouwen als voorteekenen
van rampspoed.

Desniettemin toonde de voedster den infant aan de edelen en edelvrouwen
van het koninklijk huis, opdat zij hem, naar aloud gebruik, hunne
wenschen en giften zouden bieden.

Mevrouw de la Coena hing om zijn hals een zwarten steen tegen het
vergif, zoo rond en zoo groot als eene hazelnoot, in een gouden
ring gevat; Mevrouw de Chaussade bond aan een zijden draadje eene
schelp, wolfsmuil geheeten, hangende op zijne maag, voor de goede
spijsvertering; messire Van der Steen, uit Vlaanderen, bood hem een
Gentsche worst, vijf ellebogen lang en een halven dik, en wenschte
daarbij hoogstnederig aan Zijne Hoogheid, dat hij, alleen op den
reuk van de worst, dorst mocht krijgen naar Gentschen klauwaard,
daarbij voegende dat, al wie het bier eener stad lust, de brouwers
niet kan haten; messire jonker Jacob Christoffel van Castilië bad
Zijne Hoogheid den Infant een groenen jaspis aan zijn doorluchtige
voetjes te willen dragen, opdat hij goed zou kunnen loopen. Jan de
Paepe, de nar, die daar ook was, sprak toen:

--Messire, geef hem liever den horen van Jozua, op wiens geschal al de
steden, met alles wat er in was aan mannen, vrouwlieden en kinderen,
zich in beweging zetten en liepen. Want Zijne Hoogheid moet niet
leeren zelf te loopen, maar wel de anderen te doen loopen.

De bedrukte weduwe van Floris van Borsele, in leven heer van Veere
in Zeeland, schonk aan Zijne Hoogheid Philippus eenen steen die,
naar zij zegde, de eigenschap had de mannen verliefd en de vrouwen
ontroostbaar te maken.

Maar de infant schreide zonder ophouden.

Uilenspiegel schreide ook, maar Klaas stak hem een wisschen klater
met belletjes in de hand, deed hem op zijne hand dansen en sprak:
Klingelingeling, hadt gij maar altijd belletjes aan uw kaproen,
mijn zoon, want de gekken zijn meester van de wereld.

En Uilenspiegel lachte zijn vader toe.




VIII.

Klaas had een grooten zalm gevangen, die op een Zondag gegeten werd
door hem en ook door Soetkin, Katelijne en den kleinen Uilenspiegel;
doch Katelijne at niet meer dan een vogelken.

--Maar, zei Klaas tot haar, is Vlaanderens lucht tegenwoordig zoo
voedzaam, dat gij maar moet ademhalen om gespijsd te wezen als met
een teil vleesch? Wanneer zal men kunnen leven zonder eten? De regen
moest goede soep zijn, de hagelsteenen erwten en de sneeuw stoverije;
dat zou den armen pelgrims versterking geven.

Katelijne schudde zwijgend het hoofd.

--Maar, moet gij daar zoo jammerend zitten? zei Klaas. Wat scheelt
er aan?

Toen sprak Katelijne met eene stem, zacht als een ademtocht:

--De booze geest, de zwarte nacht valt neer.--Daar meldt hij zijne
komst, met het geschreeuw van den nachtuil.--Rillend aanroep ik--te
vergeefs--de Heilige Maagd.--Voor hem, muren noch hagen, deuren noch
vensters.--Licht als een geest, dringt hij overal binnen.--Krakende
ladder.--Hij is bij mij, op den zolder waar mijne legerstee staat.--Hij
grijpt mij in zijn koude armen, als marmer zoo hard.--IJskoud is zijn
gelaat, en zijn kussen vochtig als de sneeuw.--De stroohut schudt en
slingert als een schuitje op de woelige zee....

--Elken morgen, zei Klaas, moet gij ter misse gaan, opdat de Heer
Jezus U de kracht geve dat helsche spook te verjagen.

--Hij is zoo schoon! sprak zij.




IX.

Als Uilenspiegel gespeend was, groeide hij op lijk een boom.

Dan kuste zijn vader hem zoo dikwerf niet meer, maar voedde hem streng
op, opdat hij geen weekeling worden zou.

Als Uilenspiegel thuis kwam en kloeg, dat hij, bij een of anderen
twist, klop gekregen had, kreeg hij er nog klop bij van Klaas,
omdat hij de anderen niet geklopt had: en, aldus opgebracht, kreeg
Uilenspiegel den moed van een jongen leeuw.

Als Klaas er niet was, vroeg Uilenspiegel aan Soetkin een duit om te
spelen. Dan was Soetkin boos en sprak:

--Waarom moet ge gaan spelen? Blijf liever thuis, om mutsaards
te binden.

En als zij niets gaf, begon Uilenspiegel te blaten als een lam. Maar
Soetkin maakte dan veel leven met potten en pannen, om te gebaren
dat ze hem niet hoorde. Dan weende Uilenspiegel, en de zoete moeder
liet hare geveinsde hardheid af, kwam tot hem, streelde hem en vroeg:
"Hebt gij genoeg met een denier?" Nu, gij moet weten, dat een denier
zes duiten gold.

Zoo beminde zij hem te veel en, als Klaas er niet was, was Uilenspiegel
baas in huis.




X.

Op een morgen zag Soetkin haren man met gebogen hoofd in de keuken
staan, in gedachten verdiept.

--Wat scheelt er toch, man? vroeg zij. Ge ziet bleek, gij zijt kwaad
en verstrooid.

Met eene stem, als een hond die bromt, antwoordde Klaas:

--De wreede plakkaten des keizers gaan ze weer uithalen. Opnieuw gaat
de dood over Vlaanderenland heerschen. De aanbrengers krijgen de helft
van de have der slachtoffers, als de have de honderd karolusgulden
niet te boven gaat.

--Wij zijn arm, sprak zij.

--Arm, zeide hij,... niet arm genoeg. Er zijn lage zielen, gieren
en raven, die ons zouden aanklagen, zoowel om een zak kolen als om
een zak karolussen met Zijne Majesteit te deelen. Wat bezat het arme
Tanneken, de weduw van Sies den kleermaker, die ze te Heist levend
begroeven? Een Latijnschen bijbel, drie gouden florijnen en wat potten
van Engelsch tin, waarop eene buurvrouw loerde. Wantje Martens werd
eerst in 't water geworpen; haar lijf dreef boven, en daarin zag
men hekserij, weshalve zij als tooveres verbrand werd. Zij had wat
gebroken meubelen, zeven gouden karolussen in een lederen tassche,
en de aanklager vroeg er de helft van. Eilaas! nog tot morgen zou ik
aldus kunnen spreken: maar wat baat het, vrouw: in Vlaanderen is het
leven onhoudbaar om den wille van de plakkaten. Welhaast zal telken
nacht de kar van den Dood dof door de straten rijden en wij zullen
zijne beenderen hooren rammelen.

Soetkin sprak:

--Jaag me geen schrik aan, Klaas. De keizer is de vader van Vlaanderen
en Brabant; als dusdanig is hij braaf en grootmoedig, geduldig
en genadig.

--Daarbij zou hij te veel verliezen, antwoordde Klaas, want de
verbeurdverklaarde goederen komen hem bij erfenis toe.

Plotseling hoorde men de trompet en de cimbels van den
stadsuitroeper. Op dat geluid kwamen Klaas en Soetkin, die beurt om
beurt Uilenspiegel op den arm droegen, met de volksmenigte toegeloopen.

Zoo kwamen zij aan het schepenhuis. Voor de pui waren de herauten te
peerd, op bazuinen blazend en op cimbels slaande, de provoost met de
roede der justitie in de hand en de stadsprocureur, ook te peerd,
die eene ordonnantie des keizers in de hand hield en zich gereed
maakte ze aan vergaderde volksmenigte voor te lezen.

Klaas vernam, dat het andermaal aan allen in 't algemeen en aan elk in
't bijzonder verboden was, te drukken, te lezen, in bezit te hebben of
voor te staan, de boeken, schriften of leerstellingen van Martinus
Luther, van Joannes Wycliff, Joannes Huss, Marcilius van Padua,
Æcolampadius, Ulricus Zwinglius, Philippus Melanchton, Franciscus
Lambertus, Joannes Pomeranus, Otto Brunselsius, Justus Jonas, Joannes
Pupperis en Gorcianus, de Nieuwe Testamenten gedrukt door Adriaan
van Bergen, Christoffel van Roemonde en Joannes Zell, vol Luthersche
en andere heresiën, verworpen en veroordeeld door de Faculteit der
godgeleerdheid van de Universiteit van Leuven. Mitsgaders te maken of
te doen maken smadelijke konterfeitsels of afbeeldsels van God, van de
heilige Maagd Maria of van de santen; te breken, te scheuren of uit te
wisschen de beelden of konterfeitsels, vervaardigd tot verheerlijking
van en tot aandenken aan God en de Maagd Maria of de heiligen der kerk.

Verder zei het plakkaat, dat het aan niemand toegelaten was, tot welken
staat hij ook mocht behooren, zich te vermeten de Heilige Schrifture te
bespreken of over haar te twisten, zelfs niet op twijfelachtige punten,
tenzij door een godgeleerde van naam, erkend door eene Universiteit,
daartoe gemachtigd.

Onder andere straffen besliste Zijne Heilige Majesteit, dat
de verdachten nooit of nimmer een eerbaar ambt zouden kunnen
bekleeden. En zij, welke in hunne dolingen hervielen of bleven
volharden, zouden veroordeeld worden met een zacht of hard vuur,
in een strooien huis of gebonden aan een paal te worden verbrand,
al naar de sententie van den rechter. De anderen zouden omgebracht
worden door het zweerd als zij edelen of goede burgers waren, de
gemeene manslieden aan de galg geknoopt en de vrouwlieden levend
begraven. Om tot voorbeeld te strekken, zou hun hoofd op een paal
worden gestoken. Ten profijte van den keizer was er verbeurte hunner
goederen, overal waar verbeurdverklaring geschieden kon.

Zijne Heilige Majesteit schonk den aanbrengers de helft van al
hetgene de aflijvigen in eigendom bezeten hadden, zoo die have de
somme van honderd pond grooten, Vlaamsche munte, alles in 't alles,
niet te boven ging. En wat aanging het deel van den keizer, dit
zou hij aanwenden voor werken van godsvrucht en van bermhertigheid,
gelijk bij de plundering van Rome was geschied.

En treurig keerde Klaas naar huis, met Soetkin en Uilenspiegel.




XI.

Daar het een jaar van voorspoed geweest was, kocht Klaas voor zeven
florijnen een ezel en negen halsters boonen, en op een morgen besteeg
hij zijn beest. Uilenspiegel zat van achteren. Aldus gingen zij hun
oom en oudsten broeder, Judocus Klaas, bezoeken, die woonde omtrent
Meiborg, in de Duitsche landen.

Judocus, die in zijne jeugd eenvoudig en zacht van aard was geweest,
had door vele geleden onrechtveerdigheden haat tegen de menschen
opgevat en leefde in eenzaamheid.

Zijn vermaak was, twee zoogezeid trouwe vrienden met elkander te doen
vechten, en hij gaf drie oortjes aan hem, die zijn vriend het ergst
toegetakeld had.

Ook bracht hij geerne, in een warme kamer, in grooten getale,
twistzieke oude wijven bijeen en gaf haar geroosterd brood en
kruidenwijn.

Aan de vrouwen, die meer dan zestig jaar oud waren, stelde hij saaie
ter hand, die zij in een hoek moesten opbreien; daarbij beval hij haar
altijd aan, de nagels lang te laten groeien. En 't was wonderlijk
ze te hooren kuchen, babbelen, snappen en, met hare priemen onder
de oksels, te zamen den naam en de eer van den evennaaste te hooren
schenden en rooven.

Wanneer Judocus zag, dat zij goed in gang waren, smeet hij eenen
borstel in 't vuur, die door het schroeien der haren de lucht met
een geweldigen stank vervulde.

Dan begonnen de wijven al te gelijk te kijven en elkaar te beschuldigen
de oorzaak te zijn van den stank: en allen streden het af en vlogen
weldra elkander in 't haar; en dan wierp Judocus opnieuw borstels in
het vuur en paardenhaar op den vloer. Als het gevecht zoo verwoed en
de rook zoo dik werd, en het stof zoo hoog steeg, dat hij niets meer
zien kon, ging hij zijne twee in stadsserjanten verkleede knechts
halen, die de ouden als woedende ganzen met groote stokslagen uit de
kamer verdreven.

En toen Judocus het slagveld overzag, vond hij er lappen van rokken,
van kousen, van hemden en ook oude tanden.

En droefgeestig zei hij tot zich zelven:

--Mijn dag is verloren, niet eene van haar heeft hare tong
achtergelaten.




XII.

In het baljuwschap Meiborg ging Klaas door een smal boschje: de
ezel hapte hier en daar naar een distel; Uilenspiegel smeet zijne
kaproen naar de vlinders en ving ze weer op, zonder van den ezel te
komen. Klaas at eene snede brood en nam zich voor, die in de naaste
taveerne te begieten. Van verre hoorde hij een klokje kleppen en een
gedruisch als van vele menschen die altegader spreken.

--'t Is eene bedevaart, en de heeren pelgrims zijn zeker in grooten
getale. Houd u goed vast, mijn zoon, dat zij u niet van het grauwtje
stooten. Wij zullen zien. Komaan, ezeltje, wat gauwer, toe!

En de ezel draafde.

Zij verlieten den zoom van het bosch en daalden naar een groote vlakte,
ten Westen door eene rivier bespoeld. Aan den Oosterkant stond een
kleine kapel, den gevel versierd met een beeld der Lieve-Vrouwe, met
twee stieren aan heure voeten. Op de trappen van de kapel stonden een
heremiet--die giegelend, aan 't kleppen was--vijftig staffieren met
brandende keersen in de hand, spelers, klokluiders en trommelslagers,
klaroenblazers, pijpers, schalmei- en doedelzakspelers, alsmede een
hoop lustige gezellen, die bakken vol oudroest in de handen hielden,
doch voor het oogenblik allen stille zwegen.

Meer dan vijf duizend pelgrims, in gesloten gelederen, elk van zeven
man, met helmen op en stokken van groen hout in de hand, gingen hen
voorbij. Dan schaarden zij zich, telkens zeven, vóór de kapel. Zij
lieten hunne stokken zegenen en kregen elk eene keers uit de handen
der staffieren, in ruil waarvan zij den heremiet een halven florijn
betaalden.

En hunne processie was zoo lang, dat de keersen van de eersten
opgebrand waren, toen die van de laatsten nog hare volle lengte hadden.

Klaas, Uilenspiegel en de ezel verlustigden zich met aldus een groote
verscheidenheid breede, hooge, lange, puntige, fiere, ronde of slappe
buiken te zien voorbijgaan.

Al de pelgrims hadden helmen op. Er waren er die van Troje kwamen,
andere, die phrygische mutsen leken. Sommige pelgrims hoewel met bolle
wangen en dikke buiken, droegen helmen met uitgespreide vleugelen,
doch hadden geenerlei zin tot vliegen. Anderen waren gekapt met
zoogenaamde "salades", door de slakken onwaardig gekeurd omdat ze
niet groen genoeg waren.

Maar het meerendeel had helmen, zoo oud en verroest, dat ze uit den
tijd schenen te zijn van Gambrinus, koning van Vlaanderen en koning
van het bier, dewelke regeerde negenhonderd jaar vóór Christus en eene
pint op zijn hoofd droeg, uit vrees niet op tijd te kunnen drinken,
bij gebrek aan een beker.

Eensklaps begonnen klokken, pijpen, schalmeien, trommelen en het
oudroest te kleppen, te fluiten, te schallen, te slaan en te kletteren.

Het was het sein voor de pelgrims zich omme te keeren en bij groepen
van zeven zich nu tegenover elkaar te plaatsen. Als uitdaging stak elk
de brandende keers in het gelaat van zijn overman. Daardoor ontstond
groot genies en daarna regende het stokslagen.

Ze vochten en sloegen met handen en voeten, met hoofden, met alles. Er
waren er, die, gelijk de rammen, op hunne tegenstrevers vielen, met
den helm vooruit, die bij den eersten schok over hunne ooren schoot,
en als blinden terechtkwamen op zeven andere woedende pelgrims,
die hen verwelkomden, maar niet met zachtheid.

Anderen, schreeuwers en bloodaards, jammerden om de ontvangen slagen,
maar bij het prevelen hunner gebeden werden ze bliksemsnel door nieuwe
zeventallen overvallen en zonder genade omvergeloopen of omvergetrapt.

En de heremiet lachte.

Verderop zag men zeventallen, die als klissen aan elkaar hingen en
van boven naar beneden in het water rolden; maar zij bleven elkaar
toetakelen en ranselen, zonder dat het water hunne woede bekoelde.

En de heremiet lachte.

Zij, die boven gebleven waren, sloegen elkander de oogen blauw en de
tanden vaneen, rukten elkanders haren uit, en scheurden wambuizen en
hoozen aan stukken.

En de heremiet lachte en sprak:

--Dapper aan, vrienden: wie 't hardst slaat, bemint het meest. Aan de
kloekste vechters, de schoonste liefjes! Hier ziet Onze Lieve Vrouw
van Rindbisbels, wie man is!

En de pelgrims sloegen als op kaf.

Middelerwijl was Klaas den heremiet genaderd, terwijl Uilenspiegel
lachend en gierend op de slagen bleef toekijken.

--Eerwaarde vader, vroeg hij, welke misdaad hebben die arme sukkelaars
bedreven, om elkander zoo wreedelijk te mishandelen?

Doch zonder hem te aanhooren, riep de heremiet:

--Luieriken! gij verliest den moed. Als de vuisten moede zijn, zijn
de voeten het immers nog niet! Zijn er onder U, die beenen hebben om
te vluchten als hazen? Wat doet het vuur uit de steenen springen? Het
ijzer, dat er op slaat!

Op die woorden gingen die onnoozele pelgrims voort te vechten met
helmen, met handen en met voeten. 't Was een verwoede strijd, waarvan
Argus met zijn honderd oogen niets hadde gezien dan stofwolken en
hier en daar de punt van een helm.

Doch eensklaps begon de heremiet te kleppen. Pijpen, trommelen,
trompetten en schalmeien en het oudroest staakten hun gedruisch,
tot teeken van vrede.

De pelgrims brachten nu hunne gekwetsten bijeen. Er waren er, wier
tong, gezwollen van gramschap, uit den mond hing. Maar die ging van
zelve in hare verblijfplaats terug. Moeilijker was het om de helmen
af te trekken, die tot ver over de ooren zaten. Zij schudden den kop
en bleven hem schudden: de helmen waren vast gelijk groene pruimen
aan den boom.

Doch toen sprak de heremiet:

--Leest elkeen een ave en keert terug naar uw wijf. En binnen negen
maanden zullen evenveel kinderen meer in het baljuwschap zijn, als
heden 't gevecht dappere strijders telde.

En de heremiet zong het ave voor, en allen zongen het mee. En de
klok klepte.

De heremiet zegende hen in name van Onze Lieve Vrouwe van Rindbisbels
en sprak tot de pelgrims:

--Gaat in vrede!

En roepend en stompend en zingend, trokken zij naar Meiborg terug. Al
de vrouwen, oude en jonge, wachtten hen op den dorpel van de huizen,
waar zij binnenvlogen als soldeniers in een stormenderhand veroverde
stad.

De klokken van Meiborg luidden al te gader: de jongens floten, riepen,
speelden op den rommelpot.

Pinten en stoopen, bekers en glazen gingen lustig aan 't klinken en
rinkelen. En de wijn vloeide in de kelen als een stroom in de zee.

Terwijl de klokken luidden en de wind, bij vlagen, aan Klaas 't gezang
van mannen, vrouwlieden en kinderen bracht, vroeg hij opnieuw aan den
heremiet, welke hemelsche gratie die sukkelaars hoopten te verkrijgen,
na die hardhandige oefeningen.

Lachend antwoordde hem de heremiet:

--Op die kapel daar, ziet ge twee gekapte beelden, die twee stieren
voorstellen. Zij staan daar ter herinnering aan het mirakel van den
heiligen Martinus, die twee ossen in stieren veranderen deed, door
hen met de horens te doen vechten. Daarna streek hij meer dan een
uur keersvet over hunnen snuit, en sloeg er met den stok op.

Welnu, ik kende het mirakel. Ik vroeg Zijne Heiligheid om eene
vergunning, die ik duur betaalde en kwam mij vestigen in dit oord.

Toen preekte ik over het wonder en weldra kregen al de mannen, zoo
ouden als jongen, de zekerheid dat Onze Lieve Vrouwe hun genadig was
als ze goed gevochten hadden met de keers die de zalf, en den stok die
de kracht is. Hierheen is het, dat de vrouwen heuren man sturen. De
kinderen, die uit kracht van de bedevaart verwekt zijn, worden vlug
en wreedaardig, geweldig en roekeloos en, later, vrome soldaten.

Eenklaps vroeg de heremiet aan Klaas:

--Herkent gij mij?

--Ja, sprak Klaas, gij zijt mijn broeder Judocus.

--Gij zijt er, antwoordde de heremiet, maar wie is die bengel daar,
die leelijke gezichten naar mij trekt?

--'t Is uw neef, was 't antwoord van Klaas.

--Welk verschil maakt gij tusschen keizer Karel en mij?

--'t Is groot, sprak Klaas.

--'t Is klein, wedervoer Judocus: de keizer doodt de menschen en bij
mij krijgen ze klop, tot ons beider profijt en vermaak.

Dan bracht hij Klaas en Uilenspiegel naar zijne kluis, waar zij elf
dagen achtereen kermis vierden.




XIII.

Als Klaas afscheid nam van zijn broer, steeg hij op zijn ezel, met
Uilenspiegel achter zich. Op de Markt van Meiborg stonden velerhande
pelgrims en als zij hen zagen, ontstaken ze in woede en hieven de
stokken dreigend omhoog. En allen riepen "Schelm! Nietdeug!" om
den wille van Uilenspiegel, die zijne hooze losgemaakt en zijn hemd
opgetrokken had, en zijne achterkaken liet zien.

Klaas, ziende dat ze zijn zoon bedreigden, vroeg hem:

--Wat hebt gij gedaan, dat zij zoo kwaad op u zijn?

--Vadertjelief, antwoordde Uilenspiegel, ik zit op den ezel en zeg
tot niemand een woord, en toch schelden ze mij uit voor een nietdeug.

Toen deed Klaas hem langs voren zitten.

In die postuur stak Uilenspiegel de tong uit naar de pelgrims, en
roepend en tierend balden ze hunne vuisten en dreigden met hunne
stokken Klaas en den ezel.

Maar Klaas sloeg op zijn ezel om hunne woede te ontvlieden. Toen de
pelgrims hen met rust lieten, sprak Klaas tot zijn zoon:

--Gij zijt onder een zeer slecht gesternte geboren, want gij zit vóór
mij, doet niemand kwaad en toch willen ze u dooden!

Uilenspiegel hield zijn buik vast van 't lachen.

Terwijl Klaas door 't Land van Luik reed, hoorde hij zeggen, dat
die van Rivage hongersnood leden en dat ze gesteld waren onder
de jurisdictie van den officiaal, eene vierschaar van geestelijke
rechters. Zij maakten opstand om brood en om wereldlijke rechters
te bekomen. Eenigen werden onthoofd of gehangen, anderen uit het
land gebannen; dàt was de goedertierenheid van den zachtzinnigen
aartsbisschop, den hoogweerdigen Van de Marck.

Klaas zag onderwege de gebannenen, die de zoete vallei van Luik
ontvloden, en, aan de boomen, omtrent de stad, zag hij de lijken van
hen die gehangen waren, omdat zij de misdaad begaan hadden, honger
te hebben. En Klaas schreide over hunnen rampspoed.




XIV.

Toen Klaas op zijn ezel weer thuis kwam met een zak vol oortjes,
dien hij van zijn broeder gekregen had en ook met een schoonen beker
van Engelsch tin, was 't Zondag en weekdag kermis in de arme stulp;
alle dagen at men boonen met vleesch.

Menigmaal vulde Klaas den schoonen beker met schuimende dobbele kuite.

Uilenspiegel at voor drie; hij ging en kwam naar de borden en teilen
als eene musch op een graanzolder.

Eet gij het zoutvat niet mee? vroeg Klaas.

Uilenspiegel antwoordde:

--Wanneer, gelijk hier, het zoutvat gemaakt is van een uitgeholde
korst brood, moet men het soms opeten, anders komen er wormen in.

--Waarom, zegde Soetkin, veegt gij uwe vettige handen af aan uwe hooze?

--Aan mijne hooze? wel, om nooit met natte billen te loopen.

Daarop dronk Klaas een groote teug bier uit zijn tinnen beker.

Uilenspiegel vroeg hem:

--Waarom hebt gij zoo'n grooten beker en ik maar een klein kroezeken?

Klaas antwoordde:

--Omdat ik uw vader en de baas van het huis ben.

Doch Uilenspiegel hernam:

--Gij drinkt al veertig en ik nog maar negen jaar; gij hebt al genoeg
gedronken en mijne beurt is gekomen. Geef mij den beker en neem gij
het kroezeken.

--Zoon, sprak Klaas, men giet geen vat bier in een vaatje over
zonder morsen.

--Nu ga dan te werk met verstand en giet uwe kan in mijn tonne,
want mijn buik is grooter dan uw beker, antwoordde Uilenspiegel.

En lachend liet Klaas hem zijn beker ledigen. En zoo leerde
Uilenspiegel listig worden om bier te krijgen.




XV.

Onder haren gordel droeg Soetkin het kenmerk van een nieuwe
bevruchting; ook Katelijne was zwanger, maar zij dorst heur huis
niet verlaten.

Soetkin ging haar bezoeken.

--Ach! sprak zij jammerend, wat ga ik aanvangen met de ongelukkige
vrucht van mijn lichaam? Moet ik het wichtje versmachten? Ik zou
het besterven! Maar zoo ik een kind heb zonder getrouwd te zijn,
zullen de serjanten mij pakken. Ik zal, als een ontuchtige deerne,
twintig gulden moeten betalen, en op de groote markt gegeeseld worden.

Om haar te troosten, sprak Soetkin heur eenige zoete woorden
toe. Bezorgd en nadenkend keerde zij huiswaarts. Op een morgen sprak
zij tot Klaas:

--Zoudt ge mij slaan, Klaas, als ik u twee kindjes schonk in stee
van maar één?

--Dat weet ik niet, antwoordde Klaas.

--Maar, sprak Soetkin, als het tweede kindje niet uit mijn lichaam
kwam en, gelijk dat van Katelijne, verwekt was door een onbekende,
door den duivel misschien?

--De duivel, antwoordde Klaas, verwekt wel vuur en dood en rook,
maar geen kinderen. Het kind van Katelijne zal ik als het onze aanzien.

--Zoudt gij dat? vroeg zij.

--Gelijk ik u zeg, hernam Klaas.

Soetkin ging die goede mare aan Katelijne kondschappen en uiterst
gelukkig en opgetogen riep deze uit:

--De goede man heeft gesproken voor 't heil van mijn lichaam. God zal
hem zegenen, en ook de duivel, sprak zij huiverd, als 't een duivel
is, die U verwekte, arm schaapje, dat in mijn boezem leeft.

Soetkin bracht een zoon en Katelijne eene dochter ter wereld. Beiden
werden ten doop gebracht als zoon en dochter van Klaas. De knaap werd
Hans genoemd, maar bleef niet in leven; het meisje werd Nele geheeten
en groeide flink op.

Aan vier bekers dronk zij levenssap: aan de borsten van Soetkin en
aan die van Katelijne. En een zoete strijd ontstond tusschen de twee
vrouwen, om de kleine de borst te mogen geven. Maar tot haar groot
leed, moest Katelijne heure melk laten verdrogen, want men hadde heur
gevraagd van waar die kwam, zonder dat zij moeder was.

Als Nele gespeend was, nam Katelijne heure dochter bij zich en liet
haar niet eerder naar Soetkin gaan, dan nadat zij heur "moeder"
genoemd had.

En de buren zeiden, dat het schoon was van Katelijne, die have en
goed bezat, het kind op te voeden, want Soetkin en Klaas leefden
veelal in kommer en armoe.




XVI.

Op zekeren morgen was Uilenspiegel alleen thuis. Hij verdroot zich
geweldig, en nam een schoen van zijn vader, om er een schuitje van
te maken. De groote mast stond reeds vast in de zool en Uilenspiegel
ging een gat snijden in 't overleer, om den boegspriet te plaatsen,
toen hij over 't halfdeurken het hoofd van een ruiter en den kop van
een peerd zag.

--Is hier niemand? vroeg de ruiter.

--Ja, antwoordde Uilenspiegel, een mensch, een halve mensch en een
paardekop.

--Hoezoo? vroeg de ruiter.

Uilenspiegel sprak:

--Wel, ik zie hier een heelen mensch en die ben ik; verder zie ik
een halven mensch, te weten, uw hoofd en borst, en daarbij nog den
kop van uw peerd.

--Waar zijn uw vader en moeder? vroeg de man.

--Vader gaat van kwaad tot erger en moeder is bezig met ons in scha
of schande te brengen.

--Dat begrijp ik niet, sprak de ruiter.

Uilenspiegel hernam:

--Vader graaft de voren van zijn land dieper, om de jagers, die zijn
koren plat trappen, van kwaad in erger te doen vallen. Moeder is geld
gaan leenen: geeft zij te veel weer, dan is het ons scha en geeft ze
te weinig, dan is het ons schande.

Toen vroeg de man hem den weg.

--Daar, waar de eenden gaan, antwoordde Uilenspiegel.

De ruiter ging heen, doch als Uilenspiegel bezig was met van Klaas'
tweeden schoen eene galei te maken, kwam hij terug.

--Gij hebt mij bedrogen, sprak hij; daar waar de eenden zijn, is het
modder en veengrond, waarin zij ploeteren.

Uilenspiegel antwoordde:

--Ik zei u niet van te rijden waar zij ploeteren, doch daar waar
zij gaan.

--Wijs mij ten minste den weg, die naar Heist gaat, sprak toen de man.

--In Vlaanderen, zei Uilenspiegel, zijn 't de menschen die gaan,
en de wegen blijven liggen.




XVII.

Op zekeren dag sprak Soetkin tot Klaas:

--Man, ik heb den dood op het lijf. 't Is nu al drie dagen, dat Thijl
uit den huize is. Waar mag hij wel zijn?

Treurig antwoordde Klaas:

--Hij is waar de straathonden zijn, op den grooten weg, met nietdeugen
van zijne soort. God was vol wreedheid, toen hij ons zulk een zoon
gaf. Toen Thijl ter wereld kwam, zag ik in hem de vreugd van onzen
ouden dag, een werktuig te meer in ons huis; ik meende hem een
handwerk te leeren, maar 't boosaardige noodlot maakt hem tot een
schelm, een dagdief.

--Wees niet te gestreng, man, sprak Soetkin. Onze zoon is maar negen
jaar, hij is nog in den roes van de eerste jeugd. Moet hij, als de
boomen, niet eerst zijne hulsels afwerpen, alvorens zich te kunnen
tooien met zijne bladeren, die, voor den boom des volks, de eer en de
deugd zijn? 't Is een kleine guit, ik weet het, maar zijne slimheid zal
hem later te goede keeren, als hij ze tot een of ander goed ambacht
aanwendt, in stee van ze tot kwade parten te gebruiken. Hij steekt
geerne den draak met een ieder; maar later zal hij zijn plaats vinden
in een lustige broederschap. Hij lacht gedurig; maar de gezichten,
die zuur zien vóór hunne rijpheid, zijn een slecht voorteeken voor
later. Zoo hij loopt, is 't dat hij zulks noodig heeft om te groeien;
zoo hij niet werkt, is het dat hij nog niet begrijpt, dat werken een
plicht is en als hij somwijlen dag en nacht, een halve week uitblijft,
is het dat hij niet beseft hoeveel verdriet hij ons aandoet, want
hij heeft een goed hart en ziet ons geerne.

Klaas schudde het hoofd en antwoordde niet, en toen hij sliep,
lag Soetkin te weenen. En 's morgens, als zij dacht dat haar zoon
wellicht ergens aan den weg ziek lag, ging zij op den dorpel der
deure zien of hij niet afkwam; maar zij zag hem niet en zij zette
zich aan 't venster, om van daar naar de straat te kijken. En meer
dan eens bonsde heur het hert in de borst, als zij den lichten stap
van een kind hoorde; maar als de kleine voorbijging en zij zag dat
het Uilenspiegel niet was, weende zij weer, de arme moeder.

Doch Uilenspiegel was, met zijn deugnieten van kameraden, te Brugge
op de Zaterdagsmarkt.

Daar zag men leerzenmakers en schoenlappers in hunne kramen,
kleermakers met hoozen, wambuizen, bovenkerels; Antwerpsche
meezenvangers, die 's nachts met een uil ter vogelvangst gaan; daar
waren kooplui in wild, hondenvangers, verkoopers van kattevellen voor
handschoenen, borstlappen en kragen, en koopers uit alle standen,
poorters en poorteressen, knechten en dienstmaagden, broodmeesters,
botteliers, eierboeren en -boerinnen en men hoorde ze, ieder op zijn
wijs, vragen en bieden, de waren prijzen en afkeuren.

In een hoek van de markt was een schoone lijnwaden tente opgericht op
vier palen. Aan den ingang van die tente stond een boer uit het Land
van Aalst--met twee monniken naast zich om het geld te ontvangen--die
voor een oortje aan de nieuwsgierigen een stukje van het schouderblad
van de heilige Maria van Egypte liet zien. Met schorre, heesche stemme,
roemde hij de verdiensten der gelukzalige; in zijnen lofzang vergat
hij zelfs niet te zeggen hoe ze eens, bij gebreke aan geld, een jongen
veerman, die haar overgezet had, betaalde met schoone munt der nature,
om Gods gebod, omtrent het loon der werklieden, niet te overtreden.

En de twee monniken knikten om te bevestigen, dat de boer waarheid
sprak. Naast hen stond een groot, dik wijf, met een rood gezicht,
als Astarte zoo wulpsch, een oorverdoovend lawaai te maken op een
gebarsten doedelzak, terwijl een lieftallig meisje naast haar zong
als een nachtegaaltje, doch op haar lette niemand. Aan den ingang
van de tent wiegelde eene kuip, met de beide ooren aan twee staken
vastgemaakt. Als het wijf in hoogdravende woorden vertelde, dat het
eene kuip wijwater was, die van Rome kwam en de monniken weer knikten
om hare woorden te staven, verviel Uilenspiegel in diepe overpeinzing.

Aan een van de palen der tente stond een ezel gebonden, die meer hooi
dan haver kreeg: met hangenden kop zag hij naar de aarde, maar zonder
hoop er distels te zien opschieten.

--Jongens, riep Uilenspiegel, naar het wijf, de twee paters en 't
weemoedige grauwtje wijzend, vermits de meesters zoo goed zingen,
moet de ezel dansen. En hij liep naar een winkel, en kwam met zes
duiten peper. Toen hief hij den steert van den ezel op en wreef er
de peper onder.

Als het beest de peper gevoelde, keek het omme, om te zien van waar
die ongewone warmte kwam. Het meende, dat het den vuurduivel achter
de hielen had en wilde loopen om hem te ontvlieden; dan begon het
dier te balken en te stampen en uit al zijne kracht aan den paal te
trekken. Bij den eersten schok ging de kuip los, die tusschen de
twee haken hing, en al het wijwater kletste op de tent en op hen,
die er in waren. Weldra stortte de tent in en de aanwezigen, die naar
de geschiedenis van Maria van Egypte luisterden, lagen als onder een
natten mantel begraven. En Uilenspiegel en zijne vrienden hoorden van
onder het doek groote beroering en geweeklaag, want de geloovigen,
die binnen waren, beschuldigden malkander de kuip omvergetrokken
te hebben, en wit van woede brachten ze elkander vele vuistslagen
toe. Men zag het doek van de tente op en neer gaan, en telkens als
Uilenspiegel op het doek een ronden vorm zag uitkomen, stak hij er in
met eene speld. Dan hoorde hij grootere kreten en grootere uitdeeling
van vuistslagen onder de tente.

En hij had dolle pret en het meest toen hij den ezel zag wegloopen met
doek, met kuip en met palen achter zich aan, terwijl de baas van de
tent, zijn wijf en zijn kind zich vastklampten aan den sleep van den
ezel. Eindelijk kon het dier niet meer voort, het begon erbarmelijk
te balken en te stampen, en hield maar op om onder zijn steert te
zien of het vuur, dat er brandde, niet haast gebluscht was.

Maar de kwezelaars vochten voort en zonder aan hen te denken,
scharrelden de monniken het geld bijeen, dat uit de schaal gevallen
was.

Uilenspiegel hielp devotelijk mee, doch niet zonder profijt.




XVIII.

Terwijl de zoon van den kooldrager als een schalk opwies, bracht de
ziekelijke zoon van den grooten keizer zijne dagen in droefgeestigheid
door. Edelvrouwen en heeren zagen hem, door kamers en gangen van 't
paleis van Vallodolid, zijn armzalig lichaam op waggelende beentjes
voortsleepen, alsof hij moeite had de zwaarte te dragen van zijn
groot hoofd, met stekelig blond haar bedekt.

Steeds zocht hij de donkere gangen op en bleef er uren lang zitten, met
de beenen uitgestrekt. En als een dienstknecht er uit onachtzaamheid
op trapte, liet hij hem geeselen, en als hij hem hoorde huilen van
pijn, deed het hem goed, maar hij lachte niet.

's Anderen daags haalde hij elders in de gangen van het paleis
dezelfde streken uit. Edelvrouwen, heeren en schildknapen, die hem
voorbijgingen, deed hij struikelen, en als zij vielen en zich bezeerden
deed hem dat genoegen, maar hij lachte niet.

En zoo iemand hem aanraakte en niet viel, huilde hij alsof hij geslagen
was: en de ontsteltenis ziende, was hij blij, maar hij lachte niet.

Zijne Majesteit hierover verwittigd, beval, dat men geen acht op den
infant moest geven, zeggende, zoo hij niet wilde dat men hem trapte,
hij zijne voeten niet moest zetten waar eens anders beenen gingen.

Zulks mishaagde Philippus, doch hij zei niets; men zag hem niet meer,
tenzij in den tuin, wanneer hij, bij helderen zomer dag, zijn schraal
lichaampje in de zonne ging warmen.

En als keizer Karel, van den oorlog teruggekeerd, zijn zoon vol
somberheid zag zitten, sprak hij:

--Mijn zoon, hoe zeer verschilt gij van mij! Op uwen leeftijd klom ik
op de boomen achter de eekhoorntjes; met een koord liet ik mij langs
steile rotsen glijden om arendsnesten te ledigen. Ik kon er het leven
bij inschieten, maar mijn lichaam werd er des te sterker om. Op de
jacht vluchtten de wilde dieren, als ze mij zagen met mijn vuurroer.

--Ach! zuchtte de infant, 'k heb buikpijn, heer vader.

--Paxarete-wijn is een uitstekend geneesmiddel tegen de buikpijn,
sprak Karel.

--Dien wijn lust ik niet; 'k heb hoofdpijn, heer vader.

--Mijn zoon, zei Karel, gij moet loopen, springen, stoeien, zooals
de andere kinderen van uwen leeftijd doen.

--Mijne beenen zijn stijf, heer vader.

--Kan het anders? sprak Karel, gij maakt er houten beenen van. Wacht,
ik ga u vastbinden op een vurig peerd.

De infant weende.

--Bind mij niet vast, sprak hij, ik heb pijn aan de lenden, heer vader.

--Maar, vroeg Karel, hebt gij dan overal pijn?

--Het zou niets zijn, zoo men mij gerust liet, zegde de infant.

--Denkt gij soms, hernam de keizer ongeduldig, uw koninklijk leven als
de poëten in mijmering door te brengen? Laat hen hunne perkamenten
met inkt bemorsen, in stilte, eenzaamheid en bespiegeling; aan u
zoon van het zweerd, behoort het warme bloed, het oog van den arend,
de list van den vos, de kracht van een Hercules. Waarom maakt gij het
teeken des kruises? Een leeuwenwelp mag geen paternosterknauwer zijn!

--Het Angelus, heer vader, antwoordde de infant.




XIX.

Bloei- en Zomermaand waren dat jaar oprecht de maanden der
bloemen. Nooit zag men, in Vlaanderen, zulke welriekende hagedoornen,
in de hovingen zooveel rozen, jasmijn en kamperfoelie. Als de
Westenwind de geuren van dat bloemenland naar 't Oosten dreef, stak
iedereen, en meest nog in Antwerpen, verrukt den neus omhoog, zeggende:

--Riekt gij dien goeden wind, die uit Vlaanderen waait?

Onverpoosd waren de vlijtige bijen bezig met honig uit de bloemen te
zuigen, was te maken, het broedsel te verzorgen in de korven, te weinig
in aantal om al de zwermen te bergen. Heerlijke muziek van den arbeid
onder den blauwen hemel, die schitterend den rijken bodem overdekte!

Men maakte rieten, strooien, wisschen bijenkorven. Mandenmakers,
kuipers, stroovlechters arbeidden van den vroegen morgen. En de
kastenmakers konden bijlange het bestelde werk niet afdoen.

De zwermen bestonden uit dertig duizend werkbijen en twee duizend
zevenhonderd hommels. De honigraten waren zoo lekker en van zulke
zeldzame hoedanigheid, dat de deken van Damme er elf zond aan keizer
Karel, als dankzegging omdat hij, door zijne ordonnantiën de Heilige
Inquisitie weder ingevoerd had. Philippus at de honigraten op, maar
hij had er geen genot van.

Schooiers, bedelaars, rabauwen en heel die bende luiaards, die vadsig
langs de wegen slenteren en zich liever laten opknoopen dan zich aan
eenigerhande bezigheid over te leveren, kwamen van heinde en verre
aanloopen, verlekkerd door den honiggeur. En 's nachts zwierven zij
in groote menigte door velden en hoven.

Klaas had korven gemaakt om er bijenzwermen heen te lokken; eenige
waren gevuld, andere nog ledig. Klaas bleef heel den nacht waken om
op zijn goed te letten. Als hij moede was, zegde hij tot Uilenspiegel
zijne plaats in te nemen. Deze deed het gewillig.

Nu, op een nacht dat het koel was, kroop Uilenspiegel in een ledigen
korf, en gansch ineengedrongen, keek hij door de gaten die er van
boven in waren.

Op 't punt van insluimeren, hoorde hij de haag kraken en de stemmen
van twee manslieden, die hij voor dieven aanzag. Hij keek door een
der gaten van den bijenkorf en zag, dat de beide mannen lang haar
en een langen baard hadden, hoewel een lange baard te dien tijde een
teeken van adel was.

Zij gingen van korf tot korf, en zoo kwamen zij aan den zijnen en
hem optillende, spraken zij:

--Deze is de zwaarste; vervolgens staken zij er hunne stokken onder
en droegen hem mee.

Uilenspiegel vond het geenszins aangenaam, aldus in een bijenkorf
vervoerd te worden. De nacht was donker en de dieven spraken geen
woord. Alle vijftig stappen bleven zij staan om adem te scheppen en
zich vervolgens weder op weg te begeven. Die vóór ging gromde van
kwaadheid omdat de last zoo zwaar woog, en die van achteren, kermde
weemoedig. Want in de wereld zijn twee soorten luiaards: zij, die
kwaad zijn op den arbeid, en zij, die jammeren als er te werken valt.

Uilenspiegel, die niets te doen had, trok den dief, die vóór ging,
bij zijn haar, en den anderen bij zijnen baard, zoodat de grommer
den janker toeschreeuwde:

--Als gij niet ophoudt, aan mijn haar te trekken, geef ik u eene smete
op den kop, dat hij in uwe borstkas valt en gij door uwe ribben kunt
zien, als een dief door de traliën van het Steen.

--Ik deed het niet, vriend, jammerde de janker, gij zijt het die aan
mijnen baard trekt.

De grommer antwoordde:

--Ik zoek geen ongedierte in een schurftigen baard!

--Maat, sprak de janker, doe de korf niet zoo schommelen, mijne armen
houden het niet langer uit.

--Hewel, ik zal ze u van het lijf rukken. En hij trok zijnen riem over
zijn hoofd, zette den korf op den grond en sprong op zijn makker. En
zij vochten, de eene vloekend, de andere om genade smeekende.

Toen Uilenspiegel de slagen hoorde vallen, kroop hij uit den korf,
sleepte dien in een boschje, waar hij hem terugvinden kon, en keerde
toen huiswaarts.

En zoo is het, dat de slimmen voordeel halen uit twist en krakeel.




XX.

Als Uilenspiegel vijftien jaar oud was, bouwde hij te Damme, met
vier palen, eene kleine tent op, en riep dat een iegelijk er zijn
tegenwoordig en toekomstig gelaat kon afgebeeld zien, in een schoone
lijst van hooi.

Wanneer een opgeblazen rechtsgeleerde binnen kwam, zot van eigenwaan,
stak Uilenspiegel zijn hoofd door de lijst en bootste het gezicht
van een ouden aap na; dan sprak hij:

--Een ouden snuit kan rotten, maar geenszins bloeien; ben ik uw
spiegel niet, heer dokter in de rechten?

Als Uilenspiegel tot klant een oudgediende kreeg, liet hij, in stee
van zijn gezicht, in 't midden van de lijst een schotel vleesch en
brood zien, en sprak hij:

--De oorlog zal u tot gehakt maken; wat geeft gij mij om de
voorzegging, o snorrebaard, verzot op sakkers met wijden mond?

En als een oud heertje aan Uilenspiegel zijn poezelig wijfje liet
zien, verborg de snaak zijn gelaat nogmaals en toonde in de lijste een
boompje, aan welks takken messen, koffertjes, kammen en schrijfgerei
hingen, alles van hoorn vervaardigd, en zeide:

--Vanwaar komen die schoone snuisterijen, messire? is het niet van den
horenboom, die groeit in den boomgaard der oude manslieden? Wie zal
nog zeggen, dat horendragers van geenerlei nut zijn in de samenleving?

En Uilenspiegel toonde in de lijste, nevens den boom, zijn jeugdig
gezicht.

Als de ouderling hem hoorde, ontstak hij in hevige woede, doch zijn
vrouwtje paaide hem, en glimlachend vroeg zij aan Uilenspiegel:

--En mijn spiegel, wilt ge hem mij toonen?

--Kom nader, was 't antwoord.

Zij deed het. Toen kuste hij haar waar hij maar kon.

--Uw spiegel, sprak hij, is bloeiende jeugd in trotschheid gehuld.

En de schoone ging heen, en vergat niet hem een paar gulden te geven.

Aan een dikken monnik, die hem vroeg om zijn tegenwoordig en toekomstig
gezicht te zien, antwoordde Uilenspiegel:

--Gij zijt eene hespenkast, en een bierkelder zult gij ook zijn,
want zout noodt tot drinken, niet waar, dikzak? Geef mij een oortje,
omdat ik de waarheid zei.

--Mijn zoon, sprak de monnik, nooit dragen wij geld op ons.

--Dan is het, antwoordde Uilenspiegel, dat het geld u op zich draagt,
want mij is 't bekend, dat gij het steekt tusschen twee zolen, onder
den voet! Geef mij uw riemschoen.

Maar de monnik hernam:

--Mijn zoon, 't is het goed van het klooster. Maar als 't moet,
zal ik u toch twee oortjes geven voor uwe moeite.

De monnik gaf ze en Uilenspiegel nam ze minzaam aan.

Daarna toonde hij ook aan de lieden van Damme, van Brugge, van
Blankenberge, tot zelfs van Oostende, hunnen spiegel.

En in stee van te zeggen in Vlaamsche sprake: "Ik ben Ulieden spiegel",
zei hij kortweg: "Ik ben Ulen spiegel", gelijk thans nog gezegd wordt
in Oost- en West-Vlaanderen.

En zóó kwam hij aan zijn bijnaam Uilenspiegel.




XXI.

Grooter geworden slenterde hij geerne langs kermissen en
jaarmarkten. Zag hij ergens een hobo-, vedel- of doedelzakspeler,
dan liet hij zich voor een oortje leeren, hoe men uit die speeltuigen
welluidende tonen kan halen.

Zeer behendig werd hij in 't bespelen van den rommelpot, een speeltuig
gemaakt met een pot, eene blaas en een rietje, en wel als volgt:
over den pot spant men een natte blaas; een eind van het rietje
wordt met een touwtje gebonden in het middenste van de blaas en het
ander raakt den bodem van van den pot; vervolgens wordt de blaas tot
barstens toe om den pot gespannen. 's Anderen morgens, als de blaas
droog geworden is, kan men er op slaan als op een tamboerijn en zoo
men met het rietje wrijft, bromt het schooner dan de viool.

En Uilenspiegel ging met zijn rommelpot, die het geblaf van wachthonden
nabootste, aan de deur van de huizen kerstliederen zingen, in
gezelschap van kinderen, waarvan een, op Driekoningen, een blinkende
papieren ster droeg.

Als een meester-schilder te Damme kwam om de broeders van een of ander
gilde geknield op het doek te malen, bekroop Uilenspiegel de lust te
zien hoe hij werkte; daarom vroeg hij om zijne verf te mogen wrijven,
en als loon wilde hij slechts eene snee brood, drie duiten en eene
pint kuite aanveerden.

Terwijl hij de verf fijn wreef, ging hij de doenwijze zijns meesters
na. Als deze weg was, beproefde hij te schilderen, maar overal streek
hij scharlakenrood. Hij probeerde ook 't portret te maken van Klaas,
Soetkin, Katelijne en Nele, alsmede van pinten en stoopen. En Klaas
hem aan 't werk ziende, voorzeide, dat hij, zoo hij neerstig wou
zijn, florijnen bij tientallen zou kunnen verdienen met opschriften
te schilderen op de speelwagens in Vlaanderen en Zeeland.

Ook het houtsnijden en steenkappen leerde hij van een meester-metser,
terwijl deze, in het koor van Onze Lieve Vrouwekerk, eenen zetel
kwam maken, derwijze geschikt, dat de oude deken zitten kon zonder
dat iemand het merkte.

Uilenspiegel was het, die het eerst een messenhecht sneed, zooals de
Zeeuwen gebruiken. Hij maakte er een kunstig bewerkt snijwerk van,
met van binnen een doodshoofd en van boven een wakende hond. Hetgeen
zeggen wilde: het hecht getrouw tot aan den dood.

En alzoo begon zich de voorzegging van Katelijne te verwezenlijken,
want Uilenspiegel was nu tegelijk schilder, beeldhouwer, boer en ook
edelman: immers de Klaassen voeren, van vader tot zoon, drie zilveren
pinten in een veld van bruinbier.

Maar Uilenspiegel bleef in alles ongedurig en Klaas zei dat, als dat
spelletje zoo voortging, hij hem de stulp uit zou jagen.




XXII.

De keizer, van den oorlog teruggekeerd, vroeg waarom zijn zoon
Philippus hem niet was komen begroeten.

De aartsbisschop-leermeester van den infant antwoordde, dat hij niet
gewild had, dat hij slechts van boeken en eenzaamheid hield.

De keizer vroeg, wáár hij zich ophield.

De leermeester antwoordde, dat men hem overal zoeken moest, waar het
duister was. Zoo deden zij.

Als zij door menige zalen gegaan waren, kwamen zij eindelijk in een
somber verblijf, door een smal venster verlicht. En op den grond
stond een staak, waaraan een jong en lief aapje vastgemaakt lag,
een diertje dat Zijne Hoogheid uit Indië gekregen had om er mede te
spelen. Smeulende takkebossen lagen rondom en in het vertrek hing
een walm van verkoold haar.

Het diertje, levend verbrand, had zoo verschrikkelijk geleden, dat
zijn lichaampje niet geleek op dat van een wezen dat geleefd had,
maar op een stuk gewrongen en gerimpelden wortel. En op zijn mondje,
dat open was, als om genade te vragen, stond een bloedig schuim,
en zijn arm gezichtje was nat van zijne tranen.

--Wie heeft dat gedaan? vroeg de keizer.

De leermeester dorst niet antwoorden en beiden bleven sprakeloos,
droef en grammoedig staan.

Maar onverwacht werd de stilte door een lichten kuch gestoord, die uit
den donkersten hoek kwam. Zijne Majesteit keerde zich om en zag den
infant Philippus, in 't zwart gekleed bezig een citroen uit te zuigen.

--Don Philippus, sprak hij, kom hier om mij te groeten.

Zonder zich te verroeren, bekeek de infant hem met zijne vreesachtige
oogen, waar geenerlei liefde in blonk.

--Zijt gij het, vroeg de keizer, die dat diertje verbrand hebt?

De infant boog het hoofd.

--Waart gij wreedaardig genoeg om het te bedrijven, wees dan vrank
genoeg om het te bekennen.

De infant zweeg.

Zijne Majesteit ontnam hem den citroen, wierp dien op den grond
en wilde zijn zoon slaan, maar de aartsbisschop hield hem terug,
en fluisterde hem toe:

--Zijne Hoogheid zal later een groote ketterbrander zijn!

De keizer glimlachte en beiden gingen, den infant met zijn aapje
alleen latend.

Maar ook anderen, die geen aapjes waren, kwamen in vlammen om.




XXIII.

De Slachtmaand was gekomen, de kille hoestmaand der borstlijders.

't Is ook de maand, waarin de knapen bij benden over de rapenvelden
heenstormen, om te rooven wat zij kunnen, tot groote schade der boeren,
die ze tevergeefs achternazitten met stokken en vorken.

Op een avond nu dat Uilenspiegel van een strooptocht terugkwam,
hoorde hij in een hoek van den haag, dicht bij hem, een gekerm. Hij
bukte en zag, op eenen steen, een hondeken liggen.

--Wel, mijn beestje, sprak hij, wat doet ge hier zoo spa in den avond?

Hij wilde den hond streelen en hij voelde dat zijn rug nat was. Hij
dacht, dat men hem had willen verdrinken en nam hem in de armen,
om hem te drogen en te koesteren.

Thuis gekomen, sprak hij:

--Hier is een gekwetste, wat moet ik er mee doen?

--Hem verbinden, antwoordde Klaas.

Uilenspiegel zette den hond op de tafel. Klaas, Soetkin en hij zagen
toen, bij het licht van de lamp, dat het diertje eene wond op de
rug had. Soetkin wiesch ze, lei er balsem op en bond er een doek
om. Uilenspiegel nam den hond in zijn bed, hoewel Soetkin hem in
't hare wou hebben, bevreesd dat Uilenspiegel, die woelde als een
duivel in een wijwatervat, in zijn slaap het diertje zou bezeeren.

Maar Uilenspiegel deed zijne goesting; hij verzorgde zijn hond zóó
goed, dat de gekwetste na zes dagen liep zooals de meesten zijner
verwaande natuurgenooten, met den steert omhoog.

En de schoolmeester hiet hem Titus Bibulus Snuffius: Titus in memorie
van zekeren goeden Romeinschen keizer, dewelke dwalende honden placht
op te nemen; Bibulus, omdat de hond eene dronkemansliefde voor kuite
en bruinbier had, en Snuffius omdat hij steeds met den snoet in
rattenholen en mollenritten aan 't snuffelen was.




XXIV.

Aan het einde van de Onze-Lieve-Vrouwestraat stonden twee wilgeboomen
aan den boord van een diepe gracht.

Tusschen de twee wilgen spande Uilenspiegel eene koorde, waarop hij
op een Zondag na de vespers danste, zoo vlug, dat heel de menigte
van straatloopers in de handen kletste. Toen kwam hij beneden en ging
rond met zijn schaaltje, dat met geld gevuld werd, maar hij ledigde
het in de schorte van Soetkin, en hield elf duiten voor zich.

Den volgenden Zondag wilde hij weer op de koorde dansen, maar eenige
bengels, uit nijd over zijne behendigheid, hadden eene snee in de
koorde gegeven, zoodat zij na eenige sprongen brak en Uilenspiegel in
't water tuimelde.

Terwijl hij naar den oever zwom, riepen de kleine koordesnijders
hem toe:

--Hoe gaat het, Uilenspiegel-vlug? Gaat gij nu in den vijver den
karpers leeren dansen?

Uilenspiegel kwam uit het water en schudde zich af. En daar zij uit
angst voor een pak slaag wegliepen, riep hij hun toe:

--Vreest niets; komt Zondag terug, 'k zal U andere kunsten toonen en
gij zult uw deel in de winst hebben!

's Zondags nadien sneden de bengels de koorde niet door, doch hielden
er de wacht bij, opdat niemand ze aanraakte, want er waren toeschouwers
in groote menigte.

Uilenspiegel zei hun:

--Dat ieder mij een zijner schoenen geve, en 'k wed dat ik er mee dans,
zoowel met den grootsten als met den kleinsten.

--En wat betaalt gij, als gij verliest? vroegen zij hem.

--Veertien pinten bruinbier, antwoordde Uilenspiegel, maar gij betaalt
mij drie oortjes als ik win.

--Goed! riepen zij.

En zij gaven hem elk een hunner schoenen. Uilenspiegel legde ze alle
in het voorschoot dat hij aan had en, met dien last, danste hij op
de koorde, doch niet zonder moeite.

Van beneden riepen de koordesnijders:

--Gij hebt gezegd met elk onzer schoenen te zullen dansen; trek ze
aan en houd uwe wedding.

Uilenspiegel danste voort en antwoordde:

--Ik heb niet gezegd uwe schoenen aan te trekken, doch er mee te
dansen. Nu, ik dans, en alles danst mee in mijn voorschoot. Ziet gij
het niet met uwe paddenoogen? Betaalt mij mijn drie oortjes.

Doch zij jouwden hem uit en schreeuwden, dat zij hunne schoenen
moesten terughebben.

Uilenspiegel smeet ze alle te gelijk in een worp naar beneden. Een
woedend gevecht volgde, daar niemand zijn schoen dadelijk terugvinden
kon.

Uilenspiegel kwam naar beneden en begoot de vechters, maar niet met
klaar water.




XXV.

De infant, nu vijftien jaar oud, dwaalde als naar gewoonte door gangen
en trappen en zalen van 't slot. Doch meestal slenterde hij rond de
vertrekken der edelvrouwen, om de edelknapen te verschalken, die,
gelijk hij, als katten in de gangen op loer lagen. Andere jonkers
waren in den tuin, keken verzuchtend omhoog, en zongen eene ballade
van minne.

Als de infant het hoorde, vertoonde hij zich eensklaps aan een der
vensteren, en de arme edelknapen waren ontsteld als zij zijn bleeke
tronie zagen, in stee van de zoete oogen hunner schoonen.

Onder de edelvrouwen van het hof was een lieftallige dame, een
Vlaamsche van Dudzele, omtrent Damme, van ongemeene schoonheid en in
de volheid harer jaren, met oogen, groenig-bruin, en rossig, krullend
haar, dat schitterde als goud. Vroolijk van zin en vurig van aard,
verheelde zij niemand hare neiging tot den gelukkige, wien zij, op
heur aanbiddelijk erf, het hemelsch privilege van liefde schonk. De
uitverkorene heurs herten was een schoon en fier ridder. Elken dag
op vast uur, ging zij tot hem, hetgeen Philippus wist.

Hij zette zich op eene bank tegenover een venster en wachtte. En
als zij hem voorbijging met flikkerend oog en met rozeroode lippen,
en glanzend van jeugd en van liefde in haar kleed van goudbrocaat,
zag zij den infant, die, zonder zich van zijne plaats te verheffen,
tot haar zegde:

--Mevrouwe, hebt gij een oogenblik voor mij?

Driftig als de merrie, die in haren loop gestuit wordt op 't oogenblik
dat zij rent naar den schoonen hengst, die in den beemd hinnikt,
antwoordde zij:

--Hoogheid, een ieder moet gehoorzamen aan Uwen vorstelijken wil.

--Zet U naast mij, sprak de infant.

Onbeschaamd, listiglijk en onbermhertig zag hij haar aan:

--Zeg mij het Onze-vader in Vlaamsche tale; men heeft het mij geleerd,
laas! ik heb het vergeten.

De arme vrouw zegde een Vader-ons, doch tamelijk vlug, maar hij dwong
haar telkens tot langzamer spreken.

En aldus noodzaakte hij heur het tot tienmaal toe te zeggen, aan haar,
die op dit uur aan andere gebeden dacht.

Daarna sprak hij vleiend van heure schoone gouden lokken, van heure
heldere tint, heur klare oogen, maar niets dorst hij zeggen van
heur gevleesde schouderen, noch van haren fraai gevormden boezem,
noch van iets anders.

Zij meende te mogen heengaan en blikte reeds naar den tuin waar zij
haren minnaar wachtte, toen hij vroeg of ze wist welke de deugden
der vrouw zijn?

Daar zij niet antwoordde uit vreeze van verkeerd te spreken, deed
hij het in heure plaats, en zegde hij op den toon van een zedenpreeker:

--Deugden der vrouwe zijn kuischheid, eerzaamheid en ingetogenheid.

Hij ried haar aan zich zedig te kleeden en alles wat heur was,
zorgvuldiglijk te verbergen.

Zij knikte ten teeken van goedkeuring en zeide, dat zij zich voor
Zijne Noordpoolachtige Hoogheid liever met tien berenhuiden dan met
eene el neteldoek bedekken zou.

En terwijl hij onthutst was over dit antwoord, nam zij lachende
de vlucht.

Nochmaals was het vuur der jeugd in de borst van den infant ontbrand:
maar het was dit gloeiende vuur niet, dat de sterke zielen tot groote
daden drijft, noch het zoete vuur, dat de teedere herten doet weenen:
't was een somber vuur uit de helle, door Satan ontstoken. En het
glom in zijne grijze oogen, gelijk de maan boven een kerkhof, in
winternacht. En het brandde hem wreedelijk.

Daar de arme gluiperd geene liefde voor anderen voelde, dorst hij de
edelvrouwen niet aanspreken; toen ging hij naar een afgelegen hoekje,
in een kamertje, met witte muren, slecht verlicht, waar hij gemeenlijk
zijne lekkernijen at en waar een groote menigte vliegen waren, om den
wille van de brokkelingen. Daar streelde hij zichzelven, terwijl hij de
vliegen met den kop tegen de ruiten plette en er met honderden doodde,
totdat zijne vingeren te danig beefden om hunne bloedige bezigheid
voort te zetten. En in die wreede uitspanning vond hij een genot,
mits geilheid en wreedheid twee eerlooze zusteren zijn. Als hij
uit dat hok kwam, was hij nog somberder dan te voren en een ieder
ontvluchtte het bleeke gelaat van dien terugstootenden prins.

En de treurige Hoogheid leed, want slecht herte is smerte.




XXVI.

De schoone vrouwe verliet Valladolid om naar heur slot van Dudzele,
in Vlaanderen, te gaan.

Toen zij, met heuren dikken bottelier, door Damme trok, zag zij een
veertienjarigen knaap, met den rug tegen eene hut geleund, op eenen
doedelzak spelen. Rechtover hem zat een rosse hond, die jammerlijk
huilde, daar die muziek hem niet aanstond. De zonne stond schitterend
aan den hemel. Nevens den knaap zat een aanminnig meisje, dat, bij
elk erbarmelijk gehuil van den hond, in een gulhertigen lach schoot.

Toen de schoone vrouwe en de dikke bottelier voorbij de stulp kwamen,
bezagen zij Uilenspiegel, die blies, Nele, die lachte en Titus Bibulus
Snuffius, die jankte.

--Stoute jongen, sprak zij tot Uilenspiegel, wilt ge wel ophouden
dien armen hond zoo te doen huilen!

Maar Uilenspiegel bezag haar en blies nog harder op zijnen
doedelzak. En Bibulus Snuffius jankte nog jammerlijker, en Nele
schaterlachte nog luider.

De bottelier ontstak in woede, wees naar Uilenspiegel en sprak tot
de edelvrouwe:

--Als ik dat schavuitengebroed eens afroste met de schee van mijn
degen, zou de onbeschaamderik wel ophouden!

Uilenspiegel bezag den bottelier, hiet hem Jan Papzak, om den wille
van zijn dikken buik en ging voort met blazen op zijn doedelzak. De
bottelier liep op hem toe en dreigde hem met de vuist; maar Bibulus
Snuffius vloog op hem af en beet Papzak in het been; van schrik viel
de bottelier op den grond en schreeuwde om hulp.

De dame lachte Uilenspiegel toe en sprak:

--Kunt ge mij zeggen, doedelzakspeler, of de weg, die van Damme naar
Dudzele leidt, niet veranderd is?

Uilenspiegel bleef voortblazen, schudde den kop en bezag de edelvrouwe.

--Maar waarom ziet ge mij zoo strak aan? vroeg zij.

Doch hij speelde voort en sperde de oogen open, alsof hij voor heur
in bewondering stond.

--Zijt gij niet beschaamd, voor een jongen snaak als gij, de vrouwen
aldus te bezien?

Uilenspiegel bloosde een weinig, speelde voort en bekeek heur nog meer.

--Ik heb U gevraagd, hernam zij, of de weg niet veranderd is, die
van Damme naar Dudzele leidt?

--Weleer was hij groen, thans is hij droef en schraal, sedert hij
het geluk mist U te mogen dragen, antwoordde Uilenspiegel.

--Wilt ge mij leiden?

Maar Uilenspiegel bleef zitten, haar steeds aanziende. En als ze hem
zoo snaaksch zag en zoo jong en zoo levendig, vergaf zij hem geerne
zijne woorden. Hij stond op om binnen te gaan.

--Waar gaat gij?

--Mijn beste kleeren aantrekken, antwoordde hij.

--Spoed U dan, sprak de edelvrouwe.

Toen zette zij zich neer op de bank naast de deur; de bottelier deed
zooals zij. Zij wilde tot Nele spreken, maar Nele antwoordde heur niet,
want zij was jaloersch.

Uilenspiegel kwam terug; hij was schoon gewasschen en had een
bombazijnen wambuis aan. Hij zag er flink uit in zijn zondagspak.

--Gaat gij toch mee? vroeg Nele hem.

--Ik ben dadelijk terug.

--Wil ik in uwe plaats gaan? sprak Nele.

--Neen, zegde hij, de wegen zijn vol modder.

--Waarom, vroeg de dame gestoord en insgelijks jaloersch, waarom,
kleine meid, wilt gij hem beletten van mede te gaan?

Nele antwoordde heur niet, maar twee dikke tranen welden in heure
oogen, en treuriglijk en gramstorig bekeek zij de schoone edel vrouwe.

Gevieren begaven zij zich op weg, de dame op hare witte hakkenei
met zwart fluweel getuigd; de bottelier met zijn waggelenden buik;
Uilenspiegel, die de hakkenij bij den breidel hield, en Bibulus
Snuffius, die, met den steert in de lucht, fier naast zijn meester
stapte.

Geruimen tijd reden en gingen zij aldus voort, maar Uilenspiegel was
niet op zijn gemak; stom als een visch snoof hij den fijnen benjoëreuk
op, die opsteeg uit de kleeren van de dame, en hij bekeek, ter sluip,
heur schoon paardentuig, heure zeldzame kleinooden en juweelen, en ook
heur zachtaardig uitzicht, heure schitterende oogen, heuren schoonen
boezem en heur haar, dat als een gouden helmet in de zonne schitterde.

--Waarom zegt gij zoo weinig, vriendje? vroeg zij.

Hij antwoordde niet.

--'t Ware jammer als gij uwe tong verloren hadt, want 'k had U geerne
met een boodschap belast.

--Welke? vroeg Uilenspiegel.

--Gij moet, sprak de dame, mij hier verlaten en naar Koolkerke gaan,
aan den anderen kant van den wind, en aldaar zeggen aan een edelman,
half in 't zwart, half in 't rood gekleed, dat hij mij vandaag niet
mag verwachten, maar Zondag komen moet, te tien uren van den nacht,
in mijn slot, langs de sluippoort.

--Ik ga niet! sprak Uilenspiegel.

--Waarom niet? vroeg de dame.

--Neen, ik ga niet! volhardde Uilenspiegel.

De dame sprak toen:

--Maar waarom toch maakt gij u driftig als een haantje, en wilt
niet gaan?

--Ik ga niet! sprak Uilenspiegel.

--Maar als ik U een gulden gaf?

--Neen! sprak hij.

--Een dukaat?

--Neen.

--Een karolus?

--Neen, sprak Uilenspiegel nog. En toch, voegde hij er bij met
een zucht, zou ik dien liever dan eene mosselschelp in moeder heur
tassche zien.

De dame glimlachte, en eensklaps riep zij uit:

--Ik ben mijne beugeltassche kwijt, een schoone zeldzame tassche van
zijdelaken, met fijne perelen geborduurd. Te Damme had ik ze nog aan
mijne ceintuur bevestigd.

Uilenspiegel verroerde zich niet, maar de bottelier ging naar de
edelvrouwe:

--Mevrouwe, sprak hij, als die jonge schavuit ze gaat zoeken, ziet
gij hem nimmer terug.

--En wie zal dan gaan? vroeg de edelvrouwe.

--Ik, sprak hij, hoewel ik oud van jaren ben.

En terstond ging hij op zoek.

Middag sloeg de klok; 't was drukkend warm en stille en eenzaam in
het ronde. Uilenspiegel sprak geen woord, doch deed zijn nieuw wambuis
uit, om de dame onder de schaduwe van een lindeboom te laten rusten,
zonder dat de koelte van het gras heur kwellen kon. En hij bleef
rechtstaan in verzuchting, naast heur.

Zij zag hem aan en voelde medelijden voor dien blooden jongen,
en vroeg hem of hij niet moede was, zoo lang op zijne jonge beenen
te staan. Hij antwoordde niet, doch liet zich naast heur vallen, en
zij trok hem tot zich, en zijn hoofd rustte op heuren blooten boezem,
en daar lag hij zoo goed, dat zij het als eene zonde beschouwd hadde,
hem te zeggen, dat hij elders een hoofdkussen zoeken moest,

De bottelier kwam intusschen terug, zeggende dat hij de beugeltassche
niet gevonden had.

--Ik heb ze wedergevonden, ik, antwoordde de dame, toen ik van mijn
peerd steeg; in 't vallen was zij aan den stijgbeugel vastgeraakt. En
nu, sprak zij tot Uilenspiegel, leid ons nu recht naar Dudzele en
zeg mij uw naam.

--Mijn patroon, antwoordde hij, is de heer Sint Thijlbert, naam,
die bediedt vlug te been, om te gaan waar het goed is; mijn naam is
Klaas en mijn toenaam Uilenspiegel. Als ge U zelf in mijn spiegel wilt
aanschouwen, zult gij overtuigd zijn, dat er, gansch Vlaanderenland
door, geen schitterender bloem van schoonheid bestaat dan Uwe geurige
bekoorlijkheid.

De dame bloosde van welbehagen en was geenszins verbolgen.

En gedurende die lange afwezigheid weenden Soetkin en Nele bitterlijk.




XXVII.

Toen Uilenspiegel van Dudzele terugkwam, zag hij Nele, aan den
inkoom van de stad, met den rug tegen een hek geleund, en een tros
blauwe druiven in de hand. Een voor een at zij de vruchten, die
haar verfrischten, maar blijken liet zij dit niet. Integendeel, zij
scheen verstoord, want driftig beet zij de druiven van de rist. Zij
was weemoedig, en had zulk een droevig en spijtig gezicht, dat
Uilenspiegel, vol liefde, medelijden kreeg en, stille achter haar,
heur eenen kus in den hals gaf.

Maar zij gaf hem een klinkenden kaakslag in de plaats.

--Die was raak, zei Uilenspiegel.

Zij weende dat de tranen over heure wangen rolden.

--Nele, sprak hij, gaat gij nu de fonteinen aan den ingang van de
stad stellen?

--Loop heen! zegde zij.

--Maar ik kan niet heengaan, als gij zoo weent, liefste?

--Ik ben geene liefste, sprak Nele, en weenen doe ik niet.

--Neen, gij weent niet, maar er komt water uit uwe oogen.

--Wilt gij gaan, sprak zij.

--Neen! zegde hij.

Maar met heure bevende handjes, hield zij heur schort voor 't gezicht;
zij beet er de stof van aan stukken, en heure tranen maakten het nat.

--Nele, vroeg Uilenspiegel, zeg eens, zal het straks schoon weder zijn?

En glimlachend zag hij heur liefderijk aan.

--Waarom vraagt ge mij dat? sprak zij.

--Omdat het spreekwoord zegt: na regen komt zonneschijn, antwoordde
Uilenspiegel.

--Ga, sprak zij, ga bij uw schoone dame met haar zijden kleed, die
hebt gij genoeg doen lachen.

Toen zong Uilenspiegel:


    Hoor ik mijn lieveken krijschen
    't Doet mijn herteken groot verdriet.
    Honig zoo gij haar lachen hoort,
    Peerlen zoo gij heur traantjes ziet....
    Ei, mijn lieveken laat ik niet!...
    En ik geef een bottel ten beste
    Lekkeren Leuvenschen wijn.
    En ik geef een bottel ten beste
    Als Nele vroo wil zijn....


--Gemeene man, sprak zij, gij lacht mij dan noch uit!

--Nele, sprak Uilenspiegel, ik ben een man, dat is waar, maar gemeen
ben ik niet, want onze adellijke familie, eene schepenfamilie, voert
drie zilveren pinten in een veld van bruinbier. Nele, is 't waar,
dat men, in Vlaanderenland, kaaksmeten maait als men kussen zaait?

--Ik spreek u niet aan, zegde zij.

--Waarom doet ge dan uw mondje open om het mij te zeggen?

--Ik ben kwaad, sprak zij.

Uilenspiegel klopte heel zachtjes op heuren rug en sprak:

--Kus een vrouwtje en ze zal u kloppen; klop een vrouwtje en ze zal
u kussen. Kus mij dan, liefste, vermits ik u klopte.

Nele keerde zich om. Hij opende zijne armen en, nog weenend, wierp
zij er zich in en vroeg:

--Zult ge ginder niet meer gaan, Thijl?

Maar hij antwoordde niet, want hij had het te druk met heure bevende
vingeren in de zijne te drukken en, met de lippen, de heete tranen
te wisschen, die uit Nele's oogen vielen als de dikke droppelen van
een stormregen.




XXVIII.

In dien tijd weigerde Gent, de edele stad, haar aandeel te betalen
in de bede, die haar zoon, keizer Karel, heur vroeg. Zij kon niet
betalen, want zij had geen geld meer, en dit was de schuld van Karel
zelf. Toch was dat een groote misdaad, en hij besloot haar in persoon
te gaan kastijden.

Want de slagen, die eene moeder het zeerst doen, zijn die van heuren
zoon.

Frans met den Langen Neus, zijn vijand, deed hem het aanbod om
door Frankrijk te gaan. Karel nam het aan, en in stee van te
worden gevangengezet, werd hij op vorstelijke wijze onthaald en
gevierd. Altijd zijn de vorsten bereid elkander te helpen, om 't volk
te onderdrukken.

Karel verbleef langen tijd te Valencijn, zonder eenig teeken van
toorn te geven. De stad Gent, zijne moeder, leefde zonder vrees in
het geloof, dat de Keizer, haar zoon, vergeten zou, wijl zij gehandeld
had volgens recht.

Karel kwam onder de muren van de stad met vier duizend peerden. Alva
was bij hem, alsmede de prins van Oranje. Het gemeen en de kleine
ambachten hadden geerne die kinderlijke intrede belet en de tachtig
duizend man van de stad en den bijvang op de been gebracht; maar de
hoogpoorters verzetten zich daartegen, want zij vreesden, dat het volk
de overhand zou krijgen. Nochtans had de stad Gent haren zoon met zijne
vier duizend peerden in de pan kunnen hakken. Maar zij beminde hem nog,
en de kleine ambachten zelven hadden weder vertrouwen gekregen.

Karel ook had haar lief, maar 't was om het geld, dat hij van haar
in zijne kisten had en nog van haar trekken wilde.

Toen hij zich meester gemaakt had van de stad, stelde hij overal
krijgswachten en liet hij dag- en nachtronden doen. Daarna sprak hij,
in groote statie, de sententie over de stede uit.

De voornaamste poorters moesten vóór zijnen troon vergiffenis komen
vragen, met een strop om den hals; Gent werd schuldig verklaard aan
de ergste misdaden, dewelke zijn: ontrouw, inbreuk op de tractaten,
ongehoorzaamheid, muiterij, opstand en majesteitsschennis. De keizer
verklaarde alle geschonken privileges, rechten, vrijheden, costumen
en gebruiken verbeurd en, de toekomst verbindende alsof hij God zelf
was, bepaalde hij verder, dat zijne opvolgers, bij hunne komst als
landheer, zweren moesten niets te zullen naleven dan de vernederende
Karolijnsche Concessie, door hem aan de stad verleend.

De abdij van Sint-Baafs deed hij afbreken, om ter plaatse eene vesting
te bouwen, van waar hij, gemakkelijk, de borst zijner moeder met
kogels kon doorboren.

Als een slechte zoon, die met ongeduld naar den dood zijner ouderen
wacht, verbeurde hij alle goederen en eigendommen van Gent, inkomsten
en panden, geschut en oorlogstuig.

En hij vond, dat de stad te goed verdedigd was: daarom deed hij den
Rooden Toren, den Paddenhoektoren, de Braampoort, de Steenpoort,
de Walpoort, de Ketelpoort en vele andere poorten afbreken, dewelke
als meesterstukken van bouwkunst en beeldhouwkunst doorgingen.

En als later vreemdelingen naar Gent kwamen, spraken zij verbaasd
tot elkaar:

--Is dàt Gent, die platte en treurige stad? Men vertelde er ons
wonderen van: men heeft ons bedrogen.

En die van Gent antwoordden:

--Keizer Karel heeft de stad heure krone ontnomen.

En dit zeggende, waren zij grammoedig en beschaamd. En uit het puin
van de poorten haalde de keizer steenen voor zijne vesting.

Hij wilde, dat Gent arm werd, daar aldus de stad noch door arbeid,
noch door handel of geld, zich tegen zijne stoutmoedige inzichten
verzetten kon; daarom veroordeelde hij haar tot het betalen van het
geweigerde aandeel in de schatting van vierhonderd duizend gouden
karolusgulden en, daarboven, honderd vijftig duizend karolussen in
eens, en elk jaar nog zes duizend als eeuwigdurende rente. Hij had
geld van de stad in leening gekregen en moest haar voor hetzelve
eene rente betalen van honderd vijftig pond grooten. Met geweld deed
hij zich de schuldbrieven overhandigen en verscheurde ze. En op die
manier betaalde hij zijne schuld.

In menige aangelegenheid had Gent hem lief gehad en geholpen. Maar
hij stak haar eenen dolk in de borst, om bloed te hebben, daar hij
geene melk meer vond.

Toen bezag hij Roeland, de schoone klokke, en aan haren klepel liet hij
den poorter opknoopen, die storm geluid had, om de stad ten strijde
te roepen, ten einde heur recht te verdedigen. Geene genade had hij
voor Roeland, de fiere klokke, de tong zijner moeder, waarmee zij
tot Vlaanderen sprak:


    Als men my slaat dan is 't brandt,
    Als men my luydt dan is 't storm in Vlaenderland.


Mits zijne moeder te luide sprak, nam hij de klokke weg. En die van
't platteland zeiden, dat Gent dood was, dat heur zoon, met eene tang,
heure tong uit heuren mond had gerukt.




XXIX.

Op een van die dagen,--heldere en frissche lentedagen, als heel de
aarde liefde ademt,--zat Soetkin bij het open venster te naaien,
neurde Klaas een deuntje, terwijl Uilenspiegel bezig was met Titus
Bibulus Snuffius eene rechterskap op te zetten. De hond ging met
zijne pooten te werk, alsof hij eene sententie moest uitspreken, maar
't was alleen om den hoed af te krijgen.

Doch eensklaps sprong Uilenspiegel naar het venster en deed het
dicht. Klaas en Soetkin keken op en zagen hun zoon rond de kamer
loopen, op tafels en stoelen springen om een vogeltje te vangen,
dat, met trillende vleugelen en piepend van angst, in den hoek van
een balk aan de zoldering eene schuilpaats ging zoeken.

Uilenspiegel wilde het diertje grijpen, toen Klaas hem met ruwe
stemme vroeg:

--Waarom springt gij aldus?

--Om het te vangen, antwoordde Uilenspiegel, het in eene kevie te
zetten, zaad te geven en voor mij te doen zingen.

Maar de vogel piepte van angst, vloog weer rond de kamer en bezeerde
zijn kopje tegen de ruiten.

Daar Uilenspiegel niet ophield met grijpen en springen, pakte Klaas
hem ruw bij den schouder.

--Vang het beestje, sprak hij, doe het voor u zingen, maar ik zal
u ook in eene kooi steken, met kloeke ijzeren staven gesloten en ik
zal ook u doen zingen. Gij, die zoo geerne loopt, wordt opgesloten;
in de schaduw gestoken als gij koude hebt, in den zonneschijn als
gij het warm hebt. En op een Zondag zullen wij uitgaan en vergeten u
eten te geven, en als wij 's Donderdags terugkomen, zullen wij Thijl,
gestorven van honger, met de beenen uitgestrekt vinden.

Soetkin weende, Uilenspiegel vloog naar het venster.

--Wat doet gij? vroeg Klaas.

--Het venster open doen om den vogel buiten te laten, antwoordde hij.

Inderdaad, de vogel, een distelvink, vloog het venster uit, tjilpte
blijde in de vrije lucht, en steeg als een pijl naar omhoog. Dan
ging hij op een perelaar zitten, waar hij zijne vleugelen streek en
zijne pluimen schudde en grammoedig, in zijne vogeltaal, Uilenspiegel
allerlei verwenschingen naar het hoofd stuurde.

Toen sprak Klaas:

--Mijn zoon, nooit moogt ge aan mensch of dier de vrijheid ontnemen,
want die is het hoogste goed. Laat een iegelijk de zonne zoeken als hij
koude heeft, en de schaduw als hij het warm heeft. En God oordeele
Zijne Heilige Majesteit, die het vrije geloof in Vlaanderenland
aan ketenen legt en Gent, de edele stad, in een ijzeren kooi van
slavernije sluit!




XXX.

Philippus was getrouwd met Maria van Portugal, wier bezittingen hij
bij de Spaansche krone gevoegd had; van haar had hij don Carlos,
den wreedaardigen zot. Maar liefde gevoelde hij voor zijne vrouw niet.

De koningin leed aan de gevolgen van heure kraam. Zij bleef te bed en
bij haar waren heure eeredames, onder dewelke de hertoginne van Alva.

Philippus liet heur dikwijls alleen, om ketters om hals te zien
brengen. De edelvrouwen en kamerheeren deden als hij. En zoo ook de
hertoginne van Alva, de adellijke baker van Maria.

In dien tijd vatte de officiaal een Vlaamschen beeldhouwer,
Roomsch-katholiek van geloove, omdat een monnik hem den overeengekomen
prijs voor een houten Lieve-Vrouwenbeeld geweigerd had, en nu het
aangezicht van het beeld met zijnen beitel had geschonden, zeggende:
dat hij liever zijn werk vernielde, dan het te laten onder den prijs.

Door den monnik als beeldschenner aangeklaagd, werd hij zonder genade
op de pijnbank gelegd, en veroordeeld om levend te worden verbrand.

Op de pijnbank had men hem de voetzolen geroosterd en onderwege,
van het gevang naar den brandstapel, met den san benito op het hoofd,
riep hij gedurig:

--Snijdt mijne voeten af! Snijdt mijne voeten af!

En van verre hoorde Philippus die bange kreten, en hij trilde van
genot, maar hij lachte niet.

De eeredames verlieten koningin Maria om de voltrekking van het vonnis
bij te wonen: na haar volgde de hertoginne van Alva, die bij het hooren
van de kreten van den Vlaamschen kunstenaar, ook het schouwspel wilde
zien en de Koningin alleen liet.

Toen Philippus, zijne hooge dienaren, prinsen, graven, schildknapen en
hofdames dáár waren, werd de beeldhouwer met een lange keten aan een
paal geklonken, te midden van een vuur, gemaakt van rijshout en stroo,
dat hem langzaam moest braden, terwijl hij zich zoo verre mogelijk
van het laaie vuur wilde houden.

Hij was zoo goed als naakt, en nieuwsgieriglijk keek men hoe hij
beproefde zijne zielskracht te stellen tegen de hitte des vuurs.

En middelerwijl had Maria dorst. Zij zag een halven meloen op eene
schaal liggen, sleepte zich uit heur bedde, greep de vrucht en verslond
die gulzig.

De verkoelende vrucht deed de kraamvrouw huiveren. Zij bleef op de
vloer liggen, ze kon zich niet bewegen.

--Ik zou mij verwarmen, was hier iemand om mij te bedde te leggen?

Toen hoorde zij den armen beeldhouwer schreeuwen:

--Snijdt mijne voeten af!

--Ach! riep de arme vorstinne, is dat een hond, die huilt om mijnen
dood te voorspellen?

Op dat oogenblik zag de beeldhouwer rondom zich; doch hij bespeurde
niets dan vijandige Spaansche gezichten, en hij dacht aan Vlaanderen,
het land van de dapperen; en, zijne lange keten achter zich sleepend,
stapte hij naar den vuurgloed van stroo en van rijshout. Zich in zijn
gansche lengte verheffend en de armen kruisend sprak hij:

--Ziet hoe de Vlamingen sterven onder het oog van de Spaansche
beulen! Snijdt niet mijne, maar hunne voeten af, opdat ze naar
geen nieuwe euveldaden loopen! Leve Vlaanderen! Vlaanderen in der
eeuwigheid!

En de edelvrouwen juichten hem toe, vroegen genade voor hem, als ze
zijne fiere houding zagen.

En de kunstenaar stierf.

Koningin Maria rilde over gansch heur lichaam, heure tanden klapperden
van koude en, armen en beenen uitrekkend, kreunde zij:

--Legt mij te bedde, dat ik mij verwarme. En zij stierf.

En alzoo, volgens de voorzegging van Katelijne, de goede tooveres,
zaaide Philippus overal dood, bloed en tranen.




XXXI.

Maar Uilenspiegel en Nele hadden elkander innig lief.

Het was op 't einde van de Grasmaand; al de boomen stonden in bloei,
de planten waren in lichtgroen gedost, de nachtegalen kwinkeleerden
in het loover: de heele natuur had zich gereedgemaakt om de Meimaand
waardig te ontvangen.

Dikwerf dwaalden Uilenspiegel en Nele getweeën langs de wegen. Nele
ging aan Uilenspiegel's arm en hield hem met hare twee handjes
vast. Uilenspiegel had dit geerne en sloeg soms zijn arm om Nele's
middel, om heur beter vast te houden, zegde hij. En dit deed heur
genoegen, doch zij uitte geen woord.

De wind voerde den balsemgeur der beemden over de wegen; in de verte
loeide traagzaam de zee. Uilenspiegel stapte fier vooruit; als een
jonge duivel, en Nele volgde schuchter als eene heilige uit den hemel,
beschaamd over 't genot dat zij smaakte.

Zij leunde heur hoofdje op den schouder van Uilenspiegel: hij nam
heure handjes in de zijne en kuste heur, al gaande, op het voorhoofd,
op de koonen en op heuren liefelijken mond. Doch zij uitte geen woord.

Het werd warm en zij kregen dorst; zij gingen melk drinken bij eenen
boer, maar zij waren niet verkoeld.

En zij zetten zich neer in het gras, aan den boord eener gracht. Nele's
gelaat was bleek en zij scheen bekommerd; angstig keek Uilenspiegel
heur aan.

--Zijt ge droef? sprak zij.

--Ja, antwoordde hij.

--Waarom? vroeg zij.

--Ik weet het niet, sprak hij, maar die bloesem van appelaars en
kriekelaars, die zoele lucht als bezwangerd met het vuur van den
bliksem, die blozende madeliefjes in de beemden, die witte hagedoorn,
hier dicht bij ons....

... Wie zal mij zeggen waarom ik heel ontroerd ben, waarom ik mij
steeds bereid voel tot sterven of slapen? En mijn hert klopt hevig als
ik de vogelen hoor zingen, als ik zie dat de zwaluwen terugkeeren; ik
zou willen vliegen, verder dan zon en mane. En nu eens heb ik koud,
dan weer heb ik warm. Ha, Nele! Ik zou niet meer van deze wereld
willen zijn, of duizend levens geven voor haar, die mij heure minne
schenken zou....

Maar zij uitte geen woord en, glimlachend van geluk, keek zij naar
Uilenspiegel.




XXXII.

Op Allerzielen kwam Uilenspiegel uit Onze Lieve Vrouwekerk met eenige
deugnieten van zijn leeftijd. Lamme Goedzak was onder hen verdwaald,
als een lam te midden van de wolven.

Lamme, die op alle Zon- en feestdagen van zijne moeder drie oortjes
kreeg, trakteerde de jonge snaken.

Hij trok dus met hen in het Roode Schild, bij Jan van Liebeke, die
Kortrijkschen dobbelen knollaard opbracht.

De drank verhitte hunne hersenen en, wijl zij over kerken en gebeden
spraken, uitte Uilenspiegel de meening, dat zielmissen enkel voordeel
brengen aan de priesters.

Maar er was een judas onder 't gezelschap: hij ging Uilenspiegel als
ketter verklikken. En ondanks de tranen van Soetkin en het smeeken van
Klaas, werd Uilenspiegel gepakt en gevangengezet. Eene maand en drie
dagen bleef hij in den kerker opgesloten, zonder iemand te zien. De
cipier at de drie kwart van zijn eten op. Intusschentijd deed men
onderzoek over het gedrag van den beklaagde. Er werd alleen bevonden,
dat hij een meedoogenlooze spotter was, die met iedereen gekscheerde,
maar dat hij nooit het minste kwaad gesproken had noch van den Heere
God, noch van de Maagd Maria, noch van de santen. Weshalve de sententie
dan ook zacht was; want men hadde hem kunnen brandmerken of geeselen
met schorpioenen.

Om den wille van zijn jeugdigen leeftijd, veroordeelden de rechters
hem enkel om, in zijn hemde, barrevoets en blootshoofds en met eene
waskeers in de hand, achter de priesters te stappen, in 't midden
van de eerste processie, die zou uitgaan.

Het was Ons-Heeren-Hemelvaart.

Als de processie binnentrok, moest hij in 't portaal van
Onze-Lieve-Vrouwekerk blijven staan en uitroepen:

--Dank zij Jezus-Christus! Dank zij de eerweerde geestelijken! Hunne
gebeden zijn zoet en verkwikkend voor de zielen in 't vagevuur; want
elk ave is een emmer water, die haar op den rug valt, en elk pater
eene kuip.

En het volk aanhoorde hem devotelijk, doch niet zonder lachen.

Op den Eersten-Sinksendag, moest hij nogmaals de processie volgen; hij
was barrevoets en blootshoofds, in zijn hemde, met eene waskeers in de
hand. Bij het binnengaan in 't portaal, met zijne keers eerbiediglijk
in de hand, hoewel hij moeite deed om niet in lachen uit te bersten,
sprak hij met een luide en heldere stem:

--Zoo de gebeden der christenen veel verlichting brengen
aan de zielen van 't vagevuur, zoo geven die van den deken van
Onze-Lieve-Vrouwekerk--een heilig man die alle deugden beoefent--zulk
eene verkwikking aan de smerten des vuurs, dat dit laatste seffens in
ijs verandert. Maar de duivelen, die het vuur moeten poken, krijgen
er geen zier van.

En weer luisterde het volk devotelijk, doch niet zonder lachen,
en de deken glimlachte inwendiglijk.

Verder werd Uilenspiegel voor drie jaren uit Vlaanderenland gebannen;
hem werd tevens opgelegd eene bedevaart naar Rome te doen en terug
te komen met de Pauselijke absolutie.

Klaas moest drie gulden voor deze sententie betalen, maar hij gaf er
nog eenen aan zijn zoon en daarboven eene pelgrimspij.

Op den dag van 't vertrek was Uilenspiegel 't hert in, toen hij
Klaas en Soetkin kuste, want ze schreide bitter, de arme moeder. Zij
deden hem uitgeleide tot verre op den weg, in gezelschap van meerdere
poorters en poorteressen.

Toen Klaas terug in de hut trad, sprak hij tot Soetkin:

--Vrouwe, 't is toch wreed een zoo jongen knaap tot zulke strenge
straf te veroordeelen, en dit voor eenige lichtzinnige woorden.

--Gij weent, man, sprak Soetkin; gij bemint hem meer dan ge wilt laten
blijken, want daar berst gij uit in mannelijke snikken, die de tranen
van den leeuw zijn.

Maar hij antwoordde niet.

Nele was zich in de schuur gaan verbergen, opdat niemand zien zou,
dat ook zij weende om Uilenspiegel. Van verre volgde zij Soetkin en
Klaas, de poorters en poorteressen; en toen zij heuren vriend alleen
zag voortgaan, liep ze naar hem en sprong hem om den hals:

--Ginder zult gij schoone vrouwen vinden, sprak zij.

--Schoon, misschien, antwoordde Uilenspiegel, maar toch zoo frisch
niet als gij, want zij zijn allen verbrand van de zonne.

Lang nog stapten zij samen voort: Uilenspiegel was nadenkend en
prevelde van tijd tot tijd:

--Die zielmissen zullen ze mij betalen.

--Welke missen en wie zal betalen? vroeg Nele.

Uilenspiegel antwoordde:

--Alle dekenen, parochiepapen, geestelijken, kosters en andere
hooge en lage zotskappen, die ons allerhande domheden willen doen
slikken. Was ik een noeste arbeider geweest, dan was ik voor drie jaar
mijn dagloon bestolen, met hunne bedevaart. Maar 't is de arme Klaas,
die betaalt. Mijne drie jaar zal ik hun honderdvoudig betaald zetten;
ik zal hun eene zielmis zingen, die hun aan de ribben zal hangen.

--Laas! Thijl, wees toch voorzichtig, zij zouden u levend verbranden,
antwoordde Nele.

Ik ben vuurvast, antwoordde Uilenspiegel.

En zij namen afscheid van elkander: zij badend in tranen, hij
droefgeestig en gram.




XXXIII.

Toen Uilenspiegel door Brugge, over de Woensdagmarkt kwam, zag hij
daar eene vrouw, die rondgeleid werd door den beul en zijne knechten,
en een groote menigte andere vrouwen, die rondom haar tierden en heur
allerhande vuile beleedigingen toewierpen.

Daar zij boven aan heur kleed roode lapjes en den steen der justitie
met zijne ijzeren ketenen om den hals droeg, begreep Uilenspiegel,
dat het eene vrouw was, die het jeugdig en maagdelijk lichaam van hare
dochteren verkocht had. Men zei hem, dat zij Barbara hiet en getrouwd
was met Jason Darue; dat ze in dit gewaad van de eene plaats naar
de andere gesleurd werd, totdat zij terugkwam op de Groote Markt,
waar het schavot voor haar gereed stond. Uilenspiegel volgde haar
met de menigte, die achter heur huilde en tierde. Op de Groote Markt
teruggekomen, werd zij op het schavot gebracht, aan eenen paal
gebonden, en de beul legde voor hare voeten een hoop gras en een
klomp aarde: de bediedenis van het graf.

Ook zei men aan Uilenspiegel, dat ze vooraf in 't gevang gegeeseld was.

Voortgaande, ontmoette hij Hendrik Marischal, schooier, die in de
kasselrij West-Ieperen gehangen was geweest; rond den hals toonde
hij nog het merk van de koorden. Hij hing al in de lucht, zegde hij,
en was verlost geworden alleenlijk door een goed gebed te doen tot
Onze-Lieve-Vrouwe van Halle, zoodanig, dat, toen de baljuws en de
rechters vertrokken waren, door een echt mirakel de koorden braken
en hij ongedeerd ten gronde viel.

Maar later hoorde Uilenspiegel zeggen, dat die van de koorden verloste
bedelaar een valsche Hendrik Marischal was, en dat men hem zijne
leugen liet rondventen, omdat hij een perkament had, afgegeven door
den deken van Onze-Lieve-Vrouwe van Halle, die, door het vertelsel
van dien Hendrik Marischal, de galgenazen in grooten getale met rijke
offeranden naar zijne kerk lokte. En Onze-Lieve-Vrouwe van Halle werd,
zeer lang nog, Onze-Lieve-Vrouwe der Gehangenen genoemd.




XXXIV.

In dien tijd moesten kettermeesters en godgeleerden keizer Karel
voor de tweede reis vermanen: dat de Kerke ten onder ging; dat haar
gezag miskend werd; dat zoo hij menigvuldige zegepralen behaald had,
hij dit verschuldigd was aan de gebeden der Katholieke Kerk, die de
keizerlijke macht op haren troon in stand hield.

Een aartsbisschop van Spanje vroeg hem om zes duizend hoofden te
laten afkappen en evenveel lichamen te laten verbranden, ten einde
de kwaadaardige Luthersche ketterije in de Nederlanden uit te
roeien. Zijne Heilige Majesteit oordeelde, dat dit niet voldoende was.

Overal waar de ontzette Uilenspiegel dan ook voorbij kwam, zag hij
niets dan hoofden op palen, meisjes in zakken genaaid en levend in 't
water gesmeten, mannen naakt op het rad gebonden en met ijzeren staven
geslagen, vrouwen levend in eenen kuil gelegd, met aarde boven haar
en den beul op haren boezem dansen om dien te verpletteren. Maar de
biechtvaders van hen die zich vooraf bekeerd hadden, kregen telkenmale
twaalf stuivers voor hunne moeite.

Te Leuven zag hij de beulen dertig Lutheranen tegelijk verbranden
en den brandstapel met schietpoeder aansteken. Te Limburg zag hij
een gansche familie, mannen en vrouwen, dochteren en zonen, ter
strafplaatse leiden. Allen zongen psalmen. Alleen de oude vader
schreeuwde, terwijl hij verbrandde.

En Uilenspiegel ging zijns weegs, met beklemd en toegenepen herte.




XXXV.

In het open veld gekomen schudde hij zich als een vogeltje, als een
hond die den band ontloopen is, en zijn herte was verkwikt bij het
aanschouwen van de boomen, van de beemden, van de heldere zonne.

Als hij drie dagen lang gegaan had, kwam hij omtrent Brussel, in de
machtige gemeente Ukkel. Vóór het gasthof de Trompet, werd zijn neus
gestreeld door een hemelschen geur van stoverije. Aan een kleinen
schooier, die den reuk van de saus opsnoof, vroeg hij ter eere van
welken heilige die wierook omhoog steeg? De kleine antwoordde, dat
de broeders van de Goede Tronie na de vespers moesten bijeenkomen
om de herinnering te vieren van de verlossing der gemeente door hare
vrouwen en meisjes.

Uilenspiegel zag van verre eenen staak met een gaai erop, rond
denwelken vrouwen met bogen liepen; hij vroeg of de vrouwlieden nu
boogschieters waren geworden?

De jongen snoof nog eens den reuk van de keuken op en antwoordde, dat,
in den tijd van den goeden hertog, die zelfde bogen, in de handen der
Ukkelsche vrouwen, meer dan honderd baanstroopers van het leven naar
den dood hadden gestuurd.

Uilenspiegel wilde meer weten, doch de kleine schooier zei dat hij
geen woord meer zeggen zou, zoolang hij honger en dorst had, ten ware
hij een oortje kreeg om zich te verzadigen. Uilenspiegel gaf het hem
uit medelijden.

Zoodra de jongen het oortje had, trok hij, als een vos in een
hoenderhok, het gasthof binnen, om weldra, met een halve worst en
eene dikke snee brood triomfantelijk te voorschijn te komen.

Plotseling hoorde Uilenspiegel een zoete muziek van tamboerijnen en
violen en zag hij vele dansende vrouwen, en onder haar een schoon
wijf met een gouden ketting om den hals.

De schooier, in zijn schik, omdat hij zoo lekker gegeten had, zegde
tot Uilenspiegel dat die jonge, schoone vrouw de koningin van de
gaaischieting was, dat zij Mietje heette en de vrouw was van messire
Renonckel, schepene van de gemeente. Dan vroeg hij aan Uilenspiegel
nog zes duiten om te drinken: Uilenspiegel gaf ze hem. Toen hij
gegeten en gedronken had, zette hij zich in de zonne op de hurken,
en kuischte met zijne nagelen zijne tanden.

Als de boogschietsters Uilenspiegel in zijne pelgrimspij zagen,
begonnen zij rond hem te dansen, zeggende:

--Dag, schoone pelgrim; komt gij van verre, jonge pelgrim?

Uilenspiegel antwoordde:

--Ik kom uit Vlaanderen, het schoone land der verliefde meidekens.

En droefgeestig dacht hij aan Nele.

--Wat was uwe misdaad? vroegen zij, terwijl zij haren dans staakten.

--Ik durf het niet zeggen, daar ze zoo groot is, sprak hij. Bij mij,
mijne hertjes, is niemendal klein.

Zij lachten en vroegen waarom hij aldus moest reizen met den
pelgrimsstaf, den bedelzak en de oesterschelpen?

--'t Is, antwoordde hij, omdat ik gezegd heb, dat de zielmissen
voordeelig zijn voor de priesters.

--Zij brengen hun klinkende munt op, antwoordden de vrouwen, maar
toch zijn zij ook voordeelig voor de zielen in 't vagevuur.

--Daar was ik niet bij, antwoordde Uilenspiegel.

--Komt gij met ons eten? vroeg de schoonste.

--Ik wil, sprak hij, met u eten, en u eten, u en uwe vriendinnen,
de eene na de andere, want gij zijt fijne brokjes, lekkerder dan
ortolanen, lijsters of sneppen.

--De Hemel vergeve u, dat wild is buiten prijs, zeiden zij.

--Zooals gij allen, mijne hertjes, antwoordde hij.

--'t Is te zien, spraken zij, maar wij zijn niet te koop.

--Noch te geven? vroeg hij.

--Ja, zegden zij, wij geven slagen aan degenen die te stout zijn. Hebt
gij er van doen, wij zullen op u slaan lijk op kaf.

--Ik doe niet mee, sprak hij.

--Kom dan mee-eten, zegden zij.

Blijde als hij was rond zich vroolijke, lachende gezichten te zien,
volgde hij heur naar de binnenplaats van het gasthof. Plotseling
zag hij de broeders van de Goede Tronie, in groote staatsie, met
vaandel, fluit, bazuin en tamboerijn, in het binnenhof komen; zij
droegen waardiglijk den naam van hunne broederschap. Daar zij hem
nieuwsgieriglijk bekeken, zeiden de vrouwen dat het een pelgrim was,
dien ze op den weg ontmoet en meegebracht hadden naar 't festijn,
omdat zijne tronie haar aanstond.

De mannen stemden hiermee in, en een hunner sprak:

--Reizende pelgrim, wilt gij eene bedevaart doen in sausen en
stoverije?

--Daarvoor wil ik de leerzen van Duimken aantrekken, antwoordde
Uilenspiegel.

Als hij met hen de zaal van 't festijn binnenging, zag hij op den
Parijschen steenweg een twaalftal blinden. En toen zij voorbij hem
kwamen, kloegen zij van honger en dorst. Uilenspiegel zei tot zich
zelven, dat zij dien dag zouden avondmalen als prinsen, en wel ten
koste van den deken van Ukkel, op afkorting van de zielmissen.

Hij ging tot hen en sprak:

--Hier zijn negen gulden, gij kunt komen eten. Riekt gij den geur
niet van de stoverije?

--Laas! spraken zij, reeds een half uur lang, doch zonder hope.

--Gij zult eten, zegde Uilenspiegel, vermits gij nu negen gulden
hebt. Maar hij gaf ze hun niet.

--Wees gezegend! spraken zij.

En, door Uilenspiegel geleid, zetten zij zich rond een kleine tafel,
terwijl de broeders van de Goede Tronie met hunne wijven en dochteren
aan de groote tafel gingen zitten.

Met een zelfvertrouwen van negen gulden, riepen de blinden luide
en stout:

--Baas, geef ons te eten en te drinken, alles van 't beste!

De weerd, die van negen gulden had hooren spreken, dacht, dat die in
hunne tasschen staken en vroeg wat de gasten wenschten.

Toen riepen allen tegelijk:

--Boonen met spek, hutspot met rundvleesch, kiekens, kalfsvleesch en
hamelbout. Zijn de worsten voor de honden gemaakt?

--'k Heb witte en zwarte pensen geroken; 'k zou ze zien als ik nog
mijne lanteernen had.--Waar zijn de koekebakken met Anderlechtsche
boter? Zij zingen in de pan, sappig, knappend en hijgend naar het bier,
waarmede wij ze zullen begieten.--Wie geeft de hesp met eieren die
onzen mond placht te streelen?--Waar zijt gij, hemelsche soezels, die
zwemmen midden in de nieren, hanekammen, kalfszwezeriken, ossesteerten,
schapepooten, met veel ajuin, peper, kruidnagelen, muskaat, goed
ondereengestoofd met drie pinten witten wijn als saus?--Wie brengt
u tot mij, goddelijke kalfsworsten, die zoo goed zijt dat ge niets
zegt als men u opeet? Kwaamt gij recht uit Luilekkerland, waar niet
te werken valt, en eten en drinken een ambacht is? Gij zijt verdwenen
lijk de droge bladeren van den jongsten herfst.--Ik wil een hamelbout
met erwtjes.--Ik, verkensooren.--Ik, een rozenkrans van ortolanen,
met sneppen als paters en een vetten kapoen als credo.

De weerd antwoordde bedaard:

--Gij krijgt een pannekoek van zestig eieren en, als wegwijzers om
uwe vorken te bestieren, vijftig zwarte pensen, rookend op dien berg
van eieren gestoken, en als drank dobbelen peeterman: dat zal de
riviere wezen.

Het water kwam in den mond van de arme blinden.

Breng ons den berg, de wegwijzers en de rivier!

En de broeders van de Goede Tronie en hunne vrouwen, die reeds
met Uilenspiegel aan tafel zaten, zeiden, dat deze voor de blinden
onzichtbare smulpartij hun slechts de helft van het genot deed smaken.

Toen de weerd en vier koks den pannekoek opdienden, opgesmukt met
peterselie en keur van kruiden, wilden de blinden er zich op werpen,
maar de weerd gaf, niet zonder moeite, eerlijk aan elk zijn deel.

De boogschietsters waren verrukt als zij hen zagen slempen en zuchten
van genoegen, want zij hadden grooten honger en sloegen de pensen
binnen lijk oesters. De dobbele peeterman liep in hunne magen gelijk
een waterval van het hooggebergte.

Toen de blinden hunne teilen uitgewischt hadden, vroegen zij opnieuw
koekebakken, ortolanen en weer stoverije. De weerd bracht hun slechts
een grooten schotel ossen-, kalfs- en schapenbeenderen, die in goede
saus zwommen. Maar hij deelde niet rond.

Als zij hun brood en hunne handen, tot over de polsen, in de saus
gedoopt hadden, en niets vonden dan hamel-, kalfs- en andere beenderen,
meende een iegelijk dat zijn buurman al het vleesch had, en verwoed
sloegen zij met de beenderen op elkanders gezicht.

Bij dat schouwspel lachten de broeders van de Goede Tronie naar
hertelust en legden goedhertig een deel van 't festijn op de teil van
de arme blinden, en een iegelijk die een been zocht om er mee te slaan,
legde de hand op eene lijster, een kieken, een koppel leeuwerikken,
terwijl de vrouwen hun het hoofd achterover hielden en hun Brusselschen
wijn lieten drinken, zooveel zij konden. En als de arme lieden op den
tast zochten van waar die stroom godendrank kwam, grepen zij een rok,
die gezwind uit hunne handen glipte.

Zij lachten, aten, dronken en zongen zoo heerlijk! Eenigen vermoedden
dat er poezele wijfjes moesten zijn en liepen, dol van liefde,
de eetzale rond, maar de plaagzieke vrouwen draaiden zich om en
verborgen zich achter een broeder van de Goede Tronie, roepende:
"Kus mij, toe!" En als de blinden het deden, kusten zij in stee van
de donzige huid eener vrouw, het harig gezicht van een man--maar niet
zonder kletsen te krijgen.

De broeders van de Goede Tronie zongen, en zij zongen insgelijks. En
de vrouwen glimlachten teeder, met stil genoegen, als zij hen zoo
vol vroolijkheid zagen.

Toen die heerlijke uren voorbij waren, sprak de baas:

--Gij hebt goed gegeten en gedronken, geef mij nu zeven gulden.

Elk hunner zwoer dat hij de beurze niet had en beschuldigde zijn
buurman. Een nieuw gevecht ontstond, in hetwelk zij elkaar trachtten
te schoppen, te slaan en te stompen, maar de broeders van de Goede
Tronie hielden de vechtenden van elkaar. En 't regende slagen in de
lucht, behalve een die bij ongeluk terecht kwam op 't aangezicht van
den baas, die, verwoed, nu allen aftastte en niets anders vond dan een
versleten schapulier, zeven duiten, drie knoopen en hunne paternosters.

Hij wilde hen in het verkenskot steken en hen daar op water en brood
zetten, totdat liefdadige zielen voor hen betaald hadden.

--Wilt gij, vroeg Uilenspiegel, dat ik borg voor hen blijve?

--Ja, antwoordde de baas, als iemand ook voor u borg is.

De Goede Tronies wilden borg zijn, maar Uilenspiegel voorkwam hen
en zei:

--De deken zal borg zijn, ik ga het hem vragen.

Gedachtig aan de zielmissen, trok hij naar den deken en vertelde hem
dat de baas uit de Trompet van den duivel bezeten was, en dat hij
van anders niets sprak dan van verkens en blinden; dat de verkens de
blinden opaten en de blinden de verkens. Middelerwijl, zoo vertelde
hij, brak de baas thuis alles aan stukken, en hij bad hem den armen
man van dien boozen duivel te komen verlossen.

De deken beloofde het, maar zei, dat hij niet dadelijk kon komen,
mits hij bezig was met de rekening van 't kapittel te maken en dat
dit zeer lastig was, zoo hij zijn garande wilde hebben.

Toen Uilenspiegel zag dat hij ongeduldig werd, zegde hij dat hij
zou terugkomen met het wijf van den baas en dat de deken haar zelve
kon spreken.

--'t Is goed, antwoordde de deken.

Uilenspiegel keerde terug bij den baas en zegde:

--Ik heb den deken gesproken, hij blijft borg voor de blinden. Terwijl
gij op hen let, kan de bazinne meekomen, en hij zal heur herhalen
wat ik u zegde.

--Ga mee, vrouw, sprak de baas.

De bazinne ging met Uilenspiegel bij den deken, die maar altijd aan
't cijferen was, om zijn aandeel te vinden. Toen zij binnenkwam met
Uilenspiegel, maakte hij met de hand een driftig gebaar, zeggende:

--Ga heen en wees gerust: morgen of overmorgen kom ik bij uwen man.

En toen Uilenspiegel naar de Trompet terugkeerde, sprak hij onderweg
in zich zelven: "Hij zal honderd gulden betalen en dat zal mijn eerste
zielmisse zijn."

En hij ging zijns weegs, en de blinden insgelijks.




XXXVI.

's Anderen daags kwam Uilenspiegel op eene baan vol volk. Hij volgde
de menigte en vernam, dat het dien dag beeweg naar Alsemberg was.

Hij zag er arme oude vrouwen, die, voor een gulden en om de zonden van
voorname dames te boeten, barrevoets achterweerts gingen. Terzijde
van den weg deed meer dan één pelgrim zich te goed aan wafelen en
bruinbier, bij geschal van lieren, violen en doedelzakken. En de reuk
van allerhande spijzen steeg ten hemel als een zoete wierook.

Maar daar waren ook pelgrims, die er gemeen en ellendig uitzagen;
die hadden zes stuivers van de Kerk gekregen, om achterweerts den
beeweg te doen.

Een kaalhoofdig manneken, met opengesperde oogen, volgde hen insgelijks
achterweerts springend en vaderonzen zeggend.

Uilenspiegel, die wilde weten waarom hij aldus de kreeften naäapte,
ging voor hem staan en sprong glimlachend lijk hij. Lieren, pijpen,
violen en doedelzakken, waren met het geschreeuw van de pelgrims,
de muziek van dien dans.

--Zeg eens, Jan van den Duivel, sprak Uilenspiegel, is het om zeker
te zijn van vallen, dat gij averechts gaat?

De man antwoordde niet en bad voort.

--Of is het om de boomen te tellen, vervolgde Uilenspiegel, en
misschien ook de bladeren er bij?

De man, die een credo zei, deed Uilenspiegel teeken dat hij zwijgen
moest.

--Of, sprak deze, altijd vóór hem springend en zijne gebaren
nabootsend, zijt gij misschien eensklaps zot geworden, dat gij
loopt lijk de kreeften? Maar wie van een zot een verstandig antwoord
verwacht, is zelf niet wijs. Niet waar, mijnheer de kaalkop?

Daar de man nog niet antwoordde, danste en sprong Uilenspiegel voort,
doch hij maakte daarbij zooveel lawijd met zijne zolen, dat de weg
klonk als een houten kist.

--Of zijt gij stom, mijnheer? vroeg Uilenspiegel ten slotte.

--Ave Maria, sprak de man, gratia plena et benedictus fructus ventris
tui, Jesu.

--Of misschien doof? zei Uilenspiegel. Dat gaan wij dadelijk zien:
men zegt, dat dooven vleierij noch beleediging hooren. Laat zien of
de trommel van uw ooren van vel of van ijzer is: Meent gij, lanteerne
zonder keers, mislukte voetganger, dat gij een mensch gelijkt? Ge
kunt wachten totdat wij van vodden gemaakt zijn. Zag men ooit zulke
gele tronie, zulk een kletshoofd, elders dan op een galgeveld? Zijt
ge in uw leven nooit gehangen geweest?

En Uilenspiegel danste steeds voort, en de man, die kwaad werd,
stapte boosaardig achterwaarts en bad zijn vaderonzen met heimelijke
verbolgenheid.

--Of misschien, sprak Uilenspiegel, verstaat gij geen Hoogvlaamsch;
daarom ga ik u in 't Platvlaamsch aanspreken: Zijt gij geen gulzigaard,
dan zijt gij een dronkaard; zijt gij geen dronkaard, dan zijt gij
verstopt; zijt gij niet verstopt, dan hebt gij den afgang; als er
matigheid is, dan is zij het niet, die de tonnen van uw buik vult;
zijt gij geen losbol, dan zijt gij een kapuin en als er op de duizend
millioen mannen der aarde maar één horendrager was, dan zoudt gij
het zijn....

Op die rede, viel Uilenspiegel op zijn achterste, met de beenen omhoog,
want de man had hem zulk een vuistslag op den neus toegediend, dat
het vuur hem uit zijne oogen sprong. Dan liet de man zich, ondanks
zijn dikken buik, verraderlijk op hem vallen en sloeg hem overal,
dat de slagen als hagelsteenen op het magere lichaam van Uilenspiegel
vielen. En Uilenspiegels stok rolde mede ten gronde.

--Dat zal u leeren, sprak de man, eerlijke menschen kwellen die
op bedevaart gaan. Want--gij moogt het wel weten--ik ook ga naar
Alsemberg, volgens aloud gebruik, om Onze-Lieve-Vrouwe te bidden,
een kind te willen doen afkomen, dat mijne vrouw ontving terwijl
ik op reis was. Om zulk een groote genade te verkrijgen, moet men,
zonder spreken, achterweerts loopen en dansen van den twintigsten
stap voorbij zijn huis tot aan de trappen der kerk. Laas! nu moet ik
geheel opnieuw beginnen.

Uilenspiegel, die zijn stok opgeraapt had, sprak:

--Ik zal u helpen, deugniet, die Onze-Lieve-Vrouwe wilt smeeken om
de kinderen vóór hun geboorte te vermoorden.

En meteen sloeg hij den leelijken horendrager zoo deerlijk, dat hij
hem voor dood op den weg liet.

En nog altijd steeg het gehuil der pelgrims en het geluid van  pijpen,
lieren, violen en doedelzakken omhoog, met den geurigen wierook van
gekook en gebraad.




XXXVII.

Klaas, Soetkin en Nele zaten samen rond den heerd en praatten over
den reizenden pelgrim.

--Meisje, sprak Soetkin, kondet gij hem voor altijd bij ons houden
door uwe jeugd en uwe schoonheid!

--Laas! sprak Nele, ik kan niet.

--Omdat hij, antwoordde Klaas, meer behagen vindt in loopen, zonder
ooit te rusten, tenzij om te eten.

--De leelijke stouterik! zuchtte Nele.

--Ik geef toe dat hij stout is, sprak Soetkin, maar leelijk is
hij niet. Als Uilenspiegel Grieksch noch Romeinsch van gezicht is,
is hij des te schooner; want Vlaamsch zijn zijne vlugge voeten, van
't Brugsche Vrije zijn levendige bruine oogen; en zijn neus en mond
zijn gemaakt door twee vossen, ervaren in de kunsten van slimheid
en verstand.

--Wie dan, vroeg Klaas, maakte hem zijne armen van luierik en zijne
beenen, die al te vlug loopen naar vermaak en pleizier?

--Zijn al te jeugdig herte, was 't antwoord van Soetkin.




XXXVIII.

In dien tijd genas Katelijne, met kruiden, een os, drie schapen en een
verken toebehoorende aan Speelman, doch de koe van Jan Beloen kon ze
niet genezen. Jan beschuldigde haar van hekserij en verklaarde, dat
zij het dier betooverd had, daar zij, terwijl zij het de geneeskruiden
gaf, het gestreeld en aangesproken had, zeker in een duivelsche tale,
want een eerlijk christenmensch mag het woord tot geen dier richten.

Gemelde Jan Beloen voegde er bij, dat hij gebuur was van Speelman,
wiens os, schapen en verken zij genezen had en, zoo zij zijne
koe gedood had, het zeker was op het opstoken van Speelman, die
jaloersch was, omdat zijne akkers slechter bebouwd waren en minder
opbrachten dan de zijne--van Beloen namelijk. Op getuigenis van Pieter
Meulemeester, een man van goed gedrag en zeden, en ook van Jan Beloen,
die bevestigden dat Katelijne te Damme bekend stond als tooveres,
en naar allen schijn de koe gedood had, werd Katelijne aangehouden
en veroordeeld om op de pijnbank te worden gelegd totdat zij hare
misdaden bekende.

Zij werd ondervraagd door een schout, die altijd narrig was, want
heel den dag door dronk hij brandewijn. Vóór hem en vóór die van de
Vierschaar, deed hij Katelijne op de eerste pijnbank zetten.

De beul ontkleedde haar en keek of zij geenerlei hekserij verborgen
hield.

Hij vond niets, en bond heur met koorden op de pijnbank. Toen
zegde zij:

--Heilige Moeder Gods, laat mij sterven, dat ik mijne schamelheid
aan die mannen niet hoeve te toonen!

Toen legde de beul natte doeken op heure borst, heuren buik en heure
armen; vervolgens hief hij de bank op en goot hij heet water in
heure keel, bij zulke groote hoeveelheid, dat zij gansch opgeblazen
scheen. Vervolgens liet hij de bank nedervallen.

De schout vroeg aan Katelijne of zij hare misdaad wilde bekennen. Zij
schudde het hoofd. Toen goot de beul nog heet water in haren mond,
maar Katelijne gaf het allemaal over.

Op het oordeel van den heelmeester, werd zij toen losgemaakt. Zij
sprak niet, doch klopte op hare borst om te zeggen, dat het heet
water haar verbrand had. Toen de schout zag dat zij van haar eerste
foltering bekomen was, sprak hij:

--Beken, dat gij tooveres zijt en dat gij de koe betooverd hebt.

--Ik zal niet bekennen, sprak zij. Zooveel het in de macht van mijn
zwak herte ligt, zie ik alle beesten geerne, en ik deed nog liever leed
aan mij zelve dan aan hen, daar zij zich niet verdedigen kunnen. Om
de koe te helpen, heb ik de geneeskruiden gebruikt, die ik moest.

Maar de schout sprak:

--Gij hebt vergif gebruikt, want de koe is gestorven.

--Heere schout, antwoordde Katelijne, ik ben hier voor u en in uwe
macht; en toch durf ik zeggen, dat een dier, evenals een mensch,
van ziekte kan sterven, niettegenstaande de hulp van artsen en
heelmeesteren. En bij Jezus-Christus, die voor onze zonden op het
kruis is gestorven, zweer ik dat ik die koe geenerlei kwaad gewild heb,
doch getracht heb ze te genezen met de gebruikelijke kruiden.

Woedend sprak toen de schout:

--Die tooverkol zal niet blijven afstrijden; men brenge heur op een
andere pijnbank!

En daarna dronk hij een groot glas brandewijn.

De beul deed Katelijne zitten op het deksel eener eiken doodkist,
die op pikkels stond. Dat deksel, in den vorm van een dak, was scherp
als een mes. Een groot vuur brandde in den schoorsteen, want men was
toen in de slachtmaand.

Katelijne werd op de doodkist en op een scherpe houten pinne gezet,
en men deed haar nieuwlederen schoenen aan die te smal waren. Zóó
schoof men heur tegen het vuur. Als zij de snede van de doodkist
en de scherpe pinne in heur vleesch voelde dringen, en de hitte van
't vuur het leder van de schoenen deed krimpen, riep zij uit:

--Ik lijd ongemeene smerten! Wie geeft mij zwart vergif?

--Breng haar dichter bij 't vuur, sprak de schout.

Toen ondervroeg hij Katelijne.

--Hoe dikwijls, sprak hij, reedt gij op een bezemsteel naar den
heksensabbat? Hoe dikwijls deedt gij het koren in de aar, de vrucht
op den boom, het kind in den schoot vergaan? Hoe dikwijls zaaidet
gij haat en nijd in de herten van broeders en zusters?

Katelijne wilde spreken, maar zij kon niet, en zij zwaaide met hare
handen als om "neen" te bedieden. Toen zegde de schout:

--Zij zal niet spreken vooraleer zij al heur heksenvet zal voelen
smelten. Breng haar nog dichter bij het vuur.

Katelijne schreeuwde. De schout zegde heur:

--Bid Satan dat hij u verfrissching bezorge.

Met het gezicht vol smerte, wees zij naar heure schoenen, die rookten
ten gevolge van de hitte des vuurs.

--Bid Satan, dat hij ze uitdoe, sprak de schout.

Tien uren sloeg de klok, dit was het etensuur van den wreedaard;
hij vertrok met zijn schrijver, den beul en zijn knechten, en liet
Katelijne alleen bij 't vuur, in de folterkamer.

Te elf uren kwamen zij terug, en zij vonden Katelijne stijf en
onbeweeglijk zitten. De schrijver sprak:

--Ik geloof, dat zij dood is.

De schout beval Katelijne van de doodkist te nemen en heure schoenen
uit te doen. De beul moest ze vaneen snijden en Katelijne's voeten
waren rood en bloedden.

En de schout, die aan zijn maaltijd dacht, bezag ze, doch uitte geen
woord; doch weldra kwam ze tot heur zelve terug; zij viel ten gronde
zonder zich te kunnen oprichten ondanks al heure krachtsinspanning,
en sprak tot den schout:

--Vroeger wildet gij mij voor echtgenoote, maar nu zult gij mij niet
meer hebben. Viermaal drie is een heilig getal, en de dertiende is
de echtgenoot.

Vervolgens, daar de schout wilde spreken, zegde zij tot hem:

--Zwijg stille: hij hoort beter dan de aartsengel, die in den hemel
de hertkloppingen der rechtvaardigen telt. Waarom komt gij zoo
spa? Viermaal drie is een heilig getal; het doodt de ellendelingen,
die mij willen vervolgen.

De schout sprak:

--Zij ontvangt den duivel in heur bedde.

--Zij is uitzinnig, ten gevolge van de smerten der foltering, sprak
de schrijver.

Katelijne werd terug naar 't gevang gebracht. Drie dagen nadien kwamen
de schepenen in de Vierschaar bijeen en, na rijpe beraadslaging,
werd Katelijne veroordeeld tot de straffe des vuurs.

De beul en zijne knechten brachten heur naar de Groote Markt van
Damme, alwaar een schavot opgericht was, hetwelk zij beklom. Op de
Markt stonden de provoost, de heraut en de rechters.

Driemaal klonken de bazuinen van den stadsheraut en deze sprak tot
het volk:

--De magistraat van Damme, medelijden gekregen hebbende met vrouwe
Katelijne, heeft haar niet willen straffen volgens al de strengheid
van de wet van de stede, maar tot teeken dat zij tooveres is, zal heur
haar verbrand worden; verder zal zij twintig gouden karolussen boete
betalen en voor drie jaar gebannen worden uit de stede van Damme,
op verbeurte van een lid.

En het volk juichte die barbaarsche goedertierenheid toe.

De beul bond Katelijne toen aan eenen paal, legde op heur geschoren
hoofd eene pruik van werk en stak die in brand. En het werk brandde
lang, en Katelijne schreeuwde en huilde van pijn.

Eindelijk werd zij losgemaakt; zij werd op eene kar buiten het
grondgebied van Damme gebracht, want heure voeten waren verbrand.




XXXIX.

Terwijl Uilenspiegel te 's-Hertogenbosch in Brabant was, wilden de
heeren van de stad hem tot hunnen nar benoemen, maar die weerdigheid
weigerde hij, zeggende: "Reizende pelgrims mogen zich nergens vestigen;
hun verblijf is de groote baan."

Rond dien tijd kwam Philippus, die koning van Engeland was, zijne
toekomstige erfstaten Vlaanderen, Brabant, Henegouwen, Holland en
Zeeland bezoeken. Hij was in zijn negen en twintigste jaar; in zijne
grijze oogen las men bittere droefgeestigheid, woeste geveinsdheid
en wreedaardige vastberadenheid. Koud was zijn aangezicht, stijf
zijn hoofd met vaalrood haar, alsmede zijn mager lichaam en zijne
schrale beenen. Langzaam en slijmerig sprak hij, alsof hij wolle in
den mond had.

Te midden van tornooien, steekspelen en feesten, bezocht hij
achtereenvolgens het vroolijke hertogdom Brabant, het rijke graafschap
Vlaanderen en zijne andere heerlijkheden. Overal beloofde hij onder
eede de privileges te zullen eerbiedigen; maar toen hij te Brussel
op 't Evangelie zwoer de Brabantsche gouden bul te zullen in stand
houden, trok zijne hand zoodanig te zamen, dat men hem het heilige
boek moest afnemen.

Hij ging naar Antwerpen, waar men drie en twintig zegebogen
oprichtte om hem te ontvangen. De stad gaf tweehonderd zeven en
tachtig duizend gulden uit om die bogen te betalen, alsmede voor
de kleedij van achttien honderd negen en zeventig kooplieden, allen
in karmozijnpanne, en voor de rijke livrei van vierhonderd zestien
lakeien en den schitterenden zijden dos van vier duizend poorters,
allen eender gekleed. Menigvuldige feesten werden gegeven door de
rederijkerskamers van bijna al de steden der Nederlanden.

Daar werden gezien met hunne narren: de Prins van Liefde, van Doornijk,
rijdende op eene zeuge, die Astarte hiet; de Koning der Zotten, van
Rijsel, die een peerd bestierde bij den steert en achter hetzelve
ging; de Prins van Genuchte, van Valencijn, die zich vermaakte met
de veesten van zijnen ezel te tellen; de Abt van Vroolijkheid, van
Atrecht, die zijn Brusselschen wijn dronk uit eene flesch, in de
gedaante van een getijdenboek, en het boek lustig om lezen vond; de
Abt der Gevulde Buiken van Ath, die gescheurde kleederen en versleten
schoenen aanhad, maar eene worst droeg, met dewelke hij zijn buiksken
vulde; de Proost van Onbezonnenheid, jonge knaap, die op een schuwe
geit zat en aldus door het volk reed, ten gevolge waarvan hij slagen
en stompen in groote menigte ontving; de Abt van den Zilveren Schotel,
van de stad Le Quesnoy die, te peerd, gebaarde zich neder te zetten
in eenen schotel, zeggende: hoe groot een beest ook weze, het toch
kan gebraden worden.

En zij vertoonden allerhande onschuldige gekheden, maar de vorst
bleef somber en stuursch.

's Avonds nog kwamen de markgraaf van Antwerpen, de burgemeesteren,
hoofdmannen en dekenen bijeen om toch iets te vinden, dat Philippus
zou doen lachen.

De markgraaf sprak:

--Hebt gij nooit hooren spreken van zeker Pierken Jacobsen, den nar
van 's-Hertogenbosch, die bekend is voor zijn aardige streken?

--Ja, spraken zij.

--Hewel, zei de markgraaf, laat ons hem ter stede ontbieden, en dat hij
iets aardigs vertoone, vermits onze nar lood in zijn schoenen heeft.

--Laat ons hem ontbieden! spraken zij.

Toen de bode van Antwerpen naar 's-Hertogenbosch kwam, zegde men hem,
dat de nar Pierken gebersten was van 't lachen; maar dat er voor
eenigen tijd een andere nar in de stad was, met name Uilenspiegel.

De bode ging hem zoeken in eene taveerne, waar hij gestoofde mosselen
aan 't eten was.

Uilenspiegel was verrukt toen hij vernam, dat het voor hem was,
dat de schepenbode van Antwerpen kwam, op een schoon peerd van het
Veurne-Ambacht en een ander peerd bij den toom houdend.

Zonder af te stijgen, vroeg de bode hem of hij geen nieuwe poetsen
kende om koning Philippus te doen lachen.

--Onder mijn haar liggen poetsen met de macht, antwoordde Uilenspiegel.

En zij reden weg. De twee peerden liepen spoorslags tot Antwerpen,
met den bode en met Uilenspiegel.

Uilenspiegel verscheen vóór den markgraaf, de beide burgemeesters en
de poorters van Antwerpen.

--Wat schikt gij te doen? vroeg de markgraaf hem.

--In de lucht vliegen, antwoordde Uilenspiegel.

--Hoe gaat gij dat aanleggen? vroeg de markgraaf.

--Weet gij wat nog minder weerd is dan eene blaas die berst?

--Neen, sprak de markgraaf.

--'t Is een geheim dat men uitbrengt, was 't antwoord van Uilenspiegel.

De feestherauten reden op hunne schoone peerden met karmozijnpanne
getoomd, door de straten, markten en pleinen van de stad met slaande
trom en schallenden hoorn. Op die wijze maakten zij bekend aan de
signoorkens en signorinnekens, dat Uilenspiegel, de nar van Damme,
op de kaai in de lucht zou vliegen, in de aanwezigheid van koning
Philippus en zijn eerweerdig, doorluchtig en adelijk gezelschap.

Rechtover de estrade des konings stond een huis op Italiaansche wijze
gebouwd, onder welks dak eene regengoot liep. En op die goot kwam
een zoldervenster uit.

Dien dag reed Uilenspiegel door de stad op een ezel. Een voetknecht
ging nevens hem. Uilenspiegel had het schoon karmozijnzijden kleed
aangetrokken, hetwelk de heeren van de stad hem gegeven hadden. Tot
hoofddeksel droeg hij eene kap, mede van karmozijnzijde, waaraan twee
ezelsooren met een belleken aan. Hij droeg een halssnoer van koperen
penningen, waarop het schild van Antwerpen prijkte. Aan de mouwen
van zijn kleed zag men aan een puntigen elleboog een paar vergulde
bellekens. Ook droeg hij puntleersjes, met een belleken aan elken top.

Zijn ezel, getoomd met karmozijnzijde, droeg op elke bil het schild
van Antwerpen, met fijn goud geborduurd.

De knecht hield met de eene hand den ezel bij den kop en met de andere
eenen tak, aan denwelken een koebelletje klingelde.

Uilenspiegel liet zijn knecht en zijn ezel op straat en klom in
de dakgoot.

Daar deed hij de bellekens klinken en strekte de armen wijd open, alsof
hij vliegen ging. Dan bukte hij zich naar koning Philippus, zeggende:

--Ik dacht, dat niemand dan ik in Antwerpen zot was, maar ik zie,
dat de stad vol gekken is. Hadt gij mij gezegd dat gij vliegen zoudt,
dan had ik u niet geloofd; maar een zot komt u zeggen dat hij het zal
doen, en gij gelooft hem! Hoe wilt gij dat ik vliege, daar ik geene
vleugelen heb?

De eenen lachten, de anderen vloekten, maar allen zegden:

--'t Is toch de waarheid.

Maar koning Philippus bleef stijf als een koning van steen.

En die van de gemeente fluisterden tot elkaar:

--'t Was de moeite niet, al die vermakelijkheden in te richten voor
zulk een zuur gezicht.

En zij gaven drie gulden aan Uilenspiegel die heenging, nadat hij
hun het karmozijnzijden kleed had teruggegeven.

--Wat zijn drie gulden in de tassche van een jonkman anders dan
een sneeuwbal vóór 't vuur, dan een volle flesch vóór uw aanschijn,
drinkebroers? Drie gulden! De bladeren vallen van de boomen, doch er
schieten nieuwe op hunne plaats; maar de guldens gaan uit de zakken
en keeren er nimmermeer in; de vlinders verdwijnen met den zomer,
en de guldens ook, hoewel zij meer dan twee esterlings wegen.

Dus sprekende, staarde Uilenspiegel naar zijne drie gulden.

--Welk fier gezicht, murmelde hij, heeft, op de zijde van den
beeldenaar, die gehelmde, geharnaste keizer Karel, met een zweerd
in eene hand en den aardbol in de andere! Door de genade Gods is
hij Roomsch keizer, koning van Spanje enz., en hij is wel genadig
voor ons, de geharnaste keizer! En hier op de keerzijde, hebt ge een
schild, op hetwelk de wapenen van zijne verschillende graafschappen,
hertogdommen en heerlijkheden prijken, met die schoone spreuke:
Da mihi virtutem contra hostes tuos: "Geef mij dapperheid tegen uwe
vijanden". Hij was dapper, inderdaad, tegen de protestanten, die have
en goed hadden, om van dezelven te erven. Ha! was ik keizer Karel,
ik liet guldens voor een iegelijk slaan; zoo iedereen rijk was,
zou niemand meer hoeven te werken.

Maar Uilenspiegel had niet lang genoegen in 't bezien van zijn geld:
weldra verzwond het in 't gerinkel van bottels en pinten.




XL.

Terwijl Uilenspiegel zich in karmozijnzijde op de dakgoot vertoonde,
had hij Nele niet gezien, die hem, onder de menigte, glimlachend
toekeek. Zij woonde te Borgerhout, omtrent Antwerpen, en zij had
gedacht, dat, als een nar voor koning Philippus moest vliegen, het
niemand anders kon zijn dan haar Uilenspiegel.

Terwijl hij droomend heenging, hoorde hij niet 't gerucht van haastige
stappen achter zich, doch hij voelde de twee handjes wel, die langs
achteren vóór zijne oogen werden gebracht. Aan Nele denkend, vroeg hij:

--Zijt gij het?

--Ja, sprak zij, ik loop achter u sedert dat gij uit de stad zijt. Kom
mede met mij.

--Maar, antwoordde hij, waar is Katelijne?

--Gij weet niet, sprak zij, dat zij onrechtveerdig als tooveres
gefolterd werd, vervolgens voor drie jaar uit Damme gebannen,
en men haar pijnigde en brandde. Ik zeg u dit, opdat gij niet
zoudt verschieten, want zij is uitzinnig ten gevolge van de hevige
smerten. Gansche nachten soms beziet ze heure voeten, zeggende:
Hansken, mijn zoete duivel, zie eens wat zij gedaan hebben met uwe
vriendinne. En heur arme voeten gelijken twee bloedige wonden. Dan
weent zij, zeggende: Andere vrouwen hebben een man of een minnaar,
ik, ik leef op deze wereld als een weduwe. Maar dan zeg ik tot haar,
dat haar Hansken boos zal wezen, als zij van hem tot anderen durft
spreken. En zij luistert naar mij gedwee als een kind, behalve wanneer
zij een os of eene koe, oorzake harer foltering, ziet; dan neemt zij
ijlings de vlucht, zonder dat iets, barreelen of beken of grachten,
haren loop kunne stuiten, totdat zij eindelijk nederzijgt aan den
zoom van een weg of tegen den muur van eene hoeve, waar ik haar ga
oprapen om heure bloedende voeten te verbinden. En ik geloof, dat
zij met het brandende werk, ook heure hersenen verbrand hebben.

En beiden waren zeer bedroefd, terwijl zij dachten aan Katelijne.

Zij kwamen bij haar en zagen heur op eene bank in de zonne zitten,
tegen den muur van heur huis. Uilenspiegel vroeg:

--Herkent gij mij?

Viermaal drie, sprak zij, is een heilig getal, en de dertiende is
Thereb. Wie zijt gij, kind dezer booze wereld?

--Ik ben Uilenspiegel, antwoordde hij, de zoon van Klaas en van
Soetkin.

Zij knikte tot teeken dat zij hem herkende; vervolgens wenkte zij
hem om nader te komen en fluisterde hem in 't oor:

--Als gij hem ziet, wiens kussen koud als de sneeuw zijn, zeg hem
dan te komen, Uilenspiegel.

Vervolgens heur verbrand haar toonende, sprak zij:

--Ik heb zeer; zij hebben mij mijnen geest afgenomen, maar als hij
komt zal hij mijn hoofd vullen, dat nu hol is van binnen. Hoort
gij? het klinkt als een klokke; 't is mijne ziel, die aan de deur
klopt om henen te gaan, daar het brandt in de helle. Als Hansken komt
en hij mijn hoofd niet wil vullen, zal ik hem zeggen er een gat in
te snijden: de ziel, die daar binnen is en klopt om buiten te komen,
bedrukt mij zoo deerlijk, dat ik het besterven zal. En nimmer slaap
ik meer, steeds wacht ik op hem, dat hij mij mijn geest teruggeve.

En nederzijgend, zuchtte zij diep.

En de boeren, die van het veld kwamen op etenstijd, als de klokken
luiden, gingen voorbij Katelijne en spraken:

--Daar is de zottinne.

En zij maakten het teeken des kruises.

En Nele en Uilenspiegel weenden, en Uilenspiegel moest zijne bedevaart
voortzetten.




XLI.

Zijn beeweg vervolgend, trad hij in dienst bij zekeren Judocus, de
kwabakker geheeten, om den wille van zijne zure en norsche tronie. De
kwabakker gaf hem voor eten drie oudbakken brooden per week en deed
hem slapen in een kot onder het dak, waar het regende en waaide dat
het een pleizier was.

Als Uilenspiegel zag, dat hij zoo slecht behandeld werd, bakte hij
zijnen baas verscheidene poetsen en onder andere deze: als men 's
morgens heel vroeg bakt, moet men 's nachts het meel builen. Nu op
een nacht dat de mane scheen, vroeg Uilenspiegel een keers om te zien,
en hij kreeg van zijn meester het volgende antwoord:

--Buil het meel in den maneschijn.

Uilenspiegel gehoorzaamde, en builde het meel op den grond, daar waar
de maan scheen.

Als de kwabakker 's morgens kwam zien naar Uilenspiegel's werk,
vond hij hem nog aan 't builen.

--Kost het meel dan geen geld meer, sprak hij, dat gij het nu op den
grond built?

--Ik heb het meel in den maneschijn gebuild, gelijk gij mij geheeten
hebt, antwoordde Uilenspiegel.

De bakker antwoordde:

--Ezel, die ge zijt: 't was door eene zeef dat gij het moest doen.

--Ik meende, dat de maan eene zeef van uwe vinding was, antwoordde
Uilenspiegel. Maar er zal niet veel verloren gaan, ik zal het meel
opscheppen.

--'t Is nu te laat, antwoordde de bakker, om deeg te maken en te
bakken.

Uilenspiegel sprak:

--Baas, het deeg van onzen buurman is gereed in den trog, wil ik het
gaan nemen?

--Loop naar de galg, antwoordde de kwabakker, neem wat er te vinden is.

--Ik ga, baas, antwoordde Uilenspiegel.

Hij liep naar het galgeveld en vond er de verdroogde hand van een
dief. Hij bracht ze aan den kwabakker en sprak:

Dit is eene gelukshand, die onzichtbaar maakt, wie ze draagt. Wilt
gij uwe slechte inborst verbergen?

--Ik zal u zwart maken bij het gerecht, antwoordde de kwabakker,
en gij zult zien dat gij het heerenrecht hebt overtreden.

Toen zij getweeën vóór den burgemeester stonden, wilde de kwabakker al
de misdaden van Uilenspiegel opsommen, maar deze zette groote oogen
op en maakte den kwabakker zoo grammoedig, dat hij zijne aanklacht
onderbrak om te vragen:

--Wel, wat is er?

Uilenspiegel antwoordde:

--Gij hebt mij gezegd, dat gij mij zoodanig zwart gingt maken, dat
ik zou zien. Wel, ik zie niemendal....

--Uit mijne oogen! riep de bakker.

--Was ik in uw oogen, antwoordde Uilenspiegel, dan zou ik, als gij
ze toedeedt, er langs de neusgaten moeten uitkruipen.

De burgemeester dacht dat men hem voor den aap hield en wilde hen
niet langer aanhooren.

Uilenspiegel en de kwabakker kwamen samen buiten, de bakker hief zijn
stok op, doch Uilenspiegel sprong ter zijde en sprak:

--Baas, daar het met slagen is dat men mijn meel built, neem gij
de zemelen: dat is uwe norschheid; ik houd de bloem: dat is mijne
vroolijkheid.

En zich omkeerende, zei hij: Als ge bakken wilt--hier is de oven.




XLII.

De reizende Uilenspiegel ware geerne struikroover geworden, maar hij
zei tot zich zelven, dat hij met struiken niets verrichten kon.

Hij stapte op goed valle 't uit naar Oudenaarde, waar toen een
garnizoen Vlaamsche ruiters lag, om de stad te verdedigen tegen de
Fransche benden, die het land verwoestten lijk sprinkhanen.

De hoofdman van de ruiters was een Fries, een zekere Kornjuin. Zij
ook liepen het platteland af en knevelden het volk, dat aldus, als
naar gewoonte, langs twee kanten tegelijk opgegeten werd.

Alles was hun deeg: kiekens en kapoenen, eenden en duiven, kalveren
en verkens. Op een avond dat Kornjuin en zijne mannen met buit beladen
terugkwamen, zagen zij aan den voet van een boom Uilenspiegel liggen,
die sliep en zeker van stoverije droomde.

--Wat doet gij om te leven? vroeg Kornjuin.

--Sterven van honger, antwoordde Uilenspiegel.

--Wat is uw ambacht?

--Reizen voor mijne zonden, de anderen zien wroeten, op de koorde
dansen, lieve gezichtjes schilderen, messenhechten snijden, op den
rommelpot spelen en op de trompet blazen.

Als Uilenspiegel zoo stout zei, dat hij op de trompet kon blazen,
was het omdat hij had hooren zeggen, dat, in het slot van Oudenaarde,
de plaats open was van torenwachter, ten gevolge van den dood van
den ouden man welke die bediening vervulde.

Kornjuin zei hem:

--Gij zult bazuinblazer van de stede wezen.

Uilenspiegel volgde hem en hij werd gebracht op een van de hoogste
torens der vestingen, in een goed verlucht hokje, dat open was voor
alle winden, behalve voor dien uit 't Zuiden.

Men zei hem, dat hij blazen moest als hij den vijand zag aankomen
en, daarom steeds het hoofd vrij en de oogen helder moest houden,
weshalve men hem niet te veel eten of drinken bracht.

De hoofdman en zijne huurlingen bleven in de toren en kermisten
heel den dag ten koste van het platteland. Daar werd meer dan
een kapoen, wiens eenige misdaad was vet te zijn, gedood en
opgesmuld. Uilenspiegel, die altijd vergeten werd en zich tevreden
moest houden met zijn mageren disch, vond in 't heel geen behagen
in den reuk van de saus. De Franschen kwamen, namen het vee mee,
doch Uilenspiegel blies het alarm niet.

Kornjuin kwam boven en vroeg:

--Waarom hebt gij niet geblazen?

Uilenspiegel sprak:

--Gij hadt kunnen denken, dat het als dank was voor mijn eten.

's Anderen daags bestelde de hoofdman een groot festijn voor zich en
zijne huurlingen, maar Uilenspiegel werd nogmaals vergeten. Zij gingen
zich deugd doen aan 't lekkere maal, toen Uilenspiegel alarm blies.

Kornjuin en zijne soldaten, meenende dat de Franschen daar waren,
verlieten de tafel en sprongen te peerd. Zij reden in allerijl de
stad uit, maar buiten vonden ze niets dan een os, die in de zonne
herkauwde, en dien zij meenamen.

Middelerwijl had Uilenspiegel zich volgestopt met vleesch en met
wijn. Toen de hoofdman terugkwam, zag hij hem lachend en met waggelende
beenen staan aan de deur van de zaal van 't festijn. Hij sprak:

--'t Is verraderswerk van alarm te blazen als gij den vijand niet ziet,
en van niet te blazen als ge hem wèl ziet.

--Mijnheer de hoofdman, antwoordde Uilenspiegel, ik heb geblazen om
mij te verlichten, want in mijn toren was ik zoodanig opgeblazen van
wind, dat ik vreesde te zullen wegvliegen. Laat mij maar ophangen,
nu of een andere maal, zoo gij ezelsvel noodig hebt voor uwe trommelen.

De hoofdman ging henen en zei geen woord.

Maar Oudenaarde kreeg tijding, dat de genadige keizer Karel de stede
zou komen bezoeken met een doorluchtig gezelschap. Bij die gelegenheid
gaven de schepenen aan Uilenspiegel eenen bril, om Zijne Majesteit
beter te zien aankomen. Uilenspiegel moest driemaal blazen, zoodra
hij den keizer van Leupegem zag aankomen op een kwartier gaans van
de Borgpoort.

Die van de stad zouden aldus den tijd hebben de klokken te luiden,
het vuurwerk in gereedheid te brengen, het vleesch in den oven te
zetten, de vaten aan te steken.

Zekeren dag, dat de wind uit Brabant woei en de hemel helder was,
zag Uilenspiegel, rond den middag, een grooten troep ruiters op
fiere peerden, op den weg die naar Leupegem leidt. Sommigen droegen
banieren. Degene, die statig voorop reed, had een goudlakensche
muts op met groote pluimen. Hij droeg een kleed van bruine panne,
met bloemen geborduurd.

Uilenspiegel zette zijn bril op en zag dat het keizer Karel was,
die hoogstgenadiglijk aan die van Oudenaarde kwam toestaan hem hunne
beste wijnen en fijnste vleezen op te dienen.

Heel die troep kwam stapvoets af en snoof de frissche lucht op, die
eetlust doet krijgen; maar Uilenspiegel zei tot zich zelven, dat die
lieden de vette brokken gewoon waren en zij niet zouden sterven zoo
zij eens over den pot sprongen, daar vasten gezond is. Hij zag ze
dus komen, maar blies niet op de trompet.

Lachend en pratend kwamen zij nader, terwijl Zijne Heilige Majesteit
het hoofd voorover boog, als om te zien of er in zijnen buik plaats
genoeg was voor het festijn van die zijner goede stad Oudenaarde. Doch
hij was verwonderd en ontevreden dat geenerlei klokke luidde, om
zijne komst te kondschappen.

Ondertusschen kwam een boer de stad binnenloopen om te zeggen, dat hij
in de omstreken een Franschen aanhang gezien had, die op Oudenaarde
aanrukte, om alles te stelen en te rooven.

Op die rede sloot de poortwachter zijne poort en liet de andere
poortwachters door een knaap der gemeente verwittigen. Maar de wacht
kermiste zonder van iets te weten.

Zijne Majesteit kwam nader, zeer ontstemd, geen klokkengelui of
kanongebulder te vernemen. Te vergeefs de ooren spitsend, hoorde
hij niets dan de beiaard, die het half uur speelde. Hij kwam vóór de
poort, vond die gesloten en sloeg er op met de vuisten om opengedaan
te worden.

En de heeren van zijn gevolg, verstoord als Zijne Majesteit, gromden
bittere woorden. De poortwachter, die omhoog op de vestingen stond,
riep hun toe dat zij moesten stille zijn, of dat hij hun wat kogels
zou zenden, hetwelk hun ongeduld eenigszins zou koelen.

Doch Zijne Majesteit, in woede ontstoken, riep:

--Blind verken, herkent gij uwen keizer niet?

De poortwachter antwoordde, dat de meest vergulde verkens niet altijd
de kleinsten waren, dat hij overigens goed wist, dat de Franschen
spotters van nature waren, en keizer Karel voor 't oogenblik oorloogde
in Italië, en dus niet voor de poorten van Oudenaarde wezen kon.

Daarop schreeuwden de keizer en de heeren nog luider, zeggende:

--Als gij niet opendoet, laten wij U braden op eene lans. En eerst
zult gij uwe sleutels inslikken.

Op het gerucht dat zij maakten, kwam een oudgediende uit de plaats waar
't geschut stond. Hij keek over den muur en sprak tot den poortwachter:

--Gij zijt mis, dat is onze keizer; ik herken hem goed, hoewel hij
verouderd is sedert hij Maria Vander Gheynst van hier naar 't kasteel
van Lalaing voerde.

De poortwachter viel stokkedood van schrik, de soldaat nam de sleutels
en deed de poort open.

De keizer vroeg waarom men hem zoolang had laten wachten; als de
soldaat hem het geval uitgelegd had, beval Zijne Majesteit de poort
weder te sluiten en de ruiters van Kornjuin te doen komen. Hij deed
ze vóór hem gaan, slaande op de tamboerijnen en spelend op de pijpen.

Weldra ontwaakten de klokken de eene na de andere en begonnen zij te
bimbommelen. Aldus voorafgegaan, kwam Zijne Majesteit met keizerlijk
lawaai op de Groote Markt. Burgemeesteren en schepenen waren op het
stadhuis vergaderd; schepen Jan Guigelaer kwam met veel gedruisch de
zaal binnen en riep:

--Keizer Karel is alhier! Keizer Karel is alhier!

Ten uiterst verschrikt bij het hooren van die tijding, liepen
burgemeesteren, schepenen en raadsheeren buiten om, in korps, keizer
Karel te begroeten, terwijl hunne knapen de stede rondliepen om het
vuurwerk in gereedheid te brengen, de kapoenen op 't vuur te zetten
en de tonnen aan te steken.

Mannen, vrouwlieden en kinderen riepen tot elkander:

--Keizer Karel is op de Groote Markt!

Weldra was het volk in groote menigte naar de Markt gestroomd.

Grammoedig vroeg de keizer aan de twee burgemeesteren, of zij niet
verdienden gehangen te worden, om aldus te kort te komen aan den
eerbied, den vorst verschuldigd.

De burgemeesteren antwoordden, dat zij zulks inderdaad verdienden,
maar dat Uilenspiegel, de torenwachter, het meer verdiende, vermits
hij, op de mare van 't bezoek van Zijne Majesteit, op den toren gezet
werd met een goeden bril, met uitdrukkelijk bevel driemaal te blazen,
zoodra hij den keizerlijken stoet in het gezicht kreeg. Maar hij had
het niet gedaan.

De keizer, nog immer gram, deed Uilenspiegel komen.

--Waarom, sprak hij, hebt gij bij mijne komst niet geblazen, terwijl
gij een goeden bril hadt?

Dit zeggende, streek hij de hand over de oogen, om den wille van de
zonne, en zoo bekeek hij Uilenspiegel.

Deze streek ook de hand over de oogen en antwoordde dat hij, sedert
hij Zijne Heilige Majesteit door zijne vingeren zag kijken, geen bril
meer wilde bezigen.

De keizer zei hem, dat hij ging gehangen worden; de poortwachter zei
dat het wel besteed was, en de burgemeesteren zeiden geen woord om
die sententie goed te keuren of tegen te spreken, want zij waren met
schrik vervuld.

De beul en zijne knechten werden geroepen. Zij kwamen met eene ladder
en een nieuwe koorde, grepen Uilenspiegel bij den kraag en deden hem
vóór de honderd ruiters van Kornjuin gaan. In stee van hem gerust
te laten om zijne gebeden te zeggen, begonnen deze hem te sarren en
te plagen.

Het gemeen, dat volgde, zegde:

--'t Is een ongemeene wreedheid, dien armen jongen voor zulk een
gering vergrijp ter dood te veroordeelen.

En de wevers, die daar in groote menigte onder de wapens stonden,
zegden:

--Wij zullen Uilenspiegel niet laten hangen; dat is in strijd met de
costume van Oudenaarde.

Doch men kwam aan het galgeveld. Uilenspiegel werd op de ladder
getrokken, en de beul deed de koorde rond zijnen hals. De wevers
drongen rond de galge. De provoost was daar, met de roede der justitie
bij zich, met dewelke hij op bevel van den keizer het teeken tot de
uitvoering moest geven.

Heel het vergaderde volk riep:

--Genade! genade voor Uilenspiegel!

Uilenspiegel, van op zijne ladder, sprak:

--Medelijden! genadige keizer!

De keizer hief de hand op en sprak:

--Als die deugniet mij iets vraagt, dat ik niet doen kan, schenk ik
hem het leven!

--Spreek, Uilenspiegel! riep het volk.

De vrouwen weenden en zeiden:

--Hij moet sterven, de jongen, want de keizer kan alles.

En allen riepen:

--Spreek, Uilenspiegel!

--Heilige Majesteit, ik zal U noch geld, noch erfgoederen, noch het
leven vragen, doch enkel iets voor hetwelk gij beloven moet, als
ik zoo spreken durf, mij niet te zullen doen geeselen of radbraken,
vóór dat ik naar de andere wereld vertrek.

--Dat beloof ik, sprak de keizer.

--Majesteit, zei Uilenspiegel, ik vraag dat, vóór ik gehangen worde,
gij mijnen mond komt kussen met denwelken ik geen Vlaamsch spreke....

De keizer, die lachte evenals heel de menigte, antwoordde:

--Ik kan niet doen wat gij mij vraagt, en gij zult niet gehangen
worden, Uilenspiegel.

Maar de burgemeesteren en schepenen veroordeelde hij om, zes maanden
lang, eenen bril van achteren op het hoofd te dragen, opdat, zegde
hij, als die van Oudenaarde van voren niet zien, zij tenminste van
achteren zouden zien.

En, bij keizerlijk decreet, staat die bril nog heden op het wapen
van de stad.

En Uilenspiegel ging zediglijk henen, met een kleine tassche vol geld,
dat de vrouwen hem hadden gegeven.




XLIII.

Uilenspiegel, die te Luik op de vischmarkt liep, zag een dikken
jongeling, die een net met allerhande gevogelte onder den arm droeg
en nog een ander vulde met schelvisch, forellen, paling en karpers.

Uilenspiegel herkende Lamme Goedzak.

--Wat doet gij hier, Lamme? vroeg hij.

--Gij weet, sprak hij, dat die van Vlaanderen welkom zijn in het
zoete land van Luik; ik ben hier heengetrokken door de liefde. En gij?

--Ik zoek een meester om brood te verdienen, antwoordde Uilenspiegel.

--'t Is droge kost, zei Lamme. Een rozenkrans van ortolanen met eene
lijster, als credo, staat verre daarboven.

--Zijt gij rijk? vroeg Uilenspiegel hem.

Lamme Goedzak antwoordde:

--'k Verloor mijn vader, mijn moeder en mijn jongere zuster, die mij
altijd sloeg. Ik erfde hun vermogen en ik woon met eene dienstmaagd,
die maar één oog heeft, zeer ervaren in de kunste van braden en koken.

--Wil ik uwe visch en uw gevogelte dragen, vroeg Uilenspiegel.

--Ja, sprak Lamme.

En beiden slenterden voort langs de markt.

Eensklaps vroeg Lamme:

--Weet gij waarom gij niet wijs zijt?

--Neen, antwoordde Uilenspiegel.

Omdat gij dit eten in de hand draagt, in stee van in uwe maag.

--Inderdaad, Lamme, antwoordde Uilenspiegel; maar sinds ik geen brood
meer heb, willen de ortolanen mij niet meer bezien.

--Gij zult er hebben, Uilenspiegel, sprak Lamme, en gij zult mij
dienen als gij mijne dienstmaagd vermoogt te bevallen.

Terwijl zij voortgingen, toonde Lamme aan Uilenspiegel, een schoone,
lieve, poezele meid, in zijde gekleed, die langs de markt liep en
Lamme toelonkte.

Een oud man, heur vader, ging achter heur met twee netten, één met
visch, het ander met wild.

--Die, sprak Lamme, die wordt mijne gade.

--Ja, sprak Uilenspiegel, ik ken heur, 't is een Vlaamsche van
Zottegem; zij woont in de rue Vinave-d'Isle, en de buren zeggen,
dat hare moeder in heure plaats de straat vóór de deur keert en dat
heur vader heure hemdenen strijkt.

Doch Lamme antwoordde niet en sprak blijde:

--Zij heeft mij bezien.

Getweeën kwamen zij aan het huis van Lamme, omtrent eene brug over
de Maas, en Lamme klopte aan de deur. Een eenoogige dienstmaagd kwam
opendoen. Uilenspiegel zag dat zij oud, lang, mager en norsch was.

--Sanginne, sprak Lamme tot haar, wilt gij dezen jongen man om u te
helpen in uw werk?

--Ik zal hem probeeren, sprak zij.

--Neem hem, sprak hij, en laat hem de lekkernijen van uwe keuken
proeven.

Sanginne bracht toen drie zwarte pensen, eene pint kuite en eene
homp brood.

Terwijl Uilenspiegel aan 't eten was, smulde Lamme ook aan eene pens.

--Weet gij, vroeg hij hem, waar onze ziel woont?

--Neen, Lamme, sprak Uilenspiegel.

--In onze maag, antwoordde Lamme, daar wordt ze steeds doorploegd
om ons voortdurend nieuwe geesteskracht te schenken. En welke zijn
onze beste gezellen? Het zijn de fijne brokken, begoten met wijn van
de Maas.

--Ja, sprak Uilenspiegel, pensen zijn aangenaam gezelschap voor een
eenzame ziele.

--Hij vraagt nog, Sanginne, sprak Lamme.

Deze reis gaf Sanginne hem witte pensen.

Terwijl Uilenspiegel zich volstopte, zei Lamme, in gedachten
verslonden:

--Als ik zal sterven, zal mijn maag met mij sterven, en hier beneden,
in het vagevuur, zal men mij laten vasten, en laten ronddwalen met
een slappen en ledigen buik.

--De zwarte waren beter, zei Uilenspiegel.

--Gij hebt er zes gegeten, sprak Sanginne, gij krijgt geene meer.

--Uilenspiegel, sprak Lamme, gij zult hier goed behandeld worden,
en eten lijk ik.

--Dat woord zal ik onthouden, zei Uilenspiegel.

Uilenspiegel, ziende dat hij at lijk Lamme, was gelukkig. De pensen
die hij gegeten had, gaven hem zulken moed, dat hij dien dag ketels,
potten en pateelen deed blinken lijk zonnen.

Daar hij goed leven had in dit huis, verbleef hij geerne in kelder en
keuken, en liet hij den zolder aan de katten. Eens had Sanginne twee
kiekens te braden, en beval tot Uilenspiegel aan het spit te draaien,
terwijl zij naar de markt om de toespijzen ging.

Als de twee kiekens gebraden waren, at Uilenspiegel er een op.

Sanginne kwam terug en ze sprak:

--Er waren twee kiekens, en ik zie er maar een meer.

--Doe uw ander oog open en gij zult ze alle twee zien, antwoordde
Uilenspiegel.

Woedend ging zij dat vertellen aan Lamme Goedzak, die naar de keuken
kwam en aldus sprak tot Uilenspiegel:

--Waarom spot gij met de meid? Er waren twee kiekens.

--Inderdaad, Lamme, sprak Uilenspiegel, maar als ik hier binnenkwam,
hebt gij gezegd dat ik zou eten en drinken als gij. Er waren twee
kiekens: een heb ik gegeten, het ander is voor u; mijne vreugd is
voorbij, de uwe nog niet; zijt gij niet gelukkiger dan ik?

--Ja, sprak Lamme glimlachend, maar doe immer alles wat Sanginne u
zal zeggen, en gij zult maar half werk hebben.

--Ik zal mijn best doen, Lamme, antwoordde Uilenspiegel.

Telkens dat Sanginne hem dan ook iets gebood, deed hij het maar half,
als zij hem zei van twee akers water te putten, bracht hij er maar
een; als zij hem vroeg aan de tonne den pot met kuite te vullen,
goot hij onderweg de helft in zijn keelgaat, en zoo verder.

Ten slotte werd Sanginne het moede en ze zei tot Lamme dat, als die
deugniet langer in huis bleef, zij dadelijk heenging.

Lamme ging tot Uilenspiegel en zei:

--Gij moet heengaan, mijn jongen, niettegenstaande dat gij hier goed
waart in huis. Hoor dien haan kraaien, 't is twee uren na middag,
dat is een teeken van regen. Liever zette ik u niet buiten, als er
slecht weder op handen is; maar bedenk, mijn jongen, Sanginne houdt met
heur gekook en gebraad mijn levenslicht brandend; als zij mij verlaat,
moet ik sterven. Ga heen dus, mijn vriend, op Gods genade, en neem deze
drie gulden en dezen krans worsten, om u tot vertroosting te dienen.

En Uilenspiegel trok beschaamd en beteuterd henen, want hij betreurde
Lamme en zijne keuken.




XLIV.

De slachtmaand kwam te Damme en elders, maar 't was een late
winter. Noch sneeuw, noch koude, noch regen; de zonne scheen van 's
morgens tot 's avonds, de kinderen stoeiden in het stof van straten en
wegen; en kooplieden, kramers, goudsmeden, wagenmakers en werklieden
kwamen 's avonds na het eten, op de zulle hunner deur, kijken naar den
immerblauwen hemel, naar de boomen, die nog hunne bladeren hadden,
naar de ooievaars, die op de daken zaten en de zwaluwen, die nog
niet vertrokken waren. De rozen hadden driemaal gebloeid en botten
voor de vierde reize; de nachten waren zoel, de vogeltjes kweelden
in de bosschen.

Die van Damme zegden:

--De winter is dood, laat ons hem verbranden.

En zij maakten een grooten man met een berensnoet, een langen vlassen
baard en haar van schavelingen. Zij deden hem witte kleederen aan en
verbrandden hem in groote plechtigheid.

Klaas was weemoedig; hij zegende geenszins den immerblauwen hemel,
noch de zwaluwen die niet wilden vertrekken. Want te Damme brandde
niemand meer kolen, tenzij voor de keuken, en daar iedereen er
daarvoor genoeg had, ging niemand er koopen bij Klaas, die al zijne
spaarpenningen uitgegeven had om zijn voorraad in te doen.

De kooldrager stond op de zulle zijner deur, toen hij zijn neus door
een koel windeken voelde streelen,

--Ha! sprak hij, daar komt mijn brood aanwaaien.

Maar het koel windeken bleef niet waaien, en de hemel bleef immer
blauw, en de bladeren wilden niet vallen. En Klaas weigerde zijn
wintervoorraad voor halfprijs te verkoopen aan den gierigaard
Grijpstuiver, den deken der vischverkoopers. En weldra was er gebrek
in de arme stulp.




XLV.

Doch koning Philippus had geen honger; hij at gebakjes bij zijne
gemalin, Maria de leelijke, van het koninklijk huis der Tudor's. Hij
beminde heur niet, doch hoopte die tengere vrouw te bevruchten om
aan de Engelsche natie een Spaanschen koning te geven.

Maar de verbintenis van een steen met een brandende kool mislukte haar
doel. Toch waren Philippus en Maria genoeg verbonden om protestanten
met honderden te doen sterven door het vuur en het water.

Als Philippus niet uit Londen was, of als hij niet, onder eenige
vermomming, in het een of ander slecht kot zijn vermaak zocht, bracht
de nacht de beide echtgenooten bij elkander.

Dan leunde koningin Maria, in schoone Iersche kant en fijn Doornijksch
lijnwaad gehuld, tegen het echtelijk bed, terwijl Philippus keek of
hij bij zijne vrouw geenerlei teeken van zwangerschap zag; doch niets
ziende, werd hij kwaad en bekeek de toppen zijner vingeren zonder
een woord te uiten. Teederlijk zag de vorstinne hem aan; smeekte
den ijskouden Philippus om liefde. Niets ontzag zij, tranen, kreten,
noch smeekingen om een kus te ontvangen van hem, die heur zijn minne
niet schonk.

Als een uitzinnige vrouw lachte en weende zij tegelijk om hem te
verteederen; doch lachen noch tranen vermochten dit steenen herte
te smelten.

Als een verliefde slang, kronkelde zij zich, sloeg zij te vergeefs
hare armen rond hem en trok zij tegen heur hert de smalle borstkas,
waar de wanstaltige ziel van den bloedigen koning in huisde; maar
hij verroerde zich niet.

De arme vrouw deed heur best lieftallig te zijn; zij gaf hem al de
zoete namen, die de minnezieken geven aan de verkorene heurs herten:
Philippus bekeek de toppen zijner vingeren.

Soms antwoordde hij:

--Zult gij nooit kinderen hebben?

Op die rede boog Maria het hoofd.

--Is het mijne schuld, sprak zij, zoo ik onvruchtbaar ben? Heb
medelijden met mij: ik leef als eene weduwe.

--Waarom hebt gij geene kinderen? sprak Philippus.

Toen viel de vorstinne op het tapijt, als door den dood getroffen. En
hare oogen baadden in tranen, en zij hadde bloed geweend, hadde
zij gekunnen.

En aldus wreekte God de slachtofferen, waarmede de beulen Engelands
bodem hadden bedekt.




XLVI.

Het gerucht liep, dat keizer Karel van zins was het recht van
erflating te ontnemen aan al degenen, die in de kloosters stierven,
hetgeen den Paus grootelijks mishaagde.

Uilenspiegel, die toen in de vallei der Maas was, dacht dat de keizer
aldus te allen kant voordeel halen zou, want hij erfde als de familie
niet erfde. Hij zette zich neder aan den oever van den stroom en
wierp zijne lijn met het aas uit. Vervolgens knaagde hij aan een oude
broodkorst; het speet hem wel, dat hij er geen kroes wijn bij had, maar
hij zegde tot zich zelven: men kan 't niet altijd naar wensch hebben.

Toen wierp hij een stuk van zijn brood in 't water, want wie zijn
maaltijd niet deelt met zijn evennaaste, is niet weerd dat hij leeft.

Een grondeling kwam het brood rieken en opende onnoozel den bek, in
den waan, dat het brood er van zelf ging in vallen. Terwijl hij aldus
in de lucht keek, werd hij eensklaps ingeslikt door een verradelijken
snoek, die als een pijl op hem was toegeschoten.

Een karper, die argeloos in de lucht naar de vliegen hapte, onderging
hetzelfde lot. Als de snoek verzadigd was, bleef hij onbeweeglijk stil,
de kleine vischjes versmadend, die pijlsnel van hem wegzwommen. Terwijl
hij aldus in trotschheid zijn gemak nam, schoot een hongerige,
vraatzuchtige snoek met open muil op hem toe. Een woedend gevecht
ontstond en weldra zag het water rondom hen rood van bloed. De
verzadigde snoek verdedigde zich slecht tegen den hongerige, die wat
achteruit zwom, zijn aandrift nam en op zijn tegenstrever toeschoot,
welke hem met open muil afwachtte en de helft van zijn kop inslikte;
hij wilde hem weder uit den muil stooten, doch hij slaagde er niet in,
om den wille van zijne haaktanden. En beide spartelden wanhopiglijk.

Aldus aaneengehecht, zagen zij den sterken angel niet, die, aan een
zijden snoer gebonden, langzaam omhoog kwam en in de vinne drong van
den verzadigden snoek, beide optrok en ze met krachtigen zwenk op
het gras smeet.

Uilenspiegel sneed hun de keel af en sprak:

--Snoeken, mijne vrienden, mocht gij de paus en de keizer zijn, die
elkander verslinden, en ik het wakkere volk dat u beiden opscheert,
op het uur dat God zal believen!




XLVII.

En Katelijne, die Borgerhout niet verlaten had, dwaalde steeds door
de velden en herhaalde gedurig: "Hansken, mijn man, zij hebben
vuur op mijn hoofd gelegd; maak er een gat in, dat mijne ziel er
uit kome. Helaas! zij klopt altijd en elke klop doet zeer als een
hamerslag."

En Nele verzorgde de arme uitzinnige, en treurig dacht zij aan heuren
vriend Uilenspiegel.

En te Damme bond Klaas zijne mutsaards en verkocht zijne kolen;
en menigwerf werd hij droefgeestig als hij dacht aan Uilenspiegel,
den banneling, die nog in langen tijd niet zou mogen terugkeeren naar
de ouderlijke stulp.

Soetkin zat heele dagen aan het venster te kijken of zij heuren zoon
niet zag aankomen.

Deze was nu bij Keulen en kreeg lust in 't hovenieren.

Hij ging zich als knecht verhuren bij Jan van Zuursmoel, die, ten
tijde dat hij kapitein der landsknechten was, wegens wanbetaling van
soldij bijna gehangen geweest was, weshalve hij een grooten afkeer
had van hennep, door de boeren kennep genoemd.

Op zekeren dag nam Jan van Zuursmoel Uilenspiegel mede naar zijn akker,
waarnaast een dagwand, geheel met kennep beplant.

Jan van Zuursmoel sprak tot Uilenspiegel:

--Telkenmale dat gij die leelijke plant ziet, moet gij ze met zooveel
verachting bejegenen als gij maar kunt, want zij dient tot rad en
tot galg.

--Ik zal het onthouden, antwoordde Uilenspiegel.

Eens nu dat Jan van Zuursmoel met eenige vrienden aan tafel zat,
zei de keukenmeid tot Uilenspiegel:

--Ga naar den kelder en haal er den zennep, wat toen mosterd bediedde.

Uilenspiegel opzettelijk kennep in plaats van zennep verstaande,
bejegende den mosterdpot met de meest mogelijke verachting en kwam
hem vervolgens op de tafel stellen, heimelijk lachend.

--Waarom lacht gij? vroeg Jan van Zuursmoel. Meent gij dat onze
neuzen van koper zijn? Eet zelf dien zennep, mits gij hem zelven
gereedgemaakt hebt.

--Ik eet liever kaneelkoekjes, antwoordde Uilenspiegel.

Jan van Zuursmoel stond recht om hem te slaan.

--Wat hebt gij in dien mosterdpot gedaan? sprak hij.

--Wel baas, antwoordde Uilenspiegel, herinnert gij u niet den dag, toen
ik u moest volgen naar den akker en gij mij, den zennep aanwijzende,
zegdet: "Overal waar gij die leelijke plant ziet, moet gij ze met
zooveel verachting bejegenen als gij maar kunt, want zij dient tot
rad en tot galg." En ik heb het gedaan, baas, ik heb ze al mijne
verachting uitgedrukt; gaat ge mij nu slaan omdat ik gehoorzaam was?

--Ik heb kennep gezeid en niet zennep, riep Jan van Zuursmoel.

--Baas, ge hebt zennep gezeid en niet kennep, antwoordde Uilenspiegel.

Nog langen tijd twistten zij aldus voort, Uilenspiegel op nederigen
toon, Jan van Zuursmoel met een woedend geschreeuw, waarin hij de
woorden hennep, zennep, kemp-zemp, zemp-kemp ondereen mengde als een
verwarde streng zijde.

En de gasten lachten als duivels, die zich goed doen aan
preekheerenribben en kettermeestersnieren.

Maar Uilenspiegel moest de deur uit.




XLVIII.

Nele was nog zeer bedroefd voor heur zelve en voor heure uitzinnige
moeder.

Als Uilenspiegel zich bij een kleermaker verhuurde, zei deze tot hem:

--Als gij naait, naai dicht aaneen, dat ik de steken niet
zie. Uilenspiegel ging zich onder eene tonne zetten en begon daar
te naaien.

--Wat is dàt nu? riep de kleermaker.

--Ik ben in de ton gekropen om te naaien, dan kunt gij immers de
steken niet zien? antwoordde Uilenspiegel.

--Kom, sprak de kleermaker, zet u hier neer op de tafel, en stik uwe
steken dicht bij elkander, en maak het kleed als deze wolf.--Wolf
was de naam van een boerenwambuis.

Uilenspiegel nam het wambuis, sneed het aan stukken, naaide het aaneen,
zooveel als hij kon in de gedaante van een wolf.

Toen de kleermaker dat zag, riep hij uit:

--Wat duivel? maakt gij daar?

--Een wolf, antwoordde Uilenspiegel.

--Leelijke spotter, sprak de kleermaker, ik had u gezegd van een
wolf te maken, 't is waar, maar gij weet toch wel, dat een wolf een
boerenwambuis is.

Eenigen tijd naderhand zegde hij hem:

--Jongen, gooi nog eens gauw de mouwen aan dien bovenkerel daar,
eer gij slapen gaat.

Uilenspiegel hing den bovenkerel aan eenen nagel en bracht heel den
nacht door met de mouwen naar het kleedingstuk te werpen.

Op het leven dat hij maakte, kwam de kleermaker kijken.

--Deugniet, sprak hij, welke kwade poets zijt gij mij nu aan 't bakken?

--Gij heet dat een kwade poets? antwoordde Uilenspiegel. Bezie die
mouwen, heel den nacht gooi ik ze naar den bovenkerel, en ze blijven
er nog niet op.

--Dat spreekt van zelf, zei de kleermaker, daarom gooi ik u op straat,
misschien blijft gij er op.




XLIX.

Als Katelijne bij een of anderen braven gebuur was, die op heur wilde
letten, ging Nele verre, verre alleen, zelfs tot Antwerpen, langsheen
de Schelde of elders, turend naar de wiegelende schuitjes en naar de
stoffige wegen, of ze soms heuren vriend Uilenspiegel niet ontwaarde.

Eens dat Uilenspiegel te Hamburg op de jaarmarkt was, zag hij
overal kooplieden, en onder hen, eenige oude joden, woekeraars en
schacheraars.

Uilenspiegel, die ook wilde koopmanschap drijven, raapte eenige
peerdevijgen op en droeg ze mee naar huis, 't is te zeggen naar een
hoek van den vestingmuur. Daar liet hij ze drogen. Vervolgens kocht
hij roode en groene zijde, van dewelke hij zakjes maakte; daarin
stak hij de peerdevijgen, en hij bond de zakjes toe met een lint,
alsof er muskus in stak.

Vervolgens maakte hij een houten bakje, hetwelk hij met een oude koord
om zijn hals hing, en hij kwam op de markt met het bakje vol roode
en groene zakjes, 's Avonds stelde hij een keersken midden tusschen
de zakjes, om ze te verlichten.

Als men hem kwam vragen wat hij verkocht, antwoordde hij op
geheimzinnigen toon:

--Ik zal het u zeggen, maar spreek niet te luide.

--Wat is het dan? vroegen de klanten.

--Het zijn, antwoordde Uilenspiegel, profetische zaadkorrels, die
recht van Arabië naar Vlaanderen kwamen; zij zijn met groote kunste
gereedgemaakt door meester Abdul-Medil, afstammeling van den grooten
Mahomed.

De klanten zeiden tot elkander:

't Is een Turk.

Anderen spraken:

--Maar neen, 't is een pelgrim, die uit Vlaanderen komt; hoort gij
't niet aan zijne tale?

En armoedige, in lompen gehulde liefhebbers spraken:

--Geef ons eenige profetische zaadkorrels.

--Als gij guldens zult hebben om te betalen, antwoordde Uilenspiegel.

En de armoedige, in lompen gehulde liefhebbers gingen beteuterd henen,
zeggende:

--Alles is toch voor de rijken hier op de wereld!

Maar weldra werd op de markt het gerucht verspreid, dat daar een
Vlaming was met profetische zaadkorrels.

--Ja, zeiden de poorters tot elkander, ze zijn te Jeruzalem op het graf
van Jezus Christus gewijd, maar men zegt dat hij ze niet wil verkoopen.

En de poorters kwamen bij Uilenspiegel en vroegen hem van zijne
zaadkorrels.

Maar Uilenspiegel, die groote winsten wilde opstrijken, antwoordde dat
zij niet rijp genoeg waren, en hij hield het oog op twee rijke joden,
die langs de markt slenterden.

--Ik zou wel eens willen weten, sprak een der poorters, wat er geworden
zal van mijn schip, dat op zee is.

--Het zal ten hemel varen, als de baren hoog genoeg rijzen, antwoordde
Uilenspiegel.

Een ander liet hem zijn dochter zien, een blozende, poezele meid,
en vroeg hem of het goed met haar zou loopen.

--Alles loopt zooals de natuur het wil, antwoordde Uilenspiegel,
want hij had het meisje een sleutel zien geven aan een jongen man,
die, glanzend van geluk, aan Uilenspiegel vroeg:

--Koopman, geef mij een van uwe profetische zakjes, opdat ik wete of
ik dezen nacht alleene zal slapen.

--Er staat geschreven, sprak Uilenspiegel, wie verleiding zaait,
zal horens maaien.

De jonge snaak was grammoedig en vroeg:

--Wat wilt gij zeggen?

--De zaadkorrels zeggen, antwoordde Uilenspiegel, dat zij u wenschen
een gelukkig huwelijk en een vrouw, die u geen Vulcanus-hoed
opzet. Kent gij dat hoofddeksel?

Vervolgens sprak hij op den toon van een zedenpreeker:

--Want de vrouw die een godspenning geeft op den huwelijkskoop,
geeft naderhand heel de waar aan anderen weg.

Stoutweg vroeg de meid aan Uilenspiegel:

--Ziet men dat allemaal in uwe profetische zakjes?

--Men ziet er mede eenen sleutel in, fluisterde Uilenspiegel heur
stil in het oor.

Maar de jongeling was weg met den sleutel.

Eensklaps zag Uilenspiegel een dief van den stal van een spekslachter
eene worst nemen van eene elle lang en die onder zijn mantel
verbergen. Maar de koopman zag het niet. Blijgezind kwam de dief bij
Uilenspiegel, en hij vroeg hem:

--Wat verkoopt gij daar, ongeluksprofeet?

--Zakjes, waarin gij zult zien dat uwe liefde voor de worsten u naar
de galg zal brengen.

Op die rede nam de dief ijlings de vlucht, terwijl de bestolen
koopman riep:

--Houdt den dief! houdt den dief!

Maar deze was de gaten uit.

Terwijl Uilenspiegel sprak, kwamen de twee rijke Joden, die met
aandacht geluisterd hadden, naar hem toe en vroegen:

--Wat verkoopt gij daar, Vlaming?

--Zakjes, antwoordde Uilenspiegel.

--En wat ziet men met uwe profetische zaadkorrels? vroegen zij weder.

--Men ziet de toekomst, als men op de zaadkorrels zuigt, antwoordde
Uilenspiegel.

De twee joden spraken stille tot elkander, en de oudste zei tot
den anderen:

--Zoo zouden wij weten wanneer onze Messias komt; dat ware voor ons
een groote vertroosting. Laat ons een van die zakjes koopen.

--Hoeveel, uwe zakjes? vroegen zij.

--Vijftig gulden, antwoordde Uilenspiegel. Is het te veel, trekt dan
maar op. Wie den akker niet koopt, heeft ook den vetten mest niet
van noode.

Ziende dat Uilenspiegel zoo vastberaden was, telden zij hem de
somme en namen zij een van de zakjes. Zij trokken er mee naar
hunne vergaderplaats, alwaar weldra al de joden in groote menigte
heenstroomden, toen zij gehoord hadden, dat de twee ouden een geheim
hadden gekocht, met hetwelk zij de komst van den Messias konden
voorzeggen.

Zoodra dit gekend was, wilden allen, zonder betalen, aan het zakje
zuigen; maar de oudste, die het zakje gekocht en betaald had en Jehu
hiet, wilde alleen de eer en 't genot hebben.

--Zonen van Israël, sprak hij, het zakje in de hand houdend, de
Christenen bespotten ons; zij maken jacht op ons, en roepen achter
ons alsof wij cahorsijnen of woekeraars waren. De Philistijnen willen
ons nog dieper dan den grond doen buigen; zij spuwen ons in 't gelaat,
want God heeft onze bogen ontspannen en de teugels losgelaten. Heere,
God van Abraham, van Isaäc en van Jacob, hoelang nog moet het kwaad
ons geworden, terwijl wij het goede verbeiden; hoelang moeten de
duisternissen heerschen, terwijl wij het licht verwachten? Goddelijke
Messias, zult gij weldra op de aarde nederdalen? Wanneer zullen de
Christenen zich verschuilen in holen en spelonken, bevend voor de
kastijding, die zij bij uwe verschijning zullen ontvangen?

En de joden riepen:

--Kom Messias! Zuig, Jehu!

Jehu zoog aan het zakje en, met walg spuwend, riep hij jammerend uit:

--Ik zeg U, in der waarheid, dat het drek is; de Vlaamsche pelgrim
is een dief.

Toen sprongen al de joden bij, en zij openden het zakje. Als zij zagen
wat er in stak, liepen zij in woede naar de jaarmarkt om Uilenspiegel
te vinden, maar deze had niet op hen gewacht.




L.

Een man van Damme, die aan Klaas zijne kolen niet kon betalen, had
hem het schoonste van zijn kateil gegeven, zijnde een handboog met
twaalf goed aangezette pijlen.

En als er niet te werken was, ging Klaas op jacht: meer dan één
beestje, te groot liefhebber van kool, werd door hem gedood en
veranderd in hazepeper.

Klaas zette zich toen gretig te eten, en Soetkin zag naar den eenzamen
weg en zeide:

--Thijl, mijn zoon, riekt gij den lekkeren geur van de saus
niet?... Ongetwijfeld heeft hij nu honger.

En droomerig, had zij hem zijn deel van 't festijn willen wegzetten.

--Als hij honger heeft, sprak Klaas, is het zijne schuld; dat hij
terugkome en hij zal eten als wij.

Klaas hield duiven; ook hoorde hij geerne, rondom zich, distelvinken,
leeuwerikken, musschen en andere vogelen zingen en piepen, en
schoot hij geerne muizenvalken en speurgalen, die de kleine vogelen
verslinden.

Nu, eens dat hij in zijne lochting kolen mat, toonde Soetkin hem een
grooten vogel, die in de lucht boven het duivenhok zweefde.

Klaas nam zijn handboog en sprak:

--De duivel redde Zijne Sperwerachtigheid!

Toen hij den pijl in den boog had gestoken, hield hij zich in de
lochting, alwaar hij al de bewegingen van den vogel met de oogen
volgde om hem niet te missen. Het was valavond. Klaas kon enkel een
zwarte stip onderscheiden. Hij schoot den pijl af en zag een ooievaar
in de lochting vallen.

Klaas was er droef om, maar Soetkin nog meer, en zij riep:

--Nu hebt gij den vogel Gods gedood!

Zij nam toen den ooievaar en zag dat hij maar aan den vleugel gewond
was; zij ging ongel halen en sprak, terwijl ze zijne wonde vermaakte:

--Ooievaar lief, 't is niet behendig voor u, die geerne gezien wordt,
van in de lucht te zweven als een steekvogel, die gehaat wordt. Aldus
treffen de pijlen des volks soms den verkeerden man. Hebt gij zeer aan
uwen vleugel, arme ooievaar, dat gij mij zoo gewillig laat begaan? Hoe
weet gij dat onze handen handen van vrienden zijn?

Als de ooievaar genezen was, kreeg hij alles te eten wat hem lustte;
doch liefst at hij de visch, die Klaas voor hem in de vaart ging
vangen. En telkens dat de vogel Gods hem zag komen, opende hij gretig
den bek.

Hij volgde Klaas als een hondje, maar liefst bleef hij in de keuken,
alwaar hij zijne maag warmde en met den snavel op Soetkin sloeg,
terwijl zij het noenmaal bereidde, als om heur te vragen:

--Is er niets bij voor mij?

En 't was aardig dien ernstigen geluksbode op zijne lange pooten de
hut te zien rondloopen.




LI.

Maar de slechte dagen waren teruggekomen: droevig wrocht Klaas alleen
op zijn akker, want er was geen werk voor hen beiden. Soetkin bleef in
de stulp en bereidde op allerhande manieren de boonen, hun dagelijksch
maal, om Klaas' eetlust te streelen. En zij zong en zij lachte, opdat
hij heure droefheid niet merken zou. De ooievaar stond bij heur,
op één poot en met den bek in de pluimen.

Een man te peerd hield voor hunne woning stil; hij was heel in 't
zwart gekleed en had een mager en droevig gezicht.

--Is hier iemand thuis? vroeg hij.

--God zegene Uwe Droefgeestigheid, antwoordde Soetkin; ben ik dan
een schimme, dat gij mij vraagt of iemand thuis is?

--Waar is uw vader? vroeg de ruiter.

--Als mijn vader den naam draagt van Klaas, is hij ginder, antwoordde
Soetkin, en bezig met koren te zaaien.

De ruiter ging weg, en Soetkin toog ook henen vol droefheid, want
voor de zesde reize moest ze, zonder geld, brood bij den bakker gaan
halen. En toen ze met ledige handen terugkwam, was zij versteld Klaas
triomfantelijk te zien terugkomen op het peerd van den zwarten man, die
te voet naast hem ging en het dier bij den toom hield. Klaas hield vol
trotschheid in de hand een lederen tassche, dewelke goed gevuld scheen.

Toen hij van 't peerd steeg, omhelsde hij den man en klopte hem
vervolgens vriendelijk op den schouder.

--Leve mijn broeder Judocus, de goede heremijt! riep hij uit, terwijl
hij de tassche deed rinkelen. God beware hem in vreugd, in vet en in
gezondheid. 't Is Judocus vol zegen, Judocus vol overvloed, Judocus
met zijne vette soep! De ooievaar heeft geenszins gelogen!

En hij legde de tassche op de tafel. Jammerend sprak Soetkin toen:

--Man, wij hebben geen eten vandaag: de bakker heeft mij brood
geweigerd.

Brood? sprak Klaas, de tassche openend en goudstukken op de tafel
gietend, brood? Daar is brood, boter, vleesch, wijn, bier! Daar zijn
hespen, mergpijpen, reigerpastijen, ortolanen, ganzen, krakelingen,
daar is ambrozijn, lijk bij de groote heeren! daar is bier met tonnen
en wijn met vaten! Gestraft wordt de bakker, want wij zullen bij hem
niets meer koopen.

--Maar man, sprak Soetkin verbaasd.

--Nu luister, sprak Klaas, en wees verblijd. Katelijne, in stee
van in 't markgraafschap Antwerpen hare ballingschap uit te doen,
is vergezelschapt door Nele, te voet naar Meiborg gegaan. Daar heeft
Nele tot mijn broeder Judocus gezegd, dat wij ondanks onzen harden
arbeid, veelal in armoe verkeeren. En naarvolgens die goede bode mij
zooeven gezegd heeft--en Klaas wees naar den zwarten ruiter--heeft
Judocus den heiligen Roomschen godsdienst verlaten, om de Luthersche
ketterije aan te hangen.

De zwarte man sprak:

--Ketters zijn zij, die de Groote Hoer volgen. Want de Paus vergeet
zijne plichten en drijft handel in de heilige zaken.

--Stil! zei Soetkin, spreek niet zoo luide, gij zoudt ons gedrieën
op den brandstapel brengen!

--Dus, vervolgde Klaas, Judocus heeft aan dezen braven bode gezegd,
aangezien hij strijden ging onder de troepen van Frederik van Saksen,
wien hij vijftig goed gewapende mannen bezorgde, hij zooveel geld
niet van noode had, want dat het, bij rampspoed, toch zou worden
gestolen door een of anderen landsknecht. Breng dus, zoo sprak hij,
met mijnen zegen, die zevenhonderd karolusgulden aan Klaas, mijnen
broeder en zeg hem dat hij goed leve en het heil zijner ziel gedenke.

--Ja, sprak de ruiter, want 't is tijd: God geeft een ieder naar zijne
werken en handelt met een iegelijk volgens de verdiensten zijns levens.

--Heer, sprak Klaas, 't zal mij ondertusschen toch niet verboden
zijn mij in de goede tijding te verblijden? Verweerdig u hier te
blijven. Om uwe boodschap te vieren, zullen wij eten heerlijke pensen,
menigvuldige karbonaden, een hammetje dat daar even zoo rond en zoo
lekker bij den spekslager lag, dat mijne tanden wel een voet lang
uit mijnen mond kwamen.

--Laas! sprak de man, alleen de goddeloozen denken aan genuchten,
terwijl de blikken des Heeren op hen zijn gevestigd.

--Nu, bode, sprak Klaas, wilt gij met ons eten en drinken of niet?

De man antwoordde:

--De geloovigen zullen hunne zielen aan de aardsche genoegens mogen
wijden, als de Babylonische Hoer ten gronde zal liggen!

Daar Klaas en Soetkin een kruis sloegen, wilde hij heengaan.

Klaas sprak tot hem:

--Zoo het U behaagt aldus met een slecht onthaal te vertrekken,
geef dan den vredekus aan mijn broeder Judocus en waak over hem in
't gevecht.

--Ik zal het doen, sprak de man.

En hij toog henen, terwijl Soetkin eten ging halen om dit uit de
lucht gevallen fortuin te vieren. Dien avond kreeg de ooievaar twee
grondelingen en een kabeljauwskop.

De mare verspreidde zich weldra te Damme, dat de arme Klaas, door
het toedoen van zijn broeder Judocus, de rijke Klaas was geworden. En
de deken zei, dat Katelijne zeker Judocus betooverd had, daar Klaas
van hem een groote somme gelds had gekregen en dat hij niet eens een
kleedje aan Onze-Lieve-Vrouw had geofferd.

Klaas en Soetkin waren gelukkig; Klaas wrocht op het veld of verkocht
zijne kolen, en Soetkin bleef de wakkere huisvrouw.

Maar Soetkin, altoos droefgeestig, zocht steeds, met de oogen, heuren
zoon Uilenspiegel op de wegen.

En alle drie smaakten het geluk, dat God hun zond, in afwachting van
hetgeen de menschen hun zouden jonnen.




LII.

Keizer Karel ontving dien dag uit Engeland een brief, in denwelken
zijn zoon hem schreef:



"Heer en Vader,

"Het mishaagt mij grootelijks te moeten leven in een land, waar
de gevloekte ketteren vermenigvuldigen als vlooien, rupsen en
sprinkhanen. Het vuur en het zweerd zouden niet te veel zijn om ze
te rukken van den stam des levendmakenden booms die onze Moeder de
Heilige Kerk is. Alsof mijn leed nog niet voldoende ware, beschouwen
mijne onderdanen mij niet als een koning, maar als den echtgenoot
van hunne koningin, die zonder haar geenerlei gezag zou hebben. Zij
spotten met mij, zeggende in kwaadwillige boekskens, waarvan niemand
den schrijver of drukker kan vinden, dat de Paus mij betaalt om
stoornis en verderf te brengen in het koninkrijk, door ketteren te
hangen en te branden en, zoo ik een dringende schatting opleggen
wil--want meermaals laten zij mij met opzet zonder geld--antwoorden
zij in boosaardige paskwils, dat ik er maar te vragen heb aan Satan,
voor denwelken ik werk. Die van 't Parlement bieden mij, uit vreeze,
hoogst nederig hunne verontschuldiging aan, maar zij geven toch niets.

"Doch de muren van Londen zijn bedekt met opschriften, waarin ik
voorgesteld word als een vadermoorder, gereed om Uwe Majesteit te
treffen, om van hem te erven.

"Maar gij weet, Heer en Vader dat onaangezien rechtmatigen trots,
ik aan Uwe Majesteit nog lange en glorierijke dagen wensch.

"Ook verspreiden zij in de stad eene prent, geëtst op koper,
waarop ik afgebeeld word staande bij eene klavecimbel, in dewelke
katten opgesloten zijn, die met hare pooten op de snaren slaan
en wier steerten steken uit ronde gaten, waaraan zij met ijzeren
roeden vastgemaakt zijn. Een man, die ben ik, verbrandt de steerten
met een gloeiend ijzer, om de dieren met de pooten op de toetsen
te doen slaan en erbarmlijk te doen kermen. Ik ben afgebeeld zoo
wanstaltig en met zulken grijnslach, dat ik mij niet wil bezien. En
gij weet, Heer en Vader, of ik mij ooit aan zulk onheilig vermaak
overleverde. Ongetwijfeld deed ik wel eens, voor mijn pleizier,
katten mauwen, doch ik lachte niet. Als echte muitmakers, rekenen
zij mij dit alles als eene misdaad aan, hoewel de dieren geene ziel
hebben, en een iegelijk, en inzonderheid vorstelijke personen, zich
van hen mag bedienen tot nut en verzet. Maar in Engeland is men zoo
verzot op dieren, dat men ze beter behandelt dan de dienstknechten;
stallen en hondehokken zijn hier paleizen en hier zijn heeren, die
in den stal bij hun peerd slapen.

"Daarenboven is mijne gade en koningin onvruchtbaar. Om mij te
beleedigen zeggen ze, dat ik, niet zij--die jaloersch, onhandelbaar,
en bovenmate minneziek blijft--daarvan de schuld is. Mijnheer en Vader,
alle dagen bid ik deemoedig Onzen Heere, dat Hij mij Zijne genade
schenke, in de hoop dat Hij mij een anderen troon geve, al was het
bij de Turken, in afwachting van dien tot denwelken eenmaal geroepen
zal worden de zoon Uwer Allerglorierijkste en Allerzegevierendste
Majesteit.

"Ondertekend: Philippus."


De keizer antwoordde als volgt:



"Mijnheer en Zoon,

"Uwe vijanden zijn groot, ik betwist het geenszins, doch tracht
zonder grammoedigheid een schitterender kroon te verbeiden. Reeds
meermalen heb ik het voornemen uitgedrukt, mij terug te trekken uit
de Nederlanden en uit mijne andere bezittingen, want ik voel dat ik,
oud en jichtig als ik word, niet meer zal kunnen wederstaan aan Hendrik
van Frankrijk, den tweeden van dien naam, want de Fortuin lacht steeds
den jongeren toe. Verlies ook niet uit het oog, dat gij, meester van
Engeland, door uwe macht, Frankrijk, onzen vijand, kwetst en vernedert.

"Ik werd deerlijk verslagen vóór Metz, alwaar ik veertig duizend man
verloor; ik moest vluchten voor den koning van Saksen. Als God mij
door Zijne Goedertierenheid in mijn vroegere kracht en macht niet
wil herstellen, ben ik van zins, Mijnheer en Zoon, U mijne rijken af
te staan.

"Heb dus geduld en doe ondertusschen uwen plicht tegen de ketterijen,
van dewelke gij niemand moet sparen, noch mannen, noch vrouwlieden,
noch kinderen, want mij is niet zonder leed ter kennis gekomen,
dat Mevrouw de koninginne hun dikwijls genade wil schenken.

"Uw verkleefde vader,

Onderteekend: Karel."




LIII.

Daar Uilenspiegel lang, zeer lang gegaan had, waren zijne voeten tot
bloedens toe gekwetst. Doch in het bisdom Mentz ontmoette hij eenen
wagen met pelgrims, die hem naar Rome bracht.

Toen hij in die stad kwam en uit den wagen stapte, zag hij aan de
poort eener afspanning een poezele vrouwe staan, die hem toelachte.

Heur minnelijk gezichtje beviel hem ten volle.

--Weerdin, sprak hij, wilt gij een reizenden pelgrim herbergen, die,
met zonden overladen, den Heiligen Vader om genade komt smeeken?

--Wij herbergen al degenen, die betalen.

--Ik heb honderd dukaten in mijne tassche, antwoordde Uilenspiegel,
die er maar éénen had, en met u wil ik den eersten verteren; laat
ons een bottel ouden Roomschen wijn drinken.

--De wijn is niet duur in deze heilige stede, sprak zij; kom binnen
en drink voor een soldo.

Zij dronken samen lang en ledigden, onder vriendelijk gekeuvel,
zulke menigte flesschen, dat de weerdin aan heure meid zeggen moest
de klanten in heure plaats te gerieven, terwijl zij en Uilenspiegel
in een marmeren achterkamer zaten, waar het koel was als in den winter.

Heur hoofd op zijn schouder leunend, vroeg zij hem wie hij was.

--Ik ben messire van Geenland, grave van Nergensthuis heere van
Vastendonk, en 'k heb te Damme, dat mijne geboorteplaats is, vijf en
twintig bunders maneschijn.

--Waar ligt dat land? vroeg de weerdin, uit Uilenspiegel's beker
drinkend.

--'t Is een land, sprak hij, waar men stoute verbeelding, onzinnige
verwachtingen en ijdele beloften zaait; een land, waar gij niet
vandaan zijt, met uwe lichtbruine huid, met uwe oogen die flonkeren
als perelen; ze zijn van de kleur van de zonne, die goudbruine
lokken; 't is het erfdeel van Venus, die gevleesde schouderen, die
goddelijke borsten, die ronde armen, die fijne handjes. Willen wij
samen avondmalen?

--Schoone pelgrim uit Vlaanderen, sprak zij, wat komt gij hier doen?

--Den paus spreken, antwoordde Uilenspiegel.

--Laas! sprak zij, den paus spreken! Ik, die hier vandaan ben, heb
het nog nooit gekunnen.

--Ik zal het kunnen, sprak Uilenspiegel.

--Maar, sprak zij, weet gij waar hij gaat, hoe hij is, en kent gij
zijne levenswijze?

--Onderweg zegde men mij, antwoordde Uilenspiegel, dat hij Julius de
derde heet, dat hij ontuchtig, lichtzinnig is, dat hij goed klapt en
snedig antwoordt. Men zei ook mij, dat hij een ongemeene vriendschap
opgevat heeft voor een zwarten, vuilen bedelaar, die met een aapje
de aalmoes vroeg, dat hij hem tot kardinaal gemaakt heeft en dat hij
ziek is als hij hem een dag niet ziet.

--Drink, sprak zij, en spreek niet zoo luide.

--Men zei ook, vervolgde Uilenspiegel, dat hij eens vloekte als een
soldenier, toen hij een kouden pauw niet terugvond, dien hij had doen
wegzetten voor zijn avondmaal, en dat hij sprak: Ik, de stadhouder
Gods, mag wel vloeken om een pauw, wanneer mijn meester grammoedig
om eenen appel was! Gij ziet liefste, dat ik den paus ken en weet
wie hij is.

--Laas! zegde zij, spreek daarvan aan anderen niet. Maar gij zult
hem niet zien.

--Ik zal hem spreken, zei Uilenspiegel.

--Als gij dát kunt, betaal ik U honderd florijnen.

--Ik heb ze gewonnen! sprak Uilenspiegel.

Hoewel zijne beenen vermoeid waren, doorliep hij 's anderen daags
de stad en vernam hij, dat de paus dien dag de misse zou lezen in de
kerk van San Giovanni in Laterano. Uilenspiegel toog er henen, ging
zoo dicht bij den paus staan als hij kon, en telkens dat de paus den
kelk of de hostie ophief, keerde Uilenspiegel den rug naar het autaar.

De paus was bijgestaan door een schelmschen, zwaarlijvigen kardinaal,
die, met een aapje op den schouder, het volk het sacrament gaf,
met menigvuldige ontuchtige gebaren daarbij. Hij deed den paus de
handelwijze van Uilenspiegel kennen, en als de misse gedaan was,
kwamen vier groote pijkeniers zich meester maken van den pelgrim.

--Van welk geloove zijt gij? vroeg hem de paus.

--Van hetzelfde als mijne hospita, Zeer Heilige Vader, antwoordde
Uilenspiegel.

De paus ontbood de vrouwe.

--Wat gelooft gij? vroeg hij haar.

--Alles wat Uwe Heiligheid gelooft, antwoordde zij.

--En ik van 's gelijken, sprak Uilenspiegel.

De paus vroeg hem, waarom hij den rug naar het autaar gekeerd had.

--Ik voelde mij onweerdig het te aanschouwen, antwoordde Uilenspiegel
deemoedig.

--Zijt gij pelgrim? vroeg hem de paus.

--Ja, sprak hij, en 'k kom uit Vlaanderen om vergiffenis voor mijne
zonden te vragen.

De paus zegende hem en Uilenspiegel ging henen met de weerdin, die
hem honderd florijnen telde. Met de tassche gevuld, verliet hij Rome
om naar Vlaanderenland terug te keeren.

Maar zeven dukaten moest hij betalen voor het perkament, op hetwelk
zijne vergiffenis geschreven stond.




LIV.

Te dien tijde kwamen twee premonstratenzer broeders te Damme aflaten
verkoopen. Boven hunne monnikspij, droegen zij een schoon fijn hemde,
met kant bezet.

Aan de deur der kerke, bij helder weder, en onder 't portaal als het
regenachtig was, hingen zij hun tarief uit; daarin gaven zij voor zes
duiten, voor een oortje, voor een half pond parisis, voor zeven, voor
twaalf karolusgulden, honderd, tweehonderd, driehonderd, vierhonderd
jaar aflaat, en, al naarvolgens de prijzen, halven aflaat en vollen
aflaat en de vergiffenis voor de afschuwelijkste schelmstukken, ja
zelfs voor het koesteren van begeerten ten opzichte van de Heilige
Maagd. Maar dát kostte zeventien gulden.

Aan de klanten die betaalden, stelden zij kleine stukjes perkament
ter hand, op dewelke het cijfer van de jaren aflaat geschreven was. En
daaronder stond het opschrift:


      Is er iemand die niet en wil zijn
        Gebraeden ofte geroosterd fijn,
      Bij duizend jaer in 't vaegevuer,
    Of in de Helle voor allen duer,
      Hij coope de aflaten maer
      De gratiën en de kwijtscheldingen te gaer
        Voor ietswat geld ende goed:
      God hem dan het loonen moet.


En er kwamen koopers van tien uren in 't ronde.

Een van de goede broeders preekte dikwijls voor het volk; hij had
roode kaken en een driedubbele kin.

--Ongelukkige! sprak hij, een of anderen zijner toehoorders beziende;
ongelukkige! daar zijt gij in de helle! Het vuur verbrandt u
wreedelijk: men legt u te koken in een ketel vol vet, in denwelken
men oliekoekjes voor Astarte bakt; gij zijt niets meer dan eene worst
in Lucifer's panne, een hamelbout in die van Gielgirot, den grooten
duivel, want men snijdt u eerst aan stukken! Zie nu dien grooten
zondaar, die de aflaten versmaadde; zie dien schotel stoverije: hij
is 't, hij is 't, zijn goddeloos lichaam, zijn vermaledijd lichaam
is vaneengekookt tot eene brij. En met welke saus! sulfer, pek en
teer! En al die arme zondaren worden alzoo opgegeten om opnieuw tot
hunne smerte in 't leven te komen. En 't is een gedurig geween en
tandengeknars. Ontferm U onzer, genadige God! Ja, daar ligt gij in de
helle, arme verdoemde, al die smerten te lijden. Zoo men voor u maar
éénen denier gaf, dan zoudt gij bereids verlichting aan de rechterhand
gevoelen; met nog een halven denier bij, waren uwe twee handen uit
het vuur. Maar de rest van uw lichaam? Voor één gulden slechts, zou
de dauw des aflaats op u nedervallen. O, verkwikkende koelte! En in
tien dagen, in honderd dagen, in duizend jaar, al naar gelang dat men
betaalt, geen gebraad, geen oliekoekje, geen stoverije meer! En als
't voor u niet is, zondaar, liggen er soms geen vrienden of magen
van u, geene gade of geen liefje in de gruwelijke diepte des vuurs?

En dit zeggende, stiet de monnik met den elleboog tegen den broeder,
die met een zilveren schotel naast hem stond. En op dat teeken sloeg
de broeder de oogen neer en schudde devotelijk den schotel om het
geld bij te roepen.

... Hebt gij, vervolgde de monnik, hebt gij in het helsche vuur
soms geen zoon, geene dochter, geen kindje, dat gij lief hadt? Zij
schreeuwen, zij weenen, zij roepen U. Zoudt gij doof blijven voor hun
bange klachte? Dat kunt gij niet; uw hert van ijs gaat smelten, maar
dat zal u een karolus kosten. En kijk, bij den klank van dien karolus
op dit verachtelijk metaal ... (de andere monnik schudde nogmaals
zijn schotel) maakt zich eene ruimte in het vuur, en stijgt de arme
ziele tot aan den mond van eenen vuurberg. Daar is zij in de versche,
in de vrije lucht! Waar zijn de smerten des vuurs? De zee is nabij,
de arme ziele werpt er zich in, zij zwemt op den rug, op den buik, op
de golven. Hoor, hoe zij schreeuwt van vreugde, zie, hoe zij duikelt
in 't water! De engelen bezien haar en zijn gelukkig. Zij wachten
heur, maar zij kan uit het water niet weg, zoo goed, zoo koel is het
daar. Zij weet niet, de arme ziele, dat daarboven heerlijke geurige
baden heur wachten, in dewelke groote stukken kandijsuiker drijven,
en die koel zijn als ijs. Daar komt een haai: zij vreest hem niet. Zij
klimt op zijnen rug, maar hij voelt heur niet; zij wil met hem in
't diepste der zee dringen. Zij gaat er de zeenimfen groeten, die
waterzooi eten in koralen ketels en versche oesters in perelmoeren
tellooren. En zij wordt goed ontvangen, onthaald en gevierd; de engelen
roepen heur altijd omhoog. Gansch verkwikt, gelukkig, begint zij te
zingen als een leeuwerik en vliegt zij naar 't hoogste der hemelen,
alwaar God glorierijk op Zijnen troon is gezeten. Zij vindt daar al
heure vrienden en magen terug, behalve diegenen, die de aflaten en
Onze Moeder de Heilige Kerke versmaadden en branden in het diepste
der helle. En dat voor altijd, altijd, altijd, in de eeuwigheid der
eeuwigheden. Maar de andere ziele, zij is bij den Heere; zij verkwikt
zich in welriekende baden en knabbelt kandijsuiker. Koopt aflaten,
mijne broeders: men heeft er tegen alle prijzen, tegen dukaten,
tegen gouden florijnen, Engelsche sovereings! Kopergeld wordt niet
versmaad. Koopt! koopt! alhier is de heilige winkel; armen en rijken
worden gediend, maar krediet geeft men niet, mijne broeders, want
koopen zonder klinkende munt is eene misdaad in de oogen van den Heer."

De broeder, die niet preekte, rammelde met den schotel. Guldens,
dukaten, lammeren, oortjes, stuivers en deniers vielen er in als
hagelsteenen.

Klaas, die nu geld had, betaalde een gulden voor tienduizend jaar
aflaat. De monniken gaven hem daarvoor een stuksken perkament.

Eindelijk ziende, dat er in Damme niemand overbleef dan de
hertevreters, die geen aflaten zouden koopen, trokken de beide broeders
naar Heist.




LV.

Gekleed met zijne pelgrimspij en met eene absolutie in regel op zak,
verliet Uilenspiegel de heilige stede. Hij ging recht voor zich en
kwam te Bamberg, waar de smakelijkste groenten der wereld zijn.

Hij kwam in eene afspanning, waar een vroolijke weerdinne hem vroeg:

--Jonge meester, wilt gij eten voor uw geld?

--Ja, sprak Uilenspiegel. Maar voor hoeveel eet men hier?

De hospita sprak:

--Aan de tafel der heeren eet men voor zes gulden; aan de tafel der
poorters voor vier, en aan de huistafel voor twee.

--Hoe meer, hoe liever! antwoordde Uilenspiegel.

Hij ging dus aan de tafel der heeren zitten. Als hij wel zijne bekomst
en zijn maal met Rijnwijn begoten had, sprak hij tot de weerdin:

--Bazin, ik heb goed gegeten voor mijn geld: geef mij mijne zes gulden.

De weerdinne sprak:

--'t Is om te lachen, zeker! Betaal mij maar gauw!

--Liefste bazinne, antwoordde Uilenspiegel, gij ziet er geen slechte
betaalster uit; integendeel, gij ziet er zoo eerlijk, zoo rechtschapen
uit, dat gij mij nog liever achttien gulden zoudt geven, dan mij de
zes te weigeren die gij mij schuldig zijt. Wat schoone oogen! 't is
de zonne, die mij bestraalt, die mijne liefde hooger doet schieten dan
't hondsgras in een verlaten kluis.

De weerdinne sprak:

--Ik heb geen zaken noch met uwe liefde noch met uw hondsgras, betaal
mij en trek op!

--Optrekken, sprak Uilenspiegel, en u niet meer zien. 'k Zei nog
liever vaarwel aan 't leven. Bazinne, zoete bazinne, ik, arme pelgrim,
pleeg niet voor zes gulden te eten; ik heb mij vol gepropt en straks
laat ik de tong hangen als een hond in de zonne: wil mij betalen, ik
verdiende eerlijk de zes gulden door het lastige werk mijner tanden;
geef ze mij, en 'k zal u streelen, u zoenen, u kussen, met meer vuur
dan wel zeven en twintig minnaars te zamen.

--Zoo spreekt gij voor 't geld, antwoordde zij.

--Moet ik u voor niets opeten? vroeg hij.

--Neen, sprak zij, hem afwerend.

--Ah! zuchtte hij, steeds naderend, uwe huid is als room zoo zacht,
uw haar als gebraden fazant, en uwe lippen als rijpe kersen! Maar
zijn er lekkerder kersen dan gij?

--Ik vind het goed, leelijke stouterik, sprak zij glimlachend, mij op
den koop toe nog zes gulden te vragen! Wees tevreden dat ik u eten gaf,
zonder betaling te eischen.

--Wist gij, sprak Uilenspiegel, hoeveel plaats er nog is!

--Vertrek, sprak de hospita, eer mijn man komt!

--Zie, sprak Uilenspiegel, ik zal een redelijke schuldeischer zijn,
geef mij slechts één gulden voor den dorst, die zal komen.

--Daar, stouterik, sprak zij.

En zij gaf hem een gulden.

--Mag ik nog terugkomen? vroeg Uilenspiegel.

--Wilt gij wel heengaan! sprak zij.

--Wél heengaan, zei Uilenspiegel, dat ware naar u toe gaan, maar 't
is een slecht heengaan, die schoone oogen te moeten verlaten. Als ge
mij wilt houden, zal ik alle dagen maar voor één gulden eten....

--Moet ik een stok nemen?

--Wilt gij den mijnen? antwoordde Uilenspiegel.

Zij lachte, maar hij moest henengaan.




LVI.

Rond dien tijd kwam Lamme Goedzak weder te Damme wonen, mits het land
van Luik niet meer rustig was, ter oorzake van de ketterij. Zijne
vrouw kwam volgeerne mede, omdat de Luikenaars, spotters van nature,
lachten met Lamme's lamlendigheid.

Lamme ging dikwijls bij Klaas, die sedert hij geërfd had, veel in de
taveerne den Blauwen Toren verbleef, alwaar hij eene tafel gekozen had
voor zich zelven en zijne gezellen. Aan de naburige tafel zat een man
profijtelijk zijn kapperken te drinken; 't was Judocus Grijpstuiver,
de gierige deken der vischverkoopers, die niets dan haring at en
meer van zijn geld hield dan van zijner ziele zaligheid. Klaas droeg
in zijn tassche het stuk perkament, op hetwelk zijn aflaat van tien
duizend jaar geschreven stond.

Op een avond dat hij met Lamme Goedzak, Jan van Roosebeke en Mathijs
van Assche in den Blauwen Toren zat, en Judocus Grijpstuiver er ook
was, ging Klaas lustig aan 't drinken; Jan van Roosebeke zegde tot hem:

--'t Is zonde Gods van zoo te drinken!

Klaas antwoordde:

--Voor elk pintje te veel brandt men maar een halven dag. En 'k heb
tienduizend jaar aflaat in mijn tassche. Wie wil er honderd jaar,
om zonder vrees voor de pijnen der hel, den god Bacchus te dienen?

Allen riepen:

--Hoeveel vraagt gij er voor?

--Eene pinte, antwoordde Klaas, maar honderd vijftig jaar geef ik
voor eene portie konijn.

En een ieder kwam bij en betaalde aan Klaas pinten, kuite en
muskens, hesp en konijn, en voor een ieder sneed hij een stuksken
perkament. Doch 't was niet Klaas die alles at en dronk, maar wel
Lamme Goedzak, dewelke at dat hij oogenschijnlijk opzwol, terwijl
Klaas met zijne waar de taveerne rondging.

Grijpstuiver keerde zijn schrokkig gezicht naar hem.

--Kunt gij tien dagen missen? vroeg hij.

--Neen, antwoordde Klaas, dat is moeilijk om passen.

Iedereen lachte, en Grijpstuiver kropte zijne woede op.

Toen trok Klaas naar zijne hut, gevolgd door Lamme, die stapte alsof
hij wollen beenen aan zijn lijf had.




LVII.

Rond het einde van heur derde jaar ballingschap, keerde Katelijne te
Damme terug naar heur huis. En gedurig sprak zij uitzinnig: "Vuur op
het hoofd, de ziele klopt, maakt een gat, zij wil er uit". En altijd
vluchtte zij weg, bij het zien van ossen en schapen. En zij zette
zich neer op de bank onder de linden achter heure hut, en schudde
het hoofd, terwijl zij, zonder ze te herkennen, die van Damme bekeek,
dewelke tot elkander lispten: "Daar is de zottinne".

Doch reizend over velden en wegen, zag Uilenspiegel een ezel, getuigd
met leder en koperen nagelen, en den kop versierd met roodwollen
kwasten en kwispels.

Eenige oude wijven stonden rond den ezel en zeiden, allen te gelijk
sprekend: "Niemand mag hem vastnemen; 't is het afgrijselijke rijbeest
van den grooten toovenaar, den baron von Raiz, die levend verbrand
werd, om acht kinderen aan den duivel geofferd te hebben.--Zoo rap is
hij gevlucht, dat niemand hem krijgen kon; Satan houdt de hand boven
zijnen kop.--Want terwijl hij, vermoeid op den weg, een oogenblik
stilstond om adem te halen, zijn de stadsserjanten gekomen om hem te
pakken, maar hij balkte en sloeg zoo geweldig met zijne achterpooten,
dat zij niet naderen dorsten.--En 't is niet 't gebalk van een ezel,
maar 't gebalk van een duivel.--Men heeft hem dus distelen laten
eten zonder hem voor de vierschaar te dagen of als toovenaar levend
te branden?--Die mannen, die mannen, zij hebben geen greintje moed
in hun lijf".

Niettegenstaande al deze schoone reden, namen allen schreeuwend de
vlucht, zoodra de ezel de ooren spitste of met den steert zijne zijden
sloeg; en tienmaal kwamen zij aldus nader al kakelend en snaterend,
om tienmaal weder de vlucht te nemen.

Maar Uilenspiegel zag haar van verre en sprak lachend tot zich zelven:

--Zie ze parlesanten! Hoe ouder ze zijn, hoe meer ze babbelen: de
jongeren zitten meer met minnarijen in 't hoofd.

Den ezel beziende, ging hij voort:

--Dat betooverde grauwtje staat goed op zijne pooten, dunkt mij;
ik ga het ergens berijden of verkoopen.

Zonder een woord te spreken, kocht hij een maatje haver, hetwelk
hij den ezel vóór zette. Hij sprong vervolgens gezwind op den rug
van het dier, nam den teugel vast, keerde zich naar het Noorden,
het Oosten en het Westen en zegende de oude wijven. Dezen, van schrik
bevangen, vielen op de knieën, en 's avonds vertelden zij aan den hoek
van den heerd, dat een engel verschenen was met een vilten hoed met
fazanteveeren en heur allen gezegend had en dat hij, door bijzondere
gunste van God, weggereden was op den ezel des toovenaars.

En Uilenspiegel ging met zijn ezel te midden van malsche beemden, waar
peerden huppelden, en koeien en veerzen loom in de zonne herkauwden.

En hij heette hem Jef.

De ezel was blijven staan en deed zich deugd aan de distelen. Somwijlen
nochtans, huiverde hij over gansch zijne huid en sloeg hij met den
steert op zijne zijden om de vraatzuchtige horzels te verdrijven die,
evenals hij, wilden eten, doch van zijn vleesch en zijn bloed.

Uilenspiegel, wiens maag naar eten riep, was weemoedig en sprak:

--Gij zoudt wel gelukkig zijn, mijnheer de ezel, zoo gij kondt blijven
smullen zonder dat iemand u stoort en u herinneren komt dat gij
sterfelijk zijt, dat wil zeggen geboren om te lijden en te verduren.

... Evenals gij, vervolgde hij, heeft de man met de Heilige Muil zijne
horzel en dat is mijnheer Luther; en Zijne Genadige Majesteit Karel
heeft ook de zijne, dat is messire Frans de eerste, de koning met
zijn langen neus en zijn nog langeren degen. Ik, arme zwerveling,
mag dus ook mijne horzel wel hebben, mijnheer de ezel. Laas! in
al mijne zakken zijn gaten, en langs de gaten schaveelen dukaten,
guldens en daalders, gelijk een legioen muizen die vluchten voor den
klauw eener kat. Ik weet niet waarom het geld van mij niet houdt,
ik houde nochtans zooveel van het geld. 't Is eene leugen, dat de
Fortuin eene vrouw is, want zij bemint maar de oude gierigaards, die
haar vrekkig sluiten in kisten, in koffers, in zakken, en haar nooit
met het tipje van heur gouden neusje aan 't venster laten komen. Dat
is de horzel die mij bijt en mij knaagt, die mij kittelt zonder mij
te doen lachen. Maar gij luistert niet, mijnheer de ezel, gij denkt
maar aan eten. Ha! buikvuller, uwe lange ooren blijven doof voor den
kreet mijner ledige maag. Aanhoor mij, ik wil het!

En hij zweepte hem. De ezel begon te balken.

--Laat ons gaan, nu gij gezongen hebt, sprak Uilenspiegel.

Maar de ezel verroerde zich niet meer dan een paal en scheen van zins
al die distelen van den weg tot de laatste naar binnen te jagen. En
hij sloeg er geen enkele over.

Dat ziende, steeg Uilenspiegel af; hij sneed een bussel distelen,
stak die onder den bek van den ezel en mende dezen bij den neus tot
op het grondgebied van den landgraaf van Hessen.

--Mijnheer de ezel, sprak Uilenspiegel onderweg, gij loopt achter
mijn bos distelen en versmaadt de lekkere planten waarmede de lange
weg volstaat. Gij zijt lijk de mannen die loopen achter eenen bos
roem, eenen bos gewin, eenen bos liefde, dien de Geluksgodin onder
hunnen neus steekt. Op het einde van den weg zien zij, gelijk gij,
dat de nagejaagde buit weinig weerde heeft, terwijl zij onderweg èn
rust èn werk èn gezondheid lieten.

Aldus met zijn ezel klappend, bereikte Uilenspiegel het kasteel van
den landgraaf.

Twee kapiteins der boogschutters speelden op de trap met dobbelsteenen.

Een hunner, ros van haar en groot van gestalte, bezag Uilenspiegel,
die zediglijk op Jef zat en hen aankeek.

--Wat wilt gij, met uwe hongerige en reizende tronie? sprak hij.

--'k Heb inderdaad honger, antwoordde Uilenspiegel, en reize geenszins
voor mijn vermaak.

--Zoo gij honger hebt, sprak de kapitein, kunt gij met den hals de
koorde opeten, die zwiert aan de eerste galge die gij ontmoet.

--Heer kapitein, antwoordde Uilenspiegel, als gij mij de schoone gouden
koorde geeft die rond uwen hoed ligt, zal ik mij met de tanden gaan
ophangen aan die vette hesp, die ginder bij dien spekslachter zwiert.

--Van waar komt gij? vroeg de kapitein.

--Uit Vlaanderen, was 't antwoord van Uilenspiegel.

--Wat wilt gij?

--Aan Zijne Landgrafelijke Hoogheid eene schilderij van mijne hand
toonen.

--Kom binnen, als gij een schilder en van Vlaanderen zijt, sprak de
kapitein, ik zal u bij mijnen meester brengen.

Toen Uilenspiegel bij den landgraaf was, groette hij hem drie reizen
en nog meer.

--Uwe Hoogheid, sprak hij, verweerdige mij aan zijne edele voeten eene
schilderij neder te leggen, die ik voor hem maakte, en op dewelke
ik het konterfeitsel verbeeldde van de Allerheiligste Maagd Maria,
in haren vorstelijken dos.

... Die schilderij zal misschien de eer hebben Uwe Hoogheid te
bevallen, vervolgde hij, in welk geval ik mij vermete te hopen het
ambt te verkrijgen van schilder Uwer Grootmoedigheid.

De landgraaf bezag het doek, dat goed gemaald was, en sprak:

--Gij zult onze schilder zijn; neem plaats in dien zetel.

En Uilenspiegel kuste hem op beide wangen en nam plaats in den zetel.

--Gij ziet er niet rijk uit, sprak de landgraaf.

Uilenspiegel antwoordde:

--Inderdaad sire; Jef, mijn ezel kon distelen eten, doch drie dagen
reeds leef ik van ellende en eet ik rook van hope.

--Straks krijgt gij beters, sprak de landgraaf lachend, maar waar is
uw ezel?

Uilenspiegel antwoordde:

--Ik liet hem op de Groote Markt, rechtover 't kasteel Uwer Genade;
ik ware gelukkig zoo Jef dezen nacht op stal was.

De edele landgraaf gebood dadelijk aan een zijner schildknapen den
ezel van Uilenspiegel als zijn eigen beest te behandelen.

Weldra kwam het uur des avondmaals, dat een recht festijn was. En de
spijzen rookten op tafel, en de wijn liep als een stroom door de kelen.

Uilenspiegel en de landgraaf werden zoo rood als hanen. Uilenspiegel
was vol vreugd, maar de landgraaf bleef nadenkend.

--Schilder, sprak hij eensklaps, gij zult mijn portret moeten maken,
want 't is een groote voldoening voor een sterfelijken vorst, aan
zijne nazaten de geheugenis zijner trekken te laten.

--Sire, antwoordde Uilenspiegel, uw wensch is mijn wil, maar 't
schijnt mij, nietsweerdige, dat uwe Edelheid in de toekomende eeuwen
niet veel genoegen zal smaken, zoo alleene op het doek te staan. Hij
moet vergezelschapt wezen door zijne adellijke gemalinne, mevrouw de
Landgravin, door zijne edelvrouwen en heeren, door zijne dapperste
kapiteins, te midden waarvan zijne Hoogheid en Mevrouwe schitteren
zullen als twee zonnen te midden van lanteernen.

--Inderdaad, antwoordde de landgraaf, en wat moet ik u betalen voor
dat groot kunstwerk?

--Honderd gulden op voorhand of anderszins, antwoordde Uilenspiegel.

--Hier zijn ze vooraf, sprak de edele landgraaf.

--Allergenadigste heer, hernam Uilenspiegel, gij giet olie in mijne
lamp, ze zal branden te uwer eere.

's Anderen daags vroeg hij aan den landgraaf de hovelingen vóór
hem te doen komen, welke de eer hadden hem op het doek te mogen
vergezelschappen.

Toen kwam de hertog van Luneburg, hoofdman der landsknechten in dienst
van den landgraaf. 't Was een dikke vent, die verging in zijn vet. Hij
naderde Uilenspiegel en fluisterde hem deze woorden in 't oor:

--Als gij mij op de schilderij de helft van mijnen buik niet afneemt,
laat ik u opknoopen door mijne soldaten.

En de hertog ging voort.

Toen kwam een lange dame, die een bochel op den rug had, terwijl haar
borst plat was als het zwaard der wrekende gerechtigheid.

--Heer schilder, sprak zij, als gij mij langs voren geen twee bochels
geeft, in stee van éénen langs achteren, doe ik u als giftmenger
vierendeelen.

En de hofdame ging voort.

Vervolgens kwam een jonge eerejuffer die blond, frisch en lieftallig
was, doch drie tanden miste in de bovenste rij.

--Heer schilder, sprak zij, als ge mij lachen doet en niet al mijne
tanden laat zien, doe ik u in stukskens kappen door mijn minnaar,
die daar staat.

En zij wees naar den kapitein van de boogschutters die den dag te
voren op de trappen van het paleis met de dobbelsteenen speelde;
daarop ging zij voort.

En allen gingen aldus hem voorbij; ten slotte bleef Uilenspiegel
alleen met den edelen landgraaf.

--Als gij het ongeluk hebt, sprak de edele landgraaf, alle die lieden
niet trouwelijk uit te schilderen, laat ik u het hoofd afkappen.

--Zonder hoofd, dacht Uilenspiegel, gevierendeeld, in stukskens
gekapt of voor het minste gehangen, zal het veel voorzichtiger zijn,
niemand te schilderen. Ik zal er over nadenken.

--Waar is de zaal op welker muren ik al die doorluchtige lieden moet
malen? vroeg Uilenspiegel aan den landgraaf.

--Volg mij, sprak de landgraaf.

En hij bracht hem naar een ruime kamer met groote witte muren.

--Hier is zij, sprak hij.

--Het ware goed, zei Uilenspiegel, dat men vóór die muren groote
gordijnen hing, om mijn schilderwerk te behoeden voor stof en voor
de beleediging der vliegen.

--Dat zal geschieden, sprak de edele landgraaf.

Toen de gordijnen hingen, vroeg Uilenspiegel drie leerjongens, om
zijne verven te malen, naar hij zeide.

Dertig dagen lang gastreerden Uilenspiegel en de leerjongens en lieten
zij zich de fijne vleezen en de oude wijnen goed smaken. De landgraaf
zorgde voor alles.

Doch den een en dertigsten dag stak hij zijn neus in de kamer, alwaar
Uilenspiegel gezegd had, dat niemand mocht binnenkomen.

--Hewel, Thijl, sprak hij, waar zijn de portretten?

--Ze zijn verre, antwoordde Uilenspiegel.

--Mag ik ze zien?

--Nog niet.

Den zes en dertigsten kwam hij weer met zijn neus voor de deur.

--Hewel, Thijl? vroeg hij.

--Edele landgraaf, zij gaan op hun laatste.

Den zestigsten dag maakte de landgraaf zich kwaad en, de kamer
binnentredend, sprak hij:

--Op staanden voet gaat gij mij het schilderwerk toonen.

--Ja, geduchte heer, sprak Uilenspiegel, maar gelief het gordijn niet
te openen, alvorens de kapiteins en de edelvrouwen van uw hof hier
binnen te roepen.

--Dat zij komen, sprak de edele landgraaf.

Op dit bevel traden allen binnen.

Uilenspiegel stond voor het dichtgesloten gordijn.

--Doorluchtige Landgraaf, sprak hij, en gij, mevrouwe de Landgravinne,
en gij, hertog van Luneburg, en gij allen, schoone damen en
dappere kapiteins, achter dit gordijn heb ik, op mijn beste, uw
lieve of krijgshaftige gezichten geschilderd. Een iegelijk zal zich
dadelijk herkennen. Gij zijt nieuwsgierig uw konterfeitsel te zien;
't is redelijk, doch verweerdigt u geduld te nemen en laat mij nog
een woord of vijf zeggen. Gij, schoone damen en dappere kapiteins,
die allen van edelen bloede zijt, kunt mijn schilderwerk zien en
bewonderen, maar mocht onder u zich iemand bevinden van onadellijk
bloed, niets zou hij zien dan een witten muur. En nu, verweerdigt U
uwe doorluchtige oogen te openen.

Uilenspiegel schoof het gordijn weg.

--Alleen de edelen kunnen iets zien; lieden van gemeene afkomst
blijven blind voor dit kunststuk.

Al de hovelingen sperden de oogen open, gebaarden in bewondering
te staan, zich zelven en anderen wederzijds te herkennen, doch in
werkelijkheid zagen zij niets dan een naakten muur, hetwelk hen
gansch onthutste.

Doch de nar die aanwezig was, sprong drie voet hoog, en, zijn
narrenstok zwaaiend, sprak hij:

--Men mag mij uitmaken voor boer, en daarenboven voor schurk, voor
deugniet, maar 'k zal het roepen en schreeuwen van de daken, dat ik
daar een witte muur, een naakten muur, een blooten muur voor mijnen
neus heb! Zoo helpe mij God en alle zijne santen.

Uilenspiegel sprak:

--Als de zotten spreken, is 't tijd dat de wijzen optrekken.

Hij wilde het paleis verlaten, als de landgraaf hem tegenhield.

--Snaak, sprak hij, die overal gaat en komt om het schoone en goede
te prijzen en luidkeels te spotten met de dwaasheid; gij, die in
tegenwoordigheid van zooveel grooten der aarde, als man uit het volk,
zoo onbermhertig dorst spotten met hunne blazoenen en voorrechten,
gij zult eens gehangen worden om uw stoute tong.

--Als de koord van goud is, antwoordde Uilenspiegel, zal zij breken
van schrik als ze mij ziet komen.

--Daar, sprak de landgraaf, hem vijftien gulden in de hand stoppend,
zie hier een stukje van de koorde!

--Hertelijk dank, genadige heer, antwoordde Uilenspiegel, elke
afspanning van den weg krijgt er een vezel van, een gouden vezel,
die al die dieven van weerden tot rijkaards maakt.

En hij sprong op den ezel en reed weg, met zijn hoedeken fier naar
omhoog.




LVIII.

De bladeren verdorden op de boomen en de Octoberwind begon te
waaien. Soms was Katelijne gedurende eenige uren bij heur verstand. En
Klaas zei dan dat de geest Gods heur in zijne zoete ontferming kwam
bezoeken. In die oogenblikken had zij de macht, door woorden en
gebaren, Nele te betooveren en dan zag het meisje, meer dan honderd
uren verder, alles wat omging op pleinen, in straten of in huizen.

Op een dag dat Katelijne bij heure zinnen was en oliekoeken at, wel
begoten met dobbele kuite, in gezelschap van Klaas, van Soetkin en
Nele, sprak Klaas:

--'t Is heden de troonafstand van Zijne Heilige Majesteit keizer
Karel. Zeg, Nele, liefste, zoudt gij tot Brussel, in Brabant,
kunnen zien?

--Ja, zoo Katelijne wil, antwoordde Nele.

Katelijne deed het meisje op eene bank zitten en betooverde heur door
woorden en teekenen, en Nele viel zachtjes in slaap.

Katelijne zegde heur:

--Ga in het kleine huis omtrent de Warande, het geliefkoosd verblijf
van keizer Karel.

--Ik ben, sprak Nele stille, in een kleine kamer, groen
geschilderd. Daar zit een man van vier en vijftig jaar, grijs en kaal,
met blonden baard op een vooruitstekende kin, met onheilspellenden
blik in zijne sluwe, wreede en listige oogen. Dien man heet men
Heilige Majesteit. Hij is aamborstig en hoest. Naast hem zit nog
een man, jonger, met een afschuwelijk gelaat gelijk een aap met een
waterhoofd. Ik zag hem te Antwerpen, 't is koning Philippus. Zijne
Heilige Majesteit verwijt hem, dat hij zeker weer bij eene of andere
slet in eene kroeg van de benedenstad uitgeslapen heeft. Hij zegt hem
dat zijn haar naar de taveerne riekt, en dit geen vermaak is voor een
koning die te kiezen heeft tusschen de aanbiddelijkste vrouwen met
satijnen huid, die uit geurige baden komen, wat beter is, zegt hij,
dan een vuile smots die met moeite uit de armen komt van een dronken
soldaat. Geene vrouw, onder de schoonsten en edelsten, 't zij maagd,
gehuwd of weduw, zegt hij hem, zou hem willen wederstaan; trotsch
zouden zij heure minnarijen verlichten met den gloed van wierookvaten,
in stee van het walmende licht eener stinkende vetkeers.

De koning antwoordt Zijne Heilige Majesteit, dat hij hem in alles
gehoorzaam zal wezen. Ik zie dat Zijne Heilige Majesteit een hoestbui
krijgt en eenige slokken kruidenwijn drinkt.

Hij zegt tot Philippus: Aanstonds zullen voor Ons verschijnen de
Staten-Generaal, prelaten, edelen en poorters: Oranje de Zwijger,
Egmond de IJdele, Hoorn de Onbeminde, Brederode de Leeuw en
allen die van het Gulden Vlies, van hetwelk ik u grootmeester zal
maken. Honderden liefhebbers voor dat speelgoed zult gij zien die
zich den neus zouden laten afsnijden, zoo zij het op den borst aan
een gouden ketting mochten dragen, tot teeken van hoogen adel.

Op jammerenden toon vervolgt Zijne Heilige Majesteit tot koning
Philippus: Gij weet mijn zoon, dat ik te uwen voordeele afstand doe,
aan de wereld een grootsch schouwspel ga geven, en voor eene groote
menigte spreken zal, hikkend en hoestend,--want wederom heb ik te
veel gegeten, mijn zoon,--en gij zoudt een steenen hert moeten hebben,
zoo gij, na mij aanhoord te hebben, niet eenige tranen wildet storten.

--Ik zal weenen, vader, antwoord koning Philippus.

Vervolgens spreekt Zijne Heilige Majesteit tot zijn dienstknecht
Dubois.

--Dubois, zegt hij, geef mij een stukje suiker met Madeira: ik heb den
hik. Als mij dat maar niet overkomt terwijl ik het woord voer. Zal
die gans van gisteren dan nooit zakken? Als ik een beker wijn van
Orléans dronk? Neen, die is te hard. Als ik eenige ansjovisjes at? Ze
zijn zoo vettig. Dubois, geef mij een glas Romagne-wijn.

Dubois geeft aan Zijne Heilige Majesteit wat hij vraagt; vervolgens
doet men hem een karmozijnpannen kleed en een gouden mantel aan;
men gordt een zweerd om zijne lenden; in zijne handen steekt men den
schepter en den wereldbol, op zijn hoofd zet men de krone.

Zijne Heilige Majesteit treedt uit het huis der Waranda, gezeten op een
muilezel en gevolgd door koning Philippus en hooge personages. Zij gaan
naar een groot gebouw, dat zij het Paleis heeten, en vinden daar in een
kamer een rijkgekleeden, grooten mageren man, dien zij Oranje noemen.

Zijne heilige Majesteit spreekt dien man aan en zegt:

--Zie ik er goed uit, neef Willem?

--Maar de man geeft geen antwoord.

Daarop zegt Zijne Heilige Majesteit--half lachend, half grammoedig:

--Neef, zult gij dan altijd zwijgen, zelfs om aan een oude pruik de
waarheid te zeggen? Moet ik nog regeeren of moet ik afstand doen,
Zwijger?

--Heilige Majesteit, antwoordt de magere man, als de winter daar is,
laten de sterkste eiken hunne bladeren vallen.

Drie uren slaat de klok.

--Zwijger, zegt hij, leen mij uwen schouder, dat ik er op leune.

En Zijne Majesteit gaat met hem en zijn gevolg een groote zaal binnen,
zet zich neder onder een verhemelte, behangen met karmozijnzijde. Daar
zijn drie stoelen. Zijne Heilige Majesteit neemt den middelste,
die schooner en hooger is dan de andere en waarop een keizerlijke
kroon prijkt; koning Philippus neemt den tweede, en de derde is voor
eene vrouwe, ongetwijfeld eene koningin. Rechts en links zitten,
op gestoffeerde banken, mannen in 't rood gekleed, die om den hals
een gulden schaap dragen. Achter hen staan meerdere personages, die
zeker heeren en prinsen zijn. Rechtover Zijne Heilige Majesteit,
een paar treden lager, zitten in laken gekleede mannen op houten
banken. Ik hoor hen zeggen dat zij zoo zediglijk gekleed en gezeten
zijn, omdat zij alleen alle lasten betalen. Iedereen is rechtgestaan
als Zijne Heilige Majesteit binnenkwam, doch weldra zette hij zich
neer en deed hij iedereen teeken hetzelfde te doen.

Langen tijd spreekt hij over het jicht, daarna overhandigt de vrouw,
die eene koningin schijnt te wezen, Zijne Heilige Majesteit eene rol
perkament, waarop dingen geschreven staan die Zijne Heilige Majesteit
hoestend en met zwakke stemme afleest:

--Ik heb menigvuldige reizen gedaan in Spanje, in Italië, in de
Nederlanden, in Engeland en in Afrika, dit alles voor de glorie Gods,
den roem mijner wapenen en het welzijn mijner volkeren.

Ten slotte zegt hij dat hij zwak en vermoeid is, en dat hij de kroon
van Spanje, de graafschappen, hertogdommen, heerlijkheden van deze
landen wil leggen in de handen van zijnen zoon Philippus.

Hij weent en allen weenen mede.

Nu staat koning Philippus recht en, op de knieën vallend, roept
hij uit:

--Heilige Majesteit, is het mij toegelaten die krone uit uwe handen
te ontvangen, terwijl gij nog zoo bekwaam zijt die met eere te dragen?

Zijne Heilige Majesteit fluistert hem toe een welwillende aanspraak
te houden tot de mannen, die op de gestoffeerde banken zitten.

Koning Philippus keert zich naar hen en zegt op gemelijken toon,
zonder recht te staan:

--Ik ken tamelijk goed Fransch, doch niet genoeg om het woord tot
ulieden te richten. Gij zult hooren wat de bisschop van Atrecht,
mijnheer Granvelle, u mijnentwege zal zeggen.

--Slecht geproken, mijn zoon, lispt Zijne Heilige Majesteit.

En inderdaad, de vergadering mompelt, als zij den jongen koning zoo
fier en zoo trotsch ziet. De vrouwe, die de koningin is, spreekt mede
zijnen lof; nu komt de beurt aan een ouden doctor en als deze gesproken
heeft, geeft Zijne Heilige Majesteit een teeken van dankzegging. Als
die aanspraken en plechtigheden gedaan zijn, verklaart Zijne Heilige
Majesteit zijne onderzaten ontslagen van hunnen eed van getrouwheid;
hij teekent de akten, stapt van zijnen troon en doet er Philippus op
plaats nemen. En iedereen weent. Vervolgens trekken zij terug naar
het huis der Warande.

Daar zijn zij weder getweeën in de groene kamer; zijne Heilige
Majesteit schaterlacht en zegt tot koning Philippus, die niet lacht:

--Hebt gij gezien hoe gauw men met spreken, hikken en lachen die
menschen verteedert? Wat tranenvloed! En die dikke Maes die, op 't
einde zijner aanspraak, begon te weenen gelijk een kind. Gij zelf
scheent ontroerd, doch niet genoegzaam. Dat zijn de vertooningen die
't volk moet hebben. Wij mannen, hebben die minnaressen 't liefst,
die ons 't duurst kosten. En zoo ook is het volk. Hoe meer wij
ze doen betalen, hoe liever ze ons zien. In Duitschland duldde ik
den hervormden eeredienst, dien ik in de Nederlanden strengelijk
strafte. Als de prinsen van Duitschland katholiek geweest waren, dan
ware ik Lutheraan geworden om hunne goederen verbeurd te verklaren. Zij
denken dat mijn ijver voor 't Roomsch geloove oprecht is, en 't spijt
hun dat ik hen verlaat. Door mijn toedoen zijn, in de Nederlanden,
uit hoofde van ketterije, vijftig duizend hunner dapperste mannen en
bevalligste meidekens om hals gebracht. Zonder de verbeurdverklaringen
te rekenen, deed ik hun meer schattingen en beden betalen dan Indië
en Peru samen: zij zijn droef mij te verliezen. Ik heb den vrede van
Cadzand gescheurd, Gent, de fiere stad, getemd, uit den weg geruimd wat
mij hinderen kon; vrijheden, keuren en privileges, alles is onderworpen
aan 't gezag van de keizerlijke ambtenaren. Die goede menschen wanen
zich vrij, omdat ik hun toelaat boogschietingen te houden en hunne
gildevaandels plechtiglijk door de straten te dragen. Zij voelen mijn
meesterschap; in eene kevie gestoken, bevinden zij er zich goed: zij
zingen en betreuren mij. Mijn zoon, wees met hen, lijk ik het was:
zoet van woorden, ruw van daden; geef likjes zoolang gij niet bijten
moet. Zweer, zweer altijd op hunne vrijheden, keuren en privileges,
doch vernietig ze, zoodra ze u een gevaar kunnen worden. IJzer zijn
zij, als men ze met schuchtere handen aanraakt, glas als men ze met
een sterken arm breekt. Bestrijd de ketterije, niet om haar verschil
met den Roomschen godsdienst, maar omdat zij, in de Nederlanden,
eindigen zou met ons gezag te vernielen; zij die den Paus met zijne
drie kronen aanvallen, zouden gauw gedaan krijgen met vorsten die er
maar ééne dragen. Maak als ik van de vrijheid van geweten eene daad
van majesteitsschennis, met verbeurte van goederen, en gij zult erven,
gelijk ik heel mijn leven geërfd heb; en als gij hen zult verlaten
om afstand te doen of te sterven, zullen zij zeggen: Heil! de goede
vorst! En zij zullen weenen!

--En ik hoore niets meer, vervolgde Nele; Zijne Heilige Majesteit is
op een praalbed gaan liggen en slaapt, en koning Philippus, trotsch
en vermetel, staart hem koel en liefdeloos aan.

Op die woorden werd Nele gewekt door Katelijne.

En Klaas bleef, in gedachten verslonden, kijken naar de vlam die in
den heerd flikkerde.




LIX.

Uilenspiegel verliet den landgraaf van Hessen en besteeg zijn
ezel. Toen hij over de Groote Markt reed, zag hij verbolgen gezichten
van eenige heeren en damen, maar dat deerde hem niet.

Weldra kwam hij op het grondgebied van den hertog van Luneburg en
ontmoette daar een troep Smadelijke Broeders, lustige Vlamingen van
Sluis, die alle Zaterdagen geld uitlegden om eens per jaar eene reize
in Duitschland te doen.

Zij zaten in een open wagen, bespannen met een kloek peerd uit het
Veurne--Ambacht, en zoo reden zij zingend en juichend door de wegen
en sompen van het hertogdom Luneburg. Er waren er die op de pijp,
de schalmeie, den vedel, den doedelzak speelden, en dat alles maakte
groot lawaai. Naast den wagen liep veeltijds een dikzak die op een
rommelpot speelde, in de hope wat te vermageren.

Zij waren aan hun laatsten gulden; als zij Uilenspiegel
zagen komen, riepen zij hem eene afspanning binnen om hem te
trakteeren. Uilenspiegel nam gereedelijk aan. Daar hij zag dat de
Smadelijke Broeders tot elkaar knipoogden en heimelijk lachten,
terwijl zij hem inschonken, begreep hij dat men hem eene poets wilde
bakken. Hij ging buiten, doch bleef aan de deur luisteren. Hij hoorde
den dikzak zeggen:

--'t Is de schilder van den landgraaf, die hem meer dan duizend gulden
gaf om zijn portret te maken. Onthalen wij hem op bier en op wijn,
en hij zal dobbel en dik tegenbetalen.

--Amen, zegden de anderen.

Uilenspiegel zadelde zijn ezel, bracht hem duizend passen verder,
bij een pachter en gaf twee oortjes aan de meid om op het dier te
letten. Vervolgens keerde hij terug naar de taveerne en zette zich neer
bij de Smadelijke Broeders, zonder van iets te gebaren. Ze schonken
hem in en betaalden 't gelag. Uilenspiegel liet de guldens van den
landgraaf in zijne tassche rinkelen en zei, dat hij zoo even aan
eenen boer zijnen ezel verkocht had voor zeventien zilveren daalders.

De dikzak die op den rommelpot speelde, ging bij den baas en sprak,
naar Uilenspiegel wijzend:

--'t Is de schilder van den landgraaf, hij zal alles betalen.

Als de baas guldens en daalders in Uilenspiegel's tassche hoorde
rammelen, bracht hij eten en drinken op tafel. Uilenspiegel
liet het zich goed smaken. En altijd rinkelde het geld in zijne
beurze. Menigwerf had hij ook op zijnen hoed geslagen en gezegd dat
daar zijn grootste schat stak. Als de smulpartij twee dagen en eenen
nacht geduurd had, zeiden de Smadelijke Broeders tot Uilenspiegel:

--Laat ons opkramen en 't gelag betalen.

Uilenspiegel antwoordde:

--Als een rat in een kaas zit, vraagt zij om ergens elders te gaan?

--Neen, spraken zij.

--En als een mensch goed eten en drinken heeft, vraagt hij naar het
stof van de wegen of naar 't water van de grachten die vol echelen
steken?

--Neen, spraken zij.

--Laat ons dus hier blijven, vervolgde Uilenspiegel, zoolang mijne
guldens en daalders ons dienen tot trechters om de goddelijke dranken
van den baas in onze kelen te gieten.

En hij zei tot den baas van nog wijn en nog worsten te brengen.

Terwijl zij aten en dronken, sprak Uilenspiegel:

--Ik betaal alles, nu ben ik eens de landgraaf. Als mijne beurze
ledig was, wat zoudt gij doen, kameraden? Als dat ongeluk overkomt,
neemt dan mijn vilten hoedeken: het steekt vol gouden karolussen.

--Laat ons eens tasten, spraken allen te gader.

En zuchtend, voelden zij tusschen hunne vingeren groote geldstukken
die gouden karolussen moesten zijn. Doch een hunner bleef den hoed
met zooveel vriendschap vasthouden, dat Uilenspiegel hem den hoed
moest afnemen, zeggende:

--Ongeduldige koeier, wacht ten minste tot het uur van melken daar is.

--Geef mij de helft van uw hoedeken, sprak de Smadelijke Broeder.

--Neen, sprak Uilenspiegel, want schadelijk ware het voor uwe hersenen
half in de zonne en half in de schaduw te loopen.

En, zijn hoofddeksel aan de baas gevend, sprak hij:

--Houd hem goed vast, het is wat te warm. Ik ga mij wat lichter maken.

Hij ging buiten en de baas hield het hoedeken vast.

Maar Uilenspiegel liep naar den boer, steeg op zijn ezel en sloeg
den weg in naar Emden.

Als de Smadelijke Broeders, hem niet zagen terugkomen, zeiden zij
tot elkander:

--Zou hij weg zijn? Wie zal dan 't gelag betalen?

De baas kreeg argwaan en sneed Uilenspiegels hoed middendoor.

Maar in stee van karolussen, vond hij tusschen het vilt en de voering
niets dan kwade koperen penningen.

Toen voer hij heftig uit tegen de Smadelijke Broeders.

--Diefelijke broeders, gij gaat niet uit mijn huis, vóór dat gij mij
al uwe kleederen gelaten hebt, behalve uwe hemde, sprak hij.

En zij moesten zich uitkleeden om hun gelag te betalen. In hun hemde
reden zij aldus over velden en wegen, want zij hadden hun peerd noch
hun wagen willen verkoopen.

En een iegelijk onderweg had medelijden met hen en gaf hun geerne wat
brood, wat bier en soms ook een stuk vleesch; want overal zegden zij
dat zij door dieven uitgeschud waren.

En zij hadden in 't gelijk maar ééne hooze.

Zoo kwamen zij naar Sluis terug, in hun hemde op de wagen dansend en
op den rommelpot spelend.




LX.

Intusschen reed Uilenspiegel op zijn ezel door de landen en sompen
van den hertog van Lunenburg, het Watersignoorken, zooals de Vlamingen
hem heetten.

Jef gehoorzaamde Uilenspiegel als een hondje, dronk bruinbier, danste
beter dan een Hongaarsche dansmeester en legde zich, bij het minste
teeken, op den rug met de vier pooten omhoog.

Uilenspiegel wist dat de hertog van Lunenburg--verbolgen omdat hij,
te Darmstadt, in tegenwoordigheid van den landgraaf van Hessen, met
hem den spot had gedreven--hem op straffe van den strop den toegang
tot zijn grondgebied ontzegd had.

Plotseling zag Uilenspiegel Zijne Hertogelijke Hoogheid in persoon
aankomen en mits hij zijn geweldig karakter kende, werd hij bang. Hij
sprak tot zijn ezel:

--Jef, jongen, daar komt de hertog van Lunenburg. Aan den hals voel
ik een groote krieuweling; nu, Jef, ik zou niet geerne gehangen
worden. Gedenk dat wij broeders in ellende en in lange ooren zijn;
gedenk ook welk een goeden vriend gij aan mij zoudt verliezen.

En Uilenspiegel wischte zich de oogen en Jef begon te balken.

--Wij leven samen gelukkig, vervolgde Uilenspiegel, of rampspoedig,
naarvolgens de omstandigheden; gedenk dat, Jef!--De ezel balkte
voort, want hij had honger.--En nooit zult ge mij vergeten, sprak
zijn meester, want welke liefde is sterker dan die, welke dezelfde
vreugde beleeft en denzelfden rampspoed beweent? Jef, jongen, gij
moet u op den rug leggen.

De zachtaardige ezel deed wat zijn meester begeerde en de hertog zag
hem met de vier pikkels omhoog liggen. Uilenspiegel zette zich neer
op den buik van den ezel.

--Wat doet gij daar? sprak de hertog. Weet gij dan niet dat ik, bij
mijn laatste plakkaat, u verboden heb uwe stoffige voeten in mijne
gewesten te zetten?

Uilenspiegel antwoordde:

--Genadige heer, heb erbarming met mij.

En naar zijn ezel wijzend:

--Gij weet wel, heer, dat hij, die tusschen zijne vier palen woont,
bij wet en recht immmer vrij is.

De hertog antwoordde:

--Verlaat mijne gewesten of gij zult sterven!

--Genadige heer, antwoordde Uilenspiegel, met een paar gulden zou ik
er rapper buitenrollen.

--Nietdeug, sprak de hertog, het is u niet genoeg ongehoorzaam te zijn,
ge vraagt er mij nog geld bij!

--Ik moet het wel vragen, heer, mits ik het niet nemen kan.

De hertog gaf hem een gulden.

Toen sprak Uilenspiegel tot zijn ezel:

--Jef, sta op en groet Zijne Hoogheid.

De ezel stond op en begon te balken. Toen gingen beiden hun weg.




LXI.

Soetkin en Nele zaten aan een der vensteren van de hut en keken naar
de straat. En Soetkin sprak tot Nele:

--Liefste, ziet gij mijn zoon Uilenspiegel niet komen?

--Neen, sprak Nele, dien leelijken landlooper zien wij nooit meer
terug.

Nele, antwoordde Soetkin, gij moogt niet kwaad zijn, maar gij moet
hem beklagen, omdat hij niet bij ons is, de arme jongen!

--Ik weet het, sprak Nele, maar hij heeft elders een huis, verre van
hier, een huis, rijker dan 't zijne, waar hij zeker door een schoone
dame getroeteld wordt.

--'t Ware gelukkig voor hem, zei Soetkin; daar eet hij misschien
ortolanen.

--Dat men hem keien te eten gaf, zuchtte Nele, gauw zou hij hier zijn
de slokker.

Soetkin lachte en zei:

--Van waar, liefste, die boosheid?

Maar Klaas, die stil in zijn hoekje mutsaards bond, antwoordde:

--Ziet gij dan niet dat Nele verliefd is?

--Wel, sprak Soetkin, wat doortrapte meid, die mij daar nooit een
woord over sprak. Is 't waar, liefste, hebt gij er zin in?

--Geloof er niets van, sprak Nele.

--Gij zult, zei Klaas, een goeden man aan hem hebben, met een grooten
mond, een hollen buik en een lange tonge, die van de guldens duiten
zal maken en nooit een oortje van zijnen arbeid, een straatlooper en
een nietdeug.

Doch, blozend en kwaad, antwoordde Nele:

--Waarom hebt gij hem niet anders gemaakt?

--Daar weent ze nu, sprak Soetkin, zwijg toch, man.




LXII.

Als Uilenspiegel te Neurenberg kwam, gaf hij zich uit voor grootmeester
in de medicijnen, overwinnaar van alle kwalen, wereldberoemd
lichaamzuiveraar, die pest, koorts en alle ziekten verdreef.

In het gasthuis van die stad lagen zooveel zieken dat men ten einde
raad was. De overste had de komst van Uilenspiegel vernomen; hij ging
hem bezoeken en vroeg of hij werkelijk allerlei ziekten genezen kon?

--Uitgenomen de laatste, antwoordde Uilenspiegel; maar beloof mij
tweehonderd gulden voor genezing der overigen; doch ik wil geen duit,
als al uwe zieken niet zeggen, dat zij genezen zijn en het gasthuis
kunnen verlaten.

's Anderen daags trad hij, met doctorale waardigheid de ziekenzaal
binnen. Hij ging overal rond, bezocht elken zieke afzonderlijk en zei:

--Zweer mij dat gij aan niemand zult zeggen wat ik u in het oor ga
vertellen. Welke ziekte hebt gij?

De kranke zei het hem, en zwoer bij hoog en leeg te zullen zwijgen.

--Weet, sprak Uilenspiegel, dat ik morgen een uwer tot asch moet
verbranden, om daarmede een wonderbaar geneesmiddel te bereiden, dat
alle zieken zullen te drinken krijgen. Hij, die niet gaan kan, wordt
tot pulver verbrand. Morgen kom ik terug met de overste, en ik zal
roepen: "Dat al degenen die niet ziek zijn, hun pak maken en heengaan."

Den volgenden morgen kwam Uilenspiegel en riep gelijk hij gezegd
had. Al de zieken, kreupelen, jichtlijders, koortslijders, wilden om
't zeerste buiten. En zelfs zij die in geen tien jaar uit hun bedde
waren gekomen, liepen de straat op.

De overste vroeg of zij genezen waren en of zij gaan konden.

--Ja, antwoordden zij, in 't gedacht dat er één op de binnenplaats
tot assche verbrand werd.

Toen sprak Uilenspiegel tot den overste:

--Betaal mij; gij ziet, allen zijn buiten en verklaren dat zij
genezen zijn.

De overste betaalde hem tweehonderd gulden, en Uilenspiegel spoedde
zich buiten de stad.

Maar twee dagen nadien zag de overste alle zijne zieken zieker
terugkomen, behalve één dien de frissche lucht genezen had, en die nu
dronken door de straten liep, al zingende: "Hoezee voor den grooten
dokter Uilenspiegel!"




LXIII.

Als de tweehonderd gulden verteerd waren, kwam Uilenspiegel te Weenen,
alwaar hij zich verhuurde bij eenen wagenmaker, die zijne gasten
gedurig beknorde, omdat zij den blaasbalg van de smidse niet vlug
genoeg trokken.

--Op maat schreeuwde hij, en volgt met den blaasbalg.

Eens dat de baas naar zijnen hof ging, maakte Uilenspiegel den
blaasbalg los, schouderde hem en volgde aldus zijnen meester. Als
deze verwonderd opkeek, sprak Uilenspiegel.

--Baas, gij hebt mij geheeten met den blaasbalg te volgen, waar moet
ik hem leggen, terwijl ik de anderen haal?

--Jongen, antwoordde de baas, dat heb ik u niet gezegd, breng den
blaasbalg op zijne plaats terug.

Maar de baas wilde hem die poets betaald zetten. Hij stond, van
dien dag af, te middernacht op, maakte zijne gasten wakker en deed
hen werken.

De werklieden spraken:

--Baas, waarom wekt gij ons te midden van den nacht?

--Ik heb de gewoonte, antwoordde de baas, mijne gasten de eerste
zeven dagen maar een halven nacht te laten slapen.

Den volgende nacht, wekte hij weer zijne gasten te
middernacht. Uilenspiegel, die op den zolder sliep, bond zijn bed op
zijnen rug en kwam aldus de smidse binnen.

De baas sprak tot hem:

--Zijt gij zot? Waarom laat gij uw bed niet op zijne plaats?

--Ik heb de gewoonte, antwoordde Uilenspiegel, de eerste zeven dagen
van de week de helft van den nacht op mijn bed en de andere helft
onder mijn bed te slapen.

--Zoo, antwoordde de meester, maar ik heb nog een tweede gewoonte, dat
is van mijne onbeschaamde gasten op straat te smijten, met toelating
de eerste week boven den grond, en de tweede onder den grond door
te brengen.

--In uwen kelder, baas, bij de tonnen bruinbier?




LXIV.

Als Uilenspiegel den wagenmaker verlaten had, verhuurde hij zich,
op de terugreis naar Vlaanderen, als leerknaap bij eenen schoenmaker,
die liever aan zijne deur stond, dan met zijne else op den stoel zat.

Uilenspiegel, die hem voor de honderdste maal zag opstaan, vroeg hoe
hij de overleeren moest snijden.

--Snijdt er, sprak de baas, voor groote en middelmatig voeten, opdat
zij passen aan al wie groot of klein vee drijft.

--Zoo zal geschieden, baas, antwoordde Uilenspiegel.

Als de schoenmaker weg was, sneed Uilenspiegel overleeren die alleen
goed waren voor merriën, ezelinnen, veerzen, zeugen en ooien.

Als de baas terug in zijn werkhuis kwam en zijn leder versneden zag,
riep hij uit:

--Wat steekt gij daar uit?

--Wat gij mij gezegd hebt, was 't antwoord van Uilenspiegel.

--Ik heb u gezegd, hernam de baas, schoenen te snijden die passen
aan allen die ossen, varkens en schapen drijven, en nu snijdt gij
schoenen voor die beesten.

Uilenspiegel antwoordde:

--Baas, in dit seizoen waarin alle beesten minneziek zijn, wie anders
dan de zeug, de ezelin, de veers en de ooie mennen den beer, den ezel,
den stier en den ram?

Hij maakte zich buiten, doch hij mocht niet meer binnen.




LXV.

Het was in de Grasmaand, de lucht was zoet, doch nadien begon het te
vriezen en de hemel zag grijs als op Allerzielen. Uilenspiegel's derde
jaar ballingschap was sedert lang verstreken, en Nele verwachtte alle
dagen heuren hertsvriend terug.

--Laas! sprak zij, 't gaat sneeuwen op de kersebloesems, op de
bloeiende seringa's, op al de arme planten die bij de zoele warmte
eener vroege lente vol hope ontloken waren. Lichte sneeuwvlokjes
vallen reeds op de wegen. En 't sneeuwt ook op mijn arm herte.

Waar zijn zij, de heldere zonnestralen, die de gezichten verblijden,
de daken rooder maken, den hemel blauw en de ruiten vlammend? Waar
zijn zij die warmte schenken aan aarde, lucht, aan vogelen en
insecten? Laas! nu heb ik dag en nacht koude van droefheid en bangen
twijfel. Waar zijt gij mijn lief, mijn Uilenspiegel?




LXVI.

Uilenspiegel naderde Ronse, en hij had honger en dorst, doch wilde
niet klagen; hij beproefde de menschen te doen lachen om aan brood
te geraken. Maar het ging hem niet af, de menschen kwamen en gingen
en gaven hem niets.

Het was koud, beurtelings sneeuwde, regende en hagelde het op den
rug van den zwerver. Als hij een hond een been zag afknagen, kwam
het water hem in den mond. Hij had wel een gulden willen verdienen,
doch wist niet hoe hij een gulden in zijne tassche zou krijgen.

Omhoog zoekend, zag hij duiven die van hunne piere witte plakjes
op den weg lieten vallen, maar guldens waren het niet. Hij zocht
langs de groote wegen, maar ook tusschen de kasseien schoten geene
guldens omhoog.

Rechts zoekend, zag hij wel een grimmige wolk in de lucht drijven,
maar hij wist wel dat, zoo er uit dien gieter iets moest vallen,
het geene guldenbui zou wezen. Links vorschend, zag hij een grooten,
luien kastanjelaar, die leefde en waste zonder iets te verrichten.

--Ha! sprak hij, waarom zijn er ook geen guldenaars? Daar zouden
schoone vruchten aan groeien.

Eensklaps barstte de zwarte wolk, en de hagelsteenen vielen en sloegen
geducht op Uilenspiegel's rug.

--Laas, sprak hij, ik voel het wel, 't is alleen naar dwalende honden
dat men steenen smijt.--Toen zette hij het op een loopen.--'t Is
mijne schuld niet, vervolgde hij, als ik geen paleis of zelfs geen
tent heb om mijn schraal lichaam te beschutten. Ho! die leelijke
hagelsteenen, zij zijn hard als kogels. Neen, 't is mijne schuld
niet, als ik in lompen gehuld de wereld rondzwerf, 't is enkellijk
omdat het mij behaagt. Waarom ben ik geen keizer? Die hagelsteenen
willen, lijk slechte woorden, halsstarrig in mijne ooren dringen.--En
hij liep.--Arme neus, voegde hij erbij, weldra zijt gij doorboord,
en kunt gij dienen tot pepervat op de festijnen van de grooten der
aarde, op wie het nooit te hagelen pleegt. En zijne kaken afwisschend,
sprak hij:--Deze kunnen weldra dienen tot schuimspanen voor de koks,
die het te warm bij hunne ovens hebben. Ha! verre herinnering aan
heerlijke pastijen van weleer! Ik heb honger. Ledige buik, beklaag
u niet, jammerende ingewanden, houdt u stil. Fortuin, waar zit gij
nu? breng mij ergens waar ik te eten vind.

Terwijl hij aldus tot zich zelven sprak, werd de hemel helder; het
hagelde niet meer, de zonne vertoonde zich en Uilenspiegel sprak:--Daar
is de zonne, mijne eenige vriendin, die mij komt drogen! Maar eensklaps
zag hij van verre op den weg een gespikkelden hond op zich afkomen,
met hangende tong en puilende oogen.

--Dat beest is razend, riep Uilenspiegel. Hij raapte een grooten steen
op en klom gezwind in een boom; nauwelijks had hij den eersten tak
bereikt, of de hond was dáár, en Uilenspiegel smeet hem den steen op
den kop. De hond bleef staan, trachtte nog Uilenspiegel te bijten,
maar hij kon niet en viel dood ten gronde.

Dat deed Uilenspiegel geen genoegen en te minder daar hij, beneden
gekomen, zag dat de hond geen drogen muil had, gelijk gewoonlijk bij
dolle honden 't geval is. Vervolgens het vel beziende, zei hij tot
zich zelven dat het schoon genoeg was om te verkoopen; hij stroopte
het, waschte het, hing het aan een paal, liet het in de zonne wat
drogen en stak het in zijne tassche.

Daar honger en dorst hem kwelden, ging hij eenige hoeven binnen,
doch dorst het vel niet te koop bieden, uit vreeze dat de hond aan
den boer toebehoord had. Hij vroeg een stuk brood, maar men weigerde
het hem. De nacht kwam. Zijne beenen waren vermoeid en hij ging een
kleine afspanning binnen. Daar zag hij een oude bazin, die een ouden
hond streelde, wiens vel op dat van den doode geleek.

--Van waar komt gij, reiziger? vroeg de oude bazinne.

Uilenspiegel antwoordde:

--Ik kom van Rome, alwaar ik den hond van den Paus van eene verkoudheid
genas, die hem grootelijks hinderde.

--Hebt gij den Paus gezien? vroeg zij, een glas bier tappend.

--Laas! zei Uilenspiegel, het glas ledigend, het is mij alleen
toegestaan geweest zijn heilige voeten en zijn doorluchtige muilen
te kussen.

De oude hond van de bazinne kuchte, doch spuwde niet.

--Wanneer deedt gij dat? vroeg de oude.

--Nu twee maanden geleden, antwoordde Uilenspiegel. Men verwachtte
mij, ik kwam en klopte:--Wie is daar? vroeg de aartsdoorluchtige,
aartsgeheime en aartsbuitengewone kardinaal-kamerheer van Zijne
Zeer Heilige Heiligheid.--Ik, heer kardinaal, antwoordde ik, ik
kom opzettelijk uit Vlaanderen om de voeten van den Paus te kussen
en zijnen hond van het slijm te verlossen.--Ha! zijt gij het,
Uilenspiegel? sprak de Paus langs den anderen kant, achter een
deurken. Het zou mij veel genoegen doen u te zien, maar nu is dat
onmogelijk. De heilige Decretalen verbieden mij mijn gezicht aan de
vreemdelingen te toonen, als men er met het heilige scheermes over
gaat--Laas! zei ik, het slaat mij erg tegen, ik was uit verre landen
gekomen om de voeten Uwer Heiligheid te kussen en zijn hond van het
slijm te genezen. Moet ik onverrichter zake terugkeeren?--Neen, sprak
de Heilige Vader; vervolgens hoorde ik hem roepen:--Aartskamerheer,
schuif mijn stoel tot bij de deur en open het schuifken. Zoo
werd gedaan.--En door het schuifje zag ik twee voeten steken met
gouden muilen aan, en 'k hoorde eene stem die als de donder rolde,
zeggen:--Dit zijn de doorluchtige voeten van den Prins der Prinsen,
den Koning der Koningen, den Keizer der Keizers. Kus, geloovige,
kus de heilige muilen. En ik kuste de heilige muilen en mijn neus was
gansch vervuld met den hemelschen geur die uit die voeten opsteeg. Toen
ging het schuifken weder toe en dezelfde geduchte stemme gebood mij te
wachten. De deur ging toen open en daar kwam een hond te voorschijn,
om de waarheid te zeggen, een ruige, kuchende hond met loopende oogen
en zoo opgeblazen, dat hij schier niet gaan kon.

De Heilige Vader verweerdigde zich nog mij te zeggen:--Uilenspiegel,
gij ziet mijnen hond; hij heeft slijm en andere ziekten gekregen met
te knagen aan het gebeente van geradbraakte ketteren. Genees hem,
mijn zoon, gij zult er u wel mee bevinden.

--Drink, sprak de oude.

--Schenk, antwoordde Uilenspiegel. Zijne rede vervolgend, sprak hij:
Ik deed den hond purgeeren door middel van een wonderbaar drankje,
dat ik zelf gereedgemaakt heb. Hij piste drie dagen en drie nachten
aan één stuk, en was toen genezen.

--Jezus, Maria! sprak de oude, laat mij u kussen, doorluchtige pelgrim,
die den Paus gezien hebt en ook mijn hond kunt genezen.

Doch Uilenspiegel, die niet erg ingenomen was met de kussen der oude,
sprak:--Zij, wier lippen de heilige muilen aangeraakt hebben, mogen,
twee jaar lang, geene kussen van eenige vrouwe ontvangen. Geef mij
wat goede karbonaden, een koppel bloedworsten en bier in overvloed,
en ik zal uwen hond zulke heldere stem geven, dat hij gemakkelijk
zal kunnen meezingen op de okzaal in de groote kerk.

--Mocht het waar zijn, sprak de oude, ik gaf u een gulden voor
uwe moeite.

--Ik zal het doen, sprak Uilenspiegel, maar slechts na het eten.

Zij diende hem alles wat hij gevraagd had. Hij at en dronk zijn
bekomst en had wel, uit erkentelijkheid, de oude gekust, hadde hij
niet gezegd dat dit niet mogelijk was.

Terwijl hij sprak, kwam de oude hond met zijne pooten op zijne
knieën om een stuksken te vragen. Uilenspiegel gaf er hem meerdere;
vervolgens sprak hij tot de hospita:

--Wat zoudt gij doen, als iemand bij u at en niet wilde betalen?

--Ik zou den dief zijn opperste kleed afnemen, sprak de oude.

--Goed, sprak Uilenspiegel; daarna nam hij den hond in den arm en
ging er mee naar den stal, alwaar hij hem opsloot met een been. Hij
nam het vel van den dooden hond en, bij de oude terugkomend, vroeg
hij haar of zij bij heur woord bleef, dat zij het opperste kleed zou
uitdoen van dengene die at zonder betalen.

--Zeker, antwoordde zij.

--Wel, uw hond heeft met mij medegegeten zonder betalen; en ik heb
hem volgens uw voorschrift zijn opperste en eenig kleed uitgedaan.

En hij toonde heur de huid van den dooden hond.

--Ha! snikte de oude, dat is wreed van u, mijnheer de dokter. Arm
hondje! het was mij als een kind. Waarom ontnaamt gij mij den eenigen
vriend, dien ik op aarde bezat? Nu mag ik sterven!

--Ik zal hem weder in 't leven roepen, sprak Uilenspiegel.

--Weder in 't leven! sprak zij. En hij zal mij nog streelen, nog
aankijken, nog likjes geven? Doe het, mijnheer de dokter; niet
alleenlijk zult gij voor niet een lekker maal hebben genoten, maar
'k geef u nog een gulden op den koop toe.

--Ik zal hem weder in 't leven roepen, sprak Uilenspiegel, maar ik
moet warm water hebben, siroop om de voegen van het nieuw vel toe
te plakken, eene naald en garen, en saus van karbonaden, en men moet
mij alleen laten.

De oude gaf hem alles wat hij vroeg; en hij trok met het vel van den
dooden hond naar den stal.

Daar streek hij saus aan den snoet van den ouden hond, die hem liet
begaan; van onderen op zijnen buik en aan zijne pooten maakte hij
groote streepen met siroop.

Hij stiet driemaal een grooten schreeuw en sprak: Sta op! sta op! ik
beveel het, vuile hond!

Vervolgens stak hij gezwind het vel van den dooden hond in zijne
tassche, gaf den levenden hond een schop en joeg hem alzoo de
gelagkamer binnen.

Als de oude heuren hond levend en likkebaardend terugzag, wilde zij
hem kussen van geluk. Maar Uilenspiegel liet het haar niet toe.

--Gij moogt uwen hond maar streelen, sprak hij, als hij al de siroop
afgelikt heeft die aan zijn vel plakt; dan eerst zullen de naden goed
dicht zijn. Tel mij nu mijne tien gulden.

--Eén had ik gezeid, sprak de oude.

--Eén voor het nieuw vel en negen om den hond in 't leven te roepen.

En zij telde ze hem. Uilenspiegel toog henen en smeet het vel van den
dooden hond in de gelagkamer, zeggende:--Daar, vrouwe, bewaar het oude
vel, het kan dienen om het nieuwe te vermaken, als de mot er in komt.




LXVII.

Dien Zondag ging te Brugge de Heilig-Bloedprocessie uit. Klaas zei
tot zijne vrouw en tot Nele van er heen te gaan, daar zij misschien
Uilenspiegel in de stad zouden ontmoeten. Hij zelf zou thuis blijven
om den pelgrim te ontvangen, mocht hij terugkomen.

De vrouwen vertrokken getweeën. Klaas bleef aan zijne deur zitten
en vond Damme doodsch en verlaten. Hij hoorde niets dan het kleppen
van eene of andere dorpsklok in 't ronde, terwijl de wind, bijwijlen
uit Brugge, het getintel van den beiaard en een groot geraas van
falkonetten en van vuurpijlen bracht, die ter eere van het Heilig
Bloed afgeschoten werden.

Klaas zocht droomerig Uilenspiegel op de wegen, doch hij zag niets
dan een blauwen, onbewolkten hemel, eenige honden die met hangende
tong in de zonne lagen, wat musschen die tjilpend zich wentelden in
't stof, eene kat die ze beloerde, en het zonnelicht dat vriendelijk
in al de huizen drong en er de koperen ketels en tinnen pateelen op
den schoorsteen glinsteren deed.

Doch Klaas was treurig te midden van al die vreugd en, zijn zoon
zoekend, tuurde hij in den dikken damp, die over de weiden hing en
spitste het oor om te luisteren of hij hem niet hoorde tusschen het
blijde geritsel der bladeren en het vroolijk gekweel der vogelen in
de boomen. Eensklaps zag hij op den weg van Maldegem een man van
lange gestalte afkomen, maar seffens zag hij dat het Uilenspiegel
niet was. Hij zag hem stilstaan bij een rapenveld en gulzig eenige
dier knollen opeten.

--Die moet grooten honger hebben, sprak Klaas.

Nadat hij hem een oogenblik uit het zicht verloren had, zag hij
hem weder te voorschijn komen aan den hoek van de Reigerstraat,
en hij herkende den bode van Judocus, die hem zevenhonderd gouden
karolusguldens gebracht had. Hij ging hem tegemoet en sprak:

--Kom binnen!

De man antwoordde:

--Gezegend zijn zij, die goed zijn jegens den dolenden reiziger.

Buiten op de vensterbank lagen broodkruimelen, die Soetkin voor de
vogelen had gestrooid. Zij kwamen daar 's winters hun eten zoeken. De
man nam de brokkelingen en at ze gulzig op.

--Gij hebt honger en dorst, sprak Klaas.

--Voor acht dagen werd ik uitgestroopt door de roovers, sprak de man,
en sedert dien voed ik mij met rapen en wortelen langs de wegen.

--'t Is dus tijd eenige versterking te nemen. Hier is, sprak Klaas,
de schapraai openend, hier is eene teil vol boonen, hier zijn eieren,
pensen, hesp, Gentsche worst, en nog hier is waterzooi. Beneden in
den kelder ligt Leuvensche wijn te rusten, die bereid is naar de wijze
van Bourgondië, als robijn zoo rood en zoo klaar. Hij vraagt maar om
gedronken te worden. Nu, wij gaan wat hout op het vuur doen. Hoort
gij de pensen zingen op den rooster? Dat is een liedje van wellust.

Klaas keerde de pensen op den rooster en sprak:

--Hebt gij mijn zoon, mijn Uilenspiegel, niet gezien?

--Neen, antwoordde hij.

--Brengt gij nieuws van Judocus, mijn broeder? vroeg Klaas, terwijl hij
alles opdiende: gerooste pensen, een eierpannekoek, kaas, twee groote
bekers en Leuvenschen wijn, die helder en rood in de bottels flikkerde.

De man antwoordde:

--Uw broeder is te Sippenaken gestorven op het rad. En dit om, als
ketter, de wapenen tegen den keizer te hebben gevoerd.

Klaas was als waanzinnig en beefde, over gansch zijn lijf, zoo groot
was zijn gramschap.

--De beulen, de moordenaars! Judocus! mijn arme broeder!

--Onze vreugde en onze smerten zijn niet van deze wereld, zegde de man.

En hij begon te eten. Vervolgens sprak hij:

--Ik heb uw broeder bijgestaan in het gevang, ik deed mij doorgaan
voor een zijner neven. Ik kom alhier, omdat hij mij zeide: Ga bij mijn
broeder Klaas, als gij voor 't geloove niet sterft als ik; zeg hem van
in den vrede des Heeren te leven, door werken van bermhertigheid te
plegen en zijn zoon heimelijk in de wet van Christus op te brengen. Het
geld dat ik hem gaf, werd genomen van het arme, onwetende volk; dat hij
het gebruike om Thijl op te voeden in de leering van God en zijn woord.

Op die rede, gaf de bode aan Klaas den vredekus.

En Klaas jammerde:

--Op het rad gestorven! mijn arme broeder!

En zoo groot was zijn smert, dat hij niet tot bezinning kon
komen. Doch, daar hij zag dat de man dorst had en zijn glas uitstak,
schonk hij hem wijn in, maar hij at en dronk zonder vreugde.

Soetkin en Nele bleven zeven dagen weg; gedurende dien tijd bleef de
bode de gast van den koolbrander.

Al die nachten hoorden zij Katelijne huilen:

--Het vuur! het vuur! Maak open, maak open; de ziel wil er uit!

En als Klaas naar heure hut ging, stilde hij heur met zoete woorden.

Na zeven dagen toog de vreemde henen, zonder iets van Klaas te willen
aanveerden dan twee karolussen, om onderwege te eten en te slapen.




LXVIII.

Nele en Soetkin waren van Brugge teruggekomen. Klaas zat in de keuken
als een kleermaker, knoopen aan een oude hooze te naaien. Nele stond
naast hem en hitste tegen den ooievaar Titus Bibulus Snuffius op, die
beurtelings vooruit en achteruit sprong en kefte. De ooievaar stond,
op één poot, hem ernstig te bezien, met zijn langen hals in de pluimen
zijner borst. Als Titus Bibulus Snuffius hem zoo vreedzaam zag, kefte
hij nog meer. Maar de vogel, wien die muziek op den duur verveelde,
gaf eensklaps eenen slag met zijn bek in den rug van den hond, die
jankend en jammerend wegvluchtte.

Klaas lachte, Nele insgelijks en Soetkin keek gedurig naar de straat
of Uilenspiegel niet afkwam.

Eensklaps sprak zij:

--Daar is de provoost met vier sergeanten. 't Is toch zeker niet voor
ons. Twee van de mannen loopen de hut om.

Klaas hief zijn hoofd op.

--En de twee anderen blijven staan voor de deur, vervolgde Soetkin.

Klaas stond recht.

--Wien gaat men hier vangen? sprak zij. Jezus God! man, zij komen
hier binnen.

Klaas sprong van de keuken in den hof, gevolgd door Nele en zei:

--Red de karolussen, ze steken achter den brandmuur van den
schoorsteen.

Nele begreep hem: toen zag ze dat hij over de haag sprong, dat de
serjanten hem bij den kraag vatten, dat hij worstelde om los te
geraken en zij weende en riep:

--Hij is onschuldig! hij is onschuldig! doet geen kwaad aan Klaas, aan
mijn vader! Uilenspiegel, waar zijt gij? Gij zoudt ze den kop inslaan!

En zij sprong naar een der serjanten en reet zijn gezicht met
heure nagelen vaneen. En zij riep: Zij gaan hem dooden! en zij viel
machteloos op het gras van den hof.

Op het gerucht kwam Katelijne toegeloopen, en stijf en onbeweeglijk
aanzag zij het schouwspel.

--Het vuur! het vuur! Maakt open: de ziel wil er uit!

Soetkin onkundig van hetgeen er gebeurde, sprak op vroolijken toon
tot de serjanten, die binnengekomen waren:

--Mijne heeren, wien zoekt gij hier in deze arme woning? Als 't mijn
zoon is, die is verre. Hebt gij lange beenen?

Doch op dit oogenblik schreeuwde Nele om hulp; Soetkin liep in den
hof. Daar zag zij heuren man tegenspartelend medegesleept door de
beide serjanten.

--Sla ze dood! riep zij. Uilenspiegel waar zijt gij?

En zij wilde heuren man ter hulp komen, maar een der serjanten greep
heur vast, niet zonder moeite.

Klaas verweerde zich zoo geducht, dat hij ware ontsnapt, hadden de
twee andere serjanten hunne gezellen de hand niet geleend.

En, met de handen gebonden, brachten ze hem terug naar de keuken,
waar Soetkin en Nele heete tranen weenden en snikten.

--Heer provoost, sprak Soetkin, wat heeft mijn arme man gedaan,
dat gij hem bindt als een dief?

--Ketter, sprak een der serjanten.

--Ketter? hernam Soetkin, zijt gij een ketter, gij? Die duivels liegen!

--Ik stel mijn vertrouwen op God, antwoordde Klaas.

Hij werd buitengeleid; Nele en Soetkin volgden hem weenend, in den
waan dat zij ook voor den rechter moesten verschijnen. Mannen en
vrouwlieden kwamen bij heur; maar als zij hoorden dat Klaas opgeleid
werd onder verdenking van ketterije, kregen zij zulken schrik dat zij
haastelijk weer in huis liepen en de deuren toededen. Alleen eenige
meisjes dorsten bij Klaas komen en hem vragen:

--Waar gaat gij alzoo gekoord en gebonden, kooldrager?

--Op Gods genade, meidekens, antwoordde hij.

--Men bracht hem naar het Steen; Soetkin en Nele zetten zich neer
aan de poort. Als het avond werd, zei Soetkin tot Nele te gaan zien
of Uilenspiegel niet teruggekomen was.




LXIX.

Weldra liep de mare in de omliggende dorpen, dat een man gevangengezet
was uit hoofde van ketterije en dat de kettermeester Titelman, deken
van Ronse, bijgenaamd de Inquisiteur Zonder Genade, het onderzoek
zou bestieren.

Uilenspiegel verbleef toen te Koolkerke, in de beste vriendschap met
een schoone pachterse, een jonge weduwe die hem niets weigeren kon
van hetgeen heur eigendom was. Hij werd daar gevierd en geliefkoosd,
tot op den dag dat een verraderlijke medeminnaar, een schepene der
gemeente, hem in den morgen afwachtte als hij uit de taveerne kwam
en hem afrossen wilde. Maar Uilenspiegel, om zijne woede te stillen,
smeet hem in een vijver, waaruit de schepene met de grootste moeite
klaveren kon, groen als een kikvorsch en nat als een spons.

Uilenspiegel duchtte de weerwraak van den schepene en maakte dat hij
zoo gauw mogelijk uit Koolkerke kwam.

En hij liep regelrecht naar Damme.

De avond viel: hij hadde thuis willen zijn; in zijnen geest zag
hij Nele zitten naaien, Soetkin het avondmaal bereiden, Klaas zijne
mutsaards binden en Titus Bibulus Snuffius knagen aan een been.

Een rondleurder vroeg hem in 't voorbijgaan:

--Waar loopt gij zoo haastig?

--Naar Damme, naar mijn huis, was 't antwoord van Uilenspiegel.

De rondleurder sprak:

--De stad is niet meer veilig, ter oorzake van de ketteren die men
er pakt.

En hij ging voort.

Aan de afspanning het Roode Schild gekomen, ging Uilenspiegel er
binnen, om een glas dobbele kuite te drinken.

De baas zei hem:

--Zijt gij de zoon van Klaas niet?

--Die ben ik, antwoordde Uilenspiegel.

--Haast u, sprak de baas, want het uur van rampspoed is voor uwen
vader geslagen.

Uilenspiegel vroeg wat hij zeggen wilde.

De baas antwoordde, dat hij het ongelukkiglijk maar al te gauw
zou weten.

En Uilenspiegel liep voort.

Toen hij Damme binnen kwam, liepen de honden die op de zullen der
deuren zaten, hem keffend en blaffend achterna. Op dat gerucht kwamen
de vrouwen buiten en allen vroegen hem te gelijk:

--Van waar komt gij? Hebt gij nieuws van uwen ongelukkigen vader? Waar
is uwe arme moeder? Zit zij ook in het Steen? Laas! als zij hem maar
niet levend verbranden!

Uilenspiegel liep nog harder.

Hij kwam Nele tegen, die hem zegde:

--Thijl, ga niet naar huis: die van de stad hebben er een bewaker
gesteld van wege den keizer.

Uilenspiegel bleef staan.

--Nele, sprak hij, is 't waar dat zij Klaas, mijn vader in 't gevang
hebben gestoken?

--Ja, sprak Nele, en Soetkin weent aan de poort van het Steen.

Het hert van den verloren zoon bonsde van smerte en hij zei tot Nele:

--Ik wil ze zien.

--Neen, dat moet gij niet doen, sprak Nele, maar wel volbrengen hetgeen
Klaas gezegd heeft, vóóraleer hij gepakt werd: Red de karolussen,
zij steken achter den brandmuur van den schoorsteen. Die moet gij
eerst redden, want zij zijn 't erfdeel van Soetkin, van de arme vrouwe.

Uilenspiegel luisterde niet, maar liep tot aan de poort van het
Steen. Daar vond hij Soetkin zitten; hij kuste heur snikkend en zij
weenden beiden. Door hun jammeren was het volk in menigte naar 't
gevang toegeloopen. Maar de serjanten kwamen, en verjoegen de arme
Soetkin en Uilenspiegel.

Moeder en zoon gingen toen naar het huis van Nele, naast hunne
woonstee, vóór dewelke zij een der landsknechten zagen, die men uit
Brugge ontboden had, uit vreeze voor de onlusten, die tijdens de
uitspraak en gedurende de lijfstraf konden uitbreken. Want Klaas werd
geerne gezien door de burgers van Damme.

De soldenier zat vóór de deur, en zoog de laatste droppelen uit eene
bottel brandewijn. Toen zij ledig was, smeet hij ze waar ze vliegen
wilde. Vervolgens trok hij zijn jachtmes en stak hij kasseien uit.

Snikkend kwam Soetkin bij Katelijne binnen.

En schuddebollend sprak Katelijne: "Het vuur! Maakt open, mijne ziel
wil er uit!"




LXX.

De burgstorm had geluid om de rechters ter vierschare te roepen;
omtrent vier uren zaten zij rond den boom der justitie.

Klaas werd vóór hen geleid en hij zag onder het verhemelte den Baljuw
van Damme zitten; aan zijne zijden waren de drossaard, de schepenen
en de griffier.

Op het geluid van de klokke kwam het gemeen in groote menigte
toegeloopen, en het sprak:

--Vele onder de rechters zitten daar niet om naar recht te vonnissen,
maar als slaven in dienst van den Keizer.

De griffier verklaarde dat de rechtbank zich voorafgaandelijk
ter vierschare rond den lindeboom vergaderd hebbende, beslist had
dat, gehoord de aantijgingen en getuigenissen, de genaamde Klaas,
koolbrander, geboortig van Damme, echtgenoot van Soetkin, dochter van
Joostens, bij den lijve moest gevat worden. En nu, voegde hij er bij,
gaan wij tot het verhoor der getuigen over.

Hans Barbier, buurman van Klaas, werd eerst onderhoord. Nadat hij den
eed afgelegd had, sprak hij: "Op mijner ziele zaligheid bevestig en
verzeker ik dat Klaas, alhier tegenwoordig, door mij gekend is meer
dan vijftien jaar; dat hij altijd eerlijk geleefd heeft volgens de
wetten Onzer Moeder de Heilige Kerk; dat hij nooit smadelijk over
haar gesproken of bij mijn wete nooit eenigen ketter geherbergd heeft,
noch het boek van Luther verborgen, noch over gemeld boek gesproken,
noch iets gedaan dat hem in verdenking kan brengen, de wetten en
ordonnantiën van het keizerrijk overtreden te hebben. Zoo helpen mij
God en al zijne santen."

Jan Van Roosebeke werd vervolgens onderhoord en zei "dat, gedurende de
afwezigheid van Soetkin, vrouw van Klaas, hij verscheidene reizen in
het huis van den beschuldigde twee mannenstemmen had meenen te hooren
en dat hij dikwijls, na de avondklokken, in een kleine zolderkamer,
een licht en twee klappende mannen gezien had, waaronder Klaas. Wat
betreft te zeggen of de andere man al of niet een ketter was, dat kon
hij niet, daar hij hem van verre gezien had. Maar wat Klaas betreft,
vervolgde hij, in volle waarheid moet ik zeggen dat hij, sedert ik hem
ken, geregeld zijn Paschen houdt, op de groote heiligdagen Onzen Heere
ontvangt, en alle Zondagen naar de misse gaat, uitgenomen nochtans
dien van het Heilig Bloed en de volgende. Meerder weet ik niet. Zoo
helpen mij God en al zijne santen."

Ondervraagd of hij Klaas, in de taveerne den Blauwen Toren, geene
aflaten had zien verkoopen en met het vagevuur niet had hooren spotten,
antwoordde Jan Van Roosebeke dat Klaas inderdaad aflaten verkocht had,
maar zonder eenigerlei verachting of spotternije, en dat hij, Jan Van
Roosebeke, er van hem gekocht had gelijk ook Judocus Grijpstuiver,
de deken der vischverkoopers, had willen doen.

De baljuw maakte nu de feiten en punten bekend, uit hoofde waarvan
Klaas voor de vierschare gedaagd was en sprak:

--De aanbrenger, toevallig eens te Damme gebleven, ten einde zijn
geld te Brugge niet in slemperijen en braspartijen te verteren,
gelijk dit meer gebeurt bij deze heilige gelegenheid, stond in
pais een luchtje te scheppen aan zijne zulle, toen hij een man de
Reigerstraat zag ingaan. Klaas, den man ziende, ging hem tegen en
groette hem. De man was in 't zwart gekleed. Hij ging bij Klaas
binnen en de deur bleef half open. Nieuwgierig om te weten wie
die man was, ging de aanbrenger in de gang en hoorde Klaas met den
vreemdeling spreken over zekeren Judocus, zijn broeder, die, onder
de protestantsche troepen gevangengenomen, omtrent Aken geradbraakt
werd. De vreemdeling zei tot Klaas: aangezien het geld hetwelk
zijn broeder hem gegeven had, genomen was van het arme, onwetende
volk, hij het moest gebruiken om zijn zoon op te brengen in den
hervormden eeredienst. Ook zette hij Klaas aan om den schoot Onzer
Moeder de Heilige Kerk te verlaten, en nadat hij allerlei goddelooze
woorden uitgesproken had, antwoordde Klaas alleenlijk: De beulen! De
moordenaars! Mijn arme broeder! En dusdoende lasterde de beschuldigde
Onzen Heiligen Vader den Paus en Zijne Koninklijke Majesteit, omdat zij
de ketterije terecht willen straffen als eene misdaad van goddelijke
en menschelijke majesteitsschennis. Als de man gedaan had met eten,
hoorde de aanbrenger Klaas uitroepen: "Arme Judocus, dat God zich
uwer ontferme; zij waren wreed jegens u." Daardoor beschuldigde hij
God zelf van goddeloosheid, door te willen veronderstellen dat Hij
ketteren in zijnen hemel zou ontvangen. En Klaas hield niet op te
zeggen: "Mijn arme broeder!" Gelijk een kettersch predikant, riep
de vreemdeling toen in woede uit: "Zij zal vallen, de Babylonische
Hoer, en het verblijf worden van duivelen en roofdieren." Klaas
riep daarop: "De beulen, de moordenaars! Mijn arme broeder!" De
vreemdeling, zijne rede vervolgende, sprak: "Want de engel zal eenen
steen oprapen, zoo groot als een molensteen. En hij zal hem in de
zee smijten en zeggen: Zoo wordt het groot Babylon weggeworpen en
nimmermeer teruggevonden."--"Heer, sprak Klaas, uw mond is vol
grammoedigheid; maar zeg mij wanneer de heerschappij zal komen
in dewelke de zachtmoedigen in pais op de wereld zullen kunnen
leven?"--"Nooit! antwoordde de vreemdeling, zoolang de antichrist
regeert, dat is de paus, die een vijand van licht en waarheid
is."--"Ha! sprak Klaas, gij spreekt zonder eerbied van Onzen Heiligen
Vader. Hij is onwetend van de wreede folteringen waarmede de arme
protestanten gestraft worden." De vreemdeling antwoordde: "Zeker
weet hij het, want het is op zijne bevelen dat zij worden om hals
gebracht door den keizer, nu door den koning, die profijt trekt uit
de verbeurdverklaringen, die van de gestorvenen erft en juist liefst
de rijken uit hoofde van ketterije voor de Vierscharen daagt." Klaas
antwoordde: "Overal spreekt men ervan in Vlaanderenland, ik moet het
gelooven. Het vleesch des menschen is zwak, al is het ook koninklijk
vleesch. Mijn arme Judocus!" En Klaas gaf alzoo te verstaan dat het
uit een verachtelijk winstbejag is dat Zijne Majesteit de ketteren
doet straffen. Mits de vreemdeling wilde voortgaan, antwoordde Klaas:
"Gelief, Heere, met deze reden niet voort te gaan, want werden zij
gehoord, ik zou het duur moeten bekoopen."

... Klaas stond op om naar den kelder te gaan, waaruit hij met een
kan bier terugkwam: "Ik ga de deur toedoen", sprak hij vervolgens,
en de aanbrenger hoorde niets meer, want hij moest haastelijk het huis
verlaten. Maar met valavond werd de deur weer geopend. De vreemdeling
ging heen, maar weldra kwam hij weder kloppen, zeggende: "Klaas,
't is koud; ik weet niet waar slapen; verleen mij eene schuilplaats;
niemand heeft mij zien binnenkomen; alles is stil." Klaas liet hem
binnen, stak eene lanteerne aan en men zag hem,--den ketter den weg
wijzend,--de trap opgaan en den vreemdeling brengen in een kleine
dakkamer waarvan het venster uitzicht geeft in den hof.

--Wie anders, riep Klaas uit, kan dat alles overgedragen hebben dan
gij, deugniet van een vischverkooper? Stondt gij dien Zondag niet stijf
als een paal aan uwe zulle, schijnheilig naar de zwaluwen te kijken?

En hij wees naar Judocus Grijpstuiver, deken der vischverkoopers,
die met zijn leelijke tronie tusschen het volk te zien was.

De vischverkooper grijnslachte, toen hij hoorde dat Klaas aldus zich
zelven verried. Allen die van 't gemeen, mannen, vrouwen en meidekens,
zeiden tot elkaar:

--Arme man, die woorden kosten hem het leven!

Doch de griffier ging voort:

--De ketter en Klaas spraken dien nacht en ook de zes volgende
nachten langdurig met elkander; men kon den vreemdeling vele gebaren
van dreigement of van zegening zien maken, de handen ten hemel zien
heffen, als zijne gelijken in ketterije plegen te doen. Klaas scheen
zijne reden goed te keuren. Voorzeker spraken zij die dagen, avonden
en nachten smadelijk over de misse, de biecht, de aflaten en Zijne
Koninklijke Majesteit....

--Niemand heeft dat gehoord, sprak Klaas, en zonder bewijzen mag men
mij daarvan niet beschuldigen!

De griffier hernam:--Men heeft andere dingen gehoord. Als de
vreemdeling den zevenden dag omtrent den valavond vertrok, hebt
gij hem uitgeleide gedaan tot aan den paalsteen van Katelijne's
akker. Daar vroeg de vreemdeling u wat gij gedaan hadt met de leelijke
afgodenbeelden--en de baljuw sloeg een kruis--van de Allerheiligste
Maagd, van Sint-Nikolaas en van Sint-Maarten? Gij antwoordet dat
gij ze gebroken en in den put gesmeten hadt. Zij werden inderdaad,
verleden nacht, in uwen put gevonden, en de stukken ervan liggen in
de folterkamer.

Op die rede scheen Klaas verstomd. De baljuw vroeg hem of hij niets
te antwoorden had; Klaas zegde van neen.

De baljuw vroeg hem of hij de vermaledijde gedachte niet herroepen
wilde, die hem de beelden had doen breken, alsmede de goddelooze doling
dewelke hem smadelijke woorden ten opzichte van Zijne Goddelijke
Majesteit en ten opzichte van Zijne Koninklijke Majesteit had doen
uitspreken.

Klaas antwoordde dat zijn lijf aan Zijne Koninklijke Majesteit,
maar dat zijn geweten aan Christus behoorde, wiens wet hij wilde
opvolgen. De baljuw vroeg hem of die wet diegene van de Heilige
Kerk was.

--Zij staat geschreven in de Heilige Schrift, antwoordde Klaas.

Aangemaand te antwoorden op de vraag of de Paus de Stadhouder van
Christus op dees aarde is, sprak hij:

--Neen!

--Ondervraagd of hij geloofde dat het verboden was de beelden van
de Heilige Maagd en van de Heiligen te aanbidden, antwoordde hij,
dat het afgoderij was. Ondervraagd over het stuk of de oorbiecht goed
is en heilzaam, antwoordde hij:

--Christus heeft gezegd: Belijdt uwe zonden aan malkander.

Hij was kloekmoedig in zijne antwoorden, hoewel hij in den grond
treurig en angstig scheen.

Acht uren had de klok geslagen en de avond viel: de heeren der
rechtbank stelden de uitspraak uit tot den volgenden dag.




LXXI.

In Katelijne's hut weende Soetkin, waanzinnig van smerte. En gedurig
sprak zij:

--Mijn man! mijn arme man!

Uilenspiegel en Nele omhelsden heur met oneindige teederheid. Zij
drukte hen toen in heure armen en weende in stilte. Dan deed zij hun
teeken heur alleen te laten. Nele sprak tot Uilenspiegel:

--Laat heur, zij wil het; wij zullen de karolussen redden.

En zij togen henen; Katelijne liep rond Soetkin en sprak:

Maak open: mijne ziel wil er uit!

En Soetkin, met strakke oogen, keek heur aan zonder heur te zien.

De hutten van Klaas en van Katelijne paalden aaneen, die van Klaas
stond wat achteruit en had een hofje van voren. Bij het huisje van
Katelijne hoorde een boonenveld, dat op de straat uitgaf. Dat veld
was afgesloten met een groene haag, waarin Uilenspiegel en Nele,
toen ze jong waren, een gat gemaakt hadden, om bij malkander te komen.

Uilenspiegel en Nele gingen in het boonenveld en van daar zagen zij
den landsknecht welke, met waggelenden kop in de lucht spuwde, maar
het speeksel viel terug op zijn wambuis. Een flesch lag nevens hem.

--Nele, sprak Uilenspiegel stille, die dronken soldaat heeft niet
genoeg gedronken, hij moet nog meer drinken. Eerst dan zullen wij
hem meester zijn. Laat ons de flesch nemen.

Bij den klank hunner stemmen, keerde de soldenier zijn zwaren kop
naar hen toe; hij zocht zijne flesch en, die niet vindende, spuwde hij
voort in de lucht om in den maneschijn zijn speeksel te zien vallen.

--De brandewijn zit tot aan zijne tanden, sprak Uilenspiegel, ziet gij,
Nele, hoe moeilijk hij spuwt?

Als de soldenier opnieuw gespuwd en in de lucht gekeken had, stak hij
de hand uit naar de flesch. Hij vond ze, zette ze aan zijn mond, stak
zijn hoofd achteruit, klopte zachtjes op de flesch om er de laatste
droppelen uit te halen en lokte er aan als een kind aan de borst
zijner moeder. Er niets meer in vindende, smeet hij de flesch weg,
vloekte toen in het Hoogduitsch, spuwde weer, liet den kop rechts en
links vallen, knauwde een onverstaanbaar vaderons en sliep in.

Uilenspiegel, die begreep dat die slaap niet van langen duur wezen
zou, zegde dat zij hem nog zwaarder moesten doen ronken; hij kroop
door de haag, nam de flesch van den dronkenlap, gaf ze aan Nele,
die ze met brandewijn vulde.

De soldaat snorkte door; Uilenspiegel kroop weder door het gat van
de haag, stak de volle flesch tusschen de beenen van den dronkaard
en keerde terug in het boonenveld, waar hij met Nele bleef wachten.

De koelte van de versch gevulde flesch deed den soldaat de oogen
openen, en onwillekeurig tastte hij naar het voorwerp, dat hem koude
veroorzaakte.

Zijn dronkaards-instinct zei hem, dat het wel eene volle flesch kon
wezen, en hij greep ze vast. Uilenspiegel zag hem, in den maneschijn,
de flesch schudden om te hooren of er iets in was, er van proeven,
lachen en verwonderd zijn dat zij zoo vol was, dan een slok drinken,
de flesch neerzetten, weernemen en nog drinken.

Toen zong hij:


    Komt in 't blauw heer Maneschijn
    's Avonds bij vrouw Zee....


Bij de Hoogduitschers is vrouwe Zee de gemalinne van heer Maan,
die de meester der vrouwen is. Hij zong dus:


    Komt in 't blauw heer Maneschijn
    's Avonds bij vrouw Zee,
    Vrouwe Zee dan biedt hem aan
    Heet haar grooten roemer wijn,
    Komt in 't blauw heer Maneschijn.

    Met hem zal ze aan tafel gaan,
    Om zijn hals haar armen slaan,
    En is 't rijke maal gedaan,
    In haar bed hem liggen gaan,
    Komt in 't blauw de heere Maan.

    Dien' me zoo mijn lievekijn,
    Lekker eten, heeten wijn,
    Dien' me zoo mijn lievekijn,
    Komt in 't blauw heer Maneschijn.


Na elk referein nam hij een slok en na het laatste ledigde hij de
flesch. En toen viel hij in slaap. En hij hoorde niet dat Nele zegde:
"Ze steken in eenen pot achter den brandmuur van den schoorsteen",
noch dat Uilenspiegel langs het stalleken in de keuken van Klaas
drong. Uilenspiegel hief de plaat van den brandmuur op, nam den pot en
de karolussen en ging toen de karolussen begraven naast den steenput
van Katelijne, daar hij wel wist dat men ze misschien in den put,
doch geenszins er nevens zou zoeken.

Vervolgens keerden zij terug bij Soetkin, die weende en zuchtte:

--Mijn man! mijne arme man!

Nele en Uilenspiegel bleven heel den nacht bij heur waken.




LXXII.

Den volgenden dag riep de burgstorm de rechters ter vierschare.

Als zij op de vier banken rond den boom der justitie zaten,
onderhoorden zij nogmaals Klaas en vroegen hem of hij zijne dolingen
wilde herroepen.

Klaas hief de handen ten hemel en sprak:

--Christus, mijn Heer, ziet mij van omhoog. Ik bekeek de zonne toen
mijn Thijl ter wereld kwam. Waar is hij nu, de zwerver? Soetkin,
mijn goede, mijn zoete vrouwe, zult gij kloekmoedig zijn in 't ongeluk?

Toen bezag hij den lindeboom en vloekte hij hem:

--Storm en droogte! dat de boomen van den grond onzer vaderen liever
verschroeien dan te gedogen, dat men in hunne schaduw het vrije
geweten ten dood verwijst! Waar zijt gij, mijn jongen? Ik was hard
jegens u Mijne Heeren, ontfermt U mijner, en oordeelt mij gelijk Onze
Goedertieren Heere zou doen.

En allen die hem aanhoorden, moesten weenen, behalve de rechters en
Judocus Grijpstuiver.

Toen vroeg hij of er voor hem geenerlei vergiffenis was, zeggende:

--Ik heb altijd veel gewrocht en weinig gewonnen; ik was goed jegens
den arme en gedienstig voor elkeen. Ik heb de Roomsche Kerke verlaten
om te gehoorzamen aan den geest Gods, die tot mij sprak. Ik smeek om
geen andere gratie dan de verandering van de straffe des vuurs in die
van eeuwigdurende verbanning uit Vlaanderenland, op verbeurte mijns
levens, straffe die voorwaar streng genoeg is.

Allen riepen:

--Genade, heeren! erbarming!

Maar Judocus Grijpstuiver riep niet mede.

De baljuw gaf de toehoorders teeken te zwijgen en zegde dat het door
de plakkaten strengelijk verboden was, genade voor ketteren te vragen,
maar dat, zoo Klaas zijne doling wilde afzweren, hij zou gehangen
worden in stee van verbrand.

En het volk sprak:

--Gehangen of verbrand, 't is toch de dood!

En de vrouwen weenden en de mannen morden.

--Ik zweer niets af, sprak Klaas. Doet met mijn lijf wat uwer genade
zal believen.

Titelman, de deken van Ronse, riep toen uit:

--Het is ondraaglijk zulk een kettergespuis tot zijne rechters het
hoofd te zien verheffen; het lichaam tot assche verbranden is een
kortstondige pijne; men moet de ziele redden en de ketteren, door
middel van de torture, dwingen hunne dolingen af te gaan, opdat zij
aan 't volk het gevaarlijk schouwspel niet geven van ketteren, die
in onboetveerdigheid sterven.

Op die rede weenden de vrouwen nog meer en zeiden de mannen:

--Hij heeft het stuk bekend: 't is dus de straffe, maar niet de
torture.

De rechtbank besliste dat, mits de tortuur niet voorgeschreven was
door de ordonnantiën, Klaas die niet moest verduren. Nogmaals tot
afzweren vermaand, antwoordde hij:

--Ik kan niet.

Krachtens de plakkaten, werd hij plichtig verklaard aan simonie,
wegens het verkoopen van aflaten, aan ketterije en aan het herbergen
van ketters en als dusdanig werd hij veroordeeld om "geëxecuteerd
te worden met den viere, zoo dat er de dood naar volge", vóór de pui
van het schepenhuis.

Zijn lichaam zou twee dagen aan den staak blijven hangen om tot
voorbeeld te dienen en daarna gevoerd worden ter plaatse patibulaire,
zooals zij het galgeveld heetten.

De rechtbank kende den aanbrenger Judocus Grijpstuiver--wiens' naam
niet genoemd werd--vijftig gulden op de eerste honderd karolusgulden
der erfenis en den tienden penning op het overige toe.

Als Klaas dat vonnis hoorde, sprak hij tot den deken der
vischverkoopers:

--Gij zult een kwaden dood sterven, slecht mensch, die voor een kleine
som gelds eene weduw en eenen wees, twee ongelukkigen maakt.

De rechters hadden Klaas laten uitspreken, want zij ook--behalve
Titelman--voelden groote verachting voor den deken der vischverkoopers
en zijne eerlooze aanklacht.

Grijpstuiver was bleek van woede en van schaamte.

En Klaas werd terug naar het Steen gebracht.




LXXIII.

Den volgenden dag, werd het vonnis aan Nele, Uilenspiegel en Soetkin
bekend gemaakt.

Zij vroegen den rechters om in het gevang te mogen gaan, hetwelk hun
toegestaan werd, behalve aan Nele.

Als zij binnenkwamen, zagen zij Klaas met een keten aan den muur
geklonken. Een klein houtvuur smeulde in den heerd, ter oorzake van de
wakheid. Want bij wet en recht is het in Vlaanderen voorgeschreven,
goed te zijn voor hen die moeten sterven, en hun brood, vleesch of
kaas, alsmede wijn te geven. Maar de schrokkige cipiers overtreden
dikwijls de wet, en talrijk zijn zij, die het grootste en beste deel
van het eten der arme gevangenen achterhouden.

Weenend vloog Klaas om den hals van Uilenspiegel en Soetkin, maar
hij was de eerste die ophield met weenen, want hij wilde sterk zijn,
als man en als hoofd van het huis.

Soetkin snikte en Uilenspiegel sprak:

--Kon ik die ijzers breken.

Soetkin snikte en sprak:

--Ik zal bij koning Philippus gaan, hij zal genade verleenen.

Klaas antwoordde:

--De koning erft van de martelaren.

Dan voegde hij er bij:

--Lieve vrouw en kind! treurig en smertvol ga ik deze wereld
verlaten. Zoo ik eenigen schrik koester voor het lijden mijns
lichaams, ben ik mede bedroefd als ik er aan denk dat, als ik dood
ben, gij beiden arm en ellendig zult zijn, want de koning zal u uwe
have ontnemen.

Uilenspiegel antwoordde met stille stemme:

--Gisteren heb ik met Nele alles gered.

--Dat doet mij genoegen, antwoordde Klaas; de aanbrenger zal niet
lachen op mijn lijk.

--Hij sterve, de judas, sprak Soetkin met haatvollen blik.

Maar Klaas dacht aan de karolussen en sprak:

--Dat was slim van u, Thijlken, mijn lieveling; Soetkin, mijn arme
Soetkin, zal dus in haren ouden dag geen honger hoeven te lijden.

En Klaas omhelsde heur, drukte heur tegen zijne borst, en zij snikte
nog harder, bij de gedachte dat zij weldra heuren braven beschermer
zou kwijt zijn.

Klaas bezag Uilenspiegel en sprak:

--Mijn zoon, dikwijls deedt gij kwaad, door langs de wegen te
slenteren als de rabauwen; dat moogt gij nimmermeer doen, mijn kind,
noch uw moeder alleen laten, want gij, als man, moet heur beschermer
en verdediger zijn.

--Dat zal ik, vader, sprak Uilenspiegel.

--O mijn arme man! zei Soetkin hem kussend. Welke misdaad bedreven wij
dan? Wij leefden getweeën gelukkig in eere en in deugd; wij beminden
elkander, dat weet gij, Heere God, die ons ziet! Wij stonden vroeg
op om te werken en 's avonds aten wij, U dankend, het zuur gewonnen
brood van den dag. Ik ga naar den koning; ik zal hem verscheuren met
mijne nagelen. Heere God, wij hebben niets misdaan!

Maar de cipier kwam binnen en zei dat ze moesten vertrekken.

Soetkin vroeg om te blijven. Klaas voelde heur arm gezicht branden
tegen het zijne, en de tranen van Soetkin maakten zijne wangen nat,
en heel heur lichaam trilde en huiverde in zijne armen. Hij vroeg om
heur bij hem te laten.

De cipier zei nog dat ze moesten henengaan en trok Soetkin uit de
armen van Klaas.

Klaas sprak tot Uilenspiegel:

--Waak over haar.

Uilenspiegel beloofde het hem. En de zoon de moeder ondersteunend,
togen Uilenspiegel en Soetkin henen.




LXXIV.

Den volgenden dag, die de dag van de lijfstraffe was, namen de buren
uit medelijden, Uilenspiegel, Soetkin en Nele mede naar Katelijne's
huis en sloten hen op.

Maar zij hadden er niet aan gedacht, dat zij van verre de kreten
van den martelaar hooren en, door het venster, de vlammen van den
brandstapel zien konden.

Schuddebollend dwaalde Katelijne door de stad, roepende:

--Maakt open: de ziel wil er uit!

Te negen uren werd Klaas in zijn hemde, met de handen op den rug
gebonden, uit de gevangenis gehaald. Volgens de sententie, was de
brandstapel opgericht in de Onze-Lieve-Vrouwestraat, rondom een staak,
die vóór de pui van 't schepenhuis geplaatst was. De beul en zijne
knechten waren nog bezig met het hout opeen te stapelen.

Klaas, omringd door zijne serjanten, wachtte geduldig, terwijl de
provoost te peerd, de staffieren van 't baljuwschap en de negen uit
Brugge ontboden landsknechten groote moeite hadden om het morrende
volk tegen te houden.

Allen zeiden dat het wreedheid was een man, die steeds goed, gedienstig
en neerstig was, in zijn ouden dag aldus te martelen.

Doch eensklaps knielden zij neder om te bidden. De doodklok begon
te kleppen.

De uitzinnige Katelijne stond vooraan in het volk.

Naar Klaas en den brandstapel kijkend, sprak zij:

--Het vuur! Het vuur! Maakt een gat: de ziel wil er uit.

Als Soetkin en Nele de klokke hoorden, sloegen beiden een kruis. Maar
Uilenspiegel deed het niet, zeggende dat hij God niet aanbad op de
manier van de beulen. De hut rondloopend, beproefde hij deuren en
vensteren open te breken, maar de buren, die buiten stonden, beletten
het hem.

Doch Soetkin sloeg eensklaps heur voorschoot vóór heur gezicht
en gilde:

--De rook!

De drie bedroefden zagen een groote zwarte rookwolk dwarrelend omhoog
stijgen. 't Was de rook van den brandstapel, waarop Klaas aan eenen
staak was gebonden en dien de scherprechter aan drie kanten aangestoken
had, in naam des Vaders, des Zoons en des Heiligen Geestes.

Klaas keek rond zich, en als hij Soetkin en Uilenspiegel in de menigte
niet zag, was hij tevreden dat zij hem niet zouden zien lijden.

Klaas bad, het hout knetterde, de mannen morden, de vrouwen weenden,
Katelijne sprak:--Doet het vuur uit, maakt een gat, de ziel wil er
uit,--en de doodklok klepte, en ander gerucht hoorde men niet.

Soetkin werd eensklaps bleek als de dood, zij huiverde over gansch
heur lichaam en wees naar den hemel. Een lange, smalle vlam was uit
den brandstapel opgestegen en verhief zich bijwijlen boven de daken
van de lage huizen. De vlam was bitter smertelijk voor Klaas, want al
naar gelang van de grillen des winds, knaagde zij aan zijne beenen,
verschroeidde en verbrandde zij zijn haar en zijnen baard.

Uilenspiegel drukte Soetkin in zijne armen en wilde heur van voor
het venster trekken. Zij hoorden een bangen kreet: 't was Klaas,
wiens lichaam aan eenen kant brandde. Maar hij zweeg en weende. En
zijne borst was nat van zijne tranen.

Toen hoorden Soetkin en Uilenspiegel een groot rumoer. 't Waren de
poorters, vrouwen en kinderen die riepen:

--Klaas werd niet veroordeeld om te sterven met zacht vuur, maar met
groote vlammen. Beul, pook het vuur aan!

De beul deed het, doch het vuur wilde niet laaien.

--Verworg hem, riepen zij.

En zij smeten steenen naar den provoost.

--De vlam! de groote vlam! huilde Soetkin.

Te midden van den rook, zag zij nu een roode vlam ten hemel stijgen.

--Hij gaat sterven, sprak de weduw. God, ontferm U der ziele van
den onschuldigen martelaar. Waar is de koning, dat ik hem met mijne
nagelen het hert uitrukke?

En de doodklok klepte.

Soetkin hoorde Klaas nog een grooten kreet slaken, maar zij zag noch
zijn lichaam dat zich wrong en kronkelde door de smerte des vuurs,
noch zijn gezicht dat ineentrok, zijn hoofd dat hij langs alle kanten
keerde en draaide en tegen den staak sloeg. Het volk ging voort met
roepen en fluiten, de vrouwen en kinderen smeten nog steenen, toen
plotseling heel de brandstapel ontgloeide, en allen, te midden van
rook en van vlammen, Klaas hoorden zuchten:

--Soetkin! Thijl!

En zijn hoofd viel op zijne borst alsof het van lood was.

En uit Katelijne's woning kwam een schellen, hertverscheurenden
kreet. En toen hoorde men niets meer dan de uitzinnige, die
schuddebollend sprak: "De ziel wil er uit".

Klaas was dood. De brandstapel viel ineen aan den voet van den staak,
aan denwelken het arme, verkoolde lichaam bij den hals bleef hangen.

En de doodklep klepte.




LXXV.

Met gebogen hoofd en gevouwen handen stond Soetkin zwijgend tegen
den muur van den keuken. En Uilenspiegel had zijne armen om heuren
hals geslagen, zonder spreken of weenen.

Hij was verschrikt van het koortsvuur dat in zijn moeders lichaam
brandde.

De buren, die terugkwamen, zeiden dat Klaas gedaan had met lijden.

--Hij is in den hemel, sprak de weduw.

--Bid voor hem, sprak Nele tot Uilenspiegel, en zij gaf hem heuren
rozenkrans; maar hij stiet dien van zich af, omdat, zoo hij zeide,
de bollekens door den paus gewijd waren.

De nacht was gevallen en Uilenspiegel zei:

--Moeder, ga slapen, ik zal bij u waken.

--Gij moet niet waken, sprak Soetkin, want de slaap doet goed aan
jonge menschen.

Nele maakte hun elk eene legerstee in de keuken en ging toen henen.

En zij bleven er getweeën, terwijl het vuur van de wortels in den
heerd uitbrandde.

Soetkin ging slapen, Uilenspiegel deed als zij en hoorde ze weenen
in heur bedde.

Buiten, in de nachtelijke stilte, deed de wind de boomen huilen lijk
de zee en joeg, als voorboden van den herfst, dwarrelende stofwolken
tegen de ruiten.

Het scheen Uilenspiegel dat hij een man zag over en weer gaan, dat
hij stappen hoorde in de keuken. Toen hij opkeek, zag hij den man
niet meer; maar hij luisterde en hoorde alleen den wind, die in den
schoorsteen huilde en Soetkin, die in heur bedde weende.

Dan opnieuw hoorde hij stappen, en, achter zich, tegen zijn hoofd,
een bangen zucht.--Wie is daar? sprak hij.

Niemand antwoordde, maar hij hoorde drie kloppen op de
tafel. Uilenspiegel, verschrikt en huiverend, vroeg nogmaals:--Wie is
daar? Hij kreeg geen antwoord, maar hoorde drie kloppen op de tafel
en voelde twee armen die hem vastgrepen, en over zijn gelaat zich
een ruig lichaam buigen, dat een groot gat in de borst had en naar
verbrand rook.

--Vader, sprak Uilenspiegel, is het uw arm lichaam, dat aldus op
mij drukt?

Hij kreeg geen antwoord, en, hoewel de schimme omtrent hem was,
hoorde hij buiten roepen: "Thijl! Thijl!" Soetkin stond schielijk op
en kwam aan Uilenspiegel's bed. "Hoort gij niets?" vroeg zij hem.

--'t Doet, vader die mij roept.

Ik, sprak Soetkin, ik heb een koud lichaam in mijn bedde gevoeld;
en de stroozakken schudden en de gordijnen gingen open en toe en
'k hoorde eene stemme die sprak: "Soetkin"; eene stemme die zwak
als een ademtocht was, en stappen zoo licht als het dansen der
muggen. Vervolgens tot den Geest van Klaas sprekend, zegde zij:
"Man, zoo gij iets begeert in den hemel alwaar God U opgenomen heeft,
moet gij het zeggen, opdat wij uwen wil kunnen volbrengen."

Eensklaps sloeg de wind met geweld de deur open en de kamer werd
met stof vervuld, en Uilenspiegel en Soetkin hoorden in de verte een
akelig ravengekras.

Zij kwamen samen buiten en gingen naar den brandstapel.

Het was stikdonker, behalve wanneer de gure Noordenwind de wolken in
den hemel als herten voortjoeg en de bleeke maan heur zilveren licht
ter aarde zond.

Een stadsserjant stond op wacht bij den brandstapel. Soetkin en
Uilenspiegel hoorden den klank zijner stappen op den harden grond en
het gekras eener raaf, die zekere raven bijriep, want het werd in de
verte beantwoord door andere raven.

Als Uilenspiegel en Soetkin bij den brandstapel waren, viel de raaf
op Klaas' schouderen neer, en zij hoorden heur pikken in het lijk,
en andere raven vlogen weldra bij.

Uilenspiegel wilde op den brandstapel springen om de raven te verjagen;
de serjant sprak tot hem:

--Tooveraar, 't is nuttelooze moeite die gij doen gaat, weet dat de
handen van verbranden het vermogen niet hebben onzichtbaar te maken
als die van gehangenen.

--Heer serjant, antwoordde Uilenspiegel, ik ben geen tooveraar, maar
de wees van hem die daar hangt, en deze vrouw is zijne weduwe. Wij
willen hem nogmaals kussen en een weinig van zijne assche meenemen,
tot gedenkenis. Laat het ons toe, heer, gij die geen vreemd soldenier,
maar een zoon van Vlaanderen zijt.

--Doet als gij vraagt, antwoordde de serjant.

De wees en de weduw klommen op het verkoold hout en kwamen bij het
lijk; weenend kusten zij Klaas zijn gezicht.

Ter plaats van het hert, waar de vlam een groot gat had geknaagd, nam
Uilenspiegel een weinig asch van den doode. Vervolgens nederknielend,
begonnen zij te bidden. En toen de ochtendschemering de kimmen lichtte,
zaten beiden daar nog; doch de sergeant deed hen heengaan, uit vreeze
voor straf.

Thuis, nam Soetkin een stukje roode en een stukje zwarte zijde; zij
maakte een zakje van, in hetwelk zij de assche stak; en zij naaide
twee linten aan het zakje, opdat Uilenspiegel het om den hals kon
dragen. Zij langde hem het zakje en sprak:

--Dat deze assche, die het hert van mijn man is, dit rood, dat zijn
bloed is, dit zwart, dat onze rouw is, steeds op uwe borst blijve,
als een vuur van wrake voor zijne beulen!

--Dat zal, zwoer Uilenspiegel.

En de weduw kuste den wees, en de zonne stond op.




LXXVI.

's Anderen daags kwamen de serjanten en omroepers der gemeente in de
hut van Klaas, om al het huisraad op straat te brengen en publiek te
verkoopen. Van uit Katelijne's huis zag Soetkin de wieg van ijzer en
kooper beneden komen die, van vader tot zoon, altijd in Klaas' huis
was geweest, waarin de arme doode geboren was en ook Uilenspiegel ter
wereld kwam. Vervolgens bracht men ook het bedde beneden, in hetwelk
Soetkin heuren zoon had ontvangen. En vervolgens de schapraai, en
de ketels, pateelen en potten, die niet meer blonken lijk weleer,
maar nu vuil van het stof waren.

En ook eene tonne enkele en een klein vaatje dobbele kuite en, in
een groote mande, ten minste dertig flesschen wijn; en alles werd op
straat gezet, tot den laatsten stoel uit het huis.

Met bloedend herte, doch zonder klagen, zag zij zich heur nederigen
rijkdom, alle die herinneringen van vroeger, alle die vrienden
ontnemen. De omroeper stak de keers aan en het huisraad werd stuk
voor stuk verkocht. De keers was bijkans op, als de deken der
vischverkoopers alles tegen een spotprijs gekocht had om het voort
te verkoopen. Hij scheen vergenoegd als een wezel, die de hersenen
eener henne uitzuigt.

Uilenspiegel zei in zich zelven: "Gij zult niet blijven lachen,
moordenaar."

De verkoop was gedaan en nochtans bleven de serjanten overal zoeken,
zonder de karolussen te vinden. De vischverkooper riep:

--Gij zoekt slecht: ik weet dat Klaas voor zes maanden zevenhonderd
karolussen bezat.

Uilenspiegel zei in zich zelven: "Gij zult niet erven, moordenaar."

Eensklaps keerde Soetkin zich naar hem en sprak, met den vinger naar
den vischverkooper wijzend:

--Dáár is de aanbrenger!

--Ik weet het, zei Uilenspiegel.

--Duldt gij, sprak zij, dat hij uws vaders bloed erve?

--Nog liever zat ik een heelen dag op de pijnbank, antwoordde
Uilenspiegel.

--Ik ook, sprak Soetkin, maar spreek niet uit medelijden, hoe groot
ook de smerte weze die ik lijde.

--Eilaas! gij zijt eene vrouwe, zei Uilenspiegel.

--Arme jongen, sprak Soetkin, ik bracht u ter wereld en kan tegen
't lijden. Maar gij, als ik u zag.... Vervolgens verbleekend: Ik zal
de Heilige Maagd bidden, die heuren zoon aan het kruis zag....

En zij weende, en kuste Uilenspiegel.

En aldus sloten zij een verdrag, dat hun haat en hunne kracht
versterkte.




LXXVII.

De vischverkooper moest maar de helft van de koopsom betalen, mits de
andere helft hem als aanbrenger toekwam, tot dat men de zevenhonderd
gouden karolussen vond, die hem tot zijn eerlooze daad aangezet hadden.

Soetkin weende 's nachts en werkte 's daags in het huishouden. Dikwijls
hoorde Uilenspiegel haar in zich zelve zeggen:

--Als hij erft, laat ik mij dooden.

Nele en hij, wisten dat zij doen zou wat zij zeide; zij deden hun
best om Soetkin te bewegen naar Walcheren te trekken, alwaar zij magen
had. Soetkin wilde niet, zeggende dat zij zich niet verwijderen wilde
van den bodem, die weldra heur gebeente zou ontvangen.

Ondertusschen ging de vischverkooper opnieuw tot den baljuw en zegde,
dat de aflijvige voor eenige maanden zevenhonderd karolussen geërfd
had, dat Klaas een spaarzam man was en dat hij dus die groote som
niet verteerd had, maar dat ze ergens verborgen moest zijn.

De baljuw vroeg hem wat kwaad Uilenspiegel en Soetkin hem hadden gedaan
om, na den eenen zijn vader en de andere heuren man te hebben ontnomen,
hen nu nog zoo wreedelijk te vervolgen.

De vischverkooper antwoordde dat hij, als hoogpoorter van Damme,
de wetten van den lande wilde doen eerbiedigen om 's keizers
goedertierenheid te verwerven.

Daarop liet hij in handen van den baljuw een geschrevene aanklacht en
hij bracht getuigen, die, in volle waarheid sprekende, huns ondanks
moesten bevestigen, dat de vischverkooper niet loog.

Op die getuigenissen verklaarden de heeren van de Schepenkamer,
dat de vermoedens van plichtigheid voldoende waren om de torture toe
te passen. Dienvolgens lieten zij het huis opnieuw afzoeken door de
serjanten, die last hadden moeder en zoon naar het Steen te brengen,
alwaar zij zouden opgesloten blijven, tot dat de scherprechter van
Brugge kwam, die men op staanden voet had ontboden.

Toen Soetkin en Uilenspiegel gekoord en gebonden door de straat kwamen,
stond de vischverkooper aan zijne deur naar hen te kijken.

En de poorters en poorteressen van Damme stonden ook aan hunne
deur. Mathijssen, de naaste gebuur van den vischverkooper, hoorde
Uilenspiegel tot den lafaard zeggen:

--Gij, die eene weduwe martelt, wordt gedoemd door den Heere!

En ook Soetkin, die zei:

--Gij, die eenen wees vervolgt, zult een kwaden dood sterven!

Toen die van Damme aldus vernomen hadden dat het op een tweede
aanklacht van Grijpstuiver was, dat men moeder en zoon naar 't gevang
bracht, jouwden zij den vischverkooper uit en smeten 's avonds steenen
in zijne ruiten. En zijne deur werd vol vuiligheid bestreken.

En hij dorst niet meer buitenkomen.




LXXVIII.

Omtrent tien uur des voormiddags werden Soetkin en Uilenspiegel in
de folterkamer gebracht.

Daar waren de baljuw, de griffier en de schepenen, de beul van Brugge,
zijn knecht en een chirurgijn-baardemaker.

De baljuw vroeg aan Soetkin of zij niets achterhield dat den keizer
toekwam. Zij antwoordde dat zij, mits zij niets bezat, niets kon
achterhouden.

--En gij? vroeg hij aan Uilenspiegel.

--Voor zeven maanden, antwoordde hij, erfden wij zevenhonderd
karolussen; eenigen daarvan zijn verteerd. En ik weet niet waar de
andere zijn, maar ik denk dat de reiziger, die tot onzen rampspoed
ten onzent verbleef, die heeft medegenomen, want nooit heb ik thuis
karolussen gezien.

De baljuw vroeg toen nog eens of beiden in hun gezegde bleven
volherden.

Zij antwoordden, dat zij geenerlei goed achterhielden dat den keizer
toekwam.

Ernstig doch vol medelijden, sprak de baljuw:

Mits de lasten tegen u beiden zwaar zijn, zult gij, zoo gij geen
bekentenis doet, de pijnbank moeten verduren.

--Spaar de weduw, sprak Uilenspiegel. De vischverkooper heeft alles
gekocht wat er was.

--Arme jongen, sprak Soetkin, de mannen kunnen geen smerten als de
vrouwen verdragen.

Als zij zag dat Uilenspiegel om harentwille wit als een doode was,
zeide zij nog:

--Ik haat en 'k ben sterk.

--Spaar de weduw, sprak Uilenspiegel.

--Neem mij in zijne plaats, zei Soetkin.

De baljuw vroeg aan den beul of alles gereed was om de waarheid
te ontrukken.

De beul antwoordde:

Alles is gereed.

De rechters, na beraadslaagd te hebben, besloten dat men moest beginnen
met de vrouw, om 't stuk te doen bekennen.

--Want, sprak een der schepenen, geen zoon is zoo wreedaardig dat hij
zijne moeder kan zien lijden, zonder te bekennen om heur te verlossen.

De baljuw sprak tot den scherprechter:

--Zet de vrouw op den stoel en doe de stokskens aan heure handen
en voeten.

De beul gehoorzaamde.

--Ho! doet dat niet, mijne heeren, riep Uilenspiegel. Bindt mij vast
in heure plaats, breekt mijne vingeren en teenen, maar spaart heur!

--De vischverkooper! riep Soetkin. Ik haat en 'k ben sterk.

Uilenspiegel werd nog bleeker, beefde en zweeg.

De stokskens, die van palmhout waren, werden tusschen de vingeren
gestoken. Door middel van koordjes waren zij tot een zoo vernuftigen
toestel gemaakt, dat de beul naar den wil van den rechter, al
de vingeren kon pletteren, of den lijder maar een geringe pijn
veroorzaken.

Hij stak de stokskens tusschen de vingeren en teenen van Soetkin.

--Trek aan, zei de baljuw.

De hangman deed het wreedelijk.

Toen sprak de baljuw tot Soetkin:

--Zeg mij waar de karolussen liggen.

--Ik weet het niet, antwoordde zij zuchtend.

--Nijp harder, sprak hij.

Uilenspiegel wilde zijne armen losrukken, die op zijnen rug waren
gebonden, om Soetkin te hulpe te komen.

--Doet niet prangen, heeren rechters, het zijn teere en broze
vrouwenvingeren. Een vogeltje zou ze aan stukken pikken. Prangt niet;
heer scherprechter, ik spreek geenszins tot u, want gij moet doen
wat die heeren u heeten. Spant niet, hebt medelijden.

--De vischverkooper! riep Soetkin.

En Uilenspiegel zweeg.

Doch, als hij zag dat de beul de stokskens harder deed spannen,
riep hij opnieuw:

--Erbarming, heeren! Daar breekt gij heure vingeren die zij noodig
heeft om te werken. Laas! heure voeten, nu zal zij niet meer kunnen
gaan! Erbarming, heeren!

--Vischverkooper, gij zult een bangen dood sterven! riep Soetkin.

En heure beenderen kraakten en 't bloed van heure voeten gutste
ten gronde.

Uilenspiegel zag het en sprak, bevend van smert en van gramschap:

--Vrouwenbeenderen, breekt ze toch niet, heeren rechters.

--De vischverkooper! zuchtte Soetkin.

En heure stem was zacht als de stem van eene schim.

--Heeren rechters, de handen en voeten zijn rood van 't bloed. Men
heeft heure beenderen gekraakt.

De chirurgijn-baardemaker raakte ze aan, en Soetkin stiet een kreet
van smerte.

--Beken in heure plaats, zei de baljuw tot Uilenspiegel.

Maar Soetkin bezag hem met opengesperde oogen, als die van een
doode. En hij begreep dat hij niet spreken mocht, en weende zonder
een woord te uiten.

--Daar die vrouwe de kloekmoedigheid des mans heeft, sprak toen de
baljuw, moet men ze beproeven door heuren zoon onder heure oogen uit
te rekken.

Soetkin hoorde niet, want zij lag in bezwijming, door de pijnen die
zij uitstond.

Men deed ze met azijn tot heur zelve komen.

Vervolgens werd Uilenspiegel ontkleed en bloot voor de oogen zijner
moeder gesteld. De beul scheerde hem zijn haar af, om te zien of
hij geenerlei tooverteeken verbolgen hield. Toen zag hij op zijn
rug een zwarte geboortevlek. Verscheidene reizen stak hij er in met
een lange naalde; er kwam bloed uit, en hij was van oordeel dat het
litteeken geen tooverije verborg. Op 't bevel van den baljuw, werden
Uilenspiegel's handen gebonden met twee koorden, die rond een wielken
aan een zolderbalk hingen, zoodat de beul, op bevel van de rechters,
hem met geweldige schokken kon optrekken en weer laten vallen; dit
deed hij wel negen reizen, na vooraf aan elk been een gewicht van
vijf en twintig pond te hebben gebonden.

Bij den negenden schok, scheurde de huid en werden polsen en enkels
ontwricht.

--Belijd, sprak de baljuw.

--Neen, antwoordde Uilenspiegel.

Soetkin bezag heuren zoon, doch zij had de kracht niet om te roepen
of te spreken; zij stak alleenlijk heure bloedige handen uit, ten
teeken dat men die folteringen zou staken.

Maar de beul trok Uilenspiegel nogmaals op, om hem te laten vallen. En
het vel der polsen en enkels scheurde erger en zijn voeten werden
nog erger ontwricht; doch hij schreeuwde niet.

Soetkin weende en zwaaide met heure bloedige handen.

--Belijd, sprak de baljuw, en gij krijgt vergiffenis.

--De vischverkooper heeft vergiffenis noodig, antwoordde Uilenspiegel.

--Is 't om met de rechters te spotten? vroeg een der schepenen.

--Spotten? Laas, antwoordde Uilenspiegel, ik heb er geen lust toe,
ge moogt mij gelooven.

Soetkin zag toen den beul, op bevel van den baljuw, een fornuis
aanstoken, terwijl een beulsknecht twee keersen deed branden.

Zij wilde rechtstaan op heure vermorzelde voeten, doch zij viel terug,
uitroepende:

--Weg met dat vuur! Ach! heeren rechters, spaart zijne jeugd. Weg
met dat vuur!

--De vischverkooper! riep Uilenspiegel, heur ziende wankelen.

--Trek Uilenspiegel een voet boven den grond, sprak de baljuw; stel
het fornuis onder zijne voeten en eene keers onder elken oksel.

De beul gehoorzaamde. Het haar onder de okselen knetterde en schroeide
onder de vlamme.

Uilenspiegel schreeuwde, en Soetkin sprak weenend:

--Doe dat vuur weg.

--Belijd, sprak de baljuw, en gij zult verlost zijn. Belijd voor
hem, vrouwe.

En Uilenspiegel sprak:

--De vischverkooper verdient het eeuwige vuur!

Soetkin schudde het hoofd tot teeken dat zij niets te zeggen
had. Uilenspiegel knarste op zijne tanden, en weenend keek Soetkin
met verwilderde oogen naar heuren zoon.

Nochtans toen de beul de keersen uitgeblazen had en het gloeiend
fornuis onder Uilenspiegels voeten plaatste riep zij uit:

--Heeren rechters, hebt medelijden met hem, hij weet niet wat hij zegt.

--En waarom niet? vroeg de baljuw listiglijk.

--Ondervraagt heur niet, heeren rechters, sprak Uilenspiegel, gij
ziet wel dat de smert heur waanzinnig maakt. De vischverkooper heeft
gelogen.

--Spreekt gij als hij, vrouw? vroeg de baljuw.

Soetkin knikte van ja.

--Verbrandt den vischverkooper! riep Uilenspiegel.

Soetkin zweeg, hief den arm tot vermaledijding omhoog.

Doch als zij het fornuis zag gloeien onder de voeten haars zoons,
riep zij uit:

--Heere God! Heilige Maria, die in de hemelen zijt, stelt toch een
einde aan die marteling! Ontferming! Doe het vuur weg!

--De vischverkooper! zuchtte Uilenspiegel nog.

Hij spuwde bloed door den mond en de neusgaten, en hij bleef met
gebogen hoofde, boven de gloeiende kolen hangen.

Toen riep Soetkin:

--Hij is dood! Zij hebben hem vermoord! Ha! hem ook! Rechters, doet
het vuur weg! Laat mij hem in mijne armen nemen, om getweeën te
sterven. Gij weet dat ik niet kan wegloopen, met mijn gebroken voeten.

--Geef de weduw haren zoon, sprak de baljuw.

Vervolgens gingen de rechters tot beraadslaging over.

De hangman maakte Uilenspiegel los en legde hem naakt en met bloed
overdekt op den schoot zijner moeder, terwijl de chirurgijn-baardemaker
de beenderen weer in de gewrichten bracht.

En Soetkin kuste Uilenspiegel, en weende en sprak:

Mijn zoon, arme martelaar! Ik zal u genezen, zoo de heeren rechters het
gedoogen; maar wordt toch wakker, Thijl, mijn zoon! Heeren rechters,
als gij hem gedood hebt, zal ik tot Zijne Majesteit gaan; want gij
hebt gehandeld tegen wet en recht, en gij zult zien wat een arme
vrouwe tegen de boozen vermag. Maar, heeren rechters, laat ons in
vrijheid. De hand Gods valt zwaar op ons neder, en wij zijn slechts
getweeën op de wereld.

Na beraadslaging, brachten de rechters de volgende sententie uit:

"Omme dieswille dat gij, Soetkin, weduwvrouwe van Klaas, en gij, Thijl,
zoon van Klaas, in de wandelinge Uilenspiegel, beschuldigd het goed
geroofd te hebben dat door verbeurdverklaring, niettegenstaande alle
privileges, aan Zijne Koninklijke Majesteit toebehoorde, in weerwil
van de pijnbank en voldoende beproevingen, niets beleden hebt;

"Overwegende het gebrek aan bewijzen, en gezien den erbarmlijken
staat uwer ledematen, vrouwe, en de tortuur die gij onderstaan
hebt, man, verklaart de vierschaar u beiden vrij en staat u toe,
niettegenstaande uwe armoede, te wonen bij hem of heur van de stede,
waar het u believen zal.

"Aldus gewijsd ende geprononcieerd te Damme, den drij en twintigsten
van Wijnmaand van 't jaar onzes Heeren 1558."

--Weest gezegend, heeren rechters, sprak Soetkin.

--De vischverkooper! zuchtte Uilenspiegel.

En moeder en zoon werden op eene kar naar 't huis van Katelijne
gevoerd.




LXXIX.

In dat jaar, het acht en vijftigste der eeuw, kwam Katelijne bij
Soetkin binnen en sprak:

"Dezen nacht heb ik mij laten vervoeren, door middel van eenen stok
met zalve bestreken, naar den Onze-Lieve-Vrouwetoren. Daar zag ik de
sylphen de gebeden der menschen overgeven aan de engelen, dewelke naar
het hoogste der hemelen vlogen om ze naar den troon Gods te dragen. En
heel het hemelrijk was met fonkelende sterren bezaaid. Eensklaps
verhief zich van op een brandstapel een zwarte gedaante, die omtrent
mij op den toren kwam zitten. Ik herkende Klaas gelijk hij was in
zijn leven, met zijne kooldragerskleeren.--Wat doet gij hier op
Onze-Lieve-Vrouwetoren? vroeg hij mij,--Maar gij zelf, antwoordde
ik, waar gaat gij henen, vliegend door de lucht als eene zwaluw?--Ik
ga, sprak hij, naar het oordeel; hoort gij de trompet van den engel
niet? Ik stond dicht tegen hem, en voelde dat zijn lichaam niet vast
was gelijk dat der levenden, maar zoo licht dat ik er doorging als
door een warmen damp. Aan mijne voeten, heel Vlaanderenland door,
flikkerden eenige lichtjes, en ik sprak in mij zelve: Zij die vroeg
opstaan en spade werken, zijn gezegend door God.

En heel den nacht hoorde ik de trompet van den engel schallen. En ik
zag een andere gedaante omhoog stijgen; ze kwam uit Spanje; deze was
oud en afgeleefd; siroop van kweeperen hing nog aan hare lippen. Om de
schouders droeg zij een karmozijnpannen mantel, gevoerd met hermelijn,
op het hoofd eene keizerskroon, in de eene hand eene ansjovis, in de
andere een beker bier.

Zij kwam, zeker uit vermoeienis, op Onze-Lieve-Vrouwetoren
zitten. Nederknielend vroeg ik haar: Gekroonde Majesteit, vol eerbied
lig ik voor U neder, doch ik ken U niet. Van waar komt gij, wat doet
gij op de wereld?--Ik kom, sprak zij, van Sint-Just in Estramadura,
en was keizer Karel de vijfde.--Maar, vroeg ik, waar vaart gij henen,
in dien kouden nacht, door dien hemel vol hagelwolken?--Ik ga, was
het antwoord, naar het oordeel.

Als de keizer zijne ansjovis wilde eten en zijn bier wilde drinken,
schalde de trompet van den engel. En de keizer verhief zich in de
lucht, grommend omdat hij niet voorteten kon. Ik volgde Zijne Heilige
Majesteit. Hij vloog door het luchtruim, hijgend van vermoeienis,
blazend van aamborstigheid, en soms brakend, want hij was van overdaad
gestorven. Wij klommen hooger en hooger, gelijk de pijlen uit eenen
boog van kornoelje-hout. De sterren vlogen ons voorbij en lieten
vurige strepen na. De trompet des engels weerschalde, met een machtig,
klaterend geweld. Bij elk geschal dat door de ruimte klonk, sloeg
de lucht uiteen, alsof een orkaan had geblazen. En aldus werd de weg
gebaand. Duizend uren hoog en nog meer, zagen we Christus, in al zijn
heerlijkheid op een sterrentroon gezeten. Aan zijne rechterzijde, zat
de engel die de daden der menschen opteekent in een bronzen boek, en
aan zijne linkerzijde, Maria, zijne moeder, die de zondaren voorsprak.

Klaas en keizer Karel knielden neder voor den troon.

De engel sloeg den keizer de krone van 't hoofd:--Christus alleen is
keizer, sprak hij.

Zijne Heilige Majesteit scheen verstoord, doch nederig vroeg hij:
Zou ik dit ansjovisje en dit bier niet mogen behouden, want 'k heb
honger van die lange luchtvaart?--Gelijk heel uw leven, antwoordde
de engel; nu, eet en drink maar.

Als hij gedaan had, vroeg Christus:

--Komt gij met zuivere ziele naar 't oordeel?

--Ik hoop het, zoete heer Jezus, want ik heb gebiecht, antwoordde
keizer Karel.

--En gij, Klaas? vroeg Christus; gij beeft niet lijk die keizer.

--Heer Jezus, antwoordde Klaas, geenerlei ziele is teenemaal zuiver,
doch ik heb geen angst voor U, die het opperste goed en de opperste
rechtveerdigheid zijt; maar ik vrees voor mijne zonden, die groot in
getal waren.

--Spreek, aardworm, sprak de engel tot den keizer.

--Heer, antwoordde Karel met verlegene stem, gezalfd door de hand uwer
priesteren, werd ik koning van Castilië, keizer van Duitschland en
Roomsch koning gewijd. Steeds nam ik de instandhouding van de macht,
die van U komt, ter herte, en ik ging de ketterije te keer te vuur
en te zweerd, met put en galg.

--Leugenaar, sprak de engel, gij wilt ons bedriegen. In Duitschland
duldet gij de ketteren, want gij vreesdet hen, maar gij deedt ze
onthalzen, branden, hangen en levend begraven in de Nederlanden,
dáár waar gij vreesdet niet genoeg te erven van die noeste bijen, zoo
rijk aan honig. Honderd duizend menschen werden ter dood gebracht,
niet omdat gij Christus, mijnen Heere, bemindet, maar omdat gij
een dwingeland, een landverwoester waart, die niemand bemindet, dan
zichzelven, en daarna het vleesch, de visch, het bier en den wijn,
want gij waart gulzig als een hond en dronkt als eene spons.

--En gij, Klaas, spreek, zegde Christus.

Doch de engel stond recht en sprak:

--Deze heeft niets te zeggen. Hij was goedhertig, neerstig, gelijk
heel het Vlaamsche volk, dat geerne werkt en geerne lacht, dat den
eed gestand bleef, denwelken het aan zijne vorsten gezworen had, in
den waan dat zijne vorsten ook den hunne zouden houden. Hij had geld,
hij werd in beschuldiging gesteld, en omdat hij een ketter gehuisd had,
werd hij levend verbrand.

Maria sprak toen:--Arme martelaar! doch in het hemelrijk zijn frissche
bronnen, fonteinen die melk en wijn spuiten; kom mee, kooldrager,
ik zal u leiden.

Nogmaals schalde de trompet van den engel en, van uit het diepste des
afgronds, zag ik een schoonen, naakten man verrijzen, met een ijzeren
krone op 't hoofd. En op den band van de krone stond geschreven:
Droef tot op den dag der gerechtigheid.

Hij naderde den troon en zeide tot Christus:

--Ik ben uw slaaf tot dat ik uw meester worde.

--Satan, sprak Maria, eens komt een dag waarop er geen meesters noch
slaven meer zijn, waarop Christus dewelke liefde is, en Satan, die
de hoogmoed is, beteekenen zullen: Macht en kennis.

--Vrouwe, gij zijt goed en schoon, zegde Satan.

En naar den keizer wijzend, vroeg hij aan Christus:

--Wat moet ik hiermee doen?

Christus antwoordde:

--Dien gekroonden worm zult gij brengen in eene zaal, waar al de
foltertuigen verzameld zijn, die onder zijne regeering gebruikt
werden. Telkens dat een arme onschuldige de pijne des waters
verduren zal, die de menschen opzwelt lijk blazen; of de pijne der
keersen, die hunne voetzolen en okselen verbranden; of de pijne
der radbraking, die de ledematen plettert; of de pijne der olie;
telkens dat een vrije ziel op den brandstapel den laatsten snik
zal geven, moet hij op zijne beurt dien dood, die smerten verduren,
opdat hij leere hoeveel kwaad een onrechtveerdig man doen kan, die
over millioenen gebiedt; hij verga in de gevangenissen, hij sterve
op de brandstapels, zuchte in ballingschap, ver van het Vaderland;
hij worde geschavotteerd, ontpoorterd, gegeeseld, gebrandmerkt; hij
weze rijk, opdat de bedezetters hem alles ontnemen; de afgunstige
klage hem aan en de verbeurdverklaring brenge hem ten onder. Gij zult
van hem maken een ezel, opdat hij zachtzinnig, mishandeld en slecht
gevoed weze; een arme, opdat hij bedele en beleedigingen erlange; een
arbeider, opdat hij zich afbeule en niet genoegzaam te eten krijge;
vervolgens, als hij als mensch naar ziel en lichaam alles geleden
heeft, maakt gij van hem een hond, opdat hij braaf weze en slagen
krijge; een slaaf, omdat hij aan den meestbiedende verkocht worde;
een soldenier, opdat hij vechte voor anderen en zich late dooden
zonder te weten waarom. En als hij na afloop van driehonderd jaar
aldus alle smerten, alle ellenden geproefd heeft, zult gij er een
vrijen man van maken. Is hij in dien staat goed, gelijk Klaas was,
geef dan in een lachend, lommerig oord, onder een schoonen boom, de
eeuwige ruste aan zijn gebeente, en zijne vrienden zullen aan zijn
graf komen weenen en bloemen strooien ter zijner gedachtenis.

--Genade, mijn zoon, zeide Maria, hij wist niet wat hij deed, want
macht doet het herte versteenen.

--Geene genade, sprak Christus.

--Ach, zeide Zijne Majesteit, had ik slechts een glas wijn van
Andalusië.

--Kom, sprak Satan, 't is uit met wijn, met gebraad en gevogelte.

En naar het diepste der helle bracht hij de ziele van den armen keizer,
die nog van zijn stukje ansjovis at.

Uit medelijden liet Satan hem begaan. Dan zag ik die Heilige Maagd,
die Klaas naar het hoogste des hemelrijks leidde, daar waar de sterren
met trossen aan 't gewelf hangen. En daar waschten de engelen hem,
tot dat hij schoon en jong was. En zij gaven hem rijstpap met zilveren
lepels. En de hemel sloot zich."

--Hij is in den hemel, sprak de weduwe.

--De assche klopt op mijn hert, zei Uilenspiegel.




LXXX.

Gedurende de volgende drie en twintig dagen, werd Katelijne bleek en
mager, en dorde zij, alsof zij verteerd werd door een inwendig vuur.

Zij riep niet meer: Het vuur! Maakt open! mijn ziel wil er uit! doch
in vervoering sprak zij gedurig tot Nele: Bruid ben ik; bruid moet
gij wezen. Schoon is hij; lang haar; vurige liefde; koude knieën en
koude armen!

En Soetkin bezag haar treuriglijk, en dacht dat het een nieuwe uiting
van waanzin was.

Heure rede vervolgend, sprak Katelijne:

--Driemaal drie is negen, een heilig getal. Hij alleen die 's nachts
fonkelende oogen als katoogen heeft, ziet de geheimenis.

Toen Soetkin heur op een avond zoo bezig hoorde, schudde zij
vertwijfeld het hoofd. Doch Katelijne sprak:

--Vier en drie, ongeluk onder Saturnus; onder Venus, een
bruiloftgetal. Koude armen! Koude knieën! Een herte van vuur!

Soetkin antwoordde:

--Gij moogt van die leelijke heidensche afgoden niet spreken.

Katelijne hoorde dit; zij sloeg een kruis en sprak:

--Gezegend zij de grijze ruiter. Nele moet een man hebben, een schoonen
man met een zweerd, een zwarten man met blinkend gelaat.

--Ja, sprak Uilenspiegel, eene mannenstoverij, voor dewelke ik met
mijn mes de saus zal maken.

Nele bezag teederlijk heuren vriend, want zij was gelukkig omdat hij
jaloersch was.

--Ik wil dien niet, sprak zij.

Katelijne antwoordde:

--Wanneer komt hij, die in 't grijs gekleed, en altijd anders geleersd
en gespoord is?

Soetkin sprak:

--Bidt God voor de uitzinnige.

--Uilenspiegel, zei Katelijne, haal ons twee stoopen dobbele kuite,
terwijl ik de heetekoeken bak.

Soetkin vroeg waarom zij den Zaterdag vierde, naar de wijs van
de Joden.

Katelijne antwoordde:

--Omdat het deeg gerezen is.

Uilenspiegel stond met den grooten kroes van Engelsch tin in de hand,
waarin juist twee stoopen gingen.

--Moeder, vroeg hij, wat moet ik doen?

--Ga, sprak Katelijne.

Daar zij geene meesteresse in huis was, wilde Soetkin niet
tegenspreken. Zij zegde tot Uilenspiegel:--Ga, mijn zoon.

Uilenspiegel liep naar den Staak en kwam terug met twee stoopen
dobbele kuite.

Weldra verspreidde de geur der heetekoeken zich in de keuken, en
allen hadden honger, tot zelfs Soetkin.

Uilenspiegel liet het zich goed smaken. Katelijne had hem een grooten
beker gegeven, zeggende dat, aangezien hij de eenige man, hoofd van
het huis, was, hij meer moest drinken dan de anderen en vervolgens
moest zingen.

En zij lachte heimelijk, maar Uilenspiegel dronk, doch zong niet. Nele
weende als zij Soetkin bleek en gansch ineengevallen zag zitten;
alleen Katelijne was vroolijk.

Na het avondmaal gingen Soetkin en Uilenspiegel naar boven op den
zolder slapen; Katelijne en Nele bleven in de keuken, alwaar heure
bedden nu stonden.

Rond twee uren des morgens als Uilenspiegel, door het zware bier,
al lang sliep, lag Soetkin gelijk alle nachten wakker, Maria biddende
dat zij heur slaap zou zenden, doch Maria aanhoorde heur niet.

Eensklaps hoorde zij den schreeuw van een nachtuil en, uit de keuken,
antwoordde een dergelijke kreet; vervolgens, in de verte, in den
kouter, weerklonken andere kreten en altijd scheen het heur dat men
die in de keuken beantwoordde.

Denkend dat het nachtvogelen waren, sloeg zij er niet verder
acht op. Zij hoorde peerdengehennik en hoevengetrappel op den
steenweg. Zij opende het venster en zag inderdaad twee gezadelde
peerden, die stampend het gras van den berm schoren. Toen hoorde zij
een schreeuwende vrouwenstem, een dreigende mannenstem, herhaalde
slagen, nieuwe kreten, eene deur met gedruis toeslaan en angstige
stappen de trap opklimmen.

Uilenspiegel snorkte en hoorde er niets van; de deur van den
zolder vloog open en, schier naakt, sprong Nele hijgend en snikkend
binnen. En in haast schoof zij eene tafel, stoelen, een oud komfoor en
al het huisraad dat zij vinden kon, tegen de deur. De laatste sterren
verbleekten aan het uitspansel; de hanen kraaiden; zij kondigden den
dageraad aan.

Op het gerucht dat Nele maakte, keerde Uilenspiegel zich om in zijn
bed, zonder wakker te worden.

Nele viel om Soetkin's hals en sprak:--Soetkin, ik ben bang, steek
eene keers aan.

Soetkin deed het en Nele zuchtte voortdurend.

Als de keers aangestoken was, bezag Soetkin het meisje, en ze zag dat
heur hemd op den schouder gescheurd was. Op heur voorhoofd, heure
kaken, in heuren hals zag zij bloedende schrammen, gelijk krabben
van nagels.

--Nele, vroeg Soetkin heur kussend, van waar komen die, schrammen?

Steeds bevend en zuchtend, sprak het meisje:

--Doe ons niet verbranden, Soetkin.

Doch Uilenspiegel werd wakker en wreef zich de oogen, verblind als hij
was door de klaarte der keers. Soetkin vroeg:--Wie is beneden? Nele
antwoordde:--Zwijg, 't is de man dien Katelijne mij geven wil.

Soetkin en Nele hoorden Katelijne plotseling schreeuwen, en heure
beenen knikten van schrik.--Hij slaat heur om mij, sprak Nele.

--Wie is er in huis? riep Uilenspiegel, uit zijn bed
springend. Vervolgens liep hij door de kamer tot dat hij een zwaar
stookijzer gevonden had, dat in eenen hoek lag.

--Niemand, sprak Nele, ga niet beneden, Uilenspiegel!

Maar hij luisterde niet, liep naar de deur, trok stoelen, tafels en
komfoor uit den weg. Katelijne schreeuwde nog altijd beneden. Nele
en Soetkin hielden Uilenspiegel vast, om zijn lijf, bij zijne beenen,
en spraken:--Ga niet beneden, Uilenspiegel, 't zijn duivelen.

--Ja, sprak hij, duivelsche man van Nele, ik breng u het stookijzer
tot gade. Een huwelijk van ijzer en vleesch. Laat mij, beneden!

Doch zij lieten hem niet los, want zij waren sterk, en klampten zich
vast aan de leun van de trap. Maar zij vermochten niet hem te houden,
en, naar beneden vliegend als een lawine, stormde hij de keuken
binnen. Daar zag hij Katelijne bleek en ontdaan, en hoorde haar
zeggen:--Hansken, waarom verlaat gij mij? 't Is mijne schuld niet;
Nele is stout.

Zonder te luisteren, opende Uilenspiegel de deur van het
stalleken. Hij vond er niemand; hij liep naar den kouter en van
daar op den steenweg: van verre zag hij twee dravende peerden in
den morgennevel verdwijnen. Hij wilde ze achterhalen, maar ze renden
gelijk de stormwind, die de droge bladeren opjaagt.

Vol gramschap en vertwijfeling kwam hij binnen, fluisterend:--Zij
hebben heur gehoond! En met een onheilspellend vuur in de oogen, bezag
hij Nele; deze, die huiverend voor Soetkin en Katelijne stond, sprak:

--Neen, Thijl, mijn geliefde, neen.

Dit zeggende, keek zij hem zoo droef en oprecht in de oogen, dat
Uilenspiegel zag dat zij de waarheid sprak. Toen ondervroeg hij heur:

--Van waar kwamen die kreten? Waar gingen die mannen? Waarom is
uw hemde gescheurd? Van waar komen die krabben op uwe kaken en uw
voorhoofd?

--Luister, Uilenspiegel, doe ons niet verbranden. Katelijne--God
beware heur voor de helle--heeft sedert drie-en-twintig dagen een in
't zwart gekleeden, geleersden en gespoorden duivel tot vriend. Zijn
gelaat blinkt lijk het vuur dat 's zomers, als 't warm is, schittert
op de baren der zee.

--Waarom zijt gij vertrokken, Hansken, mijn lieveling? sprak Katelijne,
Nele is stout.

Maar Nele, vervolgende, sprak:--Hij schreeuwt als een nachtuil om zijne
komst te melden. Moeder ziet hem alle Zaterdagen in de keuken. Zij
zegt, dat zijne kussen als ijs zijn en zijn lichaam als sneeuw. Hij
slaat heur als zij niet doet wat hij heet. Eens bracht hij heur enkele
guldens mee, doch hij nam heur al de andere af.

Bij dit verhaal vouwde Soetkin de handen, om voor Katelijne te
bidden. Katelijne sprak blijde:

--Mijn lijf en mijn geest, alles zij hem. Hansken, mijn liefste,
leid mij nog naar den Sabbat. 't Is Nele, die nooit komen wil! Nele
is stout.

--Bij de ochtendschemering toog hij henen, vervolgde het meisje,
's anderen daags vertelde moeder mij dan allerhande zonderlinge
dingen.... Maar bezie mij toch zoo kwaad niet, Uilenspiegel. Gisteren
zeide zij mij dat een schoon heer, in 't grijs gekleed en Hilbert
genaamd, mij ten huwelijk wilde en thuis zou komen, om zich te
toonen. Ik antwoordde dat ik geen man wilde, hij mocht schoon zijn of
leelijk. Zij deed mij opblijven om hen te verbeiden; want zij is dan
geenszins van heure zinnen, als 't minnarijen geldt. Wij waren half
ontkleed, gereed om te gaan slapen; ik sliep op genen stoel. Toen
zij binnenkwamen, werd ik niet wakker. Plotseling voelde ik iemand
die mij omhelsde, mij in mijnen hals kuste. En in den maneschijn zag
ik een helder gezicht, gelijk het schuim der branding in Hooimaand,
bij broeiend weer, en hoorde ik stille fluisteren:--Ik ben Hilbert,
uw verloofde; wees aan mij; 'k zal u rijk maken. Zijn gezicht stonk
naar visch. Ik stiet hem weg; hij wilde mij nemen met geweld, maar
'k was sterker dan tien mannen als hij. Doch hij scheurde mijn hemde,
kwetste mij aan mijn aangezicht en herhaalde: Wees aan mij, 'k zal
u rijk maken.--Ja, zei ik, lijk mijne moeder, wier laatsten duit gij
nemen zult.--Toen verdubbelde hij zijne pogingen, maar hij vermocht
niets tegen mij. Hij was nog leelijker dan een doode, en ik krabde
hem zoo geweldig met mijne nagelen in zijne oogen, dat hij kermde. Zoo
geraakte ik los, en kwam ik bij Soetkin vluchten.

Katelijne herhaalde gedurig:

--Nele is stout. Waarom zijt gij zoo gauw vertrokken, Hansken,
mijn liefste?

--Waar waart gij, slechte moeder, sprak Soetkin, terwijl men de eer
van uw kind wilde rooven?

--Nele is stout, zegde Katelijne. Ik zat bij mijn zwarten heer,
toen de grijze duivel met bloedend gelaat bij ons kwam en sprak: Kom
mede, kameraad, het deugt hier niet; de mannen willen ons doodslaan
en de vrouwen hebben messen aan heure vingeren. Daarop sprongen zij
te peerd en verdwenen zij in den nevel. Nele is stout!




LXXXI.

's Anderen daags, onder 't ontbijt, sprak Soetkin tot Katelijne:

--Gij ziet dat wee en smerte mij overal volgen, wilt gij mij uw huis
doen ontvluchten, met uwe verdoemde hekserijen?

Maar Katelijne sprak:

Nele is stout. Kom weder, mijn Hansken.

Den volgenden Woensdag kwamen de beide duivelen terug. Sedert den
Zaterdag sliep Nele bij de weduwe Vanden Houte, zeggende dat zij
niet langer bij Katelijne mocht vernachten, om Uilenspiegel, mits
dit opspraak zou verwekken.

Katelijne ontving heuren zwarten heer en zijnen vriend in de keete,
die tot waschhuis diende en waar de broodoven stond. En zij onthaalde
ze op ouden wijn en gerookte ossetong. De zwarte sprak tot Katelijne:

--Om een groot werk te verrichten, hebben wij veel geld van noode;
geef ons wat gij kunt.

Toen Katelijne hun maar één gulden geven wilde, dreigden ze heur met
den dood. Maar zij lieten heur los voor twee gouden karolussen en
zeven deniers.

--Komt 's Zaterdags niet meer, zeide zei. Uilenspiegel kent dien dag
en gewapend zal hij u wachten om u beiden te dooden, en na u zou ik
ook sterven.

--Wij zullen den naasten Dinsdag komen, zegden zij.

Dien dag sliepen Uilenspiegel en Soetkin zonder vreeze voor de
duivelen, want zij meenden dat ze 's Zaterdags kwamen.

Katelijne stond op en ging zien in de keete of heure vrienden daar
waren.

Zij was zeer ongeduldig, want sedert dat zij Hansken weergezien had,
was heure uitzinnigheid grootelijks verminderd, daar het minnegekheid
was, naar men zeide.

Als zij hen niet zag, was zij droef en troosteloos; maar in het veld,
uit de richting van Sluis, hoorde zij 't geschreeuw van den nachtuil
en zij ging er op af. En langs eenen dijk van rijshout en graszoden
stappend, hoorde zij aan den anderen kant van dien dijk de beide
duivelen samen in gesprek. De eene zei:

--Ik moet de helft hebben.

De andere antwoordde:

--Gij krijgt niets; wat Katelijne behoort, behoort mij.

Zij vloekten en twisten wie de have en de minne van Katelijne en Nele
al te gader hebben zou. Doch van schrik, bleef Katelijne roerloos
luisteren. Weldra hoorde zij ze vechten en een hunner zeggen: "Dat
ijzer is koud", dan een gereutel en den val van een zwaar lichaam.

Verschrikt, keerde zij naar heure woning terug. Rond twee uren van
den nacht hoorde zij opnieuw het gekras van den nachtuil, doch deze
reis was 't in hare lochting. Zij deed open en zag heuren vriend voor
de deur staan. Zij vroeg hem:

--Wat hebt gij met den andere gedaan?

--Hij zal niet meer komen.

Hij omhelsde en kuste haar. En zij vond hem nog kouder dan gewoonte. En
Katelijne was goed bij heur verstand. Toen hij heenging, eischte hij
twintig gulden, alles wat zij bezat: zij gaf er hem zeventien.

Door nieuwsgierigheid gedreven, keerde zij 's anderen daags terug
naar den dijk, maar zij vond niets dan op het gras eenen bloedplas zoo
groot als eene doodkist, 's Avonds wischte de regen de bloedvlek uit.

En den volgenden Woensdag hoorde zij opnieuw het gekras van den
nachtuil.




LXXXII.

Telkens dat Uilenspiegel geld noodig had om Katelijne 't
gemeenschappelijk verteer te betalen, ging hij 's nachts den steen
opheffen van het gat nabij den waterput, en nam hij eenen karolus.

Op een avond zaten de drie vrouwen te spinnen; Uilenspiegel maakte
eene doos, die de baljuw hem besteld had. Met veel vaardigheid sneed
hij er een schoone jachtpartij op, met eenen koppel Henegouwsche
honden, groote, bloeddorstige honden van Candia, Brabantsche honden
die getweeën loopen en ooreneters genoemd worden, verders allerhande
dikke en magere honden, alsmede mopsen en hazewinden.

Terwijl Katelijne daar was, vroeg Nele aan Soetkin of ze heuren
schat niet elders verbergen zou. De weduwe antwoordde argeloos,
dat hij niet beter kon zijn dan nevens den muur van den steenput.

Rond het midden van den Donderdagnacht, werd Soetkin gewekt door
Bibulus Snuffius, die zeer vinnig blafte, doch niet langdurig. Ze
dacht dat het niets was, en sliep weder in.

Toen Soetkin en Uilenspiegel Vrijdagsmorgens met den dageraad,
opstonden, zagen zij, dat Katelijne tegen heure gewoonte, in de keuken
niet was; en het vuur was niet aangestoken en de melk kookte niet. Zij
waren verwonderd en keken of ze bij toeval in de lochting niet was. In
weerwil van den motregen, zagen zij heur staan met loshangend haar,
in heur hemd, nat en bibberend, zonder te durven binnenkomen.

--Wat doet gij daar, schier naakt, in den regen?

--Ha! zegde ze, ja, ja, groot wonder!

En ze wees naar den hond die, verworgd, levenloos uitgestrekt lag.

Uilenspiegel dacht terstond aan den schat. Hij liep er henen. Het
hol was ledig en de aarde in 't ronde gestrooid.

Hij vloog naar Katelijne, en driftig heur slaande vroeg hij:

--Waar zijn de karolussen?

--Ja, ja, groot wonder! antwoordde Katelijne.

Nele, die toeliep, verdedigde heure moeder en smeekte:

--Sla niet, Uilenspiegel!

Hij hield op met slaan. Soetkin kwam toen bij en vroeg wat er scheelde.

Uilenspiegel wees naar den verworgden hond en het ledige gat.

Soetkin werd doodsbleek en sprak:

--Gij beproeft mij wel hard, heer God. Mijn arme voeten!

En zij zegde dat, om de smert die zij uitstond en om de pijniging
die zij nutteloos ondergaan had voor de gouden karolussen. Nele, als
ze Soetkin zoo verduldig zag, begon vertwijfeld te weenen. Katelijne
zwaaide met een stuk perkament en vervolgde:

--Ja, groot wonder is er geschied. Dezen nacht is hij gekomen, braaf
en schoon. Op zijn gelaat had hij dien witten schijn niet meer, die mij
steeds zoo verschrikte. Hij sprak mij liefdevol aan. Ik was verrukt en
mijn hert hoorde hem toe. Hij zegde mij: Nu ben ik rijk en weldra breng
ik duizend gouden florijnen.--Ja, zeide ik, dat doet mij meer genoegen
voor u dan voor mij, Hansken, mijn liefste.--Maar is hier niemand,
in huis, dien gij liefhebt en voor wien ik iets doen kan?--Neen,
antwoordde ik, zij die hier zijn, hebben niemand van noode.--Zijn
Soetkin en Uilenspiegel dan rijk? vroeg hij.--Zij leven zonder
iemands hulpe, antwoordde ik.--Niettegenstaande de verbeurte?--Daarop
antwoordde ik dat gij liever de pijnbank onderstaan hadt, dan uwe have
te laten ontnemen.--Dat wist ik, sprak hij. En stille en zachtjes
giegelend, begon hij te spotten met den baljuw en de schepenen,
omdat zij u geenerlei belijdenis konden ontrukken. En toen lachte ik
insgelijks. 't Ware ook dom geweest, sprak hij, van hunnen schat in
het huis te verbergen.... Ik lachte. "Of in den kelder?" Ik knikte
van neen. "Of in de lochting?" Ik antwoordde niet.--Ha! sprak hij,
dit ware zeer onvoorzichtig.--Integendeel, sprak ik, want water noch
muur zullen iets uitbrengen. En hij lachte voort.

--Dien nacht vertrok hij vroeger dan gewoonte, na mij een poeierken
gegeven te hebben met hetwelk ik, naar hij zeide, naar den schoonsten
sabbat zou gaan. Ik deed hem uitgeleide tot aan de deur van de
lochting, en ik was slaapdronken. Ik ging, zooals hij gezeid had,
naar den sabbat en kwam eerst met de ochtendschemering weder, hier
ter plaatse, waar ik den hond verworgd en het gat open vond. Dat is
een wreede slag voor mij, want ik beminde hem teederlijk en schonk
hem mijne ziel. Maar ik zal u alles geven wat ik bezit, en dag en
nacht werken om u te onderhouden.

--Ik ben als ijzer op het aambeeld; God en een dief treffen mij
tegelijk, zegde Soetkin.

--Zóó moogt gij niet spreken, antwoordde Katelijne; hij is geen dief,
maar een duivel. Ten blijke zal ik u het perkament toonen, dat hij
in de lochting achterliet. Daarop staat geschreven: "Vergeet nimmer
mij te dienen. Binnen driemaal twee weken en vijf dagen, krijgt gij
dobbel terug. Koester geen twijfel, of het kost u het leven."--En
hij zal woord houden.

--Arme zinnelooze! sprak Soetkin.

Het was heur laatste verwijt.




LXXXIII.

De twee weken waren driemaal voorbij en de vijf dagen insgelijks,
maar de duivel kwam niet terug. Doch Katelijne wanhoopte niet.

Soetkin werkte niet meer; zij stond gedurig bij het vuur, gebogen
en kuchende. Nele gaf heur de beste en geurigste kruiden; maar dat
alles kon niet baten. Uilenspiegel ging de hut niet meer buiten,
uit vreeze dat Soetkin onderwijl stierf.

Vervolgens kon zij niet meer eten of drinken zonder over te geven. De
chirurgijn-baardemaker kwam en deed heur eene lating; en toen was zij
zoo zwak, dat zij van heure bank niet meer kon opstaan. Eindelijk,
uitgeteerd van verdriet en van smert, sprak zij op een avond:

--Klaas, mijn man! Thijl, mijn zoon! Dank, de Heere neemt mij tot zich!

En zij blies den laatsten ademtocht uit.

Katelijne dorst bij heur niet waken, daarom deden Uilenspiegel en
Nele het getweeën, en heel den nacht baden zij voor de arme ziele.

Bij de ochtendschemering vloog een zwaluw het open venster binnen.

--De vogel der zielen, sprak Nele, dat is een goed teeken: Soetkin
is in den hemel.

De zwaluw vloog driemaal rond de kamer en verdween met een schellen
kreet.

Vervolgens kwam een andere zwaluw binnen, grooter en zwarter dan de
eerste. Zij vloog rondom Uilenspiegel en deze sprak:

--Vader en moeder, de assche klopt op mijne borst, ik zal doen wat
gij vraagt.

En de tweede zwaluw vloog kwetterend heen als de eerste. De oosterkim
verbleekte. Uilenspiegel zag duizenden zwaluwen rakelings over de
weide vliegen, en de zonne rees op.

En Soetkin werd op het armenveld begraven.




LXXXIV.

Sedert Soetkin's dood, liep Uilenspiegel droomend, treurig of
grammoedig de keuken op en neer; hij luisterde niet meer, at en dronk
wat men hem voorzette, zonder zelf iets te nemen. En dikwijls stond
hij 's nachts op.

Te vergeefs sprak de zoete stem van Nele hem moed in, te vergeefs zeide
Katelijne hem, dat zij wist dat Soetkin bij Klaas in den hemel was;
steeds antwoordde Uilenspiegel:

De assche klopt.

En hij geleek een waanzinnige en Nele weende als zij hem zoo
naargeestig zag.

En de vischverkooper bleef alleen in zijn huis als een vadermoorder,
en dorst slechts 's avonds buitenkomen; want de mannen en vrouwlieden
die hem zagen, jouwden hem uit en heetten hem moordenaar, en de
kleine kinderen vluchtten voor hem, daar men hun gezegd had, dat hij
de hangman was. En geschuwd door een iegelijk, dwaalde hij eenzaam in
't ronde, zonder eene taveerne te durven binnengaan; want men wees
er hem met den vinger, en, al bleef hij er slechts een korte wijl,
de andere klanten ledigden hun glas en gingen heen.

Daarom zagen de weerden hem noode komen, en zij sloten liever de deur
vóór zijn neus. Toen deed de vischverkooper hun nederig zijn beklag,
maar zij antwoordden hem, dat zij wel mochten tappen, maar dat zij
daartoe geenszins waren gedwongen.

Eindelijk ging de vischverkooper drinken in den Rooden Valk, eene
kleine herberg buiten de stad, aan de vaart naar Sluis. Daar wilde
men hem bedienen, want 't waren arme lieden, wien alle geldstukken
welkom waren. Maar de weerd of de weerdin uit den Rooden Valk spraken
nooit een woord tot hem. Daar waren twee kinderen en een hond: als
de vischverkooper de kleinen wilde streelen, liepen zij weg; en als
hij den hond riep, toonde deze brommend zijn tanden.

Op een avond stond Uilenspiegel aan de zulle; als Mathijssen, de
kuiper, hem zoo droomerig zag, zeide hij hem:

--Gij moet werken met uwe handen, om de smert te vergeten.

--De assche van Klaas klopt op mijne borst, antwoordde Uilenspiegel.

--Ha! zei Mathijssen, de ellendige vischverkooper leidt een nog
treuriger leven dan gij. Niemand spreekt tot hem en elkeen schuwt hem,
zoodat hij genoodzaakt is bij de arme lieden uit den Rooden Valk te
gaan, om zijn kapperken bruinbier in eenzaamheid te drinken. 't Is
een groote straffe.

--De assche klopt! sprak nogmaals Uilenspiegel.

Dien zelfden avond, terwijl het negen uren sloeg op
Onze-Lieve-Vrouwetoren, ging Uilenspiegel naar den Rooden Valk en,
ziende dat de vischverkooper er niet was, ging hij traagzaam slenteren
onder de boomen langs de vaart. 't Was een heldere maneschijn.

Hij zag den moordenaar komen.

Juist als hij voorbij hem kwam, kon hij hem van dichtbij zien, en,
luide sprekend lijk de menschen die in alleenigheid leven, hooren
zeggen:--Waar mogen die karolussen steken?

--Waar de duivel ze gevonden heeft, antwoordde Uilenspiegel, en meteen
gaf hij hem een vuistslag in 't gezicht.

--Laas! sprak de vischverkooper, ik herken u, gij zijt de zoon, heb
medelijden, ik ben oud en krachteloos! Wat ik deed was geenszins uit
haat, maar om Zijne Majesteit te dienen. Schenk mij vergiffenis. Ik
zal u het huisraad afstaan dat ik gekocht heb, en gij moet er mij
geen oortje voor geven. Is 't niet genoeg? Ik kocht het voor zeven
gouden florijnen. Ik geef u alles en nog een halven gulden daarbij,
want ik ben niet rijk, dat moet gij niet denken.

En knielend vroeg hij vergiffenis.

Als Uilenspiegel hem zoo verachtelijk, zoo bang en zoo lafhertig zag,
smeet hij hem in de vaart.

En hij toog henen.




LXXXV.

De lichamen der slachtoffers walmden op de brandstapels. Aan Klaas
en Soetkin denkend, weende Uilenspiegel eenzaam in stilte.

Op een avond ging hij bij Katelijne, om heur hulp en raad te vragen.

Zij was alleen met Nele, die naaide bij het licht. Op 't gerucht
dat hij bij zijn binnenkomen maakte, hief Katelijne het hoofd op,
als iemand die uit een zwaren slaap schiet.

Hij sprak:

--De assche van Klaas klopt op mijne borst, ik wil Vlaanderenland
verlossen. Ik vroeg het aan den grooten God van hemel en aarde,
doch hij antwoordt mij niet.

Katelijne sprak:

--De groote God kon u niet hooren; gij moet eerst tot de sylphen
spreken, die tusschen hemel en aarde zweven en de klachten der menschen
ontvangen en overdragen aan de engelen, om ze naar den troon des
hemelrijks te brengen.

--Help mij daartoe, sprak hij, en 'k zal u met mijn bloed betalen,
als 't noodig is.

Katelijne sprak:

--Ik zal u helpen, zoo een meisje dat u bemint, u wil medenemen naar
den Sabbat der Lentegeesten, het Pascha van 't Levenssap.

--Ik zal hem meenemen, zegde Nele.

In een kristallen beker goot Katelijne een grijsachtig vocht, dat zij
streek aan hunne slapen, neusgaten, palmen der handen en polsen; zij
deed hun elk een snuifken witte poeier eten, en zei dat ze elkander
in de oogen moesten zien, opdat hunne zielen één zouden worden.

Uilenspiegel keek Nele aan, en de zoete oogen van 't meisje ontstaken
in hem een blakerend vuur; toen begon het vocht te werken en hij
voelde als duizenden spelden in zijn lijf steken.

Vervolgens ontkleedden zij zich, en zij waren schoon in hunne
schamelheid, verlicht door de lamp: hij in al zijn fiere kracht, zij
in heure liefelijke bevalligheid. Maar reeds half ingeslapen, zagen
zij elkander niet. Toen legde Katelijne het hoofd van het meisje in
Uilenspiegels arm en zijne hand op heur hert.

En zoo bleven zij naast malkander liggen.

Het scheen hun beiden, dat hunne elkander rakende lichamen de zachte
warmte hadden van de zonne, in de maand van de rozen.

Zij stonden op, gelijk zij later zeiden, klommen op de vensterbank,
vlogen van daar in de ruimte en voelden, dat de lucht hen droeg als
het water de schepen draagt.

Toen zagen zij niets meer, noch de aarde waar de arme menschenkinderen
sliepen, noch den hemel waarin zoo even de wolken voor hunne voeten
holden. En zij zetten den voet op Sirius, de koude sterre. Van daar
werden zij op de pool geworpen.

Daar zagen zij, niet zonder schrik, een naakten reus, den reus
Winter, met ruig haar, op schotsen, met den rug tegen eenen ijsmuur
gezeten. Een huilende troep ijsberen en zeehonden zwommen in de
plassen rond hem. Met heesche stemme riep hij op: hagel, sneeuw, koude
regenbuien, donderwolken, rosse, stinkende nevelen, dwarrelwinden en de
snerpende noordenwinden. En allen woedden te gelijk in dit akelig oord.

De reus lachte al dien rampspoed toe en vlijde zich neer op de bloemen
die zijne hand verwelkt, op de bladeren die zijn adem verdroogd
had. Dan zich vooroverbuigend en den grond met zijne nagelen krabbend,
er met de tanden in bijtend, groef hij een hol, ten einde het hert
der aarde te bereiken, om het te verslinden, en de lommerige bosschen
tot zwarte kolenbedden, de gouden korenaren tot verbrand stroo, de
vruchtbare landouwen tot dorre vlakten te verkeeren. Doch het herte
der aarde was van vuur, en hij dorst het niet naderen, maar trok zich,
bevreesd, terug.

Daar troonde hij als koning, en ledigde hij zijnen beker traan, te
midden van de beren en zeehonden en van de geraamten dergenen die hij
doodde op zee, op het land en in de hutten der armen. Blijde hoorde
hij de beren brommen, de zeehonden huilen, de beenderen kletteren van
de geraamten van menschen en beesten, onder de klauwen van gieren
en raven, die er een laatsten hap vleesch aan zochten, alsook het
gekrakkrak van de ijsschotsen, die in het doode water tegen elkander
stootten.

En de stem van den reus was gelijk het geloei van den orkaan, het
geschuifel van den storm en 't gehuil van den wind in de schoorsteenen.

--Ik heb koude en ben bang, zei Uilenspiegel.

--Hij vermag niets tegen de geesten, antwoordde Nele.

Plotseling ontstond een groote beweging onder de zeehonden, die ijlings
in 't water trokken, onder de ijsberen, die, met neerhangende ooren,
jammerlijk bromden en onder de raven, die, krassend van angst in de
wolken verdwenen.

En nu hoorden Nele en Uilenspiegel de doffe slagen van den stormram
tegen de muren van ijs, waarop de reus Winter gezeten was. En de muur
kloofde en waggelde op zijne grondvesten.

Doch de reus Winter hoorde niets, en hij huilde en tierde blijmoedig,
vulde en ledigde zijnen beker en zocht naar het hert van de aarde om
het te verstijven, maar hij dorst het niet aanraken.

De slagen weerklonken harder en harder, de muur spleet meer en meer,
en een regen van ijsscherven viel rondom hem.

En de beren gromden jammerlijk en de zeehonden huilden in de doode
wateren.

De muur stortte in, de zonne werd zichtbaar; een schoone, jonge man
met een gouden akst in de hand, daalde neder. Die man was Lucifer,
koning Lente.

Als de reus hem bemerkte, wierp hij zijn beker traan weg en smeekte
hem niet te dooden.

En bij den zoelen adem van koning Lente, verloor de reus Winter al
zijne kracht. Toen nam de koning een diamanten keten, en hij bond er
den reus mee vast aan de pool.

Dan riep hij, doch teeder en liefdevol. En uit den hemel daalde een
schoone, blonde vrouw. Zij zette zich nevens den koning en zeide
tot hem:

--Sterke man, gij zijt mijn overwinnaar.

Hij antwoordde:

--Hebt gij honger, eet; hebt gij dorst, drink; zijt gij bang, kom
bij mij: ik ben uw man.

--Ik heb honger en dorst alleen naar u, zegde zij.

De koning riep nog zeven reizen met verschrikkelijke stemme. En er was
een groot gedruisch van donders en bliksemen, en achter hen verrees een
gehemelte van zonnen en sterren. En beiden zetten zich op den troon.

Toen weerklonk een geroep des konings en der vrouwe; hun edel gelaat
verroerde niet, en hun gebaar was niet strijdig met hunne kracht
en waardigheid.

Op die kreten ontstond een golvende beweging in den grond, in den
harden steen, in de ijsschotsen. En Nele en Uilenspiegel hoorden een
gerucht lijk dat, welk reusachtige vogelen zouden maken, die de schaal
van ontzaglijke eieren wilden doorpikken.

En, in die rijzing en daling van den grond, gelijk de baren der zee,
waren vormen als van een ei.

Eensklaps rezen allerwegen boomen op, wier dorre takken zich
strengelden, wier stammen wankelden lijk dronken mannen. Dan scheidden
zij, een groote ruimte tusschen zich latend. Aardgeesten stegen uit den
geschokten grond; uit het diepst van het woud kwamen de boschgeesten,
uit de naburige zee de watergeesten.

Uilenspiegel en Nele zagen daar de ruige, gebochelde, grijnzende en
mismaakte dwergen, die de schatten bewaren; de vorsten der gesteenten;
de boschmannen, die leven als boomen en, in stee van mond en maag,
onderaan 't gezicht vezelige wortels dragen, om aldus hun voedsel uit
de aarde te zuigen; de bergvorsten, die niet kunnen spreken, hert noch
ingewand hebben, zich bewegen als ledepoppen in schittergewaad. Daar
waren dwergen van vleesch en beenderen, met hagedissteerten en
kikvorschkoppen, met eene lanteern op het hoofd, die 's nachts op
de schouders van de dronken voetgangers of vreesachtige reizigers
springen, en, hunne lanteern zwierend, hen leiden en brengen naar
sompen of spelonken, terwijl de arme verdwaalden meenen dat die
lanteern de keerse is, die flikkert in hunne woning.

Daar waren ook de bloemenmaagden, dochteren vol vrouwelijke kracht
en gezondheid, fier over heure schoonheid, en die heur krachtig haar
als een zijden mantel openspreidden.

Hare vochtige oogen schitterden als perelmoer in het water, het vleesch
van heur lichaam was vast, blank, zacht gebronsd door het licht;
uit heuren rooden mond kwam een adem, geuriger dan seringabloesem.

Zij zijn het, die, minneziek, 's avonds in waranden en hovingen
zwerven, ofwel in het diepst der bosschen, langs de lommerige paden,
op zoek naar de ziele eens mans, om de genieting der minne te
smaken. Zoodra een jongeling en zijne geliefde voorbij haar komen,
beproeven zij het meisje te dooden, of blazen het weerstand biedende
meideken liefdelust in, opdat zij heuren minnaar gehoor geve; want
dan krijgt de bloemenmaagd de helft van de kussen.

Nele en Uilenspiegel zagen ook uit het diepste der hemelen de
beschermgeesten der sterren nederdalen, alsmede de geniën van wind,
van dauw en van regen, gevleugelde jongelingen die de aarde bevruchten.

Dan verschenen aan alle punten des hemelrijks de vogelen der
zielen, de lieve zwaluwen. Met hunne komst scheen het licht
heller. Bloemenmaagden, vorsten der steenen en der bergen,
boschmannen, water-, vuur- en aardgeesten riepen allen te gader:
Licht! levenssap! glorie aan den koning Lente!

Hoewel het geschal van dien roep machtiger was dan 't geloei van de
woedende zee, en van 't losgeketend orkaan, klonk het als een zoete
muziek in de ooren van Nele en Uilenspiegel, die, stom en onbeweeglijk,
achter den knoestigen stam van een eikeboom neergehurkt zaten.

Maar heviger werd hunne vrees, toen de geesten, bij duizenden
zich zetten op zetels van reusachtige spinnekoppen, kikvorschen met
olifantssnuiten, ineengekronkelde slangen, krokodillen die recht op den
steert stonden en eene menigte geesten in den muil hielden, slangen die
meer dan dertig dwergen van beider kunne schrijlings op haar golvend
lijf droegen, en wel honderdduizend insecten, grooter dan reuzen,
gewapend met zweerden, spiesen, zeisen, vorken met zeven tanden,
en allerhande moordtuigen. Zij vochten met een ijselijk gedruisch,
en de sterken verslonden de zwakken, tot bewijs dat de Dood uit het
Leven en het Leven uit den Dood komt.

En uit heel de wemelende, dichte, verwarde menigte van geesten steeg
een gedruisch op, dat leek op het dof gerol van een verren donder en
het gerucht van honderden wevers, vollers, slotenmakers, die samen
aan den arbeid zijn.

Plotseling verschenen de geesten van het levenssap; zij waren kort,
dik, met lendenen zoo breed als het Heidelbergsche vat, dijen zoo dik
als wijnmudden, en spieren zoo forsig en sterk, dat men zou gezegd
hebben dat hun lichaam gemaakt was van groote en kleine eieren, het
een op het andere, met een rood vel overdekt, vettig en blinkend als
hun dunne baard en rossig haar; en in de handen hielden zij groote
bekers met een vreemdsoortig vocht.

Als de geesten ze zagen komen, ontstond er onder hen een groote
trilling van vreugde; boomen en planten bewogen zich en de aarde
scheurde open om te drinken.

En de geesten van het levenssap schonken wijn: terstond begon alles
te botten, te groeien, te bloeien; het gras was vol gonzende diertjes,
en de lucht vol vogels en pepels; de geesten schonken voort, en die van
beneden ontvingen den wijn zooals zij konden: de bloemenmaagden openden
den mond, of sprongen op heur rosse schenkers en kusten ze, om meer te
krijgen; de eenen vouwden de handen smeekend te zamen; anderen zaten
stille en lieten zich met wijn beregenen; doch allen, zoo dorstigen
als gelaafden, zochten den wijn en bij elk dropje dat zij kregen,
werden zij levendiger. En daar waren geene grijsaards, doch allen,
schoonen of leelijken, waren vol vinnige kracht en levende jeugd.

En zij lachten, riepen, zongen, terwijl zij elkander achtervolgden in
de boomen als eekhorentjes, in de lucht als vogelen; en elke man zocht
zijn wijfje en verrichtte onder Gods hemel het heilige werk der natuur.

En de geesten van het levenssap brachten aan den koning en aan de
koningin een grooten beker wijn. En de koning en de koningin dronken,
en kusten elkander.

Vervolgens omhelsde de koning de koningin, en hij stortte den beker
uit op boomen, bloemen en geesten, en riep:

--Glorie aan het Leven! glorie aan de vrije Lucht! glorie aan de
Kracht!

En allen riepen:

--Glorie aan de Natuur! glorie aan de Kracht!

En Uilenspiegel nam Nele in zijne armen. Aldus ineengestrengeld,
begon een dans, als een warreldans van droge bladeren in de macht
eener windhoos, in denwelke alles in beweging was, boomen, planten,
insecten, vlinders, hemel en aarde, koning en koningin, bloemenmaagden,
bergvorsten, watergeesten, gebochelde dwergen, vorsten der steenen,
boschmannen, lanteerndragers, beschermgeesten der sterren en de honderd
duizenden gruwelijke insecten, die hunne spiesen, zeisen en vorken met
zeven tanden ondereenmengden. En aan dien duiveldans, hollend door
de ruimte, namen de zon, de maan, de planeten, de sterren, de wind,
de wolken insgelijks deel.

De eik, waaraan Nele en Uilenspiegel zich vastklemden, draaide in de
dwarreling mee, en Uilenspiegel zeide tot Nele:

--Liefste, nu gaan wij sterven.

Een geest hoorde hen, en zag dat zij stervelingen waren.

--Aardelingen, sprak hij, aardelingen in dit oord!

En hij trok hen van den boom en smeet hen in 't gedrang. En
Uilenspiegel en Nele vielen zachtjes op den rug van de geesten,
die ze kaatsend naar malkander smeten en spraken:

--Gegroet, menschenkinderen! Welkom, aardwormen! Wie wil het knaapje
en het meideken? Zij komen ons bezoeken, de weekelingen.

--Genade! riepen Nele en Uilenspiegel, die van den een naar den
anderen vlogen.

Maar de geesten luisterden niet, en beiden vlogen in't ronde, met het
hoofd omlaag en de beenen omhoog, lijk pluimpjes in den winterwind,
terwijl de geesten spraken:

--Glorie aan de mannekens en aan de vrouwkens! Dat zij dansen als wij!

De bloemenmaagden wilden Uilenspiegel en Nele van malkander scheiden;
zij sloegen heur en hadden ze gedood, als de koning geen einde aan
den dans gesteld had, met deze woorden:

--Men brenge die beide aardwormen vóór mij!

Zij werden gescheiden; en elke bloemenmaagd trachtte Uilenspiegel
aan de andere te ontrukken, zeggende:

--Thijl, wilt gij sterven voor mij?

--Fluks, antwoordde Uilenspiegel.

En de boschgeesten, die Nele droegen, zeiden:

--Waarom zijt gij geene ziel lijk wij, wij zouden u nemen!

--Hebt geduld, antwoordde Nele.

En zoo kwamen zij vóór den troon van den koning; en zij beefden,
als zij zijn gouden akst en zijn ijzeren kroon in het gezicht kregen.

Hij vroeg hun:

Wat komt gij hier doen, nietelingen?

Zij antwoordden niet?

--Ik ken u, tooveresseknop, voegde de koning er bij, en ook u,
kooldragerswelp; maar zoo gij door allerlei toovermiddelen in deze
werkplaats der Natuur zijt gedrongen, waarom houdt gij nu den bek
als volgepropte kapoenen?

Nele beefde als zij den verschrikkelijken duivel bezag, doch
Uilenspiegel hernam zijne mannelijke stoutmoedigheid en antwoordde:

--De assche van Klaas klopt op mijn hert. Doorluchtige vorst, in
naam des Pausen maait de Dood de krachtigste mannen, de bevalligste
vrouwlieden van Vlaanderenland; zijne privileges zijn verbroken, zijne
keuren vernietigd, de hongersnood ondermijnt het, zijne wollenwevers
verlaten het, om in den vreemde vrijen arbeid te zoeken. Het zal
sterven, als men het niet ter hulpe komt. Ik ben maar een arme
nieteling, die op de wereld kwam als een iegelijk, leefde als hij
kon, onvolmaakt, bekrompen, onwetend, geenszins deugdzaam, en de
menschelijke of goddelijke gratie teenemaal onweerdig. Doch Soetkin
stierf ten gevolge van de pijnen der tortuur en van droefheid, en
Klaas werd in een schrikkelijk vuur verbrand. Ik wilde hen wreken,
en ik deed het eenmaal; ik wilde dien bodem, bezaaid met de beenderen
zijner telgen, gelukkig zien, en vroeg aan God den dood zijner beulen,
maar hij aanhoorde mij niet. Moede van klagen, aanriep ik u door de
tooverkracht van Katelijne, en wij vallen u te voet, mijn bevende
gezellinne en ik, om u te bidden dit rampzalige land te verlossen.

De vorst en zijne vrouwe antwoordden samen:


    Door den krijg en door het vuur,
    Door den dood en door het zweerd,
      Zoek de Zeven.

    In den dood en in het bloed,
    In de puinen en de tranen,
      Vind de Zeven.

    Leelijk, wreede, boos, wanstaltig.
    Echte geesels der arme aarde,
      Brand de Zeven.

    Wacht, luister en zie,
    Zeg ons, kleine, zijt ge in uw schik niet?
      Vind de Zeven.


En al de geesten zongen samen:


    In den dood en in het bloed,
    In de puinen en de tranen,
      Zoek de Zeven.

    Wacht, luister en zie,
    Zeg ons, kleine, zijt ge in uw schik niet?
      Vind de Zeven.


--Maar, sprak Uilenspiegel, Hoogheid en gij, heeren geesten, ik
begrijp niets van uwe tale. Zeker spot gij met mij.

Doch zonder hem te aanhooren, gingen zij voort:


    Raakt het Noorden
    Kussend het Westen
    Rampspoed is uit.
    Vind de Zeven
    En den Gordel.


En dat met zooveel overeenstemming en machtigen maatklank, dat de aarde
beefde en de hemelen sidderden. En de vogelen floten, de raven krasten,
de musschen tjilpten, de nachtuilen kloegen en vlogen uitzinnig in
het ronde. En de dieren der aarde, leeuwen, slangen, beren, herten,
gemsen, wolven, honden en katten brulden, sisten, bromden, schreeuwden,
huilden, jankten, mauwden verschrikkelijk.

En de geesten zongen:


    Wacht, luister en zie,
    Heb de Zeven lief
      En den Gordel.


En de hanen kraaiden, en al de geesten verzwonden, buiten een booze
bergvorst, die Uilenspiegel en Nele elk bij een arm nam en ze vrij
onzacht naar beneden smeet.

Zij lagen naast elkander als om te slapen, als de frissche morgenwind
hen wakker maakte.

En Uilenspiegel zag Nele's lief gezicht, in gouden glans door de
rijzende zonne bestraald.







TWEEDE BOEK.


I.

Dien morgen, 't was in Herfstmaand, nam Uilenspiegel zijnen stok,
drie gulden die Katelijne hem gaf, eene snede brood met een stuk
verkenslever, en hij vertrok naar Antwerpen, op zoek naar de
Zeven. Nele sliep.

Onderwege werd hij gevolgd door een hond, die op den reuk van de
lever afkwam. Uilenspiegel wilde den hond wegjagen, maar deze bleef
halstarrig meeloopen, waarop Uilenspiegel hem de volgende rede hield:

--Hondje, mijn beestje, gij handelt verkeerd met uw huis te verlaten,
alwaar goede porties, lekkere kliekjes, mergbeenderen u wachten, om op
goed valle 't uit een zwerver te volgen, wien het zelfs aan wortelen
zal ontbreken om u toe te werpen. Geloof mij, onbezonnen hondje,
keer terug naar uwen baas. Vermijd regen, sneeuw, hagel, mist, ijzel
en andere liefelijkheden, die het lot van de zwervers zijn. Blijf u
warmen in den hoek van den heerd bij het lustige vuur, en laat mij
voortgaan in modder, in stof, in koude en hitte, heden gestoofd en
morgen bevroren, des Vrijdags verzadigd en 's Zondags verhongerd. Keer
terug van waar gij komt, hondje van weinig ondervinding, en gij zult
verstandig handelen.

Het beest scheen Uilenspiegel maar niet te begrijpen. Het
kwispelsteertte en sprong zoo hoog als het kon. Uilenspiegel meende
dat het uit vriendschap was, maar vergat de lever, die in zijne
tassche stak.

Hij ging voort, de hond volgde. Als zij alzoo bijna een uur gegaan
hadden, zagen zij op de baan eene kar, bespannen met een ezeltje,
dat den kop liet hangen. Op den berm van den weg, tusschen twee
distelstruiken, zat een man met in eene hand eenen hamelbout en in
de andere eene bottel, waaraan hij zich goed deed. Als hij niet at
of dronk, zuchtte en weeklaagde hij.

Uilenspiegel stond stil, de hond insgelijks. Bout en lever riekend,
beklom hij den berm. Daar ging hij nabij den man op zijn achterste
zitten, krabde aan zijn wambuis, om beetjes te vragen, doch de man
stiet hem terug met den elleboog, en zuchtte erbarmelijk met den bout
omhoog. De hond jankte uit begeerlijkheid; en de ezel, grammoedig
omdat hij, ingespannen, de distelen niet kon bereiken, begon te balken.

--Wat is er, Jan? vroeg de man tot den ezel.

--Niets, antwoordde Uilenspiegel, maar hij zou zich willen vergasten
aan de distelen, die naast u groeien; en deze hond zou evenmin boos
zijn, nadere kennis te maken met het been, dat gij in de hand hebt. In
afwachting daarvan, kan hij beginnen met de lever, die ik hier heb.

Toen de hond de lever binnen had, keek de man naar zijnen bout. Hij
beet er het laatste vleesch af, gaf toen het been aan den hond,
die er zijn pooten op stelde en het trachtte te kraken.

Toen keek de man naar Uilenspiegel.

Deze herkende Lamme Goedzak, van Damme.

--Lamme, vroeg hij, waarom zit gij hier te eten, te drinken en te
jammeren? Heeft een soldaat u misschien eene schudding gegeven?

--Laas! mijne vrouw! sprak Lamme.

Hij wilde zijne bottel wijn ledigen, maar Uilenspiegel hield hem tegen.

--Drink zoo niet, sprak hij, al te haastig doet geen deugd aan de
nieren. Beter zou het komen aan hem, die geene bottel op zak heeft.

--Ge spreekt goed, antwoordde Lamme, maar zoudt gij beter drinken?

En hij langde hem de bottel.

Uilenspiegel nam ze, dronk en gaf ze hem terug.

--Ge moogt mij Maraan heeten, sprak hij, als er genoeg overbleef voor
eene musch.

Lamme bezag de bottel, zuchtte en nam uit zijne tassche een andere
flesch en een stuk worst, dat hij in schijfjes sneed en weemoedig opat.

Eet gij standvastig, Lamme? vroeg Uilenspiegel.

--Veelal, mijn jongen, antwoordde Lamme, maar 't is om mijne droeve
gedachten te verjagen. Waar zijt gij, vrouwtje? weeklaagde hij,
terwijl hij een traan uit het het oog wischte.

En hij sneed tien schijfjes van de worst.

--Lamme, sprak Uilenspiegel, eet niet zoo gulzig en zonder medelijden
voor den armen pelgrim.

Lamme reikte hem weenend vier schijfjes en Uilenspiegel zuchtte om
den fijnen smaak.

Maar steeds weenend en etend, sprak Lamme:

Mijne vrouw, mijne goede vrouw, ze was zoo zoet en zoo goed gevormd van
lichaam, licht als de vlinder, vlug als de bliksem, en zij zong als een
leeuwerik! Maar toch hield zij te veel van schoone kleeren. Laas! zij
hingen heur zoo goed! Immers, hebben de bloemen ook geen schitterenden
dos? Zie, hadt gij heure handjes gezien, die tot streelen gemaaakt
schenen, nooit hadt gij heur potten of pateelen laten aanraken. Het
vuur van de keuken hadde heure hagelblanke tint verzengd. En die
oogen! Ik moest ze maar bezien, en ik verging van liefde.--Drink
een slok wijn, Thijl, 'k zal na u drinken.--Ha! waarom is zij niet
dood! Ik deed alles in huis, om heur den minsten arbeid te sparen:
ik veegde den vloer, maakte het huwelijksbed, in hetwelk zij zich
's avonds behaaglijk uitstrekte, ik waschte de schotels, alsmede het
linnen, hetwelk ik zelven ook streek.--Eet, Thijl, 't is Gentsche
worst.--Soms, als zij gaan wandelen was, kwam zij te laat naar huis
voor het noenmaal, maar heur zien was zulk een groote vreugde voor mij,
dat ik niet kijven dorst, hoogst gelukkig nog, als ze mij 's nachts
den rug niet toekeerde. Ik heb alles verloren.--Drink dien wijn, Thijl,
't is Brusselsche wijn, bereid naar de wijze van Bourgondië.

--En waarom liet zij u zitten? vroeg Uilenspiegel.

--Weet ik het? hernam Lamme Goedzak. Waar is de tijd, als ik ten
narent kwam om heure hand te vragen, en zij vluchtte,--uit vreeze en
uit liefde? Als heure armen bloot waren, schoone, ronde, en blanke
armen, sloeg zij plotseling heure mouwen neer als zij zag, dat ik
er naar keek. Andere malen mocht ik heur zoenen, en 'k kuste heure
schoone oogen, die zij dicht hield van zalig genot; dan trilde zij
en slaakte kleine kreten, of boog heur hoofd achterover en gaf er
mij een stoot op den neus mee. En zij lachte als ik riep: Ai! en ik
gaf haar dan kleine duwtjes, want tusschen ons was niets anders dan
gestoei en gejoel.--Thijl, is er nog wijn in die bottel?

--Ja, sprak Uilenspiegel.

Lamme dronk en ging voort:

--Andere reizen viel ze vol minne rond mijnen hals en zei: gij zijt
schoon! En honderd maal kuste ze mij op de kaken of op 't voorhoofd,
maar nooit op den mond. En als ik vroeg waarom, antwoordde zij
blozend, dat moeder heur vroeger dikwijls gewaarschuwd had dat dit voor
meidekens gevaarlijk is. Ha! zoete oogenblikken, zalige tijd!--Thijl,
zie eens of gij soms een hammetje vindt in de weitasch?

--Een half, antwoordde Uilenspiegel.

Uilenspiegel gaf het hem en Lamme at het heel op.

--Dat hammetje deed mij deugd, sprak Uilenspiegel, als Lamme gedaan
had.

--Mij ook, sprak deze. Maar nooit zal ik mijn liefste terugzien,
zij is weggeloopen uit Damme. Rijdt gij mede om ze te zoeken?

--Ik wil wel, antwoordde Uilenspiegel.

--Maar, sprak Lamme, is er niets meer in de bottel?

--Geen droppel, antwoordde Uilenspiegel.

En zij stegen in de kar, getrokken door grauwtje, dat weemoedig balkte
om het vertrek aan te kondigen.

Maar de hond was--als hij goed zijne bekomst had--er stillekens van
door gegaan.




II.

De kar reed op den dijk, tusschen eenen vijver en eene vaart,
en droomerig drukte Uilenspiegel de assche van Klaas tegen zijne
borst. Hij vroeg zich af of het visioen leugen of waarheid was,
of die geesten met hem den spot gedreven hadden, of wel hem op
raadselachtige wijze gezegd hadden wat hij doen moest om 't land
zijner vaderen gelukkig te maken.

En te vergeefs trachtte hij te vatten, wat de Zeven en de Gordel
bediedden.

Aan den dooden keizer, den levenden koning, de landvoogden, den paus
van Rome, den groot-inquisiteur, den generaal der jezuïeten denkend,
vond hij in hen zes groote beulen, die hij onverwijld levend had
willen verbranden. Maar hij dacht, dat er van hen geen sprake was,
dat zij zelven te geerne anderen brandden, dat hij elders moest zoeken.

En gedurig herhaalde hij in zich zelven:


    Raakt het Noorden
    Kussend het Westen
    Rampspoed is uit.
    Vind de Zeven
    En den Gordel.


--Laas, sprak hij, in dood, bloed en puinen, Zeven vinden, Zeven
branden, Zeven minnen! Mijn arme geest wordt gefolterd, want wie dan
verbrandt zijne minne?

De kar had reeds een eind wegs afgelegd; zij hoorden een gekraak van
stappen in het zand en eene stemme, die zong:


    Gij, die voorbij trekt, zaagt ge wel
    Mijn vriend, mijn vrijer, snaaksch en snel?
    Hij zwerft nu hierent en darent.
    Zaagt ge hem wel?

    Gelijk op een lam een arent,
    Viel hij op een hartken fel.
    Baardloos, een man als niemendel.
    Zaagt ge hem wel?

    Ontmoet gij hem, zeg dat Nele
    Vermoeid is van te gaan zoo snel.
    Waar toeft ge lieve Thijl, vertel:
    Zaagt ge hem wel?

    Een tortel in den abeele
    Treurt om haar verloren gezel.
    Alzoo menig trouwe gespele.
    Zaagt ge hem wel?


Uilenspiegel klopte op Lamme's buik en zei:

--Houd uwen adem in, dikzak.

--Laas, antwoordde Lamme, 't is lastig voor iemand, die zoo dik is.

Doch Uilenspiegel liet hem praten; hij verborg zich achter de huif van
de kar, en de stemme nabootsend van een die bedronken is, neurde hij:


    Uw vriend en vrijer zag ik wel
    Op een kar van 't oud model,
    Met een papzak voor gezel,
    Zag ik hem wel!


--Thijl, zei Lamme, ge zingt leelijk dezen morgen.

Zonder naar hem te luisteren, stak Uilenspiegel het hoofd door een
gat van de huif.

--Nele, herkent gij mij? riep hij.

Verschrikt, weenend en lachend te gelijk, want heure kaken waren nat,
sprak zij:

--Ik zie u, leelijke deugniet!

--Nele, sprak Uilenspiegel, als ge mij wilt slaan, heb ik thuis
eenen stok. Hij slaat goed, en laat merkteekenen na, want hij is
zwaar en knoestig.

--Thijl, vroeg Nele, gaat gij naar de Zeven?

Ja, antwoordde Uilenspiegel.

Nele droeg eene weitasch, die proppensvol stak. Zij langde die aan
Uilenspiegel en sprak:

--Thijl, ik heb gedacht dat het voor een man ongezond is van op reis
te gaan, zonder een goede vette gans, een hesp en wat Gentsche worsten
bij zich. En dit moet gij eten te mijner gedenkenis.

Daar Uilenspiegel Nele bezag en er geenszins aan dacht de weitasch
te nemen, stak Lamme het hoofd door een ander gat van de huif en sprak:

--Meideken vol voorzienigheid, als hij niet aanpakt, is 't uit
verlegenheid. Maar geef mij die hesp, die gans en die worsten: ik
zal ze bewaren voor hem en ze beschermen.

--Welk een tronie is mij dat? vroeg Nele.

't Is, sprak Uilenspiegel, een slachtoffer van het huwelijk, die met
het herte vol wee, zou uitdrogen lijk een stoksken, zoo hij zich niet
stevig hield door dag en nacht te eten en te drinken.

--Zoo is het, mijn zoon, zuchtte Lamme.

De heldere zon drukte loodzwaar op Nele's hoofd. Zij dekte zich met
haar voorschoot. Daar Uilenspiegel met heur alleen wilde zijn, zei
hij tot Lamme:

--Ziet gij ginder die vrouw in de meersch?

--Ja, zei Lamme.

--Herkent gij ze niet?

--Daar? vroeg Lamme, zou het de mijne zijn? Zij is niet gekleed als
een poorteresse.

--Twijfelt gij nog, blinde mol? sprak Uilenspiegel.

--En als zij het niet was?

--Daar zoudt gij niets bij verliezen, want op de linkerhand, naar
het Noorden, is een kaberdoesken waar men lekker bruinbier tapt. Daar
zullen wij u vinden. En hier is hesp, om u te vergezelschappen.

Lamme kwam uit de kar en liep met groote schreden naar de vrouw in
de meersch.

Uilenspiegel vroeg tot Nele:

--Waarom komt ge niet bij mij?

Toen hielp hij heur in den wagen en deed hij ze naast hem zitten;
hij nam heure huik van den schouderen, en heur honderd kussen gevend,
sprak hij:

--Waar gingt ge heen, liefste?

Zij antwoordde niet, doch scheen heel vervoerd en begeesterd. En
Uilenspiegel, vervoerd als zij, zegde tot haar:

--Ik heb u zoo geerne naast mij. De wilde roze heeft niet de zachte
tint uwer donzige huid. Ge zijt wel geen koninginne, doch laat mij
maar eene krone van kussen maken voor u. Lieve, zoete armen, die God
maakte tot koozerij! Ha! liefste, ik vrees, dat mijn ruwe handen die
schouders verwelken! De lichte vlinder rust op de purperen anjelier,
maar hoe zal ik op uwe blankheid rusten, opdat ze niet verwelkt? God
is in den hemel, de koning zit op zijnen troon en de zonne glinstert
ginder aan 't uitspansel; maar ik ben God en koning en het licht, daar
ik zoo dicht bij u wezen mag! O, dat haar is zachter dan zijde! Nele,
ik ben ruw en wild, doch wees zonder vreeze! Die lieve voetjes! Hoe
komt het, dat zij zoo wit zijn? Pleegt gij ze te wasschen met melk?

Zij wilde opstaan.

Wat vreest gij? vroeg Uilenspiegel, toch niet de zonne, die op ons
schijnt en u teenenmale in 't goud zet? Sla uwe oogen niet neder. Zie
in de mijne, welk heerlijk vuur er brandt. Luister, liefste mijne;
't is het stille middaguur, de landman keert huiswaarts; hij leeft
van brood; maar wij, laat ons van liefde leven! Duizend jaren lang
zou ik aan uwe voeten willen doorbrengen.

--Mooispreker! zegde zij.

De zonne straalde, een leeuwerik tierelierde boven de klaveren,
en Nele legde heur hoofdje op den schouder van Uilenspiegel.




III.

Maar Lamme kwam zweetend en blazend terug.

Laas! sprak hij, ik ben onder een slecht gesternte geboren. Nadat
ik mij het hert afgeloopen had achter die vrouw, zag ik, dat het de
mijne niet was en reeds bedaagd; ze moest diep in de veertig zijn,
en aan heure kap zag ik, dat ze nooit getrouwd geweest was. Ze vroeg
mij bits wat ik met mijn dikken buik in heure klaveren kwam doen?

Ik zoek mijne vrouw, die mij liet zitten, antwoordde ik zachtjes,
en daar ik u nam voor haar, liep ik naar u toe.

Op die rede zegde de oude jongedochter, dat ik kon terugkeeren waar ik
van daan kwam; dat, als mijne vrouw mij liet zitten, het wel besteed
was, want dat al de mannen truwanten, dieven en ketteren zijn, die
alle meisjes willen verleiden en dat, als ik niet dadelijk opkraamde,
ze mij door heuren hond zou doen opvreten.

En niet zonder schroom pakte ik mijne biezen, want een groote hond
lag aan heure voeten te brommen. Als ik van heur land was, zette
ik mij neer op den wegel en at ik uw stuk hesp, om op mijn effen
te komen. Plotseling hoorde ik een geritsel achter mij en, als ik
mij omkeerde, zag ik den grooten hond van de oude jongedochter;
doch nu bromde hij niet meer, integendeel, hij kwispelsteertte en
zag mij begeerig aan, om de hesp. Ik smeet hem eenige stukskens toe,
maar zijne meesteresse kwam bij en riep:

--Pak hem! pak hem! manneken!

En ik op den loop, en de groote hond achter mij; hij beet mij in mijn
been. Maar terwijl ik schreeuwde van pijn, gaf ik hem met mijnen stok
eenen slag op zijne voorpooten, dat er ten minste één van gebroken
is. Hij viel en jammerde in zijne hondentaal: "Genade", die ik hem
verleende. Ondertusschen smeet zijne meesteresse kluiten aarde naar
mij, bij gebreke aan steenen, en ik weer op den loop!

Laas! is het niet wreed en onrechtveerdig voor eene vrouw, zich op
een onschuldigen jongen als ik te wreken, omdat zij niet schoon genoeg
is om aan eenen man te geraken?

En treurig stapte ik naar het kaberdoesken, dat gij mij gewezen
hadt, om met bruinbier mijnen schrik af te drinken. Maar ik was
nogmaals bedrogen, want als ik binnenkwam, zag ik man en vrouw
bezig met vechten. Ik vroeg, dat zij zouden uitscheiden om mij eenen
pot bruinbier te tappen, al was 't maar eene pinte of zeven; maar
de vrouw, een echte stokvisch, antwoordde mij woedend, dat als ik
niet dadelijk wegkwam, zij mij in kennis zou brengen met den blok,
waarmede zij op den kop van heuren man trommelde. En nu ben ik hier,
vriend, zweetend en af van vermoeidheid; hebt gij niets te eten?

--'t Doet, zei Uilenspiegel.

En Lamme slaakte eenen zucht van verlichting.




IV.

En ze reden samen voort. De ezel, met hangende ooren, trok traagzaam
de kar.

--Lamme, sprak Uilenspiegel, wij zijn gevieren: de ezel, die op goed
geluk naar distelen zoekt; gij, dikzak, die uwe wederhelft achternazit;
zij, de teedere en zoete geliefde, die iemand vindt, harer onweerdig,
't is te zeggen mij, den vierde.

Nu, kinderen, moed! de bladeren worden geel, en de hemel zal helderder
worden; weldra zal, in de najaarsnevelen, de zonne ondergaan, en de
winter zal verschijnen, als het beeld van den dood, om allen, die
onder onze voeten liggen, met een sneeuwen lijkwade te dekken. En
ik zal optrekken voor de redding van Vlaanderenland. Arme dooden:
Soetkin stierf van smerte; Klaas door den viere: eik van goedheid en
eiloof van liefde; ik, uw zoon, ik lijd grootelijks en zal u wreken,
assche, die ik zoo liefheb, die klopt op mijne borst.

Lamme sprak:

--Gij moogt ze niet beweenen, die voor de gerechtigheid stierven.

Maar Uilenspiegel bleef nadenken; eensklaps zegde hij:

--Nele, het uur van scheiden is gekomen en 't zal voor lang zijn;
wie weet, of ik uw lief gelaat ooit wederzie.

Nele bezag hem met heure oogen, die glinsterden als sterren, en sprak:

--Stap van den wagen en kom met mij in het bosch, alwaar gij lekker
eten zult vinden; want ik ken de kruiden en kan de vogelkens bijroepen.

--Meisje, sprak Lamme, 't is slecht van uwentwege, Uilenspiegel te
willen ophouden, die naar de Zeven moet zoeken en mijne vrouw helpen
terugvinden.

--Nog niet! sprak Nele, en zij weende: doch lachte, te midden heurer
tranen, Uilenspiegel liefderijk toe.

Dit ziende antwoordde deze:

--Uw vrouw zult gij wel intijds terugvinden, als gij lust naar nieuwe
smert zult gevoelen.

--Thijl, sprak Lamme, gaat ge mij, voor dat meisje, in mijne kar alleen
laten? Gij antwoordt niet en denkt aan het woud, waar de Zeven niet
zijn, en mijne vrouw evenmin. Help ze liever zoeken op dezen steenweg,
waar de kar zoo gemakkelijk rijdt.

--Lamme, sprak Uilenspiegel, er ligt een volle weitasch in de kar,
gij zult dus niet sterven van honger, als gij van hier naar Koolkerke
gaat, alwaar ik bij U kom. Gij moet er alleen zijn, want daar zult
gij vernemen naar welke windstreek gij u richten moet, om uwe vrouw te
vinden. Luister. Gij rijdt stapvoets naar Koolkerke, op drie uren van
hier. Op den toren draait een windhaan met alle winden mee op zijn
roestige hengsels. Dat geknars wijst aan de arme mannen, die hunne
liefste verloren, den weg, langs welken zij haar zullen terugvinden.

Maar vooreerst moet men met een hazelaarstaksken, zeven reizen, op elk
muurvlak slaan. Als de hengsels knarsen, terwijl de wind uit 't noorden
blaast, is 't die kant dien gij nemen moet, doch met omzichtigheid,
want Noordenwind is oorlogswind; blaast hij uit 't Zuiden, ga dan
maar blijgemoed: 't is minnewind; uit het Oosten, loop dan gezwind:
't is licht en en vroolijkheid; uit het Westen, ga traagzaam, want
die wind brengt regen en tranen. Ga, Lamme, en wacht mij te Koolkerke.

--Ik zal, zei Lamme.

En hij reed voort met de kar.

Terwijl Lamme naar Koolkerke reed, joeg de sterke, zoele wind de grijze
wolkjes als een kudde schapen door het luchtruim. Uilenspiegel en Nele
waren alleen in het woud. Uilenspiegel had honger en Nele zocht naar
heerlijke vruchten, doch vond niets anders dan eikels, en de kussen,
die heur vriend heur in overvloed gaf.

Uilenspiegel had strikken gespannen en floot om de vogels bij
te roepen, ten einde diegenen te braden, die zich zouden laten
vangen. Een nachtegaal kwam omtrent Nele op de bladeren zitten; zij
ving hem niet, om hem te laten voortzingen; toen kwam een grasmusch,
en zij had er medelijden mee, omdat zij zoo lief en zoo hupsch was;
vervolgens kwam een leeuwerik, maar Nele zei hem, dat hij beter zou
doen hoog in de lucht te vliegen en de Natuur te bezingen, dan dom
weg te komen dartelen boven de doodelijke punt van een braadspit.

En 't was de waarheid, want inmiddels had Uilenspiegel een vuur
aangestoken en een braadspit gesneden, dat op niets anders wachtte
dan op lichtzinnige slachtofferen.

Maar de vogelen kwamen niet meer bij, tenzij eenige kwaadaardige raven,
die hoog boven hunne hoofden krasten.

En zoo kwam het, dat Uilenspiegel niemendal te eten had.

Doch Nele moest vertrekken en bij Katelijne terugkeeren. En weenend
ging zij haren weg op, en Uilenspiegel keek heur droef achterna.

Maar ze kwam terug en viel hem om den hals.

--Ik ga henen, sprak zij.

Zij ging, doch opnieuw keerde ze terug, zeggende:

--Ik ga henen.

En zoo wel twintig reizen en nog meer.

Eindelijk vertrok zij, en Uilenspiegel bleef alleen. Toen ging hij
ook henen om Lamme weder te vinden.

Als hij bij hem was, zat Lamme aan den voet van den toren, met
een grooten pot bruinbier tusschen zijne beenen, weemoedg op een
hazelaarstakje te bijten.

--Uilenspiegel, sprak hij, ik geloof, dat ge mij maar weggezonden
hebt, om met 't meideken alleen te blijven; ik heb met den hazelaar
zeven reizen op elk vlak van den toren geslagen, en hoewel de wind
blaast als een duivel, toch hebben de hengsels niet geknarst.

--Men zal ze zeker gesmeerd hebben, antwoordde Uilenspiegel. Vervolgens
togen ze henen naar het hertogdom Brabant.




V.

Dagen en nachten bracht Philippus tusschen zijne papieren en
perkamenten door. Aan hen vertrouwde hij de gedachten van zijn
ongevoelig herte. Daar hij nooit bemind had, maar ook wist dat niemand
hem liefhad, wilde hij zelf zijn onmetelijk rijk bestieren, en de
droefgeestige Atlas bukte onder den last. Weemoed en bovenmatige
arbeid ondermijnden zijn zwak lichaam. Hij had een afschuw van een
blij gezicht en daarom een haat tegen onze lachende landen; tegen onze
kooplieden, om hunne weelde en hunnen rijkdom; tegen onzen adel, om
zijne vrijmoedigheid en het vuur zijner kloeke blijgeestigheid. Hij
wist--men had het hem gezegd--dat lang reeds vóór dat kardinaal
de Couza, omtrent het jaar 1380, op de misbruiken der Kerk en op
de noodzakelijkheid der hervormingen gewezen had, de opstand tegen
Paus en de Roomsche Kerk, die zich in onze landen onder verschillende
sektevormen geuit had, in de gemoederen borrelde als kokend water in
een ketel.

Hij geloofde, de koppige, dat zijn wil op de gansche wereld
drukken moest als de wil van God; hij wilde, dat onze landen die
de gehoorzaamheid ontwend waren, bogen onder het oude juk, zonder
eenige hervorming te erlangen. Hij wilde, dat Zijne Heilige Moeder:
de Katholieke, Apostolische en Roomsche kerk één, geheel en algemeen,
ongewijzigd en onveranderd zou zijn, alléén omdat hij het wilde,
en alzoo handelde hij als een onredelijke vrouw. En 's nachts woelde
hij in zijn bed als op een leger van doornen, werd hij onophoudelijk
gefolterd door zijne gedachten.

--Ja, Heilige Philippus, Heere God, al moest ik van de Nederlanden
één kerkhof maken, tot U zullen zij komen, mijn beschermer, tot U,
Heiligen des hemelrijks.

En hij beproefde te doen wat hij zeide, zich aldus Roomscher toonend
dan de Paus en katholieker dan de kerkvergaderingen.

En Uilenspiegel en Lamme, en het volk van Vlaanderen en van de
Nederlanden, zagen, met angstvolle herten, van verre, in de sombere
halle van 't Escuriaal, die gekroonde spinnekop, met heure lange,
ruige pooten, heure geopende grijpers, het net spannen, dat hen vangen
moest om het beste van hun bloed te zuigen.

Hoewel, onder de regeering van keizer Karel, de pauselijke inquisitie
honderd duizend Christenen gedood had: hoewel de goederen dier
martelaren in de kisten van keizer en koning gevloeid waren als
regen in eene goot, oordeelde Philippus dat dit niet voldoende was,
en hij legde den lande de nieuwe bisdommen op en wilde er de Spaansche
inquisitie invoeren.

En overal lazen de stadsherauten, bij geschal van bazuinen, en geroffel
van trommen, de plakkaten af waarbij kond werd gegeven, dat al de
ketteren, met den viere zouden sterven als zij hunne dolingen niet
afzwoeren, en met de koorde als zij die wel zouden afgaan. Vrouwen
en meidekens zouden levend begraven worden, en de beul zou op heure
lichamen dansen.

En als een vuur zette de wederstand zich door heel het land voort.




VI.

Den vijfden van de grasmaand, vóór Paschen, gingen de heeren Lodewijk
van Nassau, Kuilenburg en Brederode, met driehonderd edellieden het
hof van Brussel binnen, bij Mevrouwe de landvoogdes, hertoginne van
Parma. In rangen van vieren beklommen zij de groote trap van 't paleis.

Binnengeleid in de zaal waar Mevrouwe zich bevond, boden zij heur
een klaagschrift aan, bij hetwelk zij heure tusschenkomst vroegen om
den koning te bewegen, de plakkaten op 't stuk der religie, alsmede
de Spaansche inquisitie op te heffen, verklarende, dat er in onze
misnoegde landen anders niets uit kon voortvloeien dan muiterij,
puinhoopen en algemeene ellende.

En dat verzoekschrift werd Het Eedverbond geheeten.

Berlaymont, die later zoo valsch en wreed was voor den grond zijner
vaderen, stond naast Hare Hoogheid en sprak, om te spotten met de
armoede dier edele eedgenooten:

--Mevrouwe vrees niets, het zijn maar geuzen!

Daarmede wilde hij zeggen, dat die edelen en smalle jonkers ondergegaan
waren in dienst des konings of door in weelde te wedijveren met de
Spaansche edellieden.

Om de woorden van Berlaymont met verachting te bejegenen, verklaarden
zij er eere in te stellen "geuzen" geheeten en genaamd te worden,
voor den dienst des konings en het welzijn dezer landen.

Zij besloten een gouden penning te dragen, met de beeltenis des
konings op de eene zijde, en op de andere twee ineengelegde handen,
saamgesnoerd door de riemen van eenen bedelzak, en deze woorden: "Den
koning getrouw tot den bedelzak". En op hunne hoeden en mutsen droegen
zij ook gouden juweelen in den vorm van nappen en van bedelaarsmutsen.

Intusschentijd liep Lamme met zijn dikken buik door de stad, op zoek
naar zijne vrouw, maar hij vond ze niet.




VII.

Op een morgen zei Uilenspiegel tot Lamme:

--Kom mede: wij gaan een grooten, edelen, machtigen, geduchten heere
groeten.

--Zal hij mij zeggen waar mijne vrouw is? vroeg Lamme?

--Als hij het weet, antwoordde Uilenspiegel.

En zij gingen bij Brederode, den machtigen drinker.

Hij was in het binnenhof van zijn paleis.

--Wat wilt gij? vroeg hij tot Uilenspiegel.

--U spreken heer! antwoordde Uilenspiegel.

--Spreek, zegde Brederode.

--Gij zijt, sprak Uilenspiegel, een schoon, dapper en krachtig
man. Eens hebt gij een Franschman in zijn harnas versmacht, als eene
mossel in hare schelp; doch zijt gij sterk en dapper, gij zijt mede
verstandig. Waarom dan draagt gij dien penning, waarop te lezen staat:
"Den koning getrouw tot den bedelzak"?

--Ja, heer, waarom? vroeg Lamme.

Doch Brederode antwoordde niet en keek Uilenspiegel scherp in de
oogen. Deze ging voort:

--Waarom wilt gij, edele heeren, den koning getrouw tot den bedelzak
blijven? Is 't voor het goede, dat hij u gunt, of de vriendschap,
die hij u toedraagt? Waarom, in stee van hem getrouw te zijn tot
den bedelzak, verlost gij niet liever onze landen van dien beul,
die met volle gerechtigheid zelf den bedelzak diende te dragen?

En Lamme knikte, tot teeken dat hij daarmede instemde.

Brederode bezag Uilenspiegel met zijn levendigen blik, lachte en sprak:

--Als gij geen spion van koning Philippus zijt, zijt gij een goed
Vlaming, en ik ga u loonen voor de beide gevallen.

Hij bracht hem naar de keuken en Lamme volgde hem. Daar trok hij hem
tot bloedens bij de ooren.

--Dit is voor den spion, sprak Brederode.

Uilenspiegel schreeuwde niet.

--Breng, zegde hij tot zijn bottelier, breng hier dien moor met
kaneel-wijn.

De bottelier bracht den moor en een grooten beker warmen, geurigen
wijn.

--Drink, sprak Brederode tot Uilenspiegel, dit is voor den goeden
Vlaming.

--Ha! sprak Uilenspiegel, wat schoone tale spreekt die wijn met kaneel;
zoo spreken de santen zeker in het hemelrijk niet!

Als hij de helft van den wijn uitgedronken had, gaf hij de rest
aan Lamme.

--Wie is die papzak daar, vroeg Brederode, die beloond wordt om niets
te doen?

--'t Is mijn vriend Lamme, antwoordde Uilenspiegel, telkens dat hij
warmen wijn drinkt, verbeeldt hij zich, dat hij zijne vrouw gaat
terugvinden.

--Ja! sprak Lamme, den beker devotelijk ledigend.

--Waar gaat gij nu? vroeg Brederode.

--Wij gaan, antwoordde Uilenspiegel, op zoek naar de Zeven, die
Vlaanderenland moeten verlossen.

--Welke Zeven? vroeg Brederode.

Als ik ze gevonden heb, zal ik u zeggen wie ze zijn, antwoordde
Uilenspiegel.

Maar Lamme, dien de wijn vroolijk gemaakt had, vroeg:

--Thijl, als wij eens in de maan naar mijne vrouw gingen zoeken?

--Waar is de ladder? vroeg Uilenspiegel.

In Mei, de groote Bloeimaand, sprak Uilenspiegel tot Lamme:

--Daar is de schoone Bloeimaand, de heldere, blauwe hemel! De
takken der boomen zien rood van levenssap, de grond baart welige
groeikracht. Dat is het oogenblik om te hangen en te branden voor het
geloof. Daar zijn zij, de goede ketterjagers. Wat edele gezichten! Zij
hebben het vermogen een iegelijk te straffen, te tuchtigen, af te
zetten, aan de wereldlijke rechters over te leveren, en ook hun eigen
gevangenis te hebben.--Ha! wat een schoone Bloeimaand!--in hechtenis
nemen, in rechte vervolgen zonder vorm van proces, branden, hangen,
onthalzen en vrouwen en meidekens voorbarig begraven. De vinken slaan
in de boomen. De goede kettermeesters houden de rijken in 't oog. En
de koning zal erven. Gaat, meidekens, gaat dansen in de beemden,
bij geschal van pijpen en schalmeien. Ho! de schoone Bloeimaand.

De assche van Klaas klopte op Uilenspiegel's borst.

--Laat ons gaan, sprak hij tot Lamme. Gelukkig zij, die het hert hoog
en het zweerd gereed houden in de sombere dagen, die op handen zijn.




VIII.

Uilenspiegel kwam eens, in de Oogstmaand, op den Vlaamschen steenweg,
te Brussel, voorbij de woning van Jan Sapermillemente, aldus genoemd
omdat zijn grootvader, als hij kwaad was, met dien uitroep placht te
vloeken, om den zeer heiligen naam Gods niet te lasteren noch ijdelijk
te gebruiken. Gemelde Sapermillemente was meester-borduurder; doch
daar hij zich blind en doof gedronken had, borduurde zijne vrouw--een
oud wijf met een bitsige tronie--de kleederen, wambuizen, mantels en
schoenen der heeren. Hare bevallige dochter was haar behulpzaam in
dien goedbetaalden arbeid.

Toen Uilenspiegel bij het vallen van den avond voorbij hunne woning
ging, zag hij het meideken aan 't venster en hoorde hij heur neuren:


        Oogst, oogst,
    Zeg mij, zoete maand,
    Wie neemt er mij als vrouw;
    Zeg mij, zoete maand?


--Ik, zei Uilenspiegel, als gij wilt.

--Wie, ik? vroeg zij. Kom nader, dat ik u zie.

Doch Uilenspiegel vroeg:

--Hoe komt het, dat gij in Oogstmaand roept hetgeen de Brabantsche
meidekens plegen te roepen in den vooravond van Lentemaand?

--Omdat zij maar ééne maand hebben die een man geeft, en ik er
twaalf heb. Op den vooravond van elke maand, niet te middernacht,
doch zes uren lang tot middernacht, spring ik uit mijn bed, ga ik
drie stappen achterweerts naar het venster en zing ik het liedeken;
vervolgens keer ik terug naar mijn bed, met drie stappen achterweerts,
en te middernacht ga ik slapen om te droomen van den mij bestemden
echtgenoot. Maar de maanden zijn spotters van nature, en 't is niet
van één man dat ik droom, maar van twaalf te gelijk; gij zijt de
dertiende, zoo gij lust hebt.

--De andere zouden jaloersch zijn, antwoordde Uilenspiegel. Gij ook
roept: "Verlossing!"

Het meideken bloosde en sprak:

--Ik roep om verlossing en weet wat ik vraag.

--Ik weet het insgelijks en breng het u mede, antwoordde Uilenspiegel.

--Gij moet wachten, zeide zij glimlachend en daarbij liet zij heure
schoone tanden zien.

Wachten, sprak Uilenspiegel, neen. Een huis kan op mijn hoofd vallen,
de wind mij in eene beek smijten, een dolle hond in mijn been bijten;
neen, wachten doe ik niet.

--Ik ben nog te jong, sprak ze, en roep maar naar het aloud gebruik.

Uilenspiegel werd achterdochtig, als hij er aan dacht, dat het op
Maartavond en geenszins in de Oogstmaand was, dat de Brabantsche
meidekens naar een man riepen.

Glimlachend herhaalde zij:

--Ik ben nog te jong en roep maar naar het aloud gebruik.

--Gaat gij wachten totdat gij te oud zijt? 't Ware jammer! Nog nooit
zag ik zoo'n ronden hals, zoo'n blanken boezem, een Vlaamschen boezem
vol goede melk, die kloeke mannen maakt.

--Vol? sprak zij, nog niet; gij zijt er rap bij, gij!

--Wachten? herhaalde Uilenspiegel; totdat ik geene tanden meer heb
om u levend op te eten, liefste? Gij antwoordt niet en glimlacht met
uw lichtbruine oogen en uwe lippen als kersen zoo rood!

Het meisje bezag hem met een onderzoekenden blik en antwoordde:

--Van waar komt al die liefde in eens? Wat doet gij? Zijt gij een
bedelaar, of zijt gij rijk?

--Bedelaar ben ik, sprak hij, en rijk al te gader, als gij mij
toehoort, liefste.

Zij antwoordde:

--Dat is 't niet wat ik wil weten. Gaat gij naar de misse? Zijt
gij goed Christene? Zoudt gij durven zeggen, dat gij een bedelaar,
een echte bedelaar, een geus zijt, die opstaat tegen de plakkaten en
tegen de inquisitie?

De assche van Klaas klopte op Uilenspiegel's borst.

--Ik ben geus, sprak hij, dood en opgevreten door de wormen wil ik
de verdrukkers onzer Nederlanden zien! Gij beziet mij, liefste. Dat
liefdevuur, dat voor u brandt, is het vuur van de jeugd. God stak
het aan, het brandt lijk de zonne gloort, totdat het uitdoove. Doch
God stak ook het vuur aan der wrake, dat smeult in mijn hert. Het
zal wezen het zweerd, het vuur, de koorde, de brand, de verwoesting,
de oorlog en de val van de beulen!

--Gij zijt schoon, zegde zij treurig, hem op beide wangen kussend;
maar zwijg toch.

--Waarom weent gij? vroeg hij.

--Gij moet altijd zien waar gij zijt, sprak zij, hier en ook elders.

--Hebben de muren dan ooren? vroeg Uilenspiegel.

--Zij hebben alleen de mijne, sprak zij.

--Met een kus zal ik ze geerne sluiten.

--Gekke vriend, luister toch als ik spreek.

--Waarom? wat hebt gij te zeggen?

--Luister, sprak zij met ongeduld. Daar is mijne moeder.... Zwijg,
zwijg vooral in heur bijzijn....

De oude Sapermillemente kwam binnen. Uilenspiegel bezag heur en sprak
in zich zelven:

--Gezicht als eene schuimspaan, oogen met harden en valschen blik, mond
die wil lachen en slechts grijnzen kan, gij maakt mij nieuwsgierig.

--God zij met u, heer, standvastig met u, sprak de oude. Ik heb geld
ontvangen, meisje, schoon geld van den grave van Egmond, als ik hem
zijn opperste kleed bracht, op hetwelk ik den narrenstok geborduurd
heb. Ja, heer, een narrenstok, tegen den Rooden Hond.

--Kardinaal Granvelle? vroeg Uilenspiegel.

--Ja, sprak zij, tegen den Rooden Hond. Men zegt, dat hij den koning
hunne praktijken overbrieft; zij willen hem van kant maken. Zij hebben
gelijk, niet waar, heer?

Uilenspiegel antwoordde niet.

--Hebt gij ze niet gezien in de straten, gekleed met hun wambuis en
hun grijs opperste kleed, gelijk het gemeen draagt, met hunne lange,
hangende mouwen, met kalbasfleschjes en nopjes om den hals? Op al
de opperste kleederen staat de narrenstok geborduurd. Ik heb er wel
zeven en twintig gemaakt en mijne dochter voor 't minst vijftien. Als
de Roode Hond die narrenstokken ziet, is hij grammoedig.

Vervolgens zeide zij stille tot Uilenspiegel:

--Ik weet, dat de heeren besloten hebben den narrenstok te vervangen
door eene korenschoof, tot teeken van eendracht. Ja, ja, zij gaan
strijden tegen den koning en tegen de inquisitie. Zij hebben gelijk,
niet waar, heer?

Uilenspiegel antwoordde niet.

--De vreemde heer is droefgeestig, zei de oude; hij houdt den bek toe.

Uilenspiegel zeide geen woord en ging buiten.

Hij trok een taveerne binnen om het drinken niet te verleeren. De
taveerne was vol drinkers, die zich onvoorzichtig uitlieten over den
koning, de gehate plakkaten, de inquisitie en den Rooden Hond, dien
men het land moest uitjagen. Daar zag hij de oude, in lompen gehuld,
die gebaarde te slapen naast een kapperken brandewijn. Aldus bleef
ze langen tijd zitten; eindelijk trok zij een schaaltje uit den zak;
hij zag heur bedelen in de groepen, en vooral vragen aan degenen,
die zich 't onvoorzichtigst hadden uitgelaten.

En een iegenlijk gaf heur gereedelijk een gulden, een denier of
een oortje.

In de hoop van het meisje te weten wat de oude Sapermillemente hem
verborg, ging Uilenspiegel opnieuw voorbij de woning; het meideken
riep nu niet meer, doch lachte hem, knipoogend, liefelijk toe.

Doch de oude kwam plotseling achter hem binnen.

Grammoedig heur te zien, liep Uilenspiegel als een hert de straat op,
al roepend "'t brandt! 't brandt!" totdat hij kwam vóór het huis van
Jacob Pietersen, den bakker. De ondergaande zonne weerkaatste gloeiend
rood in de vensteren van zijnen winkel, en een dikke rook van brandende
takkebossen steeg op uit den schoorsteen. Uilenspiegel liep voort,
al roepend: "'t brandt! 't brandt!" En met den vinger wees hij naar
't huis van Pietersen. De menigte schoolde samen, zag den rooden
gloed en den dikken rook, en riep lijk Uilenspiegel: 't brandt! 't
brandt! De waker der Katelijnekerk blies op zijne trompet, terwijl
de koster uit al zijne macht de wacharmklok luidde. En de knapen en
meidekens kwamen, zingend en fluitend, met hoopen toegesneld.

Daar de klok altoos luidde en de trompet altoos schalde, toog de oude
Sapermillemente er eindelijk ook henen.

Uilenspiegel hield ze van verre in 't oog. Toen zij weg was, ging
hij binnen.

--Gij, hier! sprak het meideken, brandt het dan niet?

--Neen, neen, antwoordde Uilenspiegel.

--Maar die klok, die zoo jammerlijk klept?

--Zij weet niet wat zij doet, antwoordde Uilenspiegel.

--En de trompet, en dat volk dat zoo loopt?

--Ons Heer moet zijn getal hebben.

--Waar brandt het dan toch? vroeg zij.

--In mijn hert, antwoordde Uilenspiegel.

En hij vloog naar heuren mond.

--Gij bijt mij, sprak zij.

--Ik eet geerne kersen, zegde hij.

Droef glimlachend keek zij hem aan. En schreiend sprak zij tot hem:

--Zet geen voet meer hier in huis. Gij zijt een geus, een vijand des
Pausen, zet hier geen voet meer.

--Uwe moeder? sprak hij.

--Ja, zegde zij blozend. Weet gij waar ze nu is? Daar waar het brandt,
om te luisteren wat er gezegd wordt. En fluks gaat zij bij den Rooden
Hond, hem alles overdragen en het beulswerk voorbereiden. Vlucht,
Uilenspiegel, ik red u, vlucht. Nog een kus, doch kom nooit meer terug;
nog één, gij zijt schoon, maar vertrek!

--Braaf meideken, sprak Uilenspiegel, heur in de armen drukkend.

--Dat was ik niet altijd, zegde zij. Ik deed lijk zij.

Hoe sprak hij, dat liedeken, die zoete oproep tot de verliefde mannen?

--Ja, zegde zij. Moeder wilde het, u red ik, omdat ik u uit
liefde beminne. De anderen zal ik redden te uwer gedenkenis, mijn
geliefde. Zal uw hert nog denken aan het boetveerdige meideken,
als gij verre van hier zijt? Geef mij een kus. Voor geld zal zij
geene slachtofferen naar de galge meer sturen. Ga heen; neen, blijf
nog. Hoe zacht is uwe hand! Zie, ik kus uwe hand, tot teeken van
onderdanigheid; gij zijt mijn heer, mijn meester. Luister, dichtbij,
en zwijg. Dezen nacht zijn rabauwen en diepers en ander slecht volk,
waaronder een Italiaan, de een na den ander hier geweest in ons
huis. Moeder deed ze in deze kamer komen, stak mij buiten, en sloot de
deur achter mij. Ik hoorde echter deze woorden: "Steenen kruisbeeld,
Borgerhoutsche poort, ommegang, Antwerpen, Lieve-Vrouwekerk", een
onderdrukt gelach en guldens, die op tafel geteld werden.... Vlucht,
daar komt ze; vlucht, mijn welbeminde. Denk soms aan mij; vlucht....

Uilenspiegel liep zooals zij zeide tot in den Ouden Haan, en daar
vond hij Lamme weemoedig zitten met eene worst in de hand en zijn
zevende pint Peeterman vóór zich op de tafel.

En, in weerwil van zijn dikken buik, deed hij hem loopen als hij.




IX.

Terwijl hij aldus, gevolgd door Lamme, het op een drafje zette, vond
hij in de Eikstraat een kwaadwillig paskwil tegen Brederode. Hij ging
het hem onmiddellijk overhandigen.

--Ik ben, Heere, sprak hij, die goede Vlaming en die spion van den
koning, dien gij zoo goed bij de ooren trokt en zulken goeden wijn te
drinken gaaft. Ik breng u een lieftallig schriftje, in hetwelk men u
onder anderen beschuldigt, den titel van grave van Holland te nemen,
die den koning behoort. Het is versch geprent door Jan Lastermans,
wonende op de Schavuitenkaai, omtrent de Eerrooversgang.

Glimlachend antwoordde Brederode:

--Ik laat u twee uren lang geeselen, als ge mij den echten naam van
den schrijver niet zegt.

--Heer, antwoordde Uilenspiegel, gij moogt mij twee jaar lang doen
geeselen als gij wilt, maar wat mijn mond niet weet, zult gij mijnen
rug niet doen zeggen.

En hij ging henen met een gulden voor zijne moeite.




X.

Sedert de Zomermaand, de maand van rozen, was men in Vlaanderen aan
't preeken.

En de apostelen der eerste kerstene Kerk preekten overal, op alle
plaatsen, in 't groen en in de hovingen, op de heuvelen waar men
bij overstrooming de beesten in veiligheid bracht, op de rivieren,
in booten.

Te land verschansten zij zich als in een kamp, door middel van
karren. Op de rivieren en in de reeden hielden schuiten vol gewapende
mannen de wacht rondom hen.

En rond de verschansingen stonden boogschutters en pijkeniers, om
hen te behoeden voor eene verrassing des vijands.

En aldus weerklonk allerwegen het woord der vrijheid op den bodem
der vaderen.




XI.

Uilenspiegel en Lamme waren te Brugge, en ze lieten hunne kar in een
beluik, om Sint-Salvatorskerk binnen te gaan; zij waren liever naar
de taveerne gegaan, doch hunne tassche liet geen blijd gerinkel van
geld meer hooren.

Pater Cornelis Adriaensen, minderbroeder, een vuile, woedende,
blaffende en schaamtelooze prediker, speelde dien dag zijne perten
in den kansel der waarheid.

Jong en poezele kwezelkens verdrongen zich rond hem.

Pater Cornelis sprak over de Passie. Gekomen ter plaatse van de Heilige
Schrift, waar de Joden, naar Jezus wijzend, tot Pilatus schreeuwden:
"Aan het kruis, aan het kruis met hem, want wij hebben eene wet en,
volgens die wet, moet hij sterven!" riep broeder Cornelis uit:

"Gij hoort het, goede lieden, als Ons-Heer Jezus Christus een
gruwelijken en schandelijken dood is gestorven, is het omdat er tegen
de ketters altijd wetten bestonden. Hij werd te recht veroordeeld,
omdat hij de wet had geschonden. En nu willen ze de edicten en
plakkaten als nietig aanzien. Ha! Jezus, welke vermaledijding wilt gij
over deze landen doen vallen! Allerheiligste Moeder Gods, was keizer
Karel nog in leven en kon hij het schandaal zien van die verbonden
edelen, die zoo stoutmoedig waren de landvoogdes een vertoogschrift
aan te bieden tegen de inquisitie en tegen de plakkaten, die met het
beste inzicht gemaakt, na zoo langdurige en voorzichtige overwegingen
opgesteld en uitgevaardigd zijn tot uitroeiing van alle sekten en
ketterijen! En nu ze dat meer van noode zijn dan brood en dan kaas,
willen zij ze vernielen! In welken smerigen, stinkenden, afgrond
wil men ons lokken? Luther, die razende os, zegepraalt in Saksen, in
Brunswijk, in Luneburg, in Mecklenburg; Brentius, de vuile Brentius,
die in Duitschland van eikelen leefde die de verkens versmaadden,
Brentius zegepraalt in Wurtenberg; Servet, de waanzinnige Servet, die
een kwartier van de maan in zijn hoofd heeft, zegepraalt in Pommeren,
in Denemarken en in Zweden, en daar vermeet hij zich de heilige,
glorierijke en almachtige Drievuldigheid te lasteren. Ja. Maar
men heeft mij gezegd, dat hij levend verbrand werd door Calvijn,
die eindelijk dan toch iets gedaan heeft dat deugt; ja, door den
stinkenden Calvijn, die zuur riekt; ja, met zijnen snuit zoo lang als
die van eenen otter; met zijnen kaaskop, met zijn groote tanden, die
op de tanden eener egge gelijken. Ja, die wolven verslinden elkander;
ja, die os van een Luther, de razende os, wapende de prinsen van
Duitschland tegen den wederdooper Munzer, die een snul was, naar men
zegt, en leefde volgens de Heilige Schrift. En heel Duitschland door,
hoorde men 't geloei van dien os, ja, heel Duitschland door!

"Ja, en wat ziet men in Vlaanderen, in Gelderland, in Friesland, in
Holland, in Zeeland? Adamieten, die naakt door de straten loopen, ja,
goede lieden, naakt door de straten, en schaamteloos hun mager lichaam
aan de menschen toonen. Er was er maar één, zult ge zeggen;--ja,
't kan zijn--maar één is honderd, en honderd zijn één. En werd hij
verbrand, vraagt ge? hij werd levend verbrand op het aanzoek van
Calvinisten en Lutheranen. Die wolven verslinden elkander, zeg ik u!

"Ja, wat ziet men in Vlaanderen, in Gelderland, in Friesland, in
Holland, in Zeeland? Wederdoopers, vrijheidsapostelen, die leeren dat
alle dienstbaarheid strijdig is met het woord Gods. Zij liegen, die
stinkende ketteren; wij moeten ons onderwerpen aan onze Heilige Moeder,
de Roomsche Kerke. En daar, in die verdoemde stad Antwerpen, waar
al het kettergespuis van de wereld bijeenkomt, dorsten zij preeken,
dat wij onze hostiën met hondenvet bakken! Een ander durft zeggen:
't is die geus, die op dien waterpot zit, op den hoek van de straat:
"Er is geen God, geen eeuwig leven, geene verrijzenis des vleesches,
geen eeuwige verdoemenis". "Men mag, zegt die andere ginder,
men mag doopen zonder zout, zonder vet, zonder speeksel, zonder
duivelbezwering en zonder keerse". "Er is geen vagevier", zegt een
ander. Geen vagevier, goede lieden! Zaliger voor u goede lieden,
ware het van te zondigen met uwe moeder, uwe zuster, uwe dochter,
dan een oogenblik te twijfelen aan 't bestaan van het vagevier!

"Ja, en zij lachten met den inquisiteur, den heiligen man, ja. Ze
zijn hieromtrent, te Bellem, geweest met vier duizend Calvinisten,
gewapende mannen, met trommels en vaandels. Ja. En van hier riekt gij
den stank hunner keuken. Zij hebben Sinte-Katelijnekerk genomen om
ze te onteeren, te ontwijden, te ontheiligen met hunne vermaledijde
predikatiën.

"Is die verdraagzaamheid niet goddeloos en niet schandalig? Bij
de duizenden duivelen uit de helle, waarom steekt gij ook de
handen niet uit naar de wapenen, weekhertige katholieken? Als dat
calvinistengebroed, hebt gij ook harnassen, lansen, hellebaarden,
zweerden, kruismessen, alsmede de falkonetten, bussen, slangen en
serpenten van de gemeente.

"Zij zijn vreedzaam, zult gij zeggen; zij willen, in volle rust en
vrede, Gods woord aanhooren. 't Is eender. Trekt de stad uit! verjaagt
mij, doodt mij, smijt mij al die Calvinisten uit den Tempel! Zijt
gij nog niet weg! Foei, gij zijt precies lijk verschrikte hennen,
die op eenen mesthoop staan te beven! Ik zie het oogenblik aankomen,
op hetwelk die verdoemde Calvinisten op den buik uwer vrouwen en
dochteren zullen trommelen en gij zult ze laten begaan, weekelingen
van mannen die gij zijt. Gaat niet naar Bellem, blijft hier, gij zoudt
uwe kousen verslijten. Foei, Bruggelingen! foei, katholieken! Schande
over u, eenden, ganzen en kalkoenen die gij zijt!

"Dat moeten schoone predikantjes zijn, daar gij met hoopen luisteren
gaat naar de leugenen, die zij uitbraken en daar de meidekens des
nachts naar hunne sermoenen trekken, zoodat de stad binnen negen
maanden vol kleine geuskens en geuzinnekens zal steken? Zij waren
daar gevieren, vier truwanten, die preekten op 't kerkhof. De eerste
bleek en mager, die leelijke broeksch..., had een vuilen hoed op zijn
hoofd, met denwelken hij zijne ooren verborg. Heeft iemand van u ooit
de ooren van eenen predikant gezien? Hij had geen hemd aan, want zijne
armen staken bloot uit zijn wambuis. Gij kondt door zijn broek kijken,
als door den St.-Jacobstoren van Antwerpen. De andere schelm had
geen schoenen aan zijne voeten. Niemand heeft zijne ooren gezien. En
hij bleef steken in zijne predikanterij, en de knapen en meidekens
jouwden hem uiten riepen: "Ahoe! ahoe! hij kent zijne les niet." De
derde had een vuilen, leelijken hoed op, met een pluimken op zij. Ook
zijne ooren kon men niet zien. De vierde, een beetje beter gekleed
dan de anderen, moet door den beul tweemaal gebrandmerkt zijn, ja!

"Onder hunnen hoed dragen zij allen vettige, zijden hoofddeksels,
die hunne ooren verbergen. Hebt gij ooit de ooren van een predikant
gezien? Ooren! ha! ja, hunne ooren toonen; de beul is er mee weg:
zij zijn allen gekortoord!

"En nochtans is 't rond die schelmen, rond die diepers, rond
die schoenlappers die hunnen spanriem ontliepen, rond die luizige
predikanten, dat die van 't gemeen riepen: "Leve de geus!" alsof zij
allen razend, zat of zot waren.

"Ha! ons, arme Roomsch-Katholieken, blijft anders niets over dan de
Nederlanden te verlaten, vermits men er den kreet: "Leve de geus! Leve
de geus!" laat uitbraken! Welke steen van vermaledijding is dan toch op
dat stompzinnig, betooverd volk gevallen? Ha! Jezus! overal zijn rijken
en armen, edelen en onedelen, ouden en jongen, mannen en vrouwen aan
't roepen: "Leve de geus!"

"En wat zijn al die heeren, al die kaalkoppen, die ons uit Duitschland
overgewaaid zijn? Heel hunne have hebben zij in ontucht opgegeten
met de wijven, met den drank, met het spel. Zij hebben zelfs geen
verroesten nagel meer om te krabben daar waar het jeukt. En nu eischen
zij het goed van kerken en kloosters!

"En daar, in hun gastmaal, bij dien truwant van Kuilenburg, met
dien anderen drinkebroer Brederode, hebben zij uit houten napjes
gedronken, uit minachting voor den heere van Berlaymont en mevrouwe de
landvoogdes. Ja, en zij hebben geroepen: "Leve de geus!" Ha! ware ik
in de plaats van den goeden God geweest, ik hadde hun drinken, bier
of wijn, veranderd in vuil, walgelijk schotelwater, ja, in vuile,
stinkende loog, waarin zij hunne vuile hemden en drekkige lakens
hadden kunnen wasschen.

"Ja, tiert, ezels die gij zijt, brult: "Leve de geus!" Ja, tiert maar
op, doch ik ben profeet. En al de verwenschingen, rampen, koortsen,
pesten, branden, verwoestingen, kankers, Engelsche zweetkoortsen en
zwarte pesten zullen over de Nederlanden vallen. Ja, en aldus zal God
gewroken worden over uw vuil getier van "Leve de geus!" En er blijft
geen steen uwer huizen over of geen splinter van uw verdoemde beenen,
die zoo haastig naar die vervloekte Calvinisterij en predikanterij
liepen. Het zij zoo! Amen!

--Laat ons gaan, sprak Uilenspiegel tot Lamme.

--Dadelijk, sprak Lamme.

En hij zocht onder de jonge en schoone kwezelkens, die naar het
sermoen geluisterd hadden; maar zijne vrouw vond hij niet.




XII.

Uilenspiegel en Lamme kwamen aan het Minnewater, hetwelk de groote
doctoren en wijsneuzige wijsgeeren halsstarrig doen afstammen van
Minrewater of Minderbroederswater.

Zij bleven op den oever staan en zij zagen vrouwen, meidekens en
knapen, arm in arm, met bloemen getooid, die malkander teederlijk in
de oogen bezagen en dicht tegen elkander gedrongen gingen.

Als Uilenspiegel hen zag, dacht hij aan Nele. En bij die weemoedige
herinnering, sprak hij treurig tot Lamme:

--Lamme, laat ons iets drinken.

Maar Lamme hoorde niet wat Uilenspiegel zegde; droefgeestig bezag
hij de verliefde paartjes.

--Weleer gingen wij ook aldus, arm in arm, mijne vrouw en ik, tot
groote afgunst van hen, die in alleenigheid, zonder geliefde levend,
nijdig ons nakeken.

--Kom, sprak Uilenspiegel, de Zeven vinden wij misschien op den bodem
eener pinte.

--Dat is drinkebroerspraat, antwoordde Lamme; de Zeven, dat weet gij
wel, zijn reuzen, die onder 't groot gewelf van Sint-Salvatorskerk
niet kunnen recht staan.

Uilenspiegel dacht treurig aan Nele. Ook dacht hij, dat hij misschien
in eene of andere afspanning een goed maal, een goed onderkomen en
een lieftallige bazinne zou vinden; hij sprak nogmaals:

--Laat ons iets drinken!

Maar Lamme luisterde niet en sprak, naar Onze-Lieve-Vrouwetoren
kijkend:

--Heilige Maria, patronesse der geoorloofde minne, verleen mij de
gunst, heur blanken boesem weder te zien,

--Kom mede, sprak Uilenspiegel, heur blanke boezem troont in de eene
of andere taveerne.

--Hoe durft gij dat zeggen? sprak Lamme.

--Wel zeker, sprak Uilenspiegel, ze moet ergens weerdinne zijn.

--Dronkemansuitvluchten, sprak Lamme.

Uilenspiegel vervolgde:

--Wellicht bewaart zij voor de arme zwervers een schotel gestoofd
ossevleesch, niet te vet, niet te droog, malsch lijk rozeblaadjes,
zwemmend tusschen menigvuldige kruidnagelen, notemuskaat,
hanekammetjes, kalfszwezerikken en andere hemelsche lekkernijen.

--Deugniet! sprak Lamme, gij wilt mij zeker doen sterven. Weet gij dan
niet, dat wij sedert twee dagen van droog brood en klein bier leven?

--Dat is praat van een gulzigaard, antwoordde Uilenspiegel. Gij
schreeuwt van honger; kom eten en drinken. Ik heb een halven gulden
en zal de kosten van 't gelag betalen.

Lamme lachte. Zij gingen hunne kar halen en, aldus door de stad
rijdend, zochten zij naar de beste afspanning. Doch zij trokken er
vele voorbij, als zij de zure gezichten van den baas of de bazinne
zagen, weinig aantrekkelijk uithangsbord voor een gezellige keuken.

Zij kwamen op de Zaterdagsmarkt en gingen het gasthof, de Blauwe
Lanteern binnen. Daar zag de weerd er vriendelijker uit.

Zij deden uitspannen en den ezel op stal zetten, in gezelschap van
een maatje haver. Zij lieten zich een keurig avondmaal opdienen,
aten hunne bekomst, sliepen als dassen en stonden 's morgens op,
om nog te eten. Lamme schitterde van genoegen en sprak:

--In mijne maag hoor ik een hemelsche muziek.

Als 't oogenblik van betalen gekomen was, ging de weerd bij Lamme en
sprak hij:

--'t Is tien oortjes.

--Hij heeft ze, zei Lamme, naar Uilenspiegel wijzend, die antwoordde:

--Ik heb ze niet.

--En de halve gulden?

--Ik heb er geen, sprak Uilenspiegel.

--'t Is gemakkelijk gezegd, sprak de baas; dan zal ik u uw wambuis
en hemd uittrekken.

Lamme, dien de drank moedig maakte, stond recht en riep uit:

--En als ik wil eten en drinken, ja, eten en drinken voor zeven en
twintig gulden en nog meer, zal ik het doen! Of meent gij, dat er
geen rooden duit in dezen buik steekt? Bij God! tot hiertoe werd hij
uitsluitend met ortolanen gevoed. Dergelijken buik zult gij nooit onder
uw vettigen gordelriem dragen. Bij mij ligt het vet drie duim dik op
den buik, terwijl gij het op den kraag van uw wambuis moet zoeken.

De weerd was buiten zich zelven van woede. Hakkelaar van nature,
wilde hij rap spreken; doch hoe meer hij zich haastte, hoe meer hij
moest niezen als een hond, die uit 't water komt. Middelerwijl wipte
Uilenspiegel bollekens brood naar zijn aangezicht. En Lamme, meer en
meer opgewonden, vervolgde:

--Ja, ik bezit genoeg voor uw drie magere hennen, uw vier schurftige
kiekens en dien grooten dwazerik van een pauw, die met zijn morsigen
steert het neerhof ginds ronddwijlt. En als uwe huid niet verrimpeld
was als die van een ouden haan, als uw beenderen niet vaneen vielen in
uwe borstkas, dan had ik nog genoeg om u ook op te eten, u, en uwen
snotterigen knecht, en uw halfblinde meid, en uwen kok, die gelukkig
mag zijn als hij 't schurft niet heeft, daar zijne armen te kort zijn
om zich ordentelijk te krabben.

--Bezie mij, vervolgde hij, bezie mij dien vogel eens, die, voor een
halven gulden, ons wambuis en ons hemde wil uitdoen! Daarom moet men
schaamtevrij zijn; heel zijne plunje is geen drie duiten weerd.

Maar de baas blies door zijnen neus van woede.

En Uilenspiegel wipte maar altoos bollekens brood naar zijn aangezicht.

Lamme, dapper als een leeuw, vervolgde:

--Hoeveel, magere tronie, hoeveel meent gij wel wat een ezel weerd
is, een ezel met een fijnen mond, met lange ooren, een breede borst,
met spieren als ijzer zoo sterk? Achttien gulden voor 't minst, is
't niet, armoedige baas? Hoeveel verroeste nagelen hebt gij wel,
om zulk schoon beest te betalen?

De baas blies nog meer door zijnen neus, doch dorst zich niet roeren.

Lamme sprak:

--Hoeveel meent gij, dat een schoone esschen kar geldt, die heel in
't blauw is geverfd en tegen zon en regen bespannen met eene huif
van Kortrijksch lijnwaad? Vier en twintig gulden voor 't minst,
niet waar? Vier en twintig gulden en achttien gulden, hoeveel maakt
dat? Antwoord, armzalige rekenmeester. En, daar het marktdag is en er
boeren in uwe ellendige afspanning zijn, ga ik ze dadelijk verkoopen.

Hetgene geschiedde, want allen kende Lamme. En inderdaad, voor ezel
en kar kreeg hij vier en veertig gulden en tien oortjes. Toen deed
hij het goud rinkelen onder den neus van den weerd, en sprak hij:

--Hewel, baas is hier geld genoeg om nog iets te peuzelen?

--Ja, sprak de baas.

En stille zegde hij:

--Als gij ooit uw vel verkoopt, geef ik er een oortje voor: 't zal
een amulet tegen overdadigheid wezen.

Doch een hupsch en lieftallig wijfje, dat in het donker binnenhof
stond, was verscheidene reizen voor 't venster naar Lamme komen zien,
en telkens dat hij heur schoon gezichtje kon bemerken, trok ze zich
schielijk achteruit.

's Avonds, als hij, zonder licht, waggelend de trap opklom, voelde
hij eene vrouw, die hem omarmde, hem kuste op zijne kaken, zijnen
mond, tot zelfs op zijn neus; zijn gezicht was nat van hare tranen,
na hetwelk zij hem liet voortgaan.

Lamme ging naar zijn bedde en sliep als een os, en 's anderen daags
trok hij met Uilenspiegel naar Gent.




XIII.

Daar zocht hij zijne vrouw in al de kaberdoeskens, danszalen en
taveernen. 's Avonds vond hij Uilenspiegel terug in den Zingenden
Zwaan. Uilenspiegel ging overal rond om het volk tot opstand te wekken,
tegen de beulen van den vaderlandschen bodem.

Op de Vrijdagsmarkt, omtrent de Dulle Griet, ging Uilenspiegel plat
op zijn buik ten gronde liggen.

Een kooldrager kwam voorbij en sprak:

--Wat doet gij daar?

--Ik maak mijnen neus nat om te zien van waar de wind komt, antwoordde
Uilenspiegel.

Een timmerman kwam.

--Neemt gij den grond voor een bedde? vroeg hij.

--Er zijn er, die hem weldra voor een deken zullen nemen antwoordde
Uilenspiegel.

Een monnik bleef staan.

--Wat doet dat kalf daar? vroeg hij.

--Het kalf vraagt plat op zijn buik uwen zegen, mijn vader, antwoordde
Uilenspiegel.

De monnik gaf hem dien en toog henen.

Toen legde Uilenspiegel zijn oor tegen den grond; een boer kwam
voorbij.

--Hoort gij daar iets? vroeg hij.

--Ja, sprak Uilenspiegel, ik hoor het hout groeien, hetwelk zal dienen
om de arme ketteren te verbranden.

--Hoort gij niets anders? vroeg een stadsserjant.

--Ik hoor, sprak Uilenspiegel, de Spaansche soldaten aandraven; als
gij iets hebt, dat dierbaar is, begraaf het dan, want weldra zijn de
steden niet meer veilig tegen de roovers.

--Hij is zot, zei de serjant.

--Hij is zot, herhaalden de poorters.




XIV.

Doch Lamme at of dronk niet meer, dacht standvastig aan den zoeten
droom op de trap in de Blauwe Lanteern. Zijn hert trok hem naar Brugge,
maar Uilenspiegel nam hem mede naar Antwerpen, alwaar hij jammerend
voort zocht.

Uilenspiegel ging in de taveernen en, sprekende over de plakkaten,
zeide hij tot goede Vlamingen, tot hervormden, ja zelfs tot
vrijheidminnende katholieken:

--Zij brengen ons de inquisitie mede, zoogezegd om ons lijf van
de ketterije te zuiveren, maar 't is ook voor onze beurze, dat die
rabarber zal dienen. Wij, die niets innemen tegen onze goesting, wij
zullen ons verzetten, muitmaken en de hand aan de wapenen slaan. Dat
weet de koning. Als hij ziet, dat wij zijne rabarber niet willen, zal
hij afkomen met lavementpijpen: dat zijn groote en kleine kanonnen,
falkonetten, slangen met wijden mond. Een koninklijk lavement,
kortom. En in het derwijze gepurgeerde Vlaanderenland zal geen begoede
burger meer overblijven. Gelukkige landen, die zulk een koninklijken
geneesheer hebben!

Maar de poorters lachten.

Uilenspiegel sprak: Lacht maar; doch vlucht of wapent u op den dag,
als er in Onze-Lieve-Vrouwekerk beelden worden gebroken.




XV.

Op 15 der Oogstmaand, den grooten dag van Maria en van de wijding
van kruiden en wortelen, wanneer de hennen, volgepropt met graan,
doof blijven voor 't geroep van den haan, werd aan eene der poorten
van Antwerpen, een groot steenen kruisbeeld aan stukken geslagen
door een Italiaan, in dienst van Granvelle. 's Zondags nadien ging
de ommegang van Onze-Lieve Vrouwekerk uit, voorafgegaan door groene,
gele en roode narren.

Maar het Mariabeeld werd onderwege gehoond door rapaille, dat riep:
"Maaiken, de uitdraagster, dit is uw laatste feestdag, want men zal
haast met u mosselen zieden"; het beeld werd ijlings in 't koor van
de kerk teruggebracht.

Uilenspiegel en Lamme gingen Onze-Lieve-Vrouwekerk binnen. Havelooze,
in lompen gehulde jongelieden en ook eenige volwassenen, elkeen
onbekend, stonden vóór het koor tot malkander zekere teekenen
en gebaren te maken. Zij maakten veel gerucht met voeten en
tongen. Niemand had ze ooit in Antwerpen gezien, of zag ze later
ooit weer. Een hunner, met een bruin gezicht als een verbrande ajuin,
vroeg of Maaiken--dat was Maria--bang was, daar ze zoo ijlings terug
in de kerk kwam.

--'t Is toch niet voor u dat ze bang is, leelijke moor, antwoordde
Uilenspiegel.

De jonge schoelje, tot wien hij sprak, kwam op hem af om hem te slaan,
maar Uilenspiegel nam hem bij den kraag en sprak:

--Als gij durft slaan, doe ik u uwe tong uitspuwen.

Zich vervolgens tot eenige Antwerpsche vrienden wendend, die daar
waren, zeide hij:

--Signoorkens en pagadders (naar de havelooze kerels wijzend),
betrouwt ze niet, 't zijn valsche Vlamingen, lafaards en verraders,
die betaald zijn om ons in kwaad, in ellende en in rampspoed te lokken.

Vervolgens tot het geboefte sprekend, zeide hij:

--Hewel, ezelskoppen, die uittdroogt van armoe, vanwaar haalt gij het
geld, dat thans in uwe beurze rinkelt? Hebt gij soms nu reeds uw vel
verkocht om er trommelen van te maken?

--Beziet eens dien preeker! riepen ze.

Toen begonnen zij allen samen te schelden, sprekende van
Onze-Lieve-Vrouwe:

--Maaiken heeft een schoon kleed! Maaiken heeft een schoone kroon! Ik
zal ze geven aan eene loddege van mijne kennis.

Zij gingen buiten, terwijl een onverlaat den predikstoel beklom om
er zotte reden te houden, en zij kwamen terug, roepende:

--Kom beneden, Maaiken, of wij komen u halen. Doe een mirakel, toon
nu eens dat gij kunt loopen, in stee van u laten dragen!

Maar Uilenspiegel riep te vergeefs: Rampzaligen, houdt op met uw
geschimp; alle plundering is misdaad! Zij gingen voort met hunne
heiligschendende taal en spraken zelfs van het koor binnen te breken
en Maaiken beneden te halen.

Daarop smeet een oude vrouw, die keersen verkocht in de kerk, hun de
assche van haren vuurpot in het gezicht; maar zij werd geslagen en
ten gronde gestampt, en daarna herbegon het geweld.

De markgraaf kwam in de kerk met zijne hellebaardiers. Toen hij het
volk samengeschoold zag, spoorde hij het aan de kerk te verlaten,
maar zoo weinig krachtdadig, dat slechts enkelen henen gingen; de
anderen spraken:

--Eerst moeten de kanunniken de vespers zingen, ter eere van Maaiken.

De markgraaf sprak:

--Er wordt niet gezongen.

--Dan zullen we zelven zingen was het antwoord.

Zoo deden zij in de zijbeuken en omtrent het portaal van de
kerk. Eenigen speelden met den bal en hinkelden met steentjes over
den vloer en zeiden: "Maaiken, nimmer speelt gij in het hemelrijk,
en gij verveelt u: kom spelen met ons".

En onophoudelijk hoonden zij het beeld, riepen, huilden en floten.

De markgraaf gebaarde bang te zijn en ging henen. Hij deed de deuren
sluiten behalve ééne.

En hoewel het gemeen er zich niet mee bemoeide, werden de galgenazen
stoutmoediger en riepen zij nog luider. Het gewelf weergalmde als onder
't gebulder van kanonnen.

Op den predikstoel klom er toen een. Hij scheen gezag te hebben;
met een gebaar deed hij allen zwijgen, en hij begon te preeken:

"In den naam des Vaders, des Zoons en des Heiligen Geestes,
drie zijn één en één is drie; God beware ons in 't hemelrijk van
dergelijke cijferkunde; op heden, vijftienden van de Oogstmaand, is
Maaiken met heur schoonste kleeren in triomf uitgegaan om haar houten
gezicht te toonen aan alle signoorkens en pagadders van de goede stad
Antwerpen. Maar onderwege in den ommegang, is Maaiken den duivel Satan
tegengekomen en Satan sprak lachend tot haar: "Zijt gij nu te fier
om den armen pagadder Satan goeden dag te zeggen, omdat gij gekleed
zijt als eene koningin, en gij gedragen wordt door vier signoren?" En
Maaiken antwoordde: "Gaat van hier, Satan, of ik verbrijzel u nogmaals
den kop!" "Maaiken, dat doet gij nu reeds vijftienhonderd jaar, maar
de Geest van den Heer uwen meester heeft mij verlost. Ik ben sterker
dan gij; gij zult mij op den kop niet meer trappen, en nu ga ik u een
dansken leeren. Satan nam een duchtige lederen zweep en begon er mee
te kletsen op Maaiken, die niet dorst schreeuwen om niet te laten
zien dat ze bang was; en toen is ze op den loop gegaan en deed zij
de signoorkens die haar droegen insgelijks loopen, opdat ze met heur
gouden kroon en rijke juweelen niet onder 't arme gemeene volk zou
vallen. En nu zit Maaiken koes en bevend in heur kot, te kijken naar
Satan, die daar omhoog op gindsche zuil zit, met de zweep in de hand,
en grijnslachend zegt: "Ik zal u het bloed en de tranen betaald zetten,
die vloeiden in uwen naam! Maaiken, hoe is 't met uwe onbevlektheid? Ge
moet rijden! We gaan u aan stukken slaan, leelijk houten beeld dat
ge zijt, voor al de beelden van vleesch en beenderen, die in uwen
naam genadeloos verbrand, gehangen en levend begraven werden." Aldus
sprak Satan, en hij had gelijk. En gij moet beneden, wreedaardig,
bloeddorstig Maaiken, want gij geleekt geenszins op uwen zoon Christus.

En heel de menigte handlangers riep en tierde en huilde:
"Maaiken! Maaiken, gij moet rijden! Maakt gij nu uw hemd nat van
schrik? Weg met de houten heiligen! Laat heur een bad in de Schelde
nemen! Hout drijft toch boven!"

Het volk aanhoorde hen zonder iets te zeggen.

Doch Uilenspiegel klom op den predikstoel, stampte met geweld den
spreker van de trappen en zei tot het volk:

--Dwazen, onnoozele dwazen, ziet gij dan niet verder dan uw neus lang
is? Begrijpt gij dan niet, dat dit alles verraderswerk is? Zij willen
u tot heiligschenners en tot beeldbrekers maken, om u tot muiters te
kunnen verklaren, uwe kisten te ledigen, u te onthalzen en levend
te verbranden! En de koning zal erven! Signoorkens en pagadders,
hecht geen geloof aan de woorden dier bewerkers van rampspoed: laat
Onze-Lieve-Vrouw in heure nis, leeft kloekmoedig, werkt blijgezind en
geniet van uwe winsten en profijten. De zwarte duivel des rampspoeds
heeft u in 't oog, en 't is door plundering en vernieling, dat hij het
vijandelijke leger zal roepen om u als rebellen te behandelen en Alva
over u te doen regeeren door dictatuur, inquisitie, verbeurdverklaring
en dood!

... En hij zal erven!

--Laas, sprak Lamme, plundert niet, signoorkens en pagadders; de
koning is al kwaad genoeg. De dochter van de borduurster heeft het
tot mijn vriend Uilenspiegel gezegd. Plundert niet, mijne heeren!

Maar het gemeen kon hen niet hooren.

De handlangers riepen:

--Ze moet beneden! In de Schelde, de houten heiligen. Hout drijft
toch boven!

Uilenspiegel klampte zich aan den preekstoel vast en riep tevergeefs:

--Signoorkens en pagadders, duldt de plundering niet! Brengt uwe stad
niet ten onder!

En hij werd weggerukt met gekwetst gelaat, wambuis en hoos gescheurd,
hoewel hij zich dapper verweerde met vuisten en voeten. En heel
bebloed, hield hij niet op te roepen:

--Duldt de plundering niet!

Maar het was te vergeefs.

De onbekenden en het grauw van de stad liepen tegen het hek van het
koor aan, hetwelk zij braken al roepend:

--Vive le geus!

Allen begonnen te breken, te plunderen, te vernielen. Vóór middernacht
was die groote kerk, in dewelke zeventig autaren, allerhande schoone
schilderijen en kostbaarheden waren, teenemaal ledig. De autaren
werden aan stukken geslagen, de beelden werden van hunne pedestalen
getrokken, uit hunne nissen gerukt, op den vloer geworpen en met
hamers verbrijzeld en de gewijde olie tot schoensmeer gebezigd. Toen
er niets meer te breken viel, trok de bende naar de Minderbroeders,
De Franciscanen, Sint-Pieters, Sint-Andries, Sint-Jacobs, Sint-Joris,
Sint-Michiels, de Peterpotkerk, den Burcht, het Fawkensklooster,
de Witte Zusters, de Grijze Zusters, de Predikheeren en al de
kerken en kapellen van de stad, om er te werk te gaan als in
Onze-Lieve-Vrouwe. Zij namen waskeersen en flambouwen en liepen er
mee overal rond.

En onder hen was geen getwist nog krakeel; geen hunner werd gekwetst
in die groote afbraak van steen, van hout en andere stoffen.

Zij trokken naar den-Haag, om er de beelden en autaren weg te nemen;
doch daar noch elders verleenden de protestanten hun hulp.

In den-Haag vroeg de magistraat hun, waar hunne lastgeving was.

--Hier, sprak een hunner, en hij sloeg op zijn hert.

--Hoort gij, signoorkens en pagadders? Hunne lastgeving! sprak
Uilenspiegel, die het feit vernomen had. Er is dus iemand, die hun
last geeft het werk van heiligschenners te doen! Als een dief mijne
hut binnendringt, zal ik doen als de magistraat van den-Haag, en
zal ik, mijn hoedeken afnemend, vragen: Lieve schelm, beminnelijke
dieper, eerbiedweerdige roover, waar is uwe lastgeving? Hij zal
wijzen naar zijn hert, dat dorst naar mijne have. En ik zal hem al
mijne sleutels ter hand stellen! Zoekt, zoekt wien de plundering
baat. Mistrouwt den Rooden Hond; de misdaad is begaan, de beteugeling
zal volgen. Mistrouwt den Rooden Hond! Het groote steenen kruisbeeld
is aan stukken geslagen. Mistrouwt den Rooden Hond!

Toen Uilenspiegel vernam dat de Groote Raad van Mechelen, door den
mond van zijnen voorzitter Viglius, geboden had den beeldenstorm
geenerlei verzet te bieden, sprak hij:

--Laas! de oogst is rijp voor de Spaansche maaiers. De hertog! de
hertog nadert! Vlamingen, de zee, de zee der wrake wast. Arme
vrouwen en meidekens, vlucht den put. Arme mannen, vlucht de galg,
het vuur en het zweerd! Philippus wil het bloedig werk van keizer
Karel voltooien. De vader zaaide dood en ballingschap; de zoon heeft
gezworen, dat hij liever over een kerkhof dan over een kettervolk
heerscht. Vlucht, daar zijn de beul en de grafmakers.

Het volk luisterde naar Uilenspiegel, en honderden gezinnen verlieten
de steden, en de wegen waren vervuld met karren vol huisraad van
allen die in ballingschap gingen.

En Uilenspiegel ging overal, gevolgd door Lamme, die jammerend zocht
naar zijne vrouw.

En te Damme weende Nele bij de uitzinnige Katelijne.




XVI.

Toen Uilenspiegel, in de Wijnmaand, te Gent was, kwam hij Egmond
tegen, die gegastreerd had in het edel gezelschap van den abt
van Sint-Baafs. Neurend, dede hij droomerig zijn peerd op stap
gaan. Eensklaps keek hij op, en zag hij eenen man, die met een
brandende lanteerne naast hem ging.

--Wat wilt ge? vroeg Egmond.

--Uw welzijn, antwoordde Uilenspiegel, zooveel welzijn, als een
brandende lanteerne kan geven.

--Ga heen en laat mij, sprak de graaf.

--Ik zal niet gaan, antwoordde Uilenspiegel.

--Moet gij dan van de zweep hebben?

--Ik wil er wel tienmaal van hebben, als ik in uw hoofd zulk eene
lanteerne kan steken, dat gij klaar ziet tot in 't Escuriaal.

--Ik heb zaken met uwe lanteerne noch met 't Escuriaal, antwoordde
de graaf.

--Wel, antwoordde Uilenspiegel, ik kan mij niet weerhouden u een
goeden raad te geven.

Hij greep het peerd des graven bij den teugel en, terwijl het sloeg
en steigerde, sprak hij:

--Heere, gedenk toch, dat gij thans goed op uw peerd danst en dat
uw hoofd ook goed op uwe schouderen danst; maar de koning wil, naar
men zegt, dien schoonen dans afbreken, u uw lijf laten, maar uw hoofd
nemen om het zoo verre van hier te doen dansen, dat gij het nimmermeer
krijgen kunt. Geef mij een gulden, ik heb hem verdiend.

--Van de zweep, als gij niet wegkomt, ongeluksvogel.

--Heer, ik ben Uilenspiegel, zoon van Klaas, die levend verbrand werd
voor het geloof, en van Soetkin, die stierf van verdriet. De assche
die klopt op mijne borst, zegt mij, dat Egmond, de dappere krijgsman,
met de landwacht, die hij aanvoert, tegen den hertog van Alva zijne
driemaal zegevierende troepen kan stellen.

--Ga heen, antwoordde Egmond, ik ben geen verrader.

--Red onze landen, gij alleen vermoogt het, sprak Uilenspiegel.

De graaf wilde hem slaan met zijne zweep, doch Uilenspiegel bleef op
de slagen niet wachten, wegvluchtend riep hij nog:

--Eet lanteernen, eet lanteernen, heer graaf. Red onze landen!

Op een anderen dag hield Egmond stil voor de afspanning het Bont
Verken, gehouden door een lieftallige bazinne van Kortrijk, het
Muizeken geheeten.

De graaf stond recht op zijne stijgbeugels en riep:

--Is er iemand?

Uilenspiegel, die bij 't Muizeken diende, kwam vóór met een tinnen
beker in eene hand en in de andere eene bottel vol rooden wijn.

De graaf herkende hem:

--Ha, gij zijt het, ongeluksvogel, sprak hij.

--Heere, antwoordde Uilenspiegel, kunt gij mij zeggen wat het roodst
is, óf de wijn die door de keel vloeit, óf het bloed dat uit den hals
stroomt? Dat was het wat mijne lanteerne vroeg.

De graaf antwoordde niet, dronk, betaalde en vertrok.




XVII.

Uilenspiegel en Lamme, elk gezeten op een ezel, dien zij kregen van
Simon Simonsen, een der getrouwen van den prins van Oranje, reden
overal rond om de poorters te verwittigen van de snoode inzichten
van den bloedigen koning en om tijdingen uit Spanje te vernemen.

Zij verkochten groenten, waren gekleed als boeren en liepen de
markten af.

Bij het terugkeeren van de markt van Brussel, zagen zij in een steenen
huis, op de Kareelkaai, in een lage kamer, eene dame gekleed in samijt,
hoog van kleur, vol van boezem en schalksch van oog.

Zij sprak tot een jonge en poezele keukenmeid:

--Gij zult een goede klont boter in de pan moeten smelten, want ik
houd niet van saus met ijzersmaak.

Uilenspiegel stak zijn neus voor het venster.

--Ik wel, sprak hij, want een hongerige maag kan veel verdragen.

De dame keerde zich om en sprak:

Wat is dat voor een moeial, die zich met mijne keuken bemoeit?

--Eilaas! schoone dame, sprak Uilenspiegel, liet ge mij er een weinig
mede bemoeien in uwe gezelschap, ik leerde u gerechten uit vreemde
streken maken, die onze dames niet kennen.

En smakkende, zei hij:

--Ik heb dorst.

--Naar wat? vroeg zij.

--Naar u, sprak hij.

--Hij is schoon, zei de keukenprinses tot de dame. Willen wij hem
binnenlaten, hij zal ons zijne avonturen vertellen.

--Maar zij zijn getweeën.

--Ik gelast mij met éénen, hernam de keukenmeid.

--Mevrouwe, sprak Uilenspiegel, 't is waar, we zijn getweeën: ik en
mijn arme Lamme, die geen honderd pond op den rug kan dragen, doch
gemakkelijk met vijfhonderd pond eten en drinken op de maag loopt.

--Jongen, zei Lamme, spot niet met mij; 't is al ongelukkig genoeg,
dat mijn buik mij zoo duur kost.

--Vandaag kost hij u geen duit, sprak de dame. Komt beiden binnen.

--Maar, sprak Lamme, er zijn ook twee ezelen, waarop wij zitten.

--In den stal van den grave van Meghem is geene haver te kort,
antwoordde de dame.

De keukenmeid liet heure braadpannen staan en bracht Uilenspiegel en
Lamme op het binnenhof, en de ezels begonnen seffens te balken.

--Ze rieken eten en ze schateren uit van vreugde, de arme dieren,
sprak Uilenspiegel.

Toen beiden van hunne ezels waren gestegen, sprak Uilenspiegel tot
de keukenmeid:

--Zoudt gij een ezel lijk ik willen, als gij een ezelinnetje waart?

--Ik zou een jongen met een vroolijk gezicht willen, als ik eene
vrouw was, antwoordde zij.

--Wat zijt gij dan, als gij vrouw noch ezelin zijt? vroeg Lamme.

--Eene maagd, sprak zij, eene maagd is geene vrouw, en eene ezelin
evenmin: begrijpt gij, dikzak?

Uilenspiegel sprak tot Lamme:

--Gij moet heur niet gelooven, 't is een deugnietje en een
duivelinneken. Beëlzebub heeft ze van nu af aan verkoren tot zijne
gezellin in de helle.

--Leelijke spotter, antwoordde de keukenmeid.

De dame sprak:

--Drinkt eerst eene pint bruinbier, eet een stuk hesp, snijdt van
dien bout, opent de pastei en proeft de salade.

Uilenspiegel vouwde de handen te zamen.

--Hesp, sprak hij, is heerlijk eten; bruinbier, hemelsche drank,
hamelbout, goddelijk vleesch; een gevulde pastei doet de tong van
genoegen trillen; een geurige salade is een vorstelijke spijs. Doch
zalig is hij, die uwe schoonheid tot nagerecht krijgt.

--Hoor hem eens bezig. Toe, eet, ondeugende jongen!

Uilenspiegel antwoordde:

--Zou ik niet liever beginnen met de dankzegging?

--Neen, sprak zij.

Maar Lamme was jammerlijk aan 't zuchten:

--Ik heb honger.

--Gij zult eten, sprak de schoone dame, vermits gij over niets anders
bekommert zijt dan over uwen buik.

--Ha! en mijne vrouw, zuchtte Lamme, als om heur gezegde te
logenstraffen.

Maar die woorden stelden de meid teleur. Lamme en Uilenspiegel aten
buik-sta-bij en dronken als tempeliers. En de dame gaf dien nacht
nog te eten aan Uilenspiegel en ook 's anderen daags en volgende dagen.

De ezels kregen een dobbel maatje haver en Lamme dobbel rantsoen. Eene
week lang bleef hij in de keuken geplakt en sloeg hij menigerhande
schotels naar binnen, maar hij hield zich niet bezig met de meid,
want hij dacht te veel aan zijne vrouw.

Dat maakte de dienstmeid spijtig, en ze zei, dat het een schande
was den menschen al dien last aan te doen, om uitsluitend aan zijn
vettigen buik te denken.

En intusschen leefden Uilenspiegel en de dame zeer vriendschappelijk
samen. Eens zegde zij tot hem:

Thijl, zoudt gij de verdediging uwer gemartelde broederen op u nemen?

--De assche van Klaas klopt op mijne borst, antwoordde Uilenspiegel.

--Zóó zijt gij schoon, riep zij uit. Maar wie is die Klaas?

Uilenspiegel antwoordde:

--Mijn vader, die voor het geloove verbrand werd.

--De grave van Meghem lijkt geenszins op u, sprak zij; hij wil eene
lating toedienen aan de stad, die ik minne, want ik ben van Antwerpen,
de zeeghaftige stede. Weet dus, dat hij overeengekomen is met Scheyf,
den raadsheer van Brabant, om zijne tien vendels voetvolk in Antwerpen
te brengen.

--Dat zal ik den poorters gaan zeggen, sprak Uilenspiegel; en hij ijlde
weg, rap als de wind. 's Anderen daags waren de poorters te wapen.

Doch Uilenspiegel en Lamme, die hunne ezels op stal gezet hadden
bij eenen pachter van Simon Simonsen, moesten zich schuil houden,
uit vreeze voor den grave van Meghem, die hen overal deed zoeken om
ze te hangen; want hij had vernomen, dat twee heretieken van zijn
vleesch gegeten en van zijnen wijn gedronken hadden.

De grave was jaloersch, en zeide het tot de schoone edelvrouwe,
die knarsetande, weende en wel zeventien reizen in onmacht viel. De
keukenmeid volgde heur voorbeeld, maar zoo dikwijls niet en verzekerde,
op heur aandeel in 't hemelrijk en heurer ziele zaligheid, dat zij en
heure Mevrouw niets anders gedaan hadden dan het afval van 't eetmaal
gegeven aan twee armzalige pelgrims, die op magere ezelen gezeten,
voor het keukenvenster waren komen staan,--en méér niet.

En dien dag vloeiden er zoovele tranen, dat de grond teenemale nat
was. Dit ziende, schonk messire van Meghem geloof aan heure woorden.

Lamme dorst niet meer teruggaan naar het huis van den edelen heere,
want telkens dat de keukenmeid zijn neus zag, begon zij zelve te
zuchten en te jammeren: Ha! mijne vrouw!

En hij was mistroostig, om den wille van het eten; doch Uilenspiegel
bracht hem altoos eenige lekkere kliekjes mede, want hij drong in
het huis langs de Sinte-Katelijnestraat, en hield er zich op den
zolder verscholen.

's Anderen daags, na de vespers, beleed de grave van Meghem aan de
schoone vrouwe, dat hij besloten had vóór den dageraad met zijne
soldaten 's-Hertogenbosch binnen te dringen. Dan viel hij in slaap.

De gravinne liep naar den zolder om Uilenspiegel te vertellen hetgeen
zij wist.




XVIII.

Verkleed als pelgrim, zonder geld, zonder mond behoeften, trok
Uilenspiegel dadelijk naar 's Hertogenbosch, om de poorters te
waarschuwen.

Hij was van zins een peerd te nemen bij Jeroen Praet, broeder van
Simon, voor wien hij brieven van den prins had, om van daar spoorslags,
langs de binnenwegen naar 's Bosch te rijden.

Op den steenweg, hoorde hij eene bende huurlingen achter zich
aanstappen. Hij verschrikte hevig, om reden van de brieven.

Vast besloten allen tegenspoed het hoofd te bieden, bleef hij staan om
Onze-Vaders te mompelen: toen zij hem ingehaald hadden, ging hij mede
met hen, en alzoo vernam hij, dat zij naar 's Hertogenbosch trokken.

Een Waalsch vendel opende den marsch. Aan het hoofd reden kapitein
Lamotte en zijne wacht van zes hellebaardiers; vervolgens, naar
rangorde, de vendrig met eene kleinere wacht, de provoost, zijne
hellebaardiers en zijne twee vangmannen, het hoofd van de wacht,
de trosbewaarder, de beul en zijne knecht; dan volgden pijpen en
tamboerijnen met een oorverdoovend lawijd.

Vervolgens kwam een Vlaamsch vendel van tweehonderd soldaten, met
zijn kapitein, zijn vendrig, en verdeeld in twee afdeelingen van
honderd man, elk aangevoerd door de bent-serjanten, en onderverdeeld
in rotten, geleid door tiendeniers of rotmeesters. De provoost en zijne
stokknechten waren mede voorafgegaan door pijpers en tamboerijnslagers,
die bliezen en roffelden om 't hardst.

Achter hen reden twee wagens, vol schoone, gichelende meidekens,
de lieven der soldaten. Joelend, dartelend en schaterend, etend,
drinkend en dansend, volgden de schoone, dolle meidekens den tros.

Er waren er gekleed als landsknechten, maar in fijn, helderwit
lijnwaad, uitgesneden aan de borst, uitgebekt aan mouwen en beenen,
aan het wambuis, zoodat men heure donzige huid kon zien; op het hoofd
droegen zij fijn lijnwaden kappen, met goud afgelegd, en met schoone
wapperende struisvogelpluimen. Aan heure goudlinnen gordelbanden,
gestikt met rood satijn, hingen de goudlakensche scheeden heurer
dolkmessen. En heure schoenen, kousen en hozen, heure wambuizen en
rijgsnoeren waren van witte zijde en klatermeerse.

Anderen waren insgelijks als landsknechten gekleed, doch in blauwe,
groene, scharlaken, paarse, karmozijnen stoffen, uitgebekt, geborduurd
en met wapenen versierd, naar alle grillen en vindingen. En allen
droegen op den arm een rood schijfje, tot teeken van heur bedrijf.

De hoerwijfel, haar serjant, wilde haar het zwijgen opleggen; maar zij
deden hem lachen door heur grappige woorden en bekoorlijke gebaren,
en naar zijne vermaningen luisterden zij niet.

Uilenspiegel, in zijn pelgrimspij, ging naast de twee vendels,
gelijk een speeljacht, dat vaart naast een oorlogsschip. En hij
knauwde steeds voort Onze-Vaders.

Eensklaps sprak Lamotte tot hem:

--Waar gaat gij aldus, reizende pelgrim?

--Heer kapitein, antwoordde Uilenspiegel die honger had, weleer
bedreef ik een groote zonde, en 't kapittel van Onze-Lieve-Vrouwekerk
veroordeelde mij, te voet naar Rome vergiffenis te gaan vragen aan
den Heiligen Vader, die ze mij verleende. Nu kom ik gereinigd in deze
landen terug, op voorwaarde onderwege de Heilige Mysteriën te prediken
voor alle soldaten, die ik zou ontmoeten en die mij, in ruil mijner
sermoenen, brood en vleesch moeten geven. En aldus preekend, voorzie
ik in mijn armzalig bestaan. Wilt gij mij de toelating schenken,
bij de eerste pleisterplaats mijn gelofte te houden?

--Ja, sprak messire van Lamotte.

Zich broederlijk mengend onder Walen en Vlamingen, vergat Uilenspiegel
niet, van tijd tot tijd te tasten naar de brieven onder zijn wambuis.

De lustige deernen riepen hem toe:

--Pelgrim, schoone pelgrim, kom hier en laat ons hooren den gloed
uwer rede.

Uilenspiegel naderde heur en zeide vol zedigheid:

--Zusteren in Christus, spot niet met een armen pelgrim, die allerwegen
het heilig geloof voor de soldaten moet preeken.

En met de oogen verslond hij de lieve meidekens.

Maar de lustige wijven staken heure blijde gezichten door de gaten
van het zeil van den wagen.

--Ge zijt wel jong, spraken zij, om voor de soldaten te preeken. Kom
in onze wagens, wij zullen een blijdere taal tot u spreken.

Uilenspiegel had geerne gedaan zooals zij zeiden, maar hij dorst niet,
om reden van de brieven; reeds hadden er twee heure ronde blanke armen
uit den wagen gestoken, om hem op te trekken, maar de hoerwijfel,
die jaloersch was, snauwde tot Uilenspiegel:

--Ga weg of ik kap uw hoofd af!

En Uilenspiegel verwijderde zich van den wagen, dorstige blikken
werpend naar de frissche deernen, die de zonne met licht overstroomde.

Men kwam te Berchem; Philip de Lannoy, heere van Beauvoir, aanvoerder
der Vlamingen, beval daar halt te houden.

Daar stond een eik van middelbare grootte, met een enkelen tak
afgebroken in 't midden en waaraan, eene maand geleden, een wederdooper
had gehangen.

De soldaten bleven staan, en de marketensters kwamen bij hen
om hun brood, vleesch, wijn, bier en allerhande toespijzen te
verkoopen. Aan de lustige wijvekens verkochten zij suikergebak,
krakelingen, amandelen, taartjes. Als Uilenspiegel dat zag, kreeg
hij nog grooteren honger.

Vlug als een aap, klom Uilenspiegel op den boom en zette zich op
den dikken tak, zeven voet boven den grond. Daar sloeg hij zich met
eene geeselkoord, terwijl de soldaten en hunne lieven rond den boom
kwamen staan.

--In den naam des Vaders, des Zoons en des Heiligen Geestes, sprak
hij. Amen! Er staat geschreven: Wie aan den arme geeft, leent aan God:
dappere krijgslieden, en gij ook, schoone damen, leent aan God: 't is
te zeggen, geeft mij brood, vleesch, wijn, bier, als gij wilt, en de
taartjes die gij missen kunt, en God, die rijk is, zal U alles dobbel
teruggeven, met dozijnen ortolanen, beken malvezij, bergen kandijsuiker
en rijstpap, die gij in 't hemelrijk zult eten met zilveren lepels.

Vervolgens jammerend:

--Ziet gij niet door welke wreede smerten ik beproef, vergiffenis
mijner zonden te bekomen? Zoudt gij de bijtende pijn dier geeseling
niet lenigen, die tot bloedens toe mijnen rug kwetst?

--Wat is dat voor een zot? vroegen de soldaten.

--Mijne vrienden, antwoordde Uilenspiegel, zot ben ik niet,
doch boetveerdig en stervend van honger; want terwijl mijn geest
zijne zonden beweent, beweent mijn buik het gebrek aan smakelijke
spijzen. Brave soldaten en gij, schoone meidekens, bij u zie ik vette
hesp, gebraden ganzen, worsten, wijn, bier en taartjes, in grooten
getale. Hebt gij niets over voor den armen pelgrim?

--Ja, ja, riepen de Vlaamsche soldaten, zijne tronie bevalt ons.

En allen wierpen stukken eten naar hem. Op zijn tak gezeten, hield
Uilenspiegel niet op met bidden en spreken.

--De honger, sprak hij, maakt den mensch wederspannig tegen het gebed,
doch een stuk hesp neemt die kwade stemming dadelijk weg.

--Pas op uw hoofd! riep een serjant, terwijl hij een half volle flesch
naar hem wierp.

Uilenspiegel greep de flesch en, met kleine slokjes drinkend,
sprak hij:

--Zoo razende honger schadelijk is voor 't lichaam des menschen, is
er nog iets, dat even nadeelig is: te weten de angst van den armen
pelgrim, die van goedhertige soldaten een klein stukje hesp en een
heele bottel bier kreeg. Want gewoonlijk is de pelgrim sober van aard,
en zoo hij dronk met te weinig eten in de maag, ware hij dadelijk zat.

Terwijl hij sprak, ving hij eene ganzebil.

--In de lucht weidevisch vangen, sprak hij, is iets wondersbaars. Maar
de vangst is verdwenen in mijn keelgat. Wat is er gretiger dan droog
zand? Een onvruchtbare vrouw en een hongerige maag.

Plotseling voelde hij de punt eener hellebaard in zijne bil steken. En
eenen vendrig hoorde hij zeggen:

--Versmaden de pelgrims nu hamelbout?

Uilenspiegel zag op de punt van de hellebaard een groot stuk hamelbout
steken.

Hij nam het en sprak:

Bout voor bout, liever heb ik er zoo een tusschen mijn tanden dan
zoo'n ijzeren tegen mijn maag.

--Uit medelijden trek ik dit stuk hamelbout van uw wapen. Van het
mergbeen zal ik eene pijp maken om uwen lof te bezingen, goedhertige
hellebaardier.

... Nochtans, ging hij voort, terwijl hij het been afknaagde, wat
is een bout, hij moge nog zoo lekker en sappig wezen, zoo den armen
pelgrim geen vriendelijk taartje komt toelachen?

Terwijl hij dus sprak, sloeg hij de hand vóór het gezicht, want twee
taartjes, die uit de vrouwengroep kwamen, vlogen het een op zijn
oog, het andere op zijne kaak. De meidekens schaterden van lachen en
Uilenspiegel sprak:

--Wel bedankt, lieve meidekens, die mij roomkusjes zendt!

Maar de taartjes waren ten gronde gevallen.

Plotseling roffelden de trommels, bliezen de pijpen en zetten de
soldaten zich weder op marsch.

Messire van Beauvoir beval Uilenspiegel van den boom te komen en
nevens de soldaten te stappen. Doch Uilenspiegel had honderd uren
van dáár willen zijn, want uit de woorden van eenige soldaten maakte
hij op, dat hij verdacht voorkwam en dat zij hem wel voor een spion
konden nemen; dan zouden zij hem aftasten, en dit was zeker de galge,
als ze zijne brieven ontdekten.

Hij liet zich dus in eene greppel vallen en riep:

--Medelijden, heeren soldaten, mijn been is gebroken, ik kan niet
meer gaan; laat mij meerijden in den wagen der vrouwen.

Maar hij wist, dat de hoerwijfel het niet zou gedoogen.

Van uit haren wagen riepen de vrouwen:

--Ja, kom, schoone pelgrim, kom bij ons. Wij zullen u minnen, u
streelen, u kussen, en gij zult genezen zijn.

--Ik weet het, sprak hij, vrouwenhanden zijn hemelsche balsem voor
alle wonden.

Maar de jaloersche hoerwijfel sprak tot messire van Lamotte:

--Messire, ik geloof dat die pelgrim den spot bij ons drijft, en
dat zijn been maar alleen gebroken is, om bij de vrouwen mede te
rijden. Beveel, dat men hem op den weg late liggen.

--Zoo zal geschieden, sprak messire van Lamotte.

En men liet Uilenspiegel liggen.

Eenige soldaten, die meenden dat zijn been waarlijk gebroken was,
hadden spijt dat men een christenmensch zoo maar liet liggen, want ze
vonden dat hij een lustige kwant was. Zij gaven hem vleesch en wijn
voor twee dagen. De meidekens hadden hem geerne geholpen, doch wijl zij
niet mochten, smeten zij hem de krakelingen toe, die zij nog hadden.

Als de troep verre was, koos Uilenspiegel het hazenpad. Hij kocht
een peerd en rende vlug als de wind, over wegen en paden, naar
's-Hertogenbosch.

Bij de tijding van de komst der heeren Beauvoir en Lamotte, grepen
die van de stad, ten getale van achthonderd, naar de wapenen; zij
kozen aanvoerders en zonden Uilenspiegel, in kooldrager gekleed,
naar Antwerpen om hulp te vragen aan den machtigen Brederode.

En de soldaten der heeren Lamotte en Beauvoir konden niet binnen in
's-Hertogenbosch, de wakkere stede, die zich dapper verweerde.




XIX.

De volgende maand gaf zekere doctor Agileus twee gulden aan
Uilenspiegel en brieven voor Simon Praet, die hem zou zeggen wat hij
te doen had.

Uilenspiegel kreeg bij Praet eten en slapen. Zijn slaap was goed,
zoo goed als zijn tronie; Praet, daarentegen, was schraal en droevig,
altoos in naargeestige gedachten verslonden. En Uilenspiegel was
verwonderd dat hij, als hij 's nachts bij toeval wakker werd, hoorde
kloppen met een hamer.

En hij mocht nog zoo vroeg opstaan, Simon Praet was altijd vóór hem
op, en droever was zijn gelaat, en somberder zijne blikken, als iemand
die bereid is tot sterven of strijden.

Somtijds, bij een zucht, vouwde Praet de handen biddend te zamen en
scheen hij vol verontweerdiging. Zijne vingeren, alsook zijn hemd en
zijn armen, waren vettig en zwart.

Uilenspiegel wilde weten van waar de hamerslagen, de zwarte armen en
Praet's neerslachtigheid kwamen. Op een avond, dat hij in de taveerne
de Blauwe Gans was gebleven, in gezelschap van Simon, die er zijns
ondanks gegaan was, gebaarde hij zoo dronken te zijn en zoo'n zeer
in het hoofd te hebben, dat hij zich onverwijld te bedde moest leggen.

En Praet bracht hem neerslachtig naar huis.

Uilenspiegel sliep op den zolder, bij de katten; het bed van Simon
was beneden, dicht bij den kelder.

Uilenspiegel die dronkenschap bleef voorwenden, klom waggelend de trap
op, en gebaarde schier te vallen, als hij naar de koord greep. Simon
kwam hem ter hulp als een broeder, met teedere zorgen. Hij hielp hem
in zijn bed; hij had medelijden met hem en bad God, dat Hij hem zijne
dronkenschap zou vergeven. Dan ging hij naar beneden en weldra hoorde
Uilenspiegel hetzelfde geklop, dat hem zoo dikwijls gewekt had.

Zonder gerucht stond hij op en daalde op bloote voeten de smalle
treden af; als hij er twee en zeventig geteld had, stond hij vóór
een kleine deur die op een kier stond, waardoor een licht flikkerde.

Simon drukte vliegende blaadjes met oude letteren uit den tijd van
Laurens Coster, den uitvinder van de edele drukkunst.

--Wat doet gij daar? vroeg Uilenspiegel.

Verschrikt gaf Simon hem tot antwoord:

--Klaag mij aan, zoo gij van den duivel zijt: ik zal sterven; maar
zijt gij van God, dat uw mond het gevang uwer tong zij.

--Ik ben van God, antwoordde Uilenspiegel, en wil u geenerlei
kwaad. Maar wat doet gij daar?

--Ik prent bijbels, antwoordde Simon. Want als ik, om vrouw en kinderen
te spijzen, 's daags de booze en wreede edicten Zijner Majesteit
drukken moet, 's nachts ben ik de zaaier van 't echte woord Gods en
herstel ik het kwaad, dat ik bedrijf in den dag.

--Gij zijt braaf en moedig, sprak Uilenspiegel.

--Ik heb het geloove, antwoordde Simon.

Inderdaad, uit die heilige drukkerij was het, dat de Vlaamsche bijbels
kwamen, die verspreid werden in Brabant, in Vlaanderen, in Holland,
in Zeeland, Utrecht, Noord-Brabant, Overijsel, Gelderland, tot den
dag, waarop Simon veroordeeld werd tot het schavot en aan Christus
en de gerechtigheid zijn leven offerde.




XX.

Eens vroeg Simon aan Uilenspiegel:

--Hebt gij moed, broeder?

--Ik heb er genoeg, antwoordde Uilenspiegel, om eenen Spanjaard te
geeselen totdat de dood er op volge, om eenen moordenaar te dooden,
eenen beul onschadelijk te maken.

--Zoudt gij, vroeg de drukker, geduld genoeg hebben om in eenen
schoorsteen te blijven, ten einde te luisteren wat in eene kamer
gezegd wordt?

Uilenspiegel antwoordde:

--Wijl ik door de gratie Gods stevige lenden en fiksche beenen bezit,
kan ik, als de katten, blijven staan waar ik ben.

--Hebt gij geduld en een goed geheugen? vroeg Simon.

--De assche van Klaas klopt op mijne borst, antwoordde Uilenspiegel.

--Nu, luister, sprak de drukker, neem deze aldus gevouwen speelkaart
en ga naar Dendermonde; daar zult gij tweemaal hard en eenmaal
zachtjes kloppen aan de deur van het huis, waarvan de gevel hierop is
geteekend. Iemand zal opendoen en u vragen of gij de schouwveger zijt;
gij zult antwoorden dat gij mager zijt en de kaart niet verloren
hebt. En gij zult ze hem toonen. Dan, Thijl, moet gij doen wat er
hoeft. Groote rampen zweven over Vlaanderenland. Men zal u eene schouw
toonen, gereedgemaakt en geveegd; daar zullen krammen voor uwe voeten
zijn en, om te zitten, een berd, dat stevig vastgemaakt is. Als hij,
die u binnen liet, u zegt in de schouw te kruipen, zult gij het
doen, en gij zult daar stil wachten. Adellijke heeren zullen daar
bijeenkomen, in de kamer vóór de schouw, waarin gij zijn zult. Het
zijn Willem de Zwijger, de prins van Oranje, de graven van Egmond,
van Hoorne, van Hoogstraten en Lodewijk van Nassau, de dappere broeder
des Zwijgers. Wij, hervormden, willen weten wat die heeren willen en
kunnen voor de redding onzer landen.

Nu, den eersten April, deed Uilenspiegel zooals hem gezegd was. Hij
was tevreden, dat er geen vuur in den heerd brandde en zei tot zich
zelven: hoe minder rook hoe scherper het gehoor.

Weldra werd de deur van de kamer geopend, en een tocht trok door
de schouw. Geduldig verdroeg hij den wind, zeggende: hij zal mijn
aandacht aanwakkeren.

Vervolgens hoorde hij de heeren van Oranje, van Egmond en de
anderen de kamer binnentreden. Zij spraken over hunne vreeze,
over de gramschap des konings en over het slecht beheer van 's
lands zaken en penningen. Een hunner sprak op bitsen, hoogmoedigen,
helderen toon. Het was Egmond. Uilenspiegel herkende hem, lijk hij ook
Hoogstraten herkende aan zijn heesche stem. Hoorne aan zijn harde stem;
graaf Lodewijk van Nassau aan zijn mannelijke, krijgshaftige taal, en
den Zwijger aan de langzame wijze waarop hij zijne woorden uitsprak,
alsof hij elk hunner vooraf wilde wegen.

Graaf van Egmond vroeg waarom men hen een tweede reize bijeenriep,
terwijl zij te Hellegat hadden kunnen beslissen wat er te doen stond.

Hoorne antwoordde:

--De uren loopen snel voorbij, de koning is vertoornd; wij mogen
niet talmen.

Toen sprak de Zwijger:

--De landen verkeeren in gevaar; wij moeten ze verdedigen tegen de
aanvallen van de uitheemsche soldaten.

Egmond antwoordde driftig, dat hij het zonderling vond, dat de koning
een leger meende te moeten zenden, daar alles in vrede was door de
zorgen der heeren en voornamelijk door de zijne.

Maar de Zwijger sprak:

--Philippus heeft in de Nederlanden veertien benden, die zijne bevelen
moeten uitvoeren, waarvan al de soldaten dengene verkleefd zijn,
die hen aanvoerde te Gravelingen en te Saint-Quentin.

--Ik begrijp niet, sprak Egmond.

De prins hervatte:

--Ik wil er niets bijvoegen, maar aan u en de andere vergaderde heeren
zal lezing gegeven worden van zekere brieven, met die van den armen
gevangene Montigny te beginnen.

In zijne brieven, schreef messire van Montigny:

"De koning is uitermate vergramd over hetgeen in de Nederlanden gebeurd
is, en op tijd en stond zal hij de daders der woelingen straffen".

Daarop zei Egmond, dat het koud was en dat men diende een houtvuur
aan te steken. Zoo werd gedaan, terwijl de beide heeren spraken over
de brieven.

Het vuur trok niet, om reden van den al te grooten takkebos in de
schouw, en de kamer was vol rook.

Hoestend las toen de graaf van Hoogstraten de onderschepte brieven,
door den Spaanschen gezant te Parijs, don Francès d'Alava, aan de
landvoogdes geschreven.

--De gezant, sprak hij, schrijft dat al het kwaad, dat den Nederlanden
overkomt, te wijten is aan de heeren van Oranje, van Egmond en van
Hoorne. Gij moet, schreef hij, u van de vriendelijkste zijde aan hen
toonen en hun zeggen dat de koning erkentelijk is voor hunne trouw. Wat
betreft Montigny en Bergen: Zij blijven waar zij behooren te zijn.

--Ha! dacht Uilenspiegel, ik zit nog liever in een rookende schouw
in Vlaanderenland, dan in een goed verlucht gevang in Spanje; want
daar verrijzen schavotten tusschen de vochtige muren.

De gezant van Spanje voegde er bij dat de koning in Madrid gezegd had:

--Door al hetgeen in de Nederlanden voorgevallen is, is ons koninklijk
gezag verminderd, de dienst van God verlaagd, en wij zullen liever
het bezit van al onze andere landen in de weegschaal leggen, dan
dit oproer ongestraft te laten. Wij zijn besloten in eigen persoon
naar de Nederlanden te gaan en de hulp des pausen en des keizers te
vorderen. Het kwaad van heden moet het goede van morgen baren. Wij
zullen de Nederlanden onder onze algeheele gehoorzaamheid brengen en,
naar ons believen, staat, godsdienst en regeering wijzigen.

--Ha! koning Philippus, dacht Uilenspiegel, kon ik u naar mijn believen
wijzigen, zeker zoudt gij, onder mijn Vlaamschen stok, een merkelijke
wijziging ondergaan aan uwe dijen, armen en beenen; ik zou uwen kop
met twee nagelen in het midden van uwen rug vastmaken, opdat gij
aldus de kerkhoven kondt zien, die gij achter u laat, en naar eigen
believen uw liedeken van gewelddadige wijziging zoudt kunnen zingen.

Er werd wijn opgediend. Hoogstraten stond recht en sprak:--Ik drink
op onze landen! Allen deden als hij; toen voegde hij er bij, terwijl
hij zijn ledigen beker nederzette:--De rampspoed is gekomen voor den
Belgischen adel. Wij moeten middelen beramen tot onze verdediging.

Hij wachtte een antwoord en zag naar Egmond, die zweeg.

Maar de Zwijger zei:

--Wij zullen weerstaan, als Egmond, die Frankrijk tweemaal beven deed
te Saint-Quentin en te Gravelingen, die alle gezag over de Vlaamsche
soldaten bezit, ons helpen wil om den Spanjaard te beletten in onze
landen te komen.

Messire van Egmond antwoordde:

--Ik heb een al te eerbiedigen dunk van den koning om te meenen dat
wij ons, als rebellen, tegen hem moeten wapenen. Dat zij, die zijnen
toorn duchten, deze landen verlaten. Ik zal blijven, zonder zijne
hulp kan ik niet leven.

--Philippus zal zich wreedelijk wreken, sprak de Zwijger.

--Ik heb vertrouwen, antwoordde Egmond.

--Ook voor uw hoofd? vroeg Lodewijk van Nassau.

--Mijn hoofd, mijn lijf, mijne toewijding, sprak Egmond, alles is zijn.

--Ik, een getrouw onderdaan, doe als gij, sprak Hoorne.

De Zwijger sprak:

--Men moet voorzien en niet wachten.

Toen antwoordde messire van Egmond met drift:

--Te Geeraardsbergen deed ik twee en twintig hervormden hangen. Als
de preeken ophouden, als de beeldenstormers gestraft worden, zal de
woede des konings zich stillen.

De Zwijger antwoordde:

--IJdele hoop.

--Wapenen wij ons met vertrouwen, sprak Egmond.

--Wapenen wij ons met vertrouwen, sprak Hoorne.

--'t Is met ijzer, en geenszins met vertrouwen, dat wij ons moeten
wapenen, hervatte Hoogstraten.

Daarop deed de Zwijger teeken, dat hij wilde vertrekken.

--Vaarwel, prins zonder land, zegde Egmond.

--Vaarwel, graaf zonder hoofd, antwoordde de Zwijger.

Toen zegde Lodewijk van Nassau:

--De slachter is voor het schaap, en de roem voor den moedigen
strijder, die den grond der vaderen redt.

--Ik mag, noch ik wil, sprak Egmond.

--Het bloed van de slachtoffers valle op het hoofd van den hoveling,
sprak Uilenspiegel.

De heeren verlieten de kamer.

Toen kwam Uilenspiegel uit zijne schuilplaats; hij ging rechtstreeks
bij Praet en vertelde hem wat hij gehoord had.

--Egmond is verrader; God is met den prins, zegde Praet.

De hertog! de hertog te Brussel! Waar zijn de geldkisten, die
vleugelen hebben?







DERDE BOEK.


I.

De Zwijger gaat henen, God leide hem!

De twee graven zijn reeds gevangen; Alva belooft aan den Zwijger
goedertierenheid en vergiffenis, zoo hij vóór hem wil verschijnen.

Op die tijding sprak Uilenspiegel tot Lamme:

--Op aanzoek van Dubois, procureur-generaal, heeft de hertog gedagvaard
binnen driemaal veertien dagen vóór hem te verschijnen: den prins
van Oranje, Lodewijk zijn broeder, Hoogstraten, van den Berg,
Kuilenburg, Brederode en andere vrienden des prinsen, onder belofte
van goede justitie en goedertierenheid. Luister, Lamme: Eens daagde
een Amsterdamsche jood een zijner vijanden uit, op straat te komen;
de uitdager stond op den openbaren weg en de andere was boven aan
een venster.

--Kom beneden, riep de uitdager zijn vijand toe, en ik geef u zulken
slag op uwen kop, dat hij in uwe borstkas zal zinken en gij door uwe
ribben zult kijken, lijk een dief door de traliën van zijnen kerker.

De andere antwoordde:--"Al beloofdet gij mij honderdmaal meer, nog
kwam ik niet beneden". Zoo kunnen Oranje en de anderen antwoorden. En
zoo deden zij ook, en zij weigerden vóór Alva te verschijnen. Egmond
en Hoorne deden niet als zij. En zwakheid bij het vervullen van den
plicht roept het uur van God.




II.

Te dien tijde werden te Brussel, op de Peerdenmarkt de heeren onthalsd,
die zich door verrassing hadden willen meester maken van Amsterdam.

En toen zij, geachttienen, naar de strafplaats gingen en psalmen
zongen, roffelden tamboerijnen den heelen weg langs.

En de Spaansche soldaten, die hen begeleidden met brandende toortsen,
brachten hun overal brandwonden toe. En als zij zich verroerden,
ter oorzake van de pijne, riepen de soldaten:--Hoe, Lutheranen,
doet het u dan zeer, zoo vroegtijdig te worden verbrand?

En hij, die hen verraden had, hiet Diederik Slosse. Hij had hen naar
het nog katholieke Enkhuizen gelokt, om ze den beulsknechten van den
hertog over te leveren.

En zij stierven als helden.

En de koning erfde.




III.

--Hebt gij hem zien voorbijgaan? vroeg Uilenspiegel, in houtkapper
gekleed, tot Lamme, die op dezelfde wijze uitgedost was. Hebt gij
den leelijken hertog gezien, met zijn plat voorhoofd als dat van een
arend, en zijn langen baard, die gelijkt op een eind galgekoord? God
verworge er hem mede! Hebt gij die spinnekop met haar lange harige
pooten gezien, die Satan over onze landen braakte? Kom, Lamme, kom;
laat ons steenen smijten in haar net.

--Laas! sprak Lamme, om levend verbrand te worden!

--Kom naar Groenendaal, mijn beste vriend, kom naar Groenendaal; daar
is een schoon klooster, waar de Hertogelijke Spin den God van vrede
bidt, dat Hij heur werk zou laten volvoeren, dat Hij haar als eene raaf
in rot vleesch late wroeten. Wij zijn in de vasten, maar de hertog
wil zich niet onthouden van bloed. Kom, Lamme, er zijn vijfhonderd
gewapende mannen rond het huis van Ohain; driehonderd man te voet
zijn bij kleine groepen vertrokken en dringen in het Zoniënbosch.

Straks, als Alva aan 't bidden is, grijpen wij hem vast, wij steken
hem in een ijzeren kooi en zenden 't ondier aan den prins.

Doch rillend van angst, antwoordde Lamme:

--Groot gevaar, mijn zoon, groot gevaar! Ik zou u helpen in die
onderneming, als mijne beenen zoo zwak niet waren, en mijn buik niet
zoo opgezwollen van het zuur bier, dat zij drinken in Brussel.

Dit gesprek werd gehouden in een hol, gegraven in een dicht bewassen
plaats van het bosch. Door de bladeren turend, zag Uilenspiegel
eensklaps de gele en roode kleederen van de soldeniers des hertogen,
wier wapenen flikkerden in de zonne en die te voet door het bosch
kwamen.

--Wij zijn verraden, sprak Uilenspiegel.

Als de soldaten uit het gezicht waren, liep hij ijlings naar Ohain. De
soldaten lieten hem ongemerkt door, ter oorzake van zijne kleeding
van houtkapper en den last hout, dien hij op den rug droeg. Daar
wachtten de ruiters; hij verspreidde het nieuws; allen gingen uiteen en
ontsnapten, behalve de heer Bausart d'Armentières, die gevat werd. De
heer Bausart moest het voor de anderen wreedelijk bekoopen.

En 't was een lafhertige verrader uit het regiment van den heer van
Likes, die hen allen had aangeklaagd.

Met een hert, dat klopte van angst, ging Uilenspiegel te Brussel naar
de Peerdenmarkt, den ijselijken folterdood bijwonen.

En de arme Armentières, op het rad gelegd, kreeg zeven en dertig
slagen met een ijzeren staaf op de beenen, de armen, de handen en
voeten, die achter elkander aan stukken werden geslagen, want de
beulen vermaakten zich met hem wreed te doen lijden.

En op de borst kreeg hij den zeven en dertigsten klop, van denwelken
hij stierf.




IV.

Op een zoelen en helderen dag van de Zomermaand werd te Brussel, op
de Groote Markt, vóór het Broodhuis, een schavot opgericht, dat met
zwart laken behangen was en nevens hetwelk twee hooge palen stonden,
met ijzeren pinnen. Op het schavot waren twee zwarte kussens en een
kleine tafel, met een zilveren kruisbeeld.

En op dat schavot werden, met het zweerd, de edele heeren van Egmond
en van Hoorne onthalsd.

En de koning erfde.

En de gezant van koning Frans I, over Egmond sprekend, zeide:

--Ik heb daar het hoofd zien vallen van hem, die Frankrijk tweemaal
deed beven.

En de hoofden der graven werden op de ijzeren pinnen gestoken.

En Uilenspiegel sprak tot Lamme:

--De lijken en het bloed zijn met zwart laken bedekt. Gezegend zij,
die in de zwarte dagen, welke op handen zijn, het hert hoog en het
zweerd recht zullen houden.




V.

In dien tijd bracht de Zwijger een leger bijeen, en deed hij de
Nederlanden langs drie kanten tegelijk aanvallen.

En Uilenspiegel zeide in eene vergadering van Wilde Geuzen van
Marenhout:

--Op advies van die der inquisitie heeft koning Philippus een iegelijk
inwoner der Nederlanden plichtig verklaard aan majesteitsschennis,
zoowel om de ketterije aangehangen, als om haar niet bestreden te
hebben. En uit hoofde dier afschuwelijke misdaden veroordeelt hij
allen, zonder onderscheid van kunne of ouderdom, met uitzondering
van hen, die met name genoemd zijn, tot de straffen voor dergelijke
gruweldaden bepaald; en dit zonder de minste hoop op genade. En de
koning erft. De dood maait in de rijke streek tusschen de Noordzee,
het graafschap Emden, de rivier Amisia, de landen van Westfalen,
van Kleef, van Gulik en van Luik, de bisdommen Keulen en Trier,
het land van Lotharingen en Frankrijk. De dood maait in een land van
driehonderd veertig uren omtrek, binnen tweehonderd ommuurde steden,
in honderd vijftig dorpen die stadsrecht bezitten, in vlekken en
velden. En de koning erft.

Elfduizend beulen zijn niet te veel om dat werk te verrichten,--Alva
heet hen soldaten. En de bodem der vaderen is eene slachtbank geworden,
gevlucht door de kunsten, verlaten door de getrouwen, geschuwd door al
de ambachtslieden, die liever den vreemde gaan verrijken, alwaar men
hun den God van het vrije geweten laat aanbidden. Dood en ondergang
maaien. De koning erft.

De landen hadden hunne privileges bekomen met macht van
geld, gegeven aan behoeftige vorsten; die privileges worden
verbeurdverklaard. Volgens de verdragen, gesloten tusschen de landen
en de vorsten, hadden zij gehoopt te genieten van de rijke vrucht
van hun arbeid. Zij bedriegen zich: de metser bouwt voor den brand;
de ambachtsman werkt voor den dief. De koning erft.

Bloed en tranen! De dood maait op de brandstapels, op de boomen,
die langsheen de groote wegen tot galgen dienen, in de gapende
kuilen, in dewelke de arme meidekens levend worden geworpen, in de
kerkers der gevangenissen, in de kransen van brandende takkebossen,
te midden waarvan de slachtofferen met zacht vuur verbranden, in de
gloeiende stroohutten, waarin de veroordeelden sterven door rook en
door vuur. De koning erft.

Aldus wilde de Paus van Rome.

De steden zijn vol spionnen, die loeren op hun deel van de erfenis
der slachtofferen. Hoe rijker, hoe schuldiger. De koning erft.

Maar de wakkere mannen van den lande zullen zich niet laten kelen
als lammeren. Onder de vluchtelingen, zijn gewapende mannen, die
zich in de bosschen verschuilen. De monniken hadden ze verklikt,
opdat men hun lijf en goed zou ontnemen. 's Nachts en ook 's daags
werpen zij zich dan ook bij benden, als wilde dieren, op de kloosters;
zij nemen er het geld terug, dat aan het arme volk ontroofd werd
onder de gedaante van gouden en zilveren kandeleers, fierters of
reliquieënkastjes, kostbare ciboriën, patenen en heilige vaten. Niet
waar, goede lieden? Zij drinken den wijn, dien de monniken voor zich
zelven bewaarden. De gesmolten of verkochte vaten zullen dienen tot
den heiligen oorlog. Vive le geus!

Zij bestoken, dooden, plunderen de soldaten des Konings en vluchten
vervolgens naar hunne holen. Dag en nacht ziet men in de bosschen
vuren aansteken en uitdooven, en gedurig van plaats veranderen. 't
Is het vuur onzer festijnen. Aan ons de eenden en hazen! Wij
zijn de heeren! De boeren geven ons brood en spek, zooveel als wij
willen. Bezie ze, Lamme. Schuw, armoedig, vastberaden en zonder genade,
zwerven zij door de bosschen met hunne aksten, hellebaarden, zweerden,
kruismessen, pijken, lansen, kruisbogen, bussen, want alle wapens
zijn goed, en onder vendrigs willen zij niet staan. Vive le geus!

En Uilenspiegel zong:


    Slaat op den trommel van dirre dom deijne,
    Slaat op den trommel van dirre dom dom.
    Oorlog om Oorlog! Leve de Geus!

    Rukt den hertog Zijn ingewand uit!
    Klopt met de zweep in Zijn aanzicht!
    Slaat op den trommel, de holle trom,
    Vloek zij den hertog, dood den beul!

    Werpt den honden den bloedhond voor! Leve de Geus!
    Hangt hem bij de tong op, bij den arm op,
    Bij de tong, die het vonnis velt,
    Bij den arm, die 't onderschrijft.
    Slaat op de krijgstrom. Leve de Geus!

    Levend bij lijken van slachtoffers!
    Delft den hertog in een kuil,
    Dat hij, in goren stank,
    Sterve om de pest der dooden!
    Slaat op de krijgstrom. Leve de Geus!

    Aanschouw uit den hoogen, Christus, uw scharen,
    Dapper vóór 't vuur, vóór strik en zweerd,
      Al om Uw woord.
    Redden willen wij 't vaderland.
    Slaat op de krijgstrom. Leve de Geus!


En allen dronken en riepen:

--Leve de Geus!

En Uilenspiegel dronk uit den gouden beker eens monniks en keek met
fierheid naar de krijgshaftige gezichten der Wilde Geuzen.

--Wilde geuzen, sprak hij, gij zijt wolven, leeuwen en
tijgers. Verslindt de honden van den bloedigen koning.

--Leve de Geus! riepen zij, en zij zongen:


    Slaat op den trommel van dirre dom deijne,
    Slaat op den trommel van dire dom dom.
    Oorlog om Oorlog! Leve de Geus!




VI.

Terwijl Uilenspiegel te Ieperen was en soldaten voor het leger
van den Zwijger aanwierf, werd hij gezocht door de serjanten des
hertogen. Dienvolgens bood hij zich aan als koster bij den proost van
St.-Maartens-kerk. Voor gezel had hij een klokluider, Pompilius Numan,
een lafaard die zijn gelijke niet had, en 's nachts zijn schaduw voor
den duivel en zijn hemd voor een spook nam.

De proost was vet als een sleksken, of liever, als een kalkoen,
vetgemest en pas voor het braadspit. Weldra werd Uilenspiegel gewaar,
hoe hij het aan boord legde om zoo vollijvig te wezen. Naarvolgens
hij hoorde zeggen door den klokluider en met eigen oogen zag, was de
proost gewoon te negen uren het noenmaal en te vier uren het avondmaal
te nemen. Hij bleef slapen tot halfnegen; vervolgens, alvorens te eten,
deed hij een ronde in zijne kerk, om te zien of de offerblokken voor
den arme goed gevuld waren.

En hij stak de helft der ontvangst in zijn tassche. Te negen uren
nuttigde hij een kom melk, een halven bout, een reigerspasteitje,
besproeid met vijf bekers Brusselschen wijn. Te tien uren nam hij
eenige pruimen met daarbij wat Orlans-wijn, en bad hij God dat Hij
hem steeds voor gulzigheid zou behoeden. 's Middags knabbelde hij
als tijdverdrijf eenen vleugel en de stuit van een kieken. Een uur
daarna dronk hij, in afwachting van 't avondmaal, een grooten beker
Spaanschen wijn; vervolgens legde hij zich te bed, om zich door een
middagslaapje te verkwikken.

Wakker geworden, at hij een stuksken zalm en dronk hij een
grooten beker Antwerpschen dobbelen knol, om zijn eetlust te
scherpen. Vervolgens ging hij naar de keuken, en daar zette hij zich
neer voor het schoon houtvuur, dat in den heerd flikkerde. Hij zag
het groot stuk kalfsvleesch of het speenverkentje voor de monniken
der abdij braden en bruineeren. Hij had er in gebeten, zoo lekker
scheen het. Maar de eetlust ontbrak hem een weinig. En hij bewonderde
het braadspit, dat van zelf ronddraaide. Het was werk van Pieter van
Steenkiste, den smid, wonende in de kasselrij Kortrijk. De proost
had elk dier braadspitten met vijftien pond parisis betaald.

Vervolgens keerde hij terug naar zijn bed, alwaar hij insluimerde, uit
vermoeienis. Daarna werd hij weder wakker om een weinig verkensgelei
te nemen met een slokje Romagne-wijn van tweehonderd veertig gulden
het stuk. Te drie uren peuzelde hij een vogelken met Madeirasuiker,
besproeid met twee glaasjes Malvezij van zeventien gulden het
pijpje. Te half vier at hij een halven pot confituur, begoten met
mede. Goed wakker, nam hij toen een zijner voeten in de handen en
bleef hij in diepe overweging zitten rusten.

Als de tijd van 't avondmaal dáár was, kwam de pastoor van Sint Jans
hem dikwijls bezoeken op dit genoeglijk uur. Soms wedden zij om 't
meeste visch, gevogelte, wild of vleesch te eten. En die 't eerste
vol was, moest karbonaden betalen, die volgens den toen heerschenden
smaak moesten bereid zijn met drie soorten warmen wijn, vier soorten
specerijen en zeven soorten groenten.

Terwijl zij dus dronken en aten, spraken zij samen over de ketteren,
die men, naar hun eenstemmig gevoelen, niet genoeg uitroeien kon. Ook
was er onder hen nooit eenig krakeel, behalve als zij spraken over
de negen en dertig verschillende wijzen om goede bierpap te maken.

Vervolgens neigden hunne eerbiedige hoofden over hunne heilige buiken,
en zij deden een dutje. Soms half wakker schietend, zeide een hunner
dat het leven toch schoon is en dat de arme sukkelaars, die klagen,
ongelijk hebben.

Bij dien heiligen man werd Uilenspiegel koster. Hij diende zeer goed
de misse, en vulde wel driemaal de wijnkannetjes, tweemaal voor zich
zelven en eenmaal voor den proost. De klokluider Pompilius Numan stak
hem hierbij een handeken toe.

Als Uilenspiegel den klokluider zoo gezond, zoo dik en zoo vet zag,
vroeg hij hem of het in den dienst van den proost was, dat hij al
die gezondheid opgedaan had.

--Ja, mijn zoon, antwoordde Pompilius; maar doe goed de deur toe,
want men zou kunnen luisteren.

Toen zegde hij hem stille in 't oor:

--Gij weet dat onze meester, de proost, van alle wijnen en bieren,
alle vleezen en pluimdieren houdt als de kat van de melk. Zijne
eetwaren sluit hij op in eene schapraai en zijne dranken in eenen
kelder, waarvan de sleutels gedurig in zijne tassche steken. En hij
slaapt er mee.... 's Nachts, als hij slaapt, ga ik de sleutels van
op zijnen buik nemen, en ik leg ze dan weder, doch niet zonder beven;
want als hij het wist, zou hij mij zeker in de olie doen koken.

--Pompilius, sprak Uilenspiegel, al die moeite en schrik zijn onnoodig:
neem de sleutels nog eenmaal; ik zal er van maken hetzelfde model en
de andere zullen wij gerust laten liggen op den buik van den goeden
proost, onzen heer.

--Dat is een goed gedacht, zeide Pompilius.

Uilenspiegel maakte de sleutels; zoodra hij en Pompilius, rond
acht uren des avonds, oordeelden dat de goede proost vast in slaap
was, gingen zij beneden en namen zij hunne gading uit vleezen en
flesschen. Uilenspiegel droeg de flesschen en Pompilius de spijzen,
omdat Pompilius altoos beefde als een riet en dat hespen en bouten
toch niet breken als zij vallen. Verscheidene reizen stalen zij
gevogelte, als het nog rauw was, welke feiten ten laste gelegd werden
van meerdere katten uit de gebuurte, dewelke deze dieften met den
dood moesten bekoopen.

Toen trokken de beide gezellen naar de Ketelstraat, waar de meidekens
van pleizier wonen. Daar kniesden zij niet, doch gaven hunnen lievekens
edelmoedig gerookt ossevleesch en hesp, worst en gevogelte; zij lieten
heur zelfs Orlans- en Romagne-wijn drinken, alsmede Engelsche ale
en smakelijk Oosterbier, dat zij goten in de frissche keel hunner
schoenen. En zij werden ruimschoots met kussen betaald.

Doch op een morgen, na het eten, deed de proost zijne beide dienaars
ontbieden. Hij zag er ontzagwekkend uit en zoog, met een boos gezicht,
aan een mergbeentje uit zijne soep.

Pompilius stond te beven in zijne schoenen, en zijn buik trilde van
schrik. Uilenspiegel hield zich stil en tastte, inwendig lachend,
in zijnen zak naar de sleutels.

De proost sprak tot hem:

--Men eet mijn vleesch op en drinkt mijnen wijn uit: zijt gij het,
mijn zoon?

--Neen, antwoordde Uilenspiegel.

--En die man, daar, de klokluider, sprak de proost, naar Pompilius
wijzend, heeft hij dan de hand aan die misdaad geleend, dat hij zoo
wit als een doek ziet? Zeker heeft de gestolen wijn hem vergiftigd.

--Laas! messire, sprak Uilenspiegel, gij beschuldigt uwen klokluider
ten onrechte, want zoo hij zoo wit ziet, is het niet omdat hij
uwen wijn heeft gedronken, doch wèl omdat hij er te weinig drinkt;
dáárvan is hij zoo slap, dat zijne ziel weldra bij stroomen zijne
hooze zal uitloopen.

--Er zijn arme lieden op deze wereld, zuchtte de proost, terwijl hij
een grooten slok wijn uit zijn beker dronk. Maar zeg mij, mijn zoon,
gij die arendsoogen hebt, hebt gij de dieven niet gezien?

--Ik zal goed opletten, heer proost, sprak Uilenspiegel.

--God bescherme u beiden, mijne kinderen, sprak de proost, en leeft
op sobere wijze. Want uit de onmatigheid komen hier in dit tranendal
al onze kwalen voort. Gaat in vrede.

En hij gaf hun zijn zegen.

En hij zoog nogmaals aan zijn mergbeen, en hij dronk nog een grooten
slok wijn.

Uilenspiegel en Pompilius gingen henen.

--De leelijke vrek, sprak Uilenspiegel, hij had u nog geen slokje
van zijn wijn laten drinken. Als wij nog stelen, zal 't wèl besteed
zijn. Maar wat hebt gij toch, dat gij zoo beeft?

--Heel mijne hooze is nat, zei Pompilius.

--Dat is gauw droog, kameraad, sprak Uilenspiegel. Maar wees verheugd:
dezen avond zal er flesschenmuziek zijn, bij onze lievekens in de
Ketelstraat. En de drie nachtwachten zullen wij dronken maken, en
snorkend zullen zij de stede bewaken.

Zoo gezegd, zoo gedaan.

Doch, 't was dicht tegen Sint-Maartensdag: de kerk was versierd voor
den heiligdag. Uilenspiegel en Pompilius gingen 's nachts de kerk
binnen en sloten goed de deur. Vervolgens staken zij al de waskeersen
aan; zij namen eene viool en eene doedelzak, en begonnen daarop om
het best te spelen. En de keersen vlamden als zonnen. Maar het was
nog niet alles. Als hun werk verricht was, gingen zij bij den proost,
dien zij, hoewel het al laat was, nog op vonden. Hij knabbelde een
lijster en dronk een glas Rijnwijn. De ruiten der kerk verlicht ziende,
trok hij de oogen wijd open.

--Heer proost, zei Uilenspiegel, wilt gij weten wie uw vleesch opeet
en uwen wijn uitdrinkt?

--En die verlichting? sprak de proost, naar de vensters der kerk
wijzend. Ha! Heere God, laat gij den heiligen Martinus nu toe,
's nachts zonder betalen, de keersen der arme monniken te branden?

--Hij doet nog andere dingen, heer proost, sprak Uilenspiegel. Kom
maar zien.

De proost nam zijnen staf en ging mede. Zij traden de kerk binnen.

Daar zag hij, in 't midden van den grooten beuk, al de heiligen uit
hunne nissen gedaald, in een rondeken staan. De heilige Martinus,
wel een kop grooter dan de anderen, scheen de meester te zijn. En
op den wijsvinger der rechterhand, die zegenend uitgestrekt was,
stak een gebraden kalkoen. De anderen hadden in de hand of in den
mond stukken kieken of gans, worst, hesp, versche visch en gekookte
visch en, onder andere, eenen snoek wel veertien pond zwaar. En elke
sant had eene flesch wijn voor zijne voeten staan.

Als de proost dat zag, kon hij zich van woede niet inhouden; hij zag
rood als een haan, en zijn gelaat was zóó opgezwollen, dat Pompilius
en Uilenspiegel meenden dat hij ging bersten; maar, zonder op hen te
letten, ging hij met gebalde vuist recht op den heiligen Martinus
af, alsof hij hem aanzag voor den dief. Hij rukte hem den kalkoen
van zijnen vinger en sloeg op Martinus als de duivel op Geeraard,
zoodat de arm, de neus, de staf en de mijter aan stukken vlogen.

De anderen kregen mede hun deel en meer dan één liet er bij armen,
handen, mijter, staf, zeis, bijl, rooster, zaag en andere kenteekenen
van weerdigheid of martelaarschap. Vervolgens liep de proost, woedend
en haastig, al de waskeersen uitblazen.

En al wat hij vond aan hesp, worst en gevogelte nam hij mede,
en gebogen onder den last, ging hij zoo treurig en ellendig zijne
slaapkamer binnen, dat hij drie bottels wijn dronk.

Toen Uilenspiegel zeker was dat hij sliep, peuzelden de beide vrienden
de beste brokken op, en legden zij de beentjes vóór de voeten der
heiligen. Vervolgens gingen zij naar de Ketelstraat met al wat de
proost meende gered te hebben en ook met hetgeen nog lag in de kerk.

Den volgenden morgen ging Pompilius de metten luiden, terwijl
Uilenspiegel naar boven trok om zijnen meester te wekken.

Deze vroeg wat hij wilde, en Uilenspiegel verzocht hem, beneden
te komen.

Als de proost in de kerk was, toonde Uilenspiegel het overschot van
de heiligen en van het gevogelte.

--Messire proost, sprak hij, zij hebben het toch opgegeten.

--Ja, antwoordde de proost, zij zijn als dieven in mijne slaapkamer
gedrongen, om te stelen hetgeen ik gered had. Ha! heeren santen,
ik zal mijn beklag aan den Paus doen.

--Ja, sprak Uilenspiegel met een bedenkelijk gezicht, maar de ommegang
gaat overmorgen uit: straks komen de werklieden in de kerk. Vreest
gij niet, verraden te worden als beeldenstormer, als zij al die santen
in stukken en brokken zien liggen?

--Ha! heilige Sint Maarten, sprak de proost, spaar mij van het vuur,
ik wist niet wat ik deed.

Zich naar Uilenspiegel wendend, terwijl de bange Pompilius zich aan
het klokzeel liet hangen, sprak hij:

--Nooit zal men tegen Zondag den heiligen-Martinus kunnen
herstellen. Wat zullen de menschen zeggen en wat staat mij te doen?

--Heere, antwoordde Uilenspiegel, nood breekt wet: wij moeten tot
een onschuldig bedrog onze toevlucht nemen. Wij zullen eenen baard
plakken op 't gezicht van Pompilius, die er eerbiedweerdig uitziet,
daar hij altijd weemoedig is. Wij zullen hem den mijter opzetten, hem
het koorhemd, den pelsmantel en het groote opperste kleed des santen
aandoen; wij zullen hem aanbevelen stil op zijn voetstuk te blijven,
en de geloovigen zullen hem voor den houten Sint-Maarten nemen.

De proost ging tot Pompilius, die meer dood dan levend aan het
klokzeel bengelde.

--Houd op met luiden, sprak hij, en luister. Wilt gij vijftien
dukaten verdienen? Zondag zult gij Sint-Maarten in de processie
verbeelden. Uilenspiegel zal u kleeden en als gij, door de vier
mannen gedragen, een gebaar durft maken of uw mond open doen, laat
ik u levend in de olie koken in den grooten ketel, dien de hangman
rechtover de Hallen gebouwd heeft.

--Heer, ik zeg u duizendmaal dank, sprak Pompilius, maar gij weet
dat ik zeer moeielijk mijn water kan ophouden.

--Gij moet gehoorzamen, hernam de proost.

--Ik zal gehoorzamen, eerweerdige heer, sprak Pompilius met den dood
op het lijf.




VII.

De ommegang ging uit, onder een blijde, heldere zon. Uilenspiegel had
de twaalf heiligen zoo goed mogelijk opgelapt en zij waggelden op
hunne voetstukken tusschen de banieren der gilden; daarachter kwam
het standbeeld van Onze-Lieve-Vrouw, vervolgens de maagdekens, in
't wit, die lofzangen zongen, dan de boogschutters, eindelijk het
dichtst bij den hemel en meer waggelend dan de anderen, Pompilius,
die gebogen ging onder de zware kleederen van den heiligen Martinus.

Uilenspiegel, die zich voorzien had van krabpoeder, had zelf Pompilius
zijn bisschoppelijk kleed helpen aantrekken, zijn handschoenen
aangedaan, zijnen staf in zijne hand gestoken en hem geleerd hoe hij de
handen moest houden om het volk te zegenen. Ook had hij de priesters
helpen kleeden. Den eenen had hij de stool aangedaan, den anderen den
pelsmantel, den diakenen het koorhemd. Hij liep gedurig de kerk rond
om de plooien van een wambuis of een hooze effen te strijken. Hij
bewonderde de scherpe wapenen der gilden en de geduchte bogen der
schutters. En elkeen strooide hij een weinig krabpoeder in den hals,
in den rug, op den pols. Maar de deken en de vier dragers van den
heiligen Martinus kregen het meest. De maagdekens spaarde hij omdat
zij zoo lief waren.

De processie ging uit de kerk, in prachtige orde, met fladderende
banieren en wapperende wimpels. Mannen en vrouwlieden sloegen een
kruis als zij voorbijging. En de zonne was heet.

De deken werd 't eerst het poeder gewaar en krabde een weinig achter
zijn oor. Allen, priesters, boogschutters, dragers, krabden zich aan
den hals, de beenen, de polsen, zonder het nog openlijk te durven;
doch de klokluider, die meer uitstond dan de anderen, ter oorzake van
de brandende zon, dorst zich niet verroeren, uit vreeze van levend in
de olie te worden gekookt. Hij neep zijn neus toe, trok een leelijk
gezicht en beefde op zijn waggelende beenen, want telkens dat de
dragers zich krabden, liep hij gevaar van te vallen.

Maar hij dorst zich niet verroeren, en uit schrik liet hij zijn water
maar loopen; en de dragers zeiden:

--Groote Sint Maarten, gaat het nu regenen?

De priesters zongen een lofzang aan de Heilige Maagd:


    Si de coe ... coe ... lo descenderes
    O Sanc ... ta ... ta ... Ma ... ma ... ria.


Want hunne stemmen beefden wegens de krieuweling die onuitstaanbaar
werd; maar zij krabden zich bedektelijk. Doch de deken en de vier
dragers van Sint-Maarten krabden hun vel vaneen. Pompilius hield zich
stil op zijn arme beenen, die 't meest van al jeukten.

Maar eensklaps bleven al de boogschutters, diakenen, priesters, deken
en dragers staan om zich te krabben. Het poeder beet de voetzolen
van Pompilius vaneen, doch hij dorst zich niet verroeren uit vrees
van te vallen.

En de nieuwsgierigen zeiden, dat de heilige Maarten grammoedig rondkeek
en een dreigend gezicht naar het arme volk zette.

Toen beval de deken, dat de processie zou voortgaan.

Weldra echter maakte de loodzware zon de jeukte van de plechtige
ruggen en buiken onuitstaanbaar.

En toen bleven priesters, boogschutters, diakenen en deken, net als
een bende apen eensklaps staan om zich onbeschaamd overal te krabben
waar het jeukte.

De maagdekens zongen heuren lofzang als engelen en heur frissche
stemmetjes stegen liefelijk ten hemel.

Allen trokken er trouwens van door zooals zij konden: krabbend, redde
de deken 't heilig sacrament; het geloovige volk droeg de fierters
terug in de kerk; de vier dragers van Sint Maarten smeten Pompilius
ruwweg ten gronde. En daar nog dorst de arme klokluider zich niet
krabben noch roeren, doch hij sloot devotelijk de oogen.

Twee jonge knapen wilden hem oprichten, doch daar zij hem te zwaar
vonden, stelden zij hem recht tegen den muur en daar begon Pompilius
bitter te schreien.

Het volk kwam rond hem staan; de vrouwen gingen neusdoeken van fijn,
helder lijnwaad halen, wischten zijn gelaat af om zijne tranen als
reliquieën te bewaren, en zeiden tot hem: "Mijnheer de Sant, wat hebt
gij het warm!"

De klokluider keek hen jammerlijk aan en maakte, zijns ondanks,
wegens de krieuweling, met zijn neus de koddigste gebaren.

Doch daar de tranen over zijne wangen rolden, spraken de vrouwen:

--Groote heilige Maarten, weent gij over de zonden der stede
Ieperen? Niet waar, uwe edele neus verroert zich? Wij hebben nochtans
de raadgevingen gevolgd van Lodewijk Vives, en den armen van Ieperen
zal het aan werk noch aan brood ontbreken. Ho! wat groote tranen! Het
zijn kostbare perelen. Onze redding is hier!

De mannen spraken:

--Wat moeten wij doen, groote heilige Maarten, om uwe droefheid
te stillen?

Maar het volk riep:

--Daar is de koster!

Uilenspiegel kwam bij, greep Pompilius vast en droeg hem op den
schouder weg, gevolgd door eene menigte geloovigen van beide
geslachten.

--Laas! zei de arme klokluider hem stille in 't oor, ik ga bezwijken
van de jeukte.

--Houd u stijf, antwoordde Uilenspiegel; vergeet niet dat gij een
houten heilige zijt.

Hij liep op een draf en legde Pompilius neer voor de voeten van den
proost, die zich tot bloedens toe aan 't krabben was.

--Klokluider, vroeg de proost, hebt gij u gekrabd lijk wij?

--Neen, eerwaarde, antwoordde Pompilius.

--Hebt gij gesproken of u verroerd?

--Neen, eerwaarde, antwoordde Pompilius.

--Hewel, sprak de proost, hier zijn uwe vijftien dukaten. Ga u nu
krabben; gij hebt het verdiend.




VIII.

Toen Uilenspiegel de zaak uitgebracht had, zei het gemeen 's anderen
daags, dat het een ongehoorde spotternij was, hun dien schreeuwer
van een klokluider voor eenen heilige te doen doorgaan en te doen
aanbidden.

En velen werden ketters. En, hunne have meenemend, gingen zij het
leger des prinsen versterken.

Uilenspiegel keerde naar Luik terug.

Onderweg zette hij zich te droomen in een bosch. Den helderen hemel
beziende, sprak hij tot zich zelven:

--De oorlog, altijd de oorlog, opdat de Spaansche vijand het arme
volk vermoorde, onze goederen roove, onze vrouwen en dochteren
verkrachte. Nochtans vlieden ons schoone penningen heen en stroomt
ons bloed bij beken door de straten, zonder het minste voordeel voor
iemand, tenzij voor dien koninklijken schoft, die eene perel van gezag
te meer aan zijne krone wil hechten. Perel, die hij glorierijk waant,
doch die maar eene perel van bloed en van rookwalm is. Ha! kon ik U
perelen naar mijnen zin, vliegen alleen zouden uw gezelschap nog wezen.

Terwijl hij daaraan dacht, zag hij eene bende herten voorbijrennen. Er
waren er groote en oude, die hun gewei met negen takken fier in
de lucht bewogen. Jonge reebokjes, die hunne schildknapen zijn,
trappelden met hen en schenen bereid hun met hunne scherpe horens
ter hulp te komen. Uilenspiegel wist niet waar zij heengingen, maar
hij dacht dat het naar hun leger was.

--Ha! sprak hij, oude herten en lieve reebokjes, fier en blijde gaat
gij in het diepst van het bosch uwe legerstee zoeken; langs geurige
paden vindt gij jeugdige spruitjes te eten; gelukkig zijt gij,
totdat de jager, uw beul, komt. Aldus is het ook gelegen met ons,
oude herten en jonge reebokjes!

En de assche van Klaas klopte op Uilenspiegel's borst.




IX.

In de Herfstmaand, als de muggen niet meer bijten, stak de Zwijger
te Sint-Vijt den Rijn over met zes stukken veldgeschut en vier zware
kanonnen, en met veertienduizend Vlamingen, Walen en Duitschers.

Onder de geel-en-roode vendels van Alva, den bloedigen hertog, stapten
zes en twintigduizend vijfhonderd man, vergezeld van zeventien stukken
veldgeschut en negen zware kanonnen.

Maar de Zwijger kon in dien strijd geenerlei voordeel behalen, want
Alva weigerde gedurig 't gevecht.

En zijn broeder Lodewijk, die reeds vele steden gewonnen en vele booten
op den Rijn gekaapt had, verloor bij Jemmingen, in Friesland, tegen
den zoon des hertogen, zestien kanonnen, vijftien honderd peerden en
twintig vendels, door de schuld der lafhertige huurknechten, die geld
vroegen als er te vechten viel.

En te midden van puin en van bloed en van tranen, zocht Uilenspiegel
te vergeefs de redding van den vaderlandschen bodem.

En, heel de Nederlanden door, werden onschuldige slachtofferen
gehangen, onthalsd, verbrand door de beulen.

En de koning erfde.




X.

Door het Walenland reizend, zag Uilenspiegel, dat de prins daar weinig
hulp te verwachten had, en zoo kwam hij omtrent de stad Bouillon.

Weldra zag hij op den weg bultenaars van de beide geslachten, van allen
leeftijd en allen stand verschijnen. Allen, met groote paternosters
in de hand, baden devotelijk.

En hunne gebeden geleken op het gerikkik van kikvorschen in eenen
vijver, 's avonds, na een warmen dag.

Daar waren moeders met bulten, die gebochelde kinderen op den arm
droegen, terwijl andere kleinen aan heure rokken hingen. Er waren
bultenaars op de heuvelen en bultenaars in de dalen. En overal zag
Uilenspiegel op den helderen hemel hun magere schimmen afsteken.

Hij ging tot een hunner en vroeg:

--Waar trekken zij allen henen, die ongelukkige mannen, vrouwen
en kinderen?

De man antwoordde:

--'t Is de begankenis van St. Remaclus; wij gaan naar het graf van
den heilige, om van hem te verkrijgen wat onze herten verlangen:
ons ontlasten van dat vernederend pak op onzen rug.

Uilenspiegel hernam:

--Zou ik van Sint-Remaclus niet kunnen verkrijgen wat mijn herte
verlangt: onze arme gemeenten ontlasten van den bloedigen hertog,
die als een looden bochel op de Nederlanden drukt?

--Hij is niet gelast, de bochels der boete af te nemen, antwoordde
de pelgrim.

--Neemt hij er andere af? vroeg Uilenspiegel.

--Ja, als de bulten jong zijn. Als het mirakel der genezing
geschiedt, is 't volop kermis in de stad. En elke pelgrim geeft dan
een zilverstuk, soms wel een gouden florijn, aan den gelukzalige,
die door zijne genezing heilig geworden is en alzoo met vrucht voor
de anderen kan bidden.

Uilenspiegel sprak:

--Waarom doet de rijke mijnheer Sint-Remaclus zijne genezingen betalen,
lijk een pillendraaier?

--Goddelooze reiziger, hij zal u straffen voor uwe lastertaal,
antwoordde de pelgrim, terwijl hij woedend zijnen bochel schudde.

--Laas! zuchtte Uilenspiegel.

En hij liet zich nedervallen aan den voet van een boom.

De pelgrim staarde hem aan en zeide:

--De heilige Remaclus treft goed als hij slaat!

Uilenspiegel kromde zijnen rug en zuchtte, terwijl hij er aan voelde:

--Genade, doorluchtige heilige. 't Is de kastijding. Tusschen
mijne schouderen voel ik een geweldige pijn. Laas! ai! Vergiffenis,
mijnheer Sint-Remaclus, Ga voort, pelgrim, en laat mij hier, als een
vadermoorder, in alleenigheid weenen met mijn berouwhebbend herte.

Maar de pelgrim was reeds op de vlucht: hij liep tot op de Markt van
Bouillon, waar al de bultenaars vergaderd waren.

Huiverend van schrik, zeide hij met afgebroken woorden:

--Pelgrim ontmoet ... recht als een keers ... den heilige gelasterd
... bult op den rug....

Als de andere bultenaars dit hoorden, stieten zij blijde kreten en
spraken zij:

--Sint-Remaclus, als gij bulten kunt maken, kunt gij er afnemen
ook. Neem onze bulten weg, mijnheer Sint-Remaclus.

Intusschen was Uilenspiegel opgestaan en voortgegaan. Aan de deur
eener taveerne van de eenzame voorstad, zag hij aan eenen stok twee
verkensblazen hangen, een teeken, dat het daar pensenkermis was.

Uilenspiegel nam eene der twee blazen en raapte de ruggegraat eener
schol op; stak zich, om wat bloed in de verkensblaas te laten loopen,
blies haar op, bond ze toe, na hetwelk hij ze vastmaakte op den rug
met de graat daarboven. Aldus toegetakeld, schuddebollend en waggelend
als een oude bultenaar, ging hij naar de Markt.

De pelgrim, die hem had zien vallen, werd hem dadelijk gewaar en riep:

--Daar is de lasteraar!

En hij wees met den vinger naar hem.

En allen liepen naar hem om den rampzalige te zien.

Uilenspiegel schudde treurig het hoofd.

--Ha! sprak hij, ik verdien genade noch medelijden; doodt mij als
een razenden hond.

En de bultenaars riepen verheugd:

--Eén te meer in onze broederschap!

Uilenspiegel mompelde onhoorbaar tusschen de tanden:

--Ik zal het U wel betaald zetten, booze lieden!

Doch hij scheen alles geduldig te verdragen en sprak:

--Ik eet of ik drink niet meer, totdat de hoogweerdige heilige Remaclus
mij geneest zooals hij mij trof.

Bij het nieuws van 't mirakel, kwam de deken uit de kerk. 't Was
een groote, dikke, plechtstatige kerel. Met den neus in de lucht,
kliefde hij door de baren der bultenaars, als eene bark door de zee.

Men toonde hem Uilenspiegel; hij zegde tot hem:

--Zijt gij het, manneken, die getroffen werd door de roede van den
heiligen Remaclus?

--Ja, heer deken, antwoordde Uilenspiegel, ik ben het inderdaad,
zijn nederige dienaar, die zijn nieuwen bult wil laten genezen,
als het Zijne Heiligheid belieft.

De deken, die giste dat er look in de meersch was, sprak:

--Laat mij dien bult eens betasten.

--Tast maar, genadige deken, sprak Uilenspiegel.

Toen de deken getast had, sprak hij:

--Hij is nieuw en nog nat. Ook hoop ik, dat de groote heilige U
genadig zal wezen. Kom mede.

Uilenspiegel volgde den deken en ging mee in de kerk.

De bultenaars liepen achter hem en schreeuwden:

--Daar is hij, de gedoemde, de lasteraar! Hoeveel weegt uw versche
bult? Ik zou er een zak van maken, om mijne daalders in te steken? Heel
uw leven hebt gij den spot gedreven met ons, omdat gij recht waart;
nu is 't onze beurt! Gezegend zij Sint-Remaclus!

Uilenspiegel antwoordde niet, doch volgde met gebogen hoofde den
deken, die hem leidde in een kleine kapel, waar een marmeren graf was,
gedekt met eene zerk, mede van marmer.

Tusschen het graf en den muur der kapel was eene opening van ruim eene
hand breed. Een menigte gebochelde pelgrims, die elkander volgden,
gingen tusschen den muur en de zerk van het graf, tegen dewelke zij
stilzwijgend hunne bulten wreven. En aldus hoopten zij er van verlost
te worden. En zij, die hunne bulten tegen de plaat wreven, wilden de
plaats niet afstaan aan degenen, die volgden; en er werd gevochten,
doch zonder gerucht, want zij dorsten niet dan heimelijk stompen,
uit vreeze van heiligschennis.

De deken zegde tot Uilenspiegel op de zerk te klimmen, opdat alle
pelgrims hem goed konden zien.

Uilenspiegel antwoordde:

--Dat kan ik alleen niet.

De deken hielp hem, bleef bij hem staan en deed hem
knielen. Uilenspiegel gehoorzaamde en bleef met gebogen hoofde zitten
in die deemoedige houding.

Na een kort inwendig gebed, zeide de eerwaarde geestelijke met
heldere stem:

--Kinderen en broeders in Christus, aan mijne voeten ziet gij den
grootsten zondaar en lasteraar, dien Sint-Remaclus ooit met zijne
woede trof.

En, op zijne borst kloppend, sprak Uilenspiegel:--Confiteor.

--Weleer, vervolgde de deken, was hij recht als de stok eener
hellebaard, en was hij er fier op. Beziet hem nu, hij is gebult en
gebocheld onder de verwensching des hemels.

--Confiteor, neem mijnen bult weg, sprak Uilenspiegel.

--Ja, vervolgde de deken, ja, groote heilige, ja, Sint-Remaclus, die,
sedert uw glorierijken dood, negen en dertig mirakels gedaan hebt,
neem van zijne schouderen het gewicht, dat er op drukt, opdat wij
uwen lof kunnen zingen in de eeuwigheid der eeuwigheden, in soecula
soeculorum! En vrede op de aarde aan de bultenaars, die van goeden
wil zijn.

En de bultenaars herhaalden te gelijk:

--Ja, ja, vrede op aarde aan de bultenaars, die van goeden wil
zijn; weg met de bulten, weg met haat en met nijd, weg met alle
vernedering! Neem onze bulten weg, doorluchtige heilige Remaclus!

De deken gebood Uilenspiegel het graf te verlaten en zijnen bochel
te wrijven tegen den kant van de zerk. Uilenspiegel deed het, steeds
mompelend: Mea culpa, confiteor, neem mijnen bult weg!

En hij wreef zich zoo goed, dat al de omstanders zulks oogenschijnlijk
zagen.

En dezen riepen:

--Ziet naar zijn bult, hij plooit! Ziet gij, hij smelt weg, rechts
neemt hij af,--Neen, hij zal in zijnen buik zakken; bulten vergaan
niet, zij keeren terug in de darmen, uit dewelke zij komen.--Neen,
zij keeren naar de maag, waar zij tachtig dagen lang tot voedsel
verstrekken.--'t Is een geschenk van den heilige aan hen, die door
zijne genade van hunnen last zijn verlost.--Wat geworden de oude
bulten?

Plotseling stieten al de bultenaars een grooten schreeuw uit, want
Uilenspiegel had zijnen bult gebersten, door hard tegen den boord
der zerk te drukken. Het bloed dat er in was, liep er uit, droop van
onder zijn wambuis met groote droppelen op de steenen der kerk. En
rechtspringend en de armen uitstrekkend, riep hij blijde:

--Ik ben er van af!

En al de bultenaars riepen te zamen:

--Gezegende Sint-Remaclus, genadig zijt gij voor hem.--Groote
heilige, neem den mijnen ook weg!--Ik zal u een kalf offeren.--Ik,
zeven schapen.--Ik, de jacht van één jaar.--Ik, zes hespen,--Ik, ik
schenk mijne hut aan de kerk.--Neem onze bulten af, heilige Remaclus!

En zij bekeken Uilenspiegel met eerbied en afgunst. Een der bultenaren
wilde onder Uilenspiegel's wambuis tasten, doch de deken verbood het
hem, zeggende:

--Daar is een wonde, die het licht niet mag zien.

--Ik zal voor ulieden bidden, sprak Uilenspiegel.

--Ja, pelgrim, spraken al de bultenaars ondereen, ja, mijnheer de
rechtgemaakte; wij dreven den spot met u; vergeef het ons, wij wisten
niet wat wij deden. Christus, de Zaligmaker, vergaf aan het kruis,
wilt gij ons ook vergiffenis schenken?

--Ik vergeef u, sprak Uilenspiegel op hooghertigen toon.

--Neem toch, zeiden zij, neem dit oortje, aanvaard dezen gulden,
laat ons u dien gouden angelot schenken, dien daalder aanbieden,
dien karolus in uwen zak steken.

--Laat angelotten en karolussen het daglicht niet zien, zeide
Uilenspiegel zeer stille: de linkerhand mag niet weten wat de
rechterhand geeft.

Dat zeide hij om den wille van den deken, die het geld der bultenaars
met de oogen verslond, zonder te zien of het goud was of zilver.

--Wij zeggen u duizendmaal dank, gezegende, geheiligde oud-bultenaar,
zeiden de pelgrims tot Uilenspiegel.

En hij nam hunne giften met hooghertigheid aan, zooals iemand betaamt
die met de gratie des hemels bedeeld is.

Maar de gierigaards wreven hardnekkig hunne bochels tegen het graf,
zonder iets te zeggen en vooral zonder iets te geven.

Uilenspiegel trok 's avonds naar eene taveerne, waar hij kermis vierde.

Alvorens slapen te gaan, dacht hij er aan dat de deken, zoo niet
alles, dan toch zijn deel van den buit zou eischen. Hij telde zijn
winst en vond meer goud dan zilver, want er waren minstens driehonderd
karolussen. Hij zag een verdroogden laurier in een bloempot staan, trok
de plant bij den kop uit den pot en legde zijn goud onder de aarde. En
al de halve guldens, oortjes, deniers spreidde hij uit op de tafel.

De deken trad de taveerne binnen en kwam boven bij Uilenspiegel.

Toen deze hem zag, vroeg hij:

--Heer deken, wat wilt gij van mij, nieteling?

--Ik wil niets dan uw goed, antwoordde de dienaar des Heeren.

--Laas, zuchtte Uilenspiegel, bediedt gij dát goed, dat daar ligt op
de tafel?

--Ja, mijn zoon, antwoordde de deken.

Vervolgens de hand uitstekend, ruimde hij al het geld van de tafel,
en liet hij het vallen in eenen zak, dien hij daarvoor opzettelijk
meegebracht had.

En hij gaf een gulden aan Uilenspiegel, met een zucht alsof het een
stuk zijner ziel was.

En hij vroeg hem het gerief van het mirakel.

Uilenspiegel toonde hem de graat en de blaas.

De deken nam ze, terwijl Uilenspiegel weeklaagde en hem wat méér
vroeg, daar de weg van Bouillon naar Damme zoo lang was voor een
armen voetganger, dat hij ongetwijfeld van honger zou omkomen.

De deken ging heen en lispte geen woord.

Als Uilenspiegel alleen was, sliep hij in met het oog op de plant,
's Anderen daags, met den dageraad, stak hij zijnen buit op zak en
verliet de stad.

Hij ging recht naar het kamp van den Zwijger, gaf hem het geld en
vertelde den Prins hoe hij er aan geraakt was: dit was het beste
middel om schattingen van den vijand te lichten, meende hij.

En de prins gaf hem tien gulden.

De graat werd in een kristallen doos gevat, en gestoken tusschen de
twee armen van het kruis op het hoogautaar, in de kerk van Bouillon.

En een iegelijk, in die stad, weet dat de bult van den rechtgemaakten
lasteraar steekt in het kruis.




XI.

De Zwijger, die in de omstreken van Luik was, deed, alvorens de Maas
over te steken, marschen en tegenmarschen, om de waakzaamheid des
hertogen te verschalken.

Uilenspiegel nam zijne plichten van soldaat ter herte, hanteerde zeer
behendig zijne bus, en hield steeds de ooren en oogen goed open.

Om dien tijd kwamen in het kamp meerdere Vlaamsche en Brabantsche
edelen, die in goede overeenstemming leefden met de heeren, kolonels
en hopmans van 't gevolg van den Zwijger.

En weldra kwamen in het kamp twee partijen tot stand, die gedurig met
elkander in twist waren. De eenen spraken: De prins is een verrader. De
anderen antwoordden, dat de beschuldigers logen en dat zij hun hunne
leugentaal zouden doen slikken. Het wantrouwen werd langzamerhand
grooter. Zij werden handgemeen bij troepen van zes, acht, twaalf man,
vochten in tweegevecht met alle wapenen, ja zelfs met vuurroeren.

Op het gerucht kwam de prins eens toegeloopen; hij drong tusschen de
beide partijen. Een kogel rukte zijn degen aan zijne zijde weg. Hij
stelde een einde aan 't gevecht en bezocht heel het kamp om zich te
toonen, opdat men niet zeggen zou: "De Zwijger is dood, de oorlog
is gedaan".

's Anderen daags, omtrent middernacht, bij mistig weder, stond
Uilenspiegel gereed een huis te verlaten, waar hij een Vlaamsch
minnelied aan een Waalsch meideken gaan zingen was, toen hij eensklaps
aan de deur van het naburige huis een driemaal herhaald ravengekras
hoorde. Een boer kwam op de zulle. Uilenspiegel hoorde stappen op
den weg.

Twee mannen, die Spaansch spraken, kwamen bij den boer, die hun zeide
in dezelfde tale:

--Wat hebt gij gedaan?

--Goed werk, zeiden zij, leugens verspreid ten voordeele des
konings. Dank zij ons, zeggen de wantrouwende hoofdmannen en
soldaten tot elkander: 't Is uit lage eerzucht, dat de prins den
koning wederstand biedt; aldus hoopt hij gevreesd te worden en, als
onderpand van den vrede, vele steden en heerlijkheden te krijgen;
voor vijfhonderd duizend gulden verlaat hij de dappere heeren, die
strijden voor onze landen. De hertog heeft hem algeheele kwijtschelding
doen aanbieden met belofte en eed, al de hooge legerhoofden weer in
't bezit hunner goederen te stellen, als zij zich onderwerpen aan
den koning. Oranje gaat alleen met hem onderhandelen.

--'s Zwijgers getrouwen antwoordden ons:

--De voorstellen des hertogen zijn een verraderlijke strik,
waarin de prins geenszins zal vallen; hij kent 't lot van Egmond en
Hoorne. Zij weten wel dat kardinaal Granvelle zegde, toen hij te Rome
de aanhouding der graven vernam: Men vangt de twee blieken, maar men
laat den snoek ontsnappen; men heeft niets gevangen, zoolang men den
Zwijger niet heeft.

--De verdeeldheid is dus groot in het kamp? vroeg de boer.

--De verdeeldheid is groot, zeiden zij, en wordt elken dag
grooter. Waar zijn de brieven?

Zij gingen de hut binnen, alwaar zij eene lanteerne aanstaken. Door een
klein venster loerend, zag Uilenspiegel hen twee verzegelde brieven
openen, die lezen met merkbare vreugde, een glas wijn drinken en
eindelijk weggaan, in het Spaansch tot den boer zeggende:

--Kamp verdeeld, Oranje genomen. Daar zal een ferme beker afmogen.

--Die, sprak Uilenspiegel in zich zelven, die mogen in't leven niet
blijven.

In den dikken nevel gingen zij buiten. Uilenspiegel zag den boer hun
eene lanteerne brengen.

Het licht der lanteerne werd somtijds verduisterd door een zwarte
gedaante. Uilenspiegel leidde daaruit af, dat zij achter elkander
gingen.

Hij laadde zijn vuurroer en schoot naar de zwarte gedaante. Toen zag
hij de lanteerne verscheidene reizen op en neer gaan; hij maakte eruit
op, dat een van beiden gevallen was en de andere wilde weten waar hij
gewond was. Hij wapende zijn vuurroer opnieuw. Als hij de lanteerne
vlug en slingerend in de richting des kamps zag voortgaan, schoot
hij opnieuw. De lanteerne waggelde, viel ten gronde en doofde uit.

Uilenspiegel liep naar het kamp, maar hij kwam den provoost tegen met
een menigte soldaten, die de vuurschoten hadden gewekt en hij zei hun:

--Ik ben de jager, het wild ligt ginder, gaat het maar oprapen.

--Lustige Vlaming, sprak de provoost, wat beteekenen uwe woorden?

--Woorden zijn wind, antwoordde Uilenspiegel, doch lood blijft in
het lijf der verraders. Maar volgt mij.

En, met hunne lanteernen, bracht hij hen ter plaatse waar de twee
mannen gevallen waren. Werkelijk zagen zij hen ten gronde liggen:
de eene was dood, de andere reutelde: in zijn hand hield hij eenen
brief, dien hij in een laatste stuiptrekking verfrommeld had.

Zij droegen de verslagenen mede, die zij aan de kleederen voor edelen
herkenden, en kwamen aldus met hunne lanteernen bij den prins, die
beraadslaagde met Frederik van Hollenhausen, met den markgraaf van
Hessen en met andere heeren.

Gevolgd door landsknechten, ridders met gele en groene wambuizen,
kwamen zij vóór de tent van den Zwijger, luide roepend of hij hen
wilde ontvangen.

Hij kwam buiten.

Uilenspiegel liet den provoost niet spreken, die, hoestend, zich
gereedmaakte om hem te beschuldigen, en zegde:

--Heer, in stee van raven, heb ik twee edele verraders van uw gevolg
gedood.

Vervolgens vertelde hij wat hij gezien, gehoord en gedaan had.

De Zwijger sprak geen woord. De twee lijken werden afgetast in
bijzijn van hem, Willem van Oranje, van Frederik van Hollenhausen,
van den markgraaf van Hessen, van Diederik van Schoonenberg, van
graaf Albrecht van Nassau, van den graaf van Hoogstraten, van Antonius
van Lalaing, stadhouder van Mechelen, alsmede van de soldaten en van
Lamme, die beefde als een riet. Op de edellieden werden verzegelde
brieven van Granvelle en Noircarmes gevonden, waarbij zij aangezocht
werden verdeeling te zaaien in 's prinsen gevolg, om zijne krachten te
verzwakken, hem te dwingen zich te onderwerpen en hem aldus te leveren
aan den hertog van Alva, ten einde onthoofd te worden, naarvolgens
verdienste. Gij moet, zeiden de brieven, omzichtig te werk gaan, en met
bedekte woorden doen gelooven aan die van het leger, dat de Zwijger,
in zijn eigen voordeel alleen, reeds met den hertog heeft onderhandeld;
zijn vertoornde hoofdmannen en soldaten zullen hem gevangennemen. Als
belooning werd aan elk hunner een wissel van vijfhonderd dukaten
gezonden op het huis Függer van Antwerpen; zij zouden nog duizend
dukaten krijgen, zoodra in Zeeland de Spaansche schepen aankwamen,
met de vierhonderd duizend dukaten die men verwachtte.

Het eedgespan ontdekt zijnde, wendde de prins zich naar de edelen,
heeren en soldaten, onder dewelken een groot getal hem verdachten;
zonder spreken wees hij naar de twee lijken, om hun hun wantrouwen
te verwijten.

Allen riepen met groot rumoer:

--Lang leve Oranje! Oranje is den landen getrouw!

Vol verachting wilden zij de lijken aan de honden werpen; maar de
Zwijger sprak:

--Het zijn die lijken niet, die men aan de honden moet werpen, maar
de zwakheid des geestes, die aan de zuiverste inzichten twijfelen doet.

En de heeren en soldaten riepen:

--Leve de prins! Leve Oranje, de vriend onzer landen!

En hunne stemmen klonken als de donder, dreigend voor 't onrecht.

Naar de lichamen wijzend, zeide de prins:

--Begraaft ze als kerstenen.

--En wat gaat men met mij doen? vroeg Uilenspiegel. Dat men mij
kastijde als ik kwaad, en loone als ik goed deed.

Toen sprak de Zwijger:

--Die soldaat zal in mijne tegenwoordigheid vijftig slagen krijgen
met een stok van groen hout, omdat hij, in weerwil van alle tucht
en zonder bevel, twee edellieden doodde. Ook zal hij dertig gulden
ontvangen, omdat hij zoo goed gezien en gehoord heeft.

--Heer, sprak Uilenspiegel, als men mij eerst de dertig gulden gaf,
zou ik de stokslagen met meer geduld ontvangen.

--Ja, ja, zuchtte Lamme Goedzak, lang hem eerst de dertig gulden;
de slagen zal hij deemoedig verdragen.

--En overigens, sprak Uilenspiegel, daar mijn geweten zuiver is, heb ik
niet van doen gewasschen of gespoeld te worden met stokken of zweepen.

--Ja, zuchtte Lamme Goedzak opnieuw, Uilenspiegel heeft niet van noode
gewasschen of gespoeld te worden. Zijn geweten is zuiver. Wascht hem
niet, mijne heeren, wascht hem toch niet!

Uilenspiegel had de dertig gulden ontvangen, als de provoost den
stokmeester gebood, Uilenspiegel onder handen te nemen.

--Ziet toch, mijne heeren, zegde Lamme, wat jammerlijk gezicht hij
trekt. Hij is in 't geheel geen liefhebber van stokken, mijn vriend
Uilenspiegel.

--Een schoonen, goed getakten esch, die met zijn frischgroene bladeren
in de zonne prijkt, zie ik geerne, hernam Uilenspiegel; maar ik koester
een doodelijken haat tegen die leelijke stokken, die nog nat zijn,
zonder twijgen of bladeren, die hard en woest zijn van uitzicht,

--Zijt gij gereed? vroeg de provoost.

--Gereed, herhaalde Uilenspiegel, gereed tot wat? Om geslagen te
worden? Neen, dat ben ik niet en zal het nooit wezen, mijnheer de
stokmeester. Uw baard is ros en gij ziet er vreeselijk uit; maar
ik ben zeker, dat gij zachtmoedig van aard zijt en met tegenzin een
armen man, als ik, zoudt afranselen. Ik moet het u zeggen, maar slaan
doe of zie ik niet geerne, want de rug van een kerstenmensch is een
heilige tempel, die, evenals de borst, de longen bevat met dewelke
wij Gods goede lucht ademen. Heel uw leven door, zou de wroeging u
knagen als een ruwe stokslag mij aan stukken sloeg.

--Spoed u, sprak de stokmeester.

--Heer, zegde Uilenspiegel tot den prins, er is geene haast bij, ge
moogt mij gelooven; eerst zoudt gij dien stok moeten laten goed drogen,
want men zegt, dat het sap van groen hout een doodelijk vergif voor
het bloed is. Zou uwe Hoogheid mij zulken vreeselijken dood willen
zien sterven? Heer, ik behoud mijnen rug ten dienste Uwer Hoogheid;
laat hem slaan met roeden, hem striemen met de zweep; maar, als gij
mij niet wilt zien sterven, Heer, spaar mij toch het groen hout,
als het u belieft.

--Prins, schenk hem genade, spraken beiden, de heer van Hoogstraten
en Diederik van Schoonenberg. De anderen glimlachten goedhertig
en medelijdend.

Lamme kwam achteraan en zuchtte:

--Heer, genade, heer; groen hout is doodelijk vergif.

Toen sprak de prins:

--Ik schenk hem genade.

Uilenspiegel maakte eene tuimelpert, sloeg op Lamme's buik, dwong
hem tot dansen en sprak:

--Loof met mij Zijne Hoogheid, die mij van het groen hout heeft gered.

En Lamme beproefde te dansen, maar hij kon niet, ter oorzake van zijn
dikken buik.

En Uilenspiegel trakteerde hem en liet hem eten en drinken, zooveel
als hij kon.




XII.

De hertog wilde geen slag leveren, doch bestookte den Zwijger op 't
platteland tusschen Gulik en de Maas; Oranje deed overal den stroom
peilen, te Hond, Mechelen, Elsen, Meersen, en overal vonden zij er
voetangels in, om de mannen en peerden te kwetsen, die zouden pogen
den stroom over te steken.

Te Stokhem vonden de peilers er geene. De prins beval daar te waden. De
ruiters togen over den stroom en hielden zich aan den overkant in
slagorde, om het overzetten der troepen langs den kant van het bisdom
Luik te dekken; vervolgens kwamen, van den eenen tot den anderen oever,
tien rotten busschutters en boogschutters staan, die aldus den loop van
de Maas stremden, en in het midden van welke zich Uilenspiegel bevond.

Hij stond tot aan de dijen in 't water; somwijlen zelfs werden hij
en zijn peerd opgeheven door een plotselinge, verraderlijke golving.

Hij zag de voetknechten overgaan met een zakje buskruit op het
hoofd en hunne bussen omhoog; vervolgens kwamen de ammunitiewagens,
de haakbussen, de geleiders, de stukrijders, de slangen, de dubbele
slangen, de falkonetten, de dubbele falkonetten, de serpenten, de
halve serpenten, de dubbele serpenten, de slangen met wijden mond, de
kanonnen, de halve kanonnen, de dubbele kanonnen, de donderbussen, de
sakers, de kleine stukken bereden veldgeschut, geladen op voorwagens,
met twee peerden bespannen, en die in alles geleken op de kanonnen,
die men de Pistolen des keizers heette; daarna kwamen Vlaamsche
ruiters en landsknechten, die de achterhoede moesten dekken.

Uilenspiegel zocht iets te drinken, dat hem verwarmen kon. De
boogschutter Riesencraft, een Hoogduitscher, een mager, reusachtig
en wreedaardig man, die nevens hem op zijn peerd zat te ronken,
rook geweldig naar brandewijn. Uilenspiegel zocht naar de flesch
op het kruis van zijn peerd, en vond ze aan zijnen schouderband
geknoopt. Hij sneed het koordeken door, nam de flesch en dronk lustig
van het verkwikkende nat. De gezellen boogschutters zeiden tot hem:

--Geef ons ook een slok.

En hij gaf hun de flesch. Als de brandewijn op was, bond hij 't
koordeken weer aan de flesch en wilde ze terugbrengen op de borst van
den soldenier. Toen hij den arm oplichtte om de bottel er onder te
steken, werd Riesencraft wakker. Naarde bottel grijpend, wilde hij
zijn gewone koe melken. Daar hij er echter geene melk meer in vond,
ontstak hij in hevige woede.

--Dief, sprak hij, wat hebt gij gedaan met mijn brandewijn?

Uilenspiegel antwoordde:

--Uitgedronken. Onder doornatte ruiters is de brandewijn van één,
de brandewijn van allen. Gierig zijn is leelijk.

--Morgen daag ik u uit tot een tweegevecht, antwoordde Riesencraft,
en ik beloof u fatsoenlijk aan stukken te kappen.

--Wij zullen alles afkappen, sprak Uilenspiegel, hoofden, armen en
beenen. Maar zijt gij verstopt, dat uwe tronie zoo zuur ziet?

--Dat ben ik, sprak Riesencraft.

--Dan moet gij purgeeren, in stee van te vechten.

Zij kwamen overeen zich 's anderen daags met elkander te meten. Elk
mocht gekleed en uitgerust zijn lijk hij verkoos, en zij zouden naar
elkander kerven en kappen met een korten stootdegen.

Uilenspiegel vroeg, om voor zich zelven, den degen te mogen vervangen
door eenen stok, hetgeen hem toegestaan werd.

Intusschen waren al de soldaten over den stroom getogen en reeds
stelden zij zich in goede orde, op de bevelen hunner kapiteins en
kolonels. Nu verlieten ook de tien rotten schutters hunne vochtige
stelling.

En de Zwijger sprak:

--Wij marcheeren op Luik,

Uilenspiegel was er blijde om en riep met al de Vlamingen:

--Lang leve Oranje! Naar Luik! naar Luik!

Maar de vreemdelingen, en voornamelijk de Hoogduitschers zeiden, dat
zij te nat waren om te marcheeren. Te vergeefs bevestigde de prins
hun, dat zij naar een gewisse zegepraal gingen, naar eene stede met
hert en ziel hun toegedaan: zij wilden niet luisteren, en ontstaken
groote vuren om zich te warmen, met hunne onttuigde peerden.

De aanval der stad werd uitgesteld tot 's anderen daags; en Alva,
hoogst verbaasd over den stoutmoedigen overtocht, vernam door zijne
spionnen, dat de soldaten van den Zwijger nog niet bereid waren tot
den aanval.

Daarop deed hij Luik en heel de omliggende streek bedreigen alles in
vuur en vlam te zullen zetten, zoo de vrienden des prinsen er eenige
beweging maakten. Geeraard van Groesbeek, de bisschoppelijke serjant,
deed zijne soldaten wapenen tegen den prins, die te laat kwam door
de schuld der Hoogduitschers, benauwd voor een beetje water in hunne
schoenen.




XIII.

Uilenspiegel en Riesencraft hadden hunne getuigen gekozen; deze
beslisten, dat de twee soldaten te voet zouden vechten, totdat de
dood er op volgde, zoo dit den overwinnaar behaagde, want dit waren
de voorwaarden die Riesencraft stelde.

Het gevecht greep plaats in een kleine heide.

Reeds van den vroegen morgen had Riesencraft zijne kleedij van
boogschutter aan: de salade, dat is de helm, met ijzeren halsstuk,
zonder vizier, alsmede een maliënhemd zonder mouwen. Daar zijn ander
hemd aan stukken vaneen viel, stak hij het in zijnen helm om er in
geval van nood, pluksel van te maken. Hij nam eenen voetboog van goed
hout der Ardennen, eenen koker met dertig pijlen, een lange dagge,
doch geen tweehandig zweerd, dat een wapen der busschutters was. En hij
kwam naar het strijdperk op zijn handpeerd, dat met den oorlogszadel,
het met pluimen versierde hoofdharnas, en met een ijzeren borstharnas
opgetuigd was.

Uilenspiegel koos de uitrusting van een gewapenden ridder: tot rijdier
had hij een ezel; tot zadel de rokken eener deerne; het hoofdharnas
was van wisschen, versierd met wuivende schavelingen. Het borstharnas
van zijn rijdier was van spek, want zeide hij, het ijzer kost te duur,
het staal is buiten prijs en, wat het koper betreft, in de laatste
dagen heeft men er zooveel van noodig gehad om kanonnen te gieten,
dat er niet genoeg meer overblijft om een konijn uit te rusten; tot
hoofddeksel had hij een schoonen saladestruik, dien de slekken nog
niet opgegeten hadden; op de salade stak eene zwanepluim, om hem te
doen zingen als hij soms stierf.

Zijn stootdegen was een goede, lange, dikke stok van dennenhout, waarop
een bezem van dennentakken. Aan den linkerkant van zijnen zadel hing
zijn mes, van hout, aan zijne rechterzijde slingerde zijne strijdknots:
een vliertak met eene raap opgestoken. Zijn harnas bestond uit niets
dan gaten, met andere woorden: hij had er geen aan.

Als hij, aldus toegetakeld, plechtstatig het strijdperk binnenreed,
schoten de getuigen van Riesencraft in een luiden schaterlach, doch
de Hoogduitscher bleef norsch kijken met zijn bittere tronie.

Toen vroegen de getuigen van Uilenspiegel aan die van Riesencraft, dat
de Duitscher zijne uitrusting van maliën en ijzer zou uitdoen, vermits
Uilenspiegel slechts met lompen gepantserd was. Riesencraft stemde
er in toe. Daarop vroegen de getuigen van Riesencraft aan die van
Uilenspiegel hoe het kwam, dat de Vlaming met eenen bezem gewapend was.

--Gij liet mij toe den stootdegen door eenen stok te vervangen,
sprak Uilenspiegel, maar gij hebt mij niet verboden de takken er aan
te laten.

--Ga maar uw gang, spraken de vier getuigen.

Riesencraft zei geen woord, doch kapte, in zijne opgewondenheid,
met zijne stootdegen de schrale heideplanten af.

De getuigen zetten hem aan, zijn stootdegen neder te leggen en ook
eenen bezem te nemen, lijk Uilenspiegel.

Hij antwoordde:

--Als die truwant uit eigen beweging een zoo gemeen wapen koos,
is het dat hij meent daarmede zijn leven te kunnen verdedigen.

Daar Uilenspiegel opnieuw verklaarde, dat hij zijnen bezem wilde
gebruiken, drongen de vier getuigen niet verder aan en zeiden zij
dienvolgens, dat alles in regel was.

Beiden stonden tegenover elkander: Riesencraft op zijn peerd,
dat met ijzer geharnast, Uilenspiegel op zijnen ezel, die met spek
gepantserd was.

Uilenspiegel reed tot in het midden van het veld. Zijnen bezem recht
als eene lans houdend, zeide hij:

--Dat gespuis, dat, in het leger van dappere makkers, anders niets
doet dan schuimbekkend van woede, met een zure tronie rond te loopen om
ruzie te zoeken, stinkt erger dan pest, dan melaatschheid en dood. Waar
zij komen, vlucht de lach, versterft het blijde liedeken. Zij moeten
altoos brommen of vechten, en zij vervangen het heilig gevecht
voor het vaderland door het tweegevecht, dat het leger ondermijnt
tot vreugde van den vijand. Riesencraft, hier tegenwoordig, heeft,
om onschuldige poetsen, een en twintig zijner gezellen vermoord,
maar nimmer verrichtte hij zelf, in gevecht of schermutseling,
een schitterende heldendaad of erlangde hij om betoonden moed de
minste belooning. Nu, heden behaagt het mij, het ruige vel van dien
twistzieken hond eens averechts te borstelen.

Riesencraft antwoordde:

--Die dronkelap heeft schoone dingen hooren vertellen over het
misbruik der tweegevechten; heden behaagt het mij hem het hoofd in
tweeën te klieven, om aan elkeen te toonen, dat er maar hooi in zijne
hersenpan steekt.

De getuigen deden hen afstijgen. Uilenspiegel liet van zijn hoofd
den saladestruik vallen, dien de ezel gretig binnensloeg; doch het
grauwtje werd in die bezigheid gestoord door eenen schop van een der
getuigen, om hem buiten de omheining van het strijdperk te drijven. Het
geharnaste peerd ontving mede zijn deel en de beide dieren gingen
eendrachtiglijk grazen in 't ronde.

De getuigen van Uilenspiegel, die eenen bezem droegen, en de getuigen
van Riesencraft, die eenen stootdegen voerden, gaven fluitend het
teeken van 't gevecht.

En Riesencraft en Uilenspiegel vochten als razenden: Riesencraft sloeg
met zijn stootdegen, Uilenspiegel weerde de slagen af met zijn bezem;
Riesencraft zwoer bij alle duivelen, Uilenspiegel ontweek de slagen,
liep schuins, draaide rechts, keerde links door de heide, stak de tong
uit en zette allerlei vieze gezichten naar Riesencraft, die, ziedend
van woede, buiten adem geraakte en blindelings als een dronkeman in
de lucht kapte. Als Uilenspiegel hem vlak achter zich voelde, keerde
hij zich plotseling om en gaf hem, met zijnen bezem, een forschen
slag onder den neus. Riesencraft viel neder met uitgestrekte armen
en beenen, lijk een kikvorsch op zijn uiterste.

Uilenspiegel wierp zich op hem, streek zonder genade den bezem rechts
en averechts over zijn aangezicht en sprak:

--Roep om genade, of ik doe u den bezem slikken!

En hij wreef en herwreef, tot groot genoegen van de omstanders,
en zeide altijd:

--Roep om genade, of ik doe u hem slikken!

Maar Riesencraft kon niet meer roepen, want hij was dood van woede
en gramschap.

--God hebbe uwe ziel, arme razende! zeide Uilenspiegel.

En treurig gestemd, toog hij henen.




XIV.

Het was het einde van Wijnmaand. Geld ontbrak aan den prins; zijne
soldaten hadden honger. Zij morden; de prins marcheerde naar Frankrijk
en bood den hertog 't gevecht aan, maar deze weigerde het.

Uit Quesnoy-le-Comte vertrokken om naar het land van Kamerijk te gaan,
ontmoette hij tien compagnieën Duitschers, acht vendels Spanjaards
en drie kornetten ruiterij, aangevoerd door don Ruffele Henricis,
zoon des hertogen, die te midden van het gevecht in het Spaansch riep:

--Slaat dood! Slaat dood! Geen kwartier! Leve de Paus!

Don Henricis met zijne mannen, tegenover de compagnie busschutters,
waarbij Uilenspiegel tiendenier was, wierp zich op hen.

Uilenspiegel zeide tot den bentserjant:

--De tong van dien beul ga ik in tweeën snijden!

--Snij maar op, zei de serjant.

En met een goed gerichten kogel, verplette Uilenspiegel tong en kaken
van don Ruffele Henricis, zoon van den hertog.

Uilenspiegel schoot ook den zoon van den markies Delmares van zijn
peerd.

De acht vendels en de drie kornetten werden verslagen.

Na die zegepraal zocht Uilenspiegel naar Lamme, in het kamp en in
't ronde, maar hij vond hem niet.

--Laas! sprak hij, hij is weg, mijn vriend Lamme, mijn dikke vriend. In
het vuur van den strijd zal hij het gewicht van zijn buik vergeten
en de Spaansche vluchtelingen achternagezet hebben. Buiten adem, zal
hij op den weg gevallen zijn als een zak. En zij zullen hem opgeraapt
hebben, om er losgeld van te trekken; losgeld voor kerstenspek. Vriend
Lamme, waar zijt gij toch, waar zijt gij, mijn arme, vette vriend?

Uilenspiegel zocht hem overal, en, hem niet vindend, was hij treurig
gestemd.




XV.

In de Slachtmaand, de maand der sneeuwstormen, ontbood de Zwijger
Uilenspiegel vóór zich. De prins beet op de koord van zijn maliënhemd.

--Luister goed, sprak hij.

Uilenspiegel antwoordde:

--Mijne ooren zijn gevangenispoorten; men komt er gemakkelijk binnen,
maar uitgeraken is een andere zaak.

De Zwijger sprak:

--Ga door Namen, Henegouw, Vlaanderen, Zuid-Brabant, Antwerpen,
Noord-Brabant, Gelderland, Overijsel, Noord-Holland overal verkondigen,
dat, zoo het geluk onze heilige en kerstene zaak te lande verlaat,
de strijd tegen onrecht en geweld ter zee voortgezet wordt. God
bestiere genadig deze zaak, in voor- als in tegenspoed. Te Amsterdam
gekomen, zult gij Pauwel Buys, mijn getrouwe, rekenschap geven van
uwe zending. Hier zijn drie passen, door Alva zelven onderteekend en
gevonden op verslagenen te Quesnoy-le-Comte. Mijn schrijver heeft ze
behoorlijk ingevuld. Wellicht vindt gij onderwege een goeden gezel,
in wien gij vertrouwen moogt stellen. Goeden zijn zij, die op 't
gezang van den leeuwerik antwoorden met 't krijgshaftig gekraai van
den haan. Hier zijn vijftig gulden. Wees moedig en trouw.

--De assche klopt op mijn hert, antwoordde Uilenspiegel. En hij
toog henen.




XVI.

Met oorlof van den koning en van den hertog, mocht hij, naar believen,
alle wapenen dragen. Hij nam zijn goede radbus, patronen, alsmede
droog kruit. Vervolgens trok hij een gescheurd wambuis, een gelapt
opperste kleed en eene hooze met gaten aan; naar Spaansche wijs zette
hij eene toque met wuivende pluim op en gordde een zweerd om. Aldus
verliet hij het leger en stapte naar Maastricht.

De winterkoninkjes, voorboden der koude, vlogen rond de huizen, om
eene schuilplaats te zoeken. Den derden dag viel het aan 't sneeuwen.

Menigwerf moest Uilenspiegel onderwege zijne vrijgeleide vertoonen. Men
liet hem overal door. Hij zette zijn weg voort naar Luik.

Hij kwam in eene vlakte; een hevige wind joeg de vlokken in zijn
gezicht. Vóór zich zag hij de oneindige, witte vlakte, gesluierd door
dwarrelende sneeuwbuien. Drie wolven volgden hem op de hielen; hij
velde er eenen neder met zijne bus; de anderen wierpen zich op den
gewonde, trokken hem vaneen en liepen het bosch in, elk met een stuk.

Van dat gezelschap verlost, keek Uilenspiegel of er geen andere bende
in 't veld was. Ten einde de vlakte zag hij meerdere stipjes als
grijze standbeelden, die zich bewogen in den sneeuwstorm, en achter
hen, zwarte gedaanten van soldaten te peerd.

Hij klom op eenen boom. De wind bracht een verre geweeklaag
tot hem. "Wellicht", zeide hij in zichzelven, "wellicht zijn het
pelgrims met witte pijen: met moeite zie ik iets van hun lichaam in
de sneeuw." Vervolgens onderscheidde hij menschen, die naakt liepen,
en twee ruiters met zwarte harnassen op groote peerden gezeten,
welke die ellendige kudde met zweepslagen voortdreven. Hij wapende
zijne bus. Onder die ongelukkigen zag hij jongelieden en grijsaards,
naakt, bibberend, verkleumd, ineengedrongen, angstig voortloopend om
de zweep te ontvluchten van de twee soldaten, die, warm gekleed, rood
van brandewijn en goeden kost, er vermaak in schepten, het lichaam
dier naakte menschen tot bloedens toe te striemen, om ze nog sneller
te doen aanstappen.

Uilenspiegel sprak:

--Gij zult gewroken worden, assche van Klaas.

En hij zond een kogel in 't voorhoofd van een der ruiters, die dood
van zijn peerd viel. De andere, die niet wist van waar die onverwachte
kogel kwam, werd bang, en dacht dat vijanden in het bosch verborgen
waren. Hij wilde vluchten met het peerd van zijn makker. Maar terwijl
hij met den teugel van dat dier in de hand van zijn peerd steeg om
het geld van den doode te rooven, werd hij in den hals getroffen door
een anderen kogel en viel hij insgelijks dood ten gronde.

De naakten meenden, dat een engel des hemels, een goed schutter,
hun ter hulp kwam, en vielen op de knieën. Toen kwam Uilenspiegel van
zijnen boom en werd erkend door mannen uit den troep, die, als hij,
in het leger des prinsen gediend hadden. Zij zeiden tot hem:

--Uilenspiegel, in dezen jammerlijken staat werden wij uit Frankrijk
naar Maastricht gezonden, waar de hertog is, om daar behandeld te
worden als gevangen muitmakers; daar wij geen rantsoen kunnen betalen,
zijn wij van te voren veroordeeld om gefolterd en onthalsd te worden
of, als truwanten en diepers, op de galeien des konings te roeien.

Uilenspiegel gaf zijn opperste kleed aan den oudste der bende en sprak:

Komt, ik zal U naar Mézières leiden, maar eerst moeten wij dezen
soldaten hunne kleeren uittrekken en hunne peerden meenemen.

De wambuizen, hoozen, leerzen en hoeden der soldeniers werden verdeeld
onder de zwaksten en de zieksten, en Uilenspiegel sprak:

--Wij gaan in het bosch: daar is het zoo koud niet, de lucht is er
zoeter. Komt, broeders, komt mede.

Doch een der mannen viel ten gronde en zuchtte:

--Ik sterf van kou en van honger, en vóór God zal ik getuigen, dat
de paus de antichrist is.

En hij stierf. De anderen wilden hem meenemen, om hem als kerstenmensch
te begraven.

Terwijl zij op de groote baan gingen, zagen zij eenen boer met eene
huifkar. Als hij de naakte menschen zag, kreeg hij medelijden en deed
hij hen in zijne kar komen, waar zij hooi vonden om op te liggen en
ledige zakken om hun schamelheid te bedekken. Zij dankten God, dat
zij warm lagen. Uilenspiegel reed naast de kar op een van de peerden
der soldaten, terwijl hij de andere bij den toom leidde.

Te Mézières stapten zij uit de kar; daar gaf men hun goede soep, bier,
brood en kaas, en vleesch aan de ouderlingen en aan de vrouwlieden. En
zij werden geherbergd, gekleed en opnieuw gewapend ten koste van de
gemeente. En tot zegening kusten allen Uilenspiegel, die hen goedhertig
liet begaan.

Deze verkocht de peerden der twee ruiters voor acht en veertig gulden,
waarvan hij er dertig aan de verloste gevangenen gaf.

Eenzaam voortgaande, sprak hij in zich zelven:

--Ik ga langs puinhoopen, dood en bloed, zonder iets te vinden. De
duivelen hebben zeker gelogen. Waar is Lamme? Waar is Nele? Waar zijn
de Zeven?

En de assche van Klaas klopte op zijne borst. En hij hoorde eene stem
als een ademtocht fluisteren: "Zoek in dood, puinen en tranen".

En hij ging voort.




XVII.

In de Lentemaand kwam Uilenspiegel te Namen. Hij vond er Lamme, die
groot liefhebber geworden was van visch uit de Maas en hoofdzakelijk
van forellen. Hij had een boot gehuurd en vischte in den stroom met
toelating van de gemeente. Maar hij had vijftig gulden moeten betalen
aan de nering der vischverkoopers.

Zijne vangst at hij op of verkocht hij, en aldus herstelde hij de
rondheid van zijnen buik en vergaarde hij een zakje karolussen.

Toen hij zijn vriend Uilenspiegel op den oever van de Maas naar de
stadspoort zag stappen, was hij aangenaam verrast; hij stak zijn bootje
naar wal, klaverde den oever op, niet zonder blazen, en kwam naar hem.

Stamelend van genoegen, sprak hij:

--Zijt gij daar, mijn zoon, want ik mag u zoo noemen: mijn buik is
tweemaal zoo dik als de uwe. Waar gaat gij? Wat doet gij? Gij zijt
toch niet dood? Hebt gij mijne vrouw niet gezien? Gij zult visch uit
de Maas eten, de beste, die in dit tranendal bestaat; hier maken ze
sausen, dat men er de pan bij zou opeten. Gij zijt schoon en vroom,
met uwe kaken gebruind door 't gevecht. Daar is hij eindelijk, mijn
zoon, mijn vriend Uilenspiegel, de lustige zwerver!

En stille vroeg hij hem:

--Hoeveel Spanjolen hebt gij geknipt? Hebt gij mijne vrouw niet
gezien in hunne karren met loddegen? En gij zult wijn van de Maas
drinken; hij is heerlijk en bevordert de spijsvertering. Zijt gij
gekwetst, mijn zoon? Gij blijft dus hier, frisch, gezond en wel te
pas als een veulen. En de paling moet gij proeven! Niet de minste
grachtsmaak! Omhels mij, mijn vriend! Bij God, wat ben ik tevreden!

En Lamme danste, sprong, blies en dwong ook Uilenspiegel tot dansen.

Toen stapten zij op naar Namen. Aan de poort van de stad toonde
Uilenspiegel zijn reispas, onderteekend door den hertog van Alva. En
Lamme leidde hem mede naar huis.

Terwijl hij den maaltijd bereidde, deed hij hem zijne lotgevallen
verhalen en vertelde hij ook zijn eigen wedervaren. Hij had, zeide hij,
het leger verlaten om een meisje te volgen, dat, naar hij meende, zijne
vrouw was. En zoo was hij tot in Namen gesukkeld. En gedurig vroeg hij:

--Hebt gij ze niet gezien?

--Ik heb er anderen gezien, met schoone gezichtjes, antwoordde
Uilenspiegel, en dat wèl in deze stede, waar allen verliefd schijnen.

--Om de waarheid te zeggen, sprak Lamme, ik kan er krijgen zooveel
als ik wil, maar ik blijf trouw aan mijne vrouw, want mijn jammerend
hert is vervuld van haar aandenken.

--Lijk uw buik van menigvuldige gerechten, antwoordde Uilenspiegel.

Lamme hernam:

--Als ik verdriet heb, moet ik eten.

--Is uw verdriet eeuwigdurend? vroeg Uilenspiegel.

--Laas ja! sprak Lamme.

Meteen trok hij eene forel uit eene kuip.

--Zie eens, sprak hij, hoe schoon en hoe vast. Het vleesch is
rooskleurig als dat mijner vrouw. Morgen verlaten wij Namen; ik
heb een vollen zak guldens; wij zullen elk een ezel koopen en naar
Vlaanderen reizen.

--Gij zult er veel bij verliezen, sprak Uilenspiegel.

--Mijn hert trekt naar Damme, naar de plaats, waar zij mij vurig
beminde. Misschien wacht zij daar.

--Vermits gij het wilt, sprak Uilenspiegel, zullen wij morgen
vertrekken.

En inderdaad, 's anderen daags kochten zij ezels en reden zij naast
elkander de stad uit.




XVIII.

Een gure wind blies over de aarde. De lucht, die 's morgens helder
als de jeugd was, werd grijs als de oude dag. Het regende en hagelde.

Toen de regen opgehouden had, schudde Uilenspiegel zich, zeggende:

--De hemel drinkt zooveel dampen op, dat hij zich soms moet ontlasten.

Maar het begon weer te regenen en te hagelen, en nog meer dan de
eerste maal. De twee gezellen waren doornat.

Lamme zuchtte:

--Wij waren goed gewasschen, nu is men ons aan't spoelen! De zonne
kwam weer te voorschijn en blijgemoed stegen zij weder op hunne ezelen.

Doch nu begon het zoo moorddadig te hagelen, dat de droge takken der
boomen als met messen afgekapt werden.

Lamme sprak:

--Ho! een dak toch! Mijn arme vrouw! Waar zijt gij, goed vuurtje,
zoete kussen en lekkere hutsepot?

En hij weende, de dikzak.

Doch Uilenspiegel sprak:

--Wij jammeren en weeklagen; maar is het niet van ons zelven, dat
al onze kwalen ons komen? Het regent en hagelt op onze schouderen,
doch die winterregen kweekt malsche meiklaver. En de runderen zullen
loeien van genoegen. Wij zijn zonder schuilplaats, maar waarom trouwen
wij niet? Ik toch, ten minste, waarom trouw ik niet met Nele, die zoo
schoon en zoo braaf is, en die mij nu een goeden schotel boonen met
gestoofd vleesch zou voorzetten? Wij hebben dorst, niettegenstaande het
water, dat valt; waarom bleven wij niet bij een zelfde ambacht? Zij,
die meester aanveerd zijn, hebben heele tonnen bruinbier in hunne
kelders.

De assche van Klaas klopte op zijn hert, de hemel werd helder, de
zonne schitterde aan het uitspansel en Uilenspiegel sprak:

--Mevrouw de Zon, ik zeg u duizendmaal dank, ge komt onze lendenen
verwarmen; assche van Klaas, gij verwarmt ons hert en zegt ons dat
diegenen gezegend zijn, die zwerven voor de verlossing van den bodem
der vaderen.

--Ja, maar 'k heb honger, zei Lamme.




XIX.

Zij trokken eene afspanning binnen, en men gaf er hun te eten in de
kelderkamer. Uilenspiegel opende het venster en zag van daar eene
lochting, in dewelke een minnelijk, poezel meideken wandelde, met
ronden boezem en gouden lokken. Zij had anders niet aan dan een rok,
een wit linnen jakje en een zwart voorschoot met gaatjes.

Hemden en ander vrouwenlinnen hingen te drogen; het meisje was steeds
naar Uilenspiegel gekeerd, trok de hemden van de koorden, hing ze
weder op, glimlachte en keek gedurig naar Uilenspiegel.

In de nabijheid hoorde Uilenspiegel eenen haan kraaien en zag hij
eene voedster met een kind spelen, wiens gezichtje zij naar eenen
man toekeerde, terwijl zij zeide:

--Boelkin, trek oogskens naar vader, toe!

Het kind schreide.

En het aanvallig meideken bleef in de lochting ronddrentelen en het
linnen afnemen en weder ophangen.

--'t Is eene, die aan den hertog verkocht is, sprak Lamme. Het meideken
bracht heure handen voor heure oogen en tusschen de vingeren loerend,
keek ze lachend naar Uilenspiegel.

Vervolgens ging zij op een der gespannen koorden zitten en schommelde,
zonder met heure voeten den grond aan te raken. Onder 't schommelen,
liet zij Uilenspiegel heure blanke, ronde armen zien, bloot tot aan
heur schouderen en die de bleeke zonne bestraalde. Op en neder wippend,
bekeek zij hem gestadig. Hij ging buiten om tot heur te gaan. Lamme
volgde hem. Aan de haag van de lochting zocht Uilenspiegel eene
opening om door te geraken, doch te vergeefs.

Als het meideken hem zoo bezig zag, gluurde zij nogmaals glimlachend
tusschen heure vingeren.

Uilenspiegel wilde door de haag geraken, maar Lamme hield hem met
alle geweld tegen en sprak:

--Ga daar niet binnen, 't is eene verklikster, in dienst van den
Spanjaard: wij worden levend verbrand.

Toen wandelde het meisje rond in de lochting, met heur voorschoot
over heur gezicht, doch keek door de gaatjes om te zien of heur nieuwe
vriend nog niet kwam.

Uilenspiegel wilde met een forsigen wip over de haag springen, doch
hij werd weerhouden door Lamme, die hem, bij zijn been grijpend,
deed vallen en zeide:

--Koord, zweerd en galg, 't is eene verklikster, ga niet tot haar,
zeg ik u.

Uilenspiegel verweerde zich zoo goed hij kon. Het meideken stak het
hoofd over de haag en riep:

--Vaarwel, heer, dat de liefde Uwe Lankmoedigheid onderhoude.

En hij hoorde een spottenden schaterlach.

--Ha! sprak hij, in mijne ooren steekt dat als duizend speldeprikken!

Eene deur werd luidruchtig gesloten.

En hij was gansch weemoedig.

Lamme, die hem nog altoos vasthield, zeide tot hem:

--Met spijt denkt gij aan den verloren schat. Maar 't is eene
verklikster, die u in heur spionnennet zou lokken. En gij merkt het
niet: ik berst van lachen.

Uilenspiegel zei geen woord en de beide gezellen stegen weder op
hunne ezelen.




XX.

Zij reden sprakeloos voort, schrijlings op hun grauwtje gezeten.

Lamme kauwde zijn laatsten maaltijd, terwijl hij blijgemoed met volle
teugen de frissche lucht ademde.

Plotseling gaf Uilenspiegel hem eenen zweepslag over zijn achterste,
dat met een band rond den zadel lag.

--Wat doet gij? riep Lamme jammerend uit.

--Wat? vroeg Uilenspiegel.

--Die zweepslag, zei Lamme.

--Welke zweepslag?

--Dien gij mij daar geeft, hervatte Lamme.

--Links? vroeg Uilenspiegel.

--Ja, links en op mijn achterste. Waarom deedt gij dat, schaamtelooze
nietdeug?

--Uit onwetendheid, antwoordde Uilenspiegel. Ik weet heel goed wat
een zweep is, en ook heel goed wat een achterste is, dat op eenen
zadel gespannen zit. Nu, als ik het uwe, breed, gespannen over den
zadel zag steken, zei ik in mijn zelven: Daar men met de vingeren
er niet in kan nijpen, kan het koordeken van de zweep er ook niet op
bijten. Ik was mis, ik beken het rechtuit.

Lamme glimlachte op die rede, en Uilenspiegel vervolgde:

--Maar ik ben de eenige niet op de wereld, die uit onwetendheid
zondigt, en meer dan één dwaze meester, die zijn overtollig vet op den
zadel eens ezels ten toon spreidt, zou mij daar lessen in geven. Als
mijne zweep zich vergat ten opzichte van uw achterste, vergat gij u
nog meer ten opzichte van mijne beenen, door hun te beletten achter
het meisje te loopen, dat in de lochting mij zoo lodderlijk wenkte.

--Aas voor de raven, zei Lamme, 't was dus uit wraaklust?

--Een heel klein beetje, antwoordde Uilenspiegel.




XXI.

Nele leefde bedroefd en eenzaam te Damme bij Katelijne, die om den
ijskouden duivel riep, maar dewelke niet kwam.

--Ach! zei ze, gij zijt rijk, Hansken, en zoudt mij de zevenhonderd
karolussen kunnen terugbrengen. Soetkin zou op aarde terugkomen en
Klaas zou tevreden zijn in het hemelrijk; gij moet ze teruggeven. Doe
het vuur weg, de ziel wil er uit, maak een gat, mijn ziel wil er uit.

En gedurig wees zij met den vinger naar de plaats, waar het werk heur
hoofd verbrand had.

Katelijne was nu zeer arm, doch de buren stonden haar bij met boonen,
met brood en met vleesch, al naarvolgens hunne middelen. Ook de
disch gaf heur wat geld. En Nele naaide voor de rijke poorteressen,
ging uit strijken en verdiende aldus een gulden per week.

En Katelijne riep altoos:

--Maak een gat, laat mijne ziel er uit. Zij klopt om buiten te
zijn. Hij zal de zevenhonderd karolussen teruggeven.

En weenend aanhoorde Nele heur waanzinnige reden.




XXII.

Doch Uilenspiegel en Lamme, met hunne reispassen op zak, trokken een
kleine taveerne binnen, tegen de rotsen der Samber gebouwd, die op
sommige plaatsen met boomen bedekt zijn. En boven de deur stond te
lezen: Bij Marlaire.

Zij dronken menige bottel wijn van de Maas, bereid naar de wijze van
Bourgondië, en aten veel waterzooi; daarna begonnen zij te praten met
den baas, een eersten paapschgezinde, maar die gestadig heimelijk
knipoogde, en babbelde als een ekster, ter oorzake van den wijn,
dien hij gedronken had.

Uilenspiegel, die in de gaten had dat achter dat knipoogen iets
schuilde, deed hem nog meer drinken, zoodat de weerd begon te dansen
en te schaterlachen. Vervolgens kwam hij weer aan de tafel zitten
en sprak:

--Goede katholieken, ik drink op uwe gezondheid!

--Op de uwe! antwoordden Lamme en Uilenspiegel. Op de uitroeiing van
ketters en muitmakers!

En Lamme en Uilenspiegel vulden gestadig den beker, dien de weerd
dadelijk weer leeg dronk.

--Gij zijt brave lieden, en ik drink op uwe gezondheid. Hoe meer ik
drink, hoe grooter mijn winst is. Waar zijn uwe passen?

--Hier, antwoordde Uilenspiegel.

--Geteekend door den hertog, sprak de weerd. Ik drink op den hertog!

--Wij drinken op de gezondheid van den hertog, antwoordden Lamme
en Uilenspiegel.

De weerd vervolgde:

--Waarmee vangt men ratten en muizen? Met vallen, niet waar? Wie
is de muis? 't Is de groote Oranjeketter, die rood ziet als 't
vuur van de hel. God is met ons. Zij komen weldra. He! He! laat
ons drinken! Schenkt in; ik kook, ik brand. Laat ons drinken! Heel
schoone gereformeerde predikantjes.... Ik herhaal predikantjes, dapper
en sterk lijk eiken, onze kloeke soldaten.... Laat ons drinken! Gaat
gij met hen mede naar 't kamp van den aartsketter? Reispassen heb ik,
geteekend door hem.... Gij zult hen aan 't werk zien.

--Wij gaan mee naar het kamp!

Zij zullen er zich deugd doen, en 's nachts, als de gelegenheid
gunstig is (en fluitend maakte de weerd het gebaar van een man, die
een anderen keelt), zal Stalen Wind de meerle Nassau het schuifelen
wel afleeren. Laat ons drinken, laat ons drinken!

--Gij zijt een vroolijke kwant, al zijt gij getrouwd, antwoordde
Uilenspiegel.

De weerd sprak:

--Dat ben ik of was ik nooit. Ik bewaar de geheimen der vorsten. Laat
ons drinken!--Had ik eene vrouw, zij zou ze mij ontstelen op 't
oorkussen, om mij te doen hangen, en weduwe zijn vóór de Natuur het
beliefde. Bij God! Zij komen.... Waar zijn de nieuwe reispassen? Op
mijn christelijk hert. Laat ons drinken! Dáár zijn ze, op driehonderd
stappen van hier, op den weg, nabij Marche-les-Dames. Ziet gij ze? Laat
ons drinken!

--Drink, zeide Uilenspiegel, drink; ik drink op de gezondheid van
den koning, van den hertog, van de predikanten, van Stalen Wind; op
uwe gezondheid, op mijne gezondheid, op de gezondheid van den wijn
en op de gezondheid van de bottels! Maar gij drinkt niet....

En op elken heildronk vulde Uilenspiegel het glas en ledigde de weerd
het tot den bodem.

Uilenspiegel sloeg hem eene wijl gade; toen stond hij recht en
sprak hij:

--Hij slaapt, laat ons gaan, Lamme.

En toen zij buiten waren, hernam hij:

--Hij heeft geene vrouw, die ons zal verraden.... De nacht gaat
vallen.... Hebt gij gehoord wat de schoft gezegd heeft, en weet gij
wie de drie predikanten zijn?

--Ja, sprak Lamme.

--Gij weet, dat zij van Marche-les-Dames komen langs den oever der
Maas, en dat wij wèl zullen doen, hen op den weg af te wachten,
vóór Stalen Wind blaast.

--Ja, zei Lamme.

--Wij moeten het leven des prinsen redden, sprak Uilenspiegel.

--Wij moeten, zei Lamme.

--Hier is mijn bus, sprak Uilenspiegel, ga er mee in het kreupelhout
tusschen de rotsen; laad ze met twee kogels en schiet als ge mij lijk
de raaf hoort krassen.

--Ik zal, zei Lamme.

En hij verdween in het kreupelhout. En Uilenspiegel hoorde weldra
het gekraak van het rad van de bus.

--Ziet gij ze komen? vroeg hij.

--Ik zie ze, antwoordde Lamme. Zij zijn gedrieën en gaan als soldaten,
en een hunner is een kop grooter dan de anderen.

Uilenspiegel zette zich neer op den weg, de beenen vooruit,
paternosters te mompelen, lijk de bedelaars doen. En zijn hoedeken
lag tusschen zijne knieën.

Als de drie predikanten voorbijkwamen, stak hij hun zijn hoedeken
toe. Maar zij legden er niemendal in.

Uilenspiegel stond recht en zeide op erbarmelijken toon;

--Goede heeren, weigert geen oortje aan een armen werkman, die
laatst in eene steengroef gevallen is en zich de ribben brak. Ze
zijn hardvochtig in deze streek en ze hebben mij niets gegeven,
om mijn ellende te lenigen. Laas! geeft mij een oortje en ik zal
voor u bidden. En God zal uwe bermhertigheid hier op de aarde met
vreugde beloonen.

--Mijn zoon, sprak een der predikanten, een sterke vent, voor ons geene
vreugde op aarde, zoolang de Paus en de Inquisitie zullen heerschen.

Uilenspiegel zuchtte als hij, en sprak:

--Laas! wat zegt gij, mijne heeren? Spreekt stiller, als het u
belieft. Maar geeft mij een oortje.

--Mijn zoon, antwoordde een kleine predikant met een strijdlustige
tronie, wij, arme martelaren, hebben maar juist oortjes genoeg om
onderwege onze nooddruft te koopen.

Uilenspiegel viel op de knieën.

--Zegent mij dan ten minste, sprak hij.

De drie predikanten strekten de hand uit over Uilenspiegels hoofd,
maar zonder godsvertrouwen.

Doch daar hij merkte dat zij mager waren, en toch dikke buiken hadden,
richtte hij zich op en gebaarde te vallen. En met het voorhoofd tegen
den buik van den grooten predikant botsend, hoorde hij daarin het
vroolijk gerinkel van geldstukken.

Toen sprong hij recht en, zijn kruismes trekkend, riep hij:

--Goede vaders, het is koel, ik ben dun gekleed, en gij hebt te
veel. Geeft mij van uwe wol, dat ik er mij een mantel van make. Ik
ben Geus! Leve de Geus!

De groote predikant antwoordde:

--Geus, gij draagt uwen kam te hoog; wij zullen hem kappen.

--Kappen! sprak Uilenspiegel; ik zeg u, dat Stalen Wind u, vóór den
prins, zal omverblazen. Geus ben ik, leve de Geus!

De drie onthutste predikanten spraken:

--Hoe weet hij dat? Wij zijn verraden. Ter dood! Leve de misse!

En van onder hunne hooze trokken zij goed aangezette kruismessen uit.

Maar zonder hen af te wachten, week Uilenspiegel achteruit, langs
het struikgewas, waarin Lamme verscholen zat.

Als hij oordeelde, dat de predikanten binnen het bereik van het schot
waren, riep hij:

--Raven, zwarte raven, Looden Wind blaast! Ik zing uwen dood.

En hij kraste.

Een busschot kwam uit het struikgewas, smeet den grootsten predikant
met zijn gezicht ter aarde. Een tweede schot velde den tweeden.

En Uilenspiegel ontwaarde tusschen het struikgewas de goede tronie van
Lamme, en zijn opgeheven arm, die haastiglijk de bus opnieuw laadde.

Een blauwe rookwolk steeg op uit het donker struikgewas.

De derde predikant viel, als in razernij, op Uilenspiegel aan,
die zeide:

--Stalen Wind of Looden Wind, ook gij verhuist naar de andere wereld!

En hij greep hem aan en hij stond dapper te weer.

Elkaar scherp in het oog houdend, stonden de beide vijanden pal op den
weg, steken toebrengend en afwerend. Uilenspiegel was heel met bloed
bedekt, want zijn tegenstander, behendig soldaat, had hem gekwetst
aan hoofd en been. Maar hij vocht als een leeuw. Het bloed gutste
uit zijn hoofd, en verblindde hem: toch weerde hij af, met groote
achterweertsche passen. Met de linkerhand wischte hij zijn bloed af,
maar zijne krachten verflauwden. Zeker ware hij gedood, hadde Lamme,
met een derde schot, den predikant niet geveld.

En een vloek stierf op zijne lippen, terwijl hij bloed en doods-schuim
braakte.

En opnieuw steeg een blauwe rookwolk uit het struikgewas, waartusschen
Lamme weer zijne goede tronie zien liet.

--Is 't gedaan? vroeg hij.

--Ja, mijn vriend, antwoordde Uilenspiegel, maar kom....

Als Lamme te voorschijn kwam, zag hij Uilenspiegel gansch met bloed
bedekt.

Ondanks zijnen buik, liep hij als een hert, en kwam bij Uilenspiegel,
die nabij de gedoode mannen zat.

--Hij is gekwetst, mijn goede vriend, sprak hij, gekwetst door dien
vuigen moordenaar!

En, met een schop, sloeg hij de tanden van een der predikanten stuk.

--Gij antwoordt niet, Uilenspiegel, hernam hij; gaat gij sterven? Waar
is de balsem? Ha, in de weitasch, onder de worsten.

... Uilenspiegel, hoort gij mij niet? Laas, ik heb geen warm
water om uwe wonden te wasschen, en er is geen middel om er
te krijgen. Maar ik haal water uit de Samber. Spreek toch, mijn
vriend. Gij zijt toch zóó erg niet gekwetst? Hier, een weinig koud
water, niet waar? Ha, hij wordt wakker. Ik ben het, uw vriend; ze
zijn allemaal dood. Linnen! linnen om zijne wonden te verbinden! Er
is er geen. Ha! mijn hemd!

Lamme kleedde zich uit en vervolgde:

--Aan stukken, het hemd! Het bloed is gestelpt. Mijn vriend zal niet
sterven.... 't Is koeltjes, zoo bloot in de vinnige lucht. Ik ga mij
weer aankleeden. Hij zal niet sterven. Ik ben het, Uilenspiegel, ik, uw
vriend Lamme. Hij glimlacht. Ik ga de moordenaars aftasten. Zij hebben
guldens in hunnen buik. Ja, zij hebben gouden darmen: karolussen,
daalders, lammeren, florijnen, oortjes en brieven! Wij zijn rijk! Meer
dan driehonderd karolussen voor ons getweeën. Wij zullen de wapenen
nemen en 't geld. Stalen Wind zal niet blazen voor den edelen prins!

Uilenspiegel klappertandde door de koude, en stond op.

--Daar zijt gij op de beenen! sprak Lamme.

--Door de kracht van den balsem, antwoordde Uilenspiegel.

--Balsem van dapperheid! zeide Lamme.

Vervolgens sleepte hij de lijken van de predikanten een voor een
voort, en smeet ze in een hol, tusschen de rotsen, met hunne wapenen
en hunne kleederen, behalve den mantel.

In de lucht fladderden de raven, krassend van ongeduldige vraatzucht.

En de Samber vloeide als een stalen stroom, onder den grauwen hemel.

En de sneeuw viel en wischte de bloedvlekken uit. Maar toch waren
zij ongerust en bekommerd.

Lamme sprak:

--Ik dood liever een kieken dan een mensch.

En zij stegen weder op hunne ezels.

Aan de poorten van Hoei, bloedden de wonden nog altijd; de vrienden
gebaarden daar twist te krijgen, stegen van hunne ezels en schermden
met hunne kruismessen. Na het gevecht, dat zeer wreed in schijn was,
stegen zij weder op hunne dieren en kwamen binnen de stede, nadat
zij aan de poorten hunne reispassen hadden getoond.

Toen de vrouwen Uilenspiegel gekwetst en Lamme zegevierend op zijn
ezel zagen, keken zij met teeder medelijden naar Uilenspiegel en
dreigden zij Lamme met de vuist, zeggende:

--Dáár is de deugniet, die zijn vriend schier vermoordde.

Lamme, ongerust, keek of hij onder haar zijn vrouwtje niet vond.

Hij zocht te vergeefs, wat hem in een weemoedige stemming bracht.




XXIII.

--Waar gaan wij henen? vroeg Lamme.

--Naar Maastricht, antwoordde Uilenspiegel.

--Maar, mijn zoon, men zegt dat het leger des hertogen rond Maastricht
samengebracht is en dat Alva zelf in die stede verblijft. Onze
reispassen zullen niet voldoende zijn. En al hadden de Spaansche
soldeniers er mede genoegen, wij zouden niettemin in de stad gehouden
en ondervraagd worden. Ondertusschen zouden zij den moord van de
predikanten vernemen en zouden wij aan het leven vaarwel mogen zeggen.

Uilenspiegel antwoordde:

--De raven, uilen en gieren zullen al het vleesch aftrekken, zoodat
hun aangezicht onkennelijk zal geworden zijn. Wat onze passen betreft,
die zouden wel goed zijn; maar als men den moord vernam, zouden wij
gewis, zooals gij zegt, aangehouden worden. Daar wij te Maastricht
wezen moeten, zullen wij over Landen trekken.

--Ze zullen ons ophangen, zei Lamme.

--We zullen er wel door geraken, antwoordde Uilenspiegel.

Aldus koutend kwamen zij in de afspanning de Ekster, waar zij goed
eten, goede slaping en hooi voor hunne ezelen vonden.

's Anderen daags begaven zij zich op weg naar Landen.

Toen zij omtrent een groote hoeve, nabij de stad kwamen, floot
Uilenspiegel als de Leeuwerik, en dadelijk antwoordde daarop, van
binnen, een helder hanengekraai. Een cijnzenaar met een goedig gezicht
verscheen op den drempel der hoeve. Hij riep hun toe:

--Vrienden, leve de Geus! komt binnen.

--Wie is dat? vroeg Lamme.

Uilenspiegel antwoordde:

--Thomas Utenhove, de dappere hervormde; de knechts en dienstmaagden
zijner hoeve ijveren als hij voor het vrije geweten.

Utenhove sprak toen:

--Gij zijt zendelingen des prinsen. Eet en drinkt.

En de hesp siste in de pan en de worsten insgelijks; en de wijn werd
opgebracht en de glazen gevuld. En Lamme dronk als een tempelier en
liet zich de spijzen goed smaken.

De knechts en meiden van de hoeve kwamen beurtelings voor de
halfgeopende deur kijken, om hem met de tanden te zien werken. En de
mannen zeiden, begeerig, dat zij wel zooveel zouden eten als hij.

Op het einde van den maaltijd, sprak Thomas Utenhove:

--Honderd boeren zullen deze week van hier vertrekken; zij zeggen
dat zij aan de dijken van Brugge en omstreken gaan werken. Zij reizen
bij troepen van vijf of zes, en langs verschillende wegen. Te Brugge
zullen zij schuiten vinden, die hen over zee naar Emden zullen brengen.

--Hebben zij wapenen en geld? vroeg Uilenspiegel.

--Elkeen heeft tien gulden en een hertsvanger, antwoordde Utenhove.

--God en de prins zullen U loonen!

--Ik behoef geene belooning; wat ik doe, doe ik uit overtuiging,
zeide Utenhove.

--Vriend gastheer, vroeg Lamme, die dikke zwarte pensen aan 't peuzelen
was, hoe krijgt gij ze zoo geurig, zoo smakelijk en zoo fijn van vet?

--Wij doen er kaneel en kattenkruid in, antwoordde de gastheer.

Vervolgens vroeg hij aan Uilenspiegel:

--Hoort Edzard, grave van Friesland, nog steeds tot den aanhang
des prinsen?

Uilenspiegel antwoordde:

--Openlijk niet, maar toch verleent hij te Emden schuilplaats aan
zijne vaartuigen.

En hij voegde er bij:

--Wij moeten naar Maastricht.

--Dat zult gij niet kunnen, sprak de gastheer; het leger des hertogen
is vóór de stad en in 't ronde.

Vervolgens bracht hij hem naar den zolder; daar toonde hij hem van
verre de vendels en kornetten ruiterij en voetvolk, die door het veld
reden en marcheerden.

Uilenspiegel sprak:

--Ik geraak er wel door, zoo gij, die hier machtig zijt, mij de
toelating geeft tot trouwen. De vrouw moet lieftallig, zachtaardig
en schoon zijn en moet, zoo niet voor altijd, dan toch voor eene week
met mij willen trouwen.

Lamme zuchtte en sprak:

--Doe dat niet, mijn vriend, zij zou u alleen laten, zonder kommer
voor uw liefdevuur. Uw bed, waarop gij thans zoo vredevol slaapt, zal
eene koets van netelen worden, waaruit de zoete nachtrust vlieden zal.

--Ik trouw, antwoordde Uilenspiegel.

En Lamme was diep bedroefd, omdat hij niets op de tafel meer vond. Maar
hij ontdekte krakelingen in eene schaal, en hij speelde ze weemoedig
binnen.

Uilenspiegel zei tot Thomas Utenhove:

--Nu, luister. Bezorg mij eene vrouw, rijk of arm. Ik ga met heur
naar de kerk en doe het huwelijk inzegenen door den pastoor. Deze
geeft ons een huwelijksbewijs, hoewel ongeldig, daar het komt van een
aanhanger der Inquisitie; wij doen er in schrijven, dat wij goede
kerstenen zijn, die gebiecht hebben en ten avondmaal gegaan zijn,
dat wij apostolisch leven volgens de regelen Onzer Heilige Moeder de
Roomsche Kerk,--die heure kinderen verbrandt,--om aldus over ons den
zegen te roepen van Onzen Heiligen Vader den Paus, van de hemelsche
en aardsche heirscharen, van de santen, santinnen, dekenen, pastoors,
monniken, soldeniers, serjanten, hangmannen en andere diepers. Met
dat kostbare bewijs op zak, maken wij de toebereidselen voor de
gebruikelijke speelreis.

--Maar de vrouw? vroeg Thomas Utenhove.

Die zult gij mij zoeken, antwoordde Uilenspiegel. Ik neem dus twee
speelwagens, die ik versier met sparre- en hulstetakken en papieren
festoen. En ik laat er de mannen in stijgen, die gij den prins
zenden wilt.

--Maar de vrouw? vroeg Thomas Utenhove.

--Die zal niet ver van hier zijn, antwoordde Uilenspiegel.

En zijne rede vervolgend, sprak hij:

--Voor den eersten wagen span ik twee uwer peerden, voor den tweeden
onze beide ezelen. Den eersten wagen neem ik in met mijne vrouw,
mijn vriend Lamme, de getuigen; de tweede wagen is bestemd voor de
speellieden. Vervolgens trekken wij er op los, met wuivende vendels
en onder 't geschal van tamboerijnen, pijpen, schalmeien; zingend,
dansend en drinkend, rijden wij in vollen draf de groote baan op,
die naar het galgeveld of naar de vrijheid leidt!

--Ik wil u helpen, sprak Thomas Utenhove. Maar de vrouwlieden en
dochteren zullen heure mannen en minnaren willen volgen.

--Wij gaan mee op Gods genade, sprak een minzaam meideken, dat het
hoofd binnenstak.

--Als het noodig is, zei Thomas Utenhove, kunnen er vier wagens zijn;
aldus zouden wij meer dan vijf en twintig man aan den prins kunnen
sturen.

--De hertog zal het kind van de rekening zijn, sprak Uilenspiegel.

--En de vloot van den prins zal eenige dappere soldaten meer tellen,
antwoordde Thomas Utenhove.

Vervolgens deed hij het klokje luiden, om al zijne knechts en
dienstmaagden samen te roepen.

Toen allen vergaderd waren, sprak hij tot hen:

--Gij allen, die Zeeuwen zijt, mannen als vrouwlieden, luistert:
Uilenspiegel, de Vlaming, hier tegenwoordig, wil U in bruidsgewaad
door het leger des hertogen brengen.

De mannen en vrouwen van Zeeland riepen te gelijk:

--Doodsgevaar! wij zijn er bij!

En de mannen zeiden tot elkaar:

--Voor ons is het een geluk, een land van dienstbaarheid te verlaten
om de vrije zee te bevaren. Als God er vóór is, wie zal er tegen zijn?

De vrouwlieden en meidekens spraken:

--Wij volgen onze mannen en vrienden. Wij zijn uit Zeeland en zullen
er schuilplaatse vinden.

Uilenspiegel wendde zich tot een jong en liefelijk meideken uit den
troep, en zei schertsend:

--Met u wil ik trouwen.

Doch blozend antwoordde zij:

--Ik wil wel; doch alléén in de kerk.

De vrouwen spraken lachend tot elkaar:

--Heur hert trekt naar Hans, den zoon van den baas. Hij vertrekt
zeker met heur.

--Ja, antwoordde Hans.

En de vader zei tot hem:

--Gij moogt.

De mannen trokken hunne beste kleederen aan: fluweelen wambuis en
hooze, met het groot opperste kleed daarboven, en zetten breedgerande
hoeden op 't hoofd, die hen tegen zon en regen zouden beschutten; ook
de vrouwen kleedden zich in feestdos: gebekte zwarte onderbroeken,
geplooide witte halskragen, hemelsblauwe en scharlakenroode
borststukken met goudborduurselen, zwarte wollen rokken met breede
fluweelen banden van dezelfde kleur, zwarte saaien kousen en fluweelen
schoenen met zilveren gespen; op het voorhoofd hadden zij groote
klatermeersen, die de meidekens links en de getrouwde vrouwlieden
rechts droegen.

Vervolgens ging Thomas Utenhove naar de kerk, den pastoor verzoeken
Thijlbert, zoon van Klaas, in de wandeling Uilenspiegel geheeten,
dadelijk te willen trouwen met Tanneken Pieters. En meteen stak hij
den pastoor twee rijksdaalders in de hand: de parochiepaap stemde
gereedelijk toe.

Dienvolgens begaf Uilenspiegel zich naar de kerk met heel de bruiloft,
en daar trouwde hij, vóór den pastoor, met Tanneken, die zoo schoon
en zoo lief, zoo knap en zoo poezel was, dat hij zich moest inhouden
om niet in heure kaken te bijten, die op twee kriekappeltjes geleken.

En hij zeide heur dat hij het maar liet, uit eerbied voor heur lief
en zacht gezichtje. Maar schalksch zei ze:

--Wees toch stil, zie eens hoe Hans u beziet; hij zou u vermoorden!

En een meideken, dat jaloersch was, zei:

Zoek elders, Uilenspiegel, ziet gij niet dat zij bang is voor heuren
minnaar?

Lamme wreef in zijne handen en riep:

--Ge zult ze toch allen niet hebben!

En hij was in zijn schik.

Uilenspiegel droeg geduldig zijn lot en keerde met de bruiloft terug
naar de hoeve. Daar dronk men en zong men en deed hij bescheid met
het jaloersche meideken. Hans was er gansch in zijn schik om, maar
Tanneken niet, en de bruidegom van 't meideken evenmin.

Rond den middag, bij helderen zonneschijn en terwijl een frisch
windeken woei, reden de wagens voort; ze waren gansch versierd met
bloemen en loover, en met wapperende vendels. En ze vertrokken onder
't blijde geschal van pijpen, schalmeien, tamboerijnen en doedelzakken.

In 't kamp van Alva was 't een andere kermis. De posten en
schildwachten bliezen alarm en kwamen achtereenvolgens terug naar
het kamp, zeggende:

--De vijand nadert; wij hebben 't gerucht van pijpen en schalmeien
gehoord, en vendels gezien. 't Is een sterke afdeeling ruiterij die
ons zeker in een hinderlaag wil lokken. Het legerkorps is ongetwijfeld
in aantocht.

Dadelijk deed de hertog de kampmeesters, kolonels en hoplieden
verwittigen, het leger in slagorde stellen en den vijand verkennen.

Plotseling verschenen vier wagens, die op de busschutters toereden. In
de wagens waren de mannen en vrouwen aan 't dansen, bij 't blijde
gerinkel van bottels en glazen en 't luidruchtig geschal van pijpen,
schalmeien, trommelen en doedelzakken.

De bruiloft hield halt, en de hertog van Alva kwam zelf toegeloopen
op het gerucht en zag de jonge bruid op een van de wagens en, naast
heur, Uilenspiegel, heuren bruidegom, met zijn hoed vol bloemen; en
al de boeren en boerinnen waren van de wagens gesprongen en dansten
rond het jonge paar, en noodden de soldaten tot drinken.

Alva en de zijnen waren grootendeels verwonderd over den eenvoud
dier buitenlieden, die zongen en dansten, te midden van een leger,
dat in slagorde stond.

En allen, die in de wagens zaten, schonken wijn aan de Spaansche
soldaten.

En de Maranen zwaaiden met de hoeden en juichten hen toe.

Als de wijn op was, reden de boeren en boerinnen voort, onder 't
geschal van tamboerijnen, pijpen en doedelzakken. Niemand deed hun
de minste moeilijkheid aan.

Integendeel, de soldaten schoten een salvo met hunne bussen.

En zoo kwamen zij in Maastricht, waar Uilenspiegel zich verstond
met de hervormden om, door middel van schepen, een grooten voorraad
wapenen en munitie naar de vloot van den Zwijger te zenden.

Ook te Landen deden zij hetzelfde.

En, als daglooners gekleed, geraakten zij overal door.

De list kwam den hertog ter oore; en er werd een liedje op gemaakt,
dat hem gezonden werd, met dit refrein:


    Bloed-hertog, dwaas-hertog,
    Hebt ge de bruid gezien?


En telkens dat hij een verkeerde beweging gemaakt had, zongen de
soldaten:


    De hertog krijgt schele oogen,
    Hij heeft de bruid gezien.




XXIV.

Afgunst verteerde koning Philippus. In zijn hoogmoed bad hij jammerend
God, dat hij hem de macht zou geven Engeland te overwinnen, Frankrijk
te veroveren, Milaan, Genua en Venetië in te nemen en, meester der
zeeën, heel Europa te gebieden.

Hij dacht aan die zegepraal, maar hij lachte niet.

Gedurig was hij huiverig; de wijn verwarmde hem niet, noch het
vuur van het welriekend hout, dat altijd brandde in de zaal waar
hij verbleef. Daar zat hij te midden van zoovele brieven, dat men
er wel honderd tonnen mede had kunnen vullen; hij dacht aan de
alleen-heerschappij over gansch de aarde, zooals die uitgeoefend
werd door de Roomsche keizers, en aan den naijver en den haat die
hij zijnen zoon don Carlos toedroeg, sedert deze de plaats van den
hertog van Alva in de Nederlanden had willen innemen. En als hij hem
zag, mismaakt, zot en boosaardig, kwam er een nog grootere haat over
hem. Maar niemand sprak hij er over.

Zij, die den koning en zijnen zoon dienden, wisten niet wien zij
't meest moesten vreezen, óf den moordzieken kroonprins, die zijn
dienaren in 't gezicht krabde, òf den gluiperigen koning, die zich
van anderen bediende als hij iemand wilde treffen, en die als eene
hyena leefde van lijken.

De dienaren waren verschrikt als ze den een achter den anderen zagen
sluipen, en zeiden, dat men, in 't Escuriaal, weldra van dooden
zou hooren.

Weldra vernamen zij, dat don Carlos gevangen gezet was, wegens
hoogverraad. En zij wisten dat verdriet hem verteerde; dat hij door
de staven van zijn kerker had willen kruipen om te vluchten, en zich
aldus het aangezicht had gekwetst.

Ook wist men, dat mevrouwe Isabella van Frankrijk, zijne moeder,
gedurig weende.

Maar koning Philippus weende niet.

Ze kregen mare, dat men don Carlos versche vijgen gegeven had, en dat
hij 's anderen daags zoo zacht gestorven was alsof hij ingesluimerd
was.

De dokters zeiden: Zoodra hij de vijgen gegeten had, hield zijn hert
op met kloppen en werden de natuurlijke levensverrichtingen afgebroken;
zijn buik zwol op en zoo gaf hij den geest.

Koning Philippus woonde de uitvaart van don Carlos bij, deed hem
begraven in de kapel zijner koninklijke verblijfplaats en eenen steen
op zijn graf leggen, maar hij weende niet.

En spottend met het vorstelijk grafschrift, dat in dien steen was
gebeiteld, zeiden de dienaren tot elkander:


    HIER LIGT BEGRAVEN DEGENE DIE VERSCHE
    VIJGEN AT EN STIERF ZONDER ZIEK TE ZIJN.

    A qui jace qui en para desit verdad,
    Morio s'in infirmidad.


En koning Philippus bezag met ontuchtige blikken de prinses van
Eboli, die getrouwd was. Door drift verteerd, smeekte hij heur en
zij weerstond niet....

Mevrouwe Isabella van Frankrijk, die, naar men zeide, don Carlos'
inzichten op de Nederlanden begunstigd had, werd droef en mager. Heur
haar viel uit, met dikke lokken te gelijk. En dikwerf braakte zij,
en de nagelen heurer teenen en vingeren vielen uit. En zij stierf.

En koning Philippus weende niet.

Het haar van den prins van Eboli viel insgelijks uit. Hij werd droef
en klaagde gedurig. Dan vielen ook zijne nagelen van teenen en vingeren
uit. En hij stierf.

En de koning deed hem begraven.

En hij betaalde den rouw der weduwe, en weende niet.




XXV.

In dien tijd kwamen eenige vrouwlieden en meidekens van Damme vragen
aan Nele of zij meibruid wilde zijn en zich wilde verbergen in het
struikgewas, met den bruidegom dien men voor haar vinden zou; want,
zeiden de vrouwen, niet zonder afgunst, geen jongeling van Damme en
't ronde zou u versmaden; allen zouden willen trouwen met u, die
zoo schoon en zoo braaf, zoo jong en zoo frisch blijft: gave van
toovernij, gewis.

Nele antwoordde:

--Zegt tot de jongelieden, die mij tot huisvrouw zouden begeeren,
dat Nele's hert niet hier is, maar verre, bij hem die ronddoolt om den
grond der vaderen te verlossen. En zoo ik frisch blijf, lijk gij zegt,
is dit geene gave van tooverij, maar van gezondheid.

De vrouwen antwoordden:

--Katelijne nochtans wordt verdacht.

--Hecht geen geloof aan de woorden der boozen, antwoordde
Nele. Katelijne is geene tooveres. De heeren der vierschaar hebben werk
op heur hoofd verbrand, en God heeft heur met uitzinnigheid geslagen.

En Katelijne, die in een hoek op de hurken zat, schuddebolde en sprak:

--Doe het vuur uit, hij zal terugkomen, Hansken, mijn liefste.

De vrouwen vroegen wie het Hansken was, waarvan Katelijne sprak.

Nele antwoordde:

--De zoon van Klaas, mijn zoogbroeder, dien zij waant verloren te
hebben, sedert God heur zoo wreedelijk trof.

En de goede vrouwlieden gaven zilveren oortjes aan Katelijne.

En de nieuwe geldstukken die er bij waren, toonde zij eenen, dien
niemand zag, zeggende:

--Ik ben rijk, ik heb blinkend geld. Kom, Hansken, mijn liefste;
ik zal uwe koozerijen betalen.

En als de vrouwen henen waren, weende Nele in de eenzame hut. En ze
dacht aan Uilenspiegel, die in verre landen doolde en dien ze niet
volgen mocht, en ook aan Katelijne, die steende:--Doe het vuur uit! en
de beide handen op heure borst drukte, om te bedieden, dat het vuur
der uitzinnigheid brandde in heur hoofd en heur lijf.

En intusschen verborgen meibruid en meibruidegom zich in het hooge
gras.

De jongen, die de meibruid vond, was de koning van 't feest; was het
integendeel een meisje dat den bruidegom vond, dan was zij de koningin
van het meifeest.

Nele hoorde van verre de vreugdekreten van knapen en meidekens, toen de
meibruid aan den boord eener gracht, in het hooge gras, werd gevonden.

En zij weende als zij dacht aan den zoeten tijd, toen men heur en
heuren vriend Uilenspiegel zocht.




XXVI.

En Uilenspiegel en Lamme, schrijlings op hunne ezels gezeten,
vervolgden hunnen weg.

--Nu, Lamme, luister goed, sprak Uilenspiegel, de Nederlandsche edelen,
naijverig op den prins van Oranje, verrieden de zaak der eedgenooten,
het heilig verbond, het kloekmoedig eedverbond, dat geteekend was
voor het welzijn van den grond onzer vaderen. Egmond en Hoorne waren
ontrouw, doch zij vonden er niet het minste voordeel bij, integendeel;
Brederode is dood; in dezen oorlog blijven ons niets anders over dan
het arme volk van Brabant en Vlaanderen, dat op eerlijke hoofdmannen
wacht om op te rukken; en vervolgens, mijn jongen, de eilanden van
Zeeland en Noord-Holland, waarvan de prins stadhouder is; en verder
nog, op zee, Edzard, graaf van Emden en van Oost-Friesland.

--Laas! sprak Lamme, ik word het wel gewaar: wij dwalen rond tusschen
rad, galg en brandstapel, stervend van honger, stikkend van dorst,
zonder hoop ergens ruste te vinden.

--'t Is maar een begin, antwoordde Uilenspiegel. Ge moet toch bekennen,
dat ons bestaan heel vroolijk is: wij dooden onze vijanden; wij
spotten met hen, hebben onze tasschen vol florijnen en daalders; wij
zijn goed gevoed met vleesch, met brood en met wijn. Wat wilt gij nog
meer, pluimzak? Willen wij onze ezels verkoopen om peerden te koopen?

--Thijl, zeide Lamme, de draf van een peerd is tamelijk hard voor
een man, zoo vollijvig als ik.

--Gij kunt u te peerd zetten lijk de boeren, antwoordde Uilenspiegel,
en niemand zal u uitlachen, mits gij gekleed zijt als een boer en
geen zweerd draagt lijk ik, doch enkel eenen verkensspriet.

--Maar, vroeg Lamme, zijt gij wel zeker, dat onze passen kunnen dienen
in de kleine steden?

--Heb ik geen bewijs van den parochiepaap, sprak Uilenspiegel, met
een groot lakzegel van de kerk, dat er aanhangt met twee perkamenten
steerten; hebben wij ook onze biechtbriefkens niet? De huurlingen en
serjanten des hertogen vermogen niets tegen twee mannen, van zulke
goede papieren voorzien.

Lamme antwoordde niet.

--En de zwarte paternosters die wij verkoopen? vervolgde
Uilenspiegel. Wij beiden zijn ruiters, gij Vlaming, ik Duitscher,
wij reizen op uitdrukkelijk bevel van den hertog, om de ketters
dezer landen tot het heilig katholiek geloove terug te brengen,
door het verkoopen van gewijde voorwerpen. Aldus zullen wij overal
binnendringen, bij de groote heeren en in de rijke abdijen. En daar
zullen wij rijkelijk onthaald worden. En wij zullen hunne geheimen
ontstelen. Verblijd u van te voren, mijn zachtaardige vriend.

--Jongen, sprak Lamme, wat wij doen is werk van spionnen.

--Krachtens recht en oorlogswet, antwoordde Uilenspiegel.

--Als zij de zaak der drie predikanten vernemen, worden wij
geradbraakt, zei Lamme.

Uilenspiegel zong:


    Leven steekt op mijn Vaandel uit,
    Leven in 't licht der rede.
    Lederen is mijn eerste huid,
    Stalen is mijn tweede.


Doch Lamme zuchtte:

--Ik, ik heb maar één vel, en het is zeer zacht; bij den minsten
daggeslag zou het seffens open liggen. Wij zouden beter doen ons
aan een of ander nuttig ambacht over te leveren, dan aldus van het
een oord naar 't ander te dolen, om al die groote prinsen te dienen,
die, met de voeten in fluweelen muilen, rustig, aan vergulde tafelen,
ortolanen eten. Voor ons de slagen, de gevaren, het gevecht, de regen,
de hagel, de sneeuwstormen en de magere soep van de zwervers; voor
hen, de heerlijke worsten, de vette kapoenen, de geurige lijsters,
de smakelijke ganzen.

--Het water komt in uwen mond, mijn zachtaardige vriend, sprak
Uilenspiegel.

--Waar zijt gij, nieuwbakken brood, geurige koekebakken, heerlijke
rijstpap? En gij, waar zijt gij, mijn vrouwtje?

Uilenspiegel antwoordde:

--De assche van Klaas klopt op mijn hert en drijft mij ten
strijde. Maar gij, zachtmoedige Lamme, die den dood van uwen vader
noch uwe moeder moet wreken, noch het verdriet van hen die gij bemint,
nog uw huidige armoede, laat mij alleen gaan, daar waar de plicht
mij roept, zoo de vermoeienissen des oorlogs u afschrikken.

--Alleen? sprak Lamme.

En hij hield zijn ezel in, die dezen stilstand ten nutte maakte om
zich deugd te doen aan de distelen, waarmede de weg vol stond, zoo
ver het oog reikte. Uilenspiegel's grauwtje bleef insgelijks staan
en nam deel aan 't ezelsfestijn.

--Alleen? sprak Lamme. Dát zult gij niet doen; mij alleen laten
ware een groote wreedheid. Alreeds mijne vrouw kwijt, en vervolgens
mijn vriend, dat ware te veel. Ik zal nooit meer klagen, ik beloof
het u. En, als het nu toch moet zijn,--en hij hief kloekmoedig het
hoofd op,--zal ik gaan onder den kogelregen, ja! En in 't midden
der zweerden, ja! vlak in 't gezicht van die leelijke huurlingen,
die bloed zuipen lijk wolven. En mocht ik eens doodelijk getroffen
aan uwe voeten neervallen, begraaf mij dan, mijn vriend Uilenspiegel,
en ziet gij later mijne vrouw weer, zeg heur dat ik gestorven ben,
omdat ik niet leven kon zonder door iemand bemind te wezen.... Neen,
dat zou ik niet kunnen, mijn vriend.

En Lamme weende, en Uilenspiegel voelde een krop in de keel.




XXVII.

In dien tijd verdeelde de hertog zijn leger in twee afdeelingen:
het eerste korps zond hij naar het hertogdom Luxemburg, het ander
naar het markgraafschap Namen.

--Dat is eene krijgsbeweging waarvan ik de reden niet gis, sprak
Uilenspiegel, maar 't is mij eender, laat ons vol vertrouwen naar
Maastricht gaan.

Toen zij omtrent de stede langsheen de Maas reden, zag Lamme dat
Uilenspiegel aandachtig al de booten bezag, die op den stroom vaarden,
en dat hij eindelijk bleef staan voor eene, met een gebeeldhouwde
meermin op den achtersteven. En die meermin hield een schild vast,
waarop, met gouden letteren op een zwart veld, het teeken I-H-S stond,
het teeken dat Onzen Heer Jezus-Christus bediedt.

Uilenspiegel deed teeken tot Lamme om stil te staan, en hij begon
blijgemoed te fluiten als de leeuwerik.

Op de boot kwam een man voor, die kraaide als een haan, vervolgens,
toen Uilenspiegel balkte als een ezel en naar het volk wees dat
op de kaai bijeengehoopt stond, insgelijks verschrikkelijk begon
te balken. Op dat geluid spitsten de beide ezelen van Lamme en
Uilenspiegel de ooren en vergezelden zij 't refrein in hunne
moedertaal.

Vrouwlieden trokken voorbij en ook mannen die met jaagpeerden opgingen,
en Uilenspiegel zei tot Lamme.

--Die schipper spot met ons en met onze ezelen. Als wij hem eens eene
rammeling gaven op zijne boot? Wat dunkt u er van?

--Dat hij liever hier kome, zoo hij durft, antwoordde Lamme.

Toen sprak eene vrouw:

--Als gij niet wilt voortgaan met uwe armen af, uwe ribben gebroken,
uwen snoet aan stukken, laat Sterke Pier dan maar balken zooveel het
hem lust.

--Hi han! hi han! hi han! balkte de schipper.

--Laat hem maar roepen, zei de vrouw, verleden week zagen wij hem
eene kar, beladen met zware tonnen bier, op de schouderen nemen,
en een andere kar inhouden, waarvoor een sterk Vlaamsch peerd was
gespannen. Dáár, sprak zij, naar eene afspanning wijzend, daar in
den Blauwen Toren, smeet hij, op twintig stappen afstand, zijn mes
door een eiken berd van twaalf duim dik.

--Hi han! hi han! ging de schipper voort, terwijl een jongetje
van twaalf jaar op het dek van het schip klom en insgelijks begon
te balken.

Uilenspiegel antwoordde:

--Uw Sterke Pier kan ons weinig schelen! Hij mag zoo sterk zijn als
hij wil, wij zijn sterker dan hij, en mijn vriend Lamme hier, zou er
twee van zijne dikte binnenspelen, zonder hikken of blazen.

--Wat zegt gij, mijn jongen? vroeg Lamme.

--De waarheid, antwoordde Uilenspiegel, gij moet niet loochenen
uit zedigheid.

En tot de vergaderde menigte vervolgde hij:

--Ja, goede mannen, vrouwen en arbeiders, straks zult gij hem zien
te werk gaan met de vuisten en dien fameuzen Sterken Pier met zijnen
neus in het stof duwen.

--Zwijg toch, zei Lamme.

--Uwe kracht is gekend, antwoordde Uilenspiegel, gij moet niet
loochenen.

--Hi han! riep de schipper.

--Hi han! kefte het jongetje.

Plotseling floot Uilenspiegel opnieuw, welluidend als een kweelende
leeuwerik.

En de verrukte mannen, vrouwen en arbeiders vroegen hem waar hij dat
goddelijk vogelgezang had geleerd.

--In het hemelrijk, van waar ik kom, antwoordde Uilenspiegel.

Vervolgens sprak hij tot den schipper, die niet ophield met balken
en spottend met de vingeren naar hem te wijzen:

--Waarom blijft gij daar op uwe boot, nietdeug? Durft gij aan wal
komen om met ons en onze ezels te spotten?

--Ja, durft gij? vroeg Lamme.

--Hi han! hi han! hi han! ging de schipper maar voort. Heeren
langooren, ik noodig u op mijne boot.

--Doe maar altijd lijk ik, zei Uilenspiegel stille tot Lamme. En den
schipper riep hij toe:

--Zijt gij Sterke Pier, ik, ik ben Thijl Uilenspiegel. En onze
ezelen, Jef en Jan, kunnen beter balken dan gij, want balken is hunne
moedertaal. Maar op uwe slecht gevoegde berden komen, daarvoor zullen
wij ons wachten. Uwe boot lijkt niet slecht op eene kuip; als een
golfslag haar voortstoot, wijkt zij weer achteruit, en zij kan maar
vooruit lijk de krabben, zijwaarts.

--Ja, lijk de krabben! riep Lamme achterna.

Toen sprak de schipper tot Lamme:

--Wat mompelt gij daar onverstaanbaar tusschen uwe tanden, spekblok?

Lamme, die kwaad werd, riep:

--Slechte christen, die mij mijn gebrek verwijt, weet dat mijn vet
mijn eigendom is en van voedzame spijzen voortkomt, terwijl gij,
oude, roestige nagel, van niets anders leeft dan van uitgemergelde
haringen, van keerswieken, van stokvischvellen, te oordeelen naar uw
magere beenen, die door uw gescheurde hooze steken.

--Die gaan malkander in 't haar vliegen, zeiden de omstanders, vol
ongeduldig genoegen.

--Hi han! hi han! riep de schipper.

Lamme wilde van zijnen ezel stijgen, om steenen op te rapen en naar
den schipper te werpen.

--Met geen steenen smijten, zeide Uilenspiegel.

De schipper zeide iets in 't oor van het jongetje, dat naast hem op
de boot aan 't hihannen was.

Het knaapje maakte een schuitje los, dat aan de boot vastgemeerd
was en bereikte den oever, door middel van eenen haak, dien hij zeer
behendig hanteerde.

Toen hij dicht bij den wal was, riep hij, fier met het hoofd omhoog:

--De komplimenten van mijnen baas en hij vraagt of gij op zijne boot
durft komen om tegen hem te vechten met vuisten en voeten. Die mannen
en vrouwlieden zullen getuigen zijn.

--Zeker, durven wij, zeide Uilenspiegel op waardige wijze.

--Wij nemen het gevecht aan, zeide op zijne beurt Lamme, op
hoogmoedigen toon.

Het was om den middag; de handwerkslieden, dijkwerkers, kasseiers,
scheepmakers, de vrouwen met het middageten van heure mannen, de
kinderen die op hunne vaders stonden te zien, dewelke boonen aten met
gekookt vleesch, allen lachten, klapten in de handen bij de gedachte
aan een nakend gevecht en hoopten, met onverholen blijdschap, dat een
der strijders zijn kop zou ingeslagen worden, of deerlijk gehavend
in de vaart zou vliegen, tot groot genoegen van elkeen.

--Mijn jongen, zei Lamme, die minder strijdlustig werd, hij gaat ons in
't water smijten.

--Wel, laat er u in smijten, sprak Uilenspiegel.

--De dikzak wordt benauwd, zei de menigte werklieden en vrouwen
en kinderen.

Lamme, altijd op zijnen ezel gezeten, keerde zich naar hen toe en
bekeek ze grammoedig, maar zij jouwden hem uit.

--Laat ons op de boot gaan, zei Lamme tot Uilenspiegel, zij zullen
eens zien of ik benauwd ben!

Op die woorden werd hij opnieuw uitgejouwd en Uilenspiegel sprak:

--Laat ons op de boot gaan.

Toen zij van hunne ezels gestegen waren, wierpen zij de teugels naar
het jongetje, hetwelk de grauwtjes vriendelijk streelde en naar eene
plaats leidde, waar distelen groeiden.

Vervolgens nam Uilenspiegel een riem, deed Lamme in het schuitje plaats
nemen, wrikte naar de boot, en klom er op door middel eener koord.

Lamme, zweetend en blazend, volgde hem en klaverde achter hem op
de boot.

Toen Uilenspiegel op het dek van de bark stond, boog hij zich voorover,
alsof hij zijne schoenen wilde toerijgen, en zeide hij eenige woorden
tot den schipper, die glimlachte en pinkoogde, terwijl hij naar
Lamme keek.

Vervolgens zond hij hem allerlei scheldwoorden naar het hoofd, hiet
hem deugniet, galgenaas, gevangenisgebroed, papeter, vetbol, en zei:

--Dikke walvisch, hoeveel tonnen traan levert gij wel, als men u
eenen steek in den buik geeft?

Lamme antwoordde niet, doch vloog eensklaps naar hem als een razende
stier, wierp hem ten gronde en sloeg op hem uit al zijne macht, doch
hij deed hem niet veel zeer, omdat er niet veel kracht in zijne vette
armen stak.

De schipper gebaarde dat hij zich verweerde, doch liet hem begaan en
Uilenspiegel zei op snoevenden toon:

--Die nietdeug kan maar zien, dat hij ons te drinken betaalt.

De mannen, vrouwlieden, arbeiders, die van den oever het gevecht
nagingen, zeiden:

--Wie had gedacht dat die dikzak zooveel kracht had?

En zij klapten in de handen, terwijl Lamme sloeg gelijk de duivel op
Geeraard. Maar de schipper nam geen andere voorzorg dan zijn aangezicht
te beschutten.

Eensklaps zag men Lamme, met zijne knie op de borst van Sterken Pier,
met eene hand hem bij de keel houdend en met de andere omhoog, gereed
om te slaan.

--Vraag om genade, schreeuwde hij razend, of ik stoot u dwars door
de berden uwer modderschuit.

De schipper kuchte, om te bedieden, dat hij niet kon spreken, en deed
teeken met de hand dat hij om genade vroeg.

Lamme hielp grootmoedig zijnen vijand opstaan en, met den rug naar
de toeschouwers, stak hij zijne tong uit naar Uilenspiegel, die in
een schaterlach uitberstte, toen hij Lamme, met het hoofd omhoog,
triomfantelijk met groote stappen op de boot zag over en weer loopen.

En de mannen, vrouwlieden, knapen en meidekens, die op den oever
stonden, juichten toe om het meest en riepen:

--Leve de overwinnaar van Sterken Pier! 't Is een ijzeren man!

En tot elkander zeiden zij:

--Hebt gij hem zien slaan met de vuist? Ja, en met een stoot met het
hoofd smeet hij den andere ten gronde. Nu gaan zij drinken om pais
te maken. Sterke Pier komt boven met wijn en met worsten.

Inderdaad, Sterke Pier was twee kroezen en een groote pint witten
wijn van de Maas gaan halen. En Lamme en hij gaven elkander de hand
tot teeken van vrede.

En Lamme, die als in den hemel was, ter wille van zijne zegepraal en
ook om den wijn en de worsten, vroeg hem, wijzend naar een groote
schouw waaruit een zwarte, dikke rook opsteeg, wat voor stoverije
hij maakte in het ruim.

--'t Is oorlogskeuken, antwoordde Sterke Pier met een glimlach.

De menigte werklieden, vrouwen en kinderen was uiteengegaan om
zich naar den arbeid of naar huis te begeven, en van mond tot mond
verspreidde zich het gerucht dat een dik man, op eenen ezel gezeten
en vergezeld van een kleinen pelgrim, sterker dan Samson was en dat
men zich wachten moest hem scheef te bezien.

Lamme at en dronk, en bezag zegevierend den schipper.

Deze zeide eensklaps:

--Uwe ezelen vervelen zich ginder.

Daarop bracht hij de boot tegen de kaai, ging aan wal, nam een der
ezelen bij de voorpooten en de achterpooten en, het dier dragende
gelijk het kindeken Jezus het lammeken droeg, zette hij het neer op
het dek van de boot.

Vervolgens deed hij, zonder hijgen, hetzelfde met den anderen ezel,
waarna hij zeide:

--Laat ons drinken!

Het jongetje sprong op het dek.

En zij dronken.

Lamme stond verstomd; hij wist niet goed of hij het wel was, geboortig
uit Damme, welke dien sterken, gespierden man afgerost had, en dorst
hem nog slechts ter sluips bezien en zonder den minsten hoogmoed,
want hij vreesde dat de schipper lust kreeg hem op te pakken gelijk
hij de ezelen opgenomen had, en hem levend in de Maas te smijten,
uit weerwraak.

Maar glimlachend noodde de schipper hem nogmaals tot drinken, en Lamme
herstelde zich van zijne vrees en bezag hem opnieuw met zegevierend
zelfvertrouwen.

En de schipper en Uilenspiegel bekeken elkander en schoten in een
luiden schaterlach.

Intusschen hadden de ezelen, verwonderd zich op een plankenvloer
te gevoelen (iets aan hetwelk zij geenszins gewend waren) den kop
gebogen en de ooren gestreken; zij dorsten niet drinken van schrik.

De schipper ging een van de maatjes haver halen, welke hij gaf aan
de peerden die zijne boot voorttrokken, want hij kocht zijne haver
zelf, om door de voerlieden niet bestolen te worden op den prijs van
het voeder.

Toen de ezelen het maatje haver zagen, prevelden zij binnensmonds
paternosters van vraatzucht, terwijl zij weemoedig den vloer van de
boot bekeken, want uit vreeze van uit te glijden, dorsten zij geen
stap verzetten.

Daarop zei de schipper tot Uilenspiegel en tot zijnen vriend Lamme
Goedzak:

--Laat ons naar de keuken gaan.

--'t Is oorlogskeuken, zei Lamme ongerust.

--Ja, 't is oorlogskeuken, maar zonder vrees moogt gij beneden komen,
mijn overwinnaar.

--Ik ben niet bevreesd, sprak Lamme, en ten blijke daarvan zal ik
u volgen.

Het jongetje ging naar het roer.

Toen zij beneden kwamen, zagen zij overal zakken graan, boonen,
erwten, kool, wortelen en andere groenten.

De schipper opende de deur eener smidse en zei:

--Vermits gij mannen zijt met kloekmoedig hert, die het gezang kent
van den leeuwerik, die het zinnebeeld der vrijheid is, en het dappere
gekraai van den haan, en 't gebalk van den ezel, dien zachtmoedigen
werker, wil ik u mijne oorlogskeuken toonen. Deze kleine smidse vindt
men in de meeste booten, die op de Maas varen. Ze kan niet verdacht
voorkomen, want zij dient om het ijzerwerk aan boord te herstellen;
doch alle schepen hebben den schoonen voorraad niet, die steekt in
deze kasten.

Toen schoof hij eenige steenen weg, die het onderste scheepsruim
bedekten; hij hief eenige planken op en haalde er een dikken bundel
geweerloopen uit, stak dien omhoog als een pluimken en legde hem toen
weder op zijne plaats.

Vervolgens toonde hij hun lanspunten, hellebaardijzers, zweerdklingen,
zakjes kogels en kruit.

--Leve de geus! sprak hij, hier zijn de boonen en de saus; de kolven
zijn de bouten, de hellebaardijzers zijn de salade, en die geweerloopen
de osseschinkels voor de vrijheidssoep!

... Leve de Geus! Waar moet ik al die spijzen brengen? vroeg hij
aan Uilenspiegel.

Deze antwoordde:

--Naar Nijmegen, waar gij zult binnenvaren met uwe boot nog zwaarder
beladen met echte groenten, die de boeren u brengen te Elsen,
te Stevensweert en te Roermond. En die ook zullen zingen lijk de
leeuwerik, zinnebeeld der vrije mannen, en gij zult ook antwoorden met
een dapper hanengekraai. Gij zult bij dokter Pontus gaan, die omtrent
de Nieuwe Waal woont, hem zeggen, dat gij in de stad komt met groenten,
doch dat gij droogte vreest. Terwijl de boeren met de groenten naar de
markt gaan en ze zoo duur zullen te koop stellen dat niemand ze koopen
wil, zal dokter Pontus u zeggen wat gij met uwe lading wapenen doen
moet. Maar ik denk dat hij u eene zending zal opleggen die niet zonder
gevaar is, en u bevelen de Waal, de Maas of den Rijn af te varen, uwe
groenten te ruilen tegen netten en naar de visschersschuiten te gaan
te Harlingen, alwaar vele matrozen het gezang des leeuweriks kennen,
vervolgens door de wadden, langsheen de kust, naar de Lauwerzee
te varen, de netten te ruilen tegen ijzer en lood, aan uwe boeren
kleederen te geven naar de dracht van de eilanden Marken, Vlieland
of Ameland, een weinig van de kust af te blijven, te visschen en uwe
vangst in te zouten, niet om ze te verkoopen, doch om ze te bewaren,
want zout eten en een goeden pot drinken is geoorloofd in oorlogstijd.

--Als het zoo is, sprak de schipper, laat ons drinken!

En zij gingen terug naar het dek.

Doch Lamme was vol weemoed.

--Mijnheer de schipper, sprak hij, gij hebt daar in uwe smidse een zoo
blakerend vuurtje, dat men daar voorzeker den smakelijksten hutsepot
zou koken, dien men droomen kan. Mijn keelgat smeekt luide om soep.

--Ik zal u ververschen, sprak de man.

En weldra bracht hij een vette soep op, waarin een dikke snee gezouten
hesp was gekookt.

Als Lamme eenige lepelen gegeten had, wendde hij zich naar den schipper
en sprak:

--Mijne keel is verschroeid, mijne tong brandt af; dat is geen
hutsepot dàt.

--Zout eten en dapper drinken is geoorloofd in oorlogstijd, zoo staat
er geschreven, antwoordde Uilenspiegel.

De schipper vulde de bekers en sprak:

--Ik drink op den leeuwerik, het zinnebeeld der vrijheid!

Uilenspiegel sprak:

--Ik drink op den haan, die oorlog kraait!

Lamme sprak:

--Ik drink op de gezondheid mijner vrouw; mocht dorst de welbeminde
nooit kwellen!

--Gij gaat langs de Noordzee naar Emden, zei Uilenspiegel tot den
schipper. Emden is eene schuilplaats voor ons.

--De zee is groot, sprak de schipper.

--Groot voor 't gevecht, antwoordde Uilenspiegel.

--God is met ons, zei de schipper.

--Wie dan kan tegen ons zijn? hernam Uilenspiegel.

--Wanneer vertrekt gij? vroeg Sterke Pier.

--Dadelijk, antwoordde Uilenspiegel.

--Goede reis en den wind van achteren. Neem dit kruit en deze kogelen.

De schipper gaf hun den afscheidskus en deed hun uitgeleide, nadat hij
de beide ezelen als lammekens op zijne schouders aan wal had gebracht.

Lamme en Uilenspiegel stegen op hunne grauwtjes en begaven zich op weg.

Zij reden naar Luik.

--Mijn jongen, vroeg Lamme onderwege aan Uilenspiegel, hoe is het
mogelijk, dat een zoo sterke gespierde kerel zich zoo wreedelijk liet
afrossen door iemand lijk ik?

--Dit deed hij, antwoordde Uilenspiegel, opdat de vreeze u zou
voorafgaan in alle oorden, waarheen wij ons zullen begeven. Dat is
een veiliger geleide dan twintig landsknechten te zamen. Wie dan zou
voortaan nog een minachtend woord durven richten tot Lamme den sterke,
tot den zegevierenden Lamme; tot Lamme den stier, die zijn gelijken
niet heeft, die, onder eens iegelijks oogen, met eenen stoot met
den kop, Sterken Pier nedervelde, Sterken Pier, die ezelen op zijne
schouderen draagt alsof het lammekens waren en geheele bierwagens
opheft? Iedereen kent u hier reeds. Gij zijt de geduchte Lamme,
de onoverwinbare Lamme, en in de schaduw uwer bescherming, rijd ik
onbevreesd door. Op den weg, dien wij zullen volgen, zal iedereen
u kennen, niemand zal zich durven vermeten u scheef te bezien en,
gezien de lafheid der mannen, zult gij nergens op uwen weg iets
anders aantreffen dan nederige buigingen, groeten, loftuitingen en de
algemeene achting, ter eere van de spierkracht uwer geduchte vuisten.

--Gij spreekt goed, mijn jongen, zeide Lamme, die zich stijf in den
zadel hield.

--En ik spreek waarheid, ging Uilenspiegel voort. Ziet gij die
nieuwsgierige gezichten aan de eerste huizen van het dorp? Men toont
elkander Lamme, den schrikverwekkenden overwinnaar. Ziet gij die
mannen u bekijken met afgunst, en die lafhertige weekelingen hunne
muts afnemen voor u? Beantwoord hunne groeten, Lamme; veracht nooit
het zwak van het volk. Zie, de kinderen kennen uwen naam en herhalen
hem met schrik en met eerbied.

En Lamme reed fier voorbij, groette rechts, groette links, als een
koning. En de mare zijner dapperheid ging hem vooraf van dorp tot dorp,
van stad tot stad, tot Luik, Chokier, la Neuville, Vezin en Namen,
welke stad zij lieten liggen, ter oorzake van de drie predikanten.

En aldus reden zij langen tijd voort, langs rivieren, stroomen en
vaarten. En overal werd het gezang van den leeuwerik beantwoord door
't gekraai van den haan.

En overal werden, voor 't werk van de vrijheid, wapenen gegoten,
gesmeed, geslepen, en vervolgens verscheept.

En in tonnen, in kisten, in manden, geraakten zij door, aan de tollen.

En overal werden goede lieden gevonden, die ze wilden aanveerden en
in verzekerde plaatsen bergen, met het kruit en de kogels, totdat
Gods ure zou slaan.

En Lamme reed steeds voort met Uilenspiegel, altijd voorafgegaan
door zijnen roem van onoverwinbaren vuistvechter, tot dusverre dat
hij zelf aan zijn groote kracht begon te gelooven en, hoogmoedig en
strijdlustig geworden, zijnen baard liet groeien.

En Uilenspiegel noemde hem: Lamme de Leeuw.

Doch Lamme bleef niet standvastig in zijn voornemen, want den vierden
dag begon zijn baard hem onuitstaanbaar te steken.

En hij liet het scheermes over zijn zegevierend gezicht strijken, dat
nu weder te voorschijn kwam als de volle maan, met een rooden blos,
gestoofd door het lekkere eten.

Aldus kwamen zij te Stokhem.




XXVIII.

Te Stokhem lieten zij hunne ezelen op stal, en begaven zij zich te
voet naar Antwerpen, welke stede zij bij 't vallen van den avond
binnentrokken.

En Uilenspiegel zeide tot Lamme:

--Hier is de groote stad, de gansche wereld stapelt hier hare
rijkdommen: goud, zilver, specerijen, goudleder, kostelijke tapijten,
lakens, fluweelen, tieretijnen, wollen en zijden stoffen; boonen,
erwten, granen, vleesch en meel, gezouten huiden; wijn van Leuven, van
Namen, van Luxemburg, van Luik, landwijn van Brussel en van Aarschot,
wijn van Buley, uit den wijngaard omtrent de poort van La Plante,
te Namen, Rijnwijn, heerlijke Spaansche- en Portugeesche wijnen;
druivenolie van Aarschot, die zij Landolium heeten; Bourgondische,
Malvezij- en vele andere wijnen. En de kaaien staan vol koopwaren.

... Die rijkdommen der aarde en der menschelijke bedrijvigheid trekken
naar dit oord de schoonste meidekens van de wereld.

--Ik geloof, dat gij weer aan 't droomen zijt, sprak Lamme.

Uilenspiegel antwoordde:

--Onder haar zal ik de Zeven vinden. Er werd mij gezegd:


    In den dood en in het bloed,
    In de puinen en de tranen,
        Vind de Zeven.


... Wie dan veroorzaakt meer verderf dan de meisjes van plezier? Is
het niet bij heur dat de arme, waanzinnige mannen hunne schoone,
klinkende en blinkende karolussen verteren? Laten zij niet bij heur,
juweelen, ringen en kettingen; keeren zij niet uitgeschud huiswaarts,
zonder wambuis en soms zonder hemde, terwijl de deernen smeren en teren
met het geld, dat zij hun ontfutseld hebben? Waar is het roode, heldere
bloed, dat in hunne aderen vloeide? Het is preisap geworden. En vechten
de mannen niet tegen elkander met messen, met daggen, met zweerden, tot
den dood, om heure gunst te verkrijgen? De bleeke en bloedende lijken,
die men wegbrengt, zijn lijken van arme, waanzinnige verliefden. Als
de vader knort en gestreng blijft zitten, als zijn witte haren er
witter en stijver uitzien, als uit zijne droge oogen, die branden van
verdriet over het verderf van zijn kind, geene tranen meer vloeien;
als de moeder, stilzwijgend en bleek als de dood, weent alsof voor
haar de wereld nog slechts wee en ramp moest baren, wie dan is de
schuld van dat verdriet, van die tranen? De lustige meidekens beminnen
niemand dan zich zelven en het geld, en heel de denkende, werkende,
zwoegende wereld houden zij aan heure rokken gebonden. Ja, Lamme,
dáár zijn de Zeven, en wij zullen bij de meidekens gaan. Wellicht
vinden wij daar uwe vrouw: zóó vangen wij twee vliegen in één slag.

--Ik wil wel, sprak Lamme.

Toen was men in de hooimaand, in het midden van den zomer, als de zon
de bladeren der kastanjeboomen roostert, de vogeltjes in het loover
kweelen en de insecten van genoegen gonzen, omdat het gras zoo warm is.

Lamme doolde met gebogen hoofde naast Uilenspiegel door de straten
van Antwerpen; hij sleepte zijn lichaam voort, alsof het zwaar als
een huis was.

--Lamme, sprak Uilenspiegel, gij ziet er wederom zoo weemoedig uit;
weet gij dan niet dat niets slechter kan zijn voor uw vel? Als gij
volherdt in uw zwarte gedachten, zult gij het verliezen met stukken
en brokken. En dan zal het aangenaam zijn te moeten hooren, als men
van u zal spreken: de schurftige Lamme.

--Ik heb honger, sprak Lamme.

--Kom eten, zei Uilenspiegel.

En samen gingen zij naar de Oude Trappen, waar zij soezels aten en
dobbele kuite dronken, totdat zij hunne bekomst hadden.

En Lamme weende niet meer.

En Uilenspiegel sprak:

--Gezegend zij het goed bier, dat de ziel verkwikt als een dartele
zonnestraal. Gij lacht dat uw buik er van schokt. Zoo zie ik u geerne,
met uwe darmen, die dansen van vreugde.

--Mijn vriend, antwoordde Lamme, zij zouden nog meer dansen, zoo ik
het geluk had mijne vrouw weder te vinden.

--Wij zullen ze zoeken, zei Uilenspiegel.

En zoo kwamen zij in de wijk van het Scheld.

--Kijk, zeide Uilenspiegel tot Lamme, kijk naar dit huisje, dat
heel van hout is gemaakt, met schoone, gebeitelde vensteren, waar
kleine ruitjes in steken; kijk naar die gele gordijntjes en die roode
lanteerne. Daar, mijn vriend, achter vier tonnen bruinbier, uitzet,
dobbele kuite en Spaanschen wijn, troont een schoone bazinne van over
de vijftig. Elk jaar, dat de Heer heur vergunt, krijgt zij een nieuwe
laag vet. Op eene der tonnen flikkert eene vetkeers en aan de balken
der zoldering hangt eene lanteerne. Het is daar donker en klaar:
donker voor de liefde en klaar voor 't gelag.

--Maar, sprak Lamme, 't is een klooster van duivelsche nonnen, en
uwe bazinne is de abdis.

--Ja, sprak Uilenspiegel, zij is het, die, in naam van den heer
Beëlzebub, vijftien liederlijke meidekens leidt op den weg van den
ontucht, en de meidekens vinden eten en schuilplaats bij heur, doch
mogen er niet vernachten.

--Kent gij dat huis? vroeg Lamme.

--Neen.

--Hoe kunt gij er dan van spreken?

--Ik ga er uwe vrouw zoeken. Kom mede met mij.

--Neen, sprak Lamme, ik heb mij bepeinsd en ga daar niet binnen.

--Zoudt gij uwen vriend alleen blootgesteld laten aan de ondernemingen
van die dienaressen van Astarte?

--Hij moet er maar niet heen gaan, antwoordde Lamme.

--Als hij er nu moet gaan om de Zeven en meteen uwe vrouw te
zoeken? hernam Uilenspiegel.

--Ik ging liever slapen, sprak Lamme.

--Kom maar mee, zeide Uilenspiegel.

En hij opende de deur en duwde Lamme vóór zich binnen.

--Zie, sprak hij, daar is de bazinne achter heure tonnen, tusschen twee
keersen: de zaal is groot, met heure zwart geworden eiken zoldering
van bewalmde kepers en planken. Rondom, langsheen de muren, staan
stoelen en hinkende tafelen, dewelke bedekt zijn met glazen, pinten,
bekers, kroezen, kruiken, flesschen, bottels en ander drinkgerief. In
't midden der zaal staan nog tafelen en stoelen, waarop huiken, dat
zijn vrouwenkappen, gulden gordelriemen, fluweelen steltschoenen,
doedelzakken, pijpen en schalmeien liggen. In den hoek is eene ladder,
die naar boven leidt. Een kale bultenaar speelt op eene klavecimbel,
die op glazen pooten staat, om 't geluid van het speeltuig te
vermeerderen. Dans, dikzak. Vijftien schoone meiden zitten op tafelen
of schrijlings op stoelen, in allerlei houding: gebogen, op de zijde
geleund of achterover, of met het hoofd in de hand, naarvolgens
heure grillen; ze zijn gekleed in het wit, in het rood, in allerhande
kleuren, en laten heure bloote armen zien en ook een deel van heuren
boezem. Er zijn er van alle soorten; ze zijn uitgekozen! Van de eenen,
laat het weifelend licht der keersen, dat heure blonde lokken komt
streelen, hare blauwe oogen in het duister, zoodat men er enkel het
vochtige vuur in ziet flikkeren. Anderen zien naar de zoldering en
neuren, op de maat van den vedel, een droeve Duitsche ballade. Anderen
nog, ronde, bruine, dikke, drinken met volle bekers Spaanschen wijn en
toonen heure ronde, tot de schouderen ontbloote armen, en schaamteloos
roepen en tieren de eenen na den anderen en allen te zamen. Hoor wat
ze zeggen: Het is onze mesdag! Heden willen wij niets verdienen! Heden
willen wij geen geld: wij vragen slechts liefde!

Toen Lamme zoovele blonde en bruine, frissche en verslenste vrouwen
te gelijk zag, werd hij beschaamd; hij sloeg zijn oogen neder en riep:

--Uilenspiegel, waar zijt gij?

--Hij heeft dit tranendal verlaten, mijn vriend, sprak een dikke
deerne, die hem bij den arm vatte.

--Dit tranendal verlaten? vroeg Lamme.

--Ja, zeide zij, driehonderd jaar geleden, in gezelschap van Jacobus
de Coster van Maerlandt.

--Laat mij los, sprak Lamme, en nijp mij niet meer.

En op droeven toon ging hij voort:

--Uilenspiegel, mijn vriend, waar zijt gij? Kom uwen gezel toch
ter hulp.

Maar de vrouwen sarden hem meer en meer.

--Ik ga dadelijk heen, als gij mij niet gerust laat.

--Gij zult niet vertrekken, zeiden zij.

--Uilenspiegel, ging Lamme jammerend voort, waar zijt gij dan toch?

En zich tot de plaagzieke meiden wendend, ging hij voort:

--Juffer, als 't u belieft, trek mij zoo bij mijn haar niet; het is
geene pruik, ik mag het u verzekeren. Hulp! Hulp! Vindt gij mijne ooren
niet rood genoeg, dat gij ze nijpt en er het bloed in doet stijgen? En
die andere, die mij gedurig knippen voor den neus geeft! Gij doet mij
zeer. Laas! wat wrijft gij nu in mijn aangezicht? Een spiegel! Ik
zie zwart als een ovengat. Als gij niet uitscheidt, maak ik mij
kwaad; gij moest beschaamd zijn een armen, weerloozen man aldus te
mishandelen! Laat mij los! Als gij mij eene uur bij mijne hooze, bij
mijn wambuis, rechts, links, langs alle kanten zult gesleurd hebben,
zult gij er vetter om zijn? Ja, ge moogt er zeker van wezen, ik ga
mij kwaad maken.

--Hij gaat zich kwaad maken, zeiden zij spottend; hij gaat zich kwaad
maken, zou men niet zeggen! Lach liever, en zing ons een liedeken
van zoete minne.

--Ik zal een liedeken zingen van slagen, als gij wilt. Maar nog eens,
laat mij los.

--Wie van ons ziet gij 't liefst?

--Niemand; noch u, noch eene van de anderen. Ik ga mijne klacht doen
bij den magistraat, en hij zal u doen geeselen.

--Hallo, spraken zij, doen geeselen? En zoo wij u vóór de geeseling
eens vastnamen en kusten?

--Mij? sprak Lamme.

--Ja, u! antwoordden allen.

En al de vrouwen, schoone en leelijke, frissche en verslenste, bruine
en blonde, vlogen naar Lamme.

Zij smeten zijne toque, zijn opperste kleed omhoog, streelden hem,
kusten hem, zoenden hem uit al heure kracht, daar waar zij konden,
op zijne kaken, op zijnen neus, op zijne maag, in zijnen hals.

De bazinne schaterlachte tusschen heure vetkeersen.

--Hulp! schreeuwde Lamme, hulp! Uilenspiegel, verlos mij van dat
ongedierte. Laat me los, ik wil van uwe kussen niet weten; ik ben
getrouwd, drommels!, en bewaar al mijne kussen voor mijne vrouw.

--Getrouwd, spraken zij, maar daar heeft uwe vrouw veel te veel aan,
aan een man zoo vollijvig als gij. Geef ons wat van uw vet. Een trouwe
vrouw, dat is van doen, doch een trouwe man is een kapoen. God hoede u:
gij moet eene keus doen, of wij geeselen u, op onze beurt.

--Ik zal het niet doen, sprak Lamme.

--Kies eene uit, spraken zij.

--Neen, sprak hij.

--Wilt gij mij? vroeg een schoone blonde; bezie mij, ik ben zachtzinnig
van aard, en ik min hem, die mij mint.

--Laat mij los, sprak Lamme.

--Wilt gij mij? sprak een bekoorlijke meid, met gitzwarte lokken en
een bruine tint, en die overigens door de engelen gemaakt scheen.

--Peperkoek lust ik niet, sprak Lamme.

--En mij, zult gij mij niet nemen? vroeg een echte reuzin, met een
voorhoofd, dat schier teenemaal bedekt was met heur haar, met dikke
wenkbrauwen, die samen kwamen, met groote, flikkerende oogen, met
dikke, bloedroode lippen, en ook een rood aangezicht, een rooden hals
en roode schouderen.

--Van gloeiende steenen heb ik schrik, antwoordde Lamme.

--Neem mij, sprak een zestienjarig meideken, met een gezichtje zoo
scherp als dat van een eekhorentje.

--Ik houd niet van notenkrakers, antwoordde Lamme.

--We zullen hem moeten geeselen, zeiden zij. Waarmede? Met schoone
zweepen van droog leder. En dapper geklitskletst! Het hardste vel is
niet bestand tegen lederen roeden. Neemt tien zweepen van karrelieden
en ezeldrijvers, die zijn de beste,

--Hulp! hulp! Uilenspiegel! kreet Lamme.

Doch Uilenspiegel antwoordde niet.

--Gij hebt geen hert, zuchtte Lamme, terwijl hij zijnen vriend
overal zocht.

De zweepen werden aangebracht. Twee van de meidekens begonnen Lamme's
wambuis uit te trekken.

--Eilaas! mijn arm vet, dat ik met zooveel moeite vergaarde, gaan
ze mij ongetwijfeld ontnemen met heur striemende zweepen. Maar,
meedoogenlooze wijvekens, mijn vet kan u tot niets dienen, gij kunt
er niet eens sausen van maken.

Zij antwoordden:

--Wij zullen er keersen van gieten. 't Is toch al iets, klaar te zien,
zonder dat het een oortje moet kosten! Zij, die voortaan zal beweren
dat de keersen uit zweepen voortkomen, zal door een iegelijk aanzien
worden voor een zottinne. Doch wij zullen voor heur aantrekken tot
den dood, en wij zullen meer dan ééne weddenschap winnen. Steekt de
roeden even in den azijn. Doet zijn wambuis uit. Negen uren slaat het
op Sint-Jacobs. Als gij met den laatsten slag geene keus gedaan hebt,
gaan wij er op los!

Sidderend jammerde Lamme:

Hebt genade en medelijden met mij; ik heb mijne arme vrouwe trouw
gezworen en ik zal mijn eed gestand doen, hoewel ze heel slecht deed,
mij te verlaten. Uilenspiegel, help mij, verlos mij, mijn vriend!

Doch Uilenspiegel was te hooren noch te zien.

Lamme zeide tot de deernen:

--Aanschouwt mij, ik lig aan uwe voeten. Ootmoediger kan mijne
houding niet wezen. Bediedt dit niet genoeg dat ik, als heiligen,
uwe bekoorlijkheden vereer? Gelukzalig hij, die niet getrouwd is en
uwe koozerijen mag genieten! Ik twijfel er niet aan, dat gij hemelsche
genoegens doet smaken, maar slaat mij niet, als 't u belieft.

Doch de bazinne, tusschen heure twee keersen gezeten, sprak eensklaps
met donderende en dreigende stemme:

--Vrouwen en meidekens, bij alle duivelen uit de helle zweer ik dat,
bijaldien gij, door lachen en koozerijen, dien man niet dadelijk
tot u krijgt, ik de nachtwacht ga halen en u allen in zijne plaats
doe geeselen. Gij verdient geenszins den naam van dienaressen van de
godin der liefde, zoo gij met uwen mond, uwe handen, uwe vurige oogen
niet bij machte zijt de mannen te verleiden. En om uwe onnoozelheid
wordt gij zonder mededoogen gegeeseld!

Op die rede, begonnen de vrouwen en meidekens te beven en blonk
Lamme's gezicht van vreugde.

--Nu, vrouwtjes, sprak hij schertsend, welke mare brengt gij mede van
het land der striemende zweepen? Ik zal der bazinne de moeite sparen
en zelf om de wacht gaan. Deze zal haren plicht doen en ik wil met
pleizier een handeken toesteken. Alle baten helpen.

Doch een aanvallig meideken van een vijftiental jaren viel op hare
knieën vóór Lamme.

--Heer, sprak zij, gij ziet mij hier wel nederig en gelaten vóór uwe
voeten; doch als gij niemand onzer wilt kiezen, moet ik om uwent wille
gegeeseld worden; is dat rechtveerdig? En de bazinne daar, zal mij in
een leelijken, donkeren kelder steken, onder de Schelde, waar het water
van de muren zijpelt en waar ik slechts roggebrood te eten zal krijgen.

--Zou zij werkelijk om mijnent wille gegeeseld worden, mevrouw de
bazinne? vroeg Lamme onthutst.

De bazinne bevestigde:

--Tot bloedens toe gegeeseld.

Lamme aanschouwde toen het meideken en sprak:

--Gij zijt lief, gij zeit frisch, uw blanke schouderen komen als
rozeblaadjes uit op uw kleed; ik wil niet dat die donzige huid,
onder dewelke zulk jeugdig bloed vloeit, lijde onder de slagen der
zweep; dat die heldere, flikkerende oogen weenen ter oorzake van de
smerte der slagen; dat de wakke killigheid des gevangs dat goddelijk
lichaam doe beven. Dienvolgens heb ik liever u te verkiezen, dan te
weten dat gij om mijnent wille geslagen wordt.

Het meideken leidde hem mede. En zoo zondigde hij, gelijk hij deed
heel zijn leven, uit goedhertigheid.




XXIX.

Uilenspiegel en Lamme stapten op naar Gent en kwamen met de
ochtendschemering omtrent Lokeren.

Frissche, witte dampen zweefden over de weiden.

De beide wandelaars kwamen voorbij eene smidse en Uilenspiegel
schuifelde lijk de leeuwerik, de vogel der vrijheid.

En dadelijk vertoonde zich een man met witte, lange haren, vóór de
deur van de smidse, en terstond bootste hij het dapper gekraai van
den haan na.

Uilenspiegel zeide tot Lamme:

Dat is smid Wasteele, die ploegscharen maakt, het ijzer smeedt als het
warm is om er schoone hekken voor kerkkoren van te verveerdigen, en
zeer dikwijls, 's nachts, wapenen smeedt en slijpt voor de soldaten van
het vrije geweten. Hij is vet noch gezond geworden bij dien dubbelen
arbeid, want hij is bleek als een spook, treurig als een verdoemde,
en zoo mager dat zijne beenderen door zijn vel steken. Hij is nog
niet slapen, zeker heeft hij wederom heel den nacht gewrocht.

--Komt binnen, gij beiden, zeide smid Wasteele, en brengt uwe ezelen
op de meersch, achter het huis.

Toen Uilenspiegel en Lamme dit gedaan hadden, kwamen zij terug in
de smidse en zagen, dat smid Wasteele al de zweerden in den kelder
bracht, die hij binst den nacht geslepen had, en het werk voor zijne
knechts gereedmaakte.

Uilenspiegel met doffe oogen beziende, vroeg hij hem:

--Welk nieuws brengt gij van den Zwijger?

Uilenspiegel antwoordde:

--De Prins is met zijn leger uit de Nederlanden verjaagd, ter oorzake
van de lafheid zijner huurlingen, die roepen: Geld! Geld! als er
te vechten valt. Met zijn trouwe soldaten en zijn broeder, graaf
Lodewijk, trok hij den koning van Navarra en den hugenoten ter hulp;
van daar toog hij naar Duitschland, naar Dillenburg, alwaar vele
vluchtelingen uit de Nederlanden tot hem kwamen. Gij moet wapenen
zenden en het geld dat gij opgehaald hebt, terwijl wij op zee moeten,
om het werk van vrije mannen te verrichten.

--Ik zal doen wat mij geheeten wordt, sprak smid Wasteele; ik heb
wapenen en negenduizend florijnen. Maar zijt gij hier niet gekomen
op ezelen?

--Ja, zeiden zij.

--En hebt gij, onderwege, gene tijding gehad van drie predikanten,
die gedood, uitgeplunderd en in een hol gesmeten werden op de rotsen
van de Maas?

--Ja, antwoordde Uilenspiegel met de grootste vrijmoedigheid, die
drie predikanten waren spionnen van den hertog, die betaald waren
om den prins in het verderf te brengen. Wij getweeën, Lamme en ik,
hebben hun het tijdelijke met het eeuwige doen verwisselen. Hun geld
is in ons bezit en hunne papieren insgelijks. Wij zullen er van nemen
wat ons hoeft voor onze reis, de rest zullen wij aan den prins geven.

En Uilenspiegel deed zijn wambuis open, alsmede dat van Lamme en trok
er papieren en perkamenten uit.

Smid Wasteele las ze en sprak vervolgens:

--Zij behelzen plannen van gevecht en van samenzweering. Ik zal ze den
prins doen behandigen, en er zal hem gezegd worden, dat Uilenspiegel
en Lamme Goedzak, zijn trouwe wandelaars, zijn edel leven gered
hebben. Ik ga uwe ezelen doen verkoopen, opdat men U niet aan uwe
rijdieren zou herkennen.

Uilenspiegel vroeg aan smid Wasteele of de vierschaar der schepenen
van Namen reeds heure serjanten achter hunne hielen had gezonden.

--Ik ga u kond geven van hetgene ik weet, antwoordde Wasteele. Een smid
van Namen, een dappere en overtuigde hervormde, is laatst hier bij
mij geweest, zoogezeid om mij te vragen hem te helpen in het maken
van de hekken, windwijzers en het ander ijzerwerk voor een slot,
dat men omtrent La Plante aan 't bouwen is. De deurwaarder van de
vierschaar der schepenen heeft hem verteld, dat zijne meesters reeds
bijeengekomen waren, en dat de baas eener taveerne alreeds geroepen
was, omdat hij op eenige honderden stappen van de plaats van den
moord woont. Ondervraagd of hij de moordenaars of hen, die hij van den
moord kon verdenken, gezien had, heeft hij geantwoord: "Ik heb boeren
en boerinnen gezien, die op ezelen reden; sommigen bleven op hunne
dieren zitten en vroegen te drinken aan de deur, anderen stegen van
hunne ezelen en kwamen in de gelagkamer, de manslieden dronken bier, de
vrouwen en meidekens mede. Ik zag ook twee dappere mannen, die spraken
van messire van Oranje een kopken kleiner te maken." Terwijl de baas
dit zeide, floot hij, om den steek van een mes in het vleesch van den
hals na te bootsen. "Bij Stalen Wind, zeide hij, zal ik u heimelijk
op de hoogte houden, daar dit in mijne macht is." Hij sprak en werd
losgelaten. Sedert dien tijd hebben de justitieraden ongetwijfeld
brieven gezonden aan de baljuws. De baas zei, dat hij anders niemand
gezien had dan boeren en boerinnen op ezelen; daaruit is te voorzien,
dat men jacht zal maken op allen die men schrijlings op ezelen zal
aantreffen. En de prins heeft u noodig, mijne kinderen.

--Verkoop onze ezelen, zeide Uilenspiegel, en de opbrengst kunt gij
voegen bij den oorlogsschat van den prins.

De dieren werden verkocht.

--Nu moet gij, sprak Wasteele, elk een vrij ambacht hebben, dat tot
geene gilden behoort. Kunt gij vogelkooien en rattenvallen maken?

--Ik heb er vroeger veel gemaakt, zeide Uilenspiegel.

--En gij? vroeg Wasteele aan Lamme.

--Ik, sprak Lamme, ik zal wafelen en oliekoeken verkoopen.

Volgt mij; hier zijn heel gereedgemaakte vogelkooien en rattenvallen,
met gereedschap en koperdraad om ze te herstellen en er anderen te
maken. Dit alles werd mij gebracht door een mijner spionnen Dat is voor
u, Uilenspiegel. Gij, Lamme, krijgt een klein komfoor met blaasbalg;
ik zal u ook deeg, spek en olie geven, om uwe wafelen en oliekoeken
te bakken.

--Hij is in staat alles zelf op te eten, zei Uilenspiegel.

--Wanneer beginnen wij te bakken? vroeg Lamme.

Wasteele antwoordde:

--Gij zult mij eerst een nacht of twee moeten helpen; alleen kan ik
mijn werk niet afkrijgen.

--Ik heb honger, sprak Lamme, is hier niets te eten?

--Er is brood en kaas, antwoordde Wasteele.

--Zonder boter? vroeg Lamme.

--Zonder boter, sprak Wasteele.

--Hebt gij bier of wijn? vroeg Uilenspiegel.

--Ik zelf drink er nooit, antwoordde Wasteele; doch als gij er hebben
wilt, zal ik er halen in den Pelikaan, hier dichtbij.

--Ja, sprak Lamme, en breng meteen wat hesp mee.

--Ik zal doen wat gij vraagt, sprak Wasteele, die Lamme met groote
verachting bekeek.

Toch bracht hij dobbelen klauwaard en hesp. En, van genoegen, at
Lamme voor vijven.

En hij sprak:

--Wanneer beginnen wij te werken?

--Dezen nacht, sprak Wasteele, maar blijft in de smidse en wees niet
bevreesd voor mijne gasten. Het zijn hervormden lijk gij.

--Dat gaat mij, sprak Lamme.

's Nachts, als de slaapklokken geluid hadden en de poorten gesloten
waren, deed Wasteele zich helpen door Uilenspiegel en Lamme, om uit
den kelder zware pakken wapenen naar zijne werkplaats te dragen.

--Hier zijn, sprak hij, twintig bussen, die moeten hersteld, dertig
lanspunten, die moeten geslepen worden, en lood om vijftienhonderd
kogels te gieten; gij gaat mij helpen.

--Met mijn beide handen! antwoordde Uilenspiegel. Waarom heb ik er
geen vier om u behulpzaam te wezen!

--Lamme zal ons helpen, sprak Wasteele.

--Ja, antwoordde Lamme op jammerlijken toon, want hij viel van den
vaak, ter oorzake van het overvloedig eten en drinken.

--Gij zult het lood gieten, sprak Uilenspiegel.

--Ik zal, sprak Lamme.

Lamme smolt zijn lood en goot zijn kogels, doch grimmig bekeek hij smid
Wasteele, die hem dwong op te blijven, terwijl hij zoo'n slaap had.

Hij goot de kogels, maar hij had grooten lust het gesmolten lood over
het hoofd van smid Wasteele te gieten. Doch hij hield zich in. Rond
middernacht werd hij, oververmoeid, door razernij overvallen en,
terwijl smid Wasteele en Uilenspiegel geduldig zweerden, bussen en
lanspunten slepen, hield hij met sissende stem de volgende rede:

--Daar staat gij nu, mager, bleek en schraal, met uw vast vertrouwen
in de prinsen en in de grooten der aarde; door overdreven ijver,
veronachtzaamt gij uw lichaam, uw edel lichaam, dat gij laat vergaan
van ellende en zelfvernedering. Daarom is het niet, dat de goede
God u schiep. Vergeet niet dat onze ziel, die de adem des levens is,
boonen, ossevleesch, bier, wijn, hesp, worsten, pensen, alsmede rust
noodig heeft tot haar bestaan; gij, gij leeft van brood, water en
slapeloosheid!

--Van waar komt u die ongewone woordenvloed? vroeg Uilenspiegel.

--Hij weet niet wat hij zegt, antwoordde Wasteele schokschouderend.

Maar Lamme vervolgde:

--Ik weet het beter dan gij. Ik zeg dat wij zot zijn, ik, gij en
Uilenspiegel insgelijks, onze oogen te bederven voor al die prinsen
en heeren, die zeker zouden lachen met ons, als zij ons, overvallen
door vermoeienis, den nacht zagen doorbrengen met wapenen te slijpen
en kogels te gieten, te hunnen dienste. Terwijl zij wijn uit gouden
bekers drinken en kapoenen in tinnen schotels eten, vragen zij zich
niet af of hunne vijanden met hunne zeisen onze beenen niet afkappen
en ons in den doodenkuil niet werpen. Intusschen zullen zij, die in
den grond noch hervormden, noch calvinisten, noch lutheranen, noch
katholieken zijn, maar aan God noch duivel gelooven, heerlijkheden
koopen en bemachtigen, het goed van monniken, abten en konventen
inslikken. Alles zal voor hen zijn: en vrouwen en maagden en meidekens;
uit hunne gouden bekers zullen zij drinken op hun eeuwig welzijn,
op onze altijddurende onnoozelheid en op de zeven hoofdzonden, die
zij gedurig bedrijven; ja, smid Wasteele, en dàt onder uwen neus,
die mager is van geestdrift. Aanschouw de velden, de weiden, zie naar
de oogsten, de boomgaarden, de ossen, het goud dat opstijgt uit de
aarde; aanschouw de wilde dieren van de bosschen, de vogelen van de
hemelen, de lekkere ortolanen, de heerlijke lijsters, den kop van
het everzwijn, den bout van den reebok: jacht, vischvangst, aarde,
zee, alles, alles is voor hen! En gij, gij leeft van water en brood,
en wij, wij werken ons dood voor hen, zonder slapen, zonder eten,
zonder drinken! En als wij er onder zullen bezweken zijn, zullen
zij onze lijken uit hunnen weg schoppen en tot onze moeders zeggen:
"Maakt er anderen, deze krengen kunnen ons niet meer dienen."

Uilenspiegel lachte goedmoedig zonder iets te zeggen; Lamme blies
van verontweerdiging, doch Wasteele zeide op zachtmoedigen toon:

--Gij spreekt lichtzinnig. Ik leef niet voor hesp, voor bier, noch
voor ortolanen, maar voor de zegepraal van het vrije geweten. Voor de
vrijheid, doet de prins lijk ik. Hij offert zijn goed, zijne rust,
zijn geluk op om de beulen en de dwingelandij uit de Nederlanden
te verdrijven. Doe lijk hij en tracht mager te worden. Het is niet
met den buik dat men de volkeren redt, maar met fieren moed en met
geduldige vermoeienis. En nu,... ga maar slapen, zoo gij vaak hebt.

Maar Lamme wilde niet slapen gaan, want de smid had hem beschaamd.

En gedrieën slepen zij wapenen en smolten zij kogelen tot den dageraad.

En dit drie nachten achtereen.

Toen vertrokken zij naar Gent. Onderwege leurden zij met vogelkooien,
muizenvallen en oliekoeken.

Zoo kwamen zij te Meulestede, welks roode daken men van verre ontwaart,
en daar kwamen zij overeen dat elk op zijn eigen hand zou rond gaan
en dat men 's avonds, vóór de slaapklok, malkander zou vinden in de
afspanning den Zwaan.

Lamme zwierf door de straten van Gent en verkocht gewetensvol zijne
oliekoeken, want hij kreeg zin in zijn bedrijf, maar toch vergat
hij zijne vrouw niet, want hij zocht ze gedurig, noch zijnen buik,
want hij ledigde menigvuldige pinten en at zonder ophouden.

Uilenspiegel had brieven van den prins van Oranje besteld aan Jacob
Scoelap, licentiaat in de medicijnen, aan Lieven Smet, kleermaker,
aan Jan de Wulfslaeger, aan Gillis Coorne, roodverver, en aan Jan de
Roose, ticheldekkker, welke hem het geld ter hand stelden, dat zij
voor den prins opgehaald hadden, en hem zeiden nog eenige dagen te
Gent en in 't ronde te blijven, daar zij hem nog meer zouden geven.

Die mannen werden later aan de Nieuwe Galge uit hoofde van ketterije
gehangen, en hunne lijken werden begraven op het Galgeveld, omtrent
de Brugsche poort.




XXX.

Doch de provoost, de rosse Spelle, met zijne roode roede gewapend,
reed op zijn mager peerd van de eene naar de andere stad, en overal
deed hij schavotten oprichten, brandstapels aansteken, putten delven
om arme vrouwen en meidekens levend te begraven.

En de koning erfde.

Uilenspiegel zat met Lamme te Meulestede onder eenen boom, en was
naargeestig. Het was killig, niettegenstaande het in de Zomermaand
was. Uit den hemel, vol grijze wolken, viel een fijne hagel.

--Mijn vriend, sprak Lamme, 't is nu de vierde nacht dat gij op den
dril zijt en bij de meidekens loopt. Gij slaapt in den Zoeten Inval;
gij zult eindigen lijk de man van het uithangbord, en met uw hoofd
voorop in een bijenkorf vallen. Tevergeefs zit ik op u te wachten in
den Zwaan, en uw losbandig leven voorspelt niets goeds. Waarom neemt
gij geene vrouw in alle eer en deugd?

--Lamme, sprak Uilenspiegel, hij voor wien ééne allen is, en voor
wien allen ééne zijn, in dien liefelijken strijd die minne heet,
kan zoo lichtzinnig en in der haast geene keus doen.

--En Nele, denkt gij aan heur niet?

--Nele is ver van hier, te Damme, zuchtte Uilenspiegel.

Terwijl hij steeds op de hurken zat en de hagel duchtig nederviel,
liep een jonge, lieftallige vrouw voorbij, die heuren rok over heur
hoofd had geslagen om zich voor den hagel te beschutten.

--He, sprak zij, wat zit gij daar onder dien boom te suffen?

--Ik vraag mij af, sprak Uilenspiegel, of ik ooit eene vrouw zal
vinden, die mij onder het dak van heuren rok zal laten schuilen.

--Gij hebt ze gevonden, sprak de vrouw, sta op.

Uilenspiegel stond recht en ging naar heur toe.

--Gaat gij mij weder alleen laten? vroeg Lamme.

--Ja, antwoordde Uilenspiegel, doch ga naar den Zwaan, en eet daar
eenen bout, eet hesp en al wat u lust, drink er twaalf pinten bier,
en trek vervolgens naar uw bed; zoodoende ben ik van u ontslagen.

--In dien raad steekt iets goeds, zei Lamme.

Doch Uilenspiegel hoorde hem niet en was reeds bij de vrouw.

--Licht mijn rok langs de eenen kant op, sprak zij, ik zal hem langs
den anderen kant optillen.

Toen de rok over hunne hoofden geslagen was, zeide zij:

--Laat ons nu loopen.

--Waarom loopen? vroeg Uilenspiegel.

--Om uit Meulestede te vluchten, sprak zij, de provoost Spelle is
daar met twee beulsknechten en hij heeft gezworen al de onnutte
vrouwen--lijk hij ons heet--te doen geeselen, als zij hem geen vijf
gulden willen betalen. Daarom is 't dat ik loop: kom mede en blijf
bij mij om mij te verdedigen.

--Lamme, riep Uilenspiegel van verre, Spelle is te Meulestede! Ga in
aller ijl naar Destelbergen, in de Drie Koningen.

Verschrikt, sprong Lamme schielijk op. Hij hield zijnen buik met de
beide handen vast en begon te loopen.

--Waar loopt die dikke haas naartoe?

--Naar een hol waar ik hem wel zal terugvinden, antwoordde
Uilenspiegel.

--Laat ons loopen, zeide zij, terwijl zij als een driftige merrie op
den grond stampte.

--Ik zou deugdzaam willen zijn zonder te loopen, antwoordde
Uilenspiegel.

--Wat beteekent dat? vroeg zij.

Uilenspiegel antwoordde:

--Die dikke haas daar wil mij doen verzaken aan den goeden wijn,
aan het gerstesap en aan de donzige huid van de vrouwen.

Wantrouwig bezag hem de meid.

--Gij hebt korten adem, zeide zij, gij zoudt niet slecht doen te
rusten.

--Rusten, antwoordde Uilenspiegel, rusten? Maar ik zie geenerlei
schuilplaats.

--Uwe deugd, antwoordde de deerne, zal u tot dekmantel dienen.

--Ik verkies uwen rok, zeide hij.

--Mijn rok, zeide de deerne, ware onweerdig eenen heilige te dekken,
lijk gij beweert te zijn. Ga weg, ik zal alleen voortloopen.

--Weet gij dan niet, antwoordde Uilenspiegel, dat een hond op zijn
vier pooten sneller loopt dan een mensch op twee? Ziedaar waarom wij,
met vier beenen, sneller zullen loopen.

--Ge spreekt nog al krachtig voor een deugdzaam mensch.

--Ja, zeide hij.

--Maar, sprak zij, ik heb altijd gezien dat de deugd een stille,
ingesluimerde, dikke en kouwelijke hoedanigheid is, een masker, dat
knorrende gezichten verbergt, een fluweelen opperste kleed om een man
van graniet. Ik minne die, in welker borst een mannelijk vuur blakert,
dat tot lustige en dappere ondernemingen aanzet.

--Aldus, zei Uilenspiegel, sprak de schoone duivelin tot den
doorluchtigen, heiligen Antonius.

Twintig stappen verder lag eene afspanning langs den weg.

--Gij hebt goed gesproken, vervolgde Uilenspiegel, nu moet gij goed
drinken.

--Ik heb nog geen dorst, zei de vrouw.

Zij gingen de afspanning binnen.

Op eene schapraai, nevens den schoorsteen, stond eene buikflesch.

Uilenspiegel sprak tot den baas:

--Ziet gij dezen gulden?

--Ik zie hem, zei de baas.

--Hoeveel oortjes zoudt gij er wel van afhouden, om die flesch daar
met dobbelen klauwaard te vullen?

De baas antwoordde:

--Met negen mannekens zijt gij er van af.

--Dat maakt, zei Uilenspiegel, zes mijten Vlaamsch, dus twee mijten
te veel. Om het even, tap ze maar vol.

Uilenspiegel schonk de meid eenen beker vol. Daarop stond hij recht;
met fiere houding zette hij de flesch aan den mond en goot heel
den inhoud door zijn keelgat. En het klonk als 't gerucht van een
bruisenden waterval.

De vrouw stond verstomd en vroeg:

--Hoe legt gij het aan boord om zulk een dikke flesch in uw mageren
buik te gieten?

Uilenspiegel antwoordde niet, doch sprak tot den baas:

--Breng ons een hammeken met brood, en nog een volle flesch klauwaard,
dat wij eten en drinken.

Zoo deden zij.

Terwijl de vrouw smulde van een stukje zwoord, nam hij heur zoo
onverwachts, zoo heimelijk om de lenden, dat zij er verrast en verrukt
over was.

Toen vroeg zij hem:

--Hoe komt het, met al uwe deugd, dat gij dorstig als eene spons,
vraatzuchtig als een wolf en ondernemend als een minnaar zijt?

Uilenspiegel antwoordde:

--Nadat ik op honderd manieren gezondigd had, zwoer ik, lijk gij weet,
boetveerdigheid te plegen. Dat heeft wel een groot uur geduurd. Ik
dacht tijdens dit uur aan mijn toekomstig leven en zag dezen droeven
toestand in 't verschiet: niets hebben dan droog brood om mijn honger
te stillen, niets dan water om mijnen dorst te lesschen, de minne
ontvluchten; niet durven verroeren of niet durven niezen, uit vreeze
van kwaad te doen; geëerd zijn door allen, gevreesd door een iegelijk;
alleen en verlaten als een melaatsche; treurig als een hond, die zijn
meester kwijt is, en, na een dergelijk vijftigjarig martelaarsleven,
weemoedig op eenen stroozak verrekken. De boete was langdurig genoeg;
kus mij, liefste, en laat ons getweeën het vagevuur verlaten.

--Ha! zeide zij, bereidwillig gehoorzamend, de deugd is een schoon
vendel om aan eenen stok te binden.

De tijd verliep met dit dartel minnespel; doch zij moesten opstaan
om te vertrekken, want te midden van het blijde gejoel vreesde het
meideken steeds den provoost Spelle te zien verschijnen, met zijne
beulsknechten.

--Sla uwen rok over ons hoofd, sprak Uilenspiegel.

En als herten liepen zij naar Destelbergen, naar de Drie Koningen,
alwaar zij Lamme aan 't eten vonden.




XXXI.

Te Gent ging Uilenspiegel dikwijls bij Jacob Scoelap, bij Livinus
Smet en bij Jan de Wulfslaeger, die hem kond gaven van den voor-
of tegenspoed van den edelen Zwijger.

En als Uilenspiegel naar Destelbergen terugkwam, vroeg Lamme hem
telkens:

--Welk nieuws brengt gij mede? Goed of slecht?

--Laas! zeide Uilenspiegel, de Zwijger, zijn broeder Lodewijk, de
andere hoofdlieden en de Franschen hadden besloten vooruit te rukken
in Frankrijk, om zich met den prins van Condé aan te sluiten. Op die
wijze waren zij er wellicht in geslaagd het arm Belgisch vaderland
en het vrije geweten te redden. God liet dit niet toe, de Duitsche
ruiters en landsknechten weigerden verder te gaan, en zeiden dat hun
eed sprak van tegen den hertog van Alva te vechten, doch niet tegen
Frankrijk. Hij heeft hun gesmeekt hun plicht te doen, doch tevergeefs;
de Zwijger was gedwongen hen langs Champagne en Lotharingen te brengen
naar Straatsburg, van waar zij naar Duitschland terugkeerden. Alles
mislukt door dit plotseling en halsstarrig vertrek: de koning van
Frankrijk weigert, niettegenstaande zijn verdrag met den prins, het
geld te storten, dat hij hem beloofd had; de koningin van Engeland
had er hem willen zenden om de stad en het land van Kales weder in
bezit te krijgen; heure brieven werden onderschept door den hertog
van Lotharingen, die er een afwijzend antwoord op zond.

... Aldus zien wij dat schoon leger, al onze hoop op redding,
verzwinden als spoken bij den zonsopgang; maar God is met ons, en als
de aarde ons ontsnapt, zullen wij te water voortwerken. Leve de Geus!




XXXII.

Badend in tranen, kwam 't meideken zeggen tot Lamme en tot
Uilenspiegel:

--Te Meulestede laat Spelle, voor geld, moordenaars en coquinen
ontsnappen. En onschuldigen doet hij ter dood brengen. Mijn broeder
Michielken is onder hen. Laas! laat mij het U zeggen: gij zijt
mannen, gij zult hem wreken. Een eerlooze, ontuchtige vuilbaard,
Pieter de Roose, bevlekker van kinderen en verleider van meidekens,
is de oorzaak van al het kwaad. Laas! mijn arme broeder Michielken
en Pieter de Roose zaten op een avond, doch niet aan dezelfde tafel,
in de taveerne den Valk, alwaar Pieter de Roose door een iegelijk
geschuwd werd als de pest.

... Mijn broeder, die met hem in dezelfde zaal niet wilde vertoeven,
schold hem uit voor vuilbaard en beval hem onmiddellijk zijne biezen
te pakken.

... Pieter de Roose antwoordde:

--De broeder van een publieke loddege zou minder van zijnen neus
moeten maken,

... Hij loog, want ik ben geen publieke loddege; ik geef mij alleen
aan hen, die ik minne.

... Toen smeet Michielken hem zijn pint klauwaard naar den kop, hem
toeroepende dat hij er om loog, lijk een smerige vuilbaard die hij was;
daarbij bedreigde hij hem met eene aftelling naar de eerste goesting,
als hij niet dadelijk opkraamde.

... De andere wilde nog antwoorden, doch Michielken deed als hij
gezegd had: hij sloeg tweemaal met de vuist op zijn aangezicht en
trok hem bij den snoet op de straat, alwaar hij hem, zonder deernis,
gansch bebloed en gekneusd op een mesthoop smeet.

... Als Pieter de Roose, die in alleenigheid niet kon leven, genezen
was, ging hij in het Vagevier, eene taveerne, die heuren naam niet
gestolen heeft; zóó treurig en somber is zij, dat zij maar bezocht
wordt door arme lieden en bedelaars. Daar ook werd hij alleen gelaten,
geschuwd, zelfs door de armzalige menschen. En niemand richtte het
woord tot hem, behalve eenige boeren, die hem niet kenden, en eenige
truwanten en diepers of weggeloopen soldaten. Herhaalde malen zelfs
werd hij er geslagen, want hij is twistziek van aard.

... Toen provoost Spelle met zijne beide hangmannen te Meulestede
kwam, volgde Pieter de Roose hem overal op als een hond; op dezes
kosten propte Spelle zich vol met wijn, met vleesch en smaakte alle
genoegens, die voor geld te koop zijn. Zoo werd Pieter de Roose hun
vriend en metgezel en deed hij alles wat zijn slecht karakter hem
ingaf om degenen te folteren, die hij verfoeide, en dat waren al de
inwoners van Meulestede, doch mijn armen broeder het meest.

... Eerst en vooral begon hij met Michielken. Valsche getuigen,
rabauwen, die gretig naar guldens waren, verklaarden dat Michielken een
heretiek was, dat hij vuile reden gehouden had over Onze-Lieve-Vrouwe,
en meermalen den naam van God en de santen en santinnen gelasterd
had in de taveerne den Valk, en dat hij daarenboven voor 't minst
driehonderd florijnen in eene kist liggen had.

... Alhoewel de getuigen geenszins van goed en zedelijk gedrag
waren, werd Michielken gevangengenomen. Daar Spelle en zijne knechten
verklaard hadden, dat de bewijzen voldoende waren om den beschuldigde
op de pijnbank te leggen, werd Michielken bij de armen gehangen aan
eene katrol, die in de zoldering vastgemaakt was, nadat men aan elken
zijner voeten een gewicht van vijftig pond had gebonden.

... Hij loochende het stuk en zei dat, zoo er te Meulestede een
truwant, een rabauw, een godslasteraar en een vuilbaard liep, het
wel Pieter de Roose was, maar hij niet.

... Doch Spelle wilde niets hooren, en beval den beulsknechten
Michielken op te trekken tot aan de zoldering en hem vervolgens in eens
te laten nedervallen, met de gewichten aan zijne voeten. Dat deden zij,
en wel zoo wreedelijk, dat de huid en de spieren van den ongelukkige
vaneenscheurden en dat de voeten nog nauwelijks aan de beenen hingen.

... Michielken volhardde in zijne verklaring, dat hij onschuldig was;
Spelle deed hem opnieuw folteren en liet hem verstaan dat hij hem
vrijelijk zou laten henengaan, zoo hij hem honderd gulden wilde ter
hand stellen.

... Michielken zei, dat hij nog liever alle tormenten verduurde.

... Toen die van Meulestede de gevangenneming vernomen hadden, wilden
zij bij hoopen voor Michielken komen getuigen.

... Michielken is geen ketter, zeiden eenstemmig al de goede burgers
van de gemeente, want hij ging alle Zondagen naar de misse en
naderde alle hoogdagen de heilige tafel; zij getuigden verder, dat
hij over Onze-Lieve-Vrouwe nooit eenig andere rede gehouden had dan
heure hulp in te roepen in moeilijke aangelegenheden; dat hij nooit
kwaad gesproken had van eenige vrouw op aarde, en hij dienvolgens
het nog minder hadde gedurfd van de hemelsche moeder Gods. Wat de
godslasteringen betreft, die de valsche getuigen, naar hun zeggen,
in de taveerne den Valk hadden hooren uitbraken, dat was gelogen van
't begin tot het einde, zeiden de getuigen.

... Toen werd Michielken losgelaten, en de valsche getuigen
gestraft. En Spelle deed Pieter de Roose voor zijne vierschaar
verschijnen, doch liet hem weder los, zonder een onderzoek te doen
of hem op de pijnbank te leggen, mits honderd gulden aanstonds betaald.

... Pieter de Roose vluchtte uit Meulestede, uit vreeze dat het
hem nog blijvende geld opnieuw de aandacht van Spelle zou wekken,
terwijl Michielken, mijn arme broeder, stierf van den kanker, die
zich aan zijne voeten gezet had.

... Hij, die mij niet meer bezien wilde, deed mij toch roepen om mij
te zeggen goed te letten op het vuur, dat brandt in mijn lichaam,
en dat mij zeker naar de helle zou leiden. En ik kon slechts weenen,
want het vuur brandt in mijn lichaam, en het is mijne schuld niet.

... En in mijne armen gaf hij den geest.

--Ha! zeide zij, hij, die op Spelle den dood van mijn zoeten en
beminden broeder zou wreken, zou voor eeuwig mijn meester zijn, en
'k zou hem gehoorzamen als een gewillige hond.

Terwijl zij sprak, klopte de assche van Klaas op Uilenspiegel's borst.

En hij besloot Spelle, den moordenaar, te doen hangen.

Boelkin, zoo was de naam van het meideken, keerde gerust terug naar
heur huis te Meulestede, zonder de wraak van Pieter de Roose te
vreezen, want een koerier, die voor zaken naar Destelbergen gekomen
was, verwittigde heur dat de parochiepaap en de poorters verklaard
hadden, dat zij Spelle vóór den hertog zouden doen verschijnen,
bijaldien hij de hand dorst leggen op de zuster van Michielken.

Uilenspiegel, die het meideken vergezelschapt had naar Meulestede,
kwam in de benedenkamer van het huis van Michielken, en zag daar het
konterfeitsel van een meester-pasteibakker.

Hij veronderstelde dat dit het portret van den armen doode was.

En Boelkin zeide:

--Dat is mijn rampzalige broeder.

Uilenspiegel nam het konterfeitsel en sprak:

--Spelle wordt gehangen!

--Hoe zult ge dat doen? vroeg zij.

--Moest gij het weten, antwoordde hij, dan zoudt gij geenerlei genoegen
meer smaken als gij het ziet.

Boelkin schudde het hoofd en zei met jammerende stemme:

--Gij hebt geen vertrouwen in mij.

--Hoe zoo? sprak Uilenspiegel. Is het integendeel geen groot bewijs
van vertrouwen als ik u zeg: "Spelle wordt gehangen?" Met dat woord
alleen kunt gij mij doen hangen vóór hem.

--Inderdaad, antwoordde zij.

--Dus, hernam Uilenspiegel, haal mij wat goede klei, een dobbele
pint bruinbier, klaar water en eenige sneden ossevleesch. Alles moet
afzonderlijk zijn.

... Het vleesch is voor mij, het bruinbier voor het vleesch, het
water voor de klei en de klei voor het konterfeitsel.

Uilenspiegel at en dronk, terwijl hij de klei kneedde; soms at hij
er wel een brokje van, doch daar sloeg hij geen acht op, want heel
aandachtig beschouwde hij het konterfeitsel van Boelkin's broeder.

Toen de klei gekneed was, maakte hij daarvan een masker, met een neus,
eenen mond, oogen en ooren, dat zulke groote gelijkenis had met de
trekken van den doode, dat Boelkin er oprecht over verwonderd was.

Daarna legde hij het masker in den oven te drogen. Toen het droog
was, beschilderde hij het met de kleur van de lijken, met verwilderde
oogen en een pijnlijk en getrokken gelaat, als dat van een zieltogende.

Toen was het meideken niet meer verwonderd, doch ze bekeek het masker,
zonder er van de oogen te kunnen slaan; ze werd bleek, ontstelde,
bedekte heur gezicht met de handen, en huiverend sprak zij:

--Hij is het, mijn arm Michielken!

Met klei maakte Uilenspiegel ook twee bloedige voeten.

Boelkin, die van heur eersten schrik bekomen was, zei op plechtigen
toon:

--Gezegend is hij, die den moordenaar zal vermoorden.

Uilenspiegel nam het masker en de voeten en sprak:

--Nu moet ik iemand hebben, die mij wil helpen.

Boelkin antwoordde:

--Ga naar de Blauwe Gans, bij Joost Lansaem van Ieperen, dewelke deze
taveerne houdt. Hij was de beste kameraad, de trouwste vriend van
mijn ongelukkigen broeder. Zeg hem, dat het Boelkin is, die u zendt.

Uilenspiegel deed zooals zij hem heette.

Na zijn dagelijksch werk voor den dood, ging provoost Spelle 's
avonds in de Valk warmen dobbelen klauwaard drinken, die gekookt was
met kaneel en met Madeira-suiker. Uit vreeze van gehangen te worden,
dorst men hem, in de afspanning, niets weigeren.

Pieter de Roose, die weer moed gevat had, was naar Meulestede
teruggekeerd. Overal volgde hij Spelle en zijne beulsknechten, om
door hen beschermd te worden.

En Spelle trakteerde hem soms. En samen dronken zij blijde met het
geld der onschuldige slachtofferen.

Maar de taveerne de Valk werd niet meer bezocht zooals in de schoone
dagen dat het dorpje in vrede leefde, den Heer rechtzinnig diende en
nog niet gekweld werd op het stuk van religie. Nu, echter, was het
als in rouw gehuld; dat zag men aan zijn menigvuldige ledige huizen,
aan zijn eenzame straten, waar enkel eenige magere honden rondzwierven,
die in de mesthoopen wroetten, om hun eten te zoeken.

In Meulestede was er geene plaats meer dan voor de twee booswichten. De
verschrikte inwoners zagen hen heel den dag overmoedig rondloopen,
de huizen der aanstaande slachtofferen teekenen, de doodenlijsten
opmaken. En als zij 's avonds, onder 't zingen van vuile
liedekens, van den Valk terugkeerden, werden ze gevolgd door twee
beulsknechten, dronken als zij, en van top tot teen gewapend om hen
te vergezelschappen.

Uilenspiegel ging in de Blauwe Gans, bij Joost Lansaem, die achter
zijnen toog stond.

Uilenspiegel trok een fleschje brandewijn uit zijnen zak en zei tot
den baas:

--Boelkin heeft zoo twee tonnen te verkoopen.

--Kom binnen in de keuken, zei de baas.

Hij sloot de keukendeur achter zich en bezag Uilenspiegel vlak in
de oogen.

--Gij zijt geen koopman in brandewijn, sprak hij, wat beteekent uw
knipoogen? Wie zijt gij?

Uilenspiegel antwoordde:

--Ik ben de zoon van Klaas, die te Damme verbrand werd; de assche van
den doode klopt op mijne borst: ik wil Spelle den moordenaar dooden.

--Is 't Boelkin, die u zendt? vroeg de weerd.

--Boelkin zendt mij bij u, antwoordde Uilenspiegel. Ik zal Spelle
dooden en gij zult mij helpen.

--Ik wil, zegde de baas. Wat moet ik doen?

Uilenspiegel antwoordde:

--Ga bij den parochiepaap, die, als een goede herder, de vijand van
Spelle is. Verzamel uwe vrienden en kom morgen, na de slaapklok,
met hen op de Evergemsche baan, voorbij het huis van Spelle, tusschen
den Valk en het huis van dien snoodaard. Gij moet allen in de schaduw
blijven en moogt geen witte kleeren aanhebben. Op klokslag tien zult
gij Spelle uit de herberg zien komen, terwijl van den anderen kant
een wagen zal komen aanrijden.

... Dezen avond moogt gij uwe vrienden niet verwittigen; zij
slapen te dicht bij de ooren hunner vrouw. Eerst morgen zult gij ze
opzoeken. Komt, luistert goed, en weest alles indachtig.

--Wij zullen alles onthouden, sprak Joost.

En, met zijnen beker in de hand, sprak hij:

--Ik drink op de koorde van Spelle!

--Op zijne koorde! sprak Uilenspiegel.

Daarop keerde hij met den baas terug in de gelagkamer, waar eenige
Gentsche oude-kleerkoopers zaten te drinken. Zij kwamen van de
Zaterdagsmerkt, te Brugge, alwaar zij, tegen goeden prijs, zilver-
en goudlakensche wambuizen en opperste kleederen verschacherd hadden,
dewelke zij voor eenige oortjes gekocht hadden van edelen, die ten
onder gegaan waren door de weelde der Spanjaards te willen evenaren.

En zij gastreerden luidruchtig op de groote winsten, die zij behaald
hadden.

Uilenspiegel en Joost Lansaem gingen in eenen hoek zitten en, onder
't drinken, kwamen zij overeen, zonder gehoord te worden, dat Joost
bij den parochiepaap zou gaan, die kwaad was op Spelle, den moordenaar
van zoovele onschuldige slachtofferen.

Daarna zou hij de vrienden gaan vinden.

's Anderen daags kwamen de vrienden van Michielken, die verwittigd
waren, bijeen bij Joost Lansaem in de Blauwe Gans, alwaar zij, als naar
gewoonte en om hunne inzichten te verbergen, pinten op pinten dronken.

Bij de slaapklok gingen zij henen en begaven zich, langs verschillende
wegen, naar de Evergemsche baan.

Zij waren zeventien in getal.

Op slag van tien uren kwam Spelle uit den Valk, gevolgd door zijne
twee beulsknechten en door Pieter de Roose.

Lansaem en zijne gezellen waren verscholen in de schuur van Samson
Boone, een vriend van Michielken.

Spelle kon hen niet zien.

De vrienden van Michielken hoorden hem zwijmelend voorbijgaan, alsook
Pieter de Roose en de beide beulsknechten.

Met een zware tong, stamelde Spelle hikkend en snikkend:

--Provoosten! provoosten! die hebben hier op Gods aarde goed leven;
komaan, truwanten, die van mijn overschot leeft, ondersteunt mij toch
een beetje!

Maar, op den steenweg, van den kant van den kouter, hoorde men op
eens het gebalk van een ezel en 't geklap eener zweep.

--Dat moet een weerspannige ezel zijn, zij Spelle, want hij wil niet
vooruit, niettegenstaande het vriendelijk verzoek van de zweep.

Plotseling hoorde men een groot wielengeknars en eenen wagen, die
onstuimig over den steenweg stormde.

--Houdt hem tegen! riep Spelle.

Toen de wagen dicht bij hen was, sprongen Spelle en zijne twee
beulsknechten naar den kop van den ezel.

--In dien wagen steekt niets, hij is teenemaal ledig, sprak een van
de beulsknechten.

--Lomperik, zei Spelle, sedert wanneer rijden de wagens 's nachts
heel alleen op de baan? In dien wagen is iemand, die zich verbergt;
spoedt u, steekt de lanteernen aan en heft ze omhoog, ik zal kijken.

De lanteernen werden aangestoken en Spelle klom op den wagen met
zijne lanteerne in de hand; maar nauwelijks had hij gekeken, of hij
slaakte een grooten schreeuw en viel achterover, gillend:

--Michielken! Michielken! Jezus, ontferm u mijner!

In een hoek van den wagen stond een man, die in 't wit gekleed was,
lijk de pasteibakkers, en die, in de beide handen, bloedige voeten
vasthield.

Toen Pieter de Roose den man zag, die nu door het licht der lanteernen
beschenen was, riep hij als waanzinnig:

--Michielken! Michielken!

En de twee beulsknechten klappertandden en fluisterden:

--Michielken! Heer, ontferm u onzer!

Op het gerucht kwamen de zeventien vrienden bij, om het schouwspel
te zien, en allen verschrikten toen zij, bij het zilveren licht van
de maan, de treffende gelijkenis zagen van Michielken, den armen doode.

En de gedaante zwaaide steeds met de bloedige voeten.

Het was zijn zelfde vol en rond gezicht, doch verbleekt door den
dood, en grimmig, sneeuwwit keek het dreigend toe, en aan de kin
waren reeds de wormen aan 't knagen.

Het spook, dat altijd met de bloedige voeten zwaaide, zei met holle
stem tot Spelle, die op den rug lag te zuchten:

--Spelle! provoost Spelle, word wakker!

Maar Spelle verroerde zich niet.

--Spelle, sprak het spook opnieuw, provoost Spelle, word wakker,
of ik sleep u in den gapenden mond van de helle.

Spelle sukkelde recht en riep jammerlijk, met de haren te berge
van schrik:

--Michielken! Michielken! heb medelijden!

De poorters waren nader gekomen, doch Spelle zag niets anders dan de
lichtjes hunner lanteernen, die hij voor oogen van duivelen nam. Zoo,
ten minste, bekende hij later.

--Spelle, vervolgde de schim van Michielken, zijt gij tot sterven
bereid?

--Tot sterven, neen, antwoordde de provoost, neen, messire Michielken,
daar ben ik niet toe bereid, want ik wil vóór God niet verschijnen,
beladen met zoo menigvuldige zonden.

--Herkent gij mij? vroeg het spook.

--God weze mij genadig, zuchtte Spelle; ja, ik herken u; gij zijt
het spook van Michielken, den pasteibakker, die onschuldig stierf
in zijn bed, ten gevolge van de pijnen der foltering; en de twee
bloedige voeten zijn die, aan ieder derwelke ik een gewicht van
vijftig pond deed hangen. Ha! Michielken, ontferm u mijner, schenk
mij vergiffenis; die Pieter de Roose heeft mij in bekoring gebracht;
hij bood mij vijftig gulden, en ik heb ze aanveerd, om uwen naam in
het doodenboek te schrijven.

--Wilt gij biechten? vroeg het spook.

--Ja, messire, zeker wil ik biechten, alles bekennen en penitentie
doen. Maar verweerdig u toch die duivelen te doen weggaan, die daar
staan, bereid om mij te verslinden. Ik zal alles bekennen. Verwijder
die oogen van vuur! Ik heb hetzelfde gedaan te Doornijk, met vijf
onschuldige poorters, en ook te Brugge, met vier andere. Ik weet hunne
namen niet meer, maar ik zal ze opzoeken en ze u zeggen, als gij wilt;
elders nog heb ik insgelijks gezondigd, heer, en door mijn toedoen
zijn negen en zestig onschuldige martelaren ten grave gedaald.

... Michielken, de koning moest geld hebben. Men had het mij laten
weten, doch ik ook moest er hebben; het is te Gent, in den kelder,
onder de vloersteenen, bij de oude Gravels, mijn echte moeder. Ik
heb alles, alles gezegd; genade en ontferming! Doe de duivelen
weggaan. Heere God! Heilige Maagd Maria, wees mijn voorspreekster;
verwijder de vuren der helle! Ik zal alles verkoopen, alles aan de
arme geven en mijn leven lang boetveerdigheid plegen.

Uilenspiegel, ziende dat de menigte der toegeloopen poorters bereid
was om hem ter zijde te staan, sprong van den wagen naar de keel van
Spelle en wilde hem verworgen.

Maar de pastoor kwam bij.

--Laat hem leven, sprak hij, het is beter dat hij door beulshanden
sterve dan door die van een spook.

--Wat wilt gij er mee doen? vroeg Uilenspiegel.

--Hem vóór den hertog beschuldigen en naar verdienste doen hangen,
antwoordde de parochiepaap. Maar wie zijt gij? vroeg hij.

--Ik ben, antwoordde Uilenspiegel, het masker van Michielken en een
arme Vlaamsche vos, die terug naar zijn hol trekt, uit vreeze voor
de Spaansche jagers.

Intusschen nam Pieter de Roose in aller ijl de vlucht.

En Spelle werd gevonnist en gehangen, en zijne goederen
verbeurdverklaard.

En de koning erfde.




XXXIII.

's Anderen daags trok Uilenspiegel naar Kortrijk, langsheen den boord
van de Leie, met heur helder gouden water.

Jammerend volgde Lamme zijn vriend.

Uilenspiegel zei tot hem:

--Zucht gij nu weder, lafhertige ziele, voor de vrouw, die u een
hoornen kroon op het hoofd zette?

--Mijn vriend, antwoordde Lamme weemoedig, zij was mij altijd getrouw,
en beminde mij genoegzaam, lijk ik ze te zeer beminde, mijn zoete
Jezus. Eens dat zij naar Brugge gegaan was, kwam zij teenemaal
veranderd terug. Sedertdien, als ik heur van liefde sprak, gaf zij
mij tot antwoord:

--Ik moet met u leven als eene vriendinne, doch anders niet.

--Toen sprak ik, met den weemoed in mijn gebroken herte:

--Liefste mijne, wij zijn getrouwd voor den Heer. Deed ik voor u niet
alles wat gij wildet? Ging ik niet dikwijls gedost in een zwart linnen
wambuis of een bombazijnen opperste kleed, om u, niettegenstaande
de koninklijke ordonnantiën tegen de weelde, zijden en goudlakensche
kleeren te laten dragen? Bemint ge mij dan niet meer, liefste?

--Ik bemin u, sprak zij, volgens God en Zijne wetten, volgens de
heilige voorschriften en de boetveerdigheid. Nochtans zal ik een
deugdzame gezellin voor u wezen.

--Met uwe deugdzaamheid heb ik niets te maken, antwoordde ik; u is het,
die ik hebben wil, u, mijne vrouw!

--Zij schudde het hoofd en vervolgde:

--Ik weet, dat gij goed en braaf zijt; tot heden waart gij de kok in
ons huis, om mij het koken en het braden te sparen; tot heden streekt
gij onze lakens, kragen en hemden, omdat de ijzers mij te zwaar vielen;
gij deedt de wasch, gij kuischtet het huis en de straat vóór de deur,
om mij de minste vermoeienis te sparen. Thans wil ik werken in uwe
plaats, doch verder niets, mijn vriend.

--Ik geef daar niet om, antwoordde ik; ik zal als voorheen uwe
kamenier, uwe strijkster, uwe keukenmeid, uwe waschvrouw, uw
onderdanige slaaf wezen; maar schei toch geen twee herten en zielen,
die maar één wezen uitmaken; breek den zoeten liefdeband niet, die
ons zoo innig verbindt.

--Het moet, antwoordde zij.

--Laas! zeide ik, is het te Brugge, dat gij dit harde besluit hebt
genomen?

Zij antwoordde:

--Ik heb gezworen voor God en Zijne santen.

--Wie dan, riep ik uit, heeft u gedwongen te zweren uwe echtelijke
plichten niet meer te volbrengen?

--Hij, die den geest Gods in zich heeft en zich verweerdigt mij onder
't getal zijner boetelingen te tellen, sprak zij.

--Van dat oogenblik hield zij op mijne vrouw te wezen, alsof zij de
trouwe gezellin van een ander was.

--Ik smeekte, plaagde, dreigde haar; ik weende en bad, doch
tevergeefs. Op een avond, dat ik van Blankenberge terugkwam, alwaar ik
gegaan was om de halfwinning van een mijner hofsteden te ontvangen,
vond ik mijne vrouw niet meer in huis. Zij was onze halle ontvlucht;
ongetwijfeld was zij mijne smeekingen moede, of was zij vergramd of
droevig om mijn verdriet.

--Waar mag zij nu wezen?

En Lamme zette zich neer aan den boord van de Leie, met het hoofd in
zijne handen, en keek naar het water.

--Ha! mijne vriendin, sprak hij, wat waart gij teeder, poezel en
lieftallig! Zal ik ooit een duifje vinden als gij? Stoverije van
liefde, zal ik u nimmermeer proeven? Waar zijn uwe kussen, geurig
als ortolanen; waar is uw mond, op denwelken ik uw zoenen plukte,
als het bijtje den honig op de roze; waar zijn uw witte armen, die
mij streelend omhelsden? Waar is uw kloppend hert, uw ronde boezem
en die lieve huivering van uw aanbiddelijk lichaam, verlangend naar
liefde? Doch waar zijn uwe golven van vroeger, frissche rivier, die
uw nieuwe golfjes zoo blijde voortstuwt in 't gouden licht van de zon?




XXXIV.

De beide wandelaars kwamen voorbij het Petegemsche bosch; het was
snikkend heet. Lamme sprak tot Uilenspiegel:

--Ik braad; laat ons de schaduw opzoeken.

--'t Kan mij niet schelen, antwoordde Uilenspiegel.

Zij zetten zich neer in het bosch, op het gras, en zagen eenen troep
herten voorbijrennen.

--Kijk goed, Lamme, zei Uilenspiegel, die den haan zijner Duitsche
bus overtrok. Daar zijn groote, oude herten, die hun gewei met negen
takken fier in de lucht dragen; lieve reebokjes, die hunne schildknapen
zijn, huppelen aan hunne zijde, bereid om hun van dienst te zijn met
hun puntige horens. Zij gaan naar hun leger. Trek het rad van uwe
bus over, lijk ik. Schiet. Het oude hert is gewond. Een reebokje is
getroffen aan de bil; het vlucht. Laten wij het volgen totdat het
valt. Doe lijk ik, loop, spring, vlieg....

--Mijn gekke vriend is wederom bezig, sprak Lamme, hij wil de herten
te voet achternazetten. Beproef niet te vliegen zonder vleugelen,
't is verloren moeite. Gij zult ze niet krijgen. Ha! wat wreedaardige
gezel! Meent gij, dat ik zoo vlug ben als gij? Ik zweet, mijn vriend;
ik zweet en ik ga vallen van vermoeidheid. Als de houtvester u pakt,
wordt gij gehangen. Herten zijn koningswild; laat ze loopen, mijn zoon,
gij kunt ze toch niet krijgen.

--Kom, sprak Uilenspiegel. Hoort gij het gerucht van zijn gewei in
de bladeren? 't Is als eene hoos, die voorbijvliegt. Zie eens deze
gebroken takken, de bladeren, waarmede de grond teenemaal bedekt
is. Nu heeft het een nieuwen kogel in de bil; fluks eten wij het op.

--Het is nog niet gebraden, zeide Lamme. Laat die arme dieren maar
loopen. He! wat is het warm! Ge moogt mij gelooven: ik ga er bij
vallen om nimmermeer op te staan.

Doch eensklaps kwamen armzalig gekleede mannen, die wapenen droegen,
te allen kanten te voorschijn uit het bosch. Blaffende honden renden
de herten achterna. Vier mannen met woest uitzicht kwamen rond Lamme
en Uilenspiegel staan en leidden hen naar eene plaats, te midden in
het dichtst begroeide deel van het woud.

Daar zagen zij vrouwen en kinderen, die daar gelegerd waren, en
ook een groot getal mannen, allen op verschillende wijze gewapend
met zweerden, met bussen, met voetbogen, met lansen, met spiesen,
met ruiterspistolen.

Toen Uilenspiegel hen zag, zei hij tot hen:

--Gij schijnt hier in gemeenschap te leven om de vervolging te
ontvluchten; zijt gij soms de Broeders van het Woud?

--Wij zijn de Broeders van het Woud, antwoordde een grijsaard, die bij
het vuur zat en eenige vogelen in eene braadpan liet bakken. Maar gij,
wie zijt gij?

--Ik ben uit het schoone Vlaanderenland vandaan, antwoordde
Uilenspiegel, en ben schilder, boer, edelman, beeldhouwer, alles te
gelijk. En door de wereld ga ik aldus, om het goede en het schoone
te prijzen, en luidkeels te lachen en te spotten met alles wat dwaas
en verkeerd is.

--Als gij zoovele landen bereisd hebt, sprak de oude man, moet gij
Schild en Vriend kunnen uitspreken, naar de wijs van de Gentenaren; zoo
niet, zijt gij een valsche Vlaming en moet gij u tot sterven bereiden.

Uilenspiegel sprak:

--Schild en Vriend.

--En gij, dikzak? vroeg de oude man tot Lamme, welk bedrijf voert
gij uit?

Lamme antwoordde:

--Mijne landerijen, pachthoeven, cijnzen en messeniën opeten, mijn
echtelijke vrouw zoeken, en mijn vriend Uilenspiegel in alle oorden
en plaatsen opvolgen.

--Als gij ook zooveel gereisd hebt, sprak de oude man, moet gij weten
hoe die van Weert, in Limburg, worden geheeten?

--Ik weet het niet, was 't antwoord van Lamme, maar kunt gij mij
den naam niet zeggen van den ellendigen deugniet, die mijne vrouw
overreede heur huis te verlaten? Zeg mij zijn naam, en dadelijk ga
ik hem vermoorden.

De oude man antwoordde:

--In deze wereld bestaan twee dingen, die nimmermeer wederkomen, eens
dat zij weg zijn: te weten het verteerde geld, en de onverschillig
geworden vrouw, die den huize ontvlucht is.

Toen wendde de oude man zich tot Uilenspiegel en stelde hij hem ook
deze vraag:

--En gij, weet gij niet hoe die van Weert, in Limburg, worden geheeten?

--De rogstekers, wat in hunne streek onttooveraars van roggen bediedt.

--Kunt gij ook zeggen waarom?

--Een levende rog, gevallen uit de kar van een vischverkooper, lag
zoodanig te spartelen op den weg, dat eenige oude wijven ze voor den
duivel namen. "Laat ons den parochiepaap halen om den duivel uit de
rog te verbannen", zeiden zij. De pastoor bezweerde de rog, en nam ze
mede naar huis, alwaar hij ze kookte, ter eere van die van Weert. Mocht
het Gode behagen hetzelfde lot te bescheren aan den bloedigen koning!

Intusschen hoorde men, in het bosch, 't geblaf van de honden
weerklinken. De gewapende mannen liepen het woud in, en riepen
luidkeels om het wild schrik aan te jagen.

--Het zijn de dieren, die ik achternagezet heb, zeide Uilenspiegel.

--Wij zullen ze opeten, sprak de oude man. Maar zeg mij nog: hoe
noemt men die van Eindhoven, in Limburg?

--De pinnemakers, antwoordde Uilenspiegel. Eens was de vijand vóór de
poort hunner stede, en zij grendelden die vast met eenen wortel. De
ganzen kwamen en begonnen gulzig in den wortel te pikken, en de
vijand rukte Eindhoven binnen. Maar ijzeren bekken zullen het wezen,
die de pinnen zullen vaneen pikken, achter dewelke men het vrije
geweten wil kerkeren.

--Als God met ons is, wie kan tegen ons zijn? antwoordde de oude man.

Uilenspiegel sprak:

--Hondengeblaf, mannengeschreeuw en gebroken takken: het stormt in
het woud.

--Is hertenvleesch lekkere spijze? vroeg Lamme, terwijl hij de
stoverije bekeek.

--Het geroep der drijvers komt nader en nader, zei Uilenspiegel tot
Lamme; de honden zijn nabij. Wat gedonder! Het hert! het hert! uit
den weg, mijn vriend! Foei! wat leelijk beest, het heeft mijn dikken
vriend ten gronde geworpen, te midden van potten, pannen, mooren,
ketels en stoverije. Waanzinnig van schrik, gaan de vrouwen en
meidekens op den loop. Maar gij bloedt, mijn vriend?

--Gij lacht, nietdeug, sprak Lamme. Ja, ik bloed, het dier heeft mij
met de horens eenen stoot op mijn achterste gegeven. Zie, mijne hooze
is gescheurd, en mijn vel insgelijks, en al die lekkere stoverije
ten gronde! Zie, ik verlies zooveel bloed, dat mijne kous er gansch
mee besmeurd is.

--Dat hert is een knap chirurgijn, het heeft U van eene geraaktheid
gered, antwoordde Uilenspiegel.

--Foei, hertelooze deugniet die ge zijt, sprak Lamme verwijtend. Doch
ik zal U niet meer volgen. Hier blijf ik, te midden van deze goede
mannen en vrouwen. Hoe kunt ge toch zoo schaamteloos wezen, ongevoelig
te zijn voor mijne smerten, alswanneer ik u volg op de hielen, als
een hondje, door sneeuw, door vorst, door hagel en wind en, als het
heet is, mijne ziel door mijn vel zweet?

--Wees gerust, 't is niet erg. Leg een oliekoekje op uwe wonde,
het zal een gebakken pleister zijn, antwoordde Uilenspiegel. Maar
weet gij hoe die van Leuven worden geheeten? Gij weet het niet,
mijn arme vriend? Hewel, ik zal het u zeggen, maar gij moogt niet
meer schreien. Men heet ze de koeienschieters: want eens waren
ze zoo onnoozel naar weerlooze koeien te schieten, die zij voor
vijandelijke soldaten aanzagen. Wat ons betreft, wij schieten naar
de Spaansche bokken, hun vleesch stinkt als de pest, maar hun vel is
goed om trommelen van te maken. En die van Thienen? Weet gij het? Ook
al niet? Zij hebben den glorierijken naam van kwekkers. Want bij
hen vliegt, op Sinksen, in de groote kerk, een eendvogel van het
oksaal naar het autaar, en dat is de beeltenis van hunnen Heiligen
Geest. Leg eenen heete koek op uwe wonde. Het zal niet erg zijn,
want ik zie dat gij, zonder een woord te vertellen, de mooren en
stoverije opraapt, die het hert omver gesmeten heeft. Uw moed behoort
vooral thuis in de keuken. Gij steekt het vuur opnieuw aan, brengt den
soepketel terug op zijne drie palen, en houdt u zorgvuldig bezig met
de kook. Weet gij waarom er vier wonderen te Leuven zijn? Neen? Ik
zal het u zeggen. Ten eerste, omdat de levenden er onder de dooden
gaan, want St.-Michielskerk is gebouwd dicht bij de poort van de
stad. Haar kerkhof ligt op den berm der wallen; ten tweede, omdat de
klokken er buiten de torens hangen, gelijk men aan St.-Jacobskerk
ziet, waar een groote klok en een kleine klok zijn; daar de kleine
in den toren niet meer kon geplaatst worden, heeft men ze buiten
gehangen. Ten derde, omdat de autaren buiten de kerk staan, want de
gevel van St.-Jacobskerk lijkt op een autaar. Ten vierde, ter oorzake
van den Toren-zonder-Nagels, omdat de torenspits van Ste-Geertrui
van steen gemaakt is en niet van hout, en dat men in steenen geene
nagelen slaat, behalve in het hert van den bloedigen koning, dat ik
boven aan de groote poort van Brussel zou willen spijkeren. Maar, gij
luistert niet. Hebt gij zout in het eten gedaan? Weet gij waarom die
van Dendermonde de vuurpannen heeten? Omdat, toen eens een jonge prins
in de afspanning de Wapens van Vlaanderen moest komen vernachten,
de baas niet wist hoe hij het bed warm zou krijgen, want hij had
geene vuurpan. Hij deed het bed verwarmen door zijne dochter, die,
zoodra zij den prins hoorde bovenkomen, ijlings de vlucht nam, en de
prins vroeg waarom men de pan uit het bed had genomen. God believe
dat koning Philippus, in een gloeienden ijzeren trommel gestoken,
tot vuurpan diene voor het leger van Astarte.

--Laat mij gerust, zeide Lamme; ik lach met u, met uwe vuurpannen,
met uwen Toren-zonder-Nagels, met uwe Astarte en met al de flauwe kul,
die gij verkoopt. Trek mij niet af van mijne sausen.

--Pas op, sprak Uilenspiegel. Het geblaf houdt niet op, het komt
dichter en dichter, de honden huilen, de trompetten weerschallen. Pas
op voor het hert.

Op die woorden nam Lamme de vlucht, en Uilenspiegel riep hem nog
achterna:

--Hoort gij de jachthorens?

--'t Is niets, Lamme, kom terug bij uwe stoverije, sprak de oude
man. 't Zijn de honden, die hun deel van het wild krijgen; het hert
is dood.

--Dat zal ons een lekkeren maaltijd bezorgen, sprak Lamme. Ik hoop
wel dat gij mij zult nooden, ter oorzake van de moeite, die ik mij
geef voor ulieden. De saus van de vogelen zal lekker zijn, maar ze
kraakt toch een weinig. Dat kan ook niet missen, want de vogelen
zijn in het zand gevallen, als die groote duivel van een hert op mij
kwam gestormd, en mijn wambuis en mijn vel al te zamen aan stukken
trok. Maar zeg eens, vreest gij de houtvesters niet?

--Wij zijn al te talrijk, sprak de oude man; zij zijn bevreesd en
verontrusten ons niet. Ook de serjanten, beulsknechten en rechters
laten ons met vrede. De inwoners van de steden zien ons geerne,
want wij doen hun geen kwaad. Wij zullen hier nog eenigen tijd
leven in vrede, ten ware het Spaansche leger ons omsingelde. Mocht
dat gebeuren, zoo zouden wij, grijsaards, jonge mannen, vrouwen,
dochteren, knapen en meidekens, ons leven duur verkoopen, en liever
nog doodden wij elkander, dan duizend folteringen te lijden door de
hand van den bloedigen hertog.

Uilenspiegel sprak:

De tijd is voorbij, dat men den gruwzamen beul te lande bestreed. 't
Is op zee, dat wij zijne macht moeten fnuiken. Gaat naar den kant van
de Zeeuwsche eilanden, over Brugge, Heist en Knokke, langs het duin.

--Wij bezitten geen duit, spraken zij.

Uilenspiegel antwoordde:

--Hier zijn duizend karolussen vanwege den prins. Gaat voort langsheen
de waterloopen, vaarten, stroomen en rivieren; als gij schepen ziet met
het merk J-H-S, dat een uwer het gezang des leeuweriks nabootse. Een
hanengekraai zal U antwoorden. En gij zult wezen bij vrienden, bij
soldaten van 't vrije geweten.

--Wij zullen het doen, zeiden de mannen.

De jagers, gevolgd door de honden, verschenen weldra, en trokken met
koorden het doode hert achter zich.

Toen zetten allen zich neer rond het vuur.

Zij waren wel zestig in getal, mannen, vrouwen en kinderen.

Het brood werd uit de weitasschen gehaald, de messen uit de scheeden
getrokken. Het hert werd aan stukken gesneden, gestroopt, geruimd,
en met het kleinere wild aan het braadspit gestoken.

En, na den maaltijd, zag men Lamme tegen eenen boom zitten snorken,
met het hoofd op de borst.

Toen de avond gevallen was, trokken de Broeders van het Woud in holen
onder den grond om te slapen, en Lamme en Uilenspiegel deden hetzelfde.

Gewapende mannen hielden de wacht rond het kamp. En Uilenspiegel
hoorde de droge bladeren onder hunne voeten kraken.

En 's anderen daags morgens ging hij henen met Lamme, terwijl die
van het kamp zeiden tot hem:

--God zegene u; wij gaan naar de zee.




XXXV.

Te Harelbeke vernieuwde Lamme zijnen voorraad oliekoeken. Hij vond
ze zoo lekker, dat hij er zeven en twintig zelf opat en dertig in
zijnen korf stak.

Uilenspiegel droeg zijne vogelkooien in de hand.

Rond den avond kwamen zij te Kortrijk, alwaar zij afstapten in de
afspanning de Bie, bij Gillis Vanden Ende, die aan zijne deur kwam,
zoodra hij het gezang des leeuweriks hoorde.

Daar leefden zij als vischjes in 't water. Toen de weerd de brieven
des prinsen gezien had, stelde hij Uilenspiegel vijftig karolussen ter
hand voor den Zwijger; bovendien wilde hij niets voor den kalkoen,
dien hij opgediend had, noch voor den dubbelen klauwaard, waarmede
hij hem rijkelijk besproeide. Ook verwittigde hij hem, dat er spionnen
van den Bloedraad in Kortrijk rondliepen, weshalve hij en zijn gezel
goed op hunne tong moesten letten.

--Wij zullen ze wel herkennen, zeiden Lamme en Uilenspiegel.

De zonne neigde ten Westen en vergulde de gevelspitsen der huizen;
de vogelen zongen hun avondgebed; de vrouwen praatten op de zulle
harer deuren; de kinderen stoeiden in het stof en Uilenspiegel en
Lamme dwaalden op goed-valle-'t-uit door straten en stegen.

Eensklaps sprak Lamme:

--Ik heb aan Gillis Vanden Ende gevraagd of hij geene vrouw gezien had,
die op de mijne geleek--ik gaf hem zoo goed als ik kon de beschrijving
van heur bekoorlijk gezicht--en hij zei mij dat, bij Stevenijne, op
den Brugschen steenweg, in den Regenboog, buiten de stad, alle avonden
een groot getal vrouwen bijeenkomen. Ik trek er aanstonds naar toe.

--Ik zal u daar komen vinden, sprak Uilenspiegel. Ik wil de stad
eens afzien; als ik uwe vrouw tegenkom, zal ik ze dadelijk bij u
zenden. Vergeet niet, dat de baas u voor raad heeft gegeven op uwe
tong te passen, zoo gij aan uw leven houdt.

--Wees gerust, sprak Lamme.

Uilenspiegel wandelde op zijn gemak rond de stad; de zonne ging onder
en de avond viel snel.

Uilenspiegel kwam in een eenzame steeg. Daar hoorde hij kunstig op de
vedel spelen; toen hij nadergekomen was, zag hij van verre een witte
gedaante, die hem riep, doch wegvluchtte en steeds op de vedel speelde.

Maar Uilenspiegel liep sneller dan zij; hij haalde heur in, greep ze
vast en wilde heur aanspreken; maar zij legde heure hand, die naar
benzoë rook, op zijnen mond.

--Zijt gij gemeene burger of edelman? vroeg zij.

--Ik ben Uilenspiegel.

--Zijt gij rijk?

--Rijk genoeg om een hemelsch genot te betalen, niet genoeg om mijne
ziel af te koopen.

--Hebt gij geen peerd, dat gij te voet gaat?

--Ik had een ezel, antwoordde Uilenspiegel, maar ik heb hem op stal
gelaten.

--Hoe komt het dat gij alleen, zonder vrienden of dienaren, rondzwerft
in een vreemde stede?

--Omdat mijn vriend zijnerzijds ergens ronddwaalt lijk ik mijnerzijds,
nieuwsgierige schoone.

--Ik ben geenszins nieuwsgierig, antwoordde zij. Is hij rijk,
uw vriend?

--Ja, hij is rijk, doch in vet, sprak Uilenspiegel. Maar hebt gij
haast gedaan met mij te ondervragen?

--Ik heb gedaan, zeide zij, laat mij nu.

--U laten? sprak hij, 't was precies alsof men tot Lamme, als hij
honger heeft, zou zeggen eene pateel ortolanen te laten staan. Van
u wil ik eten.

--Maar gij hebt mij nog niet gezien, zeide zij.

En zij opende eene lanteerne, die plotseling heur aangezicht
verlichtte.

--Hoe schoon! sprak Uilenspiegel. Ho! wat schoone lichtbruine huid, wat
zachte oogen, wat roode mond, wat liefelijk lichaam! Alles zij mijn!

--Alles, sprak zij.

En zij bracht hem bij Stevenijne, op den Brugschen steenweg, in
den Regenboog.

Uilenspiegel zag daar een groot getal meidekens, die aan den arm
schijfjes droegen van een andere kleur dan die van heur bombazijnen
kleed.

De gezellinne van Uilenspiegel had een zilverlakensch schijfje op
een goudlinnen kleed. En al de meidekens bezagen heur met afgunst.

Bij het binnenkomen had zij de bazinne eenen wenk gegeven, maar
Uilenspiegel had het niet bemerkt: zij zetten zich getweeën neder
en dronken.

--Weet gij, sprak zij, dat wie mij eens beminde, voor eeuwig mijn is?

--Schoone, welriekende deerne, sprak Uilenspiegel, het ware mij een
heerlijk festijn eeuwig uwe genuchten te smaken.

Eensklaps zag hij Lamme in eenen hoek zitten, met een tafeltje voor
zich, waarop eene keers, eene hesp en een pot bier stonden; hij had
het zeer druk om zijne hesp en zijn bier te verdedigen tegen twee
meidekens, die met alle geweld met hem wilden eten en drinken.

Toen Lamme zijn vriend Uilenspiegel gewaar werd, kwam hij voor hem
staan en sprong wel drie voet hoog van blijdschap.

--God zij geloofd, sprak hij, omdat Hij mij mijnen vriend Uilenspiegel
teruggeeft! Bazinne, breng ons te drinken!

Uilenspiegel trok zijne tasch uit en sprak:

--Te drinken tot dit op is!

En hij deed zijne karolussen rinkelen.

--Leve God! sprak Lamme, die hem gezwind de tassche uit de hand trok,
ik ben 't die betaal, maar gij niet! Deze tassche is mijn!

Uilenspiegel wilde met geweld zijne tassche terugnemen, doch Lamme
hield ze stevig vast. Terwijl zij met elkander vochten, de een om de
tassche te houden, de andere om ze terug te nemen, sprak Lamme stille
tot Uilenspiegel:

--Luister: serjanten in huis ... ze zijn gevieren ... in een kleine
kamer met drie meidekens.... Twee buiten voor u, voor mij.... Heb
willen weggaan ... ben belet geworden.... De deerne met heur goudlinnen
kleed is eene verklikster ... Stevenijne, ook verklikster!

Terwijl zij met elkander vochten, luisterde Uilenspiegel goed naar
Lamme en riep hij:

--Mijne tasch terug, dieper!

--Gij zult ze niet hebben, sprak Lamme.

En zij vatten elkander bij den nek, bij de schouderen en rolden ten
gronde, terwijl Lamme stille alles zeide tot Uilenspiegel wat deze
diende te weten.

Maar de baas uit de Bie kwam eensklaps binnen met zeven mannen, die
hij niet scheen te kennen. Hij kraaide als de haan en Uilenspiegel
floot als de leeuwerik.

Toen de baas Uilenspiegel en Lamme samen aan 't vechten zag, vroeg
hij tot Stevenijne:

--Wat zijn dat voor twee rabauwen?

Stevenijne antwoordde:

--Truwanten, die men niet slecht zou doen van elkander te scheiden,
in stede van hen hier al dat gedruisch te laten maken, vóór zij naar
't galgeveld trekken.

--Als hij zich vermeet ons te scheiden, sprak Uilenspiegel, hameren
wij met zijnen kop op de vloersteenen.

--Ja, op de vloersteenen, bevestigde Lamme.

--De baas komt ons redden, fluisterde Uilenspiegel tot Lamme.

De baas, die eene of andere geheimenis ried, wierp zich tusschen
de vechters.

Lamme zei hem in der haast deze woorden in 't oor:

--Komt gij ons redden? Hoe dat?

De baas gebaarde dat hij Uilenspiegel duchtig bij de ooren trok,
en fluisterde hem toe:

--Zeven voor u ... sterke mannen, beenhouwers.... Ik ga weg ... te
zeer gekend in de stad.... Als ik weg ben, is 't tijd van te beven
den klinkaard.... Alles aan stukken slaan....

--Goed, zeide Uilenspiegel, die zich oprichtte en den baas eenen
schop gaf.

Maar de baas gaf hem eenen schop terug en eenen slag daarbij. En
Uilenspiegel zei hem:

--Gij slaat dapper, kameraad.

--Ja, ze vallen als hagelsteenen, niet waar, antwoordde de baas, die
meteen vlug de tassche uit Lamme's handen rukte en ze aan Uilenspiegel
teruggaf.

--Daar, rabauw, sprak hij, trakteer mij, nu gij terug in 't bezit
van uw goed zijt.

--Zuip maar op, schandalige dieper, antwoordde Uilenspiegel.

--Hoor eens hoe stout hij is, sprak Stevenijne.

--Zoo stout als gij schoon zijt, lievelinge, antwoordde Uilenspiegel
met een spottenden glimlach.

Nu, Stevenijne was diep in de zestig en had een gezicht als eene
mispel, doch 't was nu geel van toorn en gramschap. In 't midden
stond een neus, die geleek op den bek van een uil. Zij had oogen
lijk die van een vrek, zonder glans van min of van vriendschap. Twee
lange, puntige tanden staken uit haren mageren mond met zijn dunne,
kleurlooze lippen. En een groote roode vlek bemorste hare linkerwang.

De meidekens lachten, spotten met haar en zeiden:

--Lievelinge, lievelinge, geef hem te drinken!--Hij zal u kussen en
streelen.--Hoelang is het geleden, dat gij samen voor de eerste maal
paardet?--Pas op, Uilenspiegel, zij gaat u verscheuren.--Bezie hare
oogen, zij flikkeren, maar 't is van haat en niet van liefde.--Zou men
niet zeggen, dat zij lust heeft tot bijten?--Wees niet bevreesd.--Al
de vrouwen, die oprecht beminnen, doen zooals zij.--Zij wil slechts
uw goed.--Zie eens hoe 't lachen haar in goede luim heeft gebracht!

En, inderdaad, Stevenijne lachte, doch knipoogde intusschen tot
Gilline, de deerne met heur goudlinnen kleed.

De baas dronk, betaalde en vertrok.

De zeven beenhouwers deden teeken van verstandhouding tot de serjanten
en tot Stevenijne.

Een van de zeven maakte een gebaar om te bedieden, dat hij Uilenspiegel
voor een onnoozele hield en dat hij hem leelijk ging beethebben.

En in Uilenspiegel's oor zeide hij, terwijl hij spottend de tong
uitstak naar Stevenijne, die lachte en heure tanden liet zien:

--'t Is van te beven den klinkaard!

Vervolgens, naar de serjanten wijzend, sprak hij luidop:

--Lieve hervormde, wij zijn allen met u, trakteer ons met eten
en drinken.

En Stevenijne lachte van plezier en stak ook heure tong uit naar
Uilenspiegel, toen deze met zijnen rug naar heur was gekeerd.

En Gilline, de deerne met heur goudlinnen kleed, stak insgelijks
heure tong uit naar Uilenspiegel.

En de meidekens zeiden tot elkander:

--Ziet die verklikster, die den Spanjaard aanhangt en die, door
heure schoonheid, meer dan zeven en twintig hervormden naar de wreede
pijnbank en naar den nog wreederen marteldood bracht. Zie, Gilline
is buiten zich zelve van vreugde; zeker denkt ze aan het geld, dat
zij als aanbrengster krijgt,--de eerste honderd karolusgulden op de
nalatenschap der slachtofferen. Maar zij lacht niet, want zij denkt
er aan, dat zij met Stevenijne moet deelen.

En allen, serjanten, beenhouwers en meidekens, staken hunne tong uit
om te spotten met Uilenspiegel.

En Lamme zweette water en bloed; hij was van gramschap zoo rood als
de kam van een haan, doch hij wilde niet spreken.

--Komaan, trakteer ons met eten en drinken, zeiden de beenhouwers en
de serjanten.

--Wel, sprak Uilenspiegel, terwijl hij zijne karolussen opnieuw deed
rinkelen, geef ons te eten en te drinken, beminnelijke Stevenijne,
geef ons te drinken in glazen, die klinken.

Op die rede lachten de meidekens opnieuw en stak Stevenijne heure
scherpe tanden weer uit.

Maar ze ging toch naar de keuken en naar den kelder, en ze kwam
terug met hesp, met worsten, met pannekoeken van zwarte pensen en
met klinkaards: dat zijn glazen met een voet, aldus geheeten omdat
zij klinken lijk de beiaard, als men ze tegeneen stoot.

Uilenspiegel zei toen:

--Dat zij eten, die honger hebben, en drinken, die dorst hebben!

En serjanten, meidekens, beenhouwers, Gilline en Stevenijne klapten
in de handen en trapten met de voeten. Ieder zette zich neer waar
hij plaats vond: Uilenspiegel, Lamme en de zeven beenhouwers aan de
groote eeretafel, de serjanten en de meidekens aan twee kleine tafelen.

En men at en men dronk met een luidruchtig geknauw, tot zelfs de
twee serjanten, die buiten stonden en die door hunne gezellen werden
binnengeroepen om deel te nemen aan het festijn.

En uit hunne gordeltasschen zag men koorden en kettingen steken.

Stevenijne liet hare tanden zien, en grinnikend sprak zij:

--Niemand zal hier uitgaan, vóór ik betaald ben.

En al de deuren ging zij vast doen; en de sleutelen stak zij in
heure tassche.

Gilline stak heur glas omhoog en sprak:

--Laat ons drinken, de vogel is gevangen!

Bij die rede zeiden twee meidekens, Gena en Greta, tot heur:

--Gaat gij dien ook al ter dood brengen, wreedaardige beulin?

--Laat mij gerust, zei Gilline, laat ons drinken!

Maar de twee meidekens wilden niet klinken met heur.

En Gilline nam heure vedel en zong:


    Op de vedel zing ik geerne,
      Op de vedel nacht en dag.
    Ik ben de dartele deerne
      Die leef van minnegelag.

    Venus mijn heupen maakte,
      Vlammend als van een elf;
    Wit zijn mijn schouders, de naakte,
      Mijn lijf is de godheid zelf.

    Laat uit den buidel klinkelen
      Kronen met hellen klank.
    Laat een goudstroom ruischen en rinkelen
      Geel om mijn voeten blank.

    Ik ben van Eva's geslachte,
      Door Satan, den feilen held.
    Geen vreugdbron lokt uw gedachte
      Die niet in mijn herte welt.

    'k Ben koud en gloeiend samen,
      Teeder, wankel, of stil,
    Flauw, lauw, heet in 't verzamen,
      Willig, man, naar uw wil.

    Zie mijn schoonheid veil, mijn blikken,
      Mijn oogen, blauw en rood,
    Mijn lachjes, tranen en snikken,
      En zoo ge 't zoekt, den Dood.

    Op de vedel zing ik geerne,
      Op de vedel nacht en dag.
    Ik ben de dartele deerne
      Die leef van minnegelag.


En terwijl Gilline zong, was ze zóó bevallig, zóó betooverend schoon,
dat al de mannen, serjanten, beenhouwers, Lamme en Uilenspiegel,
verteederd, glimlachend, als overwonnen, sprakeloos bleven zitten.

Eensklaps schoot Gilline in een luiden schaterlach en, Uilenspiegel
beziende, sprak ze:

--Zóó is 't dat men vogelen vangt!

En heure tooverkracht was verdwenen....

Uilenspiegel, Lamme en de zeven sterke beenhouwers bezagen malkander.

--Nu, gaat ge mij betalen? sprak Stevenijne, gaat ge mij betalen,
messire Uilenspiegel, die teert en smeert met het geld van de
predikantjes?

Lamme wilde spreken, doch Uilenspiegel deed hem zwijgen en zei tot
Stevenijne:

--Ik ben niet gewoon op voorhand te betalen.

--Dan zal ik mij naderhand doen betalen op uwe nalatenschap, zeide
Stevenijne.

--Hyena's leven van lijken, antwoordde Uilenspiegel.

--Ja, sprak een van de serjanten, die twee diepers hebben 't geld van
de predikanten genomen: meer dan driehonderd karolusgulden. Daar zal
een goede stuiver voor Gilline afmogen.

Deze zong:


    Zoek elders zoeter blikken,
      Neem alles, mijn lief genoot,
    Vreugden, kussen, en snikken,
      En, zoo ge 't wilt, den Dood.


En toen riep ze, grijnslachend:

--Laat ons drinken!

De serjanten antwoordden:

--Laat ons drinken!

--Bij God! zei Stevenijne, laat ons drinken! De deuren zijn vast,
de vensteren zijn van stevige ijzeren staven voorzien: de vogelen
zijn gevangen; laat ons drinken!

--Laat ons drinken! zei Uilenspiegel.

--Laat ons drinken! zei Lamme.

--Laat ons drinken! zeiden de zeven beenhouwers.

--Laat ons drinken! zeiden de serjanten.

--Laat ons drinken! zei Gilline, die de snaren heurer vedel
tokkelde. Ik ben schoon, laat ons drinken! Den aartsengel Gabriël
zou ik vangen in de netten van mijn lied!

--Laat ons dan maar drinken, riep Uilenspiegel. Breng wijn op, om het
feest te bekronen, en wèl van den besten! Dat onze dorstige lichamen
van het hoofd tot de voeten doortrokken wezen van het vurige sap van
den wijngaard!

--Laat ons drinken! sprak Gilline, een grondeling, als gij, is den
heekt wel een hap weerd.

Stevenijne bracht bottels wijn op.

De serjanten en de meidekens zaten samen, en dronken en zwolgen. De
zeven beenhouwers, die aan de tafel van Lamme en Uilenspiegel zaten,
smeten van hunne tafel naar die van de meidekens hespen, worsten,
pannekoeken en bottels, die zij vingen in de vlucht, gelijk de karpers
boven het water naar de vliegen snappen. En Stevenijne liet heure
scherpe tanden zien en grijnslachte, en wees naar de pakken keersen
van vijf in het pond, die boven den toog hingen. Het waren de keersen
van de meidekens.

Vervolgens sprak zij tot Uilenspiegel:

--Men gaat naar den brandstapel met eene vetkeers in de hand; wilt
gij er reeds eene hebben?

--Laat ons drinken! zei Uilenspiegel.

--Laat ons drinken! zeiden de zeven.

Gilline sprak:

--Evenals die van eenen zwaan, dien de dood nabij is, flikkeren
Uilenspiegel's oogen lijk perelen.

--Perelen, die wij voor de verkens zullen smijten, sprak Stevenijne
met wrok in het herte.

--Nu, dit ware zoo ongewoon niet: er zijn meer zeugen, die perelen
dragen; laat ons drinken! antwoordde Uilenspiegel.

--Wat zoudt gij zeggen, vervolgde Stevenijne, als men u op de pijnbank
legde en daarna uwe tong met een gloeiend ijzer doorboorde?

--Dat ik dan beter zou kunnen schuifelen: Laat ons drinken! antwoordde
Uilenspiegel opnieuw.

--Ge zoudt zooveel praat niet maken als gij gehangen werdt, sprak
Stevenijne, en uwe lievelinge zou komen zien hoe gij het stelt.

--Ja, sprak Uilenspiegel, maar ik weeg nogal zwaar, en licht kon het
gebeuren, dat ik op uw goddelijk wipneusje bonsde: laat ons drinken!

--Wat zoudt gij zeggen zoo gij gekortoord werd, en op het voorhoofd
en op den schouder met eenen sleutel gebrandmerkt?

--Ik zou zeggen, dat men een verkeerd beest heeft genomen, antwoordde
Uilenspiegel, en dat men, in stee van met de zeug Stevenijne, met
den beer Uilenspiegel bezig is: laat ons drinken!

--Mits gij van al die lieve dingen niet houdt, sprak Stevenijne, zult
gij gebracht worden op de galeien des konings, en daar gevierendeeld
worden.

--Wel, sprak Uilenspiegel, dan zullen mijne vier deelen in de zee
gesmeten worden om den haaien te dienen tot voedsel, en wat zij
overlaten is voor u, mijn hertje: laat ons drinken!

--Eet liever, sprak zij, eet liever deze keersen, zij zullen u dienstig
zijn in de helle, om uw eeuwige verdoemenis te verlichten.

--Ik zie klaar genoeg om uw lichtenden snoet te onderscheiden,
o slecht gebrande zeug, hernam Uilenspiegel.

Eensklaps sloeg hij met den voet van zijn glas op de tafel, daarbij
bootste hij, met de handen, 't gerucht na, dat de tapijtsiers maken
als zij wolle op eene horde uitkloppen, doch hij deed het stilletjes
en zei op de maat:

--'t Is van te beven den klinkaard!

In Vlaanderen was dit het teeken, dat de drinkers kwaad werden. Op
dit teeken werd gemeenlijk alles kort en klein geslagen in de huizen
met roode lanteerne.

Uilenspiegel dronk, tikte met zijn glas op de tafel en sprak:

--'t Is van te beven den klinkaard!

En de zeven deden als hij.

Allen hielden zich stille: Gilline verbleekte, Stevenijne scheen
verrast en onthutst.

De serjanten vroegen tot elkaar:

--Zouden die zeven met hen zijn?

Maar de beenhouwers knipoogden om hen gerust te stellen, terwijl zij
gedurig luider en luider zeiden met Uilenspiegel:

't Is van te beven den klinkaard! 't Is van te beven den klinkaard!

Stevenijne dronk mee, om zich een hert onder den riem te steken.

Toen sloeg Uilenspiegel met de vuist op de tafel, op de maat van
de tapijtsiers, die wolle kloppen; de zeven deden als hij: glazen,
kruiken, schalen, pinten en bekers begonnen te dansen, stieten tegen
elkander, braken, sprongen van den eenen kant weder recht om van den
anderen weer neder te vallen.

En altijd weerklonk meer en meer dreigend en vervaarlijk, het
krijgszuchtig en eentonig referein:

--'t Is van te beven den klinkaard!

--Laas! zuchtte Stevenijne, zij gaan hier alles aan stukken slaan!

En de schrik deed heure scherpe tanden nog langer uitsteken dan
gewoonte.

En, van woede en grammoedigheid begon het bloed van de zeven en van
Lamme en Uilenspiegel meer en meer te koken.

En, zonder hun eentonig en dreigend gezang te staken, namen al die
van Uilenspiegel's tafel hunne glazen en bekers en braken zij dezelve
op de tafel, op de maat der tapijtsiers. Vervolgens zetten zij zich
te peerd op hunne stoelen en trokken zij hunne kruismessen uit.

En zij maakten zulk een gedruisch met hun lied, dat al de ruiten van
het huis aan 't rinkelen gingen.

Vervolgens stormden zij, als uitzinnige duivelen, op hunne stoelen,
rond de kamer en om de tafelen, terwijl zij aanhoudend riepen:

--'t Is van te beven den klinkaard!

En bevend van schrik stonden de serjanten toen recht en haalden
zij hunne koorden en kettingen uit. Maar de beenhouwers en Lamme en
Uilenspiegel staken hunne kruismessen in de scheeden, grepen hunne
stoelen in de hand, zwaaiden ermede als knuppels, liepen aldus de kamer
rond en sloegen, in't wilde, alles aan stukken en brokken. Alleen de
meidekens werden ontzien, doch huisraad, schapraaien, ruiten en pinten,
glazen en schalen, bottels en flesschen werden aan stukken geslagen,
ook de serjanten kregen ruimschoots hun deel, altijd op de maat van
de tapijtsiers, die wolle kloppen:

--'t Is van te beven den klinkaard! 't Is van te beven den klinkaard!

Intusschen had Uilenspiegel eenen vuistslag gegeven op Stevenijne's
neus en hare sleutels uit heure tassche genomen, en nu wilde hij met
alle geweld haar heure keersen doen eten.

De schoone Gilline krabde, als eene verschrikte kattin, met heure
nagelen aan deuren, ramen, ruiten en vensteren, om ergens een uitweg
te vinden. Vervolgens ging zij, bleek als de dood, in eenen hoek op
heure hurken zitten, met heure vedel vóór zich, alsof deze heur had
moeten beschermen.

De zeven en Lamme zeiden tot de verschrikte meidekens:

--U zullen wij geenerlei leed doen.

En, geholpen door heur, bonden zij, met koorden en kettingen,
de serjanten, die beefden als riet en niet dorsten wederstaan,
daar zij wel voelden, dat de beenhouwers--die de weerd uit de Bie
onder de sterksten gekozen had--hen met hunne kruismessen in stukken
hadden gekapt.

En, naarmate Uilenspiegel met geweld Stevenijne keersen deed eten,
sprak hij:

--Deze is voor de pijne der galge; deze voor de kortooring; nog eene
voor de brandmerking; deze hier voor de tongboring; kom, hier nog twee
dikke vette voor de galeien des konings en voor de vierendeeling;
deze is voor uwe spelonk van spionnen; deze is voor uwe deerne met
heur goudlinnen kleed; en al deze hier voor mijn eigen rekening.

En de meidekens proestten van 't lachen, als ze Stevenijne hoorden
niezen van gramschap en zagen hoe zij bovenmatige pogingen inspande om
de keersen uit te spuwen. Maar te vergeefs, want heur mond was te vol.

Uilenspiegel, Lamme en de zeven anderen hielden niet op met zingen
op maat:

--'t Is van te beven den klinkaard!

Vervolgens scheidde Uilenspiegel uit, en deed hij hun teeken het
referein zachtjes te mompelen. Zulks deden zij, terwijl hij tot de
serjanten en meidekens sprak:

--Als een uwer zich vermeet om hulp te roepen, wordt hij onmiddellijk
gekeeld.

--Gekeeld! bevestigden de beenhouwers,

--Wij zullen zwijgen, maar doe ons geen leed, Uilenspiegel, zeiden
de meidekens.

Doch Gilline, die met uitpuilende oogen, met toegebeten tanden,
op de hurken in heuren hoek zat, kon niet spreken en prangde heure
vedel tegen heure borst.

En de zeven murmelden altijd op maat:

--'t Is van te beven den klinkaard!

Stevenijne wees met den vinger naar de keersen, die in haren mond
staken, om te bedieden dat zij ook zwijgen zou. De serjanten beloofden
zulks insgelijks.

Uilenspiegel vervolgde zijne rede en sprak:

--Gij zijt hier allen in onze macht; 't is donker, de nacht is
gevallen, wij zijn hier dicht bij de Leie, in dewelke men lichtelijk
verdrinkt, vooral als men daartoe door flinke gasten wordt geholpen.

--De poorten van Kortrijk zijn lang reeds gesloten. Als de nachtwacht
het gedruisch gehoord heeft, zal zij zich niet verroeren, want zij
is er te lui voor. Ook meent zij, dat het goede Vlamingen zijn, die
blijde drinken en zingen bij 't gerinkel van bottels en glazen. Houdt
u dus koest en luistert naar de bevelen van uwe meesters.

Toen vroeg hij tot de zeven:

--Gaat gij naar Petegem bij de Geuzen?

--Ja; wij hebben onze toebereidselen gemaakt, zoodra wij hoorden,
dat gij naar de stad kwaamt.

--Van daar gaat gij naar de zee?

--Ja, zeiden zij.

--Kent gij onder die serjanten een of twee, die men zou mogen loslaten,
om ons te dienen?

--Ja, zeiden ze, twee, Nicolaas en Judocus, die nimmer de arme
hervormden hebben vervolgd.

--Wij zijn getrouw! riepen Nicolaas en Judocus.

Toen sprak Uilenspiegel:

--Hier hebt gij twintig karolusgulden, tweemaal meer dan gij hadt
ontvangen als eerloozen prijs uwer aanklacht.

Plotseling riepen de vijf andere:

--Twintig gulden! Voor twintig gulden willen wij ook den prins
dienen. De koning betaalt slecht. Geef ons enkel de helft van die som,
en wij vertellen aan den rechter al wat gij wilt.

De beenhouwers en Lamme herhaalden gezamenlijk, met een dof gemurmel:

--'t Is van te beven den klinkaard! 't Is van te beven den klinkaard!

--Opdat gij uwe tong niet zoudt voorbijklappen, sprak Uilenspiegel,
zullen de zeven u gekneveld en gebonden naar Petegem brengen, bij de
Geuzen. Gij zult tien gulden hebben als gij op zee zult zijn; op die
manier zijn wij zeker, dat de keuken van 't kamp u bijhoudt. Als gij
dient als dappere soldaten, krijgt gij uw deel van de buit. Als gij
beproeft te ontsnappen wordt gij gehangen. Als gij ontsnapt, om de
koorde te ontloopen, valt gij gewis op het mes.

--Wij dienen, die ons betaalt, zeiden zij.

Lamme en de zeven sloegen op de tafels met scherven van potten en
pinten en bekers, en spraken:

--'t Is van te beven den klinkaard! 't Is van te beven den klinkaard!

--Gilline, Stevenijne en drie deernen zult gij insgelijks medenemen,
vervolgde Uilenspiegel. Als een van heur poogt te ontsnappen, naait
gij ze in eenen zak en smijt ze in de Leie.

--Hij heeft mij niet gedood, kreet Gilline, uit heuren hoek springend
en met heure vedel zwaaiend.

En zij zong:


    Bloedig was de gedachte
    Die nog mijn hart ontstelt.
    Ik ben van Eva's geslachte
    Door Satan, den fellen held.


Stevenijne en de anderen zetten een gezicht alsof zij in tranen
gingen uitbarsten.

--Vreest niets, mijne liefsten, sprak Uilenspiegel, gij zijt zoo zoet
en zoo zacht, dat men u overal zal minnen, vieren en streelen. Bij
elke bemachtiging, door onze legers gedaan, krijgt gij ook uw deel
van den buit.

--Ik, ik zal niemendal krijgen, ik ben reeds te oud, sprak Stevenijne
krijtend.

--Eén stuiver daags zult gij krijgen, sprak Uilenspiegel, want gij
zult de dienaresse dezer vier schoone deernen wezen. Gij zult heure
rokken, kleeren en hemden wasschen.

--Ik, Heere God? riep zij.

Uilenspiegel antwoordde:

--Lang genoeg hebt gij heure meesteresse gespeeld, lang genoeg
hebt gij rijkelijk geleefd op heur lijf, terwijl gij ze in armoede
en ontbering liet sukkelen. Nu moogt gij schreeuwen en ruchelen,
't is vergeefs. Zooals ik zeg, zal geschieden.

Daarop schoten de vier meidekens in eenen schaterlach; ze begonnen
met Stevenijne te lachen en zeiden, terwijl zij spottend de tong naar
heur uitstaken:

--Elk zijne beurt op de wereld. Wie had dat gedacht van de gierige
Stevenijne? Zij zal voor ons werken als onze dienstmeid. Gezegend
zij onze heer, gezegend zij Uilenspiegel!

Vervolgens zei Uilenspiegel tot de zeven beenhouwers en tot Lamme
Goedzak:

--Ledigt de wijnkelders, neemt al het geld; het zal dienen tot het
onderhoud van Stevenijne en de vier meidekens.

--Zij knarsetandt, de gierige Stevenijne, zeiden de meidekens. Gij
waart hard jegens ons, nu is men het ook jegens U. Gezegend zij onze
heer, gezegend zij Uilenspiegel!

En de drie deernen wendden zich tot Gilline:

--Gij waart heure dochter, heure broodwinster, zeiden zij, met heur
deeldet gij de vruchten van uw eerloos spionbedrijf. Zoudt gij ons
nog durven slaan en beleedigen, met uwe goudlinnen kleeren? Voor
ons koesterdet gij niets dan verachting, omdat wij maar bombazijn
droegen. Als gij zoo schoon gekleed waart, was het alleen met den
prijs van het bloed uwer slachtofferen. Wij zullen heur kleed van
heur lijf rukken, opdat zij onze gelijke zou wezen.

--Dat zal ik niet dulden, sprak Uilenspiegel.

En Gilline vloog hem om den hals en sprak blijde:

--Gezegend zijt gij, die mij spaart van den dood en niet duldt dat
ik leelijk weze!

En de afgunstige meidekens bezagen Uilenspiegel en spraken tot
elkander:

--Hij is zot van haar, evenals de anderen.

Gilline nam heure vedel en zong een liedeken van vurige minne.

De zeven vertrokken naar Petegem, langsheen de Leie, en leidden de
serjanten en de meidekens mede.

Onderweg murmelden zij:

--'t Is van te beven den klinkaard! 't Is van te beven den klinkaard!

Met den dageraad kwamen zij nabij het kamp. Zij zongen als de
leeuwerik en het gekraai van den haan antwoordde hun. De meidekens
en de serjanten werden van dichtbij bewaakt.

Edoch, den derden morgen werd Gilline dood gevonden: in heur hert
stak een groote naald.

Stevenijne werd door de drie meidekens beschuldigd en gebracht voor den
bentkapitein, zijne tiendeniers en serjanten, in verschaar vergaderd.

Daar bekende zij, zonder dat men heur op de pijnbank moest leggen, dat
zij Gilline gedood had uit afgunst op heure schoonheid en uit woede,
omdat de deerne heur zonder mededoogen als eene dienstmeid behandelde.

En Stevenijne werd gehangen en vervolgens begraven in het bosch.

Gilline werd ook begraven, en men las de gebeden der dooden over heur
liefelijk lichaam.

Doch de twee serjanten Judocus en Nikolaas, dien Uilenspiegel de
les had gespeld, waren vóór den kastelein van Kortrijk verschenen,
want het gedruisch, het geweld en de plundering moesten door hem
gestraft worden, daar het huis van Stevenijne in de kasselrij, buiten
den bijvang der stad Kortrijk lag. Nadat zij aan den kastelein het
gebeurde hadden verteld, zeiden zij hem met de innigste overtuiging
en de nederigste oprechtheid:

--De moordenaars van de predikanten zijn geenszins Uilenspiegel
en zijn trouwe vriend Lamme Goedzak, die maar naar den Regenboog
gekomen waren om zich te vermaken. Zij hebben zelfs reispassen van den
hertog en wij hebben die met eigen oogen gezien. De twee schuldigen
zijn twee kooplieden van Gent, een magere en een heel dikke, die naar
Frankrijk getogen zijn, nadat zij alles aan stukken hebben geslagen bij
Stevenijne, dewelke zij medegenomen hebben met heure vier meidekens,
voor hun pleizier. Wij hadden ze wel bij den kraag gepakt, doch daar
waren zeven beenhouwers in het kot, van de sterksten der stad, die
voor de booswichten aantrokken. Zij hebben ons allen gekneveld en ons
maar losgelaten als zij verre in Frankrijk waren. Hier ziet gij nog
het merk van de koorden. De vier andere serjanten zijn achter hunne
hielen, en wachten op versterking, om de hand op hen te leggen.

De kastelein gaf hun elk twee karolussen en een nieuw kleed, als
belooning voor hun trouwe en eerlijke diensten.

Vervolgens schreef hij naar den raad van Vlaanderen, naar de
schepenbank van Kortrijk en naar andere vierscharen om hun kond te
doen, dat de ware moordenaars ontdekt geweest waren.

En hij legde de zaak uiteen van 't begin tot het einde.

Dat deed al die van den Raad van Vlaanderen en van de smalle
vierscharen sidderen en beven.

En de kastelein werd om zijne scherpzinnigheid geloofd en geprezen.

En Uilenspiegel en Lamme gingen ongehinderd op den weg van Petegem
naar Gent, langsheen den oever der Leie; van deze laatste stede zouden
zij zich begeven naar Brugge, alwaar Lamme zijn vrouw hoopte weder
te vinden, en naar Damme, alwaar Uilenspiegel reeds had willen zijn,
om Nele te zien, die treurig leefde bij de uitzinnige Katelijne.




XXXVI.

Sedert lang werden er, in het land van Damme en in de omstreken,
afschuwelijke gruweldaden gepleegd.

Meidekens, jonge knapen, oude mannen, die met geld naar Gent, Brugge
of andere steden of dorpen van Vlaanderen waren gegaan, werden dood
gevonden op den weg, naakt als pieren, den hals doorgebeten met zulke
lange en scherpe tanden, dat het nekbeen van allen gebroken was.

De geneesheeren en de chirurgijns-baardemakers verklaarden, dat het
tanden waren van een grooten wolf.

--Dieven waren ongetwijfeld gekomen na den wolf, en hadden den
slachtofferen geld en kleederen afgenomen, zeiden zij.

Verscheidene aanzienlijke poorters, die zich kloekmoedig zonder
geleide op weg hadden begeven, verdwenen zonder dat men wist wat zij
geworden waren, behalve dat men nu en dan eens een landbouwer, die
's morgens naar zijn akker ging, wolvesporen vond in zijn kouter,
terwijl zijn hond met de pooten de aarde openkrabde en een armzalig,
naakt lijk ontblootte, waarop men, in den nek of onder het oor, de
tanden van den wolf zag, en menigwerf ook in de beenen, doch altijd
van achteren. En altijd was het nekbeen gebroken.

De ontstelde boer ging dan schielijk kennis geven van zijne akelige
vondst aan den baljuw, die met zijn griffier-crimineel, twee schepenen
en een chirurgijn-baardemaker, ter plaatse kwam, waar het lijk des
vermoorden lag. Na een neerstig en zorgvuldig onderzoek, lukte het hun
soms, als het gezicht niet afgeknaagd was door de wormen, den stand,
zelfs den naam en den toenaam van den verslagene te ontdekken.

Doch ze waren ten zeerste verwonderd, dat de wolf, die uit honger
slechts menschen aanvalt, nooit het kleinste stuk uit het lijk had
gebeten.

En die van Damme waren met schrik bevangen en dorsten 's nachts zonder
goed geleide niet meer uitgaan.

Eindelijk toch werden verscheidene kloekmoedige soldaten uitgezonden om
den wolf op te sporen, met bevel hem te zoeken, bij dag en bij nacht,
in het duin, langsheen de zee.

Toen waren ze omtrent Heist, in het groot duin. De nacht was
gevallen. Een der soldaten, vol vertrouwen op zijne kracht, wilde hen
verlaten, om alleen op zoek te gaan, gewapend met zijne bus. De anderen
lieten hem gaan, overtuigd als zij waren dat hij, een kloekmoedig
en goed gewapend soldaat, den wolf zou dooden, als deze zich dorst
laten zien.

Toen hun gezel vertrokken was, staken zij een groot vuur aan, bij
hetwelk zij zich zetten te spelen met dobbelsteenen, en brandewijn
te drinken.

En van tijd tot tijd riepen zij luide:

--Nu, kameraad, kom maar terug; de wolf heeft schrik; kom, drink
eenen slok.

Doch hij antwoordde niet.

Eensklaps hoorden zij een grooten schreeuw, als 't gereutel van een
man, die gekeeld wordt, en terstond liepen zij naar den kant van
denwelken het geschreeuw kwam.

En zij riepen:

--Verweer u kloekmoedig, wij komen u ter hulp!

Maar 't duurde tamelijk lang, voordat zij hunnen makker vonden, want
sommigen vermeenden, dat de kreet uit het dal, anderen dat hij van
de hoogste duin was gekomen.

Toen zij dal en duin met hunne lanteernen goed afgezocht hadden,
vonden zij eindelijk hunnen gezel, van achteren gebeten in den arm
en in het been en met gebroken nek, lijk de andere slachtofferen.

Hij lag op den rug, met zijn zweerd in de toegenepen hand; zijne bus
lag op het zand. Naast hem waren drie afgesneden vingeren, die de zijne
niet waren, en die zij meedroegen. Zijne gordeltasch was hem ontnomen.

Zij namen het lijk van hunnen gezel op de schouderen; zijn flink
zweerd en zijn dappere bus droegen zij insgelijks mede, en, grammoedig
en jammerend, droegen zij het lijk naar het baljuwschap, alwaar de
baljuw het ontving, bijgestaan door zijnen griffier-crimineel, door
twee schepenen, alsmede door twee chirurgijns.

De afgesneden vingeren werden onderzocht en bevonden als zijnde die van
eenen ouderling, dewelke van geenerlei ambacht kon zijn, want zij waren
dun en fijn, en de nagelen lang, lijk die van rechters en geestelijken.

's Anderen daags gingen de baljuw, de schepenen, de griffier, de
chirurgijns en de soldaten naar de plaats, waar de arme doode gebeten
was, en zij zagen bloeddroppelen op het gras, en stappen die gingen
tot aan de zee, waar zij ophielden.




XXXVII.

Het was in den tijd der rijpe druiven, de vierde dag van de Wijnmaand,
als wanneer men te Brussel, na de hoogmis, van op Sint-Nicolaastoren,
zakken okkernoten te grabbel smijt.

Des nachts werd Nele gewekt door kreten, die kwamen van de straat. Zij
zocht Katelijne in de kamer, maar vond ze niet. Zij liep naar beneden
en opende de deur, en Katelijne kwam haastiglijk binnen en sprak:

--Red mij! red mij! De wolf! de wolf!

En Nele hoorde, van verre in het veld, een akelig, schor
gehuil. Sidderend stak zij al de lampen en keersen aan, die zij vond.

--Wat is er gebeurd, Katelijne? vroeg zij, heur in de armen drukkend.

Katelijne zette zich neer op eenen stoel, en, met verwilderde oogen,
zeide zij, terwijl zij de keersen aanstaarde:

--Dat is de zonne, die de booze geesten verdrijft. De wolf, de wolf
huilt in de verte.

--Maar, zeide Nele, waarom zijt gij uit uw bed gekomen, waar gij warm
laagt, om koorts op te doen in de vochtige najaarsnachten?

En Katelijne sprak:

--Hansken schreeuwde daar even als de nachtuil; en ik heb de deur
opengedaan. En hij zei tot mij: "Drink den tooverdrank"; en ik
dronk. Hansken is schoon. Doe het vuur weg. Toen bracht hij mij dicht
bij de vaart en zeide hij mij: "Katelijne, ik zal u de zevenhonderd
karolussen teruggeven, gij zult ze geven aan Uilenspiegel, zoon
van Klaas. Hier zijn twee karolussen voor u, koop er een kleed mee,
weldra zult gij er duizend hebben".--"Duizend, sprak ik, mijn beminde,
dan zal ik rijk zijn".--"Gij zult ze hebben, sprak hij. Maar zijn er
in Damme geene vrouwen of meidekens, die nu zoo rijk zijn als gij dan
zult wezen?"--"Ik weet het niet", antwoordde ik. Ik wilde heure namen
niet zeggen, uit vreeze dat hij ze zou beminnen. Toen zeide hij mij:
"Tracht dit te weten te komen en zeg mij heure namen als ik terugkom".

...Het was koud, de mist hing over de weide, droge takjes vielen van
de boomen op den weg. En de maan glom, en er waren lichtjes op het
water van de vaart. Hansken zeide mij: "'t Is nacht van de weerwolven;
dezen nacht mogen alle schuldige zielen uit de helle komen om op de
wereld te wandelen. Gij moet driemaal het teeken des kruises met de
linkerhand maken en roepen: "Zout! zout! zout!" dat het zinnebeeld is
van onsterfelijkheid; en zij zullen u geenerlei leed doen". En ik zei:
"Ik zal doen wat gij wilt, Hansken, mijn geliefde".--Hij omhelsde mij
en sprak: "Gij zijt mijn gade".--"Ja", sprak ik. En bij zijn zoete
woorden viel een hemelsch geluk als een balsem over mijn lichaam. Hij
kroonde mij met rozen en sprak: "Gij zijt schoon". En ik zeide hem:
"Gij ook zijt schoon, Hansken, mijn geliefde, met uw fijne kleederen
van groene panne met gouden belegsels, met uw lange struisveeren, die
wuiven op uw toque en met uw bleek gezicht, dat lijkt op de branding
der zee. En als de meidekens van Damme u zagen, zouden allen achter u
loopen, om u uw herte te vragen; maar gij moogt het slechts geven aan
mij, Hansken".--Hij sprak: "Tracht te weten te komen wie de rijksten
zijn, haar fortuin is voor u". Toen vertrok hij, na mij verboden te
hebben hem te volgen of te vergezelschappen. Bibberend van koude,
nat van den mist, bleef ik staan, terwijl ik de twee karolussen in
mijne hand deed rammelen, toen eensklaps een wolf met groenen muil
en lange lischblaren in zijn wit haar, den oever van de vaart opklom
en naar mij kwam. Ik riep: "Zout! zout! zout!" en maakte driemaal
het teeken des kruises, doch daar scheen hij geenszins schrik voor
te hebben. En ik liep uit al mijne macht, al schreeuwend, terwijl
hij achter mij huilde, en ik hoorde het klapperend geluid zijner
tanden achter mij, en eenmaal dit zóó dicht tegen mijne schouderen,
dat ik dacht dat hij mij vastgrijpen ging. Maar ik liep gauwer dan
hij. Tot mijn groot geluk kwam ik aan den hoek van de Reigerstraat
den nachtwacht met zijne lanteerne tegen. "De wolf! de wolf!" riep
ik. "Wees niet bevreesd, sprak de nachtwacht tot mij, ik zal u naar
huis leiden, uitzinnige Katelijne". En ik voelde dat zijne hand,
die de mijne vasthield, insgelijks beefde. En hij ook was bevreesd.

--Maar reeds heeft hij weer moed gevat, sprak Nele. Hoor, daar zingt
hij met slepende stemme: "De klok slaat tien, tien slaat de klok!" En
hij draait met zijnen ratel.

--Doe het vuur weg, sprak Katelijne; mijn hoofd brandt. Kom terug,
Hansken, mijn liefste!

En Nele keek droevig naar Katelijne; en zij bad Onze-Lieve-Vrouwe,
de Heilige Moeder Gods, dat zij het vuur der uitzinnigheid uit heur
hoofd zou wegnemen; en zij weende over heur.




XXXVIII.

Te Bellem, aan den oever van de Brugsche vaart, kwamen Uilenspiegel
en Lamme eenen ruiter tegen, met drie haneveeren op zijn vilten hoed,
en die spoorslags naar Gent reed. Uilenspiegel zong als de leeuwerik
en de ruiter hield zijn peerd in, en antwoordde met Kanteklaar's
helder gekraai.

--Brengt gij tijdingen mede, onstuimige ruiter? vroeg Uilenspiegel.

--Gewichtige tijdingen, antwoordde de ruiter. Op raadgeving van
mijnheer de Châtillon, die in Frankrijk admiraal is, heeft de
prins kaperbrieven uitgegeven; buiten de vaartuigen van Emden en
Oost-Friesland, worden allerwegen oorlogsschepen uitgerust. De dappere
mannen, die de brieven ontvingen, zijn: Adriaan van Bergen, heer van
Dolhain; de baron de Montfaucon, Lodewijk van Brederode; Albrecht van
Egmond, zoon van den gehalsrechte en geen verrader lijk zijn broeder;
Berthold Enthens van Mentheda, de Fries; Adriaan Menningh, Hembyse,
de trotsche, vurige Gentenaar, alsmede Jan Brock.

... De prins heeft heel zijn vermogen gegeven, over de vijftigduizend
gulden.

--Ik heb er vijfhonderd voor hem, sprak Uilenspiegel.

--Draag ze naar de zee, sprak de ruiter.

En hij reed weg op een draf.

--Hij geeft heel zijn vermogen, zeide Uilenspiegel. Wij, wij hebben
slechts ons lijf en geven het geerne.

--En heet gij dat niets, vroeg Lamme, en zullen wij altijd leven
tusschen rooven en moorden? Oranje is ten gronde.

--Ja, sprak Uilenspiegel, ten gronde evenals de eik; maar met eikenhout
bouwt men schepen voor de vrijheid!

--Tot zijn profijt, sprak Lamme. Maar, nu alle gevaar verdwenen is,
konden wij ezelen koopen, dunkt mij. Ik zit nog al geerne op mijn gemak
als ik reis, en ben geen liefhebber van veeren op mijne voetzolen.

--Wij zullen langooren koopen, zeide Uilenspiegel; die kunnen wij
steeds verkoopen zonder verlies.

Zij trokken naar de merkt en kochten er twee schoone ezelen met het
noodige tuig.




XXXIX.

Schrijlings op hunne rijdieren gezeten, kwamen zij te Oostkamp,
alwaar een groot bosch is, hetwelk aan de vaart paalt.

Op zoek naar lommer en naar liefelijke geuren, traden zij er in,
zonder iets anders te zien dan lange dreven, die in alle richtingen
naar Gent, Brugge, Zuid- en Noord-Vlaanderen liepen.

Eensklaps sprong Uilenspiegel van zijnen ezel.

--Ziet gij daar niets?

Lamme sprak:

--Ja, ik zie iets.

En bevend vervolgde hij:

--Mijne vrouw, mijn goede vrouw! Zij is het, mijn vriend. Ha! ik zal
naar heur niet kunnen loopen. Wie had ooit gedacht, dat ik heur aldus
zou terugvinden?

--Waarover klaagt gij? sprak Uilenspiegel. Zij is schoon, zoo
half naakt, in dat uitgebekt neteldoeksch wambuis, dat heur vel
zoo liefelijk doet uitkomen. Die vrouw is te jong, zij kan de uwe
niet wezen.

--Mijn vriend, sprak Lamme, zij is het, mijn vriend; ik herken
ze. Draag mij, ik kan niet meer gaan. Wie had dit van heur
gedacht? Alzoo dansen, in Egyptische deerne verkleed, zonder
schaamte! Ja, zij is het; zie maar heur schoone beenen, heur tot den
schouder ontbloote armen, heur ronde lichtbruine borsten, die half
uitkomen uit heur neteldoeksch wambuis. Zie eens hoe zij dien grooten
hond plaagt met een rood vlaggetje, en hoe hij er naar toe springt.

--'t Is een Egyptische hond, zeide Uilenspiegel; die soort hoort niet
te huis in de Nederlanden.

--Of het een Egyptische hond is, weet ik niet juist.... Maar zij
is het.... Ha! mijn vriend, ik sta het niet langer uit. Zij licht
heur kleed nog hooger op, om heur ronde beenen nog hooger te laten
zien. Zij lacht om heur witte tanden te toonen, en schatert om den
klank heurer zoete stem te laten hooren. Zij opent heur wambuis
van boven en werpt zich achterover. Ha! die zwanenhals, die bloote
schouderen, die heldere en stoutmoedige oogen! Ik loop er naar toe!

En hij sprong van zijnen ezel.

Doch Uilenspiegel hield hem tegen en sprak:

--Dat meideken is uwe vrouw niet. Wij zijn omtrent een kamp
van Egyptenaren. Pas op. Ziet gij den rook tusschen de boomen
opstijgen? Hoort gij 't geblaf van de honden? Zie maar: hier zijn
er eenigen, die ons bezien en misschien lust gevoelen om ons te
bijten. Laat ons terugkeeren, Lamme.

--Ik wil niet terugkeeren, sprak Lamme, die vrouw is de mijne; zij
is uit Vlaanderen vandaan lijk wij.

--Waanzinnige blinde! zei Uilenspiegel.

--Maar ik ben niet blind, sprak Lamme. Ik zie ze, half naakt, dansen,
lachen en joelen met dien hond. Zij gebaart mij niet te zien. Maar
ik verzeker u dat zij ons ziet. Thijl! Thijl! zie, de hond werpt zich
op heur en smijt ze ten gronde, om het roode vlaggetje te hebben. En
zij valt met een smertvollen kreet.

En eensklaps vloog Lamme er naar toe, zeggende:

--Mijne vrouw, mijne vrouw! Waar hebt gij zeer, mijne liefste? Waarom
berst gij in eenen schaterlach uit? Uw oogen staan verwilderd in
uw hoofd.

En hij kuste, streelde heur, en sprak:

--Dat geboortevlekje, dat gij onder den linkerboezem hadt, zie ik
niet! Waar is het? Zoudt gij mijne vrouw niet wezen? God van den
hoogen hemel!

En zij hield op met lachen.

Eensklaps riep Uilenspiegel:

--Pas op, Lamme.

En Lamme keerde zich om, en zag een grooten duivel van een Egyptenaar
met een mager gezicht vóór zich staan, die bruin was als peperkoek.

Lamme raapte zijnen stok op, stelde zich te weer en riep:

--Ter hulp, Uilenspiegel!

Uilenspiegel was daar met zijn kruismes.

De Egyptenaar zei hem in het Hoogduitsch:

--Gieb mir Geld, einige Thaler.

--Zie, sprak Uilenspiegel, het meideken gaat schaterlachend henen en
keert zich gedurig om, opdat men heur volge.

--Gieb mir Geld, sprak de man. Betaal uwe minnarijen. Wij zijn arm
en willen u geen kwaad.

Lamme gaf hem eenen karolus.

--Welk bedrijf voert gij uit? vroeg Uilenspiegel.

--Alle bedrijven, antwoordde de Egyptenaar: zeer bedreven in de
goochelkunst, doen wij wonderbare en bovennatuurlijke toeren. Wij
spelen op de tamboerijn en dansen Hongaarsche dansen. Onder ons zijn
er, die schoone vogelkooien maken en anderen die roosters verveerdigen
om vleesch op te braden. Doch allen, Vlamingen als Walen, zijn bevreesd
voor ons en jagen ons weg. Daar wij niets kunnen verdienen, zijn wij
wel gedwongen, groenten, vleesch en kiekens bij de boeren te stelen,
vermits zij ons die niet willen geven of laten verdienen.

Lamme vroeg hem:

--Van waar komt dat meideken, dat zoo goed op mijne vrouw trekt?

--Dat is de dochter van onzen hoofdman, antwoordde de zwerver.

Vervolgens zeide hij stiller, als iemand, die vreest dat men hem
zou afluisteren:

--Zij werd door God getroffen met minnekwaal en kent niets van
de vrouwelijke eerbaarheid. Zoodra zij eenen man ziet, wordt zij
blijgeestig en minziek, en lacht zij gedurig. Zij is weinig van
zeggen; langen tijd meenden wij dat zij doof was. 's Nachts blijft
zij in alleenigheid vóór het vuur; soms zit zij te weenen, of zonder
reden te lachen, en wijst zij naar heuren buik, waar zij zeer heeft,
naar zij zegt. 's Zomers, rond het middaguur, na het eten, is ze 't
ergst gefolterd door heure kwaal. Dan gaat ze, schier teenemaal naakt,
dansen omtrent het kamp. Zij wil niets anders dragen dan kleederen
van gaas of van neteldoek, en 's winters hebben wij alle moeite om
heur een opperste kleed van geitenlaken te doen omslaan.

--Maar, sprak Lamme, heeft zij dan geen enkelen vriend om haar te
beletten aldus aan een iegelijk heur lichaam ten beste te geven?

--Neen, sprak de man, zij geeft geenerlei vriend, want als de
wandelaars, die zij tot zich lokt, heur waanzinnige oogen zien,
krijgen zij meer schrik dan liefde voor heur. Die dikke man was
tamelijk stout, sprak hij, naar Lamme wijzend.

Lamme fronste de wenkbrauwen, bij die toespeling op zijne dikte.

--Laat hem maar zeggen, Lamme; 't is de sprot, die kwaad spreekt van
den walvisch.

--Gij zijt spotziek, dezen morgen, sprak Lamme.

Doch zonder te luisteren, vervolgde Uilenspiegel tot den zwerver:

--Wat doet zij, als anderen zoo stout zijn als mijn vriend Lamme?

De Egyptenaar antwoordde droefgeestig:

--Dan heeft zij genot en profijt. Zij die heur krijgen, betalen hun
pleizier, en het geld dient om heur te kleeden en ook tot de behoeften
der grijsaards en vrouwen.

--Zij gehoorzaamt dus aan niemand? vroeg Lamme.

De bruine man antwoordde:

--Laat hen, die God treft, hun zin doen. Aldus beduidt hij zijnen
wil. En zijn wil is onze wet.

Uilenspiegel en Lamme vervolgden hunnen weg naar Brugge. En de
Egyptenaar ging ernstig en fier terug naar het kamp. En het meideken
danste, schaterlachend, in een opene plaats van het bosch.




XL.

Onderweg sprak Uilenspiegel tot Lamme:

--Wij hebben reeds schrikkelijk veel geld uitgegeven: wij hebben
huurlingen aangeworven, den serjanten eene belooning gegeven,
een karolus aan dat Egyptisch meideken geschonken; voeg daarbij de
ontelbare oliekoeken, die het u beliefde zonder ophouden zelf te eten,
liever dan er éénen te verkoopen. Nu, niettegenstaande het verzet van
uwen buik, wordt het hoog tijd dat wij ons met minder generen. Geef
mij uw geld: ik zal de gemeenschappelijke beurs houden.

--Ik wil wel, sprak Lamme.

Hem de beurs langend, sprak hij:

--Laat mij evenwel niet sterven van honger; want bedenk toch: dik en
struisch als ik ben, moet ik kloek en overvloedig voedsel hebben. Dat
is goed voor u, die mager en schraal zijt, van onbekommerd te leven,
onverschillig of gij eten vindt of niet, lijk de planken op de kaaien,
die leven van regen en lucht. Doch ik, dien de lucht en de regen
hongerig maken, ik hoef andere festijnen.

--Gij zult ze hebben, die festijnen, maar 't zullen festijnen zijn
van een deugdzame vasten. De best gevulde buiken zijn daartegen niet
bestand; zij nemen langzamerhand af en maken de zwaartste mannen
als een vlinder zoo licht. En weldra zal men Lamme, mijnen vriend,
genoegzaam ontvet, zien loopen als een hert,

--Laas! sprak Lamme, zou dit voortaan mijn armzalig lot moeten
wezen? Ik heb honger, mijn vriend, en zou willen eten.

De avond viel. Zij kwamen te Brugge langs de Gentpoort. Zij toonden
hunne passen. Toen zij een halven stuiver voor zich en twee stuivers
voor hunne ezelen hadden betaald, traden zij de stad binnen.

Lamme dacht gedurig aan de woorden van Uilenspiegel en was diep
nedergeslagen.

--Zullen wij haast avondmalen? sprak hij.

--Ja, antwoordde Uilenspiegel.

Zij stapten af in de Meermin, afspanning, die van verre kennelijk was
door de gouden meermin, die, als windwijzer, bovenop den trappengevel
stond.

De beide wandelaars brachten hunne ezelen op stal, en Uilenspiegel
bestelde brood, bier en kaas voor hun avondmaal.

De weerd grijnslachte bij het opdienen van dien schamelen
maaltijd. Lamme at met lange tanden, en zag vertwijfeld naar
Uilenspiegel, die het oudbakken brood en de te jonge kaas
binnenspeelde alsof hij ortolanen at. En Lamme dronk zijn dun bier
zonder genoegen. Uilenspiegel lachte in zich zelven als hij hem
zoo jammerend zag zitten. En daar was nog iemand, die lachte in het
binnenhof van de afspanning, en die van tijd tot tijd den neus voor
het venster kwam steken. Uilenspiegel zag dat het eene vrouw was, die
heur aangezicht verborg. In den waan dat het een oolijke dienstmaagd
was, hield hij er zich niet verder mede bezig, te meer daar hij, naar
Lamme kijkend, zag dat zijn vriend bleek, treurig en troosteloos was
ter oorzake van zijne tegengewerkte liefde voor lekkere spijzen en
dranken. Hij kreeg medelijden met hem en meende voor zijn gezel een
pannekoek met pensen, eene pateel ossenvleesch met boonen of een ander
warm gerecht te bestellen, toen de weerd binnenkwam en beleefdelijk
sprak, met zijne muts in de hand:

--Als die doorluchtige heeren een beter avondmaal wenschen, moeten
zij maar spreken en zeggen wat hun zal believen.

Lamme sperde de oogen wijd open en den mond nog wijder, en bezag
Uilenspiegel met angstige onrust.

Deze antwoordde:

--Reizende werklieden hebben geen gouden karolussen te vereten.

--Toch gebeurt het somtijds, sprak de baas, dat zij niet weten wat
zij bezitten....

En, naar Lamme wijzend, vervolgde hij:

--Die goede tronie is er twee andere weerd. Wat zouden die doorluchtige
heeren gelieven te eten en te drinken? een pannekoek met vette, lekkere
hesp? Soezels?--wij hebben er dezen avond gereedgemaakt. Krakelingen,
een kapoen, die zoo malsch is dat hij smelt in den mond? Geurige
karbonaden met saus, bereid met de vier specerijen? Antwerpsche
dobbelen knol, Brugsche dobbele kuite, Leuvenschen wijn bereid naar
de wijs van Bourgondië? En dit alles zonder een duit te betalen.

--Breng dan maar alles op, sprak Lamme.

Weldra stond de tafel gedekt en schepte Uilenspiegel er oprecht
vermaak in den armen Lamme bezig te zien, die, hongeriger dan ooit,
beurtelings alle gerechten aanviel: den pannekoek, de soezels,
den kapoen, de hesp, de karbonaden, en heele stoopen dobbelen knol,
dobbele kuite en Leuvenschen wijn, bereid naar de wijs van Bourgondië,
door zijn keelgat zond.

Toen Lamme zijne bekomst had, blies hij lijk een walvisch van genoegen;
en hij keek rondom zich op de tafel om te zien of er niets meer te
peuzelen viel. En zorgvuldig snoepte hij de brokken der krakelingen.

Hij noch Uilenspiegel hadden het lieve gezichtje gezien, dat in het
binnenhof, glimlachend voor de ruiten kwam lonken. De baas had warmen
wijn opgebracht, die met kaneel en Madeira-suiker gekookt was. En de
beide vrienden dronken en zongen.

Bij de slaapklok, vroeg de baas of zij ieder naar hun groote, schoone
kamer wilden gaan.

Uilenspiegel zeide, dat een klein kamertje voldoende was voor hun
tweeën.

De baas antwoordde:

--Kleine kamerkens heb ik niet; gij zult elk eene heerenkamer hebben,
zonder een duit te betalen.

En, inderdaad, hij bracht hen naar rijk gestoffeerde kamers met
prachtige meubelen. In die van Lamme stond een groot bed.

Uilenspiegel, die veel gedronken had en viel van den vaak, liet hem
slapen gaan en deed als hij.

's Anderen daags, rond den middag, trad hij in de kamer zijns vriends
en vond hem nog in zijne koets aan 't ronken. Naast hem lag een fijn
geborduurde beugeltasch. Hij opende die en zag dat ze met gouden
karolussen en zilveren oortjes gevuld was.

Hij schudde Lamme om hem wakker te maken; deze schoot uit zijn slaap,
wreef zich de oogen en, ongerust rondom zich kijkend, vroeg hij:

--Mijne vrouw? Waar is mijne vrouw?

En, naar de ledige plaats naast zich in het bed wijzend, sprak hij:

--Straks was ze daar nog.

Hij sprong vervolgens uit zijn bed en keek opnieuw overal rond, in
alle hoeken en kanten der kamer, in de alkoof, tot in de schapraaien.

Stampvoetend herhaalde hij:

--Mijne vrouw? Waar is mijne vrouw?

De baas kwam boven, op 't gerucht dat hij maakte.

--Deugniet, riep Lamme, den weerd bij de keel grijpend, deugniet,
waar is mijne vrouw? Wat hebt gij gedaan met mijne vrouw?

--Driftige kerel, zeide de baas, uwe vrouw? Welke vrouw? Gij zijt
hier alleen gekomen. Ik weet niet wat ge vertelt.

--Ha! hij weet het niet, hij weet het niet, sprak Lamme, die opnieuw
al de hoeken en kanten der kamer afzocht. Laas! Daar, in mijn bed,
was zij dezen nacht, als in den schoonen tijd onzer liefde. Ja,
waar zijt ge, mijn hertje?

En, de beurze ten gronde smijtend, vervolgde hij:

--'t Is uw geld niet, dat ik hebben moet; 't is u, 't is uw liefelijk
lichaam, uw schoonen boezem, 't is uw hert, mijne welbeminde! O,
genuchten des hemels, zult gij nooit meer terugkomen? Ik had er mij
aan gewend te leven zonder u te zien, te leven zonder liefde, mijn
hertediefje. En nu verlaat gij mij opnieuw, na mij uw zoete kussen
te hebben laten smaken. Maar ik zal het besterven! Mijne vrouw! Waar
is mijne vrouw?

En hij lag te snikken ten gronde. Doch eensklaps vloog hij naar de
deur; hij stormde de trap af, en liep in zijn hemd de afspanning door,
tot op de straat, al roepend:

--Mijne vrouw? waar is mijne vrouw?

Maar hij kwam dadelijk terug, want de straatjongens jouwden hem uit
en smeten met steenen naar hem.

En Uilenspiegel zeide tot hem:

--Kleed u, Lamme, en wees niet wanhopend, gij zult ze terugzien,
vermits gij ze heden gezien hebt. Zij mint u nog immer, vermits
zij bij u is teruggekomen, vermits zij het waarschijnlijk is,
die het lekkere maal van gisteravond en de heerenkamers betaald,
en deze volle beurze op het bed gelegd heeft. De assche zegt mij,
dat dit het werk niet is van een ontrouwe vrouw. Ween niet meer,
en laat ons gaan voor het heil van den grond onzer vaderen.

--Laat ons te Brugge blijven, zei Lamme; ik zal heel de stad afloopen,
en zal ze wel vinden.

--Gij zult ze niet vinden, daar zij zich voor u verbergt, sprak
Uilenspiegel.

Lamme vroeg inlichtingen aan den baas, doch deze wilde niets zeggen.

En zij togen naar Damme.

Onderwege sprak Uilenspiegel tot Lamme:

--Waarom vertelt gij mij niet, hoe gij ze dezen nacht nevens u vondt
en hoe zij u verliet?

--Mijn vriend, antwoordde Lamme, gij weet dat wij gisterenavond
gegastreerd hebben met vleesch, met bier en met wijn, en dat ik met
moeite kon blazen, toen ik de trap opklom om te slapen. Om mij te
lichten hield ik, als een groot heer, eene waskeers in mijne hand,
en om te slapen had ik den kandeleer op eene schapraai gezet; de deur
was tegenaan en de schapraai stond dicht bij de deur. Terwijl ik mij
ontkleedde, bezag ik mijn bed met genoegen, want ik had grooten vaak;
de waskeers werd eensklaps uitgeblazen. Ik hoorde als een ademtocht
lichte stappen in mijne kamer; doch mits ik meer vaak had dan schrik,
liet ik mij vallen in 't bed. Ik ging slaap vatten, toen eene stem,
heure stem, o mijne vrouw, mijn arme vrouwe, mij vroeg: "Heeft het
avondmaal gesmaakt, Lamme?" en heure stem was dicht tegen mij en heur
aangezicht ook, en heur liefelijk lichaam.




XLI.

Dien dag had koning Philippus te veel lekkernijen gegeten en was
hij naargeestiger dan gewoonte. Hij had op zijn levende klavecimbel
gespeeld, eene kist waar katten in waren, dewelke heuren kop door
ronde gaten staken, boven de toetsen. Telkens dat de koning op eene
toets sloeg, sloeg deze op hare beurt de kat met eenen schicht; en het
dier mauwde erbarmelijk, ter oorzake van de smert, die het uitstond.

Doch Phillippus lachte niet.

Gedurig zocht hij in zijnen geest hoe hij Elisabeth, de groote
koningin, zou kunnen overwinnen om Maria Stuart terug op den troon
van Engeland te plaatsen. Met dat doel had hij eenen brief geschreven
aan den Paus, dewelke diep in schulden stak; de Paus had geantwoord
dat hij, voor die onderneming, geerne de heilige vaten der tempels
en de schatten van het Vatikaan zou verkocht hebben.

Maar Philippus lachte niet.

Ridolfi, de lieveling van koningin Maria, die heur wilde verlossen
in de heimelijke hoop naderhand met heur te trouwen en koning van
Engeland te worden, kwam bij Philippus om met hem Elisabeth's dood
te beramen. Maar hij had zulke lange tong, lijk de koning naderhand
schreef, dat men ter Beurze van Antwerpen openlijk van zijn voornemen
gesproken had; en de moord werd niet bedreven.

En Philippus lachte niet.

Later zond de bloedige hertog, op bevel van den koning, vier
moordenaars naar Engeland. Zij slaagden er slechts in, zich te
doen hangen.

En Philippus lachte niet.

En aldus verijdelde God de heerschzuchtige plannen van dien
bloedzuiger, wiens voornemen was Maria Stuart heuren zoon te ontnemen
en in zijne plaats, samen met den Paus, over Engeland te regeeren. En
de moordenaar was verbitterd, omdat dit edele land zoo groot en zoo
machtig was. Gedurig wendde hij zijn bleeke oogen naar hetzelve,
en zocht hij het middel om het te verpletten, om vervolgens over de
wereld te regeeren, de hervormden uit te roeien, en liefst nog de
rijke, en have en goed te erven van de slachtofferen.

Maar hij lachte niet.

En men bracht hem ratten en muizen in een ijzeren doos met hooge
randen, open van boven; en hij stelde de doos met den bodem op een
gloeiende stoof en hij schepte er vermaak in, de arme diertjes te
zien en te hooren springen, schreeuwen, zuchten en sterven....

Maar hij lachte niet.

Vervolgens ging hij, met bleek gezicht en bevende handen, in de
armen van mevrouw van Eboli, zijn vuur van geilheid blusschen, dat
aangestoken was met de toorts van de wreedheid.

En hij lachte niet.

En mevrouw van Eboli ontving hem, uit vrees en geenszins uit liefde.




XLII.

De lucht was warm: van de kalme zee woei geen het minste
windeken. Nauwelijks trilden de bladeren der boomen aan de vaart van
Damme; de krekelen bleven in de meerschen, terwijl, in de velden,
de bedienden der kerken en abdijen het dertiende van de oogsten
ophaalden, ten profijte van papen en abten. Uit de hoogte van den
vurigen, diepen, blauwen hemel overstroomde de zonne het aardrijk
met haar gloed, en de Natuur sliep onder de zonnestralen als een
dartel meideken, dat trilt onder de kussen van beuren geliefde. De
karpers sprongen boven het water naar de vliegen, die gonsden als
een kokende ketel, terwijl de zwaluwen, met heur lang lijf en groote
vleugelen, hun hunne prooi betwistten. Uit de aarde steeg een warme,
vochtige damp omhoog, die schitterde in 't licht. Van op den toren
van Damme liet de koster, door middel eener gebarsten klok, die klonk
als een ketel, den veldarbeiders weten dat het middag was, en tijd om
te gaan eten. De vrouwen brachten heure twee handen trechtergewijze
aan heuren mond om heure mannen en broeders te roepen: Hans, Pieter,
Dokus; en boven de menigte zag men heure roode huiken uitsteken.

Lamme en Uilenspiegel zagen, in de verte, den hoogen, vierkanten,
zwaren toren van Onze-Lieve-Vrouwekerk verrijzen.

Lamme sprak:

--Daar, mijn zoon, daar zijn uwe smerten en uwe minne.

Doch Uilenspiegel antwoordde niet.

--Weldra, sprak Lamme nogmaals, zijn wij aan mijn oude woning en wie
weet of ik daar mijne vrouw niet zie.

Doch Uilenspiegel antwoordde niet.

--Houten man, zeide Lamme, steenen hert, kan niets u dan bewegen,
noch de nadering van het plekje, waar gij leefdet als kind, noch de
dierbare schimmen van den armen Klaas en de arme Soetkin, de beide
martelaren? Hoezoo! gij zijt weemoedig noch blijde van zin; wie dan
heeft aldus alle gevoel uit uw herte gerukt? Aanschouw mij, zie hoe de
angst, de aandoening mijn hert in mijnen buik doen schokken; bezie mij.

Lamme keek op naar Uilenspiegel; hij zag hem met een bleek gezicht,
met gebogen hoofd, met trillende lippen, sprakeloos weenen.

En hij zweeg.

Zonder nog een woord te wisselen, reden zij voort naar Damme;
zij kwamen de stad langs de Reigerstraat binnen, doch zij zagen
niemand, ter oorzake van de hitte. De honden lagen op hunne zijde,
met hangende tong, voor de zullen der deuren. Lamme en Uilenspiegel
gingen dicht tegen het Schepenhuis, rechtover hetwelk Klaas verbrand
werd; Uilenspiegel's lippen beefden heviger, doch hij weende niet
meer. Toen hij noesch over het huis kwam van Klaas, dat nu bewoond
was door een meester-koolbrander, ging hij er binnen, zeggende:

--Herkent gij mij? Hier wil ik rusten.

De meester-koolbrander sprak:

--Ik herken u; gij zijt de zoon van het slachtoffer. Doe alsof gij
thuis waart in deze halle.

Uilenspiegel ging in de keuken, vervolgens in de kamer van Klaas en
van Soetkin en weende.

Toen hij terug beneden was, zeide de meester-koolbrander tot hem:

--Hier is brood, kaas en bier. Eet als gij honger, drink als gij
dorst hebt.

Uilenspiegel deed teeken met de hand, dat hij honger noch dorst had.

Toen ging hij voort met Lamme, die schrijlings op zijnen ezel bleef,
terwijl Uilenspiegel den zijnen bij den halster geleidde.

Zij kwamen aan de hut van de uitzinnige Katelijne, bonden hunne ezelen
vast en gingen binnen. Het was het etensuur. Op de tafel stond eene
pateel prinsessenboonen, ondereengestoofd met boerenteenen. Katelijne
was aan 't eten, terwijl Nele recht stond met de sauspan in de hand,
gereed om saus te gieten in Katelijne's teil.

Toen Uilenspiegel binnentrad, was zij zoo ontroerd, zoo aangedaan,
dat zij de sauspan met heel den inhoud in de teil van Katelijne
liet vallen. De uitzinnige schuddebolde, zocht met heuren lepel de
boerenteenen uit, rondom de sauspan; zij sloeg op heur voorhoofd
en sprak:

--Doe het vuur weg! mijn hoofd brandt.

De reuk van de azijnsaus streelde Lamme's neus; de dikke man was in
verzoeking gebracht.

Uilenspiegel bleef staan en, in zijn groote droefheid, bezag hij Nele
met een teederen, liefderijken glimlach.

En zonder een woord tot hem te richten, vloog Nele hem om den hals. Zij
ook scheen waanzinnig; zij weende, lachte, en zeide enkellijk,
blozend van zoet en innig genoegen:

--Thijl! Thijl!

Uilenspiegel, gelukkig, kon zijne oogen niet wenden van zijne geliefde,
die zich eensklaps zachtjes losmaakte en eenen stap achteruitweek,
om hem beter te bezien; en opnieuw vloog zij blijde om zijnen hals en
drukte hem tegen heure borst, en dit herhaalde reizen achtereen. Zalig
van geluk, hield hij ze vast, zonder van heur te kunnen scheiden,
totdat zij, moede en als waanzinnig, op eenen stoel nederviel; en
zonder verlegenheid zeide zij:

--Thijl! Thijl! mijn geliefde, ge zijt dus terug!

Lamme stond nog steeds nabij de deur; toen Nele's aandoening een
weinig gestild was, bemerkte zij hem en sprak zij:

--Waar heb ik dien dikzak nog gezien?

--Het is mijn vriend, antwoordde Uilenspiegel. In mijn gezelschap
zoekt hij zijn wettige vrouw.

--Nu herken ik u, zeide Nele tot Lamme; gij hebt gewoond in de
Reigerstraat. Gij zoekt uwe vrouw; ik heb ze gezien te Brugge, alwaar
zij godvruchtig en devotelijk leeft. Ik heb heur gevraagd waarom zij
zoo wreedelijk heuren man had verlaten, en zij gaf mij tot antwoord:
"Dus was de heilige wil Gods, maar voortaan mag ik met hem niet
meer wonen".

Lamme werd droevig gestemd bij die rede en keek begeerig naar de
prinsessen met azijnsaus. En de leeuweriken zongen en verhieven
zich hoog in den hemel en de smachtende Natuur liet zich kussen door
het warme zonnelicht. En Katelijne stak met heuren lepel, rondom de
sauspan naar de boerenteenen en naar de prinsessen.




XLIII.

Omtrent dien tijd ging een meideken van vijftien jaar alleen in vollen
dag van Heist naar Knokke, langs het duin. Niemand koesterde de minste
vrees voor heur, want men wist, dat weerwolven en verdoemde zielen
alleen uitgaan en bijten des nachts. Zij droeg, in eene tassche,
acht en veertig zilveren stuivers, wat vier karolusgulden uitmaakt,
die heure moeder Tonia Pietersen, woonachtig te Heist, schuldig was,
wegens eene verkooping, aan heuren oom Jan Rapen, woonachtig te
Knokke. Het meideken, Betkin genaamd, had heure beste kleederen aan,
en was blij te moede vertrokken.

's Avonds was Betkin nog niet thuis en heure moeder werd ongerust;
doch daar zij ten slotte onderstelde, dat ze bij heuren oom was
gebleven, bedaarde zij.

Visschers die, met een goede vangst van de zee kwamen, trokken 's
anderen daags hunne boot op het strand, en losten hunne visch in
karren om ze aan de meestbiedenden te doen verkoopen te Heist, in de
mijn. Zij klommen den weg in het schelpzand op, en vonden, in het duin,
een naakt meideken liggen, dat gansch uitgeschud was, tot zelfs van
heur hemde ontdaan, en rondom heur lag bloed. Nader gekomen, zagen zij,
in heuren armen gebroken nek, het merk van lange, scherpe tanden. Het
slachtoffer lag op den rug, met de oogen wijd open naar den hemel,
met den mond insgelijks open, alsof het nog om hulp wou roepen.

Zij bedekten het lichaam van het meideken met een opperste kleed en
droegen het naar Heist, naar het Schepenhuis. Weldra kwamen aldaar
de schepenen en de chirurgijn-baardemaker bijeen, dewelke laatste
verklaarde, dat die lange tanden geenszins wolfstanden waren, zooals
de Natuur die gemaakt heeft, maar wèl die van een boozen, helschen
weerwolf, en dat men God diende te bidden om Vlaanderenland van dat
gedrocht te verlossen.

En, heel het graafschap door, en vooral te Damme, Heist en Knokke,
werden openbare gebeden bevolen.

En men zag het volk jammerend de kerken afloopen.

En in de kerk van Heist, in dewelke het lijk van het meideken ten
toon gesteld was, schreiden mannen en vrouwen, als zij den bloedigen,
verscheurden nek van het slachtoffer zagen.

En de moeder zei in de kerk zelve:

--Ik wil naar den weerwolf gaan en hem vaneenscheuren met mijne tanden.

En weenend hitsten de vrouwen heur in heur voornemen op. Sommigen
zeiden nochtans:

--Gij zoudt niet levend terugkomen.

En zij ging met heuren man en heure beide broeders--alle vier goed
gewapend--den wolf zoeken langs strand, duin en dal, maar zij vonden
hem niet. En heur man moest heur terugbrengen naar huis, want door
de nachtelijke koude had zij de koorts gekregen; en zij waakten bij
heur bed terwijl zij hunne netten herstelden.

Overwegende, dat de weerwolf een beest is dat leeft van bloed, doch
geenszins de dooden besteelt, meende de baljuw van Damme, dat het
ondier zekerlijk moest gevolgd zijn door diepers, die, voor hun snood
gewin, rondzwierven langs het strand. Dienvolgens liet hij uitbellen,
dat hij een iegelijk gelastte en beval, goed gewapend met bussen,
stokken en anderszins, op zoek te gaan, en alle schooiers en diepers
te vatten en af te tasten, om te zien of in hunne gordeltasschen
geen gouden karolussen staken of geenerlei stuk van de kleeding van
de slachtofferen. En nadien zouden de gezonde en sterke schooiers
en diepers op de galeien des konings worden gebracht. En de oude en
gebrekkelijke zou men laten gaan.

Doch men vond niets, dat licht in de zaak bracht.

Uilenspiegel ging tot den baljuw en sprak:

--Ik wil den weerwolf dooden.

--Wat geeft u vertrouwen? vroeg de baljuw.

--De assche klopt op mijn hert, antwoordde Uilenspiegel. Geef mij de
toelating in de gemeentesmidse te werken.

--Gij moogt, sprak de baljuw.

Zonder tot een man of eene vrouw van Damme een woord over zijn ontwerp
te spreken, trok Uilenspiegel naar de smidse en verveerdigde daar,
in 't geheim, eene schoone en groote val om wilde dieren te vangen.

Den volgenden dag, een Zaterdag, de geliefkoosde dag van de weerwolven,
toog Uilenspiegel henen met eenen brief van den baljuw voor den
parochiepaap van Heist, en met de val onder zijnen mantel; overigens
was hij gewapend met een goede bus en een scherp, versch aangezet
kruismes; in 't heengaan zei hij tot die van Damme:

--Ik ga op jacht naar de meeuwen en zal met haar dons oorkussens
maken voor mevrouw van den baljuw.

Naar Heist stappend, langs het duin, hoorde hij de woedende baren
der zee, die schuimend kwamen botsen op de kust, met een gedruisch
als van den donder, en den wind, die uit Engeland woei en die huilde
in het want van de gestrande schuiten.

Een schipper zei tot hem:

--Die kwade wind doet ons nadeel. Verleden nacht was de zee kalm,
doch na zonsopgang rees zij eensklaps woedend omhoog. Wij zullen niet
kunnen in zee steken.

Uilenspiegel was er blijde om, want aldus was hij zeker des nachts
hulp te krijgen, als zulks noodig mocht zijn.

Te Heist ging hij naar den pastoor, denwelken hij den brief van den
baljuw bestelde.

De parochiepaap zeide tot hem:

--Gij zijt een moedige kerel; edoch ik moet u zeggen, dat niemand
's Zaterdagavonds langs het duin gaat, zonder gebeten, en dood in
het zand gevonden te worden. De dijkwerkers en andere arbeidslieden
wachten steeds op elkaar en begeven zich maar bij troepen op weg. De
avond valt. Hoort gij in het duin den weerwolf huilen? Zal men weeral,
lijk gisteren, heel den nacht door, zijn schor gehuil hooren weergalmen
op den akker der dooden? God zij met u, mijn zoon, maar doe het niet.

En de paap maakte het teeken des kruises, en zegende hem.

--De assche klopt op mijn hert, antwoordde Uilenspiegel.

De pastoor sprak:

--Mits gij zoo'n kloekmoedige wilskracht hebt, zal ik u helpen.

--Heer pastoor, sprak Uilenspiegel, gij zoudt mij en het arme
geteisterde land grootelijks van dienst zijn, zoo gij bij Tonia, de
moeder van het slachtoffer, en ook bij heure twee broeders wildet
gaan, en hun zeggen, dat de wolf in de nabijheid is en dat ik hem
wil afwachten om hem te dooden.

De parochiepaap sprak:

--Als gij niet weet welken weg gij moet nemen, begeef u op dien, welke
leidt naar het kerkhof. Hij loopt tusschen twee groene hagen. Twee
mannen zouden er naast elkander niet kunnen gaan.

--Daar zal ik zijn, antwoordde Uilenspiegel. En gij, messire dappere
pastoor, gelast en beveel aan de moeder van het meideken, aan heuren
man en aan heure broeders zich, vóór de slaapklok, goed gewapend
in de kerk te bevinden. Als zij mij hooren fluiten lijk de meeuw,
is dit het teeken, dat ik den weerwolf gezien heb. Dan moeten zij
de wacharmklok luiden en mij ter hulp snellen. Hebt gij ook eenige
andere wakkere mannen?

--Neen, mijn zoon, antwoordde de pastoor. De visschers vreezen den
weerwolf meer dan pest en dan dood. Maar doe het niet....

Uilenspiegel antwoordde:

--De assche van Klaas klopt op mijn hert.

Toen zei de paap:

--Ik zal doen wat gij vraagt, wees gezegend. Hebt gij soms honger
of dorst?

--Beide, antwoordde Uilenspiegel.

De pastoor gaf hem bier, brood en kaas.

Uilenspiegel at en dronk; en hij toog henen.

Onderwege hief hij de oogen op; hij zag Klaas, zijn vader, in
glorie naast God in den hemel, in denwelken de heldere maan glom,
en vervolgens zag hij naar de zee en de wolken, en hoorde hij den
loeienden wind, die uit Engeland blies.

--Laas! sprak hij, zwarte wolken, die voorbijrennen in het nachtelijk
duister, weest als de Wrake die den Moord achternazet. Loeiende zee,
pikdonkere hemel; bruisend water, dat driftig, grammoedig rolt of
woest omhoog slaat, of in branding schuimend en spattend breekt op
het strand; zwarte zee, in rouw gehulde hemel, komt mij ter hulp in
mijnen strijd tegen den weerwolf, den vuigen moordenaar van onschuldige
meidekens. En gij, wind, die klagend huilt in de bremstruiken van
het duin en in het want van de schepen, gij zijt de stem van de
slachtofferen, die roepen om wrake bij den Heer, dewelke mij helpe
in mijne onderneming!

En waggelend op zijne beenen, alsof zijn hoofd honderd pond woog en
zijne maag overlast was, daalde hij neer van het duin.

Wankelend stapte hij voort met een slepend lied op de lippen, dat
hij elk oogenblik onderbrak om te hikken, te geeuwen, te spuwen. Van
tijd tot tijd bleef hij staan en gebaarde hij over te geven, doch
in werkelijkheid opende hij goed de oogen, om rondom zich alles
oplettend gade te slaan. Eensklaps hoorde hij een schor geluid; hij
bleef staan om te spugen als een hond, en, bij het licht der rijzende
maan, onderscheidde hij de gedaante van eenen wolf, die sloop naar
het kerkhof.

Waggelend sloeg Uilenspiegel het pad in, tusschen de groene hagen. Daar
gebaarde hij neder te vallen, doch 't was om de val te plaatsen langs
den kant, van denwelken de wolf kwam: hij wapende vervolgens zijne
bus en ging tien stappen verder staan in de houding eens dronkaards,
en gedurig veinsde hij te waggelen, te hikken, te braken, doch
werkelijk spande hij zijnen geest als een boog, opende de oogen en
spitste de ooren.

En niets zag hij dan de zwarte wolken, die als waanzinnig renden
door 't luchtruim, en een dikke korte en zwarte gedaante, die op hem
afkwam; en niets hoorde hij dan de wind, die kreunend huilde, de zee,
die als de donder rolde, en den weg van schelpzand, die kraakte onder
een zwaren, huppelenden stap.

Uilenspiegel veinsde zich te willen nederzetten en liet zich, als
een dronkaard, zwaar op den weg vallen. En hij braakte.

Daar hoorde hij ijzerwerk knarsen, op een paar stappen van zich,
dadelijk daarna het gerucht van de val, die toesloeg, en den gil van
een mensch.

--De weerwolf, sprak hij bij zich zelven, is met de voorpooten gevangen
in de val. Huilend richt hij zich op; hij schudt de val heen en weer
om te ontvluchten. Maar ontsnappen zal hij niet. En hij schoot zijne
bus af naar zijne beenen.

--Getroffen, sprak hij, want gekwetst valt hij neder!

En hij floot als de zeemeeuw.

Plotseling begon de klok van de kerk wacharm te luiden, en riep de
schelle stem van een knaapje in 't dorp:

--Wordt wakker, gij allen, die slaapt; de weerwolf is gevangen!

--Hoezee! God zij gedankt! sprak Uilenspiegel.

Tonia, de moeder van Betkin, Lansaem, heur man, Judocus en Michiel,
heure broeders, kwamen het eerst met hunne lanteernen.

--Hebt gij hem vast? vroegen zij.

--Ziet maar, daar ligt hij op den weg, antwoordde Uilenspiegel.

--God zij gedankt! spraken zij.

En zij maakten het teeken des kruises.

--Wie is daar aan 't luiden? vroeg Uilenspiegel.

Lansaem antwoordde:

--Mijn oudste zoon; de jongste loopt het dorp rond, om de menschen
op te kloppen en te roepen, dat de wolf gevangen is. Heil U!

--De assche klopt op mijn hert, antwoordde Uilenspiegel.

Plotseling begon de weerwolf te spreken en zeide hij:

--Heb medelijden met mij, Uilenspiegel, heb medelijden.

--De wolf spreekt, zeiden allen een kruis slaande. Hij is de duivel,
want reeds kent hij Uilenspiegel's naam.

--Heb medelijden, medelijden, smeekte de stem, zeg aan die klok van
te zwijgen; zij klept als de doodklok; medelijden, ik ben de wolf
niet. Mijne polsen zijn doorgesneden in de val; ik ben oud en ik
bloed, medelijden! Welk schelle kinderstem hoor ik daar het dorp
wakker maken? Medelijden!

--Ik herken uwe stem, ik heb ze vroeger gehoord, sprak Uilenspiegel
onstuimig. Gij zijt de vischverkooper, de moordenaar van Klaas, de
bloedzuiger der arme meidekens. Mannen en vrouwlieden, weest zonder
vrees; 't is de deken, die Soetkin deed sterven van smerte.

En met eene hand hield hij hem bij den nek, onder de kin, terwijl
hij met de andere zijn kruismes trok.

Maar Tonia, de moeder van Betkin, hield hem tegen en riep:

--Neem hem levend gevangen.

En met klissen trok zij zijn grijze haren uit, terwijl zij zijn
aangezicht met heure nagelen doorwoelde.

En zij huilde van droefheid en woede.

Met de handen gevat in de val, en kronkelend ter oorzake van de hevige
smert, riep de weerwolf:

--Hebt medelijden, hebt toch medelijden; o, die vrouw, doet ze
weggaan. Ik zal twee gouden karolussen geven. Breekt die klokken! Waar
zijn die tierende kinderen?

--Houdt hem levend! schreeuwde Tonia, houdt hem levend, hij moet het
betalen. De doodklokken kleppen voor u, moordenaar. Met zacht vuur,
met gloeiende tangen! Houdt hem levend! dat hij betale!

Intusschen stiet Tonia tegen een voorwerp, dat op den grond lag;
zij bukte zich en raapte een wafelijzer op. Toen zij het bekeek
bij den gloed van de toortsen, zag zij, naar de Brabantsche wijs,
diepe ruitjes in de ijzeren platen, maar daarenboven was het bezet met
lange en scherpe tanden, als een ijzeren muil. En als zij het toedeed,
was het als de muil van een wolfshond.

Tonia hield toen het wafelijzer vast, opende het en sloot het
beurtelings, en deed daarbij het ijzerwerk knarsen. En ze scheen
waanzinnig en, razend en knarsetandend, reutelend als eene zieltogende,
zuchtend van de bittere smert, die dorstte naar weerwraak, beet zij
met het ijzer den gevangene in zijne armen, in zijne beenen, in zijn
lijf, overal, doch vooral in den nek; en telkens dat zij het ijzer
toedrukte, sprak zij:

--Zoo deed hij met Betkin, met de ijzeren tanden. Hij betale. Bloedt
gij, moordenaar? God is rechtveerdig. Hoor maar de doodklok. Betkin
roept om gewroken te worden. Voelt gij de tanden? 't Zijn de tanden
van God!

En zij beet zonder ophouden of medelijden, en sloeg met het wafelijzer,
als zij er hem niet mee kon bijten. Maar gedreven door heur groote
begeerte naar wraak, doodde zij hem niet.

--Genade, schreeuwde de vischverkooper, Uilenspiegel, steek mij dood
met uw kruismes, stel aan mijn lijden een einde. Smijt die vrouw
weg. Breek de klokken. Dood de kinderen, die schreeuwen!

En Tonia folterde hem zonder ophouden, totdat een oud man medelijden
kreeg en heur het wafelijzer ontnam.

Maar toen spugde Tonia den weerwolf in het gezicht en trok ze zijne
haren uit, zeggende:

--Gij zult betalen, met zacht vuur, met gloeiende tangen: uwe oogen
zal ik met mijne nagelen uitrukken!

Intusschen waren al de visschers, boeren en vrouwlieden van Heist
bijgekomen, als zij vernomen hadden, dat de weerwolf geen duivel,
maar een man was.

Eenigen droegen lanteernen en toortsen. En allen riepen:

--Dief en moordenaar, waar hebt gij het goud weggestoken, dat gij
den armen slachtofferen ontroofdet? Hij moet alles teruggeven!

--Ik heb geen goud; hebt medelijden! smeekte de vischverkooper.

En de vrouwlieden smeten zand en steenen naar hem.

--Hij betale! hij betale! schreeuwde Tonia.

--Medelijden, zuchtte hij, ik ben druipend van het bloed, dat gutst
uit mijn wonden.

--Uw bloed, sprak Tonia. O, gij moet er houden voor de hand van den
beul. Hij moet sterven met zacht vuur, zijne hand afgekapt worden,
met gloeiende tangen genepen! Hij zal betalen, hij zal betalen.

En zij wilde hem slaan; doch zij viel buiten kennis op het zand als
eene doode; en men liet heur daar liggen totdat zij terug tot zich
zelve kwam.

Intusschen had Uilenspiegel de handen van den gevangene uit de val
verlost, en toen zag hij, dat drie vingeren ontbraken aan zijne
rechterhand.

En hij beval hem stevig te knevelen en in eene vischmand te
binden. Mannen, vrouwlieden en kinderen togen toen henen naar Damme,
en droegen onderwege beurtelings de benne met haar verachtelijke
vracht. En anderen droegen lanteernen en toortsen.

En de vischverkooper zei gedurig:

--Breekt de klokken, doodt de kinderen, die schreeuwen.

En Tonia sprak:

--Hij betale, met zacht vuurken, met gloeiende tangen, hij betale!

En dan weer zwegen beiden. En Uilenspiegel hoorde niets meer dan den
jagenden adem van Tonia, den zwaren stap van de mannen op het krakende
zand en de zee, die rolde als de donder.

En, met treurig hert, zag hij naar de wolken, die, als waanzinnigen,
elkander achternazetten in den hemel; naar de zee, waar de branding
zich als lichtende schaapkens vertoonde, en, bij den gloed van
lanteernen en toortsen, naar het doodsbleeke gelaat van den
vischverkooper, dewelke hem bezag met valschheid en wraaklust.

En de assche klopte op zijn hert.

En in vier uren gingen zij naar Damme, alwaar het gemeen reeds te
hoop geloopen was, daar het de tijding reeds kende. Allen wilden
den vischverkooper zien en volgden de visschers al dansend, zingend
en roepend:

--De weerwolf is gevangen; hij is gepakt, de moordenaar! Gezegend
zij Uilenspiegel! Lang leve onze broeder Uilenspiegel!

En er was veel beweging onder het gemeeen.

Toen zij aan 't huis van den baljuw waren, kwam deze vóór op het
gerucht en zei tot Uilenspiegel:

--Gij zijt overwinnaar! Heil u!

--De assche van Klaas klopte op mijn hert, antwoordde Uilenspiegel.

Toen sprak de baljuw:

--Gij krijgt de helft van de nalatenschap des moordenaars.

--Geef dat aan de slachtofferen, antwoordde Uilenspiegel.

Lamme en Nele kwamen nader; lachend en weenend van geluk, kuste Nele
heuren vriend Uilenspiegel; Lamme sprong log als een beer omhoog en
klopte op den buik van zijn vriend, zeggende:

--Dat is een brave, koene en trouwe gezel; 't is mijn vriend,
mijn spitsbroeder: zulke vrienden hebt gij niet, gijlieden van
't platteland.

Maar de visschers lachten en spotten met hem.




XLIV.

De burgstorm luidde 's anderen daags, om den baljuw, de schepenen
en de griffiers ter vierschaar te roepen op de banken van graszoden,
rond den boom der justitie, dewelke een schoone lindeboom was.

En rondom stond het gemeen.

De vischverkooper, ondervraagd, wilde niets belijden, zelfs niet
wanneer men hem de drie vingeren toonde, die de soldaat afgekapt had,
en die aan zijne rechterhand ontbraken. Hij antwoordde steeds:

--Ik ben arm en oud, hebt medelijden met mij!

Maar het gemeen jouwde hem uit en riep:

--Gij zijt een oude wolf, een moordenaar van onschuldige kinderen. Geen
medelijden, heeren rechters!

De vrouwlieden spraken:

--Ge moet ons niet bezien met uwe ijskoude oogen; gij zijt een man en
geen duivel: wij vreezen u niet. Wreedaardig beest, lafhertiger dan
eene kat die de vogeltjes in hun nestje opvreet, dooddet gij de arme
meidekens, die niets vroegen dan in braafheid hun liefelijk leven
te slijten.

--Hij betale, hij betale met zacht vuur, met gloeiende tangen,
riep Tonia.

En, hoewel de serjanten van de gemeente het heur verboden, hitsten
de moeders heure knapen en meidekens op, om steenen te werpen naar
den vischverkooper. En dezen deden het: en telkens dat hij hen bezag,
jouwden zij hem uit, en gedurig riepen zij:

--Bloedzuiger! bloedzuiger! slaat dood!

En gedurig riep Tonia:

--Hij betale met zacht vuur, met gloeiende tangen, hij betale!

En het volk morde.

--Ziet eens, zeiden de vrouwen tot elkander, hij heeft koude onder
de heldere zon, die gloort aan den hemel, en kan zijn witte haren of
zijn vaneengereten gezicht niet verwarmen.

--Hij siddert van smerte!

--'t Is de rechtveerdigheid Gods!

--Ziet eens hoe jammerlijk hij zich recht houdt!

--En zijne moordenaarshanden, van voren gebonden, bloeden ten gevolge
van het prangen der val.

--Hij betale, hij betale! schreeuwde Tonia.

En jammerend zuchtte hij:

--Ik ben arm, laat mij gaan.

En iedereen, tot zelfs de rechters, dreef den spot met hem. Toen
veinsde hij te weenen om het volk te vermurwen. Maar de vrouwen
lachten.

Gezien de genoegzame gronden tot torture, werd hij veroordeeld om op
de pijnbank te worden gezet, totdat hij zou bekennen hoe hij doodde,
van waar hij kwam, waar de kleederen van zijn slachtofferen waren,
en de plaats, waar hij zijn geld verborg.

Toen hij, met de te smalle nieuwlederen schoenen aan de voeten,
in de folterkamer gebracht werd, vroeg de baljuw hem, hoe Satan hem
beroerd had zulke afgrijselijke misdaden te bedrijven; hij antwoordde:

--Ik zelf ben Satan, want ik gelijk hem in alles. Reeds toen ik zeer
klein was,--ik was leelijk en schraal en onbehendig in alle spelen
en lichaamsoefeningen,--aanzag een iegelijk mij voor eenen onnoozele,
en werd ik dikwijls geslagen. Knapen, noch meidekens hadden medelijden
met mij. Jongeling geworden, wilde geenerlei meideken weten van mij,
zelfs niet mits betaling. Toen vatte ik wrok en haat op tegen een
iegelijk wezen, dat komt van de vrouw. Daarom kloeg ik Klaas aan, dien
een ieder beminde. En ik beminde alleenlijk Munt, die mijn witte of
goudgele gezelline was; met Klaas te doen sterven, vond ik profijt en
plezier. Nadien moest ik, meer nog dan vroeger, leven als een wolf,
en ik droomde van te bijten. Op reize door Brabant, zag ik er de
wafelijzers van dat land en zei ik bij mij zelven, dat een dergelijk
ijzer mij zou kunnen dienen als een ijzeren muil. Ha! had ik u bij
den kraag, gij allen, boosaardige tijgers, die genoegen schept in de
folteringen eens grijsaards! Ik zou u bijten met nog meerder genoegen
dan den soldaat en het meideken. Want, als ik heur op het zand, in
de zonne zoo liefelijk zag slapen met het zakje geld in de handen,
maakten liefde en medelijden zich meester van mij; doch daar ik te
oud ben en het kind niet kon nemen, beet ik het met de ijzeren tanden.

De baljuw vroeg hem waar hij woonde; de vischverkooper antwoordde:

--Te Ramskapelle; van daar ga ik naar Blankenberge, naar Heist,
ja zelfs naar Knokke. Op Zon- en kermisdagen bak ik, met dat ijzer,
wafelen naar de wijs van die van Brabant. Het was altijd zuiver en goed
gesmeerd. En in al de dorpen werd die nieuwigheid uit vreemde gewesten
zeer goed onthaald. En als het u belieft nog meerder te weten, en hoe
het komt, dat niemand mij kon herkennen, zal ik u zeggen, dat ik mijn
aangezicht wit en mijne haren ros verfde. Wat de wolfshuid betreft,
dewelke gij mij toont met uw wreeden, ondervragenden vinger, die komt
van twee wolven, die ik gedood heb in de bosschen van Raveschoot en
Maldegem. Ik had de vellen maar aaneen te naaien om er mij mede te
bedekken. Ik verborg ze in eene kist in het duin van Heist; daar ook
zijn de kleederen, gestolen door mij, om ze later te verkoopen bij
een goede gelegenheid.

--Trek hem van voor het vuur weg, sprak de baljuw.

De beul gehoorzaamde.

--Waar is uw goud? vroeg nog de baljuw.

--De koning zal het niet weten, antwoordde de vischverkooper.

--Brand hem van dichtbij met de vlammende keersen, sprak de
baljuw. Breng hem dichter bij het vuur.

De hangman gehoorzaamde en de vischverkooper schreeuwde:

--Ik zal niets belijden. Ik sprak reeds te veel: gij zult mij
verbranden. Ik ben geen tooveraar: waarom plaatst gij mij bij het
vuur? Mijn voeten bloeden ten gevolge van de brandwonden. Ik zal niets
zeggen. Waarom nu nog dichter? Zij bloeden, zeg ik u, zij bloeden;
die schoenen zijn van gloeiend ijzer gemaakt! Mijn goud? welnu, mijn
eenige vriend op deze wereld is ... trek mij weg van het vuur; het
is in mijnen kelder te Ramskapelle, in eene doos ... laat mij gaan;
genade, ontferming, heeren rechters; vermaledijde hangman, neem de
keersen weg.... Hij brandt mij nog meerder ... het ligt in eene doos
met dubbelen bodem en is gewikkeld in een wollen deken, opdat het
niet rammelen zou, als men de doos schudt; nu heb ik alles gezegd,
breng mij weg van het vuur!

Als hij van vóór het vuur werd geschoven, lachte hij valschelijk.

De baljuw vroeg hem waarom hij lachte.

--Van genoegen, omdat ik verlost ben, antwoordde hij.

De baljuw zeide tot hem:

--Vroeg niemand u ooit om uw wafelijzer met wreede tanden te zien?

De vischverkooper antwoordde:

--Men zag, dat het een wafelijzer was, teenemaal gelijk aan de anderen,
behalve dat er gaten in waren, in dewelke ik's nachts de ijzeren tanden
vastschroefde; met den dageraad nam ik ze er uit; de boeren verkozen
mijne wafelen boven die van de andere kooplieden en hieten ze "wafelen
met Brabantsche knoopen", ter oorzake van de ledige holten,--waarin
de tanden geschroefd werden,--en dewelke kleine halfronden, die op
knoopen geleken, op de wafelen maakten.

Maar de baljuw vervolgde.

--Wanneer beet gij de arme slachtofferen?

's Nachts, en ook 's daags. 's Daags dwaalde ik langs het duin
en de groote wegen, met mijn wafelijzer steeds op den loer, maar
voornamelijk 's Zaterdags, de groote merktdag te Brugge. Zag ik een
boer voorbijkomen met een droevig gezicht, dan liet ik hem gaan,
want ik dacht, dat zijne droefgeestigheid te wijten was aan den staat
zijner beurze; doch ik bleef aanstappen naast dengene, die wel te moede
scheen; en als hij er zich het minst aan verwachtte, beet ik hem in
den nek, na hetwelk ik zijne beugeltasch nam. En niet alleenlijk in
het duin liep ik, maar langs alle wegen en paden van 't platteland.

Toen sprak de baljuw:

--Heb berouw en bid God.

Maar godslasterlijk antwoordde de vischverkooper:

--'t Is de Heer God, die wilde dat ik was wat ik ben: ik deed alles
ondanks mij zelven, beroerd door den wil der Natuur. Boosaardige
tijgeren, die mij onrechtveerdig wilt straffen! Maar veroordeelt mij
niet tot het vuur: ik deed alles ondanks mij zelven; hebt medelijden,
ik ben arm en oud; ik zal sterven van mijne wonden; verbrandt mij
toch niet!

Toen werd hij terug naar de vierschaar gebracht, onder den lindeboom,
om er het vonnis te hooren, in bijzijn van het vergaderde volk.

En als schromelijke moordenaar, dief en godslasteraar, werd hij
veroordeeld om de tong met een gloeienden priem doorstoken te worden,
de rechterhand afgekapt, en met een zacht vuur verbrand, totdat de
dood er op volge, vóór de pui van het Schepenhuis.

En Tonia riep:

--'t Is rechtveerdig, hij betale!

En het volk riep:

--Lang leven de Heeren van de Wet!

En hij werd terug naar het Steen gebracht, alwaar men hem vleesch en
wijn brengen kwam. En hij was blijde, zeggende, dat hij er tot dan
toe nooit had gegeten en gedronken, maar dat de koning, die zijne
goederen erfde, wel dien laatsten maaltijd mocht betalen.

En hij grijnslachte.

's Anderen daags, bij zonsopgang, toen men hem naar het schavot bracht,
zag hij Uilenspiegel omtrent den brandstapel staan; en hij riep,
met den vinger naar hem wijzend:

--Die dààr, die moordenaar van grijsaards, moet insgelijks sterven;
tien jaar geleden smeet hij mij te Damme in de vaart, omdat ik zijn
vader had aangeklaagd. Daardoor diende ik, als trouw onderdaan,
Zijne Katholieke Majesteit.

De klokken van Onze-Lieve-Vrouwekerk klepten.

--Voor u ook kleppen die klokken, sprak hij tot Uilenspiegel; gij
zult gehangen worden, daar gij gemoord hebt!

--De vischverkooper liegt, riepen die van 't gemeen; hij liegt,
de beul, de moordenaar!

En, als waanzinnig, smeet Tonia eenen steen naar hem, die hem kwetste
aan 't voorhoofd. En ze riep:

--Had hij u verdronken, ge zoudt niet geleefd hebben om mijn arm
dochterken te bijten lijk een bloedzuiger, die ge zijt!

Uilenspiegel uitte geen woord; Lamme sprak:

--Heeft iemand den vischverkooper in 't water zien smijten?

Uilenspiegel antwoordde niet.

--Neen, neen, riep het gemeen, hij heeft gelogen, de beul!

--Neen, ik heb geenszins gelogen, schreeuwde de vischverkooper, hij
wierp mij er in, terwijl ik hem om vergiffenis smeekte, en ik kon
er maar uitgeraken door middel van een schuitje, dat aan den oever
vastgemeerd lag. Doornat en bibberend, kwam ik met veel moeite naar
mijne armzalige hut, alwaar ik de koorts had, alwaar niemand mij
oppaste, terwijl ik tusschen leven en dood lag.

--Gij liegt, sprak Lamme, niemand heeft het gezien.

--Neen, niemand, riep Tonia. In 't vuur, met den beul! Alvorens te
sterven, wil hij nog een onschuldig slachtoffer maken; in 't vuur,
hij betale! Hij heeft gelogen! Belijd niet, Uilenspiegel, al mocht
het nog waar zijn. Er zijn geene getuigen. Hij betale met zacht vuur,
met gloeiende tangen!

--Bedreeft gij den moord? vroeg de baljuw tot Uilenspiegel.

Uilenspiegel antwoordde:

--Den aanklager, den moordenaar van Klaas, mijn vader, smeet ik in
't water. De assche klopte op mijn hert.

--Hij bekent, sprak de vischverkooper; hij zal insgelijks sterven? Waar
is de galg, dat ik ze zie? Waar is de beul met het zweerd der
justitie? De doodklok klept ook voor u, nietdeug, moordenaar van een
armen grijsaard.

Uilenspiegel sprak:

--Ik smeet u in 't water om u te dooden: de assche van mijn vader
klopt op mijn hert.

En in het volk spraken de vrouwen:

--Waarom het stuk bekend, Uilenspiegel? Niemand heeft het gezien;
nu zult gij sterven.

En de vischverkooper lachte, danste van bittere vreugde, zwaaide met
zijne armen, dewelke met bloedige doeken omwonden waren.

--Hij zal sterven, sprak hij, hij zal ter helle varen met een strop
om den hals, als dieper, rabauw en truwant: hij zal sterven; God
is rechtveerdig!

--Neen, hij zal niet sterven, sprak de baljuw. Na tien jaren wordt, in
Vlaanderenland, de moord niet meer gepunieerd. Uilenspiegel pleegde een
lakensweerdige daad, maar 't was uit kinderlijke liefde. Uilenspiegel
zal uit dien hoofde niet worden vervolgd.

--Leve de Wet! riep het volk. Lang leven de Heeren van de Wet!

De klokken van Onze-Lieve-Vrouwekerk klepten. En de vischverkooper
knarsetandde, boog het hoofd en weende zijn eersten traan.

En men kapte zijne hand af, en men doorstak zijne tong met een
gloeienden priem, en hij werd levend verbrand met zacht vuur, vóór
de pui van het Schepenhuis.

Als hij den dood nabij was, riep hij:

--De koning zal mijn goud niet hebben; ik heb gelogen ... Boosaardige
tijgeren, ik zal weerkomen om u te bijten.

En Tonia riep:

--Hij betale, hij betale! Zie hoe zijne armen en beenen, die naar den
moord liepen, wringen en smijten: het lichaam van den moordenaar rookt;
zijn wit haar, hyena's haar, brandt op zijn bleek gezicht. Hij betale,
hij betale!

En de vischverkooper huilde als een wolf.

En de klokken van Onze-Lieve-Vrouwekerk klepten.

En Lamme en Uilenspiegel stegen terug op hunne ezelen.

En de jammerende Nele bleef bij Katelijne, dewelke gedurig zeide:

--Doe het vuur weg! het hoofd brandt; kom terug, Hansken, mijn liefste.







VIERDE BOEK.


I.

Te Heist, op het duin zijnde, zagen Uilenspiegel en Lamme van Oostende,
Blankenberge, Knokke, menigvuldige visschersschuiten aankomen,
vol gewapende mannen, die, in navolging van de Zeeuwsche Geuzen,
een zilveren halve maan op hun hoed droegen met deze woorden: Liever
den Turc als den Paus.

Uilenspiegel was wel te moede; hij floot als de leeuwerik; allerwegen
antwoordde het strijdzuchtig gekraai van den haan.

De booten vaarden of vischten, verkochten hare vangst en landden de
eene na de andere te Emden. Daar huisde Willem van Blois, heer van
Treslong, die, op last van den prins van Oranje, een schip uitrustte.

Uilenspiegel en Lamme kwamen te Emden, terwijl op bevel van Treslong,
de booten der Geuzen weder in zee staken.

Treslong, die sedert elf weken te Emden was, verveelde zich diep. Hij
stapte van de boot op den wal en van den wal op de boot, als een
geketende beer.

Uilenspiegel en Lamme wandelden langs de kaaien en ontwaarden daar een
heer met een goede tronie, die er eenigszins droefgeestig uitzag en
druk bezig was met de steenen van de kaai uit te steken, door middel
van een breekijzer. Het ging niet gemakkelijk, doch met goeden moed
zette hij zich steeds opnieuw aan het werk, terwijl achter zijnen
rug een hond aan een been knaagde.

Uilenspiegel kwam naar den hond toe en gebaarde, dat hij hem zijn
been wilde afnemen. De hond bromde; Uilenspiegel scheidde niet uit:
de hond werd kwader en blafte en bromde uit al zijne macht.

De heer keerde zich om op dat gerucht, en zeide tot Uilenspiegel:

--Waarom moet gij dien hond plagen?

--Waarom, messire, moet gij de kasseien plagen?

--Dat is hetzelfde niet, sprak de heer,

--Het verschil is zoo groot niet, antwoordde Uilenspiegel: als de
hond aan zijn been houdt en het niet loslaten wil, houden de kasseien
ook aan de kaai en willen zij er aan blijven. En menschen van mijnen
stand mogen wel eenen hond plagen, als lieden van den uwen de straat
niet met rust laten.

Lamme stond achter Uilenspiegel en dorst geen woord uiten.

--Wie zijt gij? vroeg de heer.

--Ik ben Thijl Uilenspiegel, zoon van Klaas, die verbrand werd om
het geloof.

En hij floot als de leeuwerik en de heer kraaide als de haan.

--Ik ben admiraal Treslong, sprak hij; wat wilt gij van mij?

Uilenspiegel vertelde hem zijne lotgevallen en langde hem vijfhonderd
karolussen.

--Wie is die dikzak? vroeg Treslong, naar Lamme wijzend.

--Mijn gezel en mijn vriend, antwoordde Uilenspiegel: hij wil evenals
ik, op uw schip, de schoone stem van de donderbus begeleiden, en het
lied der verlossing van den grond onzer vaderen zingen.

--Gij zijt twee dappere kerels, zeide Treslong, gij moogt op mijne
boot inschepen.

Toen was men in de Sprokkelmaand: scherp was de wind en vinnig de
vorst. Na drie weken spijtig wachten, barstte Treslong's ongeduld uit
en verliet hij Emden. Daar hij Texel dacht binnen te varen, vertrok
hij van 't Vlie, maar hij was gedwongen Wieringen binnen te loopen,
alwaar zijn vaartuig omringd werd door 't ijs.

Weldra zag men een vroolijk schouwspel rondom het schip:
schaatsenrijders heel in de panne, schaatsende vrouwkens met wambuizen
en rokken met gouden, zilveren, scharlaken, hemelsblauwe borduursels;
gierende meidekens; en allen gingen, kwamen, joelden, gleden achter
elkander, of bij paren, terwijl zij op 't ijs een minnelied zongen:
ofwel trokken zij in kramen en tenten met wimpels versierd, om
brandewijn, appelsienen, vijgen, peperkoek, eieren, warme worsten,
heetekoeken en zuurtjes te drinken en te eten, terwijl rond henlieden
arre- en zeilsleden onder hare sporen het ijs deden krassen.

Lamme, steeds naar zijne vrouw zoekend, schaverdijnde in 't rond,
gelijk de lustige mannen en vrouwlieden, doch hij viel dikwijls op
zijn achterste.

Intusschen ging Uilenspiegel eten en drinken in een kleine taveerne
op de kaai, alwaar hij zijne portie niet duur moest betalen; en hij
bleef geerne praten met de oude bazinne.

Op een Zondag, rond negen uren, ging hij er binnen en vroeg hij
zijn eetmaal.

--Maar, sprak hij tot een aanvallige vrouw, die vóórkwam om hem te
dienen, wat deedt gij met uwe oude rimpelen? Uw mond heeft al zijn
witte en jeugdige tanden, en uwe lippen zijn als kersen zoo rood. Is
hij voor mij, die zoete, schalksche glimlach?

--Wel neen, zeide zij, maar wat wilt gij?

--U, sprak hij.

De vrouw antwoordde:

--Dat is te veel voor een spiering lijk gij; wilt gij ander vleesch?

Daar Uilenspiegel niet sprak, ging zij voort:

--Wat hebt gij gedaan, zeide zij, met dien schoonen, welgevormden,
dikken man, denwelken ik dikwijls bij u zie?

--Lamme? vroeg hij.

--Wat hebt gij er mee gedaan? vroeg zij.

Uilenspiegel antwoordde:

--Hij eet in de kramen, harde eieren, gerookte paling, gezouten visch,
zuurtjes en alles wat hij tusschen de tanden kan steken; dit alles
om zijne vrouw op te zoeken. Waarom zijt gij de mijne niet? Wilt gij
vijftig gulden van mij? Wilt gij een gouden halssnoer?

Maar zij maakte het teeken des kruises.

--Ik ben te verkoopen noch te nemen, zeide zij.

--Bemint gij niemand? vroeg hij.

--Ik bemin u als mijn evennaaste; maar vóór alles bemin ik Onzen
Lieven Heer en Zijne Moeder de Heilige Maria, die mij bevelen in
kuischheid mijn leven te slijten. Hard en zwaar zijn mijne plichten,
doch de Heer is ons, armen vrouwen, behulpzaam. Nochtans zijn er die
bezwijken. Is uw dikke vriend vroolijk van aard?

Uilenspiegel antwoordde:

--Als hij eet is hij blijde, anders is hij treurig gestemd, en altijd
zit hij in gedachten verzonken. Maar gij, zijt gij droefgeestig
of vroolijk?

--Wij, vrouwen, sprak zij, zijn slavinnen.

--Ik ga tot Lamme zeggen, dat hij u moet komen bezoeken.

--Doe dat niet, sprak zij; hij zou weenen en ik insgelijks.

--Zaagt gij ooit zijne vrouw? vroeg Uilenspiegel.

Zuchtend antwoordde zij:

Zij zondigde met hem en werd veroordeeld tot een wreede penitentie. Zij
weet, dat hij op zee gaat voor de zegepraal der ketterije; 't is droef
voor een kerstenhert dit te moeten denken. Verdedig hem, als men hem
aanvalt; verpleeg hem, als hij gewond is: zijne vrouw verzocht mij
u die bede te doen.

--Lamme is mijn vriend en mijn broeder, antwoordde Uilenspiegel.

--Ha! zuchtte zij, waarom keert gij beiden niet terug in den schoot
onzer Moeder, de Heilige Kerk!

--Die heure kinderen verbrandt, antwoordde Uilenspiegel.

En hij toog henen.

Daar de wind vinnig blies en het ijs maar immer dikker en sterker
maakte, kon het schip van Treslong niet vertrekken; de matrozen en
de soldaten vermaakten zich dus met sleden en schaatsen.

Uilenspiegel was in de taveerne en, jammerend en droevig, zei de
lieftallige gastvrouw tot hem:

--Arme Lamme! arme Uilenspiegel!

--Waarom beklaagt gij ons zoo zeer? vroeg Uilenspiegel.

--Laas! laas! zeide zij, waarom ook gelooft gij niet aan de
misse? Zeker gingt gij naar den hemel, en in deze wereld zou ik
vermogen u te redden.

Ziende, dat zij naar de deur ging en aandachtiglijk luisterde,
vroeg Uilenspiegel:

--Is 't de sneeuw niet, die gij hoort vallen?

--Neen, sprak zij.

--Luistert gij naar den wind, die huilt in het want?

--Neen, sprak zij nogmaals.

--Of naar het blijde gejuich van onze dappere matrozen in de naburige
herberg?

--De dood sluipt stil als een dief, zeide zij.

--De dood, zeide Uilenspiegel, ik begrijp u niet; kom binnen en spreek.

--Daar zijn ze, sprak zij.

--Wie?

--Wie? antwoordde zij. De soldaten van Simon Bol, die, in naam van
den hertog, u allen gaan vangen; zoo men u hier zoo goed behandelt,
is het om met u te doen als met de ossen, die men mest in de weide. Ha,
waarom, zeide zij, badend in tranen, waarom wist ik zulks niet vroeger?

--Houd op met uw gejank en geschreeuw, sprak Uilenspiegel, en blijf
hier!

--Verraad mij niet, sprak zij.

Uilenspiegel ging het huis uit, liep naar al de kramen en taveernen,
en fluisterde in het oor van de matrozen en de soldaten:

--De Spanjool komt!

Allen liepen naar het schip, bereidden in aller ijl al wat behoefde
voor het gevecht, en wachtten dan den vijand af.

Uilenspiegel zeide tot Lamme:

--Ziet gij die lieftallige vrouw daar, op de kaai, met heur zwarten
rok met scharlaken borduurselen, die heur gezicht met heur witte
huik verbergt?

--'t Is mij eender, antwoordde Lamme. Ik heb koude en zou willen
slapen.

En hij wikkelde zijn hoofd in zijn opperste kleed. En alzoo hoorde
hij niet meer dan een doove.

Toen herkende Uilenspiegel de lieftallige vrouw en, van op het schip,
riep hij heur toe:

--Wilt gij ons volgen?

--Tot in het graf, zeide zij, maar ik mag niet....

--Gij zoudt goed doen, sprak Uilenspiegel; bedenk toch: als de
nachtegaal in het bosch blijft, is hij gelukkig en zingt hij: maar
als hij het verlaat en zijne broze vleugelen waagt in den wind van
de wijde zee, breekt hij ze en sterft hij.

--Thuis heb ik gezongen, sprak zij, en buiten zou ik zingen, zoo ik
maar mocht.

Vervolgens het schip naderend, sprak zij:

--Neem, Uilenspiegel, neem dezen balsem voor u en uwen vriend, die
slaapt als hij diende te waken.

En henen gaande, riep zij:

--Lamme! Lamme! God hoede u voor het kwaad!

En zij liet heur gezicht zien.

--Mijne vrouw! mijne vrouw! riep Lamme.

En hij wilde op het ijs springen.

--Uw trouwe vrouw! zeide zij.

En zij liep heen.

Lamme wilde van het dek op het ijs springen, maar een soldaat hield
hem bij zijn opperste kleed en belette het hem. Hij weende, schreide,
smeekte, dat men hem zou laten vertrekken. Maar de provoost zeide hem:

--Als gij het schip verlaat, wordt gij gehangen.

Lamme wilde toch op het ijs springen, maar een oude Geus weerhield
hem en sprak:

--De vloer is nat, gij zoudt koude voeten krijgen.

En Lamme viel op zijn achterste, schreide en herhaalde gedurig:

--Mijne vrouw! mijne vrouw! laat mij bij mijne vrouw gaan!

--Gij zult ze wel weerzien, sprak Uilenspiegel. Zij bemint u, maar
ziet God liever dan u.

--'t Is een razende duivelin, riep Lamme. Als ze God liever ziet dan
heuren man, waarom komt ze dan liefelijk en streelend onder mijne
oogen? En als zij mij bemint, waarom verlaat ze mij steeds?

--Ziet men klaar in de donkere putten? vroeg Uilenspiegel!

--Laas! zuchtte Lamme, ik zal het besterven!

En bleek en droefgeestig bleef hij zitten op het dek.

Intusschen rukten de lieden van Simon Bol aan, met een machtig geschut.

Zij schoten naar het schip, dat hun antwoordde. En de kogels braken
het ijs in het ronde. En tegen den avond viel een warme regen.

De wind woei uit het Westen; de zee werd omstuimig onder het ijs en
hief het omhoog met ontzaglijke blokken, dewelke men zag opstaan en
neervallen met een eentonig gekrakkrak, niet zonder gevaar voor het
schip, dat, als de morgenstond de zwarte wolken verbrak, zijn linnen
vleugelen opensperde, als een vogel der vrijheid, en naar de vrije
zee stevende.

Daar zeilden zij naar de vloot van messire Willem Lumey, graaf van de
Mark, admiraal van Holland en Zeeland, die als dusdanig eene lanteerne
omhoog in de mast van zijn schip voerde.

--Bezie hem goed, Lamme, sprak Uilenspiegel; hij zal u niet sparen,
als gij met geweld het schip wilt verlaten. Hoort gij zijne stem
bulderen als de donder? Zie hoe groot en breed hij is, zie zijn hooge
gestalte! Aanschouw zijn groote handen met kromme nagelen. Zie zijn
ronde koele oogen: 't zijn arendsoogen en zijn langen, puntigen baard,
denwelken hij gezworen heeft te laten groeien totdat hij alle papen
en monniken opgeknoopt heeft, om de beide graven te wreken! Zie eens,
hoe wreed en geducht hij is; gewis doet hij u hangen, zoo gij voortgaat
met zuchten en klagen: Mijne vrouw! Mijne vrouw!

--Mijn vriend, antwoordde Lamme, wie van koorden spreekt voor zijn
evennaaste, draagt een hennepen kraag om den hals.

--Gij zult hem dragen vóór mij. Dat is mijn hertelijke wensch,
sprak Uilenspiegel.

--Aan de galg zal uwe vuile tong eene el lang uit uwen bek steken,
antwoordde Lamme.

En de beide vrienden proestten van 't lachen.

Dien dag kaapte het vaartuig van Treslong eene kog van Biscaye, die
geladen was met kwikzilver, stofgoud, wijn en specerijen. En het schip
werd geledigd tot het merg, bemanning en buit, als een osseschinkel
onder den tand van den leeuw.

Het was ook te dien tijde, dat de hertog den Nederlanden wreede,
afschuwelijke belastingen oplegde, en al de inwoneren, die erf of
have verkochten, tot betaling dwong van duizend op de tienduizend
gulden. En die last was bestendig. Alle hoegenaamde koopers en
verkoopers moesten aan den koning den tienden penning van de koopsom
betalen, wat het volk zeggen deed, dat de handelswaar, die binst
dezelfde week tienmaal verkocht werd, ganschelijk aan den koning kwam.

En alzoo gingen nering en hanteering naar Dood en naar Ondergang.

En de Geuzen namen den Briel, een versterkte plaats aan de zee,
die de Bakermat der Vrijheid genoemd werd.




II.

Men was in het begin van de Bloeimaand; de hemel was helder en het
vaartuig dobberde statig op de wateren. Uilenspiegel zong:


    De asch klopt op mijn hart.
    De beulen kwamen, sloegen
    Met dolk en vuur, geweld en zwaard.
    Vuil geld betaalt den vuigen spioen.
    In stêe van deugden, liefde en geloof,
    Heerschen verklikking en wantrouwen.
    De slachters dienen geslacht.
    Slaat op de krijgstrom.

    Leve de Geus! Slaat op de trom.
    De Briel is aan ons.
    Vlissingen ook, de sleutel der Schelde.
    De Heer is goed. Campveere is aan ons,
    Met Zeelands schutterij.
    We hebben kruit en lood en kogels,
    IJzeren kogels, gegoten kogels.
    De Heer is met ons, wie tegen?

    Slaat op den trommel. Zege en roem!
    Leve de Geus! Slaat op de trom.

    Het zwaard is getogen, harten hoog,
    Vuisten vast; het zwaard is getogen.
    Weg met den Tienden Penning, den nood, den dood!
    Ter galge de beul, ter galge de roover!
    Meineedig vorst wil het volk in oproer.
    Het zwaard is getogen voor ons rechten,
    Voor huis en have, voor vrouw en kinderen.
    Het zwaard is getogen. Slaat op de trom.

    Harten hoog, vuisten vast.
    Weg met den Tienden Penning, weg met snood pardoen.
    Slaat op de krijgstrom. Slaat op de trom.


... Ja, spitsbroeders en vrienden, ja, te Antwerpen, noesch over het
Schepenhuis, hebben zij een groot schavot opgericht, dat met rood
laken bekleed is; de hertog troont er op als een koning te midden van
staffieren en soldeniers. Hij wil goedgunstig glimlachen, doch trekt
slechts een afgrijselijk gezicht. Slaat op de trommel! Leve de Geus!

... Hij heeft kwijtschelding geschonken; zwijgt stille: zijn gulden
harnas flikkert in de zonne, de grootprovoost zit te peerd naast
den baldakijn; daar komt de heraut met zijn trommelaars; hij leest
algemeene kwijtschelding af voor al degenen, die niets misdeden;
de anderen zullen wreedelijk worden gestraft.

... Luistert spitsbroeders, hij leest het plakkaat, hetwelk, onder
straffe van beschuldiging van muitmakerij, de betaling van den tienden
en den twinstigsten penning beveelt.

En Uilenspiegel zong:


    Hertog, hoort ge de stem van het volk,
    't Geweldig rumoer? 't Is de zee die zwelt
    In 't zware gezwoeg der stormen.
    Geld genoeg, bloed genoeg,
    Nood genoeg. Slaat op de trom.

    't Is de klauw in de bloedende wonde,
    De diefstal na den moord. Moet ge ons goud
    Mengen met ons bloed om het te drinken?
    Wij stapten in de baan des plichts,
    Den koning getrouw. De koning is meineedig.
    Wij zijn van den eed ontslagen. Slaat op de krijgstrom.

    Hertog van Alva, bloedhertog,
    Zie kramen, en winkels gesloten,
    Zie brouwers, bakkers, kruideniers,
    Weigrend te venten om niet te betalen.
    Wie groet u langs den weg?
    Niemand. Voelt ge als een mist van pest
    Haat en smaad u omringen?

    De schoone grond van Vlaanderen,
    Het lustig land Brabánt,
    Treuren als kerkhoven.
    Waar vroeger, in tijden van vrijheid,
    Vedels zongen, pijpen schalden,
    Zijn stilte en dood.
    Slaat op de krijgstrom.

    Geen vrooe gezichten meer
    Van zingende vrijers en drinkebroers,
    Maar bleeke gelaten
    Van wie gelaten
    Wachten op 't zwaard van het onrecht.
    Slaat op de krijgstrom.

    Wie hoort nog in de taveernen
    Het lustig klinken der glazen,
    Of de helle stemmen der deernen,
    Bij benden zingend op straat?
    Brabánt en Vlaanderen, vreugdelanden,
    Zijn tranenlanden.
    Slaat op de rouwtrom.

    Grond der vaadren, verdrukte geliefde,
    Plooi niet onder den voet des moorders.
    Nijvere bijen, zwiert in zwermen
    Neer op de wespen van Spanje,
    Levend begravene vrouwen en dochters,
    Roept tot Christus: wraak!

    Dwaalt bij nacht in de velden; arme zielen,
    Roept tot God. De vuist trilt om te slaan.
    Het zwaard is getogen, hertog, we rukken uw ingewand uit
    Om u in 't aangezicht te zweepen.
    Slaat op den trommel. Het zwaard is getogen.
    Slaat op den trommel. Leve de Geus!


En al de matrozen en soldaten van het vaartuig van Uilenspiegel,
en ook van de andere vaartuigen, zongen in koor:


    Slaat op den trommel, leve de Geus!


En hunne stemmen rommelden als de donder der verlossing.




III.

Men was in Louwe, de wreede maand, die het kalf in den buik van de
koe doet vervriezen. Het had gesneeuwd en daarboven gevrozen. De
knapen vingen, met vogelteer, de musschen, die op de harde sneeuw
een schamel stuksken brood kwamen zoeken, en brachten dat wild naar
de hutten hunner ouders. Op den grijzen hemel staken, onbeweeglijk,
de geraamten der boomen af, welker takken met sneeuwen kussens waren
versierd, die insgelijks de daken der hutten en de nok van de muren
bedekten, en in dewelke men pooten van katten zag, want die dieren
maakten in de sneeuw insgelijks jacht op de musschen. Heinde en ver
waren de weiden verborgen onder die wonderbare vacht, die de aarde
tegen de gure winterkoude beschut. De rook uit de schoorsteenen van
hutten en huizen stak somber af tegen den helderen hemel, en men
hoorde niet het minste gerucht.

En Katelijne en Nele zaten alleen in hare woning; en Katelijne schudde
het hoofd en sprak:

--Hans, mijn hart trekt naar u. Gij moet de zevenhonderd karolussen
teruggeven aan Uilenspiegel, den zoon van Soetkin. Zijt gij nooddruftig
en kunt gij ze thans niet teruggeven, kom dan toch maar, dat ik uw
glanzend gelaat zie. Doe het vuur weg, mijn hoofd brandt. Laas! waar
zijn uw sneeuwen kussen? waar is uw ijskoud lichaam, Hans, mijn
geliefde?

En troosteloos bleef ze vóór 't venster staan. Eensklaps kwam een
koerier, met belletjes aan den gordel, voorbijgeloopen.

--Daar komt de baljuw, de hoogbaljuw van Damme! riep de voetlooper.

En aldus liep hij tot aan het Schepenhuis, om er de burgemeesteren
en schepenen samen te roepen.

Toen hoorde Nele, in de volslagen stilte, twee klaroenen schallen. Die
van Damme kwamen allen aan hunne deur, in de meening dat het Zijne
Koninklijke Majesteit was, die zich door zulk een trompetgeschal
liet aankondigen.

En Katelijne ging ook aan de deur met Nele. In de verte zagen zij
schitterende ruiters in groepen bijeen en aan hunne spits reed een
personage, bedekt met een zwart pannen opperste kleed met marter
afgelegd, gekleed in een pannen wambuis met fijngouden belegsels
en met roode kalfsleerzen, gevoerd met martervel. En zij herkenden
den hoogbaljuw.

Achter hem reden jonge heeren, die, niettegenstaande de ordonnantie
van wijlen Zijne Keizerlijke Majestijt, aan hunne pannen kleederen,
gouden, zilveren en zijden borduursels, belegsels, banden,
boordsels droegen. En hun opperste kleederen waren, gelijk die van
den hoogbaljuw, met pels afgelegd. Zij reden vroolijk voort, met
fladderende lange struisvederen op hunne met goud afgelegde toques.

En zij zagen er allen als goede vrienden en kameraden van den
hoogbaljuw uit; en onder hen was een heer met een zure tronie,
gekleed in groene panne, met goud afgeleid; en zijn opperste kleed
was van zwarte panne, evenals zijne toque, die met lange pluimen
versierd was. En hij had een krommen neus als de bek van een gier,
een dunnen mond, ros haar, een bleek gezicht, en hij zat met fiere
houding te peerd.

Terwijl die heeren voorbij de woning reden van Katelijne, sprong
deze eensklaps naar den teugel van 't peerd van den bleeken ruiter,
en riep zij vol blijdschap:

--Hans, mijn geliefde, ik wist wel dat gij zoudt terugkomen. Zoo
zijt gij schoon, ganschelijk in de panne en in het goud, lijk eene
zon op de sneeuw! Brengt gij de zevenhonderd karolussen? Zult gij
nog schreeuwen lijk de nachtuil?

De hoogbaljuw deed den troep edellieden stilstaan en de bleeke
ruiter sprak:

--Wat wil die schooister van mij?

Maar Katelijne hield altoos het peerd bij den teugel en sprak:

--Verlaat mij niet; ik heb zoo bitter geweend om uwentwille. Zoete
nachten, mijn welbeminde, sneeuwen kussen en ijskoud lichaam.

Hier is het kind.

En zij wees naar Nele, die hem grammoedig bezag, want dreigend had
hij de karwats naar Katelijne opgeheven.

Maar Katelijne sprak schreiend:

--Ha? zoudt gij u niet meer herinneren? Neem uwe dienares in
genade. Breng mij met u waar gij wilt. Doe het vuur weg. Hans,
erbarming!

--Ga heen! sprak hij.

En hij stiet zijn peerd zoo geweldig vooruit, dat Katelijne den teugel
losliet en ten gronde viel; en het peerd trapte op heur en sloeg,
met zijn hoef, op heur voorhoofd, zoodat zij bloedde.

Toen zeide de baljuw tot den bleeken ruiter:

--Messire, kent gij die vrouwe?

--Ik ken ze niet, zeide hij, 't is zeker een krankzinnige.

Maar Nele, die Katelijne weder opgericht had, sprak luide:

--Is die vrouw krankzinnig, ik ben het niet, en wil hier sterven
van dit brokje sneeuw, dat ik eet--en zij nam een greepje sneeuw en
stak het in den mond--als die man mijne moeder niet heeft gekend,
als hij heur al heur geld niet ontnam, als hij den hond van Klaas
niet doodde, om, tegen den muur van den steenput onzer lochting,
de zevenhonderd karolussen te stelen van den armen aflijvige.

Het bloed vloeide uit de wonden van Katelijne, dewelke knielend
smeekte:

--Hans, mijn liefste, Hans, mijn welbeminde, geef mij den vredekus;
bezie mij, het bloed vloeit uit mijn voorhoofd; de ziel heeft een
gat gemaakt en nu wil zij buiten; fluks ga ik sterven: laat mij toch
niet alleen!

Vervolgens zeide zij met stillere stem:

--Eertijds hebt gij uwen vriend gedood uit jaloerschheid, langs
den dijk.

En met den vinger wees zij naar den kant van Dudzele.

--Toen bemindet gij mij meerder dan nu.

En zij nam de knie van den edelman vast en omhelsde ze, en zij greep
zijnen schoen vast en kuste dien.

--Wie is die man, die gedood werd? vroeg de hoogbaljuw.

--Ik weet het niet, genadige heer, antwoordde de bleeke ruiter. Wij
hebben geene zaken met hetgeen die schooister vertelt. Laat ons
voortgaan.

Het volk kwam te hoop rond hen; hoogpoorters en gemeen, werklieden
en boeren trokken partij voor Katelijne, en alle riepen:

--Gerechtigheid, heer baljuw, gerechtigheid!

En de baljuw sprak tot Nele:

--Wie is de man, die gedood werd? spreek volgens God en waarheid.

Nele zeide, naar den bleeken jonker wijzend:

--Deze hier kwam alle Zaterdagen in de keet om mijne moeder te zien en
heur geld af te doen: hij heeft eenen vriend van hem, Hilbert genoemd,
gedood in den akker van Servaas Vander Vichte, niet uit jaloerschheid,
maar om de zevenhonderd karolussen niet te moeten deelen met hem.

En Nele verhaalde de minnarijen van Katelijne en wat deze 's nachts
hoorde, toen zij verborgen was achter den dijk, die liep door den
kouter van Servaas Vander Vichte.

--Nele is stout, zeide Katelijne, zij is wel hard jegens Hans, jegens
heuren vader.

--Ik zweer, zeide Nele, dat hij schreeuwde als de nachtuil, om van
zijne tegenwoordigheid miede te geven.

--Gij liegt, zeide de edelman.

--Ho, neen! sprak Nele, en mijnheer de baljuw en al die heeren, hier
tegenwoordig, zien het wel: gij zijt bleek geenszins van koude, maar
van schrik. Hoe komt het dat uw gezicht niet meer blinkt? Bezigt gij
de tooverzalve niet meer, met dewelke gij u streekt, opdat gij helder
zoudt zien als de baren der zee, 's zomers, als 't donkert? Maar,
vermaledijde tooveraar, verbrand zult gij worden voor de pui van 't
Schepenhuis. Gij zijt de oorzaak van Soetkin's dood, gij bracht heuren
zoon, eenen wees, tot ellende; gij, die ongetwijfeld een edelman zijt,
kwaamt bij ons, werklieden, om mijne moeder een enkele maal een weinig
geld te brengen en er heur al de andere keeren veel te ontnemen.

--Hans, sprak Katelijne, zult gij mij nog bestrijken met de zalve,
zult gij mij nog naar den Sabbat leiden? Luister naar Nele niet:
zij is stout; gij ziet het bloed, de ziel heeft een gat gemaakt en
wil buiten; fluks zal ik sterven en dan ga ik naar 't voorgeborchte
der helle, alwaar geen vuur is.

--Zwijg, krankzinnige tooveres, zeide de edelman, ik weet niet wat
gij zeggen wilt.

--En nochtans, zeide Nele, zijt gij het, die kwaamt met eenen vriend,
dien gij mij tot man wildet geven; gij weet dat ik van hem niet wilde
weten; wat heeft hij gedaan, uw vriend Hilbert, wat heeft hij gedaan
voor zijne oogen, nadat ik er in krabde met mijne nagelen?

--Nele is stout, zeide Katelijne, geloof ze niet, Hans, mijn geliefde:
zij is grammoedig op Hilbert, die heur met geweld wilde nemen; maar nu
kan Hilbert dat nimmermeer doen, de wormen hebben hem opgegeten. En
Hilbert was leelijk; Hansken, mijn liefste, gij alleen zijt schoon;
Nele is stout!

Daarop sprak de baljuw:

--Vrouwen, gaat henen in vrede.

Maar Katelijne wilde niet weggaan van de plaats waar heur geliefde
was. En men moest ze met geweld naar heure woonstede brengen.

En al het te hoop gestroomde volk riep:

--Gerechtigheid, heer, gerechtigheid!

De serjanten van de gemeente waren bijeengekomen op het gerucht:
de baljuw gebood hun te blijven, en sprak tot de heeren en edellieden:

--Heeren en edellieden, niettegenstaande alle privileges, die
de doorluchtige orde van den adel in Vlaanderenland beschermen,
moet ik, op de beschuldigingen en hoofdzakelijk op die van hekserij,
uitgebracht tegen messire Joost Damman, denzelven apprehendeeren totdat
hij geoordeeld en gevonnist worde volgens de wetten en ordonnantiën
des Rijks. Geef mij uw zweerd af, messire Joost.

--Heer baljuw, zeide Joost Damman, met grooten hoogmoed en
adellijke fierheid, als gij mij aanhoudt, overtreedt gij de wetten
van Vlaanderen, want gij zelf zijt geen rechter. Nu, gij weet, dat
alleen valsche munters, struikroovers, brandstichters, verkrachters
van vrouwen en meidekens, soldeniers die hunnen hoofdman ontliepen,
tooveraars die de wateren vergiftigden, monniken en begijnen die hunne
kloosters ontliepen, mitsgaders gebannenen, zonder lastgeving van
den rechter, mogen geapprehendeerd worden. Nu, heeren, verdedigt mij!

Eenigen wilden bijspringen, maar de baljuw zeide tot hen:

--Heeren, ik vertegenwoordig hier onzen koning, grave en heer,
aan denwelke de beslissing van moeilijke gevallen is voorbehouden;
en ik gelast en beveel u, op peine als rebellen te worden beschouwd,
uw zweerd terug in de scheede te steken.

De edellieden gehoorzaamden; doch dewijl messire Joost Damman nog
aarzelde, riep het gemeen:

--Gerechtigheid, heer, gerechtigheid, hij geve zijn zweerd af.

Toen deed hij het tegen zijn dank, en, van zijn peerd gestegen zijnde,
werd hij door twee serjanten van de gemeente naar het Steen gebracht.

Doch hij werd niet in de kelders gestoken, maar wel in een getraliede
kamer, alwaar hij, mits betaling, een goed bed en een goed vuur kreeg
en ook goed eten mocht laten halen, van hetwelk de cipier minstens
de helft nam.




IV.

's Anderen daags gingen de baljuw, de beide griffiers-crimineel, twee
schepenen en een chirurgijn-baardemaker langs den kant van Dudzele, om
te zien of zij in den akker van Servaas Vander Vichte het lijk van een
man zouden vinden, langsheen den dijk, dewelke liep door dien kouter.

Nele had tot Katelijne gezeid:

--Hans, uw lieveling, vraagt een afgesneden hand van Hilbert: dezen
avond zal hij schreeuwen als de nachtuil, in onze hut komen en u de
zevenhonderd karolusgulden brengen.

Katelijne had geantwoord:

--De hand zal ik afsnijden.

En, inderdaad, zij nam een mes en ging heen, vergezelschapt door Nele
en gevolgd door de officieren van justitie.

Zij stapte gauw en fier vooruit met Nele, wier liefelijk gezichtje
bloosde van de vinnige koude.

Bibberend en kuchend, volgden heur de officieren van justitie, die
reeds bedaagd waren, en zij allen geleken zwarte schimmen op het
witte veld, en Nele droeg eene spade.

Toen zij bij den akker van Servaas Vander Vichte, op den dijk, gekomen
waren, ging Katelijne naar het midden: daar wees zij naar de meersch,
die op heure rechterhand lag en sprak:

--Hansken, gij wist niet dat ik daar huiverend verborgen was bij 't
wapengekletter. En Hilbert schreeuwde: Dit ijzer is koud. Hilbert is
leelijk. Hans is schoon. Gij zult zijne hand hebben, laat mij alleen!

Zij dwaalde toen links af, zette zich in de sneeuw op de knieën en
schreeuwde driemaal in de lucht, om de geesten aan te roepen.

Nele langde heur toen de spade, op dewelke Katelijne drie kruiskens
maakte; vervolgens teekende zij op de bevroren sneeuw de beeltenis van
eene doodkist, alsmede drie kruisen, één naar het Oosten, één naar het
Westen en één naar het Noorden, en sprak: Drij, dat is Mars omtrent
Saturnus, en drij is ontdekking onder Venus, de heldere sterre. En
vervolgens trok zij rondom de doodkist een grooten kring, zeggende:

--Ga heen, booze duivel, die de lijken bewaart!

Vervolgens knielde zij neder en bad:

--Duivel Hilbert, mijn vriend, zeide zij, Hans, mijn heer en meester,
beveelt mij hier uwe hand af te snijden: ik ben hem gehoorzaamheid
verschuldigd: doe mij niet treffen met het aardsche vuur, omdat ik
uw edele grafstee kom storen, en vergeef het mij in name van God en
zijne santen.

Toen kapte zij in het ijs, naarvolgens het figuur van de doodkist;
zij maakte de natte graszode bloot, vervolgens het zand, en weldra
zagen de heer baljuw, zijne officieren, Nele en Katelijne het lijk
van een jongen man te voorschijn komen, dat wit geworden was als kalk,
ter oorzake van het zand. Hij was gekleed in grijs lakensch wambuis en
een eender opperste kleed; zijn zweerd lag aan zijne zijde. Aan zijnen
gordel had hij eene maliënbeurs, en een breede dolk stak nog in zijn
lichaam, onder het hert; en er was bloed op het laken van het wambuis,
en dat bloed was geloopen tot onder den rug. En de man was nog jong.

Katelijne sneed zijne hand af en stak ze in heure gordeltasch. En de
baljuw liet heur begaan, beval heur vervolgens het lijk te ontdoen
van alle kleederen en kenteekenen. Katelijne vroeg, of Hans zulks
had geheeten, maar de baljuw antwoordde, dat hij slechts handelde
naar zijne bevelen; toen deed Katelijne alles wat hij gebood.

Toen het lijk uitgekleed was, zag men dat het droog lijk hout was:
en de baljuw en de officieren van de gemeente deden het bedekken met
zand en de serjanten droegen de kleederen en de wapenen mede.

En toen zij voorbij het Steen kwamen, zeide de baljuw tot Katelijne,
dat Hans dáár op heur wachtte; en blijde ging zij er binnen.

Nele wilde heur tegenhouden, doch Katelijne antwoordde:

--Ik wil Hans zien, mijn heer en meester.

En Nele weende aan de poort, want zij wist, dat Katelijne als tooveres
aangehouden was om de bezweringen en teekenen, die zij gemaakt had
op de sneeuw.

En men zeide te Damme, dat er voor heur geene ontferming zou zijn.

En Katelijne werd gestoken in een onderaardschen kerker van het Steen.




V.

's Anderen daags woei de wind uit Brabant: de sneeuw smolt en de
meerschen werden overstroomd.

En de burgstorm luidde, om de rechters naar de vierschaar te roepen,
onder het afdak, om den wille van de vochtigheid der zodenbanken.

En het volk stond rond de vierschaar.

Joost Damman werd voorgebracht, zonder kluisters, in zijn prachtige
kleeren. Katelijne werd insgelijks voorgebracht, doch met de handen
van voren gebonden en gekleed in een grijs lijnwaden kleed, hetwelk
de dos der gevangenen was.

Joost Damman, ondervraagd, bekende dat hij zijn vriend Hilbert gedood
had, in tweegevecht, met het zweerd. Als men hem zei, dat hij gedood
was met een dolk, antwoordde Joos Damman:

--Ik heb hem afgemaakt, omdat hij niet gauw genoeg stierf. Dien moord
beken ik gereedelijk, vermits ik sta onder de bescherming der wetten
van Vlaanderen, volgens dewelke, na verloop van tien jaar, de moord
niet meer vervolgd wordt.

De baljuw vroeg hem:

--Zijt gij geen tooveraar?

--Neen, antwoordde Damman.

--Bewijs het, zeide de baljuw.

--Ik zal het doen op tijd en stond, zeide Joost Damman, maar nu past
het mij niet.

Toen werd Katelijne ondervraagd; zij hoorde niet wat men vroeg,
doch keek gedurig naar Hans en sprak:

--Gij zijt mijn groene heer, schoon als de zon zijt ge. Doe het vuur
weg, mijn liefste!

Nele kwam toen Katelijne voorspreken en zeide:

--Heer baljuw en heeren rechters, meer dan gij weet, kan zij niet
bekennen; zij is geene tooveres, doch enkel uitzinnig.

Toen sprak de baljuw:

--Tooveraar is hij, die door voorbedachtelijk gebruikte duivelsche
middelen in iets tracht te slagen. Nu, deze twee, man en vrouw, zijn
tooveraars met inzicht en met daad; hij, omdat hij de sabbatszalve
gegeven, en zijn gezicht helder als Lucifer gemaakt heeft, ten
einde geld en vleeschelijken omgang te bekomen; zij, omdat zij hem
aangehangen heeft, hem nemende voor eenen echten duivel, en omdat
zij met hem gehanteerd heeft; hij is pleger van hekserij, en zij
is zijne baarschuldige. Men mag dus geenerlei ontferming hebben,
en ik moet het zeggen, want ik zie dat de schepenen en die van 't
gemeen te goedertieren zijn jegens de vrouw. In der waarheid heeft zij
gemoord noch gestolen, noch heeft zij personen of hunlieder beestiaal
mishand; ook heeft zij geenerlei zieken met buitengemeene middelen
genezen, maar enkellijk met gekende geneeskruiden; doch zij heeft
heure dochter willen overleveren aan den duivel, en als deze in heur
jeugdigen ouderdom niet met zooveel dapperheid wederstaan had, dan had
zij toegegeven aan Hilbert en ware zij, als de tweede beschuldigde,
insgelijks tooveres geworden. Dienvolgens vraag ik aan de heeren van de
vierschaar of zij niet van oordeel zijn, beiden ter torture te stellen?

De schepenen antwoordden niet, daardoor beduidende, dat zij niet van
dat oordeel waren, wat Katelijne betrof.

Zijne rede vervolgende, zeide toen de baljuw:

--Evenals gij, ben ik voor haar vervuld met ontferming en
medelijden; maar had die krankzinnige tooveres, die zoo goed den
duivel gehoorzaamt, als haar ontuchtige medebeschuldigde het heur had
bevolen, het hoofd heurer dochter niet kunnen afhouwen met een kapmes,
zooals Katelijne Dura, in Frankrijk, met heur twee dochters deed, op
aanzoek van den duivel? Had zij, zoo heur zwarte bruidegom het heur had
bevolen, het beestiaal niet kunnen doen sterven; de boter niet kunnen
doen keeren in de karnton, door er suiker in te smijten; had zij in
lijve niet kunnen tegenwoordig zijn bij alle duivelsvereeringen,
heksendansen, verfoeiselen en koppelingen van tooveraars? Had zij
geen menschenvleesch kunnen eten, geene kinderen kunnen dooden om er
pasteien van te maken en die te verkoopen, gelijk een pasteibakker
van Parijs deed; had zij de braaien der gehangenen niet kunnen
afsnijden en meedragen om ze rauw op te eten, aldus plegende beide
een schromelijken diefstal en eene heiligschennis? En ik vraag aan
de vierschaar Katelijne en Joost Damman op de pijnbank te leggen,
ten einde te weten of zij beiden geenerlei andere misdrijven hebben
gepleegd dan degene, die reeds gekend en onderzocht zijn. Vermits
Joost Damman weigert iets meerder te bekennen dan den moord, en
Katelijne niet alles gezegd heeft, gebieden ons de wetten des Rijks
te handelen naarvolgens mijn voorstel.

En de sententie der schepenen luidde, dat de torture twee dagen later,
des Vrijdags, zou plaats hebben.

En Nele schreeuwde:

--Genade, mijne heeren!

En het volk schreeuwde met heur, doch te vergeefs.

En Katelijne bezag Joost Damman en sprak:

--Ik heb Hilbert's hand, kom ze dezen nacht halen, liefste.

En zij werden terug naar het Steen gebracht.

Op bevel van de vierschaar, werd den cipier geheeten hun elk twee
bewakers te geven, die hen moesten slaan, telkens dat zij zouden willen
slapen; maar de twee bewakers van Katelijne lieten heur den nacht
slapende doorbrengen, en die van Joost Damman sloegen hem wreedelijk
telkens dat hij de oogen look of enkellijk het hoofd vooroverboog.

Heel den Woensdag hadden zij honger, alsook den nacht en heel den
Donderdag, tot 's avonds, als men hun vleesch te eten en water te
drinken gaf, beide bereid met zout en met salpeter. Dat was het begin
der torture. En 's morgens brachten de serjanten de beide gevangenen,
die schreeuwden van dorst, naar de folterkamer.

Daar werden zij rechtover elkander gezet en ieder gebonden op eene
bank, bekleed met knoopkoorden, die hen schromelijk pijnigden.

En ieder moest een glas water drinken, met zout en salpeter er in.

Joost Damman kreeg vaak op zijne bank, maar de serjanten sloegen
hem wakker.

En Katelijne zeide:

--Om Gods wil, slaat hem niet, mijne heeren, gij breekt zijn arm
lichaam. Hij bedreef maar een enkele misdaad, uit liefde, toen hij
Hilbert doodde. Ik heb dorst en gij ook, Hans, mijn beminde! Laat hem
eerst drinken! Water! water! mijn lichaam brandt als vuur. Spaar hem,
ik zal sterven voor hem! Drinken!

Hans zeide tot haar:

--Heks die gij zijt. Heeren rechters, smijt heure kroenge in 't
vuur. Ik heb dorst!

De griffiers schreven al zijne woorden op.

Toen zei de baljuw:

--Hebt gij niets te belijden?

--Ik heb niets meer te zeggen, antwoordde Joost Damman: Gij weet alles.

--Daar hij volherdt in zijn loochenen, zeide de baljuw, zal hij tot
verdere en volledige belijdenis op de koordebank blijven zitten en
zal hij dorst lijden, en men zal hem beletten te slapen.

--Ik zal blijven, zei Joost Damman, en mij vermaken met die tooveres
te zien lijden op heure bank. Hoe vindt gij 't huwelijksbed, nichtje?

En zuchtend antwoordde Katelijne:

--Koud van armen en warm van hert, Hans, mijn welbeminde. Ik heb dorst,
mijn hoofd brandt!

--En gij, vrouwe, sprak de baljuw, hebt gij niets meer te zeggen?

--Ik hoor, zeide zij, de kar van den Dood en een dof gerammel van
beenderen. Ik heb dorst! En Hij leidt mij naar een grooten troon,
waar water is, frisch en klaar water; maar dit water is vuur. Hans,
mijn vriend, verlos mij van die koorden. Ja, ik ben in het vagevuur
en ginder omhoog zie ik Onzen Heer Jezus in het hemelrijk zitten,
met zijn allergenadigste moeder, de Maagd Maria. Ho! Heilige Moeder
Gods, een droppelken water! Eet die sappige vruchten alleen niet op!

--Die vrouw is door wreede uitzinnigheid getroffen, zei een van de
schepenen. Men moet ze van de pijnbank verwijderen.

--Zij is niet uitzinniger dan ik; zei Joost Damman, 't is gehuichel
en gemaakt spel.

En met dreigende stemme, sprak hij tot Katelijne:

--Ik zal u zien branden in 't vuur, u, die zoo goed de uitzinnige
speelt.

En grijnzend, lachte hij om zijn boosaardige leugen.

--Ik heb dorst, zei Katelijne, hebt medelijden, ik heb dorst! Hans
mijn welbeminde, geef mij te drinken. Hoe helder is uw gezicht! Laat
mij tot hem gaan, heeren rechters!

En den mond openspalkend, vervolgde zij, smachtend van dorst:

--Ja, ja, nu steken zij vuur in mijne borst, en de duivelen binden
mij op dit gruwelijk bed. Hans, neem uw zweerd en dood ze, gij,
die zoo machtig zijt. Water! drinken! drinken!

--Sterf, tooveres, zeide Joost Damman: gij moest heur eene prop in
den mond steken om heur, eene vrouw uit 't gemeen, te beletten op te
komen tegen mij, die van adel ben.

Een schepen, vijand des adels, antwoordde op deze rede:

--Heer baljuw, het is strijdig met de rechten en costumen van den
lande, proppen te steken in den mond van hen, die men ondervraagt, want
zij zijn hier om de waarheid te zeggen en gevonnist te worden volgens
hunne rede. Proppen zijn maar toegelaten wanneer de beschuldigde,
veroordeeld zijnde, van op het schavot tot het volk spreken wil,
om het te vermurwen of gisting onder het gemeen te verwekken.

--Ik heb dorst, zeide Katelijne, geef mij te drinken, Hans, mijn
liefste.

--Ha! sprak Joost, gij lijdt, vervloekte heks, eenige schuld van al
mijne tormenten; maar in deze folterkamer zult gij nog andere smerten
verduren: de keersen, de wipgalg, de stokskens tusschen de vingeren en
tusschen de teenen. Men zal u, ganschelijk naakt, schrijlings zetten
op den rug eener doodkist, scherp als het lemmer van een mes, en dan
zult gij belijden dat gij geene uitzinnige zijt, maar een tooveres,
door Satan betaald om den edellieden last aan te doen. Drinken!

--Hans, mijn beminde, sprak Katelijne opnieuw, wees niet grammoedig
jegens uwe dienares; ik lijd duizenden pijnen voor u, mijn heer en
meester! Spaart hem, heeren rechters: geeft hem een vollen beker te
drinken, maar laat eenige droppelen over voor mij. Hans, is 't reeds
het uur van den nachtuil?

Toen vroeg de baljuw aan Joost Damman:

--Welke was de reden van het tweegevecht, waarin Hilbert den dood vond?

Joost antwoordde:

--Wij vochten om een meideken van Heist, dat wij beiden beminden.

--Een meideken van Heist, riep Katelijne, die met geweld van de
bank wilde opstaan, gij bedriegt mij dus met eene andere, helsche
verrader?... Wist gij dat ik stond te luisteren, achter den dijk,
toen gij zegdet dat gij al het geld wildet hebben, hetwelk het geld
was van Klaas? 't Was zeker om het met heur te verteren? Laas! en ik,
die mijn bloed had gegeven, als hij er goud had kunnen van maken! En
alles voor eene andere! Wees gevloekt!

Doch plotseling begon zij te weenen, en zij poogde zich om te keeren
op de folterbank:

--Neen, Hans, zeg dat gij uwe arme dienares noch zult liefhebben, en de
aarde zal ik met mijne vingeren openkrabben; een schat zal ik u vinden;
ja, een schat is verborgen; en ik zal zoeken met het hazelaarstakje,
hetwelk nederbuigt als het boven metaal wordt gehouden; en ik zal
hem vinden en hem u eerlijk brengen; kus mij, liefste, en gij zult
rijk wezen; en alle dagen zullen wij kuite drinken; ja, ja, zij, die
daar zitten, drinken ook bier, schuimend bier, dat verkwikt! O! mijne
heeren, een dropje slechts, ik brand in het vuur! Hans, ik weet waar
hazelaars groeien, maar gij moet wachten tot in den voortijd.

--Zwijg, ellendige, zei Joost Damman, ik ken u niet. Hilbert hebt
gij genomen voor mij: hij is 't die boven bij u kwam. En, met uw
helschen geest, hiet gij hem Hans. Weet dat ik niet Hans heet, maar
Joost: wij waren van dezelfde grootte, Hilbert en ik; 't was Hilbert,
waarschijnlijk, die de zevenhonderd karolussen nam. Drinken! mijn
vader zal honderd gulden betalen voor een kroezeken water; maar die
vrouw ken ik niet!

--Heer baljuw en heeren rechters, riep Katelijne uit, hij beweert dat
hij mij niet kent; maar ik, ik ken hem wel en weet, dat hij op den
rug een bruine, harige geboortevlek heeft, groot als een erwt. Ha! gij
bemindet een meideken van Heist! Hoeft een oprecht minnaar voor zijn
geliefde te blozen? Hans, ben ik niet meer schoon?

--Schoon! grijnslachte Damman, gij hebt een gezicht, glad als eene
mispel, en een lichaam, slank als eene vim takkebossen: bezie mij
die schooister, die beweert een edelman tot minnaar te hebben! Drinken!

--Zoo spraakt ge niet, Hans, mijn beminde heer en meester, als ik
zestien jaar jonger was.

Vervolgens op heur hoofd en heure borst kloppend, sprak zij:

--'t Is het vuur, dat daar is, dat mijn hert en mijn gezicht
verschroeit: verwijt het mij niet; weet gij nog dat wij veel van
zout eten hielden, om beter te kunnen drinken, naar gij zeidet? Nu is
al het zout in ons lijf, mijn beminde, en mijnheer de baljuw drinkt
wijn. Wij vragen geen wijn: geeft ons water. In de beemde kabbelt het
heldere beekje met zijn frisch, lekker water. Neen, dat water kookt,
het verbrandt mij! 't Is water uit de helle!

En Katelijne weende en zij sprak:

--Nooit deed ik iemand leed, en iedereen smijt mij in 't
vuur. Drinken! de straathonden krijgen water; ik ben een kerstene
vrouw, geeft mij te drinken. Nooit deed ik iemand leed! Geeft mij
toch te drinken!

Toen sprak een schepen:

--Die tooveres is alleenlijk uitzinnig wat betreft het vuur, dat
brandt in heur hoofd, naar zij zegt, maar voor alle andere dingen
is zij het niet, vermits zij met helderen geest ons het lijk van den
verslagene hielp ontdekken. Als Joost Damman inderdaad een harige vlek
heeft op zijnen rug, is dit merk voldoende om zijne eenzelvigheid te
doen vaststellen met den duivel Hans, op denwelken Katelijne verliefd
was. Beul, toon ons het merk op den rug.

De hangman ontblootte den hals en den schouder, en toonde de bruine,
harige vlek.

--Ha! sprak Katelijne, hoe wit is uwe huid! zou men niet zeggen dat
het de schouderen eener maagd zijn? Wat zijt gij schoon, Hans, mijn
beminde! Drinken!

Toen stak de hangman een lange naald in het merk, doch er kwam geen
bloed uit.

En de schepenen zeiden tot elkander:

--Dat is een duivel, en hij zal Joost Damman vermoord hebben en
zijn aanschijn genomen, om des te veiliger de arme lieden te kunnen
bedriegen.

En de baljuw en de schepenen schrikten:

--Hij is een duivel, en er is een tooverteeken.

En Joost Damman sprak:

--Gij weet wel dat dit geen tooverteeken is, maar dat er vleezige
uitwassen bestaan, in dewelke men mag steken, zonder dat zij
bloeden. Heeft Hilbert die tooveres geld ontfutseld,--want tooveres is
zij, die belijdt met den duivel te hebben geslapen--zoo deed hij het
met de algeheele toestemming van die boerin en werd hij, edelman,
om zijne kussen betaald, gelijk zulks telkendage gebeurt met de
meidekens van pleizier. Zijn er geene mannen, die, als de loddegen,
de vrouwen hunne kracht en hunne schoonheid met geld doen betalen?

De schepenen zeiden tot elkaar:

--Hoort gij zijn duivelsche, stoutmoedige listen? Zijn harige wrat
heeft niet gebloed: moordenaar, duivel en tooveraar, wil hij enkellijk
de schuld van het tweegevecht bekennen, om al zijn andere misdaden
te schuiven op zijn vriend den duivel, dien hij gedood heeft naar
lichaam, maar geenszins naar ziel.... En ziet eens hoe bleek zijn
gezicht is.--Aldus verschijnen al de duivelen, rood in de helle, bleek
op de wereld, want zij hebben geen levensvuur, dat aan het gezicht zijn
natuurlijken blos geeft, en zij zijn assche van binnen.--Om hem rood te
krijgen en hem te doen branden, moet men hem terug op het vuur zetten.

Toen sprak Katelijne:

--Ja, duivel is hij, doch een goede, zoete duivel! En de heilige
Joannes, zijn patroon, heeft hem de toelating gegeven de helle te
verlaten. Alle dagen bidt hij den Heer Jezus voor hem. Hij moet maar
zeven duizend jaar vagevuur meer doen: de Moeder Gods wil het, maar
Satan verzet er zich tegen. Doch Maria drijft door wat zij wil. Zult
gijlieden u verzetten tegen heuren wil? Als gij hem goed beziet,
zult gij merken, dat hij niets meer heeft van zijn duivelschen staat,
uitgenomen zijn ijskoud lichaam, en ook zijn gezicht, dat glanst lijk,
in de oogstmaand, de branding der zee, als donder op handen is.

En Joost Damman sprak:

--Zwijg, tooveres, gij doet mij verbranden!

Vervolgens zeide hij tot den baljuw en tot de schepenen:

--Aanziet mij, ik ben geen duivel; ik heb vleesch en been, bloed en
water. Ik drink en eet, verteer en werp uit lijk gijlie; mijn vel is
gelijk het uwe en mijn voet insgelijks; beul, trek mijne schoenen uit,
want met mijn gebonden voeten kan ik mij niet verroeren.

De hangman deed het, niet zonder schrik.

--Ziet, zeide Joost, terwijl hij zijn blanke voeten liet zien: zijn dat
gespleten klauwen, zijn dat duivelspooten? Wat mijne bleekheid betreft,
is niemand uwer zoo bleek als ik ben? Ik zie er meer dan drie onder
ulieden. Maar die zondigde was niet ik, doch die leelijke tooveres en
heure dochter, de boosaardige aanbrengster. Waar haalde zij het geld,
dat zij leende aan Hilbert; van waar kwamen de florijnen, die zij
hem gaf? Waren die niet het loon van den duivel, om de onschuldige
edellieden aan te klagen en te doen sterven? Het is aan die beide
vrouwen dat gij moet vragen, wie den hond in de lochting verworgde,
wie den schat uit den put nam en er mee heenging, wellicht om de
gestolen karolussen ergens elders te verbergen. Soetkin, de weduwe,
kon geen vertrouwen stellen in mij, daar zij mij niet kende, doch wel
in haarlieden, bij dewelken zij heel den dag vertoefde. Zij beiden
zijn het, die het goed van den keizer hebben gestolen.

--Vrouwe, hebt gij niets te zeggen tot uwe verdediging?

Katelijne keek naar Joost Damman en zeide met liefde:

--'t Is het uur van den nachtuil! Hans, mijn welbeminde, ik heb de
hand van Hilbert. Zij zeggen, dat gij de zevenhonderd karolussen
zult teruggeven.

... Doet het vuur weg, doet het vuur weg! kermde zij
vervolgens. Drinken! drinken! mijn hoofd brandt! God en de engelen
eten appelsienen in 't hemelrijk.

En zij viel in bezwijming.

--Neem ze weg van de pijnbank, beval de baljuw.

De hangman en zijne knechts gehoorzaamden. Men zag ze wankelen,
met gezwollen voeten, want de beul had de koorden te hard gespannen.

--Geef heur te drinken, beval de baljuw.

Men gaf heur versch water, hetwelk zij gretig dronk, met den beker
tusschen heure tanden, als een hond doet met een been, zonder hem te
willen loslaten. Vervolgens gaf men heur nog water, en zij wilde er
van dragen aan Joost Damman, maar de beul rukte heur den beker uit
de hand. En zij viel slapend ten gronde, als een blok lood.

Toen riep Joost Damman met woede:

--Ik ook heb dorst en heb vaak. Waarom laat gij heur drinken en slapen?

--Zij is eene vrouw, en daarbij zwak en uitzinnig, antwoordde de
baljuw.

--Heure uitzinnigheid is geveinsd, zeide Joost Damman, zij is eene
tooveres. Ik wil drinken, ik wil slapen!

En hij sloot de oogen, maar de beulsknechten sloegen hem in het
gezicht.

--Geef mij een mes, riep hij, dat ik al dien gemeenen boeren en
burgers de les spelle: ik ben een edelman en nooit sloeg men mij in het
gezicht. Water! laat mij slapen, ik ben onschuldig. Ik ben het niet,
die de zevenhonderd karolussen stal: 't is Hilbert. Drinken! Nooit
bedreef ik tooverij of bezwering. Ik ben onschuldig, laat mij
gaan. Drinken!

Toen vroeg de baljuw:

--Hoe bracht gij den tijd door, sedert dat gij Katelijne verliet?

--Katelijne ken ik niet en heb ze dus niet verlaten, zeide hij. Gij
ondervraagt mij over stukken, die vreemd aan de zaak zijn. Ik moet
u niet antwoorden. Drinken! Laat mij slapen! Ik zeg u, dat Hilbert
alles gedaan heeft.

--Maakt hem los, sprak de baljuw. Brengt hem terug naar het Steen. Maar
hij zal drinken noch slapen, totdat hij zijne tooverij en bezwering
bekend heeft.

En voor Damman was dit een schromelijke foltering. In den kerker
schreeuwde hij zoo luide: "Drinken! Drinken!" dat het volk het
hoorde, doch zonder mededoogen. En als hij viel van de vaak en zijne
bewakers hem in het gezicht sloegen, werd hij woedend als een tijger
en riep hij:

--Ik ben een edelman en zal u allen dooden, boeren! Ik zal gaan bij
den koning, onzen hoofdman. Drinken!

Doch hij beleed niets, en men liet hem in het Steen.




VI.

Toen was men in de Bloeimaand; de boom der justitie was groen,
insgelijks groen waren de banken van graszoden, op dewelke de rechters
waren gezeten. Nele werd ter oorkondschap geroepen. Dien dag moest
het vonnis uitgesproken worden.

En het volk: mannen, vrouwlieden, poorters en arbeiders stonden rond
de vierschaar; en de zonne scheen helder.

Katelijne en Joost Damman werden voor de vierschaar gebracht; en
Damman zag er nog bleeker uit, ter oorzake van de torture, van den
dorst en van de slapelooze nachten.

Katelijne, die zich op heure waggelende beenen niet rechthouden kon,
wees naar de zonne en sprak:

--Doe het vuur weg, mijn hoofd brandt!

En met teedere liefde zag zij naar Joost Damman.

En deze bekeek heur met haat en verachting.

En de heeren en edelen, zijne vrienden, die naar Damme waren ontboden,
waren allen als getuigen voor de vierschaar aanwezig.

Toen sprak de baljuw:

--Nele, de dochter, die heure moeder Katelijne met zooveel
genegenheid verdedigt, heeft in den genaaiden zak van den besten rok
derzelfde Katelijne een briefje gevonden, geteekend "Hansken". In de
beugeltassche, gevonden op het lijk van Hilbert Rijnvisch, stak een
andere brief, aan hem gezonden door Joost Damman, beschuldigde alhier
tegenwoordig. Beide brieven heb ik bewaard, opdat gij op het gepaste
oogenblik, dat thans aangebroken is, zoudt kunnen oordeelen over
de hardnekkigheid van dien man en hem vrijspreken of veroordeelen,
naarvolgens wet en gerechtigheid. Hier is het perkament, in de
beugeltasch gevonden; ik deed het niet open en weet niet of het
leesbaar is of niet.

Toen waren de rechters in groote verlegenheid.

De baljuw beproefde het bolleken perkament los te maken, doch te
vergeefs; en Joost Damman schompermuilde.

Toen sprak een schepen:

--Laat ons het bolleken in 't water leggen en vervolgens voor
't vuur stellen. Als het door een heimelijk middel toegeplakt is,
zullen water en vuur het wel losmaken.

Het water werd gebracht, de hangman stak een groot houtvuur aan;
de blauwe rook steeg recht omhoog in den helderen hemel, tusschen de
groene takken van den boom der justitie.

--Steek den brief in de kom niet, sprak een schepen, want als hij
geschreven is met opgelost ammoniakzout, zullen de letteren verdwijnen.

--Neen, zeide een chirurgijn, die daar was, de letteren zullen niet
verdwijnen, het water zal enkellijk het bestrijksel, hetwelk dit
tooverbolleken toeplakt, weeker maken.

Het perkament werd geweekt in het water, en, als het zachter was,
werd het geopend.

--Nu, zeide de chirurgijn, houdt het nu voor het vuur.

--Ja, ja, zeide Nele, houdt het papier voor het vuur; messire
chirurgijn is op weg naar de waarheid, want de moordenaar verbleekt,
en siddert over heel zijn lichaam.

Daarop sprak Joost Damman:

--Ik verbleek noch ik sidder, kleine heks uit 't gemeen, die op den
dood van een edelman aast; maar gij zult er niet in slagen: dat papier
moet gerot zijn na zestien jaar verblijf in den grond.

--Het perkament is geenszins bedorven, zei de schepen, de beugeltasch
was met zijde gevoerd; zijde vergaat niet in den grond, en de wormen
hebben het perkament niet opgegeten.

Het perkament werd voor 't vuur gebracht.

--Heer baljuw, heer baljuw, zeide Nele, hier voor het vuur komen
reeds letteren te voorschijn: beveel dat men het schrift leze.

De chirurgijn nam het perkament om het te lezen, als messire Joost
Damman vlug de hand uitstak om het te grijpen; doch rap als de wind
hield Nele zijnen arm tegen, en zij sprak:

--Gij zult het niet aanraken, want daar staat uw dood of die van
Katelijne geschreven. Bloedt thans uw herte, moordenaar, weet dat het
onze reeds vijftien jaar lang bloedt; 't is vijftien jaar dat Katelijne
lijdt, dat heur geest in heur hoofd verbrand werd om uwentwil; 't
is vijftien jaar dat Soetkin stierf ten gevolge der smerten; 't is
vijftien jaar dat wij leven in kommer en ellende, hoewel wij fier het
hoofd mogen verheffen. Lees het papier, lees het papier! De rechters
zijn God op de wereld, want zij zijn Gerechtigheid. Lees het papier!

--Lees het papier! riepen de mannen en vrouwlieden snikkend. Nele is
moedig en braaf! Katelijne is geene tooveres.

En de griffier las:

"Aan Hilbert, zoon van Willem Rijnvisch, schildknaap, Joost Damman,
schildknaap, Heil!

... Waarde vriend, verlies uw geld niet meer met kaarten, dobbelsteenen
en andere dergelijke kansspelen. Ik zal u zeggen hoe men zeker is
altijd geld te winnen: Laat ons duivelen worden, schoone duivelen,
bemind door vrouwen en meidekens. De schoone en rijke vrouwlieden
zullen wij nemen en de leelijken en armen daar laten; zij hebben heur
genoegen maar te betalen. Op die wijze maakte ik in Duitschland, in zes
maanden, vijfduizend rijksdaalders. De vrouwen zouden zich uitkleeden
voor den man, dien zij liefhebben; vlied de gierige feeksen, die met
tegenzin heur pleizier betalen. Wat u betreft, om schoon te wezen en
een echte nachtduivel te schijnen, kondig uwe komst aan met 't gekras
van eenen roofvogel, als zij u in het duister willen ontvangen. En om
u een gezicht te maken van een echten, verschrikkelijken duivel, wrijf
het in met phosphorus, die bij plaatsen schittert als hij nat is. Hij
stinkt, maar de vrouwen nemen dat voor den reuk van het solfer der
helle. Dood al wie u hindert: 't zij man, 't zij vrouw of 't zij beest.

... Binnen kort gaan wij samen bij Katelijne, een schoone, goedhertige
loddege; heure dochter, Nele, een kind van mij, als Katelijne mij
trouw was, is een lief en beminnelijk meideken; zonder moeite zult
gij ze nemen; ik schenk ze u, want ik geef niet om bastaards: men
kan ze nooit met zekerheid voor zijn kroost erkennen. Heure moeder
gaf mij reeds meer dan drie en twintig karolussen, gansch heure
have. Maar zij verbergt eenen schat, die, als ik het goed voorheb,
het erfdeel van Klaas is, den ketter, die te Damme levend verbrand
werd: zevenhonderd karolussen, waar verbeurdverklaring op rust;
doch de goede koning Philippus, die zoovele zijner onderdanen deed
verbranden om te erven van hen, kon dien lieven schat in zijne klauwen
niet krijgen. Hij zal zwaarder wegen in mijne tassche dan in de zijne;
Katelijne zal mij zeggen waar hij is; wij zullen hem deelen. Maar gij
moet mij 't grootste deel laten, omdat ik de aanbrenger ben. Wat de
vrouwen betreft, dewelke onze zachtmoedige dienaressen en verliefde
slavinnen zullen wezen, die zullen wij naar Duitschland brengen. Daar
zullen wij van heur nachtduivelinnetjes maken, en ze laten beslapen
door alle rijke poorters en edellieden; wij en haarlieden zullen
daar leven van de liefde, betaald met schoone rijksdaalders, panne,
zijde, goud, perelen en juweelen; zoo worden wij, buiten weten van
onze duivelinnetjes, bemind door de schoonsten onder de schoonen,
en doen wij heur steeds voor onze liefde betalen. Al de vrouwen zijn
zot en dwaselijk verknocht aan den man, die in haar het liefdevuur
doet ontvlammen, hetwelk God onder heuren gordel stak. Katelijne en
Nele zullen het nog meer wezen dan iemand, en zullen ons in alles
gehoorzamen: behoud uwen voornaam, maar voer nooit den naam van uwen
vader Rijnvisch. Neemt de rechter de vrouwen in hechtenis, dadelijk
vertrekken wij zonder dat zij ons kennen of kunnen verraden. Help
mij, mijne getrouwe. De fortuin lacht de jongelieden toe, zeide Zijne
Heilige Majesteit Keizer Karel zaliger, dewelke een meester was in
zaken van liefde en van oorlog".

En de griffier hield op met lezen en sprak:

--Zoo luidt de brief en hij is geteekend: "Joost Damman, schildknaap".

En het volk riep:

--Ter dood, de moordenaar! Ter dood, de tooveraar! In 't vuur, de
schavuit, die de vrouwlieden waanzinnig maakt! Aan de galg, de rabauw!

Toen sprak de baljuw:

--Zwijg, volk, opdat wij dien man in volle vrijheid kunnen oordeelen.

En tot de schepenen zeide hij:

--Ik wil u den tweeden brief lezen, dien Nele vond in den zak van
Katelijne's besten rok; hij luidt als volgt:

"Geliefde tooveres, ziehier het recept eener zalve, dat de vrouw van
Lucifer zelve mij zond: met die zalve zult gij u kunnen begeven in
de zonne, de maan en de sterren; kunnen spreken met de sylphen, die
aan God de gebeden der menschen overbrengen, en alle steden, dorpen,
rivieren, beemden van 't gansche heelal kunnen bezoeken. Stamp
ondereen, bij gelijke deelen, stramonium, solanum somniferum,
bilzenkruid, opium, versche henneptoppen, belladonna en datura.

... Als gij wilt, zullen wij dezen avond samen naar den sabbat der
geesten gaan: maar gij moet mij meerder beminnen en zoo gierig niet
zijn, gelijk dien avond, toen gij mij tien gulden weigerdet, onder
voorwendsel dat gij ze niet hadt. Ik weet, dat gij eenen schat verbergt
en het mij niet wilt bekennen. Bemint gij mij niet meer, mijne liefste?

"Uw koude duivel,

"Hansken".

--Ter dood, de tooveraar! riep het volk.

De baljuw sprak:

--Wij moeten de twee schriften vergelijken.

Dit werd gedaan, en zij werden eender bevonden.

Toen sprak de baljuw tot de aanwezige heeren en edellieden:

--Herkent gij den beklaagde voor messire Joost Damman, zoon van den
schepene van de keure van Gent?

--Ja, zeiden zij.

--Kendet gij, sprak hij, messire Hilbert, zoon van Willem Rijnvisch,
schildknaap?

Een der edellieden, die Vander Zickele hiet, nam het woord en sprak:

--Ik ben van Gent, mijn steen staat op de Hoogpoort; ik ken Willem
Rijnvisch, schepene van de keure van Gent. Hij verloor, over een
vijftiental jaren, een zoon van drie en twintig jaar, een losbol,
een speler, een luierik; maar men vergaf hem zijne gebreken, om den
wille van zijn jeugdigen leeftijd. Sedert dien tijd kreeg nooit iemand
miede van hem. Ik vraag om het zweerd, den dolk en de beugeltassche
van den verslagene te zien.

Toen hij die voor zich had, sprak hij:

--Op den knop van het hecht van het zweerd en den dolk staan de
wapenen van het geslacht Rijnvisch, hetwelk voert, in blauw, drie
zilveren visschen. Die zelfde wapenen zie ik op een gouden schild
tusschen de maliën der beugeltassche. Welke is die andere dolk?

De baljuw sprak:

--Die dolk stak in het lichaam van Hilbert Rijnvisch, zoon van Willem.

--Daarop herken ik de wapens der Damman's: in zilver, een roode toren.

--Zoo waarlijk helpe mij God almachtig!

De andere edellieden zeiden insgelijks:

--Die wapenen herkennen wij voor die van Rijnvisch en van Damman. Zoo
helpen ons God en al zijne santen!

Toen zei de baljuw:

--Gehoord en gelezen de voor de Vierschaar gebrachte getuigenissen
en oorkonden, is naar rechte ten genoege gebleken, dat Joost
Damman, "gecommitteerd hebbende de crimen van tooverije, doodslag,
zotmaking van vrouwlieden, diefte van 's konings goedingen, wezende
de abominabelste zonden die men ter wereld kan bedrijven, schuldig
is aan crimen divinae laesae majestatis, geenszins lijdelijk zonder
exemplaire pugnitie".

--Dat zegt gij, messire baljuw, hernam Joost, doch bij gebreke aan
genoegzame bewijzen, kunt gij mij niet veroordeelen; tooveraar ben ik
niet of was ik nooit; enkellijk speelde ik het spel van den duivel. Wat
mijn helder gezicht betreft, nu weet gij het middel, dat ik daartoe
gebruikte. De zalve, hoewel zij bilzenkruid, een vergiftige plant,
bevat, is enkel slaapverwekkend. Als die vrouw, die een ware tooveres
is, er van nam, verviel zij in slaapdronkenheid en droomde zij, dat
zij naar den sabbat ging en er danste met het gezicht buitenwaarts
van de ronde, alsook dat zij eenen duivel aanbad in de gedaante van
eenen bok, op een autaar gezeten. Als de rondedans gedaan was, droomde
zij, dat zij den duivel ging kussen onder zijnen steert, gelijk de
tooveraars doen, tot teeken van onderdanigheid. Als ik, naar zij zegt,
koude armen en een frisch lichaam had, is dit een teeken van jeugd
en geenszins van tooverij. Frischheid is niet bestand tegen het werk
des vleesches. Maar Katelijne nam heure wenschen voor werkelijkheid
en aanzag mij dus voor eenen duivel, hoewel ik een mensch ben, gelijk
gijlie. Zij alleen is schuldig om mij, voor eenen duivel nemende, in
heur bed aanveerd te hebben; aldus zondigde zij met wil en met daad
tegen God en tegen den Heiligen Geest. Zij dus is het, maar ik niet,
die de misdaad van tooverij beging, die strafbaar is met den viere, als
een razende en boosaardige tooveres, die voor uitzinnig wil doorgaan,
ten einde heure boosaardigheid te verbergen.

Doch Nele riep:

--Hoort gij den moordenaar? Als loddegen, als veile deernen, dewelke
een schijfje op den arm dragen, dreef hij handel in liefde. Hoort
gij hem? om zich te redden, wil hij degene doen verbranden, welke
hem alles gaf.

--Nele is stout, zeide Katelijne, Hans, mijn liefste, luister naar
heur niet.

--Neen, vervolgde Nele, gij zijt geen mensch: gij zijt een lafhertige,
wreedaardige duivel!

En, Katelijne in de armen nemend:

--Heeren rechters, riep zij, luistert niet naar dien bleeken booswicht;
hij heeft maar éénen wensch: mijne moeder levend te zien verbranden,
hoewel zij geen andere misdaad bedreef, dan door God met uitzinnigheid
getroffen te worden en de schimmen heurer droomen voor echt te
aanzien. Veel reeds heeft zij geleden naar lichaam en geest. Doet ze
niet sterven, heeren rechters. Laat de uitzinnige heur treurig leven
eindigen in vrede.

En Katelijne sprak:

--Nele is stout, ge moet ze niet gelooven, Hansken, mijn vriend.

En in het volk weenden de vrouwlieden en riepen de mannen:

--Genade voor Katelijne!

Op belijdenissen, die Joost Damman na nieuwe folteringen deed, brachten
de baljuw en de schepenen hunne sententie te zijnen opzichte uit:
hij werd veroordeeld om te worden ontadeld en levend verbrand met
zacht vuur, totdat de dood er op volgde.

's Anderen daags doorstond hij de doodstraf voor de pui van het
Schepenhuis, gedurig roepend:

--Doet de tooveres sterven; zij alleen is schuldig. Gevloekt weze
God! mijn vader zal de rechters vermoorden!

En hij gaf den geest.

En het volk zeide:

--Hoort hoe hij God vloekt en lastert, hij sterft als een hond.

's Anderen daags brachten de baljuw en de schepenen hun vonnis uit
ten opzichte van Katelijne: zij werd veroordeeld om de waterproef
te doorstaan, in de Brugsche vaart. Zoo zij boven dreef, zou zij als
tooveres worden verbrand; zoo zij zonk en stierf, zou zij beschouwd
worden als op kerstene wijze gestorven en als dusdanig op 't kerkhof
begraven.

's Anderen daags werd Katelijne, baarvoets, gekleed met een zwart
linnen hemde, en met eene waskeers in heure hand, processiegewijs
gebracht tot aan de vaart, langsheen de boomen. Vóór heur gingen,
de gebeden der dooden zingend, de deken van Onze-Lieve-Vrouwekerk,
zijne vicarissen, de koster met het kruis; en achter heur, de baljuw
van Damme, de schepenen, de griffiers, de serjanten der gemeente,
de provoost, de hangman en zijne beide knechts. Op de beide oevers
stond een groote menigte vrouwen, die weenden, en mannen, die morden,
uit medelijden met Katelijne, dewelke gedwee als een lam zich liet
leiden zonder te weten waarheen, en gedurig zei:

--Doet het vuur weg, mijn hoofd brandt! Hansken, waar zijt gij?

Nele, die te midden van de vrouwen stond, riep:

--Ik wil met heur in 't water worden gesmeten!

Maar de vrouwen lieten heur omtrent Katelijne niet komen.

Een scherpe wind blies van de zee; een fijne hagel viel uit
den loodgrijzen hemel in het water der vaart; eene boot lag daar
vastgemeerd; de hangman en zijne knechts namen dezelve in naam Zijner
Koninklijke Majesteit. Op hun bevel stapte Katelijne er in: de beul
stond recht in de boot en hield Katelijne vast, en, op een teeken van
den provoost met de roede der justitie, smeet hij ze in de vaart. Zij
spartelde, doch niet lang, en zonk nog roepende:

--Hans! Hans! help mij!

En het volk zeide:

--Die vrouw is geene tooveres.

Mannen sprongen in de vaart en trokken Katelijne er uit, dewelke
van heurzelve was en stijf als eene doode. Zij werd in eene taveerne
gebracht en voor een groot vuur nedergelegd; Nele trok heur nat hemd
uit en deed heur een ander aan; toen zij tot zich zelve kwam, zegde
zij bibberend en klappertandend:

--Hans, geef mij een wollen mantel.

En Katelijne kon zich niet verwarmen. En den derden dag stierf zij. En
zij werd op 't kerkhof begraven, in gewijde aarde.

En Nele toog henen naar Holland, bij Rosa van Auweghem.




VII.

Op de hulken, op de boeiers, de poonen der Geuzen, vaart Thijl Klaas
Uilenspiegel.

De vrije zee draagt de wakkere vliebooten, op dewelke acht, tien,
tot twintig ijzeren stukken staan: zij braken dood en vernieling naar
de verraderlijke Spanjolen.

Hij is een ervaren kanonnier, Thijl Uilenspiegel, zoon van Klaas:
het is een lust te zien hoe juist hij het stuk richt, hoe goed hij
mikt, en, als in boter, een gat boort in de schepen der beulen.

Op den vilten hoed draagt hij de zilveren halvemaan met het opschrift:
Liever den Turc als den Paus.

De matrozen, die hem, vlug als eene kat, met een referein op de lippen,
op hunne boot zagen springen, ondervroegen hem nieuwsgieriglijk:

--Hoe komt het, maat, dat gij er nog zoo jeugdig uitziet, want men
zegt, dat het reeds lang geleden is dat gij te Damme ter wereld kwaamt?

--Ik ben geen lichaam, maar een geest, zei hij, en Nele, mijne
vriendinne, gelijkt mij. Geest van Vlaanderen, Liefde van Vlaanderen,
zullen wij beiden nooit sterven.

--Maar, zeiden zij, als men u snijdt, bloedt gij toch?

--Schijn bedriegt, antwoordde Uilenspiegel, het is wijn, maar geen
bloed.

En de geborduurde banieren uit de ommegangen der Roomschen wapperden
aan de masten der schepen. En gekleed in panne, in brocaat, in zijde,
in goud- en zilverlaken, met mijter en staf, den wijn der monniken
drinkend, hielden de Geuzen de wacht op hunne schepen.

En 't was een vreemdsoortig schouwspel, uit de mouwen der rijke
kleederen die ruwe handen te zien steken, dewelke bogen of bussen,
hellebaarden of pieken droegen, en al die mannen met stuursche
tronie, met flikkerende pistolen en kruismessen in den gordelriem,
uit gouden kelken den wijn der abten te zien drinken, die nu de wijn
der vrijheid was.

En zij zongen en riepen: "Vive le Geus!" en dobberden aldus op het
ruime sop.




VIII.

Te dien tijde namen de Geuzen, onder dewelke Lamme en Uilenspiegel
waren, het stedeken Gorkum. En zij waren aangevoerd door kapitein
Marinus. Deze Marinus, die vroeger dijkwerker was, was weergaloos
trotsch en verwaand en teekende met Gaspard Turk, de verdediger van
Gorkum, eene capitulatie, bij dewelke Turk, de monniken, poorters en
soldaten, die binnen de vesting waren, vrijelijk zouden mogen uitgaan
met den kogel in den mond, het musket op den schouder, met alles
wat zij zouden kunnen dragen, uitgenomen de goedingen van kerken en
kloosters, die aan de belegeraars moesten komen.

Maar, op bevel van messire Lumey, wederhield kapitein Marinus negentien
monniken; alleen de soldaten en poorters liet hij gaan.

En Uilenspiegel sprak:

--Soldatenwoord moet gulden woord wezen. Waarom breekt hij het zijne?

Een oude Geus antwoordde hem:

--De monniken zijn de zonen Satans, de melaatschheid der landen, de
schande der volken. Sedert de komst van den bloedigen hertog, spelen
dezen hier den baas in Gorkum. Onder hen is er een, paap Nicolaas,
dewelke fier is als een pauw en wreed als een tijger. Telkenmale dat
hij over de straat ging met zijn monstrans, waarin zijn met hondevet
gebakken ouwel stak, keek hij met grammoedige oogen naar de huizen, uit
dewelke de vrouwen niet kwamen om neder te knielen, en kloeg hij bij
den rechter al degenen aan, die de knie niet bogen voor zijnen afgod
van water en bloem. De andere monniken volgden zijn voorbeeld. Dat
was de oorzaak van vele gruweldaden, verbrandingen en andere wreede
folteringen in het stedeken Gorkum. Kapitein Marinus deed wèl van die
monniken gevangen te houden, die anderszins, met hunne gelijken, in
vlekken, steden en gehuchten zouden gaan, om te preeken tegen ons, het
volk op te hitsen en de arme hervormden te doen verbranden. Bloedhonden
legt men aan de keten totdat zij verrekken; aan de keten, de monniken;
aan de keten, de bloedhonden van den hertog van Alva; in den kerker,
de beulen! Vive le Geus!

--Maar, sprak Uilenspiegel, Oranje, onze prins van de vrijheid, wil
dat men, bij elke overgave, de goedingen der menschen en het vrije
geweten eerbiedige.

De oude geuzen antwoordden:

--De admiraal wil dat niet voor de monniken: hij is de meester:
hij nam den Briel. In den kerker, de monniken!

--Soldatenwoord is gulden woord! Waarom schendt hij zijn
woord? antwoordde Uilenspiegel. De monniken, die in den kerker worden
gehouden, zijn aan de grofste beleedigingen blootgesteld.

--De assche klopt niet meer op uw hert, spraken zij: ten gevolge van
de edicten, hebben honderdduizend gezinnen de ambachten, de nijverheid
onzer landen, overgebracht naar het Noordwesten, naar Engeland; betoon
maar medelijden voor de bewerkers van onzen ondergang! Sedert Keizer
Karel V, Beul I, en, onder den huidigen, bloedigen koning, Beul II,
stierven honderd achttien duizend menschen den marteldood. Wie droeg de
keersen bij de begrafenissen, in den moorden in de tranen? Monniken en
Spaansche soldeniers! Hoort gij, hoort gij de zielen der slachtoffers
niet klagen en kermen in het kille graf?

--De assche klopt op mijn hert, zeide Uilenspiegel. Soldatenwoord is
gulden woord!

--Wie dan, zeiden zij, wilde door excommunicatie ons in den ban van
alle landen sluiten? Wie had hemel en aarde, God en duivel en hunne
dichte gelederen santen en santinnen tegen ons afgezonden? Wie spatte
er droppelen ossenbloed op de ouwels, wie deed de houten heiligen
weenen? Wie deed het de Profundis zingen over den grond onzer vaderen,
anders dan die gevloekte geestelijkheid, die hoop ledige, vadsige
monniken? En dit alles om hunnen rijkdom te behouden, alsmede hunnen
invloed op de afgodendienaars, en door ondergang, bloed en vuur te
heerschen over het arme land. In de kooi, de wolven, die de menschen
beloeren; in de kooi, de hyena's. Vive le Geus!

--Soldatenwoord is gulden woord!

's Anderen daags, kwam een bode vanwege messire Lumey, met bevel de
negentien gevangen monniken te doen overbrengen van Gorkum naar den
Briel, alwaar de admiraal zich bevond.

--Zij zullen gehangen worden, zei kapitein Marinus tot Uilenspiegel.

--Toch niet zoolang ik zal leven, antwoordde hij.

--Mijn vriend, zeide Lamme, spreek zóó niet tot messire Lumey. Hij is
wreedaardig en zal u doen hangen in het weinig vereerend gezelschap
der monniken.

--Ik zal spreken naarvolgens de waarheid, antwoordde Uilenspiegel:
soldatenwoord is gulden woord!

--Als gij ze kunt redden, zeide Marinus, breng hunne boot naar den
Briel. Neem Rochus den loods mee, en uwen vriend Lamme, als gij wilt.

--Ik wil, antwoordde Uilenspiegel.

De boot werd gemeerd aan de Groene Kade, de negentien monniken namen er
plaats in; de vreesachtige Rochus werd gezet aan het roer, Uilenspiegel
en Lamme, beiden goed gewapend, gingen staan op de voorplecht. Eenige
schavuiten, die met het oog op de plundering als soldaten bij de Geuzen
waren gekomen, zaten bij de monniken, die honger hadden. Uilenspiegel
gaf hun te eten en te drinken. "Die zal verraden!" zeiden de slechte
soldaten. De negentien monniken zaten in het midden, schijnheilig
vroom en bibberend, hoewel men in de Hooimaand was en de zon helder
en warm scheen, en een zachte zeewind de zeilen der boot deed zwellen,
die log en zwaar over de groene golven gleed.

Pater Nicolaas sprak toen en zeide tot den loods:

--Rochus, leidt men ons naar het Galgeveld?

Vervolgens wendde hij zich in de richting van Gorkum en sprak,
terwijl hij rechtstond en de hand uitstak:

--O, stede van Gorkum, o stede van Gorkum! Hoevele kwalen hebt gij
te lijden: gevloekt zult gij wezen onder al de steden, want binnen
uwe muren hebt gij het zaad der ketterij laten kiemen! O, stede van
Gorkum! En de engel des Heeren zal bij uwe poorten de wacht niet
meer houden. Hij zal niet meer zorgen voor de eer uwer maagden, den
moed uwer mannen, het fortuin uwer kooplieden! O stede van Gorkum,
gevloekt zijt gij, rampzalige!

--Gevloekt, gevloekt, antwoordde Uilenspiegel, gevloekt zeker als
de kam, die al de Spaansche luizen afgekamd heeft! Gevloekt als
de hond, die zijne keten verbreekt, als het trotsche peerd, dat
een wreedaardigen ruiter ontzadelt! Maar gij zelf zijt gevloekt,
dompelaar van een predikant, die slecht vindt dat men de roede,
al ware zij van ijzer, aan stukken slaat op den rug der tirannen!

De monnik zweeg en sloeg de oogen neer; hij scheen ganschelijk
overgeleverd aan zijn godvruchtigen haat.

De schavuiten, die met het oog op plundering als soldaten bij de
Geuzen waren gekomen, waren nabij de monniken, dewelke weldra weer
honger kregen. Uilenspiegel vroeg voor hen haring en beschuit. De
schipper van de boot antwoordde:

--Smijt ze in de Maas, daar zullen zij versche haring vinden.

Uilenspiegel gaf toen aan de monniken al het brood en al de worst,
die hij overhad voor zich en voor Lamme.

De schipper en de schavuiten zeiden tot elkander:

--Die is een verrader, hij spijst de monniken. Wij moeten hem
aanklagen.

Te Dordrecht hield de boot stil in de haven, aan de Bloemenkade;
mannen, vrouwlieden, knapen en meidekens kwamen in groote menigte
toeloopen om de monniken te zien en zeiden tot elkander, terwijl zij
hen met den vinger toonden of met de vuisten bedreigden:

--Beziet die schoften daar, die godmakers, die de lichamen naar de
brandstapels brengen en de zielen naar 't eeuwige vuur; beziet die
vetgemeste tijgeren, die dikbuikige jakhalzen.

De monniken lieten het hoofd zakken en dorsten niet spreken. Weer
zag Uilenspiegel hen zitten bibberen.

--Wij hebben nog honger, medelijdende soldaat, zeiden zij.

Maar de schipper sprak:

--Wie drinkt altijd? Droog zand. Wie eet altijd? Monniken.

Uilenspiegel ging hun in de stad brood, hesp en een grooten pot
bier koopen.

--Eet en drinkt, zeide hij; gij zijt onze gevangenen, doch als ik kan,
zal ik u redden. Soldatenwoord is gulden woord!

--Waarom geeft gij hun dat eten en drinken? Nooit zullen zij u betalen,
zeiden de schavuiten.

En stille spekend, fluisterden zij elkander in 't oor:

--Hij heeft beloofd hen te redden, wij moeten hem gadeslaan.

Met den dageraad kwamen zij aan den Briel. Toen de poorten hun geopend
waren, ging een voetlooper messire Lumey verwittigen van hunne komst.

Zoodra deze de miede ontving, sprong hij te peerd en, nauwelijks
gekleed en vergezelschapt door eenige gewapende ruiters en
voetknechten, kwam hij aan de boot.

En nog eens kon Uilenspiegel den wreeden admiraal zien, gekleed als
een heer, die in overvloed baadt.

--Goeden dag, heeren monniken, sprak hij. De handen op! Waar is het
bloed der heeren van Egmond en Hoorn? Gij toont mij uwe pootjes,
dat is wel van u....

Een monnik, Leonard genoemd, antwoordde:

--Doe met ons wat gij wilt. Wij zijn monniken, niemand zal ons
opeischen.

--Hij heeft goed gesproken, zeide Uilenspiegel; want vermits de
monnik afgebroken heeft met de wereld, dewelke vader en moeder,
broeder en zuster, gade en vriendin is, vindt hij op Gods uur
niemand, die hem opeischt. Nochtans, Excellentie, wil ik het doen:
Bij het teekenen van de overgave van Gorkum, bepaalde kapitein
Marinus dat die monniken vrij zouden wezen, gelijk al degenen,
die genomen werden in de citadel en die er uitkwamen. Zij werden er
echter zonder reden gevangen gehouden; ik hoor zeggen, dat zij zullen
gehangen worden. Heer, ootmoediglijk richt ik mij tot u, om hen voor
te spreken, want ik weet, dat soldatenwoord gulden woord is.

--Wie zijt gij? vroeg messire Lumey.

--Heer, antwoordde Uilenspiegel, ik ben Vlaming uit het schoone
Vlaanderenland, boer, edelman, alles te zamen, en door de wereld ga
ik aldus, om het goede en schoone te prijzen en volmondig te spotten
met alles wat dwaas en verkeerd is. En u zal ik prijzen, als gij de
belofte houdt, dewelke de kapitein heeft gesteld: Soldatenwoord is
gulden woord!

Maar de schavuiten, die met het oog op plundering bij de Geuzen waren
gekomen, zeiden:

--Heer, die is een verrader: hij heeft beloofd hen te redden; hij
heeft hun brood, hesp, worst en bier gegeven, en ons niets.

Messire Lumey zeide toen tot Uilenspiegel:

--Vlaming, die het goede prijst en monniken spijst, gij zult met
henzelven worden gehangen.

--Ik ben zonder vrees, antwoordde Uilenspiegel, soldatenwoord is
gulden woord!

--Daar hebt gij u iets moois op den hals gehaald, sprak Lamme.

--De assche klopt op mijn hert, zeide Uilenspiegel.

De monniken werden naar eene schuur gebracht, en Uilenspiegel met
hen; daar wilden zij hem bekeeren met godgeleerde bewijsvoeringen;
maar hij viel in slaap bij hunne reden.

Terwijl messire Lumey aan tafel zat, welke vol wijn en vol vleesch
stond, kwam een bode van Gorkum, vanwege kapitein Marinus, met het
afschrift van de brieven des Prinsen van Oranje, "lastende en bevelende
aan al de voogden van steden en andere plaatsen, de geestelijken in
gelijke veiligheid, zekerheid en privilege te houden als de andere
standen des volks".

De bode vroeg om bij Lumey toegelaten te worden, ten einde hem,
eigenhandig, het opschrift der brieven te geven.

--Waar is 't origineel? vroeg Lumey.

--Bij mijn meester Marinus, zeide de bode.

--En die boer zendt mij het afschrift! zeide Lumey. Waar is uw pas?

--Hier, heer, sprak de bode.

Messire Lumey las:

--"Mijnheer en meester Marinus Brand last al den ministers, stadhouders
en officieren der Vereenigde Provinciën, vrijelijk door te laten enz."

Lumey sloeg met de vuisten op de tafel en scheurde den brief aan
stukken; hij riep woedend uit:

--Verdoemd, waarmede bemoeit hij zich, die Marinus, die schooier,
die vóór de inneming van den Briel nog geene graat van een haring te
vreten had? Hij heet zich mijnheer en meester, en zendt bevelen aan
mij! Hij last en beveelt! Zeg aan uw meester, dat, mits hij zulk een
mijnheer en zulk een meester is, welk zoo goed lasten en bevelen kan,
de monniken op staanden voet zullen opgeknoopt worden, en gij daarbij,
als gij niet dadelijk opkraamt!

En met een schop onder de broek, smeet hij hem buiten de kamer.

--Drinken! riep hij. Hebt gij de verwatenheid van dien Marinus
gezien? Ik ben woedend! Dat men de monniken dadelijk opknoope in
hunne schuur, en dat men dien Vlaming voor mij brenge, nadat hij hun
halsrecht bijgewoond heeft. We zullen eens zien of hij mij zal durven
zeggen, dat ik slecht deed. Alle duivels! waarom zijn hier nog potten
en glazen van doen?

En met groot gerucht sloeg hij de bekers en het vaatwerk kapot, en
niemand durfde hem aanspreken. De knechten wilden de stukken oprapen,
maar hij liet het niet toe; onmatig ledigde hij de eene flesch na de
andere, en hij werd nog woedender, want hij liep met groote stappen
de kamer op en neer, razend de scherven onder de voeten vertrappend.

Uilenspiegel werd vóór hem gebracht.

--Hewel, zeide hij hem, brengt gij mij miede van uwe vrienden,
de monniken?

--Zij zijn gehangen, sprak Uilenspiegel, en een lafhertige beul,
door baatzucht gedreven, heeft een hunner, na zijnen dood,
den buik en de zijden geopend, om aan een apotheker het vet te
verkoopen. Soldatenwoord is geen gulden woord meer!

Lumey, voort de scherven vertrappend, bulderde:

--Gij trotseert mij, armzalige nietdeug, maar gij ook zult gehangen
worden, niet in eene schuur, maar schandelijk op de Markt, in het
aanschijn van elkeen.

--Schande over u, sprak Uilenspiegel, schande over ons: soldatenwoord
is geen gulden woord meer!

--Wilt gij zwijgen, ijzeren kop! riep messire Lumey.

--Schande over u, sprak Uilenspiegel, soldatenwoord is geen guldenwoord
meer! Straf liever de nietdeugen, verkoopers van menschenvet!

Messire Lumey vloog naar hem toe en hief de hand op om hem te slaan.

--Sla, sprak Uilenspiegel, ik ben uw gevangene, maar ik heb geen
schrik van u: Soldatenwoord is geen gulden woord meer!

Toen trok messire Lumey zijn degen en zeker had hij Uilenspiegel
gedood, zoo Treslong zijn arm niet weerhouden had, zeggende:

--Medelijden! hij is moedig en dapper, en heeft geenerlei misdaad
bedreven.

Lumey veranderde toen van gedachte en sprak:

--Dat hij vergiffenis vrage!

Maar Uilenspiegel bleef rechtstaan en sprak:

--Ik zal het niet doen.

--Dat hij ten minste zegge, dat ik geen ongelijk had, riep Lumey nog
blakend van woede.

Uilenspiegel antwoordde:

--Ik lik de hielen der heeren niet: soldatenwoord is geen gulden
woord meer!

--Dat men de galge oprichte, sprak Lumey, en dat men hem wegbrenge,
dat zal woord van kemp voor hem wezen.

--Ja, antwoordde Uilenspiegel, en voor het vergaderde volk zal ik u
toeroepen: Soldatenwoord is geen gulden woord meer!

De galge werd opgericht op de Groote Markt. De mare liep weldra door
de stad, dat men Uilenspiegel ging hangen, den dapperen Geus. En het
gemeen was tot weenens toe bewogen. En in groote menigte snelde het
naar de Groote Markt; messire Lumey, te peerd, kwam er ook, daar hij
zelf het teeken van de terechtstelling wilde geven.

Wrokkig keek hij naar Uilenspiegel op de ladder, gekleed voor den
dood, in zijn hemd, de armen op zijn lichaam gebonden, de handen
samengevouwen, het strop om den hals, met den hangman naast zich,
welke gereed was om de straf te volbrengen.

Treslong zeide tot Lumey:

--Heer, schenk hem genade; hij is geen verrader, en nimmer zag men
een man hangen omdat hij openhertig en meewarig was.

Toen de mannen en vrouwlieden uit 't volk de woorden van Treslong
hoorden, riepen zij:

--Genade heer, genade, heb medelijden met Uilenspiegel.

--Die ijzeren kop heeft mij getrotseerd, sprak Lumey: dat hij berouw
hebbe en zegge, dat ik wel gedaan heb.

--Wilt gij berouw hebben en zeggen, dat hij wel gedaan heeft? vroeg
Treslong tot Uilenspiegel.

--Soldatenwoord is geen gulden woord meer, zeide Uilenspiegel.

--Steek het strop over zijnen hals, beval Lumey.

De hangman wilde gehoorzamen, doch een meideken, heel in 't wit
gekleed, met een kroontje op 't hoofd, beklom als waanzinnig de
trappen van het schavot, vloog Uilenspiegel om den hals en zeide:

--Die man is de mijne, ik neem hem tot echtgenoot!

En het volk juichte toe, en de vrouwlieden riepen:

--Leve, leve het meideken, dat Uilenspiegel redt van den dood!

--Wat beteekent die zotternij? vroeg messire Lumey.

Treslong antwoordde:

--Volgens de costumen en gebruiken van de stede, is het recht en wet,
dat een jonge dochter, maagd of ongehuwd, een man van de koord redt,
als zij hem aan den voet van de galge tot echtgenoot neemt.

--God is met hem, zeide Lumey; maak hem los!

Hij reed tot omtrent het schavot en zag het meideken druk bezig met
Uilenspiegel's koorden door te snijden, terwijl de beul het heur
wilde beletten, zeggende:

--Als gij ze doorsnijdt, wie zal ze betalen?

Maar het meideken luisterde niet.

Als hij heur zoo vlug en ijverig en liefdevol bezig zag, was hij
verteederd.

--Wie zijt gij? vroeg hij.

--Ik ben Nele, zijne bruid, zeide zij, en kom uit Vlaanderen om hem
te halen.

--Gij kwaamt in tijds, zeide Lumey op barschen toon.

En hij toog henen.

Treslong naderde toen en sprak:

--Brave Vlaming, wilt gij op onze schepen nog dienen, als gij
getrouwd zijt?

--Ja, messire, antwoordde Uilenspiegel.

--En gij, meideken, wat zult gij doen zonder uwen man?

Nele antwoordde:

--Als gij wel wilt, messire, zal ik bij hem blijven op zijn schip en
op de pijp spelen.

--Zeker, wil ik, antwoordde Treslong.

En hij gaf heur twee gulden voor de bruiloft.

En Lamme, die weende en lachte van blijdschap, zei:

--Hier zijn nog drie gulden: wij zullen lekker gastreeren; ik
trakteer. Komt, we gaan naar den Gouden Kam. Hij is niet dood, mijn
vriend! Vive le Geus!

En het volk juichte toe, en zij trokken naar den Gouden Kam, alwaar
een groot feestmaal besteld werd, en Lamme smeet, door het venster,
oortjes te grabbel naar 't volk.

En Uilenspiegel zeide tot Nele:

--Liefste, nu zijt ge bij mij. Hoezee! zij is hier, in levenden
lijve, met hart en met ziel, mijn zoete vriendin. Ho! die zachte
oogen en die schoone roode lippen, over dewelke nooit anders dan
goede woorden kwamen! Zij redde mij 't leven, de welbeminde! Op onze
schepen zult gij de pijp der verlossing bespelen. Herinnert gij u nog
... doch neen.... Voor ons is thans blijdschap en vreugde, voor mij
uw gezichtje, dat zoet is als de bloemen in de Zomermaand. Ik ben in
het hemelrijk! Maar, zeide hij, gij weent....

--Zij hebben heur gedood, zeide zij.

En zij vertelde hem de rouwvolle mare.

En zij staarden elkander aan, en weenden van minne en van smerte.

En op het festijn aten en dronken zij, en Lamme keek hen jammerlijk
aan.

--Laas, zuchtte hij, waar zijt gij, mijne vrouw?

En de priester kwam en trouwde Nele en Uilenspiegel.

En de morgenzon vond hen bij elkander in 't huwelijksbed.

En Nele rustte met heur hoofdje op den schouder van Uilenspiegel. En
als zij ontwaakte in de zonne, zeide hij:

--Frisch gezichtje en zoet hertje, wij zullen de wrekers van Vlaanderen
wezen!

Zij kuste hem op den mond en zeide:

--Dolle kop en sterke arm, God zegene de pijp en het zweerd!

--Ik zal u een soldatendos maken.

--Dadelijk? vroeg zij.

--Dadelijk, antwoordde Uilenspiegel; maar wie dan zegt, dat aardbeziën
lekker zijn, 's morgens? Uw mond is veel zoeter!




IX.

Evenals hunne vrienden en gezellen, hadden Uilenspiegel, Lamme en
Nele, den kloosters het goed teruggenomen, dat deze vergaard hadden,
door middel van begankenissen, valsche mirakelen en andere Roomsche
mommerijen, ten koste van 't onnoozele volk. Dit was in strijd met
de bevelen van den Zwijger, den prins van de vrijheid, maar het
geld diende voor de kosten des oorlogs. Lamme Goedzak vergenoegde
zich niet met het geld, doch hij roofde nog in de kloosters hespen,
worsten, bottels bier, flesschen wijn; niet zelden kwam hij terug met
eene weitasch vol gevogelte, kalkoenen, ganzen, kapoenen en kiekens
op den buik en met eenige monnikenverkens en kloosterkalveren achter
zich aan een touw. En dit krachtens het oorlogsrecht, naar hij zeide.

Vol blijdschap bij elke verovering, bracht hij zijn buit naar het
vaartuig om er lekker mee te smullen; maar hij deed bitter zijn
beklag, dat de kok zoo weinig ervaren was in de edele konsten van
koken en braden.

Nu, dien dag hadden de Geuzen een lekker glaasje op de zege gedronken,
en ze zeiden tot Uilenspiegel:

--Gij staat steeds met den neus in den wind, om tijdingen van het
vasteland te vernemen; gij kent al de krijgsavonturen: zing ze ons
eens. Maar Lamme moet op de trom slaan en de bevallige pijpster zal
naar de maat van het lied spelen.

En Uilenspiegel zeide:

--Op een frisschen, helderen Meimorgen, vond Lodewijk van Nassau
dewelke Bergen meende binnen te rukken, zijne voetknechten en zijne
ruiters niet meer. Eenige vertrouwden hielden eene poort geopend
en eene brug was neergelaten, opdat hij de stede kon nemen. Maar
de poorters bemachtigden de brug en de poort. Waar zijn de soldaten
van graaf Lodewijk? De poorters gaan de brug ophalen. Graaf Lodewijk
blaast op den horen.

En Uilenspiegel zong:


    Waar zijn uw voetgangers? Waar uw ruiters?
    Verdwaald in het bosch, alles vertredend,
    Dorre twijgjes en bloeiende klokjes.
    Vrouw Zon doet blinken
    Roode strijdlustige wezens
    En glansende manen van rossen.
    Graaf Lodewijk steekt den hoorn.
    Ze hooren 't. Slaat zacht de trom.

    In gestrekte vaart, met schuimend gebit,
    Bliksemren, wolkenren,
    Een hoos van kletterend staal!
    Zij vliegen, de zware ruiters!
    Spoed, spoed! Ter hulp!
    De brug gaat op.... De spoor
    In den bloedenden buik der paarden.
    De brug gaat op: verloren stad.

    Er vóór reeds. Is het te laat?
    Te vierklauw, met schuimend gebit!
    Chaumont, op zijn gelen vos,
    Springt op de brug die terugvalt.
    Gewonnen stad! Hoort gij
    Op Bergens plaveien,
    Bliksemren, wolkenren,
    Een hoos van kletterend staal?

    Leve Chaumont en de gele vos!
    Klaroent uw vreugd uit, slaat op de trom;
    Hooimaand is 't, de weiden geuren.
    De leeuwerik stijgt, tiereliert in de lucht:
    Leve de vrije vogel!
    Slaat op de trom der glorie.
    Leve Chaumont en de vos!
    Alhier, te drinken!
    Gewonnen stad. Leve de Geus!


En de Geuzen zongen op de schepen:

Christus, zie uwe soldaten. Zegen onze wapenen, Heer. Leve de Geus.

En Nele met heur lachend gezichtje speelde op de pijp, en Lamme
sloeg op de trom, en naar omhoog, naar den hemel, den tempel Gods,
verhieven zich gouden kelken en lofzangen van vrijheid. En de baren,
helder en frisch, suisden welluidend rondom het schip als meerminnen,




X.

Eens, in de Oogstmaand, op een zwaren en warmen dag, was Lamme
droefgeestig. Zijn blijde trom zweeg en sliep stil, de stokken
staken weemoedig uit de opening zijner tassche. Uilenspiegel en
Nele, glimlachend van blijde minne, koesterden zich in de zonne; de
matrozen op kijkuit in de marsen, floten of zongen, en tuurden naar
de wijde zee, om te weten of zij geene prooi aan den gezichteinder
zagen. Treslong ondervroeg hen, en steeds antwoordden zij: Niets!

En Lamme, bleek en afgemat, zuchtte jammerlijk. En Nele zei hem:

--Hoe komt het, Lamme, dat gij zoo treurig gestemd zijt?

En Uilenspiegel zei hem:

--Gij wordt mager, mijn jongen.

--ja, zeide Lamme, ik ben treurig en mager. Mijn hert verliest zijne
vroolijkheid, en mijn goede tronie heure frischheid. Ja, lacht maar met
mij, gijlie, die, na duizenden gevaren, elkander terugvondt. Spot maar
met den armen Lamme, die, getrouwd zijnde, leeft als een weduwnaar,
terwijl deze hier--zeide hij, naar Nele wijzend--heuren man moest
ontrukken aan de kussen der koorde, welke toch zijne laatste
minnaresse zal wezen. Zij deed wel, God zij geloofd; maar dat ze
niet lache met mij. Ja, Nele, mijne vriendin, gij moet met den armen
Lamme niet spotten. Mijne vrouw lacht voor tien, laas! gijlie vrouwen
zijt ongevoelig voor eens andermans leed. Ja, mijn hert is treurig,
het is getroffen door het zweerd der verlatenheid; en niets zal het
kunnen versterken, dan zij.

--Of een lekkere stoverije, zeide Uilenspiegel.

--Ja, zeide Lamme, waar is het vleesch hier op dit treurig schip? Op
de bodems des konings hebben zij viermaal vleesch in de week--als er
geene vasten in valt--en driemaal visch. Wat aangaat de visch, ik mag
verdoemd zijn als die bloedlooze vezelen iets anders doen dan nutteloos
mijn arm bloed ontsteken, dat binnenkort in water zal vergaan. De
Spanjolen hebben bier, kaas, soep en goede dranken. Ja, om hunne
magen te streelen, hebben zij alles: beschuit, peperkoek, bier, boter,
gerookt vleesch; ja alles: gedroogde visch, kaas, mosterdzaad, zout,
boonen, erwten, gort, azijn, olie, vet, hout en kolen. Ons komt men
verbieden het beestiaal te nemen van wie hoegenaamd, 't zij poorter,
abt of edelman. Wij eten haring en drinken kort bier. Laas! niets heb
ik nog: noch liefde der vrouw, noch goeden wijn, noch dobbel bruinbier,
noch lekkere spijzen. Waar is hier onze vreugde?

--Ik ga het u zeggen, Lamme, antwoordde Uilenspiegel. Oog om oog, tand
om tand: te Parijs hebben ze, in den Bartholomeusnacht, tienduizend
vrije herten gedood in de stad alleen; de koning zelf schoot naar zijn
volk! Ontwaak, Vlaming, grijp naar de bijl, zonder genade! Dáár ligt
onze vreugde. Tref de vijanden, 't zij Roomschen of Spanjaards, overal
waar gij ze vindt. Denk thans niet aan uwen buik. De slachtofferen,
doode en levende, allen ondereen, werden gebracht naar den stroom
en met gansche karrevrachten in 't water gestort. Hoort gij, Lamme,
dooden en levenden, allen ondereen? Negen dagen lang was de Seine rood
van het bloed, en de raven vielen bij zwermen op de stad neder. Te
La Charité, te Rouaan, Toulouse, Lyon, Bordeaux, Bourges, Meaux was
de slachting afgrijselijk. Ziet gij die benden volgekropte honden
liggen omtrent de lijken? Hunne tanden zijn moede. De vlucht van de
raven is log, zoodanig is heure maag overlast met het vleesch van de
slachtofferen. Hoort gij, Lamme, de stemme der zielen, die dorsten
naar wraak? Ontwaak, Vlaming. Gij spreekt van uwe vrouw. Ik geloof
niet dat ze ontrouw is, maar enkel waanzinnig, en zij bemint u nog
steeds, arme vriend: zij bevond zich niet te midden dier hofdamen,
dier wulpsche vampieren, welke, den nacht zelven der slachting, met
heur fijne handjes de lijken ontblootten. En zij lachten van genot,
die adellijke hoeren! Verheug u, mijn vriend, niettegenstaande uwe
visch en uw kort bier. Is de nasmaak van haring wat flauw, flauwer nog
is de reuk van die laagheid! Zij, die gemoord hebben, gastreeren nu;
en met hunne handen, waar nog bloed aan kleeft, ziet men ze vette
ganzen voorsnijden, om de vleugels, de billen en de stuit te bieden
aan schoone freules van Parijs. Zoo even tastten die jonkvrouwen naar
ander vleesch, naar koud vleesch!

--Ik zal nimmermeer klagen, zeide Lamme rechtstaande: haring is zalm,
kort bier is malvezij voor vrije herten! Vive le Geus!

En Uilenspiegel sprak:


    Leve de Geus! Niet weenen broeders.
    In puinen en bloed
    Bloeit de roos der vrijheid.
    Is God met ons, wie tegen?

    Zegeviert de hyena,
    Dra komt de leeuw.
    Met één klauwslag werpt hij haar, gescheurd, ten gronde.
    Oog voor oog, tand voor tand. Leve de Geus.


En de Geuzen op de schepen zongen:


    De hertog bescheert ons het eigenst lot.
    Oog voor oog, tand voor tand,
    Wond voor wond. Leve de Geus!




XI.

Het was een stikdonkere nacht; de storm loeide in de zwarte, sombere
wolken; Uilenspiegel stond met Nele op het dek van het schip en sprak
tot heur:

--Al onze vuren zijn uitgedoofd. Wij zijn vossen, die des nachts
azen op Spaansch wild, 't is te zeggen op hunne twee en twintig
bodemen, rijke schepen waarop lanteernen flikkeren, welke voor hen
ongelukssterren zijn. En wij, wij zullen ze overvallen.

Nele sprak:

--Deze nacht is een tooveraarsnacht. De hemel is zwart als de monding
der hel, de bliksemschichten flikkeren als de grimlach van Satan, de
verre storm bromt met een dof geloei, de meeuwen vliegen met schelle
kreten voorbij; de zee rolt heure lichtende golven als zilveren
slangen. Thijl, mijn geliefde, kom mee in de wereld der geesten! Neem
het tooverpoeder!

--Zal ik de Zeven zien, liefste?

En zij aten het tooverpoeder.

En Nele sloot Uilenspiegel's oogen, en Uilenspiegel sloot Nele's
oogen. En zij zagen een verschrikkelijk schouwspel.

Hemel, aarde en zee waren vol mannen, vrouwlieden, kinderen, die
wrochten, dobberden, liepen of droomden. De zee slingerde hen, de
aarde droeg hen. En zij krielden als palingen in eene ben.

Op tronen in 't midden van den hemel, zaten zeven mannen en
vrouwen, met een flikkerende ster op het voorhoofd; maar zij waren
zoo onduidelijk, dat Nele en Uilenspiegel alleen hunne sterren
onderscheiden konden.

De zee steeg omhoog tot den hemel en rolde in heur schuim de ontelbare
menigte schepen mede, welker masten en touwen tegen elkander stieten,
braken, verpletterden naar gelang van de onstuimige bewegingen der
golven. Toen verscheen een schip te midden van al de anderen. Zijne
buitenhuid was van vlammend ijzer. Zijne kiel was van staal,
scherp als een mes. Het water schreeuwde, zuchtte als zij het
doorkliefde. Grijnzend zat de Dood op de achterplecht van het schip,
met zijne zeis in eene hand en in de andere een zweep, met dewelke
hij de zeven personages sloeg. Een derzelven was een treurige,
magere, trotsche, stilzwijgende vrouw. In eene hand hield zij een
schepter en, in de andere, een zweerd. Naast haar zat eene vrouw met
vuurroode wangen schrijlings op eene geit; met heur bloote borsten,
heur halfgeopend kleed, heur wulpsche oogen, strekte zij zich ontuchtig
uit naast een oude jodin, die roestige nagelen opraapte, en een dikke,
opgezwollen vrouw, die nederviel telkens dat zij heur rechthielp,
terwijl een magere man beiden razend sloeg. Noch de dikke vrouw,
noch hare roodwangige gezellin sloegen weder. Midden onder hen zat
een monnik worsten te eten. Eene vrouw, die ten gronde lag, kroop als
eene slang tusschen de anderen. Zij beet de oude jodin ter oorzake
van hare nagelen, de opgeblazen vrouw omdat zij te veel genoegen had,
de roodwangige vrouw ter oorzake van den vochtigen glans heurer oogen,
den monnik om zijne worsten, en de magere vrouw ter oorzake van haren
schepter. En allen vochten weldra met elkander.

Toen zij voorbijvoeren, was het gevecht verschrikkelijk op de zee,
in den hemel en op de aarde. Het regende bloed. De schepen werden
geslecht met bijlen, met bussen, met kanonnen. De stukken vlogen in
de lucht, te midden van den rook van het kruit. Op de aarde stieten
de heiren tegen elkander als muren van staal. Steden, dorpen, oogsten
brandden onder kreten en tranen; hooge torens, als kantwerk van steen,
wierpen hunne schaduwen op het midden van 't vuur en vielen neder,
als gevelde eiken, met een vreeselijk gekraak. Eene menigte zwarte
ruiters, dicht bijeengedrongen als benden mieren, met het zweerd in
de hand, de pistool in de vuist, sloegen de mannen, de vrouwlieden
en kinderen. Eenigen kapten bijten in 't ijs en smeten de grijsaards
levend onder de schotsen; anderen sneden de borsten der vrouwen af en
strooiden peper in de gapende wonden; anderen nog hingen de kinderen
in de schoorsteenen op. Zij, die moede van slaan waren, verkrachtten
een meideken of eene vrouw, dronken, dobbelden, en roerden stapels
goudstukken--vrucht van de plundering--met hunne handen, waaraan nog
bloed kleefde.

De met sterren gekroonde zeven riepen: "Genade voor de arme wereld!"

En de spoken grijnsden. En hunne stemmen geleken op die van duizenden
nachtuilen, die te gelijk krassen. En de Dood zwaaide met zijne zeis.

--Hoort gij ze? sprak Uilenspiegel; zij zijn de roofvogelen der
arme menschen. Zij leven van de kleine vogelen, die de goeden en
eenvoudigen zijn.

En de met sterren gekroonde Zeven riepen: "Liefde, gerechtigheid,
goedertierenheid!"

En de zeven spoken grijnsden. En hunne stemmen geleken op die van
duizenden nachtuilen, die te gelijk krassen. En de Dood sloeg hen
met zijne zweep.

En het schip vaarde op den vloed en sneed alles in twee: booten,
vaartuigen, mannen, vrouwlieden, kinderen. Op de zee weergalmde het
gejammer der slachtofferen, die riepen: "Genade!"

En het roode schip ging over hen allen heen, terwijl de grijnzende
spoken krasten als nachtuilen.

En de Dood dronk dit water, hetwelk rood zag. van bloed.

En toen het schip in de nevelen verdwenen was, hield het gevecht op
en verzwonden de met sterren gekroonde Zeven.

En Uilenspiegel en Nele zagen anders niets meer dan den pikzwarten
hemel, de holle, bruisende zee, de donkere wolken, die voortgejaagd
werden boven het lichtende water en, dichter bij, bleekroode sterren.

Het waren de lanteernen van de twee en twintig bodemen der vloot. De
zee en de donder lieten een dof gerol hooren.

En Uilenspiegel trok zachtjes aan de wacharmklok en riep:--De
Spaanjaard! De Spanjaard! Hij stevent op Vlissingen!

En de kreet werd herhaald door geheel de Geuzenvloot.

En Uilenspiegel zeide tot Nele:

--Een grijze tint kleurt de zee en den hemel. De lanteernen flikkeren
nog slechts zwak; de ochtendschemering breekt aan, de wind wordt
frisscher, de baren werpen heur schuim over 't dek van de schepen, een
felle regen valt, doch eindigt weldra, de zon verrijst in volle gloor
en verguldt de toppen der golven: dat is uw glimlach, Nele, frisch als
het krieken van den morgen, zacht als de straal van de rijzende zon.

De twee en twintig bodemen varen voorbij; op de schepen der Geuzen
hoort men trommels en pijpen; Lumey roept: "In name des Prinsen,
op jacht!" Ewoud Pietersen Worst, schout-bij-nacht, roept: "In name
van Zijne Hoogheid, den Prins van Oranje en messire den admiraal, op
jacht!" Op al de schepen: op de Johanna, den Zwaan, de Anne-Mie den
Geus, het  Eedverbond, den Egmond, den Hoorn, den Willem de Zwijger,
roepen al de kapiteins: "In name van Zijne Hoogheid, den Prins van
Oranje en messire den admiraal, op jacht!"

--Op jacht! Vive Le Geus! roepen de soldaten en de matrozen.

De hulk van Treslong, op dewelke Uilenspiegel diende, en den-Briel
genaamd, van dichtbij gevolgd door de Johanna, den Zwaan en den
Geus, bemachtigt vier Spaansche bodemen. De Geuzen werpen al wat
Spaansch is in 't water, nemen de Nederlanders gevangen, ledigen
de vaartuigen als eierdoppen en laten ze, zonder masten of zeilen,
dobberen in de reede. Daarna achtervolgen zij de achttien andere
bodemen. De wind waait geweldig uit het gat van Antwerpen, de muur
der snelle vaartuigen buigt in het water van den stroom, onder 't
gewicht van de zeilen, die gezwollen staan als de kaken eens monniks
bij den wind die waait uit de keuken; de Spaansche bodemen varen snel;
de Geuzen achtervolgen ze tot in de reede van Middelburg, onder het
vuur van de forten. Daar ontstaat een bloedig gevecht; de Geuzen,
met hun enterbijlen in de hand, springen op het dek van de schepen,
welke weldra vol liggen met afgekapte armen en beenen, die men, na het
gevecht, bij manden in den vloed werpen moet. De forten schieten naar
hen; zij lachen er mee, en onder den kreet van: "Vive le Geus", nemen
zij in de Spaansche bodemen, kruit, kanonnen, kogels en koren. Als
de vaartuigen geledigd zijn, verbranden zij die; dan varen zij naar
Vlissingen, en laten ze walmen en uitbranden in de reede.

Van daar zullen zij mannen zenden, die Zeelands en Hollands dijken
zullen doorsteken, nieuwe schepen zullen helpen maken, en namelijk de
vliebooten van honderd veertig ton, die tot twintig gegoten ijzeren
stukken voeren.




XII.

Het sneeuwt op de schepen. Heinde en ver is de lucht wit, en zonder
ophouden valt de sneeuw immer door in het zwarte water, in hetwelk
zij smelt.

Het sneeuwt op het land: wit zijn de wegen, ook wit de flauwe schimmen
der ontbladerde boomen. Geenerlei gerucht is te hooren, tenzij het
verre gelui van Haarlems klokken, die het uur slaan, en van den
blijden beiaard, die in de dikke lucht zijn gesmoorde tonen zendt.

Luidt niet, klokken; speel uw zachte, eenvoudige deuntjes niet,
beiaard: don Frederik nadert, de zoon van den bloedigen hertog. Hij
komt op u af, gevolgd van vijf en dertig vendels Spanjaarden, uwe
doodvijanden, Haarlem, o stede van vrijheid; twee en twintig vendels
Walen, achttien vendels Duitschers, achthonderd peerden, een machtig
geschut volgen hem. Hoort gij op de wagens het geknars van het doodend
ijzer? Falkonetten, slangen, donderbussen met wijden mond, dat alles
is voor u, Haarlem. Luidt niet, klokken; werp uw blijde tonen niet
meer in de met sneeuw bezwangerde lucht, lustige beiaard.

--Wij, klokken, zullen luiden; ik, beiaard, ik zal zingen en mijn
stoute tonen werpen in de met sneeuw bezwangerde lucht. Haarlem is de
stad van de dappere harten, de kloekmoedige vrouwen. Van de hoogte
heurer torens ziet zij, zonder vrees, de zwarte drommen der beulen,
als helsche mieren naderen, met golvende bewegingen: Uilenspiegel,
Lamme en honderd Watergeuzen zijn binnen heure muren. Hunne vloot
kruist op het meer.

--Laat ze komen! zeggen de inwoners; wij zijn maar poorters, visschers,
zeelieden en vrouwen. De zoon van den hertog van Alva wil, naar hij
zegt, om onze stede binnen te komen, geen andere sleutels dan zijne
donderbus. Dat hij, als hij kan, die zwakke poorten opene: daarachter
zal hij mannen vinden. Luidt, klokken; werp uw blijde tonen in de
met sneeuw bezwangerde lucht, beiaard!

... Wij hebben slechts zwakke muren en onze grachten zijn gemaakt naar
de oude wijs. Veertien donderbussen braken hare zes en veertigponders
naar de Kruispoort. Stelt mannen daar, waar steenen ontbreken. De
nacht komt, een ieder werkt, 't is alsof het kanon zich hier nimmer
hooren liet. Naar de Kruispoort hebben zij zeshonderd tachtig bommen
geschoten; naar Sint-Janspoort, zeshonderd vijf en zeventig. Die
sleutels openen niet, want ziet, daarachter verheft zich een nieuw
bolwerk. Luidt, klokken; werp, beiaard, uw blijde tonen in de
bezwangerde lucht!

... Het kanon beschiet, beschiet altoos de muren, steenen springen er
af, muurvlakken storten neer. De bres is breed genoeg om eene compagnie
in front door te laten. Zij schreeuwen: "Bestorming! doodt! doodt!" Zij
wagen de beklimming, zij zijn met tienduizend; laat ze komen over
de grachten met hunne bruggen. Onze kanonnen staan gereed. Daar is
de kudde, die moet sterven. Groet hen, kanonnen der vrijheid! Zij
groeten: de kettingkogels, de stormhoepels, de brandende pikkransen
vliegen en fluiten, boren en kappen in het gros der belegeraars, die
nederzijgen of in wanorde vluchten. Vijftienhonderd dooden vervullen
de grachten. Luidt, klokken, en gij, beiaard, werp uw blijde tonen
in de bezwangerde lucht!

... Komt terug ter bestorming! Zij durven niet. Zij beginnen opnieuw
te schieten en te mineeren. Wij ook, wij kennen de kunst van de
mijn. Steekt, steekt de wiek aan onder henzelven; loopt, wij krijgen
een prachtig vuurwerk te zien. Vierhonderd Spanjolen vliegen in de
lucht! Dat is de weg niet naar de eeuwige vlammen. O, wat blijde
dans bij het zilveren geluid onzer klokken, bij de lustige muziek
van den beiaard!

... Ze weten dus niet, dat de prins waakt over ons, dat ons, alle
dagen, langs goedbewaakte wegen, sledevrachten koren en buskruit
geworden; koren voor ons, buskruit voor hen. Waar zijn hunne zeshonderd
Duitschers, die wij doodden en verdronken in 't Haarlemmermeer? Waar
zijn de elf vendels, die wij hun namen, de zes donderbussen en de
vijftig ossen? Wij hadden één ringmuur, nu hebben wij er twee. De
vrouwen zelven vechten mede, en Kenau Hasselaar voert heure dappere
zusteren aan. Komt, beulen, komt in onze straten, de kinderen zullen
u de knieën doorsnijden met hunne mesjes. Luidt, klokken, en gij,
beiaard, werp uw blijde tonen in de bezwangerde lucht!

... Maar het geluk is met ons niet. De vloot van de Geuzen wordt
verslagen op het meer. Zij zijn verslagen, de troepen, die de Prins van
Oranje ons zond. Het vriest, het vriest bitter. Geene hulp meer! Sedert
vijf maanden, wederstaan wij met duizend man tegen tienmaal zooveel. Nu
moeten wij met de beulen onderhandelen. Maar zal hij van onderhandeling
willen hooren, die bloedige hertog, die onzen val heeft gezworen? Laat
ons een uitval wagen met al onze soldaten: misschien banen zij zich een
weg door de vijandelijke drommen. Maar de vrouwen staan aan de poorten,
uit vrees dat men heur alleen de stede late bewaken. Luidt niet meer,
klokken; werp uw blijde tonen in de lucht niet meer, beiaard.

... Nu zijn wij in de Zomermaand, het hooi riekt lekker, het koren
rijpt in de zonne, de vogelen zingen: vijf maanden lang hadden wij
honger; de stede is in rouw; wij zullen allen uit Haarlem trekken, de
busschutters aan 't hoofd om den weg te banen, de vrouwen, de kinderen
en de magistraat daarachter, gevolgd door het voetvolk, dat waakt op de
bres. Een brief, een brief van den zoon van den bloedigen hertog! Is
't de dood, dien hij ons meldt? neen, 't is het leven aan allen,
die zijn in de stede. O, onverbeide genade, o leugen wellicht! Zult
ge nog zingen, blijde beiaard? Zij komen de stede binnen....

Uilenspiegel, Lamme en Nele hadden den dos van de Duitsche soldaten
aangetrokken, die met hen, ten getale van zeshonderd, opgesloten
waren in het Augustijnerklooster.

--Vandaag zullen wij sterven, zei Uilenspiegel stille tot Lamme. En aan
zijne borst drukte hij het liefelijke lichaam van Nele, die huiverde
van schrik.

--Laas! mijne vrouw, nimmermeer zal ik ze zien, zeide Lamme.

Maar wellicht redden die kleederen van Duitsche soldaten ons 't leven?

Uilenspiegel schudde het hoofd om te bedieden, dat hij aan geene
genade geloofde.

--Ik hoor het gerucht van de plundering niet, zeide Lamme.

Uilenspiegel antwoordde:

--Volgens de overeenkomst, hebben de poorters de plundering en
het leven afgekocht, mits de somme van tweehonderd veertigduizend
gulden. Binnen twaalf dagen moeten zij honderdduizend gulden in
klinkende munte betalen, en de rest drie maanden later. Aan de vrouwen
werd bevolen de wijk te nemen in de kerken. Zij gaan ongetwijfeld de
slachting beginnen. Hoort gij de galgen en schavotten optimmeren?

--Ha! wij zullen sterven! sprak Nele; ik heb honger.

--Ja, sprak Lamme stille tot Uilenspiegel, de zoon van den bloedigen
hertog heeft gezeid, dat wij, uitgehongerd zijnde, gedwee naar de
strafplaats zullen tiegen.

--Ik heb zoo'n honger! sprak Nele.

's Avonds kwamen soldaten, en zij deelden een brood voor zes man uit.

--Driehonderd soldaten werden gehangen op de Markt, zeiden zij. Weldra
is 't uwe beurt. Geuzen en galgen hooren immer bijeen.

Den volgenden avond, kwamen zij nog met een brood voor zes man.

--Vier hoogpoorters, zeiden zij, werden onthalsd. Tweehonderd acht
en veertig soldaten werden twee aan twee gebonden en in de zee
gesmeten. De krabben zullen vet zijn dees jaar. Gij hebt geen goede
tronie, gijlie, sedert den 7n van Hooimaand, dat gij hier zijt. Wat
zijn zij slokkers en dronkaards, die inwoners der Nederlanden! wij,
Spanjaarden, generen ons met eenige vijgen voor ons avondmaal.

--'t Is zeker daarom, antwoordde Uilenspiegel, dat gij overal bij
de poorters uw vier eetmalen met vleesch, gevogelte, vla, wijn en
confituur eischt; en melk om het lichaam van uwe muchachas te wasschen,
en wijn om de pooten uwer peerden te baden?

Den 18n van Hooimaand zeide Nele:

--Mijne voeten zijn nat; wat is dit?

--'t Is bloed, zeide Uilenspiegel.

's Avonds kwamen de soldaten opnieuw met hun brood voor zes man.

--Daar waar de koorde niet volstaat, doet het zweerd het werk, zeiden
zij. Drijhonderd soldaten en zeven en twintig poorters, die de stede
meenden te ontvluchten, wandelen nu in de helle, met hun hoofd onder
hunnen arm.

's Anderen daags stroomde het bloed opnieuw in het klooster; de
soldaten kwamen geen brood brengen, maar alleenlijk naar de gevangenen
kijken en zeggen:

--De vijfhonderd Walen, Engelschen en Schotten, die gisteren onthalsd
werden, hadden een betere tronie. Dezen hebben honger, gewis; doch
wie dan zou sterven van honger, ten ware de Geus?

En, inderdaad, allen bleek, mager ontdaan en bibberend van koorts,
stonden zij daar lijk spoken.

Den 16n van Oogstmaand, om vijf uren's avonds, kwamen de soldaten
lachend binnen en zij gaven hun brood, kaas en bier. Lamme sprak:

--Dit is ons doodmaal.

Te tien uren kwamen vier vendrigs; de hoplieden deden de poorten van
vier kloosters openen en bevalen den gevangenen gevieren achter de
pijpen en trommels te gaan, tot aan de plaats, waar men hen zou doen
stilstaan. Sommige straten waren rood van 't bloed; en zij stapten naar
't Galgeveld.

Hier en daar waren de weiden bemorst met plassen bloed; overal was er
bloed op de muren gespat. De raven kwamen bij zwermen van alle kanten;
de zonne verborg zich in een bed van dampen, de hemel was nog helder,
en in het diepste deszelven ontwaakten schuchter de sterren. Eensklaps
hoorden zij een hertverscheurend gehuil.

De soldaten zeiden:

--Die daar schreeuwen, zijn de Geuzen van het fort Fuike, buiten de
stad; men laat ze sterven van honger.

--Wij ook, zeide Nele, wij gaan sterven.

En zij weende.

--De assche klopt op mijn hert, zeide Uilenspiegel.

--Ha! zeide Lamme in 't Vlaamsch,--de soldaten van het geleide
verstonden die mannelijke taal niet,--ha! zeide Lamme, had ik dien
bloedigen hertog onder handen en kon ik hem, tot zijne kroenge er van
berst, alle die koorden, galgen, pijnbanken, foltertuigen, gewichten
en Spaansche leerzen doen eten; kon ik hem doen drinken al het bloed,
dat door hem werd vergoten; kon ik, na duizenden folteringen, hem het
hert uit de borst rukken en hem dit rot en giftig ingewand rauw doen
eten! Dan zou hij voorzeker, van het leven naar den dood tiegend,
in de solferkolk vallen, alwaar de duivel het hem zonder ophouden
gelieve te doen eten en nog te doen eten. En aldus tot in de eeuwigheid
der eeuwigheden!

--Amen! zeiden Uilenspiegel en Nele.

--Maar ziet gij niets? vroeg zij.

--Neen, sprak Uilenspiegel.

--In 't Westen zie ik, zeide zij, zeven mannen en vrouwen in eenen
kring gezeten. Een der mannen is gekleed in het purper en draagt
een gouden kroon op het hoofd. Hij schijnt de hoofdman der anderen,
die allen in lompen en vodden gehuld zijn. In het Oosten zie ik een
andere groep van zeven komen: insgelijks aangevoerd door iemand, ook
gekleed in het purper, doch zonder kroon op het hoofd. En zij gaan
op tegen die van het Westen. En zij vechten tegen hen in de wolken;
maar nu zie ik niets meer.

--De Zeven, zei Uilenspiegel.

--Ik hoor, zeide Nele, omtrent ons in het loover, eene stem, zacht
als een ademtocht, neuren:


    Door den krijg en het vuur
    Door de lansen en zwaarden,
        Zoek;
    In den dood en het bloed
    In de puinen en tranen,
        Vind.


--Anderen dan wij zullen de verlossers van Vlaanderen wezen, antwoordde
Uilenspiegel. De nacht is zwart, en 'k zie de Spaansche huurlingen
fakkels aansteken. Wij zijn omtrent het Galgeveld. O, mijn zoete
vriendinne, waarom zijt gij niet ginder gebleven? Hoort gij niets
meer, Nele?

--'t Doet, zeide zij, een wapengekletter in het koren. En ziet gij,
op de gindsche heuvelen, aan het einde van den wegel, dien wij begaan,
den rooden gloed niet van fakkels, die flikkeren op het staal van
de wapenen? Ik zie de lichtjes van de wieken der bussen. Slapen
onze wachters of zijn zij met blindheid geslagen? Hoort gij dien
donderslag? Ziet gij de Spanjolen vallen onder de kogels? Hoort
gij: "Vive le Geus!" Met de piek vooruit, stormen zij den
wegel op. Langsheen de heuvelen dalen zij beneden met zwaaiende
bijlen.... Vive le Geus!

--Vive le Geus! riepen Lamme en Uilenspiegel.

--Daar, zei Nele, daar zijn soldaten, die ons wapenen langen. Neem aan,
Lamme, neem aan, mijn beminde. Vive le Geus!

--Vive le Geus! riepen al de gevangenen.

--De bussen houden niet op met schieten, zeide Nele, de Spanjolen
vallen als vliegen, verlicht als ze zijn door den gloed van de
toortsen. Vive le Geus!

--Vive le Geus! riepen de wakkere redders.

--Vive le Geus! riepen Uilenspiegel en de gevangenen. De Spanjolen
zijn omsloten in eenen kring van vuur. Slaat dood! Slaat dood! Geen
enkele ontsnappe! Slaat dood! geene genade, geen kwartier! En nu
trekken wij, met pak en zak, naar Enkhuizen. Wie heeft de zijden en
lakensche kleederen van onze beulen? Wie heeft hunne wapenen?

--Allen! Wij allen! riepen zij. Vive le Geus!

En, inderdaad, zij trokken naar Enkhuizen, alwaar zij de met hen
verloste Duitschers deden blijven, om de stede te bewaken.

En Lamme en Nele en Uilenspiegel keerden naar hunne schepen terug. En
weer zongen zij op de vrije zee: Vive le Geus!

En zij kruisten in de reede van Vlissingen.




XIII.

Daar was Lamme weder vroolijk gestemd. Hij kwam geerne aan land,
en joeg toen ossen, schapen en ganzen op, lijk anderen jacht maken
op hazen, herten en ortolanen.

En hij was niet alleen voor die voedzame jacht. Het deed deugd de
jagers te zien terugkomen met Lamme aan hunne spits: het hoornvee
trokken zij voort, terwijl zij het gewold en gevederd vee vóór zich
dreven en op de punt hunner gaffels kiekens, kapoenen en kalkoenen
droegen, niettegenstaande het verbod van den Prins.

En toen gastreerde men blijde op de schepen. En Lamme sprak:

--De geur der sausen stijgt tot in den hemel, alwaar hij de santen
verblijdt, die geerne ons maal kwamen deelen.

Terwijl zij in de reede kruisten, kwam eene koopvaardijvloot van
Lissabon, welker gezagvoerder niet wist, dat Vlissingen in de macht
der Geuzen gevallen was. Men beveelt hem het anker te werpen, de vloot
wordt omsingeld. Vive le Geus! Pijpen en trommen bevelen de entering;
de kooplieden hebben kanonnen en pieken, bijlen en bussen.

Bommen en kogelen regenen op de schepen der Geuzen. Hunne busschutters,
verborgen in de schans rondom den grooten mast, vellen, zonder gevaar
voor zich zelven, bij elk schot eenen man neer. De kooplieden vallen
als vliegen.

--Helpt mij, vrienden! zeide Uilenspiegel tot Lamme en Nele. Daar
zijn specerijen, juweelen, kostbaarheden, suiker, muskaatnoten,
kruidnagelen, gember, realen, dukaten, schoone, blinkende gouden
lammeren. Daar zijn meer dan vijfhonderd duizend geldstukken. De
Spanjool betaalt de kosten des oorlogs. Laat ons drinken! Zingen wij
de misse der Geuzen, dat is het gevecht!

En Uilenspiegel en Lamme liepen overal rond lijk leeuwen. Buiten het
bereik van de kogels, speelde Nele op de pijp, in de schans. Heel de
vloot werd genomen.

Als de dooden geteld werden, vond men er duizend langs de zijde der
Spanjaards, driehonderd langs den kant van de Geuzen; onder hen bevond
zich de kok van de vlieboot den Briel.

Uilenspiegel vroeg om voor Treslong en de matrozen te spreken, hetwelk
Treslong hem geerne toestond. En hij hield hun de volgende rede:

--Messire kapitein en gij, maats, wij hebben daar vele specerijen
geërfd, en Lamme, onze dikzak, hier tegenwoordig, vond steeds dat
de arme doode, die dáár ligt,--God hebbe zijne ziel,--niet ervaren
genoeg was in de konsten van zieden en braden. Zoo gij hem als
kok wildet aanstellen, zou hij u hemelsche stoverije en goddelijke
soezels bereiden.

--Wij willen, zeiden Treslong en de anderen; Lamme zal de kok van het
schip zijn. Hij zal den grooten pollepel voeren, om de scheepsjongens
van zijne sausen te jagen.

--Messire kapitein, gezellen en vrienden, sprak Lamme, ik ween van
geluk, want die groote onderscheiding verdien ik niet. Doch, vermits
gij u tot mijne onweerdigheid wilt richten, neem ik de edele bediening
aan van meester in de konsten van zieden en braden op de wakkere
vlieboot den Briel; doch ik bid u ootmoediglijk mij wel te willen
belasten met het opperbevelhebberschap over de keuken, zoodanig dat
uw kok--dat ben ik,--bij recht, wet ende macht, een iegelijk kunne
beletten eens andermans portie te komen eten.

Treslong en de anderen riepen:

--Leve Lamme! gij hebt recht, wet ende macht!

--Doch, zeide hij, nog een nederige bede moet ik u doen: ik ben vet,
groot en struisch, diep is mijn buik, diep mijne maag; mijn arme
vrouw--God geve ze mij weder--placht mij altijd twee portiën te geven,
in stede van eene: verleent mij dezelfde gunste.

Treslong, Uilenspiegel en de matrozen zeiden:

--Gij krijgt dobbel rantsoen, Lamme.

En Lamme, die plotseling weemoedig werd, zeide:

--Mijne vrouw, mijn liefste vriendin! als iets vermag mij over onze
scheiding te troosten, zal het, bij het uitoefenen mijner bediening,
het aandenken wezen aan uw goddelijke keuken in onze halle vol liefde.

--Gij moet den eed afleggen, mijn zoon, zei Uilenspiegel. Men brenge
den grooten pollepel en den grooten koperen ketel, op dewelken Lamme
moet zweren.

--Bij God, sprak Lamme, dewelke mij helpe, zweer ik getrouwheid aan
Zijn Hoogheid den Prins van Oranje, gezeid den Zwijger, dewelke in naam
des konings de provinciën Holland en Zeeland bestiert, getrouwheid aan
messire Lumey, admiraal-bevelhebber onzer edele vloot, en aan messire
Treslong, schout-bij-nacht en kapitein van het schip den Briel;
ik zweer, volgens de costumen en gebruiken der groote koks uit de
oudheid en naarvolgens de schoone boeken met platen, die zij over
de edele kookkunst nagelaten hebben, zoo goed als mij mogelijk is,
de vleezen, kiekens, ganzen, mitsgaders kalkoenen te bereiden, die
Fortuna ons zal zenden; ik zweer te zullen voeden: den gezegden messire
kapitein Treslong, zijn stuurman, wezende mijn vriend Uilenspiegel,
en u allen, bootsman, loods, schieman, maats, soldaten, kanonniers,
keldermeester, scheepsmaker, lijfjonker van den kapitein, chirurgijn,
hoornblazer, matrozen en wie ook genaamd. Is het gebraad te rauw,
heeft het gevogelte geen smakelijk uitzicht; verspreidt de soep een
flauwen geur, wat de voorbode is eener slechte spijsvertering; zet
de geur van de sausen u niet aan in de keuken te dringen, behoudens
mijn oorlof nochtans; maak ik u niet allen blijmoedig en wel te pas,
dan zal ik mijn edel ambt nederleggen, mij onbekwaam oordeelende
langer in de keuken te tronen. Zoo helpe mij God en zijne santen in
deze wereld en ook in de andere!

--Leve onze kok, riepen zij, de koning der keuken, de keizer der
stoverije. 's Zondags krijgt hij drij portiën in stede van twee!

En Lamme werd kok op den Briel. En terwijl zijn lekkere soep op het
vuur stond, ging hij fier, met den pollepel op den schouder, eene
handwijl aan de keukendeur staan.

En 's Zondags kreeg hij zijne drij portiën.

Als de Geuzen met den vijand handgemeen werden, bleef hij geerne
in zijne braderij; doch van tijd tot tijd klom hij naar boven, om
eenige malen zijne bus af te vuren, na hetwelk hij schielijk weer
naar beneden ging, om op zijne gerechten te passen.

Als een trouw kok en een dapper soldaat, werd hij hertelijk bemind
door een iegelijk.

Maar niemand mocht in zijne keuken komen. Want dan werd hij uiterst
grammoedig, en sloeg hij met zijnen pollepel gelijk de duivel op
Geeraard.

En wederom werd hij geheeten: Lamme de Leeuw.




XIV.

Bij zonneschijn, bij regen, bij sneeuw, bij hagel, 's winters en
's zomers, dobberen de schepen der Geuzen op het ruime sop.

Alle zeilen bijgezet, gelijk zwanen, blanke zwanen der vrijheid.

Wit voor de vrijheid, blauw voor de grootheid, oranje voor den Prins,
is de standaard der fiere bodems.

Alle zeilen bijgezet! alle zeilen bijgezet, varen de wakkere schepen;
de golven klotsen er tegen, de baren besproeien ze met schuim.

Zij varen, zij wiegen, zij vliegen op den stroom, de fiere schepen
der Geuzen, met de zeilen in 't water, snel als de wolken gejaagd
door den Noordenwind. Hoort gij hoe hun voorsteven klieft door de
baren? God der vrije mannen, vive le Geus!

Huiken, vliebooten, boeiers, poonen, vlug als de wind, die het orkaan
met zich voert: als de wolk, die den bliksem met zich draagt. Vive
le Geus!

Boeiers en poonen, platboomde vaartuigen glijden op den vloed. De
golven zuchten onder hunne kiel, als zij recht vóór zich stevenen, met
den moorddadigen muil hunner slang open op de voorplecht. Vive le Geus!

Alle zeilen bijgezet! alle zeilen bijgezet, varen de wakkere schepen;
de golven klotsen er tegen, de baren besproeien ze met schuim.

Bij dag en bij nacht, bij regen, bij hagel en sneeuw, varen zij
op de wateren. Christus lacht hen toe in de wolk, in de zon, in de
sterre. Vive le Geus!




XV.

De bloedige koning kreeg tijding van hunne zegepralen. De dood beloerde
dien beul, wiens lichaam opgevreten werd door de wormen. Door de gangen
van 't kasteel van Valladolid sleepte hij, ziekelijk en terugstootend,
zijn gezwollen voeten en zijn loodzware beenen. Nimmer neurde hij een
liedeken, de wreedaardige beul; als de Oosterkim kleurde, lachte hij
niet, en als de zonne zijn rijk verlichtte als met een glimlach des
Heeren, voelde hij geen de minste vreugd in zijn hert.

Maar Uilenspiegel, Lamme en Nele zongen als lijsters, waagden bestendig
hun leven; God schiep den dag en zij gingen er door, en zij vonden
meer genoegen in het uitdooven van eenen brandstapel, dan de zwarte
koning vreugde smaakte in het verbranden van gansch eene stad.

In dien tijd ook was Willem de Zwijger, Prins van Oranje, gedwongen
messire Lumey, graaf van der Marck, zijnen graad van admiraal te
ontnemen, uit oorzake van de ijselijke wreedheden, die hij bedreef. Hij
benoemde messire Bouwen Ewoutsen Worst in zijne plaats. Hij zag mede
naar middelen uit om den boeren het koren te betalen, dat de Geuzen
hadden genomen; om de gedwongen schattingen terug te geven, die
door dezen gelicht waren; om den Roomschen, gelijk een iegelijk, de
vrije beoefening van hunnen godsdienst te schenken, zonder vervolging
of nadeel.




XVI.

Op de schepen der Geuzen, onder den helderen hemel, op de schuimende
golven, weerklinken pijpen en doedelzakken, klokken de flesschen,
rinkelen de klinkaards, flikkeren de bussen der geweren.

--Nu, sprak Uilenspiegel, slaat op de trom van de zege, slaat de
trom van de vreugde! Vive le Geus! Spanje is verslagen, de vampier
is getemd. Aan ons de zee, Brielle is genomen! Aan ons heel de kust
van Nieuwpoort tot Helder, met Oostende, Blankenberge, de Zeeuwsche
eilanden, de monden der Schelde, de monden der Maas, de monden van
den Rijn! Aan ons Texel, Vlieland, Terschelling, Ameland, Rottum en
Borkum.... Vive le Geus!

... Aan ons Delft, Dordrecht! 't Is een loopend vuur. God houdt de
vuurlont. De beulen verlaten Rotterdam. Het vrije geweten, lijk een
leeuw met klauwen en tanden van gerechtigheid, neemt het graafschap
Zutfen, de steden Deutekom, Doesburg, Goor, Oldenzaal en, in de Veluwe,
Hattem, Elburg en Harderwijk.... Vive le Geus!

... 't Is klaar, 't is als de bliksem: Kampen, Zwolle, Hasselt,
Steenwijk vallen in onze handen met Oudewater, Gouda en Leiden.... Vive
le Geus!

... Aan ons Buren, Enkhuizen! Ja, Amsterdam, Schoonhoven, Middelburg
zijn nog in onze macht niet. Doch alles komt op tijd voor geduldige
klingen.... Vive le Geus!

... Laat ons Spaanschen wijn drinken! Laat ons drinken uit de
kelken, uit dewelke zij het bloed van de slachtoffers dronken: Wij
gaan langs de Zuiderzee, langs stroomen, rivieren en vaarten; wij
hebben Noord-Holland, Zuid-Holland en Zeeland; wij zullen ook Oost-
en West-Friesland nemen; Brielle zal de wijkplaaats wezen voor onze
vloot, de bakermat der vrijheid.... Vive le Geus!

... Hoor, Vlaanderen, geliefde vadergrond, hoor den kreet van wrake
weerklinken! Men slijpt de wapenen, men zet de zweerden aan op den
steen. Allen bewegen zich, trillen als de snaren eener harp bij den
warmen ademtocht, adem van de zielen, die stijgt uit de putten, uit
de brandstapels, uit de bloedige lijken der slachtofferen. Allen:
Henegouwen, Brabant, Luxemburg, Limburg, Namen, Luik, de vrije,
vurige stede, allen! Het bloed kiemt en rijst. De oogst is rijp voor
de zeis.... Vive le Geus!

... Aan ons de Noordzee, de wijde zee van het Noorden! Aan ons de
goede kanonnen, de slanke schepen, het stoutmoedige heir van de
dappere zeelieden: edelen, poorters en arbeiders, die de vervolging
ontvluchten. Aan ons, allen, die vereenigd opstaan voor het werk van
de vrijheid.... Vive le Geus!

... Waar zijt gij, Philippus, bloedige koning? Gedekt met den heiligen
hoed,--geschenk van den paus,--vloekt en tiert gij. Slaat op de trom
van vreugde!... Vive le Geus! Laat ons drinken!

... De wijn stroomt in de gouden kelken. Drinkt blijde een
heildronk. De priesterkleeren, dewelke die ruwe mannen bedekken,
zijn nat van het roode druivensap; de Roomsche banieren wapperen in
den wind. Eeuwige muziek! komaan, pijpen, doedelzakken, trommels,
zingt nu de lofzang der zege.... Vive le Geus!




XVII.

Toen was men in de Wintermaand, dat is de maand van de wolven. Een
scherpe regen viel als naalden in den vloed neder. De Geuzen kruisten
in de Zuiderzee. Bij trompetgeschal ontbood messire de admiraal op
zijn schip de gezagvoerders der hulken en vliebooten, en samen met
hen ook Uilenspiegel.

--Nu, zei de admiraal, eerst tot dezen sprekend, de Prins wil uw
goede en trouwe diensten erkennen en benoemt u tot gezagvoerder op
het vaartuig den Briel. Hier hebt gij uwe aanstelling op perkament.

--God zegene U, heer admiraal, antwoordde Uilenspiegel; ik zal zoo
goed gezag voeren als mij mogelijk is, en aldus gezag voerende, hoop
ik wel, met Gods hulp, Spanje het gezagvoerderschap te ontnemen over
Vlaanderen en Holland: ik wil zeggen over Zuid- en Noord-Nederland.

--Goed zoo, zei de admiraal. En nu, voegde hij er bij, tot al de
aanwezigen sprekend: moet ik u zeggen, dat die van het katholieke
Amsterdam van zins zijn Enkhuizen te belegeren. Zij zijn nog het IJ
niet uitgevaren: wij zullen kruisen vóór deze vaart, zoodat wij ze
sluiten, en elken bodem overvallen, die zijnen romp in de Zuiderzee
durft vertoonen.

Zij antwoordden:

--Wij zullen ze in den grond boren!... Vive le Geus!

Toen Uilenspiegel weder op zijn schip was gestegen, deed hij zijne
matrozen en soldaten vergaderen op het dek en deed hun kond van de
woorden des admiraals.

Zij antwoordden:

--Wij hebben vleugelen, dat zijn onze zeilen; schaatsen, dat zijn de
kielen onzer schepen; reuzenhanden, dat zijn onze enterhaken. Vive
le Geus!

De vloot vertrok en kruiste vóór Amsterdam, op eene mijl van het
strand, zoodanig dat geen schip kon binnen- of buitenvaren, als zij
het niet wilde.

Den vijfden dag hield het op met regenen; de wind woei scherper in
den helderen hemel; die van Amsterdam verroerden zich niet.

Eensklaps zag Uilenspiegel zijn vriend den kok op het dek stormen
en den scheepsjongen--een jongen snaak, ervaren in de Fransche en
in de Vlaamsche taal, maar nog meer in het smullen--achternazetten,
met zijn grooten houten pollepel in de hand.

--Nietdeug, zeide Lamme, duchtig met zijnen stoklepel slaande,
dacht gij dan, zonder eenige straf, voorbarig mijne stoverije op te
peuzelen? Klim hoog in den mast en zie of er nog geene beweging komt
op de schepen van Amsterdam; wilt ge wèldoen?

Maar de jongen antwoordde:

--Wat zult ge mij geven?

--Meent gij, dat ik u zal betalen vóór dat gij gewerkt
hebt? Dievengebroed, als gij niet omhoog klimt, laat ik u geeselen. En
uw Fransch zal u niet redden.

--'t Is een schoone tale, zeide de knaap, tale van minne en van oorlog.

En hij klom in den mast.

--Wel luiaard? vroeg Lamme.

De scheepsjongen antwoordde:

--Ik zie niets in de stad noch op de schepen.

En beneden gekomen, sprak hij:

--Betaal mij nu.

--Houd het gestolene voor uwe moeite, antwoordde Lamme; maar het zal
niet gedijen: voorzeker spuwt gij het uit.

De jongen, die weder in den mast was geklommen, riep eensklaps:

--Lamme! Lamme! daar sluipt een dief in uwe keuken!

--Daar is geen nood van, antwoordde Lamme, de sleutel steekt in
mijne tassche.

Toen nam Uilenspiegel zijnen vriend ter zijde en sprak:

--Lamme, die groote kalmte van Amsterdam verontrust mij. Zij voeren
iets in hun schild.

--Ik dacht er aan, zeide Lamme. Het water vervriest in de kruiken in de
schapraai; de kiekens zijn hard als hout; de worsten gansch berijmd;
de boter is als steen, de olie geklonterd, het zout droog als zand
in de zonne.

--Vorst is op handen, zeide Uilenspiegel. Zij zullen, in grooten
getale, ons komen beschieten met donderbussen.

Hij begaf zich naar het admiraalschip en zei daar wat hij vreesde;
de vlootvoogd antwoordde:

--De wind blaast uit Engeland: we krijgen sneeuw, maar geen vorst:
keer terug naar uw schip.

En Uilenspiegel ging henen.

's Nachts woedde een hevige sneeuwstorm; maar weldra blies de wind
uit Noorwegen, de zee vroor toe, zij was effen als een vloer. De
admiraal zag dit schouwspel.

In de vrees, dat die van Amsterdam de schepen in brand zouden steken,
beval hij den soldaten hunne schaatsen in gereedheid te houden,
voor het geval dat zij buiten en rondom de schepen moesten vechten,
en den kanonniers de kogels bij hoopen naast de affuiten te leggen,
de stukken te laden en de lonten gedurig in brand te houden.

Maar die van Amsterdam kwamen niet.

En aldus zeven dagen lang.

Tegen den avond van den zevenden dag beval Uilenspiegel, dat een goed
festijn gegeven werd aan de matrozen en soldaten, om hen te wapenen
tegen den scherpen wind, die woei uit het Noorden.

Maar Lamme zeide:

--Er blijft ons niets meer over dan beschuit en kort bier.

--Vive le Geus! zeiden zij. Dit zal ons een vastenfestijn zijn,
in afwachting van het uur van 't gevecht.

--Dat nog zoo gauw niet zal slaan, zeide Lamme. Die van Amsterdam
zullen komen om onze schepen te verbranden, maar dezen nacht nog
niet. Eerst zullen ze te hoop moeten komen rondom het vuur, en daar
menigen beker warmen wijn ledigen,--God verleene er u,--vervolgens,
als zij tot middernacht zullen beraadslaagd hebben met kalmte,
verstand en geduld, zullen zij beslissen morgen te besluiten of zij,
al dan niet, ons de toekomende week zouden aanvallen. Morgen zullen
zij, opnieuw onder het drinken van warmen wijn,--God verleene er
u,--opnieuw met kalmte, geduld en volle kannen beslissen dat zij een
anderen dag zullen vergaderen, ten einde uit te maken of het ijs, al
dan niet, een groote menigte kan dragen. En zij zullen het ijs doen
onderzoeken door deskundigen, dewelke hunne besluiten op perkament
zullen neerschrijven. Als zij die ontvangen en gelezen hebben, zullen
zij daarover verslag maken, waaruit zal blijken, dat het ijs een halve
el dik is, dat het sterk genoeg is om eenige honderden soldaten met
donderbussen en veldgeschut te dragen. Vervolgens opnieuw bijeenkomend,
om met kalmte en geduld, onder het drinken van menigen beker warmen
wijn te beraadslagen, zullen zij berekenen of het, om den wille van
den schat van Lissabon, dien wij hebben gekaapt, raadzaam is onze
schepen te bestormen of wel te verbranden. En, aldus besluiteloos,
maar dralend, zullen zij nochtans beslissen dat zij onze schepen
moeten nemen, en geenszins verbranden, niettegenstaande al het leed
en de schade, die zij ons daarmee zouden doen.

--Gij spreekt goed, antwoordde Uilenspiegel; maar ziet eens die
vuren aansteken in de stad en al die lieden haastig rondloopen met
lanteernen in de hand?

--'t Is van groote koude, zei Lamme.

En, zuchtend, voegde hij er bij:

--Alles is opgegeten. Geen ossevleesch, geen pekelvleesch, geen
gevogelte meer; geen wijn meer, laas! noch goed dobbel bier; niets
dan beschuit en kort bier. Wie komt er mee?

--Waar gaat gij? vroeg Uilenspiegel. Niemand mag het schip verlaten.

--Mijn vriend, zeide Lamme, thans zijt gij kapitein en
gezagvoerder. Zonder uwe toestemming zal ik het schip niet
verlaten. Doch gelief te bedenken, dat onze laatste worst er
eergisteren aan was; dat, in dezen harden tijd, keukenvuur de vreugd
van de goede maats is. Wie onzer is niet bereid den geur van goede saus
op te snuiven, of een lekker glaasje te drinken, hetwelk vroolijkheid
en goeden wil voor een ieder baart? Nu, kapitein en trouwe vriend,
ik durf het u zeggen: ik vreet mij het hert op, ik eet niet; ik, die
voor de rust ben, die niet geerne moord, tenzij een malsche gansch,
een vet kieken, een smakelijken kalkoen; ik volg u in de vermoeienissen
des oorlogs. Zie gindsche lichten, 't zijn die eener rijke hoeve,
goed voorzien van groot en klein vee. Weet gij wie daar woont? 't Is
die schipper van Friesland, die messire Dandelot verried en achttien
arme heeren en vrienden naar het nog Spaanschgezinde Enkhuizen
bracht, dewelke door zijn toedoen op de Peerdenmarkt--dat is de
Kleine Zavel--te Brussel, onthalsd werden. Die verrader, die Slosse
heet, ontving van den hertog twee duizend florijnen als prijs zijns
verraads. Met het geld van het bloed kocht hij, als een ware Judas,
de hoeve, die gij daar ziet, en zijn groot vee, en de velden in 't
ronde, dewelke gedijen en bloeien; ik zeg, dat hij schatrijk wordt
met zijnen grond en zijn vee.

Uilenspiegel antwoordde:

--De assche klopt op mijn hert. Het uur van God is geslagen.

--En ook het uur van het eten, zeide Lamme. Geef mij twintig wakkere
gasten, soldaten en matrozen, en ik breng u den verrader.

--Ik zelf wil hen aanvoeren, zeide Uilenspiegel. Wie voor de
rechtveerdigheid is, volge mij. Doch allen niet, mijne vrienden;
er zijn er maar twintig van doen; wie anders zou op het schip
letten? Laat de dobbelsteenen beslissen. Goed, nu zijt gij twintig,
komt mee. Riemt uwe schaatsen om en legt aan op Venus, de heldere
sterre, die flikkert boven de hoeve van den verrader.

... Komt dus, vrienden; rijdend en glijdend, met de akst op den
schouder, worden wij geleid door het glimmend licht van de heldere
maan.

... De wind fluit en jaagt witte sneeuwvlagen vóór zich op het
ijs. Komt, dappere mannen!

... Gij zingt noch gij spreekt; gij gaat, stilzwijgend, recht voor
u uit op de sterre; uwe schaatsen krassen op 't ijs.

... Wie valt, sta aanstonds weer op. Wij naderen den oever: geen
enkele menschelijke gedaante op de witte sneeuw, geen enkele vogel
vertoont zich in de ijskoude lucht. Doet uwe schaatsen af.

... Hier zijn wij op 't land, hier zijn wij in de weide, riemt uwe
schaatsen weer om. Wij zijn rondom de hoeve, houdt uwen adem in.

Uilenspiegel klopt op de deur, de honden bassen. Hij klopt nogmaals;
een venster wordt geopend en de boer, die het hoofd buitensteekt,
vraagt:

--Wie zijt gij?

Hij ziet niemand dan Uilenspiegel: de anderen zijn verborgen achter
de keet.

Uilenspiegel antwoordde:

--Messire Bossu gelast u oogenblikkelijk bij hem, naar Amsterdam,
te komen.

--Waar is uwe vrijgeleide? vroeg de baas, toen hij beneden was en de
deur had geopend.

--Hier, antwoordde Uilenspiegel, hem de twintig Geuzen toonend,
die achter hem het huis binnenstormden.

Toen sprak Uilenspiegel tot hem:

--Gij zijt schipper Slosse, de verrader, die Dandelot, Battenburg
en andere heeren in eene hinderlaag loktet. Waar is de prijs van
het bloed?

Over al zijn ledematen bevend, antwoordde de hoevenaar:

--Gij zijt de Geuzen, schenkt mij vergiffenis; ik wist niet wat
ik deed. Ik heb hier geen geld in mijn huis; alles wat ik heb, zal
ik geven.

Lamme sprak:

--Het is donker, geef ons keersen.

De baas antwoordde:

--Dáár hangen vetkeersen.

Toen eene keers aangestoken was, zeide, in den heerd, een van de
Geuzen:

--Het is koud, laat ons vuur maken. Hier zijn schoone, dikke mutsaards.

En hij wees naar eene plank, op dewelke bloempotten stonden, waarvan
al de planten verdroogd waren. Hij nam er eene bij den kop en schudde
ze; de pot viel ten gronde, gevolgd door dukaten, realen, florijnen.

Daar is de schat, zeide hij, naar de andere bloempotten wijzend.

En, inderdaad, toen zij geledigd waren, vonden zij er tien duizend
florijnen.

Als de boer dat zag, begon hij te weenen en te huilen.

Op dat geroep kwamen de knechts en meiden der hoeve toegeloopen in
hun hemde. Daar de mannen hunnen meester wilden verdedigen, werden
zij gevat en gebonden. Maar de dienstmaagden waren beschaamd, en
vooral de jonge, en zij verborgen zich achter de mannen.

Lamme kwam toen vooruit, en hij sprak:

--Verrader, waar zijn de sleutels van den kelder, den stal en de
schaapskooi?

--Schaamtelooze diepers, zeide de baas, gij zult gehangen worden
totdat de dood er op volge!

Uilenspiegel antwoordde.

--Het is het uur van God, geef de sleutels!

Toen de Geuzen de hoeve geledigd hadden, reden zij op hunne schaatsen
terug naar de schepen, lichte hallen van vrijheid.

--Ik ben de kok, zeide Lamme hen leidend; ik ben de kok. Stoot de
wakkere sleden vooruit, beladen met wijn en met bier; drijft vóór u,
met zeelen of anderszins, ossen, varkens en schapen. De duiven kirren
in de kevies; de volgepropte kapoenen kijken beteuterd in de houten
kooien, in dewelke zij zich niet kunnen verroeren. Ik ben de kok. Het
ijs kraakt onder de schaatsijzers. Wij zijn nabij de schepen. Morgen
speelt er muziek in de keuken. Laat de katrollen beneden. Bindt de
banden om de koeien en ossen. 't Is een schoon schouwspel, ze aldus
bij den buik te zien hangen; morgen zullen wij hangen met de tong aan
hun vette stoverije. De katrol hijscht ze op tot boven het ruim. Het
zijn karbonaden. Smijt maar overhoop in het ruim, eenden, kapoenen,
ganzen en hoenders. Wie zal hun den nek omwringen? de kok. De deur
is gesloten, de sleutel steekt in mijne tassche. God zij geloofd in
de keuken! Vive le Geus!

Vervolgens begaf Uilenspiegel zich naar het admiraalschip, met Diederik
Slosse en de andere gevangenen, die zuchtten en weenden uit vrees
voor de koorde.

Messire Worst kwam bij het gerucht: hij bemerkte Uilenspiegel en
zijne gezellen, verlicht door den rooden gloed van de toortsen.

--Wat wilt gij? zeide hij.

Uilenspiegel antwoordde:

--Dezen nacht namen wij, in zijne hoeve, Diederik Slosse, die de
achttien in een hinderlaag deed vallen. Hier is hij. De anderen zijn
onschuldige knechten en meiden.

Vervolgens langde hij hem een tassche, en hij sprak:

--Deze guldens groeiden in bloempotten in het huis des verraders:
er zijn er tienduizend.

Messire Worst zeide hun:

--Gij misdeedt de schepen te verlaten; doch gezien den goeden uitslag,
zal u vergiffenis worden geschonken. Welkom zijn de gevangenen en de
tassche vol guldens, en eere aan u, dappere lieden, aan dewelken ik,
volgens de rechten en costumen ter zee, het derde deel van den buit
schenk; het tweede deel zal zijn voor de vloot, en het andere derde
voor onzen hoofdman, den Prins van Oranje; knoopt den verrader op
staanden voet op.

De Geuzen gehoorzaamden; daarna kapten zij eene bijt in het ijs,
waarin zij het lijk smeten van Diederik Slosse.

Toen zeide messire Worst:

--Groeit er gras rond de schepen? Me dunkt, ik hoor hoenders kakelen,
schapen blaten en runderen loeien?

--Dat zijn de gevangenen voor onzen mond, antwoordde Uilenspiegel;
zij zullen hun rantsoen in stoverije betalen. Messire admiraal krijgt
het beste stuk van dezelve.

... Wat deze knechten en meiden betreft, onder dewelken zich
verscheidene lieftallige en poezele vrouwen bevinden, die ga ik weer
op mijn schip brengen.

Toen zulks gedaan was, hield hij hun de volgende rede:

--Mannen en vrouwen, gij zijt hier op het beste schip van de
wereld. Wij brengen er den tijd door met smullen; 't is een festijn
zonder einde. Als 't u belieft van hier weg te gaan, kunt gij het
doen, mits een rantsoen te betalen; verkiest gij te blijven, dan
zult gij leven lijk wij: dapper werken en flink eten. Wat die lieve
vrouwlieden betreft, ik geef haar bij gezagvoerderlijke macht de
volle vrijheid van lijf: 't is te zeggen, dat het mij heel eender
is of zij heure vrienden houden, die met haar op het schip kwamen,
of eene keuze doen onder onze dappere Geuzen, hier tegenwoordig,
om heur huwelijksch gezelschap te houden.

Maar al de lieftallige vrouwlieden bleven trouw aan heure vrienden,
uitgenomen een enkele, dewelke glimlachend keek naar Lamme en hem
vroeg of hij van heur wilde weten.

--God zegene u, liefste, zeide hij, maar ik ben reeds genomen.

--Hij is getrouwd, de dikzak, zeiden de Geuzen tot de spijtige schoone.

Maar zij keerde hen den rug toe en koos er een anderen, die, gelijk
Lamme, een goede tronie en een dikken buik had.

Dien dag en den volgenden gastreerde men aan boord van de schepen
met wijn, met vleesch en met gevogelte. En Uilenspiegel zeide:

--Vive le Geus! Blaas maar aan, scherpe Noordenwind, wij zullen de
lucht met onzen adem verwarmen. Ons hert is van vuur voor het vrije
geweten, van vuur onze maag voor het gebraad van den vijand. Laat
ons wijn drinken, dat is de melk van de dapperen. Vive le Geus!

Nele dronk ook uit een grooten gouden beker; zij bloosde van koude,
doch blijde bespeelde zij de pijp. En ondanks de koude, aten en
dronken de Geuzen juichend en vroolijk op het dek van de schepen.




XVIII.

Eensklaps zag heel de vloot op den oever zwarte drommen, onder
dewelke toortsen flikkerden en wapens glinsterden; vervolgens werden
de toortsen uitgedoofd, en heerschte volledigste duisternis.

De bevelen van den admiraal werden overgebracht, het sein tot
waakzaamheid gegeven, en alle de vuren uitgedoofd; matrozen en soldaten
gingen, met bijlen gewapend, op hun buik op het dek liggen. De wakkere
kanonniers, met hunne lont in de hand, waakten omtrent de donderbussen,
dewelke geladen waren met zakken kruit en met kettingkogels. Zoodra
de admiraal en de kapiteins zouden roepen: "Honderd passen!"--wat
de stelling van den vijand aanwees,--moesten zij vuren van voren,
van achterboeg of van boord, naarvolgens hunne stelling op het ijs.

En men hoorde de stem van messire Worst, dewelke sprak:

--Ter dood, hij die luide durft spreken!

En de kapiteins zeiden hem na:

--Ter dood, hij die luide durft spreken!

Het uitspansel was vol sterren, doch zonder maan.

--Hoort gij, zeide Uilenspiegel tot Lamme stil als de adem van
een spook. Hoort gij de stem van die van Amsterdam, en het ijzer
hunner schaatsen krassen op 't ijs? Zij rijden snel. Men hoort hen
spreken. Zij zeggen: "Die luie Geuzen liggen te slapen. Aan ons de
schat van Lissabon". Zij steken hunne toortsen weer aan. Ziet gij
hunne bestormingsladders en hunne leelijke tronies, en de breede
linie van hun aanvalsfront? Zij zijn duizend en meer.

--Honderd passen! riep messire Worst.

En men hoorde een geluid als van een donder, en een jammerlijk gehuil
op het ijs.

--Tachtig kanonnen bulderen tegelijk! zeide Uilenspiegel. Zij
vluchten! Ziet gij de toortsen verwijderen?

--Achtervolgt ze! zeide admiraal Worst.

--Achtervolgt! zeiden de kapiteins.

Maar de vervolging duurde niet lang, daar de vluchtelingen honderd
passen vóór waren en liepen als hazen.

En op de mannen, die kermden en reutelden op 't ijs, vond men goud,
kleinoodiën, en ook koorden om de Geuzen te binden.

En, na deze zegepraal, zeiden de Geuzen tot elkaar: "Als God met ons
is, wie zal tegen ons zijn?"

Nu, in den morgen van den derden dag, werd messire Worst ongerust,
want hij verwachtte een nieuwen aanval. Lamme sprong op het dek en
zeide tot Uilenspiegel:

--Breng mij bij dien admiraal, die u niet wilde gelooven toen gij
vorst voorspeldet.

--Ga zonder dat men u leide, zeide Uilenspiegel.

Lamme toog henen, nadat hij de deur zijner keuken goed dichtgedaan
had. De admiraal stond op het dek in de verte te turen, om te zien
of hij geenerlei beweging bespeurde langs den kant van de stad.

Lamme naderde hem en sprak:

--Messire admiraal, mag een nederige kok u zijne meening laten kennen?

--Spreek, mijn jongen, zei de admiraal.

--Heer, zeide Lamme, het water ontdooit in de kruiken, het gevogelte
wordt weder murw; de worst verliest hare schimmel van rijm; de boter
wordt slap; de olie vloeibaar; het zout vochtig. Weldra valt de regen
en zijn wij gered, heer admiraal.

--Wie zijt gij? vroeg messire Worst.

--Ik ben, zeide hij, Lamme Goedzak, kok op de vlieboot den Briel. En
als al de groote geleerden, die sterrekijkers beweren te zijn, zoo
goed in de sterren kunnen lezen als ik in mijne sausen, zouden zij
ons kunnen zeggen, dat het dezen nacht zal dooien, met groot gedruisch
van tempeest en van hagel; maar de dooi zal niet aanhouden.

En Lamme keerde terug bij Uilenspiegel, tot denwelken hij zei rond
den middag:

--Wat heb ik voorspeld? De hemel wordt duister, de wind blaast
geweldig; een warme regen valt; daar is reeds een voet water op 't ijs.

En 's avonds riep hij blijde uit:

--De Noordzee is gezwollen: het is het uur van den vloed; de hooge
baren, die in de Zuiderzee komen, breken het ijs, hetwelk in groote
stukken barst en springt op de schepen; het fonkelt en glinstert;
daar is de hagel. De admiraal beveelt ons met onze vloot terug te
trekken van vóór Amsterdam, en dit met zooveel water als ons grootste
schip noodig heeft. Hier zijn wij in de haven van Enkhuizen. De zee
vriest weer toe. Ik ben profeet, en 't is een gunst van den Heer.

En Uilenspiegel zeide:

--Wij zullen een glas drinken en Hem loven en danken.

En de winter verzwond en de zomer kwam.




XIX.

In de Oogstmaand, als de volgepropte hennen doof blijven voor 't geroep
van den haan, die heur zijne liefde toekraait, zeide Uilenspiegel
tot zijne matrozen en soldaten:

--De bloedige hertog is te Utrecht; hij durft er een lieftallig
plakkaat afkondigen, hetwelk onder meer genadige giften belooft:
honger, dood, ondergang voor de inwoneren der Nederlanden, die zich
niet onderwerpen. Alles wat nog recht staat, zegt hij, zal neergehaald
worden, en Zijn Koninklijke Majesteit zal het land bevolken met
vreemdelingen. Bijt, hertog, bijt! De vijl breekt de tanden der
adderen; wij, wij zijn vijlen! Vive le Geus!

... Alva, het bloed maakt u dronken! Meent gij, dat wij uwe
bedreigingen vreezen of aan uwe goedertierenheid gelooven? Uw
roemrijke regimenten, wier lof gij door heel de wereld verkondigdet,
uwe schepen, wier naam alleen uwen overmoed schetsen, bleven zeven
maanden lang Haarlem beschieten, een zwakke stede, door heure poorters
verdedigd. Zij zijn als gewone stervelingen in de lucht gesprongen,
bij 't ontploffen der mijnen; poorters begoten ze edelmoedig met pik;
eindelijk behaalden zij een roemvolle zege: zij keelden ontwapende
vijanden. Hoort gij Gods uur slaan, bloedige beul?

... De stede verloor haar wakkere verdedigers, hare steenen zweetten
bloed. Bij heure belegering verloor en verteerde zij twaalfhonderd
tachtigduizend gulden. De bisschop is terug in de stede; met vlugge
hand en vroolijke tronie herwijdt hij de kerken; don Frederik woont die
wijdingen bij; de bisschop wascht hem de handen, dewelke voor God rood
zullen blijven, en hij gebruikt het Avondmaal onder de beide gedaanten,
wat aan het arme gemeen niet geoorloofd wordt. En de klokken luiden, en
de beiaard werpt in de lucht zijn stille, welluidende tonen: 't is als
een engelenkoor op een kerkhof. Oog om oog, tand om tand! Vive le Geus!




XX.

Toen waren de Geuzen te Vlissingen, waar Nele koorts vatte. Gedwongen
het schip te verlaten, werd zij ingenomen bij Peeters, een hervormde,
op de Turfkaai.

Uilenspiegel, hoewel treurig, was toch blijde als hij dacht, dat de
Spaansche kogels heur niet konden treffen in dat bed, waar zij zeker
zou genezen.

En, met Lamme, was hij gedurig bij heur, om heur goed en liefdevol
te verzorgen. En daar koutten zij met elkander.

--Trouwe vriend, zei Uilenspiegel eens, kent gij het nieuws?

--Neen, mijn zoon, zei Lamme.

--Hebt gij de vlieboot gezien, die laatst onze vloot kwam versterken,
en weet gij wie daar alle dagen speelt op de vedel?

--Ten gevolge van de laatste verkoudheid, zeide Lamme, tuiten mijne
beide ooren en ben ik wat doof. Waarom lacht gij, mijn zoon?

Maar Uilenspiegel vervolgde zijn rede en sprak:

--Eens hoorde ik heur een Vlaamsch liedeken zingen, en heure stem
was zoo zoet als die van een engel.

--Laas! zeide Lamme, zij ook speelde op de vedel en zong.

--Kent gij de andere tijding? vervolgde Uilenspiegel.

--Neen, mijn zoon, antwoordde Lamme.

Uilenspiegel antwoordde:

--Bevel is ons gegeven, met onze booten de Schelde op te varen tot vóór
Antwerpen, om daar vijandelijke schepen te kapen of te verbranden. Maar
geen kwartier aan de mannen! Wat denkt gij daarvan, dikzak?

--Laas, zeide Lamme, zullen wij in deze droeve landen nooit van
anders hooren dan van verbrandingen, verhangingen, verdrinkingen en
andere uitroeiingen van 't arme menschdom? Wanneer zal de gezegende
vrede komen, om rustig patrijzen te braden, kiekens te stoven en,
te midden van de eieren, de pensen te doen sissen in de braadpan? Ik
eet liever de zwarte; de witte zijn wat vet.

--Die zoete tijd zal komen, antwoordde Uilenspiegel, als wij, in
Vlaanderens boomgaarden, aan de appelaars, pruimelaars en kerselaars,
in stede van appels, pruimen en kersen, aan elken tak eenen Spanjaard
zien hangen.

--Ha, zeide Lamme, kon ik maar mijne vrouw terugvinden, mijn
teerbeminde, zeer geliefde, beminnelijke, zoete, trouwe vrouw! Want,
weet, mijn zoon, dat ik nooit horens droeg of zal dragen; daarvoor
was zij veel te ingetogen van aard; zij vluchtte den omgang met
andere mannen; zoo zij van schoone kleederen hield, was het alleen
uit vrouwelijke behoefte. Ik was heure keukenmeid, ik beken het
volgeerne; waarom ben ik het niet meer! Doch ik was ook haar meester
en echtgenoot.

--Zwijg toch met uw gesuf, zei Uilenspiegel. Hoort gij den admiraal
roepen: "Licht de ankers!" en de kapiteins, die zijn commando
herhalen? Wij moeten in zee steken.

--Waarom vertrekt gij zoo vroeg? zeide Nele tot Uilenspiegel.

--Wij gaan naar de schepen, antwoordde hij.

--Zonder mij? sprak zij.

--Ja, zei Uilenspiegel.

--Bedenkt gij niet, vroeg zij, hoe ongerust ik over u wezen zal?

--Liefste, sprak Uilenspiegel, mijn vel is van ijzer.

--Gij spot, zeide zij. Ik zie niets dan uw wambuis, dat van laken is,
doch geenszins van ijzer; daaronder is uw lijf, dat van vleesch en been
is, lijk het mijne. Wie zal u verbinden als gij gekwetst zijt? Moet
gij moederziel alleen sterven, te midden van de strijders? Ik zal
met u gaan.

--Laas, zeide hij, als de lansen, kogels, zweerden, aksten, hamers,
mij sparen, maar op uw liefelijk lichaam vallen, wat moet ik, nietdeug,
dan doen op de wereld zonder u?

Maar Nele zeide:

--Ik wil u volgen, er zal geen gevaar zijn; ik zal mij verbergen in
de houten schansen, waar de busschutters staan.

--Als gij vertrekt, dan blijf ik; en men zal zeggen, dat uw vriend
Uilenspiegel lafaard is en verrader; maar luister naar mijn lied:


    IJzeren is mijn harentuit,
    Daar schutte natuur mij mede.
    Lederen is mijn eersten huid,
    Stalen is mijn tweede.

    Laat de dood, de leelijke, wreede,
    Loeren naar een ander buit.
    Lederen is mijn eerste huid,
    Stalen is mijn tweede.

    "Leven" steekt op mijn vendel uit,
    Leven in 't licht der rede.
    Lederen is mijn eerste huid,
    Stalen is mijn tweede.


En zingend toog hij henen, niet zonder den trillenden mond en de
liefelijke oogen te kussen van de koortsachtige Nele, die lachte en
weende te gelijk.

De Geuzen zijn vóór Antwerpen, zij kapen Alva's schepen tot in de
haven. Zij komen in lichten dag in de stad, verlossen gevangenen en
nemen paapschgezinden om tot rantsoen te dienen. Met geweld doen zij de
poorters opstaan, en dwingen eenigen hunner hen sprakeloos te volgen,
onder doodsbedreiging.

Uilenspiegel zeide tot Lamme:

--De zoon des admiraals is gevangen bij den schouteet; wij moeten
hem verlossen.

Zij dringen in het huis van den schout en vinden den jongeling,
dien zij zochten, in gezelschap van een dikbuikigen monnik, dewelke
hem een grammoedige predikatie hield om hem terug te brengen in
den schoot Onzer Moeder, de Heilige Kerk. Maar de jonge snaak
vroeg of hij hem niets beters kon aanbieden. Hij gaat henen met
Uilenspiegel. Ondertusschen grijpt Lamme den monnik bij zijne kap,
en doet hem vóór zich gaan in de straten van Antwerpen, zeggende:

--Gij zijt honderd gulden weerd: maak uw pak en ga vóór. Waarom gaat
gij zoo traag? Hebt gij lood in uwe schoenen? Wat rapper, spekzak,
vleeschbank, soepketel!

De monnik antwoordde, in woede ontstoken:

--Goed, mijnheer de Geus, ik ga; maar, met al den eerbied, dien ik
uwe schietbus verschuldigd ben, veroorloof ik mij te zeggen, dat gij
zoo dik zijt als ik.

Maar Lamme stiet hem voort en sprak:

--Hoe vermeet gij u uw onnut, vadsig kloostervet te vergelijken met
mijn Vlamingvet, dat eerlijk gekweekt werd door arbeid, vermoeienis
en gevecht? Gauw wat, of ik jaag u voort met eene spoor op de punt
van mijnen schoen.

Maar de monnik kon niet loopen, hij was gansch buiten adem, en Lamme
insgelijks. En zoo kwamen zij op het schip.




XXI.

Nadat de Geuzen, Rammekens, Geertruidenberg, Alkmaar hadden genomen,
stevenden zij weder naar Vlissingen.

Nele, die genezen was, wachtte Uilenspiegel af aan de haven.

Hem ontwarend, riep zij:

--Thijl, mijn vriend Thijl, zijt ge niet gewond?

Uilenspiegel zong:


    "Leven" steekt op mijn vendel uit,
    Leven in 't licht der rede.
    Lederen is mijn eerste huid,
    Stalen is mijn tweede.


--Laas! zeide Lamme, trekkebeenend: de kogels, granaten, kettingkogels
regenen rondom hem, en hij voelt er niets van dan den wind. Gij zijt
voorzeker een geest, Uilenspiegel, en gij ook Nele, want gij zijt
beiden altijd jeugdig en luimig.

--Wat hebt gij aan uw been? vroeg Nele tot Lamme.

--Ik ben geen geest en zal het nooit wezen, sprak hij. Ik heb dan
ook een bijlslag gekregen in mijne bil,--mijne vrouw had er zulke
ronde en schoone!--zie, ik bloed. Laas! waarom is ze niet hier om
mij te verzorgen?

Maar Nele antwoordde grammoedig:

--Waarom vraagt gij naar een meineedige vrouwe?

--Spreek geen kwaad van haar, antwoordde Lamme.

--Neem, zeide Nele, hier is balsem, dien ik meebracht voor
Uilenspiegel; strijk hem op uwe wond.

Toen Lamme zijne wond verbonden had, werd hij blijgeestig, want de
balsem stilde de bijtende smert; en zij klommen alle drie op het schip.

Toen Nele den monnik met gekluisterde handen op het dek zag wandelen,
vroeg zij:

--Wie is die? Dien zag ik reeds; en ik meen hem te kennen.

--Gelijk hij waait en draait, is die honderd gulden rantsoen weerd,
zeide Lamme.




XXII.

Dien dag was 't kermis op de vloot van de Geuzen. Niettegenstaande
het gure weder der Wintermaand, niettegenstaande regen en sneeuw,
waren al de Geuzen op het dek van de schepen. De zilveren halvemanen
flikkerden op de Zeeuwsche hoedekens.

En Uilenspiegel zong:


    Leiden is ontzet, de bloedhertog
    Wijkt uit de Nederlanden;
    Klare klokken, klinkt,
    Beiaards, schatert uw deuntjes uit;
    Rinkelt, roomers en bottels.

    Kreeg de doghond slaag,
    Staartneder, met bloedend oog,
    Loopt hij de stokken weer in.
    Zijn gescheurde muil
    Hijgt en huivert.
    Weg is de bloedhertog:
    Rinkelt, roomers en bottels. Leve de Geus!

    Bijten wou hij zijn eigen.
    De stokken brijzelden zijn gebit.
    Met hangenden suffen kop,
    Denkt hij aan dagen van moord en vraatlust.
    Weg is de bloedhertog:
    Slaat op de glorietrom,
    Slaat op de krijgstrom!
    Leve de Geus!

    Thans schreeuwt hij den duivel toe: "Koop
    Mijn hondsche ziel voor één uur kracht".
    "Uw ziel, roept de duivel,
    Uw ziel of een boestring, dat 's eender."
    Geen tand past op een tand.
    De harde brokken moest ge maar laten.
    Weg is de bloedhertog:
    Leve de Geus!

    De straathondjes, scheef, scheel, schurftig,
    Die leven en krepeeren op vuilnishoopen,
    Heffen hun poot op, beurt om beurt,
    Naar hem, die doodde uit moordzucht....
    Leve de Geus!

    "Hij hield van vrouw noch vriend,
    Van vreugd, noch zon, noch meester,
    Slechts van de Dood, zijn bruid,
    Die hem de pooten knakte,
    Tot blijdans vóór de bruiloft;
    Want heele menschen lust ze niet.
    Slaat op de vreugdtrom.
    Leve de Geus!"

    En de straathondjes mank,
    Scheef, schurftig en scheel,
    Heffen nog eens den poot op
    Dat het ziedt en zout,
    En met hen brakken en winden,
    Rekels van Hongarije,
    Van Brabant, Namen en Luxemburg.
    Leve de Geus!

    En triestig, met schuimmuil,
    Krepeert hij vóór zijn meester,
    Die hem schopt met den voet,
    Wijl hij te weinig beet.
    Ter helle huwt hij Dood.
    Hem heet zij: Mijn hertog;
    Hij haar: Mijn inquisitie.
    Leve de Geus!

    Klare klokken, klinkt,
    Beiaard, schater uw deuntjes uit;
    Rinkelt, roomers en bottels:
    Leve de Geus!







VIJFDE BOEK.


I.

Als Lamme's monnik gewaar werd, dat de Geuzen geenszins zijnen dood
wilden, doch een rantsoen voor hem eischten, begon hij het hoofd op
te steken.

--Ziet, zeide hij, terwijl hij met woede op het dek stapte en
schuddebolde, ziet in welken afgrond van vuile, zwarte en afgrijselijke
gruwelen ik gevallen ben, toen ik den voet in deze verdoemde kuip
zette. Zoo ik hier niet was, zou ik, gezalfd door den Heer....

--Met hondenvet? vroegen de Geuzen.

--Honden zijt gij zelven, antwoordde de monnik, zijne rede vervolgend,
ja, schurftige, drekkige straathonden, met het vel over de beenderen,
die het lustige pad van Onze Moeder, de Heilige Roomsche Kerk, hebt
verlaten om de schrale wegen van uwe havelooze Hervormde Kerk in te
slaan. Ja! ware ik hier niet op uwen klomp, lang reeds had de Heer,
Onze God hem doen verzwelgen in den diepsten afgrond der zee, met u,
uw vermaledijde wapenen, uwe duivelsche donderbussen, uw zingenden
kapitein, uw heiligschennende halvemanen, ja! tot in het diepste
van den onpeilbaren bodem van het rijk Satans, waar gijlie niet
zult branden, o neen! maar vervriezen, beven en sterven van koude,
de eeuwigheid der eeuwigheden lang. Ja, de God des hemels zal aldus
het vuur uitdooven van uwen goddeloozen haat tegen Onze Zoete Moeder,
de Heilige Roomsche Kerk, tegen de genadige santen, de eerwaarde
bisschoppen en de gezegende plakkaten, die zoo zachtmoedig en wijselijk
uitgedacht zijn. Ja, en van het hoogste des hemelrijks zal ik u zien,
paars lijk beeten, of wit lijk rapen, van koude. Zoo zij en zoo weze!

De matrozen, soldaten en scheepsjongens spotten met hem en schoten,
met blaaspijpen, droge erwten naar hem. En met zijne handen beschermde
hij zijn gelaat tegen die kogels.




II.

De bloedige hertog had onze landen verlaten, en de heeren Medina Celi
en Requesens regeerden ze met minder wreedheid. Vervolgens bestuurden
de Staten-Generaal, in naam van den koning.

Die van Zeeland en Holland, bevoordeeld door de zee en de dijken,
die hun natuurlijke wallen en vestingen zijn, openden ondertusschen,
aan den God der vrijen, vrije tempelen, alwaar de paapschgezinde
beulen naast hen hunne lofzangen konden aanheffen; en de Prins van
Oranje, de edele Zwijger, hield zich druk bezig met het stichten van
een stadhouderlijk en koninklijk huis.

Belgieland werd verwoest door de Walen, die ontevreden waren over
de Pacificatie van Gent, dewelke, naar men zeide, allen haat moest
uitdooven. En die Waalsche Paternosterknechten, met groote zwarte
rozenkransen om den hals, van dewelke tweeduizend te Spienne,
in Henegouw, werden gevonden, stalen twaalfhonderd, ja, tot twee
duizend ossen en peerden, onder de beste, trokken door velden en
sompen, ontvoerden vrouwen en meidekens, aten steeds zonder betalen,
en verbrandden in de schuren de gewapende boeren, die niet gedwee de
vrucht van hunne noeste vlijt lieten rooven.

En die van het volk zeiden tot elkander: "Don Juan gaat komen
met zijne Spanjolen, en Zijne Groote Hoogheid zal komen met zijne
paapschgezinde Franschen: en de Zwijger, dewelke gerust over Holland,
Zeeland, Gelderland, het Sticht, Overijsel wil heerschen, staat bij
geheime overeenkomst Belgieland af, opdat de heer van Anjou koning
kunne worden van hetzelve".

Eenigen uit het volk behielden nochtans hun vertrouwen. "De heeren
der Staten, zeiden zij, hebben twintig duizend goed gewapende mannen,
met vele kanonnen en een goede ruiterij. Zij zullen al de uitheemsche
soldaten wederstaan".

Maar de omzichtigen spraken: "De Heeren der Staten hebben twintig
duizend man op papier, maar geenszins te velde; zij hebben geene
ruiterij en laten, op eene mijl van hun kamp, hunne peerden stelen
door de Paternosterknechten. Zij hebben geen geschut, want, terwijl
wij er hier van doen hebben, hebben zij besloten honderd donderbussen
met kogels en kruit te zenden aan don Sebastiaan van Portugal; en men
weet niet waar de twee millioen daalders henen zijn, die wij in vier
maal als beden en schattingen hebben betaald. De poorters van Gent en
Brussel wapenen zich: Gent voor de hervorming en Brussel eveneens. Te
Brussel spelen de vrouwen op de tamboerijn, terwijl heure mannen aan
de vestingen werken. En het onversaagde Gent stuurt aan het lustige
Brussel het kruit en de donderbussen, welke hem ontbreken, om zich
te verdedigen tegen Malcontenten en Spanjaards.

"En elkeen, in de steden en op het platteland, ziet, dat men vertrouwen
moet hebben noch in onze heeren noch in zoovele anderen. En wij,
poorters en die van 't gemeen, zijn treurig in ons hert als wij
zien, dat, terwijl wij ons geld gaven en bereid zijn ook ons bloed
te geven, er geen vooruitgang komt voor het welzijn van den grond
onzer vaderen. En Belgieland is bang en gram, omdat het geen trouwe
hoofdmannen heeft, die het naar het gevecht brengen en naar de zege,
met groote inspanning van de wapenen, die gereed zijn tegen de vijanden
der vrijheid".

En de omzichtigen prevelden tot elkaar:

"In de Pacificatie van Gent bezwoeren de heeren van Holland en België
de uitdooving van allen haat, wederkeerigen onderstand tusschen
de Belgische Staten en de Nederlandsche Staten; verklaarden zij de
plakkaten van geener weerde, alle verbeurdverklaringen opgeheven, den
vrede tusschen de beide godsdiensten; zij beloofden alle hoegenaamde
zuilen, zegeteekenen, opschriften en standbeelden te zullen afbreken,
welke de hertog van Alva tot onze schande opgericht heeft. Doch in de
herten der hoofden blijft alle haat woeden; edelen en geestelijken
stoken verdeeldheid onder de Staten van het Verbond; zij krijgen
geld om de soldaten te betalen, en houden het voor zich om te zuipen
en te vreten; vijftien duizend gedingen wegens terugvordering van
verbeurdverklaarde goederen blijven opgeschort; Lutheranen en Roomschen
verbinden zich tegen de Calvinisten; de wettige erfgenamen vermogen
niet, de roovers uit hunne goederen te drijven; het standbeeld van
den hertog is nedergehaald, maar de beeltenis van de Inquisitie is
in al de herten".

En het arme volk en de jammerende poorters wachtten steeds op den
trouwen en wakkeren hoofdman, die hen zou brengen naar het gevecht
voor de vrijheid.

En zij zeiden tot elkander: "Waar zijn de doorluchtige onderteekenaren
van het Eedverbond, allen vereenigd, naar zij zeiden, voor het heil
des Vaderlands? Waarom sloten die valsche lieden een zoo "heilig
verbond", als zij het dadelijk daarna zouden verbreken? Waarom zich
met zooveel gezwets vereenigen, de gramschap des konings verwekken,
om daarna uiteen te gaan, als verraders en bloodaards? Met vijfhonderd
als zij waren, groote en kleine heeren, als broeders vereenigd, konden
zij ons van de Spaansche furie bevrijden; maar zij offeren België's
heil op aan hun eigen welzijn, zooals ook Egmond en Hoorne deden.

... Laas! zeiden zij, nu zal don Juan komen, die heerschzuchtige
vrouwengek, vijand van Philippus, maar nog grootere vijand van onze
landen. Hij komt voor den paus en zich zelf. Edelen en geestelijken
plegen verraad".

En zij beginnen een schijnoorlog. Op de muren van de straten en
stegen van Gent en van Brussel, tot zelfs op de masten van de schepen
der Geuzen, zag men toen uitplakken de namen van de legerhoofden
en bevelhebbers van versterkte plaatsen, die verraad pleegden:
die van den graaf van Liedekerke, dewelke zijn slot niet verdedigde
tegen don Juan; van den provoost van Luik, dewelke de stede aan don
Juan wilde verkoopen; van de heeren van Aerschot, van Mansfeld, van
Berlaymont, van Rennenberg; van den Staatsraad, van George Lalaing,
stadhouder van Friesland; van het legerhoofd, den heer van Rossignol,
afgezant van don Juan, bemiddelaar tusschen Philippus en Jaureguy,
den onbehendige, die moord wilde plegen op den Prins van Oranje; den
naam van den aartsbisschop van Kamerijk, die de Spanjaards binnen
de stede wilde laten komen; de namen der jezuïeten van Antwerpen,
die drie tonnen gouds--dat maakt twee millioen gulden--boden aan
de Staten om het kasteel niet af te breken, om het voor don Juan te
behouden; van den bisschop van Luik; van de Roomsche predikanten, die
de patriotten belaagden; van den bisschop van Utrecht, door de poorters
om zijn verraad uit het Sticht verdreven; van de bedelorden, die te
Gent konkelden ten voordeele van don Juan. Die van 's Hertogenbosch
stelden aan de kaak den naam van den karmeliet Pieter, die, geholpen
door zijnen bisschop en de geestelijkheid, zich sterk maakte de stede
aan don Juan over te leveren.

Te Dowaai hingen zij echter den rector der Hoogeschool in beeltenis
niet op, die insgelijks Spaanschgezind was geworden. Doch op de schepen
der Geuzen las men, op den buik van groote poppen, die bij den hals
aan de raas hingen, de namen van monniken, abten en prelaten; die van
de achttienhonderd rijke vrouwen en dochters uit het begijnenhof van
Mechelen, die, op eigen kosten, de beulen des vaderlands met vederen
en goudborduurselen versierden, en voorzagen in hunlieder onderhoud.

En op die poppen, schandpalen voor de verraders, las men de namen
van den markgraaf van Harrault, bevelhebber van de versterkte plaats
Philippeville, die oorlogsmunitie en mondbehoeften vermorste, om
naderhand de plaats aan den vijand te leveren, onder voorwendsel
dat hij gebrek had aan leeftocht; dien van Belver, dewelke Limburg
overgaf, alswanneer de stede het nog acht maanden volhouden kon; dien
van den voorzitter van den Raad van Vlaanderen; van den magistraat
van Mechelen, die zijne stede bewaarde voor don Juan, van de heeren
van het Rekenhof van Gelderland, dat gesloten was uit hoofde van
verraad; van die van den Raad van Brabant, van de kanselarij des
hertogdoms; van den privaten raad en van den raad van financiën; van
den hoogbaljuw en burgemeester van Meenen; van de slechte buren van
Artesië, die ongehinderd twee duizend Franschen doorlieten, dewelken
hier kwamen plunderen.

--Laas! zeiden de burgers tot elkaar, nu dat de hertog van Anjou den
voet in onze landen gezet heeft, wil hij hier koning zijn; zaagt gij
hem bij zijne inkomst in Bergen, klein, met groote heupen, een dikken
neus, een gele tronie, een spottenden mond?

... 't Is een groote prins, liefhebber van buitengewone minnarijen;
het moet een reus van een prins zijn, want men noemt hem: monseigneur
en mijnheer Zijne Groote Hoogheid van Anjou.

Uilenspiegel was droomerig.

En hij zong:


    De lucht is blauw, de lucht is klaar,
    Rouwfloers over de vanen!
    Rouw om 't gevest der degens!
    Verbergt uw juweelen,
    Uw spiegels gekeerd:
    Ik zing het lied van den Dood,
    Het lied der verraders.

    Ze hebben de fiere landen
    Op den buik en de keel getrapt,
    Brabant, Vlaanderen, Henegouw,
    Antwerpen, Artoois, Luxemburg.
    Adel en clerus verraden.
    Vuig loon verlokt, verleidt.
    Ik zing het lied der verraders.

    Als de vijand overal plundert,
    Als de Spanjaard Antwerpen binnenrukt,
    Trekken priesters, prelaten, legerhoofden
    De straten der stede door,
    Met zijden gewaden, vol goudstikkerij,
    En tronies blinkend van goeden wijn,
    Stellend hun schande ten toon.

    Door hen zal Inquisitie
    Herrijzen in triomf;
    En nieuwe titellui,
    Zullen doofstommen vastzetten
    Voor ketterij.
    Ik zing het lied der verraders.

    Onderteekenaren van 't Eedverbond,
    Lafhartige onderteekenaren,
    Wezen uw namen gevloekt.
    Waar blijft gij in 't uur des strijds?
    Als raven volgt gij
    Den drijf der Spanjaards.
    Slaat op de rouwtrom.

    Belgenland, eenmaal
    Veroordeelt u de toekomst,
    Daar ge, gewapend, u plunderen liet.
    Doch, toekomst, draal;
    Zie de verraders aan 't werk:
    Met twintig, met duizend,
    Bekleeden ze alle posten,
    De grooten stellen de kleinen aan.

    Het eens zijn ze 't
    Om den weerstand te verhindren,
    Door verdeeldheid en traagheid:
    Hun verradersleus!
    Rouwfloers over de spiegels,
    Rouw om 't gevest der degens.
    't Is het lied der verraders.

    Rebellen verklaren zij
    Spanjolen en malcontenten,
    Verbiedend hun bij te staan
    Met brood en bed,
    Met lood en kruit.
    En wordt er een gevangen,
    Om te hangen,
    Dadelijk laten zij hem los.

    Staat op! roepen die van Brussel;
    Staat op! roepen die van Gent
    En het Belgische volk.
    Arme lui, men wil u verpletteren,
    Tusschen den koning en den paus,
    Die tegen Vlaanderen
    Een kruistocht predikt.

    Ze komen, de veile knechten,
    Af op den reuk van het bloed;
    Benden honden,
    Slangen en hyena's,
    Hongerig, dorstig.
    Arme vadergrond,
    Rijp voor verval en dood!

    Niet don Juan maakt het Farnese,
    Des pausen lieveling,
    Makkelijk in 't land,
    Maar wie gij overlaaddet
    Met goed en eere,
    Wie uw vrouwen de biecht afnamen,
    Uw dochters en uw kinderen!

    Die wierpen u ter aarde,
    En de Spanjaard zet u
    Het mes op de keel.
    Een snoode spot was 't
    Dat ze te Brussel
    De komst van Oranje vierden!

    Toen men op de vaart
    Die macht van vuurwerk zag,
    Waar de vreugd uit sprankte en knalde,
    En al die zegebooten,
    Tafreelen en tapijten,
    Arm België, dan vertoonde men
    Een oude historie:
    Joseph verkocht door zijn broeders.




III.

Daar de monnik zag, dat men hem maar liet praten, maakte hij nog
grooter misbaar, en de matrozen en soldaten, om hem nog meer op
te hitsen, spraken kwaad van de Maagd, van de santen en van de
godvruchtige praktijken der Heilige Roomsche Kerk.

En, in woede ontstoken, braakte hij duizend beleedigingen uit:

--Ja! schreeuwde hij, ja, ik ben hier wel in het hol van de Geuzen! Ja,
dat zijn wel die verdoemde opvreters van de landen! En men zegt,
dat de inquisiteur, de heilige man, te veel van die galgebrokken
verbrand heeft! Integendeel: er blijft nog veel te veel van dat
gebroed over. Ja, op die goede en brave schepen van Onzen Heer Koning,
die vroeger zoo zindelijk waren en zoo goed geschrobd, wemelt nu dat
ongedierte van Geuzen, ja, het stinkend ongedierte. Ja, allen zijn
vuil, stinkend, afschuwelijk ongedierte, de kapitein, die zingt van
's morgens tot 's avonds, de kok met zijn dikken, goddeloozen buik,
en ook al de anderen, met hun heiligschennende halvemanen. Ja, als de
koning zijne schepen met geschut zal doen kuischen, zal er voor meer
dan honderdduizend gulden kruit en kogelen noodig zijn om die vuile,
leelijke, stinkende besmetting te verdrijven. Ja, gij allen zijt
geboren in de alkoof van vrouwe Lucifer, die veroordeeld was om te
wonen met Satan, tusschen muren van ongedierte, onder gordijnen van
ongedierte, op een bed van ongedierte. Ja, en dáár is het, dat zij,
in hun afschuwelijke minnarijen, de Geuzen ter wereld brachten. Ja,
en ik spuw op ulieden.

Bij die rede, zeiden de Geuzen tot elkander, zoodat hij het hoorde:

--Waarom onderhouden wij dien luien hond, dewelke niets doet dan
beleedigingen braken? Wij zouden hem beter ophangen!

En dra brachten zij alles in gereedheid.

Toen de monnik zag, dat de koorde vastgeknoopt was en de ladder tegen
den mast stond, en dat men zijne handen ging binden, zeide hij op
jammerenden toon:

--Hebt medelijden met mij, heeren Geuzen, 't is de duivel der
grammoedigheid, die spreekt in mijn hert, maar geenszins uw nederige
gevangene, een arme monnik, die maar éénen hals heeft op deze wereld;
genadige heeren, weest bermhertig: 't was niet gemeend; sluit mijnen
mond, als gij wilt, met eene prop; aangenaam is dit niet, neen,
maar om Godswil, hangt mij niet op!

Maar zij luisterden niet en trokken hem naar de ladder,
niettegenstaande zijn heftigen wederstand. Toen huilde hij zoo
schromelijk, dat Lamme zeide tot Uilenspiegel, die bij hem in de
keuken was om hem op te passen:

--Mijn vriend! mijn vriend! zij hebben in den stal een verken gestolen
en daar zijn ze bezig met het te kelen. Ho! de dieven! kon ik maar op!

Uilenspiegel klom op het dek en zag niets dan den monnik. Toen deze
hem ontwaarde, viel hij op zijne knieën en riep, met de handen naar
hem uitgestoken:

--Messire kapitein, kapitein van de wakkere Geuzen, geducht te land
en ter zee, uwe soldaten willen mij ophangen, omdat ik zondigde met
mijn tonge; dat is een onrechtveerdige straf, messire kapitein, want
dan moesten al de advocaten, procureurs, predikanten en al de vrouwen
met hennep begiftigd worden, en zou de wereld zekerlijk uitsterven;
messire, red mij van de koorde: ik zal voor u bidden, gij zult niet
verdoemd wezen; schenk mij vergiffenis. De spreekduivel sleepte mij mee
en deed mij gedurig snateren: dit is een groot ongeluk voor mij. Dan
verbittert zich mijn arme gal en doet ze mij allerhande dingen zeggen,
die niet gemeend zijn. Genade, messire kapitein, en gij allen, mijne
heeren, bidt voor mij.

Plotseling verscheen Lamme in zijn hemde op het dek, en hij zei:

--Kapitein en vrienden, wat ben ik blijde: 't was maar de monnik,
dien ik hoorde schreeuwen, en geenszins het verken. Uilenspiegel,
mijn zoon, ik heb een uitmuntend plan uitgedacht ten opzichte van
Zijne Paterschap; schenk hem het leven, maar laat hem niet vrij, of
hij speelt ons nog slechte poetsen op het schip: laat liever voor hem
op het dek een enge, goed verluchte kooi maken, in dewelke hij slechts
kan zitten en slapen, gelijk voor de kapoenen; laat mij hem spijzen,
en hij worde gehangen als hij zooveel niet eet als ik wil.

--Hij worde gehangen, als hij niet eet, zeiden Uilenspiegel en
de Geuzen.

--Wat schikt gij met mij te doen, dikzak? vroeg de monnik.

--Dat zult ge later gewaarworden, antwoordde Lamme.

En Uilenspiegel deed zooals Lamme wilde, en de monnik werd in de kooi
gestoken, en elkeen kon hem op het gemak komen zien.

Lamme was terug in de keuken gekeerd; Uilenspiegel volgde hem daar
en hoorde hem twisten met Nele:

--Ik leg mij te bed niet, zeide hij, neen, ik leg mij te bed niet;
anderen zouden mijne sausen komen vermorsen; neen, ik blijf in mijn
bed niet liggen lijk een kalf!

--Maak u niet boos, Lamme, zeide Nele, of uwe wond gaat opnieuw open,
en gij sterft.

--Wel, zeide hij, dan sterf ik: ik ben moede van te leven zonder mijne
vrouw. Is het niet hard genoeg voor mij, heur verloren te hebben, dat
gij mij, den kok van het schip, nog wilt beletten zelf te zorgen voor
den pot? Weet gij dan niet, dat geur van sausen en stoverije gezondheid
baart? Zij voedt zelfs mijnen geest en pantsert mij tegen rampspoed.

--Lamme, zeide Nele, gij moet luisteren naar onzen raad en u laten
genezen door ons.

--Ik wil mij laten genezen, sprak Lamme; maar dat geen andere, geen
weetniet, geen leepoogige, stinkneuzige, etterige, slijmerige rabauw
zich verstoute hier binnen te komen, om hier als kok te tronen in
mijne plaats, en met zijn vuile vingeren mijne sausen te vermorsen,
of ik sla hem den kop in met mijn houten pollepel, dewelke dan van
ijzer zou zijn.

--Maar, zeide Uilenspiegel, gij moet toch een helper hebben, gij
zijt ziek....

--Een helper, ik! zeide Lamme; ik, een helper! Om dat te zeggen,
moet gij zoo vol ondankbaarheid zijn als eene worst, vol gekapt
vleesch. Een helper, Thijl, en gij zijt het, die dit zegt tot mij,
uwen vriend, die u zoo lang en zoo lekker gevoed heeft! Nu gaat mijne
wond zeker weer open. Slechte vriend, wie anders hier zou uwe spijzen
bereiden, dan ik? Wat zoudt gij beiden doen, als ik hier niet was om
u, kapitein-hoofdman, en u, Nele, een of ander smakelijk gerecht voor
te dienen?

--Wij zouden ons behelpen en zelven den pot koken, zeide Uilenspiegel.

--Den pot koken? zeide Lamme. Gij zijt goed om er van te eten, om zijn
reuk op te snuiven; maar om hem gereed te maken, neen: arme vriend en
kapitein-hoofdman, met al den eerbied, dien ik u verschuldigd ben,
ik zou u in reepen gesneden weitasschen geven en gij zoudt ze eten
voor vette darmen; laat mij, mijn vriend, hier kok blijven, of ik
verdroog als een stok.

--Blijf dan kok, zeide Uilenspiegel; maar geneest gij niet, dan sluit
ik de keuken en eten wij niets dan beschuit.

--Ha! mijn zoon, zeide Lamme, die weende van geluk, gij zijt goed
als de Moeder Gods.




IV.

Doch hij scheen aan de beterhand.

Alle Zaterdagen zagen de Geuzen hem het middel van den monnik meten,
met een langen lederen riem.

Den eersten Zaterdag zeide hij:

--Vier voet.

Daarna mat hij zich zelven en sprak:

--Vier voet en half.

En hij scheen weemoedig.

Maar den achtsten Zaterdag, van den monnik sprekend, zeide hij vol
blijdschap:

--Vier voet en drij kwart.

En als hij den monnik de maat nam, zeide deze grammoedig tot Lamme:

--Wat wilt ge van mij, dikzak?

Maar Lamme stak zijne tong uit naar hem en zeide geen woord.

En, zevenmaal daags, zagen de soldaten en matrozen hem met een of
ander nieuw gerecht afkomen en hoorden zij hem zeggen tot den monnik:

--Hier zijn boonen met Vlaamsche boter: at gij er dergelijke in
uw convent? Gij hebt een goede tronie: mager wordt men niet op
de vloot van de Geuzen. Voelt gij geen kussen van vet in uwen rug
groeien? Weldra hoeft gij, om te slapen, op geene matras meer te
liggen.

Bij het tweede maal, zeide hij:

--Zie, hier zijn koekebakken naar de Brusselsche wijs; zie maar
wat blonde, goudgele tint zij kregen in de oven: ziet gij de boter
afdruipen? Zoo ook zal geschieden met het vet van uwen buik.

--Ik heb geen eetlust, zei de monnik.

--Maar gij moet eten, zei Lamme. Meent gij misschien, dat het
heetekoeken van boekweitbloem zijn? 't Is zuivere tarwe, eerweerde
vader, dikke, vette vader, 't is bloem van tarwemeel, vader met
vierdubbele kin: ik zie de vijfde reeds aankomen, en mijn hert is
verblijd. Eet!

--Laat mij met vrede, dikzak, zei de monnik.

Lamme, die grammoedig werd antwoordde:

--Ik beschik over uw leven: hebt gij liever de koorde dan een goede
teil erwtensoep met stukjes geroosterd brood, zooals ik er u dadelijk
eene zal brengen?

En toen Lamme met de teil kwam, vervolgde hij:

--Erwtensoep alleen is eigenlijk geen eetmaal: ik heb er dan ook een
schotel knoedelen naar Duitsche wijs bijgevoegd: dat zijn balletjes
deeg met krenten, in het kokend water geworpen; knoedelen zijn zware
kost, doch kweeken spek. Eet zooveel als gij kunt: hoe meer gij eet,
hoe liever ik u zie: gij moet den viesneus niet spelen, en niet blazen
alsof gij meer dan uwe bekomst hadt: eet! Is het niet beter te eten
dan hangen te bengelen aan eene koord? Laat uwe dij zien! zij wordt
ook dikker; twee voet en zeven duim omtrek. Waar vindt men nog eene
hesp, die zoo dik is?

Een uur naderhand kwam hij weer bij den monnik:

--Neem, zeide hij, hier zijn negen duifjes: men heeft ze opzettelijk
geschoten voor u, de onschuldige dieren, die, onbevreesd, boven de
schepen vlogen; versmaad ze niet; in hunnen buik stak ik een balletje
boter, broodkruim, geraspte muskaatnoot, kruidnagelen gestampt in een
koperen vijzel, dewelke blinkt als uw vel: mevrouw de zonne is gansch
verheugd zich te mogen spiegelen in een zoo helder gezicht als het uwe;
dat komt van het vet, van het goede vet, dat ik u bezorgde!

Voor den vijfden maaltijd, bracht hij een waterzoo.

--Wat denkt gij hiervan? vroeg hij hem. De zee draagt en spijst u;
meerder zou zij niet kunnen doen voor Zijne Koninklijke Majesteit. Ja,
ja, klaarblijkelijk zie ik de vijfde kin wassen, een weinigje meer
links dan rechts; wij zullen dien benadeelden kant moeten aanvetten,
want de Heer heeft gezeid: "Weest rechtveerdig jegens elkeen". Waarin
zou de rechtveerdigheid anders bestaan, dan in een rechtmatige
verdeeling van vet? Voor uw zesde maal breng ik u mosselen--die
oesters der armen--zooals gij er nooit kreegt in 't convent; dommeriken
laten ze koken en eten ze zóó op, doch dat is maar de inleiding der
stoverije: als zij gekookt zijn, moet men ze uit heure schelpen nemen,
heure tengere lichaampjes in een stoofpan leggen, dan zachtjes laten
stoven met selder, muskaatnoot en kruidnagelen en de saus binden met
bier en meel; de mosselen worden dan voorgediend met sneden geroosterd
en geboterd brood. Zoo deed ik voor u. Waarom zijn de kinderen een
zoo groote erkentelijkheid verschuldigd aan vader en moeder? Omdat
zij hun eene schuilplaats en liefde, maar vooral omdat zij hun eten
gaven: dienvolgens moet ge mij beminnen als uw vader en uwe moeder
te zamen, en zijt ge mij dezelfde dankbaarheid verschuldigd als hun:
maar zie toch zoo verbolgen naar mij niet.

... Als de mosselen gezakt zijn, breng ik u bierpap, goed gebonden met
meel, goed gesuikerd, met veel kaneel. Weet gij waarom? Opdat uw vet
doorschijnend zou worden en lustig op uw vel zou waggelen: als gij u
verroert, ziet men het alreeds. Daar klinkt de taptoe: slaap in vrede
zonder aan den dag van morgen te denken, in de zekerheid steeds uw
vette eetmalen terug te vinden, alsmede uw verkleefden vriend Lamme,
die ze u liefdevol zal geven.

--Ga henen, satansjong, en laat mij bidden, zeide de monnik.

--Bid, zeide Lamme, bid met begeleiding van een vroolijk gesnork:
bier en slaap geven vet, goed vet. Ik, ik ben blijde!

En Lamme trok naar zijn bed.

En de matrozen en soldaten zeiden tot hem:

--Waarom toch wilt gij dien vuilen monnik, die u geenerlei goed wil,
zoo rijkelijk spijzen?

--Laat mij begaan, zeide Lamme, ik verricht een schoon werk.




V.

Toen Wintermaand was gekomen, de maand der donkere dagen, zong
Uilenspiegel:


    Monseigneur, Zijn Doorluchtige Hoogheid,
    Rukt zijn mom af,
    Willend heerschen over België.
    De verspaanschte staten,
    Doch niet verangevijnscht,
    Beschikken over de belastingen.
    Slaat op de trommel
    Der angevijnsche davering!

    In hunne handen houden ze
    Domeinen, accijns en renten,
    't Benoemen der magistraten
    En de ambten meteen.
    Op de hervormden heeft hij 't gemunt,
    Monsieur Zijn Doorluchtige Hoogheid,
    Die in Frankrijk doorgaat voor atheïst.
    O, de angevijnsche davering!

    Want koning wil hij worden
    Door het zwaard en 't geweld,
    Alleenheerschend koning voorgoed,
    Die Monseigneur, en Doorluchtige Hoogheid.
    Innemen wil hij door verraad,
    Menig schoone stad en Antwerpen mee;
    Signorkens en pagaders, vroeg opgestaan,
    O, de angevijnsche davering!

    Niet op u, Frankrijk,
    Werpt zich het volk, in blinde woede;
    Niet uw edel lichaam treffen
    Moorddadige wapenen;
    Niet uw kinderen zijn het,
    Wier lijken, hoop op hoop,
    De Kipdorppoorte vullen.
    O, de angevijnsche davering!

    Neen, niet uw kinderen zijn het
    Die het volk van de schansen neergooit,
    Anjou is 't, Zijn Doorluchtige Hoogheid,
    Anjou is 't, de lijdelijke wufteling,
    Die leeft van uw bloed, o Frankrijk,
    En het onze wil drinken.
    Maar tusschen beker en lippen....
    O, de angevijnsche davering!

    Monsieur Zijn Doorluchtige Hoogheid,
    Schreeuwt in een weerlooze stad:
    Tue, tue, vive la messe!
    Met zijn mooie lievelingen,
    Wier oogen blinken
    Van 't schandevuur, schaamteloos schuw,
    Der ontucht zonder liefde.
    O, de angevijnsche davering!

    Hen velt men, niet u, arm volk,
    Op wien ze drukken met belasting,
    Zoutgeld, hoofdgeld, 't eerstenachtrecht,
    U misprijzend, daar ze u afpersen
    Koorn, paarden, wagens,
    Gij, die hun een vader zijt,
    O, de angevijnsche davering!

    Gij, die hun een moeder zijt,
    Zogend de brooddronkendheid
    Dier moedermoorders, welke, in den vreemde
    Uw naam bevlekken, o Frankrijk, overdaan
    Met den smook van hun glorie,
    Als ze hechten
    Door woeste wapenfeiten....
    O, de angevijnsche davering!

    Een bloempjen aan uw krijgskroon,
    Een provincie aan uw grondgebied.
    Laat den dwazen haan, ontucht en oorlog,
    Den voet op den strot,
    Fransch volk, manhaftig volk,
    Den voet die verplet!
    En al de volkeren krijgen u lief
    Om de angevijnsche davering!




VI.

In de Bloeimaand, als wanneer de Vlaamsche boerinnen 's nachts
langzaam drie zwarte boonen achter zich over het hoofd werpen, om
zich voor ziekte en dood te behoeden, ging Lamme's wond weder open;
de kok had een zware koorts en vroeg, dat men hem zou leggen op het
dek van het schip, rechtover de kooi van den monnik.

Uilenspiegel stond het geerne toe; doch uit vreeze, dat zijn vriend
in eenen aanval der ziekte overboord zou vallen, deed hij hem stevig
binden op zijn bed.

Zoodra Lamme een oogenblik bij zijn verstand was, vroeg hij of men
den monnik niet vergat; en hij stak zijne tong naar hem uit.

En de monnik zei:

--Gij beleedigt mij, dikzak.

--Toch niet, zeide Lamme, ik wil u vetmesten.

De wind waaide zachtjes, de zonne was warm; Lamme leed aan de koorts,
maar hij was stevig gebonden op zijn bed, opdat hij in zijne vlagen
van ijlhoofdigheid niet overboord zou vallen; doch hij waande zich
nog in de keuken en zei:

--Dat fornuis staat heel gereed. Aanstonds zal het ortolanen
regenen. Vrouw, span de strikken in onzen boomgaard. Zoo zijt
gij schoon, met uwe mouwen opgestroopt tot aan uwe ellebogen. Uw
arm is wit, ik wil er in bijten, bijten met mijne lippen, dewelke
fluweelen tanden zijn. Wien hoort dat schoon vleesch, die prachtige
boezem, dien ik zie dwars door uw wit, fijnlinnen jakje? Die
zoete schat is mijn! Wie zal de stoverije maken van hanekammetjes
en kiekenstuiten? Niet te veel muskaatnoot, daarvan krijgt men
koorts. Witte saus, tijm en laurier. Waar zijn de eierdooiers?

Vervolgens wenkte hij Uilenspiegel tot zich en zeide:

--Straks zal het wild regenen: ik zal u vier ortolanen meer geven
dan aan de anderen. Gij zijt de gezagvoerder, maar verraad mij niet!

Toen hij de golven zachtjes tegen den wand van het schip hoorde
klotsen, sprak hij verder:

--De soep kookt, mijn zoon, de soep kookt, maar met dat fornuis kan
ik geen vuur krijgen.

Zoodra hij weer tot zijne zinnen kwam, vroeg hij naar den monnik.

--Waar is hij? Vet hij aan?

En als zijn blik op hem viel, stak hij zijne tong naar hem uit,
zeggende:

--Het groote werk wordt voltooid.

Eens vroeg hij, dat men de groote waag op het dek zou brengen,
dat men hem zelven op een schaal zou zetten en den monnik op de
andere. Nauwelijks was de monnik erop, of Lamme steeg omhoog lijk
een vuurpijl in de lucht en, hem vreugdevol beziende, zeide hij:

--Hij is zwaarder! hij is zwaarder! ik ben licht als een geest tegen
hem: ik wil als een vogel de lucht klieven; ik heb mijn plan: neemt
er hem af, dat ik beneden kunne; legt er nu de gewichten op: zet hem
weder op de schaal. Hoeveel weegt hij? Driehonderd veertien pond. En
ik? Tweehonderd twintig!




VII.

In den nacht van den volgenden dag, bij de eerste ochtendschemering,
werd Uilenspiegel gewekt door Lamme, die schreeuwde:

--Uilenspiegel! Uilenspiegel! help, laat heur niet vertrekken. Snijd
de koorden door! snijd ze door!

Uilenspiegel klom op het dek en vroeg:

--Waarom roept gij? ik zie niets.

--Zij is 't, antwoordde Lamme, zij is 't, mijne vrouw, daar in die
sloep, welke de vlieboot omvaart; ja, om de vlieboot, van welke die
zangen en die vedeltonen kwamen.

Nele was ook op het dek geklommen.

--Snijd de koorden door, mijne vriendin, zei Lamme. Ziet gij niet,
dat mijne wond genezen is? Heur zachte hand heeft ze verbonden; zij,
ja, zij. Ziet gij ze rechtstaan in de sloep? Hoort gij? Zij zingt
nog. Kom, mijne liefste, kom, ontvlucht uwen armen Lamme niet meer,
die zonder u zoo moederziel alleen was op de wereld.

Nele nam zijne hand vast en legde de heure op zijn voorhoofd.

--Hij heeft nog koorts, sprak zij.

--Snijdt de koorden door, zei Lamme; geeft mij eene sloep! Ik ben
levend, ik ben gelukkig, ik ben genezen!

Uilenspiegel sneed de koorden door: Lamme sprong in zijn wit linnen
hooze, zonder wambuis, uit zijn bed, en wilde zelf de sloep in
zee laten.

--Zie hem bezig, zeide Nele tot Uilenspiegel: zijne handen beven
van ongeduld.

Toen de sloep gereed was, daalden Uilenspiegel, Nele en Lamme er in
met eenen roeier, en deze wriggelde naar de vlieboot, die, verre in
de reede, op anker lag.

--Zie, wat schoone vlieboot, zeide Lamme, die weldra, uit ongeduld,
de plaats van den roeier ingenomen had.

De romp en de masten van de vlieboot kwamen slank uit op den frisschen
morgenhemel, die, als verguld kristal, gekleurd werd door de rijzende
zonne.

Terwijl Lamme dapper doorwrikte, vroeg Uilenspiegel hem:

--Zeg ons nu hoe gij ze terugvondt.

Lamme antwoordde met horten en stooten:

--Ik sliep, reeds aan de beterzijde. Eensklaps dof gerucht. Stuk hout
klopt op het schip. Sloep! Op het gerucht een matroos toegeloopen:
Wie daar? Een zoete stem, de heure, mijn zoon, de heure antwoordt:
"Vrienden". Vervolgens grovere stem: "Vive le Geus: bevelhebber van
vlieboot Johanna moet Lamme Goedzak spreken". Matroos laat de ladder
beneden. De maan glom. Ik zie mannelijke gedaante op het dek klimmen:
breede heupen, ronde knieën, breed bekken; vrouw, maar geen man, zei
ik bij mij zelven: ik voel als eene roos die ontluikt en mijne kaak
streelt: heure lippen, mijn zoon, en ik hoor heur zeggen, begrijpt
gij? zij zelve, mij met kussen en tranen bedekkend--vloeibaar vuur,
dat als balsem nederviel op mijn gelaat--zij zelve zeide mij: "Ik weet,
dat ik misdoe, maar ik bemin u, mijn man! Ik heb voor God gezworen: ik
verbreek mijnen eed, mijn man, mijn arme man! dikwijls ben ik gekomen
zonder u te durven naderen; eindelijk stond de matroos het mij toe:
ik verbond uwe wond, gij herkendet mij niet; maar ik heb u genezen,
wees niet grammoedig, man! Ik ben u gevolgd, maar ik ben bevreesd,
hij is op dit schip: laat mij vertrekken; zoo hij mij zag, zou hij mij
verdoemen en zou ik branden in het eeuwige vuur!" Zij kuste mij nog,
weenend en gelukkig, en vertrok, mijns ondanks, in spijt van mijne
tranen: gij hadt mijne armen en beenen gebonden, mijn zoon, maar nu....

Dit zeggende, gaf hij krachtdadige riemslagen; het was als de gespannen
koord van eenen boog, die den pijl in de lucht schiet.

Naarmate zij de vlieboot naderden, zeide Lamme:

--Daar staat zij op het dek, zij speelt op de vedel, mijn beminnelijke
vrouw, met heur goudbruine lokken, heur bruine oogen, heur frissche
koonen, heur bloote, ronde armen, heur witte handjes. Vlieg over den
vloed, sloep!

Toen de kapitein van de vlieboot de sloep zag naderen en Lamme als een
duivel wriggelen, liet hij eene ladder uitwerpen. Toen Lamme er dicht
bij was, sprong hij van de sloep op de ladder, op gevaar af van in
zee te vallen, zoodat de sloep meer dan drie vademen achteruit gleed;
en, vlug als eene kat op het dek klaverend, liep hij naar zijne vrouw,
die, buiten zich zelve van geluk, hem kuste en omhelsde, en zeide:

--Lamme! breng mij niet ten verderve; ik heb voor God gezworen,
maar ik bemin u. Ha! lieve man!

Nele riep:

--'t Is Kalleken Huybrechts, het schoone Kalleken!

--Ik ben het, sprak zij, ja, Kalleken, maar schoon is ze niet meer!

En zij zette een jammerlijk gezicht.

--Wat hebt gij gedaan, vroeg Lamme, wat zijt gij geworden? waarom
liet ge mij zitten? waarom wilt gij mij weder verlaten?

--Luister, zeide zij, wees niet grammoedig, ik zal u alles bekennen:
wetende dat al de monniken mannen Gods zijn, vertrouwde ik mij aan
een hunner; hij heet broer Cornelis Adriaensen.

Toen Lamme dit hoorde, riep hij uit:

--Wat, die smerige paap, wiens mond een rioolgat was, vol drek en vol
modder, en die steeds dorstte naar het bloed der hervormden! Wat! die
verdediger der brandstapels en der plakkaten! Ha! 't was die gemeene
schavuit!

Kalleken sprak:

--Laster den man Gods niet!

--De man Gods! zeide Lamme, ik ken hem: het was de man van vuilnis en
vuigheid. Wat rampspoed! mijn schoon Kalleken gevallen in de handen
van dien ontuchtigen vuilbaard! Nader mij niet, of ik dood u; en ik,
die heur zoozeer beminde! mijn arm bedrogen hert, dat ganschelijk
heur was! Wat komt gij hier doen op onze schepen? waarom hebt gij mij
opgepast? waarom liet ge mij niet sterven? Ga heen, ik wil u voor mijne
oogen niet meer zien; ga heen, of ik smijt u in de zee. Mijn mes!...

Doch zij vloog om zijnen hals en sprak:

--Lamme, mijn man, ween niet: ik ben niet wat gij denkt: ik behoorde
nooit aan dien monnik.

--Gij liegt, zeide Lamme weenend en knarsetandend tegelijk. Ha! nooit
was ik jaloersch, doch nu ben ik het! Ongelukkige drift, grammoedigheid
en liefde, behoefte aan dooden en worgen. Uit mijne oogen! neen,
blijf! Ik was zoo goed voor heur! De moordlust is meester in mij. Mijn
mes! Ho! hier brandt, verteert, knaagt iets in mij; gij spot met
mij....

Zoet en onderdanig, omhelsde zij hem weenend.

--Ja, zeide hij, ik ben belachelijk met mijne gramschap: ja, gij
bewaardet mijne eer, die eer, die men dwaselijk hangt aan den rok
eener vrouw. Daarom was het dus, dat gij uw zoetste lonkjes koost om
mij te vragen of gij met uwe vriendinnen naar het sermoen mocht gaan?

--Laat mij spreken, zei de vrouw hem omhelzend: ik mag op staanden
voet doodvallen, zoo ik u ooit bedroog.

--Wel, val dan dood, zeide Lamme, want gij gaat liegen!

--Luister, zeide zij.

--Spreek of zwijg, sprak Lamme, 't is mij eender.

--Broer Adriaensen, zeide zij, ging door voor een bespraakt predikant;
hij stelde den geestelijken en den ongehuwden staat verre boven
den anderen, als best geschikt om de geloovigen in het hemelrijk te
brengen; zijne welsprekendheid was groot en onstuimig: daardoor bracht
hij het verstand op hol van meerdere eerlijke vrouwen, onder dewelke
ik telde, en ook van een groot aantal weduwen en meidekens. Vermits
de ongehuwde staat zoo volmaakt was, bezwoer hij ons in denzelven te
blijven: wij zwoeren, dat wij ons nimmermeer zouden laten trouwen....

--Behalve door hem ... zei Lamme weenend.

--Zwijg toch, zeide zij grammoedig.

--Komaan, sprak hij, voltooi uw werk: gij hebt mij een harden slag
toegebracht, ik zal hem niet overleven.

--'t Doet, zeide zij, zoo ik altijd bij u blijf, man.

Zij wilde hem omhelzen en kussen, maar hij stiet heur van zich af.

--De weduwen, zeide zij, zwoeren vóór hem, nooit te zullen hertrouwen.

En Lamme aanhoorde heur, gedachteloos in zijn jaloersche droomerij.

Kalleken vervolgde, beschaamd, heure rede:

--Hij wilde, zeide zij, geen andere biechtelingen dan jonge en schoone
vrouwen of meidekens: de anderen stuurde hij naar den paap heurer
parochie. Hij stelde eene orde van godvruchtige vrouwen in, en deed
ons allen zweren niemand anders tot biechtvader te zullen nemen dan
hem: dat zwoer ik; mijne gezellinnen, beter onderricht dan ik, vroegen
mij of ik mij wilde laten onderwijzen in de Heilige Geeseling en in de
Heilige Boete: ik stemde toe. Er was te Brugge, op de Steenkappersrei,
omtrent het Minderbroedersklooster, een huis bewoond door eene vrouw,
genoemd Kalle de Naeyer, welke aan de meidekens kost en onderricht
gaf, tegen een karolusgulden per maand: Broer Cornelis kon bij Kalle
de Naeyer binnen, zonder oogenschijnlijk uit zijn klooster te komen,
het was in dit huis dat ik ging, in een kleine kamer, in dewelke hij
zich alleen bevond; daar gebood hij mij, hem al mijn natuurlijke en
vleeschelijke neigingen te zeggen; eerst durfde ik niet, maar ten
slotte gaf ik toe: ik weende en zeide hem alles.

--Laas! schreide Lamme, en alzoo ontving die zwijnachtige monnik uw
zoete biechte!

--Hij zeide mij steeds, en dit is waar, mijn man, dat er boven de
aardsche eerbaarheid een hemelsche eerbaarheid bestaat, door dewelke
wij God onze wereldsche schaamte offeren, en dat wij aldus aan onzen
biechtvader al onze geheime lusten moeten bekennen, en dan weerdig
zijn de Heilige Geeseling en de Heilige Boete te ontvangen.

Eindelijk beval hij mij, naakt vóór hem te gaan staan, om op mijn
lichaam, dat gezondigd had, de al te lichte kastijding mijner schulden
te ontvangen. Eens gebood hij mij, mij te ontkleeden; ik viel in
onmacht toen ik mijn hemde moest uitdoen: hij bracht mij weer tot
mij zelve, door middel van fleschjes.--"'t Is goed voor deze reize,
mijne dochter, sprak hij, kom binnen twee dagen terug en breng eene
roede mee". Dit duurde lang, zonder dat hij ooit ... ik zweer het
voor God en al zijne santen ... mijn man ... begrijp mij ... kijk
naar mij ... zie of ik lieg: ik bleef zuiver en trouw ... ik beminde u.

--Arm zoet lichaam, zeide Lamme. O, vlek van schande op uw bruidskleed!

--Lamme, zeide zij, hij sprak in den naam Gods en onzer Moeder,
de Heilige Kerk; moest ik hem niet aanhooren? Ik beminde u steeds,
maar door schromelijke eeden had ik de Maagd gezworen mij aan u te
onttrekken; ik was nochtans zwak voor u, Lamme. Herinnert gij u nog het
gasthof te Brugge? Ik was bij Kalle de Naeyer, gij reedt daar voorbij
op uwen ezel, met Uilenspiegel. Ik volgde u; ik had een schoone som
gelds op zak, want ik verteerde niets voor mij zelve; ik zag, dat
gij honger hadt: mijn hert trok naar u, ik had medelijden en liefde!

--Waar is hij nu? vroeg Uilenspiegel.

Kalleken antwoordde:

--Na een onderzoek, bevolen door den magistraat, en eene nasporing
van de boozen, moest broer Adriaensen de stede Brugge verlaten,
en hij nam de wijk naar Antwerpen. Op de vlieboot zeide men mij,
dat mijn man hem gevangen nam.

--Wat! riep Lamme, die monnik dien ik vetmest, is....

--Hij zelf, antwoordde Kalleken, terwijl zij heur aangezicht met
heure handen bedekte.

--Eene akst! eene akst! zeide Lamme, dat ik hem doode, dat ik het
vet van dien geilen bok bij opbod verkoope! Gauw, laat ons naar het
schip terugkeeren. De sloep! Waar is de sloep?

Nele sprak:

--Het is een eerlooze wreedheid eenen gevangene te dooden of te
kwetsen.

--Gij beziet mij zoo verschrikkelijk, zeide hij, zoudt gij het mij
beletten?

--Ja, zeide zij.

--Wel, sprak Lamme, ik zal hem geenerlei leed doen: laat mij hem
slechts uit zijne kooi trekken. De sloep! Waar is de sloep?

Zij stapten weldra in de sloep. Lamme wrikte zoo vlug als hij kon en
schreide tegelijk.

--Zijt gij droef, man? vroeg Kalleken hem.

--Neen, zeide hij, ik ben gelukkig: zult ge mij niet meer verlaten?

--Nooit! zeide zij.

--Gij waart zuiver en trouw, zegt gij; maar, zoet, lief Kalleken,
ik leefde enkel om u weder te vinden, en nu zal, door de schuld van
dien monnik, ons geluk vergiftigd zijn door jaloerschheid.... Zoodra
ik droef zal wezen of enkellijk moede, zal ik u in verbeelding
naakt zien, uw schoon lichaam onderwerpende aan die schandelijke
geeseling. De lente onzer liefde was aan mij, doch de zomer aan hem;
de herfst zal grauw zijn; weldra komt de winter en die zal mijn trouwe
liefde begraven.

--Gij weent, zeide zij.

--Ja, sprak hij, wat voorbij is, komt nimmer terug.

Toen zei Nele:

--Als Kalleken trouw was, moest zij u weer alleen laten om uw leelijke
woorden.

--Hij weet niet hoezeer ik hem altoos beminde, zei Kalleken.

--Zegt gij de waarheid? riep Lamme uit; kom, liefste, kom, mijne vrouw;
geen grauwe herfst, en geen winter des doods meer!

En hij zag er blijde uit, en zij kwamen op het schip.

Uilenspiegel gaf de sleutels van de kooi aan Lamme, die deze opende;
hij wilde den monnik bij een oor op het dek trekken, maar het ging
niet; toen wilde hij hem zijdelings doen buitenkomen, maar het ging
ook niet.

Wij moeten het kot uitbreken; de kapoen is gemest, zeide hij.

De monnik kwam er toen uit, keek met groote, verdwaasde oogen in
het rond, hield met de beide handen zijn buik op, en viel op zijn
achterste, ter oorzake van een hevige baar, die het schip ophief.

En Lamme zei tot den monnik:

--Zult ge mij nog dikzak heeten? gij zijt dikker dan ik! Wie diende
u zeven eetmalen daags vóór? Ik! Hoe komt het, schreeuwer, dat gij
nu zachtmoediger zijt jegens de arme Geuzen?

En, zijne rede vervolgend:

--Als gij nog een jaar in uwe kooi blijft, kunt gij er niet meer uit:
bij de minste beweging lillen uwe kaken als verkensgelei; gij schreeuwt
al niet meer; weldra zult gij niet meer kunnen blazen.

--Zwijg, dikzak, zeide de monnik.

--Dikzak, zei Lamme, in woede ontstekend, ik ben Lamme Goedzak;
gij zijt broer Dikzak, Vetzak, Slokzak, Leugenzak, Modderzak; gij
hebt vier duim spek onder uw vel; men ziet uwe oogen niet meer;
Uilenspiegel en ik zouden, op ons gemak, huizen in uwen buik, die
groot is als eene kerk. Gij heet mij dikzak, wilt gij eenen spiegel
om Uwe Dikbuikigheid te bewonderen? Ik ben het, die u voed, gevaarte
van vleesch en been. Ik heb gezworen, dat gij vet zult spuwen, dat
gij vet zult zweeten, dat gij sporen van vet achter u zult nalaten,
als eene keers, die smelt in de zonne. Men zei mij, dat de geraaktheid
komt met de zevende kin: de zesde is in aantocht!

Vervolgens wendde hij zich tot de Geuzen:

--Aanschouwt dien hoereerder! sprak hij. Het is broer Cornelis
Adriaensen, van Brugge: dáár preekte hij een nieuwe eerbaarheid. Zijn
vet is zijne straf, en zijne straf is mijn werk. Nu, luistert,
gij allen, matrozen en soldaten: ik ga u verlaten, u verlaten,
Uilenspiegel, u verlaten, u ook, kleine Nele, om naar Vlissingen
te tiegen, alwaar ik eenig goed bezit, en er te leven met mijn arme
wedergevondene vrouw. Vroeger zwoert gij, mij alles toe te staan wat
ik zou vragen....

--Dat is Geuzenwoord zeiden zij.

--Dus, zeide Lamme, aanschouwt dien hoereerder, dien broer Adriaensen,
Vetlap-aensen van Bruggen; ik zwoer hem te doen sterven in zijn vet
als een zwijn; maakt hem een grootere kooi, doet hem met geweld twaalf
eetmalen daags verorberen in stede van zeven; geeft hem vetten en
gesuikerden kost; hij lijkt reeds een os, maakt er een olifant van,
en weldra zult gij hem de hoeken zijner kooi zien vullen.

--Wij zullen hem voortmesten, zeiden zij.

--En nu, vervolgde Lamme, tot den monnik sprekend, u ook, rabauw,
dien ik doe voeden op kloosterwijs, in stee van u te doen hangen,
u ook zeg ik vaarwel: en leef op hoop van vet en van geraaktheid!

Vervolgens zijne vrouw, zijn Kalleken, in de armen drukkend, voegde
hij er bij:

--Kijk, gij moogt knorren of balken, maar ik neem ze mee, gij zult
ze niet langer geeselen!

Maar de monnik, in woede ontstoken, zeide tot Kalleken:

--Gij keert dus terug naar uw leger van wellust, o zinnelijke
vrouwe! Ja, gij gaat henen zonder mededoogen met den armen martelaar
voor Gods woord, die u de heilige, zoete en hemelsche geeseling
leerde. Wees gedoemd! Nooit schenke een priester u vergiffenis;
de grond brande onder uwe voeten; suiker weze u zout; ossevleesch
weze u kroengevleesch; brood weze u assche; de zonne weze u ijs,
en sneeuw een hellevuur; de vrucht uws lichaams weze gevloekt;
uwe kinderen wezen afschuwelijk: met de leden van een aap, een
verkenshoofd grooter dan hun buik; lijden, weenen, zuchten weze uw lot
in deze wereld en in de andere, in de helle die u wacht, de helle van
zwavel en pik, die branden voor de wijven van uw slag; gij weigerdet
mijn vaderlijke liefde: wees driemaal vermaledijd door de heilige
Drievuldigheid; zevenmaal vermaledijd door de kandeleers der Ark;
de biecht weze u verdoemenis; de hostie weze u doodelijk venijn; en,
in de kerken, richte elke vloersteen zich op om u te verpletteren en
u te zeggen: "Hier is de hoereerster; hier is de verdoemde; hier is
de vermaledijde!"

En Lamme sprong op van geluk en riep blijde uit:

--Zij was trouw, de monnik heeft het gezegd! Leve Kalleken!

Doch zij, weenend en sidderend, zeide:

--O, Lamme, neem die verdoemenis over mij weg! Ik zie de helle! Neem
de verdoemenis weg!

--Monnik, trek de verdoemenis in, gebood Lamme.

--Ik zal het niet doen, dikzak, antwoordde de monnik.

En de vrouw, bleek en sidderend, viel op de knieën en smeekte broer
Adriaensen met de handen te zamen.

En Lamme zei tot den monnik:

--Trek de verdoemenis in of gij wordt gehangen: en, breekt de koorde,
uit hoofde van uwe zwaarte, zoo wordt gij herhangen, totdat de dood
er op volge.

--Gehangen en herhangen! zeiden de Geuzen.

--Als het zoo is, zei de monnik tot Kalleken, ga dan, ontuchtige
vrouwe; ga dan met dien dikzak; ga, ik hef mijne verdoemenis op, maar
God en al zijne santen houden u in het oog: ga met dien dikzak, ga!

En hij zweeg, blazend en zweetend.

Plotseling riep Lamme uit:

--Hij zwelt op, hij zwelt op! Daar is de zesde kin: de zevende kin
is de geraaktheid!

... En nu, zeide hij tot de Geuzen, ik beveel u aan God, u,
Uilenspiegel aan God, u allen, mijn goede vrienden, aan God, Nele
mijne vriendin, aan God, de heilige zaak van de vrijheid: ik kan
niets meer voor haar....

Vervolgens, als hij iedereen omhelsd had, zeide hij tot zijne vrouw
Kalleken:

--Kom, het is het uur van onze wettige liefde.

Terwijl het bootje, dat Lamme en zijne welbeminde meevoerde, over
het water gleed, riepen al de matrozen, soldaten en scheepsjongens
met hunnen hoed zwaaiend:

--Vaarwel, broeder; vaarwel, Lamme; vaarwel, broeder, broeder en
vriend!

En Nele wischte met heur liefelijken vinger eenen traan uit het oog
van Uilenspiegel en zeide tot hem:

--Gij zijt droef, mijn vriend?

--Hij was goed, zeide hij.

--Ha! zeide zij, zal die oorlog dan nooit een einde nemen, zullen
wij dan immer gedwongen zijn te leven in bloed en in tranen?

--Laat ons de Zeven zoeken, antwoordde Uilenspiegel: het is nakend,
het uur der verlossing....

Volgens de belofte, die zij aan Lamme gedaan hadden, mestten de
Geuzen den monnik voort in zijne kooi. Doch op zekeren dag werden
zij het moede, en ze stelden hem in vrijheid tegen een rantsoen bij
't gewicht; en hij bracht een mooien stuiver op, want hij woog toen
driehonderd zeventien pond en vijf onsen, Vlaamsch gewicht.

En hij stierf als prior van zijn convent.




VIII.

Te dien tijde vergaderden de heeren van de Staten-Generaal te
's-Gravenhage, om Philippus, koning van Spanje, grave van Vlaanderen,
van Holland enz., te oordeelen naarvolgens de door hem verleende
charters en privileges.

En de griffier sprak als volgt:

--Het is een iegelijk bekend, dat een landvorst aangesteld is door
God, als souverein en hoofd zijner onderdanen, om ze te verdedigen
en te vrijwaren van alle beleediging, verdrukking en geweld, evenals
een herder aangesteld is voor de verdediging en de hoede zijner
kudde. Het is mede algemeen bekend, dat de onderdanen geenszins door
God geschapen zijn ten gerieve des prinsen, om hem gehoorzaam te wezen
in alles wat hij zou heeten, hetzij dat het vroom is of goddeloos,
rechtveerdig of onrechtveerdig, noch om denzelven te dienen als
slaven. Maar de vorst is vorst ten behoeve van zijne onderdanen,
zonder dewelke hij niet kan wezen, om naar recht en rede te bestieren;
om ze te behouden en te beminnen als een vader zijne kinderen, als
een herder zijn kudde, en zijn leven te wagen om ze te verdedigen;
doet hij het niet, zoo moet hij aanzien worden, niet voor eenen
vorst, maar voor eenen dwingeland. Door oproeping van soldaten,
door bullen van kruistocht en van kerkban, zond Philippus koning,
vier uitheemsche legers af tegen ons. Welke zal zijne straf wezen,
overeenkomstig de wetten en costumen van den lande?

--Hij weze vervallen, antwoordden de heeren der Staten.

--Philippus heeft zijne eeden verbroken; hij vergat de diensten, welke
wij hem bewezen, de zegepralen, welke wij hem hielpen behalen. Toen
hij zag, dat wij rijk waren, liet hij ons afzetten en bestelen door
die van den raad van Spanje.

--Hij weze vervallen als ondankbare en dief, antwoordden de heeren
der Staten.

--Philippus, vervolgde de griffier, stelde in de machtigste steden
des lands bisschoppen aan, begiftigde en bevoordeelde dezelven met
de goedingen der grootste abdijen; door de hulp van dezelven, bracht
hij de Spaansche Inquisitie in onze landen.

--Hij weze vervallen als beul, verkwister van eens andermans goeding,
antwoordden de heeren der Staten.

--Ten aanzien van de dwingelandij, vertoonden de edelen van de landen
ten jare 1566 een verzoekschrift, bij hetwelk zij den souvereinen
vorst smeekten zijn strenge plakkaten te verzachten en namelijk die
op het stuk der inquisitie: hij weigerde steeds.

--Hij weze vervallen als een tijger, die hardnekkig is in de wreedheid,
antwoordden de heeren der Staten.

De griffier vervolgde:

--Philippus wordt ernstig verdacht van, door die van zijnen raad
van Spanje, heimelijk den beeldenstorm en de plundering der kerken
te hebben bewerkt, ten einde, onder voorwendsel van misdaad en
wanordelijkheden, vreemde legers tegen ons te kunnen afzenden.

--Hij weze vervallen als een werktuig des doods, antwoordden de heeren
der Staten.

--Te Antwerpen deed Philippus de inwoneren slachten, en de Vlaamsche
en vreemde kooplieden ten onder brengen. Hij en zijn raad van
Spanje gaven, door heimelijke onderrichtingen, aan zekeren Roda,
een beruchten rabauw, het recht zich hoofdman der plunderaars te
verklaren, den buit op te garen, zijn naam, van hem, Philippus koning,
te gebruiken, zijne zegelen na te maken en zich te gedragen als zijn
landvoogd en stedehouder. De onderschepte koninklijke brieven, welke
zich in onze handen bevinden, bewijzen het stuk. Alles is gebeurd
met zijne toestemming en na overleg met den raad van Spanje. Leest
zijne brieven: daarin looft hij het feit van Antwerpen, bekent hij een
uitstekenden dienst ontvangen te hebben, belooft hij dien te zullen
beloonen, zet hij Roda en de andere Spanjaards aan, voort te gaan op
dien roemvollen weg.

--Hij weze vervallen als dief, als plunderaar, als moordenaar,
antwoordden de heeren der Staten.

--Wij willen slechts het behoud van onze privileges, een eerlijken
en verzekerden vrede, meer vrijheid, namelijk op het stuk van den
godsdienst, welke hoofdzakelijk eene gewetenszaak is: van Philippus
kregen wij niets dan leugenachtige verdragen, welke tweedracht
moesten zaaien onder de provinciën, om ze de eene na de andere te
onderwerpen en met haar te handelen als met Indië, door plundering,
verbeurdverklaring, terdoodbrenging en inquisitie.

--Hij weze vervallen als moordenaar, die den moord van de landen
beraamt, antwoordden de heeren der Staten.

--Hij deed de landen bloeden door den hertog van Alva en zijne
trawanten, door Medina Celi, Requesens, de judassen der raden van
State en van de provinciën; don Juan en Alexander Farnese beval hij
met ongemeene en bloedige strengheid te werk te gaan (zooals weer
blijkt uit zijne onderschepte brieven); hij sloeg in den rijksban Prins
Willem van Oranje, betaalde drie moordenaars, in afwachting dat hij den
vierden betaalt; deed in de landen kasteelen en vestingen oprichten,
deed de mannen levend verbranden, de vrouwlieden en meidekens levend
begraven; erfde hunne goedingen, verworgde Montigny, Bergen en andere
heeren, in weerwil van zijn koninklijk woord; hij doodde zijn zoon
Carlos; vergiftigde prins Ascoly, dien hij deed trouwen met dona
Eufrasia, dewelke door hem was bezwangerd, ten einde den bastaard,
die moest geboren worden, met zijne goederen te verrijken; veerdigde
tegen ons een edict uit, hetwelk ons allen verraders verklaarde, ons
lijf en goed ontnemend, en bedreef die in een kersten land ongekende
misdaad, geen onderscheid te maken tusschen schuldigen en onschuldigen.

--Uit hoofde van alle wetten, rechten en privilegiën, weze hij
vervallen, antwoordden de heeren der Staten.

En de zegels des konings werden gebroken.

En de zonne gloorde over land en zee, verguldde de gezwollen korenaren,
rijpte de druiven en strooide op elke baar van de zee flikkerende
perelen, het sieraad van Neerlands bruid: de Vrijheid.

Vervolgens werd de Prins, te Delft zijnde, door een vierden moordenaar
met drie kogels in de borst getroffen. En hij stierf, volgens zijne
spreuk: "Rustig onder de wreede baren".

Zijne vijanden zeiden van hem, dat hij, om koning Philippus te
bestoken, en daar hij toch niet hoopte over de zuidelijke, katholieke
Nederlanden te regeeren, deze bij geheim verdrag aangeboden had aan
monseigneur Zijne Groote Hoogheid van Anjou. Doch deze was geenszins
geboren om de telg Belgieland te verwekken bij de Vrijheid, dewelke
niet houdt van buitensporige minnarijen.

En Uilenspiegel verliet met Nele de vloot.

En het Belgische vaderland zuchtte onder het juk, geworgd, gekneveld
door de verraders.




IX.

Toen was men in de maand van het rijpe koren; de lucht was drukkend,
de wind zoel: onder den vrijen hemel, op een vrijen grond, konden
maaiers en pikkers in de akkers vrijelijk het koren oogsten, dat zij
gezaaid hadden.

Friesland, Drente, Overijsel, Gelderland, Utrecht, Noord-Brabant,
Noord- en Zuid-Holland; Walcheren, Noord- en Zuid-Beveland, Duiveland
en Schouwen, welke Zeeland uitmaken; heel de kust der Noordzee,
van Knokke tot den Helder; de eilanden Texel, Vlieland, Ameland,
Schiermonnikoog zouden, van de Wester-schelde tot de Ooster-Eems,
het Spaansche juk afschudden; Maurits, zoon van den Zwijger, zette
den oorlog voort.

Nog ten volle in het bezit van hunne jeugd, hunne kracht en hunne
schoonheid,--want de liefde en de geest van Vlaanderen blijven immer
jong,--leefden Uilenspiegel en Nele rustig in den toren van Veere,
in afwachting, dat, na menigvuldige wreede beproevingen, de wind der
vrijheid over het Belgische vaderland zou waaien.

Uilenspiegel had gevraagd om bevelhebber en wachter van den toren
te worden benoemd, aanvoerende, dat hij, met zijne arendsoogen en
hazenooren, zou kunnen zien en hooren of de Spanjaard het soms niet
beproefde terug te komen naar de verloste landen en dat hij alsdan
wacharm zou luiden.

De magistraat deed wat hij vroeg: om den wille van zijn goede diensten,
gaf men hem een gulden daags, twee pinten bier, boonen, kaas, beschuit,
alsmede drie pond vleesch in de week.

Aldus leefden Uilenspiegel en Nele getweeën heel goed; van verre zagen
zij met vreugde de vrije Zeeuwsche eilanden: weiden en bosschen,
kasteelen en vestingen, en de gewapende schepen der Geuzen, die de
kusten bewaakten.

's Nachts klommen zij zeer dikwijls omhoog op den toren en, daar naast
elkander gezeten, koutten zij over de harde gevechten, de schoone
minnarijen van het verleden en ook van de toekomst. Van daar zagen zij
de zee, welker lichtende golven zich braken en in schuim uiteenspatten,
en als vurige spoken op de eilanden vielen. En Nele was verschrikt
als zij in de polders dwaallichtjes zag, welke, zeide zij, zielen
van arme dooden zijn. En al deze plaatsen waren slagvelden geweest.

De dwaallichtjes stegen op uit de polders, huppelden langshenen
de dijken, keerden vervolgens terug naar de polders, alsof zij de
lichamen niet wilden verlaten, uit welke zij kwamen.

Op zekeren nacht zei Nele tot Uilenspiegel:

--Zie hoe talrijk zij zijn in Beveland, en hoe hoog zij zweven in de
lucht: langs den kant van de vogeleilanden zie ik er het meest. Wilt
gij medekomen, Thijl? wij zullen ons strijken met de zalve, welke
dingen toont, die onzichtbaar zijn voor de oogen der stervelingen.

Uilenspiegel antwoordde:

--Als 't die zalve is, die mij naar den grooten sabbat bracht, heb
ik er geen vertrouwen meer in.

--Loochen de kracht der tooverije niet. Kom mee, Uilenspiegel.

's Anderen daags vroeg hij aan den magistraat, dat een trouw en
scherpziend soldaat hem zou vervangen om den toren te wachten en te
waken over het land.

En hij toog henen met Nele naar de vogeleilanden.

Terwijl zij stapten langs akkers en dijken, zagen zij kleine
groene eilandjes, tusschen dewelke het zeewater stroomde, en, op de
begraasde heuvelen, die zich tot het duin uitstrekten, een groote
menigte kieviten, meeuwen en zeezwaluwen, die onbeweeglijk zaten
en met hunne ruggen witte eilandjes uitmaakten; daarboven vlogen
duizenden van die vogelen. De grond was vol nesten: Uilenspiegel,
die zich bukte om een ei van den weg op te rapen, zag eene meeuw
fladderend naar hem komen en een grooten schreeuw slaken. Op dien
kreet kwamen meer dan honderd andere bij, die schreeuwden van angst
en boven het hoofd van Uilenspiegel en de naburige nesten vlogen,
doch zij durfden hem niet naderen.

--Uilenspiegel, zeide Nele, die vogelen vragen genade voor hunne
eieren.

Vervolgens begon zij te beven, en zij zeide:

--Ik ben bang, de zonne gaat onder, de hemel is wit, de sterren
ontwaken, dit is het uur van de geesten. Zie, die roode uitwasemingen
rakelings zweven langs den grond; Thijl, mijn beminde, wie is
het helsche monster, dat aldus in de wolken zijn vurigen muil open
doet? Zie, langs den kant van Philips-land, waar de koninklijke beul,
uit wreedaardige heerschzucht, tweemaal achtereen zooveel arme menschen
liet dooden, zie die dwaallichtjes dansen; 't is de nacht in denwelken
de zielen der arme mannen, die gedood werden in de gevechten, het
koude voorgeborchte des vagevuurs verlaten, om zich te komen warmen
in de zoele lucht van de aarde: dit is het uur, waarop gij alles
moogt vragen aan Christus, welke de God van de goede tooveraars is.

--De assche klopt op mijn hert, zeide Uilenspiegel. Kon Christus maar
die Zeven toonen, wier in den wind gesmeten assche ons Vlaanderen en
heel de wereld gelukkig zou maken.

--Ongeloovige, zeide Nele, gij zult ze zien met de zalve.

--Misschien, als een geest wil nederdalen uit de koude sterre, zei
Uilenspiegel, met den vinger naar Sirius wijzend.

Bij dat gebaar hechtte een dwaallichtje, dat rondom hem fladderde,
zich vast aan zijn vinger, en hoe meer hij het los wilde maken,
hoe vaster het er aan bleef gehecht.

Doch terwijl Nele beproefde Uilenspiegel los te maken, kreeg zij ook
haar dwaallichtje aan de toppen heurer vingeren.

Uilenspiegel sloeg op het zijne en sprak:

--Antwoord! zijt gij de ziel van eenen Geus of van eenen Spanjool? Zijt
gij de ziel van eenen Geus, ga dan naar het hemelrijk; zijt gij die
van eenen Spanjool, keer terug naar de helle, die u braakte.

Nele zeide hem:

--Beleedig nooit de zielen, al waren het zielen van beulen.

En, terwijl zij heur dwaallichtje op den top van heuren vinger deed
dansen, zeide zij:

--Lichtje, liefelijk lichtje, welke miede brengt gij uit het land van
de zielen? Wat doen zij? Eten en drinken zij, hoewel zij geen mond
hebben? Want gij ook hebt er geen, bevallig lichtje! ofwel, nemen
zij slechts in het gezegende hemelrijk de menschelijke gedaante aan?

--Hoe kunt gij, sprak Uilenspiegel, aldus uwen tijd verliezen met
te spreken tot dat droef vlammetje, dat geene ooren heeft om u te
aanhooren, en geenen mond om u te woord te staan?

Maar zonder naar hem te luisteren;

--Lichtje, zeide Nele, antwoord al dansend, want ik ga u driemaal
ondervragen: eenmaal in den naam Gods, eenmaal in den naam der Heilige
Maagd, en eenmaal in den naam der sylphen, die de boden zijn tusschen
God en de menschen.

Zij deed het, en het lichtje danste drie keeren.

--Trek uwe kleederen uit; ik zal hetzelfde doen: hier is de zilveren
doos met de tooverzalve, zei Nele tot Uilenspiegel.

--'t Is mij eender, antwoordde Uilenspiegel.

Toen zij zich ontkleed en met zalve bestreken hadden, legden zij zich
naast elkander op het gras.

De meeuwen kloegen; de donder rammelde dof in het zwerk, waarin een
helle flits flikkerde; de wassende maan toonde tusschen twee vluchtige
wolken nauwelijks hare twee gulden horens; Nele's en Uilenspiegel's
dwaallichtjes gingen met de anderen dansen in den beemd.

Plotseling werden Nele en heur vriend gegrepen met de groote hand
van eenen reus, dewelke ze in de lucht smeet als sneeuwballen, ze
weder opving, ze tusschen zijne handen ineenrolde en kneedde met
zijne vingeren, ze smeet in de waddenplassen tusschen de duinen, en
ze er weder uittrok, vol zeewier. En terwijl de reus ze vervolgens
ronddroeg in het luchtruim, zong hij met eene stem, die al de meeuwen
der eilanden van schrik deed ontwaken:


    Lezen willen luizedwergen
    Met ziekelijk troebel oog,
    Wat wij zoo weigerlijk bergen:
    De teekenen heilig en hoog.

    Lelie, luis, het eerwaarde,
    Lelie, vloo, de geheimenis,
    Die in hemel, lucht en aarde
    Met zeven nagels vernageld is.


En inderdaad, Uilenspiegel en Nele zagen op het gras, in de lucht en
in den hemel, zeven lichtende koperen tafelen, bevestigd door middel
van zeven vlammende nagelen. Op de tafelen stond geschreven:


    Onder den mesthoop kiemt de plant.
    Is zeven slecht, zeven is goed.
    Kolen vormen diamant,
    Dwaze doctoren, leerlingen vroed.
    Is zeven slecht, zeven is goed.


En de reus stapte voort, gevolgd door al die dwaallichtjes, die,
gonzend als krekelen, zeiden:


    Kijkt toe wie de macht hier torst,
    Der pausen paus, der vorsten vorst;
    Wie Caesar aan den leiband houdt,
    Kijkt toe, hij is van hout!


Eensklaps veranderden zijne trekken, hij scheen magerder, treuriger,
grooter. In eene hand hield hij eenen schepter en in de andere een
zweerd. Hij hiet Hooveerdigheid.

En Nele en Uilenspiegel ten gronde smijtend, zeide hij:

--Ik ben God!

En daar kwam naast hem, op eenen ezel gezeten, een dikk