<?php 

if( !defined( 'ABSPATH' ) ) exit();


if( !class_exists( 'OVACOLL_admin_settings' ) ){

	/**
	 * Make Admin Class
	 */
	class OVACOLL_admin_settings{

		/**
		 * Construct Admin
		 */
		public function __construct(){
			add_action( 'admin_enqueue_scripts', array( $this, 'ovacoll_load_media' ) );
			add_action( 'admin_init', array( $this, 'register_options' ) );
		}


		public function ovacoll_load_media() {
			wp_enqueue_media();
		}

		public function print_options_section(){
			return true;
		}


		public function register_options(){

			register_setting(
				'ovacoll_options_group', // Option group
				'ovacoll_options', // Name Option
				array( $this, 'settings_callback' ) // Call Back
			);


			/**
			 * General Settings
			 */
			// Add Section: General Settings
			add_settings_section(
				'ovacoll_general_section_id', // ID
				esc_html__('General Setting', 'ova-collection'), // Title
				array( $this, 'print_options_section' ),
				'ovacoll_general_settings' // Page
			);

			// Add Fields: General Section
			add_settings_field(
				'collection_post_type_rewrite_slug', // ID
				esc_html__('Rewrite Collection Slug','ova-collection'),
				array( $this, 'collection_post_type_rewrite_slug' ),
				'ovacoll_general_settings', // Page
				'ovacoll_general_section_id' // Section ID
			);

			add_settings_field(
				'collection_post_type_rewrite_artist_slug', // ID
				esc_html__('Rewrite Artist Slug','ova-collection'),
				array( $this, 'collection_post_type_rewrite_artist_slug' ),
				'ovacoll_general_settings', // Page
				'ovacoll_general_section_id' // Section ID
			);


			/**
			 * Collection Settings
			 */
			// Add Section: Collection Settings
			add_settings_section(
				'ovacoll_archive_collection_section_id', // ID
				esc_html__('Archive Collection Setting', 'ova-collection'), // Title
				array( $this, 'print_options_section' ),
				'ovacoll_collection_settings' // Page
			);

			// Add Fields: Collection Section
			add_settings_field(
				'archive_collection_posts_per_page', // ID
				esc_html__('Posts per page','ova-collection'),
				array( $this, 'archive_collection_posts_per_page' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_archive_collection_section_id' // Section ID
			);

			add_settings_field(
				'archive_collection_orderby', // ID
				esc_html__('Order By','ova-collection'),
				array( $this, 'archive_collection_orderby' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_archive_collection_section_id' // Section ID
			);

			add_settings_field(
				'archive_collection_order', // ID
				esc_html__('Order','ova-collection'),
				array( $this, 'archive_collection_order' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_archive_collection_section_id' // Section ID
			);

			add_settings_field(
				'archive_collection_heading', // ID
				esc_html__('Heading','ova-collection'),
				array( $this, 'archive_collection_heading' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_archive_collection_section_id' // Section ID
			);

			add_settings_field(
				'archive_collection_desc', // ID
				esc_html__('Description','ova-collection'),
				array( $this, 'archive_collection_desc' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_archive_collection_section_id' // Section ID
			);

			add_settings_field(
				'archive_collection_type', // ID
				esc_html__('Collection Type','ova-collection'),
				array( $this, 'archive_collection_type' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_archive_collection_section_id' // Section ID
			);

			add_settings_field(
				'archive_collection_header', // ID
				esc_html__('Header','ova-collection'),
				array( $this, 'archive_collection_header' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_archive_collection_section_id' // Section ID
			);

			add_settings_field(
				'archive_collection_footer', // ID
				esc_html__('Footer','ova-collection'),
				array( $this, 'archive_collection_footer' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_archive_collection_section_id' // Section ID
			);

			add_settings_field(
				'archive_collection_show_search_artist', // ID
				esc_html__('Show Search by Artist','ova-collection'),
				array( $this, 'archive_collection_show_search_artist' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_archive_collection_section_id' // Section ID
			);

			add_settings_field(
				'archive_collection_show_search_location', // ID
				esc_html__('Show Search by Location','ova-collection'),
				array( $this, 'archive_collection_show_search_location' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_archive_collection_section_id' // Section ID
			);

			add_settings_field(
				'archive_collection_show_search_type', // ID
				esc_html__('Show Search by Type','ova-collection'),
				array( $this, 'archive_collection_show_search_type' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_archive_collection_section_id' // Section ID
			);

			add_settings_field(
				'archive_collection_show_year', // ID
				esc_html__('Show Year','ova-collection'),
				array( $this, 'archive_collection_show_year' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_archive_collection_section_id' // Section ID
			);

			add_settings_field(
				'archive_collection_show_type', // ID
				esc_html__('Show Type','ova-collection'),
				array( $this, 'archive_collection_show_type' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_archive_collection_section_id' // Section ID
			);

			add_settings_field(
				'archive_collection_show_artist', // ID
				esc_html__('Show Artist','ova-collection'),
				array( $this, 'archive_collection_show_artist' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_archive_collection_section_id' // Section ID
			);

			// Add Section: Single Collection Settings
			add_settings_section(
				'ovacoll_single_collection_section_id', // ID
				esc_html__('Single Collection Setting', 'ova-collection'), // Title
				array( $this, 'print_options_section' ),
				'ovacoll_collection_settings' // Page
			);

			add_settings_field(
				'single_collection_header', // ID
				esc_html__('Header','ova-collection'),
				array( $this, 'single_collection_header' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_single_collection_section_id' // Section ID
			);

			add_settings_field(
				'single_collection_footer', // ID
				esc_html__('Footer','ova-collection'),
				array( $this, 'single_collection_footer' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_single_collection_section_id' // Section ID
			);

			add_settings_field(
				'single_collection_show_share', // ID
				esc_html__('Show Share Button','ova-collection'),
				array( $this, 'single_collection_show_share' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_single_collection_section_id' // Section ID
			);

			add_settings_field(
				'single_collection_show_download', // ID
				esc_html__('Show Download Button','ova-collection'),
				array( $this, 'single_collection_show_download' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_single_collection_section_id' // Section ID
			);

			add_settings_field(
				'single_collection_show_popup', // ID
				esc_html__('Show Popup Button','ova-collection'),
				array( $this, 'single_collection_show_popup' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_single_collection_section_id' // Section ID
			);

			add_settings_field(
				'single_collection_show_artist', // ID
				esc_html__('Show Artist below Title','ova-collection'),
				array( $this, 'single_collection_show_artist' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_single_collection_section_id' // Section ID
			);

			add_settings_field(
				'single_collection_show_year', // ID
				esc_html__('Show Year below Title','ova-collection'),
				array( $this, 'single_collection_show_year' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_single_collection_section_id' // Section ID
			);

			add_settings_field(
				'single_collection_show_location', // ID
				esc_html__('Show Location below Title','ova-collection'),
				array( $this, 'single_collection_show_location' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_single_collection_section_id' // Section ID
			);

			add_settings_field(
				'single_collection_show_description', // ID
				esc_html__('Show Description','ova-collection'),
				array( $this, 'single_collection_show_description' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_single_collection_section_id' // Section ID
			);

			add_settings_field(
				'single_collection_show_artist_mid', // ID
				esc_html__('Show Artist','ova-collection'),
				array( $this, 'single_collection_show_artist_mid' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_single_collection_section_id' // Section ID
			);

			add_settings_field(
				'single_collection_show_year_text', // ID
				esc_html__('Show Year Text','ova-collection'),
				array( $this, 'single_collection_show_year_text' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_single_collection_section_id' // Section ID
			);

			add_settings_field(
				'single_collection_show_address', // ID
				esc_html__('Show Address','ova-collection'),
				array( $this, 'single_collection_show_address' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_single_collection_section_id' // Section ID
			);

			add_settings_field(
				'single_collection_show_type', // ID
				esc_html__('Show Type','ova-collection'),
				array( $this, 'single_collection_show_type' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_single_collection_section_id' // Section ID
			);

			add_settings_field(
				'single_collection_show_material', // ID
				esc_html__('Show Material','ova-collection'),
				array( $this, 'single_collection_show_material' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_single_collection_section_id' // Section ID
			);

			add_settings_field(
				'single_collection_show_accession_number', // ID
				esc_html__('Show Accession Number','ova-collection'),
				array( $this, 'single_collection_show_accession_number' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_single_collection_section_id' // Section ID
			);

			add_settings_field(
				'single_collection_show_dimensions', // ID
				esc_html__('Show Dimensions','ova-collection'),
				array( $this, 'single_collection_show_dimensions' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_single_collection_section_id' // Section ID
			);

			add_settings_field(
				'single_collection_show_credit', // ID
				esc_html__('Show Credit','ova-collection'),
				array( $this, 'single_collection_show_credit' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_single_collection_section_id' // Section ID
			);

			add_settings_field(
				'single_collection_visual_desc', // ID
				esc_html__('Show Visual Description','ova-collection'),
				array( $this, 'single_collection_visual_desc' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_single_collection_section_id' // Section ID
			);

			add_settings_field(
				'single_collection_timeline_history', // ID
				esc_html__('Show Timeline History','ova-collection'),
				array( $this, 'single_collection_timeline_history' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_single_collection_section_id' // Section ID
			);

			add_settings_field(
				'single_collection_publications', // ID
				esc_html__('Show Publications','ova-collection'),
				array( $this, 'single_collection_publications' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_single_collection_section_id' // Section ID
			);

			add_settings_field(
				'single_collection_show_comment', // ID
				esc_html__('Show Comment','ova-collection'),
				array( $this, 'single_collection_show_comment' ),
				'ovacoll_collection_settings', // Page
				'ovacoll_single_collection_section_id' // Section ID
			);

			/**
			 * Artist Settings
			 */
			/** Add Section: Archive Artist Settings **/
			add_settings_section(
				'ovacoll_archive_artist_section_id', // ID
				esc_html__('Archive Artists Setting', 'ova-collection'), // Title
				array( $this, 'print_options_section' ),
				'archive_artist_settings' // Page
			);

			add_settings_field(
				'archive_artist_posts_per_page', // ID
				esc_html__('Posts per page','ova-collection'),
				array( $this, 'archive_artist_posts_per_page' ),
				'archive_artist_settings', // Page
				'ovacoll_archive_artist_section_id' // Section ID
			);

			add_settings_field(
				'archive_artist_orderby', // ID
				esc_html__('Order By','ova-collection'),
				array( $this, 'archive_artist_orderby' ),
				'archive_artist_settings', // Page
				'ovacoll_archive_artist_section_id' // Section ID
			);

			add_settings_field(
				'archive_artist_order', // ID
				esc_html__('Order','ova-collection'),
				array( $this, 'archive_artist_order' ),
				'archive_artist_settings', // Page
				'ovacoll_archive_artist_section_id' // Section ID
			);

			add_settings_field(
				'archive_artist_heading', // ID
				esc_html__('Heading','ova-collection'),
				array( $this, 'archive_artist_heading' ),
				'archive_artist_settings', // Page
				'ovacoll_archive_artist_section_id' // Section ID
			);

			add_settings_field(
				'archive_artist_desc', // ID
				esc_html__('Description','ova-collection'),
				array( $this, 'archive_artist_desc' ),
				'archive_artist_settings', // Page
				'ovacoll_archive_artist_section_id' // Section ID
			);

			add_settings_field(
				'archive_artist_header', // ID
				esc_html__('Header','ova-collection'),
				array( $this, 'archive_artist_header' ),
				'archive_artist_settings', // Page
				'ovacoll_archive_artist_section_id' // Section ID
			);

			add_settings_field(
				'archive_artist_footer', // ID
				esc_html__('Footer','ova-collection'),
				array( $this, 'archive_artist_footer' ),
				'archive_artist_settings', // Page
				'ovacoll_archive_artist_section_id' // Section ID
			);

			add_settings_field(
				'archive_artist_show_image', // ID
				esc_html__('Show Image','ova-collection'),
				array( $this, 'archive_artist_show_image' ),
				'archive_artist_settings', // Page
				'ovacoll_archive_artist_section_id' // Section ID
			);

			add_settings_field(
				'archive_artist_show_title', // ID
				esc_html__('Show Title','ova-collection'),
				array( $this, 'archive_artist_show_title' ),
				'archive_artist_settings', // Page
				'ovacoll_archive_artist_section_id' // Section ID
			);

			add_settings_field(
				'archive_artist_show_skill', // ID
				esc_html__('Show Skill','ova-collection'),
				array( $this, 'archive_artist_show_skill' ),
				'archive_artist_settings', // Page
				'ovacoll_archive_artist_section_id' // Section ID
			);

			add_settings_field(
				'archive_artist_show_phone', // ID
				esc_html__('Show Phone','ova-collection'),
				array( $this, 'archive_artist_show_phone' ),
				'archive_artist_settings', // Page
				'ovacoll_archive_artist_section_id' // Section ID
			);

			add_settings_field(
				'archive_artist_show_email', // ID
				esc_html__('Show Email','ova-collection'),
				array( $this, 'archive_artist_show_email' ),
				'archive_artist_settings', // Page
				'ovacoll_archive_artist_section_id' // Section ID
			);


			/** Add Section: Single Artist Settings **/
			add_settings_section(
				'ovacoll_single_artist_section_id', // ID
				esc_html__('Single Artists Setting', 'ova-collection'), // Title
				array( $this, 'print_options_section' ),
				'single_artist_settings' // Page
			);
			
			add_settings_field(
				'single_artist_related_heading', // ID
				esc_html__('Text Related','ova-collection'),
				array( $this, 'single_artist_related_heading' ),
				'single_artist_settings', // Page
				'ovacoll_single_artist_section_id' // Section ID
			);

			add_settings_field(
				'single_artist_header', // ID
				esc_html__('Header','ova-collection'),
				array( $this, 'single_artist_header' ),
				'single_artist_settings', // Page
				'ovacoll_single_artist_section_id' // Section ID
			);

			add_settings_field(
				'single_artist_footer', // ID
				esc_html__('Footer','ova-collection'),
				array( $this, 'single_artist_footer' ),
				'single_artist_settings', // Page
				'ovacoll_single_artist_section_id' // Section ID
			);

			add_settings_field(
				'single_artist_show_image', // ID
				esc_html__('Show Image','ova-collection'),
				array( $this, 'single_artist_show_image' ),
				'single_artist_settings', // Page
				'ovacoll_single_artist_section_id' // Section ID
			);

			add_settings_field(
				'single_artist_show_title', // ID
				esc_html__('Show Title','ova-collection'),
				array( $this, 'single_artist_show_title' ),
				'single_artist_settings', // Page
				'ovacoll_single_artist_section_id' // Section ID
			);

			add_settings_field(
				'single_artist_show_skill', // ID
				esc_html__('Show Skill','ova-collection'),
				array( $this, 'single_artist_show_skill' ),
				'single_artist_settings', // Page
				'ovacoll_single_artist_section_id' // Section ID
			);

			add_settings_field(
				'single_artist_show_phone', // ID
				esc_html__('Show Phone','ova-collection'),
				array( $this, 'single_artist_show_phone' ),
				'single_artist_settings', // Page
				'ovacoll_single_artist_section_id' // Section ID
			);

			add_settings_field(
				'single_artist_show_email', // ID
				esc_html__('Show Email','ova-collection'),
				array( $this, 'single_artist_show_email' ),
				'single_artist_settings', // Page
				'ovacoll_single_artist_section_id' // Section ID
			);

			add_settings_field(
				'single_artist_show_content', // ID
				esc_html__('Show Content','ova-collection'),
				array( $this, 'single_artist_show_content' ),
				'single_artist_settings', // Page
				'ovacoll_single_artist_section_id' // Section ID
			);

			add_settings_field(
				'single_artist_show_some_of_works', // ID
				esc_html__('Show Some of Works','ova-collection'),
				array( $this, 'single_artist_show_some_of_works' ),
				'single_artist_settings', // Page
				'ovacoll_single_artist_section_id' // Section ID
			);

		}


		public function settings_callback( $input ){

			$new_input = array();

			if( isset( $input['collection_post_type_rewrite_slug'] ) )
				$new_input['collection_post_type_rewrite_slug'] = sanitize_text_field( $input['collection_post_type_rewrite_slug'] ) ? sanitize_text_field( $input['collection_post_type_rewrite_slug'] ) : 'collection';

			if( isset( $input['collection_post_type_rewrite_artist_slug'] ) )
				$new_input['collection_post_type_rewrite_artist_slug'] = sanitize_text_field( $input['collection_post_type_rewrite_artist_slug'] ) ? sanitize_text_field( $input['collection_post_type_rewrite_artist_slug'] ) : 'artist';

			if( isset( $input['archive_collection_posts_per_page'] ) )
				$new_input['archive_collection_posts_per_page'] = (int)$input['archive_collection_posts_per_page'] ? (int)$input['archive_collection_posts_per_page'] : -1;

			if( isset( $input['archive_collection_orderby'] ) )
				$new_input['archive_collection_orderby'] = sanitize_text_field( $input['archive_collection_orderby'] ) ? sanitize_text_field( $input['archive_collection_orderby'] ) : 'date';

			if( isset( $input['archive_collection_order'] ) )
				$new_input['archive_collection_order'] = sanitize_text_field( $input['archive_collection_order'] ) ? sanitize_text_field( $input['archive_collection_order'] ) : 'ASC';

			if( isset( $input['archive_collection_heading'] ) )
				$new_input['archive_collection_heading'] = sanitize_text_field( $input['archive_collection_heading'] ) ? sanitize_text_field( $input['archive_collection_heading'] ) : '';

			if( isset( $input['archive_collection_desc'] ) )
				$new_input['archive_collection_desc'] = sanitize_text_field( $input['archive_collection_desc'] ) ? sanitize_text_field( $input['archive_collection_desc'] ) : '';

			if( isset( $input['archive_collection_type'] ) )
				$new_input['archive_collection_type'] = sanitize_text_field( $input['archive_collection_type'] ) ? sanitize_text_field( $input['archive_collection_type'] ) : 'type1';

			if( isset( $input['archive_collection_header'] ) )
				$new_input['archive_collection_header'] = sanitize_text_field( $input['archive_collection_header'] ) ? sanitize_text_field( $input['archive_collection_header'] ) : 'default';

			if( isset( $input['archive_collection_footer'] ) )
				$new_input['archive_collection_footer'] = sanitize_text_field( $input['archive_collection_footer'] ) ? sanitize_text_field( $input['archive_collection_footer'] ) : 'default';

			if( isset( $input['archive_collection_show_search_artist'] ) )
				$new_input['archive_collection_show_search_artist'] = sanitize_text_field( $input['archive_collection_show_search_artist'] ) ? sanitize_text_field( $input['archive_collection_show_search_artist'] ) : 'yes';

			if( isset( $input['archive_collection_show_search_location'] ) )
				$new_input['archive_collection_show_search_location'] = sanitize_text_field( $input['archive_collection_show_search_location'] ) ? sanitize_text_field( $input['archive_collection_show_search_location'] ) : 'yes';

			if( isset( $input['archive_collection_show_search_type'] ) )
				$new_input['archive_collection_show_search_type'] = sanitize_text_field( $input['archive_collection_show_search_type'] ) ? sanitize_text_field( $input['archive_collection_show_search_type'] ) : 'yes';

			if( isset( $input['archive_collection_show_year'] ) )
				$new_input['archive_collection_show_year'] = sanitize_text_field( $input['archive_collection_show_year'] ) ? sanitize_text_field( $input['archive_collection_show_year'] ) : 'yes';

			if( isset( $input['archive_collection_show_type'] ) )
				$new_input['archive_collection_show_type'] = sanitize_text_field( $input['archive_collection_show_type'] ) ? sanitize_text_field( $input['archive_collection_show_type'] ) : 'yes';

			if( isset( $input['archive_collection_show_artist'] ) )
				$new_input['archive_collection_show_artist'] = sanitize_text_field( $input['archive_collection_show_artist'] ) ? sanitize_text_field( $input['archive_collection_show_artist'] ) : 'yes';


			// single
			if( isset( $input['single_collection_header'] ) )
				$new_input['single_collection_header'] = sanitize_text_field( $input['single_collection_header'] ) ? sanitize_text_field( $input['single_collection_header'] ) : 'default';

			if( isset( $input['single_collection_footer'] ) )
				$new_input['single_collection_footer'] = sanitize_text_field( $input['single_collection_footer'] ) ? sanitize_text_field( $input['single_collection_footer'] ) : 'default';

			if( isset( $input['single_collection_show_share'] ) )
				$new_input['single_collection_show_share'] = sanitize_text_field( $input['single_collection_show_share'] ) ? sanitize_text_field( $input['single_collection_show_share'] ) : 'yes';

			if( isset( $input['single_collection_show_download'] ) )
				$new_input['single_collection_show_download'] = sanitize_text_field( $input['single_collection_show_download'] ) ? sanitize_text_field( $input['single_collection_show_download'] ) : 'yes';

			if( isset( $input['single_collection_show_popup'] ) )
				$new_input['single_collection_show_popup'] = sanitize_text_field( $input['single_collection_show_popup'] ) ? sanitize_text_field( $input['single_collection_show_popup'] ) : 'yes';


			if( isset( $input['single_collection_show_artist'] ) )
				$new_input['single_collection_show_artist'] = sanitize_text_field( $input['single_collection_show_artist'] ) ? sanitize_text_field( $input['single_collection_show_artist'] ) : 'yes';

			if( isset( $input['single_collection_show_year'] ) )
				$new_input['single_collection_show_year'] = sanitize_text_field( $input['single_collection_show_year'] ) ? sanitize_text_field( $input['single_collection_show_year'] ) : 'yes';

			if( isset( $input['single_collection_show_location'] ) )
				$new_input['single_collection_show_location'] = sanitize_text_field( $input['single_collection_show_location'] ) ? sanitize_text_field( $input['single_collection_show_location'] ) : 'yes';

			if( isset( $input['single_collection_show_description'] ) )
				$new_input['single_collection_show_description'] = sanitize_text_field( $input['single_collection_show_description'] ) ? sanitize_text_field( $input['single_collection_show_description'] ) : 'yes';

			if( isset( $input['single_collection_show_artist_mid'] ) )
				$new_input['single_collection_show_artist_mid'] = sanitize_text_field( $input['single_collection_show_artist_mid'] ) ? sanitize_text_field( $input['single_collection_show_artist_mid'] ) : 'yes';

			if( isset( $input['single_collection_show_year_text'] ) )
				$new_input['single_collection_show_year_text'] = sanitize_text_field( $input['single_collection_show_year_text'] ) ? sanitize_text_field( $input['single_collection_show_year_text'] ) : 'yes';

			if( isset( $input['single_collection_show_address'] ) )
				$new_input['single_collection_show_address'] = sanitize_text_field( $input['single_collection_show_address'] ) ? sanitize_text_field( $input['single_collection_show_address'] ) : 'yes';

			if( isset( $input['single_collection_show_type'] ) )
				$new_input['single_collection_show_type'] = sanitize_text_field( $input['single_collection_show_type'] ) ? sanitize_text_field( $input['single_collection_show_type'] ) : 'yes';

			if( isset( $input['single_collection_show_material'] ) )
				$new_input['single_collection_show_material'] = sanitize_text_field( $input['single_collection_show_material'] ) ? sanitize_text_field( $input['single_collection_show_material'] ) : 'yes';

			if( isset( $input['single_collection_show_accession_number'] ) )
				$new_input['single_collection_show_accession_number'] = sanitize_text_field( $input['single_collection_show_accession_number'] ) ? sanitize_text_field( $input['single_collection_show_accession_number'] ) : 'yes';


			if( isset( $input['single_collection_show_dimensions'] ) )
				$new_input['single_collection_show_dimensions'] = sanitize_text_field( $input['single_collection_show_dimensions'] ) ? sanitize_text_field( $input['single_collection_show_dimensions'] ) : 'yes';

			if( isset( $input['single_collection_show_credit'] ) )
				$new_input['single_collection_show_credit'] = sanitize_text_field( $input['single_collection_show_credit'] ) ? sanitize_text_field( $input['single_collection_show_credit'] ) : 'yes';

			if( isset( $input['single_collection_visual_desc'] ) )
				$new_input['single_collection_visual_desc'] = sanitize_text_field( $input['single_collection_visual_desc'] ) ? sanitize_text_field( $input['single_collection_visual_desc'] ) : 'yes';

			if( isset( $input['single_collection_timeline_history'] ) )
				$new_input['single_collection_timeline_history'] = sanitize_text_field( $input['single_collection_timeline_history'] ) ? sanitize_text_field( $input['single_collection_timeline_history'] ) : 'yes';

			if( isset( $input['single_collection_publications'] ) )
				$new_input['single_collection_publications'] = sanitize_text_field( $input['single_collection_publications'] ) ? sanitize_text_field( $input['single_collection_publications'] ) : 'yes';

			if( isset( $input['single_collection_show_comment'] ) )
				$new_input['single_collection_show_comment'] = sanitize_text_field( $input['single_collection_show_comment'] ) ? sanitize_text_field( $input['single_collection_show_comment'] ) : 'yes';


			/* Artist */
			if( isset( $input['archive_artist_posts_per_page'] ) )
				$new_input['archive_artist_posts_per_page'] = (int)$input['archive_artist_posts_per_page'] ? (int)$input['archive_artist_posts_per_page'] : -1;

			if( isset( $input['archive_artist_orderby'] ) )
				$new_input['archive_artist_orderby'] = sanitize_text_field( $input['archive_artist_orderby'] ) ? sanitize_text_field( $input['archive_artist_orderby'] ) : 'date';

			if( isset( $input['archive_artist_order'] ) )
				$new_input['archive_artist_order'] = sanitize_text_field( $input['archive_artist_order'] ) ? sanitize_text_field( $input['archive_artist_order'] ) : 'ASC';

			if( isset( $input['archive_artist_heading'] ) )
				$new_input['archive_artist_heading'] = sanitize_text_field( $input['archive_artist_heading'] ) ? sanitize_text_field( $input['archive_artist_heading'] ) : '';

			if( isset( $input['archive_artist_desc'] ) )
				$new_input['archive_artist_desc'] = sanitize_text_field( $input['archive_artist_desc'] ) ? sanitize_text_field( $input['archive_artist_desc'] ) : '';

			if( isset( $input['archive_artist_header'] ) )
				$new_input['archive_artist_header'] = sanitize_text_field( $input['archive_artist_header'] ) ? sanitize_text_field( $input['archive_artist_header'] ) : 'default';

			if( isset( $input['archive_artist_footer'] ) )
				$new_input['archive_artist_footer'] = sanitize_text_field( $input['archive_artist_footer'] ) ? sanitize_text_field( $input['archive_artist_footer'] ) : 'default';

			if( isset( $input['archive_artist_show_image'] ) )
				$new_input['archive_artist_show_image'] = sanitize_text_field( $input['archive_artist_show_image'] ) ? sanitize_text_field( $input['archive_artist_show_image'] ) : 'yes';

			if( isset( $input['archive_artist_show_title'] ) )
				$new_input['archive_artist_show_title'] = sanitize_text_field( $input['archive_artist_show_title'] ) ? sanitize_text_field( $input['archive_artist_show_title'] ) : 'yes';

			if( isset( $input['archive_artist_show_skill'] ) )
				$new_input['archive_artist_show_skill'] = sanitize_text_field( $input['archive_artist_show_skill'] ) ? sanitize_text_field( $input['archive_artist_show_skill'] ) : 'yes';

			if( isset( $input['archive_artist_show_phone'] ) )
				$new_input['archive_artist_show_phone'] = sanitize_text_field( $input['archive_artist_show_phone'] ) ? sanitize_text_field( $input['archive_artist_show_phone'] ) : 'yes';

			if( isset( $input['archive_artist_show_email'] ) )
				$new_input['archive_artist_show_email'] = sanitize_text_field( $input['archive_artist_show_email'] ) ? sanitize_text_field( $input['archive_artist_show_email'] ) : 'yes';


			// single
			if( isset( $input['single_artist_related_heading'] ) )
			$new_input['single_artist_related_heading'] = sanitize_text_field( $input['single_artist_related_heading'] ) ? sanitize_text_field( $input['single_artist_related_heading'] ) : '';

			if( isset( $input['single_artist_header'] ) )
				$new_input['single_artist_header'] = sanitize_text_field( $input['single_artist_header'] ) ? sanitize_text_field( $input['single_artist_header'] ) : 'default';

			if( isset( $input['single_artist_footer'] ) )
				$new_input['single_artist_footer'] = sanitize_text_field( $input['single_artist_footer'] ) ? sanitize_text_field( $input['single_artist_footer'] ) : 'default';

			if( isset( $input['single_artist_show_image'] ) )
				$new_input['single_artist_show_image'] = sanitize_text_field( $input['single_artist_show_image'] ) ? sanitize_text_field( $input['single_artist_show_image'] ) : 'yes';

			if( isset( $input['single_artist_show_title'] ) )
				$new_input['single_artist_show_title'] = sanitize_text_field( $input['single_artist_show_title'] ) ? sanitize_text_field( $input['single_artist_show_title'] ) : 'yes';

			if( isset( $input['single_artist_show_skill'] ) )
				$new_input['single_artist_show_skill'] = sanitize_text_field( $input['single_artist_show_skill'] ) ? sanitize_text_field( $input['single_artist_show_skill'] ) : 'yes';

			if( isset( $input['single_artist_show_phone'] ) )
				$new_input['single_artist_show_phone'] = sanitize_text_field( $input['single_artist_show_phone'] ) ? sanitize_text_field( $input['single_artist_show_phone'] ) : 'yes';

			if( isset( $input['single_artist_show_email'] ) )
				$new_input['single_artist_show_email'] = sanitize_text_field( $input['single_artist_show_email'] ) ? sanitize_text_field( $input['single_artist_show_email'] ) : 'yes';

			if( isset( $input['single_artist_show_content'] ) )
				$new_input['single_artist_show_content'] = sanitize_text_field( $input['single_artist_show_content'] ) ? sanitize_text_field( $input['single_artist_show_content'] ) : 'yes';

			if( isset( $input['single_artist_show_some_of_works'] ) )
				$new_input['single_artist_show_some_of_works'] = sanitize_text_field( $input['single_artist_show_some_of_works'] ) ? sanitize_text_field( $input['single_artist_show_some_of_works'] ) : 'yes';


			return $new_input;
		}


		public static function create_admin_setting_page() { ?>
			<div class="wrap ovacoll_admin_setting">
				<h1><?php esc_html_e( "Collection Settings", "ova-collection" ); ?></h1>

				<form method="post" action="options.php">
					<div id="tabs">
						<?php settings_fields( 'ovacoll_options_group' ); // Options group ?>

						<!-- Menu Tab -->
						<ul>
							<li><a href="#ovacoll_general_settings"><?php esc_html_e( 'General Settings', 'ova-collection' ); ?></a></li>
							<li><a href="#ovacoll_collection_settings"><?php esc_html_e( 'Collection Settings', 'ova-collection' ); ?></a></li>
							<li><a href="#artist_settings"><?php esc_html_e( 'Artist Settings', 'ova-collection' ); ?></a></li>
						</ul>

						<!-- General Tab Content -->  
						<div id="ovacoll_general_settings" class="ovacoll_general_settings">
							<?php do_settings_sections( 'ovacoll_general_settings' ); // Page ?>
						</div>

						<!-- Collection Settings -->  
						<div id="ovacoll_collection_settings" class="ovacoll_collection_settings">
							<?php do_settings_sections( 'ovacoll_collection_settings' ); // Page ?>
						</div>

						<!-- Collection Settings -->  
						<div id="artist_settings" class="ovacoll_artist_settings">
							<?php do_settings_sections( 'archive_artist_settings' ); // Page ?>
							<hr>
							<?php do_settings_sections( 'single_artist_settings' ); // Page ?>
						</div>

					</div>
					<?php submit_button(); ?>
				</form>
			</div>
		<?php }


		/**
		 * General Settings
		 */
		public function collection_post_type_rewrite_slug(){
			$collection_post_type_rewrite_slug =  OVACOLL_Settings::collection_post_type_rewrite_slug();

			printf(
				'<input type="text"  id="collection_post_type_rewrite_slug" name="ovacoll_options[collection_post_type_rewrite_slug]" value="%s" />',
				isset( $collection_post_type_rewrite_slug ) ? $collection_post_type_rewrite_slug : 'collection'
			);

			echo '<span >'.esc_html__(' Name should only contain lowercase letters and the underscore character, and not be more than 32 characters long and  without any spaces', 'ova-collection').'<span>';
		}

		public function collection_post_type_rewrite_artist_slug(){
			$collection_post_type_rewrite_artist_slug =  OVACOLL_Settings::collection_post_type_rewrite_artist_slug();

			printf(
				'<input type="text"  id="collection_post_type_rewrite_artist_slug" name="ovacoll_options[collection_post_type_rewrite_artist_slug]" value="%s" />',
				isset( $collection_post_type_rewrite_artist_slug ) ? $collection_post_type_rewrite_artist_slug : 'artist'
			);

			echo '<span >'.esc_html__(' Name should only contain lowercase letters and the underscore character, and not be more than 32 characters long and  without any spaces', 'ova-collection').'<span>';
		}


		/**
		 * Collection Settings
		 */
		public function archive_collection_posts_per_page() {
			$archive_collection_posts_per_page = OVACOLL_Settings::archive_collection_posts_per_page();
			$archive_collection_posts_per_page = isset( $archive_collection_posts_per_page ) ? $archive_collection_posts_per_page : '-1';

			printf(
				'<input type="text"  id="archive_collection_posts_per_page" name="ovacoll_options[archive_collection_posts_per_page]" value="%s" />',
				$archive_collection_posts_per_page
			);
		}

		public function archive_collection_orderby(){
			$archive_collection_orderby = OVACOLL_Settings::archive_collection_orderby();
			$archive_collection_orderby = isset( $archive_collection_orderby ) ? $archive_collection_orderby : 'date';

			$title                  = ( 'title' == $archive_collection_orderby) ? 'selected' : '';
			$collection_custom_sort = ( 'collection_custom_sort' == $archive_collection_orderby) ? 'selected' : '';
			$date                   = ( 'date' == $archive_collection_orderby) ? 'selected' : '';
			$id                     = ( 'ID' == $archive_collection_orderby) ? 'selected' : '';

			?>
			<select name="ovacoll_options[archive_collection_orderby]" id="archive_collection_orderby">
				<option <?php echo esc_attr($date) ?> value="date"><?php echo esc_html__('Date', 'ova-collection') ?></option>
				<option <?php echo esc_attr($title) ?> value="title"><?php echo esc_html__('Title', 'ova-collection') ?></option>
				<option <?php echo esc_attr($collection_custom_sort) ?> value="collection_custom_sort"><?php echo esc_html__('Custom Sort', 'ova-collection') ?></option>
				<option <?php echo esc_attr($id) ?> value="ID"><?php echo esc_html__('ID', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function archive_collection_order(){
			$archive_collection_order = OVACOLL_Settings::archive_collection_order(); 	
			$archive_collection_order = isset( $archive_collection_order ) ? $archive_collection_order : 'ASC';

			$asc_selected  = ('ASC' == $archive_collection_order) ? 'selected' : '';
			$desc_selected = ('DESC' == $archive_collection_order) ? 'selected' : '';

			?>
			<select name="ovacoll_options[archive_collection_order]" id="archive_collection_order">
				<option <?php echo esc_attr($asc_selected) ?> value="ASC"><?php echo esc_html__('Ascending', 'ova-collection') ?></option>
				<option <?php echo esc_attr($desc_selected) ?> value="DESC"><?php echo esc_html__('Descending', 'ova-collection') ?></option>
			</select>
			<?php
		}
		

		public function archive_collection_heading(){
			$archive_collection_heading =  OVACOLL_Settings::archive_collection_heading();

			isset( $archive_collection_heading ) ? $archive_collection_heading : '';
			printf(
				'<input type="text"  id="archive_collection_heading" name="ovacoll_options[archive_collection_heading]" value="%s" />',
				isset( $archive_collection_heading ) ? $archive_collection_heading : ''
			);
		}

		public function archive_collection_desc(){
			$archive_collection_desc =  OVACOLL_Settings::archive_collection_desc();

			isset( $archive_collection_desc ) ? $archive_collection_desc : '';
			printf(
				'<textarea id="archive_collection_desc" rows="4" cols="50" name="ovacoll_options[archive_collection_desc]" value="%s">'.$archive_collection_desc.'</textarea>',
				isset( $archive_collection_desc ) ? $archive_collection_desc : ''
			);
		}

		public function archive_collection_type(){
			$archive_collection_type = OVACOLL_Settings::archive_collection_type(); 	
			$archive_collection_type = isset( $archive_collection_type ) ? $archive_collection_type : 'type1';

			$type1 = ('type1' == $archive_collection_type) ? 'selected' : '';
			$type2 = ('type2' == $archive_collection_type) ? 'selected' : '';

			?>
			<select name="ovacoll_options[archive_collection_type]" id="archive_collection_type">
				<option <?php echo esc_attr($type1) ?> value="type1"><?php echo esc_html__('Type 1', 'ova-collection') ?></option>
				<option <?php echo esc_attr($type2) ?> value="type2"><?php echo esc_html__('Type 2', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function archive_collection_header(){
			$archive_collection_header = OVACOLL_Settings::archive_collection_header(); 	
			$archive_collection_header = isset( $archive_collection_header ) ? $archive_collection_header : 'default';

			$list_header = apply_filters('gimont_list_header', '');

			?>
			<select name="ovacoll_options[archive_collection_header]" id="archive_collection_header">
				<?php if( $list_header ){ ?>
					<?php foreach ($list_header as $key => $value) { ?>
						<option <?php if( $key == $archive_collection_header ) echo 'selected'; ?> value="<?php echo $key; ?>"><?php echo $value; ?></option>
					<?php } ?>
				<?php } ?>
				
			</select>
			<?php
		}

		public function archive_collection_footer(){
			$archive_collection_footer = OVACOLL_Settings::archive_collection_footer(); 	
			$archive_collection_footer = isset( $archive_collection_footer ) ? $archive_collection_footer : 'default';

			$list_footer = apply_filters('gimont_list_footer', '');

			?>
			<select name="ovacoll_options[archive_collection_footer]" id="archive_collection_footer">
				<?php if( $list_footer ){ ?>
					<?php foreach ($list_footer as $key => $value) { ?>
						<option <?php if( $key == $archive_collection_footer ) echo 'selected'; ?> value="<?php echo $key; ?>"><?php echo $value; ?></option>
					<?php } ?>
				<?php } ?>
				
			</select>
			<?php
		}

		public function archive_collection_show_search_artist(){
			$archive_collection_show_search_artist = OVACOLL_Settings::archive_collection_show_search_artist(); 	
			$archive_collection_show_search_artist = isset( $archive_collection_show_search_artist ) ? $archive_collection_show_search_artist : 'yes';

			$yes_selected  = ('yes' == $archive_collection_show_search_artist) ? 'selected' : '';
			$no_selected   = ('no' == $archive_collection_show_search_artist) ? 'selected' : '';
			?>
			<select name="ovacoll_options[archive_collection_show_search_artist]" id="archive_collection_show_search_artist">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function archive_collection_show_search_location(){
			$archive_collection_show_search_location = OVACOLL_Settings::archive_collection_show_search_location(); 	
			$archive_collection_show_search_location = isset( $archive_collection_show_search_location ) ? $archive_collection_show_search_location : 'yes';

			$yes_selected  = ('yes' == $archive_collection_show_search_location) ? 'selected' : '';
			$no_selected   = ('no' == $archive_collection_show_search_location) ? 'selected' : '';
			?>
			<select name="ovacoll_options[archive_collection_show_search_location]" id="archive_collection_show_search_location">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function archive_collection_show_search_type(){
			$archive_collection_show_search_type = OVACOLL_Settings::archive_collection_show_search_type(); 	
			$archive_collection_show_search_type = isset( $archive_collection_show_search_type ) ? $archive_collection_show_search_type : 'yes';

			$yes_selected  = ('yes' == $archive_collection_show_search_type) ? 'selected' : '';
			$no_selected   = ('no' == $archive_collection_show_search_type) ? 'selected' : '';
			?>
			<select name="ovacoll_options[archive_collection_show_search_type]" id="archive_collection_show_search_type">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function archive_collection_show_year(){
			$archive_collection_show_year = OVACOLL_Settings::archive_collection_show_year(); 	
			$archive_collection_show_year = isset( $archive_collection_show_year ) ? $archive_collection_show_year : 'yes';

			$yes_selected  = ('yes' == $archive_collection_show_year) ? 'selected' : '';
			$no_selected   = ('no' == $archive_collection_show_year) ? 'selected' : '';
			?>
			<select name="ovacoll_options[archive_collection_show_year]" id="archive_collection_show_year">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function archive_collection_show_type(){
			$archive_collection_show_type = OVACOLL_Settings::archive_collection_show_type(); 	
			$archive_collection_show_type = isset( $archive_collection_show_type ) ? $archive_collection_show_type : 'yes';

			$yes_selected  = ('yes' == $archive_collection_show_type) ? 'selected' : '';
			$no_selected   = ('no' == $archive_collection_show_type) ? 'selected' : '';
			?>
			<select name="ovacoll_options[archive_collection_show_type]" id="archive_collection_show_type">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function archive_collection_show_artist(){
			$archive_collection_show_artist = OVACOLL_Settings::archive_collection_show_artist(); 	
			$archive_collection_show_artist = isset( $archive_collection_show_artist ) ? $archive_collection_show_artist : 'yes';

			$yes_selected  = ('yes' == $archive_collection_show_artist) ? 'selected' : '';
			$no_selected   = ('no' == $archive_collection_show_artist) ? 'selected' : '';
			?>
			<select name="ovacoll_options[archive_collection_show_artist]" id="archive_collection_show_artist">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}


		// single
		public function single_collection_header(){
			$single_collection_header = OVACOLL_Settings::single_collection_header(); 	
			$single_collection_header = isset( $single_collection_header ) ? $single_collection_header : 'default';

			$list_header = apply_filters('gimont_list_header', '');

			?>
			<select name="ovacoll_options[single_collection_header]" id="single_collection_header">
				<?php if( $list_header ){ ?>
					<?php foreach ($list_header as $key => $value) { ?>
						<option <?php if( $key == $single_collection_header ) echo 'selected'; ?> value="<?php echo $key; ?>"><?php echo $value; ?></option>
					<?php } ?>
				<?php } ?>
				
			</select>
			<?php
		}

		public function single_collection_footer(){
			$single_collection_footer = OVACOLL_Settings::single_collection_footer(); 	
			$single_collection_footer = isset( $single_collection_footer ) ? $single_collection_footer : 'default';

			$list_footer = apply_filters('gimont_list_footer', '');

			?>
			<select name="ovacoll_options[single_collection_footer]" id="single_collection_footer">
				<?php if( $list_footer ){ ?>
					<?php foreach ($list_footer as $key => $value) { ?>
						<option <?php if( $key == $single_collection_footer ) echo 'selected'; ?> value="<?php echo $key; ?>"><?php echo $value; ?></option>
					<?php } ?>
				<?php } ?>
				
			</select>
			<?php
		}

		public function single_collection_show_share(){
			$single_collection_show_share = OVACOLL_Settings::single_collection_show_share(); 	
			$single_collection_show_share = isset( $single_collection_show_share ) ? $single_collection_show_share : 'yes';

			$yes_selected  = ('yes' == $single_collection_show_share) ? 'selected' : '';
			$no_selected   = ('no' == $single_collection_show_share) ? 'selected' : '';
			?>
			<select name="ovacoll_options[single_collection_show_share]" id="single_collection_show_share">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function single_collection_show_download(){
			$single_collection_show_download = OVACOLL_Settings::single_collection_show_download(); 	
			$single_collection_show_download = isset( $single_collection_show_download ) ? $single_collection_show_download : 'yes';

			$yes_selected  = ('yes' == $single_collection_show_download) ? 'selected' : '';
			$no_selected   = ('no' == $single_collection_show_download) ? 'selected' : '';
			?>
			<select name="ovacoll_options[single_collection_show_download]" id="single_collection_show_download">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function single_collection_show_popup(){
			$single_collection_show_popup = OVACOLL_Settings::single_collection_show_popup(); 	
			$single_collection_show_popup = isset( $single_collection_show_popup ) ? $single_collection_show_popup : 'yes';

			$yes_selected  = ('yes' == $single_collection_show_popup) ? 'selected' : '';
			$no_selected   = ('no' == $single_collection_show_popup) ? 'selected' : '';
			?>
			<select name="ovacoll_options[single_collection_show_popup]" id="single_collection_show_popup">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function single_collection_show_artist(){
			$single_collection_show_artist = OVACOLL_Settings::single_collection_show_artist(); 	
			$single_collection_show_artist = isset( $single_collection_show_artist ) ? $single_collection_show_artist : 'yes';

			$yes_selected  = ('yes' == $single_collection_show_artist) ? 'selected' : '';
			$no_selected   = ('no' == $single_collection_show_artist) ? 'selected' : '';
			?>
			<select name="ovacoll_options[single_collection_show_artist]" id="single_collection_show_artist">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function single_collection_show_year(){
			$single_collection_show_year = OVACOLL_Settings::single_collection_show_year(); 	
			$single_collection_show_year = isset( $single_collection_show_year ) ? $single_collection_show_year : 'yes';

			$yes_selected  = ('yes' == $single_collection_show_year) ? 'selected' : '';
			$no_selected   = ('no' == $single_collection_show_year) ? 'selected' : '';
			?>
			<select name="ovacoll_options[single_collection_show_year]" id="single_collection_show_year">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function single_collection_show_location(){
			$single_collection_show_location = OVACOLL_Settings::single_collection_show_location(); 	
			$single_collection_show_location = isset( $single_collection_show_location ) ? $single_collection_show_location : 'yes';

			$yes_selected  = ('yes' == $single_collection_show_location) ? 'selected' : '';
			$no_selected   = ('no' == $single_collection_show_location) ? 'selected' : '';
			?>
			<select name="ovacoll_options[single_collection_show_location]" id="single_collection_show_location">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function single_collection_show_description(){
			$single_collection_show_description = OVACOLL_Settings::single_collection_show_description(); 	
			$single_collection_show_description = isset( $single_collection_show_description ) ? $single_collection_show_description : 'yes';

			$yes_selected  = ('yes' == $single_collection_show_description) ? 'selected' : '';
			$no_selected   = ('no' == $single_collection_show_description) ? 'selected' : '';
			?>
			<select name="ovacoll_options[single_collection_show_description]" id="single_collection_show_description">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function single_collection_show_artist_mid(){
			$single_collection_show_artist_mid = OVACOLL_Settings::single_collection_show_artist_mid(); 	
			$single_collection_show_artist_mid = isset( $single_collection_show_artist_mid ) ? $single_collection_show_artist_mid : 'yes';

			$yes_selected  = ('yes' == $single_collection_show_artist_mid) ? 'selected' : '';
			$no_selected   = ('no' == $single_collection_show_artist_mid) ? 'selected' : '';
			?>
			<select name="ovacoll_options[single_collection_show_artist_mid]" id="single_collection_show_artist_mid">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function single_collection_show_year_text(){
			$single_collection_show_year_text = OVACOLL_Settings::single_collection_show_year_text(); 	
			$single_collection_show_year_text = isset( $single_collection_show_year_text ) ? $single_collection_show_year_text : 'yes';

			$yes_selected  = ('yes' == $single_collection_show_year_text) ? 'selected' : '';
			$no_selected   = ('no' == $single_collection_show_year_text) ? 'selected' : '';
			?>
			<select name="ovacoll_options[single_collection_show_year_text]" id="single_collection_show_year_text">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function single_collection_show_address(){
			$single_collection_show_address = OVACOLL_Settings::single_collection_show_address(); 	
			$single_collection_show_address = isset( $single_collection_show_address ) ? $single_collection_show_address : 'yes';

			$yes_selected  = ('yes' == $single_collection_show_address) ? 'selected' : '';
			$no_selected   = ('no' == $single_collection_show_address) ? 'selected' : '';
			?>
			<select name="ovacoll_options[single_collection_show_address]" id="single_collection_show_address">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function single_collection_show_type(){
			$single_collection_show_type = OVACOLL_Settings::single_collection_show_type(); 	
			$single_collection_show_type = isset( $single_collection_show_type ) ? $single_collection_show_type : 'yes';

			$yes_selected  = ('yes' == $single_collection_show_type) ? 'selected' : '';
			$no_selected   = ('no' == $single_collection_show_type) ? 'selected' : '';
			?>
			<select name="ovacoll_options[single_collection_show_type]" id="single_collection_show_type">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function single_collection_show_material(){
			$single_collection_show_material = OVACOLL_Settings::single_collection_show_material(); 	
			$single_collection_show_material = isset( $single_collection_show_material ) ? $single_collection_show_material : 'yes';

			$yes_selected  = ('yes' == $single_collection_show_material) ? 'selected' : '';
			$no_selected   = ('no' == $single_collection_show_material) ? 'selected' : '';
			?>
			<select name="ovacoll_options[single_collection_show_material]" id="single_collection_show_material">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function single_collection_show_accession_number(){
			$single_collection_show_accession_number = OVACOLL_Settings::single_collection_show_accession_number(); 	
			$single_collection_show_accession_number = isset( $single_collection_show_accession_number ) ? $single_collection_show_accession_number : 'yes';

			$yes_selected  = ('yes' == $single_collection_show_accession_number) ? 'selected' : '';
			$no_selected   = ('no' == $single_collection_show_accession_number) ? 'selected' : '';
			?>
			<select name="ovacoll_options[single_collection_show_accession_number]" id="single_collection_show_accession_number">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function single_collection_show_dimensions(){
			$single_collection_show_dimensions = OVACOLL_Settings::single_collection_show_dimensions(); 	
			$single_collection_show_dimensions = isset( $single_collection_show_dimensions ) ? $single_collection_show_dimensions : 'yes';

			$yes_selected  = ('yes' == $single_collection_show_dimensions) ? 'selected' : '';
			$no_selected   = ('no' == $single_collection_show_dimensions) ? 'selected' : '';
			?>
			<select name="ovacoll_options[single_collection_show_dimensions]" id="single_collection_show_dimensions">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function single_collection_show_credit(){
			$single_collection_show_credit = OVACOLL_Settings::single_collection_show_credit(); 	
			$single_collection_show_credit = isset( $single_collection_show_credit ) ? $single_collection_show_credit : 'yes';

			$yes_selected  = ('yes' == $single_collection_show_credit) ? 'selected' : '';
			$no_selected   = ('no' == $single_collection_show_credit) ? 'selected' : '';
			?>
			<select name="ovacoll_options[single_collection_show_credit]" id="single_collection_show_credit">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function single_collection_visual_desc(){
			$single_collection_visual_desc = OVACOLL_Settings::single_collection_visual_desc(); 	
			$single_collection_visual_desc = isset( $single_collection_visual_desc ) ? $single_collection_visual_desc : 'yes';

			$yes_selected  = ('yes' == $single_collection_visual_desc) ? 'selected' : '';
			$no_selected   = ('no' == $single_collection_visual_desc) ? 'selected' : '';
			?>
			<select name="ovacoll_options[single_collection_visual_desc]" id="single_collection_visual_desc">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function single_collection_timeline_history(){
			$single_collection_timeline_history = OVACOLL_Settings::single_collection_timeline_history(); 	
			$single_collection_timeline_history = isset( $single_collection_timeline_history ) ? $single_collection_timeline_history : 'yes';

			$yes_selected  = ('yes' == $single_collection_timeline_history) ? 'selected' : '';
			$no_selected   = ('no' == $single_collection_timeline_history) ? 'selected' : '';
			?>
			<select name="ovacoll_options[single_collection_timeline_history]" id="single_collection_timeline_history">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function single_collection_publications(){
			$single_collection_publications = OVACOLL_Settings::single_collection_publications(); 	
			$single_collection_publications = isset( $single_collection_publications ) ? $single_collection_publications : 'yes';

			$yes_selected  = ('yes' == $single_collection_publications) ? 'selected' : '';
			$no_selected   = ('no' == $single_collection_publications) ? 'selected' : '';
			?>
			<select name="ovacoll_options[single_collection_publications]" id="single_collection_publications">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function single_collection_show_comment(){
			$single_collection_show_comment = OVACOLL_Settings::single_collection_show_comment(); 	
			$single_collection_show_comment = isset( $single_collection_show_comment ) ? $single_collection_show_comment : 'yes';

			$yes_selected  = ('yes' == $single_collection_show_comment) ? 'selected' : '';
			$no_selected   = ('no' == $single_collection_show_comment) ? 'selected' : '';
			?>
			<select name="ovacoll_options[single_collection_show_comment]" id="single_collection_show_comment">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}
		

		/**
		 * Artist Settings
		 */
		public function archive_artist_posts_per_page() {
			$archive_artist_posts_per_page = OVACOLL_Settings::archive_artist_posts_per_page();
			$archive_artist_posts_per_page = isset( $archive_artist_posts_per_page ) ? $archive_artist_posts_per_page : '-1';

			printf(
				'<input type="text"  id="archive_artist_posts_per_page" name="ovacoll_options[archive_artist_posts_per_page]" value="%s" />',
				$archive_artist_posts_per_page
			);
		}

		public function archive_artist_orderby(){
			$archive_artist_orderby = OVACOLL_Settings::archive_artist_orderby();
			$archive_artist_orderby = isset( $archive_artist_orderby ) ? $archive_artist_orderby : 'date';
			
			$title              = ( 'title' == $archive_artist_orderby) ? 'selected' : '';
			$artist_custom_sort = ( 'artist_custom_sort' == $archive_artist_orderby) ? 'selected' : '';
			$date               = ( 'date' == $archive_artist_orderby) ? 'selected' : '';
			$id                 = ( 'ID' == $archive_artist_orderby) ? 'selected' : '';

			?>
			<select name="ovacoll_options[archive_artist_orderby]" id="archive_artist_orderby">
				<option <?php echo esc_attr($date) ?> value="date"><?php echo esc_html__('Date', 'ova-collection') ?></option>
				<option <?php echo esc_attr($title) ?> value="title"><?php echo esc_html__('Title', 'ova-collection') ?></option>
				<option <?php echo esc_attr($artist_custom_sort) ?> value="artist_custom_sort"><?php echo esc_html__('Custom Sort', 'ova-collection') ?></option>
				<option <?php echo esc_attr($id) ?> value="ID"><?php echo esc_html__('ID', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function archive_artist_order(){
			$archive_artist_order = OVACOLL_Settings::archive_artist_order(); 	
			$archive_artist_order = isset( $archive_artist_order ) ? $archive_artist_order : 'ASC';

			$asc_selected  = ('ASC' == $archive_artist_order) ? 'selected' : '';
			$desc_selected = ('DESC' == $archive_artist_order) ? 'selected' : '';

			?>
			<select name="ovacoll_options[archive_artist_order]" id="archive_artist_order">
				<option <?php echo esc_attr($asc_selected) ?> value="ASC"><?php echo esc_html__('Ascending', 'ova-collection') ?></option>
				<option <?php echo esc_attr($desc_selected) ?> value="DESC"><?php echo esc_html__('Descending', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function archive_artist_heading(){
			$archive_artist_heading =  OVACOLL_Settings::archive_artist_heading();

			isset( $archive_artist_heading ) ? $archive_artist_heading : '';
			printf(
				'<input type="text"  id="archive_artist_heading" name="ovacoll_options[archive_artist_heading]" value="%s" />',
				isset( $archive_artist_heading ) ? $archive_artist_heading : ''
			);
		}

		public function archive_artist_desc(){
			$archive_artist_desc =  OVACOLL_Settings::archive_artist_desc();

			isset( $archive_artist_desc ) ? $archive_artist_desc : '';
			printf(
				'<textarea id="archive_artist_desc" rows="4" cols="50" name="ovacoll_options[archive_artist_desc]" value="%s">'.$archive_artist_desc.'</textarea>',
				isset( $archive_artist_desc ) ? $archive_artist_desc : ''
			);
		}

		
		public function archive_artist_header(){
			$archive_artist_header = OVACOLL_Settings::archive_artist_header(); 	
			$archive_artist_header = isset( $archive_artist_header ) ? $archive_artist_header : 'default';

			$list_header = apply_filters('gimont_list_header', '');

			?>
			<select name="ovacoll_options[archive_artist_header]" id="archive_artist_header">
				<?php if( $list_header ){ ?>
					<?php foreach ($list_header as $key => $value) { ?>
						<option <?php if( $key == $archive_artist_header ) echo 'selected'; ?> value="<?php echo $key; ?>"><?php echo $value; ?></option>
					<?php } ?>
				<?php } ?>
				
			</select>
			<?php
		}

		public function archive_artist_footer(){
			$archive_artist_footer = OVACOLL_Settings::archive_artist_footer(); 	
			$archive_artist_footer = isset( $archive_artist_footer ) ? $archive_artist_footer : 'default';

			$list_footer = apply_filters('gimont_list_footer', '');

			?>
			<select name="ovacoll_options[archive_artist_footer]" id="archive_artist_footer">
				<?php if( $list_footer ){ ?>
					<?php foreach ($list_footer as $key => $value) { ?>
						<option <?php if( $key == $archive_artist_footer ) echo 'selected'; ?> value="<?php echo $key; ?>"><?php echo $value; ?></option>
					<?php } ?>
				<?php } ?>
				
			</select>
			<?php
		}

		public function archive_artist_show_image(){
			$archive_artist_show_image = OVACOLL_Settings::archive_artist_show_image(); 	
			$archive_artist_show_image = isset( $archive_artist_show_image ) ? $archive_artist_show_image : 'yes';

			$yes_selected  = ('yes' == $archive_artist_show_image) ? 'selected' : '';
			$no_selected   = ('no' == $archive_artist_show_image) ? 'selected' : '';
			?>
			<select name="ovacoll_options[archive_artist_show_image]" id="archive_artist_show_image">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function archive_artist_show_title(){
			$archive_artist_show_title = OVACOLL_Settings::archive_artist_show_title(); 	
			$archive_artist_show_title = isset( $archive_artist_show_title ) ? $archive_artist_show_title : 'yes';

			$yes_selected  = ('yes' == $archive_artist_show_title) ? 'selected' : '';
			$no_selected   = ('no' == $archive_artist_show_title) ? 'selected' : '';
			?>
			<select name="ovacoll_options[archive_artist_show_title]" id="archive_artist_show_title">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function archive_artist_show_skill(){
			$archive_artist_show_skill = OVACOLL_Settings::archive_artist_show_skill(); 	
			$archive_artist_show_skill = isset( $archive_artist_show_skill ) ? $archive_artist_show_skill : 'yes';

			$yes_selected  = ('yes' == $archive_artist_show_skill) ? 'selected' : '';
			$no_selected   = ('no' == $archive_artist_show_skill) ? 'selected' : '';
			?>
			<select name="ovacoll_options[archive_artist_show_skill]" id="archive_artist_show_skill">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function archive_artist_show_phone(){
			$archive_artist_show_phone = OVACOLL_Settings::archive_artist_show_phone(); 	
			$archive_artist_show_phone = isset( $archive_artist_show_phone ) ? $archive_artist_show_phone : 'yes';

			$yes_selected  = ('yes' == $archive_artist_show_phone) ? 'selected' : '';
			$no_selected   = ('no' == $archive_artist_show_phone) ? 'selected' : '';
			?>
			<select name="ovacoll_options[archive_artist_show_phone]" id="archive_artist_show_phone">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function archive_artist_show_email(){
			$archive_artist_show_email = OVACOLL_Settings::archive_artist_show_email(); 	
			$archive_artist_show_email = isset( $archive_artist_show_email ) ? $archive_artist_show_email : 'yes';

			$yes_selected  = ('yes' == $archive_artist_show_email) ? 'selected' : '';
			$no_selected   = ('no' == $archive_artist_show_email) ? 'selected' : '';
			?>
			<select name="ovacoll_options[archive_artist_show_email]" id="archive_artist_show_email">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}


		// single artist
		public function single_artist_related_heading(){
			$single_artist_related_heading =  OVACOLL_Settings::single_artist_related_heading();

			isset( $single_artist_related_heading ) ? $single_artist_related_heading : '';
			printf(
				'<input type="text" id="single_artist_related_heading" name="ovacoll_options[single_artist_related_heading]" value="%s" />',
				isset( $single_artist_related_heading ) ? $single_artist_related_heading : ''
			);
		}

		public function single_artist_header(){
			$single_artist_header = OVACOLL_Settings::single_artist_header(); 	
			$single_artist_header = isset( $single_artist_header ) ? $single_artist_header : 'default';

			$list_header = apply_filters('gimont_list_header', '');

			?>
			<select name="ovacoll_options[single_artist_header]" id="single_artist_header">
				<?php if( $list_header ){ ?>
					<?php foreach ($list_header as $key => $value) { ?>
						<option <?php if( $key == $single_artist_header ) echo 'selected'; ?> value="<?php echo $key; ?>"><?php echo $value; ?></option>
					<?php } ?>
				<?php } ?>
				
			</select>
			<?php
		}

		public function single_artist_footer(){
			$single_artist_footer = OVACOLL_Settings::single_artist_footer(); 	
			$single_artist_footer = isset( $single_artist_footer ) ? $single_artist_footer : 'default';

			$list_footer = apply_filters('gimont_list_footer', '');

			?>
			<select name="ovacoll_options[single_artist_footer]" id="single_artist_footer">
				<?php if( $list_footer ){ ?>
					<?php foreach ($list_footer as $key => $value) { ?>
						<option <?php if( $key == $single_artist_footer ) echo 'selected'; ?> value="<?php echo $key; ?>"><?php echo $value; ?></option>
					<?php } ?>
				<?php } ?>
				
			</select>
			<?php
		}

		public function single_artist_show_image(){
			$single_artist_show_image = OVACOLL_Settings::single_artist_show_image(); 	
			$single_artist_show_image = isset( $single_artist_show_image ) ? $single_artist_show_image : 'yes';

			$yes_selected  = ('yes' == $single_artist_show_image) ? 'selected' : '';
			$no_selected   = ('no' == $single_artist_show_image) ? 'selected' : '';
			?>
			<select name="ovacoll_options[single_artist_show_image]" id="single_artist_show_image">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function single_artist_show_title(){
			$single_artist_show_title = OVACOLL_Settings::single_artist_show_title(); 	
			$single_artist_show_title = isset( $single_artist_show_title ) ? $single_artist_show_title : 'yes';

			$yes_selected  = ('yes' == $single_artist_show_title) ? 'selected' : '';
			$no_selected   = ('no' == $single_artist_show_title) ? 'selected' : '';
			?>
			<select name="ovacoll_options[single_artist_show_title]" id="single_artist_show_title">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function single_artist_show_skill(){
			$single_artist_show_skill = OVACOLL_Settings::single_artist_show_skill(); 	
			$single_artist_show_skill = isset( $single_artist_show_skill ) ? $single_artist_show_skill : 'yes';

			$yes_selected  = ('yes' == $single_artist_show_skill) ? 'selected' : '';
			$no_selected   = ('no' == $single_artist_show_skill) ? 'selected' : '';
			?>
			<select name="ovacoll_options[single_artist_show_skill]" id="single_artist_show_skill">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function single_artist_show_phone(){
			$single_artist_show_phone = OVACOLL_Settings::single_artist_show_phone(); 	
			$single_artist_show_phone = isset( $single_artist_show_phone ) ? $single_artist_show_phone : 'yes';

			$yes_selected  = ('yes' == $single_artist_show_phone) ? 'selected' : '';
			$no_selected   = ('no' == $single_artist_show_phone) ? 'selected' : '';
			?>
			<select name="ovacoll_options[single_artist_show_phone]" id="single_artist_show_phone">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function single_artist_show_email(){
			$single_artist_show_email = OVACOLL_Settings::single_artist_show_email(); 	
			$single_artist_show_email = isset( $single_artist_show_email ) ? $single_artist_show_email : 'yes';

			$yes_selected  = ('yes' == $single_artist_show_email) ? 'selected' : '';
			$no_selected   = ('no' == $single_artist_show_email) ? 'selected' : '';
			?>
			<select name="ovacoll_options[single_artist_show_email]" id="single_artist_show_email">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function single_artist_show_content(){
			$single_artist_show_content = OVACOLL_Settings::single_artist_show_content(); 	
			$single_artist_show_content = isset( $single_artist_show_content ) ? $single_artist_show_content : 'yes';

			$yes_selected  = ('yes' == $single_artist_show_content) ? 'selected' : '';
			$no_selected   = ('no' == $single_artist_show_content) ? 'selected' : '';
			?>
			<select name="ovacoll_options[single_artist_show_content]" id="single_artist_show_content">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}

		public function single_artist_show_some_of_works(){
			$single_artist_show_some_of_works = OVACOLL_Settings::single_artist_show_some_of_works(); 	
			$single_artist_show_some_of_works = isset( $single_artist_show_some_of_works ) ? $single_artist_show_some_of_works : 'yes';

			$yes_selected  = ('yes' == $single_artist_show_some_of_works) ? 'selected' : '';
			$no_selected   = ('no' == $single_artist_show_some_of_works) ? 'selected' : '';
			?>
			<select name="ovacoll_options[single_artist_show_some_of_works]" id="single_artist_show_some_of_works">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ova-collection') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ova-collection') ?></option>
			</select>
			<?php
		}


	}

	if( is_admin() ) new OVACOLL_admin_settings();
	
}