<?php
/*
Plugin Name: Ovatheme Department
Plugin URI: https://themeforest.net/user/ovatheme
Description: Department
Author: Ovatheme
Version: 1.0.5
Author URI: https://themeforest.net/user/ovatheme/portfolio
Text Domain: ova-dep
Domain Path: /languages/
*/

if ( !defined( 'ABSPATH' ) ) exit();


if (!class_exists('ovadep')) {
	
	class ovadep
	{
		static $_instance = null;

		function __construct()
		{
			$this -> define_constants();
			$this -> includes();
			$this -> supports();
		}

		function define_constants(){
			$this->define( 'OVADEP_PLUGIN_FILE', __FILE__ );
			$this->define( 'OVADEP_PLUGIN_URI', plugin_dir_url( __FILE__ ) );
			$this->define( 'OVADEP_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
			load_plugin_textdomain( 'ova-dep', false, basename( dirname( __FILE__ ) ) .'/languages' );
		}

		function define( $name, $value ) {
			if ( ! defined( $name ) ) {
				define( $name, $value );
			}
		}

		public static function instance() {
			if ( !empty( self::$_instance ) ) {
				return self::$_instance;
			}
			return self::$_instance = new self();
		}

		function includes() {

			// inc
			require_once( OVADEP_PLUGIN_PATH.'inc/class-ova-custom-post-type.php' );

			require_once( OVADEP_PLUGIN_PATH.'inc/class-ova-get-data.php' );

			require_once( OVADEP_PLUGIN_PATH.'inc/ova-core-functions.php' );
			
			require_once( OVADEP_PLUGIN_PATH.'inc/class-ova-templates-loaders.php' );

			require_once( OVADEP_PLUGIN_PATH.'inc/class-ova-assets.php' );


			// admin
			require_once( OVADEP_PLUGIN_PATH.'admin/class-ova-metabox.php' );

			/* Customize */

			// if( current_user_can('customize') ){
			    require_once OVADEP_PLUGIN_PATH.'/inc/class-customize.php';
			// }

		}


		function supports() {

			/* Make Elementors */
			if ( did_action( 'elementor/loaded' ) ) {
				include OVADEP_PLUGIN_PATH.'elementor/class-ova-register-elementor.php';
			}

		}

	}
}

function ovadep() {
	return ovadep::instance();
}

$GLOBALS['ovadep'] = ovadep();