<?php if ( !defined( 'ABSPATH' ) ) exit();

	$category 		= $args['category'];
	$show_icon 		= $args['show_icon'];
	$show_title 	= $args['show_title'];
	$show_excerpt 	= $args['show_excerpt'];
	$show_readmore 	= $args['show_readmore'];

	$text_button 	= $args['text_button'];

	// background image
	$background_image = '';
	if ( isset( $args['background_image'] ) && !empty( $args['background_image']['url']) ) {
		$background_image = $args['background_image']['url'];
	}

	$data_options['items']              = $args['item_number'];
	$data_options['slideBy']            = $args['slides_to_scroll'];
	$data_options['margin']             = $args['margin_items'];
	$data_options['autoplayHoverPause'] = $args['pause_on_hover'] === 'yes' ? true : false;
	$data_options['loop']               = $args['infinite'] === 'yes' ? true : false;
	$data_options['autoplay']           = $args['autoplay'] === 'yes' ? true : false;
	$data_options['autoplayTimeout']    = $args['autoplay_speed'];
	$data_options['smartSpeed']         = $args['smartspeed'];
	$data_options['dots']               = $args['dot_control'] === 'yes' ? true : false;
	$data_options['rtl']				= is_rtl() ? true : false;

	if( $category == 'all' ){
		$args_new = array(
			'post_type' => 'ova_dep',
			'post_status' => 'publish',
			'posts_per_page' => $args['total_count'],
		);
	} else {
		$args_new = array(
			'post_type' => 'ova_dep',
			'post_status' => 'publish',
			'posts_per_page' => $args['total_count'],
			'tax_query' => array(
				array(
					'taxonomy' => 'cat_department',
					'field'    => 'slug',
					'terms'    => $category,
				)
			),
		);
	}

	$args_dep_order = [];
	if( $args['orderby_post'] === 'ova_dep_met_order_dep' ) {
		$args_dep_order = [
			'meta_key'   => $args['orderby_post'],
			'orderby'    => 'meta_value_num',
			'meta_type' => 'NUMERIC',
			'order'   => $args['order'],
		];
	} else { 
		$args_dep_order = [
			'orderby'        => $args['orderby_post'],
		];
	}
	$args_dep = array_merge( $args_new, $args_dep_order );

	$deps  = new \WP_Query($args_dep);

	$count = 0;

?>

	<div class="ova_dep_slide owl-carousel owl-theme" data-options="<?php echo esc_attr(json_encode($data_options)); ?>">
		<?php if( $deps->have_posts() ) : while ( $deps->have_posts() ) : $deps->the_post(); $count++; ?>

			<div class="dep_slide_content">

				<?php 
					$id = get_the_id();

					$class_icon = get_post_meta( $id, 'ova_dep_met_class_icon', true );
					$title 		= get_the_title();
					$excerpt 	= ova_dep_custom_text( get_the_excerpt(), 20 );
					$thumbnail  = get_the_post_thumbnail( $id, 'large', array('class'=> 'img-responsive' ));
					$thumbnail_url = get_the_post_thumbnail_url( $id, 'full' );
				?>

				<?php if ( $background_image != '' ) : ?> 
				    <div class="mask" style="background-image: url(<?php echo esc_attr( $background_image ) ; ?>)"></div>
			    <?php endif;?>
			
				<?php if( $show_icon === 'yes' ){ ?>
					<div class="icon">
						<i class="<?php echo esc_attr( $class_icon ); ?>" aria-hidden="true"></i>
					</div>
				<?php } ?>
				<?php if( $show_title === 'yes' ){ ?>
					<div class="title-wrapper">
						<span class="number">
							<?php echo sprintf('%02s', $count) . '.';?>
						</span>
						<h2 class="title">
							<a href="<?php echo get_the_permalink(); ?>">
								<?php echo esc_html($title); ?>
							</a>
						</h2>
					</div>
				<?php } ?>
				<?php if( ! empty( $excerpt ) && $show_excerpt === 'yes' ){ ?>
					<p class="description">
						<?php echo $excerpt; ?>
					</p>
				<?php } ?>
				<?php if( $show_readmore === 'yes' ){ ?>
					<a class="readmore" href="<?php echo get_the_permalink(); ?>" >
						<span class="text-button">
							<?php echo esc_html($text_button); ?>
						</span>
						<i aria-hidden="true" class="gimonticon gimonticon-right"></i>
					</a>
				<?php } ?>
			</div>

		<?php endwhile; endif; wp_reset_postdata(); ?>
	</div>

<?php 