<?php if ( !defined( 'ABSPATH' ) ) exit();
	
	global $post;

	$id 	= get_the_ID();

	$type 	= $args['type'];

	$title_dep_all 	= $args['title_dep_all'];
	$posts_per_page	= $args['posts_per_page'];

	$template   = $args['template'];

	$order 		= $args['order'];
	$orderby    = $args['orderby'];
	$category   = $args['category'];

	// Departments
	$args_dep = array(
		'post_type' 		=> 'ova_dep',
		'posts_per_page' 	=> $posts_per_page,
		'order' 			=> $order,
	);

	if ( $orderby  === 'ova_dep_met_order_dep' ) {
		$args_dep['orderby'] 	= 'meta_value_num';
		$args_dep['meta_type'] 	= 'NUMERIC';
		$args_dep['meta_key'] 	= 'ova_dep_met_order_dep';
	} else {
		$args_dep['orderby'] = $orderby;
	}

	if ( $category  !== 'all' ) {
		$args_dep['tax_query'] = array(
			array(
				'taxonomy' => 'cat_department',
				'field'    => 'slug',
				'terms'    => $category,
			)
		);
	} 

	$list_deps = get_posts( $args_dep );

	// Categories
	$category_not_in = isset($args['category_not_in']) ? $args['category_not_in'] : '';

	$args_cat = array(
		'taxonomy' 	 => 'cat_department',
		'orderby' 	 => $orderby,
		'order'   	 => $order,
		'hide_empty' => false,
		'parent' 	 => 0,
		'exclude'    => explode( '|', $category_not_in ),
	);

	$terms    = get_the_terms( $post, 'cat_department' );
	$term_ids = [];
	if ( $terms ) {
		foreach ($terms as $key => $term) {
			array_push( $term_ids, $term->term_id );
		}
	}

	$categories = get_categories($args_cat);
	$term_id 	= get_queried_object_id();

?>


<div class="ova-list-dep-name <?php echo esc_attr( $template ); ?>">

	<?php if($title_dep_all): ?>
		<h2 class="title">
			<?php echo esc_html( $title_dep_all ); ?>
		</h2>
	<?php endif;?>

	<ul class="dep-list">
		<?php if ($list_deps && $type == 'post' ) {
			foreach ( $list_deps as $dep ) :
				$id_dep 	= $dep->ID;
				$title_dep 	= $dep->post_title;

				$active_class_dep = ( $id == $id_dep ) ? 'active' : '';
			?>
				<li class="item <?php echo esc_attr( $active_class_dep ) ?>">
					<a class="item-link" href="<?php echo get_the_permalink( $id_dep ); ?>">
						<?php echo esc_html( $title_dep ); ?>
						<?php if($template == 'template2'): ?>
							<i class="ovaicon-next-4" aria-hidden="true"></i>
						<?php endif;?>
					</a>
				</li>

			<?php endforeach;

			} else { 
				if ( $categories ) : foreach ($categories as $cat) : 
					$active_class = $cat->term_id == $term_id ? 'active' : ''; 
					if ( $id ) {
						$active_class = in_array( $cat->term_id, $term_ids) ? 'active' : '';
					}
				?>
					<li class="item <?php echo esc_attr( $active_class ); ?>">
						<a href="<?php echo esc_url( get_term_link( $cat ) ); ?>" class="item-link" 
							data-slug="<?php echo esc_attr( $cat->slug ); ?>"
							title="<?php echo esc_attr( $cat->name ); ?>"
						>
							<?php echo esc_html( $cat->name ); ?>
							<?php if (get_term_children( $cat->term_id, 'cat_department' ) ): ?>
								<i class="fas fa-plus" aria-hidden="true"></i>
							<?php endif; ?>	
						</a>
						<?php ovadep_cat_list( $cat->term_id, $term_ids ); ?>
					</li>
				<?php endforeach; ?>
			<?php endif; ?>
		<?php } ?>
	</ul>
</div>