<?php

if ( ! defined('ABSPATH') ) {
	exit();
}


if ( ! class_exists( 'OVADOC_Ajax' ) ) {
	
	class OVADOC_Ajax {

		public function __construct(){

			add_action( 'wp_ajax_ova_show_file_list', array( $this, 'ova_show_file_list' ) );
			add_action( 'wp_ajax_nopriv_ova_show_file_list', array( $this, 'ova_show_file_list' ) );

			add_action( 'wp_ajax_ova_show_doc_list', array( $this, 'ova_show_doc_list' ) );
			add_action( 'wp_ajax_nopriv_ova_show_doc_list', array( $this, 'ova_show_doc_list' ) );

			add_action( 'wp_ajax_ova_doc_pagination_ajax', array( $this, 'ova_doc_pagination_ajax' ) );
			add_action( 'wp_ajax_nopriv_ova_doc_pagination_ajax', array( $this, 'ova_doc_pagination_ajax' ) );

			add_action( 'wp_ajax_ova_doc_filter_ajax', array( $this, 'ova_doc_filter_ajax' ) );
			add_action( 'wp_ajax_nopriv_ova_doc_filter_ajax', array( $this, 'ova_doc_filter_ajax' ) );
		}

		public function ova_show_file_list() {
			$id = intval( $_POST['id'] );
			ob_start();
			ova_modal_get_file_list( $id );
			echo ob_get_clean();
			wp_die();
		}

		public function ova_show_doc_list() {
			$cate_slug 		= isset($_POST['slug']) ? $_POST['slug'] : 'all' ;
			$args_show      = isset($_POST['args_show']) ? $_POST['args_show'] : [];

			$post_per_page 	= intval( get_theme_mod( 'ova_doc_total_record', 8 ) );
			$order_by 		= get_theme_mod( 'ova_doc_orderby', 'ID' );
			$order 			= get_theme_mod( 'ova_doc_order', 'DESC' );

			$args = array(
				'order_by' 			=> $order_by,
				'order' 			=> $order,
				'posts_per_page' 	=> $post_per_page,
				'cate' 				=> $cate_slug,
			);
			
			$documents 		= ova_doc_category_ajax( $cate_slug );
			$total_items 	= $documents->found_posts;
			$total_pages 	= $documents->max_num_pages;
			$curent_page 	= 1;

			ob_start();
			ova_get_doc_list( $documents, $cate_slug, $args_show );
			ova_doc_pagination_ajax($total_pages,$curent_page,$post_per_page,$args);
			echo ob_get_clean();
			wp_die();
		}

		public function ova_doc_pagination_ajax() {
			$args 			= isset($_POST['args']) ? $_POST['args'] : [] ;
			$offset			= isset($_POST['offset']) ? $_POST['offset'] : '';
			$curent_page 	= isset($_POST['page']) ? $_POST['page'] : 1;
			$args_show      = isset($_POST['args_show']) ? $_POST['args_show'] : [];

			$cate_slug 		= sanitize_text_field ( urldecode($args['cate']) );
			$args['offset'] = intval( $offset );

			$documents 		= ova_doc_pagination_query_ajax( $args );
			$total_pages 	= $documents->max_num_pages;
			$post_per_page 	= intval( $args['posts_per_page'] );

			ob_start();
			ova_get_doc_list($documents, $cate_slug, $args_show);
			ova_doc_pagination_ajax($total_pages,$curent_page,$post_per_page,$args);
			echo ob_get_clean();
			wp_die();
		}

		public function ova_doc_filter_ajax(){
			$form_data 		= isset($_POST['form_data']) ? $_POST['form_data'] : [];
			$args_show      = isset($_POST['args_show']) ? $_POST['args_show'] : [];

			$cate_name 		= sanitize_text_field( $form_data['cate_name'] );
			$published_date = sanitize_text_field( $form_data['published_date'] );
			$cate_slug 		= sanitize_text_field( urldecode($form_data['cate_slug']) );
			$start_date 	= '';
			$end_date 		= '';

			if ($published_date) {
				$published_date_arr = explode(" - ",$published_date);
				$start_date 		= $published_date_arr[0];
				$end_date 			= $published_date_arr[1];
			}

			$post_per_page 	= intval( get_theme_mod( 'ova_doc_total_record', 8 ) );
			$order_by 		= get_theme_mod( 'ova_doc_orderby', 'ID' );
			$order 			= get_theme_mod( 'ova_doc_order', 'DESC' );

			$args = array(
				'order_by' 			=> $order_by,
				'order' 			=> $order,
				'posts_per_page' 	=> $post_per_page,
				'cate' 				=> $cate_slug,
				'cate_name'			=> trim( $cate_name ),
				'start_date'		=> $start_date,
				'end_date'			=> $end_date,
			);

			$documents 		= ova_doc_query_filter( $cate_name, $start_date, $end_date, $cate_slug );
			$total_items 	= $documents->found_posts;
			$total_pages 	= $documents->max_num_pages;
			$curent_page 	= 1;

			ob_start();
			ova_get_doc_list( $documents, $cate_slug, $args_show );
			ova_doc_pagination_ajax($total_pages,$curent_page,$post_per_page,$args);
			echo ob_get_clean();
			wp_die();
		}
	}

	new OVADOC_Ajax();
}