<?php 

if( !defined( 'ABSPATH' ) ) exit();

if( !class_exists( 'OVADOC_custom_post_type' ) ) {

	class OVADOC_custom_post_type{

		public function __construct(){
			add_action( 'init', array( $this, 'OVADOC_register_post_type_ova_doc' ) );
			add_action( 'init', array( $this, 'OVADOC_register_taxonomy_ova_doc' ) );
		}

		
		function OVADOC_register_post_type_ova_doc() {

			$taxonomies = array('cat_doc');

			$labels = array(
				'name'                  => _x( 'Documents', 'Post Type General Name', 'ova-doc' ),
				'singular_name'         => _x( 'Document', 'Post Type Singular Name', 'ova-doc' ),
				'menu_name'             => __( 'Documents', 'ova-doc' ),
				'name_admin_bar'        => __( 'Document', 'ova-doc' ),
				'archives'              => __( 'Item Archives', 'ova-doc' ),
				'attributes'            => __( 'Item Attributes', 'ova-doc' ),
				'parent_item_colon'     => __( 'Parent Item:', 'ova-doc' ),
				'all_items'             => __( 'All Documents', 'ova-doc' ),
				'add_new_item'          => __( 'Add New Document', 'ova-doc' ),
				'add_new'               => __( 'Add New', 'ova-doc' ),
				'new_item'              => __( 'New Item', 'ova-doc' ),
				'edit_item'             => __( 'Edit Document', 'ova-doc' ),
				'view_item'             => __( 'View Item', 'ova-doc' ),
				'view_items'            => __( 'View Items', 'ova-doc' ),
				'search_items'          => __( 'Search Item', 'ova-doc' ),
				'not_found'             => __( 'Not found', 'ova-doc' ),
				'not_found_in_trash'    => __( 'Not found in Trash', 'ova-doc' ),
			);
			$args = array(
				'description'         => __( 'Post Type Description', 'ova-doc' ),
				'labels'              => $labels,
				'supports'            => array( 'title', 'editor', 'comments', 'thumbnail' ),
				'taxonomies'          => $taxonomies,
				'hierarchical'        => false,
				'public'              => true,
				'show_ui'             => true,
				'show_in_rest'        => true,
				'menu_position'       => 20,
				'menu_icon' 		  => 'dashicons-media-document',
				'query_var'           => true,
				'has_archive'         => true,
				'exclude_from_search' => true,
				'publicly_queryable'  => true,
				'rewrite'             => array( 'slug' => _x( 'ova_doc', 'URL slug', 'ova-doc' ) ),
				'capability_type'     => 'post',
			);
			register_post_type( 'ova_doc', $args );
		}

		function OVADOC_register_taxonomy_ova_doc(){

			$labels = array(
				'name'                       => _x( 'Document categories', 'Post Type General Name', 'ova-doc' ),
				'singular_name'              => _x( 'Category Document', 'Post Type Singular Name', 'ova-doc' ),
				'menu_name'                  => __( 'Categories', 'ova-doc' ),
				'all_items'                  => __( 'All Category Document', 'ova-doc' ),
				'parent_item'                => __( 'Parent Item', 'ova-doc' ),
				'parent_item_colon'          => __( 'Parent Item:', 'ova-doc' ),
				'new_item_name'              => __( 'New Item Name', 'ova-doc' ),
				'add_new_item'               => __( 'Add New Category', 'ova-doc' ),
				'add_new'                    => __( 'Add New Category', 'ova-doc' ),
				'edit_item'                  => __( 'Edit Category', 'ova-doc' ),
				'view_item'                  => __( 'View Item', 'ova-doc' ),
				'separate_items_with_commas' => __( 'Separate items with commas', 'ova-doc' ),
				'add_or_remove_items'        => __( 'Add or remove items', 'ova-doc' ),
				'choose_from_most_used'      => __( 'Choose from the most used', 'ova-doc' ),
				'popular_items'              => __( 'Popular Items', 'ova-doc' ),
				'search_items'               => __( 'Search Items', 'ova-doc' ),
				'not_found'                  => __( 'Not Found', 'ova-doc' ),
				'no_terms'                   => __( 'No items', 'ova-doc' ),
				'items_list'                 => __( 'Items list', 'ova-doc' ),
				'items_list_navigation'      => __( 'Items list navigation', 'ova-doc' ),

			);
			$args = array(
				'labels'            => $labels,
				'hierarchical'      => true,
				'publicly_queryable' => true,
				'public'            => true,
				'show_ui'           => true,
				'show_in_rest'      => true,
				'show_admin_column' => true,
				'show_in_nav_menus' => true,
				'show_tagcloud'     => false,
				'rewrite'            => array(
					'slug'       => _x( 'cat_doc','Document Slug', 'ova-doc' ),
					'with_front' => false,
					'feeds'      => true,
				),
			);
			register_taxonomy( 'cat_doc', array( 'ova_doc' ), $args );
		}
	}

	new OVADOC_custom_post_type();
}