<?php

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

if( !function_exists( 'ovadoc_locate_template' ) ){
	function ovadoc_locate_template( $template_name, $template_path = '', $default_path = '' ) {
		
		// Set variable to search in ovacoll-templates folder of theme.
		if ( ! $template_path ) :
			$template_path = 'ovadoc-templates/';
		endif;

		// Set default plugin templates path.
		if ( ! $default_path ) :
			$default_path = OVADOC_PLUGIN_PATH . 'templates/'; // Path to the template folder
		endif;

		// Search template file in theme folder.
		$template = locate_template( array(
			$template_path . $template_name
			// $template_name
		) );

		// Get plugins template file.
		if ( ! $template ) :
			$template = $default_path . $template_name;
		endif;

		return apply_filters( 'ovadoc_locate_template', $template, $template_name, $template_path, $default_path );
	}

}


function ovadoc_get_template( $template_name, $args = array(), $tempate_path = '', $default_path = '' ) {
	if ( is_array( $args ) && isset( $args ) ) :
		extract( $args );
	endif;
	$template_file = ovadoc_locate_template( $template_name, $tempate_path, $default_path );
	if ( ! file_exists( $template_file ) ) :
		_doing_it_wrong( __FUNCTION__, sprintf( '<code>%s</code> does not exist.', $template_file ), '1.0.0' );
		return;
	endif;

	
	include $template_file;
}


add_filter( 'gimont_header_customize', 'gimont_header_customize_doc', 10, 1 );
function gimont_header_customize_doc( $header ){


	if( is_tax( 'cat_doc' ) ||  get_query_var( 'cat_doc' ) != '' || is_post_type_archive( 'ova_doc' ) ){

	  	$header = get_theme_mod( 'header_archive_doc', 'default' );

	}else if( is_singular( 'ova_doc' ) ){

		$header = get_theme_mod( 'header_single_doc', 'default' );
	}

	return $header;

}

add_filter( 'gimont_footer_customize', 'gimont_footer_customize_doc', 10, 1 );
function gimont_footer_customize_doc( $footer ){
    
   if( is_tax( 'cat_doc' ) ||  get_query_var( 'cat_doc' ) != '' || is_post_type_archive( 'ova_doc' ) ){

        $footer = get_theme_mod( 'archive_footer_doc', 'default' );

    }else if( is_singular( 'ova_doc' ) ){

        $footer = get_theme_mod( 'single_footer_doc', 'default' );
    }

    return $footer;

}


/**
 * Get files data from ID
 */
function ova_doc_get_name_files( $ID ) {
	$args = array(
	    'post_type' => 'attachment',
	    'p'		=> $ID
	);
	$query = new WP_Query( $args );

	return $query->posts;
}