<?php 

if( !defined( 'ABSPATH' ) ) exit();


if( !class_exists( 'OVAEV_Admin_Settings' ) ){

	/**
	 * Make Admin Class
	 */
	class OVAEV_Admin_Settings{

		/**
		 * Construct Admin
		 */
		public function __construct(){
			add_action( 'admin_enqueue_scripts', array( $this, 'ovaev_load_media' ) );
			add_action( 'admin_init', array( $this, 'register_options' ) );
		}


		public function ovaev_load_media() {
			wp_enqueue_media();
		}


		public function print_options_section(){
			return true;
		}


		public function register_options(){

			register_setting(
				'ovaev_options_group', // Option group
				'ovaev_options', // Name Option
				array( $this, 'settings_callback' ) // Call Back
			);

			/**
			 * General Settings
			 */
			// Add Section: General Settings
			add_settings_section(
				'ovaev_general_section_id', // ID
				esc_html__('General Setting', 'ovaev'), // Title
				array( $this, 'print_options_section' ),
				'ovaev_general_settings' // Page
			);

			add_settings_field(
				'archive_event_format_date', // ID
				esc_html__('Date Format','ovaev'),
				array( $this, 'archive_event_format_date' ),
				'ovaev_general_settings', // Page
				'ovaev_general_section_id' // Section ID
			);

			add_settings_field(
				'archive_event_format_time', // ID
				esc_html__('Time Format','ovaev'),
				array( $this, 'archive_event_format_time' ),
				'ovaev_general_settings', // Page
				'ovaev_general_section_id' // Section ID
			);

			add_settings_field(
				'archive_format_date_lang', // ID
				esc_html__('Calendar Language','ovaev'),
				array( $this, 'archive_format_date_lang' ),
				'ovaev_general_settings', // Page
				'ovaev_general_section_id' // Section ID
			);

			/**
			 * Basic Settings
			 */

			/** Add Section: Archive Event Settings **/
			add_settings_section(
				'ovaev_archive_event_section_id', // ID
				esc_html__('Archive Event Setting', 'ovaev'), // Title
				array( $this, 'print_options_section' ),
				'ovaev_archive_event_settings' // Page
			);

			add_settings_field(
				'archive_event_type', // ID
				esc_html__('Templates','ovaev'),
				array( $this, 'archive_event_type' ),
				'ovaev_archive_event_settings', // Page
				'ovaev_archive_event_section_id', // Section ID
				array( 'class' => 'ovaev_archive_event_type' )
			);

			add_settings_field(
				'archive_event_posts_per_page',
				esc_html__( 'Posts per page', 'ovaev' ),
				array( $this, 'archive_event_posts_per_page' ),
				'ovaev_archive_event_settings',
				'ovaev_archive_event_section_id'
			);

			add_settings_field(
				'archive_event_orderby', // ID
				esc_html__('Order By','ovaev'),
				array( $this, 'archive_event_orderby' ),
				'ovaev_archive_event_settings', // Page
				'ovaev_archive_event_section_id' // Section ID
			);

			add_settings_field(
				'archive_event_order', // ID
				esc_html__('Order','ovaev'),
				array( $this, 'archive_event_order' ),
				'ovaev_archive_event_settings', // Page
				'ovaev_archive_event_section_id' // Section ID
			);

			add_settings_field(
				'archive_event_header', // ID
				esc_html__('Header','ovaev'),
				array( $this, 'archive_event_header' ),
				'ovaev_archive_event_settings', // Page
				'ovaev_archive_event_section_id' // Section ID
			);

			add_settings_field(
				'archive_event_footer', // ID
				esc_html__('Footer','ovaev'),
				array( $this, 'archive_event_footer' ),
				'ovaev_archive_event_settings', // Page
				'ovaev_archive_event_section_id' // Section ID
			);

			add_settings_field(
				'archive_event_col', // ID
				esc_html__('Columns','ovaev'),
				array( $this, 'archive_event_col' ),
				'ovaev_archive_event_settings', // Page
				'ovaev_archive_event_section_id' // Section ID
			);

			add_settings_field(
				'archive_event_thumbnail', // ID
				esc_html__('Thumbnail','ovaev'),
				array( $this, 'archive_event_thumbnail' ),
				'ovaev_archive_event_settings', // Page
				'ovaev_archive_event_section_id' // Section ID
			);

			add_settings_field(
				'ovaev_show_sidebar', // ID
				esc_html__('Show event sidebar','ovaev'),
				array( $this, 'ovaev_show_sidebar' ),
				'ovaev_archive_event_settings', // Page
				'ovaev_archive_event_section_id' // Section ID
			);

			add_settings_field(
				'ovaev_show_past', // ID
				esc_html__('Show Past Event in Result','ovaev'),
				array( $this, 'ovaev_show_past' ),
				'ovaev_archive_event_settings', // Page
				'ovaev_archive_event_section_id' // Section ID
			);

			add_settings_field(
				'ovaev_show_search_by_date', // ID
				esc_html__('Show search by date','ovaev'),
				array( $this, 'ovaev_show_search_by_date' ),
				'ovaev_archive_event_settings', // Page
				'ovaev_archive_event_section_id' // Section ID
			);

			add_settings_field(
				'ovaev_show_search_by_category', // ID
				esc_html__('Show search by category','ovaev'),
				array( $this, 'ovaev_show_search_by_category' ),
				'ovaev_archive_event_settings', // Page
				'ovaev_archive_event_section_id' // Section ID
			);

			add_settings_field(
				'ovaev_archive_show_thumbnail', // ID
				esc_html__('Show Thumbnail','ovaev'),
				array( $this, 'ovaev_archive_show_thumbnail' ),
				'ovaev_archive_event_settings', // Page
				'ovaev_archive_event_section_id' // Section ID
			);

			add_settings_field(
				'ovaev_archive_show_date', // ID
				esc_html__('Show Date','ovaev'),
				array( $this, 'ovaev_archive_show_date' ),
				'ovaev_archive_event_settings', // Page
				'ovaev_archive_event_section_id' // Section ID
			);

			add_settings_field(
				'ovaev_archive_show_hour', // ID
				esc_html__('Show Hour','ovaev'),
				array( $this, 'ovaev_archive_show_hour' ),
				'ovaev_archive_event_settings', // Page
				'ovaev_archive_event_section_id' // Section ID
			);

			add_settings_field(
				'ovaev_archive_show_location', // ID
				esc_html__('Show Location','ovaev'),
				array( $this, 'ovaev_archive_show_location' ),
				'ovaev_archive_event_settings', // Page
				'ovaev_archive_event_section_id' // Section ID
			);

			add_settings_field(
				'ovaev_archive_show_title', // ID
				esc_html__('Show Title','ovaev'),
				array( $this, 'ovaev_archive_show_title' ),
				'ovaev_archive_event_settings', // Page
				'ovaev_archive_event_section_id' // Section ID
			);

			add_settings_field(
				'ovaev_archive_show_short_desc', // ID
				esc_html__('Show Excerpt','ovaev'),
				array( $this, 'ovaev_archive_show_short_desc' ),
				'ovaev_archive_event_settings', // Page
				'ovaev_archive_event_section_id', // Section ID
				array( 'class' => 'ovaev_archive_show_short_desc' )
			);

			add_settings_field(
				'ovaev_archive_show_link_to', // ID
				esc_html__('Show Link to Detail','ovaev'),
				array( $this, 'ovaev_archive_show_link_to' ),
				'ovaev_archive_event_settings', // Page
				'ovaev_archive_event_section_id' // Section ID
			);
			

			/** Add Section: Single Event Settings **/
			add_settings_section(
				'ovaev_single_event_section_id', // ID
				esc_html__('Single Event Setting', 'ovaev'), // Title
				array( $this, 'print_options_section' ),
				'ovaev_single_event_settings' // Page
			);

			add_settings_field(
				'ovaev_get_template_single', // ID
				esc_html__('Templates','ovaev'),
				array( $this, 'ovaev_get_template_single' ),
				'ovaev_single_event_settings', // Page
				'ovaev_single_event_section_id' // Section ID
			);

			add_settings_field(
				'single_event_header', // ID
				esc_html__('Header','ovaev'),
				array( $this, 'single_event_header' ),
				'ovaev_single_event_settings', // Page
				'ovaev_single_event_section_id' // Section ID
			);

			add_settings_field(
				'single_event_footer', // ID
				esc_html__('Footer','ovaev'),
				array( $this, 'single_event_footer' ),
				'ovaev_single_event_settings', // Page
				'ovaev_single_event_section_id' // Section ID
			);

			add_settings_field(
				'google_key_map', // ID
				esc_html__('Google Key Map','ovaev'),
				array( $this, 'google_key_map' ),
				'ovaev_single_event_settings', // Page
				'ovaev_single_event_section_id' // Section ID
			);

			add_settings_field(
				'event_map_zoom', // ID
				esc_html__('Google Map Zoom','ovaev'),
				array( $this, 'event_map_zoom' ),
				'ovaev_single_event_settings', // Page
				'ovaev_single_event_section_id' // Section ID
			);

			add_settings_field(
				'ovaev_show_sidebar_single', // ID
				esc_html__('Show sidebar','ovaev'),
				array( $this, 'ovaev_show_sidebar_single' ),
				'ovaev_single_event_settings', // Page
				'ovaev_single_event_section_id' // Section ID
			);

			add_settings_field(
				'ovaev_single_show_image', // ID
				esc_html__('Show Image','ovaev'),
				array( $this, 'ovaev_single_show_image' ),
				'ovaev_single_event_settings', // Page
				'ovaev_single_event_section_id' // Section ID
			);

			add_settings_field(
				'ovaev_show_title_single', // ID
				esc_html__('Show title','ovaev'),
				array( $this, 'ovaev_show_title_single' ),
				'ovaev_single_event_settings', // Page
				'ovaev_single_event_section_id' // Section ID
			);

			add_settings_field(
				'ovaev_single_show_register_button', // ID
				esc_html__('Show Register Button','ovaev'),
				array( $this, 'ovaev_single_show_register_button' ),
				'ovaev_single_event_settings', // Page
				'ovaev_single_event_section_id' // Section ID
			);

			add_settings_field(
				'ovaev_single_show_date', // ID
				esc_html__('Show Date','ovaev'),
				array( $this, 'ovaev_single_show_date' ),
				'ovaev_single_event_settings', // Page
				'ovaev_single_event_section_id' // Section ID
			);

			add_settings_field(
				'ovaev_single_show_time', // ID
				esc_html__('Show Time','ovaev'),
				array( $this, 'ovaev_single_show_time' ),
				'ovaev_single_event_settings', // Page
				'ovaev_single_event_section_id' // Section ID
			);

			add_settings_field(
				'ovaev_single_show_venue', // ID
				esc_html__('Show Venue','ovaev'),
				array( $this, 'ovaev_single_show_venue' ),
				'ovaev_single_event_settings', // Page
				'ovaev_single_event_section_id' // Section ID
			);

			add_settings_field(
				'ovaev_single_show_google_calendar', // ID
				esc_html__('Show Google Calendar Export','ovaev'),
				array( $this, 'ovaev_single_show_google_calendar' ),
				'ovaev_single_event_settings', // Page
				'ovaev_single_event_section_id' // Section ID
			);

			add_settings_field(
				'ovaev_single_show_ical_export', // ID
				esc_html__('Show Ical Export','ovaev'),
				array( $this, 'ovaev_single_show_ical_export' ),
				'ovaev_single_event_settings', // Page
				'ovaev_single_event_section_id' // Section ID
			);

			add_settings_field(
				'ovaev_single_show_content', // ID
				esc_html__('Show Content','ovaev'),
				array( $this, 'ovaev_single_show_content' ),
				'ovaev_single_event_settings', // Page
				'ovaev_single_event_section_id' // Section ID
			);

			add_settings_field(
				'ovaev_single_show_map', // ID
				esc_html__('Show Map','ovaev'),
				array( $this, 'ovaev_single_show_map' ),
				'ovaev_single_event_settings', // Page
				'ovaev_single_event_section_id' // Section ID
			);

			add_settings_field(
				'ovaev_single_show_organizer', // ID
				esc_html__('Show Organizer Name','ovaev'),
				array( $this, 'ovaev_single_show_organizer' ),
				'ovaev_single_event_settings', // Page
				'ovaev_single_event_section_id' // Section ID
			);

			add_settings_field(
				'ovaev_single_show_phone', // ID
				esc_html__('Show Phone','ovaev'),
				array( $this, 'ovaev_single_show_phone' ),
				'ovaev_single_event_settings', // Page
				'ovaev_single_event_section_id' // Section ID
			);

			add_settings_field(
				'ovaev_single_show_email', // ID
				esc_html__('Show Email','ovaev'),
				array( $this, 'ovaev_single_show_email' ),
				'ovaev_single_event_settings', // Page
				'ovaev_single_event_section_id' // Section ID
			);

			add_settings_field(
				'ovaev_single_show_website', // ID
				esc_html__('Show Website','ovaev'),
				array( $this, 'ovaev_single_show_website' ),
				'ovaev_single_event_settings', // Page
				'ovaev_single_event_section_id' // Section ID
			);

			add_settings_field(
				'ovaev_single_show_gallery', // ID
				esc_html__('Show Gallery','ovaev'),
				array( $this, 'ovaev_single_show_gallery' ),
				'ovaev_single_event_settings', // Page
				'ovaev_single_event_section_id' // Section ID
			);

			add_settings_field(
				'ovaev_single_show_share', // ID
				esc_html__('Show Share','ovaev'),
				array( $this, 'ovaev_single_show_share' ),
				'ovaev_single_event_settings', // Page
				'ovaev_single_event_section_id' // Section ID
			);

			add_settings_field(
				'ovaev_single_show_next_prev', // ID
				esc_html__('Show Next Prev','ovaev'),
				array( $this, 'ovaev_single_show_next_prev' ),
				'ovaev_single_event_settings', // Page
				'ovaev_single_event_section_id' // Section ID
			);

			add_settings_field(
				'ovaev_single_show_related', // ID
				esc_html__('Show Related','ovaev'),
				array( $this, 'ovaev_single_show_related' ),
				'ovaev_single_event_settings', // Page
				'ovaev_single_event_section_id' // Section ID
			);

			add_settings_field(
				'ovaev_single_show_comment', // ID
				esc_html__('Show Comment','ovaev'),
				array( $this, 'ovaev_single_show_comment' ),
				'ovaev_single_event_settings', // Page
				'ovaev_single_event_section_id' // Section ID
			);

		}

		public function settings_callback( $input ){

			$new_input = array();

			// general
			if( isset( $input['archive_event_format_date'] ) )
				$new_input['archive_event_format_date'] = sanitize_text_field( $input['archive_event_format_date'] ) ? sanitize_text_field( $input['archive_event_format_date'] ) : 'd-m-Y';

			if( isset( $input['archive_format_date_lang'] ) )
				$new_input['archive_format_date_lang'] = sanitize_text_field( $input['archive_format_date_lang'] ) ? sanitize_text_field( $input['archive_format_date_lang'] ) : 'en';

			if( isset( $input['archive_event_format_time'] ) )
				$new_input['archive_event_format_time'] = sanitize_text_field( $input['archive_event_format_time'] ) ? sanitize_text_field( $input['archive_event_format_time'] ) : 'H:i';

			// archive
			if( isset( $input['ovaev_show_past'] ) )
				$new_input['ovaev_show_past'] = sanitize_text_field( $input['ovaev_show_past'] ) ? sanitize_text_field( $input['ovaev_show_past'] ) : 'yes';

			if ( isset( $input['archive_event_posts_per_page'] ) ) {
				$new_input['archive_event_posts_per_page'] = sanitize_text_field( $input['archive_event_posts_per_page'] ) ? sanitize_text_field( $input['archive_event_posts_per_page'] ) : 6;
			}

			if( isset( $input['archive_event_orderby'] ) )
				$new_input['archive_event_orderby'] = sanitize_text_field( $input['archive_event_orderby'] ) ? sanitize_text_field( $input['archive_event_orderby'] ) : 'title';

			if( isset( $input['archive_event_order'] ) )
				$new_input['archive_event_order'] = sanitize_text_field( $input['archive_event_order'] ) ? sanitize_text_field( $input['archive_event_order'] ) : 'ASC';

			if( isset( $input['archive_event_thumbnail'] ) )
				$new_input['archive_event_thumbnail'] = sanitize_text_field( $input['archive_event_thumbnail'] ) ? sanitize_text_field( $input['archive_event_thumbnail'] ) : '600x400';

			if( isset( $input['archive_event_type'] ) )
				$new_input['archive_event_type'] = sanitize_text_field( $input['archive_event_type'] ) ? sanitize_text_field( $input['archive_event_type'] ) : 'type1';

			if( isset( $input['archive_event_col'] ) )
				$new_input['archive_event_col'] = sanitize_text_field( $input['archive_event_col'] ) ? sanitize_text_field( $input['archive_event_col'] ) : 'col1';
            
            if( isset( $input['archive_event_header'] ) )
				$new_input['archive_event_header'] = sanitize_text_field( $input['archive_event_header'] ) ? sanitize_text_field( $input['archive_event_header'] ) : 'default';

			if( isset( $input['archive_event_footer'] ) )
				$new_input['archive_event_footer'] = sanitize_text_field( $input['archive_event_footer'] ) ? sanitize_text_field( $input['archive_event_footer'] ) : 'default';

			if( isset( $input['ovaev_show_sidebar'] ) )
				$new_input['ovaev_show_sidebar'] = sanitize_text_field( $input['ovaev_show_sidebar'] ) ? sanitize_text_field( $input['ovaev_show_sidebar'] ) : 'yes';

			if( isset( $input['ovaev_show_search_by_date'] ) )
				$new_input['ovaev_show_search_by_date'] = sanitize_text_field( $input['ovaev_show_search_by_date'] ) ? sanitize_text_field( $input['ovaev_show_search_by_date'] ) : 'yes';

			if( isset( $input['ovaev_show_search_by_category'] ) )
				$new_input['ovaev_show_search_by_category'] = sanitize_text_field( $input['ovaev_show_search_by_category'] ) ? sanitize_text_field( $input['ovaev_show_search_by_category'] ) : 'yes';

			if( isset( $input['ovaev_archive_show_thumbnail'] ) )
				$new_input['ovaev_archive_show_thumbnail'] = sanitize_text_field( $input['ovaev_archive_show_thumbnail'] ) ? sanitize_text_field( $input['ovaev_archive_show_thumbnail'] ) : 'yes';

			if( isset( $input['ovaev_archive_show_date'] ) )
				$new_input['ovaev_archive_show_date'] = sanitize_text_field( $input['ovaev_archive_show_date'] ) ? sanitize_text_field( $input['ovaev_archive_show_date'] ) : 'yes';

			if( isset( $input['ovaev_archive_show_hour'] ) )
				$new_input['ovaev_archive_show_hour'] = sanitize_text_field( $input['ovaev_archive_show_hour'] ) ? sanitize_text_field( $input['ovaev_archive_show_hour'] ) : 'yes';

			if( isset( $input['ovaev_archive_show_location'] ) )
				$new_input['ovaev_archive_show_location'] = sanitize_text_field( $input['ovaev_archive_show_location'] ) ? sanitize_text_field( $input['ovaev_archive_show_location'] ) : 'yes';

			if( isset( $input['ovaev_archive_show_title'] ) )
				$new_input['ovaev_archive_show_title'] = sanitize_text_field( $input['ovaev_archive_show_title'] ) ? sanitize_text_field( $input['ovaev_archive_show_title'] ) : 'yes';

			if( isset( $input['ovaev_archive_show_short_desc'] ) )
				$new_input['ovaev_archive_show_short_desc'] = sanitize_text_field( $input['ovaev_archive_show_short_desc'] ) ? sanitize_text_field( $input['ovaev_archive_show_short_desc'] ) : 'yes';

			if( isset( $input['ovaev_archive_show_link_to'] ) )
				$new_input['ovaev_archive_show_link_to'] = sanitize_text_field( $input['ovaev_archive_show_link_to'] ) ? sanitize_text_field( $input['ovaev_archive_show_link_to'] ) : 'yes';


			// single
			if( isset( $input['ovaev_get_template_single'] ) )
				$new_input['ovaev_get_template_single'] = sanitize_text_field( $input['ovaev_get_template_single'] ) ? sanitize_text_field( $input['ovaev_get_template_single'] ) : 'default';

			if( isset( $input['ovaev_show_sidebar_single'] ) )
				$new_input['ovaev_show_sidebar_single'] = sanitize_text_field( $input['ovaev_show_sidebar_single'] ) ? sanitize_text_field( $input['ovaev_show_sidebar_single'] ) : 'yes';

			if( isset( $input['single_event_header'] ) )
				$new_input['single_event_header'] = sanitize_text_field( $input['single_event_header'] ) ? sanitize_text_field( $input['single_event_header'] ) : 'default';

			if( isset( $input['single_event_footer'] ) )
				$new_input['single_event_footer'] = sanitize_text_field( $input['single_event_footer'] ) ? sanitize_text_field( $input['single_event_footer'] ) : 'default';

			if( isset( $input['google_key_map'] ) )
				$new_input['google_key_map'] = sanitize_text_field( $input['google_key_map'] ) ? sanitize_text_field( $input['google_key_map'] ) : '';

			if( isset( $input['event_map_zoom'] ) )
				$new_input['event_map_zoom'] = sanitize_text_field( $input['event_map_zoom'] ) ? sanitize_text_field( $input['event_map_zoom'] ) : '18';

			if( isset( $input['ovaev_show_title_single'] ) )
				$new_input['ovaev_show_title_single'] = sanitize_text_field( $input['ovaev_show_title_single'] ) ? sanitize_text_field( $input['ovaev_show_title_single'] ) : 'yes';

			if( isset( $input['ovaev_single_show_google_calendar'] ) )
			$new_input['ovaev_single_show_google_calendar'] = sanitize_text_field( $input['ovaev_single_show_google_calendar'] ) ? sanitize_text_field( $input['ovaev_single_show_google_calendar'] ) : 'yes';

			if( isset( $input['ovaev_single_show_ical_export'] ) )
			$new_input['ovaev_single_show_ical_export'] = sanitize_text_field( $input['ovaev_single_show_ical_export'] ) ? sanitize_text_field( $input['ovaev_single_show_ical_export'] ) : 'yes';

			if( isset( $input['ovaev_single_show_image'] ) )
			$new_input['ovaev_single_show_image'] = sanitize_text_field( $input['ovaev_single_show_image'] ) ? sanitize_text_field( $input['ovaev_single_show_image'] ) : 'yes';

			if( isset( $input['ovaev_single_show_register_button'] ) )
			$new_input['ovaev_single_show_register_button'] = sanitize_text_field( $input['ovaev_single_show_register_button'] ) ? sanitize_text_field( $input['ovaev_single_show_register_button'] ) : 'yes';

			if( isset( $input['ovaev_single_show_date'] ) )
			$new_input['ovaev_single_show_date'] = sanitize_text_field( $input['ovaev_single_show_date'] ) ? sanitize_text_field( $input['ovaev_single_show_date'] ) : 'yes';

			if( isset( $input['ovaev_single_show_time'] ) )
			$new_input['ovaev_single_show_time'] = sanitize_text_field( $input['ovaev_single_show_time'] ) ? sanitize_text_field( $input['ovaev_single_show_time'] ) : 'yes';

			if( isset( $input['ovaev_single_show_venue'] ) )
			$new_input['ovaev_single_show_venue'] = sanitize_text_field( $input['ovaev_single_show_venue'] ) ? sanitize_text_field( $input['ovaev_single_show_venue'] ) : 'yes';

			if( isset( $input['ovaev_single_show_content'] ) )
			$new_input['ovaev_single_show_content'] = sanitize_text_field( $input['ovaev_single_show_content'] ) ? sanitize_text_field( $input['ovaev_single_show_content'] ) : 'yes';

			if( isset( $input['ovaev_single_show_map'] ) )
			$new_input['ovaev_single_show_map'] = sanitize_text_field( $input['ovaev_single_show_map'] ) ? sanitize_text_field( $input['ovaev_single_show_map'] ) : 'yes';

			if( isset( $input['ovaev_single_show_organizer'] ) )
			$new_input['ovaev_single_show_organizer'] = sanitize_text_field( $input['ovaev_single_show_organizer'] ) ? sanitize_text_field( $input['ovaev_single_show_organizer'] ) : 'yes';

			if( isset( $input['ovaev_single_show_phone'] ) )
			$new_input['ovaev_single_show_phone'] = sanitize_text_field( $input['ovaev_single_show_phone'] ) ? sanitize_text_field( $input['ovaev_single_show_phone'] ) : 'yes';

			if( isset( $input['ovaev_single_show_email'] ) )
			$new_input['ovaev_single_show_email'] = sanitize_text_field( $input['ovaev_single_show_email'] ) ? sanitize_text_field( $input['ovaev_single_show_email'] ) : 'yes';

			if( isset( $input['ovaev_single_show_website'] ) )
			$new_input['ovaev_single_show_website'] = sanitize_text_field( $input['ovaev_single_show_website'] ) ? sanitize_text_field( $input['ovaev_single_show_website'] ) : 'yes';

			if( isset( $input['ovaev_single_show_gallery'] ) )
			$new_input['ovaev_single_show_gallery'] = sanitize_text_field( $input['ovaev_single_show_gallery'] ) ? sanitize_text_field( $input['ovaev_single_show_gallery'] ) : 'yes';

			if( isset( $input['ovaev_single_show_share'] ) )
			$new_input['ovaev_single_show_share'] = sanitize_text_field( $input['ovaev_single_show_share'] ) ? sanitize_text_field( $input['ovaev_single_show_share'] ) : 'yes';

			if( isset( $input['ovaev_single_show_next_prev'] ) )
			$new_input['ovaev_single_show_next_prev'] = sanitize_text_field( $input['ovaev_single_show_next_prev'] ) ? sanitize_text_field( $input['ovaev_single_show_next_prev'] ) : 'yes';

			if( isset( $input['ovaev_single_show_related'] ) )
			$new_input['ovaev_single_show_related'] = sanitize_text_field( $input['ovaev_single_show_related'] ) ? sanitize_text_field( $input['ovaev_single_show_related'] ) : 'yes';

			if( isset( $input['ovaev_single_show_comment'] ) )
			$new_input['ovaev_single_show_comment'] = sanitize_text_field( $input['ovaev_single_show_comment'] ) ? sanitize_text_field( $input['ovaev_single_show_comment'] ) : 'yes';
		

			return $new_input;
		}


		public static function create_admin_setting_page() { ?>
			<div class="wrap">
				<h1><?php esc_html_e( "Event Settings", "ovaev" ); ?></h1>

				<form method="post" action="options.php">

					<div id="tabs">

						<?php settings_fields( 'ovaev_options_group' ); // Options group ?>

						<!-- Menu Tab -->
						<ul>
							<li><a href="#ovaev_general_settings"><?php esc_html_e( 'General Settings', 'ovaev' ); ?></a></li>
							<li><a href="#ovaev_event_settings"><?php esc_html_e( 'Event Settings', 'ovaev' ); ?></a></li>
						</ul>

						<!-- General Settings -->  
						<div id="ovaev_general_settings" class="ovaev_admin_settings">
							<?php do_settings_sections( 'ovaev_general_settings' ); // Page ?>
						</div>

						<!-- Event Settings -->  
						<div id="ovaev_event_settings" class="ovaev_admin_settings">
							<?php do_settings_sections( 'ovaev_archive_event_settings' ); // Page ?>
							<hr>
							<?php do_settings_sections( 'ovaev_single_event_settings' ); // Page ?>
						</div>

					</div>

					<?php submit_button(); ?>
				</form>
			</div>

		<?php }


		/***** Archive Event Settings *****/
		public function ovaev_show_past(){
			$ovaev_show_past = OVAEV_Settings::ovaev_show_past();
			$ovaev_show_past = isset( $ovaev_show_past ) ? $ovaev_show_past : 'yes';

			$yes = ( 'yes' == $ovaev_show_past ) ? 'selected' : '';
			$no  = ( 'no' == $ovaev_show_past ) ? 'selected' : '';

			?>
			<select name="ovaev_options[ovaev_show_past]" id="ovaev_show_past">
				<option <?php echo esc_attr($yes) ?> value="yes"><?php echo esc_html__('Yes', 'ovaev') ?></option>
				<option <?php echo esc_attr($no) ?> value="no"><?php echo esc_html__('No', 'ovaev') ?></option>
			</select>
			<?php
		}

		public function archive_event_header(){
			$archive_event_header = OVAEV_Settings::archive_event_header();
			$lits_headers = apply_filters('gimont_list_header', '');
			?>
			<select name="ovaev_options[archive_event_header]" id="archive_event_header">
				<?php if( ! empty( $lits_headers ) ){
					foreach( $lits_headers as $key => $val  ){
						$selected = ($archive_event_header == $key) ? 'selected' : '';
					?>
					<option <?php echo esc_attr( $selected ) ?> value="<?php echo esc_attr( $key ) ?>">
						<?php echo esc_html( $val ) ?>
					</option>
					<?php
					}
				} ?>
			</select>
			<?php
		}

		public function archive_event_footer(){
			$archive_event_footer = OVAEV_Settings::archive_event_footer(); 
			$lits_headers = apply_filters('gimont_list_footer', '');
			?>
			<select name="ovaev_options[archive_event_footer]" id="archive_event_footer">
				<?php if( ! empty( $lits_headers ) ){
					foreach( $lits_headers as $key => $val  ){
						$selected = ($archive_event_footer == $key) ? 'selected' : '';
					?>
					<option <?php echo esc_attr( $selected ) ?> value="<?php echo esc_attr( $key ) ?>">
						<?php echo esc_html( $val ) ?>
					</option>
					<?php
					}
				} ?>
			</select>
			<?php
		}

		public function archive_event_posts_per_page() {
			$archive_event_posts_per_page = OVAEV_Settings::archive_event_posts_per_page();

				if (! $archive_event_posts_per_page) {
					$archive_event_posts_per_page = 6;
				}
			?>

			<input type="number" name="ovaev_options[archive_event_posts_per_page]" id="archive_event_posts_per_page"
				value="<?php esc_attr_e( $archive_event_posts_per_page ); ?>" min="-1" max="10" step="1" 
			/>
			<?php
		}

		public function archive_event_orderby(){
			$archive_event_orderby = OVAEV_Settings::archive_event_orderby();
			$archive_event_orderby = isset( $archive_event_orderby ) ? $archive_event_orderby : 'title';

			$title             = ( 'title' == $archive_event_orderby) ? 'selected' : '';
			$event_custom_sort = ( 'event_custom_sort' == $archive_event_orderby) ? 'selected' : '';
			$ovaev_start_date  = ( 'ovaev_start_date' == $archive_event_orderby) ? 'selected' : '';
			$id                = ( 'ID' == $archive_event_orderby) ? 'selected' : '';

			?>
			<select name="ovaev_options[archive_event_orderby]" id="archive_event_orderby">
				<option <?php echo esc_attr($title) ?> value="title"><?php echo esc_html__('Title', 'ovaev') ?></option>
				<option <?php echo esc_attr($event_custom_sort) ?> value="event_custom_sort"><?php echo esc_html__('Custom Sort', 'ovaev') ?></option>
				<option <?php echo esc_attr($ovaev_start_date) ?> value="ovaev_start_date"><?php echo esc_html__('Start Date', 'ovaev') ?></option>
				<option <?php echo esc_attr($id) ?> value="ID"><?php echo esc_html__('ID', 'ovaev') ?></option>
			</select>
			<?php
		}

		public function archive_event_order(){
			$archive_event_order = OVAEV_Settings::archive_event_order(); 	
			$archive_event_order = isset( $archive_event_order ) ? $archive_event_order : 'ASC';

			$asc_selected  = ('ASC' == $archive_event_order) ? 'selected' : '';
			$desc_selected = ('DESC' == $archive_event_order) ? 'selected' : '';

			?>
			<select name="ovaev_options[archive_event_order]" id="archive_event_order">
				<option <?php echo esc_attr($asc_selected) ?> value="ASC"><?php echo esc_html__('Increasing', 'ovaev') ?></option>
				<option <?php echo esc_attr($desc_selected) ?> value="DESC"><?php echo esc_html__('Decreasing', 'ovaev') ?></option>
			</select>
			<?php
		}


		public function archive_event_type(){
			$archive_event_type = OVAEV_Settings::archive_event_type(); 	
			$archive_event_type = isset( $archive_event_type ) ? $archive_event_type : 'type1';

			$type1 = ('type1' == $archive_event_type) ? 'selected' : '';
			$type2 = ('type2' == $archive_event_type) ? 'selected' : '';
			$type3 = ('type3' == $archive_event_type) ? 'selected' : '';
			$type4 = ('type4' == $archive_event_type) ? 'selected' : '';
			$type5 = ('type5' == $archive_event_type) ? 'selected' : '';
			$type6 = ('type6' == $archive_event_type) ? 'selected' : '';
			$type7 = ('type7' == $archive_event_type) ? 'selected' : '';

			?>
			<select name="ovaev_options[archive_event_type]" id="archive_event_type">
				<option <?php echo esc_attr($type1) ?> value="type1"><?php echo esc_html__('Type 1', 'ovaev') ?></option>
				<option <?php echo esc_attr($type2) ?> value="type2"><?php echo esc_html__('Type 2', 'ovaev') ?></option>
				<option <?php echo esc_attr($type3) ?> value="type3"><?php echo esc_html__('Type 3', 'ovaev') ?></option>
				<option <?php echo esc_attr($type4) ?> value="type4"><?php echo esc_html__('Type 4', 'ovaev') ?></option>
				<option <?php echo esc_attr($type5) ?> value="type5"><?php echo esc_html__('Type 5', 'ovaev') ?></option>
				<option <?php echo esc_attr($type6) ?> value="type6"><?php echo esc_html__('Type 6', 'ovaev') ?></option>
				<option <?php echo esc_attr($type7) ?> value="type7"><?php echo esc_html__('Type 7', 'ovaev') ?></option>
			</select>
			<?php
		}

		public function archive_event_col(){
			$archive_event_col = OVAEV_Settings::archive_event_col(); 	
			$archive_event_col = isset( $archive_event_col ) ? $archive_event_col : 'ASC';

			$col1 = ('col1' == $archive_event_col) ? 'selected' : '';
			$col2 = ('col2' == $archive_event_col) ? 'selected' : '';
			$col3 = ('col3' == $archive_event_col) ? 'selected' : '';

			?>
			<select name="ovaev_options[archive_event_col]" id="archive_event_col">
				<option <?php echo esc_attr($col1) ?> value="col1"><?php echo esc_html__('Column 1', 'ovaev') ?></option>
				<option <?php echo esc_attr($col2) ?> value="col2"><?php echo esc_html__('Column 2', 'ovaev') ?></option>
				<option <?php echo esc_attr($col3) ?> value="col3"><?php echo esc_html__('Column 3', 'ovaev') ?></option>
			</select>
			<?php
		}

		public function ovaev_show_sidebar(){
			$ovaev_show_sidebar = OVAEV_Settings::ovaev_show_sidebar();
			$ovaev_show_sidebar = isset( $ovaev_show_sidebar ) ? $ovaev_show_sidebar : 'no';

			$yes = ( 'yes' == $ovaev_show_sidebar ) ? 'selected' : '';
			$no  = ( 'no' == $ovaev_show_sidebar ) ? 'selected' : '';

			?>
			<select name="ovaev_options[ovaev_show_sidebar]" id="ovaev_show_sidebar">
				<option <?php echo esc_attr($yes) ?> value="yes"><?php echo esc_html__('Yes', 'ovaev') ?></option>
				<option <?php echo esc_attr($no) ?> value="no"><?php echo esc_html__('No', 'ovaev') ?></option>
			</select>
			<?php
		}

		public function archive_event_thumbnail(){
			$archive_event_thumbnail =  esc_attr( OVAEV_Settings::archive_event_thumbnail() );
			printf(
				'<input type="text" id="archive_event_thumbnail"  name="ovaev_options[archive_event_thumbnail]" value="%s" />',
				isset( $archive_event_thumbnail ) ? $archive_event_thumbnail : ''
			);

			echo '<br/>'; 
			esc_html_e('Example: 600x400', 'ovaev');
		}

		public function ovaev_show_search_by_date(){
			$ovaev_show_search_by_date = OVAEV_Settings::ovaev_show_search_by_date();
			$ovaev_show_search_by_date = isset( $ovaev_show_search_by_date ) ? $ovaev_show_search_by_date : 'yes';

			$yes = ( 'yes' == $ovaev_show_search_by_date ) ? 'selected' : '';
			$no  = ( 'no' == $ovaev_show_search_by_date ) ? 'selected' : '';

			?>
			<select name="ovaev_options[ovaev_show_search_by_date]" id="ovaev_show_search_by_date">
				<option <?php echo esc_attr($yes) ?> value="yes"><?php echo esc_html__('Yes', 'ovaev') ?></option>
				<option <?php echo esc_attr($no) ?> value="no"><?php echo esc_html__('No', 'ovaev') ?></option>
			</select>
			<?php
		}

		public function ovaev_show_search_by_category(){
			$ovaev_show_search_by_category = OVAEV_Settings::ovaev_show_search_by_category();
			$ovaev_show_search_by_category = isset( $ovaev_show_search_by_category ) ? $ovaev_show_search_by_category : 'yes';

			$yes = ( 'yes' == $ovaev_show_search_by_category ) ? 'selected' : '';
			$no  = ( 'no' == $ovaev_show_search_by_category ) ? 'selected' : '';

			?>
			<select name="ovaev_options[ovaev_show_search_by_category]" id="ovaev_show_search_by_category">
				<option <?php echo esc_attr($yes) ?> value="yes"><?php echo esc_html__('Yes', 'ovaev') ?></option>
				<option <?php echo esc_attr($no) ?> value="no"><?php echo esc_html__('No', 'ovaev') ?></option>
			</select>
			<?php
		}

		public function ovaev_archive_show_thumbnail(){
			$ovaev_archive_show_thumbnail = OVAEV_Settings::ovaev_archive_show_thumbnail();
			$ovaev_archive_show_thumbnail = isset( $ovaev_archive_show_thumbnail ) ? $ovaev_archive_show_thumbnail : 'yes';

			$yes = ( 'yes' == $ovaev_archive_show_thumbnail ) ? 'selected' : '';
			$no  = ( 'no' == $ovaev_archive_show_thumbnail ) ? 'selected' : '';

			?>
			<select name="ovaev_options[ovaev_archive_show_thumbnail]" id="ovaev_archive_show_thumbnail">
				<option <?php echo esc_attr($yes) ?> value="yes"><?php echo esc_html__('Yes', 'ovaev') ?></option>
				<option <?php echo esc_attr($no) ?> value="no"><?php echo esc_html__('No', 'ovaev') ?></option>
			</select>
			<?php
		}

		public function ovaev_archive_show_date(){
			$ovaev_archive_show_date = OVAEV_Settings::ovaev_archive_show_date();
			$ovaev_archive_show_date = isset( $ovaev_archive_show_date ) ? $ovaev_archive_show_date : 'yes';

			$yes = ( 'yes' == $ovaev_archive_show_date ) ? 'selected' : '';
			$no  = ( 'no' == $ovaev_archive_show_date ) ? 'selected' : '';

			?>
			<select name="ovaev_options[ovaev_archive_show_date]" id="ovaev_archive_show_date">
				<option <?php echo esc_attr($yes) ?> value="yes"><?php echo esc_html__('Yes', 'ovaev') ?></option>
				<option <?php echo esc_attr($no) ?> value="no"><?php echo esc_html__('No', 'ovaev') ?></option>
			</select>
			<?php
		}

		public function ovaev_archive_show_hour(){
			$ovaev_archive_show_hour = OVAEV_Settings::ovaev_archive_show_hour();
			$ovaev_archive_show_hour = isset( $ovaev_archive_show_hour ) ? $ovaev_archive_show_hour : 'yes';

			$yes = ( 'yes' == $ovaev_archive_show_hour ) ? 'selected' : '';
			$no  = ( 'no' == $ovaev_archive_show_hour ) ? 'selected' : '';

			?>
			<select name="ovaev_options[ovaev_archive_show_hour]" id="ovaev_archive_show_hour">
				<option <?php echo esc_attr($yes) ?> value="yes"><?php echo esc_html__('Yes', 'ovaev') ?></option>
				<option <?php echo esc_attr($no) ?> value="no"><?php echo esc_html__('No', 'ovaev') ?></option>
			</select>
			<?php
		}

		public function ovaev_archive_show_location(){
			$ovaev_archive_show_location = OVAEV_Settings::ovaev_archive_show_location();
			$ovaev_archive_show_location = isset( $ovaev_archive_show_location ) ? $ovaev_archive_show_location : 'yes';

			$yes = ( 'yes' == $ovaev_archive_show_location ) ? 'selected' : '';
			$no  = ( 'no' == $ovaev_archive_show_location ) ? 'selected' : '';

			?>
			<select name="ovaev_options[ovaev_archive_show_location]" id="ovaev_archive_show_location">
				<option <?php echo esc_attr($yes) ?> value="yes"><?php echo esc_html__('Yes', 'ovaev') ?></option>
				<option <?php echo esc_attr($no) ?> value="no"><?php echo esc_html__('No', 'ovaev') ?></option>
			</select>
			<?php
		}

		public function ovaev_archive_show_title(){
			$ovaev_archive_show_title = OVAEV_Settings::ovaev_archive_show_title();
			$ovaev_archive_show_title = isset( $ovaev_archive_show_title ) ? $ovaev_archive_show_title : 'yes';

			$yes = ( 'yes' == $ovaev_archive_show_title ) ? 'selected' : '';
			$no  = ( 'no' == $ovaev_archive_show_title ) ? 'selected' : '';

			?>
			<select name="ovaev_options[ovaev_archive_show_title]" id="ovaev_archive_show_title">
				<option <?php echo esc_attr($yes) ?> value="yes"><?php echo esc_html__('Yes', 'ovaev') ?></option>
				<option <?php echo esc_attr($no) ?> value="no"><?php echo esc_html__('No', 'ovaev') ?></option>
			</select>
			<?php
		}

		public function ovaev_archive_show_short_desc(){
			$ovaev_archive_show_short_desc = OVAEV_Settings::ovaev_archive_show_short_desc();
			$ovaev_archive_show_short_desc = isset( $ovaev_archive_show_short_desc ) ? $ovaev_archive_show_short_desc : 'yes';

			$yes = ( 'yes' == $ovaev_archive_show_short_desc ) ? 'selected' : '';
			$no  = ( 'no' == $ovaev_archive_show_short_desc ) ? 'selected' : '';

			?>
			<select name="ovaev_options[ovaev_archive_show_short_desc]" id="ovaev_archive_show_short_desc">
				<option <?php echo esc_attr($yes) ?> value="yes"><?php echo esc_html__('Yes', 'ovaev') ?></option>
				<option <?php echo esc_attr($no) ?> value="no"><?php echo esc_html__('No', 'ovaev') ?></option>
			</select>
			<?php
		}

		public function ovaev_archive_show_link_to(){
			$ovaev_archive_show_link_to = OVAEV_Settings::ovaev_archive_show_link_to();
			$ovaev_archive_show_link_to = isset( $ovaev_archive_show_link_to ) ? $ovaev_archive_show_link_to : 'yes';

			$yes = ( 'yes' == $ovaev_archive_show_link_to ) ? 'selected' : '';
			$no  = ( 'no' == $ovaev_archive_show_link_to ) ? 'selected' : '';

			?>
			<select name="ovaev_options[ovaev_archive_show_link_to]" id="ovaev_archive_show_link_to">
				<option <?php echo esc_attr($yes) ?> value="yes"><?php echo esc_html__('Yes', 'ovaev') ?></option>
				<option <?php echo esc_attr($no) ?> value="no"><?php echo esc_html__('No', 'ovaev') ?></option>
			</select>
			<?php
		}

		public function archive_event_format_date(){

			$archive_event_format_date = OVAEV_Settings::archive_event_format_date() ? OVAEV_Settings::archive_event_format_date() : 'd-m-Y';

			$date_format = apply_filters( 'ovaev_date_format' ,array(
				'd-m-Y'	=> 'd-m-Y',
				'm/d/Y'	=> 'm/d/Y',
				'Y/m/d'	=> 'Y/m/d',
				'Y-m-d'	=> 'Y-m-d',
			) );
		?>

			<select name="ovaev_options[archive_event_format_date]">
				<?php foreach ($date_format as $key => $value) { ?>
					<?php $selected = ( $archive_event_format_date == $key ) ? 'selected' : ''; ?>
					<option value="<?php echo $key; ?>" <?php echo $selected ?> >
						<?php echo $value; ?>
					</option>
				<?php } ?>
			</select>
			
		<?php 
		}

		public function archive_event_format_time(){

			$archive_event_format_time = OVAEV_Settings::archive_event_format_time() ? OVAEV_Settings::archive_event_format_time() : 'H:i';

			$time_format = apply_filters( 'ovaev_time_format', array(

				'H:i'	=> 'H:i'.' '.esc_html__( '24 hour', 'ovaev' ),
				'g:i A'	=> 'g:i A'.' '.esc_html__( '12 hour', 'ovaev' ),
				'g:i a'	=> 'g:i a'.' '.esc_html__( '12 hour', 'ovaev' ),
				
			) );
			?>

			<select name="ovaev_options[archive_event_format_time]">
				<?php foreach ($time_format as $key => $value) { ?>
					<?php $selected = ( $archive_event_format_time == $key ) ? 'selected' : ''; ?>
					<option value="<?php echo $key; ?>" <?php echo $selected ?> >
						<?php echo $value; ?>
					</option>
				<?php } ?>
			</select>

			
		<?php	
		}

		public function archive_format_date_lang(){
			$archive_format_date_lang = OVAEV_Settings::archive_format_date_lang() ? OVAEV_Settings::archive_format_date_lang() : 'en';

			$langauges = array(
				'ar'	=> esc_html__( 'Arabic', 'ovaev' ),
				'az'	=> esc_html__( 'Azerbaijanian', 'ovaev' ),
				'bg'	=> esc_html__( 'Bulgarian', 'ovaev' ),
				'bs'	=> esc_html__( 'Bosanski', 'ovaev' ),
				'ca'	=> esc_html__( 'Català', 'ovaev' ),
				'ch'	=> esc_html__( 'Simplified Chinese', 'ovaev' ),
				'cs'	=> esc_html__( 'Čeština', 'ovaev' ),
				'da'	=> esc_html__( 'Dansk', 'ovaev' ),
				'de'	=> esc_html__( 'German', 'ovaev' ),
				'el'	=> esc_html__( 'Ελληνικά', 'ovaev' ),
				'en'	=> esc_html__( 'English', 'ovaev' ),
				'en-GB'	=> esc_html__( 'English(British)', 'ovaev' ),
				'es'	=> esc_html__( 'Spanish', 'ovaev' ),
				'et'	=> esc_html__( 'Eesti', 'ovaev' ),
				'eu'	=> esc_html__( 'Euskara', 'ovaev' ),
				'fa'	=> esc_html__( 'Finnish(Suomi)', 'ovaev' ),
				'fr'	=> esc_html__( 'French', 'ovaev' ),
				'gl'	=> esc_html__( 'Galego', 'ovaev' ),
				'he'	=> esc_html__( 'Hebrew', 'ovaev' ),
				'hr'	=> esc_html__( 'Hrvatski', 'ovaev' ),
				'hu'	=> esc_html__( 'Hungarian', 'ovaev' ),
				'id'	=> esc_html__( 'Indonesian', 'ovaev' ),
				'it'	=> esc_html__( 'Italian', 'ovaev' ),
				'ja'	=> esc_html__( 'Japanese', 'ovaev' ),
				'ko'	=> esc_html__( 'Korean', 'ovaev' ),
				'kr'	=> esc_html__( 'Korean', 'ovaev' ),
				'lt'	=> esc_html__( 'Lithuanian', 'ovaev' ),
				'lv'	=> esc_html__( 'Latvian', 'ovaev' ),
				'mk'	=> esc_html__( 'Macedonian', 'ovaev' ),
				'mn'	=> esc_html__( 'Mongolian', 'ovaev' ),
				'nl'	=> esc_html__( 'Dutch', 'ovaev' ),
				'no'	=> esc_html__( 'Norwegian', 'ovaev' ),
				'pl'	=> esc_html__( 'Polish', 'ovaev' ),
				'pt'	=> esc_html__( 'Portuguese', 'ovaev' ),
				'pt-BR'	=> esc_html__( 'Português', 'ovaev' ),
				'ro'	=> esc_html__( 'Romanian', 'ovaev' ),
				'ru'	=> esc_html__( 'Russian', 'ovaev' ),
				'se'	=> esc_html__( 'Swedish', 'ovaev' ),
				'sk'	=> esc_html__( 'Slovenčina', 'ovaev' ),
				'sl'	=> esc_html__( 'Slovenščina', 'ovaev' ),
				'sq'	=> esc_html__( 'Albanian', 'ovaev' ),
				'sr'	=> esc_html__( 'Serbian', 'ovaev' ),
				'sr-YU'	=> esc_html__( 'Serbian (Srpski)', 'ovaev' ),
				'sv'	=> esc_html__( 'Svenska', 'ovaev' ),
				'th'	=> esc_html__( 'Thai', 'ovaev' ),
				'tr'	=> esc_html__( 'Turkish', 'ovaev' ),
				'uk'	=> esc_html__( 'Ukrainian', 'ovaev' ),
				'vi'	=> esc_html__( 'Vietnamese', 'ovaev' ),
				'zh'	=> esc_html__( 'Simplified Chinese ', 'ovaev' ),
				'zh-TW'	=> esc_html__( 'Traditional Chinese', 'ovaev' )
			);
			?>
			<select name="ovaev_options[archive_format_date_lang]">
				<?php foreach ($langauges as $key => $value) { ?>
					<?php $selected = ( $archive_format_date_lang == $key ) ? 'selected' : ''; ?>
					<option value="<?php echo $key; ?>" <?php echo $selected ?> >
						<?php echo $value; ?>
					</option>
				<?php } ?>
			</select>

			
		<?php }


		/*****  Single Event Settings *****/
		public function single_event_header(){
			$single_event_header = OVAEV_Settings::single_event_header(); 
			$lits_headers = apply_filters('gimont_list_header', '');
			?>
			<select name="ovaev_options[single_event_header]" id="single_event_header">
				<?php if( ! empty( $lits_headers ) ){
					foreach( $lits_headers as $key => $val  ){
						$selected = ($single_event_header == $key) ? 'selected' : '';
					?>
					<option <?php echo esc_attr( $selected ) ?> value="<?php echo esc_attr( $key ) ?>">
						<?php echo esc_html( $val ) ?>
					</option>
					<?php
					}
				} ?>
			</select>
			<?php
		}

		public function single_event_footer(){
			$single_event_footer = OVAEV_Settings::single_event_footer(); 
			$lits_headers = apply_filters('gimont_list_footer', '');
			?>
			<select name="ovaev_options[single_event_footer]" id="single_event_footer">
				<?php if( ! empty( $lits_headers ) ){
					foreach( $lits_headers as $key => $val  ){
						$selected = ($single_event_footer == $key) ? 'selected' : '';
					?>
					<option <?php echo esc_attr( $selected ) ?> value="<?php echo esc_attr( $key ) ?>">
						<?php echo esc_html( $val ) ?>
					</option>
					<?php
					}
				} ?>
			</select>
			<?php
		}

		public function ovaev_get_template_single(){
			$ovaev_get_template_single = OVAEV_Settings::ovaev_get_template_single();
			$ovaev_get_template_single = isset( $ovaev_get_template_single ) ? $ovaev_get_template_single : 'default';

			$selected = ( 'default' == $ovaev_get_template_single ) ? ' selected ' : '';

			$args = array(
			  	'post_type'      => 'elementor_library',
			  	'posts_per_page' => -1,
			  	'tabs_group' => 'library',
			  	'elementor_library_type' => 'page',
			);

			$templates = get_posts($args);

			?>
			<div class="ovaev_template_single">
				<select name="ovaev_options[ovaev_get_template_single]" id="ovaev_get_template_single">
					<option <?php echo esc_attr( $selected ); ?> value="default"><?php echo esc_html__('Default', 'ovaev') ?></option>
					<?php if ( ! empty( $templates ) ):
						foreach( $templates as $template ):
							$id 		= $template->ID;
							$title 		= $template->post_title;
							$selected 	= ( $id == $ovaev_get_template_single ) ? ' selected ' : '';
					?>
						<option <?php echo esc_attr( $selected ); ?> value="<?php echo esc_attr( $id ); ?>"><?php echo esc_html( $title ); ?></option>
					<?php  endforeach; endif; ?>
				</select>
				<?php
				echo '<br/>'; 
				esc_html_e('Default or Other (made in Templates of Elementor )', 'ovaev');
			?>
			</div>
			<?php
		}

		public function google_key_map(){
			$google_key_map =  esc_attr( OVAEV_Settings::google_key_map() );
			printf(
				'<input type="text" id="google_key_map"  name="ovaev_options[google_key_map]" value="%s" />',
				isset( $google_key_map ) ? $google_key_map : ''
			);

			echo '<br/>'; 
			esc_html_e('You can get here: https://developers.google.com/maps/documentation/javascript/get-api-key', 'ovaev');
		}

		public function event_map_zoom(){
			$event_map_zoom = OVAEV_Settings::event_map_zoom();
			$event_map_zoom = isset( $event_map_zoom ) ? $event_map_zoom : '18';

			printf(
				'<input type="number" id="event_map_zoom" name="ovaev_options[event_map_zoom]" value="%s" />',
				isset( $event_map_zoom ) ? $event_map_zoom : '18'
			);
		}

			public function ovaev_show_sidebar_single(){
			$ovaev_show_sidebar_single = OVAEV_Settings::ovaev_show_sidebar_single();
			$ovaev_show_sidebar_single = isset( $ovaev_show_sidebar_single ) ? $ovaev_show_sidebar_single : 'yes';

			$yes = ( 'yes' == $ovaev_show_sidebar_single ) ? 'selected' : '';
			$no  = ( 'no' == $ovaev_show_sidebar_single ) ? 'selected' : '';

			?>
			<select name="ovaev_options[ovaev_show_sidebar_single]" id="ovaev_show_sidebar_single">
				<option <?php echo esc_attr($yes) ?> value="yes"><?php echo esc_html__('Yes', 'ovaev') ?></option>
				<option <?php echo esc_attr($no) ?> value="no"><?php echo esc_html__('No', 'ovaev') ?></option>
			</select>
			<?php
		}

		public function ovaev_show_title_single(){
			$ovaev_show_title_single = OVAEV_Settings::ovaev_show_title_single();
			$ovaev_show_title_single = isset( $ovaev_show_title_single ) ? $ovaev_show_title_single : 'yes';

			$yes = ( 'yes' == $ovaev_show_title_single ) ? 'selected' : '';
			$no  = ( 'no' == $ovaev_show_title_single ) ? 'selected' : '';

			?>
			<select name="ovaev_options[ovaev_show_title_single]" id="ovaev_show_title_single">
				<option <?php echo esc_attr($yes) ?> value="yes"><?php echo esc_html__('Yes', 'ovaev') ?></option>
				<option <?php echo esc_attr($no) ?> value="no"><?php echo esc_html__('No', 'ovaev') ?></option>
			</select>
			<?php
		}

		public function ovaev_single_show_google_calendar(){
			$ovaev_single_show_google_calendar = OVAEV_Settings::ovaev_single_show_google_calendar();
			$ovaev_single_show_google_calendar = isset( $ovaev_single_show_google_calendar ) ? $ovaev_single_show_google_calendar : 'yes';

			$yes = ( 'yes' == $ovaev_single_show_google_calendar ) ? 'selected' : '';
			$no  = ( 'no' == $ovaev_single_show_google_calendar ) ? 'selected' : '';

			?>
			<select name="ovaev_options[ovaev_single_show_google_calendar]" id="ovaev_single_show_google_calendar">
				<option <?php echo esc_attr($yes) ?> value="yes"><?php echo esc_html__('Yes', 'ovaev') ?></option>
				<option <?php echo esc_attr($no) ?> value="no"><?php echo esc_html__('No', 'ovaev') ?></option>
			</select>
			<?php
		}

		public function ovaev_single_show_ical_export(){
			$ovaev_single_show_ical_export = OVAEV_Settings::ovaev_single_show_ical_export();
			$ovaev_single_show_ical_export = isset( $ovaev_single_show_ical_export ) ? $ovaev_single_show_ical_export : 'yes';

			$yes = ( 'yes' == $ovaev_single_show_ical_export ) ? 'selected' : '';
			$no  = ( 'no' == $ovaev_single_show_ical_export ) ? 'selected' : '';

			?>
			<select name="ovaev_options[ovaev_single_show_ical_export]" id="ovaev_single_show_ical_export">
				<option <?php echo esc_attr($yes) ?> value="yes"><?php echo esc_html__('Yes', 'ovaev') ?></option>
				<option <?php echo esc_attr($no) ?> value="no"><?php echo esc_html__('No', 'ovaev') ?></option>
			</select>
			<?php
		}

		public function ovaev_single_show_image(){
			$ovaev_single_show_image = OVAEV_Settings::ovaev_single_show_image();
			$ovaev_single_show_image = isset( $ovaev_single_show_image ) ? $ovaev_single_show_image : 'yes';

			$yes = ( 'yes' == $ovaev_single_show_image ) ? 'selected' : '';
			$no  = ( 'no' == $ovaev_single_show_image ) ? 'selected' : '';

			?>
			<select name="ovaev_options[ovaev_single_show_image]" id="ovaev_single_show_image">
				<option <?php echo esc_attr($yes) ?> value="yes"><?php echo esc_html__('Yes', 'ovaev') ?></option>
				<option <?php echo esc_attr($no) ?> value="no"><?php echo esc_html__('No', 'ovaev') ?></option>
			</select>
			<?php
		}

		public function ovaev_single_show_register_button(){
			$ovaev_single_show_register_button = OVAEV_Settings::ovaev_single_show_register_button();
			$ovaev_single_show_register_button = isset( $ovaev_single_show_register_button ) ? $ovaev_single_show_register_button : 'yes';

			$yes = ( 'yes' == $ovaev_single_show_register_button ) ? 'selected' : '';
			$no  = ( 'no' == $ovaev_single_show_register_button ) ? 'selected' : '';

			?>
			<select name="ovaev_options[ovaev_single_show_register_button]" id="ovaev_single_show_register_button">
				<option <?php echo esc_attr($yes) ?> value="yes"><?php echo esc_html__('Yes', 'ovaev') ?></option>
				<option <?php echo esc_attr($no) ?> value="no"><?php echo esc_html__('No', 'ovaev') ?></option>
			</select>
			<?php
		}

		public function ovaev_single_show_date(){
			$ovaev_single_show_date = OVAEV_Settings::ovaev_single_show_date();
			$ovaev_single_show_date = isset( $ovaev_single_show_date ) ? $ovaev_single_show_date : 'yes';

			$yes = ( 'yes' == $ovaev_single_show_date ) ? 'selected' : '';
			$no  = ( 'no' == $ovaev_single_show_date ) ? 'selected' : '';

			?>
			<select name="ovaev_options[ovaev_single_show_date]" id="ovaev_single_show_date">
				<option <?php echo esc_attr($yes) ?> value="yes"><?php echo esc_html__('Yes', 'ovaev') ?></option>
				<option <?php echo esc_attr($no) ?> value="no"><?php echo esc_html__('No', 'ovaev') ?></option>
			</select>
			<?php
		}

		public function ovaev_single_show_time(){
			$ovaev_single_show_time = OVAEV_Settings::ovaev_single_show_time();
			$ovaev_single_show_time = isset( $ovaev_single_show_time ) ? $ovaev_single_show_time : 'yes';

			$yes = ( 'yes' == $ovaev_single_show_time ) ? 'selected' : '';
			$no  = ( 'no' == $ovaev_single_show_time ) ? 'selected' : '';

			?>
			<select name="ovaev_options[ovaev_single_show_time]" id="ovaev_single_show_time">
				<option <?php echo esc_attr($yes) ?> value="yes"><?php echo esc_html__('Yes', 'ovaev') ?></option>
				<option <?php echo esc_attr($no) ?> value="no"><?php echo esc_html__('No', 'ovaev') ?></option>
			</select>
			<?php
		}

		public function ovaev_single_show_venue(){
			$ovaev_single_show_venue = OVAEV_Settings::ovaev_single_show_venue();
			$ovaev_single_show_venue = isset( $ovaev_single_show_venue ) ? $ovaev_single_show_venue : 'yes';

			$yes = ( 'yes' == $ovaev_single_show_venue ) ? 'selected' : '';
			$no  = ( 'no' == $ovaev_single_show_venue ) ? 'selected' : '';

			?>
			<select name="ovaev_options[ovaev_single_show_venue]" id="ovaev_single_show_venue">
				<option <?php echo esc_attr($yes) ?> value="yes"><?php echo esc_html__('Yes', 'ovaev') ?></option>
				<option <?php echo esc_attr($no) ?> value="no"><?php echo esc_html__('No', 'ovaev') ?></option>
			</select>
			<?php
		}

		public function ovaev_single_show_content(){
			$ovaev_single_show_content = OVAEV_Settings::ovaev_single_show_content();
			$ovaev_single_show_content = isset( $ovaev_single_show_content ) ? $ovaev_single_show_content : 'yes';

			$yes = ( 'yes' == $ovaev_single_show_content ) ? 'selected' : '';
			$no  = ( 'no' == $ovaev_single_show_content ) ? 'selected' : '';

			?>
			<select name="ovaev_options[ovaev_single_show_content]" id="ovaev_single_show_content">
				<option <?php echo esc_attr($yes) ?> value="yes"><?php echo esc_html__('Yes', 'ovaev') ?></option>
				<option <?php echo esc_attr($no) ?> value="no"><?php echo esc_html__('No', 'ovaev') ?></option>
			</select>
			<?php
		}

		public function ovaev_single_show_map(){
			$ovaev_single_show_map = OVAEV_Settings::ovaev_single_show_map();
			$ovaev_single_show_map = isset( $ovaev_single_show_map ) ? $ovaev_single_show_map : 'yes';

			$yes = ( 'yes' == $ovaev_single_show_map ) ? 'selected' : '';
			$no  = ( 'no' == $ovaev_single_show_map ) ? 'selected' : '';

			?>
			<select name="ovaev_options[ovaev_single_show_map]" id="ovaev_single_show_map">
				<option <?php echo esc_attr($yes) ?> value="yes"><?php echo esc_html__('Yes', 'ovaev') ?></option>
				<option <?php echo esc_attr($no) ?> value="no"><?php echo esc_html__('No', 'ovaev') ?></option>
			</select>
			<?php
		}

		public function ovaev_single_show_organizer(){
			$ovaev_single_show_organizer = OVAEV_Settings::ovaev_single_show_organizer();
			$ovaev_single_show_organizer = isset( $ovaev_single_show_organizer ) ? $ovaev_single_show_organizer : 'yes';

			$yes = ( 'yes' == $ovaev_single_show_organizer ) ? 'selected' : '';
			$no  = ( 'no' == $ovaev_single_show_organizer ) ? 'selected' : '';

			?>
			<select name="ovaev_options[ovaev_single_show_organizer]" id="ovaev_single_show_organizer">
				<option <?php echo esc_attr($yes) ?> value="yes"><?php echo esc_html__('Yes', 'ovaev') ?></option>
				<option <?php echo esc_attr($no) ?> value="no"><?php echo esc_html__('No', 'ovaev') ?></option>
			</select>
			<?php
		}

		public function ovaev_single_show_phone(){
			$ovaev_single_show_phone = OVAEV_Settings::ovaev_single_show_phone();
			$ovaev_single_show_phone = isset( $ovaev_single_show_phone ) ? $ovaev_single_show_phone : 'yes';

			$yes = ( 'yes' == $ovaev_single_show_phone ) ? 'selected' : '';
			$no  = ( 'no' == $ovaev_single_show_phone ) ? 'selected' : '';

			?>
			<select name="ovaev_options[ovaev_single_show_phone]" id="ovaev_single_show_phone">
				<option <?php echo esc_attr($yes) ?> value="yes"><?php echo esc_html__('Yes', 'ovaev') ?></option>
				<option <?php echo esc_attr($no) ?> value="no"><?php echo esc_html__('No', 'ovaev') ?></option>
			</select>
			<?php
		}

		public function ovaev_single_show_email(){
			$ovaev_single_show_email = OVAEV_Settings::ovaev_single_show_email();
			$ovaev_single_show_email = isset( $ovaev_single_show_email ) ? $ovaev_single_show_email : 'yes';

			$yes = ( 'yes' == $ovaev_single_show_email ) ? 'selected' : '';
			$no  = ( 'no' == $ovaev_single_show_email ) ? 'selected' : '';

			?>
			<select name="ovaev_options[ovaev_single_show_email]" id="ovaev_single_show_email">
				<option <?php echo esc_attr($yes) ?> value="yes"><?php echo esc_html__('Yes', 'ovaev') ?></option>
				<option <?php echo esc_attr($no) ?> value="no"><?php echo esc_html__('No', 'ovaev') ?></option>
			</select>
			<?php
		}

		public function ovaev_single_show_website(){
			$ovaev_single_show_website = OVAEV_Settings::ovaev_single_show_website();
			$ovaev_single_show_website = isset( $ovaev_single_show_website ) ? $ovaev_single_show_website : 'yes';

			$yes = ( 'yes' == $ovaev_single_show_website ) ? 'selected' : '';
			$no  = ( 'no' == $ovaev_single_show_website ) ? 'selected' : '';

			?>
			<select name="ovaev_options[ovaev_single_show_website]" id="ovaev_single_show_website">
				<option <?php echo esc_attr($yes) ?> value="yes"><?php echo esc_html__('Yes', 'ovaev') ?></option>
				<option <?php echo esc_attr($no) ?> value="no"><?php echo esc_html__('No', 'ovaev') ?></option>
			</select>
			<?php
		}

		public function ovaev_single_show_gallery(){
			$ovaev_single_show_gallery = OVAEV_Settings::ovaev_single_show_gallery();
			$ovaev_single_show_gallery = isset( $ovaev_single_show_gallery ) ? $ovaev_single_show_gallery : 'yes';

			$yes = ( 'yes' == $ovaev_single_show_gallery ) ? 'selected' : '';
			$no  = ( 'no' == $ovaev_single_show_gallery ) ? 'selected' : '';

			?>
			<select name="ovaev_options[ovaev_single_show_gallery]" id="ovaev_single_show_gallery">
				<option <?php echo esc_attr($yes) ?> value="yes"><?php echo esc_html__('Yes', 'ovaev') ?></option>
				<option <?php echo esc_attr($no) ?> value="no"><?php echo esc_html__('No', 'ovaev') ?></option>
			</select>
			<?php
		}

		public function ovaev_single_show_share(){
			$ovaev_single_show_share = OVAEV_Settings::ovaev_single_show_share();
			$ovaev_single_show_share = isset( $ovaev_single_show_share ) ? $ovaev_single_show_share : 'yes';

			$yes = ( 'yes' == $ovaev_single_show_share ) ? 'selected' : '';
			$no  = ( 'no' == $ovaev_single_show_share ) ? 'selected' : '';

			?>
			<select name="ovaev_options[ovaev_single_show_share]" id="ovaev_single_show_share">
				<option <?php echo esc_attr($yes) ?> value="yes"><?php echo esc_html__('Yes', 'ovaev') ?></option>
				<option <?php echo esc_attr($no) ?> value="no"><?php echo esc_html__('No', 'ovaev') ?></option>
			</select>
			<?php
		}

		public function ovaev_single_show_next_prev(){
			$ovaev_single_show_next_prev = OVAEV_Settings::ovaev_single_show_next_prev();
			$ovaev_single_show_next_prev = isset( $ovaev_single_show_next_prev ) ? $ovaev_single_show_next_prev : 'yes';

			$yes = ( 'yes' == $ovaev_single_show_next_prev ) ? 'selected' : '';
			$no  = ( 'no' == $ovaev_single_show_next_prev ) ? 'selected' : '';

			?>
			<select name="ovaev_options[ovaev_single_show_next_prev]" id="ovaev_single_show_next_prev">
				<option <?php echo esc_attr($yes) ?> value="yes"><?php echo esc_html__('Yes', 'ovaev') ?></option>
				<option <?php echo esc_attr($no) ?> value="no"><?php echo esc_html__('No', 'ovaev') ?></option>
			</select>
			<?php
		}

		public function ovaev_single_show_related(){
			$ovaev_single_show_related = OVAEV_Settings::ovaev_single_show_related();
			$ovaev_single_show_related = isset( $ovaev_single_show_related ) ? $ovaev_single_show_related : 'yes';

			$yes = ( 'yes' == $ovaev_single_show_related ) ? 'selected' : '';
			$no  = ( 'no' == $ovaev_single_show_related ) ? 'selected' : '';

			?>
			<select name="ovaev_options[ovaev_single_show_related]" id="ovaev_single_show_related">
				<option <?php echo esc_attr($yes) ?> value="yes"><?php echo esc_html__('Yes', 'ovaev') ?></option>
				<option <?php echo esc_attr($no) ?> value="no"><?php echo esc_html__('No', 'ovaev') ?></option>
			</select>
			<?php
		}

		public function ovaev_single_show_comment(){
			$ovaev_single_show_comment = OVAEV_Settings::ovaev_single_show_comment();
			$ovaev_single_show_comment = isset( $ovaev_single_show_comment ) ? $ovaev_single_show_comment : 'yes';

			$yes = ( 'yes' == $ovaev_single_show_comment ) ? 'selected' : '';
			$no  = ( 'no' == $ovaev_single_show_comment ) ? 'selected' : '';

			?>
			<select name="ovaev_options[ovaev_single_show_comment]" id="ovaev_single_show_comment">
				<option <?php echo esc_attr($yes) ?> value="yes"><?php echo esc_html__('Yes', 'ovaev') ?></option>
				<option <?php echo esc_attr($no) ?> value="no"><?php echo esc_html__('No', 'ovaev') ?></option>
			</select>
			<?php
		}


	}
	new OVAEV_Admin_Settings();
}