<?php
defined( 'ABSPATH' ) || exit();

if( !class_exists( 'OVAEV_Assets' ) ){
	class OVAEV_Assets{

		public function __construct(){
			add_action( 'wp_enqueue_scripts', array( $this, 'ovaev_enqueue_style' ) );
		}

		public function ovaev_enqueue_style(){
			// Style
			wp_enqueue_style( 'event-frontend', OVAEV_PLUGIN_URI.'assets/css/frontend/event.css', array(), null );
            
            // Script
			wp_enqueue_script( 'event-frontend-js', OVAEV_PLUGIN_URI.'assets/js/frontend/event.js', array('jquery'), false, true );
			wp_localize_script( 'event-frontend-js', 'ajax_object', array('ajax_url' => admin_url('admin-ajax.php')));

			if ( is_post_type_archive( 'event' ) || is_tax( 'event_category' ) || is_tax( 'event_tag' ) ){
				// Jquery Datetimepicker
				wp_enqueue_style( 'datetimepicker', OVAEV_PLUGIN_URI.'assets/libs/datetimepicker/jquery.datetimepicker.css' );
				wp_enqueue_script( 'datetimepicker', OVAEV_PLUGIN_URI.'assets/libs/datetimepicker/jquery.datetimepicker.js', array('jquery'), false, true );

				// Select2
				wp_enqueue_style( 'select2', OVAEV_PLUGIN_URI.'assets/libs/dist/css/select2.min.css', array(), null );
				wp_enqueue_script( 'select2', OVAEV_PLUGIN_URI.'assets/libs/dist/js/select2.min.js', array('jquery'), false, true );

				// Elegant font
				wp_enqueue_style( 'elegant_font', OVAEV_PLUGIN_URI.'assets/libs/elegant_font/ele_style.css', array(), null );
			}


			if( is_singular( 'event' ) ){
				// Map
				wp_enqueue_script( 'google','https://maps.googleapis.com/maps/api/js?key='.OVAEV_Settings::google_key_map().'&libraries=places', false, true );

				// Prettyphoto
				wp_enqueue_style('prettyphoto', OVAEV_PLUGIN_URI.'assets/libs/prettyphoto/css/prettyPhoto.css');
				if (is_ssl()) {
					wp_enqueue_script('prettyphoto', OVAEV_PLUGIN_URI.'assets/libs/prettyphoto/jquery.prettyPhoto_https.js', array('jquery'),null,true);
				}
				else{
					wp_enqueue_script('prettyphoto', OVAEV_PLUGIN_URI.'assets/libs/prettyphoto/jquery.prettyPhoto.js', array('jquery'),null,true);
				}

				// Elegant font
				wp_enqueue_style( 'elegant_font', OVAEV_PLUGIN_URI.'assets/libs/elegant_font/ele_style.css', array(), null );
			}
			
		}

	}

	new OVAEV_Assets();
}