<?php

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

class OVAPOR_templates_loader {
	
	/**
	 * The Constructor
	 */
	public function __construct() {
		add_filter( 'template_include', array( $this, 'template_loader' ) );
	}

	public function template_loader( $template ) {

		$post_type = isset($_REQUEST['post_type'] ) ? esc_html( $_REQUEST['post_type'] ) : get_post_type();


		if( is_tax( 'cat_por' ) ||  get_query_var( 'cat_por' ) != '' ){
			
			ovapor_get_template( 'archive-por.php' );
			return false;
		}


		// Is Team Post Type
		if(  $post_type == 'ova_por' ){

			if ( is_post_type_archive( 'ova_por' ) ) { 

				ovapor_get_template( 'archive-por.php' );
				return false;

			} else if ( is_single() ) {

				ovapor_get_template( 'single-por.php' );
				return false;

			}
		}


		if ( $post_type !== 'ova_por' ){
			return $template;
		}
	}
}

new OVAPOR_templates_loader();
