<?php

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

if( !function_exists( 'ovapor_locate_template' ) ){
	function ovapor_locate_template( $template_name, $template_path = '', $default_path = '' ) {
		
		// Set variable to search in ovacoll-templates folder of theme.
		if ( ! $template_path ) :
			$template_path = 'ovapor-templates/';
		endif;

		// Set default plugin templates path.
		if ( ! $default_path ) :
			$default_path = OVAPOR_PLUGIN_PATH . 'templates/'; // Path to the template folder
		endif;

		// Search template file in theme folder.
		$template = locate_template( array(
			$template_path . $template_name
			// $template_name
		) );

		// Get plugins template file.
		if ( ! $template ) :
			$template = $default_path . $template_name;
		endif;

		return apply_filters( 'ovapor_locate_template', $template, $template_name, $template_path, $default_path );
	}

}


function ovapor_get_template( $template_name, $args = array(), $tempate_path = '', $default_path = '' ) {
	if ( is_array( $args ) && isset( $args ) ) :
		extract( $args );
	endif;
	$template_file = ovapor_locate_template( $template_name, $tempate_path, $default_path );
	if ( ! file_exists( $template_file ) ) :
		_doing_it_wrong( __FUNCTION__, sprintf( '<code>%s</code> does not exist.', $template_file ), '1.0.0' );
		return;
	endif;

	
	include $template_file;
}

add_filter( 'gimont_header_customize', 'gimont_header_customize_por', 10, 1 );
function gimont_header_customize_por( $header ){

	if( is_tax( 'cat_por' ) ||  get_query_var( 'cat_por' ) != '' || is_post_type_archive( 'ova_por' ) ){

	  	$header = get_theme_mod( 'header_archive_por', 'default' );

	}else if( is_singular( 'ova_por' ) ){

		$header = get_theme_mod( 'header_single_por', 'default' );
	}

	return $header;

}


add_filter( 'gimont_header_bg_customize', 'gimont_header_bg_customize_por', 10, 1 );
function gimont_header_bg_customize_por( $bg ){

	if( is_tax( 'cat_por' ) ||  get_query_var( 'cat_por' ) != '' || is_post_type_archive( 'ova_por' ) ){

	  	$bg = get_theme_mod( 'archive_background_por', '' );

	}else if( is_singular( 'ova_por' ) ){

		$bg = get_theme_mod( 'single_background_por', '' );

		$current_id = gimont_get_current_id();
		$header_bg_source =  get_the_post_thumbnail_url( $current_id, 'full' );

		if( $header_bg_source ){
			$bg = $header_bg_source;
		}
	}

	return $bg;
}


add_filter( 'gimont_footer_customize', 'gimont_footer_customize_por', 10, 1 );
function gimont_footer_customize_por( $footer ){
    
   if( is_tax( 'cat_por' ) ||  get_query_var( 'cat_por' ) != '' || is_post_type_archive( 'ova_por' ) ){

        $footer = get_theme_mod( 'archive_footer_por', '' );

   }else if( is_singular( 'ova_por' ) ){

        $footer = get_theme_mod( 'single_footer_por', '' );
    }

    return $footer;

}